;
/*
    zfence - allocator for glib
    Copyright (C) 2012-2014 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/


#include <zfence.h>

#include <zdebug.h>
#include <zhash.h>
#include <zlist.h>
#include <zthread.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define METHOD1
#define METHOD2x

#ifdef METHOD1
static gsize zf_padsize = 0;
static char zf_padchar;
static int zf_memvalue;
static int zf_checking = 0;

struct zf_header{
	struct zf_header *next;
	struct zf_header *prev;
	gsize size;
};

struct zf_header zf_blocks;
#endif

#ifdef METHOD2
#include <crtdbg.h>
FILE *zf_log;
long zf_n = 0;
#endif

MUTEX_DEFINE(zf);
int zf_initialized = 0;

void zfence_init(gsize padsize, char padchar, int memvalue){
    GMemVTable vt;

	if (zf_initialized) return; // already intialized
	zf_initialized = 1;
	vt.malloc = zfence_malloc;
	vt.realloc = zfence_realloc;
	vt.free = zfence_mfree;
	vt.calloc = NULL;
	vt.try_malloc = NULL;
	vt.try_realloc = NULL;

#ifdef METHOD1
	zf_padsize = padsize;
	zf_padchar = padchar;
	zf_memvalue = zf_memvalue;

	// must allocate with original allocator
	init_list(zf_blocks);
#endif
#ifdef METHOD2
	zf_log = fopen("zf_log", "wt");
#endif
#if !GLIB_CHECK_VERSION(2, 32, 0)
	g_thread_init(NULL);
#endif
	MUTEX_INIT(zf);
	g_mem_set_vtable(&vt);
#ifdef METHOD2
	{
		int tmpFlag = _CrtSetDbgFlag( _CRTDBG_REPORT_FLAG );
		tmpFlag |= _CRTDBG_CHECK_ALWAYS_DF;
		//tmpFlag |=  _CRTDBG_DELAY_FREE_MEM_DF;
		_CrtSetDbgFlag( tmpFlag );
	}
#endif
}


void zfence_free(void){
//  cannot free hashes
}

#ifdef METHOD1
void zfence_check(void){
	struct zf_header *h;
	char *c, i;

	if (!zf_checking){
		zf_checking = 1;
		foreach(h, zf_blocks){
			char *m = (char *)h;
			char *g = m + sizeof(struct zf_header) + zf_padsize;

			c = m + sizeof(struct zf_header);
			for (i = zf_padsize; i > 0; i--, c++){
				if (*c == zf_padchar) continue;
				zinternal("Heap corrupted at %p (malloc=%p, glib=%p, size=%d)", c, m, g, h->size);
			}
			c = g + h->size;
			for (i = zf_padsize; i > 0; i--, c++){
				if (*c == zf_padchar) continue;
				zinternal("Heap corrupted at %p (malloc=%p, glib=%p, size=%d)", c, m, g, h->size);
			}
		}
		zf_checking = 0;
	}
}

gpointer zfence_malloc(gsize n_bytes){
	char *m, *g; // malloc, glib
	struct zf_header *h;

	zfence_check();
	MUTEX_LOCK(zf);
	m = (char *)malloc(sizeof(struct zf_header) + zf_padsize + n_bytes + zf_padsize);
	g = m + sizeof(struct zf_header) + zf_padsize;
	h = (struct zf_header *)m;
	memset(m + sizeof(struct zf_header), zf_padchar, zf_padsize);
	memset(g + n_bytes, zf_padchar, zf_padsize);
	h->size = n_bytes;
	add_to_list(zf_blocks, h);
	MUTEX_UNLOCK(zf);
	//zfence_check();
	return g;
}

gpointer zfence_realloc (gpointer zmem, gsize n_bytes){
	char *m, *g;
	struct zf_header *h;

	if (!zmem) return zfence_malloc(n_bytes);

	zfence_check();
	MUTEX_LOCK(zf);
	g = (char *)zmem;
	m = g - zf_padsize - sizeof(struct zf_header);
	h = (struct zf_header *)m;
	del_from_list(h);
	m = (char *)realloc(m, sizeof(struct zf_header) + zf_padsize + n_bytes + zf_padsize);
	g = m + sizeof(struct zf_header) + zf_padsize;
	h = (struct zf_header *)m;
	memset(g + n_bytes, zf_padchar, zf_padsize);
	h->size = n_bytes;
	add_to_list(zf_blocks, h);
	MUTEX_UNLOCK(zf);
	//zfence_check();
	return g;
}

void zfence_mfree(gpointer zmem){
	char *m, *g;
	struct zf_header *h;

	zfence_check();
	MUTEX_LOCK(zf);
	g = (char *)zmem;
	m = g - zf_padsize - sizeof(struct zf_header);
	h = (struct zf_header *)m;
	del_from_list(h);
	free(m);
	MUTEX_UNLOCK(zf);
	//zfence_check();
}
#endif

#ifdef METHOD2
void zfence_check(void){
	if (zf_n == 503){
		int a = 0;
	}
	
}

gpointer zfence_malloc(gsize n_bytes){
	char *m;
	MUTEX_LOCK(zf);
	m = (char *)malloc(n_bytes);
	fprintf(zf_log, "%6d: %p - %p (%d)\n", zf_n++, m, m + n_bytes, n_bytes);
	zfence_check();
	MUTEX_UNLOCK(zf);
	return m;
}

gpointer zfence_realloc (gpointer zmem, gsize n_bytes){
	char *m;

	if (!zmem) return zfence_malloc(n_bytes);

	MUTEX_LOCK(zf);
	m = (char *)realloc(zmem, n_bytes);
	fprintf(zf_log, "%6d: %p - %p (%d)\n", zf_n++, m, m + n_bytes, n_bytes);
	zfence_check();
	MUTEX_UNLOCK(zf);
	return m;
}

void zfence_mfree(gpointer zmem){
	free(zmem);
}
#endif
