/*  Copyright (c) MediaArea.net SARL. All Rights Reserved.
 *
 *  Use of this source code is governed by a zlib-style license that can
 *  be found in the License.txt file in the root of the source tree.
 */

//---------------------------------------------------------------------------
#include "ZenLib/PreComp.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "ZenLib/Conf_Internal.h"
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "ZenLib/CriticalSection.h"
//---------------------------------------------------------------------------

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ZENLIB_USEWX
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#ifdef ZENLIB_USEWX
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include <wx/thread.h>
//---------------------------------------------------------------------------

namespace ZenLib
{

//***************************************************************************
// Constructor/Destructor
//***************************************************************************

//---------------------------------------------------------------------------
CriticalSection::CriticalSection()
{
    CritSect=new wxCriticalSection();
}

//---------------------------------------------------------------------------
CriticalSection::~CriticalSection()
{
    delete ((wxCriticalSection*)CritSect); //CritSect=NULL;
}

//***************************************************************************
// Enter/Leave
//***************************************************************************

//---------------------------------------------------------------------------
void CriticalSection::Enter()
{
    ((wxCriticalSection*)CritSect)->Enter();
}

//---------------------------------------------------------------------------
void CriticalSection::Leave()
{
    ((wxCriticalSection*)CritSect)->Leave();
}

} //Namespace

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// WINDOWS
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#else //ZENLIB_USEWX
#ifdef WINDOWS
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#undef __TEXT
#include <windows.h>
//---------------------------------------------------------------------------


namespace ZenLib
{

//***************************************************************************
// Constructor/Destructor
//***************************************************************************

//---------------------------------------------------------------------------
CriticalSection::CriticalSection()
{
    CritSect=new CRITICAL_SECTION;
    InitializeCriticalSection((CRITICAL_SECTION*)CritSect);
}

//---------------------------------------------------------------------------
CriticalSection::~CriticalSection()
{
    DeleteCriticalSection((CRITICAL_SECTION*)CritSect);
    delete ((CRITICAL_SECTION*)CritSect); //CritSect=NULL;
}

//***************************************************************************
// Enter/Leave
//***************************************************************************

//---------------------------------------------------------------------------
void CriticalSection::Enter()
{
    EnterCriticalSection((CRITICAL_SECTION*)CritSect);
}

//---------------------------------------------------------------------------
void CriticalSection::Leave()
{
    LeaveCriticalSection((CRITICAL_SECTION*)CritSect);
}

} //Namespace

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// UNIX
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#else //WINDOWS
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include <pthread.h>
//---------------------------------------------------------------------------

namespace ZenLib
{

//***************************************************************************
// Constructor/Destructor
//***************************************************************************

//---------------------------------------------------------------------------
CriticalSection::CriticalSection()
{
    CritSect=new pthread_mutex_t;
    pthread_mutex_init((pthread_mutex_t*)CritSect, NULL);
}

//---------------------------------------------------------------------------
CriticalSection::~CriticalSection()
{
    pthread_mutex_destroy((pthread_mutex_t*)CritSect);
    delete (pthread_mutex_t*)CritSect;
}

//***************************************************************************
// Enter/Leave
//***************************************************************************

//---------------------------------------------------------------------------
void CriticalSection::Enter()
{
    pthread_mutex_lock((pthread_mutex_t*)CritSect);
}

//---------------------------------------------------------------------------
void CriticalSection::Leave()
{
    pthread_mutex_unlock((pthread_mutex_t*)CritSect);
}

} //Namespace

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#endif //WINDOWS
#endif //ZENLIB_USEWX
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
