//
//   Copyright (C) 2008 by sinamas <sinamas at users.sourceforge.net>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License version 2 for more details.
//
//   You should have received a copy of the GNU General Public License
//   version 2 along with this program; if not, write to the
//   Free Software Foundation, Inc.,
//   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#include "initstate.h"
#include "counterdef.h"
#include "savestate.h"
#include "sound/sound_unit.h"
#include <algorithm>
#include <cstring>
#include <ctime>

namespace {

static void setInitialCgbWram(unsigned char wram[]) {
	static struct { unsigned short addr; unsigned char val; } const cgbWramDumpDiff[] = {
		{ 0x0083, 0x7F }, { 0x008B, 0x10 }, { 0x00C0, 0x7F }, { 0x00E1, 0x7F },
		{ 0x00E2, 0x7F }, { 0x00EA, 0x10 }, { 0x010A, 0x40 }, { 0x0179, 0x01 },
		{ 0x01AF, 0x01 }, { 0x0201, 0xFB }, { 0x0254, 0xF7 }, { 0x0264, 0x7F },
		{ 0x02D1, 0xBF }, { 0x02D2, 0xFB }, { 0x0301, 0xF7 }, { 0x0313, 0xF7 },
		{ 0x0315, 0x7F }, { 0x0325, 0x7F }, { 0x0339, 0x04 }, { 0x0354, 0x7F },
		{ 0x0375, 0xFD }, { 0x0391, 0xFB }, { 0x03AC, 0x40 }, { 0x03C5, 0xFB },
		{ 0x03FB, 0x20 }, { 0x0412, 0xF7 }, { 0x0422, 0xF7 }, { 0x04B1, 0xFB },
		{ 0x04B5, 0x7F }, { 0x04C6, 0x7F }, { 0x04D0, 0xFB }, { 0x04D2, 0xDF },
		{ 0x0504, 0x7F }, { 0x051C, 0x01 }, { 0x0523, 0xFD }, { 0x0532, 0xF7 },
		{ 0x0535, 0xF7 }, { 0x0606, 0x7F }, { 0x0690, 0xF7 }, { 0x0697, 0xFB },
		{ 0x0698, 0x02 }, { 0x06B5, 0x7F }, { 0x06E4, 0x7F }, { 0x06F1, 0xDF },
		{ 0x06F9, 0x04 }, { 0x0730, 0xFD }, { 0x0783, 0xFB }, { 0x07B5, 0x7F },
		{ 0x07B6, 0xF7 }, { 0x080E, 0xF7 }, { 0x081C, 0xF7 }, { 0x0849, 0xBF },
		{ 0x0859, 0xF7 }, { 0x085E, 0x7F }, { 0x085F, 0x7F }, { 0x0869, 0x7F },
		{ 0x086D, 0x7F }, { 0x086E, 0x7F }, { 0x0879, 0xBF }, { 0x087C, 0xFB },
		{ 0x0889, 0xBB }, { 0x089A, 0xF7 }, { 0x089D, 0xD7 }, { 0x089E, 0x9F },
		{ 0x08A9, 0x7F }, { 0x08AA, 0xFB }, { 0x08AC, 0x7F }, { 0x08AF, 0xF7 },
		{ 0x08BB, 0xDF }, { 0x08D8, 0xFB }, { 0x08DB, 0x7F }, { 0x08DC, 0xBF },
		{ 0x08E8, 0xF7 }, { 0x08FB, 0x7D }, { 0x08FC, 0x7F }, { 0x08FD, 0xFD },
		{ 0x090A, 0xFB }, { 0x091C, 0xF7 }, { 0x091E, 0xDF }, { 0x0929, 0xF7 },
		{ 0x092B, 0xF7 }, { 0x092C, 0xF7 }, { 0x092D, 0xFB }, { 0x094B, 0xF7 },
		{ 0x094D, 0x7F }, { 0x095B, 0x7B }, { 0x0969, 0xF7 }, { 0x097C, 0x7F },
		{ 0x097E, 0xF7 }, { 0x09DC, 0x5F }, { 0x09EB, 0xFD }, { 0x09EE, 0xDF },
		{ 0x09EF, 0x7F }, { 0x09FB, 0xBF }, { 0x09FE, 0xF7 }, { 0x0A0A, 0xF7 },
		{ 0x0A0E, 0xBF }, { 0x0A0F, 0x7F }, { 0x0A1A, 0xBF }, { 0x0A1C, 0x3F },
		{ 0x0A2A, 0xFD }, { 0x0A2E, 0xF7 }, { 0x0A3C, 0xDF }, { 0x0A3E, 0xF7 },
		{ 0x0A4B, 0xFB }, { 0x0A4F, 0xDF }, { 0x0A5C, 0xF7 }, { 0x0A6E, 0xF7 },
		{ 0x0A7E, 0xB7 }, { 0x0A7F, 0xF7 }, { 0x0A81, 0x01 }, { 0x0A8D, 0xDF },
		{ 0x0A9F, 0x7F }, { 0x0AAB, 0xFD }, { 0x0AAC, 0xFB }, { 0x0ABE, 0xBF },
		{ 0x0AC9, 0xFB }, { 0x0ACF, 0xF7 }, { 0x0ADC, 0xF5 }, { 0x0ADD, 0xBF },
		{ 0x0AEA, 0x7B }, { 0x0AEB, 0x7F }, { 0x0AF8, 0xFB }, { 0x0AFB, 0xDF },
		{ 0x0B0D, 0x7F }, { 0x0B2E, 0xFD }, { 0x0B39, 0xF7 }, { 0x0B48, 0xBF },
		{ 0x0B5D, 0x7F }, { 0x0B6B, 0x7F }, { 0x0B6D, 0xFB }, { 0x0B76, 0x10 },
		{ 0x0B8B, 0x7F }, { 0x0B8C, 0xF5 }, { 0x0B8D, 0xDF }, { 0x0B9F, 0xBF },
		{ 0x0BB9, 0xDF }, { 0x0BBF, 0x7F }, { 0x0BCE, 0xF7 }, { 0x0BDF, 0x7F },
		{ 0x0BE9, 0x7F }, { 0x0BEE, 0xF7 }, { 0x0BF9, 0x7F }, { 0x0BFE, 0xB7 },
		{ 0x0C09, 0xFD }, { 0x0C0C, 0xFD }, { 0x0C0D, 0xFD }, { 0x0C0F, 0xFB },
		{ 0x0C18, 0xDB }, { 0x0C1A, 0xF7 }, { 0x0C1B, 0xBF }, { 0x0C1E, 0xF7 },
		{ 0x0C29, 0x7F }, { 0x0C2D, 0xFD }, { 0x0C3F, 0x77 }, { 0x0C5B, 0xF7 },
		{ 0x0C5E, 0xBF }, { 0x0C6B, 0x7F }, { 0x0C78, 0x7F }, { 0x0C79, 0xF7 },
		{ 0x0C7D, 0xF7 }, { 0x0C8F, 0x77 }, { 0x0C9A, 0xF7 }, { 0x0CBB, 0xDB },
		{ 0x0CBC, 0xF9 }, { 0x0CCE, 0x7F }, { 0x0CD8, 0xDF }, { 0x0CF8, 0x7F },
		{ 0x0CFE, 0xFB }, { 0x0CFF, 0x7F }, { 0x0D09, 0xDB }, { 0x0D1C, 0xDF },
		{ 0x0D1F, 0xF7 }, { 0x0D29, 0x7F }, { 0x0D2E, 0x7B }, { 0x0D39, 0x77 },
		{ 0x0D3A, 0xFB }, { 0x0D3B, 0x7F }, { 0x0D3C, 0xDF }, { 0x0D3E, 0xFB },
		{ 0x0D59, 0x7F }, { 0x0D5E, 0xDF }, { 0x0D6E, 0xFD }, { 0x0D78, 0xF7 },
		{ 0x0D79, 0xFB }, { 0x0D7A, 0x7F }, { 0x0D8B, 0xFB }, { 0x0D8F, 0xBF },
		{ 0x0D9B, 0xF7 }, { 0x0DBA, 0xBF }, { 0x0DBF, 0xD7 }, { 0x0DC9, 0x7F },
		{ 0x0DCA, 0xF7 }, { 0x0DD8, 0xFB }, { 0x0DD9, 0xFB }, { 0x0DDA, 0xFD },
		{ 0x0DDB, 0xF7 }, { 0x0DDD, 0xF7 }, { 0x0DDE, 0xF7 }, { 0x0DFB, 0xFB },
		{ 0x0DFD, 0x7F }, { 0x0E08, 0xFB }, { 0x0E09, 0xFB }, { 0x0E18, 0xFB },
		{ 0x0E29, 0xB7 }, { 0x0E2B, 0xFB }, { 0x0E3D, 0xF7 }, { 0x0E43, 0x20 },
		{ 0x0E48, 0xF7 }, { 0x0E4D, 0xF7 }, { 0x0E5F, 0xF7 }, { 0x0E69, 0x7F },
		{ 0x0E6B, 0xFB }, { 0x0E7E, 0x7B }, { 0x0E89, 0x7F }, { 0x0E8B, 0xFB },
		{ 0x0E8D, 0xF7 }, { 0x0E99, 0xBF }, { 0x0E9B, 0xF7 }, { 0x0E9D, 0xF7 },
		{ 0x0E9F, 0xF7 }, { 0x0EAB, 0xDF }, { 0x0EAF, 0xF7 }, { 0x0EB9, 0xDF },
		{ 0x0EBD, 0x7F }, { 0x0EBE, 0xFB }, { 0x0ECB, 0xDF }, { 0x0ECE, 0xF7 },
		{ 0x0ECF, 0x7F }, { 0x0EDF, 0xDF }, { 0x0EEB, 0xFD }, { 0x0EF8, 0xD7 },
		{ 0x0EFC, 0x77 }, { 0x0EFD, 0xDF }, { 0x0EFF, 0x7F }, { 0x0F08, 0xF7 },
		{ 0x0F0D, 0xDF }, { 0x0F1E, 0x7F }, { 0x0F2C, 0xDF }, { 0x0F2D, 0xF7 },
		{ 0x0F2E, 0xFB }, { 0x0F2F, 0x7F }, { 0x0F38, 0xFB }, { 0x0F3B, 0xDF },
		{ 0x0F43, 0x10 }, { 0x0F4B, 0x57 }, { 0x0F4C, 0x7F }, { 0x0F5F, 0xD7 },
		{ 0x0F78, 0xBF }, { 0x0F8F, 0xBB }, { 0x0F9F, 0xF7 }, { 0x0FAB, 0xFD },
		{ 0x0FAF, 0xF7 }, { 0x0FB8, 0xFB }, { 0x0FBE, 0x7F }, { 0x0FD9, 0xB3 },
		{ 0x0FDD, 0xFB }, { 0x0FDF, 0x7F }, { 0x0FF2, 0xF7 }, { 0x0FFC, 0xF7 },
		{ 0x10B0, 0xF7 }, { 0x10E0, 0xFD }, { 0x112B, 0x40 }, { 0x1150, 0xDF },
		{ 0x1184, 0xBF }, { 0x1188, 0x01 }, { 0x11C1, 0x7F }, { 0x11E4, 0x7F },
		{ 0x11F1, 0x7F }, { 0x1211, 0xF7 }, { 0x1214, 0xFD }, { 0x1215, 0xF7 },
		{ 0x1244, 0xFB }, { 0x125B, 0x20 }, { 0x126C, 0x04 }, { 0x1272, 0xFD },
		{ 0x12C1, 0xDF }, { 0x12DB, 0x10 }, { 0x12F0, 0x7F }, { 0x1364, 0xF7 },
		{ 0x13F2, 0xFB }, { 0x1413, 0xDF }, { 0x1430, 0xF7 }, { 0x1436, 0xF7 },
		{ 0x1450, 0x7F }, { 0x1470, 0xF7 }, { 0x1472, 0x7F }, { 0x14B4, 0xDF },
		{ 0x14B6, 0xFB }, { 0x1516, 0xF7 }, { 0x151B, 0x01 }, { 0x1565, 0x7F },
		{ 0x1597, 0xBF }, { 0x15A6, 0x7F }, { 0x15B0, 0x7F }, { 0x15C5, 0xBF },
		{ 0x15D5, 0xFB }, { 0x15F2, 0xFD }, { 0x15FC, 0x04 }, { 0x161A, 0x10 },
		{ 0x1689, 0x20 }, { 0x16A7, 0xFB }, { 0x170A, 0x02 }, { 0x1732, 0xFD },
		{ 0x1744, 0x7F }, { 0x1759, 0x01 }, { 0x1761, 0xF7 }, { 0x1774, 0xF7 },
		{ 0x1795, 0xFD }, { 0x179B, 0x10 }, { 0x17C4, 0xF7 }, { 0x1808, 0xDF },
		{ 0x180B, 0xDF }, { 0x180F, 0x77 }, { 0x181D, 0x7F }, { 0x181F, 0xF7 },
		{ 0x182C, 0x7F }, { 0x183F, 0x7F }, { 0x184A, 0x7F }, { 0x184D, 0x7F },
		{ 0x184E, 0xF7 }, { 0x1859, 0x7F }, { 0x185F, 0x7F }, { 0x1864, 0x01 },
		{ 0x1868, 0x3F }, { 0x186E, 0x9F }, { 0x186F, 0xF7 }, { 0x187A, 0xFB },
		{ 0x188F, 0xBF }, { 0x189D, 0x7F }, { 0x189E, 0xFB }, { 0x18AA, 0xDF },
		{ 0x18BE, 0x7F }, { 0x18CF, 0x7F }, { 0x18DB, 0x77 }, { 0x18DC, 0xDF },
		{ 0x18E8, 0x77 }, { 0x18E9, 0x7F }, { 0x18FB, 0xF7 }, { 0x18FE, 0xF7 },
		{ 0x191E, 0x7F }, { 0x191F, 0x7F }, { 0x1929, 0xBF }, { 0x192D, 0xDF },
		{ 0x194C, 0xFB }, { 0x194E, 0xDF }, { 0x195B, 0x7F }, { 0x1968, 0xBF },
		{ 0x196A, 0xF7 }, { 0x197F, 0xF7 }, { 0x198B, 0x7F }, { 0x198E, 0x7F },
		{ 0x199B, 0xFB }, { 0x19A8, 0xDF }, { 0x19AA, 0xB7 }, { 0x19AB, 0x77 },
		{ 0x19AD, 0xFD }, { 0x19B8, 0xBF }, { 0x19BE, 0xFD }, { 0x19BF, 0xDF },
		{ 0x19DC, 0x7F }, { 0x19DF, 0x7D }, { 0x19EA, 0xDF }, { 0x19EC, 0xDF },
		{ 0x19EF, 0x7F }, { 0x19FB, 0xFB }, { 0x19FC, 0xF7 }, { 0x19FD, 0xBF },
		{ 0x19FF, 0xFE }, { 0x1A08, 0xDF }, { 0x1A0B, 0xF7 }, { 0x1A0D, 0x7F },
		{ 0x1A0F, 0x7F }, { 0x1A1A, 0xBF }, { 0x1A1D, 0xBF }, { 0x1A1F, 0x7F },
		{ 0x1A29, 0xFD }, { 0x1A2A, 0xFD }, { 0x1A2F, 0xF7 }, { 0x1A3E, 0x7F },
		{ 0x1A49, 0xFD }, { 0x1A4A, 0xBB }, { 0x1A4C, 0xF7 }, { 0x1A4F, 0x7F },
		{ 0x1A68, 0xF7 }, { 0x1A6D, 0xBF }, { 0x1A78, 0xBF }, { 0x1A7D, 0x7F },
		{ 0x1A7E, 0xF7 }, { 0x1A9B, 0xF7 }, { 0x1A9C, 0xBF }, { 0x1A9D, 0xF7 },
		{ 0x1A9F, 0x7F }, { 0x1AAA, 0x7F }, { 0x1ABF, 0xBF }, { 0x1ACA, 0xBF },
		{ 0x1ACF, 0xF7 }, { 0x1ADA, 0xF7 }, { 0x1AEA, 0xFD }, { 0x1AFF, 0xFD },
		{ 0x1B0B, 0xF7 }, { 0x1B19, 0x7F }, { 0x1B1D, 0xF7 }, { 0x1B1E, 0xF7 },
		{ 0x1B29, 0xDF }, { 0x1B3B, 0xFB }, { 0x1B3C, 0xF7 }, { 0x1B4D, 0xFB },
		{ 0x1B4F, 0xF7 }, { 0x1B6D, 0x7F }, { 0x1B6E, 0xF7 }, { 0x1B78, 0xF7 },
		{ 0x1B9B, 0x7F }, { 0x1B9E, 0xDF }, { 0x1B9F, 0x7F }, { 0x1BAB, 0xBF },
		{ 0x1BAF, 0xFD }, { 0x1BB8, 0xFB }, { 0x1BBA, 0xF7 }, { 0x1BBF, 0xF7 },
		{ 0x1BCD, 0xDF }, { 0x1BDA, 0xDF }, { 0x1BDE, 0x77 }, { 0x1BF8, 0xBF },
		{ 0x1BFC, 0xFD }, { 0x1BFD, 0xFB }, { 0x1BFE, 0xF7 }, { 0x1C0C, 0xF7 },
		{ 0x1C0E, 0x7F }, { 0x1C1A, 0x7F }, { 0x1C1C, 0xFB }, { 0x1C2E, 0xFB },
		{ 0x1C3E, 0xFD }, { 0x1C4D, 0x7F }, { 0x1C4F, 0xF7 }, { 0x1C5F, 0x7F },
		{ 0x1C6A, 0xFD }, { 0x1C6E, 0xFB }, { 0x1C89, 0xFB }, { 0x1C8B, 0xFD },
		{ 0x1C8E, 0xFD }, { 0x1C9A, 0xFB }, { 0x1C9C, 0x7F }, { 0x1CA8, 0xBF },
		{ 0x1CA9, 0xBF }, { 0x1CAE, 0xBF }, { 0x1CB9, 0xF7 }, { 0x1CBA, 0x7F },
		{ 0x1CBD, 0xDF }, { 0x1CCF, 0xF7 }, { 0x1D0C, 0xFB }, { 0x1D0F, 0x7F },
		{ 0x1D18, 0xBF }, { 0x1D1F, 0xF7 }, { 0x1D28, 0xDF }, { 0x1D29, 0xF7 },
		{ 0x1D2F, 0xF7 }, { 0x1D48, 0xD7 }, { 0x1D4A, 0xF7 }, { 0x1D59, 0xF7 },
		{ 0x1D63, 0x40 }, { 0x1D6A, 0xF7 }, { 0x1D6C, 0xBF }, { 0x1D6E, 0xF7 },
		{ 0x1D7D, 0xBF }, { 0x1D8E, 0xB7 }, { 0x1D9B, 0xFB }, { 0x1D9E, 0xFD },
		{ 0x1DAD, 0x7F }, { 0x1DAF, 0x7F }, { 0x1DC8, 0xF7 }, { 0x1DCA, 0xBF },
		{ 0x1DCF, 0xFB }, { 0x1DDB, 0xF7 }, { 0x1DDE, 0xBF }, { 0x1DE9, 0xBF },
		{ 0x1E0F, 0xFD }, { 0x1E1B, 0xFD }, { 0x1E2B, 0xDF }, { 0x1E2D, 0x7F },
		{ 0x1E39, 0xFB }, { 0x1E3A, 0x04 }, { 0x1E3D, 0xDF }, { 0x1E48, 0x5F },
		{ 0x1E4D, 0x7F }, { 0x1E5E, 0x7F }, { 0x1E6B, 0x7F }, { 0x1E6F, 0x3F },
		{ 0x1E7B, 0xFB }, { 0x1E7E, 0xF7 }, { 0x1E89, 0x7F }, { 0x1E8C, 0x7B },
		{ 0x1E8F, 0xF7 }, { 0x1E99, 0xF7 }, { 0x1E9C, 0xF7 }, { 0x1E9F, 0xFB },
		{ 0x1EA8, 0xFD }, { 0x1EAC, 0x7F }, { 0x1EAD, 0xF7 }, { 0x1EBF, 0xF7 },
		{ 0x1ECF, 0x7F }, { 0x1EDC, 0xDF }, { 0x1EDD, 0xFD }, { 0x1EDE, 0x77 },
		{ 0x1EDF, 0xF7 }, { 0x1EEE, 0xF5 }, { 0x1EEF, 0xF7 }, { 0x1EFB, 0xF3 },
		{ 0x1F08, 0x7F }, { 0x1F09, 0xF7 }, { 0x1F0C, 0x7F }, { 0x1F19, 0xFB },
		{ 0x1F1E, 0xFD }, { 0x1F2A, 0x02 }, { 0x1F38, 0xF7 }, { 0x1F4B, 0xDF },
		{ 0x1F4F, 0xBF }, { 0x1F5C, 0xFD }, { 0x1F5D, 0xDF }, { 0x1F5F, 0x7F },
		{ 0x1F78, 0xFB }, { 0x1F7A, 0x01 }, { 0x1F85, 0x01 }, { 0x1F88, 0x7F },
		{ 0x1F89, 0xDF }, { 0x1F8B, 0xF7 }, { 0x1F9E, 0xFD }, { 0x1F9F, 0x7F },
		{ 0x1FA8, 0xFB }, { 0x1FAC, 0xDF }, { 0x1FAE, 0xF7 }, { 0x1FAF, 0xDF },
		{ 0x1FBB, 0xBF }, { 0x1FBE, 0xFB }, { 0x1FCB, 0x7F }, { 0x1FCE, 0x7F },
		{ 0x1FD9, 0xF7 }, { 0x1FDE, 0xFB }, { 0x1FDF, 0x7F }, { 0x1FEB, 0x7F },
		{ 0x1FF8, 0x7F }, { 0x1FFB, 0xDF }, { 0x1FFC, 0x7F }, { 0x1FFD, 0x7F },
		{ 0x1FFE, 0xF7 }, { 0x2008, 0x1C }, { 0x200B, 0x03 }, { 0x2840, 0xFF },
		{ 0x2841, 0x7F }, { 0x2842, 0xFF }, { 0x2843, 0x7F }, { 0x2844, 0xFF },
		{ 0x2845, 0x7F }, { 0x2846, 0xFF }, { 0x2847, 0x7F }, { 0x2848, 0xFF },
		{ 0x2849, 0x7F }, { 0x284A, 0xFF }, { 0x284B, 0x7F }, { 0x284C, 0xFF },
		{ 0x284D, 0x7F }, { 0x284E, 0xFF }, { 0x284F, 0x7F }, { 0x2850, 0xFF },
		{ 0x2851, 0x7F }, { 0x2852, 0xFF }, { 0x2853, 0x7F }, { 0x2854, 0xFF },
		{ 0x2855, 0x7F }, { 0x2856, 0xFF }, { 0x2857, 0x7F }, { 0x2858, 0xFF },
		{ 0x2859, 0x7F }, { 0x285A, 0xFF }, { 0x285B, 0x7F }, { 0x285C, 0xFF },
		{ 0x285D, 0x7F }, { 0x285E, 0xFF }, { 0x285F, 0x7F }, { 0x2860, 0xFF },
		{ 0x2861, 0x7F }, { 0x2862, 0xFF }, { 0x2863, 0x7F }, { 0x2864, 0xFF },
		{ 0x2865, 0x7F }, { 0x2866, 0xFF }, { 0x2867, 0x7F }, { 0x2868, 0xFF },
		{ 0x2869, 0x7F }, { 0x286A, 0xFF }, { 0x286B, 0x7F }, { 0x286C, 0xFF },
		{ 0x286D, 0x7F }, { 0x286E, 0xFF }, { 0x286F, 0x7F }, { 0x2870, 0xFF },
		{ 0x2871, 0x7F }, { 0x2872, 0xFF }, { 0x2873, 0x7F }, { 0x2874, 0xFF },
		{ 0x2875, 0x7F }, { 0x2876, 0xFF }, { 0x2877, 0x7F }, { 0x2878, 0xFF },
		{ 0x2879, 0x7F }, { 0x287A, 0xFF }, { 0x287B, 0x7F }, { 0x287C, 0xFF },
		{ 0x287D, 0x7F }, { 0x287E, 0xFF }, { 0x287F, 0x7F }, { 0x2900, 0x80 },
		{ 0x2901, 0x80 }, { 0x2902, 0x40 }, { 0x2903, 0x88 }, { 0x2904, 0x88 },
		{ 0x2905, 0x68 }, { 0x2906, 0xDE }, { 0x2907, 0xDE }, { 0x2908, 0x70 },
		{ 0x2909, 0xDE }, { 0x290A, 0xDE }, { 0x290B, 0x78 }, { 0x290C, 0x20 },
		{ 0x290D, 0x20 }, { 0x290E, 0x38 }, { 0x290F, 0x20 }, { 0x2910, 0x20 },
		{ 0x2911, 0x90 }, { 0x2912, 0x20 }, { 0x2913, 0x20 }, { 0x2914, 0xA0 },
		{ 0x2915, 0xE0 }, { 0x2916, 0xE0 }, { 0x2917, 0xC0 }, { 0x2918, 0x98 },
		{ 0x2919, 0x98 }, { 0x291A, 0x48 }, { 0x291B, 0x80 }, { 0x291C, 0x80 },
		{ 0x291D, 0x50 }, { 0x291E, 0x1E }, { 0x291F, 0x1E }, { 0x2920, 0x58 },
		{ 0x2921, 0x20 }, { 0x2922, 0x20 }, { 0x2923, 0xE0 }, { 0x2924, 0x88 },
		{ 0x2925, 0x88 }, { 0x2926, 0x10 }, { 0x2927, 0x20 }, { 0x2928, 0x20 },
		{ 0x2929, 0x10 }, { 0x292A, 0x20 }, { 0x292B, 0x20 }, { 0x292C, 0x18 },
		{ 0x292D, 0xE0 }, { 0x292E, 0xE0 }, { 0x2930, 0x18 }, { 0x2931, 0x18 },
		{ 0x2932, 0x20 }, { 0x2933, 0xA8 }, { 0x2934, 0xA8 }, { 0x2935, 0x20 },
		{ 0x2936, 0x18 }, { 0x2937, 0x18 }, { 0x2939, 0x20 }, { 0x293A, 0x20 },
		{ 0x293B, 0xD8 }, { 0x293C, 0xC8 }, { 0x293D, 0xC8 }, { 0x293E, 0xE0 },
		{ 0x2941, 0x40 }, { 0x2942, 0x28 }, { 0x2943, 0x28 }, { 0x2944, 0x28 },
		{ 0x2945, 0x18 }, { 0x2946, 0x18 }, { 0x2947, 0x60 }, { 0x2948, 0x20 },
		{ 0x2949, 0x20 }, { 0x294A, 0xE0 }, { 0x294D, 0x08 }, { 0x294E, 0xE0 },
		{ 0x294F, 0xE0 }, { 0x2950, 0x30 }, { 0x2951, 0xD0 }, { 0x2952, 0xD0 },
		{ 0x2953, 0xD0 }, { 0x2954, 0x20 }, { 0x2955, 0x20 }, { 0x2956, 0xE8 },
		{ 0x2957, 0xFF }, { 0x2958, 0xFF }, { 0x2959, 0xBF }, { 0x2A00, 0xFF },
		{ 0x2A01, 0x7F }, { 0x2A02, 0xDF }, { 0x2A03, 0x01 }, { 0x2A04, 0x12 },
		{ 0x2A05, 0x01 }, { 0x2A08, 0xFF }, { 0x2A09, 0x7F }, { 0x2A0A, 0xDF },
		{ 0x2A0B, 0x01 }, { 0x2A0C, 0x12 }, { 0x2A0D, 0x01 }, { 0x2A10, 0xFF },
		{ 0x2A11, 0x7F }, { 0x2A12, 0xB5 }, { 0x2A13, 0x42 }, { 0x2A14, 0xC8 },
		{ 0x2A15, 0x3D }, { 0x2A18, 0x1F }, { 0x2A19, 0x23 }, { 0x2A1A, 0x5F },
		{ 0x2A1B, 0x03 }, { 0x2A1C, 0xF2 }, { 0x2A1E, 0x09 }, { 0x2A20, 0x1F },
		{ 0x2A21, 0x23 }, { 0x2A22, 0x5F }, { 0x2A23, 0x03 }, { 0x2A24, 0xF2 },
		{ 0x2A26, 0x09 }, { 0x2A28, 0xFF }, { 0x2A29, 0x4F }, { 0x2A2A, 0xD2 },
		{ 0x2A2B, 0x7E }, { 0x2A2C, 0x4C }, { 0x2A2D, 0x3A }, { 0x2A2E, 0xE0 },
		{ 0x2A2F, 0x1C }, { 0x2A30, 0xFF }, { 0x2A31, 0x7F }, { 0x2A32, 0xFF },
		{ 0x2A33, 0x7F }, { 0x2A34, 0x8C }, { 0x2A35, 0x7E }, { 0x2A37, 0x7C },
		{ 0x2A38, 0xFF }, { 0x2A39, 0x7F }, { 0x2A3A, 0xFF }, { 0x2A3B, 0x7F },
		{ 0x2A3C, 0x8C }, { 0x2A3D, 0x7E }, { 0x2A3F, 0x7C }, { 0x2A40, 0xED },
		{ 0x2A41, 0x03 }, { 0x2A42, 0xFF }, { 0x2A43, 0x7F }, { 0x2A44, 0x5F },
		{ 0x2A45, 0x25 }, { 0x2A48, 0xFF }, { 0x2A49, 0x7F }, { 0x2A4A, 0xFF },
		{ 0x2A4B, 0x7F }, { 0x2A4C, 0x8C }, { 0x2A4D, 0x7E }, { 0x2A4F, 0x7C },
		{ 0x2A50, 0xFF }, { 0x2A51, 0x7F }, { 0x2A52, 0xFF }, { 0x2A53, 0x7F },
		{ 0x2A54, 0x8C }, { 0x2A55, 0x7E }, { 0x2A57, 0x7C }, { 0x2A58, 0x6A },
		{ 0x2A59, 0x03 }, { 0x2A5A, 0x1F }, { 0x2A5B, 0x02 }, { 0x2A5C, 0xFF },
		{ 0x2A5D, 0x03 }, { 0x2A5E, 0xFF }, { 0x2A5F, 0x7F }, { 0x2A60, 0xFF },
		{ 0x2A61, 0x7F }, { 0x2A62, 0x1F }, { 0x2A63, 0x42 }, { 0x2A64, 0xF2 },
		{ 0x2A65, 0x1C }, { 0x2A68, 0xFF }, { 0x2A69, 0x7F }, { 0x2A6A, 0x1F },
		{ 0x2A6B, 0x42 }, { 0x2A6C, 0xF2 }, { 0x2A6D, 0x1C }, { 0x2A70, 0xFF },
		{ 0x2A71, 0x7F }, { 0x2A72, 0xEF }, { 0x2A73, 0x03 }, { 0x2A74, 0xD6 },
		{ 0x2A75, 0x01 }, { 0x2A78, 0xFF }, { 0x2A79, 0x7F }, { 0x2A7A, 0x1F },
		{ 0x2A7B, 0x42 }, { 0x2A7C, 0xF2 }, { 0x2A7D, 0x1C }, { 0x2A80, 0xFF },
		{ 0x2A81, 0x7F }, { 0x2A82, 0x1F }, { 0x2A83, 0x42 }, { 0x2A84, 0xF2 },
		{ 0x2A85, 0x1C }, { 0x2A88, 0xFF }, { 0x2A89, 0x7F }, { 0x2A8A, 0xEA },
		{ 0x2A8B, 0x03 }, { 0x2A8C, 0x1F }, { 0x2A8D, 0x01 }, { 0x2A90, 0xFF },
		{ 0x2A91, 0x7F }, { 0x2A92, 0x1F }, { 0x2A93, 0x42 }, { 0x2A94, 0xF2 },
		{ 0x2A95, 0x1C }, { 0x2A98, 0xFF }, { 0x2A99, 0x7F }, { 0x2A9A, 0x1F },
		{ 0x2A9B, 0x42 }, { 0x2A9C, 0xF2 }, { 0x2A9D, 0x1C }, { 0x2AA0, 0xFF },
		{ 0x2AA1, 0x7F }, { 0x2AA2, 0x7F }, { 0x2AA3, 0x02 }, { 0x2AA4, 0x1F },
		{ 0x2AA8, 0xFF }, { 0x2AA9, 0x7F }, { 0x2AAA, 0x8C }, { 0x2AAB, 0x7E },
		{ 0x2AAD, 0x7C }, { 0x2AB0, 0xFF }, { 0x2AB1, 0x7F }, { 0x2AB2, 0x8C },
		{ 0x2AB3, 0x7E }, { 0x2AB5, 0x7C }, { 0x2AB8, 0xFF }, { 0x2AB9, 0x7F },
		{ 0x2ABA, 0xFF }, { 0x2ABB, 0x03 }, { 0x2ABC, 0x1F }, { 0x2AC0, 0x9F },
		{ 0x2AC1, 0x29 }, { 0x2AC2, 0x1A }, { 0x2AC4, 0x0C }, { 0x2AC8, 0x9F },
		{ 0x2AC9, 0x29 }, { 0x2ACA, 0x1A }, { 0x2ACC, 0x0C }, { 0x2AD0, 0x74 },
		{ 0x2AD1, 0x7E }, { 0x2AD2, 0xFF }, { 0x2AD3, 0x03 }, { 0x2AD4, 0x80 },
		{ 0x2AD5, 0x01 }, { 0x2AD8, 0xFF }, { 0x2AD9, 0x7F }, { 0x2ADA, 0xDF },
		{ 0x2ADB, 0x01 }, { 0x2ADC, 0x12 }, { 0x2ADD, 0x01 }, { 0x2AE0, 0xFF },
		{ 0x2AE1, 0x7F }, { 0x2AE2, 0xDF }, { 0x2AE3, 0x01 }, { 0x2AE4, 0x12 },
		{ 0x2AE5, 0x01 }, { 0x2AE8, 0xFF }, { 0x2AE9, 0x67 }, { 0x2AEA, 0xAC },
		{ 0x2AEB, 0x77 }, { 0x2AEC, 0x13 }, { 0x2AED, 0x1A }, { 0x2AEE, 0x6B },
		{ 0x2AEF, 0x2D }, { 0x2AF2, 0xFF }, { 0x2AF3, 0x7F }, { 0x2AF4, 0x1F },
		{ 0x2AF5, 0x42 }, { 0x2AF6, 0xF2 }, { 0x2AF7, 0x1C }, { 0x2AFA, 0xFF },
		{ 0x2AFB, 0x7F }, { 0x2AFC, 0x1F }, { 0x2AFD, 0x42 }, { 0x2AFE, 0xF2 },
		{ 0x2AFF, 0x1C }, { 0x2B00, 0xD6 }, { 0x2B01, 0x7E }, { 0x2B02, 0xFF },
		{ 0x2B03, 0x4B }, { 0x2B04, 0x75 }, { 0x2B05, 0x21 }, { 0x2B08, 0xFF },
		{ 0x2B09, 0x7F }, { 0x2B0A, 0x1F }, { 0x2B0B, 0x42 }, { 0x2B0C, 0xF2 },
		{ 0x2B0D, 0x1C }, { 0x2B10, 0xFF }, { 0x2B11, 0x7F }, { 0x2B12, 0x1F },
		{ 0x2B13, 0x42 }, { 0x2B14, 0xF2 }, { 0x2B15, 0x1C }, { 0x2B18, 0xFF },
		{ 0x2B19, 0x7F }, { 0x2B1A, 0x8C }, { 0x2B1B, 0x7E }, { 0x2B1D, 0x7C },
		{ 0x2B20, 0x1F }, { 0x2B21, 0x23 }, { 0x2B22, 0x5F }, { 0x2B23, 0x03 },
		{ 0x2B24, 0xF2 }, { 0x2B26, 0x09 }, { 0x2B28, 0x1F }, { 0x2B29, 0x23 },
		{ 0x2B2A, 0x5F }, { 0x2B2B, 0x03 }, { 0x2B2C, 0xF2 }, { 0x2B2E, 0x09 },
		{ 0x2B30, 0xFF }, { 0x2B31, 0x7F }, { 0x2B32, 0x31 }, { 0x2B33, 0x6E },
		{ 0x2B34, 0x4A }, { 0x2B35, 0x45 }, { 0x2B38, 0xFF }, { 0x2B39, 0x7F },
		{ 0x2B3A, 0x1F }, { 0x2B3B, 0x42 }, { 0x2B3C, 0xF2 }, { 0x2B3D, 0x1C },
		{ 0x2B40, 0xFF }, { 0x2B41, 0x7F }, { 0x2B42, 0x1F }, { 0x2B43, 0x42 },
		{ 0x2B44, 0xF2 }, { 0x2B45, 0x1C }, { 0x2B48, 0xFF }, { 0x2B49, 0x7F },
		{ 0x2B4A, 0x31 }, { 0x2B4B, 0x6E }, { 0x2B4C, 0x4A }, { 0x2B4D, 0x45 },
		{ 0x2B50, 0xFF }, { 0x2B51, 0x7F }, { 0x2B52, 0x1F }, { 0x2B53, 0x42 },
		{ 0x2B54, 0xF2 }, { 0x2B55, 0x1C }, { 0x2B58, 0xFF }, { 0x2B59, 0x7F },
		{ 0x2B5A, 0x1F }, { 0x2B5B, 0x42 }, { 0x2B5C, 0xF2 }, { 0x2B5D, 0x1C },
		{ 0x2B60, 0xFF }, { 0x2B61, 0x7F }, { 0x2B62, 0xEF }, { 0x2B63, 0x1B },
		{ 0x2B65, 0x02 }, { 0x2B68, 0xFF }, { 0x2B69, 0x7F }, { 0x2B6A, 0x8C },
		{ 0x2B6B, 0x7E }, { 0x2B6D, 0x7C }, { 0x2B70, 0xFF }, { 0x2B71, 0x7F },
		{ 0x2B72, 0x8C }, { 0x2B73, 0x7E }, { 0x2B75, 0x7C }, { 0x2B78, 0xFF },
		{ 0x2B79, 0x7F }, { 0x2B7A, 0xBF }, { 0x2B7B, 0x32 }, { 0x2B7C, 0xD0 },
		{ 0x2B80, 0xFF }, { 0x2B81, 0x7F }, { 0x2B82, 0xEF }, { 0x2B83, 0x1B },
		{ 0x2B85, 0x02 }, { 0x2B88, 0xFF }, { 0x2B89, 0x7F }, { 0x2B8A, 0xEF },
		{ 0x2B8B, 0x1B }, { 0x2B8D, 0x02 }, { 0x2B90, 0xFF }, { 0x2B91, 0x7F },
		{ 0x2B92, 0x1F }, { 0x2B93, 0x42 }, { 0x2B94, 0xF2 }, { 0x2B95, 0x1C },
		{ 0x2B98, 0xFF }, { 0x2B99, 0x7F }, { 0x2B9A, 0xE0 }, { 0x2B9B, 0x03 },
		{ 0x2B9C, 0x06 }, { 0x2B9D, 0x02 }, { 0x2B9E, 0x20 }, { 0x2B9F, 0x01 },
		{ 0x2BA0, 0xFF }, { 0x2BA1, 0x7F }, { 0x2BA2, 0xE0 }, { 0x2BA3, 0x03 },
		{ 0x2BA4, 0x06 }, { 0x2BA5, 0x02 }, { 0x2BA6, 0x20 }, { 0x2BA7, 0x01 },
		{ 0x2BA8, 0xFF }, { 0x2BA9, 0x7F }, { 0x2BAA, 0x1F }, { 0x2BAB, 0x42 },
		{ 0x2BAC, 0xF2 }, { 0x2BAD, 0x1C }, { 0x2BB0, 0xFF }, { 0x2BB1, 0x7F },
		{ 0x2BB2, 0xEF }, { 0x2BB3, 0x1B }, { 0x2BB5, 0x02 }, { 0x2BB8, 0xFF },
		{ 0x2BB9, 0x7F }, { 0x2BBA, 0xEF }, { 0x2BBB, 0x1B }, { 0x2BBD, 0x02 },
		{ 0x2BC0, 0xFF }, { 0x2BC1, 0x7F }, { 0x2BC2, 0xBF }, { 0x2BC3, 0x32 },
		{ 0x2BC4, 0xD0 }, { 0x2BC8, 0xFF }, { 0x2BC9, 0x7F }, { 0x2BCA, 0x1F },
		{ 0x2BCB, 0x42 }, { 0x2BCC, 0xF2 }, { 0x2BCD, 0x1C }, { 0x2BD0, 0xFF },
		{ 0x2BD1, 0x7F }, { 0x2BD2, 0x1F }, { 0x2BD3, 0x42 }, { 0x2BD4, 0xF2 },
		{ 0x2BD5, 0x1C }, { 0x2BDB, 0x42 }, { 0x2BDC, 0x7F }, { 0x2BDD, 0x03 },
		{ 0x2BDE, 0xFF }, { 0x2BDF, 0x7F }, { 0x2BE0, 0xFF }, { 0x2BE1, 0x03 },
		{ 0x2BE2, 0x1F }, { 0x2BE4, 0x0C }, { 0x2BE8, 0xFF }, { 0x2BE9, 0x03 },
		{ 0x2BEA, 0x1F }, { 0x2BEC, 0x0C }, { 0x2BF0, 0xFF }, { 0x2BF1, 0x7F },
		{ 0x2BF2, 0x8C }, { 0x2BF3, 0x7E }, { 0x2BF5, 0x7C }, { 0x2BF8, 0xFF },
		{ 0x2BF9, 0x7F }, { 0x2BFA, 0xBF }, { 0x2BFB, 0x32 }, { 0x2BFC, 0xD0 },
		{ 0x2C00, 0xFF }, { 0x2C01, 0x7F }, { 0x2C02, 0xBF }, { 0x2C03, 0x32 },
		{ 0x2C04, 0xD0 }, { 0x2C08, 0xFF }, { 0x2C09, 0x7F }, { 0x2C0A, 0xB5 },
		{ 0x2C0B, 0x42 }, { 0x2C0C, 0xC8 }, { 0x2C0D, 0x3D }, { 0x2C10, 0xFF },
		{ 0x2C11, 0x7F }, { 0x2C12, 0x94 }, { 0x2C13, 0x52 }, { 0x2C14, 0x4A },
		{ 0x2C15, 0x29 }, { 0x2C18, 0xFF }, { 0x2C19, 0x7F }, { 0x2C1A, 0x94 },
		{ 0x2C1B, 0x52 }, { 0x2C1C, 0x4A }, { 0x2C1D, 0x29 }, { 0x2C20, 0xFF },
		{ 0x2C21, 0x7F }, { 0x2C22, 0x94 }, { 0x2C23, 0x52 }, { 0x2C24, 0x4A },
		{ 0x2C25, 0x29 }, { 0x2C28, 0xFF }, { 0x2C29, 0x7F }, { 0x2C2A, 0xEF },
		{ 0x2C2B, 0x1B }, { 0x2C2D, 0x02 }, { 0x2C30, 0xFF }, { 0x2C31, 0x7F },
		{ 0x2C32, 0xEF }, { 0x2C33, 0x1B }, { 0x2C35, 0x02 }, { 0x2C38, 0xFF },
		{ 0x2C39, 0x53 }, { 0x2C3A, 0x5F }, { 0x2C3B, 0x4A }, { 0x2C3C, 0x52 },
		{ 0x2C3D, 0x7E }, { 0x2C40, 0xFF }, { 0x2C41, 0x7F }, { 0x2C42, 0x1F },
		{ 0x2C43, 0x42 }, { 0x2C44, 0xF2 }, { 0x2C45, 0x1C }, { 0x2C48, 0xFF },
		{ 0x2C49, 0x7F }, { 0x2C4A, 0x1F }, { 0x2C4B, 0x42 }, { 0x2C4C, 0xF2 },
		{ 0x2C4D, 0x1C }, { 0x2C50, 0xFF }, { 0x2C51, 0x7F }, { 0x2C52, 0x8C },
		{ 0x2C53, 0x7E }, { 0x2C55, 0x7C }, { 0x2C58, 0xFF }, { 0x2C59, 0x7F },
		{ 0x2C5A, 0xBF }, { 0x2C5B, 0x32 }, { 0x2C5C, 0xD0 }, { 0x2C60, 0xFF },
		{ 0x2C61, 0x7F }, { 0x2C62, 0xBF }, { 0x2C63, 0x32 }, { 0x2C64, 0xD0 },
		{ 0x2C68, 0x9F }, { 0x2C69, 0x63 }, { 0x2C6A, 0x79 }, { 0x2C6B, 0x42 },
		{ 0x2C6C, 0xB0 }, { 0x2C6D, 0x15 }, { 0x2C6E, 0xCB }, { 0x2C6F, 0x04 },
		{ 0x2C70, 0xFF }, { 0x2C71, 0x7F }, { 0x2C72, 0x8C }, { 0x2C73, 0x7E },
		{ 0x2C75, 0x7C }, { 0x2C78, 0xFF }, { 0x2C79, 0x7F }, { 0x2C7A, 0x8C },
		{ 0x2C7B, 0x7E }, { 0x2C7D, 0x7C }, { 0x2C80, 0xFF }, { 0x2C81, 0x7F },
		{ 0x2C82, 0xFF }, { 0x2C83, 0x03 }, { 0x2C84, 0x2F }, { 0x2C85, 0x01 },
		{ 0x2C88, 0xFF }, { 0x2C89, 0x7F }, { 0x2C8A, 0x3F }, { 0x2C8B, 0x03 },
		{ 0x2C8C, 0x93 }, { 0x2C8D, 0x01 }, { 0x2C90, 0xFF }, { 0x2C91, 0x7F },
		{ 0x2C92, 0x3F }, { 0x2C93, 0x03 }, { 0x2C94, 0x93 }, { 0x2C95, 0x01 },
		{ 0x2C98, 0xFF }, { 0x2C99, 0x7F }, { 0x2C9A, 0x3F }, { 0x2C9B, 0x03 },
		{ 0x2C9C, 0x93 }, { 0x2C9D, 0x01 }, { 0x2CA0, 0xFF }, { 0x2CA1, 0x7F },
		{ 0x2CA2, 0x1F }, { 0x2CA3, 0x42 }, { 0x2CA4, 0xF2 }, { 0x2CA5, 0x1C },
		{ 0x2CA8, 0xFF }, { 0x2CA9, 0x7F }, { 0x2CAA, 0x1F }, { 0x2CAB, 0x42 },
		{ 0x2CAC, 0xF2 }, { 0x2CAD, 0x1C }, { 0x2CB0, 0xFF }, { 0x2CB1, 0x7F },
		{ 0x2CB2, 0xEF }, { 0x2CB3, 0x1B }, { 0x2CB4, 0x80 }, { 0x2CB5, 0x61 },
		{ 0x2CB8, 0x20 }, { 0x2CB9, 0x21 }, { 0x2CBA, 0x22 }, { 0x2CBB, 0x80 },
		{ 0x2CBC, 0x81 }, { 0x2CBD, 0x82 }, { 0x2CBE, 0x10 }, { 0x2CBF, 0x11 },
		{ 0x2CC0, 0x20 }, { 0x2CC1, 0x21 }, { 0x2CC2, 0x22 }, { 0x2CC3, 0x80 },
		{ 0x2CC4, 0x81 }, { 0x2CC5, 0x82 }, { 0x2CC6, 0x10 }, { 0x2CC7, 0x11 },
		{ 0x2CC9, 0xFF }, { 0x2CCA, 0x7F }, { 0x2CCB, 0xFF }, { 0x2CCC, 0x03 },
		{ 0x2CCD, 0x1F }, { 0x2CD0, 0xFF }, { 0x2CD1, 0x7F }, { 0x2CD2, 0xBF },
		{ 0x2CD3, 0x32 }, { 0x2CD4, 0xD0 }, { 0x2CD8, 0xFF }, { 0x2CD9, 0x7F },
		{ 0x2CDA, 0xBF }, { 0x2CDB, 0x32 }, { 0x2CDC, 0xD0 }, { 0x2CE0, 0xFF },
		{ 0x2CE1, 0x7F }, { 0x2CE2, 0xBF }, { 0x2CE3, 0x32 }, { 0x2CE4, 0xD0 },
		{ 0x2CE8, 0xFF }, { 0x2CE9, 0x7F }, { 0x2CEA, 0xBF }, { 0x2CEB, 0x32 },
		{ 0x2CEC, 0xD0 }, { 0x2CF0, 0xFF }, { 0x2CF1, 0x7F }, { 0x2CF2, 0xBF },
		{ 0x2CF3, 0x32 }, { 0x2CF4, 0xD0 }, { 0x2CF8, 0xFF }, { 0x2CF9, 0x7F },
		{ 0x2CFA, 0xBF }, { 0x2CFB, 0x32 }, { 0x2CFC, 0xD0 }, { 0x307F, 0x40 },
		{ 0x30E9, 0x02 }, { 0x30F4, 0xBF }, { 0x3107, 0xF7 }, { 0x3180, 0x3F },
		{ 0x31BB, 0x10 }, { 0x31F4, 0xDF }, { 0x3212, 0x7F }, { 0x3225, 0x7F },
		{ 0x326A, 0x01 }, { 0x32B0, 0x7F }, { 0x32B5, 0xF7 }, { 0x32F0, 0xFD },
		{ 0x32F6, 0x7F }, { 0x3300, 0x7F }, { 0x3311, 0xF7 }, { 0x3331, 0xDF },
		{ 0x3354, 0xF7 }, { 0x3397, 0xBF }, { 0x33BC, 0x04 }, { 0x3437, 0xDF },
		{ 0x34D1, 0x7F }, { 0x34E1, 0xDF }, { 0x3510, 0xBF }, { 0x3547, 0x7F },
		{ 0x3573, 0xF7 }, { 0x3586, 0xDF }, { 0x35A5, 0xBF }, { 0x35B0, 0xF7 },
		{ 0x35D7, 0xF7 }, { 0x3601, 0xDF }, { 0x3607, 0xBD }, { 0x3634, 0xF7 },
		{ 0x3690, 0xF7 }, { 0x369A, 0x04 }, { 0x36C8, 0x10 }, { 0x36D2, 0xF7 },
		{ 0x36E3, 0xBF }, { 0x3705, 0xFD }, { 0x371C, 0x40 }, { 0x371D, 0x01 },
		{ 0x371F, 0x04 }, { 0x372E, 0x40 }, { 0x3731, 0xDF }, { 0x3768, 0x01 },
		{ 0x3780, 0xBF }, { 0x37A7, 0x7F }, { 0x37CD, 0x01 }, { 0x37F6, 0xF7 },
		{ 0x3808, 0x7F }, { 0x380C, 0xBF }, { 0x3834, 0x02 }, { 0x383A, 0xBF },
		{ 0x384D, 0xBF }, { 0x385A, 0x7F }, { 0x385D, 0x7F }, { 0x386B, 0xBF },
		{ 0x387B, 0xFB }, { 0x387C, 0xFD }, { 0x3889, 0xBF }, { 0x388A, 0x7F },
		{ 0x38A8, 0xF7 }, { 0x38AA, 0x7F }, { 0x38AE, 0xBF }, { 0x38BC, 0x7F },
		{ 0x38EC, 0xDF }, { 0x38FB, 0xF7 }, { 0x38FC, 0xFD }, { 0x390B, 0xBF },
		{ 0x392B, 0x7F }, { 0x392D, 0xBF }, { 0x393D, 0xFB }, { 0x3958, 0xFD },
		{ 0x395F, 0xF7 }, { 0x396F, 0x7F }, { 0x3979, 0xDF }, { 0x397F, 0x7F },
		{ 0x3989, 0xF3 }, { 0x398F, 0x7F }, { 0x3998, 0xBF }, { 0x399E, 0xF7 },
		{ 0x399F, 0xFB }, { 0x39AC, 0xF7 }, { 0x39AD, 0xDF }, { 0x39AE, 0xF7 },
		{ 0x39AF, 0xF7 }, { 0x39BA, 0xF7 }, { 0x39BB, 0xF7 }, { 0x39BE, 0xFB },
		{ 0x39BF, 0x7F }, { 0x39C8, 0xFB }, { 0x39CC, 0xF7 }, { 0x39D9, 0x7F },
		{ 0x39DE, 0x7F }, { 0x39DF, 0x7F }, { 0x39EA, 0xF7 }, { 0x39FD, 0xBF },
		{ 0x39FE, 0xF7 }, { 0x3A09, 0x7F }, { 0x3A18, 0xBF }, { 0x3A1B, 0xBF },
		{ 0x3A1D, 0xF7 }, { 0x3A2B, 0xBF }, { 0x3A2C, 0xF7 }, { 0x3A2F, 0x7F },
		{ 0x3A3E, 0xDF }, { 0x3A4E, 0x7F }, { 0x3A4F, 0x7F }, { 0x3A5D, 0x7F },
		{ 0x3A6D, 0xDF }, { 0x3A6E, 0xDF }, { 0x3A8B, 0xF7 }, { 0x3A99, 0xBF },
		{ 0x3A9D, 0x7F }, { 0x3A9E, 0xF7 }, { 0x3AAB, 0xF7 }, { 0x3AAC, 0xDF },
		{ 0x3AAE, 0xF7 }, { 0x3ACD, 0xD7 }, { 0x3ACE, 0xF7 }, { 0x3AD8, 0x7F },
		{ 0x3AE9, 0xFD }, { 0x3AEB, 0x3F }, { 0x3AFB, 0xF7 }, { 0x3B1C, 0xF5 },
		{ 0x3B2B, 0xF7 }, { 0x3B2C, 0x9F }, { 0x3B2D, 0xBF }, { 0x3B3C, 0xDB },
		{ 0x3B3D, 0xF7 }, { 0x3B3E, 0x7F }, { 0x3B3F, 0xFB }, { 0x3B48, 0xFB },
		{ 0x3B4B, 0x7F }, { 0x3B4C, 0xF7 }, { 0x3B5A, 0x7F }, { 0x3B6A, 0x7F },
		{ 0x3B6B, 0xBF }, { 0x3B7B, 0xFB }, { 0x3B7D, 0x7F }, { 0x3B7F, 0xBF },
		{ 0x3B8D, 0xFB }, { 0x3B8F, 0x5F }, { 0x3B98, 0x7F }, { 0x3B9A, 0x7F },
		{ 0x3B9E, 0xFD }, { 0x3BAB, 0xFD }, { 0x3BAC, 0xDF }, { 0x3BAF, 0xF7 },
		{ 0x3BB2, 0x02 }, { 0x3BBB, 0x7F }, { 0x3BCE, 0xFD }, { 0x3BDB, 0xBF },
		{ 0x3C18, 0x7F }, { 0x3C1F, 0x7F }, { 0x3C2B, 0xF7 }, { 0x3C39, 0xFD },
		{ 0x3C4A, 0x77 }, { 0x3C4C, 0x7F }, { 0x3C59, 0xBF }, { 0x3C5F, 0xFB },
		{ 0x3C68, 0x7F }, { 0x3C69, 0xDF }, { 0x3C6A, 0xBB }, { 0x3C6F, 0x7F },
		{ 0x3C79, 0xF7 }, { 0x3C8B, 0xDF }, { 0x3C9A, 0x5F }, { 0x3CA9, 0x7F },
		{ 0x3CAF, 0xBF }, { 0x3CB8, 0xBF }, { 0x3CB9, 0x7F }, { 0x3CBA, 0x7F },
		{ 0x3CBB, 0x7F }, { 0x3CBC, 0xBF }, { 0x3CBF, 0xDD }, { 0x3CC8, 0xDF },
		{ 0x3CCF, 0x7F }, { 0x3CDD, 0xF7 }, { 0x3CDE, 0x77 }, { 0x3CE8, 0xF7 },
		{ 0x3CEB, 0xDF }, { 0x3CEF, 0xFB }, { 0x3CF0, 0x01 }, { 0x3CF9, 0x7F },
		{ 0x3CFB, 0xF7 }, { 0x3D19, 0xF7 }, { 0x3D2A, 0xFB }, { 0x3D2F, 0x7F },
		{ 0x3D3B, 0xDD }, { 0x3D3F, 0xFB }, { 0x3D48, 0xBF }, { 0x3D5B, 0xF7 },
		{ 0x3D6F, 0xBF }, { 0x3D7D, 0xFB }, { 0x3D8A, 0x7F }, { 0x3D8C, 0xFB },
		{ 0x3D96, 0x40 }, { 0x3D9F, 0x7F }, { 0x3DAA, 0xF7 }, { 0x3DAD, 0xF7 },
		{ 0x3DAF, 0x77 }, { 0x3DB8, 0x7F }, { 0x3DBC, 0xBF }, { 0x3DBD, 0xDF },
		{ 0x3DC9, 0xF7 }, { 0x3DEF, 0xDF }, { 0x3DFA, 0xDF }, { 0x3DFD, 0xFD },
		{ 0x3DFE, 0xFB }, { 0x3E18, 0xFB }, { 0x3E1F, 0xF7 }, { 0x3E2D, 0xDF },
		{ 0x3E2F, 0xFB }, { 0x3E3D, 0x7F }, { 0x3E3F, 0xFB }, { 0x3E48, 0xF5 },
		{ 0x3E49, 0xFD }, { 0x3E5C, 0xFB }, { 0x3E5F, 0x5F }, { 0x3E6D, 0xBF },
		{ 0x3E6F, 0x7F }, { 0x3E7C, 0xFD }, { 0x3E7E, 0x7F }, { 0x3E88, 0xFD },
		{ 0x3E9E, 0xFD }, { 0x3EAE, 0x7F }, { 0x3EBC, 0xDF }, { 0x3ECD, 0x77 },
		{ 0x3EED, 0xF7 }, { 0x3EFB, 0x7F }, { 0x3F08, 0xF7 }, { 0x3F0F, 0xFD },
		{ 0x3F1D, 0xBF }, { 0x3F1E, 0x9F }, { 0x3F29, 0xFB }, { 0x3F2E, 0x7F },
		{ 0x3F39, 0xDF }, { 0x3F3F, 0xDF }, { 0x3F48, 0xDF }, { 0x3F4E, 0xFB },
		{ 0x3F69, 0xFD }, { 0x3F7C, 0xFD }, { 0x3F7E, 0x3F }, { 0x3F89, 0xF7 },
		{ 0x3F9B, 0xF7 }, { 0x3F9E, 0xF7 }, { 0x3FAE, 0x7F }, { 0x3FB2, 0xDF },
		{ 0x3FBC, 0xF7 }, { 0x3FD9, 0xBD }, { 0x3FDB, 0xD7 }, { 0x3FDE, 0x7F },
		{ 0x3FEE, 0x7F }, { 0x3FEF, 0x7F }, { 0x3FFE, 0x7B }, { 0x4045, 0x7F },
		{ 0x408C, 0x20 }, { 0x40A7, 0xFD }, { 0x40B3, 0xD7 }, { 0x40D1, 0x7F },
		{ 0x40E0, 0x77 }, { 0x40FE, 0x40 }, { 0x4103, 0x7F }, { 0x4130, 0xBF },
		{ 0x413D, 0x10 }, { 0x4152, 0xF7 }, { 0x4159, 0x01 }, { 0x417D, 0x02 },
		{ 0x41A5, 0xDF }, { 0x41A7, 0x7F }, { 0x4218, 0x40 }, { 0x421F, 0x02 },
		{ 0x4222, 0xF7 }, { 0x4286, 0xF7 }, { 0x42E3, 0x9F }, { 0x4303, 0xFB },
		{ 0x434E, 0x04 }, { 0x43BA, 0x01 }, { 0x4408, 0x01 }, { 0x4413, 0xF7 },
		{ 0x442E, 0x20 }, { 0x443B, 0x01 }, { 0x44C7, 0x7F }, { 0x44E0, 0x7F },
		{ 0x44E7, 0xF7 }, { 0x4523, 0xF7 }, { 0x4534, 0x7F }, { 0x4546, 0x7F },
		{ 0x4579, 0x10 }, { 0x458A, 0x01 }, { 0x4594, 0xFB }, { 0x459A, 0x02 },
		{ 0x45B4, 0xF7 }, { 0x45B6, 0xFD }, { 0x45C5, 0x7F }, { 0x45D5, 0x7F },
		{ 0x45F0, 0xF7 }, { 0x4613, 0xFB }, { 0x4638, 0x01 }, { 0x4678, 0x01 },
		{ 0x4694, 0xBF }, { 0x46A0, 0xF7 }, { 0x46CE, 0x01 }, { 0x46D6, 0xBF },
		{ 0x46F4, 0xF7 }, { 0x46F5, 0xDF }, { 0x4710, 0x7F }, { 0x4727, 0x7F },
		{ 0x472B, 0x04 }, { 0x4730, 0xBF }, { 0x4736, 0x7F }, { 0x4762, 0xF7 },
		{ 0x476C, 0x04 }, { 0x477B, 0x04 }, { 0x47D5, 0xFB }, { 0x47E4, 0xBF },
		{ 0x47F0, 0xDF }, { 0x4809, 0x7F }, { 0x480D, 0x7F }, { 0x481E, 0xDF },
		{ 0x4828, 0x7F }, { 0x482E, 0xFD }, { 0x4838, 0xFD }, { 0x483D, 0x7F },
		{ 0x483F, 0xFB }, { 0x484B, 0xFD }, { 0x484D, 0x7F }, { 0x485E, 0xFD },
		{ 0x486F, 0xBF }, { 0x4878, 0xDF }, { 0x4888, 0xFB }, { 0x4889, 0xF7 },
		{ 0x488D, 0x7F }, { 0x48A9, 0x7F }, { 0x48AC, 0xDF }, { 0x48AE, 0x7F },
		{ 0x48B4, 0x01 }, { 0x48BC, 0xF7 }, { 0x48BD, 0xBB }, { 0x48BE, 0xF7 },
		{ 0x48C8, 0xFB }, { 0x48CB, 0xDF }, { 0x48CC, 0x7F }, { 0x48ED, 0xFB },
		{ 0x48EE, 0x7F }, { 0x48F0, 0x10 }, { 0x490B, 0xB7 }, { 0x4929, 0x7F },
		{ 0x492E, 0xBF }, { 0x4930, 0x01 }, { 0x493D, 0xDF }, { 0x4948, 0xFB },
		{ 0x494A, 0x7F }, { 0x494E, 0xFB }, { 0x496E, 0x5F }, { 0x496F, 0xDF },
		{ 0x4979, 0xF7 }, { 0x498E, 0xDF }, { 0x499A, 0xFB }, { 0x499D, 0xF7 },
		{ 0x499F, 0xF7 }, { 0x49A9, 0xBF }, { 0x49AA, 0x7F }, { 0x49BD, 0xF7 },
		{ 0x49BE, 0xFD }, { 0x49C9, 0xBF }, { 0x49DE, 0x7F }, { 0x49EB, 0xFD },
		{ 0x49EE, 0x7F }, { 0x4A1B, 0xF7 }, { 0x4A1D, 0x77 }, { 0x4A1E, 0x7F },
		{ 0x4A1F, 0xBF }, { 0x4A2B, 0xDF }, { 0x4A30, 0x40 }, { 0x4A3F, 0xF3 },
		{ 0x4A4F, 0xFB }, { 0x4A58, 0xF7 }, { 0x4A69, 0xF7 }, { 0x4A6B, 0xF7 },
		{ 0x4A6E, 0xF7 }, { 0x4A7E, 0xFD }, { 0x4A8F, 0x7F }, { 0x4A99, 0x7F },
		{ 0x4A9A, 0xF7 }, { 0x4A9D, 0x7F }, { 0x4A9E, 0xFB }, { 0x4AAE, 0xFD },
		{ 0x4AB9, 0x7F }, { 0x4ABC, 0x7F }, { 0x4ABD, 0xF7 }, { 0x4ACB, 0xBF },
		{ 0x4ACE, 0xF7 }, { 0x4ACF, 0xDF }, { 0x4ADC, 0xF7 }, { 0x4ADE, 0xFB },
		{ 0x4AEE, 0xBF }, { 0x4AFF, 0x7F }, { 0x4B1B, 0xFB }, { 0x4B1E, 0xF3 },
		{ 0x4B28, 0xF7 }, { 0x4B3A, 0xF7 }, { 0x4B3B, 0x5D }, { 0x4B3D, 0xFB },
		{ 0x4B3F, 0x3F }, { 0x4B4D, 0xBF }, { 0x4B4E, 0xF7 }, { 0x4B5F, 0x7F },
		{ 0x4B6E, 0xFB }, { 0x4B8A, 0xDF }, { 0x4B8F, 0x7F }, { 0x4B90, 0x10 },
		{ 0x4B9B, 0xDD }, { 0x4B9F, 0x7F }, { 0x4BA9, 0x7F }, { 0x4BAC, 0xBF },
		{ 0x4BB9, 0xFD }, { 0x4BC8, 0xFB }, { 0x4BCA, 0xFB }, { 0x4BCB, 0xDB },
		{ 0x4BCD, 0x77 }, { 0x4BDB, 0xFD }, { 0x4BDC, 0xF7 }, { 0x4BDF, 0x7F },
		{ 0x4BE9, 0x7F }, { 0x4BF9, 0xF7 }, { 0x4BFA, 0xFB }, { 0x4BFB, 0xBF },
		{ 0x4BFD, 0x77 }, { 0x4BFE, 0xF9 }, { 0x4C0A, 0x7F }, { 0x4C0F, 0xBF },
		{ 0x4C18, 0xFD }, { 0x4C19, 0xBF }, { 0x4C1B, 0xF7 }, { 0x4C1C, 0x7F },
		{ 0x4C1E, 0x7F }, { 0x4C1F, 0x7F }, { 0x4C38, 0xF7 }, { 0x4C3D, 0xF7 },
		{ 0x4C48, 0xDF }, { 0x4C4A, 0xF7 }, { 0x4C4D, 0xDF }, { 0x4C5D, 0xF7 },
		{ 0x4C68, 0x7F }, { 0x4C6B, 0x7F }, { 0x4C6F, 0x7F }, { 0x4C7F, 0x7F },
		{ 0x4C81, 0x40 }, { 0x4C88, 0xFB }, { 0x4C99, 0xF7 }, { 0x4C9C, 0x7F },
		{ 0x4C9D, 0x7F }, { 0x4CAE, 0x7F }, { 0x4CAF, 0x7F }, { 0x4CBA, 0xBF },
		{ 0x4CBB, 0x7F }, { 0x4CBC, 0xFB }, { 0x4CBF, 0xF7 }, { 0x4CCA, 0xBF },
		{ 0x4CCB, 0xBF }, { 0x4CCF, 0xBF }, { 0x4CDA, 0xF3 }, { 0x4CDB, 0xBF },
		{ 0x4CE8, 0xFD }, { 0x4CEB, 0xFB }, { 0x4CED, 0xDF }, { 0x4D08, 0xBF },
		{ 0x4D0A, 0x77 }, { 0x4D19, 0xFB }, { 0x4D1C, 0xFB }, { 0x4D1F, 0xBF },
		{ 0x4D2F, 0x7D }, { 0x4D39, 0xBF }, { 0x4D3A, 0xDF }, { 0x4D3B, 0x77 },
		{ 0x4D5A, 0xBF }, { 0x4D5B, 0x77 }, { 0x4D5E, 0xF7 }, { 0x4D7A, 0xB7 },
		{ 0x4D7B, 0xF7 }, { 0x4D7C, 0x7F }, { 0x4D7F, 0x7F }, { 0x4D8D, 0xDF },
		{ 0x4D8F, 0xF7 }, { 0x4D9F, 0x7F }, { 0x4DBD, 0x7F }, { 0x4DCC, 0xBF },
		{ 0x4DCF, 0x7F }, { 0x4DD8, 0xFD }, { 0x4DDB, 0x7F }, { 0x4DE5, 0x04 },
		{ 0x4DFA, 0xBF }, { 0x4E0B, 0xDF }, { 0x4E0C, 0x7F }, { 0x4E19, 0xFD },
		{ 0x4E1B, 0xF7 }, { 0x4E1F, 0xFB }, { 0x4E4F, 0x7F }, { 0x4E69, 0x7F },
		{ 0x4E6F, 0xFD }, { 0x4E7B, 0xFB }, { 0x4E7F, 0xBF }, { 0x4E89, 0xF7 },
		{ 0x4E98, 0xFB }, { 0x4E9E, 0x7F }, { 0x4EA8, 0xF7 }, { 0x4EA9, 0xFD },
		{ 0x4EBB, 0xD7 }, { 0x4EC8, 0xBF }, { 0x4EE0, 0x40 }, { 0x4EEC, 0xF7 },
		{ 0x4EFB, 0xFB }, { 0x4EFC, 0x7F }, { 0x4EFF, 0xFD }, { 0x4F0C, 0x7F },
		{ 0x4F0D, 0xFB }, { 0x4F1D, 0xFB }, { 0x4F28, 0xBF }, { 0x4F3D, 0xBF },
		{ 0x4F4D, 0xDF }, { 0x4F4F, 0xFB }, { 0x4F5C, 0xF7 }, { 0x4F5E, 0xF7 },
		{ 0x4F6F, 0xFD }, { 0x4F78, 0xF7 }, { 0x4F7B, 0xF7 }, { 0x4F7D, 0x7F },
		{ 0x4F85, 0x10 }, { 0x4F99, 0xFD }, { 0x4F9D, 0x7F }, { 0x4F9F, 0x7F },
		{ 0x4FAB, 0xFB }, { 0x4FAC, 0x7F }, { 0x4FAD, 0x7D }, { 0x4FAF, 0xFD },
		{ 0x4FBD, 0xF7 }, { 0x4FC8, 0x7D }, { 0x4FD9, 0x9F }, { 0x4FDE, 0x7F },
		{ 0x4FE9, 0x7F }, { 0x4FED, 0xFD }, { 0x4FEE, 0xFD }, { 0x4FF9, 0xF7 },
		{ 0x4FFC, 0xBF }, { 0x4FFF, 0x7F }, { 0x5008, 0x01 }, { 0x5063, 0xBF },
		{ 0x5086, 0xBF }, { 0x509A, 0x04 }, { 0x50B1, 0xF7 }, { 0x50DC, 0x04 },
		{ 0x5131, 0x7F }, { 0x514E, 0x20 }, { 0x515A, 0x10 }, { 0x517B, 0x01 },
		{ 0x518F, 0x01 }, { 0x51A2, 0xBF }, { 0x51D1, 0x7F }, { 0x5201, 0xFB },
		{ 0x5212, 0xF7 }, { 0x5219, 0x04 }, { 0x5232, 0xF7 }, { 0x5242, 0x7F },
		{ 0x531B, 0x01 }, { 0x5347, 0x7F }, { 0x5367, 0x7F }, { 0x5372, 0xF7 },
		{ 0x5384, 0xFD }, { 0x53B4, 0xFB }, { 0x53D0, 0xF7 }, { 0x5410, 0xFB },
		{ 0x5442, 0xFD }, { 0x5455, 0x7F }, { 0x5456, 0xBF }, { 0x5462, 0x7F },
		{ 0x5490, 0xBF }, { 0x5524, 0xFB }, { 0x5542, 0xF7 }, { 0x5562, 0xDF },
		{ 0x5575, 0xF7 }, { 0x5581, 0xDF }, { 0x5582, 0xBF }, { 0x55D7, 0x7F },
		{ 0x55F6, 0xF7 }, { 0x5612, 0xDF }, { 0x5613, 0x7F }, { 0x5627, 0xFB },
		{ 0x5644, 0x7F }, { 0x56FA, 0x02 }, { 0x5725, 0xF7 }, { 0x5734, 0xFD },
		{ 0x5739, 0x02 }, { 0x57E9, 0x20 }, { 0x580A, 0xFB }, { 0x580D, 0x7F },
		{ 0x5819, 0x7F }, { 0x581E, 0xFD }, { 0x582F, 0xF7 }, { 0x584D, 0xBF },
		{ 0x584F, 0xFB }, { 0x5859, 0xF7 }, { 0x586D, 0xBF }, { 0x587C, 0xDF },
		{ 0x587E, 0xF7 }, { 0x5889, 0xFD }, { 0x5898, 0xBF }, { 0x589C, 0xF7 },
		{ 0x58AA, 0xBF }, { 0x58CB, 0xDF }, { 0x58EE, 0xF7 }, { 0x58FF, 0x7F },
		{ 0x590E, 0xFB }, { 0x5918, 0xBF }, { 0x5929, 0x7F }, { 0x592A, 0xBF },
		{ 0x592B, 0xFD }, { 0x593A, 0xBF }, { 0x593E, 0x7F }, { 0x5949, 0x7F },
		{ 0x595B, 0x7F }, { 0x5979, 0x7F }, { 0x597D, 0x7F }, { 0x5988, 0x7F },
		{ 0x5989, 0xBF }, { 0x598B, 0x7F }, { 0x5998, 0xBF }, { 0x599F, 0xFD },
		{ 0x59A8, 0xDF }, { 0x59AE, 0xFD }, { 0x59B8, 0x7F }, { 0x59CA, 0xFB },
		{ 0x59CE, 0x7F }, { 0x59CF, 0xFB }, { 0x59DD, 0xBF }, { 0x59EA, 0xFB },
		{ 0x59EB, 0x7F }, { 0x59F8, 0xF7 }, { 0x59F9, 0xFD }, { 0x59FA, 0xF7 },
		{ 0x5A0F, 0xDF }, { 0x5A1A, 0xF7 }, { 0x5A1D, 0x7F }, { 0x5A1F, 0xBF },
		{ 0x5A2E, 0xF7 }, { 0x5A3F, 0x7F }, { 0x5A59, 0xDF }, { 0x5A5A, 0xB7 },
		{ 0x5A5F, 0x7F }, { 0x5A6D, 0xF7 }, { 0x5A7C, 0xDF }, { 0x5A8F, 0x7F },
		{ 0x5A98, 0x7B }, { 0x5AAA, 0x7F }, { 0x5AAF, 0x7F }, { 0x5ABC, 0x7F },
		{ 0x5ABD, 0xFD }, { 0x5ACD, 0xDF }, { 0x5AD9, 0xBF }, { 0x5ADF, 0x7F },
		{ 0x5AE8, 0x7F }, { 0x5AEA, 0xF7 }, { 0x5AED, 0xF7 }, { 0x5AFE, 0xF7 },
		{ 0x5AFF, 0x5F }, { 0x5B09, 0xFB }, { 0x5B0A, 0xFB }, { 0x5B0E, 0xBF },
		{ 0x5B0F, 0x7B }, { 0x5B28, 0xFD }, { 0x5B2B, 0xFB }, { 0x5B2E, 0xBF },
		{ 0x5B2F, 0xFB }, { 0x5B3D, 0xF7 }, { 0x5B3F, 0xF7 }, { 0x5B49, 0x7F },
		{ 0x5B4E, 0xF7 }, { 0x5B5E, 0xF7 }, { 0x5B6B, 0x7F }, { 0x5B6C, 0xBF },
		{ 0x5B6F, 0x7F }, { 0x5B79, 0x7F }, { 0x5B7E, 0x5F }, { 0x5B8E, 0xDF },
		{ 0x5B99, 0xF3 }, { 0x5B9F, 0xD7 }, { 0x5BA8, 0xBF }, { 0x5BAA, 0xBF },
		{ 0x5BAC, 0xF7 }, { 0x5BAD, 0x77 }, { 0x5BBA, 0x7F }, { 0x5BBE, 0xF7 },
		{ 0x5BCA, 0xBF }, { 0x5BCF, 0x5F }, { 0x5BD2, 0x40 }, { 0x5BDB, 0xF7 },
		{ 0x5BEA, 0xF7 }, { 0x5BEB, 0xF7 }, { 0x5BFB, 0xBB }, { 0x5BFD, 0xF7 },
		{ 0x5C0E, 0x7F }, { 0x5C0F, 0xDF }, { 0x5C1A, 0xF7 }, { 0x5C28, 0x7F },
		{ 0x5C2B, 0xF7 }, { 0x5C3D, 0xDF }, { 0x5C3E, 0xFB }, { 0x5C4A, 0xDF },
		{ 0x5C4C, 0xDF }, { 0x5C4D, 0xFD }, { 0x5C5C, 0x7F }, { 0x5C6D, 0x7F },
		{ 0x5C7F, 0x7F }, { 0x5C85, 0x01 }, { 0x5C8A, 0xFD }, { 0x5C8B, 0x7F },
		{ 0x5C9B, 0xBF }, { 0x5C9F, 0x7F }, { 0x5CAE, 0x7F }, { 0x5CAF, 0x7F },
		{ 0x5CB9, 0xFB }, { 0x5CCE, 0xFD }, { 0x5CD3, 0x04 }, { 0x5CD6, 0x01 },
		{ 0x5CDF, 0xFD }, { 0x5CEB, 0x7F }, { 0x5CF9, 0xBF }, { 0x5D0B, 0xBF },
		{ 0x5D1D, 0xFD }, { 0x5D1E, 0x7F }, { 0x5D2B, 0xFD }, { 0x5D2C, 0xFD },
		{ 0x5D2D, 0x7F }, { 0x5D2F, 0xBF }, { 0x5D3A, 0x7F }, { 0x5D3B, 0xF7 },
		{ 0x5D4B, 0xFB }, { 0x5D4D, 0xFB }, { 0x5D4F, 0xF7 }, { 0x5D5A, 0xFD },
		{ 0x5D5B, 0xDF }, { 0x5D5C, 0x7F }, { 0x5D5E, 0xBF }, { 0x5D69, 0xFB },
		{ 0x5D6B, 0xB7 }, { 0x5D6D, 0xBF }, { 0x5D70, 0x02 }, { 0x5D78, 0xF7 },
		{ 0x5D7F, 0xFB }, { 0x5D8A, 0xDF }, { 0x5D8F, 0xFD }, { 0x5D99, 0xBF },
		{ 0x5D9E, 0xDF }, { 0x5DAC, 0xFB }, { 0x5DCB, 0x7F }, { 0x5DCD, 0xBF },
		{ 0x5DDB, 0xD7 }, { 0x5DDE, 0x7F }, { 0x5DE9, 0x7F }, { 0x5DEA, 0xFB },
		{ 0x5DFF, 0x7F }, { 0x5E19, 0xF7 }, { 0x5E1F, 0xFB }, { 0x5E28, 0xBF },
		{ 0x5E2D, 0xDF }, { 0x5E3D, 0x7F }, { 0x5E49, 0x7F }, { 0x5E4E, 0xFB },
		{ 0x5E5C, 0xBF }, { 0x5E68, 0xFD }, { 0x5E6C, 0xDF }, { 0x5E6D, 0xDF },
		{ 0x5E79, 0xDF }, { 0x5E7D, 0x7F }, { 0x5E99, 0x7F }, { 0x5EAF, 0xBF },
		{ 0x5EBC, 0xDF }, { 0x5EC8, 0xBF }, { 0x5ECC, 0xF7 }, { 0x5ED2, 0xBF },
		{ 0x5EF9, 0xF7 }, { 0x5EFE, 0xDF }, { 0x5F08, 0xF7 }, { 0x5F0F, 0xF7 },
		{ 0x5F18, 0xFD }, { 0x5F19, 0x7F }, { 0x5F1B, 0xFD }, { 0x5F3F, 0x7F },
		{ 0x5F4C, 0xFD }, { 0x5F4E, 0xF7 }, { 0x5F5C, 0x7F }, { 0x5F5D, 0xF7 },
		{ 0x5F5E, 0x7F }, { 0x5F69, 0xFB }, { 0x5F6C, 0xFD }, { 0x5F6F, 0xDF },
		{ 0x5F92, 0xF7 }, { 0x5FAD, 0x7F }, { 0x5FAE, 0xF7 }, { 0x5FCD, 0xF7 },
		{ 0x5FCF, 0xBF }, { 0x5FDC, 0xF7 }, { 0x5FDE, 0x7F }, { 0x5FDF, 0x7F },
		{ 0x5FEB, 0x7F }, { 0x5FED, 0xDF }, { 0x5FF8, 0xDF }, { 0x600C, 0x20 },
		{ 0x6041, 0xBF }, { 0x6045, 0x7F }, { 0x6062, 0xF7 }, { 0x6077, 0xBF },
		{ 0x60A0, 0xDF }, { 0x60C1, 0x7F }, { 0x60C7, 0xFD }, { 0x60CB, 0x40 },
		{ 0x60E8, 0x01 }, { 0x6118, 0x02 }, { 0x613C, 0x01 }, { 0x6143, 0xF7 },
		{ 0x614A, 0x40 }, { 0x615B, 0x10 }, { 0x616F, 0x01 }, { 0x617C, 0x01 },
		{ 0x6190, 0xDF }, { 0x6196, 0xF7 }, { 0x61A6, 0x7F }, { 0x61D6, 0xF7 },
		{ 0x61F8, 0x04 }, { 0x61FA, 0x10 }, { 0x6201, 0x7F }, { 0x62A7, 0xBF },
		{ 0x62D4, 0x7F }, { 0x6322, 0xF7 }, { 0x6361, 0xFB }, { 0x6363, 0x7F },
		{ 0x6374, 0xF7 }, { 0x6392, 0x7F }, { 0x639F, 0x01 }, { 0x63A0, 0xF7 },
		{ 0x63A1, 0x7F }, { 0x63D9, 0x20 }, { 0x63E8, 0x01 }, { 0x6406, 0x7F },
		{ 0x6424, 0x7F }, { 0x6437, 0x7F }, { 0x643B, 0x01 }, { 0x64B1, 0xFB },
		{ 0x6514, 0xF7 }, { 0x6536, 0xFD }, { 0x6546, 0x7F }, { 0x6578, 0x01 },
		{ 0x6582, 0x7F }, { 0x65A3, 0xFB }, { 0x65B9, 0x01 }, { 0x65C9, 0x01 },
		{ 0x65E0, 0xF7 }, { 0x6612, 0xDF }, { 0x6632, 0xF7 }, { 0x6636, 0x7F },
		{ 0x6651, 0xF7 }, { 0x6666, 0xF7 }, { 0x6675, 0x7F }, { 0x6684, 0x7F },
		{ 0x6687, 0x7F }, { 0x66E9, 0x40 }, { 0x6706, 0xFD }, { 0x6713, 0xDF },
		{ 0x6758, 0x11 }, { 0x6773, 0xF7 }, { 0x6776, 0xBF }, { 0x67F0, 0x7F },
		{ 0x682B, 0xFB }, { 0x682C, 0xFB }, { 0x683E, 0xF5 }, { 0x683F, 0x7F },
		{ 0x6849, 0xF7 }, { 0x685C, 0xF5 }, { 0x686C, 0x7F }, { 0x686D, 0xF7 },
		{ 0x686E, 0x7F }, { 0x687E, 0xDF }, { 0x6889, 0x7F }, { 0x688E, 0xBF },
		{ 0x688F, 0x7F }, { 0x689B, 0xF7 }, { 0x689C, 0xF7 }, { 0x689E, 0x7F },
		{ 0x68CB, 0xBF }, { 0x68E9, 0x7F }, { 0x68EA, 0xDF }, { 0x68EB, 0x7F },
		{ 0x68EF, 0xF7 }, { 0x690B, 0xF7 }, { 0x6918, 0xBF }, { 0x691D, 0xF7 },
		{ 0x6929, 0x7F }, { 0x6938, 0x7F }, { 0x693A, 0x3F }, { 0x693E, 0x3F },
		{ 0x6949, 0xF7 }, { 0x694C, 0x7F }, { 0x694D, 0xDF }, { 0x694E, 0x77 },
		{ 0x695A, 0xFD }, { 0x697B, 0x7F }, { 0x697E, 0x7F }, { 0x6989, 0x7F },
		{ 0x698A, 0x7F }, { 0x698E, 0xF7 }, { 0x698F, 0xF7 }, { 0x699B, 0xDF },
		{ 0x699E, 0x5F }, { 0x699F, 0xDF }, { 0x69AD, 0x7F }, { 0x69C9, 0xF7 },
		{ 0x69D9, 0xF7 }, { 0x69DC, 0xF7 }, { 0x69F9, 0xBF }, { 0x69FA, 0xF7 },
		{ 0x69FC, 0x7F }, { 0x6A09, 0xF7 }, { 0x6A1B, 0x7F }, { 0x6A2A, 0xF7 },
		{ 0x6A2D, 0xFD }, { 0x6A3C, 0xFD }, { 0x6A3D, 0x7F }, { 0x6A3F, 0x7F },
		{ 0x6A5A, 0xBF }, { 0x6A6C, 0xFB }, { 0x6A6F, 0xFD }, { 0x6A7A, 0xF7 },
		{ 0x6A7B, 0x7B }, { 0x6A89, 0x7F }, { 0x6A9F, 0x7F }, { 0x6AAB, 0xDF },
		{ 0x6AB8, 0xF7 }, { 0x6ABE, 0xFD }, { 0x6AC8, 0xFD }, { 0x6ACB, 0x7F },
		{ 0x6ACF, 0xD7 }, { 0x6ADC, 0xFD }, { 0x6AEA, 0xBF }, { 0x6AEB, 0xF7 },
		{ 0x6AF8, 0xFB }, { 0x6AFD, 0xBF }, { 0x6B1A, 0x7F }, { 0x6B1F, 0x7F },
		{ 0x6B2D, 0xFD }, { 0x6B2E, 0xD7 }, { 0x6B3E, 0xDF }, { 0x6B4B, 0xF7 },
		{ 0x6B4D, 0xFB }, { 0x6B4F, 0xBF }, { 0x6B5E, 0x7B }, { 0x6B5F, 0x7F },
		{ 0x6B6C, 0xFB }, { 0x6B6F, 0xDF }, { 0x6B88, 0xDD }, { 0x6B8A, 0xFB },
		{ 0x6B8B, 0x77 }, { 0x6BA8, 0x7F }, { 0x6BAA, 0xF7 }, { 0x6BCA, 0xFB },
		{ 0x6BCB, 0xF7 }, { 0x6BDB, 0xDF }, { 0x6BDC, 0xBF }, { 0x6BDD, 0x77 },
		{ 0x6BDF, 0xFD }, { 0x6BE8, 0x7F }, { 0x6BE9, 0xF7 }, { 0x6BED, 0x7F },
		{ 0x6BF8, 0xFD }, { 0x6BF9, 0xF5 }, { 0x6BFA, 0xF7 }, { 0x6BFD, 0xF5 },
		{ 0x6BFE, 0xF7 }, { 0x6BFF, 0xBF }, { 0x6C09, 0xFB }, { 0x6C0F, 0x7F },
		{ 0x6C29, 0xD7 }, { 0x6C2F, 0x7F }, { 0x6C3A, 0xDF }, { 0x6C3E, 0xF7 },
		{ 0x6C4E, 0xBF }, { 0x6C5E, 0x7F }, { 0x6C5F, 0xDF }, { 0x6C79, 0xDF },
		{ 0x6C7A, 0x7F }, { 0x6C7E, 0xBF }, { 0x6C8B, 0x7F }, { 0x6C8D, 0xDF },
		{ 0x6C99, 0xFD }, { 0x6C9A, 0xBF }, { 0x6C9E, 0x7F }, { 0x6CA9, 0x7F },
		{ 0x6CAA, 0xF7 }, { 0x6CAC, 0xFB }, { 0x6CAD, 0x7F }, { 0x6CAF, 0xF7 },
		{ 0x6CC9, 0xFB }, { 0x6CDC, 0xFD }, { 0x6CEC, 0xDF }, { 0x6CEF, 0xBF },
		{ 0x6CFB, 0x7F }, { 0x6D1D, 0xFD }, { 0x6D1F, 0xDF }, { 0x6D2B, 0xD9 },
		{ 0x6D3B, 0x7F }, { 0x6D3C, 0xB7 }, { 0x6D4D, 0xBF }, { 0x6D58, 0x7F },
		{ 0x6D5C, 0x7F }, { 0x6D6D, 0xFD }, { 0x6D7E, 0x7F }, { 0x6D89, 0xBF },
		{ 0x6D9B, 0x7F }, { 0x6D9F, 0xF7 }, { 0x6DB9, 0x7F }, { 0x6DBF, 0xFB },
		{ 0x6DE9, 0x7F }, { 0x6DEA, 0xF7 }, { 0x6DEC, 0xBF }, { 0x6DFB, 0x7F },
		{ 0x6E09, 0x7F }, { 0x6E0F, 0x7F }, { 0x6E10, 0x01 }, { 0x6E12, 0xDF },
		{ 0x6E1E, 0xFB }, { 0x6E28, 0xF7 }, { 0x6E2E, 0xFB }, { 0x6E4E, 0x7F },
		{ 0x6E72, 0x7F }, { 0x6E79, 0x7F }, { 0x6E7E, 0x9F }, { 0x6E88, 0x7F },
		{ 0x6E8E, 0xF7 }, { 0x6E9E, 0xBF }, { 0x6EAC, 0xFD }, { 0x6EAD, 0xF7 },
		{ 0x6EAF, 0x7F }, { 0x6EB9, 0xFB }, { 0x6EBE, 0x7F }, { 0x6EC9, 0x7F },
		{ 0x6EE8, 0xF7 }, { 0x6EE9, 0x77 }, { 0x6EEB, 0xF7 }, { 0x6EEC, 0x7F },
		{ 0x6F04, 0x04 }, { 0x6F0C, 0x7F }, { 0x6F0E, 0x7F }, { 0x6F18, 0xDF },
		{ 0x6F1F, 0x7F }, { 0x6F2B, 0xFB }, { 0x6F2E, 0xFD }, { 0x6F3C, 0xF7 },
		{ 0x6F3F, 0x7F }, { 0x6F4D, 0xFB }, { 0x6F59, 0x77 }, { 0x6F5E, 0x7F },
		{ 0x6F6B, 0xFB }, { 0x6F6E, 0x9F }, { 0x6F9F, 0x7F }, { 0x6FAD, 0xB7 },
		{ 0x6FBF, 0xF7 }, { 0x6FC8, 0xDF }, { 0x6FCD, 0x3F }, { 0x6FCE, 0xBB },
		{ 0x6FDC, 0x7F }, { 0x6FDD, 0xDF }, { 0x6FEF, 0xF7 }, { 0x6FFB, 0xFB },
		{ 0x6FFD, 0x77 }, { 0x701E, 0x10 }, { 0x7047, 0x7F }, { 0x7076, 0xF7 },
		{ 0x707C, 0x10 }, { 0x70D5, 0xFD }, { 0x70F4, 0xDF }, { 0x710C, 0x04 },
		{ 0x711A, 0x01 }, { 0x714E, 0x06 }, { 0x716F, 0x01 }, { 0x71A3, 0xDF },
		{ 0x71B0, 0xFD }, { 0x71DE, 0x10 }, { 0x7206, 0xBF }, { 0x720C, 0x40 },
		{ 0x7223, 0xFB }, { 0x726C, 0x04 }, { 0x7272, 0xF7 }, { 0x72A5, 0xBF },
		{ 0x72C0, 0xF7 }, { 0x72DE, 0x01 }, { 0x72F8, 0x04 }, { 0x7302, 0xDF },
		{ 0x7313, 0x7F }, { 0x7332, 0xF7 }, { 0x7372, 0xF7 }, { 0x73EB, 0x40 },
		{ 0x7410, 0xDF }, { 0x7423, 0xF7 }, { 0x7432, 0xF7 }, { 0x7433, 0xF7 },
		{ 0x744A, 0x01 }, { 0x748B, 0x01 }, { 0x7490, 0xF7 }, { 0x749A, 0x01 },
		{ 0x7526, 0xFB }, { 0x7536, 0x7F }, { 0x7540, 0x7F }, { 0x7557, 0x7F },
		{ 0x757F, 0x04 }, { 0x7584, 0x7F }, { 0x75B8, 0x01 }, { 0x75C2, 0xF7 },
		{ 0x75C6, 0x7F }, { 0x75D5, 0xB7 }, { 0x75F8, 0x01 }, { 0x7607, 0xDF },
		{ 0x764F, 0x02 }, { 0x7694, 0x7F }, { 0x7697, 0xFD }, { 0x76CC, 0x10 },
		{ 0x76D0, 0xF7 }, { 0x76E0, 0xF7 }, { 0x7702, 0xF7 }, { 0x7721, 0x7F },
		{ 0x7752, 0xFB }, { 0x77B6, 0xFB }, { 0x77B8, 0x01 }, { 0x77C2, 0xF7 },
		{ 0x77D2, 0xF7 }, { 0x77D3, 0x7F }, { 0x77E3, 0xFD }, { 0x780B, 0x7F },
		{ 0x780F, 0x3F }, { 0x7818, 0xF7 }, { 0x7834, 0x01 }, { 0x784C, 0x7F },
		{ 0x784F, 0x5F }, { 0x785B, 0x7F }, { 0x7878, 0x7F }, { 0x7888, 0x7F },
		{ 0x7889, 0xFB }, { 0x788A, 0xFB }, { 0x788B, 0xF7 }, { 0x78B9, 0x7F },
		{ 0x78CB, 0xDF }, { 0x78CD, 0x7F }, { 0x78DA, 0xF7 }, { 0x78EA, 0xF7 },
		{ 0x78FB, 0xFB }, { 0x790B, 0x7F }, { 0x790C, 0xF7 }, { 0x790D, 0xDF },
		{ 0x790E, 0xFB }, { 0x790F, 0xFD }, { 0x791A, 0x7F }, { 0x791D, 0xBF },
		{ 0x793B, 0xF7 }, { 0x793F, 0x7F }, { 0x7949, 0xFD }, { 0x794F, 0xFB },
		{ 0x795C, 0x7F }, { 0x7960, 0x01 }, { 0x7968, 0xBF }, { 0x7969, 0xFD },
		{ 0x7978, 0x7F }, { 0x797D, 0xF7 }, { 0x798D, 0xFE }, { 0x798E, 0xBF },
		{ 0x79A9, 0x7F }, { 0x79AD, 0xF7 }, { 0x79BB, 0xFD }, { 0x79C8, 0xF7 },
		{ 0x79C9, 0x7F }, { 0x79DB, 0x7F }, { 0x79DE, 0x7F }, { 0x79E9, 0xFB },
		{ 0x79F8, 0xB7 }, { 0x79FB, 0xBF }, { 0x79FF, 0xBF }, { 0x7A0C, 0xF3 },
		{ 0x7A0F, 0xDD }, { 0x7A18, 0x7F }, { 0x7A38, 0x7F }, { 0x7A39, 0x7F },
		{ 0x7A49, 0xBF }, { 0x7A4B, 0x77 }, { 0x7A4C, 0x7F }, { 0x7A51, 0x40 },
		{ 0x7A6D, 0xFD }, { 0x7A6F, 0x7F }, { 0x7A8E, 0x7F }, { 0x7AAF, 0xDF },
		{ 0x7ABB, 0x7F }, { 0x7ACE, 0xBF }, { 0x7ADC, 0xDF }, { 0x7ADF, 0xB7 },
		{ 0x7AEE, 0xF7 }, { 0x7AEF, 0xFB }, { 0x7AF8, 0xF7 }, { 0x7AFB, 0x7F },
		{ 0x7AFE, 0xFB }, { 0x7B0F, 0xDF }, { 0x7B19, 0xFD }, { 0x7B1F, 0xFD },
		{ 0x7B29, 0xF5 }, { 0x7B2D, 0x7F }, { 0x7B2F, 0xF7 }, { 0x7B38, 0x7F },
		{ 0x7B3C, 0xFB }, { 0x7B3D, 0xFD }, { 0x7B4A, 0xF7 }, { 0x7B4B, 0xF7 },
		{ 0x7B5A, 0x7F }, { 0x7B5E, 0x7F }, { 0x7B5F, 0xBF }, { 0x7B6D, 0xBF },
		{ 0x7B6F, 0x33 }, { 0x7B7A, 0xF7 }, { 0x7B7B, 0xFB }, { 0x7B7F, 0x7F },
		{ 0x7B8E, 0x7F }, { 0x7B95, 0x04 }, { 0x7B99, 0xF7 }, { 0x7BA9, 0x7F },
		{ 0x7BB8, 0x7F }, { 0x7BB9, 0xFD }, { 0x7BCE, 0x7F }, { 0x7BCF, 0x7F },
		{ 0x7BD8, 0xD7 }, { 0x7BDA, 0x7F }, { 0x7BDC, 0x7F }, { 0x7BDE, 0xF7 },
		{ 0x7BE9, 0xFB }, { 0x7BF8, 0x9F }, { 0x7BFA, 0xBF }, { 0x7BFB, 0xDF },
		{ 0x7BFE, 0xF7 }, { 0x7BFF, 0x77 }, { 0x7C08, 0x7F }, { 0x7C0A, 0xDF },
		{ 0x7C1A, 0x7F }, { 0x7C1C, 0xF7 }, { 0x7C2E, 0x7F }, { 0x7C2F, 0x7F },
		{ 0x7C3E, 0xF7 }, { 0x7C48, 0xF7 }, { 0x7C59, 0x7F }, { 0x7C5C, 0xF7 },
		{ 0x7C7B, 0xF7 }, { 0x7C7F, 0xFB }, { 0x7CB9, 0xDF }, { 0x7CBF, 0x7F },
		{ 0x7CD9, 0x7F }, { 0x7CDA, 0x7F }, { 0x7CDD, 0x7F }, { 0x7CFD, 0xDF },
		{ 0x7D08, 0xFD }, { 0x7D1D, 0xF7 }, { 0x7D2D, 0xD7 }, { 0x7D2F, 0x7F },
		{ 0x7D3B, 0xBF }, { 0x7D4A, 0xDF }, { 0x7D4D, 0xF7 }, { 0x7D4E, 0x7F },
		{ 0x7D5A, 0x7F }, { 0x7D5B, 0xDF }, { 0x7D5F, 0xDF }, { 0x7D6A, 0xBF },
		{ 0x7D6C, 0xFB }, { 0x7D6E, 0xF9 }, { 0x7D78, 0xF7 }, { 0x7D7D, 0xDF },
		{ 0x7D7E, 0x7F }, { 0x7D8D, 0xF7 }, { 0x7D8E, 0xF7 }, { 0x7D8F, 0x5F },
		{ 0x7D98, 0x77 }, { 0x7D9A, 0xF7 }, { 0x7D9D, 0xDF }, { 0x7D9E, 0xFB },
		{ 0x7DB8, 0xF7 }, { 0x7DB9, 0xF7 }, { 0x7DBB, 0xDF }, { 0x7DBC, 0xDF },
		{ 0x7DBF, 0xDF }, { 0x7DCC, 0xBF }, { 0x7DD9, 0xF7 }, { 0x7DEA, 0xDF },
		{ 0x7DEC, 0xFD }, { 0x7DEE, 0xDD }, { 0x7DF9, 0xF7 }, { 0x7DFD, 0x7F },
		{ 0x7E02, 0xFD }, { 0x7E0B, 0xFD }, { 0x7E18, 0xF7 }, { 0x7E1B, 0xFB },
		{ 0x7E1D, 0x7F }, { 0x7E48, 0xFB }, { 0x7E4A, 0x01 }, { 0x7E6C, 0xDF },
		{ 0x7E6F, 0xF7 }, { 0x7E8E, 0xFD }, { 0x7EDD, 0x7F }, { 0x7EEA, 0x20 },
		{ 0x7EEB, 0xBF }, { 0x7EEF, 0xEF }, { 0x7EFD, 0x77 }, { 0x7EFE, 0x7F },
		{ 0x7EFF, 0xDF }, { 0x7F28, 0xF7 }, { 0x7F2C, 0xF7 }, { 0x7F2E, 0x7B },
		{ 0x7F2F, 0xF7 }, { 0x7F36, 0x10 }, { 0x7F3D, 0xFD }, { 0x7F49, 0x7F },
		{ 0x7F58, 0x7B }, { 0x7F5E, 0xDF }, { 0x7F68, 0xF7 }, { 0x7F6C, 0xF7 },
		{ 0x7F7B, 0xF9 }, { 0x7F7E, 0xDF }, { 0x7F8D, 0xDF }, { 0x7F92, 0xF7 },
		{ 0x7F98, 0xF7 }, { 0x7F9C, 0x7F }, { 0x7FA9, 0xB9 }, { 0x7FAB, 0x7B },
		{ 0x7FBC, 0x7F }, { 0x7FBF, 0xF7 }, { 0x7FC9, 0x7F }, { 0x7FCB, 0x7F },
		{ 0x7FCD, 0xBF }, { 0x7FCE, 0x7F }, { 0x7FCF, 0xFB }, { 0x7FDB, 0xF7 },
		{ 0x7FDF, 0x7F }, { 0x7FE8, 0xDF }, { 0x7FEC, 0xFB }, { 0x7FF2, 0xF7 }
	};

	for (unsigned addr = 0x0000; addr < 0x0800; addr += 0x10) {
		std::memset(wram + addr + 0x00, 0xFF, 0x08);
		std::memset(wram + addr + 0x08, 0x00, 0x08);
	}

	for (unsigned addr = 0x0800; addr < 0x1000; addr += 0x10) {
		std::memset(wram + addr + 0x00, 0x00, 0x08);
		std::memset(wram + addr + 0x08, 0xFF, 0x08);
	}

	for (unsigned addr = 0x0E00; addr < 0x1000; addr += 0x10) {
		wram[addr + 0x02] = 0xFF;
		wram[addr + 0x0A] = 0x00;
	}

	for (unsigned addr = 0x1000; addr < 0x8000; addr += 0x1000) {
		if (0x2000 != addr)
			std::memcpy(wram + addr, wram, 0x1000);
	}

	std::memset(wram + 0x2000, 0, 0x1000);

	for (std::size_t i = 0; i < sizeof cgbWramDumpDiff / sizeof cgbWramDumpDiff[0]; ++i)
		wram[cgbWramDumpDiff[i].addr] = cgbWramDumpDiff[i].val;
}

static void setInitialDmgWram(unsigned char wram[]) {
	static struct { unsigned short addr; unsigned char val; } const dmgWramDumpDiff[] = {
		{ 0x0000, 0x08 }, { 0x0004, 0x08 }, { 0x0008, 0x4D }, { 0x000A, 0x80 },
		{ 0x0010, 0x02 }, { 0x0018, 0x04 }, { 0x0020, 0x10 }, { 0x0028, 0x05 },
		{ 0x002C, 0x08 }, { 0x0038, 0x21 }, { 0x003A, 0x40 }, { 0x0060, 0x02 },
		{ 0x0066, 0x03 }, { 0x0068, 0x40 }, { 0x0072, 0x80 }, { 0x0074, 0x40 },
		{ 0x0076, 0x80 }, { 0x007C, 0x80 }, { 0x007E, 0x20 }, { 0x0080, 0x0C },
		{ 0x0088, 0x08 }, { 0x008C, 0x02 }, { 0x008E, 0x04 }, { 0x0092, 0x01 },
		{ 0x0098, 0x02 }, { 0x00A2, 0x08 }, { 0x00A8, 0x02 }, { 0x00AC, 0x15 },
		{ 0x00B0, 0x02 }, { 0x00B2, 0x80 }, { 0x00B6, 0x80 }, { 0x00B8, 0x06 },
		{ 0x00BA, 0x01 }, { 0x00BC, 0x08 }, { 0x00C4, 0x04 }, { 0x00C8, 0x02 },
		{ 0x00CC, 0x01 }, { 0x00D0, 0x85 }, { 0x00D8, 0x81 }, { 0x00DC, 0x01 },
		{ 0x00DE, 0x01 }, { 0x00E0, 0x01 }, { 0x00E6, 0x08 }, { 0x00E8, 0x44 },
		{ 0x00EC, 0x44 }, { 0x00F0, 0x40 }, { 0x00F4, 0x20 }, { 0x00FA, 0x04 },
		{ 0x00FC, 0x12 }, { 0x00FE, 0x01 }, { 0x0103, 0x7F }, { 0x0107, 0xFD },
		{ 0x0113, 0xFB }, { 0x0119, 0xBF }, { 0x011B, 0xEF }, { 0x011D, 0xFB },
		{ 0x0121, 0xFB }, { 0x0133, 0xF7 }, { 0x0135, 0x6F }, { 0x0137, 0xBD },
		{ 0x013F, 0xF6 }, { 0x0145, 0xF7 }, { 0x0149, 0xDF }, { 0x014D, 0xFA },
		{ 0x014F, 0xFE }, { 0x0151, 0xFD }, { 0x0161, 0xFD }, { 0x0165, 0xBF },
		{ 0x0171, 0xFD }, { 0x0173, 0xEF }, { 0x0177, 0xFE }, { 0x0179, 0x7F },
		{ 0x0185, 0xF7 }, { 0x0189, 0xEF }, { 0x0199, 0xF7 }, { 0x01AB, 0xEF },
		{ 0x01B1, 0x7F }, { 0x01B3, 0xEF }, { 0x01B5, 0xBF }, { 0x01C1, 0xFB },
		{ 0x01C9, 0xFB }, { 0x01CB, 0xEF }, { 0x01CF, 0xBF }, { 0x01D5, 0x7F },
		{ 0x01E1, 0xDD }, { 0x01E7, 0xF7 }, { 0x01F5, 0xFE }, { 0x0218, 0x01 },
		{ 0x0220, 0x08 }, { 0x0226, 0x08 }, { 0x022C, 0x20 }, { 0x0230, 0x50 },
		{ 0x0238, 0x01 }, { 0x0246, 0x02 }, { 0x0256, 0x10 }, { 0x0258, 0x40 },
		{ 0x0260, 0x70 }, { 0x0264, 0x04 }, { 0x0268, 0x28 }, { 0x0278, 0x02 },
		{ 0x0284, 0x10 }, { 0x0298, 0x20 }, { 0x029A, 0x10 }, { 0x02A0, 0x44 },
		{ 0x02AE, 0x20 }, { 0x02B2, 0x20 }, { 0x02C0, 0x28 }, { 0x02CA, 0x64 },
		{ 0x02D0, 0x20 }, { 0x02E0, 0x80 }, { 0x02E8, 0x02 }, { 0x02EA, 0x02 },
		{ 0x02EE, 0x08 }, { 0x02F0, 0x0C }, { 0x02F2, 0x02 }, { 0x0305, 0xDF },
		{ 0x0307, 0xFE }, { 0x0309, 0xFD }, { 0x030F, 0xBF }, { 0x0311, 0xFB },
		{ 0x0325, 0xDF }, { 0x0329, 0xFD }, { 0x0335, 0xFD }, { 0x033B, 0xF7 },
		{ 0x0345, 0xFB }, { 0x0347, 0xFD }, { 0x034B, 0xEF }, { 0x0353, 0xF9 },
		{ 0x035B, 0xBF }, { 0x035D, 0xBF }, { 0x0361, 0xF5 }, { 0x0369, 0xBF },
		{ 0x0375, 0xFD }, { 0x0381, 0xEF }, { 0x0383, 0xDF }, { 0x038D, 0xF7 },
		{ 0x0391, 0xF7 }, { 0x039B, 0xFE }, { 0x03A9, 0xDF }, { 0x03B3, 0xFB },
		{ 0x03C1, 0xFE }, { 0x03CD, 0xFB }, { 0x03DB, 0xFB }, { 0x03DD, 0x7F },
		{ 0x03E1, 0x7F }, { 0x03ED, 0xFD }, { 0x03F3, 0xFD }, { 0x03FD, 0xFB },
		{ 0x0406, 0x20 }, { 0x040E, 0x04 }, { 0x0412, 0x05 }, { 0x041C, 0x08 },
		{ 0x0420, 0x10 }, { 0x0422, 0x40 }, { 0x0428, 0x40 }, { 0x042A, 0x08 },
		{ 0x0430, 0x32 }, { 0x0434, 0x02 }, { 0x0438, 0x80 }, { 0x043A, 0x01 },
		{ 0x044A, 0x02 }, { 0x0452, 0x50 }, { 0x0458, 0x01 }, { 0x0470, 0x14 },
		{ 0x0478, 0xA0 }, { 0x047A, 0x01 }, { 0x048E, 0x01 }, { 0x0490, 0x04 },
		{ 0x0492, 0x10 }, { 0x0496, 0x50 }, { 0x0498, 0x02 }, { 0x049E, 0x0C },
		{ 0x04A2, 0x40 }, { 0x04A6, 0x01 }, { 0x04A8, 0xC0 }, { 0x04B0, 0x02 },
		{ 0x04BE, 0x20 }, { 0x04C2, 0x01 }, { 0x04C8, 0x01 }, { 0x04CC, 0x01 },
		{ 0x04D0, 0x01 }, { 0x04D2, 0x20 }, { 0x04DE, 0x01 }, { 0x04E0, 0x0C },
		{ 0x04E2, 0x18 }, { 0x04EA, 0x08 }, { 0x04EE, 0x01 }, { 0x04F2, 0x90 },
		{ 0x04F8, 0x20 }, { 0x04FA, 0x81 }, { 0x04FC, 0x40 }, { 0x0505, 0xF7 },
		{ 0x0509, 0xFE }, { 0x0511, 0xCD }, { 0x0517, 0xF3 }, { 0x0525, 0xF7 },
		{ 0x052B, 0xF7 }, { 0x052D, 0x7F }, { 0x052F, 0xBF }, { 0x0531, 0xEF },
		{ 0x0533, 0xBF }, { 0x0545, 0xFB }, { 0x055D, 0xF7 }, { 0x0583, 0xFE },
		{ 0x0593, 0xFE }, { 0x05AB, 0xEF }, { 0x05B1, 0xDF }, { 0x05BD, 0x6F },
		{ 0x05CB, 0xBF }, { 0x05CD, 0xFB }, { 0x05CF, 0xFB }, { 0x05D3, 0xFB },
		{ 0x05FB, 0xD5 }, { 0x05FD, 0xF7 }, { 0x0600, 0x82 }, { 0x0606, 0x04 },
		{ 0x0618, 0x28 }, { 0x0630, 0x40 }, { 0x0638, 0x08 }, { 0x0640, 0x20 },
		{ 0x0654, 0x40 }, { 0x0658, 0x22 }, { 0x065C, 0x84 }, { 0x0664, 0x06 },
		{ 0x066E, 0x10 }, { 0x0672, 0x01 }, { 0x0678, 0x04 }, { 0x0680, 0x10 },
		{ 0x0686, 0x80 }, { 0x068A, 0x42 }, { 0x0690, 0x12 }, { 0x06A8, 0x11 },
		{ 0x06B0, 0x40 }, { 0x06CE, 0x08 }, { 0x06D8, 0x10 }, { 0x06DC, 0x81 },
		{ 0x06E2, 0x06 }, { 0x06F0, 0x04 }, { 0x0713, 0xF9 }, { 0x0715, 0xBF },
		{ 0x071B, 0xDF }, { 0x071D, 0xFD }, { 0x0725, 0xFD }, { 0x0745, 0xEF },
		{ 0x0749, 0xFA }, { 0x0753, 0xBF }, { 0x075B, 0xBF }, { 0x075F, 0xFD },
		{ 0x0763, 0xDF }, { 0x0771, 0xDF }, { 0x078F, 0xF7 }, { 0x0799, 0xFD },
		{ 0x07A5, 0xEF }, { 0x07D3, 0x7F }, { 0x07DD, 0xBF }, { 0x07E3, 0xFD },
		{ 0x07E5, 0xF6 }, { 0x07EB, 0xFD }, { 0x07FB, 0xBF }, { 0x0803, 0xBF },
		{ 0x080F, 0xED }, { 0x0811, 0xBF }, { 0x0813, 0xF7 }, { 0x081B, 0x7F },
		{ 0x0827, 0xFA }, { 0x0829, 0x7F }, { 0x082F, 0xEF }, { 0x0833, 0xEF },
		{ 0x083F, 0xEF }, { 0x0841, 0xDF }, { 0x0843, 0xFE }, { 0x084D, 0xFB },
		{ 0x0877, 0xBF }, { 0x087F, 0xFB }, { 0x088D, 0xFE }, { 0x088F, 0x7F },
		{ 0x089F, 0xEF }, { 0x08A5, 0xBF }, { 0x08A9, 0xEF }, { 0x08AB, 0xFD },
		{ 0x08B1, 0xEF }, { 0x08B5, 0xEF }, { 0x08BF, 0xDF }, { 0x08C7, 0xDF },
		{ 0x08CF, 0xFB }, { 0x08DD, 0xFE }, { 0x08DF, 0xF7 }, { 0x08E3, 0x5A },
		{ 0x08E7, 0xBF }, { 0x08EB, 0xFB }, { 0x08ED, 0xF9 }, { 0x08EF, 0xFB },
		{ 0x08F7, 0x9F }, { 0x08FF, 0xDF }, { 0x0914, 0x94 }, { 0x0916, 0x11 },
		{ 0x0918, 0x21 }, { 0x091C, 0x01 }, { 0x0922, 0x40 }, { 0x0926, 0x08 },
		{ 0x092C, 0x04 }, { 0x0934, 0x10 }, { 0x0938, 0x02 }, { 0x093A, 0x08 },
		{ 0x096A, 0x02 }, { 0x0986, 0x10 }, { 0x0988, 0x20 }, { 0x09A2, 0x03 },
		{ 0x09AA, 0x02 }, { 0x09B2, 0x08 }, { 0x09B8, 0x08 }, { 0x09BE, 0x10 },
		{ 0x09C2, 0x02 }, { 0x09CA, 0x40 }, { 0x09D4, 0x40 }, { 0x09E2, 0x01 },
		{ 0x09E8, 0x10 }, { 0x09EC, 0x40 }, { 0x0A01, 0xEF }, { 0x0A07, 0x6F },
		{ 0x0A17, 0xD7 }, { 0x0A27, 0xFE }, { 0x0A2D, 0xFB }, { 0x0A2F, 0xBF },
		{ 0x0A33, 0xEF }, { 0x0A37, 0xFE }, { 0x0A5F, 0xFA }, { 0x0A67, 0xFB },
		{ 0x0A8D, 0xDF }, { 0x0A8F, 0xFD }, { 0x0A91, 0xEF }, { 0x0A97, 0xFD },
		{ 0x0A9F, 0xFC }, { 0x0AA7, 0xEF }, { 0x0AAD, 0xEF }, { 0x0AB1, 0xBF },
		{ 0x0ABF, 0x7F }, { 0x0AD9, 0xDF }, { 0x0AF7, 0xFE }, { 0x0AFF, 0xBE },
		{ 0x0B14, 0x10 }, { 0x0B24, 0x08 }, { 0x0B2C, 0x02 }, { 0x0B44, 0x08 },
		{ 0x0B46, 0x01 }, { 0x0B4E, 0x80 }, { 0x0B52, 0x10 }, { 0x0B54, 0x80 },
		{ 0x0B6A, 0x04 }, { 0x0B72, 0x08 }, { 0x0B88, 0x20 }, { 0x0BB6, 0x20 },
		{ 0x0BC2, 0x04 }, { 0x0BCE, 0x10 }, { 0x0BD8, 0x08 }, { 0x0BEC, 0x40 },
		{ 0x0C0F, 0xFE }, { 0x0C11, 0xBF }, { 0x0C17, 0xB7 }, { 0x0C19, 0x7F },
		{ 0x0C23, 0xFB }, { 0x0C27, 0xFE }, { 0x0C2D, 0xDF }, { 0x0C2F, 0xBB },
		{ 0x0C37, 0xEF }, { 0x0C3F, 0xBD }, { 0x0C49, 0xFD }, { 0x0C4F, 0xF7 },
		{ 0x0C5F, 0xBF }, { 0x0C61, 0xDF }, { 0x0C67, 0x37 }, { 0x0C6B, 0xDF },
		{ 0x0C73, 0xF7 }, { 0x0C7D, 0x7F }, { 0x0C87, 0xDC }, { 0x0C89, 0xDF },
		{ 0x0C8B, 0xFD }, { 0x0C91, 0xEF }, { 0x0CA3, 0xFB }, { 0x0CA5, 0xFB },
		{ 0x0CB7, 0xF6 }, { 0x0CBF, 0x3F }, { 0x0CC5, 0xFB }, { 0x0CC7, 0x7F },
		{ 0x0CD1, 0x7F }, { 0x0CD5, 0x7F }, { 0x0CD7, 0xEF }, { 0x0CD9, 0x7F },
		{ 0x0CE5, 0xBF }, { 0x0CF5, 0x7F }, { 0x0CFB, 0x7F }, { 0x0CFF, 0xFE },
		{ 0x0D02, 0x01 }, { 0x0D0A, 0x11 }, { 0x0D0C, 0x80 }, { 0x0D0E, 0x08 },
		{ 0x0D12, 0x40 }, { 0x0D16, 0x0B }, { 0x0D1E, 0x08 }, { 0x0D22, 0x01 },
		{ 0x0D26, 0x04 }, { 0x0D28, 0x04 }, { 0x0D2A, 0x01 }, { 0x0D2E, 0x02 },
		{ 0x0D32, 0x10 }, { 0x0D44, 0x11 }, { 0x0D4E, 0x04 }, { 0x0D52, 0x80 },
		{ 0x0D5A, 0x40 }, { 0x0D5E, 0x04 }, { 0x0D72, 0x01 }, { 0x0D76, 0x02 },
		{ 0x0D7A, 0x04 }, { 0x0D7C, 0x80 }, { 0x0D82, 0x80 }, { 0x0D84, 0x04 },
		{ 0x0D90, 0x04 }, { 0x0DA0, 0x01 }, { 0x0DA4, 0x02 }, { 0x0DB0, 0x04 },
		{ 0x0DB4, 0x04 }, { 0x0DB6, 0x10 }, { 0x0DBC, 0x08 }, { 0x0DC2, 0x08 },
		{ 0x0DD0, 0x28 }, { 0x0DD2, 0x10 }, { 0x0DD6, 0x10 }, { 0x0DE2, 0x08 },
		{ 0x0E17, 0xFE }, { 0x0E19, 0xDF }, { 0x0E2B, 0xEF }, { 0x0E2F, 0xFD },
		{ 0x0E37, 0xF3 }, { 0x0E39, 0xDF }, { 0x0E3F, 0xDF }, { 0x0E4F, 0xFE },
		{ 0x0E53, 0xFB }, { 0x0E5B, 0xEF }, { 0x0E5D, 0xF7 }, { 0x0E5F, 0xFD },
		{ 0x0E71, 0xFB }, { 0x0E77, 0xFD }, { 0x0E7B, 0xFB }, { 0x0E7F, 0xFD },
		{ 0x0E85, 0x7F }, { 0x0E8B, 0xFD }, { 0x0E9B, 0x7B }, { 0x0EA7, 0xFE },
		{ 0x0EBB, 0xFB }, { 0x0ED7, 0x77 }, { 0x0EE1, 0xDF }, { 0x0EE3, 0xF7 },
		{ 0x0EEF, 0xFE }, { 0x0EFB, 0xFE }, { 0x0EFF, 0xF7 }, { 0x0F02, 0x10 },
		{ 0x0F06, 0x20 }, { 0x0F0A, 0x02 }, { 0x0F1C, 0x10 }, { 0x0F32, 0x08 },
		{ 0x0F54, 0x10 }, { 0x0F84, 0x10 }, { 0x0F92, 0x40 }, { 0x0FA6, 0x08 },
		{ 0x0FAA, 0x02 }, { 0x0FB6, 0x40 }, { 0x0FCE, 0x0A }, { 0x0FD2, 0x10 },
		{ 0x0FD4, 0x10 }, { 0x0FE0, 0x04 }, { 0x0FF0, 0x04 }, { 0x1000, 0x80 },
		{ 0x1004, 0x08 }, { 0x1008, 0x09 }, { 0x1010, 0x02 }, { 0x1012, 0x20 },
		{ 0x1020, 0x05 }, { 0x1024, 0x01 }, { 0x1026, 0x10 }, { 0x102A, 0x02 },
		{ 0x1032, 0x40 }, { 0x1034, 0x08 }, { 0x1036, 0x03 }, { 0x1038, 0x01 },
		{ 0x103E, 0x40 }, { 0x1040, 0x40 }, { 0x1042, 0x12 }, { 0x1046, 0x02 },
		{ 0x1050, 0x22 }, { 0x1056, 0x80 }, { 0x1058, 0x10 }, { 0x105E, 0x40 },
		{ 0x1066, 0x04 }, { 0x1068, 0x02 }, { 0x106C, 0x60 }, { 0x1070, 0x80 },
		{ 0x1076, 0x40 }, { 0x1078, 0x66 }, { 0x107C, 0x02 }, { 0x1080, 0x40 },
		{ 0x1088, 0x01 }, { 0x108A, 0x80 }, { 0x108E, 0x10 }, { 0x1090, 0x31 },
		{ 0x1092, 0x20 }, { 0x1098, 0x11 }, { 0x109A, 0x80 }, { 0x10A0, 0x05 },
		{ 0x10A4, 0x01 }, { 0x10A6, 0x81 }, { 0x10A8, 0x01 }, { 0x10AA, 0x01 },
		{ 0x10B0, 0x40 }, { 0x10B4, 0x40 }, { 0x10B6, 0x20 }, { 0x10B8, 0x03 },
		{ 0x10BC, 0x88 }, { 0x10BE, 0x02 }, { 0x10C0, 0x30 }, { 0x10C4, 0x42 },
		{ 0x10C6, 0x10 }, { 0x10C8, 0x01 }, { 0x10D4, 0x40 }, { 0x10D8, 0x80 },
		{ 0x10DE, 0x10 }, { 0x10E0, 0x10 }, { 0x10E2, 0x10 }, { 0x10E4, 0x01 },
		{ 0x10E8, 0x26 }, { 0x10EE, 0x10 }, { 0x10F0, 0x80 }, { 0x10F6, 0x40 },
		{ 0x10F8, 0x01 }, { 0x10FA, 0x20 }, { 0x10FC, 0x04 }, { 0x10FE, 0x80 },
		{ 0x1101, 0xFD }, { 0x1113, 0x7F }, { 0x1115, 0xEF }, { 0x1117, 0xFB },
		{ 0x1121, 0x7F }, { 0x1139, 0xF7 }, { 0x1141, 0xFD }, { 0x1153, 0xFD },
		{ 0x1159, 0xF5 }, { 0x115F, 0x7F }, { 0x116D, 0xF7 }, { 0x1171, 0x7E },
		{ 0x1179, 0xDF }, { 0x117B, 0xFB }, { 0x117F, 0xDF }, { 0x1189, 0x7F },
		{ 0x1195, 0xDF }, { 0x119D, 0xDF }, { 0x119F, 0xD7 }, { 0x11A7, 0xF9 },
		{ 0x11AB, 0xAF }, { 0x11AD, 0xBF }, { 0x11B9, 0xDF }, { 0x11BB, 0xBF },
		{ 0x11C5, 0xF9 }, { 0x11CF, 0x7F }, { 0x11D5, 0x7F }, { 0x11DF, 0xEF },
		{ 0x11E1, 0xFE }, { 0x11E7, 0xDF }, { 0x11E9, 0xF7 }, { 0x11ED, 0xFB },
		{ 0x1208, 0x01 }, { 0x1218, 0x16 }, { 0x1230, 0x04 }, { 0x1242, 0x0C },
		{ 0x1246, 0x80 }, { 0x1260, 0x01 }, { 0x1276, 0x10 }, { 0x1278, 0x10 },
		{ 0x1280, 0x04 }, { 0x1284, 0x44 }, { 0x1286, 0x01 }, { 0x128A, 0x02 },
		{ 0x1290, 0x80 }, { 0x12A0, 0x02 }, { 0x12A8, 0x50 }, { 0x12B0, 0x08 },
		{ 0x12B2, 0x40 }, { 0x12B4, 0x10 }, { 0x12B6, 0x02 }, { 0x12B8, 0x04 },
		{ 0x12C0, 0x04 }, { 0x12CC, 0x20 }, { 0x12D0, 0x42 }, { 0x12D8, 0x10 },
		{ 0x12DA, 0x10 }, { 0x12E4, 0x08 }, { 0x12F0, 0x40 }, { 0x12F2, 0x40 },
		{ 0x12F8, 0x42 }, { 0x12FC, 0x80 }, { 0x12FE, 0x40 }, { 0x1301, 0xFD },
		{ 0x1307, 0x7F }, { 0x1309, 0x3F }, { 0x1325, 0xDF }, { 0x132F, 0xFB },
		{ 0x134D, 0x7F }, { 0x1351, 0xDB }, { 0x1353, 0xE7 }, { 0x1357, 0xEF },
		{ 0x1363, 0xF7 }, { 0x136D, 0xF7 }, { 0x136F, 0xF7 }, { 0x1389, 0x7F },
		{ 0x138B, 0xFE }, { 0x138D, 0x7F }, { 0x139B, 0xEB }, { 0x13A1, 0xEF },
		{ 0x13BB, 0xEF }, { 0x13C7, 0x7F }, { 0x13D5, 0xF7 }, { 0x13EB, 0xFD },
		{ 0x13F5, 0xDF }, { 0x13F7, 0xFE }, { 0x1400, 0x11 }, { 0x1408, 0x90 },
		{ 0x140E, 0x20 }, { 0x1414, 0x10 }, { 0x1416, 0x01 }, { 0x1418, 0x10 },
		{ 0x1420, 0x20 }, { 0x1428, 0x0C }, { 0x142C, 0x11 }, { 0x1430, 0x01 },
		{ 0x1434, 0x20 }, { 0x1438, 0x10 }, { 0x143A, 0x02 }, { 0x143E, 0x10 },
		{ 0x1440, 0xA1 }, { 0x144A, 0x20 }, { 0x144C, 0x80 }, { 0x1450, 0x12 },
		{ 0x1452, 0x80 }, { 0x1458, 0x80 }, { 0x145A, 0x41 }, { 0x145C, 0x02 },
		{ 0x1460, 0x12 }, { 0x1466, 0x82 }, { 0x1468, 0x18 }, { 0x1470, 0x08 },
		{ 0x1472, 0x24 }, { 0x147C, 0x20 }, { 0x147E, 0x81 }, { 0x1484, 0x10 },
		{ 0x1488, 0x04 }, { 0x1490, 0x04 }, { 0x1492, 0x08 }, { 0x1498, 0x60 },
		{ 0x149C, 0x02 }, { 0x14A0, 0x80 }, { 0x14A2, 0x51 }, { 0x14A8, 0x04 },
		{ 0x14AC, 0x02 }, { 0x14B0, 0x01 }, { 0x14B8, 0x10 }, { 0x14BA, 0x80 },
		{ 0x14BE, 0x14 }, { 0x14C0, 0x02 }, { 0x14C4, 0x80 }, { 0x14C8, 0x8C },
		{ 0x14CA, 0x0C }, { 0x14D2, 0x80 }, { 0x14D8, 0x08 }, { 0x14DC, 0x80 },
		{ 0x14E8, 0x90 }, { 0x14EA, 0x09 }, { 0x14F0, 0x04 }, { 0x14F4, 0x04 },
		{ 0x14F8, 0x44 }, { 0x14FA, 0x02 }, { 0x14FC, 0x40 }, { 0x14FE, 0x08 },
		{ 0x1505, 0xFE }, { 0x150D, 0xF7 }, { 0x1513, 0xDF }, { 0x151B, 0xEF },
		{ 0x151F, 0xDF }, { 0x1527, 0x7F }, { 0x152B, 0xBB }, { 0x152D, 0xFE },
		{ 0x152F, 0xFD }, { 0x1531, 0xDF }, { 0x1539, 0xBF }, { 0x153B, 0xFE },
		{ 0x1541, 0xDF }, { 0x1547, 0xBF }, { 0x154B, 0x7F }, { 0x156B, 0x7F },
		{ 0x157D, 0xBF }, { 0x1585, 0xFE }, { 0x1587, 0xEF }, { 0x1591, 0xDF },
		{ 0x1593, 0xEF }, { 0x1597, 0xFB }, { 0x1599, 0xF7 }, { 0x159B, 0xBF },
		{ 0x15A3, 0xD5 }, { 0x15A5, 0xBF }, { 0x15B3, 0xEB }, { 0x15B5, 0xFE },
		{ 0x15C3, 0xF7 }, { 0x15C5, 0xEF }, { 0x15C9, 0xFD }, { 0x15D1, 0xFE },
		{ 0x15D7, 0xFE }, { 0x15D9, 0xEF }, { 0x15DD, 0xFB }, { 0x15E1, 0x7B },
		{ 0x15E3, 0xBF }, { 0x15E9, 0xFD }, { 0x15F5, 0x7F }, { 0x15FB, 0xEF },
		{ 0x1600, 0x20 }, { 0x160A, 0x10 }, { 0x161E, 0x04 }, { 0x1620, 0x02 },
		{ 0x1630, 0x04 }, { 0x1636, 0x40 }, { 0x1640, 0x2C }, { 0x1646, 0x20 },
		{ 0x1654, 0x20 }, { 0x1656, 0x18 }, { 0x1658, 0x4A }, { 0x165A, 0x20 },
		{ 0x165C, 0x80 }, { 0x1664, 0x08 }, { 0x1668, 0x02 }, { 0x1670, 0x48 },
		{ 0x167A, 0x20 }, { 0x1680, 0x10 }, { 0x1682, 0x08 }, { 0x1684, 0x40 },
		{ 0x168C, 0x01 }, { 0x1698, 0x21 }, { 0x169E, 0x40 }, { 0x16A0, 0x03 },
		{ 0x16A2, 0x40 }, { 0x16A4, 0x01 }, { 0x16A6, 0x01 }, { 0x16B6, 0x10 },
		{ 0x16B8, 0x80 }, { 0x16BA, 0x02 }, { 0x16BC, 0x01 }, { 0x16D0, 0x04 },
		{ 0x16D2, 0x02 }, { 0x16D8, 0x81 }, { 0x16E8, 0x03 }, { 0x16EE, 0x80 },
		{ 0x16F8, 0xA4 }, { 0x1703, 0xFE }, { 0x172B, 0xEF }, { 0x172D, 0xBF },
		{ 0x173B, 0xDF }, { 0x1745, 0x3D }, { 0x1749, 0xFB }, { 0x174B, 0xDF },
		{ 0x1753, 0xDF }, { 0x1759, 0xFD }, { 0x1763, 0xEF }, { 0x1765, 0xBF },
		{ 0x1775, 0xBF }, { 0x177D, 0xDF }, { 0x1781, 0xFE }, { 0x1789, 0xEF },
		{ 0x178B, 0xFE }, { 0x1791, 0xEF }, { 0x1793, 0xDF }, { 0x1795, 0xEF },
		{ 0x179B, 0xFE }, { 0x17A7, 0xFB }, { 0x17AD, 0xFE }, { 0x17B3, 0xFB },
		{ 0x17B5, 0xFA }, { 0x17B9, 0xFB }, { 0x17C3, 0xFB }, { 0x17DB, 0xFB },
		{ 0x17EB, 0xBF }, { 0x17F3, 0xFB }, { 0x1803, 0xBD }, { 0x1813, 0xBF },
		{ 0x181B, 0x7E }, { 0x1827, 0xFD }, { 0x1833, 0xFE }, { 0x1837, 0xDB },
		{ 0x1839, 0xF7 }, { 0x1845, 0xDF }, { 0x184B, 0xFD }, { 0x1853, 0xDF },
		{ 0x1867, 0xFD }, { 0x186F, 0xF7 }, { 0x1879, 0xDF }, { 0x187D, 0xEF },
		{ 0x1889, 0xFB }, { 0x188F, 0x9F }, { 0x1893, 0xDF }, { 0x1897, 0xFD },
		{ 0x189B, 0x7F }, { 0x18A9, 0xFD }, { 0x18AF, 0xFB }, { 0x18B5, 0xBF },
		{ 0x18B7, 0x2F }, { 0x18BD, 0xFE }, { 0x18BF, 0xFB }, { 0x18CD, 0xBF },
		{ 0x18D3, 0xF5 }, { 0x18D5, 0x7F }, { 0x18D7, 0xFD }, { 0x18E1, 0xFD },
		{ 0x18E3, 0xEF }, { 0x18E5, 0x7F }, { 0x18EB, 0xFE }, { 0x18EF, 0xDF },
		{ 0x18F3, 0xEF }, { 0x18F7, 0xEF }, { 0x18FB, 0x7B }, { 0x18FD, 0xDF },
		{ 0x18FF, 0xDF }, { 0x190A, 0x40 }, { 0x1910, 0x20 }, { 0x1916, 0x04 },
		{ 0x1920, 0x01 }, { 0x1924, 0x02 }, { 0x1926, 0x02 }, { 0x1936, 0x40 },
		{ 0x1946, 0x04 }, { 0x195A, 0x10 }, { 0x195C, 0x40 }, { 0x1968, 0x20 },
		{ 0x197C, 0x08 }, { 0x1988, 0x08 }, { 0x1994, 0x20 }, { 0x1996, 0x20 },
		{ 0x199A, 0x12 }, { 0x19BA, 0x08 }, { 0x19C4, 0x01 }, { 0x19CC, 0x04 },
		{ 0x19D4, 0x04 }, { 0x19DA, 0x80 }, { 0x19DC, 0x40 }, { 0x19E2, 0x02 },
		{ 0x19EE, 0x80 }, { 0x19F4, 0x02 }, { 0x19F6, 0x90 }, { 0x19FC, 0x02 },
		{ 0x19FE, 0x1A }, { 0x1A11, 0xDF }, { 0x1A1F, 0xEE }, { 0x1A25, 0xFB },
		{ 0x1A27, 0xF7 }, { 0x1A2D, 0xF5 }, { 0x1A2F, 0xFA }, { 0x1A3B, 0xEF },
		{ 0x1A3F, 0xFB }, { 0x1A4B, 0xDF }, { 0x1A6F, 0xFB }, { 0x1A77, 0xF7 },
		{ 0x1A81, 0xE7 }, { 0x1A8F, 0xE7 }, { 0x1A93, 0xDF }, { 0x1A9F, 0xDF },
		{ 0x1AAD, 0xEF }, { 0x1AC7, 0xF7 }, { 0x1AD5, 0xFE }, { 0x1ADF, 0xFB },
		{ 0x1AE3, 0xBF }, { 0x1AED, 0xF7 }, { 0x1AF1, 0xFE }, { 0x1AF9, 0xFD },
		{ 0x1B1A, 0x02 }, { 0x1B26, 0x10 }, { 0x1B6C, 0x02 }, { 0x1B84, 0x04 },
		{ 0x1B88, 0x40 }, { 0x1BA0, 0x08 }, { 0x1BAE, 0x08 }, { 0x1BBC, 0x02 },
		{ 0x1BF4, 0x04 }, { 0x1C07, 0xDF }, { 0x1C0B, 0x7F }, { 0x1C0F, 0xDF },
		{ 0x1C13, 0xBF }, { 0x1C1B, 0xFB }, { 0x1C1F, 0xEF }, { 0x1C27, 0xBD },
		{ 0x1C2F, 0x77 }, { 0x1C3D, 0xEF }, { 0x1C3F, 0xF7 }, { 0x1C41, 0xF7 },
		{ 0x1C43, 0xFE }, { 0x1C45, 0xDF }, { 0x1C47, 0xFE }, { 0x1C4F, 0xEF },
		{ 0x1C53, 0xF3 }, { 0x1C5D, 0xDF }, { 0x1C5F, 0xBB }, { 0x1C61, 0xFB },
		{ 0x1C67, 0xFE }, { 0x1C69, 0xFD }, { 0x1C6B, 0xFE }, { 0x1C73, 0xFB },
		{ 0x1C7B, 0xFE }, { 0x1C7D, 0xEF }, { 0x1C83, 0xEF }, { 0x1C87, 0x3F },
		{ 0x1C8B, 0xEF }, { 0x1C8F, 0xD9 }, { 0x1C97, 0xEF }, { 0x1C9B, 0xEF },
		{ 0x1C9F, 0xF7 }, { 0x1CA3, 0xFD }, { 0x1CA7, 0xBF }, { 0x1CA9, 0xF7 },
		{ 0x1CAB, 0xFB }, { 0x1CAD, 0xFD }, { 0x1CB1, 0x7F }, { 0x1CB3, 0xBB },
		{ 0x1CB9, 0xFD }, { 0x1CBB, 0xFB }, { 0x1CC7, 0xF6 }, { 0x1CCF, 0xBF },
		{ 0x1CD3, 0xEB }, { 0x1CE1, 0xBF }, { 0x1CF1, 0xFD }, { 0x1CF5, 0x7F },
		{ 0x1CF7, 0xEF }, { 0x1CFD, 0xDF }, { 0x1CFF, 0xFD }, { 0x1D02, 0x04 },
		{ 0x1D06, 0x40 }, { 0x1D08, 0x92 }, { 0x1D10, 0x04 }, { 0x1D1A, 0x02 },
		{ 0x1D1C, 0x08 }, { 0x1D24, 0x08 }, { 0x1D30, 0x01 }, { 0x1D34, 0x04 },
		{ 0x1D3A, 0x22 }, { 0x1D3E, 0x04 }, { 0x1D56, 0x10 }, { 0x1D5A, 0x02 },
		{ 0x1D7E, 0x40 }, { 0x1D8E, 0x01 }, { 0x1D90, 0x20 }, { 0x1D9A, 0x10 },
		{ 0x1DA0, 0x04 }, { 0x1DA4, 0x02 }, { 0x1DAC, 0x21 }, { 0x1DBE, 0x20 },
		{ 0x1DC2, 0x20 }, { 0x1DD6, 0x40 }, { 0x1DD8, 0x08 }, { 0x1DF2, 0x01 },
		{ 0x1DFE, 0x80 }, { 0x1E01, 0xEF }, { 0x1E05, 0xEF }, { 0x1E1D, 0xDF },
		{ 0x1E27, 0xDD }, { 0x1E2F, 0x7F }, { 0x1E33, 0xF5 }, { 0x1E37, 0xFB },
		{ 0x1E3F, 0xF7 }, { 0x1E4B, 0xDF }, { 0x1E5F, 0x7F }, { 0x1E71, 0xEB },
		{ 0x1E7F, 0xBF }, { 0x1E8F, 0xDF }, { 0x1E97, 0xBF }, { 0x1E9B, 0xEF },
		{ 0x1E9F, 0xF7 }, { 0x1EA7, 0xFD }, { 0x1EB3, 0xFB }, { 0x1EB7, 0x7F },
		{ 0x1EC5, 0x7F }, { 0x1EDF, 0x7F }, { 0x1EE9, 0xF7 }, { 0x1EF3, 0xFD },
		{ 0x1F02, 0x10 }, { 0x1F04, 0x05 }, { 0x1F20, 0x04 }, { 0x1F24, 0x10 },
		{ 0x1F3A, 0x80 }, { 0x1F44, 0x04 }, { 0x1F46, 0x04 }, { 0x1F4E, 0x40 },
		{ 0x1F50, 0x01 }, { 0x1F54, 0x03 }, { 0x1F60, 0x03 }, { 0x1F72, 0x01 },
		{ 0x1F76, 0x04 }, { 0x1F7A, 0x02 }, { 0x1F86, 0x80 }, { 0x1F8C, 0x02 },
		{ 0x1FA2, 0x40 }, { 0x1FB6, 0x80 }, { 0x1FC6, 0x10 }, { 0x1FCC, 0x20 },
		{ 0x1FD2, 0x20 }, { 0x1FD8, 0x04 }, { 0x1FDC, 0x10 }, { 0x1FDE, 0x04 }
	};

	for (unsigned addr = 0x0000; addr < 0x0800; addr += 0x200) {
		std::memset(wram + addr        , 0x00, 0x100);
		std::memset(wram + addr + 0x100, 0xFF, 0x100);
	}

	for (unsigned addr = 0x0800; addr < 0x1000; addr += 0x200) {
		std::memset(wram + addr        , 0xFF, 0x100);
		std::memset(wram + addr + 0x100, 0x00, 0x100);
	}

	std::memcpy(wram + 0x1000, wram, 0x1000);

	for (std::size_t i = 0; i < sizeof dmgWramDumpDiff / sizeof dmgWramDumpDiff[0]; ++i)
		wram[dmgWramDumpDiff[i].addr] = dmgWramDumpDiff[i].val;
}

static void setInitialVram(unsigned char vram[], bool const cgb) {
	static unsigned char const even_numbered_8010_to_81a0_dump[] = {
		0xF0, 0xF0, 0xFC, 0xFC, 0xFC, 0xFC, 0xF3, 0xF3,
		0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
		0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0xF3, 0xF3,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xCF,
		0x00, 0x00, 0x0F, 0x0F, 0x3F, 0x3F, 0x0F, 0x0F,
		0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x0F, 0x0F,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF3, 0xF3,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0,
		0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFF, 0xFF,
		0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC3, 0xC3,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFC,
		0xF3, 0xF3, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0,
		0x3C, 0x3C, 0xFC, 0xFC, 0xFC, 0xFC, 0x3C, 0x3C,
		0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
		0xF3, 0xF3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3,
		0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF,
		0x3C, 0x3C, 0x3F, 0x3F, 0x3C, 0x3C, 0x0F, 0x0F,
		0x3C, 0x3C, 0xFC, 0xFC, 0x00, 0x00, 0xFC, 0xFC,
		0xFC, 0xFC, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0,
		0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF0, 0xF0,
		0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xFF, 0xFF,
		0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xC3, 0xC3,
		0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xFC, 0xFC,
		0x3C, 0x42, 0xB9, 0xA5, 0xB9, 0xA5, 0x42, 0x3C
	};

	std::memset(vram, 0, 0x4000);

	for (std::size_t i = 0; i < sizeof even_numbered_8010_to_81a0_dump; ++i) {
		vram[0x0010 + i * 2] = even_numbered_8010_to_81a0_dump[i];
	}

	if (!cgb) {
		unsigned i = 1;

		for (unsigned addr = 0x1904; addr < 0x1910; ++addr)
			vram[addr] = i++;

		vram[0x1910] = 0x19;

		for (unsigned addr = 0x1924; addr < 0x1930; ++addr)
			vram[addr] = i++;
	}
}

static void setInitialCgbIoamhram(unsigned char ioamhram[]) {
	static unsigned char const feaxDump[0x60] = {
		0x08, 0x01, 0xEF, 0xDE, 0x06, 0x4A, 0xCD, 0xBD,
		0x08, 0x01, 0xEF, 0xDE, 0x06, 0x4A, 0xCD, 0xBD,
		0x08, 0x01, 0xEF, 0xDE, 0x06, 0x4A, 0xCD, 0xBD,
		0x08, 0x01, 0xEF, 0xDE, 0x06, 0x4A, 0xCD, 0xBD,
		0x00, 0x90, 0xF7, 0x7F, 0xC0, 0xB1, 0xBC, 0xFB,
		0x00, 0x90, 0xF7, 0x7F, 0xC0, 0xB1, 0xBC, 0xFB,
		0x00, 0x90, 0xF7, 0x7F, 0xC0, 0xB1, 0xBC, 0xFB,
		0x00, 0x90, 0xF7, 0x7F, 0xC0, 0xB1, 0xBC, 0xFB,
		0x24, 0x13, 0xFD, 0x3A, 0x10, 0x10, 0xAD, 0x45,
		0x24, 0x13, 0xFD, 0x3A, 0x10, 0x10, 0xAD, 0x45,
		0x24, 0x13, 0xFD, 0x3A, 0x10, 0x10, 0xAD, 0x45,
		0x24, 0x13, 0xFD, 0x3A, 0x10, 0x10, 0xAD, 0x45
	};

	static unsigned char const ffxxDump[0x100] = {
		0xCF, 0x00, 0x7C, 0xFF, 0x44, 0x00, 0x00, 0xF8,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1,
		0x80, 0xBF, 0xF3, 0xFF, 0xBF, 0xFF, 0x3F, 0x00,
		0xFF, 0xBF, 0x7F, 0xFF, 0x9F, 0xFF, 0xBF, 0xFF,
		0xFF, 0x00, 0x00, 0xBF, 0x77, 0xF3, 0xF1, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF,
		0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF,
		0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
		0x00, 0x00, 0x00, 0x00, 0xFF, 0x7E, 0xFF, 0xFE,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xC0, 0xFF, 0xC1, 0x00, 0xFE, 0xFF, 0xFF, 0xFF,
		0xF8, 0xFF, 0x00, 0x00, 0x00, 0x8F, 0x00, 0x00,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xCE, 0xED, 0x66, 0x66, 0xCC, 0x0D, 0x00, 0x0B,
		0x03, 0x73, 0x00, 0x83, 0x00, 0x0C, 0x00, 0x0D,
		0x00, 0x08, 0x11, 0x1F, 0x88, 0x89, 0x00, 0x0E,
		0xDC, 0xCC, 0x6E, 0xE6, 0xDD, 0xDD, 0xD9, 0x99,
		0xBB, 0xBB, 0x67, 0x63, 0x6E, 0x0E, 0xEC, 0xCC,
		0xDD, 0xDC, 0x99, 0x9F, 0xBB, 0xB9, 0x33, 0x3E,
		0x45, 0xEC, 0x42, 0xFA, 0x08, 0xB7, 0x07, 0x5D,
		0x01, 0xF5, 0xC0, 0xFF, 0x08, 0xFC, 0x00, 0xE5,
		0x0B, 0xF8, 0xC2, 0xCA, 0xF4, 0xF9, 0x0D, 0x7F,
		0x44, 0x6D, 0x19, 0xFE, 0x46, 0x97, 0x33, 0x5E,
		0x08, 0xFF, 0xD1, 0xFF, 0xC6, 0x8B, 0x24, 0x74,
		0x12, 0xFC, 0x00, 0x9F, 0x94, 0xB7, 0x06, 0xD5,
		0x40, 0x7A, 0x20, 0x9E, 0x04, 0x5F, 0x41, 0x2F,
		0x3D, 0x77, 0x36, 0x75, 0x81, 0x8A, 0x70, 0x3A,
		0x98, 0xD1, 0x71, 0x02, 0x4D, 0x01, 0xC1, 0xFF,
		0x0D, 0x00, 0xD3, 0x05, 0xF9, 0x00, 0x0B, 0x00
	};

	std::memset(ioamhram, 0x00, 0x0A0);
	std::memcpy(ioamhram + 0x0A0, feaxDump, sizeof feaxDump);
	std::memcpy(ioamhram + 0x100, ffxxDump, sizeof ffxxDump);
}

static void setInitialDmgIoamhram(unsigned char ioamhram[]) {
	static unsigned char const oamDump[0xA0] = {
		0xBB, 0xD8, 0xC4, 0x04, 0xCD, 0xAC, 0xA1, 0xC7,
		0x7D, 0x85, 0x15, 0xF0, 0xAD, 0x19, 0x11, 0x6A,
		0xBA, 0xC7, 0x76, 0xF8, 0x5C, 0xA0, 0x67, 0x0A,
		0x7B, 0x75, 0x56, 0x3B, 0x65, 0x5C, 0x4D, 0xA3,
		0x00, 0x05, 0xD7, 0xC9, 0x1B, 0xCA, 0x11, 0x6D,
		0x38, 0xE7, 0x13, 0x2A, 0xB1, 0x10, 0x72, 0x4D,
		0xA7, 0x47, 0x13, 0x89, 0x7C, 0x62, 0x5F, 0x90,
		0x64, 0x2E, 0xD3, 0xEF, 0xAB, 0x01, 0x15, 0x85,
		0xE8, 0x2A, 0x6E, 0x4A, 0x1F, 0xBE, 0x49, 0xB1,
		0xE6, 0x0F, 0x93, 0xE2, 0xB6, 0x87, 0x5D, 0x35,
		0xD8, 0xD4, 0x4A, 0x45, 0xCA, 0xB3, 0x33, 0x74,
		0x18, 0xC1, 0x16, 0xFB, 0x8F, 0xA4, 0x8E, 0x70,
		0xCD, 0xB4, 0x4A, 0xDC, 0xE6, 0x34, 0x32, 0x41,
		0xF9, 0x84, 0x6A, 0x99, 0xEC, 0x92, 0xF1, 0x8B,
		0x5D, 0xA5, 0x09, 0xCF, 0x3A, 0x93, 0xBC, 0xE0,
		0x15, 0x19, 0xE4, 0xB6, 0x9A, 0x04, 0x3B, 0xC1,
		0x96, 0xB7, 0x56, 0x85, 0x6A, 0xAA, 0x1E, 0x2A,
		0x80, 0xEE, 0xE7, 0x46, 0x76, 0x8B, 0x0D, 0xBA,
		0x24, 0x40, 0x42, 0x05, 0x0E, 0x04, 0x20, 0xA6,
		0x5E, 0xC1, 0x97, 0x7E, 0x44, 0x05, 0x01, 0xA9
	};

	static unsigned char const ffxxDump[0x100] = {
		0xCF, 0x00, 0x7E, 0xFF, 0xD3, 0x00, 0x00, 0xF8,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1,
		0x80, 0xBF, 0xF3, 0xFF, 0xBF, 0xFF, 0x3F, 0x00,
		0xFF, 0xBF, 0x7F, 0xFF, 0x9F, 0xFF, 0xBF, 0xFF,
		0xFF, 0x00, 0x00, 0xBF, 0x77, 0xF3, 0xF1, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0x71, 0x72, 0xD5, 0x91, 0x58, 0xBB, 0x2A, 0xFA,
		0xCF, 0x3C, 0x54, 0x75, 0x48, 0xCF, 0x8F, 0xD9,
		0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFC,
		0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0x2B, 0x0B, 0x64, 0x2F, 0xAF, 0x15, 0x60, 0x6D,
		0x61, 0x4E, 0xAC, 0x45, 0x0F, 0xDA, 0x92, 0xF3,
		0x83, 0x38, 0xE4, 0x4E, 0xA7, 0x6C, 0x38, 0x58,
		0xBE, 0xEA, 0xE5, 0x81, 0xB4, 0xCB, 0xBF, 0x7B,
		0x59, 0xAD, 0x50, 0x13, 0x5E, 0xF6, 0xB3, 0xC1,
		0xDC, 0xDF, 0x9E, 0x68, 0xD7, 0x59, 0x26, 0xF3,
		0x62, 0x54, 0xF8, 0x36, 0xB7, 0x78, 0x6A, 0x22,
		0xA7, 0xDD, 0x88, 0x15, 0xCA, 0x96, 0x39, 0xD3,
		0xE6, 0x55, 0x6E, 0xEA, 0x90, 0x76, 0xB8, 0xFF,
		0x50, 0xCD, 0xB5, 0x1B, 0x1F, 0xA5, 0x4D, 0x2E,
		0xB4, 0x09, 0x47, 0x8A, 0xC4, 0x5A, 0x8C, 0x4E,
		0xE7, 0x29, 0x50, 0x88, 0xA8, 0x66, 0x85, 0x4B,
		0xAA, 0x38, 0xE7, 0x6B, 0x45, 0x3E, 0x30, 0x37,
		0xBA, 0xC5, 0x31, 0xF2, 0x71, 0xB4, 0xCF, 0x29,
		0xBC, 0x7F, 0x7E, 0xD0, 0xC7, 0xC3, 0xBD, 0xCF,
		0x59, 0xEA, 0x39, 0x01, 0x2E, 0x00, 0x69, 0x00
	};

	std::memcpy(ioamhram        ,  oamDump, sizeof oamDump);
	std::memset(ioamhram + 0x0A0, 0x00, 0x060);
	std::memcpy(ioamhram + 0x100, ffxxDump, sizeof ffxxDump);
}

} // anon namespace

void gambatte::setInitState(SaveState &state, bool const cgb, bool const gbaCgbMode) {
	static unsigned char const cgbObjpDump[0x40] = {
		0x00, 0x00, 0xF2, 0xAB,
		0x61, 0xC2, 0xD9, 0xBA,
		0x88, 0x6E, 0xDD, 0x63,
		0x28, 0x27, 0xFB, 0x9F,
		0x35, 0x42, 0xD6, 0xD4,
		0x50, 0x48, 0x57, 0x5E,
		0x23, 0x3E, 0x3D, 0xCA,
		0x71, 0x21, 0x37, 0xC0,
		0xC6, 0xB3, 0xFB, 0xF9,
		0x08, 0x00, 0x8D, 0x29,
		0xA3, 0x20, 0xDB, 0x87,
		0x62, 0x05, 0x5D, 0xD4,
		0x0E, 0x08, 0xFE, 0xAF,
		0x20, 0x02, 0xD7, 0xFF,
		0x07, 0x6A, 0x55, 0xEC,
		0x83, 0x40, 0x0B, 0x77
	};

	state.cpu.cycleCounter = cgb ? 0x102A0 : 0x102A0 + 0x8D2C;
	state.cpu.pc = 0x100;
	state.cpu.sp = 0xFFFE;
	state.cpu.a = cgb * 0x10 | 0x01;
	state.cpu.b = cgb & gbaCgbMode;
	state.cpu.c = 0x13;
	state.cpu.d = 0x00;
	state.cpu.e = 0xD8;
	state.cpu.f = 0xB0;
	state.cpu.h = 0x01;
	state.cpu.l = 0x4D;
	state.cpu.skip = false;

	std::memset(state.mem.sram.ptr, 0xFF, state.mem.sram.size());

	setInitialVram(state.mem.vram.ptr, cgb);

	if (cgb) {
		setInitialCgbWram(state.mem.wram.ptr);
		setInitialCgbIoamhram(state.mem.ioamhram.ptr);
	} else {
		setInitialDmgWram(state.mem.wram.ptr);
		setInitialDmgIoamhram(state.mem.ioamhram.ptr);
	}

	state.mem.ioamhram.ptr[0x104] = 0x1C;
	state.mem.ioamhram.ptr[0x140] = 0x91;
	state.mem.ioamhram.ptr[0x144] = 0x00;

	state.mem.divLastUpdate = 0;
	state.mem.timaLastUpdate = 0;
	state.mem.tmatime = disabled_time;
	state.mem.nextSerialtime = disabled_time;
	state.mem.lastOamDmaUpdate = disabled_time;
	state.mem.unhaltTime = disabled_time;
	state.mem.minIntTime = 0;
	state.mem.rombank = 1;
	state.mem.dmaSource = 0;
	state.mem.dmaDestination = 0;
	state.mem.rambank = 0;
	state.mem.oamDmaPos = 0xFE;
	state.mem.IME = false;
	state.mem.halted = false;
	state.mem.enableRam = false;
	state.mem.rambankMode = false;
	state.mem.hdmaTransfer = false;


	for (int i = 0x00; i < 0x40; i += 0x02) {
		state.ppu.bgpData.ptr[i    ] = 0xFF;
		state.ppu.bgpData.ptr[i + 1] = 0x7F;
	}

	std::memcpy(state.ppu.objpData.ptr, cgbObjpDump, sizeof cgbObjpDump);

	if (!cgb) {
		state.ppu.bgpData.ptr[0] = state.mem.ioamhram.get()[0x147];
		state.ppu.objpData.ptr[0] = state.mem.ioamhram.get()[0x148];
		state.ppu.objpData.ptr[1] = state.mem.ioamhram.get()[0x149];
	}

	for (int pos = 0; pos < 80; ++pos)
		state.ppu.oamReaderBuf.ptr[pos] = state.mem.ioamhram.ptr[(pos * 2 & ~3) | (pos & 1)];

	std::fill_n(state.ppu.oamReaderSzbuf.ptr, 40, false);
	std::memset(state.ppu.spAttribList, 0, sizeof state.ppu.spAttribList);
	std::memset(state.ppu.spByte0List, 0, sizeof state.ppu.spByte0List);
	std::memset(state.ppu.spByte1List, 0, sizeof state.ppu.spByte1List);
	state.ppu.videoCycles = cgb ? 144*456ul + 164 : 153*456ul + 396;
	state.ppu.enableDisplayM0Time = state.cpu.cycleCounter;
	state.ppu.winYPos = 0xFF;
	state.ppu.xpos = 0;
	state.ppu.endx = 0;
	state.ppu.reg0 = 0;
	state.ppu.reg1 = 0;
	state.ppu.tileword = 0;
	state.ppu.ntileword = 0;
	state.ppu.attrib = 0;
	state.ppu.nattrib = 0;
	state.ppu.state = 0;
	state.ppu.nextSprite = 0;
	state.ppu.currentSprite = 0;
	state.ppu.lyc   = state.mem.ioamhram.get()[0x145];
	state.ppu.m0lyc = state.mem.ioamhram.get()[0x145];
	state.ppu.weMaster = false;
	state.ppu.winDrawState = 0;
	state.ppu.wscx = 0;
	state.ppu.lastM0Time = 1234;
	state.ppu.nextM0Irq = 0;
	state.ppu.oldWy = state.mem.ioamhram.get()[0x14A];
	state.ppu.pendingLcdstatIrq = false;

	// spu.cycleCounter >> 12 & 7 represents the frame sequencer position.
	state.spu.cycleCounter = (cgb ? 0x1E00 : 0x2400) | (state.cpu.cycleCounter >> 1 & 0x1FF);

	state.spu.ch1.sweep.counter = SoundUnit::counter_disabled;
	state.spu.ch1.sweep.shadow = 0;
	state.spu.ch1.sweep.nr0 = 0;
	state.spu.ch1.sweep.negging = false;
	if (cgb) {
		state.spu.ch1.duty.nextPosUpdate = (state.spu.cycleCounter & ~1ul) + 37 * 2;
		state.spu.ch1.duty.pos = 6;
		state.spu.ch1.duty.high = true;
	} else {
		state.spu.ch1.duty.nextPosUpdate = (state.spu.cycleCounter & ~1ul) + 69 * 2;
		state.spu.ch1.duty.pos = 3;
		state.spu.ch1.duty.high = false;
	}
	state.spu.ch1.duty.nr3 = 0xC1;
	state.spu.ch1.env.counter = SoundUnit::counter_disabled;
	state.spu.ch1.env.volume = 0;
	state.spu.ch1.lcounter.counter = SoundUnit::counter_disabled;
	state.spu.ch1.lcounter.lengthCounter = 0x40;
	state.spu.ch1.nr4 = 0x07;
	state.spu.ch1.master = true;

	state.spu.ch2.duty.nextPosUpdate = SoundUnit::counter_disabled;
	state.spu.ch2.duty.nr3 = 0;
	state.spu.ch2.duty.pos = 0;
	state.spu.ch2.duty.high = false;
	state.spu.ch2.env.counter = SoundUnit::counter_disabled;
	state.spu.ch2.env.volume = 0;
	state.spu.ch2.lcounter.counter = SoundUnit::counter_disabled;
	state.spu.ch2.lcounter.lengthCounter = 0x40;
	state.spu.ch2.nr4 = 0;
	state.spu.ch2.master = false;

	std::memcpy(state.spu.ch3.waveRam.ptr, state.mem.ioamhram.get() + 0x130, 0x10);
	state.spu.ch3.lcounter.counter = SoundUnit::counter_disabled;
	state.spu.ch3.lcounter.lengthCounter = 0x100;
	state.spu.ch3.waveCounter = SoundUnit::counter_disabled;
	state.spu.ch3.lastReadTime = SoundUnit::counter_disabled;
	state.spu.ch3.nr3 = 0;
	state.spu.ch3.nr4 = 0;
	state.spu.ch3.wavePos = 0;
	state.spu.ch3.sampleBuf = 0;
	state.spu.ch3.master = false;

	state.spu.ch4.lfsr.counter = state.spu.cycleCounter + 4;
	state.spu.ch4.lfsr.reg = 0xFF;
	state.spu.ch4.env.counter = SoundUnit::counter_disabled;
	state.spu.ch4.env.volume = 0;
	state.spu.ch4.lcounter.counter = SoundUnit::counter_disabled;
	state.spu.ch4.lcounter.lengthCounter = 0x40;
	state.spu.ch4.nr4 = 0;
	state.spu.ch4.master = false;

	state.rtc.baseTime = std::time(0);
	state.rtc.haltTime = state.rtc.baseTime;
	state.rtc.dataDh = 0;
	state.rtc.dataDl = 0;
	state.rtc.dataH = 0;
	state.rtc.dataM = 0;
	state.rtc.dataS = 0;
	state.rtc.lastLatchData = false;
}
