/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
// Self
#include "decodetest.h"

// Qt
#include <QtTest>

// Local
#include <qindicatedecode.h>

QTEST_MAIN(DecodeTest)

static QDateTime localDateTimeFromUtcTime(int hour, int minute, int second, int msec=0)
{
    QTime utcTime(hour, minute, second, msec);
    QDateTime utcDateTime(QDate(1970, 1, 1), utcTime, Qt::UTC);
    return utcDateTime.toLocalTime();
}

void DecodeTest::testDateTimeFromValue()
{
    QCOMPARE(QIndicate::Decode::dateTimeFromValue("1970-01-01T23:45:56.001000Z"), localDateTimeFromUtcTime(23, 45, 56, 1));
    QCOMPARE(QIndicate::Decode::dateTimeFromValue("1970-01-01T23:45:56Z"), localDateTimeFromUtcTime(23, 45, 56));
    QCOMPARE(QIndicate::Decode::dateTimeFromValue("John Doe"), QDateTime());
    QCOMPARE(QIndicate::Decode::dateTimeFromValue("1970-01-01T23:45:56.aZ"), QDateTime());
}

#include "decodetest.moc"
