#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#include "LynkeosCommon.h"
#include "ffmpeg_access.h"


@interface LynkeosFfmpegMovie : NSObject {
  FfmpegMovie movie;
  TimeValue currentFrame;
}


/**
 * Returns an array of strings representing those file types that contain supported movie data. The array returned by this method may be passed directly to NSOpenPanel\u2019s runModalForTypes: method.
 *
 **/
+ (NSArray*) movieUnfilteredFileTypes;

/**
 * Go to the next frame, return the frame time (in other word ... the frame number) or (-1) if no frame left.
 *
 **/
- (TimeValue)getNextFrameTime;
- (id)initWithURL:(NSURL *)url byReference:(BOOL)byRef;


/**
 * Return the size of the image movie.
 *
 **/
- (NSSize) imageSize;

/**
 * Return image of the movie at time 'time'
 *
 **/
- (NSImage*) getImageAt:(TimeValue)time;

- (void) loadImageDataIn:(NSMutableData*)data;


- (void) resetMovie;

@end

