// Luanti
// SPDX-License-Identifier: LGPL-2.1-or-later
// Copyright (C) 2023 Vitaliy Lobachevskiy

#include "test.h"

#include "mesh_compare.h"

// This is a self-test to ensure proper functionality of the vertex
// building functions (`Triangle`, `Quad`) and its validation function
// `checkMeshEqual` in preparation for the tests in test_content_mapblock.cpp
class TestMeshCompare : public TestBase {
public:
	TestMeshCompare() { TestManager::registerTestModule(this); }
	const char *getName() override { return "TestMeshCompare"; }

	void runTests(IGameDef *gamedef) override {
		TEST(testTriangle);
		TEST(testQuad);
	}

	void testTriangle() {
		UASSERT(checkMeshEqual({
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
		}, {0, 1, 2}, {
			Triangle{{
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			}},
		}));
		UASSERT(checkMeshEqual({
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
		}, {2, 0, 1}, {
			Triangle{{
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			}},
		}));
		UASSERT(!checkMeshEqual({
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
		}, {0, 2, 1}, {
			Triangle{{
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			}},
		}));

		UASSERT(checkMeshEqual({
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
		}, {0, 1, 2}, {
			Triangle{{
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			}},
		}));
		UASSERT(!checkMeshEqual({
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
		}, {0, 1, 2}, {
			Triangle{{
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			}},
		}));
	}

	void testQuad() {
		UASSERT(checkMeshEqual({
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
			{{1., -1., 1.}, {4., 0., 0.}, 4, {0., 0.}},
		}, {0, 1, 2, 0, 2, 3}, {
			Quad{{
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{1., -1., 1.}, {4., 0., 0.}, 4, {0., 0.}},
			}},
		}));
		UASSERT(checkMeshEqual({
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
			{{1., -1., 1.}, {4., 0., 0.}, 4, {0., 0.}},
		}, {2, 3, 0, 1, 2, 0}, {
			Quad{{
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{1., -1., 1.}, {4., 0., 0.}, 4, {0., 0.}},
			}},
		}));
		UASSERT(checkMeshEqual({
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
			{{1., -1., 1.}, {4., 0., 0.}, 4, {0., 0.}},
		}, {2, 3, 1, 0, 1, 3}, {
			Quad{{
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{1., -1., 1.}, {4., 0., 0.}, 4, {0., 0.}},
			}},
		}));
		UASSERT(checkMeshEqual({
			{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
			{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
			{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
			{{1., -1., 1.}, {4., 0., 0.}, 4, {0., 0.}},
		}, {3, 0, 1, 1, 2, 3}, {
			Quad{{
				{{1., 0., 0.}, {3., 0., 0.}, 1, {0., 0.}},
				{{0., 1., 0.}, {2., 0., 0.}, 2, {0., 0.}},
				{{0., 0., 1.}, {1., 0., 0.}, 3, {0., 0.}},
				{{1., -1., 1.}, {4., 0., 0.}, 4, {0., 0.}},
			}},
		}));
	}
};

static TestMeshCompare mesh_compare_test;
