<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'Node.php';
	require_once 'Attribute.php';

	/**
	* Test Module object
	*
	* Author: Nicolas Dufresne
	*/
	
	class LogsViewer{
		//var $node;
		//var $parent;
		//var $children;
		//var $status;
		//var $newStatus;
		var $attributes;
		var $current;			// Shown page
		var $logs_per_page;		// Number of logs per pages
		var $start;			// First log of the shown page
		//var $next;
		var $numRows;			// Number of rows
		var $conversion_attributes;
		var $conversion_comparator;

		
		function LogsViewer() {
			$where = "";

			/* Constructor */
			$this->conversion_attributes = array( 	'ts' => getMessage('logs_ts'),
									'id' => getMessage('logs_id'),
									'mac' => getMessage('logs_mac'),
									'ip' => getMessage('logs_ip'),
									'bootservip' => getMessage('logs_bootservip'),
									'appservip' => getMessage('logs_appservip'),
									'username' => getMessage('logs_username'),
									'code' => getMessage('logs_code') );
			$this->conversion_comparator = array(	'=' => getMEssage('logs_equals'),
									'>' => getMEssage('logs_greater'),
									'>=' => getMEssage('logs_gt_equals'),
									'<' => getMEssage('logs_smaller'),
									'<=' => getMEssage('logs_sm_equals'),
									'<>' => getMEssage('logs_not_equals') );

			// Verify that current is set, otherwise assign a default value
			if( isset( $_GET["logs_page"] ) )
				$this->current = $_GET["logs_page"];
			else
				$this->current = 0;

			// Verify that logs_per_page is set, otherwise assign a default value
			if( isset( $_GET['logs_per_page'] ) )
				if( $_GET["logs_per_page"] > 25000 )
					$this->logs_per_page = 25000;
				else
					$this->logs_per_page = abs( round( $_GET["logs_per_page"] ) );
			else
				$this->logs_per_page = 100;

			// Add conditions to the Filter of logs
			if( isset( $_POST['logs_add_condition'] ) && $_POST['logs_value'] <> "" ){
				$filter = $_SESSION['logs_filters'];
				$condition = $_POST['logs_condition'];
				$comparator = $_POST['logs_comparator'];
				$value = $_POST['logs_value'];
				$filter[] = $condition." ".$comparator." '".$value."'";
				$_SESSION['logs_filters'] = $filter;
			} else if( isset( $_POST['logs_remove_condition'] ) ){
				$_SESSION['logs_filters'] = array();
			}

			// Creation of the Where with the Filters
			if( isset( $_SESSION['logs_filters'] ) && count( $_SESSION['logs_filters'] ) > 0 ){
				$where = "WHERE";
				$filter = current( $_SESSION['logs_filters'] );
				$is_first_filter = true;
				do{
					if( $is_first_filter )
						$is_first_filter = false;
					else
						$where .= " AND";
					$where .= " ".$filter;
				}while( $filter = next( $_SESSION['logs_filters'] ) );
			}
					

			// Compute page information
			$this->start = $this->current * $this->logs_per_page;
			$this->attributes = select("SELECT * FROM log $where ORDER BY id_key DESC LIMIT $this->logs_per_page OFFSET $this->start;");
			$this->numRows = singleResultSelect("SELECT COUNT(*) FROM log $where");

			if ( !is_array( $this->attributes ) && !is_null( $this->attributes ) ){
				die( $this->attributes );
			}
		}
		
		function print_nav(){
			$last_page = ceil( $this->numRows['count'] / $this->logs_per_page );
			// Prev logs page
			print "<p>";
			echo "[&nbsp;";
			if( ($this->start-$this->logs_per_page) >=0 )
			{
				$newPrev = $this->current - 1;
				print "<a href=admin.php?&module=logs_module&logs_page=". $newPrev ."&logs_per_page=". $this->logs_per_page .">".getMessage('logs_prev')."</a>";
			}
			else print getMessage('logs_prev');
			echo "&nbsp;] ";
			// Middle Navigation
			for( $page = 0; $page < $last_page; $page++ ){
				$nb_shown_marks = 5;
				if( $page == 0 || $page == $last_page - 1 || ( $page <= $this->current + $nb_shown_marks && $page >= $this->current - $nb_shown_marks ) ){
					echo "[&nbsp;";
					if( $page <> $this->current ){
						echo "<a href=admin.php?&module=logs_module&logs_page=".$page."&logs_per_page=". $this->logs_per_page .">".( $page + 1 )."</a>";
					} else {
						echo $page+1;
					}
					echo "&nbsp;] ";
				}
			}


			// Next logs page
			echo "[&nbsp;";
			if( ($this->start + $this->logs_per_page) < $this->numRows["count"])
			{
				$newCurrent = $this->current + 1;
				print 	"<a href=admin.php?module=logs_module&logs_page=". $newCurrent ."&logs_per_page=". $this->logs_per_page .">" . getMessage('logs_next')."</a>";
			}
			else print getMessage('logs_next');
			echo "&nbsp;]";
			print "</p>";
		}

		function logs_per_page_selector(){
			print "<p>";
				echo "<FORM METHOD='GET'>";
					echo "<INPUT TYPE='text' VALUE='".$this->logs_per_page."' NAME='logs_per_page'>";
					echo "<INPUT TYPE='hidden' VALUE='logs_module' NAME='module'>";
					echo "<INPUT TYPE='SUBMIT' VALUE='".getMessage('logs_validate')."'>";
				echo "</FORM>";
			print "</p>";
		}

		function print_filters(){
			print "<FORM METHOD='POST' ACTION='admin.php?".getGETParam()."'>";
				print "<SELECT NAME='logs_condition'>\n";
					foreach( $this->conversion_attributes as $key => $value ){
						print "<OPTION VALUE='$key'>$value</OPTION>\n";
					}
				print "</SELECT>\n";
				print "<SELECT NAME='logs_comparator'>\n";
					foreach( $this->conversion_comparator as $key => $value ){
						print "<OPTION VALUE='$key'>$value</OPTION>\n";
					}
				print "</SELECT>\n";
				print "<INPUT TYPE='TEXT' NAME='logs_value'>\n";
				print "<INPUT TYPE='SUBMIT' NAME='logs_add_condition' VALUE='".getMessage('logs_send_add_filter')."'>";
				if( isset( $_SESSION['logs_filters'] ) && count( $_SESSION['logs_filters'] ) > 0 ){
					echo "<h3>".getMessage('logs_msg_active_filters')."</h3>";
					print "<p>";
					foreach( $_SESSION['logs_filters'] as $filter ){
						print str_replace(array_keys( $this->conversion_attributes ), array_values( $this->conversion_attributes ), str_replace(array_keys( $this->conversion_comparator ), array_values( $this->conversion_comparator ), $filter ) )."<br />";
					}
					print "</p>";
					print "<INPUT TYPE='SUBMIT' NAME='logs_remove_condition' VALUE='".getMessage('logs_send_remove_filter')."'>";
				}
			print "</FORM>";
		}
			
		function print_logs() {
			echo "<h2>".getMessage('logs_filter_message')."</h2>";
			$this->print_filters();
			echo "<h3>".getMessage('logs_nb_logs_message')."</h3>";
			$this->logs_per_page_selector();
			echo "<h2>".getMessage('logs_table_message')."</h2>";
			echo "<table>";
			echo "<tr><th colspan='2'>".getMessage('logs_code_msg_legend')."</th></tr>";
			echo "<tr><td>1</td><td>".getMessage('logs_code_booting')."</td></tr>";
			echo "<tr><td>2</td><td>".getMessage('logs_code_GDM')."</td></tr>";
			echo "<tr><td>3</td><td>".getMessage('logs_code_logging')."</td></tr>";
			echo "<tr><td>4</td><td>".getMessage('logs_code_unlogging')."</td></tr>";
			echo "</table>";
			$this->print_nav();
			
			print '<table border=1><tr>';
			print "<th>".getMEssage('logs_ts')." </th>\n";
			print "<th>".getMEssage('logs_id')."</th>\n"; 
			print "<th>".getMEssage('logs_mac')."</th>\n";
			print "<th>".getMEssage('logs_ip')."</th>\n";
			print "<th>".getMEssage('logs_bootservip')."</th>\n";
			print "<th>".getMEssage('logs_appservip')."</th>\n";
			//print "<th>".getMEssage('logs_display')."</th>\n";
			print "<th>".getMEssage('logs_username')."</th>\n";
			print "<th>".getMEssage('logs_code')."</th>\n";
			//print "<th>".getMEssage('logs_bootservretry')."</th>\n";
			//print "<th>".getMEssage('logs_appservretry')."</th>\n";
			print "</tr>";
			if (is_array($this->attributes)) {
				foreach ($this->attributes as $element) {
					switch ( $element['code'] ){
						case "1" :
							$code = getMessage('logs_code_booting');
							break;
						case "2" :
							$code = getMessage('logs_code_GDM');
							break;
						case "3" :
							$code = getMessage('logs_code_logging');
							break;
						case "4" :
							$code = getMessage('logs_code_unlogging');
							break;
						default :
							$code = $element[code];
							break;
					}
					print "<tr>";
					print "<td>$element[ts]</td>\n";
					print "<td align=\"center\"><a href=\"admin.php?node_id=$element[id]&module=configuration_module\">$element[id]</a></td>\n"; 
					print "<td>$element[mac]</td>\n";
					print "<td>$element[ip]</td>\n";
					print "<td>$element[bootservip]</td>\n";
					print "<td>$element[appservip]</td>\n";
					//print "<td>$element[display]</td>\n";
					print "<td>".( ( strlen( $element[username] ) > 0 ) ? $element[username] : "&nbsp;" )."</td>\n"; // Added if to be sure the empty-cells show ( 2007, Mars 3 )
					print "<td>$code</td>\n";
					//print "<td>$element[bootservretry]</td>\n";
					//print "<td>$element[appservretry]</td>\n";
					print '</tr>';
				}
			}
			print '</table>';
			$this->print_nav();
		}
	}
?>
