; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=mldst-motion -S < %s | FileCheck %s
;target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

define void @no_gep_same_ptr(i1 %c, ptr %p, i32 %x, i32 %y) {
; CHECK-LABEL: @no_gep_same_ptr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[Y_SINK:%.*]] = phi i32 [ [[X:%.*]], [[IF_THEN]] ], [ [[Y:%.*]], [[IF_ELSE]] ]
; CHECK-NEXT:    store i32 [[Y_SINK]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:
  store i32 %x, ptr %p
  br label %if.end

if.else:
  store i32 %y, ptr %p
  br label %if.end

if.end:
  ret void
}

define void @no_gep_different_ptr(i1 %c, ptr %p1, ptr %p2, i32 %x, i32 %y) {
; CHECK-LABEL: @no_gep_different_ptr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    store i32 [[X:%.*]], ptr [[P1:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    store i32 [[Y:%.*]], ptr [[P2:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:
  store i32 %x, ptr %p1
  br label %if.end

if.else:
  store i32 %y, ptr %p2
  br label %if.end

if.end:
  ret void
}

define void @shared_gep(i1 %c, ptr %p, i32 %x, i32 %y) {
; CHECK-LABEL: @shared_gep(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i32, ptr [[P:%.*]], i32 1
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[Y_SINK:%.*]] = phi i32 [ [[X:%.*]], [[IF_THEN]] ], [ [[Y:%.*]], [[IF_ELSE]] ]
; CHECK-NEXT:    store i32 [[Y_SINK]], ptr [[GEP]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %gep = getelementptr i32, ptr %p, i32 1
  br i1 %c, label %if.then, label %if.else

if.then:
  store i32 %x, ptr %gep
  br label %if.end

if.else:
  store i32 %y, ptr %gep
  br label %if.end

if.end:
  ret void
}

define void @separate_geps(i1 %c, ptr %p, i32 %x, i32 %y) {
; CHECK-LABEL: @separate_geps(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[Y_SINK:%.*]] = phi i32 [ [[X:%.*]], [[IF_THEN]] ], [ [[Y:%.*]], [[IF_ELSE]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr i32, ptr [[P:%.*]], i32 1
; CHECK-NEXT:    store i32 [[Y_SINK]], ptr [[TMP0]], align 4
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:
  %gep1 = getelementptr i32, ptr %p, i32 1
  store i32 %x, ptr %gep1
  br label %if.end

if.else:
  %gep2 = getelementptr i32, ptr %p, i32 1
  store i32 %y, ptr %gep2
  br label %if.end

if.end:
  ret void
}
