; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; See https://lists.llvm.org/pipermail/llvm-commits/Week-of-Mon-20210412/904154.html
; When replacing an allocation that is only modified by a memcpy/memmove from
; a constant whose alignment is equal to or exceeds that of the allocation,
; we also need to ensure that we actually can replace all uses of an alloca
; with said constant. This matters because it could be e.g. a select between
; two constants, that happens after the first use of an alloca.

%t0 = type { ptr, i64 }

@g0 = external constant %t0
@g1 = external constant %t0
define void @test(ptr %out) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    [[I0:%.*]] = alloca [[T0:%.*]], align 8
; CHECK-NEXT:    [[I2:%.*]] = call i1 @get_cond()
; CHECK-NEXT:    [[I3:%.*]] = select i1 [[I2]], ptr @g0, ptr @g1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 8 dereferenceable(16) [[I0]], ptr noundef nonnull align 8 dereferenceable(16) [[I3]], i64 16, i1 false)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(16) [[OUT:%.*]], ptr noundef nonnull align 8 dereferenceable(16) [[I0]], i64 16, i1 false)
; CHECK-NEXT:    ret void
;
  %i0 = alloca %t0
  %i2 = call i1 @get_cond()
  %i3 = select i1 %i2, ptr @g0, ptr @g1
  call void @llvm.memcpy.p0.p0.i64(ptr %i0, ptr %i3, i64 16, i1 false)
  call void @llvm.memcpy.p0.p0.i64(ptr %out, ptr %i0, i64 16, i1 false)
  ret void
}

define void @test2() {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I:%.*]] = alloca [[T0:%.*]], align 8
; CHECK-NEXT:    [[I1:%.*]] = call i32 @func(ptr undef)
; CHECK-NEXT:    [[I2:%.*]] = icmp eq i32 [[I1]], 2503
; CHECK-NEXT:    [[I3:%.*]] = select i1 [[I2]], ptr @g0, ptr @g1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 8 dereferenceable(16) [[I]], ptr noundef nonnull align 8 dereferenceable(16) [[I3]], i64 16, i1 false)
; CHECK-NEXT:    [[I5:%.*]] = call i32 @func(ptr nonnull byval([[T0]]) [[I]])
; CHECK-NEXT:    unreachable
;
bb:
  %i = alloca %t0, align 8
  %i1 = call i32 @func(ptr undef)
  %i2 = icmp eq i32 %i1, 2503
  %i3 = select i1 %i2, ptr @g0, ptr @g1
  call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 8 dereferenceable(16) %i, ptr noundef nonnull align 8 dereferenceable(16) %i3, i64 16, i1 false)
  %i5 = call i32 @func(ptr nonnull byval(%t0) %i)
  unreachable
}

declare i32 @func(ptr)
declare i1 @get_cond()
declare void @llvm.memcpy.p0.p0.i64(ptr, ptr, i64, i1)
