; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i64 @zext(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @zext(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i32 0, i32 [[Z:%.*]]
; CHECK-NEXT:    [[R:%.*]] = zext i32 [[SEL]] to i64
; CHECK-NEXT:    ret i64 [[R]]
;
  %cmp = icmp eq i32 %x, %y
  %sel = select i1 %cmp, i32 0, i32 %z
  %r = zext i32 %sel to i64
  ret i64 %r
}

define <2 x i32> @zext_vec(<2 x i8> %x, <2 x i8> %y, <2 x i8> %z) {
; CHECK-LABEL: @zext_vec(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select <2 x i1> [[CMP]], <2 x i8> [[Z:%.*]], <2 x i8> <i8 42, i8 7>
; CHECK-NEXT:    [[R:%.*]] = zext <2 x i8> [[SEL]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[R]]
;
  %cmp = icmp ugt <2 x i8> %x, %y
  %sel = select <2 x i1> %cmp, <2 x i8> %z, <2 x i8> <i8 42, i8 7>
  %r = zext <2 x i8> %sel to <2 x i32>
  ret <2 x i32> %r
}

define i64 @sext(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @sext(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 42, i8 [[Z:%.*]]
; CHECK-NEXT:    [[R:%.*]] = sext i8 [[SEL]] to i64
; CHECK-NEXT:    ret i64 [[R]]
;
  %cmp = icmp ult i8 %x, %y
  %sel = select i1 %cmp, i8 42, i8 %z
  %r = sext i8 %sel to i64
  ret i64 %r
}

define <2 x i32> @sext_vec(<2 x i8> %x, <2 x i8> %y, <2 x i8> %z) {
; CHECK-LABEL: @sext_vec(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select <2 x i1> [[CMP]], <2 x i8> [[Z:%.*]], <2 x i8> <i8 42, i8 7>
; CHECK-NEXT:    [[R:%.*]] = sext <2 x i8> [[SEL]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[R]]
;
  %cmp = icmp ugt <2 x i8> %x, %y
  %sel = select <2 x i1> %cmp, <2 x i8> %z, <2 x i8> <i8 42, i8 7>
  %r = sext <2 x i8> %sel to <2 x i32>
  ret <2 x i32> %r
}

define i16 @trunc(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @trunc(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[Z:%.*]] to i16
; CHECK-NEXT:    [[R:%.*]] = select i1 [[CMP]], i16 42, i16 [[TMP1]]
; CHECK-NEXT:    ret i16 [[R]]
;
  %cmp = icmp ult i32 %x, %y
  %sel = select i1 %cmp, i32 42, i32 %z
  %r = trunc i32 %sel to i16
  ret i16 %r
}

define <2 x i32> @trunc_vec(<2 x i64> %x, <2 x i64> %y, <2 x i64> %z) {
; CHECK-LABEL: @trunc_vec(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i64> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select <2 x i1> [[CMP]], <2 x i64> [[Z:%.*]], <2 x i64> <i64 42, i64 7>
; CHECK-NEXT:    [[R:%.*]] = trunc <2 x i64> [[SEL]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[R]]
;
  %cmp = icmp ugt <2 x i64> %x, %y
  %sel = select <2 x i1> %cmp, <2 x i64> %z, <2 x i64> <i64 42, i64 7>
  %r = trunc <2 x i64> %sel to <2 x i32>
  ret <2 x i32> %r
}

define double @fpext(float %x, float %y, float %z) {
; CHECK-LABEL: @fpext(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], float 1.700000e+01, float [[Z:%.*]]
; CHECK-NEXT:    [[R:%.*]] = fpext float [[SEL]] to double
; CHECK-NEXT:    ret double [[R]]
;
  %cmp = fcmp oeq float %x, %y
  %sel = select i1 %cmp, float 17.0, float %z
  %r = fpext float %sel to double
  ret double %r
}

define <2 x double> @fpext_vec(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fpext_vec(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt <2 x float> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select <2 x i1> [[CMP]], <2 x float> [[Z:%.*]], <2 x float> <float 4.200000e+01, float -2.000000e+00>
; CHECK-NEXT:    [[R:%.*]] = fpext <2 x float> [[SEL]] to <2 x double>
; CHECK-NEXT:    ret <2 x double> [[R]]
;
  %cmp = fcmp ugt <2 x float> %x, %y
  %sel = select <2 x i1> %cmp, <2 x float> %z, <2 x float> <float 42.0, float -2.0>
  %r = fpext <2 x float> %sel to <2 x double>
  ret <2 x double> %r
}

define float @fptrunc(double %x, double %y, double %z) {
; CHECK-LABEL: @fptrunc(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult double [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], double 4.200000e+01, double [[Z:%.*]]
; CHECK-NEXT:    [[R:%.*]] = fptrunc double [[SEL]] to float
; CHECK-NEXT:    ret float [[R]]
;
  %cmp = fcmp ult double %x, %y
  %sel = select i1 %cmp, double 42.0, double %z
  %r = fptrunc double %sel to float
  ret float %r
}

define <2 x float> @fptrunc_vec(<2 x double> %x, <2 x double> %y, <2 x double> %z) {
; CHECK-LABEL: @fptrunc_vec(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge <2 x double> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select <2 x i1> [[CMP]], <2 x double> [[Z:%.*]], <2 x double> <double -4.200000e+01, double 1.200000e+01>
; CHECK-NEXT:    [[R:%.*]] = fptrunc <2 x double> [[SEL]] to <2 x float>
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %cmp = fcmp oge <2 x double> %x, %y
  %sel = select <2 x i1> %cmp, <2 x double> %z, <2 x double> <double -42.0, double 12.0>
  %r = fptrunc <2 x double> %sel to <2 x float>
  ret <2 x float> %r
}

