#===----------------------------------------------------------------------===
#
# Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
# See https://llvm.org/LICENSE.txt for license information.
# SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
#
#===----------------------------------------------------------------------===

# Test that a nested exception is thrown by a destructor inside a try-block
# when the code is generated by the legacy AIX xlclang compiler.

# REQUIRES: target=powerpc-ibm-aix{{.*}}
# UNSUPPORTED: no-exceptions

# RUN: %{cxx} %{flags} %s %{link_flags} \
# RUN:   -o %t_32.exe
# RUN: %{exec} %t_32.exe

# This assembly file was generated by IBM legacy xlclang++ compiler from
# the following C++ source file for 32-bit mode.
#
# aix_xlclang_nested_excp.cpp:
#
# #include <cassert>
#
# struct Scary {
#   ~Scary() {
#     try {
#       throw 42;
#     } catch (int e) {
#       assert(e == 42);
#     }
#   }
# };
# int main(void) {
#   try {
#     Scary s;
#     throw 13;
#   } catch (int e) { // Destructor for 'Scary' runs before
#                     // '__xlc_exception_handle()' is called.
#     assert(e == 13);
#   }
# }
#
.set r0,0; .set SP,1; .set RTOC,2; .set r3,3; .set r4,4
.set r5,5; .set r6,6; .set r7,7; .set r8,8; .set r9,9
.set r10,10; .set r11,11; .set r12,12; .set r13,13; .set r14,14
.set r15,15; .set r16,16; .set r17,17; .set r18,18; .set r19,19
.set r20,20; .set r21,21; .set r22,22; .set r23,23; .set r24,24
.set r25,25; .set r26,26; .set r27,27; .set r28,28; .set r29,29
.set r30,30; .set r31,31
.set fp0,0; .set fp1,1; .set fp2,2; .set fp3,3; .set fp4,4
.set fp5,5; .set fp6,6; .set fp7,7; .set fp8,8; .set fp9,9
.set fp10,10; .set fp11,11; .set fp12,12; .set fp13,13; .set fp14,14
.set fp15,15; .set fp16,16; .set fp17,17; .set fp18,18; .set fp19,19
.set fp20,20; .set fp21,21; .set fp22,22; .set fp23,23; .set fp24,24
.set fp25,25; .set fp26,26; .set fp27,27; .set fp28,28; .set fp29,29
.set fp30,30; .set fp31,31
.set v0,0; .set v1,1; .set v2,2; .set v3,3; .set v4,4
.set v5,5; .set v6,6; .set v7,7; .set v8,8; .set v9,9
.set v10,10; .set v11,11; .set v12,12; .set v13,13; .set v14,14
.set v15,15; .set v16,16; .set v17,17; .set v18,18; .set v19,19
.set v20,20; .set v21,21; .set v22,22; .set v23,23; .set v24,24
.set v25,25; .set v26,26; .set v27,27; .set v28,28; .set v29,29
.set v30,30; .set v31,31
.set x0,0; .set x1,1; .set x2,2; .set x3,3; .set x4,4
.set x5,5; .set x6,6; .set x7,7; .set x8,8; .set x9,9
.set x10,10; .set x11,11; .set x12,12; .set x13,13; .set x14,14
.set x15,15; .set x16,16; .set x17,17; .set x18,18; .set x19,19
.set x20,20; .set x21,21; .set x22,22; .set x23,23; .set x24,24
.set x25,25; .set x26,26; .set x27,27; .set x28,28; .set x29,29
.set x30,30; .set x31,31; .set x32,32; .set x33,33; .set x34,34
.set x35,35; .set x36,36; .set x37,37; .set x38,38; .set x39,39
.set x40,40; .set x41,41; .set x42,42; .set x43,43; .set x44,44
.set x45,45; .set x46,46; .set x47,47; .set x48,48; .set x49,49
.set x50,50; .set x51,51; .set x52,52; .set x53,53; .set x54,54
.set x55,55; .set x56,56; .set x57,57; .set x58,58; .set x59,59
.set x60,60; .set x61,61; .set x62,62; .set x63,63
.set q0,0; .set q1,1; .set q2,2; .set q3,3; .set q4,4
.set q5,5; .set q6,6; .set q7,7; .set q8,8; .set q9,9
.set q10,10; .set q11,11; .set q12,12; .set q13,13; .set q14,14
.set q15,15; .set q16,16; .set q17,17; .set q18,18; .set q19,19
.set q20,20; .set q21,21; .set q22,22; .set q23,23; .set q24,24
.set q25,25; .set q26,26; .set q27,27; .set q28,28; .set q29,29
.set q30,30; .set q31,31
.set MQ,0; .set XER,1; .set DSCR,3; .set FROM_RTCU,4; .set FROM_RTCL,5
.set FROM_DEC,6; .set LR,8; .set CTR,9; .set AMR,13; .set TID,17; .set DSISR,18
.set DAR,19; .set TO_RTCU,20; .set TO_RTCL,21; .set TO_DEC,22; .set SDR_0,24
.set SDR_1,25; .set SRR_0,26; .set SRR_1,27
.set BO_dCTR_NZERO_AND_NOT,0; .set BO_dCTR_NZERO_AND_NOT_1,1
.set BO_dCTR_ZERO_AND_NOT,2; .set BO_dCTR_ZERO_AND_NOT_1,3
.set BO_IF_NOT,4; .set BO_IF_NOT_1,5; .set BO_IF_NOT_2,6
.set BO_IF_NOT_3,7; .set BO_dCTR_NZERO_AND,8; .set BO_dCTR_NZERO_AND_1,9
.set BO_dCTR_ZERO_AND,10; .set BO_dCTR_ZERO_AND_1,11; .set BO_IF,12
.set BO_IF_1,13; .set BO_IF_2,14; .set BO_IF_3,15; .set BO_dCTR_NZERO,16
.set BO_dCTR_NZERO_1,17; .set BO_dCTR_ZERO,18; .set BO_dCTR_ZERO_1,19
.set BO_ALWAYS,20; .set BO_ALWAYS_1,21; .set BO_ALWAYS_2,22
.set BO_ALWAYS_3,23; .set BO_dCTR_NZERO_8,24; .set BO_dCTR_NZERO_9,25
.set BO_dCTR_ZERO_8,26; .set BO_dCTR_ZERO_9,27; .set BO_ALWAYS_8,28
.set BO_ALWAYS_9,29; .set BO_ALWAYS_10,30; .set BO_ALWAYS_11,31
.set CR0_LT,0; .set CR0_GT,1; .set CR0_EQ,2; .set CR0_SO,3
.set CR1_FX,4; .set CR1_FEX,5; .set CR1_VX,6; .set CR1_OX,7
.set CR2_LT,8; .set CR2_GT,9; .set CR2_EQ,10; .set CR2_SO,11
.set CR3_LT,12; .set CR3_GT,13; .set CR3_EQ,14; .set CR3_SO,15
.set CR4_LT,16; .set CR4_GT,17; .set CR4_EQ,18; .set CR4_SO,19
.set CR5_LT,20; .set CR5_GT,21; .set CR5_EQ,22; .set CR5_SO,23
.set CR6_LT,24; .set CR6_GT,25; .set CR6_EQ,26; .set CR6_SO,27
.set CR7_LT,28; .set CR7_GT,29; .set CR7_EQ,30; .set CR7_SO,31
.set TO_LT,16; .set TO_GT,8; .set TO_EQ,4; .set TO_LLT,2; .set TO_LGT,1

	.rename	H.10.NO_SYMBOL{PR},""
	.rename	H.16..__21,".__21"
	.rename	H.18..__26,".__26"
	.rename	H.20..__22,".__22"
	.rename	H.22..__30,".__30"
	.rename	H.24..__29,".__29"
	.rename	H.26..__3,".__3"
	.rename	H.28..__10,".__10"
	.rename	H.30..__7,".__7"
	.rename	H.32..__2,".__2"
	.rename	H.36.NO_SYMBOL{TC},""
	.rename	H.38.NO_SYMBOL{RO},""
	.rename	E.40.__STATIC{RW},"_$STATIC"
	.rename	H.42.__STATIC{TC},"_$STATIC"
	.rename	H.46.__22{TC},"__22"
	.rename	H.50.__30{TC},"__30"
	.rename	H.54.__29{TC},"__29"
	.rename	H.58.__26{TC},"__26"
	.rename	H.62.__21{TC},"__21"
	.rename	H.66.__3{TC},"__3"
	.rename	H.70.__10{TC},"__10"
	.rename	H.74.__7{TC},"__7"
	.rename	H.78.__2{TC},"__2"
	.rename	H.82._ZN5ScaryD2Ev{TC},"_ZN5ScaryD2Ev"
	.rename	H.86._ZTIi{TC},"_ZTIi"
	.rename	H.90.main{TC},"main"

	.lglobl	H.10.NO_SYMBOL{PR}
	.weak	._ZN5ScaryD2Ev
	.globl	.main
	.lglobl	H.16..__21
	.lglobl	H.18..__26
	.lglobl	H.20..__22
	.lglobl	H.22..__30
	.lglobl	H.24..__29
	.lglobl	H.26..__3
	.lglobl	H.28..__10
	.lglobl	H.30..__7
	.lglobl	H.32..__2
	.lglobl	H.38.NO_SYMBOL{RO}
	.lglobl	E.40.__STATIC{RW}
	.lglobl	__22{DS}
	.lglobl	__30{DS}
	.lglobl	__29{DS}
	.lglobl	__26{DS}
	.lglobl	__21{DS}
	.lglobl	__3{DS}
	.lglobl	__10{DS}
	.lglobl	__7{DS}
	.lglobl	__2{DS}
	.weak	_ZN5ScaryD2Ev{DS}
	.extern	_ZTIi{UA}
	.globl	main{DS}
	.extern	.__cxa_allocate_exception{PR}
	.extern	.__cxa_throw{PR}
	.extern	.__xlc_exception_handle{PR}
	.extern	.__xlc_catch_matchv2{PR}
	.extern	.__cxa_begin_catch{PR}
	.extern	.__assert{PR}
	.extern	.__cxa_end_catch{PR}
	.extern	.__cxa_rethrow{PR}
	.extern	._Unwind_Resume{PR}
	.extern	._ZSt9terminatev{PR}


# .text section
	.file	"aix_xlclang_nested_excp.cpp","Thu Oct 20 13:21:16 2022 ","IBM XL C/C++ for AIX, Version 16.1.0.13"



	.csect	H.10.NO_SYMBOL{PR}, 7
._ZN5ScaryD2Ev:                         # 0x00000000 (H.10.NO_SYMBOL)
	mfspr      r0,LR
	st         r31,-4(SP)
	st         r30,-8(SP)
	st         r29,-12(SP)
	st         r0,8(SP)
	stu        SP,-128(SP)
	oril       r30,SP,0x0000
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	st         r3,152(r30)
	cal        r3,0(r0)
	st         r3,64(r30)
	cal        r4,88(r31)
	st         r4,68(r30)
	l          r4,152(r30)
	st         r4,72(r30)
	st         r3,76(r30)
	cal        r3,1(r0)
	stb        r3,67(r30)
	cal        r3,3(r0)
	stb        r3,67(r30)
	cal        r3,4(r0)
	bl         .__cxa_allocate_exception{PR}
	oril       r0,r0,0x0000
	oril       r4,r3,0x0000
	st         r4,80(r30)
	cal        r3,42(r0)
	st         r3,0(r4)
	l          r3,80(r30)
	l          r4,T.86._ZTIi(RTOC)
	cal        r5,0(r0)
	bl         .__cxa_throw{PR}
	oril       r0,r0,0x0000
	cal        r3,1(r0)
	stb        r3,67(r30)
	b          __L14c
__L90:                                  # 0x00000090 (H.10.NO_SYMBOL+0x90)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	cal        r3,4(r0)
	stb        r3,67(r30)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,84(r30)
	l          r4,T.86._ZTIi(RTOC)
	cal        r5,88(r30)
	bl         .__xlc_catch_matchv2{PR}
	oril       r0,r0,0x0000
	cmpli      0,r3,0x0000
	bc         BO_IF_NOT,CR0_EQ,__Lc8
	b          __L128
__Lc8:                                  # 0x000000c8 (H.10.NO_SYMBOL+0xc8)
	l          r3,84(r30)
	bl         .__cxa_begin_catch{PR}
	oril       r0,r0,0x0000
	l          r3,88(r30)
	l          r3,0(r3)
	st         r3,92(r30)
	cmpi       0,r3,42
	bc         BO_IF_NOT,CR0_EQ,__Lec
	b          __L100
__Lec:                                  # 0x000000ec (H.10.NO_SYMBOL+0xec)
	oril       r3,r29,0x0000
	cal        r4,8(r29)
	cal        r5,16(r0)
	bl         .__assert{PR}
	oril       r0,r0,0x0000
__L100:                                 # 0x00000100 (H.10.NO_SYMBOL+0x100)
	bl         .__cxa_end_catch{PR}
	oril       r0,r0,0x0000
	cal        r3,1(r0)
	stb        r3,67(r30)
	b          __L14c
__L114:                                 # 0x00000114 (H.10.NO_SYMBOL+0x114)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	bl         .__cxa_end_catch{PR}
	oril       r0,r0,0x0000
	b          __L1a8
__L128:                                 # 0x00000128 (H.10.NO_SYMBOL+0x128)
	cal        r3,4(r0)
	stb        r3,67(r30)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,96(r30)
	bl         .__cxa_begin_catch{PR}
	oril       r0,r0,0x0000
	bl         .__cxa_rethrow{PR}
	oril       r0,r0,0x0000
__L14c:                                 # 0x0000014c (H.10.NO_SYMBOL+0x14c)
	b          __L178
__L150:                                 # 0x00000150 (H.10.NO_SYMBOL+0x150)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,100(r30)
	bl         ._Unwind_Resume{PR}
	oril       r0,r0,0x0000
__L164:                                 # 0x00000164 (H.10.NO_SYMBOL+0x164)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	bl         ._ZSt9terminatev{PR}
	oril       r0,r0,0x0000
	b          __L150
__L178:                                 # 0x00000178 (H.10.NO_SYMBOL+0x178)
	b          __L1dc
__L17c:                                 # 0x0000017c (H.10.NO_SYMBOL+0x17c)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	bl         .__cxa_end_catch{PR}
	oril       r0,r0,0x0000
	cal        r3,0(r0)
	stb        r3,67(r30)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,104(r30)
	bl         ._Unwind_Resume{PR}
	oril       r0,r0,0x0000
__L1a8:                                 # 0x000001a8 (H.10.NO_SYMBOL+0x1a8)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	cal        r3,2(r0)
	stb        r3,67(r30)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,108(r30)
	bl         .__cxa_begin_catch{PR}
	oril       r0,r0,0x0000
	bl         ._ZSt9terminatev{PR}
	oril       r0,r0,0x0000
	bl         .__cxa_rethrow{PR}
	oril       r0,r0,0x0000
__L1dc:                                 # 0x000001dc (H.10.NO_SYMBOL+0x1dc)
	l          SP,0(SP)
	l          r29,-12(SP)
	l          r30,-8(SP)
	l          r31,-4(SP)
	l          r0,8(SP)
	mtspr      LR,r0
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x28			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=1,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x61			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=1,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=1
	.byte	0x80			# STORES_BC=1,FPR_SAVED=0
	.byte	0x03			# GPR_SAVED=3
	.byte	0x01			# FIXEDPARMS=1
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000000		#
	.long	0x000001f8		# TB_OFFSET
	.long	0x00000001		# NUM_CTL_INFO
	.long	0x00000040		# ctl_info_disp[0]
	.short	13			# NAME_LEN
	.byte	"_ZN5ScaryD2Ev"         # NAME

	.byte	30			# ALLOCA_REG
# End of traceback table
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
.main:                                  # 0x00000240 (H.10.NO_SYMBOL+0x240)
	mfspr      r0,LR
	st         r31,-4(SP)
	st         r30,-8(SP)
	st         r29,-12(SP)
	st         r0,8(SP)
	stu        SP,-128(SP)
	oril       r30,SP,0x0000
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	cal        r3,0(r0)
	st         r3,64(r30)
	oril       r4,r31,0x0000
	st         r4,68(r30)
	st         r3,72(r30)
	st         r3,76(r30)
	cal        r3,1(r0)
	stb        r3,67(r30)
	cal        r3,3(r0)
	stb        r3,67(r30)
	cal        r3,4(r0)
	bl         .__cxa_allocate_exception{PR}
	oril       r0,r0,0x0000
	oril       r4,r3,0x0000
	st         r4,80(r30)
	cal        r3,13(r0)
	st         r3,0(r4)
	l          r3,80(r30)
	l          r4,T.86._ZTIi(RTOC)
	cal        r5,0(r0)
	bl         .__cxa_throw{PR}
	oril       r0,r0,0x0000
	cal        r3,1(r0)
	stb        r3,67(r30)
	cal        r3,84(r30)
	bl         ._ZN5ScaryD2Ev
	oril       r0,r0,0x0000
	cal        r3,0(r0)
	stb        r3,67(r30)
	b          __L3b0
__L2dc:                                 # 0x000002dc (H.10.NO_SYMBOL+0x2dc)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	cal        r3,2(r0)
	stb        r3,67(r30)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,88(r30)
	l          r4,T.86._ZTIi(RTOC)
	cal        r5,92(r30)
	bl         .__xlc_catch_matchv2{PR}
	oril       r0,r0,0x0000
	cmpli      0,r3,0x0000
	bc         BO_IF_NOT,CR0_EQ,__L314
	b          __L38c
__L314:                                 # 0x00000314 (H.10.NO_SYMBOL+0x314)
	l          r3,88(r30)
	bl         .__cxa_begin_catch{PR}
	oril       r0,r0,0x0000
	l          r3,92(r30)
	l          r3,0(r3)
	st         r3,96(r30)
	cmpi       0,r3,13
	bc         BO_IF_NOT,CR0_EQ,__L338
	b          __L34c
__L338:                                 # 0x00000338 (H.10.NO_SYMBOL+0x338)
	cal        r3,36(r29)
	cal        r4,8(r29)
	cal        r5,26(r0)
	bl         .__assert{PR}
	oril       r0,r0,0x0000
__L34c:                                 # 0x0000034c (H.10.NO_SYMBOL+0x34c)
	bl         .__cxa_end_catch{PR}
	oril       r0,r0,0x0000
	cal        r3,0(r0)
	stb        r3,67(r30)
	b          __L3b0
__L360:                                 # 0x00000360 (H.10.NO_SYMBOL+0x360)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	bl         .__cxa_end_catch{PR}
	oril       r0,r0,0x0000
	cal        r3,0(r0)
	stb        r3,67(r30)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,100(r30)
	bl         ._Unwind_Resume{PR}
	oril       r0,r0,0x0000
__L38c:                                 # 0x0000038c (H.10.NO_SYMBOL+0x38c)
	cal        r3,2(r0)
	stb        r3,67(r30)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,104(r30)
	bl         .__cxa_begin_catch{PR}
	oril       r0,r0,0x0000
	bl         .__cxa_rethrow{PR}
	oril       r0,r0,0x0000
__L3b0:                                 # 0x000003b0 (H.10.NO_SYMBOL+0x3b0)
	cal        r3,0(r0)
	b          __L408
__L3b8:                                 # 0x000003b8 (H.10.NO_SYMBOL+0x3b8)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	cal        r3,4(r0)
	stb        r3,67(r30)
	cal        r3,84(r30)
	bl         ._ZN5ScaryD2Ev
	oril       r0,r0,0x0000
	cal        r3,1(r0)
	stb        r3,67(r30)
	b          __L2dc
__L3e0:                                 # 0x000003e0 (H.10.NO_SYMBOL+0x3e0)
	bl         .__xlc_exception_handle{PR}
	oril       r0,r0,0x0000
	st         r3,108(r30)
	bl         ._Unwind_Resume{PR}
	oril       r0,r0,0x0000
__L3f4:                                 # 0x000003f4 (H.10.NO_SYMBOL+0x3f4)
	l          r31,T.42.__STATIC(RTOC)
	l          r29,T.36.NO_SYMBOL(RTOC)
	bl         ._ZSt9terminatev{PR}
	oril       r0,r0,0x0000
	b          __L3e0
__L408:                                 # 0x00000408 (H.10.NO_SYMBOL+0x408)
	l          SP,0(SP)
	l          r29,-12(SP)
	l          r30,-8(SP)
	l          r31,-4(SP)
	l          r0,8(SP)
	mtspr      LR,r0
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x28			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=1,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x61			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=1,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=1
	.byte	0x80			# STORES_BC=1,FPR_SAVED=0
	.byte	0x03			# GPR_SAVED=3
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x000001e4		# TB_OFFSET
	.long	0x00000001		# NUM_CTL_INFO
	.long	0x00000040		# ctl_info_disp[0]
	.short	4			# NAME_LEN
	.byte	"main"                  # NAME

	.byte	30			# ALLOCA_REG
	.byte	0			# padding
# End of traceback table
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
H.16..__21:                             # 0x00000460 (H.10.NO_SYMBOL+0x460)
	b          __L1a8
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	4			# NAME_LEN
	.byte	"__21"                  # NAME

	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.18..__26:                             # 0x00000480 (H.10.NO_SYMBOL+0x480)
	b          __L17c
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	4			# NAME_LEN
	.byte	"__26"                  # NAME

	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.20..__22:                             # 0x000004a0 (H.10.NO_SYMBOL+0x4a0)
	b          __L164
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	4			# NAME_LEN
	.byte	"__22"                  # NAME

	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.22..__30:                             # 0x000004c0 (H.10.NO_SYMBOL+0x4c0)
	b          __L114
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	4			# NAME_LEN
	.byte	"__30"                  # NAME

	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.24..__29:                             # 0x000004e0 (H.10.NO_SYMBOL+0x4e0)
	b          __L90
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	4			# NAME_LEN
	.byte	"__29"                  # NAME

	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.26..__3:                              # 0x00000500 (H.10.NO_SYMBOL+0x500)
	b          __L3f4
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	3			# NAME_LEN
	.byte	"__3"                   # NAME

	.byte	0			# padding
	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.28..__10:                             # 0x00000520 (H.10.NO_SYMBOL+0x520)
	b          __L3b8
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	4			# NAME_LEN
	.byte	"__10"                  # NAME

	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.30..__7:                              # 0x00000540 (H.10.NO_SYMBOL+0x540)
	b          __L360
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	3			# NAME_LEN
	.byte	"__7"                   # NAME

	.byte	0			# padding
	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.32..__2:                              # 0x00000560 (H.10.NO_SYMBOL+0x560)
	b          __L2dc
	bcr        BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	3			# NAME_LEN
	.byte	"__2"                   # NAME

	.byte	0			# padding
	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
# End	csect	H.10.NO_SYMBOL{PR}

# .data section


	.toc	                        # 0x00000580
T.82._ZN5ScaryD2Ev:
	.tc	H.82._ZN5ScaryD2Ev{TC},_ZN5ScaryD2Ev{DS}
T.42.__STATIC:
	.tc	H.42.__STATIC{TC},E.40.__STATIC{RW}
T.36.NO_SYMBOL:
	.tc	H.36.NO_SYMBOL{TC},H.38.NO_SYMBOL{RO}
T.86._ZTIi:
	.tc	H.86._ZTIi{TC},_ZTIi{UA}
T.90.main:
	.tc	H.90.main{TC},main{DS}
T.62.__21:
	.tc	H.62.__21{TC},__21{DS}
T.58.__26:
	.tc	H.58.__26{TC},__26{DS}
T.46.__22:
	.tc	H.46.__22{TC},__22{DS}
T.50.__30:
	.tc	H.50.__30{TC},__30{DS}
T.54.__29:
	.tc	H.54.__29{TC},__29{DS}
T.66.__3:
	.tc	H.66.__3{TC},__3{DS}
T.70.__10:
	.tc	H.70.__10{TC},__10{DS}
T.74.__7:
	.tc	H.74.__7{TC},__7{DS}
T.78.__2:
	.tc	H.78.__2{TC},__2{DS}


	.csect	_ZN5ScaryD2Ev{DS}
	.long	._ZN5ScaryD2Ev          # "\0\0\0\0"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	_ZN5ScaryD2Ev{DS}


	.csect	main{DS}
	.long	.main                   # "\0\0\002@"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	main{DS}


	.csect	__21{DS}
	.long	H.16..__21              # "\0\0\004`"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__21{DS}


	.csect	__26{DS}
	.long	H.18..__26              # "\0\0\004\200"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__26{DS}


	.csect	__22{DS}
	.long	H.20..__22              # "\0\0\004\240"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__22{DS}


	.csect	__30{DS}
	.long	H.22..__30              # "\0\0\004\300"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__30{DS}


	.csect	__29{DS}
	.long	H.24..__29              # "\0\0\004\340"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__29{DS}


	.csect	__3{DS}
	.long	H.26..__3               # "\0\0\005\0"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__3{DS}


	.csect	__10{DS}
	.long	H.28..__10              # "\0\0\005 "
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__10{DS}


	.csect	__7{DS}
	.long	H.30..__7               # "\0\0\005@"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__7{DS}


	.csect	__2{DS}
	.long	H.32..__2               # "\0\0\005`"
	.long	TOC{TC0}                # "\0\0\005\200"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__2{DS}


	.csect	E.40.__STATIC{RW}, 3
	.long	0x1cedbeef              # "\034\355\276\357"
	.long	0x00000004              # "\0\0\0\004"
	.long	0x00000000              # "\0\0\0\0"
	.long	__2{DS}                 # "\0\0\0060"
	.long	0xffffffff              # "\377\377\377\377"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	__7{DS}                 # "\0\0\006$"
	.long	0xfffffffe              # "\377\377\377\376"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	__10{DS}                # "\0\0\006\030"
	.long	0xfffffffe              # "\377\377\377\376"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000001              # "\0\0\0\001"
	.long	0x00000000              # "\0\0\0\0"
	.long	__3{DS}                 # "\0\0\006\f"
	.long	0xfffffffc              # "\377\377\377\374"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x1cedbeef              # "\034\355\276\357"
	.long	0x00000005              # "\0\0\0\005"
	.long	0x00000000              # "\0\0\0\0"
	.long	__21{DS}                # "\0\0\005\320"
	.long	0xffffffff              # "\377\377\377\377"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	__26{DS}                # "\0\0\005\334"
	.long	0xfffffffe              # "\377\377\377\376"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	__29{DS}                # "\0\0\006\0"
	.long	0xffffffff              # "\377\377\377\377"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000001              # "\0\0\0\001"
	.long	0x00000000              # "\0\0\0\0"
	.long	__30{DS}                # "\0\0\005\364"
	.long	0xfffffffe              # "\377\377\377\376"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000001              # "\0\0\0\001"
	.long	0x00000000              # "\0\0\0\0"
	.long	__22{DS}                # "\0\0\005\350"
	.long	0xfffffffc              # "\377\377\377\374"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	E.40.__STATIC{RW}


	.csect	H.38.NO_SYMBOL{RO}, 3
	.long	0x65203d3d              # "e =="
	.long	0x20343200              # " 42\0"
	.long	0x6169785f              # "aix_"
	.long	0x786c636c              # "xlcl"
	.long	0x616e675f              # "ang_"
	.long	0x6e657374              # "nest"
	.long	0x65645f65              # "ed_e"
	.long	0x7863702e              # "xcp."
	.long	0x63707000              # "cpp\0"
	.long	0x65203d3d              # "e =="
	.long	0x20313300              # " 13\0"
# End	csect	H.38.NO_SYMBOL{RO}



# .bss section


# dwarf sections

# end dwarf sections
