/**
 * SECTION:setup-settings
 * @short_description: Class to store settings of a IPK setup.
 */
/**
 * LISTALLER_TYPE_SETUP_SETTINGS:
 * 
 * The type for <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link>.
 */
/**
 * listaller_setup_settings_lock:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 * 
 * Lock the settings, so no changes can be made anymore
 */
/**
 * listaller_setup_settings_unlock:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 * 
 * Allow changing the settings again
 */
/**
 * listaller_setup_settings_database_file:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 */
/**
 * listaller_setup_settings_appregister_dir:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 * 
 * Get software registry directory
 */
/**
 * listaller_setup_settings_appdata_dir:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 */
/**
 * listaller_setup_settings_depdata_dir:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 */
/**
 * listaller_setup_settings_icon_base_dir:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 */
/**
 * listaller_setup_settings_icon_size_dir:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 * @size: &nbsp;
 */
/**
 * listaller_setup_settings_applications_dir:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance
 */
/**
 * ListallerSetupSettings:current-mode:
 */
/**
 * listaller_setup_settings_get_current_mode:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerSetupSettings--current-mode"><type>"current-mode"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerSetupSettings--current-mode"><type>"current-mode"</type></link> property
 */
/**
 * listaller_setup_settings_set_current_mode:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerSetupSettings--current-mode"><type>"current-mode"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerSetupSettings--current-mode"><type>"current-mode"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerSetupSettings:locked:
 */
/**
 * listaller_setup_settings_get_locked:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerSetupSettings--locked"><type>"locked"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerSetupSettings--locked"><type>"locked"</type></link> property
 */
/**
 * ListallerSetupSettings:shared-mode:
 */
/**
 * listaller_setup_settings_get_shared_mode:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerSetupSettings--shared-mode"><type>"shared-mode"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerSetupSettings--shared-mode"><type>"shared-mode"</type></link> property
 */
/**
 * ListallerSetupSettings:private-mode:
 */
/**
 * listaller_setup_settings_get_private_mode:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerSetupSettings--private-mode"><type>"private-mode"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerSetupSettings--private-mode"><type>"private-mode"</type></link> property
 */
/**
 * ListallerSetupSettings:test-mode:
 */
/**
 * listaller_setup_settings_get_test_mode:
 * @self: the <link linkend="ListallerSetupSettings"><type>ListallerSetupSettings</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerSetupSettings--test-mode"><type>"test-mode"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerSetupSettings--test-mode"><type>"test-mode"</type></link> property
 */
/**
 * ListallerSetupSettings:
 * 
 * Class to store settings of a IPK setup.
 */
/**
 * ListallerSetupSettingsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-TYPE-SETUP-SETTINGS:CAPS"><literal>LISTALLER_TYPE_SETUP_SETTINGS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * listaller_ipk_install_mode_is_all_set:
 * @self: the <link linkend="ListallerIPKInstallMode"><type>ListallerIPKInstallMode</type></link> instance
 * @flags: &nbsp;
 */
/**
 * listaller_ipk_install_mode_is_any_set:
 * @self: the <link linkend="ListallerIPKInstallMode"><type>ListallerIPKInstallMode</type></link> instance
 * @flags: &nbsp;
 */
/**
 * listaller_ipk_install_mode_set:
 * @self: the <link linkend="ListallerIPKInstallMode"><type>ListallerIPKInstallMode</type></link> instance
 * @mode: &nbsp;
 */
/**
 * listaller_ipk_install_mode_unset:
 * @self: the <link linkend="ListallerIPKInstallMode"><type>ListallerIPKInstallMode</type></link> instance
 * @mode: &nbsp;
 */
/**
 * ListallerIPKInstallMode:
 * 
 * Mode of a current installation.
 * 
 * <para>This class is also used to indicate installation modes supported by an IPK package.</para>
 */
