/**********************************************************************
 *
 * Copyright (C) Imagination Technologies Ltd. All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope it will be useful but, except 
 * as otherwise stated in writing, without any warranty; without even the 
 * implied warranty of merchantability or fitness for a particular purpose. 
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * The full GNU General Public License is included in this distribution in
 * the file called "COPYING".
 *
 * Contact Information:
 * Imagination Technologies Ltd. <gpl-support@imgtec.com>
 * Home Park Estate, Kings Langley, Herts, WD4 8LZ, UK 
 *
 ******************************************************************************/

#ifndef _SGX545DEFS_KM_H_
#define _SGX545DEFS_KM_H_

#define EUR_CR_CLKGATECTL                   0x0000
#define EUR_CR_CLKGATECTL_ISP_CLKG_MASK     0x00000003U
#define EUR_CR_CLKGATECTL_ISP_CLKG_SHIFT    0
#define EUR_CR_CLKGATECTL_ISP_CLKG_SIGNED   0
#define EUR_CR_CLKGATECTL_ISP2_CLKG_MASK    0x0000000CU
#define EUR_CR_CLKGATECTL_ISP2_CLKG_SHIFT   2
#define EUR_CR_CLKGATECTL_ISP2_CLKG_SIGNED  0
#define EUR_CR_CLKGATECTL_TSP_CLKG_MASK     0x00000030U
#define EUR_CR_CLKGATECTL_TSP_CLKG_SHIFT    4
#define EUR_CR_CLKGATECTL_TSP_CLKG_SIGNED   0
#define EUR_CR_CLKGATECTL_TE_CLKG_MASK      0x000000C0U
#define EUR_CR_CLKGATECTL_TE_CLKG_SHIFT     6
#define EUR_CR_CLKGATECTL_TE_CLKG_SIGNED    0
#define EUR_CR_CLKGATECTL_MTE_CLKG_MASK     0x00000300U
#define EUR_CR_CLKGATECTL_MTE_CLKG_SHIFT    8
#define EUR_CR_CLKGATECTL_MTE_CLKG_SIGNED   0
#define EUR_CR_CLKGATECTL_DPM_CLKG_MASK     0x00000C00U
#define EUR_CR_CLKGATECTL_DPM_CLKG_SHIFT    10
#define EUR_CR_CLKGATECTL_DPM_CLKG_SIGNED   0
#define EUR_CR_CLKGATECTL_VDM_CLKG_MASK     0x00003000U
#define EUR_CR_CLKGATECTL_VDM_CLKG_SHIFT    12
#define EUR_CR_CLKGATECTL_VDM_CLKG_SIGNED   0
#define EUR_CR_CLKGATECTL_PDS0_CLKG_MASK    0x0000C000U
#define EUR_CR_CLKGATECTL_PDS0_CLKG_SHIFT   14
#define EUR_CR_CLKGATECTL_PDS0_CLKG_SIGNED  0
#define EUR_CR_CLKGATECTL_AUTO_MAN_REG_MASK 0x01000000U
#define EUR_CR_CLKGATECTL_AUTO_MAN_REG_SHIFT 24
#define EUR_CR_CLKGATECTL_AUTO_MAN_REG_SIGNED 0
#define EUR_CR_CLKGATECTL2                  0x0004
#define EUR_CR_CLKGATECTL2_PBE_CLKG_MASK    0x00000003U
#define EUR_CR_CLKGATECTL2_PBE_CLKG_SHIFT   0
#define EUR_CR_CLKGATECTL2_PBE_CLKG_SIGNED  0
#define EUR_CR_CLKGATECTL2_CACHEL2_CLKG_MASK 0x0000000CU
#define EUR_CR_CLKGATECTL2_CACHEL2_CLKG_SHIFT 2
#define EUR_CR_CLKGATECTL2_CACHEL2_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_UCACHEL2_CLKG_MASK 0x00000030U
#define EUR_CR_CLKGATECTL2_UCACHEL2_CLKG_SHIFT 4
#define EUR_CR_CLKGATECTL2_UCACHEL2_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_USE0_CLKG_MASK   0x000000C0U
#define EUR_CR_CLKGATECTL2_USE0_CLKG_SHIFT  6
#define EUR_CR_CLKGATECTL2_USE0_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_ITR0_CLKG_MASK   0x00000300U
#define EUR_CR_CLKGATECTL2_ITR0_CLKG_SHIFT  8
#define EUR_CR_CLKGATECTL2_ITR0_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_TEX0_CLKG_MASK   0x00000C00U
#define EUR_CR_CLKGATECTL2_TEX0_CLKG_SHIFT  10
#define EUR_CR_CLKGATECTL2_TEX0_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_MADD0_CLKG_MASK  0x00003000U
#define EUR_CR_CLKGATECTL2_MADD0_CLKG_SHIFT 12
#define EUR_CR_CLKGATECTL2_MADD0_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_USE1_CLKG_MASK   0x0000C000U
#define EUR_CR_CLKGATECTL2_USE1_CLKG_SHIFT  14
#define EUR_CR_CLKGATECTL2_USE1_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_ITR1_CLKG_MASK   0x00030000U
#define EUR_CR_CLKGATECTL2_ITR1_CLKG_SHIFT  16
#define EUR_CR_CLKGATECTL2_ITR1_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_TEX1_CLKG_MASK   0x000C0000U
#define EUR_CR_CLKGATECTL2_TEX1_CLKG_SHIFT  18
#define EUR_CR_CLKGATECTL2_TEX1_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_MADD1_CLKG_MASK  0x00300000U
#define EUR_CR_CLKGATECTL2_MADD1_CLKG_SHIFT 20
#define EUR_CR_CLKGATECTL2_MADD1_CLKG_SIGNED 0
#define EUR_CR_CLKGATECTL2_PDS1_CLKG_MASK   0x00C00000U
#define EUR_CR_CLKGATECTL2_PDS1_CLKG_SHIFT  22
#define EUR_CR_CLKGATECTL2_PDS1_CLKG_SIGNED 0
#define EUR_CR_CLKGATESTATUS                0x0008
#define EUR_CR_CLKGATESTATUS_ISP_CLKS_MASK  0x00000001U
#define EUR_CR_CLKGATESTATUS_ISP_CLKS_SHIFT 0
#define EUR_CR_CLKGATESTATUS_ISP_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_ISP2_CLKS_MASK 0x00000002U
#define EUR_CR_CLKGATESTATUS_ISP2_CLKS_SHIFT 1
#define EUR_CR_CLKGATESTATUS_ISP2_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_TSP_CLKS_MASK  0x00000004U
#define EUR_CR_CLKGATESTATUS_TSP_CLKS_SHIFT 2
#define EUR_CR_CLKGATESTATUS_TSP_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_TE_CLKS_MASK   0x00000008U
#define EUR_CR_CLKGATESTATUS_TE_CLKS_SHIFT  3
#define EUR_CR_CLKGATESTATUS_TE_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_MTE_CLKS_MASK  0x00000010U
#define EUR_CR_CLKGATESTATUS_MTE_CLKS_SHIFT 4
#define EUR_CR_CLKGATESTATUS_MTE_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_DPM_CLKS_MASK  0x00000020U
#define EUR_CR_CLKGATESTATUS_DPM_CLKS_SHIFT 5
#define EUR_CR_CLKGATESTATUS_DPM_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_VDM_CLKS_MASK  0x00000040U
#define EUR_CR_CLKGATESTATUS_VDM_CLKS_SHIFT 6
#define EUR_CR_CLKGATESTATUS_VDM_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_PDS0_CLKS_MASK 0x00000080U
#define EUR_CR_CLKGATESTATUS_PDS0_CLKS_SHIFT 7
#define EUR_CR_CLKGATESTATUS_PDS0_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_PBE_CLKS_MASK  0x00000100U
#define EUR_CR_CLKGATESTATUS_PBE_CLKS_SHIFT 8
#define EUR_CR_CLKGATESTATUS_PBE_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_CACHEL2_CLKS_MASK 0x00000200U
#define EUR_CR_CLKGATESTATUS_CACHEL2_CLKS_SHIFT 9
#define EUR_CR_CLKGATESTATUS_CACHEL2_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_UCACHEL2_CLKS_MASK 0x00000400U
#define EUR_CR_CLKGATESTATUS_UCACHEL2_CLKS_SHIFT 10
#define EUR_CR_CLKGATESTATUS_UCACHEL2_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_USE0_CLKS_MASK 0x00000800U
#define EUR_CR_CLKGATESTATUS_USE0_CLKS_SHIFT 11
#define EUR_CR_CLKGATESTATUS_USE0_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_ITR0_CLKS_MASK 0x00001000U
#define EUR_CR_CLKGATESTATUS_ITR0_CLKS_SHIFT 12
#define EUR_CR_CLKGATESTATUS_ITR0_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_TEX0_CLKS_MASK 0x00002000U
#define EUR_CR_CLKGATESTATUS_TEX0_CLKS_SHIFT 13
#define EUR_CR_CLKGATESTATUS_TEX0_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_MADD0_CLKS_MASK 0x00004000U
#define EUR_CR_CLKGATESTATUS_MADD0_CLKS_SHIFT 14
#define EUR_CR_CLKGATESTATUS_MADD0_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_USE1_CLKS_MASK 0x00008000U
#define EUR_CR_CLKGATESTATUS_USE1_CLKS_SHIFT 15
#define EUR_CR_CLKGATESTATUS_USE1_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_ITR1_CLKS_MASK 0x00010000U
#define EUR_CR_CLKGATESTATUS_ITR1_CLKS_SHIFT 16
#define EUR_CR_CLKGATESTATUS_ITR1_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_TEX1_CLKS_MASK 0x00020000U
#define EUR_CR_CLKGATESTATUS_TEX1_CLKS_SHIFT 17
#define EUR_CR_CLKGATESTATUS_TEX1_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_MADD1_CLKS_MASK 0x00040000U
#define EUR_CR_CLKGATESTATUS_MADD1_CLKS_SHIFT 18
#define EUR_CR_CLKGATESTATUS_MADD1_CLKS_SIGNED 0
#define EUR_CR_CLKGATESTATUS_PDS1_CLKS_MASK 0x00080000U
#define EUR_CR_CLKGATESTATUS_PDS1_CLKS_SHIFT 19
#define EUR_CR_CLKGATESTATUS_PDS1_CLKS_SIGNED 0
#define EUR_CR_CLKGATECTLOVR                0x000C
#define EUR_CR_CLKGATECTLOVR_ISP_CLKO_MASK  0x00000003U
#define EUR_CR_CLKGATECTLOVR_ISP_CLKO_SHIFT 0
#define EUR_CR_CLKGATECTLOVR_ISP_CLKO_SIGNED 0
#define EUR_CR_CLKGATECTLOVR_ISP2_CLKO_MASK 0x0000000CU
#define EUR_CR_CLKGATECTLOVR_ISP2_CLKO_SHIFT 2
#define EUR_CR_CLKGATECTLOVR_ISP2_CLKO_SIGNED 0
#define EUR_CR_CLKGATECTLOVR_TSP_CLKO_MASK  0x00000030U
#define EUR_CR_CLKGATECTLOVR_TSP_CLKO_SHIFT 4
#define EUR_CR_CLKGATECTLOVR_TSP_CLKO_SIGNED 0
#define EUR_CR_CLKGATECTLOVR_TE_CLKO_MASK   0x000000C0U
#define EUR_CR_CLKGATECTLOVR_TE_CLKO_SHIFT  6
#define EUR_CR_CLKGATECTLOVR_TE_CLKO_SIGNED 0
#define EUR_CR_CLKGATECTLOVR_MTE_CLKO_MASK  0x00000300U
#define EUR_CR_CLKGATECTLOVR_MTE_CLKO_SHIFT 8
#define EUR_CR_CLKGATECTLOVR_MTE_CLKO_SIGNED 0
#define EUR_CR_CLKGATECTLOVR_DPM_CLKO_MASK  0x00000C00U
#define EUR_CR_CLKGATECTLOVR_DPM_CLKO_SHIFT 10
#define EUR_CR_CLKGATECTLOVR_DPM_CLKO_SIGNED 0
#define EUR_CR_CLKGATECTLOVR_VDM_CLKO_MASK  0x00003000U
#define EUR_CR_CLKGATECTLOVR_VDM_CLKO_SHIFT 12
#define EUR_CR_CLKGATECTLOVR_VDM_CLKO_SIGNED 0
#define EUR_CR_CLKGATECTLOVR_PDS0_CLKO_MASK 0x0000C000U
#define EUR_CR_CLKGATECTLOVR_PDS0_CLKO_SHIFT 14
#define EUR_CR_CLKGATECTLOVR_PDS0_CLKO_SIGNED 0
#define EUR_CR_CORE_ID                      0x001C
#define EUR_CR_CORE_ID_CONFIG_MASK          0x0000FFFFU
#define EUR_CR_CORE_ID_CONFIG_SHIFT         0
#define EUR_CR_CORE_ID_CONFIG_SIGNED        0
#define EUR_CR_CORE_ID_ID_MASK              0xFFFF0000U
#define EUR_CR_CORE_ID_ID_SHIFT             16
#define EUR_CR_CORE_ID_ID_SIGNED            0
#define EUR_CR_CORE_REVISION                0x0020
#define EUR_CR_CORE_REVISION_MAINTENANCE_MASK 0x000000FFU
#define EUR_CR_CORE_REVISION_MAINTENANCE_SHIFT 0
#define EUR_CR_CORE_REVISION_MAINTENANCE_SIGNED 0
#define EUR_CR_CORE_REVISION_MINOR_MASK     0x0000FF00U
#define EUR_CR_CORE_REVISION_MINOR_SHIFT    8
#define EUR_CR_CORE_REVISION_MINOR_SIGNED   0
#define EUR_CR_CORE_REVISION_MAJOR_MASK     0x00FF0000U
#define EUR_CR_CORE_REVISION_MAJOR_SHIFT    16
#define EUR_CR_CORE_REVISION_MAJOR_SIGNED   0
#define EUR_CR_CORE_REVISION_DESIGNER_MASK  0xFF000000U
#define EUR_CR_CORE_REVISION_DESIGNER_SHIFT 24
#define EUR_CR_CORE_REVISION_DESIGNER_SIGNED 0
#define EUR_CR_DESIGNER_REV_FIELD1          0x0024
#define EUR_CR_DESIGNER_REV_FIELD1_DESIGNER_REV_FIELD1_MASK 0xFFFFFFFFU
#define EUR_CR_DESIGNER_REV_FIELD1_DESIGNER_REV_FIELD1_SHIFT 0
#define EUR_CR_DESIGNER_REV_FIELD1_DESIGNER_REV_FIELD1_SIGNED 0
#define EUR_CR_DESIGNER_REV_FIELD2          0x002C
#define EUR_CR_DESIGNER_REV_FIELD2_DESIGNER_REV_FIELD2_MASK 0xFFFFFFFFU
#define EUR_CR_DESIGNER_REV_FIELD2_DESIGNER_REV_FIELD2_SHIFT 0
#define EUR_CR_DESIGNER_REV_FIELD2_DESIGNER_REV_FIELD2_SIGNED 0
#define EUR_CR_SOFT_RESET                   0x0080
#define EUR_CR_SOFT_RESET_BIF_RESET_MASK    0x00000001U
#define EUR_CR_SOFT_RESET_BIF_RESET_SHIFT   0
#define EUR_CR_SOFT_RESET_BIF_RESET_SIGNED  0
#define EUR_CR_SOFT_RESET_DPM_RESET_MASK    0x00000002U
#define EUR_CR_SOFT_RESET_DPM_RESET_SHIFT   1
#define EUR_CR_SOFT_RESET_DPM_RESET_SIGNED  0
#define EUR_CR_SOFT_RESET_TA_RESET_MASK     0x00000004U
#define EUR_CR_SOFT_RESET_TA_RESET_SHIFT    2
#define EUR_CR_SOFT_RESET_TA_RESET_SIGNED   0
#define EUR_CR_SOFT_RESET_USE_RESET_MASK    0x00000008U
#define EUR_CR_SOFT_RESET_USE_RESET_SHIFT   3
#define EUR_CR_SOFT_RESET_USE_RESET_SIGNED  0
#define EUR_CR_SOFT_RESET_ISP_RESET_MASK    0x00000010U
#define EUR_CR_SOFT_RESET_ISP_RESET_SHIFT   4
#define EUR_CR_SOFT_RESET_ISP_RESET_SIGNED  0
#define EUR_CR_SOFT_RESET_TSP_RESET_MASK    0x00000020U
#define EUR_CR_SOFT_RESET_TSP_RESET_SHIFT   5
#define EUR_CR_SOFT_RESET_TSP_RESET_SIGNED  0
#define EUR_CR_EVENT_HOST_ENABLE2           0x0110
#define EUR_CR_EVENT_HOST_ENABLE2_MTE_STATE_FLUSHED_MASK 0x00008000U
#define EUR_CR_EVENT_HOST_ENABLE2_MTE_STATE_FLUSHED_SHIFT 15
#define EUR_CR_EVENT_HOST_ENABLE2_MTE_STATE_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_VDM_CONTEXT_LOAD_MASK 0x00004000U
#define EUR_CR_EVENT_HOST_ENABLE2_VDM_CONTEXT_LOAD_SHIFT 14
#define EUR_CR_EVENT_HOST_ENABLE2_VDM_CONTEXT_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_VDM_TASK_KICKED_MASK 0x00002000U
#define EUR_CR_EVENT_HOST_ENABLE2_VDM_TASK_KICKED_SHIFT 13
#define EUR_CR_EVENT_HOST_ENABLE2_VDM_TASK_KICKED_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_OTPM_MEM_CLEARED_MASK 0x00001000U
#define EUR_CR_EVENT_HOST_ENABLE2_OTPM_MEM_CLEARED_SHIFT 12
#define EUR_CR_EVENT_HOST_ENABLE2_OTPM_MEM_CLEARED_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_OTPM_FLUSHED_INV_MASK 0x00000800U
#define EUR_CR_EVENT_HOST_ENABLE2_OTPM_FLUSHED_INV_SHIFT 11
#define EUR_CR_EVENT_HOST_ENABLE2_OTPM_FLUSHED_INV_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_DCU_INVALCOMPLETE_MASK 0x00000400U
#define EUR_CR_EVENT_HOST_ENABLE2_DCU_INVALCOMPLETE_SHIFT 10
#define EUR_CR_EVENT_HOST_ENABLE2_DCU_INVALCOMPLETE_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_GSG_FLUSHED_MASK 0x00000200U
#define EUR_CR_EVENT_HOST_ENABLE2_GSG_FLUSHED_SHIFT 9
#define EUR_CR_EVENT_HOST_ENABLE2_GSG_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_GSG_LOADED_MASK 0x00000100U
#define EUR_CR_EVENT_HOST_ENABLE2_GSG_LOADED_SHIFT 8
#define EUR_CR_EVENT_HOST_ENABLE2_GSG_LOADED_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_TA_MASK 0x00000080U
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_TA_SHIFT 7
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_TA_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_3D_MASK 0x00000040U
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_3D_SHIFT 6
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_3D_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_DL_MASK 0x00000020U
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_DL_SHIFT 5
#define EUR_CR_EVENT_HOST_ENABLE2_TRIG_DL_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_DHOST_FREE_LOAD_MASK 0x00000008U
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_DHOST_FREE_LOAD_SHIFT 3
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_DHOST_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_HOST_FREE_LOAD_MASK 0x00000004U
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_HOST_FREE_LOAD_SHIFT 2
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_HOST_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_3D_FREE_LOAD_MASK 0x00000002U
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_3D_FREE_LOAD_SHIFT 1
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_3D_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_TA_FREE_LOAD_MASK 0x00000001U
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_TA_FREE_LOAD_SHIFT 0
#define EUR_CR_EVENT_HOST_ENABLE2_DPM_TA_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2            0x0114
#define EUR_CR_EVENT_HOST_CLEAR2_MTE_STATE_FLUSHED_MASK 0x00008000U
#define EUR_CR_EVENT_HOST_CLEAR2_MTE_STATE_FLUSHED_SHIFT 15
#define EUR_CR_EVENT_HOST_CLEAR2_MTE_STATE_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_VDM_CONTEXT_LOAD_MASK 0x00004000U
#define EUR_CR_EVENT_HOST_CLEAR2_VDM_CONTEXT_LOAD_SHIFT 14
#define EUR_CR_EVENT_HOST_CLEAR2_VDM_CONTEXT_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_VDM_TASK_KICKED_MASK 0x00002000U
#define EUR_CR_EVENT_HOST_CLEAR2_VDM_TASK_KICKED_SHIFT 13
#define EUR_CR_EVENT_HOST_CLEAR2_VDM_TASK_KICKED_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_OTPM_MEM_CLEARED_MASK 0x00001000U
#define EUR_CR_EVENT_HOST_CLEAR2_OTPM_MEM_CLEARED_SHIFT 12
#define EUR_CR_EVENT_HOST_CLEAR2_OTPM_MEM_CLEARED_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_OTPM_FLUSHED_INV_MASK 0x00000800U
#define EUR_CR_EVENT_HOST_CLEAR2_OTPM_FLUSHED_INV_SHIFT 11
#define EUR_CR_EVENT_HOST_CLEAR2_OTPM_FLUSHED_INV_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_DCU_INVALCOMPLETE_MASK 0x00000400U
#define EUR_CR_EVENT_HOST_CLEAR2_DCU_INVALCOMPLETE_SHIFT 10
#define EUR_CR_EVENT_HOST_CLEAR2_DCU_INVALCOMPLETE_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_GSG_FLUSHED_MASK 0x00000200U
#define EUR_CR_EVENT_HOST_CLEAR2_GSG_FLUSHED_SHIFT 9
#define EUR_CR_EVENT_HOST_CLEAR2_GSG_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_GSG_LOADED_MASK 0x00000100U
#define EUR_CR_EVENT_HOST_CLEAR2_GSG_LOADED_SHIFT 8
#define EUR_CR_EVENT_HOST_CLEAR2_GSG_LOADED_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_TA_MASK 0x00000080U
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_TA_SHIFT 7
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_TA_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_3D_MASK 0x00000040U
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_3D_SHIFT 6
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_3D_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_DL_MASK 0x00000020U
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_DL_SHIFT 5
#define EUR_CR_EVENT_HOST_CLEAR2_TRIG_DL_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_DHOST_FREE_LOAD_MASK 0x00000008U
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_DHOST_FREE_LOAD_SHIFT 3
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_DHOST_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_HOST_FREE_LOAD_MASK 0x00000004U
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_HOST_FREE_LOAD_SHIFT 2
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_HOST_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_3D_FREE_LOAD_MASK 0x00000002U
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_3D_FREE_LOAD_SHIFT 1
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_3D_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_TA_FREE_LOAD_MASK 0x00000001U
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_TA_FREE_LOAD_SHIFT 0
#define EUR_CR_EVENT_HOST_CLEAR2_DPM_TA_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_STATUS2                0x0118
#define EUR_CR_EVENT_STATUS2_MTE_STATE_FLUSHED_MASK 0x00008000U
#define EUR_CR_EVENT_STATUS2_MTE_STATE_FLUSHED_SHIFT 15
#define EUR_CR_EVENT_STATUS2_MTE_STATE_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_STATUS2_VDM_CONTEXT_LOAD_MASK 0x00004000U
#define EUR_CR_EVENT_STATUS2_VDM_CONTEXT_LOAD_SHIFT 14
#define EUR_CR_EVENT_STATUS2_VDM_CONTEXT_LOAD_SIGNED 0
#define EUR_CR_EVENT_STATUS2_VDM_TASK_KICKED_MASK 0x00002000U
#define EUR_CR_EVENT_STATUS2_VDM_TASK_KICKED_SHIFT 13
#define EUR_CR_EVENT_STATUS2_VDM_TASK_KICKED_SIGNED 0
#define EUR_CR_EVENT_STATUS2_OTPM_MEM_CLEARED_MASK 0x00001000U
#define EUR_CR_EVENT_STATUS2_OTPM_MEM_CLEARED_SHIFT 12
#define EUR_CR_EVENT_STATUS2_OTPM_MEM_CLEARED_SIGNED 0
#define EUR_CR_EVENT_STATUS2_OTPM_FLUSHED_INV_MASK 0x00000800U
#define EUR_CR_EVENT_STATUS2_OTPM_FLUSHED_INV_SHIFT 11
#define EUR_CR_EVENT_STATUS2_OTPM_FLUSHED_INV_SIGNED 0
#define EUR_CR_EVENT_STATUS2_DCU_INVALCOMPLETE_MASK 0x00000400U
#define EUR_CR_EVENT_STATUS2_DCU_INVALCOMPLETE_SHIFT 10
#define EUR_CR_EVENT_STATUS2_DCU_INVALCOMPLETE_SIGNED 0
#define EUR_CR_EVENT_STATUS2_GSG_FLUSHED_MASK 0x00000200U
#define EUR_CR_EVENT_STATUS2_GSG_FLUSHED_SHIFT 9
#define EUR_CR_EVENT_STATUS2_GSG_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_STATUS2_GSG_LOADED_MASK 0x00000100U
#define EUR_CR_EVENT_STATUS2_GSG_LOADED_SHIFT 8
#define EUR_CR_EVENT_STATUS2_GSG_LOADED_SIGNED 0
#define EUR_CR_EVENT_STATUS2_TRIG_TA_MASK   0x00000080U
#define EUR_CR_EVENT_STATUS2_TRIG_TA_SHIFT  7
#define EUR_CR_EVENT_STATUS2_TRIG_TA_SIGNED 0
#define EUR_CR_EVENT_STATUS2_TRIG_3D_MASK   0x00000040U
#define EUR_CR_EVENT_STATUS2_TRIG_3D_SHIFT  6
#define EUR_CR_EVENT_STATUS2_TRIG_3D_SIGNED 0
#define EUR_CR_EVENT_STATUS2_TRIG_DL_MASK   0x00000020U
#define EUR_CR_EVENT_STATUS2_TRIG_DL_SHIFT  5
#define EUR_CR_EVENT_STATUS2_TRIG_DL_SIGNED 0
#define EUR_CR_EVENT_STATUS2_DPM_DHOST_FREE_LOAD_MASK 0x00000008U
#define EUR_CR_EVENT_STATUS2_DPM_DHOST_FREE_LOAD_SHIFT 3
#define EUR_CR_EVENT_STATUS2_DPM_DHOST_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_STATUS2_DPM_HOST_FREE_LOAD_MASK 0x00000004U
#define EUR_CR_EVENT_STATUS2_DPM_HOST_FREE_LOAD_SHIFT 2
#define EUR_CR_EVENT_STATUS2_DPM_HOST_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_STATUS2_DPM_3D_FREE_LOAD_MASK 0x00000002U
#define EUR_CR_EVENT_STATUS2_DPM_3D_FREE_LOAD_SHIFT 1
#define EUR_CR_EVENT_STATUS2_DPM_3D_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_STATUS2_DPM_TA_FREE_LOAD_MASK 0x00000001U
#define EUR_CR_EVENT_STATUS2_DPM_TA_FREE_LOAD_SHIFT 0
#define EUR_CR_EVENT_STATUS2_DPM_TA_FREE_LOAD_SIGNED 0
#define EUR_CR_EVENT_STATUS                 0x012C
#define EUR_CR_EVENT_STATUS_MASTER_INTERRUPT_MASK 0x80000000U
#define EUR_CR_EVENT_STATUS_MASTER_INTERRUPT_SHIFT 31
#define EUR_CR_EVENT_STATUS_MASTER_INTERRUPT_SIGNED 0
#define EUR_CR_EVENT_STATUS_TIMER_MASK      0x20000000U
#define EUR_CR_EVENT_STATUS_TIMER_SHIFT     29
#define EUR_CR_EVENT_STATUS_TIMER_SIGNED    0
#define EUR_CR_EVENT_STATUS_TA_DPM_FAULT_MASK 0x10000000U
#define EUR_CR_EVENT_STATUS_TA_DPM_FAULT_SHIFT 28
#define EUR_CR_EVENT_STATUS_TA_DPM_FAULT_SIGNED 0
#define EUR_CR_EVENT_STATUS_MADD_CACHE_INVALCOMPLETE_MASK 0x04000000U
#define EUR_CR_EVENT_STATUS_MADD_CACHE_INVALCOMPLETE_SHIFT 26
#define EUR_CR_EVENT_STATUS_MADD_CACHE_INVALCOMPLETE_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_ZLS_MASK 0x02000000U
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_ZLS_SHIFT 25
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_ZLS_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_TA_MEM_FREE_MASK 0x01000000U
#define EUR_CR_EVENT_STATUS_DPM_TA_MEM_FREE_SHIFT 24
#define EUR_CR_EVENT_STATUS_DPM_TA_MEM_FREE_SIGNED 0
#define EUR_CR_EVENT_STATUS_ISP_END_TILE_MASK 0x00800000U
#define EUR_CR_EVENT_STATUS_ISP_END_TILE_SHIFT 23
#define EUR_CR_EVENT_STATUS_ISP_END_TILE_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_INITEND_MASK 0x00400000U
#define EUR_CR_EVENT_STATUS_DPM_INITEND_SHIFT 22
#define EUR_CR_EVENT_STATUS_DPM_INITEND_SIGNED 0
#define EUR_CR_EVENT_STATUS_ISP2_ZLS_CSW_FINISHED_MASK 0x00200000U
#define EUR_CR_EVENT_STATUS_ISP2_ZLS_CSW_FINISHED_SHIFT 21
#define EUR_CR_EVENT_STATUS_ISP2_ZLS_CSW_FINISHED_SIGNED 0
#define EUR_CR_EVENT_STATUS_OTPM_INV_MASK   0x00100000U
#define EUR_CR_EVENT_STATUS_OTPM_INV_SHIFT  20
#define EUR_CR_EVENT_STATUS_OTPM_INV_SIGNED 0
#define EUR_CR_EVENT_STATUS_OTPM_FLUSHED_MASK 0x00080000U
#define EUR_CR_EVENT_STATUS_OTPM_FLUSHED_SHIFT 19
#define EUR_CR_EVENT_STATUS_OTPM_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_STATUS_PIXELBE_END_RENDER_MASK 0x00040000U
#define EUR_CR_EVENT_STATUS_PIXELBE_END_RENDER_SHIFT 18
#define EUR_CR_EVENT_STATUS_PIXELBE_END_RENDER_SIGNED 0
#define EUR_CR_EVENT_STATUS_ISP_VISIBILITY_FAIL_MASK 0x00010000U
#define EUR_CR_EVENT_STATUS_ISP_VISIBILITY_FAIL_SHIFT 16
#define EUR_CR_EVENT_STATUS_ISP_VISIBILITY_FAIL_SIGNED 0
#define EUR_CR_EVENT_STATUS_BREAKPOINT_MASK 0x00008000U
#define EUR_CR_EVENT_STATUS_BREAKPOINT_SHIFT 15
#define EUR_CR_EVENT_STATUS_BREAKPOINT_SIGNED 0
#define EUR_CR_EVENT_STATUS_SW_EVENT_MASK   0x00004000U
#define EUR_CR_EVENT_STATUS_SW_EVENT_SHIFT  14
#define EUR_CR_EVENT_STATUS_SW_EVENT_SIGNED 0
#define EUR_CR_EVENT_STATUS_TA_FINISHED_MASK 0x00002000U
#define EUR_CR_EVENT_STATUS_TA_FINISHED_SHIFT 13
#define EUR_CR_EVENT_STATUS_TA_FINISHED_SIGNED 0
#define EUR_CR_EVENT_STATUS_TA_TERMINATE_MASK 0x00001000U
#define EUR_CR_EVENT_STATUS_TA_TERMINATE_SHIFT 12
#define EUR_CR_EVENT_STATUS_TA_TERMINATE_SIGNED 0
#define EUR_CR_EVENT_STATUS_TPC_CLEAR_MASK  0x00000800U
#define EUR_CR_EVENT_STATUS_TPC_CLEAR_SHIFT 11
#define EUR_CR_EVENT_STATUS_TPC_CLEAR_SIGNED 0
#define EUR_CR_EVENT_STATUS_TPC_FLUSH_MASK  0x00000400U
#define EUR_CR_EVENT_STATUS_TPC_FLUSH_SHIFT 10
#define EUR_CR_EVENT_STATUS_TPC_FLUSH_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_CLEAR_MASK 0x00000200U
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_CLEAR_SHIFT 9
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_CLEAR_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_LOAD_MASK 0x00000100U
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_LOAD_SHIFT 8
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_LOAD_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_STORE_MASK 0x00000080U
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_STORE_SHIFT 7
#define EUR_CR_EVENT_STATUS_DPM_CONTROL_STORE_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_STATE_CLEAR_MASK 0x00000040U
#define EUR_CR_EVENT_STATUS_DPM_STATE_CLEAR_SHIFT 6
#define EUR_CR_EVENT_STATUS_DPM_STATE_CLEAR_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_STATE_LOAD_MASK 0x00000020U
#define EUR_CR_EVENT_STATUS_DPM_STATE_LOAD_SHIFT 5
#define EUR_CR_EVENT_STATUS_DPM_STATE_LOAD_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_STATE_STORE_MASK 0x00000010U
#define EUR_CR_EVENT_STATUS_DPM_STATE_STORE_SHIFT 4
#define EUR_CR_EVENT_STATUS_DPM_STATE_STORE_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_REACHED_MEM_THRESH_MASK 0x00000008U
#define EUR_CR_EVENT_STATUS_DPM_REACHED_MEM_THRESH_SHIFT 3
#define EUR_CR_EVENT_STATUS_DPM_REACHED_MEM_THRESH_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_GBL_MASK 0x00000004U
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_GBL_SHIFT 2
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_GBL_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_MT_MASK 0x00000002U
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_MT_SHIFT 1
#define EUR_CR_EVENT_STATUS_DPM_OUT_OF_MEMORY_MT_SIGNED 0
#define EUR_CR_EVENT_STATUS_DPM_3D_MEM_FREE_MASK 0x00000001U
#define EUR_CR_EVENT_STATUS_DPM_3D_MEM_FREE_SHIFT 0
#define EUR_CR_EVENT_STATUS_DPM_3D_MEM_FREE_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE            0x0130
#define EUR_CR_EVENT_HOST_ENABLE_MASTER_INTERRUPT_MASK 0x80000000U
#define EUR_CR_EVENT_HOST_ENABLE_MASTER_INTERRUPT_SHIFT 31
#define EUR_CR_EVENT_HOST_ENABLE_MASTER_INTERRUPT_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_TIMER_MASK 0x20000000U
#define EUR_CR_EVENT_HOST_ENABLE_TIMER_SHIFT 29
#define EUR_CR_EVENT_HOST_ENABLE_TIMER_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_TA_DPM_FAULT_MASK 0x10000000U
#define EUR_CR_EVENT_HOST_ENABLE_TA_DPM_FAULT_SHIFT 28
#define EUR_CR_EVENT_HOST_ENABLE_TA_DPM_FAULT_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_MADD_CACHE_INVALCOMPLETE_MASK 0x04000000U
#define EUR_CR_EVENT_HOST_ENABLE_MADD_CACHE_INVALCOMPLETE_SHIFT 26
#define EUR_CR_EVENT_HOST_ENABLE_MADD_CACHE_INVALCOMPLETE_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_ZLS_MASK 0x02000000U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_ZLS_SHIFT 25
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_ZLS_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_TA_MEM_FREE_MASK 0x01000000U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_TA_MEM_FREE_SHIFT 24
#define EUR_CR_EVENT_HOST_ENABLE_DPM_TA_MEM_FREE_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_ISP_END_TILE_MASK 0x00800000U
#define EUR_CR_EVENT_HOST_ENABLE_ISP_END_TILE_SHIFT 23
#define EUR_CR_EVENT_HOST_ENABLE_ISP_END_TILE_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_INITEND_MASK 0x00400000U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_INITEND_SHIFT 22
#define EUR_CR_EVENT_HOST_ENABLE_DPM_INITEND_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_ISP2_ZLS_CSW_FINISHED_MASK 0x00200000U
#define EUR_CR_EVENT_HOST_ENABLE_ISP2_ZLS_CSW_FINISHED_SHIFT 21
#define EUR_CR_EVENT_HOST_ENABLE_ISP2_ZLS_CSW_FINISHED_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_OTPM_INV_MASK 0x00100000U
#define EUR_CR_EVENT_HOST_ENABLE_OTPM_INV_SHIFT 20
#define EUR_CR_EVENT_HOST_ENABLE_OTPM_INV_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_OTPM_FLUSHED_MASK 0x00080000U
#define EUR_CR_EVENT_HOST_ENABLE_OTPM_FLUSHED_SHIFT 19
#define EUR_CR_EVENT_HOST_ENABLE_OTPM_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_PIXELBE_END_RENDER_MASK 0x00040000U
#define EUR_CR_EVENT_HOST_ENABLE_PIXELBE_END_RENDER_SHIFT 18
#define EUR_CR_EVENT_HOST_ENABLE_PIXELBE_END_RENDER_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_ISP_VISIBILITY_FAIL_MASK 0x00010000U
#define EUR_CR_EVENT_HOST_ENABLE_ISP_VISIBILITY_FAIL_SHIFT 16
#define EUR_CR_EVENT_HOST_ENABLE_ISP_VISIBILITY_FAIL_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_BREAKPOINT_MASK 0x00008000U
#define EUR_CR_EVENT_HOST_ENABLE_BREAKPOINT_SHIFT 15
#define EUR_CR_EVENT_HOST_ENABLE_BREAKPOINT_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_SW_EVENT_MASK 0x00004000U
#define EUR_CR_EVENT_HOST_ENABLE_SW_EVENT_SHIFT 14
#define EUR_CR_EVENT_HOST_ENABLE_SW_EVENT_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_TA_FINISHED_MASK 0x00002000U
#define EUR_CR_EVENT_HOST_ENABLE_TA_FINISHED_SHIFT 13
#define EUR_CR_EVENT_HOST_ENABLE_TA_FINISHED_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_TA_TERMINATE_MASK 0x00001000U
#define EUR_CR_EVENT_HOST_ENABLE_TA_TERMINATE_SHIFT 12
#define EUR_CR_EVENT_HOST_ENABLE_TA_TERMINATE_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_TPC_CLEAR_MASK 0x00000800U
#define EUR_CR_EVENT_HOST_ENABLE_TPC_CLEAR_SHIFT 11
#define EUR_CR_EVENT_HOST_ENABLE_TPC_CLEAR_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_TPC_FLUSH_MASK 0x00000400U
#define EUR_CR_EVENT_HOST_ENABLE_TPC_FLUSH_SHIFT 10
#define EUR_CR_EVENT_HOST_ENABLE_TPC_FLUSH_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_CLEAR_MASK 0x00000200U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_CLEAR_SHIFT 9
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_CLEAR_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_LOAD_MASK 0x00000100U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_LOAD_SHIFT 8
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_STORE_MASK 0x00000080U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_STORE_SHIFT 7
#define EUR_CR_EVENT_HOST_ENABLE_DPM_CONTROL_STORE_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_CLEAR_MASK 0x00000040U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_CLEAR_SHIFT 6
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_CLEAR_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_LOAD_MASK 0x00000020U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_LOAD_SHIFT 5
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_STORE_MASK 0x00000010U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_STORE_SHIFT 4
#define EUR_CR_EVENT_HOST_ENABLE_DPM_STATE_STORE_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_REACHED_MEM_THRESH_MASK 0x00000008U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_REACHED_MEM_THRESH_SHIFT 3
#define EUR_CR_EVENT_HOST_ENABLE_DPM_REACHED_MEM_THRESH_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_GBL_MASK 0x00000004U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_GBL_SHIFT 2
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_GBL_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_MT_MASK 0x00000002U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_MT_SHIFT 1
#define EUR_CR_EVENT_HOST_ENABLE_DPM_OUT_OF_MEMORY_MT_SIGNED 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_3D_MEM_FREE_MASK 0x00000001U
#define EUR_CR_EVENT_HOST_ENABLE_DPM_3D_MEM_FREE_SHIFT 0
#define EUR_CR_EVENT_HOST_ENABLE_DPM_3D_MEM_FREE_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR             0x0134
#define EUR_CR_EVENT_HOST_CLEAR_MASTER_INTERRUPT_MASK 0x80000000U
#define EUR_CR_EVENT_HOST_CLEAR_MASTER_INTERRUPT_SHIFT 31
#define EUR_CR_EVENT_HOST_CLEAR_MASTER_INTERRUPT_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_TIMER_MASK  0x20000000U
#define EUR_CR_EVENT_HOST_CLEAR_TIMER_SHIFT 29
#define EUR_CR_EVENT_HOST_CLEAR_TIMER_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_TA_DPM_FAULT_MASK 0x10000000U
#define EUR_CR_EVENT_HOST_CLEAR_TA_DPM_FAULT_SHIFT 28
#define EUR_CR_EVENT_HOST_CLEAR_TA_DPM_FAULT_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_MADD_CACHE_INVALCOMPLETE_MASK 0x04000000U
#define EUR_CR_EVENT_HOST_CLEAR_MADD_CACHE_INVALCOMPLETE_SHIFT 26
#define EUR_CR_EVENT_HOST_CLEAR_MADD_CACHE_INVALCOMPLETE_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_ZLS_MASK 0x02000000U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_ZLS_SHIFT 25
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_ZLS_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_TA_MEM_FREE_MASK 0x01000000U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_TA_MEM_FREE_SHIFT 24
#define EUR_CR_EVENT_HOST_CLEAR_DPM_TA_MEM_FREE_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_ISP_END_TILE_MASK 0x00800000U
#define EUR_CR_EVENT_HOST_CLEAR_ISP_END_TILE_SHIFT 23
#define EUR_CR_EVENT_HOST_CLEAR_ISP_END_TILE_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_INITEND_MASK 0x00400000U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_INITEND_SHIFT 22
#define EUR_CR_EVENT_HOST_CLEAR_DPM_INITEND_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_ISP2_ZLS_CSW_FINISHED_MASK 0x00200000U
#define EUR_CR_EVENT_HOST_CLEAR_ISP2_ZLS_CSW_FINISHED_SHIFT 21
#define EUR_CR_EVENT_HOST_CLEAR_ISP2_ZLS_CSW_FINISHED_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_OTPM_INV_MASK 0x00100000U
#define EUR_CR_EVENT_HOST_CLEAR_OTPM_INV_SHIFT 20
#define EUR_CR_EVENT_HOST_CLEAR_OTPM_INV_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_OTPM_FLUSHED_MASK 0x00080000U
#define EUR_CR_EVENT_HOST_CLEAR_OTPM_FLUSHED_SHIFT 19
#define EUR_CR_EVENT_HOST_CLEAR_OTPM_FLUSHED_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_PIXELBE_END_RENDER_MASK 0x00040000U
#define EUR_CR_EVENT_HOST_CLEAR_PIXELBE_END_RENDER_SHIFT 18
#define EUR_CR_EVENT_HOST_CLEAR_PIXELBE_END_RENDER_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_ISP_VISIBILITY_FAIL_MASK 0x00010000U
#define EUR_CR_EVENT_HOST_CLEAR_ISP_VISIBILITY_FAIL_SHIFT 16
#define EUR_CR_EVENT_HOST_CLEAR_ISP_VISIBILITY_FAIL_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_BREAKPOINT_MASK 0x00008000U
#define EUR_CR_EVENT_HOST_CLEAR_BREAKPOINT_SHIFT 15
#define EUR_CR_EVENT_HOST_CLEAR_BREAKPOINT_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_SW_EVENT_MASK 0x00004000U
#define EUR_CR_EVENT_HOST_CLEAR_SW_EVENT_SHIFT 14
#define EUR_CR_EVENT_HOST_CLEAR_SW_EVENT_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_TA_FINISHED_MASK 0x00002000U
#define EUR_CR_EVENT_HOST_CLEAR_TA_FINISHED_SHIFT 13
#define EUR_CR_EVENT_HOST_CLEAR_TA_FINISHED_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_TA_TERMINATE_MASK 0x00001000U
#define EUR_CR_EVENT_HOST_CLEAR_TA_TERMINATE_SHIFT 12
#define EUR_CR_EVENT_HOST_CLEAR_TA_TERMINATE_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_TPC_CLEAR_MASK 0x00000800U
#define EUR_CR_EVENT_HOST_CLEAR_TPC_CLEAR_SHIFT 11
#define EUR_CR_EVENT_HOST_CLEAR_TPC_CLEAR_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_TPC_FLUSH_MASK 0x00000400U
#define EUR_CR_EVENT_HOST_CLEAR_TPC_FLUSH_SHIFT 10
#define EUR_CR_EVENT_HOST_CLEAR_TPC_FLUSH_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_CLEAR_MASK 0x00000200U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_CLEAR_SHIFT 9
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_CLEAR_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_LOAD_MASK 0x00000100U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_LOAD_SHIFT 8
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_STORE_MASK 0x00000080U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_STORE_SHIFT 7
#define EUR_CR_EVENT_HOST_CLEAR_DPM_CONTROL_STORE_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_CLEAR_MASK 0x00000040U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_CLEAR_SHIFT 6
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_CLEAR_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_LOAD_MASK 0x00000020U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_LOAD_SHIFT 5
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_LOAD_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_STORE_MASK 0x00000010U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_STORE_SHIFT 4
#define EUR_CR_EVENT_HOST_CLEAR_DPM_STATE_STORE_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_REACHED_MEM_THRESH_MASK 0x00000008U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_REACHED_MEM_THRESH_SHIFT 3
#define EUR_CR_EVENT_HOST_CLEAR_DPM_REACHED_MEM_THRESH_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_GBL_MASK 0x00000004U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_GBL_SHIFT 2
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_GBL_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_MT_MASK 0x00000002U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_MT_SHIFT 1
#define EUR_CR_EVENT_HOST_CLEAR_DPM_OUT_OF_MEMORY_MT_SIGNED 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_3D_MEM_FREE_MASK 0x00000001U
#define EUR_CR_EVENT_HOST_CLEAR_DPM_3D_MEM_FREE_SHIFT 0
#define EUR_CR_EVENT_HOST_CLEAR_DPM_3D_MEM_FREE_SIGNED 0
#define EUR_CR_TIMER                        0x0144
#define EUR_CR_TIMER_VALUE_MASK             0xFFFFFFFFU
#define EUR_CR_TIMER_VALUE_SHIFT            0
#define EUR_CR_TIMER_VALUE_SIGNED           0
#define EUR_CR_USE_CODE_BASE_0              0x0A0C
#define EUR_CR_USE_CODE_BASE_ADDR_00_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_00_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_00_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_00_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_00_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_00_SIGNED   0
#define EUR_CR_USE_CODE_BASE_1              0x0A10
#define EUR_CR_USE_CODE_BASE_ADDR_01_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_01_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_01_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_01_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_01_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_01_SIGNED   0
#define EUR_CR_USE_CODE_BASE_2              0x0A14
#define EUR_CR_USE_CODE_BASE_ADDR_02_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_02_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_02_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_02_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_02_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_02_SIGNED   0
#define EUR_CR_USE_CODE_BASE_3              0x0A18
#define EUR_CR_USE_CODE_BASE_ADDR_03_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_03_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_03_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_03_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_03_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_03_SIGNED   0
#define EUR_CR_USE_CODE_BASE_4              0x0A1C
#define EUR_CR_USE_CODE_BASE_ADDR_04_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_04_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_04_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_04_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_04_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_04_SIGNED   0
#define EUR_CR_USE_CODE_BASE_5              0x0A20
#define EUR_CR_USE_CODE_BASE_ADDR_05_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_05_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_05_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_05_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_05_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_05_SIGNED   0
#define EUR_CR_USE_CODE_BASE_6              0x0A24
#define EUR_CR_USE_CODE_BASE_ADDR_06_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_06_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_06_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_06_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_06_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_06_SIGNED   0
#define EUR_CR_USE_CODE_BASE_7              0x0A28
#define EUR_CR_USE_CODE_BASE_ADDR_07_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_07_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_07_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_07_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_07_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_07_SIGNED   0
#define EUR_CR_USE_CODE_BASE_8              0x0A2C
#define EUR_CR_USE_CODE_BASE_ADDR_08_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_08_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_08_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_08_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_08_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_08_SIGNED   0
#define EUR_CR_USE_CODE_BASE_9              0x0A30
#define EUR_CR_USE_CODE_BASE_ADDR_09_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_09_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_09_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_09_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_09_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_09_SIGNED   0
#define EUR_CR_USE_CODE_BASE_10             0x0A34
#define EUR_CR_USE_CODE_BASE_ADDR_10_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_10_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_10_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_10_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_10_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_10_SIGNED   0
#define EUR_CR_USE_CODE_BASE_11             0x0A38
#define EUR_CR_USE_CODE_BASE_ADDR_11_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_11_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_11_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_11_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_11_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_11_SIGNED   0
#define EUR_CR_USE_CODE_BASE_12             0x0A3C
#define EUR_CR_USE_CODE_BASE_ADDR_12_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_12_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_12_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_12_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_12_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_12_SIGNED   0
#define EUR_CR_USE_CODE_BASE_13             0x0A40
#define EUR_CR_USE_CODE_BASE_ADDR_13_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_13_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_13_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_13_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_13_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_13_SIGNED   0
#define EUR_CR_USE_CODE_BASE_14             0x0A44
#define EUR_CR_USE_CODE_BASE_ADDR_14_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_14_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_14_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_14_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_14_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_14_SIGNED   0
#define EUR_CR_USE_CODE_BASE_15             0x0A48
#define EUR_CR_USE_CODE_BASE_ADDR_15_MASK   0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_15_SHIFT  0
#define EUR_CR_USE_CODE_BASE_ADDR_15_SIGNED 0
#define EUR_CR_USE_CODE_BASE_DM_15_MASK     0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_15_SHIFT    25
#define EUR_CR_USE_CODE_BASE_DM_15_SIGNED   0
#define EUR_CR_PDS_EXEC_BASE                0x0AB8
#define EUR_CR_PDS_EXEC_BASE_ADDR_MASK      0xFFF00000U
#define EUR_CR_PDS_EXEC_BASE_ADDR_SHIFT     20
#define EUR_CR_PDS_EXEC_BASE_ADDR_SIGNED    0
#define EUR_CR_EVENT_KICKER                 0x0AC4
#define EUR_CR_EVENT_KICKER_ADDRESS_MASK    0xFFFFFFF0U
#define EUR_CR_EVENT_KICKER_ADDRESS_SHIFT   4
#define EUR_CR_EVENT_KICKER_ADDRESS_SIGNED  0
#define EUR_CR_EVENT_KICK                   0x0AC8
#define EUR_CR_EVENT_KICK_NOW_MASK          0x00000001U
#define EUR_CR_EVENT_KICK_NOW_SHIFT         0
#define EUR_CR_EVENT_KICK_NOW_SIGNED        0
#define EUR_CR_EVENT_TIMER                  0x0ACC
#define EUR_CR_EVENT_TIMER_ENABLE_MASK      0x01000000U
#define EUR_CR_EVENT_TIMER_ENABLE_SHIFT     24
#define EUR_CR_EVENT_TIMER_ENABLE_SIGNED    0
#define EUR_CR_EVENT_TIMER_VALUE_MASK       0x00FFFFFFU
#define EUR_CR_EVENT_TIMER_VALUE_SHIFT      0
#define EUR_CR_EVENT_TIMER_VALUE_SIGNED     0
#define EUR_CR_PDS_INV0                     0x0AD0
#define EUR_CR_PDS_INV0_DSC_MASK            0x00000001U
#define EUR_CR_PDS_INV0_DSC_SHIFT           0
#define EUR_CR_PDS_INV0_DSC_SIGNED          0
#define EUR_CR_PDS_INV1                     0x0AD4
#define EUR_CR_PDS_INV1_DSC_MASK            0x00000001U
#define EUR_CR_PDS_INV1_DSC_SHIFT           0
#define EUR_CR_PDS_INV1_DSC_SIGNED          0
#define EUR_CR_PDS_INV3                     0x0AD8
#define EUR_CR_PDS_INV3_DSC_MASK            0x00000001U
#define EUR_CR_PDS_INV3_DSC_SHIFT           0
#define EUR_CR_PDS_INV3_DSC_SIGNED          0
#define EUR_CR_PDS_INV_CSC                  0x0AE0
#define EUR_CR_PDS_INV_CSC_KICK_MASK        0x00000001U
#define EUR_CR_PDS_INV_CSC_KICK_SHIFT       0
#define EUR_CR_PDS_INV_CSC_KICK_SIGNED      0
#define EUR_CR_EVENT_KICK1                  0x0AE4
#define EUR_CR_EVENT_KICK1_NOW_MASK         0x000000FFU
#define EUR_CR_EVENT_KICK1_NOW_SHIFT        0
#define EUR_CR_EVENT_KICK1_NOW_SIGNED       0
#define EUR_CR_EVENT_KICK2                  0x0AE8
#define EUR_CR_EVENT_KICK2_NOW_MASK         0x00000001U
#define EUR_CR_EVENT_KICK2_NOW_SHIFT        0
#define EUR_CR_EVENT_KICK2_NOW_SIGNED       0
#define EUR_CR_EVENT_KICK3                  0x0AEC
#define EUR_CR_EVENT_KICK3_NOW_MASK         0x00000001U
#define EUR_CR_EVENT_KICK3_NOW_SHIFT        0
#define EUR_CR_EVENT_KICK3_NOW_SIGNED       0
#define EUR_CR_BIF_CTRL                     0x0C00
#define EUR_CR_BIF_CTRL_NOREORDER_MASK      0x00000001U
#define EUR_CR_BIF_CTRL_NOREORDER_SHIFT     0
#define EUR_CR_BIF_CTRL_NOREORDER_SIGNED    0
#define EUR_CR_BIF_CTRL_PAUSE_MASK          0x00000002U
#define EUR_CR_BIF_CTRL_PAUSE_SHIFT         1
#define EUR_CR_BIF_CTRL_PAUSE_SIGNED        0
#define EUR_CR_BIF_CTRL_FLUSH_MASK          0x00000004U
#define EUR_CR_BIF_CTRL_FLUSH_SHIFT         2
#define EUR_CR_BIF_CTRL_FLUSH_SIGNED        0
#define EUR_CR_BIF_CTRL_INVALDC_MASK        0x00000008U
#define EUR_CR_BIF_CTRL_INVALDC_SHIFT       3
#define EUR_CR_BIF_CTRL_INVALDC_SIGNED      0
#define EUR_CR_BIF_CTRL_CLEAR_FAULT_MASK    0x00000010U
#define EUR_CR_BIF_CTRL_CLEAR_FAULT_SHIFT   4
#define EUR_CR_BIF_CTRL_CLEAR_FAULT_SIGNED  0
#define EUR_CR_BIF_CTRL_MMU_BYPASS_CACHE_MASK 0x00000100U
#define EUR_CR_BIF_CTRL_MMU_BYPASS_CACHE_SHIFT 8
#define EUR_CR_BIF_CTRL_MMU_BYPASS_CACHE_SIGNED 0
#define EUR_CR_BIF_CTRL_MMU_BYPASS_VDM_MASK 0x00000200U
#define EUR_CR_BIF_CTRL_MMU_BYPASS_VDM_SHIFT 9
#define EUR_CR_BIF_CTRL_MMU_BYPASS_VDM_SIGNED 0
#define EUR_CR_BIF_CTRL_MMU_BYPASS_TE_MASK  0x00000400U
#define EUR_CR_BIF_CTRL_MMU_BYPASS_TE_SHIFT 10
#define EUR_CR_BIF_CTRL_MMU_BYPASS_TE_SIGNED 0
#define EUR_CR_BIF_CTRL_MMU_BYPASS_PBE_MASK 0x00000800U
#define EUR_CR_BIF_CTRL_MMU_BYPASS_PBE_SHIFT 11
#define EUR_CR_BIF_CTRL_MMU_BYPASS_PBE_SIGNED 0
#define EUR_CR_BIF_CTRL_MMU_BYPASS_TSPP_MASK 0x00001000U
#define EUR_CR_BIF_CTRL_MMU_BYPASS_TSPP_SHIFT 12
#define EUR_CR_BIF_CTRL_MMU_BYPASS_TSPP_SIGNED 0
#define EUR_CR_BIF_CTRL_MMU_BYPASS_ISP_MASK 0x00002000U
#define EUR_CR_BIF_CTRL_MMU_BYPASS_ISP_SHIFT 13
#define EUR_CR_BIF_CTRL_MMU_BYPASS_ISP_SIGNED 0
#define EUR_CR_BIF_CTRL_MMU_BYPASS_USE_MASK 0x00004000U
#define EUR_CR_BIF_CTRL_MMU_BYPASS_USE_SHIFT 14
#define EUR_CR_BIF_CTRL_MMU_BYPASS_USE_SIGNED 0
#define EUR_CR_BIF_CTRL_MMU_BYPASS_HOST_MASK 0x00008000U
#define EUR_CR_BIF_CTRL_MMU_BYPASS_HOST_SHIFT 15
#define EUR_CR_BIF_CTRL_MMU_BYPASS_HOST_SIGNED 0
#define EUR_CR_BIF_INT_STAT                 0x0C04
#define EUR_CR_BIF_INT_STAT_FAULT_REQ_MASK  0x0000FFFFU
#define EUR_CR_BIF_INT_STAT_FAULT_REQ_SHIFT 0
#define EUR_CR_BIF_INT_STAT_FAULT_REQ_SIGNED 0
#define EUR_CR_BIF_INT_STAT_FAULT_TYPE_MASK 0x00070000U
#define EUR_CR_BIF_INT_STAT_FAULT_TYPE_SHIFT 16
#define EUR_CR_BIF_INT_STAT_FAULT_TYPE_SIGNED 0
#define EUR_CR_BIF_INT_STAT_FLUSH_COMPLETE_MASK 0x00080000U
#define EUR_CR_BIF_INT_STAT_FLUSH_COMPLETE_SHIFT 19
#define EUR_CR_BIF_INT_STAT_FLUSH_COMPLETE_SIGNED 0
#define EUR_CR_BIF_FAULT                    0x0C08
#define EUR_CR_BIF_FAULT_CID_MASK           0x0000000FU
#define EUR_CR_BIF_FAULT_CID_SHIFT          0
#define EUR_CR_BIF_FAULT_CID_SIGNED         0
#define EUR_CR_BIF_FAULT_SB_MASK            0x000001F0U
#define EUR_CR_BIF_FAULT_SB_SHIFT           4
#define EUR_CR_BIF_FAULT_SB_SIGNED          0
#define EUR_CR_BIF_FAULT_ADDR_MASK          0xFFFFF000U
#define EUR_CR_BIF_FAULT_ADDR_SHIFT         12
#define EUR_CR_BIF_FAULT_ADDR_SIGNED        0
#define EUR_CR_BIF_TILE0                    0x0C0C
#define EUR_CR_BIF_TILE0_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE0_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE0_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE0_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE0_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE0_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE0_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE0_CFG_SHIFT          24
#define EUR_CR_BIF_TILE0_CFG_SIGNED         0
#define EUR_CR_BIF_TILE1                    0x0C10
#define EUR_CR_BIF_TILE1_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE1_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE1_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE1_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE1_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE1_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE1_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE1_CFG_SHIFT          24
#define EUR_CR_BIF_TILE1_CFG_SIGNED         0
#define EUR_CR_BIF_TILE2                    0x0C14
#define EUR_CR_BIF_TILE2_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE2_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE2_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE2_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE2_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE2_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE2_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE2_CFG_SHIFT          24
#define EUR_CR_BIF_TILE2_CFG_SIGNED         0
#define EUR_CR_BIF_TILE3                    0x0C18
#define EUR_CR_BIF_TILE3_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE3_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE3_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE3_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE3_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE3_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE3_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE3_CFG_SHIFT          24
#define EUR_CR_BIF_TILE3_CFG_SIGNED         0
#define EUR_CR_BIF_TILE4                    0x0C1C
#define EUR_CR_BIF_TILE4_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE4_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE4_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE4_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE4_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE4_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE4_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE4_CFG_SHIFT          24
#define EUR_CR_BIF_TILE4_CFG_SIGNED         0
#define EUR_CR_BIF_TILE5                    0x0C20
#define EUR_CR_BIF_TILE5_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE5_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE5_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE5_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE5_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE5_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE5_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE5_CFG_SHIFT          24
#define EUR_CR_BIF_TILE5_CFG_SIGNED         0
#define EUR_CR_BIF_TILE6                    0x0C24
#define EUR_CR_BIF_TILE6_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE6_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE6_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE6_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE6_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE6_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE6_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE6_CFG_SHIFT          24
#define EUR_CR_BIF_TILE6_CFG_SIGNED         0
#define EUR_CR_BIF_TILE7                    0x0C28
#define EUR_CR_BIF_TILE7_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE7_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE7_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE7_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE7_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE7_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE7_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE7_CFG_SHIFT          24
#define EUR_CR_BIF_TILE7_CFG_SIGNED         0
#define EUR_CR_BIF_TILE8                    0x0C2C
#define EUR_CR_BIF_TILE8_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE8_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE8_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE8_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE8_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE8_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE8_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE8_CFG_SHIFT          24
#define EUR_CR_BIF_TILE8_CFG_SIGNED         0
#define EUR_CR_BIF_TILE9                    0x0C30
#define EUR_CR_BIF_TILE9_MIN_ADDRESS_MASK   0x00000FFFU
#define EUR_CR_BIF_TILE9_MIN_ADDRESS_SHIFT  0
#define EUR_CR_BIF_TILE9_MIN_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE9_MAX_ADDRESS_MASK   0x00FFF000U
#define EUR_CR_BIF_TILE9_MAX_ADDRESS_SHIFT  12
#define EUR_CR_BIF_TILE9_MAX_ADDRESS_SIGNED 0
#define EUR_CR_BIF_TILE9_CFG_MASK           0x0F000000U
#define EUR_CR_BIF_TILE9_CFG_SHIFT          24
#define EUR_CR_BIF_TILE9_CFG_SIGNED         0
#define EUR_CR_BIF_DIR_LIST_BASE1           0x0C38
#define EUR_CR_BIF_DIR_LIST_BASE1_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE1_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE1_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE2           0x0C3C
#define EUR_CR_BIF_DIR_LIST_BASE2_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE2_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE2_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE3           0x0C40
#define EUR_CR_BIF_DIR_LIST_BASE3_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE3_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE3_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE4           0x0C44
#define EUR_CR_BIF_DIR_LIST_BASE4_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE4_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE4_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE5           0x0C48
#define EUR_CR_BIF_DIR_LIST_BASE5_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE5_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE5_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE6           0x0C4C
#define EUR_CR_BIF_DIR_LIST_BASE6_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE6_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE6_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE7           0x0C50
#define EUR_CR_BIF_DIR_LIST_BASE7_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE7_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE7_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE8           0x0C54
#define EUR_CR_BIF_DIR_LIST_BASE8_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE8_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE8_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE9           0x0C58
#define EUR_CR_BIF_DIR_LIST_BASE9_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE9_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE9_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE10          0x0C5C
#define EUR_CR_BIF_DIR_LIST_BASE10_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE10_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE10_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE11          0x0C60
#define EUR_CR_BIF_DIR_LIST_BASE11_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE11_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE11_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE12          0x0C64
#define EUR_CR_BIF_DIR_LIST_BASE12_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE12_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE12_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE13          0x0C68
#define EUR_CR_BIF_DIR_LIST_BASE13_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE13_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE13_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE14          0x0C6C
#define EUR_CR_BIF_DIR_LIST_BASE14_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE14_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE14_ADDR_SIGNED 0
#define EUR_CR_BIF_DIR_LIST_BASE15          0x0C70
#define EUR_CR_BIF_DIR_LIST_BASE15_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE15_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE15_ADDR_SIGNED 0
#define EUR_CR_BIF_BANK_SET                 0x0C74
#define EUR_CR_BIF_BANK_SET_SELECT_2D_MASK  0x00000001U
#define EUR_CR_BIF_BANK_SET_SELECT_2D_SHIFT 0
#define EUR_CR_BIF_BANK_SET_SELECT_2D_SIGNED 0
#define EUR_CR_BIF_BANK_SET_SELECT_3D_MASK  0x0000000CU
#define EUR_CR_BIF_BANK_SET_SELECT_3D_SHIFT 2
#define EUR_CR_BIF_BANK_SET_SELECT_3D_SIGNED 0
#define EUR_CR_BIF_BANK_SET_SELECT_HOST_MASK 0x00000010U
#define EUR_CR_BIF_BANK_SET_SELECT_HOST_SHIFT 4
#define EUR_CR_BIF_BANK_SET_SELECT_HOST_SIGNED 0
#define EUR_CR_BIF_BANK_SET_SELECT_TA_MASK  0x000000C0U
#define EUR_CR_BIF_BANK_SET_SELECT_TA_SHIFT 6
#define EUR_CR_BIF_BANK_SET_SELECT_TA_SIGNED 0
#define EUR_CR_BIF_BANK_SET_SELECT_EDM_MASK 0x00000100U
#define EUR_CR_BIF_BANK_SET_SELECT_EDM_SHIFT 8
#define EUR_CR_BIF_BANK_SET_SELECT_EDM_SIGNED 0
#define EUR_CR_BIF_BANK_SET_SELECT_DPM_LSS_MASK 0x00000200U
#define EUR_CR_BIF_BANK_SET_SELECT_DPM_LSS_SHIFT 9
#define EUR_CR_BIF_BANK_SET_SELECT_DPM_LSS_SIGNED 0
#define EUR_CR_BIF_BANK0                    0x0C78
#define EUR_CR_BIF_BANK0_INDEX_EDM_MASK     0x0000000FU
#define EUR_CR_BIF_BANK0_INDEX_EDM_SHIFT    0
#define EUR_CR_BIF_BANK0_INDEX_EDM_SIGNED   0
#define EUR_CR_BIF_BANK0_INDEX_TA_MASK      0x000000F0U
#define EUR_CR_BIF_BANK0_INDEX_TA_SHIFT     4
#define EUR_CR_BIF_BANK0_INDEX_TA_SIGNED    0
#define EUR_CR_BIF_BANK0_INDEX_HOST_MASK    0x00000F00U
#define EUR_CR_BIF_BANK0_INDEX_HOST_SHIFT   8
#define EUR_CR_BIF_BANK0_INDEX_HOST_SIGNED  0
#define EUR_CR_BIF_BANK0_INDEX_3D_MASK      0x0000F000U
#define EUR_CR_BIF_BANK0_INDEX_3D_SHIFT     12
#define EUR_CR_BIF_BANK0_INDEX_3D_SIGNED    0
#define EUR_CR_BIF_BANK0_INDEX_2D_MASK      0x000F0000U
#define EUR_CR_BIF_BANK0_INDEX_2D_SHIFT     16
#define EUR_CR_BIF_BANK0_INDEX_2D_SIGNED    0
#define EUR_CR_BIF_BANK1                    0x0C7C
#define EUR_CR_BIF_BANK1_INDEX_EDM_MASK     0x0000000FU
#define EUR_CR_BIF_BANK1_INDEX_EDM_SHIFT    0
#define EUR_CR_BIF_BANK1_INDEX_EDM_SIGNED   0
#define EUR_CR_BIF_BANK1_INDEX_TA_MASK      0x000000F0U
#define EUR_CR_BIF_BANK1_INDEX_TA_SHIFT     4
#define EUR_CR_BIF_BANK1_INDEX_TA_SIGNED    0
#define EUR_CR_BIF_BANK1_INDEX_HOST_MASK    0x00000F00U
#define EUR_CR_BIF_BANK1_INDEX_HOST_SHIFT   8
#define EUR_CR_BIF_BANK1_INDEX_HOST_SIGNED  0
#define EUR_CR_BIF_BANK1_INDEX_3D_MASK      0x0000F000U
#define EUR_CR_BIF_BANK1_INDEX_3D_SHIFT     12
#define EUR_CR_BIF_BANK1_INDEX_3D_SIGNED    0
#define EUR_CR_BIF_BANK1_INDEX_2D_MASK      0x000F0000U
#define EUR_CR_BIF_BANK1_INDEX_2D_SHIFT     16
#define EUR_CR_BIF_BANK1_INDEX_2D_SIGNED    0
#define EUR_CR_BIF_DIR_LIST_BASE0           0x0C84
#define EUR_CR_BIF_DIR_LIST_BASE0_ADDR_MASK 0xFFFFFF00U
#define EUR_CR_BIF_DIR_LIST_BASE0_ADDR_SHIFT 8
#define EUR_CR_BIF_DIR_LIST_BASE0_ADDR_SIGNED 0
#define EUR_CR_BIF_TA_REQ_BASE              0x0C90
#define EUR_CR_BIF_TA_REQ_BASE_ADDR_MASK    0xFFF00000U
#define EUR_CR_BIF_TA_REQ_BASE_ADDR_SHIFT   20
#define EUR_CR_BIF_TA_REQ_BASE_ADDR_SIGNED  0
#define EUR_CR_BIF_MEM_REQ_STAT             0x0CA8
#define EUR_CR_BIF_MEM_REQ_STAT_READS_MASK  0x000007FFU
#define EUR_CR_BIF_MEM_REQ_STAT_READS_SHIFT 0
#define EUR_CR_BIF_MEM_REQ_STAT_READS_SIGNED 0
#define EUR_CR_BIF_3D_REQ_BASE              0x0CAC
#define EUR_CR_BIF_3D_REQ_BASE_ADDR_MASK    0xFFF00000U
#define EUR_CR_BIF_3D_REQ_BASE_ADDR_SHIFT   20
#define EUR_CR_BIF_3D_REQ_BASE_ADDR_SIGNED  0
#define EUR_CR_BIF_ZLS_REQ_BASE             0x0CB0
#define EUR_CR_BIF_ZLS_REQ_BASE_ADDR_MASK   0xFFF00000U
#define EUR_CR_BIF_ZLS_REQ_BASE_ADDR_SHIFT  20
#define EUR_CR_BIF_ZLS_REQ_BASE_ADDR_SIGNED 0
#define EUR_CR_BIF_BANK_STATUS              0x0CB4
#define EUR_CR_BIF_BANK_STATUS_3D_CURRENT_BANK_MASK 0x00000001U
#define EUR_CR_BIF_BANK_STATUS_3D_CURRENT_BANK_SHIFT 0
#define EUR_CR_BIF_BANK_STATUS_3D_CURRENT_BANK_SIGNED 0
#define EUR_CR_BIF_BANK_STATUS_TA_CURRENT_BANK_MASK 0x00000002U
#define EUR_CR_BIF_BANK_STATUS_TA_CURRENT_BANK_SHIFT 1
#define EUR_CR_BIF_BANK_STATUS_TA_CURRENT_BANK_SIGNED 0
#define EUR_CR_BIF_36BIT_ADDRESSING         0x0CCC
#define EUR_CR_BIF_36BIT_ADDRESSING_ENABLE_MASK 0x00000001U
#define EUR_CR_BIF_36BIT_ADDRESSING_ENABLE_SHIFT 0
#define EUR_CR_BIF_36BIT_ADDRESSING_ENABLE_SIGNED 0
#define EUR_CR_BIF_TILE0_ADDR_EXT           0x0CD0
#define EUR_CR_BIF_TILE0_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE0_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE0_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE0_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE0_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE0_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE1_ADDR_EXT           0x0CD4
#define EUR_CR_BIF_TILE1_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE1_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE1_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE1_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE1_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE1_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE2_ADDR_EXT           0x0CD8
#define EUR_CR_BIF_TILE2_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE2_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE2_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE2_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE2_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE2_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE3_ADDR_EXT           0x0CDC
#define EUR_CR_BIF_TILE3_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE3_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE3_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE3_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE3_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE3_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE4_ADDR_EXT           0x0CE0
#define EUR_CR_BIF_TILE4_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE4_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE4_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE4_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE4_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE4_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE5_ADDR_EXT           0x0CE4
#define EUR_CR_BIF_TILE5_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE5_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE5_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE5_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE5_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE5_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE6_ADDR_EXT           0x0CE8
#define EUR_CR_BIF_TILE6_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE6_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE6_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE6_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE6_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE6_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE7_ADDR_EXT           0x0CEC
#define EUR_CR_BIF_TILE7_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE7_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE7_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE7_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE7_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE7_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE8_ADDR_EXT           0x0CF0
#define EUR_CR_BIF_TILE8_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE8_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE8_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE8_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE8_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE8_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_TILE9_ADDR_EXT           0x0CF4
#define EUR_CR_BIF_TILE9_ADDR_EXT_MIN_MASK  0x000000FFU
#define EUR_CR_BIF_TILE9_ADDR_EXT_MIN_SHIFT 0
#define EUR_CR_BIF_TILE9_ADDR_EXT_MIN_SIGNED 0
#define EUR_CR_BIF_TILE9_ADDR_EXT_MAX_MASK  0x0000FF00U
#define EUR_CR_BIF_TILE9_ADDR_EXT_MAX_SHIFT 8
#define EUR_CR_BIF_TILE9_ADDR_EXT_MAX_SIGNED 0
#define EUR_CR_BIF_CTRL_RDATA               0x0CF8
#define EUR_CR_BIF_CTRL_RDATA_LIMIT_MASK    0x000003FFU
#define EUR_CR_BIF_CTRL_RDATA_LIMIT_SHIFT   0
#define EUR_CR_BIF_CTRL_RDATA_LIMIT_SIGNED  0
#define EUR_CR_USE_CODE_BASE(X)     (0x0A0C + (4 * (X)))
#define EUR_CR_USE_CODE_BASE_ADDR_MASK      0x01FFFFFFU
#define EUR_CR_USE_CODE_BASE_ADDR_SHIFT     0
#define EUR_CR_USE_CODE_BASE_ADDR_SIGNED    0
#define EUR_CR_USE_CODE_BASE_DM_MASK        0x06000000U
#define EUR_CR_USE_CODE_BASE_DM_SHIFT       25
#define EUR_CR_USE_CODE_BASE_DM_SIGNED      0
#define EUR_CR_USE_CODE_BASE_SIZE_UINT32 16
#define EUR_CR_USE_CODE_BASE_NUM_ENTRIES 16

#endif 

