
var
    Option_Version : Boolean = False;
    Option_Help    : Boolean = False;
    Option_Struct  : Boolean = False;
    Option_Long    : Boolean = False;
    Option_Terse   : Boolean = False;

    ReadMeFile : Text;

// get debian package version from it's changelog
function GetVersion (Package : String) : String;
var OK : Boolean;
    S1 : String;

begin
    OK := RunCommand('/usr/bin/dpkg-parsechangelog', ['-l', '/usr/share/doc/' + Package, '--show-field', 'Version'],
        S1,  [poUsePipes, poWaitOnExit]);

    If OK then
        result := TrimRight(S1)
    else
        result := '';
end;


Procedure ShowVersions;
begin
    Writeln (' Versions: recon ' + (GetVersion('licenserecon/changelog.gz'))
          + '  check ' + (GetVersion('licensecheck/changelog.Debian.gz')));
end;


Procedure ShowHelp;
var line   : String;
begin
    OpenFile ('/usr/share/doc/licenserecon/ReadMe', ReadMeFile);

    While not EOF (ReadMeFile) Do
    begin
        Readln (ReadMeFile, Line);
        Writeln (Line);
    end;
end;


procedure CheckParam (P : String);
begin
    if (CompareText (P, '-v') = 0) or (CompareText (P, '--version') = 0) then
        Option_Version := true
    else if (CompareText (P, '-h') = 0) or (CompareText (P, '-?') = 0) or (CompareText (P, '--help') = 0) then
        Option_Help := True
    else if (CompareText (P, '-s') = 0) or (CompareText (P, '--struct') = 0) then
        Option_Struct := true
    else if (CompareText (P, '-t') = 0) or (CompareText (P, '--terse') = 0) then
        Option_Terse   := true
    else if (CompareText (P, '-l') = 0) or (CompareText (P, '--long') = 0) then
        Option_Long := true
    else
        Writeln ('Ignoring unknown option/command ', P);
end;


procedure GetOptions;
var P : Integer;
begin
    // Defaults
    Option_Version := False;
    Option_Help    := False;
    Option_Struct  := False;
    Option_Terse   := False;
    Option_Long    := False;

    for P := 1 to ParamCount do
        CheckParam (ParamStr(P));

    // Some combinations make no sense
    if Option_Terse then
        Option_Long := False;
end;
