/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "vpntypesinfodialog.h"

#include <QtGui/QCursor>
#include <QtGui/QPixmap>
#include <QtCore/QString>
#include <QtGui/QToolTip>
#include <QList>
#include <QTreeWidget>
#include <QTreeWidgetItem>

#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include "utils.h"

VpnTypesInfoDialog::VpnTypesInfoDialog(KVpncConfig *GlobalConfig, QWidget *parent, const char *) : KDialog(parent)
{
    QWidget *page = new QWidget(this);
    ToolsInfoWidget = new Ui_ToolsInfoWidgetBase();
    ToolsInfoWidget->setupUi(page);
    setMainWidget(page);
    ToolsInfoWidget->InfoListView->setMinimumSize(ToolsInfoWidget->InfoListView->sizeHint());
    ToolsInfoWidget->InfoListView->setColumnCount(4);
    QStringList LabelList;
    LabelList << i18n("VPN type") << i18n("State") << i18n("Requirements") << i18n("Comment");
    ToolsInfoWidget->InfoListView->setHeaderLabels(LabelList);
    ToolsInfoWidget->textLabel1->setText(i18n("The following information about the VPN tyes has been collected:"));

    QIcon ok_icon = QIcon(KIconLoader::global() ->loadIcon("dialog-ok-apply", KIconLoader::NoGroup, 16));
    QIcon wrong_icon = QIcon(KIconLoader::global() ->loadIcon("dialog-close", KIconLoader::NoGroup, 16));

    VpnTypesInfoList = new QList<VpnTypeInfo*>();
    VpnTypeInfo *it;
    QTreeWidgetItem *item;
    QStringList RequirementsList;
    QString RequirementsString;
    QString tipStr;

    GlobalConfig->appPointer->setOverrideCursor(QCursor(Qt::WaitCursor));

    Utils UtilsInstance(GlobalConfig);
    QList<QTreeWidgetItem *> items;
    QStringList values;

    it = new VpnTypeInfo();
    it->VpnType = "cisco";
    it->Name = i18n("Cisco VPN");
    it->Requirements.append("vpnc / vpnclient");

    bool vpnc_found = UtilsInstance.getToolInfo("vpnc")->found;
    bool vpnclient_found = UtilsInstance.getToolInfo("vpnclient")->found;

    if (vpnc_found || vpnclient_found) {
        it->VpnState = true;
        it->state = i18n("All tools found");
    } else {
        it->VpnState = false;
        it->state = i18n("Some tools missing");
    }

    if (vpnc_found && !vpnclient_found) {
        it->Comment += i18n("no certificate support");
    }
    if (vpnc_found && vpnclient_found) {
        it->Comment += i18n("certificate support only with vpnclient (original Cisco client)");
    }
	if (vpnc_found ) {
		it->Comment += ", "+i18n("hybrid support only if vpnc compiled with OpenSSL support");
	}
    values.clear();
    values << it->VpnType << it->state << it->Requirements.join(" " + i18n("and") + " ") << it->Comment;
    item = new QTreeWidgetItem((QTreeWidget*)0, values);

    RequirementsList = it->Requirements.join(" " + i18n("and") + " ").split(",", QString::KeepEmptyParts);
    RequirementsString = "<ul>";
    for (QStringList::Iterator it = RequirementsList.begin(); it != RequirementsList.end(); ++it)
        RequirementsString += "<li>" + *it + "</li>";
    RequirementsString += "</ul>";
    tipStr = QString("<h2>" + it->VpnType + "</h2><ul><li>" + i18n("Requirements:") + " " + RequirementsString + "</li><li>" + i18n("Comment:") + " " + it->Comment + "</li></ul>");

    item->setToolTip(0, tipStr);
    item->setToolTip(1, tipStr);
    item->setToolTip(2, tipStr);
    item->setToolTip(3, tipStr);
    item->setToolTip(4, tipStr);
    item->setToolTip(5, tipStr);
    item->setToolTip(6, tipStr);

    if (it->VpnState == true)
        item->setIcon(0, ok_icon);
    else
        item->setIcon(0, wrong_icon);
    items.append(item);

    VpnTypesInfoList->append(it);

    it = new VpnTypeInfo();
    it->VpnType = "ipsec";
    it->Name = i18n("IPsec VPN");
    it->Requirements.append("Openswan / strongSwan / FreeS/Wan / ipsec-tools");

    bool ipsec_found = UtilsInstance.getToolInfo("ipsec")->found;
    bool racoon_found = UtilsInstance.getToolInfo("racoon")->found;


    if (ipsec_found || racoon_found) {
        it->VpnState = true;
        it->state = i18n("All tools found");
    } else {
        it->VpnState = false;
        it->state = i18n("Some tools missing");
    }

    if (ipsec_found && (!UtilsInstance.getToolInfo("ipsec")->Version.contains("Openswan") && !UtilsInstance.getToolInfo("ipsec")->Version.contains("strongswan"))) {
        it->Comment += i18n("FreeS/WAN detected, please upgrade to Openswan/strongSwan");
    }
    if (ipsec_found && UtilsInstance.getToolInfo("ipsec")->Version.contains("Openswan")) {
        it->Comment += i18n("Openswan detected, no smartcard support");
    }
    if (ipsec_found && UtilsInstance.getToolInfo("ipsec")->Version.contains("strongswan")) {
        it->Comment += i18n("%1 detected", i18n("strongSwan"));
    }

    values.clear();
    values << it->VpnType << it->state << it->Requirements.join(" " + i18n("and") + " ") << it->Comment;
    item = new QTreeWidgetItem((QTreeWidget*)0, values);

    RequirementsList = it->Requirements.join(" " + i18n("and") + " ").split(",", QString::KeepEmptyParts);
    RequirementsString = "<ul>";
    for (QStringList::Iterator it = RequirementsList.begin(); it != RequirementsList.end(); ++it)
        RequirementsString += "<li>" + *it + "</li>";
    RequirementsString += "</ul>";
    tipStr = QString("<h2>" + it->VpnType + "</h2><ul><li>" + i18n("Requirements:") + " " + RequirementsString + "</li><li>" + i18n("Comment:") + " " + it->Comment + "</li></ul>");

    item->setToolTip(0, tipStr);
    item->setToolTip(1, tipStr);
    item->setToolTip(2, tipStr);
    item->setToolTip(3, tipStr);
    item->setToolTip(4, tipStr);
    item->setToolTip(5, tipStr);
    item->setToolTip(6, tipStr);

    if (it->VpnState == true)
        item->setIcon(0, ok_icon);
    else
        item->setIcon(0, wrong_icon);
    items.append(item);


    VpnTypesInfoList->append(it);

    it = new VpnTypeInfo();
    it->VpnType = "pptp";
    it->Name = i18n("Microsoft PPTP VPN");
    it->Requirements.append("pptpclient");
    it->Requirements.append("pppd");
    it->Requirements.append(i18n("MPPE extensions in kernel"));
    bool pptpd_found = UtilsInstance.getToolInfo("pptp")->found;
    bool pppd_found = UtilsInstance.getToolInfo("pppd")->found;

    Utils::PppdCapabilities pppdcap = UtilsInstance.checkPppdCapabilities();

    if (pppd_found && pptpd_found && (pppdcap.pppdHasMppeRequiredSupport || pppdcap.pppdHasRequireMppeSupport)) {
        it->VpnState = true;
        it->state = i18n("All tools found");
    } else {
        it->VpnState = false;
        it->state = i18n("Some tools missing");
    }

    if (pptpd_found && !pppd_found) {
        it->Comment += i18n("pppd is missing");
    }
    if (!pptpd_found && pppd_found) {
        it->Comment += i18n("pptpclient is missing");
    }

    if (!pptpd_found && !pppd_found) {
        it->Comment += i18n("pptpclient and pppd are missing");
    }

    if (!it->Comment.isEmpty())
        it->Comment += ", ";
    if (!pppdcap.pppdHasMppeRequiredSupport && !pppdcap.pppdHasRequireMppeSupport)
        it->Comment += i18n("MPPE support is missing");

    values.clear();
    values << it->VpnType << it->state << it->Requirements.join(" " + i18n("and") + " ") << it->Comment;
    item = new QTreeWidgetItem((QTreeWidget*)0, values);

    RequirementsList = it->Requirements.join(" " + i18n("and") + " ").split(",", QString::KeepEmptyParts);
    RequirementsString = "<ul>";
    for (QStringList::Iterator it = RequirementsList.begin(); it != RequirementsList.end(); ++it)
        RequirementsString += "<li>" + *it + "</li>";
    RequirementsString += "</ul>";
    tipStr = QString("<h2>" + it->VpnType + "</h2><ul><li>" + i18n("Requirements:") + " " + RequirementsString + "</li><li>" + i18n("Comment:") + " " + it->Comment + "</li></ul>");

    item->setToolTip(0, tipStr);
    item->setToolTip(1, tipStr);
    item->setToolTip(2, tipStr);
    item->setToolTip(3, tipStr);
    item->setToolTip(4, tipStr);
    item->setToolTip(5, tipStr);
    item->setToolTip(6, tipStr);

    if (it->VpnState == true)
        item->setIcon(0, ok_icon);
    else
        item->setIcon(0, wrong_icon);
    items.append(item);

    VpnTypesInfoList->append(it);

    it = new VpnTypeInfo();
    it->VpnType = "openvpn";
    it->Name = i18n("OpenVPN SSL-VPN");
    it->Requirements.append("openvpn");
    it->Requirements.append("openssl");

    bool openvpn_found = UtilsInstance.getToolInfo("openvpn")->found;
    bool openssl_found = UtilsInstance.getToolInfo("openvpn")->found;

    if (openvpn_found && openssl_found) {
        it->VpnState = true;
        it->state = i18n("All tools found");
    } else {
        it->VpnState = false;
        it->state = i18n("Some tools missing");
    }
    if (!openvpn_found && openssl_found) {
        it->Comment += i18n("openvpn is missing");
    }
    if (openvpn_found && !openssl_found) {
        it->Comment += i18n("openssl is missing");
    }
    if (!openvpn_found && !openssl_found) {
        it->Comment += i18n("openvpn and openssl are missing");
    }

    values.clear();
    values << it->VpnType << it->state << it->Requirements.join(" " + i18n("and") + " ") << it->Comment;
    item = new QTreeWidgetItem((QTreeWidget*)0, values);

    RequirementsList = it->Requirements.join(" " + i18n("and") + " ").split(",", QString::KeepEmptyParts);
    RequirementsString = "<ul>";
    for (QStringList::Iterator it = RequirementsList.begin(); it != RequirementsList.end(); ++it)
        RequirementsString += "<li>" + *it + "</li>";
    RequirementsString += "</ul>";
    tipStr = QString("<h2>" + it->VpnType + "</h2><ul><li>" + i18n("Requirements:") + " " + RequirementsString + "</li><li>" + i18n("Comment:") + " " + it->Comment + "</li></ul>");

    item->setToolTip(0, tipStr);
    item->setToolTip(1, tipStr);
    item->setToolTip(2, tipStr);
    item->setToolTip(3, tipStr);
    item->setToolTip(4, tipStr);
    item->setToolTip(5, tipStr);
    item->setToolTip(6, tipStr);

    if (it->VpnState == true)
        item->setIcon(0, ok_icon);
    else
        item->setIcon(0, wrong_icon);
    items.append(item);


    VpnTypesInfoList->append(it);

    it = new VpnTypeInfo();
    it->VpnType = "l2tpd_ipsec";
    it->Name = i18n("L2TP over IPSec");
    it->Requirements.append("Openswan / strongSwan / FreeS/Wan / ipsec-tools");
    it->Requirements.append("l2tpd / xl2tpd / openl2tp");

    ipsec_found = UtilsInstance.getToolInfo("ipsec")->found;
    racoon_found = UtilsInstance.getToolInfo("racoon")->found;
    bool l2tpd_found = UtilsInstance.getToolInfo("l2tpd")->found;
    bool xl2tpd_found = UtilsInstance.getToolInfo("xl2tpd")->found;
    bool openl2tp_found = UtilsInstance.getToolInfo("openl2tpd")->found;


    if ((ipsec_found || racoon_found) && (l2tpd_found || xl2tpd_found || openl2tp_found)) {
        it->VpnState = true;
        it->state = i18n("All tools found");
    } else {
        it->VpnState = false;
        it->state = i18n("Some tools missing");
    }

    if (ipsec_found && (!UtilsInstance.getToolInfo("ipsec")->Version.contains("Openswan") && !UtilsInstance.getToolInfo("ipsec")->Version.contains("strongswan"))) {
        it->Comment += i18n("FreeS/WAN detected, please upgrade to Openswan/strongSwan");
    }
    if (ipsec_found && UtilsInstance.getToolInfo("ipsec")->Version.contains("Openswan")) {
        it->Comment += i18n("Openswan detected, no smartcard support");
    }
    if (ipsec_found && UtilsInstance.getToolInfo("ipsec")->Version.contains("strongswan")) {
        it->Comment += i18n("%1 detected", i18n("strongSwan"));
    }

    if (l2tpd_found) {
        it->Comment += ", ";
        it->Comment += i18n("%1 detected", i18n("l2tpd"));
    }
    if (xl2tpd_found) {
        it->Comment += ", ";
        it->Comment += i18n("%1 detected", i18n("xl2tpd"));
    }
    if (openl2tp_found) {
        it->Comment += ", ";
        it->Comment += i18n("%1 detected", i18n("openl2tp"));
    }

    values.clear();
    values << it->VpnType << it->state << it->Requirements.join(" " + i18n("and") + " ") << it->Comment;
    item = new QTreeWidgetItem((QTreeWidget*)0, values);

    RequirementsList = it->Requirements.join(" " + i18n("and") + " ").split(",", QString::KeepEmptyParts);
    RequirementsString = "<ul>";
    for (QStringList::Iterator it = RequirementsList.begin(); it != RequirementsList.end(); ++it)
        RequirementsString += "<li>" + *it + "</li>";
    RequirementsString += "</ul>";
    tipStr = QString("<h2>" + it->VpnType + "</h2><ul><li>" + i18n("Requirements:") + " " + RequirementsString + "</li><li>" + i18n("Comment:") + " " + it->Comment + "</li></ul>");

    item->setToolTip(0, tipStr);
    item->setToolTip(1, tipStr);
    item->setToolTip(2, tipStr);
    item->setToolTip(3, tipStr);
    item->setToolTip(4, tipStr);
    item->setToolTip(5, tipStr);
    item->setToolTip(6, tipStr);

    if (it->VpnState == true)
        item->setIcon(0, ok_icon);
    else
        item->setIcon(0, wrong_icon);
    items.append(item);

    VpnTypesInfoList->append(it);

    it = new VpnTypeInfo();
    it->VpnType = "vtun";
    it->Name = i18n("Vtun VPN");
    it->Requirements.append("vtund");
    it->Requirements.append("pppd");

    bool vtund_found = UtilsInstance.getToolInfo("vtund")->found;
    pppd_found = UtilsInstance.getToolInfo("pppd")->found;

    if (vtund_found && pppd_found) {
        it->VpnState = true;
        it->state = i18n("All tools found");
    } else {
        it->VpnState = false;
        it->state = i18n("Some tools missing");
    }

    if (vtund_found && !pppd_found) {
        it->Comment += i18n("pppd is missing");
    }
    if (!vtund_found && pppd_found) {
        it->Comment += i18n("vtun is missing");
    }

    values.clear();
    values << it->VpnType << it->state << it->Requirements.join(" " + i18n("and") + " ") << it->Comment;
    item = new QTreeWidgetItem((QTreeWidget*)0, values);

    RequirementsList = it->Requirements.join(" " + i18n("and") + " ").split(",", QString::KeepEmptyParts);
    RequirementsString = "<ul>";
    for (QStringList::Iterator it = RequirementsList.begin(); it != RequirementsList.end(); ++it)
        RequirementsString += "<li>" + *it + "</li>";
    RequirementsString += "</ul>";
    tipStr = QString("<h2>" + it->VpnType + "</h2><ul><li>" + i18n("Requirements:") + " " + RequirementsString + "</li><li>" + i18n("Comment:") + " " + it->Comment + "</li></ul>");

    item->setToolTip(0, tipStr);
    item->setToolTip(1, tipStr);
    item->setToolTip(2, tipStr);
    item->setToolTip(3, tipStr);
    item->setToolTip(4, tipStr);
    item->setToolTip(5, tipStr);
    item->setToolTip(6, tipStr);

    if (it->VpnState == true)
        item->setIcon(0, ok_icon);
    else
        item->setIcon(0, wrong_icon);
    items.append(item);

    VpnTypesInfoList->append(it);

    it = new VpnTypeInfo();
    it->VpnType = "ssh";
    it->Name = i18n("SSH VPN");
    it->Requirements.append("ssh");
    it->Requirements.append("ksshaskpass / gnome-ssh-askpass");

    bool ssh_found = UtilsInstance.getToolInfo("ssh")->found;
    bool ksshaskpass_found = UtilsInstance.getToolInfo("ksshaskpass")->found;
    bool sshaskpassgnome_found = UtilsInstance.getToolInfo("gnome-ssh-askpass")->found;

    if (ssh_found && (ksshaskpass_found || sshaskpassgnome_found)) {
        it->VpnState = true;
        it->state = i18n("All tools found");
    } else {
        it->VpnState = false;
        if (!ssh_found && (ksshaskpass_found || sshaskpassgnome_found))
            it->Comment += i18n("ssh is missing");
        else
            it->Comment += i18n("Password entry tool is missing");

    }

    values.clear();
    values << it->VpnType << it->state << it->Requirements.join(" " + i18n("and") + " ") << it->Comment;
    item = new QTreeWidgetItem((QTreeWidget*)0, values);

    RequirementsList = it->Requirements.join(" " + i18n("and") + " ").split(",", QString::KeepEmptyParts);
    RequirementsString = "<ul>";
    for (QStringList::Iterator it = RequirementsList.begin(); it != RequirementsList.end(); ++it)
        RequirementsString += "<li>" + *it + "</li>";
    RequirementsString += "</ul>";
    tipStr = QString("<h2>" + it->VpnType + "</h2><ul><li>" + i18n("Requirements:") + " " + RequirementsString + "</li><li>" + i18n("Comment:") + " " + it->Comment + "</li></ul>");

    item->setToolTip(0, tipStr);
    item->setToolTip(1, tipStr);
    item->setToolTip(2, tipStr);
    item->setToolTip(3, tipStr);
    item->setToolTip(4, tipStr);
    item->setToolTip(5, tipStr);
    item->setToolTip(6, tipStr);

    if (it->VpnState == true)
        item->setIcon(0, ok_icon);
    else
        item->setIcon(0, wrong_icon);
    items.append(item);

    VpnTypesInfoList->append(it);

    ToolsInfoWidget->InfoListView->insertTopLevelItems(0, items);
	ToolsInfoWidget->InfoListView->model()->sort(0);

    this->resize(800, 600);
    GlobalConfig->appPointer->restoreOverrideCursor();
}


VpnTypesInfoDialog::~VpnTypesInfoDialog()
{
}


