<?php
/******************************
 * Knowledgeroot
 * Frank Habermann
 * 21.09.2006
 *
 * Version 0.1
 * This Class shows informations in the admin interface
 ******************************/

class admin_config extends extension_base {

	function main() {
		$content = "";

		// add menu item to admin navi
		$this->menu['admin']['adm_config']['name'] = $this->CLASS['language']->get['ext']['admin_config']['menuitem'];
		$this->menu['admin']['adm_config']['link'] = "index.php?action=show_config";
		$this->menu['admin']['adm_config']['priority'] = "20";

		// check if informations should be shown
		if(isset($_GET['action']) and $_GET['action'] == "show_config") {
			$content = $this->show_config();
		}

		// save configvalue
		if(isset($_POST['action']) and isset($_POST['ext']) and $_POST['ext'] == "admin_config" and $_POST['action'] == "save_config") {
			$this->save_config();
		}

		return $content;
	}

	// show informations
	function show_config() {
		// load js file
		$this->CLASS['kr_header']->addjssrc("../" . $this->myPath . $this->CONF['jsfile']);

		$out = "";

		$out .= "<h2>".$this->CLASS['language']->get['ext']['admin_config']['header']."</h2>";

		$res = $this->CLASS['db']->query("SELECT * FROM settings ORDER BY name ASC");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			$out .= "<div onmouseover=\"show_edit('".$row['name']."');\" onmouseout=\"hide_edit('".$row['name']."');\">";
			$out .= "<span>".$row['description']."</span><br />\n";
			$out .= $row['name'] . " = <span id=\"value_".$row['name']."\">" . ($row['value'] == "" ? "&nbsp;" : $row['value']) . "</span>";
			$out .= "<span id=\"".$row['name']."\" style=\"display:none;\">[<a href=\"javascript:;\" onclick=\"show_field('".$row['name']."');\">edit</a>]</span>\n";
			$out .= "<span id=\"input_".$row['name']."\" style=\"display:none;\"><input type=\"text\" id=\"input_field_".$row['name']."\" name=\"input_field_".$row['name']."\" value=\"".$row['value']."\" /><input onclick=\"saveConfig('".$row['name']."',document.getElementById('input_field_".$row['name']."').value);\" type=\"submit\" name=\"submit\" value=\"save\" /></span>\n";
			$out .= "<span id=\"cancel_".$row['name']."\" style=\"display:none;\">[<a href=\"javascript:;\" onclick=\"hide_field('".$row['name']."');\">cancel</a>]</span>\n";
			$out .= "</div><br />\n";
			$out .= "\n";
		}

		return $out;
	}

	// save config value
	function save_config() {
		if(isset($_POST['config_path']) && $_POST['config_path'] != "") {
			$this->CLASS['knowledgeroot']->setConfig($_POST['config_path'],$_POST['config_value']);

			// set xml header
			header("Content-Type: text/xml");

			// generate xmloutput
			$xmlcode = '<?xml version="1.0" ?>' . "\n";
			$xmlcode .= "<root>\n";
			$xmlcode .= "\t<name>".$_POST['config_path']."</name>\n";
			$xmlcode .= "\t<value>\n";
			$xmlcode .= "<![CDATA[\n";
			$xmlcode .= $this->CLASS['knowledgeroot']->getConfig($_POST['config_path']);
			$xmlcode .= "]]>\n";
			$xmlcode .= "\t</value>\n";
			$xmlcode .= "</root>\n";

			echo $xmlcode;
		}

		exit();
	}
}

?>
