/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2009 Wayne Stambaugh <stambaughw@verizon.net>
 * Copyright (C) 2014 KiCad Developers, see CHANGELOG.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#ifndef __dialog_sch_sheet_props__
#define __dialog_sch_sheet_props__

/**
 * @file
 * Subclass of DIALOG_SCH_SHEET_PROPS_BASE, which is generated by wxFormBuilder.
 */

#include <dialog_sch_sheet_props_base.h>

/** Implementing DIALOG_SCH_SHEET_PROPS_BASE */
class DIALOG_SCH_SHEET_PROPS : public DIALOG_SCH_SHEET_PROPS_BASE
{
public:
    /** Constructor */
    DIALOG_SCH_SHEET_PROPS( wxWindow* parent );

    void SetFileName( const wxString& aFileName );
    const wxString GetFileName();

    void SetSheetName( const wxString& aSheetName )
    {
        m_textSheetName->SetValue( aSheetName );
    }
    wxString GetSheetName() { return m_textSheetName->GetValue(); }

    void SetFileNameTextSize( const wxString& aTextSize )
    {
        m_textFileNameSize->SetValue( aTextSize );
    }
    wxString GetFileNameTextSize() { return m_textFileNameSize->GetValue(); }

    void SetSheetNameTextSize( const wxString& aTextSize )
    {
        m_textSheetNameSize->SetValue( aTextSize );
    }
    wxString GetSheetNameTextSize() { return m_textSheetNameSize->GetValue(); }

    void SetFileNameTextSizeUnits(const wxString& aUnits)
    {
        m_staticFileNameSizeUnits->SetLabel( aUnits );
    }

    void SetSheetNameTextSizeUnits(const wxString& aUnits)
    {
        m_staticSheetNameSizeUnits->SetLabel( aUnits );
    }

    void SetSheetTimeStamp(const wxString& aTimeStamp)
    {
        m_textCtrlTimeStamp->SetValue( aTimeStamp );
    }

};

#endif // __dialog_sch_sheet_props__
