/*
Copyright (c) 2014 VMware, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package soap

import (
	"testing"

	"github.com/juju/govmomi/vim25/xml"
)

func TestEmptyEnvelope(t *testing.T) {
	env := Envelope{}

	b, err := xml.Marshal(env)
	if err != nil {
		t.Errorf("error: %s", err)
		return
	}

	expected := `<Envelope xmlns="http://schemas.xmlsoap.org/soap/envelope/"></Envelope>`
	actual := string(b)
	if expected != actual {
		t.Fatalf("expected: %s, actual: %s", expected, actual)
	}
}

func TestEmptyHeader(t *testing.T) {
	h := Header{}

	b, err := xml.Marshal(h)
	if err != nil {
		t.Errorf("error: %s", err)
		return
	}

	expected := `<Header xmlns="http://schemas.xmlsoap.org/soap/envelope/"></Header>`
	actual := string(b)
	if expected != actual {
		t.Fatalf("expected: %s, actual: %s", expected, actual)
	}
}
