/*
 * Copyright (c) 2016 Vivid Solutions.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */
package org.locationtech.jts.io.geojson;


/**
 * Constants for GeoJSON objects
 * 
 * @author Martin Davis
 */
public class GeoJsonConstants {

  public static final String NAME_GEOMETRIES = "geometries";
  public static final String NAME_CRS = "crs";
  public static final String NAME_PROPERTIES = "properties";
  public static final String NAME_NAME = "name";
  public static final String NAME_TYPE = "type";
  public static final String NAME_POINT = "Point";
  public static final String NAME_LINESTRING = "LineString";
  public static final String NAME_POLYGON = "Polygon";
  public static final String NAME_COORDINATES = "coordinates";
  public static final String NAME_GEOMETRYCOLLECTION = "GeometryCollection";
  public static final String NAME_MULTIPOLYGON = "MultiPolygon";
  public static final String NAME_MULTILINESTRING = "MultiLineString";
  public static final String NAME_MULTIPOINT = "MultiPoint";

}
