/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.UrlBindingParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBinding {
    protected Class<? extends ActionBean> beanType;
    protected String path;
    protected String suffix;
    protected List<Object> components;
    protected List<UrlBindingParameter> parameters;

    public UrlBinding(Class<? extends ActionBean> beanType, String path, List<Object> components) {
        Object last;
        this.beanType = beanType;
        this.path = path;
        if (components != null) {
            this.components = Collections.unmodifiableList(components);
        }
        this.parameters = new ArrayList<UrlBindingParameter>(this.components.size());
        for (Object component : components) {
            if (!(component instanceof UrlBindingParameter)) continue;
            this.parameters.add((UrlBindingParameter)component);
        }
        if (this.parameters.size() > 0 && (last = this.components.get(this.components.size() - 1)) instanceof String) {
            this.suffix = (String)last;
        }
    }

    public UrlBinding(Class<? extends ActionBean> beanType, String path) {
        this.beanType = beanType;
        this.path = path;
        this.components = Collections.emptyList();
        this.parameters = Collections.emptyList();
    }

    public Class<? extends ActionBean> getBeanType() {
        return this.beanType;
    }

    public List<Object> getComponents() {
        return this.components;
    }

    public List<UrlBindingParameter> getParameters() {
        return this.parameters;
    }

    public String getPath() {
        return this.path;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getPath());
        for (Object component : this.getComponents()) {
            if (component instanceof String) {
                buf.append(component);
                continue;
            }
            if (!(component instanceof UrlBindingParameter)) continue;
            UrlBindingParameter parameter = (UrlBindingParameter)component;
            buf.append('{').append(parameter.getName());
            if (parameter.getDefaultValue() != null) {
                buf.append('=').append(parameter.getDefaultValue());
            }
            buf.append('}');
        }
        return buf.toString();
    }
}

