#!/usr/bin/env perl
# $Header: /cvs/src/jbofihe/noralujv.pl,v 1.2 2001/01/11 21:33:36 richard Exp $
# Process the NORALUJV.txt file to generate dictionary input
#
#
# Copyright (C) Richard P. Curnow  1998-2001
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
# 
#

open (IN, "<NORALUJV.txt") || die "Could not open NORALUJV.txt";
@lines = <IN>;
close (IN);

foreach $x (@lines) {
    chomp $x;
    $lujvo = substr($x, 0, 30);
    $lujvo =~ s/ +$//;
    $rest = substr($x, 31);
    $rest =~ m/^([^:]*):([^:]*):(.*)$/ || next;
    $makeup = $1;
    $trans = $2;
    $plac = $3;
    $plac =~ s/\([^\)]+\)//g;
    @plac = split(/,/, $plac);

    $trans =~ s/^ +//;
    $trans =~ s/ +$//;

    print $lujvo."1:".$trans."\n";
    
    @places = ();
    foreach $p (@plac) {
        if ($p =~ m/x([1-9]) = ([a-z\']+[12345])/) {
            $place = $1;
            $gismu = $2;
            $gplace = $3;
            
            if ($place > 1) {
                $places[$place] = $gismu.$gplace;
                print $lujvo.$place.":\@".$gismu.$gplace."\n";
            }
        }
    }
}
