#!/usr/bin/env python3
#
# Copyright (C) 2017 Ying-Chun Liu (PaulLiu) <paulliu@debian.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
# USA


import re
import sys

authorR = re.compile(r'^Author:\s+(.*)')
dateR = re.compile(r'^Date:\s+(\w+)\s+(\w+)\s+(\w+)\s+(\d+[:]\d+[:]\d+)\s+(\d+)(\s+)?(.*)')

if __name__ == '__main__':
    rec1 = {}
    currentAuthor = None
    for line in sys.stdin:
        line = line.rstrip()
        authorM = authorR.match(line)
        if (authorM):
            currentAuthor = authorM.group(1)
            continue
        dateM = dateR.match(line)
        if (dateM):
            year = int(dateM.group(5))
            if (currentAuthor):
                if (currentAuthor in rec1):
                    if (year < rec1[currentAuthor]['min']):
                        rec1[currentAuthor]['min'] = year
                    if (year > rec1[currentAuthor]['max']):
                        rec1[currentAuthor]['max'] = year
                else:
                    rec1[currentAuthor] = { 'min':year, 'max':year }
    for k in sorted(rec1.keys()):
        if (rec1[k]['min'] == rec1[k]['max']):
            print ('%d %s'%(rec1[k]['max'], k))
        else:
            print ('%d-%d %s'%(rec1[k]['min'], rec1[k]['max'], k))
