+++
title = "Essays"
insert_anchor_links = "heading"
sort_by = "date"
generate_feeds = true
template = "essay_index.html"
page_template = "essay.html"
+++

### Hypermedia and REST
* [HATEOAS](@/essays/hateoas.md)
* [How Did REST Come To Mean The Opposite of REST?](@/essays/how-did-rest-come-to-mean-the-opposite-of-rest.md)
* [Two Approaches To Decoupling](@/essays/two-approaches-to-decoupling.md)
* [Hypermedia Clients](@/essays/hypermedia-clients.md)
* [HATEOAS Is For Humans](https://intercoolerjs.org/2016/05/08/hatoeas-is-for-humans.html)
* [Taking HTML Seriously](https://intercoolerjs.org/2020/01/14/taking-html-seriously)
* [The #ViewSource Affordance](@/essays/right-click-view-source.md)

### Why Hypermedia? Why Multi-Page Applications?
* [Hypermedia On Whatever you'd Like (HOWL)](@/essays/hypermedia-on-whatever-youd-like.md)
* [A Response To "Have SPAs Ruined The Web"](@/essays/a-response-to-rich-harris.md)
* [When To Use Hypermedia?](@/essays/when-to-use-hypermedia.md)
* [The API Churn/Security Trade-off](https://intercoolerjs.org/2016/02/17/api-churn-vs-security.html)
* [Does Hypermedia Scale?](@/essays/does-hypermedia-scale.md)

### Real World htmx Experiences
* [A Real World React to htmx Port](@/essays/a-real-world-react-to-htmx-port.md)
* [Another Real World React to htmx Port](@/essays/another-real-world-react-to-htmx-port.md)
* [A Real World wasm to htmx Port](@/essays/a-real-world-wasm-to-htmx-port.md)
* [Next.js to htmx — A Real World Example](@/essays/a-real-world-nextjs-to-htmx-port.md)
* [You Can't Build Interactive Web Apps Except as Single Page Applications... And Other Myths](@/essays/you-cant.md)

### On The Other Hand...
* [htmx sucks](@/essays/htmx-sucks.md)
* [Why Gumroad Didn't Choose htmx](@/essays/why-gumroad-didnt-choose-htmx.md)
* [A Modest Critique of htmx](https://chrisdone.com/posts/htmx-critique/) [[Response]](https://news.ycombinator.com/item?id=41782080)
* [I tried HTMX, then ditched it](https://ajmoon.com/posts/mesh-i-tried-htmx-then-ditched-it) 
* [Alternatives](@/essays/alternatives.md)

### Building Hypermedia Applications
* [Hypermedia-Driven Applications (HDAs)](@/essays/hypermedia-driven-applications.md)
* [Web Security Basics (with htmx)](@/essays/web-security-basics-with-htmx.md)
* [Hypermedia Friendly Scripting](@/essays/hypermedia-friendly-scripting.md)
* [10 Tips For Building SSR/HDA applications](@/essays/10-tips-for-SSR-HDA-apps.md)
* [Why I Tend Not To Use Content Negotiation](@/essays/why-tend-not-to-use-content-negotiation.md)
* [Template Fragments](@/essays/template-fragments.md)
* [Web Components Work Great with htmx](@/essays/webcomponents-work-great.md)
* [View Transitions](@/essays/view-transitions.md)
* [Model/View/Controller](@/essays/mvc.md)
* [Is Rendering JSON More Efficient Than Rendering HTML?](https://github.com/1cg/html-json-speed-comparison)
* [Is JSON Smaller Than HTML?](https://github.com/1cg/html-json-size-comparison)

### Complexity Very, Very Bad
* [The Grug Brained Developer](https://grugbrain.dev)
* [Codin' Dirty](@/essays/codin-dirty.md)
* [Locality of Behavior (LoB)](@/essays/locality-of-behaviour.md)
* [Complexity Budget](@/essays/complexity-budget.md)
* [Why htmx Does Not Have a Build Step](@/essays/no-build-step.md)
* [Is htmx Just Another JavaScript Framework?](@/essays/is-htmx-another-javascript-framework.md)
* [htmx Implementation Deep Dive (Video)](https://www.youtube.com/watch?v=javGxN-h9VQ)
* [Vendoring](@/essays/vendoring.md)

### Hypermedia Research

* [A File Structure For The Complex, The Changing and the Indeterminate (Ted Nelson, 1965)](https://dl.acm.org/doi/pdf/10.1145/800197.806036)
* [The Mother Of All Demos (Doug Englebart, 1968)](https://www.youtube.com/watch?v=B6rKUf9DWRI)
* [The First Web Page (1991)](http://info.cern.ch/hypertext/WWW/TheProject.html)
* [Architectural Styles and the Design of Network-based Software Architectures (Roy Fielding, 2000)](https://ics.uci.edu/~fielding/pubs/dissertation/top.htm)
* [State of the Art Review on Hypermedia Issues and Applications (2006)](https://paul.luon.net/hypermedia/index.html) [[archive]](https://web.archive.org/web/20240428215142/https://paul.luon.net/hypermedia/index.html)
* [How Primer has changed the way we write JavaScript for the better at Facebook (Makinde Adeagbo and Tom Occhino, 2010)](https://www.facebook.com/watch/?v=596368660334) [[archive.org mirror]](https://archive.org/details/facebook-front-end-tech-talk-8-5-2010-primerjs) [[youtube mirror]](https://youtu.be/BZmfCjtv6cM)
* [Hypermedia Controls: Feral to Formal (ACM HT'24)](https://dl.acm.org/doi/pdf/10.1145/3648188.3675127)
* [Preserving REST-ful Visibility Of Rich Web Applications With Generalized Hypermedia Controls (ACM SIGWEB Newsletter, Autumn'24)](https://hypermedia.cs.montana.edu/papers/preserving-restful.pdf)

### Interviews

* [Henning Koch](@/essays/interviews/henning_koch.md), creator of [Unpoly](https://unpoly.com/)
* [Makinde Adeagbo](@/essays/interviews/makinde_adeagbo.md), creator of [Primer](https://www.youtube.com/watch?v=wHlyLEPtL9o)
* [Chris Wanstrath aka @defunkt](@/essays/interviews/chris_wanstrath.md), creator of [pjax](https://github.com/defunkt/jquery-pjax)
* [Mike Amundsen](@/essays/interviews/mike_amundsen.md), author of [RESTful Web APIs](http://restfulwebapis.com/)
* [Leonard Richardson](@/essays/interviews/leonard_richardson.md), creator of the [RMM](https://en.wikipedia.org/wiki/Richardson_Maturity_Model)

## Banners
<div style="text-align: center;margin:32px">
  <img width="90%" loading="lazy" src="/img/createdwith.jpeg"
    alt="Site created with htmx, The Right Way.">
</div>

## Memes

<style>
  .memes {
    text-align: center;
  }
  .memes img {
     min-height: 200px;
     max-width: 100%;
     margin: 32px;
   }
</style>
<div class="memes">
<img loading="lazy" src="/img/memes/original.png"
  alt="2004 architecture: router, controller, model and view on server side,
    browser, DOM and JS on client. 2019 architecture: browser, DOM, js, model,
    view, controller, virtual DOM, server-side JS runtime, router, model view
    and controller again, another virtual dom, another model-view-controller
    for the JSON API... discontent wojak. and 2021 architecture, same as 200 but
    with htmx and smug wojak.">
<img loading="lazy" src="/img/memes/20yearold.png"
  alt='crying wojak with smiling mask says "lol you are going to use twenty year
    old technology to build modern websites lol maybe for a toy website good
    luck w/ that lmao"
    django, php, flask and rails say: "Yes."
    lisp says: "no, sixty years old."'>
<img loading="lazy" src="/img/memes/whowillwin.png"
  alt='Who Will Win? On the left corner: the champions Angular and React, with
    their respective Google and Facebook legions.
    On the right corner: a lunatic in montana and his internet friends
    "u guys should use hypermedia"'>
<img loading="lazy" src="/img/memes/uarealldoingitwrong.png"
  alt='Despair.com poster with Roy Fielding&apos;s face.
    "REST: You&apos;re doing it completely wrong."'>
<img loading="lazy" src="/img/memes/restapi.png"
  alt='"I&apos;m going to create a RESTful API..." happy roy
    "Using JSON..." distressed roy
    "here are my API docs" angery laser eyes roy'>
<img loading="lazy" src="/img/memes/justusehtml.png"
  alt="diagram explaining difference between 'hydration' which has 4 long stages
    and 'resumability' which is apparently one step.
    or just use HTML in one tiny step (loading the html)">
<img loading="lazy" src="/img/memes/istudiedhtml.png"
  alt="When You wrote class components I studied HTML.
    When you were converting classes to hooks I mastered the HTML.
    While you wasted time moving all your client-side logic to server components
    I cultivated inner HTML.
    And now that the browser won't hydrate your thick client JSON API you have
    the audacity to come to me for help?">
<img loading="lazy" src="/img/memes/htmlvsjson.png"
  alt='HTML says "I feel bad for you".
    JSON says "I don&apos;t think about you at all.'>
<img loading="lazy" src="/img/memes/dontknowwhatclientsideroutingis.png"
  alt="Roll Safe meme: Can't route client side if u don't know what client-side routing is.">
<img loading="lazy" src="/img/memes/nocap.png"
  alt="yo no cap u don't even need that for web dev fr. hypermedia straight bussin. mf deadass simple fr
    -- grug with broccoli hair">
<img loading="lazy" src="/img/memes/ie11enjoyer.png"
  alt='average "browsers should follow open standards" fan vs average IE11 enjoyer'>
<img loading="lazy" src="/img/memes/hydration.png"
  alt="How much water is in your body? Adult male 60%, adult female 55%, children 65%, infant 75%, React 100%">
<img loading="lazy" src="/img/memes/viewsource.png"
  alt='Gigachad: "I wonder how this works..." *clicks view source* "Oh, neat."'>
<img loading="lazy" src="/img/memes/javascripthistory.png"
  alt="Friends? Free time? Happiness? Nope, says the JavaScript History API">
<img loading="lazy" src="/img/memes/bellcurve.png"
  alt="Bell curve meme. Lower percentile: HTML + a backend.
    Median: ONE BILLION COMPONENTS highest percentile: HTML + a backend">
<img loading="lazy" src="/img/memes/drakearchitecture.png"
  alt="Disapproving Drake: web dev learning graph with a dozen branches.
    Pleased Drake: Learn the basics - HTML and CSS">
<img loading="lazy" src="/img/memes/bellcurve2.png"
  alt="Bell curve meme. Low: HTML is fine. Median: we have to use react and
    react router and graphql and redux and... high: htmx is fine">
<img loading="lazy" src="/img/memes/dbtohtml.png"
  alt="DB to JSON to HTML -- or you can just do DB to HTML...">
<img loading="lazy" src="/img/memes/normal.png"
  alt="Me: Why can't you just be normal? JavaScript: *screams*">
<img loading="lazy" src="/img/memes/feelbad.png"
  alt="You are using the term REST bad and you should feel bad -- zoidberg">
<img loading="lazy" src="/img/memes/drakememes.png"
  alt="Disapproving Drake: well reasoned, detailed and insightful content
    explaining the strengths and weaknesses of htmx vs other perfectly valid
    potential approaches to front end web development">
<img loading="lazy" src="/img/memes/fullstack.jpg"
  alt="htmx to backend dev: 'Look at me. You're fullstack now.'">
<img loading="lazy" src="/img/memes/frontenddevs.png"
  alt="front end devs thinkin' everyone is going to be using JavaScript on the
    backend soon:   htmx:">
<img loading="lazy" src="/img/memes/htmxanddjango.png"
  alt="django is a monkey sitting on htmx's back and it's refusing something labeled
   'all that complicated js noise">
<img loading="lazy" src="/img/memes/aye.png"
  alt='me, an old java dev: "I never thought I would die fighting side by side
    w/ dotnet developers"
    "what about side by side w/ someone who also hates JS frameworks?"
    "aye, I could do that"'>
<img loading="lazy" src="/img/memes/extinction.png"
  alt="still from an avengers movie? idk. javascript/node is thanos and java, ruby,
    lisp, python and php are fighting it, also haskell is dr strange i think which
    seems relevant">
</div>
