/*
 * endtypes.c
 *
 * Copyright (c) Chris Putnam 2003-2018
 *
 * Program and source code released under the GPL version 2
 *
 */
#include <stdio.h>
#include <string.h>
#include "is_ws.h"
#include "fields.h"
#include "reftypes.h"

/* if no specific type can be identified */
static lookups generic[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%J", "TITLE",           TITLE,    LEVEL_HOST }, /* for refer formats */
	{ "%E", "2ND_AUTHOR",      PERSON,   LEVEL_MAIN },
	{ "%B", "2ND_TITLE",       SIMPLE,   LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME" ,         SIMPLE,   LEVEL_MAIN },
	{ "%6", "NUMVOLUMES",      SIMPLE,   LEVEL_HOST },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",           PAGES,    LEVEL_MAIN },
	{ "%&", "SECTION",         SIMPLE,   LEVEL_MAIN },
	{ "%Y", "AUTHOR",          PERSON,   LEVEL_SERIES },
	{ "%S", "TITLE",           TITLE,    LEVEL_SERIES },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%?", "SUB_AUTHOR",      PERSON,   LEVEL_MAIN }, /* subsidiary-authors */
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",  SIMPLE,   LEVEL_MAIN },
	{ "%*", "REVIEWEDITEM",    SIMPLE,   LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%Z", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN }
};

static lookups journalarticle[] = {
	{ "%0", "INTERNAL_TYPE",         TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",       PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",   PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE",SIMPLE, LEVEL_MAIN },
	{ "%D", "PARTDATE:YEAR",     SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,       TITLE,    LEVEL_MAIN },
	{ "%J", "TITLE",        TITLE,    LEVEL_HOST }, /* journal title */
	{ "%B", "TITLE",        TITLE,    LEVEL_HOST }, /* journal title */
	{ "%C", "ADDRESS",      SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME" ,      SIMPLE,   LEVEL_MAIN },
	{ "%N", "ISSUE",        SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",        PAGES,    LEVEL_MAIN },
	{ "%I", "PUBLISHER",    SIMPLE,   LEVEL_HOST }, 
	{ "%8", "PARTDATE:MONTH", DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",  GENRE,   LEVEL_MAIN },
	{ "%!", "SHORTTITLE",   TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER", SERIALNO, LEVEL_HOST },
	{ "%(", "TITLE",        SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",SIMPLE,  LEVEL_MAIN },
	{ "%*", "REVIEWEDITEM", SIMPLE,   LEVEL_MAIN },
	{ "%M", "ACCESSNUM",    SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",   SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",      SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",     SIMPLE,   LEVEL_MAIN },
	{ "%U", "URL",          URL,      LEVEL_MAIN },
	{ "%O", "NOTES",        NOTES,    LEVEL_MAIN },
	{ "%Z", "NOTES",        NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",      NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",      NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",      NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",      NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",      NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",      NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",      SIMPLE,   LEVEL_MAIN },
	{ "%G", "LANGUAGE",     SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",  SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%^", "CAPTION",      SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",   SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",  SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",     SIMPLE,   LEVEL_MAIN },
	{ "  ", "ISSUANCE|continuing",             ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",                   ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:BIBUTILS|journal article",  ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|periodical",           ALWAYS, LEVEL_HOST },
	{ "  ", "GENRE:BIBUTILS|academic journal", ALWAYS, LEVEL_HOST }
};

static lookups magazinearticle[] = {
	{ "%0", "INTERNAL_TYPE",      TYPE,    LEVEL_MAIN },
	{ "%A", "AUTHOR",    PERSON,  LEVEL_MAIN },
	{ "%H", "TRANSLATOR",PERSON, LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE, LEVEL_MAIN },
	{ "%D", "PARTDATE:YEAR",  SIMPLE,  LEVEL_MAIN },
	{ "%T", "TITLE",     TITLE,   LEVEL_MAIN },
	{ "%J", "TITLE",     TITLE,   LEVEL_HOST }, /* magazine name */
	{ "%B", "TITLE",     TITLE,   LEVEL_HOST }, /* magazine name */
	{ "%C", "ADDRESS",   SIMPLE, LEVEL_MAIN },
	{ "%V", "VOLUME",    SIMPLE,  LEVEL_MAIN },
	{ "%N", "ISSUE",     SIMPLE,  LEVEL_MAIN },
	{ "%P", "PAGES",     PAGES,   LEVEL_MAIN },
	{ "%I", "PUBLISHER", SIMPLE,    LEVEL_HOST },
	{ "%8", "PARTDATE:MONTH", DATE,    LEVEL_MAIN },
	{ "%!", "SHORTTITLE",TITLE,   LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",      SERIALNO,LEVEL_HOST },
	{ "%(", "TITLE",     SIMPLE,  LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",SIMPLE,LEVEL_MAIN },
	{ "%*", "REVIEWEDITEM",SIMPLE,LEVEL_MAIN },
	{ "%M", "ACCESSNUM", SIMPLE,  LEVEL_MAIN },
	{ "%L", "CALLNUMBER",SIMPLE,  LEVEL_MAIN },
	{ "%F", "REFNUM",    SIMPLE,  LEVEL_MAIN },
	{ "%K", "KEYWORD",   SIMPLE,  LEVEL_MAIN },
	{ "%X", "ABSTRACT",  SIMPLE,  LEVEL_MAIN },
	{ "%U", "URL",       URL,     LEVEL_MAIN },
	{ "%O", "NOTES",     SIMPLE,  LEVEL_MAIN },
	{ "%Z", "NOTES",     SIMPLE,  LEVEL_MAIN },
	{ "%1", "CUSTOM1",      NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",      NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",      NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",      NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",      NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",      NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",SIMPLE,LEVEL_MAIN },
	{ "%>", "PDFLINK",      SIMPLE, LEVEL_MAIN },
	{ "%G", "LANGUAGE",     SIMPLE, LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",  SIMPLE, LEVEL_MAIN },  /* physical location */
	{ "%^", "CAPTION",      SIMPLE, LEVEL_MAIN },
	{ "%[", "ACCESSDATE",   SIMPLE, LEVEL_MAIN },
	{ "%=", "LASTMODDATE",  SIMPLE, LEVEL_MAIN },
	{ "%~", "DATABASE",     SIMPLE, LEVEL_MAIN },
	{ "  ", "ISSUANCE|continuing",     ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",           ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|periodical",   ALWAYS, LEVEL_HOST },
	{ "  ", "GENRE:BIBUTILS|magazine", ALWAYS, LEVEL_HOST }
};

static lookups newspaperarticle[] = {
	{ "%0", "INTERNAL_TYPE",      TYPE,    LEVEL_MAIN },
	{ "%A", "REPORTER",  PERSON,  LEVEL_MAIN },
	{ "%H", "TRANSLATOR",PERSON, LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE, LEVEL_MAIN },
	{ "%D", "PARTDATE:YEAR",  SIMPLE,  LEVEL_MAIN },
	{ "%T", "TITLE" ,    TITLE,   LEVEL_MAIN },
	{ "%J", "TITLE",     TITLE,   LEVEL_HOST }, /* newspaper name */
	{ "%B", "TITLE",     TITLE,   LEVEL_HOST }, /* newspaper name */
	{ "%V", "VOLUME" ,   SIMPLE,  LEVEL_MAIN },
	{ "%C", "ADDRESS",   SIMPLE, LEVEL_MAIN },
	{ "%N", "ISSUE",     SIMPLE,  LEVEL_MAIN },
	{ "%P", "PAGES",     PAGES,   LEVEL_MAIN },
	{ "%7", "EDITION",   SIMPLE,  LEVEL_MAIN },
	{ "%8", "PARTDATE:MONTH", DATE,    LEVEL_MAIN },
	{ "%!", "SHORTTITLE",TITLE,   LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",      SERIALNO, LEVEL_MAIN },
	{ "%(", "TITLE",     SIMPLE, LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",SIMPLE, LEVEL_MAIN },
	{ "%*", "REVIEWEDITEM",SIMPLE,LEVEL_MAIN },
	{ "%M", "ACCESSNUM", SIMPLE,  LEVEL_MAIN },
	{ "%L", "CALLNUMBER",SIMPLE,  LEVEL_MAIN },
	{ "%F", "REFNUM",    SIMPLE,  LEVEL_MAIN },
	{ "%K", "KEYWORD",   SIMPLE,  LEVEL_MAIN },
	{ "%X", "ABSTRACT",  SIMPLE,  LEVEL_MAIN },
	{ "%U", "URL",       URL,     LEVEL_MAIN },
	{ "%O", "NOTES",     SIMPLE,  LEVEL_MAIN },
	{ "%Z", "NOTES",     SIMPLE,  LEVEL_MAIN },
	{ "%1", "CUSTOM1",      NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",      NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",      NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",      NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",      NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",      NOTES,    LEVEL_MAIN },
	{ "%G", "LANGUAGE",     SIMPLE, LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",  SIMPLE, LEVEL_MAIN },  /* physical location */
	{ "%+", "AUTHORADDRESS",SIMPLE,LEVEL_MAIN },
	{ "%>", "PDFLINK",      SIMPLE, LEVEL_MAIN },
	{ "%^", "CAPTION",      SIMPLE, LEVEL_MAIN },
	{ "%[", "ACCESSDATE",   SIMPLE, LEVEL_MAIN },
	{ "%=", "LASTMODDATE",  SIMPLE, LEVEL_MAIN },
	{ "%~", "DATABASE",     SIMPLE, LEVEL_MAIN },
	{ "  ", "ISSUANCE|continuing",  ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",        ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|newspaper", ALWAYS, LEVEL_HOST }
};

static lookups book[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%E", "AUTHOR",          PERSON,   LEVEL_HOST }, /* SERIES_AUTHOR */
	{ "%B", "TITLE",           TITLE,    LEVEL_HOST }, /* SERIES_TITLE */
	{ "%S", "TITLE",           TITLE,    LEVEL_SERIES },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME" ,         SIMPLE,   LEVEL_MAIN },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%6", "NUMVOLUMES",      SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES:TOTAL",     SIMPLE,   LEVEL_MAIN },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_MAIN },
	{ "%?", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",  SIMPLE,   LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "GENRE:MARC|book",      ALWAYS, LEVEL_MAIN },
	{ "  ", "ISSUANCE|monographic", ALWAYS, LEVEL_MAIN },
	{ "  ", "RESOURCE|text",        ALWAYS, LEVEL_MAIN }
};

static lookups booksection[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_HOST },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%E", "EDITOR",          PERSON,   LEVEL_HOST }, /* editor for book */
	{ "%B", "TITLE",           TITLE,    LEVEL_HOST }, /* book title */
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_HOST },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_HOST },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_HOST },
	{ "%V", "VOLUME" ,         SIMPLE,   LEVEL_MAIN },
	{ "%6", "NUMVOLUMES",      SIMPLE,   LEVEL_HOST },
	{ "%P", "PAGES",           PAGES,    LEVEL_MAIN },
	{ "%Y", "EDITOR",          PERSON,   LEVEL_SERIES },
	{ "%S", "TITLE",           TITLE,    LEVEL_SERIES },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_HOST },
	{ "%?", "TRANSLATOR",      PERSON,   LEVEL_HOST },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_HOST },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",  SIMPLE,   LEVEL_HOST },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
        { "  ", "GENRE:BIBUTILS|book chapter", ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|book",             ALWAYS, LEVEL_HOST },
	{ "  ", "ISSUANCE|monographic",        ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",               ALWAYS, LEVEL_MAIN }
};

static lookups editedbook[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "EDITOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%E", "EDITOR",          PERSON,   LEVEL_HOST }, /* SERIES_EDITOR */
	{ "%B", "TITLE",           TITLE,    LEVEL_HOST }, /* SERIES_TITLE */
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME" ,         SIMPLE,   LEVEL_MAIN },
	{ "%6", "NUMVOLUMES",      SIMPLE,   LEVEL_HOST },
	{ "%P", "PAGES:TOTAL",     SIMPLE,   LEVEL_MAIN },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_MAIN },
	{ "%?", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",  SIMPLE,   LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "GENRE:MARC|book",      ALWAYS, LEVEL_MAIN },
	{ "  ", "ISSUANCE|monographic", ALWAYS, LEVEL_MAIN },
	{ "  ", "RESOURCE|text",        ALWAYS, LEVEL_MAIN }
};

static lookups manuscript[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,   LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON, LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON, LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE, LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE, LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,  LEVEL_MAIN },
	{ "%B", "TITLE",           TITLE,  LEVEL_HOST }, /* COLLECTION_TITLE */
	{ "%C", "ADDRESS",         SIMPLE, LEVEL_MAIN },
	{ "%N", "NUMBER",          SIMPLE, LEVEL_MAIN },
	{ "%P", "PAGES",           PAGES,  LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,   LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,  LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,  LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE, LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE, LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE, LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE, LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE, LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,  LEVEL_MAIN },
	{ "%U", "URL",             URL,    LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,  LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,  LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,  LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,  LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,  LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,  LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,  LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE, LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE, LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE, LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE, LEVEL_MAIN },  /* physical location */
	{ "%^", "CAPTION",         SIMPLE, LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE, LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE, LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE, LEVEL_MAIN },
	{ "  ", "RESOURCE|text",             ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:BIBUTILS|manuscript", ALWAYS, LEVEL_MAIN }
};

static lookups communication[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,   LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON, LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON, LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE, LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE, LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,  LEVEL_MAIN },
	{ "%E", "ADDRESSEE",       PERSON, LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE, LEVEL_MAIN },
	{ "%V", "VOLUME",          SIMPLE, LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE, LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,   LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,  LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,  LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE, LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE, LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE, LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE, LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE, LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,  LEVEL_MAIN },
	{ "%U", "URL",             URL,    LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,  LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,  LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,  LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,  LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,  LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,  LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,  LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE, LEVEL_MAIN },  /* physical location */
	{ "%+", "AUTHORADDRESS",   SIMPLE, LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE, LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE, LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE, LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE, LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE, LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE, LEVEL_MAIN },
	{ "  ", "GENRE:BIBUTILS|communication", ALWAYS, LEVEL_MAIN}
};

static lookups proceedings[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_HOST },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%E", "EDITOR",          PERSON,   LEVEL_MAIN },
	{ "%B", "TITLE",           SIMPLE,   LEVEL_HOST },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME" ,         SIMPLE,   LEVEL_MAIN },
	{ "%6", "NUMVOLUMES",      SIMPLE,   LEVEL_HOST },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",           PAGES,    LEVEL_MAIN },
	{ "%Y", "EDITOR",          PERSON,   LEVEL_SERIES },
	{ "%S", "TITLE",           TITLE,    LEVEL_SERIES },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_HOST },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|text",                     ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|conference publication", ALWAYS, LEVEL_MAIN }
};

static lookups conferencepaper[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "PARTDATE:YEAR",   SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%J", "TITLE",           TITLE,    LEVEL_HOST }, /* journal title */
	{ "%B", "TITLE",           TITLE,    LEVEL_HOST }, /* journal title */
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME" ,         SIMPLE,   LEVEL_MAIN },
	{ "%N", "ISSUE",           SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",           PAGES,    LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_HOST },
	{ "%8", "PARTDATE:MONTH",  DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_HOST },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",  SIMPLE,   LEVEL_MAIN },
	{ "%*", "REVIEWEDITEM",    SIMPLE,   LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|text",                     ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|conference publication", ALWAYS, LEVEL_HOST }
};

static lookups thesis[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%B", "ACADEMIC_DEPARTMENT", SIMPLE, LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME",          SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES:TOTAL",     PAGES,    LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN }, /* thesis type */
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|text",     ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|thesis", ALWAYS, LEVEL_MAIN }
};

static lookups program[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%7", "VERSION",         SIMPLE,   LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%1", "COMPUTER",        SIMPLE,   LEVEL_MAIN },
	{ "%2", "CUSTOM2",         SIMPLE,   LEVEL_MAIN },
	{ "%3", "CUSTOM3",         SIMPLE,   LEVEL_MAIN },
	{ "%4", "CUSTOM4",         SIMPLE,   LEVEL_MAIN },
	{ "%#", "CUSTOM5",         SIMPLE,   LEVEL_MAIN },
	{ "%$", "CUSTOM6",         SIMPLE,   LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|software, multimedia", ALWAYS, LEVEL_MAIN }
};

static lookups audiovisual[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "WRITER",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%B", "TITLE",           TITLE,    LEVEL_HOST }, /* COLLECTION_TITLE */
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%V", "EXTENTOFWORK",    SIMPLE,   LEVEL_MAIN },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%?", "PERFORMER",       PERSON,   LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|mixed material", ALWAYS, LEVEL_MAIN }
};

static lookups broadcast[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%E", "DIRECTOR",        PERSON,   LEVEL_MAIN },
	{ "%B", "TITLE",           TITLE,    LEVEL_HOST }, /* SERIES_TITLE */
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%Y", "PRODUCER",        PERSON,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_MAIN },
	{ "%?", "PERFORMER",       PERSON,   LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|moving image",               ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|motion picture",           ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:BIBUTILS|television broadcast", ALWAYS, LEVEL_MAIN },
};

static lookups electronic[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN }, 
	{ "%V", "ACCESS_YEAR",     SIMPLE,   LEVEL_MAIN },
	{ "%N", "ACCESS_DATE",     DATE,     LEVEL_MAIN },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_MAIN },
	{ "%8", "UPDATE_DATE",     DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%V", "VOLUME",          SIMPLE,   LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
        { " ",  "RESOURCE|software, multimedia", ALWAYS, LEVEL_MAIN },
        { " ",  "GENRE:MARC|electronic",         ALWAYS, LEVEL_MAIN },
};

static lookups webpage[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN }, 
	{ "%V", "ACCESS_YEAR",     SIMPLE,   LEVEL_MAIN },
	{ "%N", "ACCESS_DATE",     DATE,     LEVEL_MAIN },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_MAIN },
	{ "%8", "UPDATE_DATE",     DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%V", "VOLUME",          SIMPLE,   LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
        { " ",  "RESOURCE|software, multimedia", ALWAYS, LEVEL_MAIN },
        { " ",  "GENRE:MARC|web page",           ALWAYS, LEVEL_MAIN },
};

static lookups artwork[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "ARTIST",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "GENRE:MARC|art original", ALWAYS, LEVEL_MAIN }
};

static lookups report[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",           PAGES,    LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UKNOWN",    GENRE,    LEVEL_MAIN },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|text",               ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|technical report", ALWAYS, LEVEL_MAIN },
};

static lookups map[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "CARTOGRAPHER",    PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_MAIN },
	{ "%9", "GENRE:UKNOWN",    GENRE,    LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%1", "SCALE",           SIMPLE,   LEVEL_MAIN },
	{ "%2", "CUSTOM2",         SIMPLE,   LEVEL_MAIN },
	{ "%3", "CUSTOM3",         SIMPLE,   LEVEL_MAIN },
	{ "%4", "CUSTOM4",         SIMPLE,   LEVEL_MAIN },
	{ "%#", "CUSTOM5",         SIMPLE,   LEVEL_MAIN },
	{ "%$", "CUSTOM6",         SIMPLE,   LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|cartographic", ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|map",        ALWAYS, LEVEL_MAIN }
};

static lookups patent[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE" ,          TITLE,    LEVEL_MAIN },
	{ "%B", "PUBLISHED_SOURCE",SIMPLE,   LEVEL_MAIN },
	{ "%C", "COUNTRY",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "ASSIGNEE",        SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME",          SIMPLE,   LEVEL_MAIN },
	{ "%N", "ISSUE",           SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",           SIMPLE,   LEVEL_MAIN },
	{ "%@", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           SIMPLE,   LEVEL_MAIN },
	{ "%1", "SCALE",           SIMPLE,   LEVEL_MAIN },
	{ "%2", "CUSTOM2",         SIMPLE,   LEVEL_MAIN },
	{ "%3", "CUSTOM3",         SIMPLE,   LEVEL_MAIN },
	{ "%4", "CUSTOM4",         SIMPLE,   LEVEL_MAIN },
	{ "%#", "CUSTOM5",         SIMPLE,   LEVEL_MAIN },
	{ "%$", "CUSTOM6",         SIMPLE,   LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|text",     ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|patent", ALWAYS, LEVEL_MAIN }
};

static lookups hearing[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%B", "COMMITTEE:CORP",  SIMPLE,   LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN }, 
	{ "%6", "NUMVOLUMES",      SIMPLE,   LEVEL_MAIN },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES:TOTAL",     PAGES,    LEVEL_MAIN },
	{ "%S", "LEGISLATIVEBODY:CORP", SIMPLE, LEVEL_MAIN },
	{ "%7", "SESSION",         SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* orig publication */
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "GENRE:BIBUTILS|hearing",ALWAYS, LEVEL_MAIN }
};

static lookups bill[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%B", "CODE",            SIMPLE,   LEVEL_MAIN },
	{ "%V", "CODEVOLUME",      SIMPLE,   LEVEL_MAIN },
	{ "%N", "BILLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%P", "CODEPAGES",       SIMPLE,   LEVEL_MAIN },
	{ "%&", "CODESECTION",     SIMPLE,   LEVEL_MAIN },
	{ "%S", "LEGISLATIVEBODY:CORP", SIMPLE, LEVEL_MAIN },
	{ "%7", "SESSION",         SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%?", "SPONSOR",         PERSON,   LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|text",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|legislation", ALWAYS, LEVEL_MAIN }
};

static lookups statute[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%B", "CODE",            SIMPLE,   LEVEL_MAIN },
	{ "%V", "CODENUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%N", "PUBLICLAWNUMBER", SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",           PAGES,    LEVEL_MAIN },
	{ "%&", "SECTION",         SIMPLE,   LEVEL_MAIN },
	{ "%7", "SESSION",         SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|text",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|legislation", ALWAYS, LEVEL_MAIN }
};

static lookups lawcase[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%E", "REPORTER",        TITLE,    LEVEL_HOST }, /*Reporter is name of book*/
	{ "%B", "CODE",            SIMPLE,   LEVEL_MAIN },
	{ "%I", "COURT:CORP",      SIMPLE,   LEVEL_MAIN },
	{ "%V", "VOLUME",          SIMPLE,   LEVEL_MAIN },
	{ "%N", "PUBLICLAWNUMBER", SIMPLE,   LEVEL_MAIN },
	{ "%P", "STARTPAGE",       SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%?", "COUNSEL",         PERSON,   LEVEL_MAIN },
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "RESOURCE|text",                        ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE:MARC|legal case and case notes", ALWAYS, LEVEL_MAIN }
};

static lookups chart[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%J", "TITLE",           TITLE,    LEVEL_HOST }, /* for refer formats */
	{ "%E", "2ND_AUTHOR",      PERSON,   LEVEL_MAIN },
	{ "%B", "2ND_TITLE",       SIMPLE,   LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN }, 
	{ "%V", "VOLUME" ,         SIMPLE,   LEVEL_MAIN },
	{ "%6", "NUMVOLUMES",      SIMPLE,   LEVEL_HOST },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",           PAGES,    LEVEL_MAIN },
	{ "%&", "SECTION",         SIMPLE,   LEVEL_MAIN },
	{ "%Y", "AUTHOR",          PERSON,   LEVEL_SERIES },
	{ "%S", "TITLE",           TITLE,    LEVEL_SERIES },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%?", "SUB_AUTHOR",      PERSON,   LEVEL_MAIN }, /* subsidiary-authors */
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",  SIMPLE,   LEVEL_MAIN },
	{ "%*", "REVIEWEDITEM",    SIMPLE,   LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "  ", "GENRE:MARC|chart",  ALWAYS, LEVEL_MAIN }
};

static lookups unpublished[] = {
	{ "%0", "INTERNAL_TYPE",   TYPE,     LEVEL_MAIN },
	{ "%A", "AUTHOR",          PERSON,   LEVEL_MAIN },
	{ "%H", "TRANSLATOR",      PERSON,   LEVEL_MAIN },
	{ "%Q", "TRANSLATEDTITLE", SIMPLE,   LEVEL_MAIN },
	{ "%D", "DATE:YEAR",       SIMPLE,   LEVEL_MAIN },
	{ "%T", "TITLE",           TITLE,    LEVEL_MAIN },
	{ "%J", "TITLE",           TITLE,    LEVEL_HOST }, /* for refer formats */
	{ "%E", "2ND_AUTHOR",      PERSON,   LEVEL_MAIN },
	{ "%B", "2ND_TITLE",       SIMPLE,   LEVEL_MAIN },
	{ "%C", "ADDRESS",         SIMPLE,   LEVEL_MAIN },
	{ "%I", "PUBLISHER",       SIMPLE,   LEVEL_MAIN }, 
	{ "%V", "VOLUME",          SIMPLE,   LEVEL_MAIN },
	{ "%6", "NUMVOLUMES",      SIMPLE,   LEVEL_HOST },
	{ "%N", "NUMBER",          SIMPLE,   LEVEL_MAIN },
	{ "%P", "PAGES",           PAGES,    LEVEL_MAIN },
	{ "%&", "SECTION",         SIMPLE,   LEVEL_MAIN },
	{ "%Y", "AUTHOR",          PERSON,   LEVEL_SERIES },
	{ "%S", "TITLE",           TITLE,    LEVEL_SERIES },
	{ "%7", "EDITION",         SIMPLE,   LEVEL_MAIN },
	{ "%8", "DATE:MONTH",      DATE,     LEVEL_MAIN },
	{ "%9", "GENRE:UNKNOWN",   GENRE,    LEVEL_MAIN },
	{ "%?", "SUB_AUTHOR",      PERSON,   LEVEL_MAIN }, /* subsidiary-authors */
	{ "%!", "SHORTTITLE",      TITLE,    LEVEL_MAIN },
	{ "%@", "SERIALNUMBER",    SERIALNO, LEVEL_MAIN },
	{ "%(", "TITLE",           SIMPLE,   LEVEL_ORIG }, /* original pub */
	{ "%)", "REPRINTEDITION",  SIMPLE,   LEVEL_MAIN },
	{ "%*", "REVIEWEDITEM",    SIMPLE,   LEVEL_MAIN },
	{ "%1", "CUSTOM1",         NOTES,    LEVEL_MAIN },
	{ "%2", "CUSTOM2",         NOTES,    LEVEL_MAIN },
	{ "%3", "CUSTOM3",         NOTES,    LEVEL_MAIN },
	{ "%4", "CUSTOM4",         NOTES,    LEVEL_MAIN },
	{ "%#", "CUSTOM5",         NOTES,    LEVEL_MAIN },
	{ "%$", "CUSTOM6",         NOTES,    LEVEL_MAIN },
	{ "%M", "ACCESSNUM",       SIMPLE,   LEVEL_MAIN },
	{ "%L", "CALLNUMBER",      SIMPLE,   LEVEL_MAIN },
	{ "%F", "REFNUM",          SIMPLE,   LEVEL_MAIN },
	{ "%K", "KEYWORD",         SIMPLE,   LEVEL_MAIN },
	{ "%X", "ABSTRACT",        SIMPLE,   LEVEL_MAIN },
	{ "%O", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%U", "URL",             URL,      LEVEL_MAIN },
	{ "%>", "PDFLINK",         SIMPLE,   LEVEL_MAIN },
	{ "%Z", "NOTES",           NOTES,    LEVEL_MAIN },
	{ "%W", "PHYSICALLOC",     SIMPLE,   LEVEL_MAIN },  /* physical location */
	{ "%G", "LANGUAGE",        SIMPLE,   LEVEL_MAIN },
	{ "%+", "AUTHORADDRESS",   SIMPLE,   LEVEL_MAIN },
	{ "%^", "CAPTION",         SIMPLE,   LEVEL_MAIN },
	{ "%[", "ACCESSDATE",      SIMPLE,   LEVEL_MAIN },
	{ "%=", "LASTMODDATE",     SIMPLE,   LEVEL_MAIN },
	{ "%~", "DATABASE",        SIMPLE,   LEVEL_MAIN },
        { "  ", "INTERNAL_TYPE|BOOK",         ALWAYS, LEVEL_MAIN },
        { "  ", "RESOURCE|text",              ALWAYS, LEVEL_MAIN },
        { "  ", "GENRE:BIBUTILS|unpublished", ALWAYS, LEVEL_MAIN },
};


/* order is important....."Book" matches "Book" and "Book Section", hence
 * "Book Section must come first */

#define ORIG(a) ( &(a[0]) )
#define SIZE(a) ( sizeof( a ) / sizeof( lookups ) )
#define REFTYPE(a,b) { a, ORIG(b), SIZE(b) }

variants end_all[] = {
	REFTYPE( "Generic", generic ),
	REFTYPE( "Artwork", artwork ),
	REFTYPE( "Audiovisual Material", audiovisual ),
	REFTYPE( "Bill", bill ),
	REFTYPE( "Book Section", booksection ),
	REFTYPE( "Book", book ),
	REFTYPE( "Case", lawcase ),
	REFTYPE( "Chart or Table", chart ),
	REFTYPE( "Classical Work", generic ),
	REFTYPE( "Computer Program", program ),
	REFTYPE( "Conference Paper", conferencepaper ),
	REFTYPE( "Conference Proceeding", proceedings ),
	REFTYPE( "Edited Book", editedbook ),
/*	REFTYPE( "Equation", equation ), */
/*	REFTYPE( "Electronic Article", electronicarticle ), */
/*	REFTYPE( "Electronic Book", electronicbook ), */
/*	REFTYPE( "Figure", figure ), */
	REFTYPE( "Film or Broadcast", broadcast ),
	REFTYPE( "Electronic Source", electronic ),
/*	REFTYPE( "Government Document", governmentdocument ), */
	REFTYPE( "Hearing", hearing ),
	REFTYPE( "Journal Article", journalarticle ),
/*	REFTYPE( "Legal Rule/Regulation", legalrule ), */
	REFTYPE( "Magazine Article", magazinearticle ),
	REFTYPE( "Manuscript", manuscript ),
	REFTYPE( "Map", map ),
	REFTYPE( "Newspaper Article", newspaperarticle ),
/*	REFTYPE( "Online Database", onlinedatabase ), */
/*	REFTYPE( "Online Multimedia", onlinemultimedia ), */
	REFTYPE( "Patent", patent ),
	REFTYPE( "Personal Communication", communication ),
	REFTYPE( "Report", report ),
	REFTYPE( "Statute", statute ),
	REFTYPE( "Thesis", thesis ),
	REFTYPE( "Unpublished Work", unpublished ),
	REFTYPE( "Web Page", webpage ),
};


int end_nall = sizeof( end_all ) / sizeof( variants );


