// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkdataboxmm/databox.h>
#include <gtkdataboxmm/private/databox_p.h>


/* Copyright (c) 2012  iCub Facility, Istituto Italiano di Tecnologia
 *   @author Daniele E. Domenichelli <daniele.domenichelli@iit.it>
 *
 * This file is part of gtkdataboxmm.
 *
 * gtkdataboxmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * gtkdataboxmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkdatabox.h>
#include <gtkdataboxmm/graph.h>
#include <gtkdataboxmm/ruler.h>
#include <gtkmm/table.h>

using Gtk::manage;

GtkWidget* DataboxHelper(Gtk::Table **table, bool scrollbar_x, bool scrollbar_y, bool ruler_x, bool ruler_y)
{
    GtkWidget *gbox;
    GtkWidget *gtable;
    gtk_databox_create_box_with_scrollbars_and_rulers(&gbox,
                                                      &gtable,
                                                      scrollbar_x,
                                                      scrollbar_y,
                                                      ruler_x,
                                                      ruler_y);
    *table = Glib::wrap(GTK_TABLE(gtable), true);
    return gbox;
}

namespace GDatabox
{

Databox::Databox(Gtk::Table **table, bool scrollbar_x, bool scrollbar_y, bool ruler_x, bool ruler_y) :
    Gtk::Widget(DataboxHelper(table, scrollbar_x, scrollbar_y, ruler_x, ruler_y))
{
}

} // namespace GDatabox

namespace
{


static const Glib::SignalProxyInfo Databox_signal_zoomed_info =
{
  "zoomed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Databox_signal_selection_canceled_info =
{
  "selection_canceled",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

GDatabox::Databox* wrap(GtkDatabox* object, bool take_copy)
{
  return dynamic_cast<GDatabox::Databox *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace GDatabox
{


/* The *_Class implementation: */

const Glib::Class& Databox_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Databox_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_databox_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Databox_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->zoomed = &zoomed_callback;
  klass->selection_canceled = &selection_canceled_callback;
}


void Databox_Class::zoomed_callback(GtkDatabox* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_zoomed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->zoomed)
    (*base->zoomed)(self);
}
void Databox_Class::selection_canceled_callback(GtkDatabox* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_selection_canceled();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_canceled)
    (*base->selection_canceled)(self);
}


Glib::ObjectBase* Databox_Class::wrap_new(GObject* o)
{
  return manage(new Databox((GtkDatabox*)(o)));

}


/* The implementation: */

Databox::Databox(const Glib::ConstructParams& construct_params)
:
  Gtk::Widget(construct_params)
{
  }

Databox::Databox(GtkDatabox* castitem)
:
  Gtk::Widget((GtkWidget*)(castitem))
{
  }

Databox::~Databox()
{
  destroy_();
}

Databox::CppClassType Databox::databox_class_; // initialize static member

GType Databox::get_type()
{
  return databox_class_.init().get_type();
}


GType Databox::get_base_type()
{
  return gtk_databox_get_type();
}


Databox::Databox()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gtk::Widget(Glib::ConstructParams(databox_class_.init()))
{
  

}

int Databox::graph_add(const Glib::RefPtr<Graph> & graph)
{
  return gtk_databox_graph_add(gobj(), Glib::unwrap(graph));
}

int Databox::graph_remove(const Glib::RefPtr<Graph> & graph)
{
  return gtk_databox_graph_remove(gobj(), Glib::unwrap(graph));
}

int Databox::graph_remove_all()
{
  return gtk_databox_graph_remove_all(gobj());
}

int Databox::auto_rescale(float border)
{
  return gtk_databox_auto_rescale(gobj(), border);
}

int Databox::calculate_extrema(float & min_x, float & max_x, float & min_y, float & max_y)
{
  return gtk_databox_calculate_extrema(gobj(), &(min_x), &(max_x), &(min_y), &(max_y));
}

void Databox::set_total_limits(float left, float right, float top, float bottom)
{
  gtk_databox_set_total_limits(gobj(), left, right, top, bottom); 
}

void Databox::set_visible_limits(float left, float right, float top, float bottom)
{
  gtk_databox_set_visible_limits(gobj(), left, right, top, bottom); 
}

void Databox::get_total_limits(float & left, float & right, float & top, float & bottom) const
{
  gtk_databox_get_total_limits(const_cast<GtkDatabox*>(gobj()), &(left), &(right), &(top), &(bottom)); 
}

void Databox::get_visible_limits(float & left, float & right, float & top, float & bottom) const
{
  gtk_databox_get_visible_limits(const_cast<GtkDatabox*>(gobj()), &(left), &(right), &(top), &(bottom)); 
}

void Databox::set_adjustment_x(Gtk::Adjustment & adj)
{
  gtk_databox_set_adjustment_x(gobj(), (adj).gobj()); 
}

void Databox::set_adjustment_y(Gtk::Adjustment & adj)
{
  gtk_databox_set_adjustment_y(gobj(), (adj).gobj()); 
}

Gtk::Adjustment* Databox::get_adjustment_x()
{
  return Glib::wrap(gtk_databox_get_adjustment_x(gobj()));
}

const Gtk::Adjustment* Databox::get_adjustment_x() const
{
  return const_cast<Databox*>(this)->get_adjustment_x();
}

Gtk::Adjustment* Databox::get_adjustment_y()
{
  return Glib::wrap(gtk_databox_get_adjustment_y(gobj()));
}

const Gtk::Adjustment* Databox::get_adjustment_y() const
{
  return const_cast<Databox*>(this)->get_adjustment_y();
}

void Databox::set_ruler_x(const Ruler& ruler)
{
  gtk_databox_set_ruler_x(gobj(), const_cast<GtkDataboxRuler*>((ruler).gobj())); 
}

void Databox::set_ruler_y(const Ruler& ruler)
{
  gtk_databox_set_ruler_y(gobj(), const_cast<GtkDataboxRuler*>((ruler).gobj())); 
}

const Ruler* Databox::get_ruler_x() const
{
  return Glib::wrap(gtk_databox_get_ruler_x(const_cast<GtkDatabox*>(gobj())));
}

const Ruler* Databox::get_ruler_y() const
{
  return Glib::wrap(gtk_databox_get_ruler_y(const_cast<GtkDatabox*>(gobj())));
}

void Databox::set_enable_selection(bool enable)
{
  gtk_databox_set_enable_selection(gobj(), static_cast<int>(enable)); 
}

void Databox::set_enable_zoom(bool enable)
{
  gtk_databox_set_enable_zoom(gobj(), static_cast<int>(enable)); 
}

bool Databox::get_enable_selection() const
{
  return gtk_databox_get_enable_selection(const_cast<GtkDatabox*>(gobj()));
}

bool Databox::get_enable_zoom() const
{
  return gtk_databox_get_enable_selection(const_cast<GtkDatabox*>(gobj()));
}

void Databox::zoom_to_selection()
{
  gtk_databox_zoom_to_selection(gobj()); 
}

void Databox::zoom_out()
{
  gtk_databox_zoom_out(gobj()); 
}

void Databox::zoom_home()
{
  gtk_databox_zoom_home(gobj()); 
}

short Databox::value_to_pixel_x(float value)
{
  return gtk_databox_value_to_pixel_x(gobj(), value);
}

short Databox::value_to_pixel_y(float value)
{
  return gtk_databox_value_to_pixel_x(gobj(), value);
}

float Databox::pixel_to_value_x(short pixel)
{
  return gtk_databox_pixel_to_value_x(gobj(), pixel);
}

float Databox::pixel_to_value_y(short pixel)
{
  return gtk_databox_pixel_to_value_y(gobj(), pixel);
}

Glib::RefPtr<Gdk::Pixmap> Databox::get_backing_pixmap() const
{
  return Glib::wrap((GdkPixmapObject*)(gtk_databox_get_backing_pixmap(const_cast<GtkDatabox*>(gobj()))));
}


Glib::SignalProxy0< void > Databox::signal_zoomed()
{
  return Glib::SignalProxy0< void >(this, &Databox_signal_zoomed_info);
}


Glib::SignalProxy0< void > Databox::signal_selection_canceled()
{
  return Glib::SignalProxy0< void >(this, &Databox_signal_selection_canceled_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< bool > Databox::property_enable_selection() 
{
  return Glib::PropertyProxy< bool >(this, "enable-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Databox::property_enable_selection() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "enable-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< bool > Databox::property_enable_zoom() 
{
  return Glib::PropertyProxy< bool >(this, "enable-zoom");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Databox::property_enable_zoom() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "enable-zoom");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Gtk::Adjustment* > Databox::property_adjustment_x() 
{
  return Glib::PropertyProxy< Gtk::Adjustment* >(this, "adjustment-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Gtk::Adjustment* > Databox::property_adjustment_x() const
{
  return Glib::PropertyProxy_ReadOnly< Gtk::Adjustment* >(this, "adjustment-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Gtk::Adjustment* > Databox::property_adjustment_y() 
{
  return Glib::PropertyProxy< Gtk::Adjustment* >(this, "adjustment-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Gtk::Adjustment* > Databox::property_adjustment_y() const
{
  return Glib::PropertyProxy_ReadOnly< Gtk::Adjustment* >(this, "adjustment-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Ruler > Databox::property_ruler_x() 
{
  return Glib::PropertyProxy< Ruler >(this, "ruler-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Ruler > Databox::property_ruler_x() const
{
  return Glib::PropertyProxy_ReadOnly< Ruler >(this, "ruler-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Ruler > Databox::property_ruler_y() 
{
  return Glib::PropertyProxy< Ruler >(this, "ruler-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Ruler > Databox::property_ruler_y() const
{
  return Glib::PropertyProxy_ReadOnly< Ruler >(this, "ruler-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void GDatabox::Databox::on_zoomed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->zoomed)
    (*base->zoomed)(gobj());
}
void GDatabox::Databox::on_selection_canceled()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_canceled)
    (*base->selection_canceled)(gobj());
}


} // namespace GDatabox


