// Code generated by protoc-gen-go. DO NOT EDIT.
// source: grpc/service_config/service_config.proto

package grpc_service_config

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	code "google.golang.org/genproto/googleapis/rpc/code"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Load balancing policy.
//
// Note that load_balancing_policy is deprecated in favor of
// load_balancing_config; the former will be used only if the latter
// is unset.
//
// If no LB policy is configured here, then the default is pick_first.
// If the policy name is set via the client API, that value overrides
// the value specified here.
//
// If the deprecated load_balancing_policy field is used, note that if the
// resolver returns at least one balancer address (as opposed to backend
// addresses), gRPC will use grpclb (see
// https://github.com/grpc/grpc/blob/master/doc/load-balancing.md),
// regardless of what policy is configured here.  However, if the resolver
// returns at least one backend address in addition to the balancer
// address(es), the client may fall back to the requested policy if it
// is unable to reach any of the grpclb load balancers.
type ServiceConfig_LoadBalancingPolicy int32

const (
	ServiceConfig_UNSPECIFIED ServiceConfig_LoadBalancingPolicy = 0
	ServiceConfig_ROUND_ROBIN ServiceConfig_LoadBalancingPolicy = 1
)

var ServiceConfig_LoadBalancingPolicy_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "ROUND_ROBIN",
}

var ServiceConfig_LoadBalancingPolicy_value = map[string]int32{
	"UNSPECIFIED": 0,
	"ROUND_ROBIN": 1,
}

func (x ServiceConfig_LoadBalancingPolicy) String() string {
	return proto.EnumName(ServiceConfig_LoadBalancingPolicy_name, int32(x))
}

func (ServiceConfig_LoadBalancingPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{7, 0}
}

// Configuration for a method.
type MethodConfig struct {
	Name []*MethodConfig_Name `protobuf:"bytes,1,rep,name=name,proto3" json:"name,omitempty"`
	// Whether RPCs sent to this method should wait until the connection is
	// ready by default. If false, the RPC will abort immediately if there is
	// a transient failure connecting to the server. Otherwise, gRPC will
	// attempt to connect until the deadline is exceeded.
	//
	// The value specified via the gRPC client API will override the value
	// set here. However, note that setting the value in the client API will
	// also affect transient errors encountered during name resolution, which
	// cannot be caught by the value here, since the service config is
	// obtained by the gRPC client via name resolution.
	WaitForReady *wrappers.BoolValue `protobuf:"bytes,2,opt,name=wait_for_ready,json=waitForReady,proto3" json:"wait_for_ready,omitempty"`
	// The default timeout in seconds for RPCs sent to this method. This can be
	// overridden in code. If no reply is received in the specified amount of
	// time, the request is aborted and a DEADLINE_EXCEEDED error status
	// is returned to the caller.
	//
	// The actual deadline used will be the minimum of the value specified here
	// and the value set by the application via the gRPC client API.  If either
	// one is not set, then the other will be used.  If neither is set, then the
	// request has no deadline.
	Timeout *duration.Duration `protobuf:"bytes,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The maximum allowed payload size for an individual request or object in a
	// stream (client->server) in bytes. The size which is measured is the
	// serialized payload after per-message compression (but before stream
	// compression) in bytes. This applies both to streaming and non-streaming
	// requests.
	//
	// The actual value used is the minimum of the value specified here and the
	// value set by the application via the gRPC client API.  If either one is
	// not set, then the other will be used.  If neither is set, then the
	// built-in default is used.
	//
	// If a client attempts to send an object larger than this value, it will not
	// be sent and the client will see a ClientError.
	// Note that 0 is a valid value, meaning that the request message
	// must be empty.
	MaxRequestMessageBytes *wrappers.UInt32Value `protobuf:"bytes,4,opt,name=max_request_message_bytes,json=maxRequestMessageBytes,proto3" json:"max_request_message_bytes,omitempty"`
	// The maximum allowed payload size for an individual response or object in a
	// stream (server->client) in bytes. The size which is measured is the
	// serialized payload after per-message compression (but before stream
	// compression) in bytes. This applies both to streaming and non-streaming
	// requests.
	//
	// The actual value used is the minimum of the value specified here and the
	// value set by the application via the gRPC client API.  If either one is
	// not set, then the other will be used.  If neither is set, then the
	// built-in default is used.
	//
	// If a server attempts to send an object larger than this value, it will not
	// be sent, and a ServerError will be sent to the client instead.
	// Note that 0 is a valid value, meaning that the response message
	// must be empty.
	MaxResponseMessageBytes *wrappers.UInt32Value `protobuf:"bytes,5,opt,name=max_response_message_bytes,json=maxResponseMessageBytes,proto3" json:"max_response_message_bytes,omitempty"`
	// Only one of retry_policy or hedging_policy may be set. If neither is set,
	// RPCs will not be retried or hedged.
	//
	// Types that are valid to be assigned to RetryOrHedgingPolicy:
	//	*MethodConfig_RetryPolicy_
	//	*MethodConfig_HedgingPolicy_
	RetryOrHedgingPolicy isMethodConfig_RetryOrHedgingPolicy `protobuf_oneof:"retry_or_hedging_policy"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *MethodConfig) Reset()         { *m = MethodConfig{} }
func (m *MethodConfig) String() string { return proto.CompactTextString(m) }
func (*MethodConfig) ProtoMessage()    {}
func (*MethodConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{0}
}

func (m *MethodConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MethodConfig.Unmarshal(m, b)
}
func (m *MethodConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MethodConfig.Marshal(b, m, deterministic)
}
func (m *MethodConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MethodConfig.Merge(m, src)
}
func (m *MethodConfig) XXX_Size() int {
	return xxx_messageInfo_MethodConfig.Size(m)
}
func (m *MethodConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MethodConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MethodConfig proto.InternalMessageInfo

func (m *MethodConfig) GetName() []*MethodConfig_Name {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *MethodConfig) GetWaitForReady() *wrappers.BoolValue {
	if m != nil {
		return m.WaitForReady
	}
	return nil
}

func (m *MethodConfig) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *MethodConfig) GetMaxRequestMessageBytes() *wrappers.UInt32Value {
	if m != nil {
		return m.MaxRequestMessageBytes
	}
	return nil
}

func (m *MethodConfig) GetMaxResponseMessageBytes() *wrappers.UInt32Value {
	if m != nil {
		return m.MaxResponseMessageBytes
	}
	return nil
}

type isMethodConfig_RetryOrHedgingPolicy interface {
	isMethodConfig_RetryOrHedgingPolicy()
}

type MethodConfig_RetryPolicy_ struct {
	RetryPolicy *MethodConfig_RetryPolicy `protobuf:"bytes,6,opt,name=retry_policy,json=retryPolicy,proto3,oneof"`
}

type MethodConfig_HedgingPolicy_ struct {
	HedgingPolicy *MethodConfig_HedgingPolicy `protobuf:"bytes,7,opt,name=hedging_policy,json=hedgingPolicy,proto3,oneof"`
}

func (*MethodConfig_RetryPolicy_) isMethodConfig_RetryOrHedgingPolicy() {}

func (*MethodConfig_HedgingPolicy_) isMethodConfig_RetryOrHedgingPolicy() {}

func (m *MethodConfig) GetRetryOrHedgingPolicy() isMethodConfig_RetryOrHedgingPolicy {
	if m != nil {
		return m.RetryOrHedgingPolicy
	}
	return nil
}

func (m *MethodConfig) GetRetryPolicy() *MethodConfig_RetryPolicy {
	if x, ok := m.GetRetryOrHedgingPolicy().(*MethodConfig_RetryPolicy_); ok {
		return x.RetryPolicy
	}
	return nil
}

func (m *MethodConfig) GetHedgingPolicy() *MethodConfig_HedgingPolicy {
	if x, ok := m.GetRetryOrHedgingPolicy().(*MethodConfig_HedgingPolicy_); ok {
		return x.HedgingPolicy
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MethodConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MethodConfig_RetryPolicy_)(nil),
		(*MethodConfig_HedgingPolicy_)(nil),
	}
}

// The names of the methods to which this configuration applies.
// - MethodConfig without names (empty list) will be skipped.
// - Each name entry must be unique across the entire ServiceConfig.
// - If the 'method' field is empty, this MethodConfig specifies the defaults
//   for all methods for the specified service.
// - If the 'service' field is empty, the 'method' field must be empty, and
//   this MethodConfig specifies the default for all methods (it's the default
//   config).
//
// When determining which MethodConfig to use for a given RPC, the most
// specific match wins. For example, let's say that the service config
// contains the following MethodConfig entries:
//
// method_config { name { } ... }
// method_config { name { service: "MyService" } ... }
// method_config { name { service: "MyService" method: "Foo" } ... }
//
// MyService/Foo will use the third entry, because it exactly matches the
// service and method name. MyService/Bar will use the second entry, because
// it provides the default for all methods of MyService. AnotherService/Baz
// will use the first entry, because it doesn't match the other two.
//
// In JSON representation, value "", value `null`, and not present are the
// same. The following are the same Name:
// - { "service": "s" }
// - { "service": "s", "method": null }
// - { "service": "s", "method": "" }
type MethodConfig_Name struct {
	Service              string   `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	Method               string   `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MethodConfig_Name) Reset()         { *m = MethodConfig_Name{} }
func (m *MethodConfig_Name) String() string { return proto.CompactTextString(m) }
func (*MethodConfig_Name) ProtoMessage()    {}
func (*MethodConfig_Name) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{0, 0}
}

func (m *MethodConfig_Name) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MethodConfig_Name.Unmarshal(m, b)
}
func (m *MethodConfig_Name) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MethodConfig_Name.Marshal(b, m, deterministic)
}
func (m *MethodConfig_Name) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MethodConfig_Name.Merge(m, src)
}
func (m *MethodConfig_Name) XXX_Size() int {
	return xxx_messageInfo_MethodConfig_Name.Size(m)
}
func (m *MethodConfig_Name) XXX_DiscardUnknown() {
	xxx_messageInfo_MethodConfig_Name.DiscardUnknown(m)
}

var xxx_messageInfo_MethodConfig_Name proto.InternalMessageInfo

func (m *MethodConfig_Name) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *MethodConfig_Name) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

// The retry policy for outgoing RPCs.
type MethodConfig_RetryPolicy struct {
	// The maximum number of RPC attempts, including the original attempt.
	//
	// This field is required and must be greater than 1.
	// Any value greater than 5 will be treated as if it were 5.
	MaxAttempts uint32 `protobuf:"varint,1,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// Exponential backoff parameters. The initial retry attempt will occur at
	// random(0, initial_backoff). In general, the nth attempt will occur at
	// random(0,
	//   min(initial_backoff*backoff_multiplier**(n-1), max_backoff)).
	// Required. Must be greater than zero.
	InitialBackoff *duration.Duration `protobuf:"bytes,2,opt,name=initial_backoff,json=initialBackoff,proto3" json:"initial_backoff,omitempty"`
	// Required. Must be greater than zero.
	MaxBackoff        *duration.Duration `protobuf:"bytes,3,opt,name=max_backoff,json=maxBackoff,proto3" json:"max_backoff,omitempty"`
	BackoffMultiplier float32            `protobuf:"fixed32,4,opt,name=backoff_multiplier,json=backoffMultiplier,proto3" json:"backoff_multiplier,omitempty"`
	// The set of status codes which may be retried.
	//
	// This field is required and must be non-empty.
	RetryableStatusCodes []code.Code `protobuf:"varint,5,rep,packed,name=retryable_status_codes,json=retryableStatusCodes,proto3,enum=google.rpc.Code" json:"retryable_status_codes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *MethodConfig_RetryPolicy) Reset()         { *m = MethodConfig_RetryPolicy{} }
func (m *MethodConfig_RetryPolicy) String() string { return proto.CompactTextString(m) }
func (*MethodConfig_RetryPolicy) ProtoMessage()    {}
func (*MethodConfig_RetryPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{0, 1}
}

func (m *MethodConfig_RetryPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MethodConfig_RetryPolicy.Unmarshal(m, b)
}
func (m *MethodConfig_RetryPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MethodConfig_RetryPolicy.Marshal(b, m, deterministic)
}
func (m *MethodConfig_RetryPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MethodConfig_RetryPolicy.Merge(m, src)
}
func (m *MethodConfig_RetryPolicy) XXX_Size() int {
	return xxx_messageInfo_MethodConfig_RetryPolicy.Size(m)
}
func (m *MethodConfig_RetryPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_MethodConfig_RetryPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_MethodConfig_RetryPolicy proto.InternalMessageInfo

func (m *MethodConfig_RetryPolicy) GetMaxAttempts() uint32 {
	if m != nil {
		return m.MaxAttempts
	}
	return 0
}

func (m *MethodConfig_RetryPolicy) GetInitialBackoff() *duration.Duration {
	if m != nil {
		return m.InitialBackoff
	}
	return nil
}

func (m *MethodConfig_RetryPolicy) GetMaxBackoff() *duration.Duration {
	if m != nil {
		return m.MaxBackoff
	}
	return nil
}

func (m *MethodConfig_RetryPolicy) GetBackoffMultiplier() float32 {
	if m != nil {
		return m.BackoffMultiplier
	}
	return 0
}

func (m *MethodConfig_RetryPolicy) GetRetryableStatusCodes() []code.Code {
	if m != nil {
		return m.RetryableStatusCodes
	}
	return nil
}

// The hedging policy for outgoing RPCs. Hedged RPCs may execute more than
// once on the server, so only idempotent methods should specify a hedging
// policy.
type MethodConfig_HedgingPolicy struct {
	// The hedging policy will send up to max_requests RPCs.
	// This number represents the total number of all attempts, including
	// the original attempt.
	//
	// This field is required and must be greater than 1.
	// Any value greater than 5 will be treated as if it were 5.
	MaxAttempts uint32 `protobuf:"varint,1,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// The first RPC will be sent immediately, but the max_requests-1 subsequent
	// hedged RPCs will be sent at intervals of every hedging_delay. Set this
	// to 0 to immediately send all max_requests RPCs.
	HedgingDelay *duration.Duration `protobuf:"bytes,2,opt,name=hedging_delay,json=hedgingDelay,proto3" json:"hedging_delay,omitempty"`
	// The set of status codes which indicate other hedged RPCs may still
	// succeed. If a non-fatal status code is returned by the server, hedged
	// RPCs will continue. Otherwise, outstanding requests will be canceled and
	// the error returned to the client application layer.
	//
	// This field is optional.
	NonFatalStatusCodes  []code.Code `protobuf:"varint,3,rep,packed,name=non_fatal_status_codes,json=nonFatalStatusCodes,proto3,enum=google.rpc.Code" json:"non_fatal_status_codes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *MethodConfig_HedgingPolicy) Reset()         { *m = MethodConfig_HedgingPolicy{} }
func (m *MethodConfig_HedgingPolicy) String() string { return proto.CompactTextString(m) }
func (*MethodConfig_HedgingPolicy) ProtoMessage()    {}
func (*MethodConfig_HedgingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{0, 2}
}

func (m *MethodConfig_HedgingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MethodConfig_HedgingPolicy.Unmarshal(m, b)
}
func (m *MethodConfig_HedgingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MethodConfig_HedgingPolicy.Marshal(b, m, deterministic)
}
func (m *MethodConfig_HedgingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MethodConfig_HedgingPolicy.Merge(m, src)
}
func (m *MethodConfig_HedgingPolicy) XXX_Size() int {
	return xxx_messageInfo_MethodConfig_HedgingPolicy.Size(m)
}
func (m *MethodConfig_HedgingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_MethodConfig_HedgingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_MethodConfig_HedgingPolicy proto.InternalMessageInfo

func (m *MethodConfig_HedgingPolicy) GetMaxAttempts() uint32 {
	if m != nil {
		return m.MaxAttempts
	}
	return 0
}

func (m *MethodConfig_HedgingPolicy) GetHedgingDelay() *duration.Duration {
	if m != nil {
		return m.HedgingDelay
	}
	return nil
}

func (m *MethodConfig_HedgingPolicy) GetNonFatalStatusCodes() []code.Code {
	if m != nil {
		return m.NonFatalStatusCodes
	}
	return nil
}

// Configuration for pick_first LB policy.
type PickFirstConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PickFirstConfig) Reset()         { *m = PickFirstConfig{} }
func (m *PickFirstConfig) String() string { return proto.CompactTextString(m) }
func (*PickFirstConfig) ProtoMessage()    {}
func (*PickFirstConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{1}
}

func (m *PickFirstConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PickFirstConfig.Unmarshal(m, b)
}
func (m *PickFirstConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PickFirstConfig.Marshal(b, m, deterministic)
}
func (m *PickFirstConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PickFirstConfig.Merge(m, src)
}
func (m *PickFirstConfig) XXX_Size() int {
	return xxx_messageInfo_PickFirstConfig.Size(m)
}
func (m *PickFirstConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PickFirstConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PickFirstConfig proto.InternalMessageInfo

// Configuration for round_robin LB policy.
type RoundRobinConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoundRobinConfig) Reset()         { *m = RoundRobinConfig{} }
func (m *RoundRobinConfig) String() string { return proto.CompactTextString(m) }
func (*RoundRobinConfig) ProtoMessage()    {}
func (*RoundRobinConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{2}
}

func (m *RoundRobinConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RoundRobinConfig.Unmarshal(m, b)
}
func (m *RoundRobinConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RoundRobinConfig.Marshal(b, m, deterministic)
}
func (m *RoundRobinConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoundRobinConfig.Merge(m, src)
}
func (m *RoundRobinConfig) XXX_Size() int {
	return xxx_messageInfo_RoundRobinConfig.Size(m)
}
func (m *RoundRobinConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_RoundRobinConfig.DiscardUnknown(m)
}

var xxx_messageInfo_RoundRobinConfig proto.InternalMessageInfo

// Configuration for grpclb LB policy.
type GrpcLbConfig struct {
	// Optional.  What LB policy to use for routing between the backend
	// addresses.  If unset, defaults to round_robin.
	// Currently, the only supported values are round_robin and pick_first.
	// Note that this will be used both in balancer mode and in fallback mode.
	// Multiple LB policies can be specified; clients will iterate through
	// the list in order and stop at the first policy that they support.
	ChildPolicy []*LoadBalancingConfig `protobuf:"bytes,1,rep,name=child_policy,json=childPolicy,proto3" json:"child_policy,omitempty"`
	// Optional.  If specified, overrides the name of the service to be sent to
	// the balancer.
	ServiceName          string   `protobuf:"bytes,2,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GrpcLbConfig) Reset()         { *m = GrpcLbConfig{} }
func (m *GrpcLbConfig) String() string { return proto.CompactTextString(m) }
func (*GrpcLbConfig) ProtoMessage()    {}
func (*GrpcLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{3}
}

func (m *GrpcLbConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GrpcLbConfig.Unmarshal(m, b)
}
func (m *GrpcLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GrpcLbConfig.Marshal(b, m, deterministic)
}
func (m *GrpcLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GrpcLbConfig.Merge(m, src)
}
func (m *GrpcLbConfig) XXX_Size() int {
	return xxx_messageInfo_GrpcLbConfig.Size(m)
}
func (m *GrpcLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GrpcLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GrpcLbConfig proto.InternalMessageInfo

func (m *GrpcLbConfig) GetChildPolicy() []*LoadBalancingConfig {
	if m != nil {
		return m.ChildPolicy
	}
	return nil
}

func (m *GrpcLbConfig) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Configuration for the cds LB policy.
type CdsConfig struct {
	Cluster              string   `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CdsConfig) Reset()         { *m = CdsConfig{} }
func (m *CdsConfig) String() string { return proto.CompactTextString(m) }
func (*CdsConfig) ProtoMessage()    {}
func (*CdsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{4}
}

func (m *CdsConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CdsConfig.Unmarshal(m, b)
}
func (m *CdsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CdsConfig.Marshal(b, m, deterministic)
}
func (m *CdsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CdsConfig.Merge(m, src)
}
func (m *CdsConfig) XXX_Size() int {
	return xxx_messageInfo_CdsConfig.Size(m)
}
func (m *CdsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_CdsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_CdsConfig proto.InternalMessageInfo

func (m *CdsConfig) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

// Configuration for xds LB policy.
type XdsConfig struct {
	// Name of balancer to connect to.
	BalancerName string `protobuf:"bytes,1,opt,name=balancer_name,json=balancerName,proto3" json:"balancer_name,omitempty"` // Deprecated: Do not use.
	// Optional.  What LB policy to use for intra-locality routing.
	// If unset, will use whatever algorithm is specified by the balancer.
	// Multiple LB policies can be specified; clients will iterate through
	// the list in order and stop at the first policy that they support.
	ChildPolicy []*LoadBalancingConfig `protobuf:"bytes,2,rep,name=child_policy,json=childPolicy,proto3" json:"child_policy,omitempty"`
	// Optional.  What LB policy to use in fallback mode.  If not
	// specified, defaults to round_robin.
	// Multiple LB policies can be specified; clients will iterate through
	// the list in order and stop at the first policy that they support.
	FallbackPolicy []*LoadBalancingConfig `protobuf:"bytes,3,rep,name=fallback_policy,json=fallbackPolicy,proto3" json:"fallback_policy,omitempty"`
	// Optional.  Name to use in EDS query.  If not present, defaults to
	// the server name from the target URI.
	EdsServiceName string `protobuf:"bytes,4,opt,name=eds_service_name,json=edsServiceName,proto3" json:"eds_service_name,omitempty"`
	// LRS server to send load reports to.
	// If not present, load reporting will be disabled.
	// If set to the empty string, load reporting will be sent to the same
	// server that we obtained CDS data from.
	LrsLoadReportingServerName *wrappers.StringValue `protobuf:"bytes,5,opt,name=lrs_load_reporting_server_name,json=lrsLoadReportingServerName,proto3" json:"lrs_load_reporting_server_name,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}              `json:"-"`
	XXX_unrecognized           []byte                `json:"-"`
	XXX_sizecache              int32                 `json:"-"`
}

func (m *XdsConfig) Reset()         { *m = XdsConfig{} }
func (m *XdsConfig) String() string { return proto.CompactTextString(m) }
func (*XdsConfig) ProtoMessage()    {}
func (*XdsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{5}
}

func (m *XdsConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_XdsConfig.Unmarshal(m, b)
}
func (m *XdsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_XdsConfig.Marshal(b, m, deterministic)
}
func (m *XdsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_XdsConfig.Merge(m, src)
}
func (m *XdsConfig) XXX_Size() int {
	return xxx_messageInfo_XdsConfig.Size(m)
}
func (m *XdsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_XdsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_XdsConfig proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *XdsConfig) GetBalancerName() string {
	if m != nil {
		return m.BalancerName
	}
	return ""
}

func (m *XdsConfig) GetChildPolicy() []*LoadBalancingConfig {
	if m != nil {
		return m.ChildPolicy
	}
	return nil
}

func (m *XdsConfig) GetFallbackPolicy() []*LoadBalancingConfig {
	if m != nil {
		return m.FallbackPolicy
	}
	return nil
}

func (m *XdsConfig) GetEdsServiceName() string {
	if m != nil {
		return m.EdsServiceName
	}
	return ""
}

func (m *XdsConfig) GetLrsLoadReportingServerName() *wrappers.StringValue {
	if m != nil {
		return m.LrsLoadReportingServerName
	}
	return nil
}

// Selects LB policy and provides corresponding configuration.
//
// In general, all instances of this field should be repeated. Clients will
// iterate through the list in order and stop at the first policy that they
// support.  This allows the service config to specify custom policies that may
// not be known to all clients.
//
// - If the config for the first supported policy is invalid, the whole service
//   config is invalid.
// - If the list doesn't contain any supported policy, the whole service config
//   is invalid.
type LoadBalancingConfig struct {
	// Exactly one LB policy may be configured.
	//
	// Types that are valid to be assigned to Policy:
	//	*LoadBalancingConfig_PickFirst
	//	*LoadBalancingConfig_RoundRobin
	//	*LoadBalancingConfig_Grpclb
	//	*LoadBalancingConfig_Cds
	//	*LoadBalancingConfig_Xds
	//	*LoadBalancingConfig_XdsExperimental
	Policy               isLoadBalancingConfig_Policy `protobuf_oneof:"policy"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *LoadBalancingConfig) Reset()         { *m = LoadBalancingConfig{} }
func (m *LoadBalancingConfig) String() string { return proto.CompactTextString(m) }
func (*LoadBalancingConfig) ProtoMessage()    {}
func (*LoadBalancingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{6}
}

func (m *LoadBalancingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancingConfig.Unmarshal(m, b)
}
func (m *LoadBalancingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancingConfig.Marshal(b, m, deterministic)
}
func (m *LoadBalancingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancingConfig.Merge(m, src)
}
func (m *LoadBalancingConfig) XXX_Size() int {
	return xxx_messageInfo_LoadBalancingConfig.Size(m)
}
func (m *LoadBalancingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancingConfig proto.InternalMessageInfo

type isLoadBalancingConfig_Policy interface {
	isLoadBalancingConfig_Policy()
}

type LoadBalancingConfig_PickFirst struct {
	PickFirst *PickFirstConfig `protobuf:"bytes,4,opt,name=pick_first,proto3,oneof"`
}

type LoadBalancingConfig_RoundRobin struct {
	RoundRobin *RoundRobinConfig `protobuf:"bytes,1,opt,name=round_robin,proto3,oneof"`
}

type LoadBalancingConfig_Grpclb struct {
	Grpclb *GrpcLbConfig `protobuf:"bytes,3,opt,name=grpclb,proto3,oneof"`
}

type LoadBalancingConfig_Cds struct {
	Cds *CdsConfig `protobuf:"bytes,6,opt,name=cds,proto3,oneof"`
}

type LoadBalancingConfig_Xds struct {
	Xds *XdsConfig `protobuf:"bytes,2,opt,name=xds,proto3,oneof"`
}

type LoadBalancingConfig_XdsExperimental struct {
	XdsExperimental *XdsConfig `protobuf:"bytes,5,opt,name=xds_experimental,proto3,oneof"`
}

func (*LoadBalancingConfig_PickFirst) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_RoundRobin) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Grpclb) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Cds) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Xds) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_XdsExperimental) isLoadBalancingConfig_Policy() {}

func (m *LoadBalancingConfig) GetPolicy() isLoadBalancingConfig_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *LoadBalancingConfig) GetPickFirst() *PickFirstConfig {
	if x, ok := m.GetPolicy().(*LoadBalancingConfig_PickFirst); ok {
		return x.PickFirst
	}
	return nil
}

func (m *LoadBalancingConfig) GetRoundRobin() *RoundRobinConfig {
	if x, ok := m.GetPolicy().(*LoadBalancingConfig_RoundRobin); ok {
		return x.RoundRobin
	}
	return nil
}

func (m *LoadBalancingConfig) GetGrpclb() *GrpcLbConfig {
	if x, ok := m.GetPolicy().(*LoadBalancingConfig_Grpclb); ok {
		return x.Grpclb
	}
	return nil
}

func (m *LoadBalancingConfig) GetCds() *CdsConfig {
	if x, ok := m.GetPolicy().(*LoadBalancingConfig_Cds); ok {
		return x.Cds
	}
	return nil
}

func (m *LoadBalancingConfig) GetXds() *XdsConfig {
	if x, ok := m.GetPolicy().(*LoadBalancingConfig_Xds); ok {
		return x.Xds
	}
	return nil
}

func (m *LoadBalancingConfig) GetXdsExperimental() *XdsConfig {
	if x, ok := m.GetPolicy().(*LoadBalancingConfig_XdsExperimental); ok {
		return x.XdsExperimental
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LoadBalancingConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LoadBalancingConfig_PickFirst)(nil),
		(*LoadBalancingConfig_RoundRobin)(nil),
		(*LoadBalancingConfig_Grpclb)(nil),
		(*LoadBalancingConfig_Cds)(nil),
		(*LoadBalancingConfig_Xds)(nil),
		(*LoadBalancingConfig_XdsExperimental)(nil),
	}
}

// A ServiceConfig represents information about a service but is not specific to
// any name resolver.
type ServiceConfig struct {
	LoadBalancingPolicy ServiceConfig_LoadBalancingPolicy `protobuf:"varint,1,opt,name=load_balancing_policy,json=loadBalancingPolicy,proto3,enum=grpc.service_config.ServiceConfig_LoadBalancingPolicy" json:"load_balancing_policy,omitempty"` // Deprecated: Do not use.
	// Multiple LB policies can be specified; clients will iterate through
	// the list in order and stop at the first policy that they support. If none
	// are supported, the service config is considered invalid.
	LoadBalancingConfig []*LoadBalancingConfig `protobuf:"bytes,4,rep,name=load_balancing_config,json=loadBalancingConfig,proto3" json:"load_balancing_config,omitempty"`
	// Per-method configuration.
	MethodConfig         []*MethodConfig                      `protobuf:"bytes,2,rep,name=method_config,json=methodConfig,proto3" json:"method_config,omitempty"`
	RetryThrottling      *ServiceConfig_RetryThrottlingPolicy `protobuf:"bytes,3,opt,name=retry_throttling,json=retryThrottling,proto3" json:"retry_throttling,omitempty"`
	HealthCheckConfig    *ServiceConfig_HealthCheckConfig     `protobuf:"bytes,5,opt,name=health_check_config,json=healthCheckConfig,proto3" json:"health_check_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ServiceConfig) Reset()         { *m = ServiceConfig{} }
func (m *ServiceConfig) String() string { return proto.CompactTextString(m) }
func (*ServiceConfig) ProtoMessage()    {}
func (*ServiceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{7}
}

func (m *ServiceConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceConfig.Unmarshal(m, b)
}
func (m *ServiceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceConfig.Marshal(b, m, deterministic)
}
func (m *ServiceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceConfig.Merge(m, src)
}
func (m *ServiceConfig) XXX_Size() int {
	return xxx_messageInfo_ServiceConfig.Size(m)
}
func (m *ServiceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceConfig proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *ServiceConfig) GetLoadBalancingPolicy() ServiceConfig_LoadBalancingPolicy {
	if m != nil {
		return m.LoadBalancingPolicy
	}
	return ServiceConfig_UNSPECIFIED
}

func (m *ServiceConfig) GetLoadBalancingConfig() []*LoadBalancingConfig {
	if m != nil {
		return m.LoadBalancingConfig
	}
	return nil
}

func (m *ServiceConfig) GetMethodConfig() []*MethodConfig {
	if m != nil {
		return m.MethodConfig
	}
	return nil
}

func (m *ServiceConfig) GetRetryThrottling() *ServiceConfig_RetryThrottlingPolicy {
	if m != nil {
		return m.RetryThrottling
	}
	return nil
}

func (m *ServiceConfig) GetHealthCheckConfig() *ServiceConfig_HealthCheckConfig {
	if m != nil {
		return m.HealthCheckConfig
	}
	return nil
}

// If a RetryThrottlingPolicy is provided, gRPC will automatically throttle
// retry attempts and hedged RPCs when the client's ratio of failures to
// successes exceeds a threshold.
//
// For each server name, the gRPC client will maintain a token_count which is
// initially set to max_tokens. Every outgoing RPC (regardless of service or
// method invoked) will change token_count as follows:
//
//   - Every failed RPC will decrement the token_count by 1.
//   - Every successful RPC will increment the token_count by token_ratio.
//
// If token_count is less than or equal to max_tokens / 2, then RPCs will not
// be retried and hedged RPCs will not be sent.
type ServiceConfig_RetryThrottlingPolicy struct {
	// The number of tokens starts at max_tokens. The token_count will always be
	// between 0 and max_tokens.
	//
	// This field is required and must be greater than zero.
	MaxTokens uint32 `protobuf:"varint,1,opt,name=max_tokens,json=maxTokens,proto3" json:"max_tokens,omitempty"`
	// The amount of tokens to add on each successful RPC. Typically this will
	// be some number between 0 and 1, e.g., 0.1.
	//
	// This field is required and must be greater than zero. Up to 3 decimal
	// places are supported.
	TokenRatio           float32  `protobuf:"fixed32,2,opt,name=token_ratio,json=tokenRatio,proto3" json:"token_ratio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServiceConfig_RetryThrottlingPolicy) Reset()         { *m = ServiceConfig_RetryThrottlingPolicy{} }
func (m *ServiceConfig_RetryThrottlingPolicy) String() string { return proto.CompactTextString(m) }
func (*ServiceConfig_RetryThrottlingPolicy) ProtoMessage()    {}
func (*ServiceConfig_RetryThrottlingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{7, 0}
}

func (m *ServiceConfig_RetryThrottlingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceConfig_RetryThrottlingPolicy.Unmarshal(m, b)
}
func (m *ServiceConfig_RetryThrottlingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceConfig_RetryThrottlingPolicy.Marshal(b, m, deterministic)
}
func (m *ServiceConfig_RetryThrottlingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceConfig_RetryThrottlingPolicy.Merge(m, src)
}
func (m *ServiceConfig_RetryThrottlingPolicy) XXX_Size() int {
	return xxx_messageInfo_ServiceConfig_RetryThrottlingPolicy.Size(m)
}
func (m *ServiceConfig_RetryThrottlingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceConfig_RetryThrottlingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceConfig_RetryThrottlingPolicy proto.InternalMessageInfo

func (m *ServiceConfig_RetryThrottlingPolicy) GetMaxTokens() uint32 {
	if m != nil {
		return m.MaxTokens
	}
	return 0
}

func (m *ServiceConfig_RetryThrottlingPolicy) GetTokenRatio() float32 {
	if m != nil {
		return m.TokenRatio
	}
	return 0
}

type ServiceConfig_HealthCheckConfig struct {
	// Service name to use in the health-checking request.
	ServiceName          *wrappers.StringValue `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ServiceConfig_HealthCheckConfig) Reset()         { *m = ServiceConfig_HealthCheckConfig{} }
func (m *ServiceConfig_HealthCheckConfig) String() string { return proto.CompactTextString(m) }
func (*ServiceConfig_HealthCheckConfig) ProtoMessage()    {}
func (*ServiceConfig_HealthCheckConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e32d3cb2c41c77ce, []int{7, 1}
}

func (m *ServiceConfig_HealthCheckConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceConfig_HealthCheckConfig.Unmarshal(m, b)
}
func (m *ServiceConfig_HealthCheckConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceConfig_HealthCheckConfig.Marshal(b, m, deterministic)
}
func (m *ServiceConfig_HealthCheckConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceConfig_HealthCheckConfig.Merge(m, src)
}
func (m *ServiceConfig_HealthCheckConfig) XXX_Size() int {
	return xxx_messageInfo_ServiceConfig_HealthCheckConfig.Size(m)
}
func (m *ServiceConfig_HealthCheckConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceConfig_HealthCheckConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceConfig_HealthCheckConfig proto.InternalMessageInfo

func (m *ServiceConfig_HealthCheckConfig) GetServiceName() *wrappers.StringValue {
	if m != nil {
		return m.ServiceName
	}
	return nil
}

func init() {
	proto.RegisterEnum("grpc.service_config.ServiceConfig_LoadBalancingPolicy", ServiceConfig_LoadBalancingPolicy_name, ServiceConfig_LoadBalancingPolicy_value)
	proto.RegisterType((*MethodConfig)(nil), "grpc.service_config.MethodConfig")
	proto.RegisterType((*MethodConfig_Name)(nil), "grpc.service_config.MethodConfig.Name")
	proto.RegisterType((*MethodConfig_RetryPolicy)(nil), "grpc.service_config.MethodConfig.RetryPolicy")
	proto.RegisterType((*MethodConfig_HedgingPolicy)(nil), "grpc.service_config.MethodConfig.HedgingPolicy")
	proto.RegisterType((*PickFirstConfig)(nil), "grpc.service_config.PickFirstConfig")
	proto.RegisterType((*RoundRobinConfig)(nil), "grpc.service_config.RoundRobinConfig")
	proto.RegisterType((*GrpcLbConfig)(nil), "grpc.service_config.GrpcLbConfig")
	proto.RegisterType((*CdsConfig)(nil), "grpc.service_config.CdsConfig")
	proto.RegisterType((*XdsConfig)(nil), "grpc.service_config.XdsConfig")
	proto.RegisterType((*LoadBalancingConfig)(nil), "grpc.service_config.LoadBalancingConfig")
	proto.RegisterType((*ServiceConfig)(nil), "grpc.service_config.ServiceConfig")
	proto.RegisterType((*ServiceConfig_RetryThrottlingPolicy)(nil), "grpc.service_config.ServiceConfig.RetryThrottlingPolicy")
	proto.RegisterType((*ServiceConfig_HealthCheckConfig)(nil), "grpc.service_config.ServiceConfig.HealthCheckConfig")
}

func init() {
	proto.RegisterFile("grpc/service_config/service_config.proto", fileDescriptor_e32d3cb2c41c77ce)
}

var fileDescriptor_e32d3cb2c41c77ce = []byte{
	// 1161 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdb, 0x6e, 0x23, 0x45,
	0x10, 0x8d, 0xed, 0x6c, 0xb2, 0x2e, 0x5f, 0xe2, 0x74, 0x48, 0xd6, 0x6b, 0xc1, 0x92, 0x44, 0x2c,
	0xf8, 0x25, 0x8e, 0xe4, 0x20, 0x58, 0x2d, 0x12, 0x17, 0x27, 0x31, 0x8e, 0x48, 0xb2, 0xa1, 0x93,
	0xb0, 0x41, 0x42, 0x6a, 0xda, 0x33, 0x6d, 0x7b, 0x94, 0x99, 0xe9, 0xa1, 0xa7, 0xcd, 0x3a, 0x2f,
	0xfc, 0x0d, 0xe2, 0x1b, 0xf8, 0x13, 0x9e, 0x10, 0x9f, 0x82, 0xfa, 0x32, 0x8e, 0xc7, 0xf6, 0xe2,
	0xac, 0x78, 0x9c, 0xaa, 0x3a, 0xa7, 0xab, 0xab, 0x4e, 0x55, 0x0f, 0xd4, 0xfb, 0x22, 0x72, 0xf6,
	0x63, 0x26, 0x7e, 0xf5, 0x1c, 0x46, 0x1c, 0x1e, 0xf6, 0xbc, 0xfe, 0xd4, 0x67, 0x23, 0x12, 0x5c,
	0x72, 0xb4, 0xa1, 0x22, 0x1b, 0x69, 0x57, 0xed, 0x59, 0x9f, 0xf3, 0xbe, 0xcf, 0xf6, 0x75, 0x48,
	0x77, 0xd8, 0xdb, 0x77, 0x87, 0x82, 0x4a, 0x8f, 0x87, 0x06, 0x34, 0xeb, 0x7f, 0x23, 0x68, 0x14,
	0x31, 0x11, 0x5b, 0xff, 0xa6, 0xf5, 0xab, 0x24, 0x1c, 0xee, 0x32, 0x63, 0xde, 0xfd, 0xfb, 0x31,
	0x14, 0xcf, 0x98, 0x1c, 0x70, 0xf7, 0x50, 0x9f, 0x83, 0x5e, 0xc2, 0x72, 0x48, 0x03, 0x56, 0xcd,
	0x6c, 0xe7, 0xea, 0x85, 0xe6, 0xc7, 0x8d, 0x39, 0xb9, 0x34, 0x26, 0x01, 0x8d, 0x73, 0x1a, 0x30,
	0xac, 0x31, 0xe8, 0x6b, 0x28, 0xbf, 0xa1, 0x9e, 0x24, 0x3d, 0x2e, 0x88, 0x60, 0xd4, 0xbd, 0xab,
	0x66, 0xb7, 0x33, 0xf5, 0x42, 0xb3, 0xd6, 0x30, 0x87, 0x37, 0x92, 0xe4, 0x1a, 0x2d, 0xce, 0xfd,
	0x1f, 0xa8, 0x3f, 0x64, 0xb8, 0xa8, 0x10, 0x6d, 0x2e, 0xb0, 0x8a, 0x47, 0x07, 0xb0, 0x2a, 0xbd,
	0x80, 0xf1, 0xa1, 0xac, 0xe6, 0x34, 0xf4, 0xe9, 0x0c, 0xf4, 0xc8, 0xde, 0x1b, 0x27, 0x91, 0xe8,
	0x35, 0x3c, 0x0d, 0xe8, 0x88, 0x08, 0xf6, 0xcb, 0x90, 0xc5, 0x92, 0x04, 0x2c, 0x8e, 0x69, 0x9f,
	0x91, 0xee, 0x9d, 0x64, 0x71, 0x75, 0x59, 0xd3, 0xbc, 0x3f, 0x43, 0x73, 0x7d, 0x12, 0xca, 0x83,
	0xa6, 0xc9, 0x61, 0x2b, 0xa0, 0x23, 0x6c, 0xd0, 0x67, 0x06, 0xdc, 0x52, 0x58, 0xf4, 0x23, 0xd4,
	0x0c, 0x71, 0x1c, 0xf1, 0x30, 0x66, 0x53, 0xcc, 0x8f, 0x1e, 0xc0, 0xfc, 0x44, 0x33, 0x1b, 0x78,
	0x8a, 0x1a, 0x43, 0x51, 0x30, 0x29, 0xee, 0x48, 0xc4, 0x7d, 0xcf, 0xb9, 0xab, 0xae, 0x68, 0xb2,
	0xbd, 0xc5, 0xe5, 0xc6, 0x0a, 0x75, 0xa1, 0x41, 0x9d, 0x25, 0x5c, 0x10, 0xf7, 0x9f, 0xe8, 0x06,
	0xca, 0x03, 0xe6, 0xf6, 0xbd, 0xb0, 0x9f, 0xb0, 0xae, 0x6a, 0xd6, 0xfd, 0xc5, 0xac, 0x1d, 0x83,
	0x1b, 0xf3, 0x96, 0x06, 0x93, 0x86, 0xda, 0x0b, 0x58, 0x56, 0x6d, 0x46, 0x55, 0x58, 0xb5, 0x2c,
	0xd5, 0xcc, 0x76, 0xa6, 0x9e, 0xc7, 0xc9, 0x27, 0xda, 0x82, 0x95, 0x40, 0x13, 0xea, 0x96, 0xe7,
	0xb1, 0xfd, 0xaa, 0xfd, 0x91, 0x85, 0xc2, 0x44, 0xca, 0x68, 0x07, 0x8a, 0xaa, 0xa4, 0x54, 0x4a,
	0x16, 0x44, 0x32, 0xd6, 0x34, 0x25, 0x5c, 0x08, 0xe8, 0xe8, 0x1b, 0x6b, 0x42, 0x2d, 0x58, 0xf3,
	0x42, 0x4f, 0x7a, 0xd4, 0x27, 0x5d, 0xea, 0xdc, 0xf2, 0x5e, 0xcf, 0xca, 0xe8, 0x3f, 0xb4, 0x50,
	0xb6, 0x88, 0x96, 0x01, 0xa0, 0x97, 0xa0, 0x28, 0xc7, 0xf8, 0x85, 0x5a, 0x82, 0x80, 0x8e, 0x12,
	0xec, 0x1e, 0x20, 0x8b, 0x23, 0xc1, 0xd0, 0x97, 0x5e, 0xe4, 0x7b, 0x4c, 0x68, 0x1d, 0x65, 0xf1,
	0xba, 0xf5, 0x9c, 0x8d, 0x1d, 0xa8, 0x0d, 0x5b, 0xba, 0x09, 0xb4, 0xeb, 0x33, 0x12, 0x4b, 0x2a,
	0x87, 0x31, 0x51, 0x03, 0xa6, 0x04, 0x92, 0xab, 0x97, 0x9b, 0x95, 0xe4, 0x54, 0xd5, 0x83, 0x43,
	0xee, 0x32, 0xfc, 0xde, 0x38, 0xfe, 0x52, 0x87, 0x2b, 0x63, 0x5c, 0xfb, 0x33, 0x03, 0xa5, 0x54,
	0x1b, 0x1e, 0x52, 0xab, 0x2f, 0x21, 0xe9, 0x14, 0x71, 0x99, 0x4f, 0xef, 0x16, 0x57, 0xaa, 0x68,
	0xe3, 0x8f, 0x54, 0x38, 0x3a, 0x86, 0xad, 0x90, 0x87, 0xa4, 0x47, 0x25, 0xf5, 0xd3, 0xc9, 0xe7,
	0xde, 0x92, 0xfc, 0x46, 0xc8, 0xc3, 0xb6, 0x0a, 0x9f, 0xc8, 0xbd, 0xf5, 0x14, 0x9e, 0x18, 0x35,
	0x73, 0x41, 0xd2, 0x12, 0xdc, 0x5d, 0x87, 0xb5, 0x0b, 0xcf, 0xb9, 0x6d, 0x7b, 0x22, 0x96, 0x46,
	0x6c, 0xbb, 0x08, 0x2a, 0x98, 0x0f, 0x43, 0x17, 0xf3, 0xae, 0x17, 0x5a, 0xdb, 0x6f, 0x50, 0xfc,
	0x56, 0x44, 0xce, 0x69, 0xd7, 0xae, 0xa1, 0xef, 0xa0, 0xe8, 0x0c, 0x3c, 0xdf, 0x4d, 0x94, 0x6c,
	0xd6, 0x51, 0x7d, 0xae, 0x92, 0x4f, 0x39, 0x75, 0x5b, 0xd4, 0xa7, 0xa1, 0xe3, 0x85, 0x7d, 0x83,
	0xc7, 0x05, 0x8d, 0xbe, 0x2f, 0x64, 0x02, 0xd1, 0xbb, 0xcd, 0x48, 0xb4, 0x60, 0x6d, 0x4a, 0xd9,
	0xbb, 0xcf, 0x21, 0x7f, 0xe8, 0xc6, 0xf6, 0xf0, 0x2a, 0xac, 0x3a, 0xfe, 0x30, 0x96, 0x4c, 0x24,
	0x32, 0xb7, 0x9f, 0xbb, 0xff, 0x64, 0x21, 0x7f, 0x33, 0x8e, 0xfb, 0x04, 0x4a, 0x5d, 0x7d, 0x2e,
	0x13, 0xc4, 0x2e, 0xcd, 0x4c, 0x3d, 0xdf, 0xca, 0x56, 0x33, 0xb8, 0x98, 0x38, 0xf4, 0xdc, 0x4c,
	0xdf, 0x26, 0xfb, 0x7f, 0x6e, 0xf3, 0x3d, 0xac, 0xf5, 0xa8, 0xef, 0x2b, 0x25, 0x26, 0x7c, 0xb9,
	0x77, 0xe4, 0x2b, 0x27, 0x04, 0x96, 0xb2, 0x0e, 0x15, 0xe6, 0xc6, 0x24, 0x55, 0xa4, 0x65, 0x7d,
	0xf3, 0x32, 0x73, 0xe3, 0xcb, 0xfb, 0x3a, 0xa1, 0x9f, 0xe1, 0x99, 0x2f, 0x62, 0xe2, 0x73, 0xea,
	0x12, 0xc1, 0x22, 0x2e, 0xa4, 0xea, 0xb5, 0x02, 0x26, 0x35, 0x78, 0xdb, 0x5a, 0xbc, 0x94, 0xc2,
	0x0b, 0xfb, 0x66, 0x2d, 0xd6, 0x7c, 0x11, 0xab, 0xbc, 0x70, 0xc2, 0x70, 0xa9, 0x09, 0x74, 0x27,
	0x7e, 0xcf, 0xc1, 0xc6, 0x9c, 0x9c, 0x51, 0x1b, 0x20, 0xf2, 0x9c, 0x5b, 0xd2, 0x53, 0x4a, 0xb2,
	0x6b, 0xfd, 0xa3, 0xb9, 0x37, 0x9e, 0xd2, 0x5b, 0x67, 0x09, 0x4f, 0x20, 0xd1, 0x09, 0x14, 0x84,
	0x52, 0x1f, 0x11, 0x4a, 0x7e, 0xba, 0x65, 0x85, 0xe6, 0xf3, 0xb9, 0x44, 0xd3, 0x2a, 0xd5, 0x0b,
	0xf7, 0x1e, 0x8b, 0xbe, 0x80, 0x15, 0x05, 0xf3, 0xbb, 0x76, 0xc1, 0xec, 0xcc, 0x65, 0x99, 0xd4,
	0x75, 0x67, 0x09, 0x5b, 0x08, 0x6a, 0x42, 0xce, 0x71, 0x63, 0xbb, 0xf8, 0x9f, 0xcd, 0x45, 0x8e,
	0x15, 0xd9, 0x59, 0xc2, 0x2a, 0x58, 0x61, 0x46, 0x6e, 0x6c, 0x87, 0x7c, 0x3e, 0xe6, 0x66, 0x12,
	0x33, 0x72, 0x63, 0x74, 0x0a, 0x95, 0x91, 0x1b, 0x13, 0x36, 0x8a, 0x98, 0xf0, 0x02, 0x16, 0x4a,
	0xea, 0xdb, 0x1e, 0x2d, 0x26, 0x98, 0x41, 0xb6, 0x1e, 0xc3, 0x8a, 0x1d, 0xec, 0xbf, 0x1e, 0x41,
	0xc9, 0x2a, 0xc3, 0x76, 0x28, 0x84, 0x4d, 0xad, 0x8b, 0x6e, 0xd2, 0xb9, 0xfb, 0xe1, 0xcd, 0xd4,
	0xcb, 0xcd, 0xcf, 0xe6, 0x1e, 0x97, 0xa2, 0x48, 0x8b, 0xd5, 0x88, 0x53, 0x8f, 0xd3, 0x86, 0x3f,
	0xeb, 0x40, 0x3f, 0xcd, 0x9c, 0x67, 0x38, 0xab, 0xcb, 0xef, 0x38, 0x0e, 0x69, 0xf6, 0xb1, 0xde,
	0x4a, 0xe6, 0x0d, 0x4b, 0x58, 0xcd, 0xd0, 0xee, 0x2c, 0x7c, 0x4c, 0x71, 0x31, 0x98, 0xfc, 0xa1,
	0x72, 0xa0, 0x62, 0x76, 0xa3, 0x1c, 0x08, 0x2e, 0xa5, 0xef, 0x85, 0x7d, 0x2b, 0x97, 0x17, 0x0f,
	0x28, 0x88, 0x7e, 0x3b, 0xaf, 0xc6, 0x48, 0x73, 0x73, 0xbc, 0x26, 0xd2, 0x66, 0xe4, 0xc2, 0xc6,
	0x80, 0x51, 0x5f, 0x0e, 0x88, 0x33, 0x60, 0xce, 0x6d, 0x92, 0xb2, 0xe9, 0xf3, 0xa7, 0x0f, 0x38,
	0xa7, 0xa3, 0xd1, 0x87, 0x0a, 0x6c, 0x6f, 0xb1, 0x3e, 0x98, 0x36, 0xd5, 0x5e, 0xc3, 0xe6, 0xdc,
	0x7c, 0xd0, 0x07, 0xa0, 0x1e, 0x50, 0x22, 0xf9, 0x2d, 0x0b, 0x93, 0x77, 0x2a, 0x1f, 0xd0, 0xd1,
	0x95, 0x36, 0xa0, 0x0f, 0xa1, 0xa0, 0x5d, 0x44, 0xbf, 0x41, 0x5a, 0xbe, 0x59, 0x0c, 0xda, 0x84,
	0x95, 0xa5, 0x76, 0x05, 0xeb, 0x33, 0x09, 0xa0, 0xaf, 0xa6, 0xb6, 0x76, 0xe6, 0x01, 0x8b, 0x25,
	0xb5, 0xd3, 0x3f, 0x9f, 0x5a, 0x24, 0x36, 0xd9, 0x35, 0x28, 0x5c, 0x9f, 0x5f, 0x5e, 0x1c, 0x1f,
	0x9e, 0xb4, 0x4f, 0x8e, 0x8f, 0x2a, 0x4b, 0xca, 0x80, 0x5f, 0x5d, 0x9f, 0x1f, 0x11, 0xfc, 0xaa,
	0x75, 0x72, 0x5e, 0xc9, 0xb4, 0xf6, 0x60, 0xd3, 0xe3, 0xa9, 0xa2, 0x99, 0x9a, 0xb5, 0x50, 0xaa,
	0x68, 0x17, 0x2a, 0x83, 0x8b, 0x4c, 0x77, 0x45, 0xa7, 0x72, 0xf0, 0x6f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x2d, 0xca, 0x96, 0x84, 0xe2, 0x0b, 0x00, 0x00,
}
