// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/resourcemanager/v2/folders.proto

package resourcemanager

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Folder lifecycle states.
type Folder_LifecycleState int32

const (
	// Unspecified state.
	Folder_LIFECYCLE_STATE_UNSPECIFIED Folder_LifecycleState = 0
	// The normal and active state.
	Folder_ACTIVE Folder_LifecycleState = 1
	// The folder has been marked for deletion by the user.
	Folder_DELETE_REQUESTED Folder_LifecycleState = 2
)

var Folder_LifecycleState_name = map[int32]string{
	0: "LIFECYCLE_STATE_UNSPECIFIED",
	1: "ACTIVE",
	2: "DELETE_REQUESTED",
}

var Folder_LifecycleState_value = map[string]int32{
	"LIFECYCLE_STATE_UNSPECIFIED": 0,
	"ACTIVE":                      1,
	"DELETE_REQUESTED":            2,
}

func (x Folder_LifecycleState) String() string {
	return proto.EnumName(Folder_LifecycleState_name, int32(x))
}

func (Folder_LifecycleState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{0, 0}
}

// The type of operation that failed.
type FolderOperation_OperationType int32

const (
	// Operation type not specified.
	FolderOperation_OPERATION_TYPE_UNSPECIFIED FolderOperation_OperationType = 0
	// A create folder operation.
	FolderOperation_CREATE FolderOperation_OperationType = 1
	// A move folder operation.
	FolderOperation_MOVE FolderOperation_OperationType = 2
)

var FolderOperation_OperationType_name = map[int32]string{
	0: "OPERATION_TYPE_UNSPECIFIED",
	1: "CREATE",
	2: "MOVE",
}

var FolderOperation_OperationType_value = map[string]int32{
	"OPERATION_TYPE_UNSPECIFIED": 0,
	"CREATE":                     1,
	"MOVE":                       2,
}

func (x FolderOperation_OperationType) String() string {
	return proto.EnumName(FolderOperation_OperationType_name, int32(x))
}

func (FolderOperation_OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{11, 0}
}

// A Folder in an Organization's resource hierarchy, used to
// organize that Organization's resources.
type Folder struct {
	// Output only. The resource name of the Folder.
	// Its format is `folders/{folder_id}`, for example: "folders/1234".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Folder’s parent's resource name.
	// Updates to the folder's parent must be performed via
	// [MoveFolder][google.cloud.resourcemanager.v2.Folders.MoveFolder].
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The folder’s display name.
	// A folder’s display name must be unique amongst its siblings, e.g.
	// no two folders with the same parent can share the same display name.
	// The display name must start and end with a letter or digit, may contain
	// letters, digits, spaces, hyphens and underscores and can be no longer
	// than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The lifecycle state of the folder.
	// Updates to the lifecycle_state must be performed via
	// [DeleteFolder][google.cloud.resourcemanager.v2.Folders.DeleteFolder] and
	// [UndeleteFolder][google.cloud.resourcemanager.v2.Folders.UndeleteFolder].
	LifecycleState Folder_LifecycleState `protobuf:"varint,4,opt,name=lifecycle_state,json=lifecycleState,proto3,enum=google.cloud.resourcemanager.v2.Folder_LifecycleState" json:"lifecycle_state,omitempty"`
	// Output only. Timestamp when the Folder was created. Assigned by the server.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when the Folder was last modified.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Folder) Reset()         { *m = Folder{} }
func (m *Folder) String() string { return proto.CompactTextString(m) }
func (*Folder) ProtoMessage()    {}
func (*Folder) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{0}
}

func (m *Folder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Folder.Unmarshal(m, b)
}
func (m *Folder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Folder.Marshal(b, m, deterministic)
}
func (m *Folder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Folder.Merge(m, src)
}
func (m *Folder) XXX_Size() int {
	return xxx_messageInfo_Folder.Size(m)
}
func (m *Folder) XXX_DiscardUnknown() {
	xxx_messageInfo_Folder.DiscardUnknown(m)
}

var xxx_messageInfo_Folder proto.InternalMessageInfo

func (m *Folder) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Folder) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Folder) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Folder) GetLifecycleState() Folder_LifecycleState {
	if m != nil {
		return m.LifecycleState
	}
	return Folder_LIFECYCLE_STATE_UNSPECIFIED
}

func (m *Folder) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Folder) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// The ListFolders request message.
type ListFoldersRequest struct {
	// Required. The resource name of the Organization or Folder whose Folders are
	// being listed.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	// Access to this method is controlled by checking the
	// `resourcemanager.folders.list` permission on the `parent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of Folders to return in the response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A pagination token returned from a previous call to `ListFolders`
	// that indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Controls whether Folders in the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED]
	// state should be returned. Defaults to false.
	ShowDeleted          bool     `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFoldersRequest) Reset()         { *m = ListFoldersRequest{} }
func (m *ListFoldersRequest) String() string { return proto.CompactTextString(m) }
func (*ListFoldersRequest) ProtoMessage()    {}
func (*ListFoldersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{1}
}

func (m *ListFoldersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFoldersRequest.Unmarshal(m, b)
}
func (m *ListFoldersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFoldersRequest.Marshal(b, m, deterministic)
}
func (m *ListFoldersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFoldersRequest.Merge(m, src)
}
func (m *ListFoldersRequest) XXX_Size() int {
	return xxx_messageInfo_ListFoldersRequest.Size(m)
}
func (m *ListFoldersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFoldersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFoldersRequest proto.InternalMessageInfo

func (m *ListFoldersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListFoldersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFoldersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFoldersRequest) GetShowDeleted() bool {
	if m != nil {
		return m.ShowDeleted
	}
	return false
}

// The ListFolders response message.
type ListFoldersResponse struct {
	// A possibly paginated list of Folders that are direct descendants of
	// the specified parent resource.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// A pagination token returned from a previous call to `ListFolders`
	// that indicates from where listing should continue.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFoldersResponse) Reset()         { *m = ListFoldersResponse{} }
func (m *ListFoldersResponse) String() string { return proto.CompactTextString(m) }
func (*ListFoldersResponse) ProtoMessage()    {}
func (*ListFoldersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{2}
}

func (m *ListFoldersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFoldersResponse.Unmarshal(m, b)
}
func (m *ListFoldersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFoldersResponse.Marshal(b, m, deterministic)
}
func (m *ListFoldersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFoldersResponse.Merge(m, src)
}
func (m *ListFoldersResponse) XXX_Size() int {
	return xxx_messageInfo_ListFoldersResponse.Size(m)
}
func (m *ListFoldersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFoldersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFoldersResponse proto.InternalMessageInfo

func (m *ListFoldersResponse) GetFolders() []*Folder {
	if m != nil {
		return m.Folders
	}
	return nil
}

func (m *ListFoldersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for searching folders.
type SearchFoldersRequest struct {
	// Optional. The maximum number of folders to return in the response.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A pagination token returned from a previous call to `SearchFolders`
	// that indicates from where search should continue.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Search criteria used to select the Folders to return.
	// If no search criteria is specified then all accessible folders will be
	// returned.
	//
	// Query expressions can be used to restrict results based upon displayName,
	// lifecycleState and parent, where the operators `=`, `NOT`, `AND` and `OR`
	// can be used along with the suffix wildcard symbol `*`.
	//
	// The displayName field in a query expression should use escaped quotes
	// for values that include whitespace to prevent unexpected behavior.
	//
	// Some example queries are:
	//
	// * Query `displayName=Test*` returns Folder resources whose display name
	// starts with "Test".
	// * Query `lifecycleState=ACTIVE` returns Folder resources with
	// `lifecycleState` set to `ACTIVE`.
	// * Query `parent=folders/123` returns Folder resources that have
	// `folders/123` as a parent resource.
	// * Query `parent=folders/123 AND lifecycleState=ACTIVE` returns active
	// Folder resources that have `folders/123` as a parent resource.
	// * Query `displayName=\\"Test String\\"` returns Folder resources with
	// display names that include both "Test" and "String".
	Query                string   `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchFoldersRequest) Reset()         { *m = SearchFoldersRequest{} }
func (m *SearchFoldersRequest) String() string { return proto.CompactTextString(m) }
func (*SearchFoldersRequest) ProtoMessage()    {}
func (*SearchFoldersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{3}
}

func (m *SearchFoldersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchFoldersRequest.Unmarshal(m, b)
}
func (m *SearchFoldersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchFoldersRequest.Marshal(b, m, deterministic)
}
func (m *SearchFoldersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchFoldersRequest.Merge(m, src)
}
func (m *SearchFoldersRequest) XXX_Size() int {
	return xxx_messageInfo_SearchFoldersRequest.Size(m)
}
func (m *SearchFoldersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchFoldersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchFoldersRequest proto.InternalMessageInfo

func (m *SearchFoldersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchFoldersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchFoldersRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

// The response message for searching folders.
type SearchFoldersResponse struct {
	// A possibly paginated folder search results.
	// the specified parent resource.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// A pagination token returned from a previous call to `SearchFolders`
	// that indicates from where searching should continue.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchFoldersResponse) Reset()         { *m = SearchFoldersResponse{} }
func (m *SearchFoldersResponse) String() string { return proto.CompactTextString(m) }
func (*SearchFoldersResponse) ProtoMessage()    {}
func (*SearchFoldersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{4}
}

func (m *SearchFoldersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchFoldersResponse.Unmarshal(m, b)
}
func (m *SearchFoldersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchFoldersResponse.Marshal(b, m, deterministic)
}
func (m *SearchFoldersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchFoldersResponse.Merge(m, src)
}
func (m *SearchFoldersResponse) XXX_Size() int {
	return xxx_messageInfo_SearchFoldersResponse.Size(m)
}
func (m *SearchFoldersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchFoldersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchFoldersResponse proto.InternalMessageInfo

func (m *SearchFoldersResponse) GetFolders() []*Folder {
	if m != nil {
		return m.Folders
	}
	return nil
}

func (m *SearchFoldersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The GetFolder request message.
type GetFolderRequest struct {
	// Required. The resource name of the Folder to retrieve.
	// Must be of the form `folders/{folder_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFolderRequest) Reset()         { *m = GetFolderRequest{} }
func (m *GetFolderRequest) String() string { return proto.CompactTextString(m) }
func (*GetFolderRequest) ProtoMessage()    {}
func (*GetFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{5}
}

func (m *GetFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFolderRequest.Unmarshal(m, b)
}
func (m *GetFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFolderRequest.Marshal(b, m, deterministic)
}
func (m *GetFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFolderRequest.Merge(m, src)
}
func (m *GetFolderRequest) XXX_Size() int {
	return xxx_messageInfo_GetFolderRequest.Size(m)
}
func (m *GetFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFolderRequest proto.InternalMessageInfo

func (m *GetFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The CreateFolder request message.
type CreateFolderRequest struct {
	// Required. The resource name of the new Folder's parent.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Folder being created, only the display name will be consulted.
	// All other fields will be ignored.
	Folder               *Folder  `protobuf:"bytes,2,opt,name=folder,proto3" json:"folder,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFolderRequest) Reset()         { *m = CreateFolderRequest{} }
func (m *CreateFolderRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFolderRequest) ProtoMessage()    {}
func (*CreateFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{6}
}

func (m *CreateFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFolderRequest.Unmarshal(m, b)
}
func (m *CreateFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFolderRequest.Marshal(b, m, deterministic)
}
func (m *CreateFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFolderRequest.Merge(m, src)
}
func (m *CreateFolderRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFolderRequest.Size(m)
}
func (m *CreateFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFolderRequest proto.InternalMessageInfo

func (m *CreateFolderRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFolderRequest) GetFolder() *Folder {
	if m != nil {
		return m.Folder
	}
	return nil
}

// The MoveFolder request message.
type MoveFolderRequest struct {
	// Required. The resource name of the Folder to move.
	// Must be of the form folders/{folder_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resource name of the Folder or Organization to reparent
	// the folder under.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	DestinationParent    string   `protobuf:"bytes,2,opt,name=destination_parent,json=destinationParent,proto3" json:"destination_parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveFolderRequest) Reset()         { *m = MoveFolderRequest{} }
func (m *MoveFolderRequest) String() string { return proto.CompactTextString(m) }
func (*MoveFolderRequest) ProtoMessage()    {}
func (*MoveFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{7}
}

func (m *MoveFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveFolderRequest.Unmarshal(m, b)
}
func (m *MoveFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveFolderRequest.Marshal(b, m, deterministic)
}
func (m *MoveFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveFolderRequest.Merge(m, src)
}
func (m *MoveFolderRequest) XXX_Size() int {
	return xxx_messageInfo_MoveFolderRequest.Size(m)
}
func (m *MoveFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveFolderRequest proto.InternalMessageInfo

func (m *MoveFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MoveFolderRequest) GetDestinationParent() string {
	if m != nil {
		return m.DestinationParent
	}
	return ""
}

// The request message for updating a folder's display name.
type UpdateFolderRequest struct {
	// Required. The new definition of the Folder. It must include a
	// a `name` and `display_name` field. The other fields
	// will be ignored.
	Folder *Folder `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	// Required. Fields to be updated.
	// Only the `display_name` can be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateFolderRequest) Reset()         { *m = UpdateFolderRequest{} }
func (m *UpdateFolderRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFolderRequest) ProtoMessage()    {}
func (*UpdateFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{8}
}

func (m *UpdateFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFolderRequest.Unmarshal(m, b)
}
func (m *UpdateFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFolderRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFolderRequest.Merge(m, src)
}
func (m *UpdateFolderRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFolderRequest.Size(m)
}
func (m *UpdateFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFolderRequest proto.InternalMessageInfo

func (m *UpdateFolderRequest) GetFolder() *Folder {
	if m != nil {
		return m.Folder
	}
	return nil
}

func (m *UpdateFolderRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The DeleteFolder request message.
type DeleteFolderRequest struct {
	// Required. The resource name of the Folder to be deleted.
	// Must be of the form `folders/{folder_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Instructs DeleteFolderAction to delete a folder even when the folder is not
	// empty.
	RecursiveDelete      bool     `protobuf:"varint,2,opt,name=recursive_delete,json=recursiveDelete,proto3" json:"recursive_delete,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFolderRequest) Reset()         { *m = DeleteFolderRequest{} }
func (m *DeleteFolderRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFolderRequest) ProtoMessage()    {}
func (*DeleteFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{9}
}

func (m *DeleteFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFolderRequest.Unmarshal(m, b)
}
func (m *DeleteFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFolderRequest.Marshal(b, m, deterministic)
}
func (m *DeleteFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFolderRequest.Merge(m, src)
}
func (m *DeleteFolderRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFolderRequest.Size(m)
}
func (m *DeleteFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFolderRequest proto.InternalMessageInfo

func (m *DeleteFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteFolderRequest) GetRecursiveDelete() bool {
	if m != nil {
		return m.RecursiveDelete
	}
	return false
}

// The UndeleteFolder request message.
type UndeleteFolderRequest struct {
	// Required. The resource name of the Folder to undelete.
	// Must be of the form `folders/{folder_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UndeleteFolderRequest) Reset()         { *m = UndeleteFolderRequest{} }
func (m *UndeleteFolderRequest) String() string { return proto.CompactTextString(m) }
func (*UndeleteFolderRequest) ProtoMessage()    {}
func (*UndeleteFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{10}
}

func (m *UndeleteFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeleteFolderRequest.Unmarshal(m, b)
}
func (m *UndeleteFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeleteFolderRequest.Marshal(b, m, deterministic)
}
func (m *UndeleteFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeleteFolderRequest.Merge(m, src)
}
func (m *UndeleteFolderRequest) XXX_Size() int {
	return xxx_messageInfo_UndeleteFolderRequest.Size(m)
}
func (m *UndeleteFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeleteFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UndeleteFolderRequest proto.InternalMessageInfo

func (m *UndeleteFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Metadata describing a long running folder operation
type FolderOperation struct {
	// The display name of the folder.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of this operation.
	OperationType FolderOperation_OperationType `protobuf:"varint,2,opt,name=operation_type,json=operationType,proto3,enum=google.cloud.resourcemanager.v2.FolderOperation_OperationType" json:"operation_type,omitempty"`
	// The resource name of the folder's parent.
	// Only applicable when the operation_type is MOVE.
	SourceParent string `protobuf:"bytes,3,opt,name=source_parent,json=sourceParent,proto3" json:"source_parent,omitempty"`
	// The resource name of the folder or organization we are either creating
	// the folder under or moving the folder to.
	DestinationParent    string   `protobuf:"bytes,4,opt,name=destination_parent,json=destinationParent,proto3" json:"destination_parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FolderOperation) Reset()         { *m = FolderOperation{} }
func (m *FolderOperation) String() string { return proto.CompactTextString(m) }
func (*FolderOperation) ProtoMessage()    {}
func (*FolderOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe78511a4713776e, []int{11}
}

func (m *FolderOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FolderOperation.Unmarshal(m, b)
}
func (m *FolderOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FolderOperation.Marshal(b, m, deterministic)
}
func (m *FolderOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FolderOperation.Merge(m, src)
}
func (m *FolderOperation) XXX_Size() int {
	return xxx_messageInfo_FolderOperation.Size(m)
}
func (m *FolderOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_FolderOperation.DiscardUnknown(m)
}

var xxx_messageInfo_FolderOperation proto.InternalMessageInfo

func (m *FolderOperation) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *FolderOperation) GetOperationType() FolderOperation_OperationType {
	if m != nil {
		return m.OperationType
	}
	return FolderOperation_OPERATION_TYPE_UNSPECIFIED
}

func (m *FolderOperation) GetSourceParent() string {
	if m != nil {
		return m.SourceParent
	}
	return ""
}

func (m *FolderOperation) GetDestinationParent() string {
	if m != nil {
		return m.DestinationParent
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.resourcemanager.v2.Folder_LifecycleState", Folder_LifecycleState_name, Folder_LifecycleState_value)
	proto.RegisterEnum("google.cloud.resourcemanager.v2.FolderOperation_OperationType", FolderOperation_OperationType_name, FolderOperation_OperationType_value)
	proto.RegisterType((*Folder)(nil), "google.cloud.resourcemanager.v2.Folder")
	proto.RegisterType((*ListFoldersRequest)(nil), "google.cloud.resourcemanager.v2.ListFoldersRequest")
	proto.RegisterType((*ListFoldersResponse)(nil), "google.cloud.resourcemanager.v2.ListFoldersResponse")
	proto.RegisterType((*SearchFoldersRequest)(nil), "google.cloud.resourcemanager.v2.SearchFoldersRequest")
	proto.RegisterType((*SearchFoldersResponse)(nil), "google.cloud.resourcemanager.v2.SearchFoldersResponse")
	proto.RegisterType((*GetFolderRequest)(nil), "google.cloud.resourcemanager.v2.GetFolderRequest")
	proto.RegisterType((*CreateFolderRequest)(nil), "google.cloud.resourcemanager.v2.CreateFolderRequest")
	proto.RegisterType((*MoveFolderRequest)(nil), "google.cloud.resourcemanager.v2.MoveFolderRequest")
	proto.RegisterType((*UpdateFolderRequest)(nil), "google.cloud.resourcemanager.v2.UpdateFolderRequest")
	proto.RegisterType((*DeleteFolderRequest)(nil), "google.cloud.resourcemanager.v2.DeleteFolderRequest")
	proto.RegisterType((*UndeleteFolderRequest)(nil), "google.cloud.resourcemanager.v2.UndeleteFolderRequest")
	proto.RegisterType((*FolderOperation)(nil), "google.cloud.resourcemanager.v2.FolderOperation")
}

func init() {
	proto.RegisterFile("google/cloud/resourcemanager/v2/folders.proto", fileDescriptor_fe78511a4713776e)
}

var fileDescriptor_fe78511a4713776e = []byte{
	// 1496 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcb, 0x6b, 0x1b, 0xd7,
	0x1a, 0xbf, 0x47, 0x76, 0x1c, 0xfb, 0x48, 0xb2, 0x95, 0x63, 0xfb, 0xda, 0x51, 0x6e, 0x62, 0xdf,
	0x31, 0xc9, 0x75, 0x74, 0xed, 0x99, 0x46, 0x69, 0x43, 0x51, 0x68, 0xc8, 0x58, 0x1e, 0x1b, 0x83,
	0x1f, 0xaa, 0x24, 0x1b, 0x12, 0x02, 0xc3, 0x44, 0x3a, 0x96, 0x87, 0x8c, 0x66, 0x26, 0x33, 0x23,
	0xb9, 0x4a, 0x48, 0x29, 0x59, 0x94, 0x2e, 0x5a, 0x28, 0x94, 0x2e, 0xbb, 0x69, 0xc9, 0x26, 0x14,
	0xba, 0x2b, 0x85, 0x42, 0xf7, 0xcd, 0xb2, 0xdd, 0x69, 0x15, 0x68, 0x57, 0xfd, 0x13, 0xba, 0x2a,
	0xe7, 0x31, 0xf2, 0xcc, 0x48, 0x89, 0xc6, 0x85, 0x74, 0x65, 0xeb, 0x7b, 0x9c, 0xef, 0xf7, 0x3d,
	0xce, 0xef, 0x3b, 0x12, 0x5c, 0x6d, 0x58, 0x56, 0xc3, 0xc0, 0x52, 0xcd, 0xb0, 0x5a, 0x75, 0xc9,
	0xc1, 0xae, 0xd5, 0x72, 0x6a, 0xb8, 0xa9, 0x99, 0x5a, 0x03, 0x3b, 0x52, 0x3b, 0x2f, 0x1d, 0x5a,
	0x46, 0x1d, 0x3b, 0xae, 0x68, 0x3b, 0x96, 0x67, 0xa1, 0x05, 0x66, 0x2e, 0x52, 0x73, 0x31, 0x62,
	0x2e, 0xb6, 0xf3, 0xd9, 0xff, 0xf0, 0xf3, 0x34, 0x5b, 0x97, 0x34, 0xd3, 0xb4, 0x3c, 0xcd, 0xd3,
	0x2d, 0x93, 0xbb, 0x67, 0xe7, 0x02, 0xda, 0x9a, 0xa1, 0x63, 0xd3, 0xe3, 0x8a, 0x85, 0x80, 0xe2,
	0x50, 0xc7, 0x46, 0x5d, 0xbd, 0x8f, 0x8f, 0xb4, 0xb6, 0x6e, 0x39, 0xdc, 0xe0, 0x7c, 0xc0, 0xc0,
	0x0f, 0xcb, 0x55, 0x97, 0xb8, 0x4a, 0xd7, 0x9a, 0x52, 0xfb, 0x1a, 0xf9, 0xa3, 0xda, 0x96, 0xa1,
	0xd7, 0x3a, 0x5c, 0x9f, 0x0d, 0xeb, 0x43, 0xba, 0x25, 0xae, 0x33, 0x2c, 0xb3, 0xe1, 0xb4, 0x4c,
	0x53, 0x37, 0x1b, 0x92, 0x65, 0x63, 0x27, 0x84, 0x7a, 0x91, 0x1b, 0xd1, 0x4f, 0xf7, 0x5b, 0x87,
	0x1c, 0x61, 0x53, 0x73, 0x1f, 0x44, 0xe0, 0xf7, 0x2c, 0x3c, 0xbd, 0x89, 0x5d, 0x4f, 0x6b, 0xda,
	0xcc, 0x40, 0xf8, 0x6d, 0x04, 0x8e, 0x6d, 0xd0, 0x4a, 0xa2, 0x39, 0x38, 0x6a, 0x6a, 0x4d, 0x3c,
	0x0f, 0x16, 0xc1, 0xf2, 0xc4, 0xda, 0xc8, 0x4b, 0x79, 0xa4, 0x4c, 0x05, 0xe8, 0x02, 0x1c, 0xb3,
	0x35, 0x07, 0x9b, 0xde, 0x7c, 0xc2, 0x57, 0x25, 0xca, 0x5c, 0x84, 0xfe, 0x0b, 0x53, 0x75, 0xdd,
	0xb5, 0x0d, 0xad, 0xa3, 0x52, 0xef, 0x11, 0x62, 0x52, 0x4e, 0x72, 0xd9, 0x2e, 0xf1, 0xaf, 0xc3,
	0x29, 0x43, 0x3f, 0xc4, 0xb5, 0x4e, 0xcd, 0xc0, 0xaa, 0xeb, 0x69, 0x1e, 0x9e, 0x1f, 0x5d, 0x04,
	0xcb, 0x93, 0xf9, 0x1b, 0xe2, 0x90, 0xae, 0x89, 0x0c, 0x9a, 0xb8, 0xed, 0xbb, 0x57, 0x88, 0x37,
	0xc3, 0x36, 0x69, 0x84, 0x84, 0xe8, 0x36, 0x4c, 0xd6, 0x1c, 0xac, 0x79, 0x58, 0x25, 0x39, 0xce,
	0x9f, 0x59, 0x04, 0xcb, 0xc9, 0x7c, 0xd6, 0x8f, 0xe0, 0x17, 0x40, 0xac, 0xfa, 0x05, 0x60, 0xa7,
	0x40, 0xe6, 0x43, 0xa4, 0xe4, 0x84, 0x96, 0x5d, 0xef, 0x9d, 0x30, 0x16, 0xf3, 0x04, 0xe6, 0x43,
	0xa4, 0x42, 0x05, 0x4e, 0x86, 0xa1, 0xa2, 0x05, 0x78, 0x61, 0x7b, 0x6b, 0x43, 0x29, 0xde, 0x29,
	0x6e, 0x2b, 0x6a, 0xa5, 0x2a, 0x57, 0x15, 0x75, 0x7f, 0xb7, 0x52, 0x52, 0x8a, 0x5b, 0x1b, 0x5b,
	0xca, 0x7a, 0xe6, 0x5f, 0x08, 0xc2, 0x31, 0xb9, 0x58, 0xdd, 0x3a, 0x50, 0x32, 0x00, 0xcd, 0xc0,
	0xcc, 0xba, 0xb2, 0xad, 0x54, 0x15, 0xb5, 0xac, 0xbc, 0xbf, 0xaf, 0x54, 0xaa, 0xca, 0x7a, 0x26,
	0x51, 0x90, 0xff, 0x90, 0x6f, 0xc1, 0x1c, 0x2d, 0x51, 0xb4, 0x42, 0x0c, 0x9a, 0x66, 0xeb, 0xae,
	0x58, 0xb3, 0x9a, 0x12, 0x6f, 0x64, 0x86, 0x5f, 0x0d, 0xe9, 0x31, 0xfb, 0xe7, 0x89, 0xf0, 0x0c,
	0x40, 0xb4, 0xad, 0xbb, 0x1e, 0x33, 0x70, 0xcb, 0xf8, 0x61, 0x0b, 0xbb, 0xa4, 0x77, 0x7e, 0x63,
	0x59, 0xcf, 0x27, 0x5e, 0xca, 0x89, 0x3f, 0xe5, 0x11, 0x04, 0x72, 0xbd, 0xf6, 0x2e, 0xc2, 0x09,
	0x5b, 0x6b, 0x60, 0xd5, 0xd5, 0x1f, 0x61, 0xda, 0xfe, 0x33, 0x24, 0x6b, 0x50, 0x1e, 0x27, 0xd2,
	0x8a, 0xfe, 0x08, 0x23, 0x01, 0x42, 0x6a, 0xe1, 0x59, 0x0f, 0xb0, 0xc9, 0xda, 0xcf, 0x4c, 0xa8,
	0x63, 0x95, 0x48, 0xd1, 0x15, 0x98, 0x72, 0x8f, 0xac, 0x63, 0xb5, 0x8e, 0x0d, 0xec, 0xe1, 0x3a,
	0x6d, 0xff, 0x38, 0xb3, 0x4a, 0x12, 0xc5, 0x3a, 0x93, 0x0b, 0x1f, 0x01, 0x38, 0x1d, 0xc2, 0xe9,
	0xda, 0x96, 0xe9, 0x62, 0x24, 0xc3, 0xb3, 0x3c, 0xa7, 0x79, 0xb0, 0x38, 0xb2, 0x9c, 0xcc, 0xff,
	0x2f, 0xe6, 0xe4, 0x94, 0x7d, 0x3f, 0x74, 0x05, 0x4e, 0x99, 0xf8, 0x03, 0x4f, 0x0d, 0x60, 0xa5,
	0xd3, 0x5c, 0x4e, 0x13, 0x71, 0xc9, 0x87, 0x2a, 0x38, 0x70, 0xa6, 0x82, 0x35, 0xa7, 0x76, 0x14,
	0xa9, 0x55, 0xa8, 0x10, 0x60, 0x78, 0x21, 0x12, 0x03, 0x0b, 0x31, 0x03, 0xcf, 0x3c, 0x6c, 0x61,
	0xa7, 0xc3, 0xaf, 0x09, 0xfb, 0x20, 0x3c, 0x05, 0x70, 0x36, 0x12, 0xf4, 0x9f, 0x4f, 0xfc, 0x2e,
	0xcc, 0x6c, 0x62, 0x5e, 0x79, 0x3f, 0xe9, 0x8d, 0x10, 0x25, 0xe4, 0xe9, 0x78, 0xac, 0x9c, 0x66,
	0x16, 0x19, 0x83, 0x08, 0x1f, 0xc2, 0xe9, 0x22, 0xbd, 0x67, 0xe1, 0xe3, 0x63, 0xcc, 0xdf, 0x3a,
	0x1c, 0x63, 0x89, 0x50, 0xd0, 0xf1, 0xf3, 0xe7, 0x24, 0xc5, 0x7c, 0x85, 0x2f, 0x01, 0x3c, 0xb7,
	0x63, 0xb5, 0xf1, 0x1b, 0xc9, 0x0e, 0xbd, 0x0b, 0x51, 0x1d, 0xbb, 0x9e, 0x6e, 0x52, 0x72, 0x56,
	0x43, 0x5c, 0x19, 0x48, 0xe9, 0x5c, 0xc0, 0xa8, 0x44, 0x6d, 0x84, 0xaf, 0x00, 0x9c, 0xde, 0xa7,
	0xf4, 0x11, 0x46, 0x76, 0x92, 0x35, 0xf8, 0xfb, 0x59, 0x07, 0xf8, 0x8c, 0x6c, 0x04, 0x5e, 0xc0,
	0x7e, 0x3e, 0xdb, 0x20, 0x4b, 0x63, 0x47, 0x73, 0x1f, 0x30, 0x6f, 0xce, 0x67, 0x44, 0x20, 0x7c,
	0x02, 0xe0, 0x34, 0xbb, 0x9b, 0x6f, 0xa6, 0x72, 0x57, 0x61, 0xc6, 0xc1, 0xb5, 0x96, 0xe3, 0xea,
	0x6d, 0xcc, 0xc9, 0x81, 0xc2, 0x1c, 0x2f, 0x4f, 0xf5, 0xe4, 0x2c, 0xbe, 0xa0, 0xc2, 0xd9, 0x7d,
	0xb3, 0xfe, 0xe6, 0xb0, 0x08, 0xdf, 0x27, 0xe0, 0x14, 0x13, 0xec, 0xf9, 0x7b, 0xb6, 0x6f, 0xb9,
	0x81, 0xfe, 0xe5, 0x86, 0xe1, 0x64, 0x6f, 0x2f, 0xab, 0x5e, 0xc7, 0x66, 0x09, 0x4c, 0xe6, 0x6f,
	0xc5, 0x6c, 0x59, 0x2f, 0x98, 0xd8, 0xfb, 0xaf, 0xda, 0xb1, 0x71, 0x39, 0x6d, 0x05, 0x3f, 0xa2,
	0x25, 0x98, 0x66, 0x07, 0xf8, 0xe3, 0xc5, 0x08, 0x24, 0xc5, 0x84, 0x6c, 0x9c, 0xd0, 0xea, 0xc0,
	0x41, 0x1c, 0xa5, 0x96, 0x03, 0xa6, 0x4f, 0x81, 0xe9, 0x50, 0x4c, 0x74, 0x09, 0x66, 0xf7, 0x4a,
	0x4a, 0x59, 0xae, 0x6e, 0xed, 0xed, 0xaa, 0xd5, 0x3b, 0xa5, 0x01, 0xbb, 0xaa, 0x58, 0x56, 0xe4,
	0x2a, 0xd9, 0x55, 0xe3, 0x70, 0x74, 0x67, 0xef, 0x40, 0xc9, 0x24, 0xf2, 0x3f, 0x4d, 0xc1, 0xb3,
	0x9c, 0xb7, 0xd0, 0x37, 0x00, 0x26, 0x03, 0x04, 0x8e, 0xae, 0x0f, 0xad, 0x42, 0xff, 0x5a, 0xca,
	0xbe, 0x7d, 0x3a, 0x27, 0x46, 0x95, 0xc2, 0xd5, 0xae, 0x3c, 0xcd, 0x32, 0x5e, 0x09, 0xee, 0x9a,
	0xa7, 0xbf, 0xfe, 0xfe, 0x45, 0x22, 0x8d, 0x92, 0x81, 0x27, 0x23, 0x7a, 0x06, 0x60, 0x3a, 0xc4,
	0xb7, 0xe8, 0x9d, 0xa1, 0x21, 0x07, 0x2d, 0x85, 0xec, 0x8d, 0xd3, 0xba, 0x71, 0xac, 0x97, 0xbb,
	0x32, 0xa3, 0x7e, 0x8a, 0x6e, 0x4e, 0x40, 0x01, 0x74, 0x05, 0x97, 0xba, 0x14, 0x40, 0x0e, 0x7d,
	0x0a, 0xe0, 0x44, 0x8f, 0x93, 0xd1, 0xb5, 0xa1, 0xc1, 0xa2, 0xfc, 0x9d, 0x8d, 0xcb, 0x1b, 0xc2,
	0x52, 0x57, 0xa6, 0xb7, 0x80, 0xe2, 0xf9, 0x37, 0x9a, 0x21, 0x78, 0x1e, 0x13, 0xc1, 0x7b, 0xfe,
	0x5b, 0x22, 0xf7, 0x04, 0x7d, 0x0b, 0x60, 0x2a, 0x48, 0xe3, 0x68, 0x78, 0xa3, 0x06, 0xb0, 0x7e,
	0xf6, 0xa2, 0xef, 0x15, 0x78, 0xdb, 0x9e, 0x0c, 0xbf, 0xb0, 0xf9, 0x42, 0x3e, 0xdf, 0x7b, 0x93,
	0x46, 0x6f, 0x64, 0x57, 0x4e, 0xf3, 0x1e, 0x33, 0x5c, 0x14, 0xef, 0xac, 0x10, 0xec, 0x6e, 0xc1,
	0xa7, 0xbf, 0xef, 0x00, 0x4c, 0x05, 0xc9, 0x35, 0x06, 0xdc, 0x01, 0x5c, 0x1c, 0xbf, 0x86, 0xb7,
	0xbb, 0x32, 0x62, 0xa1, 0x57, 0x02, 0xb4, 0x4b, 0x11, 0x5e, 0xce, 0x5f, 0xa0, 0x15, 0x65, 0x6a,
	0x31, 0x52, 0xd8, 0x1e, 0xe2, 0x1f, 0x01, 0x84, 0x27, 0x6b, 0x0a, 0xe5, 0x87, 0x46, 0xee, 0xdb,
	0x69, 0xc3, 0x8a, 0x7b, 0xf7, 0xf5, 0xc5, 0x9d, 0x23, 0xc8, 0x56, 0xfa, 0x39, 0x84, 0x26, 0x71,
	0x49, 0x38, 0x3f, 0x68, 0x2c, 0x0a, 0x4d, 0xab, 0x8d, 0xc9, 0xb4, 0x3e, 0x07, 0x30, 0x15, 0x5c,
	0x16, 0x31, 0xea, 0x3d, 0x60, 0xb7, 0xc4, 0xaf, 0xf7, 0x4d, 0x3e, 0xb3, 0x5d, 0x79, 0x96, 0xc2,
	0x8e, 0x6e, 0x12, 0x36, 0xcb, 0xb9, 0xc1, 0xb3, 0xfc, 0x35, 0x80, 0x93, 0xe1, 0x7d, 0x82, 0x86,
	0x5f, 0xe6, 0x81, 0x0b, 0x28, 0x3e, 0x60, 0x29, 0x78, 0xc9, 0x04, 0xe1, 0xe2, 0xc0, 0x6a, 0xb6,
	0x78, 0x0c, 0x52, 0xd1, 0x8f, 0x01, 0x4c, 0x6d, 0x62, 0x6f, 0x4b, 0x6b, 0x96, 0xe8, 0x77, 0x43,
	0x24, 0xf8, 0xa1, 0x74, 0xad, 0x29, 0xb6, 0xaf, 0x89, 0x41, 0xa5, 0x0f, 0x67, 0x36, 0x62, 0xc3,
	0xb4, 0xa4, 0x5a, 0xe3, 0x3e, 0x34, 0x0a, 0x20, 0x27, 0x5c, 0xa6, 0x00, 0x7c, 0x61, 0x10, 0x44,
	0x23, 0x70, 0x2e, 0x01, 0xf2, 0x19, 0x80, 0xa9, 0xca, 0xeb, 0x80, 0x54, 0xe2, 0x03, 0x59, 0xeb,
	0xca, 0x53, 0x7e, 0xcc, 0x15, 0xf6, 0x9d, 0x77, 0x28, 0x1e, 0x37, 0x82, 0xe7, 0x07, 0x00, 0x51,
	0x15, 0xbb, 0x54, 0x88, 0x9d, 0xa6, 0xee, 0xba, 0xe4, 0x5b, 0x31, 0x5a, 0x8e, 0x44, 0xec, 0x37,
	0xf1, 0xb1, 0x5d, 0x8d, 0x61, 0xc9, 0xb9, 0x7a, 0xa7, 0x2b, 0xcf, 0x9c, 0xe0, 0x3d, 0x31, 0xa0,
	0xa0, 0xdf, 0x12, 0xfe, 0xff, 0x4a, 0xd0, 0x5e, 0xdf, 0x99, 0x05, 0x90, 0xcb, 0x7e, 0x0e, 0x5e,
	0xc8, 0x4b, 0x31, 0x1e, 0x27, 0xbf, 0xc8, 0x8d, 0x23, 0xcf, 0xb3, 0xdd, 0x82, 0x24, 0x1d, 0x1f,
	0x1f, 0x47, 0x5f, 0x2e, 0x5a, 0xcb, 0x3b, 0x62, 0x3f, 0x8d, 0xac, 0xda, 0x86, 0xe6, 0x1d, 0x5a,
	0x4e, 0x73, 0xe5, 0x74, 0xe6, 0xa2, 0x83, 0xb5, 0xfa, 0xaa, 0x65, 0x1a, 0x9d, 0xb5, 0x9f, 0x01,
	0x5c, 0xaa, 0x59, 0xcd, 0x61, 0x63, 0xbc, 0x96, 0xe2, 0x6b, 0xac, 0x44, 0x5e, 0x8e, 0x25, 0x70,
	0x77, 0x97, 0x3b, 0x34, 0x2c, 0x43, 0x33, 0x1b, 0xa2, 0xe5, 0x34, 0xa4, 0x06, 0x36, 0xe9, 0xbb,
	0x52, 0x3a, 0x01, 0xf0, 0xca, 0x5f, 0x70, 0x6e, 0x46, 0x44, 0xcf, 0x13, 0x0b, 0x9b, 0xec, 0xc0,
	0x22, 0x45, 0x50, 0xe6, 0xea, 0x1d, 0x8e, 0xe0, 0x20, 0xff, 0xc2, 0xb7, 0xb8, 0x47, 0x2d, 0xee,
	0x45, 0x2c, 0xee, 0x1d, 0xe4, 0xef, 0x8f, 0xd1, 0xf0, 0xd7, 0xff, 0x0a, 0x00, 0x00, 0xff, 0xff,
	0x4f, 0x3f, 0x0c, 0xe4, 0x3f, 0x12, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FoldersClient is the client API for Folders service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FoldersClient interface {
	// Lists the Folders that are direct descendants of supplied parent resource.
	// List provides a strongly consistent view of the Folders underneath
	// the specified parent resource.
	// List returns Folders sorted based upon the (ascending) lexical ordering
	// of their display_name.
	// The caller must have `resourcemanager.folders.list` permission on the
	// identified parent.
	ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error)
	// Search for folders that match specific filter criteria.
	// Search provides an eventually consistent view of the folders a user has
	// access to which meet the specified filter criteria.
	//
	// This will only return folders on which the caller has the
	// permission `resourcemanager.folders.get`.
	SearchFolders(ctx context.Context, in *SearchFoldersRequest, opts ...grpc.CallOption) (*SearchFoldersResponse, error)
	// Retrieves a Folder identified by the supplied resource name.
	// Valid Folder resource names have the format `folders/{folder_id}`
	// (for example, `folders/1234`).
	// The caller must have `resourcemanager.folders.get` permission on the
	// identified folder.
	GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Creates a Folder in the resource hierarchy.
	// Returns an Operation which can be used to track the progress of the
	// folder creation workflow.
	// Upon success the Operation.response field will be populated with the
	// created Folder.
	//
	// In order to succeed, the addition of this new Folder must not violate
	// the Folder naming, height or fanout constraints.
	//
	// + The Folder's display_name must be distinct from all other Folder's that
	// share its parent.
	// + The addition of the Folder must not cause the active Folder hierarchy
	// to exceed a height of 4. Note, the full active + deleted Folder hierarchy
	// is allowed to reach a height of 8; this provides additional headroom when
	// moving folders that contain deleted folders.
	// + The addition of the Folder must not cause the total number of Folders
	// under its parent to exceed 100.
	//
	// If the operation fails due to a folder constraint violation, some errors
	// may be returned by the CreateFolder request, with status code
	// FAILED_PRECONDITION and an error description. Other folder constraint
	// violations will be communicated in the Operation, with the specific
	// PreconditionFailure returned via the details list in the Operation.error
	// field.
	//
	// The caller must have `resourcemanager.folders.create` permission on the
	// identified parent.
	CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a Folder, changing its display_name.
	// Changes to the folder display_name will be rejected if they violate either
	// the display_name formatting rules or naming constraints described in
	// the [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	//
	// The Folder's display name must start and end with a letter or digit,
	// may contain letters, digits, spaces, hyphens and underscores and can be
	// no longer than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	// The caller must have `resourcemanager.folders.update` permission on the
	// identified folder.
	//
	// If the update fails due to the unique name constraint then a
	// PreconditionFailure explaining this violation will be returned
	// in the Status.details field.
	UpdateFolder(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Moves a Folder under a new resource parent.
	// Returns an Operation which can be used to track the progress of the
	// folder move workflow.
	// Upon success the Operation.response field will be populated with the
	// moved Folder.
	// Upon failure, a FolderOperationError categorizing the failure cause will
	// be returned - if the failure occurs synchronously then the
	// FolderOperationError will be returned via the Status.details field
	// and if it occurs asynchronously then the FolderOperation will be returned
	// via the Operation.error field.
	// In addition, the Operation.metadata field will be populated with a
	// FolderOperation message as an aid to stateless clients.
	// Folder moves will be rejected if they violate either the naming, height
	// or fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.move` permission on the
	// folder's current and proposed new parent.
	MoveFolder(ctx context.Context, in *MoveFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Requests deletion of a Folder. The Folder is moved into the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED] state
	// immediately, and is deleted approximately 30 days later. This method may
	// only be called on an empty Folder in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state, where a Folder is empty if
	// it doesn't contain any Folders or Projects in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state.
	// The caller must have `resourcemanager.folders.delete` permission on the
	// identified folder.
	DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Cancels the deletion request for a Folder. This method may only be
	// called on a Folder in the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED] state.
	// In order to succeed, the Folder's parent must be in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state.
	// In addition, reintroducing the folder into the tree must not violate
	// folder naming, height and fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.undelete` permission on the
	// identified folder.
	UndeleteFolder(ctx context.Context, in *UndeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Gets the access control policy for a Folder. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the Folder's resource name, e.g. "folders/1234".
	// The caller must have `resourcemanager.folders.getIamPolicy` permission
	// on the identified folder.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy on a Folder, replacing any existing policy.
	// The `resource` field should be the Folder's resource name, e.g.
	// "folders/1234".
	// The caller must have `resourcemanager.folders.setIamPolicy` permission
	// on the identified folder.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified Folder.
	// The `resource` field should be the Folder's resource name,
	// e.g. "folders/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type foldersClient struct {
	cc grpc.ClientConnInterface
}

func NewFoldersClient(cc grpc.ClientConnInterface) FoldersClient {
	return &foldersClient{cc}
}

func (c *foldersClient) ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error) {
	out := new(ListFoldersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/ListFolders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) SearchFolders(ctx context.Context, in *SearchFoldersRequest, opts ...grpc.CallOption) (*SearchFoldersResponse, error) {
	out := new(SearchFoldersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/SearchFolders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/GetFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/CreateFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) UpdateFolder(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/UpdateFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) MoveFolder(ctx context.Context, in *MoveFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/MoveFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/DeleteFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) UndeleteFolder(ctx context.Context, in *UndeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/UndeleteFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FoldersServer is the server API for Folders service.
type FoldersServer interface {
	// Lists the Folders that are direct descendants of supplied parent resource.
	// List provides a strongly consistent view of the Folders underneath
	// the specified parent resource.
	// List returns Folders sorted based upon the (ascending) lexical ordering
	// of their display_name.
	// The caller must have `resourcemanager.folders.list` permission on the
	// identified parent.
	ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error)
	// Search for folders that match specific filter criteria.
	// Search provides an eventually consistent view of the folders a user has
	// access to which meet the specified filter criteria.
	//
	// This will only return folders on which the caller has the
	// permission `resourcemanager.folders.get`.
	SearchFolders(context.Context, *SearchFoldersRequest) (*SearchFoldersResponse, error)
	// Retrieves a Folder identified by the supplied resource name.
	// Valid Folder resource names have the format `folders/{folder_id}`
	// (for example, `folders/1234`).
	// The caller must have `resourcemanager.folders.get` permission on the
	// identified folder.
	GetFolder(context.Context, *GetFolderRequest) (*Folder, error)
	// Creates a Folder in the resource hierarchy.
	// Returns an Operation which can be used to track the progress of the
	// folder creation workflow.
	// Upon success the Operation.response field will be populated with the
	// created Folder.
	//
	// In order to succeed, the addition of this new Folder must not violate
	// the Folder naming, height or fanout constraints.
	//
	// + The Folder's display_name must be distinct from all other Folder's that
	// share its parent.
	// + The addition of the Folder must not cause the active Folder hierarchy
	// to exceed a height of 4. Note, the full active + deleted Folder hierarchy
	// is allowed to reach a height of 8; this provides additional headroom when
	// moving folders that contain deleted folders.
	// + The addition of the Folder must not cause the total number of Folders
	// under its parent to exceed 100.
	//
	// If the operation fails due to a folder constraint violation, some errors
	// may be returned by the CreateFolder request, with status code
	// FAILED_PRECONDITION and an error description. Other folder constraint
	// violations will be communicated in the Operation, with the specific
	// PreconditionFailure returned via the details list in the Operation.error
	// field.
	//
	// The caller must have `resourcemanager.folders.create` permission on the
	// identified parent.
	CreateFolder(context.Context, *CreateFolderRequest) (*longrunning.Operation, error)
	// Updates a Folder, changing its display_name.
	// Changes to the folder display_name will be rejected if they violate either
	// the display_name formatting rules or naming constraints described in
	// the [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	//
	// The Folder's display name must start and end with a letter or digit,
	// may contain letters, digits, spaces, hyphens and underscores and can be
	// no longer than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	// The caller must have `resourcemanager.folders.update` permission on the
	// identified folder.
	//
	// If the update fails due to the unique name constraint then a
	// PreconditionFailure explaining this violation will be returned
	// in the Status.details field.
	UpdateFolder(context.Context, *UpdateFolderRequest) (*Folder, error)
	// Moves a Folder under a new resource parent.
	// Returns an Operation which can be used to track the progress of the
	// folder move workflow.
	// Upon success the Operation.response field will be populated with the
	// moved Folder.
	// Upon failure, a FolderOperationError categorizing the failure cause will
	// be returned - if the failure occurs synchronously then the
	// FolderOperationError will be returned via the Status.details field
	// and if it occurs asynchronously then the FolderOperation will be returned
	// via the Operation.error field.
	// In addition, the Operation.metadata field will be populated with a
	// FolderOperation message as an aid to stateless clients.
	// Folder moves will be rejected if they violate either the naming, height
	// or fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.move` permission on the
	// folder's current and proposed new parent.
	MoveFolder(context.Context, *MoveFolderRequest) (*longrunning.Operation, error)
	// Requests deletion of a Folder. The Folder is moved into the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED] state
	// immediately, and is deleted approximately 30 days later. This method may
	// only be called on an empty Folder in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state, where a Folder is empty if
	// it doesn't contain any Folders or Projects in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state.
	// The caller must have `resourcemanager.folders.delete` permission on the
	// identified folder.
	DeleteFolder(context.Context, *DeleteFolderRequest) (*Folder, error)
	// Cancels the deletion request for a Folder. This method may only be
	// called on a Folder in the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED] state.
	// In order to succeed, the Folder's parent must be in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state.
	// In addition, reintroducing the folder into the tree must not violate
	// folder naming, height and fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.undelete` permission on the
	// identified folder.
	UndeleteFolder(context.Context, *UndeleteFolderRequest) (*Folder, error)
	// Gets the access control policy for a Folder. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the Folder's resource name, e.g. "folders/1234".
	// The caller must have `resourcemanager.folders.getIamPolicy` permission
	// on the identified folder.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy on a Folder, replacing any existing policy.
	// The `resource` field should be the Folder's resource name, e.g.
	// "folders/1234".
	// The caller must have `resourcemanager.folders.setIamPolicy` permission
	// on the identified folder.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified Folder.
	// The `resource` field should be the Folder's resource name,
	// e.g. "folders/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedFoldersServer can be embedded to have forward compatible implementations.
type UnimplementedFoldersServer struct {
}

func (*UnimplementedFoldersServer) ListFolders(ctx context.Context, req *ListFoldersRequest) (*ListFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFolders not implemented")
}
func (*UnimplementedFoldersServer) SearchFolders(ctx context.Context, req *SearchFoldersRequest) (*SearchFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchFolders not implemented")
}
func (*UnimplementedFoldersServer) GetFolder(ctx context.Context, req *GetFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFolder not implemented")
}
func (*UnimplementedFoldersServer) CreateFolder(ctx context.Context, req *CreateFolderRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFolder not implemented")
}
func (*UnimplementedFoldersServer) UpdateFolder(ctx context.Context, req *UpdateFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFolder not implemented")
}
func (*UnimplementedFoldersServer) MoveFolder(ctx context.Context, req *MoveFolderRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveFolder not implemented")
}
func (*UnimplementedFoldersServer) DeleteFolder(ctx context.Context, req *DeleteFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFolder not implemented")
}
func (*UnimplementedFoldersServer) UndeleteFolder(ctx context.Context, req *UndeleteFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteFolder not implemented")
}
func (*UnimplementedFoldersServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedFoldersServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedFoldersServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterFoldersServer(s *grpc.Server, srv FoldersServer) {
	s.RegisterService(&_Folders_serviceDesc, srv)
}

func _Folders_ListFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).ListFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/ListFolders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).ListFolders(ctx, req.(*ListFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_SearchFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).SearchFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/SearchFolders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).SearchFolders(ctx, req.(*SearchFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_GetFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).GetFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/GetFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).GetFolder(ctx, req.(*GetFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_CreateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).CreateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/CreateFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).CreateFolder(ctx, req.(*CreateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_UpdateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).UpdateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/UpdateFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).UpdateFolder(ctx, req.(*UpdateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_MoveFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).MoveFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/MoveFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).MoveFolder(ctx, req.(*MoveFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_DeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).DeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/DeleteFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).DeleteFolder(ctx, req.(*DeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_UndeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).UndeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/UndeleteFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).UndeleteFolder(ctx, req.(*UndeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Folders_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v2.Folders",
	HandlerType: (*FoldersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFolders",
			Handler:    _Folders_ListFolders_Handler,
		},
		{
			MethodName: "SearchFolders",
			Handler:    _Folders_SearchFolders_Handler,
		},
		{
			MethodName: "GetFolder",
			Handler:    _Folders_GetFolder_Handler,
		},
		{
			MethodName: "CreateFolder",
			Handler:    _Folders_CreateFolder_Handler,
		},
		{
			MethodName: "UpdateFolder",
			Handler:    _Folders_UpdateFolder_Handler,
		},
		{
			MethodName: "MoveFolder",
			Handler:    _Folders_MoveFolder_Handler,
		},
		{
			MethodName: "DeleteFolder",
			Handler:    _Folders_DeleteFolder_Handler,
		},
		{
			MethodName: "UndeleteFolder",
			Handler:    _Folders_UndeleteFolder_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Folders_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Folders_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Folders_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v2/folders.proto",
}
