// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/managedidentities/v1beta1/resource.proto

package managedidentities

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents the different states of a managed domain.
type Domain_State int32

const (
	// Not set.
	Domain_STATE_UNSPECIFIED Domain_State = 0
	// The domain is being created.
	Domain_CREATING Domain_State = 1
	// The domain has been created and is fully usable.
	Domain_READY Domain_State = 2
	// The domain's configuration is being updated.
	Domain_UPDATING Domain_State = 3
	// The domain is being deleted.
	Domain_DELETING Domain_State = 4
	// The domain is being repaired and may be unusable. Details
	// can be found in the `status_message` field.
	Domain_REPAIRING Domain_State = 5
	// The domain is undergoing maintenance.
	Domain_PERFORMING_MAINTENANCE Domain_State = 6
	// The domain is not serving requests.
	Domain_UNAVAILABLE Domain_State = 7
)

var Domain_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
	3: "UPDATING",
	4: "DELETING",
	5: "REPAIRING",
	6: "PERFORMING_MAINTENANCE",
	7: "UNAVAILABLE",
}

var Domain_State_value = map[string]int32{
	"STATE_UNSPECIFIED":      0,
	"CREATING":               1,
	"READY":                  2,
	"UPDATING":               3,
	"DELETING":               4,
	"REPAIRING":              5,
	"PERFORMING_MAINTENANCE": 6,
	"UNAVAILABLE":            7,
}

func (x Domain_State) String() string {
	return proto.EnumName(Domain_State_name, int32(x))
}

func (Domain_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8981da39176e480d, []int{0, 0}
}

// Represents the different states of a domain trust.
type Trust_State int32

const (
	// Not set.
	Trust_STATE_UNSPECIFIED Trust_State = 0
	// The domain trust is being created.
	Trust_CREATING Trust_State = 1
	// The domain trust is being updated.
	Trust_UPDATING Trust_State = 2
	// The domain trust is being deleted.
	Trust_DELETING Trust_State = 3
	// The domain trust is connected.
	Trust_CONNECTED Trust_State = 4
	// The domain trust is disconnected.
	Trust_DISCONNECTED Trust_State = 5
)

var Trust_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "UPDATING",
	3: "DELETING",
	4: "CONNECTED",
	5: "DISCONNECTED",
}

var Trust_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"UPDATING":          2,
	"DELETING":          3,
	"CONNECTED":         4,
	"DISCONNECTED":      5,
}

func (x Trust_State) String() string {
	return proto.EnumName(Trust_State_name, int32(x))
}

func (Trust_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8981da39176e480d, []int{1, 0}
}

// Represents the different inter-forest trust types.
type Trust_TrustType int32

const (
	// Not set.
	Trust_TRUST_TYPE_UNSPECIFIED Trust_TrustType = 0
	// The forest trust.
	Trust_FOREST Trust_TrustType = 1
	// The external domain trust.
	Trust_EXTERNAL Trust_TrustType = 2
)

var Trust_TrustType_name = map[int32]string{
	0: "TRUST_TYPE_UNSPECIFIED",
	1: "FOREST",
	2: "EXTERNAL",
}

var Trust_TrustType_value = map[string]int32{
	"TRUST_TYPE_UNSPECIFIED": 0,
	"FOREST":                 1,
	"EXTERNAL":               2,
}

func (x Trust_TrustType) String() string {
	return proto.EnumName(Trust_TrustType_name, int32(x))
}

func (Trust_TrustType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8981da39176e480d, []int{1, 1}
}

// Represents the direction of trust.
// See
// [System.DirectoryServices.ActiveDirectory.TrustDirection](https://docs.microsoft.com/en-us/dotnet/api/system.directoryservices.activedirectory.trustdirection?view=netframework-4.7.2)
// for more information.
type Trust_TrustDirection int32

const (
	// Not set.
	Trust_TRUST_DIRECTION_UNSPECIFIED Trust_TrustDirection = 0
	// The inbound direction represents the trusting side.
	Trust_INBOUND Trust_TrustDirection = 1
	// The outboud direction represents the trusted side.
	Trust_OUTBOUND Trust_TrustDirection = 2
	// The bidirectional direction represents the trusted / trusting side.
	Trust_BIDIRECTIONAL Trust_TrustDirection = 3
)

var Trust_TrustDirection_name = map[int32]string{
	0: "TRUST_DIRECTION_UNSPECIFIED",
	1: "INBOUND",
	2: "OUTBOUND",
	3: "BIDIRECTIONAL",
}

var Trust_TrustDirection_value = map[string]int32{
	"TRUST_DIRECTION_UNSPECIFIED": 0,
	"INBOUND":                     1,
	"OUTBOUND":                    2,
	"BIDIRECTIONAL":               3,
}

func (x Trust_TrustDirection) String() string {
	return proto.EnumName(Trust_TrustDirection_name, int32(x))
}

func (Trust_TrustDirection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8981da39176e480d, []int{1, 2}
}

// Represents a managed Microsoft Active Directory domain.
type Domain struct {
	// Output only. The unique name of the domain using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Resource labels that can contain user-provided metadata.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The full names of the Google Compute Engine
	// [networks](/compute/docs/networks-and-firewalls#networks) the domain
	// instance is connected to. Networks can be added using UpdateDomain.
	// The domain is only available on networks listed in `authorized_networks`.
	// If CIDR subnets overlap between networks, domain creation will fail.
	AuthorizedNetworks []string `protobuf:"bytes,3,rep,name=authorized_networks,json=authorizedNetworks,proto3" json:"authorized_networks,omitempty"`
	// Required. The CIDR range of internal addresses that are reserved for this
	// domain. Reserved networks must be /24 or larger. Ranges must be
	// unique and non-overlapping with existing subnets in
	// [Domain].[authorized_networks].
	ReservedIpRange string `protobuf:"bytes,4,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Required. Locations where domain needs to be provisioned.
	// [regions][compute/docs/regions-zones/]
	// e.g. us-west1 or us-east4
	// Service supports up to 4 locations at once. Each location will use a /26
	// block.
	Locations []string `protobuf:"bytes,5,rep,name=locations,proto3" json:"locations,omitempty"`
	// Optional. The name of delegated administrator account used to perform
	// Active Directory operations. If not specified, `setupadmin` will be used.
	Admin string `protobuf:"bytes,6,opt,name=admin,proto3" json:"admin,omitempty"`
	// Output only. The fully-qualified domain name of the exposed domain used by
	// clients to connect to the service. Similar to what would be chosen for an
	// Active Directory set up on an internal network.
	Fqdn string `protobuf:"bytes,10,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The current state of this domain.
	State Domain_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.managedidentities.v1beta1.Domain_State" json:"state,omitempty"`
	// Output only. Additional information about the current status of this
	// domain, if available.
	StatusMessage string `protobuf:"bytes,14,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. The current trusts associated with the domain.
	Trusts               []*Trust `protobuf:"bytes,15,rep,name=trusts,proto3" json:"trusts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Domain) Reset()         { *m = Domain{} }
func (m *Domain) String() string { return proto.CompactTextString(m) }
func (*Domain) ProtoMessage()    {}
func (*Domain) Descriptor() ([]byte, []int) {
	return fileDescriptor_8981da39176e480d, []int{0}
}

func (m *Domain) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Domain.Unmarshal(m, b)
}
func (m *Domain) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Domain.Marshal(b, m, deterministic)
}
func (m *Domain) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Domain.Merge(m, src)
}
func (m *Domain) XXX_Size() int {
	return xxx_messageInfo_Domain.Size(m)
}
func (m *Domain) XXX_DiscardUnknown() {
	xxx_messageInfo_Domain.DiscardUnknown(m)
}

var xxx_messageInfo_Domain proto.InternalMessageInfo

func (m *Domain) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Domain) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Domain) GetAuthorizedNetworks() []string {
	if m != nil {
		return m.AuthorizedNetworks
	}
	return nil
}

func (m *Domain) GetReservedIpRange() string {
	if m != nil {
		return m.ReservedIpRange
	}
	return ""
}

func (m *Domain) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *Domain) GetAdmin() string {
	if m != nil {
		return m.Admin
	}
	return ""
}

func (m *Domain) GetFqdn() string {
	if m != nil {
		return m.Fqdn
	}
	return ""
}

func (m *Domain) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Domain) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Domain) GetState() Domain_State {
	if m != nil {
		return m.State
	}
	return Domain_STATE_UNSPECIFIED
}

func (m *Domain) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Domain) GetTrusts() []*Trust {
	if m != nil {
		return m.Trusts
	}
	return nil
}

// Represents a relationship between two domains. This allows a controller in
// one domain to authenticate a user in another domain.
type Trust struct {
	// The fully qualified target domain name which will be in trust with the
	// current domain.
	TargetDomainName string `protobuf:"bytes,1,opt,name=target_domain_name,json=targetDomainName,proto3" json:"target_domain_name,omitempty"`
	// The type of trust represented by the trust resource.
	TrustType Trust_TrustType `protobuf:"varint,2,opt,name=trust_type,json=trustType,proto3,enum=google.cloud.managedidentities.v1beta1.Trust_TrustType" json:"trust_type,omitempty"`
	// The trust direction, which decides if the current domain is trusted,
	// trusting, or both.
	TrustDirection Trust_TrustDirection `protobuf:"varint,3,opt,name=trust_direction,json=trustDirection,proto3,enum=google.cloud.managedidentities.v1beta1.Trust_TrustDirection" json:"trust_direction,omitempty"`
	// The trust authentication type, which decides whether the trusted side has
	// forest/domain wide access or selective access to an approved set of
	// resources.
	SelectiveAuthentication bool `protobuf:"varint,4,opt,name=selective_authentication,json=selectiveAuthentication,proto3" json:"selective_authentication,omitempty"`
	// The target DNS server IP addresses which can resolve the remote domain
	// involved in the trust.
	TargetDnsIpAddresses []string `protobuf:"bytes,5,rep,name=target_dns_ip_addresses,json=targetDnsIpAddresses,proto3" json:"target_dns_ip_addresses,omitempty"`
	// Input only, and will not be stored. The trust secret used for the handshake
	// with the target domain.
	TrustHandshakeSecret string `protobuf:"bytes,6,opt,name=trust_handshake_secret,json=trustHandshakeSecret,proto3" json:"trust_handshake_secret,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The current state of the trust.
	State Trust_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.managedidentities.v1beta1.Trust_State" json:"state,omitempty"`
	// Output only. Additional information about the current state of the
	// trust, if available.
	StateDescription string `protobuf:"bytes,11,opt,name=state_description,json=stateDescription,proto3" json:"state_description,omitempty"`
	// Output only. The last heartbeat time when the trust was known to be
	// connected.
	LastTrustHeartbeatTime *timestamp.Timestamp `protobuf:"bytes,12,opt,name=last_trust_heartbeat_time,json=lastTrustHeartbeatTime,proto3" json:"last_trust_heartbeat_time,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}             `json:"-"`
	XXX_unrecognized       []byte               `json:"-"`
	XXX_sizecache          int32                `json:"-"`
}

func (m *Trust) Reset()         { *m = Trust{} }
func (m *Trust) String() string { return proto.CompactTextString(m) }
func (*Trust) ProtoMessage()    {}
func (*Trust) Descriptor() ([]byte, []int) {
	return fileDescriptor_8981da39176e480d, []int{1}
}

func (m *Trust) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trust.Unmarshal(m, b)
}
func (m *Trust) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trust.Marshal(b, m, deterministic)
}
func (m *Trust) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trust.Merge(m, src)
}
func (m *Trust) XXX_Size() int {
	return xxx_messageInfo_Trust.Size(m)
}
func (m *Trust) XXX_DiscardUnknown() {
	xxx_messageInfo_Trust.DiscardUnknown(m)
}

var xxx_messageInfo_Trust proto.InternalMessageInfo

func (m *Trust) GetTargetDomainName() string {
	if m != nil {
		return m.TargetDomainName
	}
	return ""
}

func (m *Trust) GetTrustType() Trust_TrustType {
	if m != nil {
		return m.TrustType
	}
	return Trust_TRUST_TYPE_UNSPECIFIED
}

func (m *Trust) GetTrustDirection() Trust_TrustDirection {
	if m != nil {
		return m.TrustDirection
	}
	return Trust_TRUST_DIRECTION_UNSPECIFIED
}

func (m *Trust) GetSelectiveAuthentication() bool {
	if m != nil {
		return m.SelectiveAuthentication
	}
	return false
}

func (m *Trust) GetTargetDnsIpAddresses() []string {
	if m != nil {
		return m.TargetDnsIpAddresses
	}
	return nil
}

func (m *Trust) GetTrustHandshakeSecret() string {
	if m != nil {
		return m.TrustHandshakeSecret
	}
	return ""
}

func (m *Trust) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Trust) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Trust) GetState() Trust_State {
	if m != nil {
		return m.State
	}
	return Trust_STATE_UNSPECIFIED
}

func (m *Trust) GetStateDescription() string {
	if m != nil {
		return m.StateDescription
	}
	return ""
}

func (m *Trust) GetLastTrustHeartbeatTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastTrustHeartbeatTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.managedidentities.v1beta1.Domain_State", Domain_State_name, Domain_State_value)
	proto.RegisterEnum("google.cloud.managedidentities.v1beta1.Trust_State", Trust_State_name, Trust_State_value)
	proto.RegisterEnum("google.cloud.managedidentities.v1beta1.Trust_TrustType", Trust_TrustType_name, Trust_TrustType_value)
	proto.RegisterEnum("google.cloud.managedidentities.v1beta1.Trust_TrustDirection", Trust_TrustDirection_name, Trust_TrustDirection_value)
	proto.RegisterType((*Domain)(nil), "google.cloud.managedidentities.v1beta1.Domain")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.managedidentities.v1beta1.Domain.LabelsEntry")
	proto.RegisterType((*Trust)(nil), "google.cloud.managedidentities.v1beta1.Trust")
}

func init() {
	proto.RegisterFile("google/cloud/managedidentities/v1beta1/resource.proto", fileDescriptor_8981da39176e480d)
}

var fileDescriptor_8981da39176e480d = []byte{
	// 960 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xd1, 0x6e, 0xdb, 0x36,
	0x14, 0x9d, 0xed, 0xd8, 0x89, 0xaf, 0x13, 0x47, 0xe1, 0xb2, 0x54, 0xcb, 0x0a, 0x34, 0x30, 0xb0,
	0x22, 0xe8, 0x36, 0x1b, 0x49, 0x5b, 0x6c, 0x6d, 0xf7, 0x22, 0x5b, 0x4c, 0xaa, 0xc1, 0x91, 0x0d,
	0x5a, 0xce, 0xd6, 0xbd, 0x08, 0x8c, 0xc5, 0x2a, 0x42, 0x6c, 0x49, 0x13, 0xe9, 0x0c, 0xd9, 0x4f,
	0xec, 0x6d, 0x1f, 0xb1, 0x9f, 0xd8, 0x4f, 0xed, 0x03, 0x06, 0x92, 0x52, 0x1c, 0xa7, 0x0f, 0x8d,
	0xd7, 0x17, 0x83, 0x97, 0x87, 0xe7, 0x90, 0xf7, 0x90, 0xc7, 0x36, 0xbc, 0x0c, 0x93, 0x24, 0x9c,
	0xb2, 0xce, 0x64, 0x9a, 0xcc, 0x83, 0xce, 0x8c, 0xc6, 0x34, 0x64, 0x41, 0x14, 0xb0, 0x58, 0x44,
	0x22, 0x62, 0xbc, 0x73, 0x7d, 0x74, 0xc1, 0x04, 0x3d, 0xea, 0x64, 0x8c, 0x27, 0xf3, 0x6c, 0xc2,
	0xda, 0x69, 0x96, 0x88, 0x04, 0x3d, 0xd5, 0xb4, 0xb6, 0xa2, 0xb5, 0x3f, 0xa0, 0xb5, 0x73, 0xda,
	0xfe, 0x93, 0x5c, 0x5e, 0xb1, 0x2e, 0xe6, 0xef, 0x3b, 0x22, 0x9a, 0x31, 0x2e, 0xe8, 0x2c, 0xd5,
	0x42, 0xfb, 0x8f, 0xf3, 0x05, 0x34, 0x8d, 0x3a, 0x34, 0x8e, 0x13, 0x41, 0x45, 0x94, 0xc4, 0x5c,
	0xa3, 0xad, 0xbf, 0x6a, 0x50, 0xb3, 0x93, 0x19, 0x8d, 0x62, 0x84, 0x60, 0x2d, 0xa6, 0x33, 0x66,
	0x96, 0x0e, 0x4a, 0x87, 0x75, 0xa2, 0xc6, 0x88, 0x40, 0x6d, 0x4a, 0x2f, 0xd8, 0x94, 0x9b, 0xe5,
	0x83, 0xca, 0x61, 0xe3, 0xf8, 0x75, 0xfb, 0x61, 0xc7, 0x6a, 0x6b, 0xcd, 0x76, 0x5f, 0x91, 0x71,
	0x2c, 0xb2, 0x1b, 0x92, 0x2b, 0xa1, 0x0e, 0x7c, 0x4e, 0xe7, 0xe2, 0x32, 0xc9, 0xa2, 0x3f, 0x58,
	0xe0, 0xc7, 0x4c, 0xfc, 0x9e, 0x64, 0x57, 0xdc, 0xac, 0x1c, 0x54, 0x0e, 0xeb, 0x04, 0x2d, 0x20,
	0x37, 0x47, 0xd0, 0x33, 0xd8, 0xc9, 0x18, 0x67, 0xd9, 0x35, 0x0b, 0xfc, 0x28, 0xf5, 0x33, 0x1a,
	0x87, 0xcc, 0x5c, 0x53, 0xa7, 0xdc, 0x2e, 0x00, 0x27, 0x25, 0x72, 0x1a, 0x3d, 0x86, 0xfa, 0x34,
	0x99, 0xe8, 0x16, 0xcd, 0xaa, 0x92, 0x5c, 0x4c, 0xa0, 0x5d, 0xa8, 0xd2, 0x60, 0x16, 0xc5, 0x66,
	0x4d, 0xb1, 0x75, 0x21, 0x1b, 0x7f, 0xff, 0x5b, 0x10, 0x9b, 0xa0, 0x1b, 0x97, 0x63, 0xf4, 0x06,
	0x1a, 0x93, 0x8c, 0x51, 0xc1, 0x7c, 0xe9, 0xa7, 0xd9, 0x38, 0x28, 0x1d, 0x36, 0x8e, 0xf7, 0x8b,
	0xee, 0x0b, 0xb3, 0xdb, 0x5e, 0x61, 0x36, 0x01, 0xbd, 0x5c, 0x4e, 0x48, 0xf2, 0x3c, 0x0d, 0x6e,
	0xc9, 0x9b, 0x1f, 0x27, 0xeb, 0xe5, 0x8a, 0xfc, 0x13, 0x54, 0xb9, 0xa0, 0x82, 0x99, 0x5b, 0x07,
	0xa5, 0xc3, 0xe6, 0xf1, 0x8b, 0x15, 0x1d, 0x1f, 0x49, 0x2e, 0xd1, 0x12, 0xe8, 0x6b, 0x68, 0xca,
	0xc1, 0x9c, 0xfb, 0x33, 0xc6, 0x39, 0x0d, 0x99, 0xd9, 0x54, 0x3d, 0x6e, 0xe9, 0xd9, 0x33, 0x3d,
	0x89, 0x30, 0xd4, 0x44, 0x36, 0xe7, 0x82, 0x9b, 0xdb, 0xea, 0x96, 0xbf, 0x7b, 0xe8, 0x9e, 0x9e,
	0x64, 0x91, 0x9c, 0xbc, 0xff, 0x0a, 0x1a, 0x77, 0xee, 0x1b, 0x19, 0x50, 0xb9, 0x62, 0x37, 0xf9,
	0x73, 0x92, 0x43, 0x69, 0xff, 0x35, 0x9d, 0xce, 0x99, 0x59, 0xd6, 0xf6, 0xab, 0xe2, 0x75, 0xf9,
	0x87, 0x52, 0xeb, 0xcf, 0x12, 0x54, 0xd5, 0xc9, 0xd1, 0x17, 0xb0, 0x33, 0xf2, 0x2c, 0x0f, 0xfb,
	0x63, 0x77, 0x34, 0xc4, 0x3d, 0xe7, 0xc4, 0xc1, 0xb6, 0xf1, 0x19, 0xda, 0x84, 0x8d, 0x1e, 0xc1,
	0x96, 0xe7, 0xb8, 0xa7, 0x46, 0x09, 0xd5, 0xa1, 0x4a, 0xb0, 0x65, 0xbf, 0x33, 0xca, 0x12, 0x18,
	0x0f, 0x6d, 0x0d, 0x54, 0x64, 0x65, 0xe3, 0x3e, 0x56, 0xd5, 0x1a, 0xda, 0x82, 0x3a, 0xc1, 0x43,
	0xcb, 0x21, 0xb2, 0xac, 0xa2, 0x7d, 0xd8, 0x1b, 0x62, 0x72, 0x32, 0x20, 0x67, 0x8e, 0x7b, 0xea,
	0x9f, 0x59, 0x8e, 0xeb, 0x61, 0xd7, 0x72, 0x7b, 0xd8, 0xa8, 0xa1, 0x6d, 0x68, 0x8c, 0x5d, 0xeb,
	0xdc, 0x72, 0xfa, 0x56, 0xb7, 0x8f, 0x8d, 0xf5, 0xd6, 0xbf, 0xeb, 0x50, 0x55, 0xed, 0xa1, 0x6f,
	0x01, 0x09, 0x9a, 0x85, 0x4c, 0xf8, 0x81, 0xb2, 0xd8, 0xbf, 0x93, 0x12, 0x43, 0x23, 0xda, 0x7b,
	0x57, 0x26, 0xe6, 0x1c, 0x40, 0xd9, 0xe1, 0x8b, 0x9b, 0x54, 0x37, 0xda, 0x3c, 0xfe, 0x7e, 0x25,
	0x3f, 0xf5, 0xa7, 0x77, 0x93, 0x32, 0x52, 0x17, 0xc5, 0x10, 0x31, 0xd8, 0xd6, 0xba, 0x41, 0x94,
	0xb1, 0x89, 0x7c, 0xce, 0x66, 0x45, 0x89, 0xff, 0xf8, 0x3f, 0xc4, 0xed, 0x42, 0x83, 0x34, 0xc5,
	0x52, 0x8d, 0x5e, 0x81, 0xc9, 0xd9, 0x54, 0x16, 0xd7, 0xcc, 0x97, 0x59, 0x94, 0x32, 0x3a, 0x3e,
	0x2a, 0x72, 0x1b, 0xe4, 0xd1, 0x2d, 0x6e, 0x2d, 0xc1, 0xe8, 0x25, 0x3c, 0x2a, 0x7c, 0x8a, 0xb9,
	0x0c, 0x2a, 0x0d, 0x82, 0x8c, 0x71, 0xce, 0x8a, 0x20, 0xee, 0xe6, 0x66, 0xc5, 0xdc, 0x49, 0xad,
	0x02, 0x43, 0x2f, 0x60, 0x4f, 0x37, 0x76, 0x49, 0xe3, 0x80, 0x5f, 0xd2, 0x2b, 0xe6, 0x73, 0x36,
	0xc9, 0x98, 0xc8, 0x43, 0xba, 0xab, 0xd0, 0xb7, 0x05, 0x38, 0x52, 0xd8, 0xfd, 0x7c, 0xae, 0x7f,
	0x4a, 0x3e, 0x37, 0x56, 0xca, 0xa7, 0x53, 0xe4, 0xb3, 0xae, 0xec, 0x7f, 0xbe, 0x9a, 0xfd, 0x4b,
	0xf1, 0xfc, 0x06, 0x76, 0xd4, 0xc0, 0x0f, 0x18, 0x9f, 0x64, 0x51, 0xaa, 0x5c, 0x6e, 0xe8, 0x87,
	0xa5, 0x00, 0x7b, 0x31, 0x8f, 0xc6, 0xf0, 0xe5, 0x94, 0xca, 0x77, 0xa5, 0xcd, 0x62, 0x34, 0x13,
	0x17, 0x8c, 0x8a, 0x87, 0x7e, 0xc5, 0xec, 0x49, 0xb2, 0x3a, 0xc3, 0xdb, 0x82, 0x2a, 0xc1, 0x56,
	0xb4, 0x52, 0xf0, 0xee, 0xa6, 0xad, 0xbc, 0x94, 0xb6, 0x8a, 0x4c, 0x5b, 0x6f, 0xe0, 0xba, 0xb8,
	0xe7, 0x61, 0xdb, 0x58, 0x43, 0x06, 0x6c, 0xda, 0xce, 0x68, 0x31, 0x53, 0x6d, 0x59, 0x50, 0xbf,
	0x7d, 0xda, 0x32, 0x8c, 0x1e, 0x19, 0x8f, 0x3c, 0xdf, 0x7b, 0x37, 0xbc, 0xbf, 0x27, 0x40, 0xed,
	0x64, 0x40, 0xf0, 0xc8, 0xd3, 0x3b, 0xe2, 0x5f, 0x3c, 0x4c, 0x5c, 0xab, 0x6f, 0x94, 0x5b, 0x3e,
	0x34, 0x97, 0x1f, 0x30, 0x7a, 0x02, 0x5f, 0x69, 0x1d, 0xdb, 0x21, 0xb8, 0xe7, 0x39, 0x03, 0xf7,
	0x9e, 0x58, 0x03, 0xd6, 0x1d, 0xb7, 0x3b, 0x18, 0xbb, 0xb6, 0x56, 0x1b, 0x8c, 0x3d, 0x5d, 0x95,
	0xd1, 0x0e, 0x6c, 0x75, 0x9d, 0x5b, 0x9e, 0xd5, 0x37, 0x2a, 0xdd, 0x7f, 0x4a, 0xf0, 0x6c, 0x92,
	0xcc, 0x1e, 0x78, 0xa9, 0xdd, 0x2d, 0x92, 0xff, 0x6a, 0x0f, 0xa5, 0xe3, 0xc3, 0xd2, 0xaf, 0x3f,
	0xe7, 0xc4, 0x30, 0x99, 0xd2, 0x38, 0x6c, 0x27, 0x59, 0xd8, 0x09, 0x59, 0xac, 0xee, 0xa3, 0xa3,
	0x21, 0x9a, 0x46, 0xfc, 0x63, 0x7f, 0x06, 0xde, 0x7c, 0x80, 0xfc, 0x5d, 0x7e, 0x7a, 0xaa, 0x95,
	0x7b, 0xea, 0x48, 0x67, 0x7a, 0x81, 0xb3, 0x38, 0xd2, 0xf9, 0x51, 0x57, 0x52, 0x2f, 0x6a, 0x6a,
	0xb3, 0xe7, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0xda, 0xda, 0xbf, 0x21, 0x78, 0x08, 0x00, 0x00,
}
