// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/ad_group_simulation.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad group simulation. Supported combinations of advertising
// channel type, simulation type and simulation modification method is
// detailed below respectively.
//
// 1. SEARCH - CPC_BID - DEFAULT
// 2. SEARCH - CPC_BID - UNIFORM
// 3. SEARCH - TARGET_CPA - UNIFORM
// 4. DISPLAY - CPC_BID - DEFAULT
// 5. DISPLAY - CPC_BID - UNIFORM
// 6. DISPLAY - TARGET_CPA - UNIFORM
// 7. VIDEO - CPV_BID - DEFAULT
// 8. VIDEO - CPV_BID - UNIFORM
type AdGroupSimulation struct {
	// Output only. The resource name of the ad group simulation.
	// Ad group simulation resource names have the form:
	//
	// `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. Ad group id of the simulation.
	AdGroupId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=ad_group_id,json=adGroupId,proto3" json:"ad_group_id,omitempty"`
	// Output only. The field that the simulation modifies.
	Type enums.SimulationTypeEnum_SimulationType `protobuf:"varint,3,opt,name=type,proto3,enum=google.ads.googleads.v3.enums.SimulationTypeEnum_SimulationType" json:"type,omitempty"`
	// Output only. How the simulation modifies the field.
	ModificationMethod enums.SimulationModificationMethodEnum_SimulationModificationMethod `protobuf:"varint,4,opt,name=modification_method,json=modificationMethod,proto3,enum=google.ads.googleads.v3.enums.SimulationModificationMethodEnum_SimulationModificationMethod" json:"modification_method,omitempty"`
	// Output only. First day on which the simulation is based, in YYYY-MM-DD format.
	StartDate *wrappers.StringValue `protobuf:"bytes,5,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Output only. Last day on which the simulation is based, in YYYY-MM-DD format
	EndDate *wrappers.StringValue `protobuf:"bytes,6,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// List of simulation points.
	//
	// Types that are valid to be assigned to PointList:
	//	*AdGroupSimulation_CpcBidPointList
	//	*AdGroupSimulation_CpvBidPointList
	//	*AdGroupSimulation_TargetCpaPointList
	PointList            isAdGroupSimulation_PointList `protobuf_oneof:"point_list"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AdGroupSimulation) Reset()         { *m = AdGroupSimulation{} }
func (m *AdGroupSimulation) String() string { return proto.CompactTextString(m) }
func (*AdGroupSimulation) ProtoMessage()    {}
func (*AdGroupSimulation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfe8b62d7d533dcc, []int{0}
}

func (m *AdGroupSimulation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupSimulation.Unmarshal(m, b)
}
func (m *AdGroupSimulation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupSimulation.Marshal(b, m, deterministic)
}
func (m *AdGroupSimulation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupSimulation.Merge(m, src)
}
func (m *AdGroupSimulation) XXX_Size() int {
	return xxx_messageInfo_AdGroupSimulation.Size(m)
}
func (m *AdGroupSimulation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupSimulation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupSimulation proto.InternalMessageInfo

func (m *AdGroupSimulation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupSimulation) GetAdGroupId() *wrappers.Int64Value {
	if m != nil {
		return m.AdGroupId
	}
	return nil
}

func (m *AdGroupSimulation) GetType() enums.SimulationTypeEnum_SimulationType {
	if m != nil {
		return m.Type
	}
	return enums.SimulationTypeEnum_UNSPECIFIED
}

func (m *AdGroupSimulation) GetModificationMethod() enums.SimulationModificationMethodEnum_SimulationModificationMethod {
	if m != nil {
		return m.ModificationMethod
	}
	return enums.SimulationModificationMethodEnum_UNSPECIFIED
}

func (m *AdGroupSimulation) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *AdGroupSimulation) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

type isAdGroupSimulation_PointList interface {
	isAdGroupSimulation_PointList()
}

type AdGroupSimulation_CpcBidPointList struct {
	CpcBidPointList *common.CpcBidSimulationPointList `protobuf:"bytes,8,opt,name=cpc_bid_point_list,json=cpcBidPointList,proto3,oneof"`
}

type AdGroupSimulation_CpvBidPointList struct {
	CpvBidPointList *common.CpvBidSimulationPointList `protobuf:"bytes,10,opt,name=cpv_bid_point_list,json=cpvBidPointList,proto3,oneof"`
}

type AdGroupSimulation_TargetCpaPointList struct {
	TargetCpaPointList *common.TargetCpaSimulationPointList `protobuf:"bytes,9,opt,name=target_cpa_point_list,json=targetCpaPointList,proto3,oneof"`
}

func (*AdGroupSimulation_CpcBidPointList) isAdGroupSimulation_PointList() {}

func (*AdGroupSimulation_CpvBidPointList) isAdGroupSimulation_PointList() {}

func (*AdGroupSimulation_TargetCpaPointList) isAdGroupSimulation_PointList() {}

func (m *AdGroupSimulation) GetPointList() isAdGroupSimulation_PointList {
	if m != nil {
		return m.PointList
	}
	return nil
}

func (m *AdGroupSimulation) GetCpcBidPointList() *common.CpcBidSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_CpcBidPointList); ok {
		return x.CpcBidPointList
	}
	return nil
}

func (m *AdGroupSimulation) GetCpvBidPointList() *common.CpvBidSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_CpvBidPointList); ok {
		return x.CpvBidPointList
	}
	return nil
}

func (m *AdGroupSimulation) GetTargetCpaPointList() *common.TargetCpaSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_TargetCpaPointList); ok {
		return x.TargetCpaPointList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupSimulation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupSimulation_CpcBidPointList)(nil),
		(*AdGroupSimulation_CpvBidPointList)(nil),
		(*AdGroupSimulation_TargetCpaPointList)(nil),
	}
}

func init() {
	proto.RegisterType((*AdGroupSimulation)(nil), "google.ads.googleads.v3.resources.AdGroupSimulation")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/ad_group_simulation.proto", fileDescriptor_bfe8b62d7d533dcc)
}

var fileDescriptor_bfe8b62d7d533dcc = []byte{
	// 661 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xdb, 0x6a, 0x13, 0x4f,
	0x18, 0xff, 0x27, 0xe9, 0xbf, 0x87, 0x69, 0x55, 0x5c, 0x51, 0x62, 0x2d, 0xda, 0x0a, 0x85, 0x22,
	0x32, 0x03, 0x8d, 0x08, 0x6e, 0x2b, 0x74, 0xb7, 0x4a, 0xad, 0x58, 0x29, 0x69, 0x89, 0x28, 0x81,
	0x65, 0xb2, 0x33, 0xdd, 0x0e, 0x66, 0x0e, 0xec, 0xcc, 0xae, 0x94, 0xd2, 0x2b, 0xdf, 0xc0, 0x47,
	0xf0, 0xd2, 0x47, 0xf1, 0x29, 0x7a, 0xdd, 0x4b, 0x2f, 0xbd, 0x92, 0xcc, 0x1e, 0x12, 0x93, 0xa6,
	0x8d, 0x77, 0xdf, 0xee, 0xf7, 0x3b, 0x7c, 0xdf, 0x6f, 0x67, 0x07, 0x6c, 0x44, 0x52, 0x46, 0x5d,
	0x8a, 0x30, 0xd1, 0x28, 0x2b, 0x7b, 0x55, 0xda, 0x40, 0x31, 0xd5, 0x32, 0x89, 0x43, 0xaa, 0x11,
	0x26, 0x41, 0x14, 0xcb, 0x44, 0x05, 0x9a, 0xf1, 0xa4, 0x8b, 0x0d, 0x93, 0x02, 0xaa, 0x58, 0x1a,
	0xe9, 0xac, 0x64, 0x0c, 0x88, 0x89, 0x86, 0x25, 0x19, 0xa6, 0x0d, 0x58, 0x92, 0x17, 0xd1, 0x38,
	0xfd, 0x50, 0x72, 0x2e, 0x05, 0x1a, 0xd6, 0x5c, 0xf4, 0xc7, 0x11, 0xa8, 0x48, 0xb8, 0x1e, 0xc0,
	0x07, 0x5c, 0x12, 0x76, 0xc4, 0xc2, 0xfc, 0x81, 0x9a, 0x63, 0x49, 0x72, 0x8d, 0xc6, 0xc4, 0x1a,
	0xe6, 0x44, 0xd1, 0x9c, 0xf4, 0xa8, 0x20, 0x29, 0x86, 0x8e, 0x18, 0xed, 0x92, 0xa0, 0x43, 0x8f,
	0x71, 0xca, 0x64, 0x9c, 0x03, 0xee, 0x0f, 0x00, 0x8a, 0x05, 0xf3, 0xd6, 0xc3, 0xbc, 0x65, 0x9f,
	0x3a, 0xc9, 0x11, 0xfa, 0x12, 0x63, 0xa5, 0x68, 0xac, 0xf3, 0xfe, 0xd2, 0x00, 0x15, 0x0b, 0x21,
	0x8d, 0x75, 0xcf, 0xbb, 0x8f, 0x7f, 0xcd, 0x80, 0xdb, 0x1e, 0xd9, 0xe9, 0x65, 0x7c, 0x50, 0x8e,
	0xe6, 0x7c, 0x00, 0x37, 0x0a, 0x97, 0x40, 0x60, 0x4e, 0xeb, 0x95, 0xe5, 0xca, 0xda, 0x9c, 0xbf,
	0x7e, 0xee, 0xd5, 0x7e, 0x7b, 0x4f, 0xc1, 0x93, 0x7e, 0xe0, 0x79, 0xa5, 0x98, 0x86, 0xa1, 0xe4,
	0x68, 0x44, 0xaa, 0xb9, 0x50, 0x08, 0xbd, 0xc7, 0x9c, 0x3a, 0x5b, 0x60, 0xbe, 0xfc, 0xa4, 0x8c,
	0xd4, 0xab, 0xcb, 0x95, 0xb5, 0xf9, 0xf5, 0x07, 0xb9, 0x0a, 0x2c, 0x56, 0x80, 0xbb, 0xc2, 0x3c,
	0x7f, 0xd6, 0xc2, 0xdd, 0x84, 0xfa, 0xb5, 0x73, 0xaf, 0xd6, 0x9c, 0xc3, 0x99, 0xee, 0x2e, 0x71,
	0x3e, 0x82, 0xa9, 0x5e, 0x70, 0xf5, 0xda, 0x72, 0x65, 0xed, 0xe6, 0xfa, 0x16, 0x1c, 0x77, 0x0c,
	0x6c, 0xdc, 0xb0, 0x3f, 0xc8, 0xe1, 0x89, 0xa2, 0xaf, 0x45, 0xc2, 0x87, 0x5e, 0x65, 0xfa, 0x56,
	0xd2, 0xf9, 0x56, 0x01, 0x77, 0x2e, 0xf9, 0xb0, 0xf5, 0x29, 0x6b, 0xd5, 0x9e, 0xd8, 0x6a, 0x6f,
	0x40, 0x63, 0xcf, 0x4a, 0x0c, 0x19, 0x8f, 0x02, 0xb2, 0x31, 0x1c, 0x3e, 0xd2, 0x70, 0xb6, 0x00,
	0xd0, 0x06, 0xc7, 0x26, 0x20, 0xd8, 0xd0, 0xfa, 0xff, 0x36, 0xb0, 0xa5, 0x91, 0xc0, 0x0e, 0x4c,
	0xcc, 0x44, 0x34, 0x98, 0x98, 0x25, 0xbd, 0xc2, 0x86, 0x3a, 0x9b, 0x60, 0x96, 0x0a, 0x92, 0xf1,
	0xa7, 0x27, 0xe5, 0xcf, 0x50, 0x41, 0x2c, 0x9b, 0x03, 0x27, 0x54, 0x61, 0xd0, 0x61, 0x24, 0x50,
	0x92, 0x09, 0x13, 0x74, 0x99, 0x36, 0xf5, 0x59, 0xab, 0xf3, 0x62, 0x6c, 0x24, 0xd9, 0x1f, 0x06,
	0xb7, 0x55, 0xe8, 0x33, 0xd2, 0x5f, 0x7c, 0xbf, 0xa7, 0xf0, 0x8e, 0x69, 0x63, 0x4d, 0xde, 0xfc,
	0xd7, 0xbc, 0x15, 0x5a, 0x44, 0xf9, 0x3e, 0xb3, 0x4b, 0x87, 0xed, 0xc0, 0xa4, 0x76, 0xe9, 0xb5,
	0x76, 0xe9, 0x5f, 0x76, 0x29, 0xb8, 0x6b, 0x70, 0x1c, 0x51, 0x13, 0x84, 0x0a, 0x0f, 0x3a, 0xce,
	0x59, 0xc7, 0xcd, 0xeb, 0x1c, 0x0f, 0x2d, 0x79, 0x5b, 0xe1, 0x2b, 0x4c, 0x1d, 0x53, 0x80, 0xca,
	0x96, 0x2b, 0x2e, 0xbc, 0xcf, 0xff, 0xf2, 0x1b, 0x39, 0x2f, 0xc3, 0x44, 0x1b, 0xc9, 0x69, 0xac,
	0xd1, 0x69, 0x51, 0x9e, 0x21, 0x3c, 0x8c, 0xd3, 0xe8, 0xf4, 0x92, 0x2b, 0xf3, 0xcc, 0x5f, 0x00,
	0xa0, 0xbf, 0x9c, 0xff, 0xb5, 0x0a, 0x56, 0x43, 0xc9, 0xe1, 0xb5, 0x57, 0xa8, 0x7f, 0x6f, 0x64,
	0x92, 0xfd, 0xde, 0x91, 0xd9, 0xaf, 0x7c, 0x7a, 0x9b, 0x93, 0x23, 0xd9, 0xc5, 0x22, 0x82, 0x32,
	0x8e, 0x50, 0x44, 0x85, 0x3d, 0x50, 0xa8, 0xbf, 0xcd, 0x15, 0x77, 0xfb, 0x46, 0x59, 0x7d, 0xaf,
	0xd6, 0x76, 0x3c, 0xef, 0x47, 0x75, 0x65, 0x27, 0x93, 0xf4, 0x88, 0x86, 0x59, 0xd9, 0xab, 0x5a,
	0x0d, 0xd8, 0x2c, 0x90, 0x3f, 0x0b, 0x4c, 0xdb, 0x23, 0xba, 0x5d, 0x62, 0xda, 0xad, 0x46, 0xbb,
	0xc4, 0x5c, 0x54, 0x57, 0xb3, 0x86, 0xeb, 0x7a, 0x44, 0xbb, 0x6e, 0x89, 0x72, 0xdd, 0x56, 0xc3,
	0x75, 0x4b, 0x5c, 0x67, 0xda, 0x0e, 0xdb, 0xf8, 0x13, 0x00, 0x00, 0xff, 0xff, 0xcc, 0x23, 0xd9,
	0xb4, 0x87, 0x06, 0x00, 0x00,
}
