// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/clouddebugger/v2/debugger.proto

package clouddebugger

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request to set a breakpoint
type SetBreakpointRequest struct {
	// ID of the debuggee where the breakpoint is to be set.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// Breakpoint specification to set.
	// The field `location` of the breakpoint must be set.
	Breakpoint *Breakpoint `protobuf:"bytes,2,opt,name=breakpoint" json:"breakpoint,omitempty"`
	// The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *SetBreakpointRequest) Reset()                    { *m = SetBreakpointRequest{} }
func (m *SetBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*SetBreakpointRequest) ProtoMessage()               {}
func (*SetBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *SetBreakpointRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *SetBreakpointRequest) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

func (m *SetBreakpointRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Response for setting a breakpoint.
type SetBreakpointResponse struct {
	// Breakpoint resource.
	// The field `id` is guaranteed to be set (in addition to the echoed fileds).
	Breakpoint *Breakpoint `protobuf:"bytes,1,opt,name=breakpoint" json:"breakpoint,omitempty"`
}

func (m *SetBreakpointResponse) Reset()                    { *m = SetBreakpointResponse{} }
func (m *SetBreakpointResponse) String() string            { return proto.CompactTextString(m) }
func (*SetBreakpointResponse) ProtoMessage()               {}
func (*SetBreakpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *SetBreakpointResponse) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

// Request to get breakpoint information.
type GetBreakpointRequest struct {
	// ID of the debuggee whose breakpoint to get.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// ID of the breakpoint to get.
	BreakpointId string `protobuf:"bytes,2,opt,name=breakpoint_id,json=breakpointId" json:"breakpoint_id,omitempty"`
	// The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *GetBreakpointRequest) Reset()                    { *m = GetBreakpointRequest{} }
func (m *GetBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*GetBreakpointRequest) ProtoMessage()               {}
func (*GetBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *GetBreakpointRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *GetBreakpointRequest) GetBreakpointId() string {
	if m != nil {
		return m.BreakpointId
	}
	return ""
}

func (m *GetBreakpointRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Response for getting breakpoint information.
type GetBreakpointResponse struct {
	// Complete breakpoint state.
	// The fields `id` and `location` are guaranteed to be set.
	Breakpoint *Breakpoint `protobuf:"bytes,1,opt,name=breakpoint" json:"breakpoint,omitempty"`
}

func (m *GetBreakpointResponse) Reset()                    { *m = GetBreakpointResponse{} }
func (m *GetBreakpointResponse) String() string            { return proto.CompactTextString(m) }
func (*GetBreakpointResponse) ProtoMessage()               {}
func (*GetBreakpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *GetBreakpointResponse) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

// Request to delete a breakpoint.
type DeleteBreakpointRequest struct {
	// ID of the debuggee whose breakpoint to delete.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// ID of the breakpoint to delete.
	BreakpointId string `protobuf:"bytes,2,opt,name=breakpoint_id,json=breakpointId" json:"breakpoint_id,omitempty"`
	// The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,3,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *DeleteBreakpointRequest) Reset()                    { *m = DeleteBreakpointRequest{} }
func (m *DeleteBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteBreakpointRequest) ProtoMessage()               {}
func (*DeleteBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *DeleteBreakpointRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *DeleteBreakpointRequest) GetBreakpointId() string {
	if m != nil {
		return m.BreakpointId
	}
	return ""
}

func (m *DeleteBreakpointRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Request to list breakpoints.
type ListBreakpointsRequest struct {
	// ID of the debuggee whose breakpoints to list.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// When set to `true`, the response includes the list of breakpoints set by
	// any user. Otherwise, it includes only breakpoints set by the caller.
	IncludeAllUsers bool `protobuf:"varint,2,opt,name=include_all_users,json=includeAllUsers" json:"include_all_users,omitempty"`
	// When set to `true`, the response includes active and inactive
	// breakpoints. Otherwise, it includes only active breakpoints.
	IncludeInactive bool `protobuf:"varint,3,opt,name=include_inactive,json=includeInactive" json:"include_inactive,omitempty"`
	// When set, the response includes only breakpoints with the specified action.
	Action *ListBreakpointsRequest_BreakpointActionValue `protobuf:"bytes,4,opt,name=action" json:"action,omitempty"`
	// This field is deprecated. The following fields are always stripped out of
	// the result: `stack_frames`, `evaluated_expressions` and `variable_table`.
	StripResults bool `protobuf:"varint,5,opt,name=strip_results,json=stripResults" json:"strip_results,omitempty"`
	// A wait token that, if specified, blocks the call until the breakpoints
	// list has changed, or a server selected timeout has expired.  The value
	// should be set from the last response. The error code
	// `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
	// should be called again with the same `wait_token`.
	WaitToken string `protobuf:"bytes,6,opt,name=wait_token,json=waitToken" json:"wait_token,omitempty"`
	// The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,8,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *ListBreakpointsRequest) Reset()                    { *m = ListBreakpointsRequest{} }
func (m *ListBreakpointsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListBreakpointsRequest) ProtoMessage()               {}
func (*ListBreakpointsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *ListBreakpointsRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *ListBreakpointsRequest) GetIncludeAllUsers() bool {
	if m != nil {
		return m.IncludeAllUsers
	}
	return false
}

func (m *ListBreakpointsRequest) GetIncludeInactive() bool {
	if m != nil {
		return m.IncludeInactive
	}
	return false
}

func (m *ListBreakpointsRequest) GetAction() *ListBreakpointsRequest_BreakpointActionValue {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *ListBreakpointsRequest) GetStripResults() bool {
	if m != nil {
		return m.StripResults
	}
	return false
}

func (m *ListBreakpointsRequest) GetWaitToken() string {
	if m != nil {
		return m.WaitToken
	}
	return ""
}

func (m *ListBreakpointsRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Wrapper message for `Breakpoint.Action`. Defines a filter on the action
// field of breakpoints.
type ListBreakpointsRequest_BreakpointActionValue struct {
	// Only breakpoints with the specified action will pass the filter.
	Value Breakpoint_Action `protobuf:"varint,1,opt,name=value,enum=google.devtools.clouddebugger.v2.Breakpoint_Action" json:"value,omitempty"`
}

func (m *ListBreakpointsRequest_BreakpointActionValue) Reset() {
	*m = ListBreakpointsRequest_BreakpointActionValue{}
}
func (m *ListBreakpointsRequest_BreakpointActionValue) String() string {
	return proto.CompactTextString(m)
}
func (*ListBreakpointsRequest_BreakpointActionValue) ProtoMessage() {}
func (*ListBreakpointsRequest_BreakpointActionValue) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{5, 0}
}

func (m *ListBreakpointsRequest_BreakpointActionValue) GetValue() Breakpoint_Action {
	if m != nil {
		return m.Value
	}
	return Breakpoint_CAPTURE
}

// Response for listing breakpoints.
type ListBreakpointsResponse struct {
	// List of breakpoints matching the request.
	// The fields `id` and `location` are guaranteed to be set on each breakpoint.
	// The fields: `stack_frames`, `evaluated_expressions` and `variable_table`
	// are cleared on each breakpoint regardless of its status.
	Breakpoints []*Breakpoint `protobuf:"bytes,1,rep,name=breakpoints" json:"breakpoints,omitempty"`
	// A wait token that can be used in the next call to `list` (REST) or
	// `ListBreakpoints` (RPC) to block until the list of breakpoints has changes.
	NextWaitToken string `protobuf:"bytes,2,opt,name=next_wait_token,json=nextWaitToken" json:"next_wait_token,omitempty"`
}

func (m *ListBreakpointsResponse) Reset()                    { *m = ListBreakpointsResponse{} }
func (m *ListBreakpointsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListBreakpointsResponse) ProtoMessage()               {}
func (*ListBreakpointsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *ListBreakpointsResponse) GetBreakpoints() []*Breakpoint {
	if m != nil {
		return m.Breakpoints
	}
	return nil
}

func (m *ListBreakpointsResponse) GetNextWaitToken() string {
	if m != nil {
		return m.NextWaitToken
	}
	return ""
}

// Request to list debuggees.
type ListDebuggeesRequest struct {
	// Project number of a Google Cloud project whose debuggees to list.
	Project string `protobuf:"bytes,2,opt,name=project" json:"project,omitempty"`
	// When set to `true`, the result includes all debuggees. Otherwise, the
	// result includes only debuggees that are active.
	IncludeInactive bool `protobuf:"varint,3,opt,name=include_inactive,json=includeInactive" json:"include_inactive,omitempty"`
	// The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *ListDebuggeesRequest) Reset()                    { *m = ListDebuggeesRequest{} }
func (m *ListDebuggeesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDebuggeesRequest) ProtoMessage()               {}
func (*ListDebuggeesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *ListDebuggeesRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListDebuggeesRequest) GetIncludeInactive() bool {
	if m != nil {
		return m.IncludeInactive
	}
	return false
}

func (m *ListDebuggeesRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Response for listing debuggees.
type ListDebuggeesResponse struct {
	// List of debuggees accessible to the calling user.
	// The fields `debuggee.id` and `description` are guaranteed to be set.
	// The `description` field is a human readable field provided by agents and
	// can be displayed to users.
	Debuggees []*Debuggee `protobuf:"bytes,1,rep,name=debuggees" json:"debuggees,omitempty"`
}

func (m *ListDebuggeesResponse) Reset()                    { *m = ListDebuggeesResponse{} }
func (m *ListDebuggeesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDebuggeesResponse) ProtoMessage()               {}
func (*ListDebuggeesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *ListDebuggeesResponse) GetDebuggees() []*Debuggee {
	if m != nil {
		return m.Debuggees
	}
	return nil
}

func init() {
	proto.RegisterType((*SetBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.SetBreakpointRequest")
	proto.RegisterType((*SetBreakpointResponse)(nil), "google.devtools.clouddebugger.v2.SetBreakpointResponse")
	proto.RegisterType((*GetBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.GetBreakpointRequest")
	proto.RegisterType((*GetBreakpointResponse)(nil), "google.devtools.clouddebugger.v2.GetBreakpointResponse")
	proto.RegisterType((*DeleteBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.DeleteBreakpointRequest")
	proto.RegisterType((*ListBreakpointsRequest)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsRequest")
	proto.RegisterType((*ListBreakpointsRequest_BreakpointActionValue)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue")
	proto.RegisterType((*ListBreakpointsResponse)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsResponse")
	proto.RegisterType((*ListDebuggeesRequest)(nil), "google.devtools.clouddebugger.v2.ListDebuggeesRequest")
	proto.RegisterType((*ListDebuggeesResponse)(nil), "google.devtools.clouddebugger.v2.ListDebuggeesResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Debugger2 service

type Debugger2Client interface {
	// Sets the breakpoint to the debuggee.
	SetBreakpoint(ctx context.Context, in *SetBreakpointRequest, opts ...grpc.CallOption) (*SetBreakpointResponse, error)
	// Gets breakpoint information.
	GetBreakpoint(ctx context.Context, in *GetBreakpointRequest, opts ...grpc.CallOption) (*GetBreakpointResponse, error)
	// Deletes the breakpoint from the debuggee.
	DeleteBreakpoint(ctx context.Context, in *DeleteBreakpointRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Lists all breakpoints for the debuggee.
	ListBreakpoints(ctx context.Context, in *ListBreakpointsRequest, opts ...grpc.CallOption) (*ListBreakpointsResponse, error)
	// Lists all the debuggees that the user has access to.
	ListDebuggees(ctx context.Context, in *ListDebuggeesRequest, opts ...grpc.CallOption) (*ListDebuggeesResponse, error)
}

type debugger2Client struct {
	cc *grpc.ClientConn
}

func NewDebugger2Client(cc *grpc.ClientConn) Debugger2Client {
	return &debugger2Client{cc}
}

func (c *debugger2Client) SetBreakpoint(ctx context.Context, in *SetBreakpointRequest, opts ...grpc.CallOption) (*SetBreakpointResponse, error) {
	out := new(SetBreakpointResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) GetBreakpoint(ctx context.Context, in *GetBreakpointRequest, opts ...grpc.CallOption) (*GetBreakpointResponse, error) {
	out := new(GetBreakpointResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) DeleteBreakpoint(ctx context.Context, in *DeleteBreakpointRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) ListBreakpoints(ctx context.Context, in *ListBreakpointsRequest, opts ...grpc.CallOption) (*ListBreakpointsResponse, error) {
	out := new(ListBreakpointsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) ListDebuggees(ctx context.Context, in *ListDebuggeesRequest, opts ...grpc.CallOption) (*ListDebuggeesResponse, error) {
	out := new(ListDebuggeesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/ListDebuggees", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Debugger2 service

type Debugger2Server interface {
	// Sets the breakpoint to the debuggee.
	SetBreakpoint(context.Context, *SetBreakpointRequest) (*SetBreakpointResponse, error)
	// Gets breakpoint information.
	GetBreakpoint(context.Context, *GetBreakpointRequest) (*GetBreakpointResponse, error)
	// Deletes the breakpoint from the debuggee.
	DeleteBreakpoint(context.Context, *DeleteBreakpointRequest) (*google_protobuf3.Empty, error)
	// Lists all breakpoints for the debuggee.
	ListBreakpoints(context.Context, *ListBreakpointsRequest) (*ListBreakpointsResponse, error)
	// Lists all the debuggees that the user has access to.
	ListDebuggees(context.Context, *ListDebuggeesRequest) (*ListDebuggeesResponse, error)
}

func RegisterDebugger2Server(s *grpc.Server, srv Debugger2Server) {
	s.RegisterService(&_Debugger2_serviceDesc, srv)
}

func _Debugger2_SetBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).SetBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).SetBreakpoint(ctx, req.(*SetBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_GetBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).GetBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).GetBreakpoint(ctx, req.(*GetBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_DeleteBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).DeleteBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).DeleteBreakpoint(ctx, req.(*DeleteBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_ListBreakpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBreakpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).ListBreakpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).ListBreakpoints(ctx, req.(*ListBreakpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_ListDebuggees_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDebuggeesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).ListDebuggees(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/ListDebuggees",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).ListDebuggees(ctx, req.(*ListDebuggeesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Debugger2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouddebugger.v2.Debugger2",
	HandlerType: (*Debugger2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetBreakpoint",
			Handler:    _Debugger2_SetBreakpoint_Handler,
		},
		{
			MethodName: "GetBreakpoint",
			Handler:    _Debugger2_GetBreakpoint_Handler,
		},
		{
			MethodName: "DeleteBreakpoint",
			Handler:    _Debugger2_DeleteBreakpoint_Handler,
		},
		{
			MethodName: "ListBreakpoints",
			Handler:    _Debugger2_ListBreakpoints_Handler,
		},
		{
			MethodName: "ListDebuggees",
			Handler:    _Debugger2_ListDebuggees_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouddebugger/v2/debugger.proto",
}

func init() { proto.RegisterFile("google/devtools/clouddebugger/v2/debugger.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 781 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xcb, 0x6e, 0xd3, 0x4c,
	0x18, 0xd5, 0xa4, 0x7f, 0x2f, 0xf9, 0xd2, 0xb4, 0xfd, 0x47, 0xbd, 0x58, 0xe1, 0x16, 0x99, 0x8b,
	0x4a, 0x41, 0x36, 0x72, 0x11, 0xb4, 0xb0, 0xa1, 0xa1, 0x28, 0x8d, 0x54, 0xaa, 0x2a, 0x40, 0x91,
	0xd8, 0x44, 0x4e, 0x3c, 0xb5, 0x4c, 0x5d, 0x8f, 0xf1, 0x8c, 0x03, 0xa8, 0xea, 0xa6, 0x48, 0xec,
	0x11, 0x2f, 0x00, 0x5b, 0x84, 0xc4, 0x13, 0x20, 0xb1, 0x43, 0x62, 0xcb, 0x2b, 0xf0, 0x20, 0xc8,
	0xf6, 0xb8, 0x71, 0x82, 0x21, 0x71, 0x2a, 0x75, 0xe7, 0x9c, 0xcc, 0x77, 0x7c, 0xce, 0x99, 0x6f,
	0xbe, 0x31, 0xa8, 0x26, 0xa5, 0xa6, 0x4d, 0x54, 0x83, 0xb4, 0x39, 0xa5, 0x36, 0x53, 0x5b, 0x36,
	0xf5, 0x0d, 0x83, 0x34, 0x7d, 0xd3, 0x24, 0x9e, 0xda, 0xd6, 0xd4, 0xf8, 0x59, 0x71, 0x3d, 0xca,
	0x29, 0x2e, 0x47, 0x05, 0x4a, 0x5c, 0xa0, 0x74, 0x15, 0x28, 0x6d, 0xad, 0x74, 0x56, 0x50, 0xea,
	0xae, 0xa5, 0xea, 0x8e, 0x43, 0xb9, 0xce, 0x2d, 0xea, 0xb0, 0xa8, 0xbe, 0x74, 0xad, 0xff, 0x0b,
	0x75, 0xae, 0x8b, 0xc5, 0x67, 0xc4, 0xe2, 0xf0, 0x57, 0xd3, 0xdf, 0x55, 0xc9, 0xbe, 0xcb, 0x5f,
	0x47, 0x7f, 0xca, 0x9f, 0x11, 0xcc, 0x3e, 0x22, 0xbc, 0xe2, 0x11, 0x7d, 0xcf, 0xa5, 0x96, 0xc3,
	0xeb, 0xe4, 0x85, 0x4f, 0x18, 0xc7, 0x17, 0xa0, 0x20, 0xf8, 0x48, 0xc3, 0x32, 0x24, 0x54, 0x46,
	0x8b, 0xf9, 0x3a, 0xc4, 0x50, 0xcd, 0xc0, 0x9b, 0x00, 0xcd, 0xe3, 0x2a, 0x29, 0x57, 0x46, 0x8b,
	0x05, 0xed, 0xba, 0xd2, 0xcf, 0x98, 0x92, 0x78, 0x53, 0xa2, 0x1e, 0x5f, 0x86, 0xa9, 0x96, 0x6d,
	0x11, 0x87, 0x37, 0xda, 0xc4, 0x63, 0x16, 0x75, 0xa4, 0xff, 0xc2, 0x37, 0x16, 0x23, 0x74, 0x27,
	0x02, 0x65, 0x02, 0x73, 0x3d, 0x6a, 0x99, 0x4b, 0x1d, 0x46, 0x7a, 0xd4, 0xa0, 0x93, 0xa9, 0x91,
	0xdf, 0x20, 0x98, 0xad, 0x0e, 0x95, 0xca, 0x45, 0x28, 0x76, 0x78, 0x82, 0x25, 0xb9, 0x70, 0xc9,
	0x64, 0x07, 0xac, 0x19, 0x19, 0xcc, 0x56, 0x4f, 0xc1, 0xec, 0x5b, 0x04, 0x0b, 0xeb, 0xc4, 0x26,
	0x9c, 0x9c, 0x9e, 0xdf, 0x91, 0x34, 0xbf, 0xdf, 0x47, 0x60, 0x7e, 0xd3, 0x62, 0x09, 0xc7, 0x6c,
	0x60, 0x1d, 0x4b, 0xf0, 0xbf, 0xe5, 0xb4, 0x6c, 0xdf, 0x20, 0x0d, 0xdd, 0xb6, 0x1b, 0x3e, 0x23,
	0x1e, 0x0b, 0xb5, 0x4c, 0xd4, 0xa7, 0xc5, 0x1f, 0x6b, 0xb6, 0xfd, 0x24, 0x80, 0xf1, 0x55, 0x98,
	0x89, 0xd7, 0x5a, 0x8e, 0xde, 0xe2, 0x56, 0x9b, 0x84, 0x82, 0x3a, 0x4b, 0x6b, 0x02, 0xc6, 0xbb,
	0x30, 0x16, 0x3c, 0x89, 0x1d, 0x2a, 0x68, 0x5b, 0xfd, 0x53, 0x4e, 0x77, 0x90, 0x08, 0x7f, 0x2d,
	0x24, 0xdc, 0xd1, 0x6d, 0x9f, 0xd4, 0x05, 0x7b, 0x10, 0x23, 0xe3, 0x9e, 0xe5, 0x36, 0x3c, 0xc2,
	0x7c, 0x9b, 0x33, 0x69, 0x34, 0xd4, 0x33, 0x19, 0x82, 0xf5, 0x08, 0xc3, 0xe7, 0x00, 0x5e, 0xea,
	0x16, 0x6f, 0x70, 0xba, 0x47, 0x1c, 0x69, 0x2c, 0xcc, 0x20, 0x1f, 0x20, 0x8f, 0x03, 0x20, 0x25,
	0xe5, 0x89, 0x94, 0x94, 0x4b, 0x4d, 0x98, 0x4b, 0xd5, 0x82, 0x6b, 0x30, 0xda, 0x0e, 0x1e, 0xc2,
	0x74, 0xa7, 0xb4, 0xe5, 0x2c, 0x0d, 0xa5, 0x44, 0x44, 0xf5, 0x88, 0x41, 0x7e, 0x87, 0x60, 0xe1,
	0x8f, 0x1c, 0x44, 0xf3, 0x6e, 0x41, 0xa1, 0xd3, 0x1c, 0x4c, 0x42, 0xe5, 0x91, 0xcc, 0xdd, 0x9b,
	0x24, 0xc0, 0x57, 0x60, 0xda, 0x21, 0xaf, 0x78, 0x23, 0x11, 0x4d, 0xd4, 0x83, 0xc5, 0x00, 0x7e,
	0x1a, 0xc7, 0x23, 0x1f, 0x21, 0x98, 0x0d, 0x34, 0xad, 0x8b, 0xa6, 0x39, 0xee, 0x2d, 0x09, 0xc6,
	0x5d, 0x8f, 0x3e, 0x27, 0x2d, 0x2e, 0x0a, 0xe3, 0x9f, 0x59, 0x1a, 0x65, 0xc0, 0x23, 0xad, 0xc3,
	0x5c, 0x8f, 0x06, 0x91, 0xca, 0x06, 0xe4, 0xe3, 0x6e, 0x8e, 0x33, 0x59, 0xea, 0x9f, 0x49, 0xcc,
	0x53, 0xef, 0x14, 0x6b, 0x5f, 0xc7, 0x21, 0x2f, 0x70, 0x4f, 0xc3, 0x3f, 0x10, 0x14, 0xbb, 0x26,
	0x26, 0xbe, 0xd5, 0x9f, 0x36, 0xed, 0x42, 0x28, 0xdd, 0xce, 0x5c, 0x17, 0x59, 0x93, 0x37, 0x8e,
	0x7e, 0xfe, 0x7a, 0x9f, 0xab, 0xc8, 0x37, 0x93, 0x17, 0xa1, 0x7a, 0x2c, 0x58, 0x3d, 0x48, 0x9c,
	0xec, 0x43, 0x35, 0xb1, 0xb5, 0x2a, 0x23, 0xfc, 0x4e, 0xf2, 0x92, 0x08, 0xcc, 0x54, 0xb3, 0x9a,
	0xa9, 0x0e, 0x69, 0xa6, 0xfa, 0x2f, 0x33, 0xf8, 0x5e, 0x66, 0x33, 0x07, 0x5d, 0x73, 0xf2, 0x10,
	0x7f, 0x41, 0x30, 0xd3, 0x3b, 0x76, 0xf1, 0xea, 0x20, 0x7b, 0x9e, 0x3a, 0xaa, 0x4b, 0xf3, 0x71,
	0x69, 0x7c, 0xcf, 0x2b, 0x0f, 0x82, 0x7b, 0x3e, 0x56, 0xbc, 0x74, 0x72, 0xc5, 0xdf, 0x10, 0x4c,
	0xf7, 0x9c, 0x6a, 0xbc, 0x32, 0xec, 0x40, 0x2c, 0xad, 0x0e, 0x51, 0x29, 0x36, 0x61, 0x25, 0xb4,
	0xa4, 0xe1, 0x1b, 0x59, 0x2d, 0xe1, 0x0f, 0x08, 0x8a, 0x5d, 0x07, 0x70, 0x90, 0x0e, 0x4a, 0x9b,
	0x1a, 0x83, 0x74, 0x50, 0xea, 0x49, 0x97, 0xcf, 0x87, 0xe2, 0x25, 0x3c, 0x9f, 0x2e, 0xbe, 0xf2,
	0x11, 0xc1, 0xa5, 0x16, 0xdd, 0xef, 0x4b, 0x5f, 0x29, 0xc6, 0xa7, 0x7c, 0x3b, 0xd8, 0xf0, 0x6d,
	0xf4, 0xec, 0xa1, 0x28, 0x31, 0xa9, 0xad, 0x3b, 0xa6, 0x42, 0x3d, 0x53, 0x35, 0x89, 0x13, 0xb6,
	0x83, 0xf8, 0x42, 0xd5, 0x5d, 0x8b, 0xfd, 0xfd, 0xa3, 0xf1, 0x6e, 0x17, 0xf0, 0x29, 0x27, 0x55,
	0x23, 0xbe, 0xfb, 0x01, 0x1c, 0xcf, 0x1a, 0x4f, 0xd9, 0xd1, 0x9a, 0x63, 0x21, 0xe9, 0xf2, 0xef,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x66, 0xf8, 0x5d, 0x68, 0xf9, 0x0a, 0x00, 0x00,
}
