// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/bigtable/internal/table_service_proto/bigtable_table_service_messages.proto
// DO NOT EDIT!

/*
Package google_bigtable_admin_table_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/cloud/bigtable/internal/table_service_proto/bigtable_table_service_messages.proto
	google.golang.org/cloud/bigtable/internal/table_service_proto/bigtable_table_service.proto

It has these top-level messages:
	CreateTableRequest
	ListTablesRequest
	ListTablesResponse
	GetTableRequest
	DeleteTableRequest
	RenameTableRequest
	CreateColumnFamilyRequest
	DeleteColumnFamilyRequest
*/
package google_bigtable_admin_table_v1

import proto "github.com/golang/protobuf/proto"
import google_bigtable_admin_table_v11 "google.golang.org/cloud/bigtable/internal/table_data_proto"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal

type CreateTableRequest struct {
	// The unique name of the cluster in which to create the new table.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name by which the new table should be referred to within the cluster,
	// e.g. "foobar" rather than "<cluster_name>/tables/foobar".
	TableId string `protobuf:"bytes,2,opt,name=table_id" json:"table_id,omitempty"`
	// The Table to create. The `name` field of the Table and all of its
	// ColumnFamilies must be left blank, and will be populated in the response.
	Table *google_bigtable_admin_table_v11.Table `protobuf:"bytes,3,opt,name=table" json:"table,omitempty"`
}

func (m *CreateTableRequest) Reset()         { *m = CreateTableRequest{} }
func (m *CreateTableRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTableRequest) ProtoMessage()    {}

func (m *CreateTableRequest) GetTable() *google_bigtable_admin_table_v11.Table {
	if m != nil {
		return m.Table
	}
	return nil
}

type ListTablesRequest struct {
	// The unique name of the cluster for which tables should be listed.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *ListTablesRequest) Reset()         { *m = ListTablesRequest{} }
func (m *ListTablesRequest) String() string { return proto.CompactTextString(m) }
func (*ListTablesRequest) ProtoMessage()    {}

type ListTablesResponse struct {
	// The tables present in the requested cluster.
	// At present, only the names of the tables are populated.
	Tables []*google_bigtable_admin_table_v11.Table `protobuf:"bytes,1,rep,name=tables" json:"tables,omitempty"`
}

func (m *ListTablesResponse) Reset()         { *m = ListTablesResponse{} }
func (m *ListTablesResponse) String() string { return proto.CompactTextString(m) }
func (*ListTablesResponse) ProtoMessage()    {}

func (m *ListTablesResponse) GetTables() []*google_bigtable_admin_table_v11.Table {
	if m != nil {
		return m.Tables
	}
	return nil
}

type GetTableRequest struct {
	// The unique name of the requested table.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetTableRequest) Reset()         { *m = GetTableRequest{} }
func (m *GetTableRequest) String() string { return proto.CompactTextString(m) }
func (*GetTableRequest) ProtoMessage()    {}

type DeleteTableRequest struct {
	// The unique name of the table to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteTableRequest) Reset()         { *m = DeleteTableRequest{} }
func (m *DeleteTableRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTableRequest) ProtoMessage()    {}

type RenameTableRequest struct {
	// The current unique name of the table.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The new name by which the table should be referred to within its containing
	// cluster, e.g. "foobar" rather than "<cluster_name>/tables/foobar".
	NewId string `protobuf:"bytes,2,opt,name=new_id" json:"new_id,omitempty"`
}

func (m *RenameTableRequest) Reset()         { *m = RenameTableRequest{} }
func (m *RenameTableRequest) String() string { return proto.CompactTextString(m) }
func (*RenameTableRequest) ProtoMessage()    {}

type CreateColumnFamilyRequest struct {
	// The unique name of the table in which to create the new column family.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name by which the new column family should be referred to within the
	// table, e.g. "foobar" rather than "<table_name>/columnFamilies/foobar".
	ColumnFamilyId string `protobuf:"bytes,2,opt,name=column_family_id" json:"column_family_id,omitempty"`
	// The column family to create. The `name` field must be left blank.
	ColumnFamily *google_bigtable_admin_table_v11.ColumnFamily `protobuf:"bytes,3,opt,name=column_family" json:"column_family,omitempty"`
}

func (m *CreateColumnFamilyRequest) Reset()         { *m = CreateColumnFamilyRequest{} }
func (m *CreateColumnFamilyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateColumnFamilyRequest) ProtoMessage()    {}

func (m *CreateColumnFamilyRequest) GetColumnFamily() *google_bigtable_admin_table_v11.ColumnFamily {
	if m != nil {
		return m.ColumnFamily
	}
	return nil
}

type DeleteColumnFamilyRequest struct {
	// The unique name of the column family to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteColumnFamilyRequest) Reset()         { *m = DeleteColumnFamilyRequest{} }
func (m *DeleteColumnFamilyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteColumnFamilyRequest) ProtoMessage()    {}

func init() {
}
