// Code generated by protoc-gen-ts_proto. DO NOT EDIT.
// versions:
//   protoc-gen-ts_proto  v2.7.5
//   protoc               v6.30.2
// source: rekor/v2/verifier.proto

/* eslint-disable */
import {
  PublicKeyDetails,
  publicKeyDetailsFromJSON,
  publicKeyDetailsToJSON,
  X509Certificate,
} from "../../sigstore_common";

/** PublicKey contains an encoded public key */
export interface PublicKey {
  /** DER-encoded public key */
  rawBytes: Buffer;
}

/** Either a public key or a X.509 cerificiate with an embedded public key */
export interface Verifier {
  verifier?:
    | //
    /** DER-encoded public key. Encoding method is specified by the key_details attribute */
    { $case: "publicKey"; publicKey: PublicKey }
    | //
    /** DER-encoded certificate */
    { $case: "x509Certificate"; x509Certificate: X509Certificate }
    | undefined;
  /** Key encoding and signature algorithm to use for this key */
  keyDetails: PublicKeyDetails;
}

/** A signature and an associated verifier */
export interface Signature {
  content: Buffer;
  verifier: Verifier | undefined;
}

export const PublicKey: MessageFns<PublicKey> = {
  fromJSON(object: any): PublicKey {
    return { rawBytes: isSet(object.rawBytes) ? Buffer.from(bytesFromBase64(object.rawBytes)) : Buffer.alloc(0) };
  },

  toJSON(message: PublicKey): unknown {
    const obj: any = {};
    if (message.rawBytes.length !== 0) {
      obj.rawBytes = base64FromBytes(message.rawBytes);
    }
    return obj;
  },
};

export const Verifier: MessageFns<Verifier> = {
  fromJSON(object: any): Verifier {
    return {
      verifier: isSet(object.publicKey)
        ? { $case: "publicKey", publicKey: PublicKey.fromJSON(object.publicKey) }
        : isSet(object.x509Certificate)
        ? { $case: "x509Certificate", x509Certificate: X509Certificate.fromJSON(object.x509Certificate) }
        : undefined,
      keyDetails: isSet(object.keyDetails) ? publicKeyDetailsFromJSON(object.keyDetails) : 0,
    };
  },

  toJSON(message: Verifier): unknown {
    const obj: any = {};
    if (message.verifier?.$case === "publicKey") {
      obj.publicKey = PublicKey.toJSON(message.verifier.publicKey);
    } else if (message.verifier?.$case === "x509Certificate") {
      obj.x509Certificate = X509Certificate.toJSON(message.verifier.x509Certificate);
    }
    if (message.keyDetails !== 0) {
      obj.keyDetails = publicKeyDetailsToJSON(message.keyDetails);
    }
    return obj;
  },
};

export const Signature: MessageFns<Signature> = {
  fromJSON(object: any): Signature {
    return {
      content: isSet(object.content) ? Buffer.from(bytesFromBase64(object.content)) : Buffer.alloc(0),
      verifier: isSet(object.verifier) ? Verifier.fromJSON(object.verifier) : undefined,
    };
  },

  toJSON(message: Signature): unknown {
    const obj: any = {};
    if (message.content.length !== 0) {
      obj.content = base64FromBytes(message.content);
    }
    if (message.verifier !== undefined) {
      obj.verifier = Verifier.toJSON(message.verifier);
    }
    return obj;
  },
};

function bytesFromBase64(b64: string): Uint8Array {
  return Uint8Array.from(globalThis.Buffer.from(b64, "base64"));
}

function base64FromBytes(arr: Uint8Array): string {
  return globalThis.Buffer.from(arr).toString("base64");
}

function isSet(value: any): boolean {
  return value !== null && value !== undefined;
}

interface MessageFns<T> {
  fromJSON(object: any): T;
  toJSON(message: T): unknown;
}
