/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// WriteRequestDeletes struct for WriteRequestDeletes
type WriteRequestDeletes struct {
	TupleKeys []TupleKeyWithoutCondition `json:"tuple_keys" yaml:"tuple_keys"`
	// On 'error', the API returns an error when deleting a tuple that does not exist. On 'ignore', deletes of non-existent tuples are treated as no-ops.
	OnMissing *string `json:"on_missing,omitempty" yaml:"on_missing,omitempty"`
}

// NewWriteRequestDeletes instantiates a new WriteRequestDeletes object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewWriteRequestDeletes(tupleKeys []TupleKeyWithoutCondition) *WriteRequestDeletes {
	this := WriteRequestDeletes{}
	this.TupleKeys = tupleKeys
	var onMissing = "error"
	this.OnMissing = &onMissing
	return &this
}

// NewWriteRequestDeletesWithDefaults instantiates a new WriteRequestDeletes object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewWriteRequestDeletesWithDefaults() *WriteRequestDeletes {
	this := WriteRequestDeletes{}
	var onMissing = "error"
	this.OnMissing = &onMissing
	return &this
}

// GetTupleKeys returns the TupleKeys field value
func (o *WriteRequestDeletes) GetTupleKeys() []TupleKeyWithoutCondition {
	if o == nil {
		var ret []TupleKeyWithoutCondition
		return ret
	}

	return o.TupleKeys
}

// GetTupleKeysOk returns a tuple with the TupleKeys field value
// and a boolean to check if the value has been set.
func (o *WriteRequestDeletes) GetTupleKeysOk() (*[]TupleKeyWithoutCondition, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TupleKeys, true
}

// SetTupleKeys sets field value
func (o *WriteRequestDeletes) SetTupleKeys(v []TupleKeyWithoutCondition) {
	o.TupleKeys = v
}

// GetOnMissing returns the OnMissing field value if set, zero value otherwise.
func (o *WriteRequestDeletes) GetOnMissing() string {
	if o == nil || o.OnMissing == nil {
		var ret string
		return ret
	}
	return *o.OnMissing
}

// GetOnMissingOk returns a tuple with the OnMissing field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *WriteRequestDeletes) GetOnMissingOk() (*string, bool) {
	if o == nil || o.OnMissing == nil {
		return nil, false
	}
	return o.OnMissing, true
}

// HasOnMissing returns a boolean if a field has been set.
func (o *WriteRequestDeletes) HasOnMissing() bool {
	if o != nil && o.OnMissing != nil {
		return true
	}

	return false
}

// SetOnMissing gets a reference to the given string and assigns it to the OnMissing field.
func (o *WriteRequestDeletes) SetOnMissing(v string) {
	o.OnMissing = &v
}

func (o WriteRequestDeletes) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["tuple_keys"] = o.TupleKeys
	if o.OnMissing != nil {
		toSerialize["on_missing"] = o.OnMissing
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableWriteRequestDeletes struct {
	value *WriteRequestDeletes
	isSet bool
}

func (v NullableWriteRequestDeletes) Get() *WriteRequestDeletes {
	return v.value
}

func (v *NullableWriteRequestDeletes) Set(val *WriteRequestDeletes) {
	v.value = val
	v.isSet = true
}

func (v NullableWriteRequestDeletes) IsSet() bool {
	return v.isSet
}

func (v *NullableWriteRequestDeletes) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableWriteRequestDeletes(val *WriteRequestDeletes) *NullableWriteRequestDeletes {
	return &NullableWriteRequestDeletes{value: val, isSet: true}
}

func (v NullableWriteRequestDeletes) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableWriteRequestDeletes) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
