package snappystream

var testDataMan = []byte(`
.TH XARGS 1L \" -*- nroff -*-
.SH NAME
xargs \- build and execute command lines from standard input
.SH SYNOPSIS
.B xargs
[\-0prtx] [\-e[eof-str]] [\-i[replace-str]] [\-l[max-lines]]
[\-n max-args] [\-s max-chars] [\-P max-procs] [\-\-null] [\-\-eof[=eof-str]]
[\-\-replace[=replace-str]] [\-\-max-lines[=max-lines]] [\-\-interactive]
[\-\-max-chars=max-chars] [\-\-verbose] [\-\-exit] [\-\-max-procs=max-procs]
[\-\-max-args=max-args] [\-\-no-run-if-empty] [\-\-version] [\-\-help]
[command [initial-arguments]]
.SH DESCRIPTION
This manual page
documents the GNU version of
.BR xargs .
.B xargs
reads arguments from the standard input, delimited by blanks (which can be
protected with double or single quotes or a backslash) or newlines,
and executes the
.I command
(default is /bin/echo) one or more times with any
.I initial-arguments
followed by arguments read from standard input.  Blank lines on the
standard input are ignored.
.P
.B xargs
exits with the following status:
.nf
0 if it succeeds
123 if any invocation of the command exited with status 1-125
124 if the command exited with status 255
125 if the command is killed by a signal
126 if the command cannot be run
127 if the command is not found
1 if some other error occurred.
.fi
.SS OPTIONS
.TP
.I "\-\-null, \-0"
Input filenames are terminated by a null character instead of by
whitespace, and the quotes and backslash are not special (every
character is taken literally).  Disables the end of file string, which
is treated like any other argument.  Useful when arguments might
contain white space, quote marks, or backslashes.  The GNU find
\-print0 option produces input suitable for this mode.
.TP
.I "\-\-eof[=eof-str], \-e[eof-str]"
Set the end of file string to \fIeof-str\fR.  If the end of file
string occurs as a line of input, the rest of the input is ignored.
If \fIeof-str\fR is omitted, there is no end of file string.  If this
option is not given, the end of file string defaults to "_".
.TP
.I "\-\-help"
Print a summary of the options to
.B xargs
and exit.
.TP
.I "\-\-replace[=replace-str], \-i[replace-str]"
Replace occurences of \fIreplace-str\fR in the initial arguments with
names read from standard input.
Also, unquoted blanks do not terminate arguments.
If \fIreplace-str\fR is omitted, it
defaults to "{}" (like for 'find \-exec').  Implies \fI\-x\fP and
\fI\-l 1\fP.
.TP
.I "\-\-max-lines[=max-lines], -l[max-lines]"
Use at most \fImax-lines\fR nonblank input lines per command line;
\fImax-lines\fR defaults to 1 if omitted.  Trailing blanks cause an
input line to be logically continued on the next input line.  Implies
\fI\-x\fR.
.TP
.I "\-\-max-args=max-args, \-n max-args"
Use at most \fImax-args\fR arguments per command line.  Fewer than
\fImax-args\fR arguments will be used if the size (see the \-s option)
is exceeded, unless the \-x option is given, in which case \fBxargs\fR
will exit.
.TP
.I "\-\-interactive, \-p"
Prompt the user about whether to run each command line and read a line
from the terminal.  Only run the command line if the response starts
with 'y' or 'Y'.  Implies \fI\-t\fR.
.TP
.I "\-\-no-run-if-empty, \-r"
If the standard input does not contain any nonblanks, do not run the
command.  Normally, the command is run once even if there is no input.
.TP
.I "\-\-max-chars=max-chars, \-s max-chars"
Use at most \fImax-chars\fR characters per command line, including the
command and initial arguments and the terminating nulls at the ends of
the argument strings.  The default is as large as possible, up to 20k
characters.
.TP
.I "\-\-verbose, \-t"
Print the command line on the standard error output before executing
it.
.TP
.I "\-\-version"
Print the version number of
.B xargs
and exit.
.TP
.I "\-\-exit, \-x"
Exit if the size (see the \fI\-s\fR option) is exceeded.
.TP
.I "\-\-max-procs=max-procs, \-P max-procs"
Run up to \fImax-procs\fR processes at a time; the default is 1.  If
\fImax-procs\fR is 0, \fBxargs\fR will run as many processes as
possible at a time.  Use the \fI\-n\fR option with \fI\-P\fR;
otherwise chances are that only one exec will be done.
.SH "SEE ALSO"
\fBfind\fP(1L), \fBlocate\fP(1L), \fBlocatedb\fP(5L), \fBupdatedb\fP(1)
\fBFinding Files\fP (on-line in Info, or printed)`)

// curl -s https://api.github.com/users/mreiferson/repos
var testDataJSON = []byte(`
[
  {
    "id": 19041094,
    "name": "2014-talks",
    "full_name": "mreiferson/2014-talks",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/2014-talks",
    "description": "This is the official repository for slides and talks from GopherCon 2014",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/2014-talks",
    "forks_url": "https://api.github.com/repos/mreiferson/2014-talks/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/2014-talks/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/2014-talks/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/2014-talks/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/2014-talks/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/2014-talks/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/2014-talks/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/2014-talks/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/2014-talks/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/2014-talks/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/2014-talks/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/2014-talks/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/2014-talks/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/2014-talks/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/2014-talks/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/2014-talks/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/2014-talks/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/2014-talks/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/2014-talks/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/2014-talks/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/2014-talks/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/2014-talks/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/2014-talks/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/2014-talks/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/2014-talks/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/2014-talks/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/2014-talks/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/2014-talks/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/2014-talks/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/2014-talks/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/2014-talks/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/2014-talks/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/2014-talks/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/2014-talks/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/2014-talks/releases{/id}",
    "created_at": "2014-04-22T18:28:59Z",
    "updated_at": "2014-04-26T03:10:39Z",
    "pushed_at": "2014-04-25T14:46:35Z",
    "git_url": "git://github.com/mreiferson/2014-talks.git",
    "ssh_url": "git@github.com:mreiferson/2014-talks.git",
    "clone_url": "https://github.com/mreiferson/2014-talks.git",
    "svn_url": "https://github.com/mreiferson/2014-talks",
    "homepage": null,
    "size": 3596,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": null,
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 3329246,
    "name": "asyncdynamo",
    "full_name": "mreiferson/asyncdynamo",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/asyncdynamo",
    "description": "async Amazon DynamoDB library for Tornado",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/asyncdynamo",
    "forks_url": "https://api.github.com/repos/mreiferson/asyncdynamo/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/asyncdynamo/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/asyncdynamo/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/asyncdynamo/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/asyncdynamo/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/asyncdynamo/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/asyncdynamo/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/asyncdynamo/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/asyncdynamo/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/asyncdynamo/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/asyncdynamo/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/asyncdynamo/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/asyncdynamo/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/asyncdynamo/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/asyncdynamo/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/asyncdynamo/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/asyncdynamo/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/asyncdynamo/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/asyncdynamo/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/asyncdynamo/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/asyncdynamo/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/asyncdynamo/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/asyncdynamo/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/asyncdynamo/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/asyncdynamo/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/asyncdynamo/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/asyncdynamo/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/asyncdynamo/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/asyncdynamo/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/asyncdynamo/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/asyncdynamo/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/asyncdynamo/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/asyncdynamo/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/asyncdynamo/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/asyncdynamo/releases{/id}",
    "created_at": "2012-02-01T21:32:54Z",
    "updated_at": "2014-04-03T21:58:44Z",
    "pushed_at": "2012-02-01T21:06:23Z",
    "git_url": "git://github.com/mreiferson/asyncdynamo.git",
    "ssh_url": "git@github.com:mreiferson/asyncdynamo.git",
    "clone_url": "https://github.com/mreiferson/asyncdynamo.git",
    "svn_url": "https://github.com/mreiferson/asyncdynamo",
    "homepage": "",
    "size": 73,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Python",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 2622445,
    "name": "asyncmongo",
    "full_name": "mreiferson/asyncmongo",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/asyncmongo",
    "description": "An asynchronous library for accessing mongo with tornado.ioloop",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/asyncmongo",
    "forks_url": "https://api.github.com/repos/mreiferson/asyncmongo/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/asyncmongo/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/asyncmongo/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/asyncmongo/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/asyncmongo/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/asyncmongo/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/asyncmongo/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/asyncmongo/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/asyncmongo/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/asyncmongo/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/asyncmongo/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/asyncmongo/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/asyncmongo/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/asyncmongo/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/asyncmongo/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/asyncmongo/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/asyncmongo/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/asyncmongo/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/asyncmongo/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/asyncmongo/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/asyncmongo/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/asyncmongo/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/asyncmongo/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/asyncmongo/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/asyncmongo/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/asyncmongo/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/asyncmongo/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/asyncmongo/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/asyncmongo/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/asyncmongo/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/asyncmongo/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/asyncmongo/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/asyncmongo/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/asyncmongo/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/asyncmongo/releases{/id}",
    "created_at": "2011-10-21T19:01:05Z",
    "updated_at": "2013-01-04T11:58:26Z",
    "pushed_at": "2011-10-21T19:02:46Z",
    "git_url": "git://github.com/mreiferson/asyncmongo.git",
    "ssh_url": "git@github.com:mreiferson/asyncmongo.git",
    "clone_url": "https://github.com/mreiferson/asyncmongo.git",
    "svn_url": "https://github.com/mreiferson/asyncmongo",
    "homepage": "http://github.com/bitly/asyncmongo",
    "size": 563,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Python",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 4554560,
    "name": "blog.perplexedlabs.com",
    "full_name": "mreiferson/blog.perplexedlabs.com",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/blog.perplexedlabs.com",
    "description": "archive of posts",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com",
    "forks_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/blog.perplexedlabs.com/releases{/id}",
    "created_at": "2012-06-05T01:38:40Z",
    "updated_at": "2014-04-27T23:44:56Z",
    "pushed_at": "2014-04-27T23:44:56Z",
    "git_url": "git://github.com/mreiferson/blog.perplexedlabs.com.git",
    "ssh_url": "git@github.com:mreiferson/blog.perplexedlabs.com.git",
    "clone_url": "https://github.com/mreiferson/blog.perplexedlabs.com.git",
    "svn_url": "https://github.com/mreiferson/blog.perplexedlabs.com",
    "homepage": "http://blog.perplexedlabs.com/",
    "size": 668,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": null,
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 2861903,
    "name": "btpath",
    "full_name": "mreiferson/btpath",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/btpath",
    "description": "A* implementation/test app (1997)",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/btpath",
    "forks_url": "https://api.github.com/repos/mreiferson/btpath/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/btpath/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/btpath/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/btpath/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/btpath/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/btpath/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/btpath/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/btpath/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/btpath/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/btpath/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/btpath/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/btpath/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/btpath/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/btpath/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/btpath/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/btpath/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/btpath/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/btpath/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/btpath/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/btpath/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/btpath/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/btpath/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/btpath/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/btpath/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/btpath/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/btpath/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/btpath/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/btpath/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/btpath/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/btpath/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/btpath/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/btpath/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/btpath/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/btpath/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/btpath/releases{/id}",
    "created_at": "2011-11-27T17:23:02Z",
    "updated_at": "2013-01-04T17:58:42Z",
    "pushed_at": "2011-11-29T01:36:49Z",
    "git_url": "git://github.com/mreiferson/btpath.git",
    "ssh_url": "git@github.com:mreiferson/btpath.git",
    "clone_url": "https://github.com/mreiferson/btpath.git",
    "svn_url": "https://github.com/mreiferson/btpath",
    "homepage": "",
    "size": 88,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "C++",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 15747148,
    "name": "chef-nsq",
    "full_name": "mreiferson/chef-nsq",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/chef-nsq",
    "description": "Chef Cookbook for NSQ",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/chef-nsq",
    "forks_url": "https://api.github.com/repos/mreiferson/chef-nsq/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/chef-nsq/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/chef-nsq/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/chef-nsq/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/chef-nsq/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/chef-nsq/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/chef-nsq/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/chef-nsq/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/chef-nsq/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/chef-nsq/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/chef-nsq/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/chef-nsq/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/chef-nsq/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/chef-nsq/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/chef-nsq/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/chef-nsq/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/chef-nsq/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/chef-nsq/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/chef-nsq/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/chef-nsq/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/chef-nsq/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/chef-nsq/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/chef-nsq/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/chef-nsq/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/chef-nsq/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/chef-nsq/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/chef-nsq/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/chef-nsq/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/chef-nsq/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/chef-nsq/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/chef-nsq/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/chef-nsq/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/chef-nsq/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/chef-nsq/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/chef-nsq/releases{/id}",
    "created_at": "2014-01-08T20:27:41Z",
    "updated_at": "2014-04-28T14:15:50Z",
    "pushed_at": "2014-04-28T04:31:58Z",
    "git_url": "git://github.com/mreiferson/chef-nsq.git",
    "ssh_url": "git@github.com:mreiferson/chef-nsq.git",
    "clone_url": "https://github.com/mreiferson/chef-nsq.git",
    "svn_url": "https://github.com/mreiferson/chef-nsq",
    "homepage": null,
    "size": 132,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "Ruby",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": false,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 5287337,
    "name": "dablooms",
    "full_name": "mreiferson/dablooms",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/dablooms",
    "description": "scaling, counting, bloom filter library",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/dablooms",
    "forks_url": "https://api.github.com/repos/mreiferson/dablooms/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/dablooms/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/dablooms/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/dablooms/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/dablooms/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/dablooms/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/dablooms/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/dablooms/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/dablooms/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/dablooms/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/dablooms/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/dablooms/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/dablooms/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/dablooms/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/dablooms/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/dablooms/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/dablooms/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/dablooms/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/dablooms/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/dablooms/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/dablooms/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/dablooms/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/dablooms/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/dablooms/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/dablooms/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/dablooms/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/dablooms/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/dablooms/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/dablooms/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/dablooms/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/dablooms/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/dablooms/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/dablooms/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/dablooms/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/dablooms/releases{/id}",
    "created_at": "2012-08-03T16:03:50Z",
    "updated_at": "2013-03-08T15:37:44Z",
    "pushed_at": "2013-03-08T15:37:44Z",
    "git_url": "git://github.com/mreiferson/dablooms.git",
    "ssh_url": "git@github.com:mreiferson/dablooms.git",
    "clone_url": "https://github.com/mreiferson/dablooms.git",
    "svn_url": "https://github.com/mreiferson/dablooms",
    "homepage": "",
    "size": 186,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "C",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 2861959,
    "name": "dod",
    "full_name": "mreiferson/dod",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/dod",
    "description": "Do or Die - an incomplete real-time strategy game inspired by Warcraft (1997)",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/dod",
    "forks_url": "https://api.github.com/repos/mreiferson/dod/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/dod/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/dod/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/dod/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/dod/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/dod/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/dod/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/dod/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/dod/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/dod/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/dod/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/dod/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/dod/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/dod/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/dod/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/dod/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/dod/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/dod/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/dod/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/dod/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/dod/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/dod/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/dod/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/dod/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/dod/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/dod/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/dod/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/dod/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/dod/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/dod/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/dod/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/dod/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/dod/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/dod/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/dod/releases{/id}",
    "created_at": "2011-11-27T17:33:19Z",
    "updated_at": "2014-05-13T00:56:53Z",
    "pushed_at": "2011-11-29T02:08:57Z",
    "git_url": "git://github.com/mreiferson/dod.git",
    "ssh_url": "git@github.com:mreiferson/dod.git",
    "clone_url": "https://github.com/mreiferson/dod.git",
    "svn_url": "https://github.com/mreiferson/dod",
    "homepage": "",
    "size": 2044,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "C++",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 4515792,
    "name": "doozer",
    "full_name": "mreiferson/doozer",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/doozer",
    "description": "Go client driver for doozerd, a consistent, distributed data store",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/doozer",
    "forks_url": "https://api.github.com/repos/mreiferson/doozer/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/doozer/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/doozer/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/doozer/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/doozer/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/doozer/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/doozer/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/doozer/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/doozer/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/doozer/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/doozer/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/doozer/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/doozer/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/doozer/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/doozer/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/doozer/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/doozer/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/doozer/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/doozer/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/doozer/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/doozer/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/doozer/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/doozer/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/doozer/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/doozer/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/doozer/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/doozer/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/doozer/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/doozer/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/doozer/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/doozer/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/doozer/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/doozer/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/doozer/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/doozer/releases{/id}",
    "created_at": "2012-06-01T03:41:14Z",
    "updated_at": "2013-03-16T15:23:56Z",
    "pushed_at": "2013-03-16T15:23:55Z",
    "git_url": "git://github.com/mreiferson/doozer.git",
    "ssh_url": "git@github.com:mreiferson/doozer.git",
    "clone_url": "https://github.com/mreiferson/doozer.git",
    "svn_url": "https://github.com/mreiferson/doozer",
    "homepage": "https://github.com/ha/doozerd",
    "size": 2584,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "Go",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 3391437,
    "name": "doozer-c",
    "full_name": "mreiferson/doozer-c",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/doozer-c",
    "description": "async C client library for doozerd",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/doozer-c",
    "forks_url": "https://api.github.com/repos/mreiferson/doozer-c/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/doozer-c/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/doozer-c/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/doozer-c/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/doozer-c/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/doozer-c/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/doozer-c/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/doozer-c/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/doozer-c/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/doozer-c/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/doozer-c/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/doozer-c/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/doozer-c/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/doozer-c/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/doozer-c/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/doozer-c/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/doozer-c/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/doozer-c/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/doozer-c/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/doozer-c/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/doozer-c/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/doozer-c/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/doozer-c/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/doozer-c/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/doozer-c/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/doozer-c/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/doozer-c/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/doozer-c/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/doozer-c/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/doozer-c/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/doozer-c/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/doozer-c/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/doozer-c/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/doozer-c/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/doozer-c/releases{/id}",
    "created_at": "2012-02-08T21:15:33Z",
    "updated_at": "2014-04-03T21:58:49Z",
    "pushed_at": "2012-11-21T16:46:25Z",
    "git_url": "git://github.com/mreiferson/doozer-c.git",
    "ssh_url": "git@github.com:mreiferson/doozer-c.git",
    "clone_url": "https://github.com/mreiferson/doozer-c.git",
    "svn_url": "https://github.com/mreiferson/doozer-c",
    "homepage": "",
    "size": 158,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "C",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 4515795,
    "name": "doozerd",
    "full_name": "mreiferson/doozerd",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/doozerd",
    "description": "A consistent distributed data store.",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/doozerd",
    "forks_url": "https://api.github.com/repos/mreiferson/doozerd/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/doozerd/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/doozerd/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/doozerd/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/doozerd/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/doozerd/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/doozerd/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/doozerd/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/doozerd/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/doozerd/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/doozerd/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/doozerd/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/doozerd/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/doozerd/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/doozerd/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/doozerd/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/doozerd/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/doozerd/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/doozerd/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/doozerd/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/doozerd/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/doozerd/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/doozerd/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/doozerd/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/doozerd/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/doozerd/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/doozerd/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/doozerd/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/doozerd/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/doozerd/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/doozerd/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/doozerd/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/doozerd/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/doozerd/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/doozerd/releases{/id}",
    "created_at": "2012-06-01T03:41:32Z",
    "updated_at": "2013-12-28T19:22:30Z",
    "pushed_at": "2013-12-28T19:22:30Z",
    "git_url": "git://github.com/mreiferson/doozerd.git",
    "ssh_url": "git@github.com:mreiferson/doozerd.git",
    "clone_url": "https://github.com/mreiferson/doozerd.git",
    "svn_url": "https://github.com/mreiferson/doozerd",
    "homepage": "",
    "size": 3135,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "Go",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 8172002,
    "name": "e",
    "full_name": "mreiferson/e",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/e",
    "description": "Library containing high-performance datastructures and utilities for C++",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/e",
    "forks_url": "https://api.github.com/repos/mreiferson/e/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/e/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/e/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/e/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/e/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/e/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/e/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/e/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/e/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/e/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/e/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/e/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/e/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/e/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/e/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/e/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/e/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/e/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/e/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/e/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/e/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/e/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/e/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/e/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/e/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/e/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/e/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/e/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/e/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/e/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/e/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/e/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/e/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/e/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/e/releases{/id}",
    "created_at": "2013-02-13T02:42:55Z",
    "updated_at": "2013-02-18T21:10:07Z",
    "pushed_at": "2013-02-13T02:45:16Z",
    "git_url": "git://github.com/mreiferson/e.git",
    "ssh_url": "git@github.com:mreiferson/e.git",
    "clone_url": "https://github.com/mreiferson/e.git",
    "svn_url": "https://github.com/mreiferson/e",
    "homepage": "",
    "size": 437,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "C++",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 2792604,
    "name": "encfs-macfusion2",
    "full_name": "mreiferson/encfs-macfusion2",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/encfs-macfusion2",
    "description": "enhanced version of encfs-macfusion2 plugin http://code.google.com/p/encfs-macfusion2/",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/encfs-macfusion2",
    "forks_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/encfs-macfusion2/releases{/id}",
    "created_at": "2011-11-17T01:58:01Z",
    "updated_at": "2013-10-22T06:29:03Z",
    "pushed_at": "2011-11-17T02:13:15Z",
    "git_url": "git://github.com/mreiferson/encfs-macfusion2.git",
    "ssh_url": "git@github.com:mreiferson/encfs-macfusion2.git",
    "clone_url": "https://github.com/mreiferson/encfs-macfusion2.git",
    "svn_url": "https://github.com/mreiferson/encfs-macfusion2",
    "homepage": "",
    "size": 195,
    "stargazers_count": 4,
    "watchers_count": 4,
    "language": "Objective-C",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 1,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 1,
    "open_issues": 0,
    "watchers": 4,
    "default_branch": "master"
  },
  {
    "id": 5263991,
    "name": "file2http",
    "full_name": "mreiferson/file2http",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/file2http",
    "description": "spray a line-oriented file at an HTTP endpoint",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/file2http",
    "forks_url": "https://api.github.com/repos/mreiferson/file2http/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/file2http/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/file2http/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/file2http/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/file2http/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/file2http/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/file2http/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/file2http/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/file2http/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/file2http/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/file2http/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/file2http/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/file2http/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/file2http/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/file2http/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/file2http/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/file2http/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/file2http/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/file2http/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/file2http/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/file2http/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/file2http/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/file2http/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/file2http/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/file2http/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/file2http/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/file2http/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/file2http/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/file2http/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/file2http/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/file2http/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/file2http/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/file2http/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/file2http/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/file2http/releases{/id}",
    "created_at": "2012-08-01T19:56:16Z",
    "updated_at": "2013-01-11T13:21:40Z",
    "pushed_at": "2012-12-21T15:44:32Z",
    "git_url": "git://github.com/mreiferson/file2http.git",
    "ssh_url": "git@github.com:mreiferson/file2http.git",
    "clone_url": "https://github.com/mreiferson/file2http.git",
    "svn_url": "https://github.com/mreiferson/file2http",
    "homepage": "",
    "size": 96,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Go",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 15291117,
    "name": "gablog",
    "full_name": "mreiferson/gablog",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/gablog",
    "description": "Gopher Academy Blog -- fork of go.blog",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/gablog",
    "forks_url": "https://api.github.com/repos/mreiferson/gablog/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/gablog/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/gablog/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/gablog/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/gablog/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/gablog/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/gablog/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/gablog/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/gablog/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/gablog/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/gablog/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/gablog/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/gablog/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/gablog/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/gablog/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/gablog/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/gablog/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/gablog/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/gablog/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/gablog/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/gablog/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/gablog/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/gablog/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/gablog/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/gablog/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/gablog/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/gablog/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/gablog/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/gablog/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/gablog/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/gablog/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/gablog/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/gablog/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/gablog/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/gablog/releases{/id}",
    "created_at": "2013-12-18T18:38:37Z",
    "updated_at": "2013-12-20T22:39:33Z",
    "pushed_at": "2013-12-20T22:21:52Z",
    "git_url": "git://github.com/mreiferson/gablog.git",
    "ssh_url": "git@github.com:mreiferson/gablog.git",
    "clone_url": "https://github.com/mreiferson/gablog.git",
    "svn_url": "https://github.com/mreiferson/gablog",
    "homepage": "http://blog.gopheracademy.com",
    "size": 7911,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "CSS",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 12223286,
    "name": "git-open-pull",
    "full_name": "mreiferson/git-open-pull",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/git-open-pull",
    "description": "convert a github issue into a pull request",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/git-open-pull",
    "forks_url": "https://api.github.com/repos/mreiferson/git-open-pull/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/git-open-pull/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/git-open-pull/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/git-open-pull/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/git-open-pull/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/git-open-pull/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/git-open-pull/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/git-open-pull/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/git-open-pull/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/git-open-pull/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/git-open-pull/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/git-open-pull/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/git-open-pull/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/git-open-pull/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/git-open-pull/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/git-open-pull/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/git-open-pull/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/git-open-pull/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/git-open-pull/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/git-open-pull/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/git-open-pull/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/git-open-pull/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/git-open-pull/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/git-open-pull/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/git-open-pull/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/git-open-pull/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/git-open-pull/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/git-open-pull/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/git-open-pull/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/git-open-pull/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/git-open-pull/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/git-open-pull/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/git-open-pull/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/git-open-pull/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/git-open-pull/releases{/id}",
    "created_at": "2013-08-19T17:45:47Z",
    "updated_at": "2014-03-03T19:50:11Z",
    "pushed_at": "2014-03-03T19:50:09Z",
    "git_url": "git://github.com/mreiferson/git-open-pull.git",
    "ssh_url": "git@github.com:mreiferson/git-open-pull.git",
    "clone_url": "https://github.com/mreiferson/git-open-pull.git",
    "svn_url": "https://github.com/mreiferson/git-open-pull",
    "homepage": "https://github.com/jehiah/git-open-pull",
    "size": 155,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "Shell",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 9547968,
    "name": "go-hostpool",
    "full_name": "mreiferson/go-hostpool",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-hostpool",
    "description": "Intelligently and flexibly pool among multiple hosts from your Go application",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/go-hostpool",
    "forks_url": "https://api.github.com/repos/mreiferson/go-hostpool/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-hostpool/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-hostpool/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-hostpool/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-hostpool/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-hostpool/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-hostpool/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-hostpool/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-hostpool/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-hostpool/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-hostpool/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-hostpool/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-hostpool/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-hostpool/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-hostpool/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-hostpool/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-hostpool/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-hostpool/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-hostpool/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-hostpool/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-hostpool/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-hostpool/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-hostpool/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-hostpool/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-hostpool/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-hostpool/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-hostpool/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-hostpool/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-hostpool/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-hostpool/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-hostpool/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-hostpool/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-hostpool/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-hostpool/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-hostpool/releases{/id}",
    "created_at": "2013-04-19T15:06:04Z",
    "updated_at": "2013-04-30T14:17:45Z",
    "pushed_at": "2013-04-30T14:17:44Z",
    "git_url": "git://github.com/mreiferson/go-hostpool.git",
    "ssh_url": "git@github.com:mreiferson/go-hostpool.git",
    "clone_url": "https://github.com/mreiferson/go-hostpool.git",
    "svn_url": "https://github.com/mreiferson/go-hostpool",
    "homepage": null,
    "size": 98,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "Go",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 3488675,
    "name": "go-httpclient",
    "full_name": "mreiferson/go-httpclient",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-httpclient",
    "description": "a Go HTTP client with timeouts",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/go-httpclient",
    "forks_url": "https://api.github.com/repos/mreiferson/go-httpclient/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-httpclient/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-httpclient/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-httpclient/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-httpclient/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-httpclient/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-httpclient/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-httpclient/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-httpclient/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-httpclient/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-httpclient/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-httpclient/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-httpclient/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-httpclient/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-httpclient/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-httpclient/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-httpclient/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-httpclient/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-httpclient/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-httpclient/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-httpclient/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-httpclient/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-httpclient/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-httpclient/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-httpclient/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-httpclient/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-httpclient/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-httpclient/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-httpclient/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-httpclient/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-httpclient/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-httpclient/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-httpclient/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-httpclient/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-httpclient/releases{/id}",
    "created_at": "2012-02-19T21:51:42Z",
    "updated_at": "2014-07-19T16:41:18Z",
    "pushed_at": "2014-04-25T16:53:03Z",
    "git_url": "git://github.com/mreiferson/go-httpclient.git",
    "ssh_url": "git@github.com:mreiferson/go-httpclient.git",
    "clone_url": "https://github.com/mreiferson/go-httpclient.git",
    "svn_url": "https://github.com/mreiferson/go-httpclient",
    "homepage": "",
    "size": 362,
    "stargazers_count": 167,
    "watchers_count": 167,
    "language": "Go",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": false,
    "forks_count": 21,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 21,
    "open_issues": 0,
    "watchers": 167,
    "default_branch": "master"
  },
  {
    "id": 3924124,
    "name": "go-install-as",
    "full_name": "mreiferson/go-install-as",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-install-as",
    "description": "a Go tool to install a package with a specific import path",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/go-install-as",
    "forks_url": "https://api.github.com/repos/mreiferson/go-install-as/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-install-as/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-install-as/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-install-as/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-install-as/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-install-as/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-install-as/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-install-as/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-install-as/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-install-as/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-install-as/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-install-as/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-install-as/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-install-as/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-install-as/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-install-as/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-install-as/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-install-as/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-install-as/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-install-as/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-install-as/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-install-as/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-install-as/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-install-as/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-install-as/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-install-as/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-install-as/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-install-as/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-install-as/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-install-as/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-install-as/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-install-as/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-install-as/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-install-as/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-install-as/releases{/id}",
    "created_at": "2012-04-04T00:17:37Z",
    "updated_at": "2014-06-29T20:11:46Z",
    "pushed_at": "2012-09-24T16:08:50Z",
    "git_url": "git://github.com/mreiferson/go-install-as.git",
    "ssh_url": "git@github.com:mreiferson/go-install-as.git",
    "clone_url": "https://github.com/mreiferson/go-install-as.git",
    "svn_url": "https://github.com/mreiferson/go-install-as",
    "homepage": "",
    "size": 107,
    "stargazers_count": 53,
    "watchers_count": 53,
    "language": "Shell",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": false,
    "forks_count": 2,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 2,
    "open_issues": 0,
    "watchers": 53,
    "default_branch": "master"
  },
  {
    "id": 4744067,
    "name": "go-notify",
    "full_name": "mreiferson/go-notify",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-notify",
    "description": "a Go package to observe notable events in a decoupled fashion",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/go-notify",
    "forks_url": "https://api.github.com/repos/mreiferson/go-notify/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-notify/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-notify/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-notify/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-notify/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-notify/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-notify/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-notify/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-notify/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-notify/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-notify/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-notify/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-notify/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-notify/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-notify/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-notify/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-notify/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-notify/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-notify/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-notify/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-notify/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-notify/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-notify/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-notify/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-notify/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-notify/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-notify/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-notify/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-notify/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-notify/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-notify/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-notify/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-notify/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-notify/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-notify/releases{/id}",
    "created_at": "2012-06-21T20:30:43Z",
    "updated_at": "2013-01-10T18:07:58Z",
    "pushed_at": "2012-06-21T20:30:22Z",
    "git_url": "git://github.com/mreiferson/go-notify.git",
    "ssh_url": "git@github.com:mreiferson/go-notify.git",
    "clone_url": "https://github.com/mreiferson/go-notify.git",
    "svn_url": "https://github.com/mreiferson/go-notify",
    "homepage": null,
    "size": 68,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Go",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 12449360,
    "name": "go-nsq",
    "full_name": "mreiferson/go-nsq",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-nsq",
    "description": "the official Go package for NSQ",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/go-nsq",
    "forks_url": "https://api.github.com/repos/mreiferson/go-nsq/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-nsq/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-nsq/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-nsq/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-nsq/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-nsq/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-nsq/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-nsq/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-nsq/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-nsq/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-nsq/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-nsq/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-nsq/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-nsq/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-nsq/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-nsq/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-nsq/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-nsq/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-nsq/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-nsq/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-nsq/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-nsq/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-nsq/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-nsq/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-nsq/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-nsq/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-nsq/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-nsq/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-nsq/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-nsq/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-nsq/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-nsq/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-nsq/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-nsq/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-nsq/releases{/id}",
    "created_at": "2013-08-29T02:07:54Z",
    "updated_at": "2014-06-29T13:56:36Z",
    "pushed_at": "2014-07-20T16:44:32Z",
    "git_url": "git://github.com/mreiferson/go-nsq.git",
    "ssh_url": "git@github.com:mreiferson/go-nsq.git",
    "clone_url": "https://github.com/mreiferson/go-nsq.git",
    "svn_url": "https://github.com/mreiferson/go-nsq",
    "homepage": "",
    "size": 1783,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "Go",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": false,
    "forks_count": 1,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 1,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 16654468,
    "name": "go-options",
    "full_name": "mreiferson/go-options",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-options",
    "description": "a Go package to structure and resolve options",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/go-options",
    "forks_url": "https://api.github.com/repos/mreiferson/go-options/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-options/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-options/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-options/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-options/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-options/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-options/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-options/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-options/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-options/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-options/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-options/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-options/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-options/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-options/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-options/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-options/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-options/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-options/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-options/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-options/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-options/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-options/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-options/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-options/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-options/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-options/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-options/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-options/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-options/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-options/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-options/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-options/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-options/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-options/releases{/id}",
    "created_at": "2014-02-08T22:19:33Z",
    "updated_at": "2014-02-16T00:39:59Z",
    "pushed_at": "2014-02-16T00:39:58Z",
    "git_url": "git://github.com/mreiferson/go-options.git",
    "ssh_url": "git@github.com:mreiferson/go-options.git",
    "clone_url": "https://github.com/mreiferson/go-options.git",
    "svn_url": "https://github.com/mreiferson/go-options",
    "homepage": null,
    "size": 128,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Go",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 3924909,
    "name": "go-simplejson",
    "full_name": "mreiferson/go-simplejson",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-simplejson",
    "description": "a Go package to interact with arbitrary JSON",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/go-simplejson",
    "forks_url": "https://api.github.com/repos/mreiferson/go-simplejson/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-simplejson/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-simplejson/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-simplejson/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-simplejson/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-simplejson/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-simplejson/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-simplejson/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-simplejson/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-simplejson/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-simplejson/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-simplejson/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-simplejson/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-simplejson/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-simplejson/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-simplejson/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-simplejson/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-simplejson/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-simplejson/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-simplejson/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-simplejson/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-simplejson/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-simplejson/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-simplejson/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-simplejson/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-simplejson/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-simplejson/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-simplejson/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-simplejson/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-simplejson/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-simplejson/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-simplejson/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-simplejson/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-simplejson/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-simplejson/releases{/id}",
    "created_at": "2012-04-04T02:36:33Z",
    "updated_at": "2014-06-25T01:24:01Z",
    "pushed_at": "2014-06-30T15:13:50Z",
    "git_url": "git://github.com/mreiferson/go-simplejson.git",
    "ssh_url": "git@github.com:mreiferson/go-simplejson.git",
    "clone_url": "https://github.com/mreiferson/go-simplejson.git",
    "svn_url": "https://github.com/mreiferson/go-simplejson",
    "homepage": "",
    "size": 210,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Go",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": false,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 8614089,
    "name": "go-simplelog",
    "full_name": "mreiferson/go-simplelog",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-simplelog",
    "description": "a simple logging package for Go (inspired by Tornado)",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/go-simplelog",
    "forks_url": "https://api.github.com/repos/mreiferson/go-simplelog/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-simplelog/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-simplelog/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-simplelog/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-simplelog/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-simplelog/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-simplelog/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-simplelog/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-simplelog/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-simplelog/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-simplelog/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-simplelog/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-simplelog/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-simplelog/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-simplelog/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-simplelog/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-simplelog/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-simplelog/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-simplelog/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-simplelog/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-simplelog/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-simplelog/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-simplelog/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-simplelog/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-simplelog/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-simplelog/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-simplelog/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-simplelog/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-simplelog/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-simplelog/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-simplelog/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-simplelog/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-simplelog/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-simplelog/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-simplelog/releases{/id}",
    "created_at": "2013-03-06T21:53:48Z",
    "updated_at": "2013-10-11T22:49:05Z",
    "pushed_at": "2013-03-31T23:20:11Z",
    "git_url": "git://github.com/mreiferson/go-simplelog.git",
    "ssh_url": "git@github.com:mreiferson/go-simplelog.git",
    "clone_url": "https://github.com/mreiferson/go-simplelog.git",
    "svn_url": "https://github.com/mreiferson/go-simplelog",
    "homepage": null,
    "size": 140,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Go",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": false,
    "forks_count": 1,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 1,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 12498288,
    "name": "go-snappystream",
    "full_name": "mreiferson/go-snappystream",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-snappystream",
    "description": "a Go package for framed snappy streams",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/go-snappystream",
    "forks_url": "https://api.github.com/repos/mreiferson/go-snappystream/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-snappystream/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-snappystream/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-snappystream/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-snappystream/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-snappystream/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-snappystream/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-snappystream/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-snappystream/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-snappystream/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-snappystream/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-snappystream/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-snappystream/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-snappystream/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-snappystream/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-snappystream/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-snappystream/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-snappystream/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-snappystream/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-snappystream/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-snappystream/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-snappystream/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-snappystream/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-snappystream/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-snappystream/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-snappystream/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-snappystream/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-snappystream/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-snappystream/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-snappystream/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-snappystream/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-snappystream/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-snappystream/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-snappystream/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-snappystream/releases{/id}",
    "created_at": "2013-08-31T00:41:11Z",
    "updated_at": "2014-07-20T07:52:45Z",
    "pushed_at": "2013-09-17T21:00:14Z",
    "git_url": "git://github.com/mreiferson/go-snappystream.git",
    "ssh_url": "git@github.com:mreiferson/go-snappystream.git",
    "clone_url": "https://github.com/mreiferson/go-snappystream.git",
    "svn_url": "https://github.com/mreiferson/go-snappystream",
    "homepage": null,
    "size": 184,
    "stargazers_count": 21,
    "watchers_count": 21,
    "language": "Go",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 1,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 1,
    "open_issues": 0,
    "watchers": 21,
    "default_branch": "master"
  },
  {
    "id": 5183238,
    "name": "go-stat",
    "full_name": "mreiferson/go-stat",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-stat",
    "description": "performant instrumentation/profiling for Go",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/go-stat",
    "forks_url": "https://api.github.com/repos/mreiferson/go-stat/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-stat/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-stat/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-stat/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-stat/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-stat/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-stat/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-stat/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-stat/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-stat/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-stat/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-stat/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-stat/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-stat/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-stat/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-stat/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-stat/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-stat/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-stat/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-stat/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-stat/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-stat/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-stat/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-stat/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-stat/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-stat/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-stat/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-stat/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-stat/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-stat/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-stat/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-stat/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-stat/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-stat/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-stat/releases{/id}",
    "created_at": "2012-07-25T19:03:42Z",
    "updated_at": "2014-01-10T04:39:14Z",
    "pushed_at": "2012-07-25T19:04:37Z",
    "git_url": "git://github.com/mreiferson/go-stat.git",
    "ssh_url": "git@github.com:mreiferson/go-stat.git",
    "clone_url": "https://github.com/mreiferson/go-stat.git",
    "svn_url": "https://github.com/mreiferson/go-stat",
    "homepage": null,
    "size": 96,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Go",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 8662365,
    "name": "go-ujson",
    "full_name": "mreiferson/go-ujson",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/go-ujson",
    "description": "a pure Go port of ultrajson",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/go-ujson",
    "forks_url": "https://api.github.com/repos/mreiferson/go-ujson/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/go-ujson/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/go-ujson/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/go-ujson/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/go-ujson/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/go-ujson/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/go-ujson/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/go-ujson/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/go-ujson/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/go-ujson/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/go-ujson/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/go-ujson/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/go-ujson/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/go-ujson/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/go-ujson/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/go-ujson/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/go-ujson/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/go-ujson/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/go-ujson/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/go-ujson/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/go-ujson/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/go-ujson/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/go-ujson/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/go-ujson/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/go-ujson/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/go-ujson/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/go-ujson/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/go-ujson/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/go-ujson/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/go-ujson/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/go-ujson/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/go-ujson/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/go-ujson/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/go-ujson/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/go-ujson/releases{/id}",
    "created_at": "2013-03-08T23:57:54Z",
    "updated_at": "2014-06-26T01:50:40Z",
    "pushed_at": "2013-11-10T19:49:16Z",
    "git_url": "git://github.com/mreiferson/go-ujson.git",
    "ssh_url": "git@github.com:mreiferson/go-ujson.git",
    "clone_url": "https://github.com/mreiferson/go-ujson.git",
    "svn_url": "https://github.com/mreiferson/go-ujson",
    "homepage": "",
    "size": 140,
    "stargazers_count": 31,
    "watchers_count": 31,
    "language": "Go",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 8,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 8,
    "open_issues": 0,
    "watchers": 31,
    "default_branch": "master"
  },
  {
    "id": 12815437,
    "name": "godep",
    "full_name": "mreiferson/godep",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/godep",
    "description": "dependency tool for go",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/godep",
    "forks_url": "https://api.github.com/repos/mreiferson/godep/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/godep/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/godep/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/godep/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/godep/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/godep/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/godep/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/godep/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/godep/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/godep/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/godep/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/godep/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/godep/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/godep/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/godep/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/godep/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/godep/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/godep/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/godep/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/godep/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/godep/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/godep/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/godep/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/godep/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/godep/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/godep/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/godep/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/godep/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/godep/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/godep/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/godep/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/godep/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/godep/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/godep/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/godep/releases{/id}",
    "created_at": "2013-09-13T17:36:10Z",
    "updated_at": "2014-03-21T02:53:20Z",
    "pushed_at": "2014-01-05T18:07:02Z",
    "git_url": "git://github.com/mreiferson/godep.git",
    "ssh_url": "git@github.com:mreiferson/godep.git",
    "clone_url": "https://github.com/mreiferson/godep.git",
    "svn_url": "https://github.com/mreiferson/godep",
    "homepage": "http://godoc.org/github.com/kr/godep",
    "size": 196,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "Go",
    "has_issues": false,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  },
  {
    "id": 2862096,
    "name": "hajiworld",
    "full_name": "mreiferson/hajiworld",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/hajiworld",
    "description": "super mario clone (1999)",
    "fork": false,
    "url": "https://api.github.com/repos/mreiferson/hajiworld",
    "forks_url": "https://api.github.com/repos/mreiferson/hajiworld/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/hajiworld/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/hajiworld/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/hajiworld/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/hajiworld/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/hajiworld/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/hajiworld/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/hajiworld/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/hajiworld/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/hajiworld/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/hajiworld/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/hajiworld/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/hajiworld/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/hajiworld/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/hajiworld/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/hajiworld/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/hajiworld/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/hajiworld/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/hajiworld/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/hajiworld/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/hajiworld/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/hajiworld/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/hajiworld/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/hajiworld/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/hajiworld/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/hajiworld/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/hajiworld/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/hajiworld/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/hajiworld/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/hajiworld/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/hajiworld/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/hajiworld/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/hajiworld/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/hajiworld/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/hajiworld/releases{/id}",
    "created_at": "2011-11-27T18:05:02Z",
    "updated_at": "2014-01-08T14:10:43Z",
    "pushed_at": "2011-11-29T02:49:49Z",
    "git_url": "git://github.com/mreiferson/hajiworld.git",
    "ssh_url": "git@github.com:mreiferson/hajiworld.git",
    "clone_url": "https://github.com/mreiferson/hajiworld.git",
    "svn_url": "https://github.com/mreiferson/hajiworld",
    "homepage": "",
    "size": 27872,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "C++",
    "has_issues": true,
    "has_downloads": true,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master"
  },
  {
    "id": 14853562,
    "name": "homebrew",
    "full_name": "mreiferson/homebrew",
    "owner": {
      "login": "mreiferson",
      "id": 187441,
      "avatar_url": "https://avatars.githubusercontent.com/u/187441?",
      "gravatar_id": "dd56a8e1de66aeedb987397511f830e7",
      "url": "https://api.github.com/users/mreiferson",
      "html_url": "https://github.com/mreiferson",
      "followers_url": "https://api.github.com/users/mreiferson/followers",
      "following_url": "https://api.github.com/users/mreiferson/following{/other_user}",
      "gists_url": "https://api.github.com/users/mreiferson/gists{/gist_id}",
      "starred_url": "https://api.github.com/users/mreiferson/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/mreiferson/subscriptions",
      "organizations_url": "https://api.github.com/users/mreiferson/orgs",
      "repos_url": "https://api.github.com/users/mreiferson/repos",
      "events_url": "https://api.github.com/users/mreiferson/events{/privacy}",
      "received_events_url": "https://api.github.com/users/mreiferson/received_events",
      "type": "User",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://github.com/mreiferson/homebrew",
    "description": "The missing package manager for OS X.",
    "fork": true,
    "url": "https://api.github.com/repos/mreiferson/homebrew",
    "forks_url": "https://api.github.com/repos/mreiferson/homebrew/forks",
    "keys_url": "https://api.github.com/repos/mreiferson/homebrew/keys{/key_id}",
    "collaborators_url": "https://api.github.com/repos/mreiferson/homebrew/collaborators{/collaborator}",
    "teams_url": "https://api.github.com/repos/mreiferson/homebrew/teams",
    "hooks_url": "https://api.github.com/repos/mreiferson/homebrew/hooks",
    "issue_events_url": "https://api.github.com/repos/mreiferson/homebrew/issues/events{/number}",
    "events_url": "https://api.github.com/repos/mreiferson/homebrew/events",
    "assignees_url": "https://api.github.com/repos/mreiferson/homebrew/assignees{/user}",
    "branches_url": "https://api.github.com/repos/mreiferson/homebrew/branches{/branch}",
    "tags_url": "https://api.github.com/repos/mreiferson/homebrew/tags",
    "blobs_url": "https://api.github.com/repos/mreiferson/homebrew/git/blobs{/sha}",
    "git_tags_url": "https://api.github.com/repos/mreiferson/homebrew/git/tags{/sha}",
    "git_refs_url": "https://api.github.com/repos/mreiferson/homebrew/git/refs{/sha}",
    "trees_url": "https://api.github.com/repos/mreiferson/homebrew/git/trees{/sha}",
    "statuses_url": "https://api.github.com/repos/mreiferson/homebrew/statuses/{sha}",
    "languages_url": "https://api.github.com/repos/mreiferson/homebrew/languages",
    "stargazers_url": "https://api.github.com/repos/mreiferson/homebrew/stargazers",
    "contributors_url": "https://api.github.com/repos/mreiferson/homebrew/contributors",
    "subscribers_url": "https://api.github.com/repos/mreiferson/homebrew/subscribers",
    "subscription_url": "https://api.github.com/repos/mreiferson/homebrew/subscription",
    "commits_url": "https://api.github.com/repos/mreiferson/homebrew/commits{/sha}",
    "git_commits_url": "https://api.github.com/repos/mreiferson/homebrew/git/commits{/sha}",
    "comments_url": "https://api.github.com/repos/mreiferson/homebrew/comments{/number}",
    "issue_comment_url": "https://api.github.com/repos/mreiferson/homebrew/issues/comments/{number}",
    "contents_url": "https://api.github.com/repos/mreiferson/homebrew/contents/{+path}",
    "compare_url": "https://api.github.com/repos/mreiferson/homebrew/compare/{base}...{head}",
    "merges_url": "https://api.github.com/repos/mreiferson/homebrew/merges",
    "archive_url": "https://api.github.com/repos/mreiferson/homebrew/{archive_format}{/ref}",
    "downloads_url": "https://api.github.com/repos/mreiferson/homebrew/downloads",
    "issues_url": "https://api.github.com/repos/mreiferson/homebrew/issues{/number}",
    "pulls_url": "https://api.github.com/repos/mreiferson/homebrew/pulls{/number}",
    "milestones_url": "https://api.github.com/repos/mreiferson/homebrew/milestones{/number}",
    "notifications_url": "https://api.github.com/repos/mreiferson/homebrew/notifications{?since,all,participating}",
    "labels_url": "https://api.github.com/repos/mreiferson/homebrew/labels{/name}",
    "releases_url": "https://api.github.com/repos/mreiferson/homebrew/releases{/id}",
    "created_at": "2013-12-02T05:20:40Z",
    "updated_at": "2014-02-17T17:19:19Z",
    "pushed_at": "2014-02-17T17:06:03Z",
    "git_url": "git://github.com/mreiferson/homebrew.git",
    "ssh_url": "git@github.com:mreiferson/homebrew.git",
    "clone_url": "https://github.com/mreiferson/homebrew.git",
    "svn_url": "https://github.com/mreiferson/homebrew",
    "homepage": "http://brew.sh",
    "size": 29725,
    "stargazers_count": 0,
    "watchers_count": 0,
    "language": "Ruby",
    "has_issues": false,
    "has_downloads": false,
    "has_wiki": true,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 0,
    "default_branch": "master"
  }
]
`)
