package plugin

import (
	"bytes"
	"io"
	"testing"
	"time"
)

func TestClient_App(t *testing.T) {
	client, _ := TestPluginRPCConn(t, map[string]Plugin{
		"test": new(testInterfacePlugin),
	})
	defer client.Close()

	raw, err := client.Dispense("test")
	if err != nil {
		t.Fatalf("err: %s", err)
	}

	impl, ok := raw.(testInterface)
	if !ok {
		t.Fatalf("bad: %#v", raw)
	}

	result := impl.Double(21)
	if result != 42 {
		t.Fatalf("bad: %#v", result)
	}
}

func TestClient_syncStreams(t *testing.T) {
	client, server := TestPluginRPCConn(t, map[string]Plugin{})

	// Create streams for the server that we can talk to
	stdout_r, stdout_w := io.Pipe()
	stderr_r, stderr_w := io.Pipe()
	server.Stdout = stdout_r
	server.Stderr = stderr_r

	// Start the data copying
	var stdout_out, stderr_out bytes.Buffer
	stdout := bytes.NewBufferString("stdouttest")
	stderr := bytes.NewBufferString("stderrtest")
	go client.SyncStreams(&stdout_out, &stderr_out)
	go io.Copy(stdout_w, stdout)
	go io.Copy(stderr_w, stderr)

	// Unfortunately I can't think of a better way to make sure all the
	// copies above go through so let's just exit.
	time.Sleep(100 * time.Millisecond)

	// Close everything, and lets test the result
	client.Close()
	stdout_w.Close()
	stderr_w.Close()

	if v := stdout_out.String(); v != "stdouttest" {
		t.Fatalf("bad: %s", v)
	}
	if v := stderr_out.String(); v != "stderrtest" {
		t.Fatalf("bad: %s", v)
	}
}
