package layers

import (
	"testing"

	"github.com/gopacket/gopacket"
)

var testParseLinkTypeLinuxSLL2 = []byte{
	// sll2
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x04, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	// ipv4
	0x45, 0x00, 0x00, 0x3c, 0xaf, 0x93, 0x40, 0x00, 0x40, 0x06, 0x8d, 0x26, 0x7f, 0x00, 0x00, 0x01,
	0x7f, 0x00, 0x00, 0x01,
	// tcp
	0xb8, 0x46, 0x04, 0xd2, 0x4e, 0x2a, 0x3f, 0xda, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x02, 0xff, 0xd7,
	0xfe, 0x30, 0x00, 0x00, 0x02, 0x04, 0xff, 0xd7, 0x04, 0x02, 0x08, 0x0a, 0xe4, 0x67, 0xf5, 0x17,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x07,
}

func TestParseLinkTypeLinuxSLL2(t *testing.T) {
	p := gopacket.NewPacket(testParseLinkTypeLinuxSLL2, LinkTypeLinuxSLL2, testDecodeOptions)
	if p.ErrorLayer() != nil {
		t.Error("Failed to decode packet:", p.ErrorLayer().Error())
	}
	checkLayers(p, []gopacket.LayerType{LayerTypeLinuxSLL2, LayerTypeIPv4, LayerTypeTCP}, t)
}
