Bokeh
=====

<table>
<tr>
  <td>Latest Release</td>
  <td><img src="https://badge.fury.io/gh/bokeh%2Fbokeh.svg" alt="latest release" /></td>
</tr>
<tr>
  <td>License</td>
  <td>
    <a href="https://github.com/bokeh/bokeh/blob/master/LICENSE.txt">
    <img src="https://img.shields.io/github/license/bokeh/bokeh.svg" alt="Bokeh license" />
    </a>
  </td>
</tr>
<tr>
  <td>Build Status</td>
  <td>
    <a href="https://travis-ci.org/bokeh/bokeh">
    <img src="https://travis-ci.org/bokeh/bokeh.svg?branch=master" alt="build status" />
    </a>
  </td>
</tr>
<tr>
  <td>Static Analyis</td>
  <td>
    <a href="https://bettercodehub.com/edge/badge/bokeh/bokeh?branch=master">
    <img src='https://bettercodehub.com/edge/badge/bokeh/bokeh?branch=master'>
    </a>
  </td>
</tr>
<tr>
  <td>Conda</td>
  <td>
    <a href="https://bokeh.pydata.org/en/latest/docs/installation.html">
    <img src="http://pubbadges.s3-website-us-east-1.amazonaws.com/pkgs-downloads-bokeh.png" alt="conda downloads" />
    </a>
  </td>
</tr>
<tr>
  <td>PyPI</td>
  <td>
    <img src="https://bokeh.pydata.org/pip-bokeh-badge.png" />
  </td>
</tr>
<tr>
  <td>Live Tutorial</td>
  <td>
    <a href="https://mybinder.org/v2/gh/bokeh/bokeh-notebooks/master?filepath=tutorial%2F00%20-%20Introduction%20and%20Setup.ipynb">
    <img src="https://mybinder.org/badge.svg" />
    </a>
  </td>
</tr>
<tr>
  <td>Gitter</td>
  <td>
    <a href="https://gitter.im/bokeh/bokeh?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge">
    <img src="https://badges.gitter.im/bokeh/bokeh.svg" />
    </a>
  </td>
</tr>
<tr>
  <td>Twitter</td>
  <td>
    <a href="https://twitter.com/BokehPlots">
    <img src="https://img.shields.io/twitter/follow/bokehplots.svg?style=social&label=Follow" />
    </a>
  </td>
</tr>
</table>

Bokeh, a Python interactive visualization library, enables beautiful and
meaningful visual presentation of data in modern web browsers. With Bokeh,
you can quickly and easily create interactive plots, dashboards, and data
applications.

Bokeh helps provide elegant, concise construction of novel graphics in the
style of D3.js, while also delivering **high-performance** interactivity over
very large or streaming datasets.

[Interactive gallery](https://bokeh.pydata.org/en/latest/docs/gallery.html)
---------------------------------------------------------------------------

<p>
<table cellspacing="20">
<tr>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/image.html">
  <img alt="image" src="https://bokeh.pydata.org/en/latest/_images/image_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/anscombe.html">
  <img alt="anscombe" src="https://bokeh.pydata.org/en/latest/_images/anscombe_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/stocks.html">
  <img alt="stocks" src="https://bokeh.pydata.org/en/latest/_images/stocks_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/lorenz.html">
  <img alt="lorenz" src="https://bokeh.pydata.org/en/latest/_images/lorenz_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/candlestick.html">
  <img alt="candlestick" src="https://bokeh.pydata.org/en/latest/_images/candlestick_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/color_scatter.html">
  <img alt="scatter" src="https://bokeh.pydata.org/en/latest/_images/scatter_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/iris_splom.html">
  <img alt="splom" src="https://bokeh.pydata.org/en/latest/_images/splom_t.png" />
  </a>
  </td>

</tr>
<tr>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/iris.html">
  <img alt="iris" src="https://bokeh.pydata.org/en/latest/_images/iris_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/histogram.html">
  <img alt="histogram" src="https://bokeh.pydata.org/en/latest/_images/histogram_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/periodic.html">
  <img alt="periodic" src="https://bokeh.pydata.org/en/latest/_images/periodic_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/texas.html">
  <img alt="choropleth" src="https://bokeh.pydata.org/en/latest/_images/choropleth_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/burtin.html">
  <img alt="burtin" src="https://bokeh.pydata.org/en/latest/_images/burtin_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/streamline.html">
  <img alt="streamline" src="https://bokeh.pydata.org/en/latest/_images/streamline_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/image_rgba.html">
  <img alt="image_rgba" src="https://bokeh.pydata.org/en/latest/_images/image_rgba_t.png" />
  </a>
  </td>

</tr>
<tr>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/brewer.html">
  <img alt="stacked" src="https://bokeh.pydata.org/en/latest/_images/stacked_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/quiver.html">
  <img alt="quiver" src="https://bokeh.pydata.org/en/latest/_images/quiver_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/elements.html">
  <img alt="elements" src="https://bokeh.pydata.org/en/latest/_images/elements_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/boxplot.html">
  <img alt="boxplot" src="https://bokeh.pydata.org/en/latest/_images/boxplot_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/categorical.html">
  <img alt="categorical" src="https://bokeh.pydata.org/en/latest/_images/categorical_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/unemployment.html">
  <img alt="unemployment" src="https://bokeh.pydata.org/en/latest/_images/unemployment_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/les_mis.html">
  <img alt="les_mis" src="https://bokeh.pydata.org/en/latest/_images/les_mis_t.png" />
  </a>
  </td>

</tr>
</table>
</p>

Installation
------------
We recommend using the [Anaconda Python distribution](https://www.anaconda.com/what-is-anaconda/) and conda to install Bokeh. Enter this command at a Bash or Windows command prompt:

```
conda install bokeh
```

This installs Bokeh and all needed dependencies.

To begin using Bokeh or to install using `pip`, follow the [Quickstart](https://bokeh.pydata.org/en/latest/docs/user_guide/quickstart.html) documentation.

Documentation
-------------
Visit the [Bokeh web page](https://bokeh.pydata.org/en/latest) for information and full documentation, or [launch the Bokeh tutorial](https://mybinder.org/v2/gh/bokeh/bokeh-notebooks/master?filepath=tutorial%2F00%20-%20Introduction%20and%20Setup.ipynb) in live Jupyter Notebooks

Contribute to Bokeh
-------------------
To contribute to Bokeh, please review the [Developer Guide](https://bokeh.pydata.org/en/latest/docs/dev_guide.html).

Follow us
---------
Follow us on Twitter [@bokehplots](https://twitter.com/BokehPlots) and on [YouTube](https://www.youtube.com/channel/UCK0rSk29mmg4UT4bIOvPYhw).
