package emoji

// Code generated by github.com/enescakir/emoji/internal/generator DO NOT EDIT.

// Source: https://unicode.org/Public/emoji/13.0/emoji-test.txt
// Create at: 2020-03-08T15:58:37+03:00

var (

	// GROUP: Smileys & Emotion
	// SUBGROUP: face-smiling
	GrinningFace                Emoji = "\U0001f600" // grinning face
	GrinningFaceWithBigEyes     Emoji = "\U0001f603" // grinning face with big eyes
	GrinningFaceWithSmilingEyes Emoji = "\U0001f604" // grinning face with smiling eyes
	BeamingFaceWithSmilingEyes  Emoji = "\U0001f601" // beaming face with smiling eyes
	GrinningSquintingFace       Emoji = "\U0001f606" // grinning squinting face
	GrinningFaceWithSweat       Emoji = "\U0001f605" // grinning face with sweat
	RollingOnTheFloorLaughing   Emoji = "\U0001f923" // rolling on the floor laughing
	FaceWithTearsOfJoy          Emoji = "\U0001f602" // face with tears of joy
	SlightlySmilingFace         Emoji = "\U0001f642" // slightly smiling face
	UpsideDownFace              Emoji = "\U0001f643" // upside-down face
	WinkingFace                 Emoji = "\U0001f609" // winking face
	SmilingFaceWithSmilingEyes  Emoji = "\U0001f60a" // smiling face with smiling eyes
	SmilingFaceWithHalo         Emoji = "\U0001f607" // smiling face with halo
	// SUBGROUP: face-affection
	SmilingFaceWithHearts      Emoji = "\U0001f970"   // smiling face with hearts
	SmilingFaceWithHeartEyes   Emoji = "\U0001f60d"   // smiling face with heart-eyes
	StarStruck                 Emoji = "\U0001f929"   // star-struck
	FaceBlowingAKiss           Emoji = "\U0001f618"   // face blowing a kiss
	KissingFace                Emoji = "\U0001f617"   // kissing face
	SmilingFace                Emoji = "\u263a\ufe0f" // smiling face
	KissingFaceWithClosedEyes  Emoji = "\U0001f61a"   // kissing face with closed eyes
	KissingFaceWithSmilingEyes Emoji = "\U0001f619"   // kissing face with smiling eyes
	SmilingFaceWithTear        Emoji = "\U0001f972"   // smiling face with tear
	// SUBGROUP: face-tongue
	FaceSavoringFood        Emoji = "\U0001f60b" // face savoring food
	FaceWithTongue          Emoji = "\U0001f61b" // face with tongue
	WinkingFaceWithTongue   Emoji = "\U0001f61c" // winking face with tongue
	ZanyFace                Emoji = "\U0001f92a" // zany face
	SquintingFaceWithTongue Emoji = "\U0001f61d" // squinting face with tongue
	MoneyMouthFace          Emoji = "\U0001f911" // money-mouth face
	// SUBGROUP: face-hand
	HuggingFace           Emoji = "\U0001f917" // hugging face
	FaceWithHandOverMouth Emoji = "\U0001f92d" // face with hand over mouth
	ShushingFace          Emoji = "\U0001f92b" // shushing face
	ThinkingFace          Emoji = "\U0001f914" // thinking face
	// SUBGROUP: face-neutral-skeptical
	ZipperMouthFace       Emoji = "\U0001f910" // zipper-mouth face
	FaceWithRaisedEyebrow Emoji = "\U0001f928" // face with raised eyebrow
	NeutralFace           Emoji = "\U0001f610" // neutral face
	ExpressionlessFace    Emoji = "\U0001f611" // expressionless face
	FaceWithoutMouth      Emoji = "\U0001f636" // face without mouth
	SmirkingFace          Emoji = "\U0001f60f" // smirking face
	UnamusedFace          Emoji = "\U0001f612" // unamused face
	FaceWithRollingEyes   Emoji = "\U0001f644" // face with rolling eyes
	GrimacingFace         Emoji = "\U0001f62c" // grimacing face
	LyingFace             Emoji = "\U0001f925" // lying face
	// SUBGROUP: face-sleepy
	RelievedFace Emoji = "\U0001f60c" // relieved face
	PensiveFace  Emoji = "\U0001f614" // pensive face
	SleepyFace   Emoji = "\U0001f62a" // sleepy face
	DroolingFace Emoji = "\U0001f924" // drooling face
	SleepingFace Emoji = "\U0001f634" // sleeping face
	// SUBGROUP: face-unwell
	FaceWithMedicalMask Emoji = "\U0001f637" // face with medical mask
	FaceWithThermometer Emoji = "\U0001f912" // face with thermometer
	FaceWithHeadBandage Emoji = "\U0001f915" // face with head-bandage
	NauseatedFace       Emoji = "\U0001f922" // nauseated face
	FaceVomiting        Emoji = "\U0001f92e" // face vomiting
	SneezingFace        Emoji = "\U0001f927" // sneezing face
	HotFace             Emoji = "\U0001f975" // hot face
	ColdFace            Emoji = "\U0001f976" // cold face
	WoozyFace           Emoji = "\U0001f974" // woozy face
	DizzyFace           Emoji = "\U0001f635" // dizzy face
	ExplodingHead       Emoji = "\U0001f92f" // exploding head
	// SUBGROUP: face-hat
	CowboyHatFace Emoji = "\U0001f920" // cowboy hat face
	PartyingFace  Emoji = "\U0001f973" // partying face
	DisguisedFace Emoji = "\U0001f978" // disguised face
	// SUBGROUP: face-glasses
	SmilingFaceWithSunglasses Emoji = "\U0001f60e" // smiling face with sunglasses
	NerdFace                  Emoji = "\U0001f913" // nerd face
	FaceWithMonocle           Emoji = "\U0001f9d0" // face with monocle
	// SUBGROUP: face-concerned
	ConfusedFace              Emoji = "\U0001f615"   // confused face
	WorriedFace               Emoji = "\U0001f61f"   // worried face
	SlightlyFrowningFace      Emoji = "\U0001f641"   // slightly frowning face
	FrowningFace              Emoji = "\u2639\ufe0f" // frowning face
	FaceWithOpenMouth         Emoji = "\U0001f62e"   // face with open mouth
	HushedFace                Emoji = "\U0001f62f"   // hushed face
	AstonishedFace            Emoji = "\U0001f632"   // astonished face
	FlushedFace               Emoji = "\U0001f633"   // flushed face
	PleadingFace              Emoji = "\U0001f97a"   // pleading face
	FrowningFaceWithOpenMouth Emoji = "\U0001f626"   // frowning face with open mouth
	AnguishedFace             Emoji = "\U0001f627"   // anguished face
	FearfulFace               Emoji = "\U0001f628"   // fearful face
	AnxiousFaceWithSweat      Emoji = "\U0001f630"   // anxious face with sweat
	SadButRelievedFace        Emoji = "\U0001f625"   // sad but relieved face
	CryingFace                Emoji = "\U0001f622"   // crying face
	LoudlyCryingFace          Emoji = "\U0001f62d"   // loudly crying face
	FaceScreamingInFear       Emoji = "\U0001f631"   // face screaming in fear
	ConfoundedFace            Emoji = "\U0001f616"   // confounded face
	PerseveringFace           Emoji = "\U0001f623"   // persevering face
	DisappointedFace          Emoji = "\U0001f61e"   // disappointed face
	DowncastFaceWithSweat     Emoji = "\U0001f613"   // downcast face with sweat
	WearyFace                 Emoji = "\U0001f629"   // weary face
	TiredFace                 Emoji = "\U0001f62b"   // tired face
	YawningFace               Emoji = "\U0001f971"   // yawning face
	// SUBGROUP: face-negative
	FaceWithSteamFromNose  Emoji = "\U0001f624"   // face with steam from nose
	PoutingFace            Emoji = "\U0001f621"   // pouting face
	AngryFace              Emoji = "\U0001f620"   // angry face
	FaceWithSymbolsOnMouth Emoji = "\U0001f92c"   // face with symbols on mouth
	SmilingFaceWithHorns   Emoji = "\U0001f608"   // smiling face with horns
	AngryFaceWithHorns     Emoji = "\U0001f47f"   // angry face with horns
	Skull                  Emoji = "\U0001f480"   // skull
	SkullAndCrossbones     Emoji = "\u2620\ufe0f" // skull and crossbones
	// SUBGROUP: face-costume
	PileOfPoo    Emoji = "\U0001f4a9" // pile of poo
	ClownFace    Emoji = "\U0001f921" // clown face
	Ogre         Emoji = "\U0001f479" // ogre
	Goblin       Emoji = "\U0001f47a" // goblin
	Ghost        Emoji = "\U0001f47b" // ghost
	Alien        Emoji = "\U0001f47d" // alien
	AlienMonster Emoji = "\U0001f47e" // alien monster
	Robot        Emoji = "\U0001f916" // robot
	// SUBGROUP: cat-face
	GrinningCat                Emoji = "\U0001f63a" // grinning cat
	GrinningCatWithSmilingEyes Emoji = "\U0001f638" // grinning cat with smiling eyes
	CatWithTearsOfJoy          Emoji = "\U0001f639" // cat with tears of joy
	SmilingCatWithHeartEyes    Emoji = "\U0001f63b" // smiling cat with heart-eyes
	CatWithWrySmile            Emoji = "\U0001f63c" // cat with wry smile
	KissingCat                 Emoji = "\U0001f63d" // kissing cat
	WearyCat                   Emoji = "\U0001f640" // weary cat
	CryingCat                  Emoji = "\U0001f63f" // crying cat
	PoutingCat                 Emoji = "\U0001f63e" // pouting cat
	// SUBGROUP: monkey-face
	SeeNoEvilMonkey   Emoji = "\U0001f648" // see-no-evil monkey
	HearNoEvilMonkey  Emoji = "\U0001f649" // hear-no-evil monkey
	SpeakNoEvilMonkey Emoji = "\U0001f64a" // speak-no-evil monkey
	// SUBGROUP: emotion
	KissMark          Emoji = "\U0001f48b"                             // kiss mark
	LoveLetter        Emoji = "\U0001f48c"                             // love letter
	HeartWithArrow    Emoji = "\U0001f498"                             // heart with arrow
	HeartWithRibbon   Emoji = "\U0001f49d"                             // heart with ribbon
	SparklingHeart    Emoji = "\U0001f496"                             // sparkling heart
	GrowingHeart      Emoji = "\U0001f497"                             // growing heart
	BeatingHeart      Emoji = "\U0001f493"                             // beating heart
	RevolvingHearts   Emoji = "\U0001f49e"                             // revolving hearts
	TwoHearts         Emoji = "\U0001f495"                             // two hearts
	HeartDecoration   Emoji = "\U0001f49f"                             // heart decoration
	HeartExclamation  Emoji = "\u2763\ufe0f"                           // heart exclamation
	BrokenHeart       Emoji = "\U0001f494"                             // broken heart
	RedHeart          Emoji = "\u2764\ufe0f"                           // red heart
	OrangeHeart       Emoji = "\U0001f9e1"                             // orange heart
	YellowHeart       Emoji = "\U0001f49b"                             // yellow heart
	GreenHeart        Emoji = "\U0001f49a"                             // green heart
	BlueHeart         Emoji = "\U0001f499"                             // blue heart
	PurpleHeart       Emoji = "\U0001f49c"                             // purple heart
	BrownHeart        Emoji = "\U0001f90e"                             // brown heart
	BlackHeart        Emoji = "\U0001f5a4"                             // black heart
	WhiteHeart        Emoji = "\U0001f90d"                             // white heart
	HundredPoints     Emoji = "\U0001f4af"                             // hundred points
	AngerSymbol       Emoji = "\U0001f4a2"                             // anger symbol
	Collision         Emoji = "\U0001f4a5"                             // collision
	Dizzy             Emoji = "\U0001f4ab"                             // dizzy
	SweatDroplets     Emoji = "\U0001f4a6"                             // sweat droplets
	DashingAway       Emoji = "\U0001f4a8"                             // dashing away
	Hole              Emoji = "\U0001f573\ufe0f"                       // hole
	Bomb              Emoji = "\U0001f4a3"                             // bomb
	SpeechBalloon     Emoji = "\U0001f4ac"                             // speech balloon
	EyeInSpeechBubble Emoji = "\U0001f441\ufe0f\u200d\U0001f5e8\ufe0f" // eye in speech bubble
	LeftSpeechBubble  Emoji = "\U0001f5e8\ufe0f"                       // left speech bubble
	RightAngerBubble  Emoji = "\U0001f5ef\ufe0f"                       // right anger bubble
	ThoughtBalloon    Emoji = "\U0001f4ad"                             // thought balloon
	Zzz               Emoji = "\U0001f4a4"                             // zzz

	// GROUP: People & Body
	// SUBGROUP: hand-fingers-open
	WavingHand             EmojiWithTone = newEmojiWithTone("\U0001f44b@")                           // waving hand
	RaisedBackOfHand       EmojiWithTone = newEmojiWithTone("\U0001f91a@")                           // raised back of hand
	HandWithFingersSplayed EmojiWithTone = newEmojiWithTone("\U0001f590@").withDefaultTone("\ufe0f") // hand with fingers splayed
	RaisedHand             EmojiWithTone = newEmojiWithTone("\u270b@")                               // raised hand
	VulcanSalute           EmojiWithTone = newEmojiWithTone("\U0001f596@")                           // vulcan salute
	// SUBGROUP: hand-fingers-partial
	OkHand         EmojiWithTone = newEmojiWithTone("\U0001f44c@")                       // OK hand
	PinchedFingers EmojiWithTone = newEmojiWithTone("\U0001f90c@")                       // pinched fingers
	PinchingHand   EmojiWithTone = newEmojiWithTone("\U0001f90f@")                       // pinching hand
	VictoryHand    EmojiWithTone = newEmojiWithTone("\u270c@").withDefaultTone("\ufe0f") // victory hand
	CrossedFingers EmojiWithTone = newEmojiWithTone("\U0001f91e@")                       // crossed fingers
	LoveYouGesture EmojiWithTone = newEmojiWithTone("\U0001f91f@")                       // love-you gesture
	SignOfTheHorns EmojiWithTone = newEmojiWithTone("\U0001f918@")                       // sign of the horns
	CallMeHand     EmojiWithTone = newEmojiWithTone("\U0001f919@")                       // call me hand
	// SUBGROUP: hand-single-finger
	BackhandIndexPointingLeft  EmojiWithTone = newEmojiWithTone("\U0001f448@")                       // backhand index pointing left
	BackhandIndexPointingRight EmojiWithTone = newEmojiWithTone("\U0001f449@")                       // backhand index pointing right
	BackhandIndexPointingUp    EmojiWithTone = newEmojiWithTone("\U0001f446@")                       // backhand index pointing up
	MiddleFinger               EmojiWithTone = newEmojiWithTone("\U0001f595@")                       // middle finger
	BackhandIndexPointingDown  EmojiWithTone = newEmojiWithTone("\U0001f447@")                       // backhand index pointing down
	IndexPointingUp            EmojiWithTone = newEmojiWithTone("\u261d@").withDefaultTone("\ufe0f") // index pointing up
	// SUBGROUP: hand-fingers-closed
	ThumbsUp        EmojiWithTone = newEmojiWithTone("\U0001f44d@") // thumbs up
	ThumbsDown      EmojiWithTone = newEmojiWithTone("\U0001f44e@") // thumbs down
	RaisedFist      EmojiWithTone = newEmojiWithTone("\u270a@")     // raised fist
	OncomingFist    EmojiWithTone = newEmojiWithTone("\U0001f44a@") // oncoming fist
	LeftFacingFist  EmojiWithTone = newEmojiWithTone("\U0001f91b@") // left-facing fist
	RightFacingFist EmojiWithTone = newEmojiWithTone("\U0001f91c@") // right-facing fist
	// SUBGROUP: hands
	ClappingHands   EmojiWithTone = newEmojiWithTone("\U0001f44f@") // clapping hands
	RaisingHands    EmojiWithTone = newEmojiWithTone("\U0001f64c@") // raising hands
	OpenHands       EmojiWithTone = newEmojiWithTone("\U0001f450@") // open hands
	PalmsUpTogether EmojiWithTone = newEmojiWithTone("\U0001f932@") // palms up together
	Handshake       Emoji         = "\U0001f91d"                    // handshake
	FoldedHands     EmojiWithTone = newEmojiWithTone("\U0001f64f@") // folded hands
	// SUBGROUP: hand-prop
	WritingHand EmojiWithTone = newEmojiWithTone("\u270d@").withDefaultTone("\ufe0f") // writing hand
	NailPolish  EmojiWithTone = newEmojiWithTone("\U0001f485@")                       // nail polish
	Selfie      EmojiWithTone = newEmojiWithTone("\U0001f933@")                       // selfie
	// SUBGROUP: body-parts
	FlexedBiceps      EmojiWithTone = newEmojiWithTone("\U0001f4aa@") // flexed biceps
	MechanicalArm     Emoji         = "\U0001f9be"                    // mechanical arm
	MechanicalLeg     Emoji         = "\U0001f9bf"                    // mechanical leg
	Leg               EmojiWithTone = newEmojiWithTone("\U0001f9b5@") // leg
	Foot              EmojiWithTone = newEmojiWithTone("\U0001f9b6@") // foot
	Ear               EmojiWithTone = newEmojiWithTone("\U0001f442@") // ear
	EarWithHearingAid EmojiWithTone = newEmojiWithTone("\U0001f9bb@") // ear with hearing aid
	Nose              EmojiWithTone = newEmojiWithTone("\U0001f443@") // nose
	Brain             Emoji         = "\U0001f9e0"                    // brain
	AnatomicalHeart   Emoji         = "\U0001fac0"                    // anatomical heart
	Lungs             Emoji         = "\U0001fac1"                    // lungs
	Tooth             Emoji         = "\U0001f9b7"                    // tooth
	Bone              Emoji         = "\U0001f9b4"                    // bone
	Eyes              Emoji         = "\U0001f440"                    // eyes
	Eye               Emoji         = "\U0001f441\ufe0f"              // eye
	Tongue            Emoji         = "\U0001f445"                    // tongue
	Mouth             Emoji         = "\U0001f444"                    // mouth
	// SUBGROUP: person
	Baby                EmojiWithTone = newEmojiWithTone("\U0001f476@")                   // baby
	Child               EmojiWithTone = newEmojiWithTone("\U0001f9d2@")                   // child
	Boy                 EmojiWithTone = newEmojiWithTone("\U0001f466@")                   // boy
	Girl                EmojiWithTone = newEmojiWithTone("\U0001f467@")                   // girl
	Person              EmojiWithTone = newEmojiWithTone("\U0001f9d1@")                   // person
	PersonWithBlondHair EmojiWithTone = newEmojiWithTone("\U0001f471@")                   // person: blond hair
	Man                 EmojiWithTone = newEmojiWithTone("\U0001f468@")                   // man
	ManWithBeard        EmojiWithTone = newEmojiWithTone("\U0001f9d4@")                   // man: beard
	ManWithRedHair      EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f9b0")   // man: red hair
	ManWithCurlyHair    EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f9b1")   // man: curly hair
	ManWithWhiteHair    EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f9b3")   // man: white hair
	ManBald             EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f9b2")   // man: bald
	Woman               EmojiWithTone = newEmojiWithTone("\U0001f469@")                   // woman
	WomanWithRedHair    EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f9b0")   // woman: red hair
	PersonWithRedHair   EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f9b0")   // person: red hair
	WomanWithCurlyHair  EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f9b1")   // woman: curly hair
	PersonWithCurlyHair EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f9b1")   // person: curly hair
	WomanWithWhiteHair  EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f9b3")   // woman: white hair
	PersonWithWhiteHair EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f9b3")   // person: white hair
	WomanBald           EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f9b2")   // woman: bald
	PersonBald          EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f9b2")   // person: bald
	WomanWithBlondHair  EmojiWithTone = newEmojiWithTone("\U0001f471@\u200d\u2640\ufe0f") // woman: blond hair
	ManWithBlondHair    EmojiWithTone = newEmojiWithTone("\U0001f471@\u200d\u2642\ufe0f") // man: blond hair
	OlderPerson         EmojiWithTone = newEmojiWithTone("\U0001f9d3@")                   // older person
	OldMan              EmojiWithTone = newEmojiWithTone("\U0001f474@")                   // old man
	OldWoman            EmojiWithTone = newEmojiWithTone("\U0001f475@")                   // old woman
	// SUBGROUP: person-gesture
	PersonFrowning    EmojiWithTone = newEmojiWithTone("\U0001f64d@")                   // person frowning
	ManFrowning       EmojiWithTone = newEmojiWithTone("\U0001f64d@\u200d\u2642\ufe0f") // man frowning
	WomanFrowning     EmojiWithTone = newEmojiWithTone("\U0001f64d@\u200d\u2640\ufe0f") // woman frowning
	PersonPouting     EmojiWithTone = newEmojiWithTone("\U0001f64e@")                   // person pouting
	ManPouting        EmojiWithTone = newEmojiWithTone("\U0001f64e@\u200d\u2642\ufe0f") // man pouting
	WomanPouting      EmojiWithTone = newEmojiWithTone("\U0001f64e@\u200d\u2640\ufe0f") // woman pouting
	PersonGesturingNo EmojiWithTone = newEmojiWithTone("\U0001f645@")                   // person gesturing NO
	ManGesturingNo    EmojiWithTone = newEmojiWithTone("\U0001f645@\u200d\u2642\ufe0f") // man gesturing NO
	WomanGesturingNo  EmojiWithTone = newEmojiWithTone("\U0001f645@\u200d\u2640\ufe0f") // woman gesturing NO
	PersonGesturingOk EmojiWithTone = newEmojiWithTone("\U0001f646@")                   // person gesturing OK
	ManGesturingOk    EmojiWithTone = newEmojiWithTone("\U0001f646@\u200d\u2642\ufe0f") // man gesturing OK
	WomanGesturingOk  EmojiWithTone = newEmojiWithTone("\U0001f646@\u200d\u2640\ufe0f") // woman gesturing OK
	PersonTippingHand EmojiWithTone = newEmojiWithTone("\U0001f481@")                   // person tipping hand
	ManTippingHand    EmojiWithTone = newEmojiWithTone("\U0001f481@\u200d\u2642\ufe0f") // man tipping hand
	WomanTippingHand  EmojiWithTone = newEmojiWithTone("\U0001f481@\u200d\u2640\ufe0f") // woman tipping hand
	PersonRaisingHand EmojiWithTone = newEmojiWithTone("\U0001f64b@")                   // person raising hand
	ManRaisingHand    EmojiWithTone = newEmojiWithTone("\U0001f64b@\u200d\u2642\ufe0f") // man raising hand
	WomanRaisingHand  EmojiWithTone = newEmojiWithTone("\U0001f64b@\u200d\u2640\ufe0f") // woman raising hand
	DeafPerson        EmojiWithTone = newEmojiWithTone("\U0001f9cf@")                   // deaf person
	DeafMan           EmojiWithTone = newEmojiWithTone("\U0001f9cf@\u200d\u2642\ufe0f") // deaf man
	DeafWoman         EmojiWithTone = newEmojiWithTone("\U0001f9cf@\u200d\u2640\ufe0f") // deaf woman
	PersonBowing      EmojiWithTone = newEmojiWithTone("\U0001f647@")                   // person bowing
	ManBowing         EmojiWithTone = newEmojiWithTone("\U0001f647@\u200d\u2642\ufe0f") // man bowing
	WomanBowing       EmojiWithTone = newEmojiWithTone("\U0001f647@\u200d\u2640\ufe0f") // woman bowing
	PersonFacepalming EmojiWithTone = newEmojiWithTone("\U0001f926@")                   // person facepalming
	ManFacepalming    EmojiWithTone = newEmojiWithTone("\U0001f926@\u200d\u2642\ufe0f") // man facepalming
	WomanFacepalming  EmojiWithTone = newEmojiWithTone("\U0001f926@\u200d\u2640\ufe0f") // woman facepalming
	PersonShrugging   EmojiWithTone = newEmojiWithTone("\U0001f937@")                   // person shrugging
	ManShrugging      EmojiWithTone = newEmojiWithTone("\U0001f937@\u200d\u2642\ufe0f") // man shrugging
	WomanShrugging    EmojiWithTone = newEmojiWithTone("\U0001f937@\u200d\u2640\ufe0f") // woman shrugging
	// SUBGROUP: person-role
	HealthWorker            EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\u2695\ufe0f")                           // health worker
	ManHealthWorker         EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\u2695\ufe0f")                           // man health worker
	WomanHealthWorker       EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\u2695\ufe0f")                           // woman health worker
	Student                 EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f393")                             // student
	ManStudent              EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f393")                             // man student
	WomanStudent            EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f393")                             // woman student
	Teacher                 EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f3eb")                             // teacher
	ManTeacher              EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f3eb")                             // man teacher
	WomanTeacher            EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f3eb")                             // woman teacher
	Judge                   EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\u2696\ufe0f")                           // judge
	ManJudge                EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\u2696\ufe0f")                           // man judge
	WomanJudge              EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\u2696\ufe0f")                           // woman judge
	Farmer                  EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f33e")                             // farmer
	ManFarmer               EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f33e")                             // man farmer
	WomanFarmer             EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f33e")                             // woman farmer
	Cook                    EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f373")                             // cook
	ManCook                 EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f373")                             // man cook
	WomanCook               EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f373")                             // woman cook
	Mechanic                EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f527")                             // mechanic
	ManMechanic             EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f527")                             // man mechanic
	WomanMechanic           EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f527")                             // woman mechanic
	FactoryWorker           EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f3ed")                             // factory worker
	ManFactoryWorker        EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f3ed")                             // man factory worker
	WomanFactoryWorker      EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f3ed")                             // woman factory worker
	OfficeWorker            EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f4bc")                             // office worker
	ManOfficeWorker         EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f4bc")                             // man office worker
	WomanOfficeWorker       EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f4bc")                             // woman office worker
	Scientist               EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f52c")                             // scientist
	ManScientist            EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f52c")                             // man scientist
	WomanScientist          EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f52c")                             // woman scientist
	Technologist            EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f4bb")                             // technologist
	ManTechnologist         EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f4bb")                             // man technologist
	WomanTechnologist       EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f4bb")                             // woman technologist
	Singer                  EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f3a4")                             // singer
	ManSinger               EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f3a4")                             // man singer
	WomanSinger             EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f3a4")                             // woman singer
	Artist                  EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f3a8")                             // artist
	ManArtist               EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f3a8")                             // man artist
	WomanArtist             EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f3a8")                             // woman artist
	Pilot                   EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\u2708\ufe0f")                           // pilot
	ManPilot                EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\u2708\ufe0f")                           // man pilot
	WomanPilot              EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\u2708\ufe0f")                           // woman pilot
	Astronaut               EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f680")                             // astronaut
	ManAstronaut            EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f680")                             // man astronaut
	WomanAstronaut          EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f680")                             // woman astronaut
	Firefighter             EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f692")                             // firefighter
	ManFirefighter          EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f692")                             // man firefighter
	WomanFirefighter        EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f692")                             // woman firefighter
	PoliceOfficer           EmojiWithTone = newEmojiWithTone("\U0001f46e@")                                             // police officer
	ManPoliceOfficer        EmojiWithTone = newEmojiWithTone("\U0001f46e@\u200d\u2642\ufe0f")                           // man police officer
	WomanPoliceOfficer      EmojiWithTone = newEmojiWithTone("\U0001f46e@\u200d\u2640\ufe0f")                           // woman police officer
	Detective               EmojiWithTone = newEmojiWithTone("\U0001f575@").withDefaultTone("\ufe0f")                   // detective
	ManDetective            EmojiWithTone = newEmojiWithTone("\U0001f575@\u200d\u2642\ufe0f").withDefaultTone("\ufe0f") // man detective
	WomanDetective          EmojiWithTone = newEmojiWithTone("\U0001f575@\u200d\u2640\ufe0f").withDefaultTone("\ufe0f") // woman detective
	Guard                   EmojiWithTone = newEmojiWithTone("\U0001f482@")                                             // guard
	ManGuard                EmojiWithTone = newEmojiWithTone("\U0001f482@\u200d\u2642\ufe0f")                           // man guard
	WomanGuard              EmojiWithTone = newEmojiWithTone("\U0001f482@\u200d\u2640\ufe0f")                           // woman guard
	Ninja                   EmojiWithTone = newEmojiWithTone("\U0001f977@")                                             // ninja
	ConstructionWorker      EmojiWithTone = newEmojiWithTone("\U0001f477@")                                             // construction worker
	ManConstructionWorker   EmojiWithTone = newEmojiWithTone("\U0001f477@\u200d\u2642\ufe0f")                           // man construction worker
	WomanConstructionWorker EmojiWithTone = newEmojiWithTone("\U0001f477@\u200d\u2640\ufe0f")                           // woman construction worker
	Prince                  EmojiWithTone = newEmojiWithTone("\U0001f934@")                                             // prince
	Princess                EmojiWithTone = newEmojiWithTone("\U0001f478@")                                             // princess
	PersonWearingTurban     EmojiWithTone = newEmojiWithTone("\U0001f473@")                                             // person wearing turban
	ManWearingTurban        EmojiWithTone = newEmojiWithTone("\U0001f473@\u200d\u2642\ufe0f")                           // man wearing turban
	WomanWearingTurban      EmojiWithTone = newEmojiWithTone("\U0001f473@\u200d\u2640\ufe0f")                           // woman wearing turban
	PersonWithSkullcap      EmojiWithTone = newEmojiWithTone("\U0001f472@")                                             // person with skullcap
	WomanWithHeadscarf      EmojiWithTone = newEmojiWithTone("\U0001f9d5@")                                             // woman with headscarf
	PersonInTuxedo          EmojiWithTone = newEmojiWithTone("\U0001f935@")                                             // person in tuxedo
	ManInTuxedo             EmojiWithTone = newEmojiWithTone("\U0001f935@\u200d\u2642\ufe0f")                           // man in tuxedo
	WomanInTuxedo           EmojiWithTone = newEmojiWithTone("\U0001f935@\u200d\u2640\ufe0f")                           // woman in tuxedo
	PersonWithVeil          EmojiWithTone = newEmojiWithTone("\U0001f470@")                                             // person with veil
	ManWithVeil             EmojiWithTone = newEmojiWithTone("\U0001f470@\u200d\u2642\ufe0f")                           // man with veil
	WomanWithVeil           EmojiWithTone = newEmojiWithTone("\U0001f470@\u200d\u2640\ufe0f")                           // woman with veil
	PregnantWoman           EmojiWithTone = newEmojiWithTone("\U0001f930@")                                             // pregnant woman
	BreastFeeding           EmojiWithTone = newEmojiWithTone("\U0001f931@")                                             // breast-feeding
	WomanFeedingBaby        EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f37c")                             // woman feeding baby
	ManFeedingBaby          EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f37c")                             // man feeding baby
	PersonFeedingBaby       EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f37c")                             // person feeding baby
	// SUBGROUP: person-fantasy
	BabyAngel         EmojiWithTone = newEmojiWithTone("\U0001f47c@")                   // baby angel
	SantaClaus        EmojiWithTone = newEmojiWithTone("\U0001f385@")                   // Santa Claus
	MrsClaus          EmojiWithTone = newEmojiWithTone("\U0001f936@")                   // Mrs. Claus
	MxClaus           EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f384")   // mx claus
	Superhero         EmojiWithTone = newEmojiWithTone("\U0001f9b8@")                   // superhero
	ManSuperhero      EmojiWithTone = newEmojiWithTone("\U0001f9b8@\u200d\u2642\ufe0f") // man superhero
	WomanSuperhero    EmojiWithTone = newEmojiWithTone("\U0001f9b8@\u200d\u2640\ufe0f") // woman superhero
	Supervillain      EmojiWithTone = newEmojiWithTone("\U0001f9b9@")                   // supervillain
	ManSupervillain   EmojiWithTone = newEmojiWithTone("\U0001f9b9@\u200d\u2642\ufe0f") // man supervillain
	WomanSupervillain EmojiWithTone = newEmojiWithTone("\U0001f9b9@\u200d\u2640\ufe0f") // woman supervillain
	Mage              EmojiWithTone = newEmojiWithTone("\U0001f9d9@")                   // mage
	ManMage           EmojiWithTone = newEmojiWithTone("\U0001f9d9@\u200d\u2642\ufe0f") // man mage
	WomanMage         EmojiWithTone = newEmojiWithTone("\U0001f9d9@\u200d\u2640\ufe0f") // woman mage
	Fairy             EmojiWithTone = newEmojiWithTone("\U0001f9da@")                   // fairy
	ManFairy          EmojiWithTone = newEmojiWithTone("\U0001f9da@\u200d\u2642\ufe0f") // man fairy
	WomanFairy        EmojiWithTone = newEmojiWithTone("\U0001f9da@\u200d\u2640\ufe0f") // woman fairy
	Vampire           EmojiWithTone = newEmojiWithTone("\U0001f9db@")                   // vampire
	ManVampire        EmojiWithTone = newEmojiWithTone("\U0001f9db@\u200d\u2642\ufe0f") // man vampire
	WomanVampire      EmojiWithTone = newEmojiWithTone("\U0001f9db@\u200d\u2640\ufe0f") // woman vampire
	Merperson         EmojiWithTone = newEmojiWithTone("\U0001f9dc@")                   // merperson
	Merman            EmojiWithTone = newEmojiWithTone("\U0001f9dc@\u200d\u2642\ufe0f") // merman
	Mermaid           EmojiWithTone = newEmojiWithTone("\U0001f9dc@\u200d\u2640\ufe0f") // mermaid
	Elf               EmojiWithTone = newEmojiWithTone("\U0001f9dd@")                   // elf
	ManElf            EmojiWithTone = newEmojiWithTone("\U0001f9dd@\u200d\u2642\ufe0f") // man elf
	WomanElf          EmojiWithTone = newEmojiWithTone("\U0001f9dd@\u200d\u2640\ufe0f") // woman elf
	Genie             Emoji         = "\U0001f9de"                                      // genie
	ManGenie          Emoji         = "\U0001f9de\u200d\u2642\ufe0f"                    // man genie
	WomanGenie        Emoji         = "\U0001f9de\u200d\u2640\ufe0f"                    // woman genie
	Zombie            Emoji         = "\U0001f9df"                                      // zombie
	ManZombie         Emoji         = "\U0001f9df\u200d\u2642\ufe0f"                    // man zombie
	WomanZombie       Emoji         = "\U0001f9df\u200d\u2640\ufe0f"                    // woman zombie
	// SUBGROUP: person-activity
	PersonGettingMassage        EmojiWithTone = newEmojiWithTone("\U0001f486@")                           // person getting massage
	ManGettingMassage           EmojiWithTone = newEmojiWithTone("\U0001f486@\u200d\u2642\ufe0f")         // man getting massage
	WomanGettingMassage         EmojiWithTone = newEmojiWithTone("\U0001f486@\u200d\u2640\ufe0f")         // woman getting massage
	PersonGettingHaircut        EmojiWithTone = newEmojiWithTone("\U0001f487@")                           // person getting haircut
	ManGettingHaircut           EmojiWithTone = newEmojiWithTone("\U0001f487@\u200d\u2642\ufe0f")         // man getting haircut
	WomanGettingHaircut         EmojiWithTone = newEmojiWithTone("\U0001f487@\u200d\u2640\ufe0f")         // woman getting haircut
	PersonWalking               EmojiWithTone = newEmojiWithTone("\U0001f6b6@")                           // person walking
	ManWalking                  EmojiWithTone = newEmojiWithTone("\U0001f6b6@\u200d\u2642\ufe0f")         // man walking
	WomanWalking                EmojiWithTone = newEmojiWithTone("\U0001f6b6@\u200d\u2640\ufe0f")         // woman walking
	PersonStanding              EmojiWithTone = newEmojiWithTone("\U0001f9cd@")                           // person standing
	ManStanding                 EmojiWithTone = newEmojiWithTone("\U0001f9cd@\u200d\u2642\ufe0f")         // man standing
	WomanStanding               EmojiWithTone = newEmojiWithTone("\U0001f9cd@\u200d\u2640\ufe0f")         // woman standing
	PersonKneeling              EmojiWithTone = newEmojiWithTone("\U0001f9ce@")                           // person kneeling
	ManKneeling                 EmojiWithTone = newEmojiWithTone("\U0001f9ce@\u200d\u2642\ufe0f")         // man kneeling
	WomanKneeling               EmojiWithTone = newEmojiWithTone("\U0001f9ce@\u200d\u2640\ufe0f")         // woman kneeling
	PersonWithWhiteCane         EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f9af")           // person with white cane
	ManWithWhiteCane            EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f9af")           // man with white cane
	WomanWithWhiteCane          EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f9af")           // woman with white cane
	PersonInMotorizedWheelchair EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f9bc")           // person in motorized wheelchair
	ManInMotorizedWheelchair    EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f9bc")           // man in motorized wheelchair
	WomanInMotorizedWheelchair  EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f9bc")           // woman in motorized wheelchair
	PersonInManualWheelchair    EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f9bd")           // person in manual wheelchair
	ManInManualWheelchair       EmojiWithTone = newEmojiWithTone("\U0001f468@\u200d\U0001f9bd")           // man in manual wheelchair
	WomanInManualWheelchair     EmojiWithTone = newEmojiWithTone("\U0001f469@\u200d\U0001f9bd")           // woman in manual wheelchair
	PersonRunning               EmojiWithTone = newEmojiWithTone("\U0001f3c3@")                           // person running
	ManRunning                  EmojiWithTone = newEmojiWithTone("\U0001f3c3@\u200d\u2642\ufe0f")         // man running
	WomanRunning                EmojiWithTone = newEmojiWithTone("\U0001f3c3@\u200d\u2640\ufe0f")         // woman running
	WomanDancing                EmojiWithTone = newEmojiWithTone("\U0001f483@")                           // woman dancing
	ManDancing                  EmojiWithTone = newEmojiWithTone("\U0001f57a@")                           // man dancing
	PersonInSuitLevitating      EmojiWithTone = newEmojiWithTone("\U0001f574@").withDefaultTone("\ufe0f") // person in suit levitating
	PeopleWithBunnyEars         Emoji         = "\U0001f46f"                                              // people with bunny ears
	MenWithBunnyEars            Emoji         = "\U0001f46f\u200d\u2642\ufe0f"                            // men with bunny ears
	WomenWithBunnyEars          Emoji         = "\U0001f46f\u200d\u2640\ufe0f"                            // women with bunny ears
	PersonInSteamyRoom          EmojiWithTone = newEmojiWithTone("\U0001f9d6@")                           // person in steamy room
	ManInSteamyRoom             EmojiWithTone = newEmojiWithTone("\U0001f9d6@\u200d\u2642\ufe0f")         // man in steamy room
	WomanInSteamyRoom           EmojiWithTone = newEmojiWithTone("\U0001f9d6@\u200d\u2640\ufe0f")         // woman in steamy room
	PersonClimbing              EmojiWithTone = newEmojiWithTone("\U0001f9d7@")                           // person climbing
	ManClimbing                 EmojiWithTone = newEmojiWithTone("\U0001f9d7@\u200d\u2642\ufe0f")         // man climbing
	WomanClimbing               EmojiWithTone = newEmojiWithTone("\U0001f9d7@\u200d\u2640\ufe0f")         // woman climbing
	// SUBGROUP: person-sport
	PersonFencing          Emoji         = "\U0001f93a"                                                                // person fencing
	HorseRacing            EmojiWithTone = newEmojiWithTone("\U0001f3c7@")                                             // horse racing
	Skier                  Emoji         = "\u26f7\ufe0f"                                                              // skier
	Snowboarder            EmojiWithTone = newEmojiWithTone("\U0001f3c2@")                                             // snowboarder
	PersonGolfing          EmojiWithTone = newEmojiWithTone("\U0001f3cc@").withDefaultTone("\ufe0f")                   // person golfing
	ManGolfing             EmojiWithTone = newEmojiWithTone("\U0001f3cc@\u200d\u2642\ufe0f").withDefaultTone("\ufe0f") // man golfing
	WomanGolfing           EmojiWithTone = newEmojiWithTone("\U0001f3cc@\u200d\u2640\ufe0f").withDefaultTone("\ufe0f") // woman golfing
	PersonSurfing          EmojiWithTone = newEmojiWithTone("\U0001f3c4@")                                             // person surfing
	ManSurfing             EmojiWithTone = newEmojiWithTone("\U0001f3c4@\u200d\u2642\ufe0f")                           // man surfing
	WomanSurfing           EmojiWithTone = newEmojiWithTone("\U0001f3c4@\u200d\u2640\ufe0f")                           // woman surfing
	PersonRowingBoat       EmojiWithTone = newEmojiWithTone("\U0001f6a3@")                                             // person rowing boat
	ManRowingBoat          EmojiWithTone = newEmojiWithTone("\U0001f6a3@\u200d\u2642\ufe0f")                           // man rowing boat
	WomanRowingBoat        EmojiWithTone = newEmojiWithTone("\U0001f6a3@\u200d\u2640\ufe0f")                           // woman rowing boat
	PersonSwimming         EmojiWithTone = newEmojiWithTone("\U0001f3ca@")                                             // person swimming
	ManSwimming            EmojiWithTone = newEmojiWithTone("\U0001f3ca@\u200d\u2642\ufe0f")                           // man swimming
	WomanSwimming          EmojiWithTone = newEmojiWithTone("\U0001f3ca@\u200d\u2640\ufe0f")                           // woman swimming
	PersonBouncingBall     EmojiWithTone = newEmojiWithTone("\u26f9@").withDefaultTone("\ufe0f")                       // person bouncing ball
	ManBouncingBall        EmojiWithTone = newEmojiWithTone("\u26f9@\u200d\u2642\ufe0f").withDefaultTone("\ufe0f")     // man bouncing ball
	WomanBouncingBall      EmojiWithTone = newEmojiWithTone("\u26f9@\u200d\u2640\ufe0f").withDefaultTone("\ufe0f")     // woman bouncing ball
	PersonLiftingWeights   EmojiWithTone = newEmojiWithTone("\U0001f3cb@").withDefaultTone("\ufe0f")                   // person lifting weights
	ManLiftingWeights      EmojiWithTone = newEmojiWithTone("\U0001f3cb@\u200d\u2642\ufe0f").withDefaultTone("\ufe0f") // man lifting weights
	WomanLiftingWeights    EmojiWithTone = newEmojiWithTone("\U0001f3cb@\u200d\u2640\ufe0f").withDefaultTone("\ufe0f") // woman lifting weights
	PersonBiking           EmojiWithTone = newEmojiWithTone("\U0001f6b4@")                                             // person biking
	ManBiking              EmojiWithTone = newEmojiWithTone("\U0001f6b4@\u200d\u2642\ufe0f")                           // man biking
	WomanBiking            EmojiWithTone = newEmojiWithTone("\U0001f6b4@\u200d\u2640\ufe0f")                           // woman biking
	PersonMountainBiking   EmojiWithTone = newEmojiWithTone("\U0001f6b5@")                                             // person mountain biking
	ManMountainBiking      EmojiWithTone = newEmojiWithTone("\U0001f6b5@\u200d\u2642\ufe0f")                           // man mountain biking
	WomanMountainBiking    EmojiWithTone = newEmojiWithTone("\U0001f6b5@\u200d\u2640\ufe0f")                           // woman mountain biking
	PersonCartwheeling     EmojiWithTone = newEmojiWithTone("\U0001f938@")                                             // person cartwheeling
	ManCartwheeling        EmojiWithTone = newEmojiWithTone("\U0001f938@\u200d\u2642\ufe0f")                           // man cartwheeling
	WomanCartwheeling      EmojiWithTone = newEmojiWithTone("\U0001f938@\u200d\u2640\ufe0f")                           // woman cartwheeling
	PeopleWrestling        Emoji         = "\U0001f93c"                                                                // people wrestling
	MenWrestling           Emoji         = "\U0001f93c\u200d\u2642\ufe0f"                                              // men wrestling
	WomenWrestling         Emoji         = "\U0001f93c\u200d\u2640\ufe0f"                                              // women wrestling
	PersonPlayingWaterPolo EmojiWithTone = newEmojiWithTone("\U0001f93d@")                                             // person playing water polo
	ManPlayingWaterPolo    EmojiWithTone = newEmojiWithTone("\U0001f93d@\u200d\u2642\ufe0f")                           // man playing water polo
	WomanPlayingWaterPolo  EmojiWithTone = newEmojiWithTone("\U0001f93d@\u200d\u2640\ufe0f")                           // woman playing water polo
	PersonPlayingHandball  EmojiWithTone = newEmojiWithTone("\U0001f93e@")                                             // person playing handball
	ManPlayingHandball     EmojiWithTone = newEmojiWithTone("\U0001f93e@\u200d\u2642\ufe0f")                           // man playing handball
	WomanPlayingHandball   EmojiWithTone = newEmojiWithTone("\U0001f93e@\u200d\u2640\ufe0f")                           // woman playing handball
	PersonJuggling         EmojiWithTone = newEmojiWithTone("\U0001f939@")                                             // person juggling
	ManJuggling            EmojiWithTone = newEmojiWithTone("\U0001f939@\u200d\u2642\ufe0f")                           // man juggling
	WomanJuggling          EmojiWithTone = newEmojiWithTone("\U0001f939@\u200d\u2640\ufe0f")                           // woman juggling
	// SUBGROUP: person-resting
	PersonInLotusPosition EmojiWithTone = newEmojiWithTone("\U0001f9d8@")                   // person in lotus position
	ManInLotusPosition    EmojiWithTone = newEmojiWithTone("\U0001f9d8@\u200d\u2642\ufe0f") // man in lotus position
	WomanInLotusPosition  EmojiWithTone = newEmojiWithTone("\U0001f9d8@\u200d\u2640\ufe0f") // woman in lotus position
	PersonTakingBath      EmojiWithTone = newEmojiWithTone("\U0001f6c0@")                   // person taking bath
	PersonInBed           EmojiWithTone = newEmojiWithTone("\U0001f6cc@")                   // person in bed
	// SUBGROUP: family
	PeopleHoldingHands        EmojiWithTone = newEmojiWithTone("\U0001f9d1@\u200d\U0001f91d\u200d\U0001f9d1@", "\U0001f9d1@\u200d\U0001f91d\u200d\U0001f9d1@") // people holding hands
	WomenHoldingHands         EmojiWithTone = newEmojiWithTone("\U0001f46d@", "\U0001f469@\u200d\U0001f91d\u200d\U0001f469@")                                  // women holding hands
	WomanAndManHoldingHands   EmojiWithTone = newEmojiWithTone("\U0001f46b@", "\U0001f469@\u200d\U0001f91d\u200d\U0001f468@")                                  // woman and man holding hands
	MenHoldingHands           EmojiWithTone = newEmojiWithTone("\U0001f46c@", "\U0001f468@\u200d\U0001f91d\u200d\U0001f468@")                                  // men holding hands
	Kiss                      Emoji         = "\U0001f48f"                                                                                                     // kiss
	KissWomanMan              Emoji         = "\U0001f469\u200d\u2764\ufe0f\u200d\U0001f48b\u200d\U0001f468"                                                   // kiss: woman, man
	KissManMan                Emoji         = "\U0001f468\u200d\u2764\ufe0f\u200d\U0001f48b\u200d\U0001f468"                                                   // kiss: man, man
	KissWomanWoman            Emoji         = "\U0001f469\u200d\u2764\ufe0f\u200d\U0001f48b\u200d\U0001f469"                                                   // kiss: woman, woman
	CoupleWithHeart           Emoji         = "\U0001f491"                                                                                                     // couple with heart
	CoupleWithHeartWomanMan   Emoji         = "\U0001f469\u200d\u2764\ufe0f\u200d\U0001f468"                                                                   // couple with heart: woman, man
	CoupleWithHeartManMan     Emoji         = "\U0001f468\u200d\u2764\ufe0f\u200d\U0001f468"                                                                   // couple with heart: man, man
	CoupleWithHeartWomanWoman Emoji         = "\U0001f469\u200d\u2764\ufe0f\u200d\U0001f469"                                                                   // couple with heart: woman, woman
	Family                    Emoji         = "\U0001f46a"                                                                                                     // family
	FamilyManWomanBoy         Emoji         = "\U0001f468\u200d\U0001f469\u200d\U0001f466"                                                                     // family: man, woman, boy
	FamilyManWomanGirl        Emoji         = "\U0001f468\u200d\U0001f469\u200d\U0001f467"                                                                     // family: man, woman, girl
	FamilyManWomanGirlBoy     Emoji         = "\U0001f468\u200d\U0001f469\u200d\U0001f467\u200d\U0001f466"                                                     // family: man, woman, girl, boy
	FamilyManWomanBoyBoy      Emoji         = "\U0001f468\u200d\U0001f469\u200d\U0001f466\u200d\U0001f466"                                                     // family: man, woman, boy, boy
	FamilyManWomanGirlGirl    Emoji         = "\U0001f468\u200d\U0001f469\u200d\U0001f467\u200d\U0001f467"                                                     // family: man, woman, girl, girl
	FamilyManManBoy           Emoji         = "\U0001f468\u200d\U0001f468\u200d\U0001f466"                                                                     // family: man, man, boy
	FamilyManManGirl          Emoji         = "\U0001f468\u200d\U0001f468\u200d\U0001f467"                                                                     // family: man, man, girl
	FamilyManManGirlBoy       Emoji         = "\U0001f468\u200d\U0001f468\u200d\U0001f467\u200d\U0001f466"                                                     // family: man, man, girl, boy
	FamilyManManBoyBoy        Emoji         = "\U0001f468\u200d\U0001f468\u200d\U0001f466\u200d\U0001f466"                                                     // family: man, man, boy, boy
	FamilyManManGirlGirl      Emoji         = "\U0001f468\u200d\U0001f468\u200d\U0001f467\u200d\U0001f467"                                                     // family: man, man, girl, girl
	FamilyWomanWomanBoy       Emoji         = "\U0001f469\u200d\U0001f469\u200d\U0001f466"                                                                     // family: woman, woman, boy
	FamilyWomanWomanGirl      Emoji         = "\U0001f469\u200d\U0001f469\u200d\U0001f467"                                                                     // family: woman, woman, girl
	FamilyWomanWomanGirlBoy   Emoji         = "\U0001f469\u200d\U0001f469\u200d\U0001f467\u200d\U0001f466"                                                     // family: woman, woman, girl, boy
	FamilyWomanWomanBoyBoy    Emoji         = "\U0001f469\u200d\U0001f469\u200d\U0001f466\u200d\U0001f466"                                                     // family: woman, woman, boy, boy
	FamilyWomanWomanGirlGirl  Emoji         = "\U0001f469\u200d\U0001f469\u200d\U0001f467\u200d\U0001f467"                                                     // family: woman, woman, girl, girl
	FamilyManBoy              Emoji         = "\U0001f468\u200d\U0001f466"                                                                                     // family: man, boy
	FamilyManBoyBoy           Emoji         = "\U0001f468\u200d\U0001f466\u200d\U0001f466"                                                                     // family: man, boy, boy
	FamilyManGirl             Emoji         = "\U0001f468\u200d\U0001f467"                                                                                     // family: man, girl
	FamilyManGirlBoy          Emoji         = "\U0001f468\u200d\U0001f467\u200d\U0001f466"                                                                     // family: man, girl, boy
	FamilyManGirlGirl         Emoji         = "\U0001f468\u200d\U0001f467\u200d\U0001f467"                                                                     // family: man, girl, girl
	FamilyWomanBoy            Emoji         = "\U0001f469\u200d\U0001f466"                                                                                     // family: woman, boy
	FamilyWomanBoyBoy         Emoji         = "\U0001f469\u200d\U0001f466\u200d\U0001f466"                                                                     // family: woman, boy, boy
	FamilyWomanGirl           Emoji         = "\U0001f469\u200d\U0001f467"                                                                                     // family: woman, girl
	FamilyWomanGirlBoy        Emoji         = "\U0001f469\u200d\U0001f467\u200d\U0001f466"                                                                     // family: woman, girl, boy
	FamilyWomanGirlGirl       Emoji         = "\U0001f469\u200d\U0001f467\u200d\U0001f467"                                                                     // family: woman, girl, girl
	// SUBGROUP: person-symbol
	SpeakingHead      Emoji = "\U0001f5e3\ufe0f" // speaking head
	BustInSilhouette  Emoji = "\U0001f464"       // bust in silhouette
	BustsInSilhouette Emoji = "\U0001f465"       // busts in silhouette
	PeopleHugging     Emoji = "\U0001fac2"       // people hugging
	Footprints        Emoji = "\U0001f463"       // footprints

	// GROUP: Component
	// SUBGROUP: skin-tone
	LightSkinTone       Emoji = "\U0001f3fb" // light skin tone
	MediumLightSkinTone Emoji = "\U0001f3fc" // medium-light skin tone
	MediumSkinTone      Emoji = "\U0001f3fd" // medium skin tone
	MediumDarkSkinTone  Emoji = "\U0001f3fe" // medium-dark skin tone
	DarkSkinTone        Emoji = "\U0001f3ff" // dark skin tone
	// SUBGROUP: hair-style
	RedHair   Emoji = "\U0001f9b0" // red hair
	CurlyHair Emoji = "\U0001f9b1" // curly hair
	WhiteHair Emoji = "\U0001f9b3" // white hair
	Bald      Emoji = "\U0001f9b2" // bald

	// GROUP: Animals & Nature
	// SUBGROUP: animal-mammal
	MonkeyFace   Emoji = "\U0001f435"                   // monkey face
	Monkey       Emoji = "\U0001f412"                   // monkey
	Gorilla      Emoji = "\U0001f98d"                   // gorilla
	Orangutan    Emoji = "\U0001f9a7"                   // orangutan
	DogFace      Emoji = "\U0001f436"                   // dog face
	Dog          Emoji = "\U0001f415"                   // dog
	GuideDog     Emoji = "\U0001f9ae"                   // guide dog
	ServiceDog   Emoji = "\U0001f415\u200d\U0001f9ba"   // service dog
	Poodle       Emoji = "\U0001f429"                   // poodle
	Wolf         Emoji = "\U0001f43a"                   // wolf
	Fox          Emoji = "\U0001f98a"                   // fox
	Raccoon      Emoji = "\U0001f99d"                   // raccoon
	CatFace      Emoji = "\U0001f431"                   // cat face
	Cat          Emoji = "\U0001f408"                   // cat
	BlackCat     Emoji = "\U0001f408\u200d\u2b1b"       // black cat
	Lion         Emoji = "\U0001f981"                   // lion
	TigerFace    Emoji = "\U0001f42f"                   // tiger face
	Tiger        Emoji = "\U0001f405"                   // tiger
	Leopard      Emoji = "\U0001f406"                   // leopard
	HorseFace    Emoji = "\U0001f434"                   // horse face
	Horse        Emoji = "\U0001f40e"                   // horse
	Unicorn      Emoji = "\U0001f984"                   // unicorn
	Zebra        Emoji = "\U0001f993"                   // zebra
	Deer         Emoji = "\U0001f98c"                   // deer
	Bison        Emoji = "\U0001f9ac"                   // bison
	CowFace      Emoji = "\U0001f42e"                   // cow face
	Ox           Emoji = "\U0001f402"                   // ox
	WaterBuffalo Emoji = "\U0001f403"                   // water buffalo
	Cow          Emoji = "\U0001f404"                   // cow
	PigFace      Emoji = "\U0001f437"                   // pig face
	Pig          Emoji = "\U0001f416"                   // pig
	Boar         Emoji = "\U0001f417"                   // boar
	PigNose      Emoji = "\U0001f43d"                   // pig nose
	Ram          Emoji = "\U0001f40f"                   // ram
	Ewe          Emoji = "\U0001f411"                   // ewe
	Goat         Emoji = "\U0001f410"                   // goat
	Camel        Emoji = "\U0001f42a"                   // camel
	TwoHumpCamel Emoji = "\U0001f42b"                   // two-hump camel
	Llama        Emoji = "\U0001f999"                   // llama
	Giraffe      Emoji = "\U0001f992"                   // giraffe
	Elephant     Emoji = "\U0001f418"                   // elephant
	Mammoth      Emoji = "\U0001f9a3"                   // mammoth
	Rhinoceros   Emoji = "\U0001f98f"                   // rhinoceros
	Hippopotamus Emoji = "\U0001f99b"                   // hippopotamus
	MouseFace    Emoji = "\U0001f42d"                   // mouse face
	Mouse        Emoji = "\U0001f401"                   // mouse
	Rat          Emoji = "\U0001f400"                   // rat
	Hamster      Emoji = "\U0001f439"                   // hamster
	RabbitFace   Emoji = "\U0001f430"                   // rabbit face
	Rabbit       Emoji = "\U0001f407"                   // rabbit
	Chipmunk     Emoji = "\U0001f43f\ufe0f"             // chipmunk
	Beaver       Emoji = "\U0001f9ab"                   // beaver
	Hedgehog     Emoji = "\U0001f994"                   // hedgehog
	Bat          Emoji = "\U0001f987"                   // bat
	Bear         Emoji = "\U0001f43b"                   // bear
	PolarBear    Emoji = "\U0001f43b\u200d\u2744\ufe0f" // polar bear
	Koala        Emoji = "\U0001f428"                   // koala
	Panda        Emoji = "\U0001f43c"                   // panda
	Sloth        Emoji = "\U0001f9a5"                   // sloth
	Otter        Emoji = "\U0001f9a6"                   // otter
	Skunk        Emoji = "\U0001f9a8"                   // skunk
	Kangaroo     Emoji = "\U0001f998"                   // kangaroo
	Badger       Emoji = "\U0001f9a1"                   // badger
	PawPrints    Emoji = "\U0001f43e"                   // paw prints
	// SUBGROUP: animal-bird
	Turkey               Emoji = "\U0001f983"       // turkey
	Chicken              Emoji = "\U0001f414"       // chicken
	Rooster              Emoji = "\U0001f413"       // rooster
	HatchingChick        Emoji = "\U0001f423"       // hatching chick
	BabyChick            Emoji = "\U0001f424"       // baby chick
	FrontFacingBabyChick Emoji = "\U0001f425"       // front-facing baby chick
	Bird                 Emoji = "\U0001f426"       // bird
	Penguin              Emoji = "\U0001f427"       // penguin
	Dove                 Emoji = "\U0001f54a\ufe0f" // dove
	Eagle                Emoji = "\U0001f985"       // eagle
	Duck                 Emoji = "\U0001f986"       // duck
	Swan                 Emoji = "\U0001f9a2"       // swan
	Owl                  Emoji = "\U0001f989"       // owl
	Dodo                 Emoji = "\U0001f9a4"       // dodo
	Feather              Emoji = "\U0001fab6"       // feather
	Flamingo             Emoji = "\U0001f9a9"       // flamingo
	Peacock              Emoji = "\U0001f99a"       // peacock
	Parrot               Emoji = "\U0001f99c"       // parrot
	// SUBGROUP: animal-amphibian
	Frog Emoji = "\U0001f438" // frog
	// SUBGROUP: animal-reptile
	Crocodile  Emoji = "\U0001f40a" // crocodile
	Turtle     Emoji = "\U0001f422" // turtle
	Lizard     Emoji = "\U0001f98e" // lizard
	Snake      Emoji = "\U0001f40d" // snake
	DragonFace Emoji = "\U0001f432" // dragon face
	Dragon     Emoji = "\U0001f409" // dragon
	Sauropod   Emoji = "\U0001f995" // sauropod
	TRex       Emoji = "\U0001f996" // T-Rex
	// SUBGROUP: animal-marine
	SpoutingWhale Emoji = "\U0001f433" // spouting whale
	Whale         Emoji = "\U0001f40b" // whale
	Dolphin       Emoji = "\U0001f42c" // dolphin
	Seal          Emoji = "\U0001f9ad" // seal
	Fish          Emoji = "\U0001f41f" // fish
	TropicalFish  Emoji = "\U0001f420" // tropical fish
	Blowfish      Emoji = "\U0001f421" // blowfish
	Shark         Emoji = "\U0001f988" // shark
	Octopus       Emoji = "\U0001f419" // octopus
	SpiralShell   Emoji = "\U0001f41a" // spiral shell
	// SUBGROUP: animal-bug
	Snail      Emoji = "\U0001f40c"       // snail
	Butterfly  Emoji = "\U0001f98b"       // butterfly
	Bug        Emoji = "\U0001f41b"       // bug
	Ant        Emoji = "\U0001f41c"       // ant
	Honeybee   Emoji = "\U0001f41d"       // honeybee
	Beetle     Emoji = "\U0001fab2"       // beetle
	LadyBeetle Emoji = "\U0001f41e"       // lady beetle
	Cricket    Emoji = "\U0001f997"       // cricket
	Cockroach  Emoji = "\U0001fab3"       // cockroach
	Spider     Emoji = "\U0001f577\ufe0f" // spider
	SpiderWeb  Emoji = "\U0001f578\ufe0f" // spider web
	Scorpion   Emoji = "\U0001f982"       // scorpion
	Mosquito   Emoji = "\U0001f99f"       // mosquito
	Fly        Emoji = "\U0001fab0"       // fly
	Worm       Emoji = "\U0001fab1"       // worm
	Microbe    Emoji = "\U0001f9a0"       // microbe
	// SUBGROUP: plant-flower
	Bouquet       Emoji = "\U0001f490"       // bouquet
	CherryBlossom Emoji = "\U0001f338"       // cherry blossom
	WhiteFlower   Emoji = "\U0001f4ae"       // white flower
	Rosette       Emoji = "\U0001f3f5\ufe0f" // rosette
	Rose          Emoji = "\U0001f339"       // rose
	WiltedFlower  Emoji = "\U0001f940"       // wilted flower
	Hibiscus      Emoji = "\U0001f33a"       // hibiscus
	Sunflower     Emoji = "\U0001f33b"       // sunflower
	Blossom       Emoji = "\U0001f33c"       // blossom
	Tulip         Emoji = "\U0001f337"       // tulip
	// SUBGROUP: plant-other
	Seedling             Emoji = "\U0001f331"   // seedling
	PottedPlant          Emoji = "\U0001fab4"   // potted plant
	EvergreenTree        Emoji = "\U0001f332"   // evergreen tree
	DeciduousTree        Emoji = "\U0001f333"   // deciduous tree
	PalmTree             Emoji = "\U0001f334"   // palm tree
	Cactus               Emoji = "\U0001f335"   // cactus
	SheafOfRice          Emoji = "\U0001f33e"   // sheaf of rice
	Herb                 Emoji = "\U0001f33f"   // herb
	Shamrock             Emoji = "\u2618\ufe0f" // shamrock
	FourLeafClover       Emoji = "\U0001f340"   // four leaf clover
	MapleLeaf            Emoji = "\U0001f341"   // maple leaf
	FallenLeaf           Emoji = "\U0001f342"   // fallen leaf
	LeafFlutteringInWind Emoji = "\U0001f343"   // leaf fluttering in wind

	// GROUP: Food & Drink
	// SUBGROUP: food-fruit
	Grapes      Emoji = "\U0001f347" // grapes
	Melon       Emoji = "\U0001f348" // melon
	Watermelon  Emoji = "\U0001f349" // watermelon
	Tangerine   Emoji = "\U0001f34a" // tangerine
	Lemon       Emoji = "\U0001f34b" // lemon
	Banana      Emoji = "\U0001f34c" // banana
	Pineapple   Emoji = "\U0001f34d" // pineapple
	Mango       Emoji = "\U0001f96d" // mango
	RedApple    Emoji = "\U0001f34e" // red apple
	GreenApple  Emoji = "\U0001f34f" // green apple
	Pear        Emoji = "\U0001f350" // pear
	Peach       Emoji = "\U0001f351" // peach
	Cherries    Emoji = "\U0001f352" // cherries
	Strawberry  Emoji = "\U0001f353" // strawberry
	Blueberries Emoji = "\U0001fad0" // blueberries
	KiwiFruit   Emoji = "\U0001f95d" // kiwi fruit
	Tomato      Emoji = "\U0001f345" // tomato
	Olive       Emoji = "\U0001fad2" // olive
	Coconut     Emoji = "\U0001f965" // coconut
	// SUBGROUP: food-vegetable
	Avocado    Emoji = "\U0001f951"       // avocado
	Eggplant   Emoji = "\U0001f346"       // eggplant
	Potato     Emoji = "\U0001f954"       // potato
	Carrot     Emoji = "\U0001f955"       // carrot
	EarOfCorn  Emoji = "\U0001f33d"       // ear of corn
	HotPepper  Emoji = "\U0001f336\ufe0f" // hot pepper
	BellPepper Emoji = "\U0001fad1"       // bell pepper
	Cucumber   Emoji = "\U0001f952"       // cucumber
	LeafyGreen Emoji = "\U0001f96c"       // leafy green
	Broccoli   Emoji = "\U0001f966"       // broccoli
	Garlic     Emoji = "\U0001f9c4"       // garlic
	Onion      Emoji = "\U0001f9c5"       // onion
	Mushroom   Emoji = "\U0001f344"       // mushroom
	Peanuts    Emoji = "\U0001f95c"       // peanuts
	Chestnut   Emoji = "\U0001f330"       // chestnut
	// SUBGROUP: food-prepared
	Bread            Emoji = "\U0001f35e" // bread
	Croissant        Emoji = "\U0001f950" // croissant
	BaguetteBread    Emoji = "\U0001f956" // baguette bread
	Flatbread        Emoji = "\U0001fad3" // flatbread
	Pretzel          Emoji = "\U0001f968" // pretzel
	Bagel            Emoji = "\U0001f96f" // bagel
	Pancakes         Emoji = "\U0001f95e" // pancakes
	Waffle           Emoji = "\U0001f9c7" // waffle
	CheeseWedge      Emoji = "\U0001f9c0" // cheese wedge
	MeatOnBone       Emoji = "\U0001f356" // meat on bone
	PoultryLeg       Emoji = "\U0001f357" // poultry leg
	CutOfMeat        Emoji = "\U0001f969" // cut of meat
	Bacon            Emoji = "\U0001f953" // bacon
	Hamburger        Emoji = "\U0001f354" // hamburger
	FrenchFries      Emoji = "\U0001f35f" // french fries
	Pizza            Emoji = "\U0001f355" // pizza
	HotDog           Emoji = "\U0001f32d" // hot dog
	Sandwich         Emoji = "\U0001f96a" // sandwich
	Taco             Emoji = "\U0001f32e" // taco
	Burrito          Emoji = "\U0001f32f" // burrito
	Tamale           Emoji = "\U0001fad4" // tamale
	StuffedFlatbread Emoji = "\U0001f959" // stuffed flatbread
	Falafel          Emoji = "\U0001f9c6" // falafel
	Egg              Emoji = "\U0001f95a" // egg
	Cooking          Emoji = "\U0001f373" // cooking
	ShallowPanOfFood Emoji = "\U0001f958" // shallow pan of food
	PotOfFood        Emoji = "\U0001f372" // pot of food
	Fondue           Emoji = "\U0001fad5" // fondue
	BowlWithSpoon    Emoji = "\U0001f963" // bowl with spoon
	GreenSalad       Emoji = "\U0001f957" // green salad
	Popcorn          Emoji = "\U0001f37f" // popcorn
	Butter           Emoji = "\U0001f9c8" // butter
	Salt             Emoji = "\U0001f9c2" // salt
	CannedFood       Emoji = "\U0001f96b" // canned food
	// SUBGROUP: food-asian
	BentoBox           Emoji = "\U0001f371" // bento box
	RiceCracker        Emoji = "\U0001f358" // rice cracker
	RiceBall           Emoji = "\U0001f359" // rice ball
	CookedRice         Emoji = "\U0001f35a" // cooked rice
	CurryRice          Emoji = "\U0001f35b" // curry rice
	SteamingBowl       Emoji = "\U0001f35c" // steaming bowl
	Spaghetti          Emoji = "\U0001f35d" // spaghetti
	RoastedSweetPotato Emoji = "\U0001f360" // roasted sweet potato
	Oden               Emoji = "\U0001f362" // oden
	Sushi              Emoji = "\U0001f363" // sushi
	FriedShrimp        Emoji = "\U0001f364" // fried shrimp
	FishCakeWithSwirl  Emoji = "\U0001f365" // fish cake with swirl
	MoonCake           Emoji = "\U0001f96e" // moon cake
	Dango              Emoji = "\U0001f361" // dango
	Dumpling           Emoji = "\U0001f95f" // dumpling
	FortuneCookie      Emoji = "\U0001f960" // fortune cookie
	TakeoutBox         Emoji = "\U0001f961" // takeout box
	// SUBGROUP: food-marine
	Crab    Emoji = "\U0001f980" // crab
	Lobster Emoji = "\U0001f99e" // lobster
	Shrimp  Emoji = "\U0001f990" // shrimp
	Squid   Emoji = "\U0001f991" // squid
	Oyster  Emoji = "\U0001f9aa" // oyster
	// SUBGROUP: food-sweet
	SoftIceCream Emoji = "\U0001f366" // soft ice cream
	ShavedIce    Emoji = "\U0001f367" // shaved ice
	IceCream     Emoji = "\U0001f368" // ice cream
	Doughnut     Emoji = "\U0001f369" // doughnut
	Cookie       Emoji = "\U0001f36a" // cookie
	BirthdayCake Emoji = "\U0001f382" // birthday cake
	Shortcake    Emoji = "\U0001f370" // shortcake
	Cupcake      Emoji = "\U0001f9c1" // cupcake
	Pie          Emoji = "\U0001f967" // pie
	ChocolateBar Emoji = "\U0001f36b" // chocolate bar
	Candy        Emoji = "\U0001f36c" // candy
	Lollipop     Emoji = "\U0001f36d" // lollipop
	Custard      Emoji = "\U0001f36e" // custard
	HoneyPot     Emoji = "\U0001f36f" // honey pot
	// SUBGROUP: drink
	BabyBottle            Emoji = "\U0001f37c" // baby bottle
	GlassOfMilk           Emoji = "\U0001f95b" // glass of milk
	HotBeverage           Emoji = "\u2615"     // hot beverage
	Teapot                Emoji = "\U0001fad6" // teapot
	TeacupWithoutHandle   Emoji = "\U0001f375" // teacup without handle
	Sake                  Emoji = "\U0001f376" // sake
	BottleWithPoppingCork Emoji = "\U0001f37e" // bottle with popping cork
	WineGlass             Emoji = "\U0001f377" // wine glass
	CocktailGlass         Emoji = "\U0001f378" // cocktail glass
	TropicalDrink         Emoji = "\U0001f379" // tropical drink
	BeerMug               Emoji = "\U0001f37a" // beer mug
	ClinkingBeerMugs      Emoji = "\U0001f37b" // clinking beer mugs
	ClinkingGlasses       Emoji = "\U0001f942" // clinking glasses
	TumblerGlass          Emoji = "\U0001f943" // tumbler glass
	CupWithStraw          Emoji = "\U0001f964" // cup with straw
	BubbleTea             Emoji = "\U0001f9cb" // bubble tea
	BeverageBox           Emoji = "\U0001f9c3" // beverage box
	Mate                  Emoji = "\U0001f9c9" // mate
	Ice                   Emoji = "\U0001f9ca" // ice
	// SUBGROUP: dishware
	Chopsticks            Emoji = "\U0001f962"       // chopsticks
	ForkAndKnifeWithPlate Emoji = "\U0001f37d\ufe0f" // fork and knife with plate
	ForkAndKnife          Emoji = "\U0001f374"       // fork and knife
	Spoon                 Emoji = "\U0001f944"       // spoon
	KitchenKnife          Emoji = "\U0001f52a"       // kitchen knife
	Amphora               Emoji = "\U0001f3fa"       // amphora

	// GROUP: Travel & Places
	// SUBGROUP: place-map
	GlobeShowingEuropeAfrica  Emoji = "\U0001f30d"       // globe showing Europe-Africa
	GlobeShowingAmericas      Emoji = "\U0001f30e"       // globe showing Americas
	GlobeShowingAsiaAustralia Emoji = "\U0001f30f"       // globe showing Asia-Australia
	GlobeWithMeridians        Emoji = "\U0001f310"       // globe with meridians
	WorldMap                  Emoji = "\U0001f5fa\ufe0f" // world map
	MapOfJapan                Emoji = "\U0001f5fe"       // map of Japan
	Compass                   Emoji = "\U0001f9ed"       // compass
	// SUBGROUP: place-geographic
	SnowCappedMountain Emoji = "\U0001f3d4\ufe0f" // snow-capped mountain
	Mountain           Emoji = "\u26f0\ufe0f"     // mountain
	Volcano            Emoji = "\U0001f30b"       // volcano
	MountFuji          Emoji = "\U0001f5fb"       // mount fuji
	Camping            Emoji = "\U0001f3d5\ufe0f" // camping
	BeachWithUmbrella  Emoji = "\U0001f3d6\ufe0f" // beach with umbrella
	Desert             Emoji = "\U0001f3dc\ufe0f" // desert
	DesertIsland       Emoji = "\U0001f3dd\ufe0f" // desert island
	NationalPark       Emoji = "\U0001f3de\ufe0f" // national park
	// SUBGROUP: place-building
	Stadium              Emoji = "\U0001f3df\ufe0f" // stadium
	ClassicalBuilding    Emoji = "\U0001f3db\ufe0f" // classical building
	BuildingConstruction Emoji = "\U0001f3d7\ufe0f" // building construction
	Brick                Emoji = "\U0001f9f1"       // brick
	Rock                 Emoji = "\U0001faa8"       // rock
	Wood                 Emoji = "\U0001fab5"       // wood
	Hut                  Emoji = "\U0001f6d6"       // hut
	Houses               Emoji = "\U0001f3d8\ufe0f" // houses
	DerelictHouse        Emoji = "\U0001f3da\ufe0f" // derelict house
	House                Emoji = "\U0001f3e0"       // house
	HouseWithGarden      Emoji = "\U0001f3e1"       // house with garden
	OfficeBuilding       Emoji = "\U0001f3e2"       // office building
	JapanesePostOffice   Emoji = "\U0001f3e3"       // Japanese post office
	PostOffice           Emoji = "\U0001f3e4"       // post office
	Hospital             Emoji = "\U0001f3e5"       // hospital
	Bank                 Emoji = "\U0001f3e6"       // bank
	Hotel                Emoji = "\U0001f3e8"       // hotel
	LoveHotel            Emoji = "\U0001f3e9"       // love hotel
	ConvenienceStore     Emoji = "\U0001f3ea"       // convenience store
	School               Emoji = "\U0001f3eb"       // school
	DepartmentStore      Emoji = "\U0001f3ec"       // department store
	Factory              Emoji = "\U0001f3ed"       // factory
	JapaneseCastle       Emoji = "\U0001f3ef"       // Japanese castle
	Castle               Emoji = "\U0001f3f0"       // castle
	Wedding              Emoji = "\U0001f492"       // wedding
	TokyoTower           Emoji = "\U0001f5fc"       // Tokyo tower
	StatueOfLiberty      Emoji = "\U0001f5fd"       // Statue of Liberty
	// SUBGROUP: place-religious
	Church       Emoji = "\u26ea"       // church
	Mosque       Emoji = "\U0001f54c"   // mosque
	HinduTemple  Emoji = "\U0001f6d5"   // hindu temple
	Synagogue    Emoji = "\U0001f54d"   // synagogue
	ShintoShrine Emoji = "\u26e9\ufe0f" // shinto shrine
	Kaaba        Emoji = "\U0001f54b"   // kaaba
	// SUBGROUP: place-other
	Fountain             Emoji = "\u26f2"           // fountain
	Tent                 Emoji = "\u26fa"           // tent
	Foggy                Emoji = "\U0001f301"       // foggy
	NightWithStars       Emoji = "\U0001f303"       // night with stars
	Cityscape            Emoji = "\U0001f3d9\ufe0f" // cityscape
	SunriseOverMountains Emoji = "\U0001f304"       // sunrise over mountains
	Sunrise              Emoji = "\U0001f305"       // sunrise
	CityscapeAtDusk      Emoji = "\U0001f306"       // cityscape at dusk
	Sunset               Emoji = "\U0001f307"       // sunset
	BridgeAtNight        Emoji = "\U0001f309"       // bridge at night
	HotSprings           Emoji = "\u2668\ufe0f"     // hot springs
	CarouselHorse        Emoji = "\U0001f3a0"       // carousel horse
	FerrisWheel          Emoji = "\U0001f3a1"       // ferris wheel
	RollerCoaster        Emoji = "\U0001f3a2"       // roller coaster
	BarberPole           Emoji = "\U0001f488"       // barber pole
	CircusTent           Emoji = "\U0001f3aa"       // circus tent
	// SUBGROUP: transport-ground
	Locomotive             Emoji = "\U0001f682"       // locomotive
	RailwayCar             Emoji = "\U0001f683"       // railway car
	HighSpeedTrain         Emoji = "\U0001f684"       // high-speed train
	BulletTrain            Emoji = "\U0001f685"       // bullet train
	Train                  Emoji = "\U0001f686"       // train
	Metro                  Emoji = "\U0001f687"       // metro
	LightRail              Emoji = "\U0001f688"       // light rail
	Station                Emoji = "\U0001f689"       // station
	Tram                   Emoji = "\U0001f68a"       // tram
	Monorail               Emoji = "\U0001f69d"       // monorail
	MountainRailway        Emoji = "\U0001f69e"       // mountain railway
	TramCar                Emoji = "\U0001f68b"       // tram car
	Bus                    Emoji = "\U0001f68c"       // bus
	OncomingBus            Emoji = "\U0001f68d"       // oncoming bus
	Trolleybus             Emoji = "\U0001f68e"       // trolleybus
	Minibus                Emoji = "\U0001f690"       // minibus
	Ambulance              Emoji = "\U0001f691"       // ambulance
	FireEngine             Emoji = "\U0001f692"       // fire engine
	PoliceCar              Emoji = "\U0001f693"       // police car
	OncomingPoliceCar      Emoji = "\U0001f694"       // oncoming police car
	Taxi                   Emoji = "\U0001f695"       // taxi
	OncomingTaxi           Emoji = "\U0001f696"       // oncoming taxi
	Automobile             Emoji = "\U0001f697"       // automobile
	OncomingAutomobile     Emoji = "\U0001f698"       // oncoming automobile
	SportUtilityVehicle    Emoji = "\U0001f699"       // sport utility vehicle
	PickupTruck            Emoji = "\U0001f6fb"       // pickup truck
	DeliveryTruck          Emoji = "\U0001f69a"       // delivery truck
	ArticulatedLorry       Emoji = "\U0001f69b"       // articulated lorry
	Tractor                Emoji = "\U0001f69c"       // tractor
	RacingCar              Emoji = "\U0001f3ce\ufe0f" // racing car
	Motorcycle             Emoji = "\U0001f3cd\ufe0f" // motorcycle
	MotorScooter           Emoji = "\U0001f6f5"       // motor scooter
	ManualWheelchair       Emoji = "\U0001f9bd"       // manual wheelchair
	MotorizedWheelchair    Emoji = "\U0001f9bc"       // motorized wheelchair
	AutoRickshaw           Emoji = "\U0001f6fa"       // auto rickshaw
	Bicycle                Emoji = "\U0001f6b2"       // bicycle
	KickScooter            Emoji = "\U0001f6f4"       // kick scooter
	Skateboard             Emoji = "\U0001f6f9"       // skateboard
	RollerSkate            Emoji = "\U0001f6fc"       // roller skate
	BusStop                Emoji = "\U0001f68f"       // bus stop
	Motorway               Emoji = "\U0001f6e3\ufe0f" // motorway
	RailwayTrack           Emoji = "\U0001f6e4\ufe0f" // railway track
	OilDrum                Emoji = "\U0001f6e2\ufe0f" // oil drum
	FuelPump               Emoji = "\u26fd"           // fuel pump
	PoliceCarLight         Emoji = "\U0001f6a8"       // police car light
	HorizontalTrafficLight Emoji = "\U0001f6a5"       // horizontal traffic light
	VerticalTrafficLight   Emoji = "\U0001f6a6"       // vertical traffic light
	StopSign               Emoji = "\U0001f6d1"       // stop sign
	Construction           Emoji = "\U0001f6a7"       // construction
	// SUBGROUP: transport-water
	Anchor        Emoji = "\u2693"           // anchor
	Sailboat      Emoji = "\u26f5"           // sailboat
	Canoe         Emoji = "\U0001f6f6"       // canoe
	Speedboat     Emoji = "\U0001f6a4"       // speedboat
	PassengerShip Emoji = "\U0001f6f3\ufe0f" // passenger ship
	Ferry         Emoji = "\u26f4\ufe0f"     // ferry
	MotorBoat     Emoji = "\U0001f6e5\ufe0f" // motor boat
	Ship          Emoji = "\U0001f6a2"       // ship
	// SUBGROUP: transport-air
	Airplane          Emoji = "\u2708\ufe0f"     // airplane
	SmallAirplane     Emoji = "\U0001f6e9\ufe0f" // small airplane
	AirplaneDeparture Emoji = "\U0001f6eb"       // airplane departure
	AirplaneArrival   Emoji = "\U0001f6ec"       // airplane arrival
	Parachute         Emoji = "\U0001fa82"       // parachute
	Seat              Emoji = "\U0001f4ba"       // seat
	Helicopter        Emoji = "\U0001f681"       // helicopter
	SuspensionRailway Emoji = "\U0001f69f"       // suspension railway
	MountainCableway  Emoji = "\U0001f6a0"       // mountain cableway
	AerialTramway     Emoji = "\U0001f6a1"       // aerial tramway
	Satellite         Emoji = "\U0001f6f0\ufe0f" // satellite
	Rocket            Emoji = "\U0001f680"       // rocket
	FlyingSaucer      Emoji = "\U0001f6f8"       // flying saucer
	// SUBGROUP: hotel
	BellhopBell Emoji = "\U0001f6ce\ufe0f" // bellhop bell
	Luggage     Emoji = "\U0001f9f3"       // luggage
	// SUBGROUP: time
	HourglassDone    Emoji = "\u231b"           // hourglass done
	HourglassNotDone Emoji = "\u23f3"           // hourglass not done
	Watch            Emoji = "\u231a"           // watch
	AlarmClock       Emoji = "\u23f0"           // alarm clock
	Stopwatch        Emoji = "\u23f1\ufe0f"     // stopwatch
	TimerClock       Emoji = "\u23f2\ufe0f"     // timer clock
	MantelpieceClock Emoji = "\U0001f570\ufe0f" // mantelpiece clock
	TwelveOClock     Emoji = "\U0001f55b"       // twelve o’clock
	TwelveThirty     Emoji = "\U0001f567"       // twelve-thirty
	OneOClock        Emoji = "\U0001f550"       // one o’clock
	OneThirty        Emoji = "\U0001f55c"       // one-thirty
	TwoOClock        Emoji = "\U0001f551"       // two o’clock
	TwoThirty        Emoji = "\U0001f55d"       // two-thirty
	ThreeOClock      Emoji = "\U0001f552"       // three o’clock
	ThreeThirty      Emoji = "\U0001f55e"       // three-thirty
	FourOClock       Emoji = "\U0001f553"       // four o’clock
	FourThirty       Emoji = "\U0001f55f"       // four-thirty
	FiveOClock       Emoji = "\U0001f554"       // five o’clock
	FiveThirty       Emoji = "\U0001f560"       // five-thirty
	SixOClock        Emoji = "\U0001f555"       // six o’clock
	SixThirty        Emoji = "\U0001f561"       // six-thirty
	SevenOClock      Emoji = "\U0001f556"       // seven o’clock
	SevenThirty      Emoji = "\U0001f562"       // seven-thirty
	EightOClock      Emoji = "\U0001f557"       // eight o’clock
	EightThirty      Emoji = "\U0001f563"       // eight-thirty
	NineOClock       Emoji = "\U0001f558"       // nine o’clock
	NineThirty       Emoji = "\U0001f564"       // nine-thirty
	TenOClock        Emoji = "\U0001f559"       // ten o’clock
	TenThirty        Emoji = "\U0001f565"       // ten-thirty
	ElevenOClock     Emoji = "\U0001f55a"       // eleven o’clock
	ElevenThirty     Emoji = "\U0001f566"       // eleven-thirty
	// SUBGROUP: sky & weather
	NewMoon                   Emoji = "\U0001f311"       // new moon
	WaxingCrescentMoon        Emoji = "\U0001f312"       // waxing crescent moon
	FirstQuarterMoon          Emoji = "\U0001f313"       // first quarter moon
	WaxingGibbousMoon         Emoji = "\U0001f314"       // waxing gibbous moon
	FullMoon                  Emoji = "\U0001f315"       // full moon
	WaningGibbousMoon         Emoji = "\U0001f316"       // waning gibbous moon
	LastQuarterMoon           Emoji = "\U0001f317"       // last quarter moon
	WaningCrescentMoon        Emoji = "\U0001f318"       // waning crescent moon
	CrescentMoon              Emoji = "\U0001f319"       // crescent moon
	NewMoonFace               Emoji = "\U0001f31a"       // new moon face
	FirstQuarterMoonFace      Emoji = "\U0001f31b"       // first quarter moon face
	LastQuarterMoonFace       Emoji = "\U0001f31c"       // last quarter moon face
	Thermometer               Emoji = "\U0001f321\ufe0f" // thermometer
	Sun                       Emoji = "\u2600\ufe0f"     // sun
	FullMoonFace              Emoji = "\U0001f31d"       // full moon face
	SunWithFace               Emoji = "\U0001f31e"       // sun with face
	RingedPlanet              Emoji = "\U0001fa90"       // ringed planet
	Star                      Emoji = "\u2b50"           // star
	GlowingStar               Emoji = "\U0001f31f"       // glowing star
	ShootingStar              Emoji = "\U0001f320"       // shooting star
	MilkyWay                  Emoji = "\U0001f30c"       // milky way
	Cloud                     Emoji = "\u2601\ufe0f"     // cloud
	SunBehindCloud            Emoji = "\u26c5"           // sun behind cloud
	CloudWithLightningAndRain Emoji = "\u26c8\ufe0f"     // cloud with lightning and rain
	SunBehindSmallCloud       Emoji = "\U0001f324\ufe0f" // sun behind small cloud
	SunBehindLargeCloud       Emoji = "\U0001f325\ufe0f" // sun behind large cloud
	SunBehindRainCloud        Emoji = "\U0001f326\ufe0f" // sun behind rain cloud
	CloudWithRain             Emoji = "\U0001f327\ufe0f" // cloud with rain
	CloudWithSnow             Emoji = "\U0001f328\ufe0f" // cloud with snow
	CloudWithLightning        Emoji = "\U0001f329\ufe0f" // cloud with lightning
	Tornado                   Emoji = "\U0001f32a\ufe0f" // tornado
	Fog                       Emoji = "\U0001f32b\ufe0f" // fog
	WindFace                  Emoji = "\U0001f32c\ufe0f" // wind face
	Cyclone                   Emoji = "\U0001f300"       // cyclone
	Rainbow                   Emoji = "\U0001f308"       // rainbow
	ClosedUmbrella            Emoji = "\U0001f302"       // closed umbrella
	Umbrella                  Emoji = "\u2602\ufe0f"     // umbrella
	UmbrellaWithRainDrops     Emoji = "\u2614"           // umbrella with rain drops
	UmbrellaOnGround          Emoji = "\u26f1\ufe0f"     // umbrella on ground
	HighVoltage               Emoji = "\u26a1"           // high voltage
	Snowflake                 Emoji = "\u2744\ufe0f"     // snowflake
	Snowman                   Emoji = "\u2603\ufe0f"     // snowman
	SnowmanWithoutSnow        Emoji = "\u26c4"           // snowman without snow
	Comet                     Emoji = "\u2604\ufe0f"     // comet
	Fire                      Emoji = "\U0001f525"       // fire
	Droplet                   Emoji = "\U0001f4a7"       // droplet
	WaterWave                 Emoji = "\U0001f30a"       // water wave

	// GROUP: Activities
	// SUBGROUP: event
	JackOLantern        Emoji = "\U0001f383"       // jack-o-lantern
	ChristmasTree       Emoji = "\U0001f384"       // Christmas tree
	Fireworks           Emoji = "\U0001f386"       // fireworks
	Sparkler            Emoji = "\U0001f387"       // sparkler
	Firecracker         Emoji = "\U0001f9e8"       // firecracker
	Sparkles            Emoji = "\u2728"           // sparkles
	Balloon             Emoji = "\U0001f388"       // balloon
	PartyPopper         Emoji = "\U0001f389"       // party popper
	ConfettiBall        Emoji = "\U0001f38a"       // confetti ball
	TanabataTree        Emoji = "\U0001f38b"       // tanabata tree
	PineDecoration      Emoji = "\U0001f38d"       // pine decoration
	JapaneseDolls       Emoji = "\U0001f38e"       // Japanese dolls
	CarpStreamer        Emoji = "\U0001f38f"       // carp streamer
	WindChime           Emoji = "\U0001f390"       // wind chime
	MoonViewingCeremony Emoji = "\U0001f391"       // moon viewing ceremony
	RedEnvelope         Emoji = "\U0001f9e7"       // red envelope
	Ribbon              Emoji = "\U0001f380"       // ribbon
	WrappedGift         Emoji = "\U0001f381"       // wrapped gift
	ReminderRibbon      Emoji = "\U0001f397\ufe0f" // reminder ribbon
	AdmissionTickets    Emoji = "\U0001f39f\ufe0f" // admission tickets
	Ticket              Emoji = "\U0001f3ab"       // ticket
	// SUBGROUP: award-medal
	MilitaryMedal    Emoji = "\U0001f396\ufe0f" // military medal
	Trophy           Emoji = "\U0001f3c6"       // trophy
	SportsMedal      Emoji = "\U0001f3c5"       // sports medal
	FirstPlaceMedal  Emoji = "\U0001f947"       // 1st place medal
	SecondPlaceMedal Emoji = "\U0001f948"       // 2nd place medal
	ThirdPlaceMedal  Emoji = "\U0001f949"       // 3rd place medal
	// SUBGROUP: sport
	SoccerBall         Emoji = "\u26bd"       // soccer ball
	Baseball           Emoji = "\u26be"       // baseball
	Softball           Emoji = "\U0001f94e"   // softball
	Basketball         Emoji = "\U0001f3c0"   // basketball
	Volleyball         Emoji = "\U0001f3d0"   // volleyball
	AmericanFootball   Emoji = "\U0001f3c8"   // american football
	RugbyFootball      Emoji = "\U0001f3c9"   // rugby football
	Tennis             Emoji = "\U0001f3be"   // tennis
	FlyingDisc         Emoji = "\U0001f94f"   // flying disc
	Bowling            Emoji = "\U0001f3b3"   // bowling
	CricketGame        Emoji = "\U0001f3cf"   // cricket game
	FieldHockey        Emoji = "\U0001f3d1"   // field hockey
	IceHockey          Emoji = "\U0001f3d2"   // ice hockey
	Lacrosse           Emoji = "\U0001f94d"   // lacrosse
	PingPong           Emoji = "\U0001f3d3"   // ping pong
	Badminton          Emoji = "\U0001f3f8"   // badminton
	BoxingGlove        Emoji = "\U0001f94a"   // boxing glove
	MartialArtsUniform Emoji = "\U0001f94b"   // martial arts uniform
	GoalNet            Emoji = "\U0001f945"   // goal net
	FlagInHole         Emoji = "\u26f3"       // flag in hole
	IceSkate           Emoji = "\u26f8\ufe0f" // ice skate
	FishingPole        Emoji = "\U0001f3a3"   // fishing pole
	DivingMask         Emoji = "\U0001f93f"   // diving mask
	RunningShirt       Emoji = "\U0001f3bd"   // running shirt
	Skis               Emoji = "\U0001f3bf"   // skis
	Sled               Emoji = "\U0001f6f7"   // sled
	CurlingStone       Emoji = "\U0001f94c"   // curling stone
	// SUBGROUP: game
	DirectHit          Emoji = "\U0001f3af"       // direct hit
	YoYo               Emoji = "\U0001fa80"       // yo-yo
	Kite               Emoji = "\U0001fa81"       // kite
	Pool8Ball          Emoji = "\U0001f3b1"       // pool 8 ball
	CrystalBall        Emoji = "\U0001f52e"       // crystal ball
	MagicWand          Emoji = "\U0001fa84"       // magic wand
	NazarAmulet        Emoji = "\U0001f9ff"       // nazar amulet
	VideoGame          Emoji = "\U0001f3ae"       // video game
	Joystick           Emoji = "\U0001f579\ufe0f" // joystick
	SlotMachine        Emoji = "\U0001f3b0"       // slot machine
	GameDie            Emoji = "\U0001f3b2"       // game die
	PuzzlePiece        Emoji = "\U0001f9e9"       // puzzle piece
	TeddyBear          Emoji = "\U0001f9f8"       // teddy bear
	Pinata             Emoji = "\U0001fa85"       // piñata
	NestingDolls       Emoji = "\U0001fa86"       // nesting dolls
	SpadeSuit          Emoji = "\u2660\ufe0f"     // spade suit
	HeartSuit          Emoji = "\u2665\ufe0f"     // heart suit
	DiamondSuit        Emoji = "\u2666\ufe0f"     // diamond suit
	ClubSuit           Emoji = "\u2663\ufe0f"     // club suit
	ChessPawn          Emoji = "\u265f\ufe0f"     // chess pawn
	Joker              Emoji = "\U0001f0cf"       // joker
	MahjongRedDragon   Emoji = "\U0001f004"       // mahjong red dragon
	FlowerPlayingCards Emoji = "\U0001f3b4"       // flower playing cards
	// SUBGROUP: arts & crafts
	PerformingArts Emoji = "\U0001f3ad"       // performing arts
	FramedPicture  Emoji = "\U0001f5bc\ufe0f" // framed picture
	ArtistPalette  Emoji = "\U0001f3a8"       // artist palette
	Thread         Emoji = "\U0001f9f5"       // thread
	SewingNeedle   Emoji = "\U0001faa1"       // sewing needle
	Yarn           Emoji = "\U0001f9f6"       // yarn
	Knot           Emoji = "\U0001faa2"       // knot

	// GROUP: Objects
	// SUBGROUP: clothing
	Glasses             Emoji = "\U0001f453"       // glasses
	Sunglasses          Emoji = "\U0001f576\ufe0f" // sunglasses
	Goggles             Emoji = "\U0001f97d"       // goggles
	LabCoat             Emoji = "\U0001f97c"       // lab coat
	SafetyVest          Emoji = "\U0001f9ba"       // safety vest
	Necktie             Emoji = "\U0001f454"       // necktie
	TShirt              Emoji = "\U0001f455"       // t-shirt
	Jeans               Emoji = "\U0001f456"       // jeans
	Scarf               Emoji = "\U0001f9e3"       // scarf
	Gloves              Emoji = "\U0001f9e4"       // gloves
	Coat                Emoji = "\U0001f9e5"       // coat
	Socks               Emoji = "\U0001f9e6"       // socks
	Dress               Emoji = "\U0001f457"       // dress
	Kimono              Emoji = "\U0001f458"       // kimono
	Sari                Emoji = "\U0001f97b"       // sari
	OnePieceSwimsuit    Emoji = "\U0001fa71"       // one-piece swimsuit
	Briefs              Emoji = "\U0001fa72"       // briefs
	Shorts              Emoji = "\U0001fa73"       // shorts
	Bikini              Emoji = "\U0001f459"       // bikini
	WomanSClothes       Emoji = "\U0001f45a"       // woman’s clothes
	Purse               Emoji = "\U0001f45b"       // purse
	Handbag             Emoji = "\U0001f45c"       // handbag
	ClutchBag           Emoji = "\U0001f45d"       // clutch bag
	ShoppingBags        Emoji = "\U0001f6cd\ufe0f" // shopping bags
	Backpack            Emoji = "\U0001f392"       // backpack
	ThongSandal         Emoji = "\U0001fa74"       // thong sandal
	ManSShoe            Emoji = "\U0001f45e"       // man’s shoe
	RunningShoe         Emoji = "\U0001f45f"       // running shoe
	HikingBoot          Emoji = "\U0001f97e"       // hiking boot
	FlatShoe            Emoji = "\U0001f97f"       // flat shoe
	HighHeeledShoe      Emoji = "\U0001f460"       // high-heeled shoe
	WomanSSandal        Emoji = "\U0001f461"       // woman’s sandal
	BalletShoes         Emoji = "\U0001fa70"       // ballet shoes
	WomanSBoot          Emoji = "\U0001f462"       // woman’s boot
	Crown               Emoji = "\U0001f451"       // crown
	WomanSHat           Emoji = "\U0001f452"       // woman’s hat
	TopHat              Emoji = "\U0001f3a9"       // top hat
	GraduationCap       Emoji = "\U0001f393"       // graduation cap
	BilledCap           Emoji = "\U0001f9e2"       // billed cap
	MilitaryHelmet      Emoji = "\U0001fa96"       // military helmet
	RescueWorkerSHelmet Emoji = "\u26d1\ufe0f"     // rescue worker’s helmet
	PrayerBeads         Emoji = "\U0001f4ff"       // prayer beads
	Lipstick            Emoji = "\U0001f484"       // lipstick
	Ring                Emoji = "\U0001f48d"       // ring
	GemStone            Emoji = "\U0001f48e"       // gem stone
	// SUBGROUP: sound
	MutedSpeaker        Emoji = "\U0001f507" // muted speaker
	SpeakerLowVolume    Emoji = "\U0001f508" // speaker low volume
	SpeakerMediumVolume Emoji = "\U0001f509" // speaker medium volume
	SpeakerHighVolume   Emoji = "\U0001f50a" // speaker high volume
	Loudspeaker         Emoji = "\U0001f4e2" // loudspeaker
	Megaphone           Emoji = "\U0001f4e3" // megaphone
	PostalHorn          Emoji = "\U0001f4ef" // postal horn
	Bell                Emoji = "\U0001f514" // bell
	BellWithSlash       Emoji = "\U0001f515" // bell with slash
	// SUBGROUP: music
	MusicalScore     Emoji = "\U0001f3bc"       // musical score
	MusicalNote      Emoji = "\U0001f3b5"       // musical note
	MusicalNotes     Emoji = "\U0001f3b6"       // musical notes
	StudioMicrophone Emoji = "\U0001f399\ufe0f" // studio microphone
	LevelSlider      Emoji = "\U0001f39a\ufe0f" // level slider
	ControlKnobs     Emoji = "\U0001f39b\ufe0f" // control knobs
	Microphone       Emoji = "\U0001f3a4"       // microphone
	Headphone        Emoji = "\U0001f3a7"       // headphone
	Radio            Emoji = "\U0001f4fb"       // radio
	// SUBGROUP: musical-instrument
	Saxophone       Emoji = "\U0001f3b7" // saxophone
	Accordion       Emoji = "\U0001fa97" // accordion
	Guitar          Emoji = "\U0001f3b8" // guitar
	MusicalKeyboard Emoji = "\U0001f3b9" // musical keyboard
	Trumpet         Emoji = "\U0001f3ba" // trumpet
	Violin          Emoji = "\U0001f3bb" // violin
	Banjo           Emoji = "\U0001fa95" // banjo
	Drum            Emoji = "\U0001f941" // drum
	LongDrum        Emoji = "\U0001fa98" // long drum
	// SUBGROUP: phone
	MobilePhone          Emoji = "\U0001f4f1"   // mobile phone
	MobilePhoneWithArrow Emoji = "\U0001f4f2"   // mobile phone with arrow
	Telephone            Emoji = "\u260e\ufe0f" // telephone
	TelephoneReceiver    Emoji = "\U0001f4de"   // telephone receiver
	Pager                Emoji = "\U0001f4df"   // pager
	FaxMachine           Emoji = "\U0001f4e0"   // fax machine
	// SUBGROUP: computer
	Battery         Emoji = "\U0001f50b"       // battery
	ElectricPlug    Emoji = "\U0001f50c"       // electric plug
	Laptop          Emoji = "\U0001f4bb"       // laptop
	DesktopComputer Emoji = "\U0001f5a5\ufe0f" // desktop computer
	Printer         Emoji = "\U0001f5a8\ufe0f" // printer
	Keyboard        Emoji = "\u2328\ufe0f"     // keyboard
	ComputerMouse   Emoji = "\U0001f5b1\ufe0f" // computer mouse
	Trackball       Emoji = "\U0001f5b2\ufe0f" // trackball
	ComputerDisk    Emoji = "\U0001f4bd"       // computer disk
	FloppyDisk      Emoji = "\U0001f4be"       // floppy disk
	OpticalDisk     Emoji = "\U0001f4bf"       // optical disk
	Dvd             Emoji = "\U0001f4c0"       // dvd
	Abacus          Emoji = "\U0001f9ee"       // abacus
	// SUBGROUP: light & video
	MovieCamera                Emoji = "\U0001f3a5"       // movie camera
	FilmFrames                 Emoji = "\U0001f39e\ufe0f" // film frames
	FilmProjector              Emoji = "\U0001f4fd\ufe0f" // film projector
	ClapperBoard               Emoji = "\U0001f3ac"       // clapper board
	Television                 Emoji = "\U0001f4fa"       // television
	Camera                     Emoji = "\U0001f4f7"       // camera
	CameraWithFlash            Emoji = "\U0001f4f8"       // camera with flash
	VideoCamera                Emoji = "\U0001f4f9"       // video camera
	Videocassette              Emoji = "\U0001f4fc"       // videocassette
	MagnifyingGlassTiltedLeft  Emoji = "\U0001f50d"       // magnifying glass tilted left
	MagnifyingGlassTiltedRight Emoji = "\U0001f50e"       // magnifying glass tilted right
	Candle                     Emoji = "\U0001f56f\ufe0f" // candle
	LightBulb                  Emoji = "\U0001f4a1"       // light bulb
	Flashlight                 Emoji = "\U0001f526"       // flashlight
	RedPaperLantern            Emoji = "\U0001f3ee"       // red paper lantern
	DiyaLamp                   Emoji = "\U0001fa94"       // diya lamp
	// SUBGROUP: book-paper
	NotebookWithDecorativeCover Emoji = "\U0001f4d4"       // notebook with decorative cover
	ClosedBook                  Emoji = "\U0001f4d5"       // closed book
	OpenBook                    Emoji = "\U0001f4d6"       // open book
	GreenBook                   Emoji = "\U0001f4d7"       // green book
	BlueBook                    Emoji = "\U0001f4d8"       // blue book
	OrangeBook                  Emoji = "\U0001f4d9"       // orange book
	Books                       Emoji = "\U0001f4da"       // books
	Notebook                    Emoji = "\U0001f4d3"       // notebook
	Ledger                      Emoji = "\U0001f4d2"       // ledger
	PageWithCurl                Emoji = "\U0001f4c3"       // page with curl
	Scroll                      Emoji = "\U0001f4dc"       // scroll
	PageFacingUp                Emoji = "\U0001f4c4"       // page facing up
	Newspaper                   Emoji = "\U0001f4f0"       // newspaper
	RolledUpNewspaper           Emoji = "\U0001f5de\ufe0f" // rolled-up newspaper
	BookmarkTabs                Emoji = "\U0001f4d1"       // bookmark tabs
	Bookmark                    Emoji = "\U0001f516"       // bookmark
	Label                       Emoji = "\U0001f3f7\ufe0f" // label
	// SUBGROUP: money
	MoneyBag               Emoji = "\U0001f4b0" // money bag
	Coin                   Emoji = "\U0001fa99" // coin
	YenBanknote            Emoji = "\U0001f4b4" // yen banknote
	DollarBanknote         Emoji = "\U0001f4b5" // dollar banknote
	EuroBanknote           Emoji = "\U0001f4b6" // euro banknote
	PoundBanknote          Emoji = "\U0001f4b7" // pound banknote
	MoneyWithWings         Emoji = "\U0001f4b8" // money with wings
	CreditCard             Emoji = "\U0001f4b3" // credit card
	Receipt                Emoji = "\U0001f9fe" // receipt
	ChartIncreasingWithYen Emoji = "\U0001f4b9" // chart increasing with yen
	// SUBGROUP: mail
	Envelope                     Emoji = "\u2709\ufe0f"     // envelope
	EMail                        Emoji = "\U0001f4e7"       // e-mail
	IncomingEnvelope             Emoji = "\U0001f4e8"       // incoming envelope
	EnvelopeWithArrow            Emoji = "\U0001f4e9"       // envelope with arrow
	OutboxTray                   Emoji = "\U0001f4e4"       // outbox tray
	InboxTray                    Emoji = "\U0001f4e5"       // inbox tray
	Package                      Emoji = "\U0001f4e6"       // package
	ClosedMailboxWithRaisedFlag  Emoji = "\U0001f4eb"       // closed mailbox with raised flag
	ClosedMailboxWithLoweredFlag Emoji = "\U0001f4ea"       // closed mailbox with lowered flag
	OpenMailboxWithRaisedFlag    Emoji = "\U0001f4ec"       // open mailbox with raised flag
	OpenMailboxWithLoweredFlag   Emoji = "\U0001f4ed"       // open mailbox with lowered flag
	Postbox                      Emoji = "\U0001f4ee"       // postbox
	BallotBoxWithBallot          Emoji = "\U0001f5f3\ufe0f" // ballot box with ballot
	// SUBGROUP: writing
	Pencil      Emoji = "\u270f\ufe0f"     // pencil
	BlackNib    Emoji = "\u2712\ufe0f"     // black nib
	FountainPen Emoji = "\U0001f58b\ufe0f" // fountain pen
	Pen         Emoji = "\U0001f58a\ufe0f" // pen
	Paintbrush  Emoji = "\U0001f58c\ufe0f" // paintbrush
	Crayon      Emoji = "\U0001f58d\ufe0f" // crayon
	Memo        Emoji = "\U0001f4dd"       // memo
	// SUBGROUP: office
	Briefcase         Emoji = "\U0001f4bc"       // briefcase
	FileFolder        Emoji = "\U0001f4c1"       // file folder
	OpenFileFolder    Emoji = "\U0001f4c2"       // open file folder
	CardIndexDividers Emoji = "\U0001f5c2\ufe0f" // card index dividers
	Calendar          Emoji = "\U0001f4c5"       // calendar
	TearOffCalendar   Emoji = "\U0001f4c6"       // tear-off calendar
	SpiralNotepad     Emoji = "\U0001f5d2\ufe0f" // spiral notepad
	SpiralCalendar    Emoji = "\U0001f5d3\ufe0f" // spiral calendar
	CardIndex         Emoji = "\U0001f4c7"       // card index
	ChartIncreasing   Emoji = "\U0001f4c8"       // chart increasing
	ChartDecreasing   Emoji = "\U0001f4c9"       // chart decreasing
	BarChart          Emoji = "\U0001f4ca"       // bar chart
	Clipboard         Emoji = "\U0001f4cb"       // clipboard
	Pushpin           Emoji = "\U0001f4cc"       // pushpin
	RoundPushpin      Emoji = "\U0001f4cd"       // round pushpin
	Paperclip         Emoji = "\U0001f4ce"       // paperclip
	LinkedPaperclips  Emoji = "\U0001f587\ufe0f" // linked paperclips
	StraightRuler     Emoji = "\U0001f4cf"       // straight ruler
	TriangularRuler   Emoji = "\U0001f4d0"       // triangular ruler
	Scissors          Emoji = "\u2702\ufe0f"     // scissors
	CardFileBox       Emoji = "\U0001f5c3\ufe0f" // card file box
	FileCabinet       Emoji = "\U0001f5c4\ufe0f" // file cabinet
	Wastebasket       Emoji = "\U0001f5d1\ufe0f" // wastebasket
	// SUBGROUP: lock
	Locked        Emoji = "\U0001f512"       // locked
	Unlocked      Emoji = "\U0001f513"       // unlocked
	LockedWithPen Emoji = "\U0001f50f"       // locked with pen
	LockedWithKey Emoji = "\U0001f510"       // locked with key
	Key           Emoji = "\U0001f511"       // key
	OldKey        Emoji = "\U0001f5dd\ufe0f" // old key
	// SUBGROUP: tool
	Hammer          Emoji = "\U0001f528"       // hammer
	Axe             Emoji = "\U0001fa93"       // axe
	Pick            Emoji = "\u26cf\ufe0f"     // pick
	HammerAndPick   Emoji = "\u2692\ufe0f"     // hammer and pick
	HammerAndWrench Emoji = "\U0001f6e0\ufe0f" // hammer and wrench
	Dagger          Emoji = "\U0001f5e1\ufe0f" // dagger
	CrossedSwords   Emoji = "\u2694\ufe0f"     // crossed swords
	Pistol          Emoji = "\U0001f52b"       // pistol
	Boomerang       Emoji = "\U0001fa83"       // boomerang
	BowAndArrow     Emoji = "\U0001f3f9"       // bow and arrow
	Shield          Emoji = "\U0001f6e1\ufe0f" // shield
	CarpentrySaw    Emoji = "\U0001fa9a"       // carpentry saw
	Wrench          Emoji = "\U0001f527"       // wrench
	Screwdriver     Emoji = "\U0001fa9b"       // screwdriver
	NutAndBolt      Emoji = "\U0001f529"       // nut and bolt
	Gear            Emoji = "\u2699\ufe0f"     // gear
	Clamp           Emoji = "\U0001f5dc\ufe0f" // clamp
	BalanceScale    Emoji = "\u2696\ufe0f"     // balance scale
	WhiteCane       Emoji = "\U0001f9af"       // white cane
	Link            Emoji = "\U0001f517"       // link
	Chains          Emoji = "\u26d3\ufe0f"     // chains
	Hook            Emoji = "\U0001fa9d"       // hook
	Toolbox         Emoji = "\U0001f9f0"       // toolbox
	Magnet          Emoji = "\U0001f9f2"       // magnet
	Ladder          Emoji = "\U0001fa9c"       // ladder
	// SUBGROUP: science
	Alembic          Emoji = "\u2697\ufe0f" // alembic
	TestTube         Emoji = "\U0001f9ea"   // test tube
	PetriDish        Emoji = "\U0001f9eb"   // petri dish
	Dna              Emoji = "\U0001f9ec"   // dna
	Microscope       Emoji = "\U0001f52c"   // microscope
	Telescope        Emoji = "\U0001f52d"   // telescope
	SatelliteAntenna Emoji = "\U0001f4e1"   // satellite antenna
	// SUBGROUP: medical
	Syringe         Emoji = "\U0001f489" // syringe
	DropOfBlood     Emoji = "\U0001fa78" // drop of blood
	Pill            Emoji = "\U0001f48a" // pill
	AdhesiveBandage Emoji = "\U0001fa79" // adhesive bandage
	Stethoscope     Emoji = "\U0001fa7a" // stethoscope
	// SUBGROUP: household
	Door             Emoji = "\U0001f6aa"       // door
	Elevator         Emoji = "\U0001f6d7"       // elevator
	Mirror           Emoji = "\U0001fa9e"       // mirror
	Window           Emoji = "\U0001fa9f"       // window
	Bed              Emoji = "\U0001f6cf\ufe0f" // bed
	CouchAndLamp     Emoji = "\U0001f6cb\ufe0f" // couch and lamp
	Chair            Emoji = "\U0001fa91"       // chair
	Toilet           Emoji = "\U0001f6bd"       // toilet
	Plunger          Emoji = "\U0001faa0"       // plunger
	Shower           Emoji = "\U0001f6bf"       // shower
	Bathtub          Emoji = "\U0001f6c1"       // bathtub
	MouseTrap        Emoji = "\U0001faa4"       // mouse trap
	Razor            Emoji = "\U0001fa92"       // razor
	LotionBottle     Emoji = "\U0001f9f4"       // lotion bottle
	SafetyPin        Emoji = "\U0001f9f7"       // safety pin
	Broom            Emoji = "\U0001f9f9"       // broom
	Basket           Emoji = "\U0001f9fa"       // basket
	RollOfPaper      Emoji = "\U0001f9fb"       // roll of paper
	Bucket           Emoji = "\U0001faa3"       // bucket
	Soap             Emoji = "\U0001f9fc"       // soap
	Toothbrush       Emoji = "\U0001faa5"       // toothbrush
	Sponge           Emoji = "\U0001f9fd"       // sponge
	FireExtinguisher Emoji = "\U0001f9ef"       // fire extinguisher
	ShoppingCart     Emoji = "\U0001f6d2"       // shopping cart
	// SUBGROUP: other-object
	Cigarette  Emoji = "\U0001f6ac"   // cigarette
	Coffin     Emoji = "\u26b0\ufe0f" // coffin
	Headstone  Emoji = "\U0001faa6"   // headstone
	FuneralUrn Emoji = "\u26b1\ufe0f" // funeral urn
	Moai       Emoji = "\U0001f5ff"   // moai
	Placard    Emoji = "\U0001faa7"   // placard

	// GROUP: Symbols
	// SUBGROUP: transport-sign
	AtmSign          Emoji = "\U0001f3e7" // ATM sign
	LitterInBinSign  Emoji = "\U0001f6ae" // litter in bin sign
	PotableWater     Emoji = "\U0001f6b0" // potable water
	WheelchairSymbol Emoji = "\u267f"     // wheelchair symbol
	MenSRoom         Emoji = "\U0001f6b9" // men’s room
	WomenSRoom       Emoji = "\U0001f6ba" // women’s room
	Restroom         Emoji = "\U0001f6bb" // restroom
	BabySymbol       Emoji = "\U0001f6bc" // baby symbol
	WaterCloset      Emoji = "\U0001f6be" // water closet
	PassportControl  Emoji = "\U0001f6c2" // passport control
	Customs          Emoji = "\U0001f6c3" // customs
	BaggageClaim     Emoji = "\U0001f6c4" // baggage claim
	LeftLuggage      Emoji = "\U0001f6c5" // left luggage
	// SUBGROUP: warning
	Warning            Emoji = "\u26a0\ufe0f" // warning
	ChildrenCrossing   Emoji = "\U0001f6b8"   // children crossing
	NoEntry            Emoji = "\u26d4"       // no entry
	Prohibited         Emoji = "\U0001f6ab"   // prohibited
	NoBicycles         Emoji = "\U0001f6b3"   // no bicycles
	NoSmoking          Emoji = "\U0001f6ad"   // no smoking
	NoLittering        Emoji = "\U0001f6af"   // no littering
	NonPotableWater    Emoji = "\U0001f6b1"   // non-potable water
	NoPedestrians      Emoji = "\U0001f6b7"   // no pedestrians
	NoMobilePhones     Emoji = "\U0001f4f5"   // no mobile phones
	NoOneUnderEighteen Emoji = "\U0001f51e"   // no one under eighteen
	Radioactive        Emoji = "\u2622\ufe0f" // radioactive
	Biohazard          Emoji = "\u2623\ufe0f" // biohazard
	// SUBGROUP: arrow
	UpArrow                      Emoji = "\u2b06\ufe0f" // up arrow
	UpRightArrow                 Emoji = "\u2197\ufe0f" // up-right arrow
	RightArrow                   Emoji = "\u27a1\ufe0f" // right arrow
	DownRightArrow               Emoji = "\u2198\ufe0f" // down-right arrow
	DownArrow                    Emoji = "\u2b07\ufe0f" // down arrow
	DownLeftArrow                Emoji = "\u2199\ufe0f" // down-left arrow
	LeftArrow                    Emoji = "\u2b05\ufe0f" // left arrow
	UpLeftArrow                  Emoji = "\u2196\ufe0f" // up-left arrow
	UpDownArrow                  Emoji = "\u2195\ufe0f" // up-down arrow
	LeftRightArrow               Emoji = "\u2194\ufe0f" // left-right arrow
	RightArrowCurvingLeft        Emoji = "\u21a9\ufe0f" // right arrow curving left
	LeftArrowCurvingRight        Emoji = "\u21aa\ufe0f" // left arrow curving right
	RightArrowCurvingUp          Emoji = "\u2934\ufe0f" // right arrow curving up
	RightArrowCurvingDown        Emoji = "\u2935\ufe0f" // right arrow curving down
	ClockwiseVerticalArrows      Emoji = "\U0001f503"   // clockwise vertical arrows
	CounterclockwiseArrowsButton Emoji = "\U0001f504"   // counterclockwise arrows button
	BackArrow                    Emoji = "\U0001f519"   // BACK arrow
	EndArrow                     Emoji = "\U0001f51a"   // END arrow
	OnArrow                      Emoji = "\U0001f51b"   // ON! arrow
	SoonArrow                    Emoji = "\U0001f51c"   // SOON arrow
	TopArrow                     Emoji = "\U0001f51d"   // TOP arrow
	// SUBGROUP: religion
	PlaceOfWorship       Emoji = "\U0001f6d0"       // place of worship
	AtomSymbol           Emoji = "\u269b\ufe0f"     // atom symbol
	Om                   Emoji = "\U0001f549\ufe0f" // om
	StarOfDavid          Emoji = "\u2721\ufe0f"     // star of David
	WheelOfDharma        Emoji = "\u2638\ufe0f"     // wheel of dharma
	YinYang              Emoji = "\u262f\ufe0f"     // yin yang
	LatinCross           Emoji = "\u271d\ufe0f"     // latin cross
	OrthodoxCross        Emoji = "\u2626\ufe0f"     // orthodox cross
	StarAndCrescent      Emoji = "\u262a\ufe0f"     // star and crescent
	PeaceSymbol          Emoji = "\u262e\ufe0f"     // peace symbol
	Menorah              Emoji = "\U0001f54e"       // menorah
	DottedSixPointedStar Emoji = "\U0001f52f"       // dotted six-pointed star
	// SUBGROUP: zodiac
	Aries       Emoji = "\u2648" // Aries
	Taurus      Emoji = "\u2649" // Taurus
	Gemini      Emoji = "\u264a" // Gemini
	Cancer      Emoji = "\u264b" // Cancer
	Leo         Emoji = "\u264c" // Leo
	Virgo       Emoji = "\u264d" // Virgo
	Libra       Emoji = "\u264e" // Libra
	Scorpio     Emoji = "\u264f" // Scorpio
	Sagittarius Emoji = "\u2650" // Sagittarius
	Capricorn   Emoji = "\u2651" // Capricorn
	Aquarius    Emoji = "\u2652" // Aquarius
	Pisces      Emoji = "\u2653" // Pisces
	Ophiuchus   Emoji = "\u26ce" // Ophiuchus
	// SUBGROUP: av-symbol
	ShuffleTracksButton Emoji = "\U0001f500"   // shuffle tracks button
	RepeatButton        Emoji = "\U0001f501"   // repeat button
	RepeatSingleButton  Emoji = "\U0001f502"   // repeat single button
	PlayButton          Emoji = "\u25b6\ufe0f" // play button
	FastForwardButton   Emoji = "\u23e9"       // fast-forward button
	NextTrackButton     Emoji = "\u23ed\ufe0f" // next track button
	PlayOrPauseButton   Emoji = "\u23ef\ufe0f" // play or pause button
	ReverseButton       Emoji = "\u25c0\ufe0f" // reverse button
	FastReverseButton   Emoji = "\u23ea"       // fast reverse button
	LastTrackButton     Emoji = "\u23ee\ufe0f" // last track button
	UpwardsButton       Emoji = "\U0001f53c"   // upwards button
	FastUpButton        Emoji = "\u23eb"       // fast up button
	DownwardsButton     Emoji = "\U0001f53d"   // downwards button
	FastDownButton      Emoji = "\u23ec"       // fast down button
	PauseButton         Emoji = "\u23f8\ufe0f" // pause button
	StopButton          Emoji = "\u23f9\ufe0f" // stop button
	RecordButton        Emoji = "\u23fa\ufe0f" // record button
	EjectButton         Emoji = "\u23cf\ufe0f" // eject button
	Cinema              Emoji = "\U0001f3a6"   // cinema
	DimButton           Emoji = "\U0001f505"   // dim button
	BrightButton        Emoji = "\U0001f506"   // bright button
	AntennaBars         Emoji = "\U0001f4f6"   // antenna bars
	VibrationMode       Emoji = "\U0001f4f3"   // vibration mode
	MobilePhoneOff      Emoji = "\U0001f4f4"   // mobile phone off
	// SUBGROUP: gender
	FemaleSign        Emoji = "\u2640\ufe0f" // female sign
	MaleSign          Emoji = "\u2642\ufe0f" // male sign
	TransgenderSymbol Emoji = "\u26a7\ufe0f" // transgender symbol
	// SUBGROUP: math
	Multiply Emoji = "\u2716\ufe0f" // multiply
	Plus     Emoji = "\u2795"       // plus
	Minus    Emoji = "\u2796"       // minus
	Divide   Emoji = "\u2797"       // divide
	Infinity Emoji = "\u267e\ufe0f" // infinity
	// SUBGROUP: punctuation
	DoubleExclamationMark   Emoji = "\u203c\ufe0f" // double exclamation mark
	ExclamationQuestionMark Emoji = "\u2049\ufe0f" // exclamation question mark
	QuestionMark            Emoji = "\u2753"       // question mark
	WhiteQuestionMark       Emoji = "\u2754"       // white question mark
	WhiteExclamationMark    Emoji = "\u2755"       // white exclamation mark
	ExclamationMark         Emoji = "\u2757"       // exclamation mark
	WavyDash                Emoji = "\u3030\ufe0f" // wavy dash
	// SUBGROUP: currency
	CurrencyExchange Emoji = "\U0001f4b1" // currency exchange
	HeavyDollarSign  Emoji = "\U0001f4b2" // heavy dollar sign
	// SUBGROUP: other-symbol
	MedicalSymbol             Emoji = "\u2695\ufe0f" // medical symbol
	RecyclingSymbol           Emoji = "\u267b\ufe0f" // recycling symbol
	FleurDeLis                Emoji = "\u269c\ufe0f" // fleur-de-lis
	TridentEmblem             Emoji = "\U0001f531"   // trident emblem
	NameBadge                 Emoji = "\U0001f4db"   // name badge
	JapaneseSymbolForBeginner Emoji = "\U0001f530"   // Japanese symbol for beginner
	HollowRedCircle           Emoji = "\u2b55"       // hollow red circle
	CheckMarkButton           Emoji = "\u2705"       // check mark button
	CheckBoxWithCheck         Emoji = "\u2611\ufe0f" // check box with check
	CheckMark                 Emoji = "\u2714\ufe0f" // check mark
	CrossMark                 Emoji = "\u274c"       // cross mark
	CrossMarkButton           Emoji = "\u274e"       // cross mark button
	CurlyLoop                 Emoji = "\u27b0"       // curly loop
	DoubleCurlyLoop           Emoji = "\u27bf"       // double curly loop
	PartAlternationMark       Emoji = "\u303d\ufe0f" // part alternation mark
	EightSpokedAsterisk       Emoji = "\u2733\ufe0f" // eight-spoked asterisk
	EightPointedStar          Emoji = "\u2734\ufe0f" // eight-pointed star
	Sparkle                   Emoji = "\u2747\ufe0f" // sparkle
	Copyright                 Emoji = "\u00a9\ufe0f" // copyright
	Registered                Emoji = "\u00ae\ufe0f" // registered
	TradeMark                 Emoji = "\u2122\ufe0f" // trade mark
	// SUBGROUP: keycap
	KeycapHash     Emoji = "#\ufe0f\u20e3" // keycap: #
	KeycapAsterisk Emoji = "*\ufe0f\u20e3" // keycap: *
	Keycap0        Emoji = "0\ufe0f\u20e3" // keycap: 0
	Keycap1        Emoji = "1\ufe0f\u20e3" // keycap: 1
	Keycap2        Emoji = "2\ufe0f\u20e3" // keycap: 2
	Keycap3        Emoji = "3\ufe0f\u20e3" // keycap: 3
	Keycap4        Emoji = "4\ufe0f\u20e3" // keycap: 4
	Keycap5        Emoji = "5\ufe0f\u20e3" // keycap: 5
	Keycap6        Emoji = "6\ufe0f\u20e3" // keycap: 6
	Keycap7        Emoji = "7\ufe0f\u20e3" // keycap: 7
	Keycap8        Emoji = "8\ufe0f\u20e3" // keycap: 8
	Keycap9        Emoji = "9\ufe0f\u20e3" // keycap: 9
	Keycap10       Emoji = "\U0001f51f"    // keycap: 10
	// SUBGROUP: alphanum
	InputLatinUppercase           Emoji = "\U0001f520"       // input latin uppercase
	InputLatinLowercase           Emoji = "\U0001f521"       // input latin lowercase
	InputNumbers                  Emoji = "\U0001f522"       // input numbers
	InputSymbols                  Emoji = "\U0001f523"       // input symbols
	InputLatinLetters             Emoji = "\U0001f524"       // input latin letters
	AButtonBloodType              Emoji = "\U0001f170\ufe0f" // A button (blood type)
	AbButtonBloodType             Emoji = "\U0001f18e"       // AB button (blood type)
	BButtonBloodType              Emoji = "\U0001f171\ufe0f" // B button (blood type)
	ClButton                      Emoji = "\U0001f191"       // CL button
	CoolButton                    Emoji = "\U0001f192"       // COOL button
	FreeButton                    Emoji = "\U0001f193"       // FREE button
	Information                   Emoji = "\u2139\ufe0f"     // information
	IdButton                      Emoji = "\U0001f194"       // ID button
	CircledM                      Emoji = "\u24c2\ufe0f"     // circled M
	NewButton                     Emoji = "\U0001f195"       // NEW button
	NgButton                      Emoji = "\U0001f196"       // NG button
	OButtonBloodType              Emoji = "\U0001f17e\ufe0f" // O button (blood type)
	OkButton                      Emoji = "\U0001f197"       // OK button
	PButton                       Emoji = "\U0001f17f\ufe0f" // P button
	SosButton                     Emoji = "\U0001f198"       // SOS button
	UpButton                      Emoji = "\U0001f199"       // UP! button
	VsButton                      Emoji = "\U0001f19a"       // VS button
	JapaneseHereButton            Emoji = "\U0001f201"       // Japanese “here” button
	JapaneseServiceChargeButton   Emoji = "\U0001f202\ufe0f" // Japanese “service charge” button
	JapaneseMonthlyAmountButton   Emoji = "\U0001f237\ufe0f" // Japanese “monthly amount” button
	JapaneseNotFreeOfChargeButton Emoji = "\U0001f236"       // Japanese “not free of charge” button
	JapaneseReservedButton        Emoji = "\U0001f22f"       // Japanese “reserved” button
	JapaneseBargainButton         Emoji = "\U0001f250"       // Japanese “bargain” button
	JapaneseDiscountButton        Emoji = "\U0001f239"       // Japanese “discount” button
	JapaneseFreeOfChargeButton    Emoji = "\U0001f21a"       // Japanese “free of charge” button
	JapaneseProhibitedButton      Emoji = "\U0001f232"       // Japanese “prohibited” button
	JapaneseAcceptableButton      Emoji = "\U0001f251"       // Japanese “acceptable” button
	JapaneseApplicationButton     Emoji = "\U0001f238"       // Japanese “application” button
	JapanesePassingGradeButton    Emoji = "\U0001f234"       // Japanese “passing grade” button
	JapaneseVacancyButton         Emoji = "\U0001f233"       // Japanese “vacancy” button
	JapaneseCongratulationsButton Emoji = "\u3297\ufe0f"     // Japanese “congratulations” button
	JapaneseSecretButton          Emoji = "\u3299\ufe0f"     // Japanese “secret” button
	JapaneseOpenForBusinessButton Emoji = "\U0001f23a"       // Japanese “open for business” button
	JapaneseNoVacancyButton       Emoji = "\U0001f235"       // Japanese “no vacancy” button
	// SUBGROUP: geometric
	RedCircle              Emoji = "\U0001f534"   // red circle
	OrangeCircle           Emoji = "\U0001f7e0"   // orange circle
	YellowCircle           Emoji = "\U0001f7e1"   // yellow circle
	GreenCircle            Emoji = "\U0001f7e2"   // green circle
	BlueCircle             Emoji = "\U0001f535"   // blue circle
	PurpleCircle           Emoji = "\U0001f7e3"   // purple circle
	BrownCircle            Emoji = "\U0001f7e4"   // brown circle
	BlackCircle            Emoji = "\u26ab"       // black circle
	WhiteCircle            Emoji = "\u26aa"       // white circle
	RedSquare              Emoji = "\U0001f7e5"   // red square
	OrangeSquare           Emoji = "\U0001f7e7"   // orange square
	YellowSquare           Emoji = "\U0001f7e8"   // yellow square
	GreenSquare            Emoji = "\U0001f7e9"   // green square
	BlueSquare             Emoji = "\U0001f7e6"   // blue square
	PurpleSquare           Emoji = "\U0001f7ea"   // purple square
	BrownSquare            Emoji = "\U0001f7eb"   // brown square
	BlackLargeSquare       Emoji = "\u2b1b"       // black large square
	WhiteLargeSquare       Emoji = "\u2b1c"       // white large square
	BlackMediumSquare      Emoji = "\u25fc\ufe0f" // black medium square
	WhiteMediumSquare      Emoji = "\u25fb\ufe0f" // white medium square
	BlackMediumSmallSquare Emoji = "\u25fe"       // black medium-small square
	WhiteMediumSmallSquare Emoji = "\u25fd"       // white medium-small square
	BlackSmallSquare       Emoji = "\u25aa\ufe0f" // black small square
	WhiteSmallSquare       Emoji = "\u25ab\ufe0f" // white small square
	LargeOrangeDiamond     Emoji = "\U0001f536"   // large orange diamond
	LargeBlueDiamond       Emoji = "\U0001f537"   // large blue diamond
	SmallOrangeDiamond     Emoji = "\U0001f538"   // small orange diamond
	SmallBlueDiamond       Emoji = "\U0001f539"   // small blue diamond
	RedTrianglePointedUp   Emoji = "\U0001f53a"   // red triangle pointed up
	RedTrianglePointedDown Emoji = "\U0001f53b"   // red triangle pointed down
	DiamondWithADot        Emoji = "\U0001f4a0"   // diamond with a dot
	RadioButton            Emoji = "\U0001f518"   // radio button
	WhiteSquareButton      Emoji = "\U0001f533"   // white square button
	BlackSquareButton      Emoji = "\U0001f532"   // black square button

	// GROUP: Flags
	// SUBGROUP: flag
	ChequeredFlag   Emoji = "\U0001f3c1"                         // chequered flag
	TriangularFlag  Emoji = "\U0001f6a9"                         // triangular flag
	CrossedFlags    Emoji = "\U0001f38c"                         // crossed flags
	BlackFlag       Emoji = "\U0001f3f4"                         // black flag
	WhiteFlag       Emoji = "\U0001f3f3\ufe0f"                   // white flag
	RainbowFlag     Emoji = "\U0001f3f3\ufe0f\u200d\U0001f308"   // rainbow flag
	TransgenderFlag Emoji = "\U0001f3f3\ufe0f\u200d\u26a7\ufe0f" // transgender flag
	PirateFlag      Emoji = "\U0001f3f4\u200d\u2620\ufe0f"       // pirate flag
	// SUBGROUP: country-flag
	FlagForAscensionIsland                     Emoji = "\U0001f1e6\U0001f1e8" // flag: Ascension Island
	FlagForAndorra                             Emoji = "\U0001f1e6\U0001f1e9" // flag: Andorra
	FlagForUnitedArabEmirates                  Emoji = "\U0001f1e6\U0001f1ea" // flag: United Arab Emirates
	FlagForAfghanistan                         Emoji = "\U0001f1e6\U0001f1eb" // flag: Afghanistan
	FlagForAntiguaAndBarbuda                   Emoji = "\U0001f1e6\U0001f1ec" // flag: Antigua & Barbuda
	FlagForAnguilla                            Emoji = "\U0001f1e6\U0001f1ee" // flag: Anguilla
	FlagForAlbania                             Emoji = "\U0001f1e6\U0001f1f1" // flag: Albania
	FlagForArmenia                             Emoji = "\U0001f1e6\U0001f1f2" // flag: Armenia
	FlagForAngola                              Emoji = "\U0001f1e6\U0001f1f4" // flag: Angola
	FlagForAntarctica                          Emoji = "\U0001f1e6\U0001f1f6" // flag: Antarctica
	FlagForArgentina                           Emoji = "\U0001f1e6\U0001f1f7" // flag: Argentina
	FlagForAmericanSamoa                       Emoji = "\U0001f1e6\U0001f1f8" // flag: American Samoa
	FlagForAustria                             Emoji = "\U0001f1e6\U0001f1f9" // flag: Austria
	FlagForAustralia                           Emoji = "\U0001f1e6\U0001f1fa" // flag: Australia
	FlagForAruba                               Emoji = "\U0001f1e6\U0001f1fc" // flag: Aruba
	FlagForAlandIslands                        Emoji = "\U0001f1e6\U0001f1fd" // flag: Åland Islands
	FlagForAzerbaijan                          Emoji = "\U0001f1e6\U0001f1ff" // flag: Azerbaijan
	FlagForBosniaAndHerzegovina                Emoji = "\U0001f1e7\U0001f1e6" // flag: Bosnia & Herzegovina
	FlagForBarbados                            Emoji = "\U0001f1e7\U0001f1e7" // flag: Barbados
	FlagForBangladesh                          Emoji = "\U0001f1e7\U0001f1e9" // flag: Bangladesh
	FlagForBelgium                             Emoji = "\U0001f1e7\U0001f1ea" // flag: Belgium
	FlagForBurkinaFaso                         Emoji = "\U0001f1e7\U0001f1eb" // flag: Burkina Faso
	FlagForBulgaria                            Emoji = "\U0001f1e7\U0001f1ec" // flag: Bulgaria
	FlagForBahrain                             Emoji = "\U0001f1e7\U0001f1ed" // flag: Bahrain
	FlagForBurundi                             Emoji = "\U0001f1e7\U0001f1ee" // flag: Burundi
	FlagForBenin                               Emoji = "\U0001f1e7\U0001f1ef" // flag: Benin
	FlagForStBarthelemy                        Emoji = "\U0001f1e7\U0001f1f1" // flag: St. Barthélemy
	FlagForBermuda                             Emoji = "\U0001f1e7\U0001f1f2" // flag: Bermuda
	FlagForBrunei                              Emoji = "\U0001f1e7\U0001f1f3" // flag: Brunei
	FlagForBolivia                             Emoji = "\U0001f1e7\U0001f1f4" // flag: Bolivia
	FlagForCaribbeanNetherlands                Emoji = "\U0001f1e7\U0001f1f6" // flag: Caribbean Netherlands
	FlagForBrazil                              Emoji = "\U0001f1e7\U0001f1f7" // flag: Brazil
	FlagForBahamas                             Emoji = "\U0001f1e7\U0001f1f8" // flag: Bahamas
	FlagForBhutan                              Emoji = "\U0001f1e7\U0001f1f9" // flag: Bhutan
	FlagForBouvetIsland                        Emoji = "\U0001f1e7\U0001f1fb" // flag: Bouvet Island
	FlagForBotswana                            Emoji = "\U0001f1e7\U0001f1fc" // flag: Botswana
	FlagForBelarus                             Emoji = "\U0001f1e7\U0001f1fe" // flag: Belarus
	FlagForBelize                              Emoji = "\U0001f1e7\U0001f1ff" // flag: Belize
	FlagForCanada                              Emoji = "\U0001f1e8\U0001f1e6" // flag: Canada
	FlagForCocosKeelingIslands                 Emoji = "\U0001f1e8\U0001f1e8" // flag: Cocos (Keeling) Islands
	FlagForCongoKinshasa                       Emoji = "\U0001f1e8\U0001f1e9" // flag: Congo - Kinshasa
	FlagForCentralAfricanRepublic              Emoji = "\U0001f1e8\U0001f1eb" // flag: Central African Republic
	FlagForCongoBrazzaville                    Emoji = "\U0001f1e8\U0001f1ec" // flag: Congo - Brazzaville
	FlagForSwitzerland                         Emoji = "\U0001f1e8\U0001f1ed" // flag: Switzerland
	FlagForCoteDIvoire                         Emoji = "\U0001f1e8\U0001f1ee" // flag: Côte d’Ivoire
	FlagForCookIslands                         Emoji = "\U0001f1e8\U0001f1f0" // flag: Cook Islands
	FlagForChile                               Emoji = "\U0001f1e8\U0001f1f1" // flag: Chile
	FlagForCameroon                            Emoji = "\U0001f1e8\U0001f1f2" // flag: Cameroon
	FlagForChina                               Emoji = "\U0001f1e8\U0001f1f3" // flag: China
	FlagForColombia                            Emoji = "\U0001f1e8\U0001f1f4" // flag: Colombia
	FlagForClippertonIsland                    Emoji = "\U0001f1e8\U0001f1f5" // flag: Clipperton Island
	FlagForCostaRica                           Emoji = "\U0001f1e8\U0001f1f7" // flag: Costa Rica
	FlagForCuba                                Emoji = "\U0001f1e8\U0001f1fa" // flag: Cuba
	FlagForCapeVerde                           Emoji = "\U0001f1e8\U0001f1fb" // flag: Cape Verde
	FlagForCuracao                             Emoji = "\U0001f1e8\U0001f1fc" // flag: Curaçao
	FlagForChristmasIsland                     Emoji = "\U0001f1e8\U0001f1fd" // flag: Christmas Island
	FlagForCyprus                              Emoji = "\U0001f1e8\U0001f1fe" // flag: Cyprus
	FlagForCzechia                             Emoji = "\U0001f1e8\U0001f1ff" // flag: Czechia
	FlagForGermany                             Emoji = "\U0001f1e9\U0001f1ea" // flag: Germany
	FlagForDiegoGarcia                         Emoji = "\U0001f1e9\U0001f1ec" // flag: Diego Garcia
	FlagForDjibouti                            Emoji = "\U0001f1e9\U0001f1ef" // flag: Djibouti
	FlagForDenmark                             Emoji = "\U0001f1e9\U0001f1f0" // flag: Denmark
	FlagForDominica                            Emoji = "\U0001f1e9\U0001f1f2" // flag: Dominica
	FlagForDominicanRepublic                   Emoji = "\U0001f1e9\U0001f1f4" // flag: Dominican Republic
	FlagForAlgeria                             Emoji = "\U0001f1e9\U0001f1ff" // flag: Algeria
	FlagForCeutaAndMelilla                     Emoji = "\U0001f1ea\U0001f1e6" // flag: Ceuta & Melilla
	FlagForEcuador                             Emoji = "\U0001f1ea\U0001f1e8" // flag: Ecuador
	FlagForEstonia                             Emoji = "\U0001f1ea\U0001f1ea" // flag: Estonia
	FlagForEgypt                               Emoji = "\U0001f1ea\U0001f1ec" // flag: Egypt
	FlagForWesternSahara                       Emoji = "\U0001f1ea\U0001f1ed" // flag: Western Sahara
	FlagForEritrea                             Emoji = "\U0001f1ea\U0001f1f7" // flag: Eritrea
	FlagForSpain                               Emoji = "\U0001f1ea\U0001f1f8" // flag: Spain
	FlagForEthiopia                            Emoji = "\U0001f1ea\U0001f1f9" // flag: Ethiopia
	FlagForEuropeanUnion                       Emoji = "\U0001f1ea\U0001f1fa" // flag: European Union
	FlagForFinland                             Emoji = "\U0001f1eb\U0001f1ee" // flag: Finland
	FlagForFiji                                Emoji = "\U0001f1eb\U0001f1ef" // flag: Fiji
	FlagForFalklandIslands                     Emoji = "\U0001f1eb\U0001f1f0" // flag: Falkland Islands
	FlagForMicronesia                          Emoji = "\U0001f1eb\U0001f1f2" // flag: Micronesia
	FlagForFaroeIslands                        Emoji = "\U0001f1eb\U0001f1f4" // flag: Faroe Islands
	FlagForFrance                              Emoji = "\U0001f1eb\U0001f1f7" // flag: France
	FlagForGabon                               Emoji = "\U0001f1ec\U0001f1e6" // flag: Gabon
	FlagForUnitedKingdom                       Emoji = "\U0001f1ec\U0001f1e7" // flag: United Kingdom
	FlagForGrenada                             Emoji = "\U0001f1ec\U0001f1e9" // flag: Grenada
	FlagForGeorgia                             Emoji = "\U0001f1ec\U0001f1ea" // flag: Georgia
	FlagForFrenchGuiana                        Emoji = "\U0001f1ec\U0001f1eb" // flag: French Guiana
	FlagForGuernsey                            Emoji = "\U0001f1ec\U0001f1ec" // flag: Guernsey
	FlagForGhana                               Emoji = "\U0001f1ec\U0001f1ed" // flag: Ghana
	FlagForGibraltar                           Emoji = "\U0001f1ec\U0001f1ee" // flag: Gibraltar
	FlagForGreenland                           Emoji = "\U0001f1ec\U0001f1f1" // flag: Greenland
	FlagForGambia                              Emoji = "\U0001f1ec\U0001f1f2" // flag: Gambia
	FlagForGuinea                              Emoji = "\U0001f1ec\U0001f1f3" // flag: Guinea
	FlagForGuadeloupe                          Emoji = "\U0001f1ec\U0001f1f5" // flag: Guadeloupe
	FlagForEquatorialGuinea                    Emoji = "\U0001f1ec\U0001f1f6" // flag: Equatorial Guinea
	FlagForGreece                              Emoji = "\U0001f1ec\U0001f1f7" // flag: Greece
	FlagForSouthGeorgiaAndSouthSandwichIslands Emoji = "\U0001f1ec\U0001f1f8" // flag: South Georgia & South Sandwich Islands
	FlagForGuatemala                           Emoji = "\U0001f1ec\U0001f1f9" // flag: Guatemala
	FlagForGuam                                Emoji = "\U0001f1ec\U0001f1fa" // flag: Guam
	FlagForGuineaBissau                        Emoji = "\U0001f1ec\U0001f1fc" // flag: Guinea-Bissau
	FlagForGuyana                              Emoji = "\U0001f1ec\U0001f1fe" // flag: Guyana
	FlagForHongKongSarChina                    Emoji = "\U0001f1ed\U0001f1f0" // flag: Hong Kong SAR China
	FlagForHeardAndMcdonaldIslands             Emoji = "\U0001f1ed\U0001f1f2" // flag: Heard & McDonald Islands
	FlagForHonduras                            Emoji = "\U0001f1ed\U0001f1f3" // flag: Honduras
	FlagForCroatia                             Emoji = "\U0001f1ed\U0001f1f7" // flag: Croatia
	FlagForHaiti                               Emoji = "\U0001f1ed\U0001f1f9" // flag: Haiti
	FlagForHungary                             Emoji = "\U0001f1ed\U0001f1fa" // flag: Hungary
	FlagForCanaryIslands                       Emoji = "\U0001f1ee\U0001f1e8" // flag: Canary Islands
	FlagForIndonesia                           Emoji = "\U0001f1ee\U0001f1e9" // flag: Indonesia
	FlagForIreland                             Emoji = "\U0001f1ee\U0001f1ea" // flag: Ireland
	FlagForIsrael                              Emoji = "\U0001f1ee\U0001f1f1" // flag: Israel
	FlagForIsleOfMan                           Emoji = "\U0001f1ee\U0001f1f2" // flag: Isle of Man
	FlagForIndia                               Emoji = "\U0001f1ee\U0001f1f3" // flag: India
	FlagForBritishIndianOceanTerritory         Emoji = "\U0001f1ee\U0001f1f4" // flag: British Indian Ocean Territory
	FlagForIraq                                Emoji = "\U0001f1ee\U0001f1f6" // flag: Iraq
	FlagForIran                                Emoji = "\U0001f1ee\U0001f1f7" // flag: Iran
	FlagForIceland                             Emoji = "\U0001f1ee\U0001f1f8" // flag: Iceland
	FlagForItaly                               Emoji = "\U0001f1ee\U0001f1f9" // flag: Italy
	FlagForJersey                              Emoji = "\U0001f1ef\U0001f1ea" // flag: Jersey
	FlagForJamaica                             Emoji = "\U0001f1ef\U0001f1f2" // flag: Jamaica
	FlagForJordan                              Emoji = "\U0001f1ef\U0001f1f4" // flag: Jordan
	FlagForJapan                               Emoji = "\U0001f1ef\U0001f1f5" // flag: Japan
	FlagForKenya                               Emoji = "\U0001f1f0\U0001f1ea" // flag: Kenya
	FlagForKyrgyzstan                          Emoji = "\U0001f1f0\U0001f1ec" // flag: Kyrgyzstan
	FlagForCambodia                            Emoji = "\U0001f1f0\U0001f1ed" // flag: Cambodia
	FlagForKiribati                            Emoji = "\U0001f1f0\U0001f1ee" // flag: Kiribati
	FlagForComoros                             Emoji = "\U0001f1f0\U0001f1f2" // flag: Comoros
	FlagForStKittsAndNevis                     Emoji = "\U0001f1f0\U0001f1f3" // flag: St. Kitts & Nevis
	FlagForNorthKorea                          Emoji = "\U0001f1f0\U0001f1f5" // flag: North Korea
	FlagForSouthKorea                          Emoji = "\U0001f1f0\U0001f1f7" // flag: South Korea
	FlagForKuwait                              Emoji = "\U0001f1f0\U0001f1fc" // flag: Kuwait
	FlagForCaymanIslands                       Emoji = "\U0001f1f0\U0001f1fe" // flag: Cayman Islands
	FlagForKazakhstan                          Emoji = "\U0001f1f0\U0001f1ff" // flag: Kazakhstan
	FlagForLaos                                Emoji = "\U0001f1f1\U0001f1e6" // flag: Laos
	FlagForLebanon                             Emoji = "\U0001f1f1\U0001f1e7" // flag: Lebanon
	FlagForStLucia                             Emoji = "\U0001f1f1\U0001f1e8" // flag: St. Lucia
	FlagForLiechtenstein                       Emoji = "\U0001f1f1\U0001f1ee" // flag: Liechtenstein
	FlagForSriLanka                            Emoji = "\U0001f1f1\U0001f1f0" // flag: Sri Lanka
	FlagForLiberia                             Emoji = "\U0001f1f1\U0001f1f7" // flag: Liberia
	FlagForLesotho                             Emoji = "\U0001f1f1\U0001f1f8" // flag: Lesotho
	FlagForLithuania                           Emoji = "\U0001f1f1\U0001f1f9" // flag: Lithuania
	FlagForLuxembourg                          Emoji = "\U0001f1f1\U0001f1fa" // flag: Luxembourg
	FlagForLatvia                              Emoji = "\U0001f1f1\U0001f1fb" // flag: Latvia
	FlagForLibya                               Emoji = "\U0001f1f1\U0001f1fe" // flag: Libya
	FlagForMorocco                             Emoji = "\U0001f1f2\U0001f1e6" // flag: Morocco
	FlagForMonaco                              Emoji = "\U0001f1f2\U0001f1e8" // flag: Monaco
	FlagForMoldova                             Emoji = "\U0001f1f2\U0001f1e9" // flag: Moldova
	FlagForMontenegro                          Emoji = "\U0001f1f2\U0001f1ea" // flag: Montenegro
	FlagForStMartin                            Emoji = "\U0001f1f2\U0001f1eb" // flag: St. Martin
	FlagForMadagascar                          Emoji = "\U0001f1f2\U0001f1ec" // flag: Madagascar
	FlagForMarshallIslands                     Emoji = "\U0001f1f2\U0001f1ed" // flag: Marshall Islands
	FlagForNorthMacedonia                      Emoji = "\U0001f1f2\U0001f1f0" // flag: North Macedonia
	FlagForMali                                Emoji = "\U0001f1f2\U0001f1f1" // flag: Mali
	FlagForMyanmarBurma                        Emoji = "\U0001f1f2\U0001f1f2" // flag: Myanmar (Burma)
	FlagForMongolia                            Emoji = "\U0001f1f2\U0001f1f3" // flag: Mongolia
	FlagForMacaoSarChina                       Emoji = "\U0001f1f2\U0001f1f4" // flag: Macao SAR China
	FlagForNorthernMarianaIslands              Emoji = "\U0001f1f2\U0001f1f5" // flag: Northern Mariana Islands
	FlagForMartinique                          Emoji = "\U0001f1f2\U0001f1f6" // flag: Martinique
	FlagForMauritania                          Emoji = "\U0001f1f2\U0001f1f7" // flag: Mauritania
	FlagForMontserrat                          Emoji = "\U0001f1f2\U0001f1f8" // flag: Montserrat
	FlagForMalta                               Emoji = "\U0001f1f2\U0001f1f9" // flag: Malta
	FlagForMauritius                           Emoji = "\U0001f1f2\U0001f1fa" // flag: Mauritius
	FlagForMaldives                            Emoji = "\U0001f1f2\U0001f1fb" // flag: Maldives
	FlagForMalawi                              Emoji = "\U0001f1f2\U0001f1fc" // flag: Malawi
	FlagForMexico                              Emoji = "\U0001f1f2\U0001f1fd" // flag: Mexico
	FlagForMalaysia                            Emoji = "\U0001f1f2\U0001f1fe" // flag: Malaysia
	FlagForMozambique                          Emoji = "\U0001f1f2\U0001f1ff" // flag: Mozambique
	FlagForNamibia                             Emoji = "\U0001f1f3\U0001f1e6" // flag: Namibia
	FlagForNewCaledonia                        Emoji = "\U0001f1f3\U0001f1e8" // flag: New Caledonia
	FlagForNiger                               Emoji = "\U0001f1f3\U0001f1ea" // flag: Niger
	FlagForNorfolkIsland                       Emoji = "\U0001f1f3\U0001f1eb" // flag: Norfolk Island
	FlagForNigeria                             Emoji = "\U0001f1f3\U0001f1ec" // flag: Nigeria
	FlagForNicaragua                           Emoji = "\U0001f1f3\U0001f1ee" // flag: Nicaragua
	FlagForNetherlands                         Emoji = "\U0001f1f3\U0001f1f1" // flag: Netherlands
	FlagForNorway                              Emoji = "\U0001f1f3\U0001f1f4" // flag: Norway
	FlagForNepal                               Emoji = "\U0001f1f3\U0001f1f5" // flag: Nepal
	FlagForNauru                               Emoji = "\U0001f1f3\U0001f1f7" // flag: Nauru
	FlagForNiue                                Emoji = "\U0001f1f3\U0001f1fa" // flag: Niue
	FlagForNewZealand                          Emoji = "\U0001f1f3\U0001f1ff" // flag: New Zealand
	FlagForOman                                Emoji = "\U0001f1f4\U0001f1f2" // flag: Oman
	FlagForPanama                              Emoji = "\U0001f1f5\U0001f1e6" // flag: Panama
	FlagForPeru                                Emoji = "\U0001f1f5\U0001f1ea" // flag: Peru
	FlagForFrenchPolynesia                     Emoji = "\U0001f1f5\U0001f1eb" // flag: French Polynesia
	FlagForPapuaNewGuinea                      Emoji = "\U0001f1f5\U0001f1ec" // flag: Papua New Guinea
	FlagForPhilippines                         Emoji = "\U0001f1f5\U0001f1ed" // flag: Philippines
	FlagForPakistan                            Emoji = "\U0001f1f5\U0001f1f0" // flag: Pakistan
	FlagForPoland                              Emoji = "\U0001f1f5\U0001f1f1" // flag: Poland
	FlagForStPierreAndMiquelon                 Emoji = "\U0001f1f5\U0001f1f2" // flag: St. Pierre & Miquelon
	FlagForPitcairnIslands                     Emoji = "\U0001f1f5\U0001f1f3" // flag: Pitcairn Islands
	FlagForPuertoRico                          Emoji = "\U0001f1f5\U0001f1f7" // flag: Puerto Rico
	FlagForPalestinianTerritories              Emoji = "\U0001f1f5\U0001f1f8" // flag: Palestinian Territories
	FlagForPortugal                            Emoji = "\U0001f1f5\U0001f1f9" // flag: Portugal
	FlagForPalau                               Emoji = "\U0001f1f5\U0001f1fc" // flag: Palau
	FlagForParaguay                            Emoji = "\U0001f1f5\U0001f1fe" // flag: Paraguay
	FlagForQatar                               Emoji = "\U0001f1f6\U0001f1e6" // flag: Qatar
	FlagForReunion                             Emoji = "\U0001f1f7\U0001f1ea" // flag: Réunion
	FlagForRomania                             Emoji = "\U0001f1f7\U0001f1f4" // flag: Romania
	FlagForSerbia                              Emoji = "\U0001f1f7\U0001f1f8" // flag: Serbia
	FlagForRussia                              Emoji = "\U0001f1f7\U0001f1fa" // flag: Russia
	FlagForRwanda                              Emoji = "\U0001f1f7\U0001f1fc" // flag: Rwanda
	FlagForSaudiArabia                         Emoji = "\U0001f1f8\U0001f1e6" // flag: Saudi Arabia
	FlagForSolomonIslands                      Emoji = "\U0001f1f8\U0001f1e7" // flag: Solomon Islands
	FlagForSeychelles                          Emoji = "\U0001f1f8\U0001f1e8" // flag: Seychelles
	FlagForSudan                               Emoji = "\U0001f1f8\U0001f1e9" // flag: Sudan
	FlagForSweden                              Emoji = "\U0001f1f8\U0001f1ea" // flag: Sweden
	FlagForSingapore                           Emoji = "\U0001f1f8\U0001f1ec" // flag: Singapore
	FlagForStHelena                            Emoji = "\U0001f1f8\U0001f1ed" // flag: St. Helena
	FlagForSlovenia                            Emoji = "\U0001f1f8\U0001f1ee" // flag: Slovenia
	FlagForSvalbardAndJanMayen                 Emoji = "\U0001f1f8\U0001f1ef" // flag: Svalbard & Jan Mayen
	FlagForSlovakia                            Emoji = "\U0001f1f8\U0001f1f0" // flag: Slovakia
	FlagForSierraLeone                         Emoji = "\U0001f1f8\U0001f1f1" // flag: Sierra Leone
	FlagForSanMarino                           Emoji = "\U0001f1f8\U0001f1f2" // flag: San Marino
	FlagForSenegal                             Emoji = "\U0001f1f8\U0001f1f3" // flag: Senegal
	FlagForSomalia                             Emoji = "\U0001f1f8\U0001f1f4" // flag: Somalia
	FlagForSuriname                            Emoji = "\U0001f1f8\U0001f1f7" // flag: Suriname
	FlagForSouthSudan                          Emoji = "\U0001f1f8\U0001f1f8" // flag: South Sudan
	FlagForSaoTomeAndPrincipe                  Emoji = "\U0001f1f8\U0001f1f9" // flag: São Tomé & Príncipe
	FlagForElSalvador                          Emoji = "\U0001f1f8\U0001f1fb" // flag: El Salvador
	FlagForSintMaarten                         Emoji = "\U0001f1f8\U0001f1fd" // flag: Sint Maarten
	FlagForSyria                               Emoji = "\U0001f1f8\U0001f1fe" // flag: Syria
	FlagForEswatini                            Emoji = "\U0001f1f8\U0001f1ff" // flag: Eswatini
	FlagForTristanDaCunha                      Emoji = "\U0001f1f9\U0001f1e6" // flag: Tristan da Cunha
	FlagForTurksAndCaicosIslands               Emoji = "\U0001f1f9\U0001f1e8" // flag: Turks & Caicos Islands
	FlagForChad                                Emoji = "\U0001f1f9\U0001f1e9" // flag: Chad
	FlagForFrenchSouthernTerritories           Emoji = "\U0001f1f9\U0001f1eb" // flag: French Southern Territories
	FlagForTogo                                Emoji = "\U0001f1f9\U0001f1ec" // flag: Togo
	FlagForThailand                            Emoji = "\U0001f1f9\U0001f1ed" // flag: Thailand
	FlagForTajikistan                          Emoji = "\U0001f1f9\U0001f1ef" // flag: Tajikistan
	FlagForTokelau                             Emoji = "\U0001f1f9\U0001f1f0" // flag: Tokelau
	FlagForTimorLeste                          Emoji = "\U0001f1f9\U0001f1f1" // flag: Timor-Leste
	FlagForTurkmenistan                        Emoji = "\U0001f1f9\U0001f1f2" // flag: Turkmenistan
	FlagForTunisia                             Emoji = "\U0001f1f9\U0001f1f3" // flag: Tunisia
	FlagForTonga                               Emoji = "\U0001f1f9\U0001f1f4" // flag: Tonga
	FlagForTurkey                              Emoji = "\U0001f1f9\U0001f1f7" // flag: Turkey
	FlagForTrinidadAndTobago                   Emoji = "\U0001f1f9\U0001f1f9" // flag: Trinidad & Tobago
	FlagForTuvalu                              Emoji = "\U0001f1f9\U0001f1fb" // flag: Tuvalu
	FlagForTaiwan                              Emoji = "\U0001f1f9\U0001f1fc" // flag: Taiwan
	FlagForTanzania                            Emoji = "\U0001f1f9\U0001f1ff" // flag: Tanzania
	FlagForUkraine                             Emoji = "\U0001f1fa\U0001f1e6" // flag: Ukraine
	FlagForUganda                              Emoji = "\U0001f1fa\U0001f1ec" // flag: Uganda
	FlagForUsOutlyingIslands                   Emoji = "\U0001f1fa\U0001f1f2" // flag: U.S. Outlying Islands
	FlagForUnitedNations                       Emoji = "\U0001f1fa\U0001f1f3" // flag: United Nations
	FlagForUnitedStates                        Emoji = "\U0001f1fa\U0001f1f8" // flag: United States
	FlagForUruguay                             Emoji = "\U0001f1fa\U0001f1fe" // flag: Uruguay
	FlagForUzbekistan                          Emoji = "\U0001f1fa\U0001f1ff" // flag: Uzbekistan
	FlagForVaticanCity                         Emoji = "\U0001f1fb\U0001f1e6" // flag: Vatican City
	FlagForStVincentAndGrenadines              Emoji = "\U0001f1fb\U0001f1e8" // flag: St. Vincent & Grenadines
	FlagForVenezuela                           Emoji = "\U0001f1fb\U0001f1ea" // flag: Venezuela
	FlagForBritishVirginIslands                Emoji = "\U0001f1fb\U0001f1ec" // flag: British Virgin Islands
	FlagForUsVirginIslands                     Emoji = "\U0001f1fb\U0001f1ee" // flag: U.S. Virgin Islands
	FlagForVietnam                             Emoji = "\U0001f1fb\U0001f1f3" // flag: Vietnam
	FlagForVanuatu                             Emoji = "\U0001f1fb\U0001f1fa" // flag: Vanuatu
	FlagForWallisAndFutuna                     Emoji = "\U0001f1fc\U0001f1eb" // flag: Wallis & Futuna
	FlagForSamoa                               Emoji = "\U0001f1fc\U0001f1f8" // flag: Samoa
	FlagForKosovo                              Emoji = "\U0001f1fd\U0001f1f0" // flag: Kosovo
	FlagForYemen                               Emoji = "\U0001f1fe\U0001f1ea" // flag: Yemen
	FlagForMayotte                             Emoji = "\U0001f1fe\U0001f1f9" // flag: Mayotte
	FlagForSouthAfrica                         Emoji = "\U0001f1ff\U0001f1e6" // flag: South Africa
	FlagForZambia                              Emoji = "\U0001f1ff\U0001f1f2" // flag: Zambia
	FlagForZimbabwe                            Emoji = "\U0001f1ff\U0001f1fc" // flag: Zimbabwe
	// SUBGROUP: subdivision-flag
	FlagForEngland  Emoji = "\U0001f3f4\U000e0067\U000e0062\U000e0065\U000e006e\U000e0067\U000e007f" // flag: England
	FlagForScotland Emoji = "\U0001f3f4\U000e0067\U000e0062\U000e0073\U000e0063\U000e0074\U000e007f" // flag: Scotland
	FlagForWales    Emoji = "\U0001f3f4\U000e0067\U000e0062\U000e0077\U000e006c\U000e0073\U000e007f" // flag: Wales

)
