// Deprecated: Please note, this package has been deprecated. A replacement package is available [github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql](https://pkg.go.dev/github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql). We strongly encourage you to upgrade to continue receiving updates. See [Migration Guide](https://aka.ms/azsdk/golang/t2/migration) for guidance on upgrading. Refer to our [deprecation policy](https://azure.github.io/azure-sdk/policies_support.html) for more details.
package sqlapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/v5.0/sql"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/gofrs/uuid"
)

// RecoverableDatabasesClientAPI contains the set of methods on the RecoverableDatabasesClient type.
type RecoverableDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.RecoverableDatabase, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.RecoverableDatabaseListResult, err error)
}

var _ RecoverableDatabasesClientAPI = (*sql.RecoverableDatabasesClient)(nil)

// DataMaskingPoliciesClientAPI contains the set of methods on the DataMaskingPoliciesClient type.
type DataMaskingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DataMaskingPolicy) (result sql.DataMaskingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataMaskingPolicy, err error)
}

var _ DataMaskingPoliciesClientAPI = (*sql.DataMaskingPoliciesClient)(nil)

// DataMaskingRulesClientAPI contains the set of methods on the DataMaskingRulesClient type.
type DataMaskingRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, dataMaskingRuleName string, parameters sql.DataMaskingRule) (result sql.DataMaskingRule, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataMaskingRuleListResult, err error)
}

var _ DataMaskingRulesClientAPI = (*sql.DataMaskingRulesClient)(nil)

// GeoBackupPoliciesClientAPI contains the set of methods on the GeoBackupPoliciesClient type.
type GeoBackupPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.GeoBackupPolicy) (result sql.GeoBackupPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.GeoBackupPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.GeoBackupPolicyListResult, err error)
}

var _ GeoBackupPoliciesClientAPI = (*sql.GeoBackupPoliciesClient)(nil)

// DatabasesClientAPI contains the set of methods on the DatabasesClient type.
type DatabasesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.Database) (result sql.DatabasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesDeleteFuture, err error)
	Export(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ExportDatabaseDefinition) (result sql.DatabasesExportFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, databaseName string, replicaType sql.ReplicaType) (result sql.DatabasesFailoverFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.Database, err error)
	Import(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ImportExistingDatabaseDefinition) (result sql.DatabasesImportFuture, err error)
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.DatabaseListResultPage, err error)
	ListByElasticPoolComplete(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.DatabaseListResultIterator, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string, skipToken string) (result sql.DatabaseListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string, skipToken string) (result sql.DatabaseListResultIterator, err error)
	ListInaccessibleByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseListResultPage, err error)
	ListInaccessibleByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseListResultIterator, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.MetricDefinitionListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.MetricListResult, err error)
	Pause(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesPauseFuture, err error)
	Rename(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ResourceMoveDefinition) (result autorest.Response, err error)
	Resume(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesResumeFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseUpdate) (result sql.DatabasesUpdateFuture, err error)
	UpgradeDataWarehouse(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesUpgradeDataWarehouseFuture, err error)
}

var _ DatabasesClientAPI = (*sql.DatabasesClient)(nil)

// ElasticPoolsClientAPI contains the set of methods on the ElasticPoolsClient type.
type ElasticPoolsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, parameters sql.ElasticPool) (result sql.ElasticPoolsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolsDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolsFailoverFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPool, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string, skip *int64) (result sql.ElasticPoolListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string, skip *int64) (result sql.ElasticPoolListResultIterator, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.MetricDefinitionListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, filter string) (result sql.MetricListResult, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, parameters sql.ElasticPoolUpdate) (result sql.ElasticPoolsUpdateFuture, err error)
}

var _ ElasticPoolsClientAPI = (*sql.ElasticPoolsClient)(nil)

// ServerCommunicationLinksClientAPI contains the set of methods on the ServerCommunicationLinksClient type.
type ServerCommunicationLinksClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string, parameters sql.ServerCommunicationLink) (result sql.ServerCommunicationLinksCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string) (result sql.ServerCommunicationLink, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerCommunicationLinkListResult, err error)
}

var _ ServerCommunicationLinksClientAPI = (*sql.ServerCommunicationLinksClient)(nil)

// ServiceObjectivesClientAPI contains the set of methods on the ServiceObjectivesClient type.
type ServiceObjectivesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, serviceObjectiveName string) (result sql.ServiceObjective, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServiceObjectiveListResult, err error)
}

var _ ServiceObjectivesClientAPI = (*sql.ServiceObjectivesClient)(nil)

// ElasticPoolActivitiesClientAPI contains the set of methods on the ElasticPoolActivitiesClient type.
type ElasticPoolActivitiesClientAPI interface {
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolActivityListResult, err error)
}

var _ ElasticPoolActivitiesClientAPI = (*sql.ElasticPoolActivitiesClient)(nil)

// ElasticPoolDatabaseActivitiesClientAPI contains the set of methods on the ElasticPoolDatabaseActivitiesClient type.
type ElasticPoolDatabaseActivitiesClientAPI interface {
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolDatabaseActivityListResult, err error)
}

var _ ElasticPoolDatabaseActivitiesClientAPI = (*sql.ElasticPoolDatabaseActivitiesClient)(nil)

// ServerUsagesClientAPI contains the set of methods on the ServerUsagesClient type.
type ServerUsagesClientAPI interface {
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerUsageListResult, err error)
}

var _ ServerUsagesClientAPI = (*sql.ServerUsagesClient)(nil)

// DatabaseAdvisorsClientAPI contains the set of methods on the DatabaseAdvisorsClient type.
type DatabaseAdvisorsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, advisorName string) (result sql.Advisor, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, expand string) (result sql.ListAdvisor, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, advisorName string, parameters sql.Advisor) (result sql.Advisor, err error)
}

var _ DatabaseAdvisorsClientAPI = (*sql.DatabaseAdvisorsClient)(nil)

// DatabaseAutomaticTuningClientAPI contains the set of methods on the DatabaseAutomaticTuningClient type.
type DatabaseAutomaticTuningClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseAutomaticTuning, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseAutomaticTuning) (result sql.DatabaseAutomaticTuning, err error)
}

var _ DatabaseAutomaticTuningClientAPI = (*sql.DatabaseAutomaticTuningClient)(nil)

// DatabaseColumnsClientAPI contains the set of methods on the DatabaseColumnsClient type.
type DatabaseColumnsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result sql.DatabaseColumn, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schema []string, table []string, column []string, orderBy []string, skiptoken string) (result sql.DatabaseColumnListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schema []string, table []string, column []string, orderBy []string, skiptoken string) (result sql.DatabaseColumnListResultIterator, err error)
	ListByTable(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, filter string) (result sql.DatabaseColumnListResultPage, err error)
	ListByTableComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, filter string) (result sql.DatabaseColumnListResultIterator, err error)
}

var _ DatabaseColumnsClientAPI = (*sql.DatabaseColumnsClient)(nil)

// DatabaseRecommendedActionsClientAPI contains the set of methods on the DatabaseRecommendedActionsClient type.
type DatabaseRecommendedActionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, advisorName string, recommendedActionName string) (result sql.RecommendedAction, err error)
	ListByDatabaseAdvisor(ctx context.Context, resourceGroupName string, serverName string, databaseName string, advisorName string) (result sql.ListRecommendedAction, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, advisorName string, recommendedActionName string, parameters sql.RecommendedAction) (result sql.RecommendedAction, err error)
}

var _ DatabaseRecommendedActionsClientAPI = (*sql.DatabaseRecommendedActionsClient)(nil)

// DatabaseSchemasClientAPI contains the set of methods on the DatabaseSchemasClient type.
type DatabaseSchemasClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string) (result sql.DatabaseSchema, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.DatabaseSchemaListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.DatabaseSchemaListResultIterator, err error)
}

var _ DatabaseSchemasClientAPI = (*sql.DatabaseSchemasClient)(nil)

// DatabaseSecurityAlertPoliciesClientAPI contains the set of methods on the DatabaseSecurityAlertPoliciesClient type.
type DatabaseSecurityAlertPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseSecurityAlertPolicy) (result sql.DatabaseSecurityAlertPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSecurityAlertPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSecurityAlertListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSecurityAlertListResultIterator, err error)
}

var _ DatabaseSecurityAlertPoliciesClientAPI = (*sql.DatabaseSecurityAlertPoliciesClient)(nil)

// DatabaseTablesClientAPI contains the set of methods on the DatabaseTablesClient type.
type DatabaseTablesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string) (result sql.DatabaseTable, err error)
	ListBySchema(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, filter string) (result sql.DatabaseTableListResultPage, err error)
	ListBySchemaComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, filter string) (result sql.DatabaseTableListResultIterator, err error)
}

var _ DatabaseTablesClientAPI = (*sql.DatabaseTablesClient)(nil)

// DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI contains the set of methods on the DatabaseVulnerabilityAssessmentRuleBaselinesClient type.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName, parameters sql.DatabaseVulnerabilityAssessmentRuleBaseline) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
}

var _ DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI = (*sql.DatabaseVulnerabilityAssessmentRuleBaselinesClient)(nil)

// DatabaseVulnerabilityAssessmentsClientAPI contains the set of methods on the DatabaseVulnerabilityAssessmentsClient type.
type DatabaseVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseVulnerabilityAssessment) (result sql.DatabaseVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessment, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultIterator, err error)
}

var _ DatabaseVulnerabilityAssessmentsClientAPI = (*sql.DatabaseVulnerabilityAssessmentsClient)(nil)

// DatabaseVulnerabilityAssessmentScansClientAPI contains the set of methods on the DatabaseVulnerabilityAssessmentScansClient type.
type DatabaseVulnerabilityAssessmentScansClientAPI interface {
	Export(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.DatabaseVulnerabilityAssessmentScansExport, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.VulnerabilityAssessmentScanRecord, err error)
	InitiateScan(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.DatabaseVulnerabilityAssessmentScansInitiateScanFuture, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultIterator, err error)
}

var _ DatabaseVulnerabilityAssessmentScansClientAPI = (*sql.DatabaseVulnerabilityAssessmentScansClient)(nil)

// DataWarehouseUserActivitiesClientAPI contains the set of methods on the DataWarehouseUserActivitiesClient type.
type DataWarehouseUserActivitiesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataWarehouseUserActivities, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataWarehouseUserActivitiesListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataWarehouseUserActivitiesListResultIterator, err error)
}

var _ DataWarehouseUserActivitiesClientAPI = (*sql.DataWarehouseUserActivitiesClient)(nil)

// DeletedServersClientAPI contains the set of methods on the DeletedServersClient type.
type DeletedServersClientAPI interface {
	Get(ctx context.Context, locationName string, deletedServerName string) (result sql.DeletedServer, err error)
	List(ctx context.Context) (result sql.DeletedServerListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.DeletedServerListResultIterator, err error)
	ListByLocation(ctx context.Context, locationName string) (result sql.DeletedServerListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string) (result sql.DeletedServerListResultIterator, err error)
	Recover(ctx context.Context, locationName string, deletedServerName string) (result sql.DeletedServersRecoverFuture, err error)
}

var _ DeletedServersClientAPI = (*sql.DeletedServersClient)(nil)

// ElasticPoolOperationsClientAPI contains the set of methods on the ElasticPoolOperationsClient type.
type ElasticPoolOperationsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, operationID uuid.UUID) (result autorest.Response, err error)
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolOperationListResultPage, err error)
	ListByElasticPoolComplete(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolOperationListResultIterator, err error)
}

var _ ElasticPoolOperationsClientAPI = (*sql.ElasticPoolOperationsClient)(nil)

// EncryptionProtectorsClientAPI contains the set of methods on the EncryptionProtectorsClient type.
type EncryptionProtectorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.EncryptionProtector) (result sql.EncryptionProtectorsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtector, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorListResultIterator, err error)
	Revalidate(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorsRevalidateFuture, err error)
}

var _ EncryptionProtectorsClientAPI = (*sql.EncryptionProtectorsClient)(nil)

// FailoverGroupsClientAPI contains the set of methods on the FailoverGroupsClient type.
type FailoverGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, parameters sql.FailoverGroup) (result sql.FailoverGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsFailoverFuture, err error)
	ForceFailoverAllowDataLoss(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsForceFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroup, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.FailoverGroupListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.FailoverGroupListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, parameters sql.FailoverGroupUpdate) (result sql.FailoverGroupsUpdateFuture, err error)
}

var _ FailoverGroupsClientAPI = (*sql.FailoverGroupsClient)(nil)

// FirewallRulesClientAPI contains the set of methods on the FirewallRulesClient type.
type FirewallRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string, parameters sql.FirewallRule) (result sql.FirewallRule, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result sql.FirewallRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.FirewallRuleListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.FirewallRuleListResultIterator, err error)
	Replace(ctx context.Context, resourceGroupName string, serverName string, parameters sql.FirewallRuleList) (result sql.FirewallRule, err error)
}

var _ FirewallRulesClientAPI = (*sql.FirewallRulesClient)(nil)

// InstanceFailoverGroupsClientAPI contains the set of methods on the InstanceFailoverGroupsClient type.
type InstanceFailoverGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string, parameters sql.InstanceFailoverGroup) (result sql.InstanceFailoverGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string) (result sql.InstanceFailoverGroupsDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string) (result sql.InstanceFailoverGroupsFailoverFuture, err error)
	ForceFailoverAllowDataLoss(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string) (result sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string) (result sql.InstanceFailoverGroup, err error)
	ListByLocation(ctx context.Context, resourceGroupName string, locationName string) (result sql.InstanceFailoverGroupListResultPage, err error)
	ListByLocationComplete(ctx context.Context, resourceGroupName string, locationName string) (result sql.InstanceFailoverGroupListResultIterator, err error)
}

var _ InstanceFailoverGroupsClientAPI = (*sql.InstanceFailoverGroupsClient)(nil)

// InstancePoolsClientAPI contains the set of methods on the InstancePoolsClient type.
type InstancePoolsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, instancePoolName string, parameters sql.InstancePool) (result sql.InstancePoolsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, instancePoolName string) (result sql.InstancePoolsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, instancePoolName string) (result sql.InstancePool, err error)
	List(ctx context.Context) (result sql.InstancePoolListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.InstancePoolListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.InstancePoolListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.InstancePoolListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, instancePoolName string, parameters sql.InstancePoolUpdate) (result sql.InstancePoolsUpdateFuture, err error)
}

var _ InstancePoolsClientAPI = (*sql.InstancePoolsClient)(nil)

// JobAgentsClientAPI contains the set of methods on the JobAgentsClient type.
type JobAgentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, parameters sql.JobAgent) (result sql.JobAgentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobAgentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobAgent, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.JobAgentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.JobAgentListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, parameters sql.JobAgentUpdate) (result sql.JobAgentsUpdateFuture, err error)
}

var _ JobAgentsClientAPI = (*sql.JobAgentsClient)(nil)

// JobCredentialsClientAPI contains the set of methods on the JobCredentialsClient type.
type JobCredentialsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string, parameters sql.JobCredential) (result sql.JobCredential, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string) (result sql.JobCredential, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobCredentialListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobCredentialListResultIterator, err error)
}

var _ JobCredentialsClientAPI = (*sql.JobCredentialsClient)(nil)

// JobExecutionsClientAPI contains the set of methods on the JobExecutionsClient type.
type JobExecutionsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result autorest.Response, err error)
	Create(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobExecutionsCreateFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result sql.JobExecutionsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result sql.JobExecution, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobExecutionsClientAPI = (*sql.JobExecutionsClient)(nil)

// JobsClientAPI contains the set of methods on the JobsClient type.
type JobsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, parameters sql.Job) (result sql.Job, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.Job, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobListResultIterator, err error)
}

var _ JobsClientAPI = (*sql.JobsClient)(nil)

// JobStepExecutionsClientAPI contains the set of methods on the JobStepExecutionsClient type.
type JobStepExecutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string) (result sql.JobExecution, err error)
	ListByJobExecution(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobExecutionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobStepExecutionsClientAPI = (*sql.JobStepExecutionsClient)(nil)

// JobStepsClientAPI contains the set of methods on the JobStepsClient type.
type JobStepsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string, parameters sql.JobStep) (result sql.JobStep, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string) (result sql.JobStep, err error)
	GetByVersion(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32, stepName string) (result sql.JobStep, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobStepListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobStepListResultIterator, err error)
	ListByVersion(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobStepListResultPage, err error)
	ListByVersionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobStepListResultIterator, err error)
}

var _ JobStepsClientAPI = (*sql.JobStepsClient)(nil)

// JobTargetExecutionsClientAPI contains the set of methods on the JobTargetExecutionsClient type.
type JobTargetExecutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, targetID uuid.UUID) (result sql.JobExecution, err error)
	ListByJobExecution(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobExecutionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
	ListByStep(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByStepComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobTargetExecutionsClientAPI = (*sql.JobTargetExecutionsClient)(nil)

// JobTargetGroupsClientAPI contains the set of methods on the JobTargetGroupsClient type.
type JobTargetGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string, parameters sql.JobTargetGroup) (result sql.JobTargetGroup, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string) (result sql.JobTargetGroup, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobTargetGroupListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobTargetGroupListResultIterator, err error)
}

var _ JobTargetGroupsClientAPI = (*sql.JobTargetGroupsClient)(nil)

// JobVersionsClientAPI contains the set of methods on the JobVersionsClient type.
type JobVersionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobVersion, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobVersionListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobVersionListResultIterator, err error)
}

var _ JobVersionsClientAPI = (*sql.JobVersionsClient)(nil)

// CapabilitiesClientAPI contains the set of methods on the CapabilitiesClient type.
type CapabilitiesClientAPI interface {
	ListByLocation(ctx context.Context, locationName string, include sql.CapabilityGroup) (result sql.LocationCapabilities, err error)
}

var _ CapabilitiesClientAPI = (*sql.CapabilitiesClient)(nil)

// LongTermRetentionPoliciesClientAPI contains the set of methods on the LongTermRetentionPoliciesClient type.
type LongTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.LongTermRetentionPolicy) (result sql.LongTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LongTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LongTermRetentionPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LongTermRetentionPolicyListResultIterator, err error)
}

var _ LongTermRetentionPoliciesClientAPI = (*sql.LongTermRetentionPoliciesClient)(nil)

// MaintenanceWindowOptionsClientAPI contains the set of methods on the MaintenanceWindowOptionsClient type.
type MaintenanceWindowOptionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, maintenanceWindowOptionsName string) (result sql.MaintenanceWindowOptions, err error)
}

var _ MaintenanceWindowOptionsClientAPI = (*sql.MaintenanceWindowOptionsClient)(nil)

// MaintenanceWindowsClientAPI contains the set of methods on the MaintenanceWindowsClient type.
type MaintenanceWindowsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, maintenanceWindowName string, parameters sql.MaintenanceWindows) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, maintenanceWindowName string) (result sql.MaintenanceWindows, err error)
}

var _ MaintenanceWindowsClientAPI = (*sql.MaintenanceWindowsClient)(nil)

// ManagedBackupShortTermRetentionPoliciesClientAPI contains the set of methods on the ManagedBackupShortTermRetentionPoliciesClient type.
type ManagedBackupShortTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicyListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture, err error)
}

var _ ManagedBackupShortTermRetentionPoliciesClientAPI = (*sql.ManagedBackupShortTermRetentionPoliciesClient)(nil)

// ManagedDatabaseColumnsClientAPI contains the set of methods on the ManagedDatabaseColumnsClient type.
type ManagedDatabaseColumnsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string) (result sql.DatabaseColumn, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schema []string, table []string, column []string, orderBy []string, skiptoken string) (result sql.DatabaseColumnListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schema []string, table []string, column []string, orderBy []string, skiptoken string) (result sql.DatabaseColumnListResultIterator, err error)
	ListByTable(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, filter string) (result sql.DatabaseColumnListResultPage, err error)
	ListByTableComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, filter string) (result sql.DatabaseColumnListResultIterator, err error)
}

var _ ManagedDatabaseColumnsClientAPI = (*sql.ManagedDatabaseColumnsClient)(nil)

// ManagedDatabaseQueriesClientAPI contains the set of methods on the ManagedDatabaseQueriesClient type.
type ManagedDatabaseQueriesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, queryID string) (result sql.ManagedInstanceQuery, err error)
	ListByQuery(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, queryID string, startTime string, endTime string, interval sql.QueryTimeGrainType) (result sql.ManagedInstanceQueryStatisticsPage, err error)
	ListByQueryComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, queryID string, startTime string, endTime string, interval sql.QueryTimeGrainType) (result sql.ManagedInstanceQueryStatisticsIterator, err error)
}

var _ ManagedDatabaseQueriesClientAPI = (*sql.ManagedDatabaseQueriesClient)(nil)

// ManagedDatabaseSchemasClientAPI contains the set of methods on the ManagedDatabaseSchemasClient type.
type ManagedDatabaseSchemasClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string) (result sql.DatabaseSchema, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, filter string) (result sql.DatabaseSchemaListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, filter string) (result sql.DatabaseSchemaListResultIterator, err error)
}

var _ ManagedDatabaseSchemasClientAPI = (*sql.ManagedDatabaseSchemasClient)(nil)

// ManagedDatabaseSecurityAlertPoliciesClientAPI contains the set of methods on the ManagedDatabaseSecurityAlertPoliciesClient type.
type ManagedDatabaseSecurityAlertPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseSecurityAlertPolicy) (result sql.ManagedDatabaseSecurityAlertPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseSecurityAlertPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseSecurityAlertPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseSecurityAlertPolicyListResultIterator, err error)
}

var _ ManagedDatabaseSecurityAlertPoliciesClientAPI = (*sql.ManagedDatabaseSecurityAlertPoliciesClient)(nil)

// ManagedDatabaseSecurityEventsClientAPI contains the set of methods on the ManagedDatabaseSecurityEventsClient type.
type ManagedDatabaseSecurityEventsClientAPI interface {
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, filter string, skip *int32, top *int32, skiptoken string) (result sql.SecurityEventCollectionPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, filter string, skip *int32, top *int32, skiptoken string) (result sql.SecurityEventCollectionIterator, err error)
}

var _ ManagedDatabaseSecurityEventsClientAPI = (*sql.ManagedDatabaseSecurityEventsClient)(nil)

// ManagedDatabaseTablesClientAPI contains the set of methods on the ManagedDatabaseTablesClient type.
type ManagedDatabaseTablesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string) (result sql.DatabaseTable, err error)
	ListBySchema(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, filter string) (result sql.DatabaseTableListResultPage, err error)
	ListBySchemaComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, filter string) (result sql.DatabaseTableListResultIterator, err error)
}

var _ ManagedDatabaseTablesClientAPI = (*sql.ManagedDatabaseTablesClient)(nil)

// ManagedDatabaseTransparentDataEncryptionClientAPI contains the set of methods on the ManagedDatabaseTransparentDataEncryptionClient type.
type ManagedDatabaseTransparentDataEncryptionClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedTransparentDataEncryption) (result sql.ManagedTransparentDataEncryption, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedTransparentDataEncryption, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedTransparentDataEncryptionListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedTransparentDataEncryptionListResultIterator, err error)
}

var _ ManagedDatabaseTransparentDataEncryptionClientAPI = (*sql.ManagedDatabaseTransparentDataEncryptionClient)(nil)

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientAPI contains the set of methods on the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient type.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName, parameters sql.DatabaseVulnerabilityAssessmentRuleBaseline) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
}

var _ ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientAPI = (*sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient)(nil)

// ManagedDatabaseVulnerabilityAssessmentsClientAPI contains the set of methods on the ManagedDatabaseVulnerabilityAssessmentsClient type.
type ManagedDatabaseVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.DatabaseVulnerabilityAssessment) (result sql.DatabaseVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.DatabaseVulnerabilityAssessment, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultIterator, err error)
}

var _ ManagedDatabaseVulnerabilityAssessmentsClientAPI = (*sql.ManagedDatabaseVulnerabilityAssessmentsClient)(nil)

// ManagedDatabaseVulnerabilityAssessmentScansClientAPI contains the set of methods on the ManagedDatabaseVulnerabilityAssessmentScansClient type.
type ManagedDatabaseVulnerabilityAssessmentScansClientAPI interface {
	Export(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, scanID string) (result sql.DatabaseVulnerabilityAssessmentScansExport, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, scanID string) (result sql.VulnerabilityAssessmentScanRecord, err error)
	InitiateScan(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, scanID string) (result sql.ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultIterator, err error)
}

var _ ManagedDatabaseVulnerabilityAssessmentScansClientAPI = (*sql.ManagedDatabaseVulnerabilityAssessmentScansClient)(nil)

// ManagedInstanceAdministratorsClientAPI contains the set of methods on the ManagedInstanceAdministratorsClient type.
type ManagedInstanceAdministratorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceAdministrator) (result sql.ManagedInstanceAdministratorsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministrator, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorListResultIterator, err error)
}

var _ ManagedInstanceAdministratorsClientAPI = (*sql.ManagedInstanceAdministratorsClient)(nil)

// ManagedInstanceAzureADOnlyAuthenticationsClientAPI contains the set of methods on the ManagedInstanceAzureADOnlyAuthenticationsClient type.
type ManagedInstanceAzureADOnlyAuthenticationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceAzureADOnlyAuthentication) (result sql.ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAzureADOnlyAuthenticationsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAzureADOnlyAuthentication, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAzureADOnlyAuthListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAzureADOnlyAuthListResultIterator, err error)
}

var _ ManagedInstanceAzureADOnlyAuthenticationsClientAPI = (*sql.ManagedInstanceAzureADOnlyAuthenticationsClient)(nil)

// ManagedInstanceEncryptionProtectorsClientAPI contains the set of methods on the ManagedInstanceEncryptionProtectorsClient type.
type ManagedInstanceEncryptionProtectorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceEncryptionProtector) (result sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceEncryptionProtector, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceEncryptionProtectorListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceEncryptionProtectorListResultIterator, err error)
	Revalidate(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceEncryptionProtectorsRevalidateFuture, err error)
}

var _ ManagedInstanceEncryptionProtectorsClientAPI = (*sql.ManagedInstanceEncryptionProtectorsClient)(nil)

// ManagedInstanceKeysClientAPI contains the set of methods on the ManagedInstanceKeysClient type.
type ManagedInstanceKeysClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, keyName string, parameters sql.ManagedInstanceKey) (result sql.ManagedInstanceKeysCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, keyName string) (result sql.ManagedInstanceKeysDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, keyName string) (result sql.ManagedInstanceKey, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string, filter string) (result sql.ManagedInstanceKeyListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, filter string) (result sql.ManagedInstanceKeyListResultIterator, err error)
}

var _ ManagedInstanceKeysClientAPI = (*sql.ManagedInstanceKeysClient)(nil)

// ManagedInstanceLongTermRetentionPoliciesClientAPI contains the set of methods on the ManagedInstanceLongTermRetentionPoliciesClient type.
type ManagedInstanceLongTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedInstanceLongTermRetentionPolicy) (result sql.ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedInstanceLongTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedInstanceLongTermRetentionPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedInstanceLongTermRetentionPolicyListResultIterator, err error)
}

var _ ManagedInstanceLongTermRetentionPoliciesClientAPI = (*sql.ManagedInstanceLongTermRetentionPoliciesClient)(nil)

// ManagedInstanceOperationsClientAPI contains the set of methods on the ManagedInstanceOperationsClient type.
type ManagedInstanceOperationsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, managedInstanceName string, operationID uuid.UUID) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, operationID uuid.UUID) (result sql.ManagedInstanceOperation, err error)
	ListByManagedInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceOperationListResultPage, err error)
	ListByManagedInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceOperationListResultIterator, err error)
}

var _ ManagedInstanceOperationsClientAPI = (*sql.ManagedInstanceOperationsClient)(nil)

// ManagedInstancePrivateEndpointConnectionsClientAPI contains the set of methods on the ManagedInstancePrivateEndpointConnectionsClient type.
type ManagedInstancePrivateEndpointConnectionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, privateEndpointConnectionName string, parameters sql.ManagedInstancePrivateEndpointConnection) (result sql.ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, privateEndpointConnectionName string) (result sql.ManagedInstancePrivateEndpointConnectionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, privateEndpointConnectionName string) (result sql.ManagedInstancePrivateEndpointConnection, err error)
	ListByManagedInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstancePrivateEndpointConnectionListResultPage, err error)
	ListByManagedInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstancePrivateEndpointConnectionListResultIterator, err error)
}

var _ ManagedInstancePrivateEndpointConnectionsClientAPI = (*sql.ManagedInstancePrivateEndpointConnectionsClient)(nil)

// ManagedInstancePrivateLinkResourcesClientAPI contains the set of methods on the ManagedInstancePrivateLinkResourcesClient type.
type ManagedInstancePrivateLinkResourcesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, groupName string) (result sql.ManagedInstancePrivateLink, err error)
	ListByManagedInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstancePrivateLinkListResultPage, err error)
	ListByManagedInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstancePrivateLinkListResultIterator, err error)
}

var _ ManagedInstancePrivateLinkResourcesClientAPI = (*sql.ManagedInstancePrivateLinkResourcesClient)(nil)

// ManagedInstanceTdeCertificatesClientAPI contains the set of methods on the ManagedInstanceTdeCertificatesClient type.
type ManagedInstanceTdeCertificatesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.TdeCertificate) (result sql.ManagedInstanceTdeCertificatesCreateFuture, err error)
}

var _ ManagedInstanceTdeCertificatesClientAPI = (*sql.ManagedInstanceTdeCertificatesClient)(nil)

// ManagedInstanceVulnerabilityAssessmentsClientAPI contains the set of methods on the ManagedInstanceVulnerabilityAssessmentsClient type.
type ManagedInstanceVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceVulnerabilityAssessment) (result sql.ManagedInstanceVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceVulnerabilityAssessment, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceVulnerabilityAssessmentListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceVulnerabilityAssessmentListResultIterator, err error)
}

var _ ManagedInstanceVulnerabilityAssessmentsClientAPI = (*sql.ManagedInstanceVulnerabilityAssessmentsClient)(nil)

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientAPI contains the set of methods on the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient type.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.ManagedBackupShortTermRetentionPolicy, err error)
	ListByRestorableDroppedDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.ManagedBackupShortTermRetentionPolicyListResultPage, err error)
	ListByRestorableDroppedDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.ManagedBackupShortTermRetentionPolicyListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture, err error)
}

var _ ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientAPI = (*sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient)(nil)

// ManagedServerSecurityAlertPoliciesClientAPI contains the set of methods on the ManagedServerSecurityAlertPoliciesClient type.
type ManagedServerSecurityAlertPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedServerSecurityAlertPolicy) (result sql.ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedServerSecurityAlertPolicy, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedServerSecurityAlertPolicyListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedServerSecurityAlertPolicyListResultIterator, err error)
}

var _ ManagedServerSecurityAlertPoliciesClientAPI = (*sql.ManagedServerSecurityAlertPoliciesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result sql.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*sql.OperationsClient)(nil)

// PrivateEndpointConnectionsClientAPI contains the set of methods on the PrivateEndpointConnectionsClient type.
type PrivateEndpointConnectionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, privateEndpointConnectionName string, parameters sql.PrivateEndpointConnection) (result sql.PrivateEndpointConnectionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, privateEndpointConnectionName string) (result sql.PrivateEndpointConnectionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, privateEndpointConnectionName string) (result sql.PrivateEndpointConnection, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.PrivateEndpointConnectionListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.PrivateEndpointConnectionListResultIterator, err error)
}

var _ PrivateEndpointConnectionsClientAPI = (*sql.PrivateEndpointConnectionsClient)(nil)

// PrivateLinkResourcesClientAPI contains the set of methods on the PrivateLinkResourcesClient type.
type PrivateLinkResourcesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, groupName string) (result sql.PrivateLinkResource, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.PrivateLinkResourceListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.PrivateLinkResourceListResultIterator, err error)
}

var _ PrivateLinkResourcesClientAPI = (*sql.PrivateLinkResourcesClient)(nil)

// RecoverableManagedDatabasesClientAPI contains the set of methods on the RecoverableManagedDatabasesClient type.
type RecoverableManagedDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, recoverableDatabaseName string) (result sql.RecoverableManagedDatabase, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RecoverableManagedDatabaseListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RecoverableManagedDatabaseListResultIterator, err error)
}

var _ RecoverableManagedDatabasesClientAPI = (*sql.RecoverableManagedDatabasesClient)(nil)

// RestorePointsClientAPI contains the set of methods on the RestorePointsClient type.
type RestorePointsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.CreateDatabaseRestorePointDefinition) (result sql.RestorePointsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, restorePointName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, restorePointName string) (result sql.RestorePoint, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.RestorePointListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.RestorePointListResultIterator, err error)
}

var _ RestorePointsClientAPI = (*sql.RestorePointsClient)(nil)

// ServerAdvisorsClientAPI contains the set of methods on the ServerAdvisorsClient type.
type ServerAdvisorsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, advisorName string) (result sql.Advisor, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string, expand string) (result sql.ListAdvisor, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, advisorName string, parameters sql.Advisor) (result sql.Advisor, err error)
}

var _ ServerAdvisorsClientAPI = (*sql.ServerAdvisorsClient)(nil)

// ServerAutomaticTuningClientAPI contains the set of methods on the ServerAutomaticTuningClient type.
type ServerAutomaticTuningClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAutomaticTuning, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerAutomaticTuning) (result sql.ServerAutomaticTuning, err error)
}

var _ ServerAutomaticTuningClientAPI = (*sql.ServerAutomaticTuningClient)(nil)

// ServerAzureADAdministratorsClientAPI contains the set of methods on the ServerAzureADAdministratorsClient type.
type ServerAzureADAdministratorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerAzureADAdministrator) (result sql.ServerAzureADAdministratorsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADAdministratorsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADAdministrator, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.AdministratorListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.AdministratorListResultIterator, err error)
}

var _ ServerAzureADAdministratorsClientAPI = (*sql.ServerAzureADAdministratorsClient)(nil)

// ServerAzureADOnlyAuthenticationsClientAPI contains the set of methods on the ServerAzureADOnlyAuthenticationsClient type.
type ServerAzureADOnlyAuthenticationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerAzureADOnlyAuthentication) (result sql.ServerAzureADOnlyAuthenticationsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADOnlyAuthenticationsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADOnlyAuthentication, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.AzureADOnlyAuthListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.AzureADOnlyAuthListResultIterator, err error)
}

var _ ServerAzureADOnlyAuthenticationsClientAPI = (*sql.ServerAzureADOnlyAuthenticationsClient)(nil)

// ServerDevOpsAuditSettingsClientAPI contains the set of methods on the ServerDevOpsAuditSettingsClient type.
type ServerDevOpsAuditSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, devOpsAuditingSettingsName string, parameters sql.ServerDevOpsAuditingSettings) (result sql.ServerDevOpsAuditSettingsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, devOpsAuditingSettingsName string) (result sql.ServerDevOpsAuditingSettings, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerDevOpsAuditSettingsListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerDevOpsAuditSettingsListResultIterator, err error)
}

var _ ServerDevOpsAuditSettingsClientAPI = (*sql.ServerDevOpsAuditSettingsClient)(nil)

// ServerDNSAliasesClientAPI contains the set of methods on the ServerDNSAliasesClient type.
type ServerDNSAliasesClientAPI interface {
	Acquire(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string, parameters sql.ServerDNSAliasAcquisition) (result sql.ServerDNSAliasesAcquireFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAliasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAliasesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAlias, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerDNSAliasListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerDNSAliasListResultIterator, err error)
}

var _ ServerDNSAliasesClientAPI = (*sql.ServerDNSAliasesClient)(nil)

// ServerKeysClientAPI contains the set of methods on the ServerKeysClient type.
type ServerKeysClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, keyName string, parameters sql.ServerKey) (result sql.ServerKeysCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, keyName string) (result sql.ServerKeysDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, keyName string) (result sql.ServerKey, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerKeyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerKeyListResultIterator, err error)
}

var _ ServerKeysClientAPI = (*sql.ServerKeysClient)(nil)

// ServerOperationsClientAPI contains the set of methods on the ServerOperationsClient type.
type ServerOperationsClientAPI interface {
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerOperationListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerOperationListResultIterator, err error)
}

var _ ServerOperationsClientAPI = (*sql.ServerOperationsClient)(nil)

// ServerSecurityAlertPoliciesClientAPI contains the set of methods on the ServerSecurityAlertPoliciesClient type.
type ServerSecurityAlertPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerSecurityAlertPolicy) (result sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerSecurityAlertPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.LogicalServerSecurityAlertPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.LogicalServerSecurityAlertPolicyListResultIterator, err error)
}

var _ ServerSecurityAlertPoliciesClientAPI = (*sql.ServerSecurityAlertPoliciesClient)(nil)

// ServerTrustGroupsClientAPI contains the set of methods on the ServerTrustGroupsClient type.
type ServerTrustGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, locationName string, serverTrustGroupName string, parameters sql.ServerTrustGroup) (result sql.ServerTrustGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, locationName string, serverTrustGroupName string) (result sql.ServerTrustGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, locationName string, serverTrustGroupName string) (result sql.ServerTrustGroup, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ServerTrustGroupListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ServerTrustGroupListResultIterator, err error)
	ListByLocation(ctx context.Context, resourceGroupName string, locationName string) (result sql.ServerTrustGroupListResultPage, err error)
	ListByLocationComplete(ctx context.Context, resourceGroupName string, locationName string) (result sql.ServerTrustGroupListResultIterator, err error)
}

var _ ServerTrustGroupsClientAPI = (*sql.ServerTrustGroupsClient)(nil)

// ServerVulnerabilityAssessmentsClientAPI contains the set of methods on the ServerVulnerabilityAssessmentsClient type.
type ServerVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerVulnerabilityAssessment) (result sql.ServerVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerVulnerabilityAssessment, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerVulnerabilityAssessmentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerVulnerabilityAssessmentListResultIterator, err error)
}

var _ ServerVulnerabilityAssessmentsClientAPI = (*sql.ServerVulnerabilityAssessmentsClient)(nil)

// AgentClientAPI contains the set of methods on the AgentClient type.
type AgentClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.AgentConfiguration) (result sql.AgentConfiguration, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.AgentConfiguration, err error)
}

var _ AgentClientAPI = (*sql.AgentClient)(nil)

// SubscriptionUsagesClientAPI contains the set of methods on the SubscriptionUsagesClient type.
type SubscriptionUsagesClientAPI interface {
	Get(ctx context.Context, locationName string, usageName string) (result sql.SubscriptionUsage, err error)
	ListByLocation(ctx context.Context, locationName string) (result sql.SubscriptionUsageListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string) (result sql.SubscriptionUsageListResultIterator, err error)
}

var _ SubscriptionUsagesClientAPI = (*sql.SubscriptionUsagesClient)(nil)

// SyncAgentsClientAPI contains the set of methods on the SyncAgentsClient type.
type SyncAgentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string, parameters sql.SyncAgent) (result sql.SyncAgentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentsDeleteFuture, err error)
	GenerateKey(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentKeyProperties, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgent, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.SyncAgentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.SyncAgentListResultIterator, err error)
	ListLinkedDatabases(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentLinkedDatabaseListResultPage, err error)
	ListLinkedDatabasesComplete(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentLinkedDatabaseListResultIterator, err error)
}

var _ SyncAgentsClientAPI = (*sql.SyncAgentsClient)(nil)

// SyncGroupsClientAPI contains the set of methods on the SyncGroupsClient type.
type SyncGroupsClientAPI interface {
	CancelSync(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, parameters sql.SyncGroup) (result sql.SyncGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroup, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.SyncGroupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.SyncGroupListResultIterator, err error)
	ListHubSchemas(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncFullSchemaPropertiesListResultPage, err error)
	ListHubSchemasComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncFullSchemaPropertiesListResultIterator, err error)
	ListLogs(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, startTime string, endTime string, typeParameter sql.SyncGroupsType, continuationToken string) (result sql.SyncGroupLogListResultPage, err error)
	ListLogsComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, startTime string, endTime string, typeParameter sql.SyncGroupsType, continuationToken string) (result sql.SyncGroupLogListResultIterator, err error)
	ListSyncDatabaseIds(ctx context.Context, locationName string) (result sql.SyncDatabaseIDListResultPage, err error)
	ListSyncDatabaseIdsComplete(ctx context.Context, locationName string) (result sql.SyncDatabaseIDListResultIterator, err error)
	RefreshHubSchema(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroupsRefreshHubSchemaFuture, err error)
	TriggerSync(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, parameters sql.SyncGroup) (result sql.SyncGroupsUpdateFuture, err error)
}

var _ SyncGroupsClientAPI = (*sql.SyncGroupsClient)(nil)

// SyncMembersClientAPI contains the set of methods on the SyncMembersClient type.
type SyncMembersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, parameters sql.SyncMember) (result sql.SyncMembersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMembersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMember, err error)
	ListBySyncGroup(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncMemberListResultPage, err error)
	ListBySyncGroupComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncMemberListResultIterator, err error)
	ListMemberSchemas(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncFullSchemaPropertiesListResultPage, err error)
	ListMemberSchemasComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncFullSchemaPropertiesListResultIterator, err error)
	RefreshMemberSchema(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMembersRefreshMemberSchemaFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, parameters sql.SyncMember) (result sql.SyncMembersUpdateFuture, err error)
}

var _ SyncMembersClientAPI = (*sql.SyncMembersClient)(nil)

// TdeCertificatesClientAPI contains the set of methods on the TdeCertificatesClient type.
type TdeCertificatesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, serverName string, parameters sql.TdeCertificate) (result sql.TdeCertificatesCreateFuture, err error)
}

var _ TdeCertificatesClientAPI = (*sql.TdeCertificatesClient)(nil)

// TimeZonesClientAPI contains the set of methods on the TimeZonesClient type.
type TimeZonesClientAPI interface {
	Get(ctx context.Context, locationName string, timeZoneID string) (result sql.TimeZone, err error)
	ListByLocation(ctx context.Context, locationName string) (result sql.TimeZoneListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string) (result sql.TimeZoneListResultIterator, err error)
}

var _ TimeZonesClientAPI = (*sql.TimeZonesClient)(nil)

// VirtualNetworkRulesClientAPI contains the set of methods on the VirtualNetworkRulesClient type.
type VirtualNetworkRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string, parameters sql.VirtualNetworkRule) (result sql.VirtualNetworkRulesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string) (result sql.VirtualNetworkRulesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string) (result sql.VirtualNetworkRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.VirtualNetworkRuleListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.VirtualNetworkRuleListResultIterator, err error)
}

var _ VirtualNetworkRulesClientAPI = (*sql.VirtualNetworkRulesClient)(nil)

// WorkloadClassifiersClientAPI contains the set of methods on the WorkloadClassifiersClient type.
type WorkloadClassifiersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string, parameters sql.WorkloadClassifier) (result sql.WorkloadClassifiersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string) (result sql.WorkloadClassifiersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string) (result sql.WorkloadClassifier, err error)
	ListByWorkloadGroup(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string) (result sql.WorkloadClassifierListResultPage, err error)
	ListByWorkloadGroupComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string) (result sql.WorkloadClassifierListResultIterator, err error)
}

var _ WorkloadClassifiersClientAPI = (*sql.WorkloadClassifiersClient)(nil)

// WorkloadGroupsClientAPI contains the set of methods on the WorkloadGroupsClient type.
type WorkloadGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, parameters sql.WorkloadGroup) (result sql.WorkloadGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string) (result sql.WorkloadGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string) (result sql.WorkloadGroup, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.WorkloadGroupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.WorkloadGroupListResultIterator, err error)
}

var _ WorkloadGroupsClientAPI = (*sql.WorkloadGroupsClient)(nil)

// TransparentDataEncryptionsClientAPI contains the set of methods on the TransparentDataEncryptionsClient type.
type TransparentDataEncryptionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.LogicalDatabaseTransparentDataEncryption) (result sql.LogicalDatabaseTransparentDataEncryption, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LogicalDatabaseTransparentDataEncryption, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LogicalDatabaseTransparentDataEncryptionListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LogicalDatabaseTransparentDataEncryptionListResultIterator, err error)
}

var _ TransparentDataEncryptionsClientAPI = (*sql.TransparentDataEncryptionsClient)(nil)

// BackupShortTermRetentionPoliciesClientAPI contains the set of methods on the BackupShortTermRetentionPoliciesClient type.
type BackupShortTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.BackupShortTermRetentionPolicy) (result sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.BackupShortTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.BackupShortTermRetentionPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.BackupShortTermRetentionPolicyListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.BackupShortTermRetentionPolicy) (result sql.BackupShortTermRetentionPoliciesUpdateFuture, err error)
}

var _ BackupShortTermRetentionPoliciesClientAPI = (*sql.BackupShortTermRetentionPoliciesClient)(nil)

// DatabaseExtensionsClientAPI contains the set of methods on the DatabaseExtensionsClient type.
type DatabaseExtensionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, extensionName string, parameters sql.DatabaseExtensions) (result sql.DatabaseExtensionsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, extensionName string) (result autorest.Response, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ImportExportExtensionsOperationListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ImportExportExtensionsOperationListResultIterator, err error)
}

var _ DatabaseExtensionsClientAPI = (*sql.DatabaseExtensionsClient)(nil)

// DatabaseOperationsClientAPI contains the set of methods on the DatabaseOperationsClient type.
type DatabaseOperationsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, serverName string, databaseName string, operationID uuid.UUID) (result autorest.Response, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseOperationListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseOperationListResultIterator, err error)
}

var _ DatabaseOperationsClientAPI = (*sql.DatabaseOperationsClient)(nil)

// DatabaseUsagesClientAPI contains the set of methods on the DatabaseUsagesClient type.
type DatabaseUsagesClientAPI interface {
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseUsageListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseUsageListResultIterator, err error)
}

var _ DatabaseUsagesClientAPI = (*sql.DatabaseUsagesClient)(nil)

// LedgerDigestUploadsClientAPI contains the set of methods on the LedgerDigestUploadsClient type.
type LedgerDigestUploadsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.LedgerDigestUploads) (result sql.LedgerDigestUploadsCreateOrUpdateFuture, err error)
	Disable(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LedgerDigestUploadsDisableFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LedgerDigestUploads, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LedgerDigestUploadsListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.LedgerDigestUploadsListResultIterator, err error)
}

var _ LedgerDigestUploadsClientAPI = (*sql.LedgerDigestUploadsClient)(nil)

// OutboundFirewallRulesClientAPI contains the set of methods on the OutboundFirewallRulesClient type.
type OutboundFirewallRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, outboundRuleFqdn string, parameters sql.OutboundFirewallRule) (result sql.OutboundFirewallRulesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, outboundRuleFqdn string) (result sql.OutboundFirewallRulesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, outboundRuleFqdn string) (result sql.OutboundFirewallRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.OutboundFirewallRuleListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.OutboundFirewallRuleListResultIterator, err error)
}

var _ OutboundFirewallRulesClientAPI = (*sql.OutboundFirewallRulesClient)(nil)

// ServersClientAPI contains the set of methods on the ServersClient type.
type ServersClientAPI interface {
	CheckNameAvailability(ctx context.Context, parameters sql.CheckNameAvailabilityRequest) (result sql.CheckNameAvailabilityResponse, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.Server) (result sql.ServersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, expand string) (result sql.Server, err error)
	ImportDatabase(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ImportNewDatabaseDefinition) (result sql.ServersImportDatabaseFuture, err error)
	List(ctx context.Context, expand string) (result sql.ServerListResultPage, err error)
	ListComplete(ctx context.Context, expand string) (result sql.ServerListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, expand string) (result sql.ServerListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, expand string) (result sql.ServerListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerUpdate) (result sql.ServersUpdateFuture, err error)
}

var _ ServersClientAPI = (*sql.ServersClient)(nil)

// UsagesClientAPI contains the set of methods on the UsagesClient type.
type UsagesClientAPI interface {
	ListByInstancePool(ctx context.Context, resourceGroupName string, instancePoolName string, expandChildren *bool) (result sql.UsageListResultPage, err error)
	ListByInstancePoolComplete(ctx context.Context, resourceGroupName string, instancePoolName string, expandChildren *bool) (result sql.UsageListResultIterator, err error)
}

var _ UsagesClientAPI = (*sql.UsagesClient)(nil)

// LongTermRetentionBackupsClientAPI contains the set of methods on the LongTermRetentionBackupsClient type.
type LongTermRetentionBackupsClientAPI interface {
	Copy(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters sql.CopyLongTermRetentionBackupParameters) (result sql.LongTermRetentionBackupsCopyFuture, err error)
	CopyByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters sql.CopyLongTermRetentionBackupParameters) (result sql.LongTermRetentionBackupsCopyByResourceGroupFuture, err error)
	Delete(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result sql.LongTermRetentionBackupsDeleteFuture, err error)
	DeleteByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result sql.LongTermRetentionBackupsDeleteByResourceGroupFuture, err error)
	Get(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result sql.LongTermRetentionBackup, err error)
	GetByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result sql.LongTermRetentionBackup, err error)
	ListByDatabase(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByLocation(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupDatabase(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupDatabaseComplete(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupLocation(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupLocationComplete(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupServer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupServerComplete(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByServer(ctx context.Context, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByServerComplete(ctx context.Context, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	Update(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters sql.UpdateLongTermRetentionBackupParameters) (result sql.LongTermRetentionBackupsUpdateFuture, err error)
	UpdateByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters sql.UpdateLongTermRetentionBackupParameters) (result sql.LongTermRetentionBackupsUpdateByResourceGroupFuture, err error)
}

var _ LongTermRetentionBackupsClientAPI = (*sql.LongTermRetentionBackupsClient)(nil)

// LongTermRetentionManagedInstanceBackupsClientAPI contains the set of methods on the LongTermRetentionManagedInstanceBackupsClient type.
type LongTermRetentionManagedInstanceBackupsClientAPI interface {
	Delete(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string) (result sql.LongTermRetentionManagedInstanceBackupsDeleteFuture, err error)
	DeleteByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string) (result sql.LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture, err error)
	Get(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string) (result sql.ManagedInstanceLongTermRetentionBackup, err error)
	GetByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string) (result sql.ManagedInstanceLongTermRetentionBackup, err error)
	ListByDatabase(ctx context.Context, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByInstance(ctx context.Context, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByLocation(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupDatabase(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupDatabaseComplete(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupInstance(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupInstanceComplete(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupLocation(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupLocationComplete(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
}

var _ LongTermRetentionManagedInstanceBackupsClientAPI = (*sql.LongTermRetentionManagedInstanceBackupsClient)(nil)

// ManagedInstancesClientAPI contains the set of methods on the ManagedInstancesClient type.
type ManagedInstancesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstance) (result sql.ManagedInstancesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstancesDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, managedInstanceName string, replicaType sql.ReplicaType) (result sql.ManagedInstancesFailoverFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, expand string) (result sql.ManagedInstance, err error)
	List(ctx context.Context, expand string) (result sql.ManagedInstanceListResultPage, err error)
	ListComplete(ctx context.Context, expand string) (result sql.ManagedInstanceListResultIterator, err error)
	ListByInstancePool(ctx context.Context, resourceGroupName string, instancePoolName string, expand string) (result sql.ManagedInstanceListResultPage, err error)
	ListByInstancePoolComplete(ctx context.Context, resourceGroupName string, instancePoolName string, expand string) (result sql.ManagedInstanceListResultIterator, err error)
	ListByManagedInstance(ctx context.Context, resourceGroupName string, managedInstanceName string, numberOfQueries *int32, databases string, startTime string, endTime string, interval sql.QueryTimeGrainType, aggregationFunction sql.AggregationFunctionType, observationMetric sql.MetricType) (result sql.TopQueriesListResultPage, err error)
	ListByManagedInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, numberOfQueries *int32, databases string, startTime string, endTime string, interval sql.QueryTimeGrainType, aggregationFunction sql.AggregationFunctionType, observationMetric sql.MetricType) (result sql.TopQueriesListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, expand string) (result sql.ManagedInstanceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, expand string) (result sql.ManagedInstanceListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceUpdate) (result sql.ManagedInstancesUpdateFuture, err error)
}

var _ ManagedInstancesClientAPI = (*sql.ManagedInstancesClient)(nil)

// RestorableDroppedDatabasesClientAPI contains the set of methods on the RestorableDroppedDatabasesClient type.
type RestorableDroppedDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, restorableDroppedDatabaseID string) (result sql.RestorableDroppedDatabase, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.RestorableDroppedDatabaseListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.RestorableDroppedDatabaseListResultIterator, err error)
}

var _ RestorableDroppedDatabasesClientAPI = (*sql.RestorableDroppedDatabasesClient)(nil)

// RestorableDroppedManagedDatabasesClientAPI contains the set of methods on the RestorableDroppedManagedDatabasesClient type.
type RestorableDroppedManagedDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.RestorableDroppedManagedDatabase, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RestorableDroppedManagedDatabaseListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RestorableDroppedManagedDatabaseListResultIterator, err error)
}

var _ RestorableDroppedManagedDatabasesClientAPI = (*sql.RestorableDroppedManagedDatabasesClient)(nil)

// ServerConnectionPoliciesClientAPI contains the set of methods on the ServerConnectionPoliciesClient type.
type ServerConnectionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerConnectionPolicy) (result sql.ServerConnectionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerConnectionPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerConnectionPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerConnectionPolicyListResultIterator, err error)
}

var _ ServerConnectionPoliciesClientAPI = (*sql.ServerConnectionPoliciesClient)(nil)

// DistributedAvailabilityGroupsClientAPI contains the set of methods on the DistributedAvailabilityGroupsClient type.
type DistributedAvailabilityGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, distributedAvailabilityGroupName string, parameters sql.DistributedAvailabilityGroup) (result sql.DistributedAvailabilityGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, distributedAvailabilityGroupName string) (result sql.DistributedAvailabilityGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, distributedAvailabilityGroupName string) (result sql.DistributedAvailabilityGroup, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.DistributedAvailabilityGroupsListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.DistributedAvailabilityGroupsListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, distributedAvailabilityGroupName string, parameters sql.DistributedAvailabilityGroup) (result sql.DistributedAvailabilityGroupsUpdateFuture, err error)
}

var _ DistributedAvailabilityGroupsClientAPI = (*sql.DistributedAvailabilityGroupsClient)(nil)

// ServerTrustCertificatesClientAPI contains the set of methods on the ServerTrustCertificatesClient type.
type ServerTrustCertificatesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, certificateName string, parameters sql.ServerTrustCertificate) (result sql.ServerTrustCertificatesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, certificateName string) (result sql.ServerTrustCertificatesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, certificateName string) (result sql.ServerTrustCertificate, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ServerTrustCertificatesListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ServerTrustCertificatesListResultIterator, err error)
}

var _ ServerTrustCertificatesClientAPI = (*sql.ServerTrustCertificatesClient)(nil)

// IPv6FirewallRulesClientAPI contains the set of methods on the IPv6FirewallRulesClient type.
type IPv6FirewallRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string, parameters sql.IPv6FirewallRule) (result sql.IPv6FirewallRule, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result sql.IPv6FirewallRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.IPv6FirewallRuleListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.IPv6FirewallRuleListResultIterator, err error)
}

var _ IPv6FirewallRulesClientAPI = (*sql.IPv6FirewallRulesClient)(nil)

// EndpointCertificatesClientAPI contains the set of methods on the EndpointCertificatesClient type.
type EndpointCertificatesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, endpointType string) (result sql.EndpointCertificate, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.EndpointCertificateListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.EndpointCertificateListResultIterator, err error)
}

var _ EndpointCertificatesClientAPI = (*sql.EndpointCertificatesClient)(nil)

// ManagedDatabaseSensitivityLabelsClientAPI contains the set of methods on the ManagedDatabaseSensitivityLabelsClient type.
type ManagedDatabaseSensitivityLabelsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string, parameters sql.SensitivityLabel) (result sql.SensitivityLabel, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	DisableRecommendation(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	EnableRecommendation(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string, sensitivityLabelSource sql.SensitivityLabelSource) (result sql.SensitivityLabel, err error)
	ListCurrentByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, skipToken string, count *bool, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListCurrentByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, skipToken string, count *bool, filter string) (result sql.SensitivityLabelListResultIterator, err error)
	ListRecommendedByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, skipToken string, includeDisabledRecommendations *bool, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListRecommendedByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, skipToken string, includeDisabledRecommendations *bool, filter string) (result sql.SensitivityLabelListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.SensitivityLabelUpdateList) (result autorest.Response, err error)
}

var _ ManagedDatabaseSensitivityLabelsClientAPI = (*sql.ManagedDatabaseSensitivityLabelsClient)(nil)

// ManagedDatabaseRecommendedSensitivityLabelsClientAPI contains the set of methods on the ManagedDatabaseRecommendedSensitivityLabelsClient type.
type ManagedDatabaseRecommendedSensitivityLabelsClientAPI interface {
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.RecommendedSensitivityLabelUpdateList) (result autorest.Response, err error)
}

var _ ManagedDatabaseRecommendedSensitivityLabelsClientAPI = (*sql.ManagedDatabaseRecommendedSensitivityLabelsClient)(nil)

// SensitivityLabelsClientAPI contains the set of methods on the SensitivityLabelsClient type.
type SensitivityLabelsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string, parameters sql.SensitivityLabel) (result sql.SensitivityLabel, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	DisableRecommendation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	EnableRecommendation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string, sensitivityLabelSource sql.SensitivityLabelSource) (result sql.SensitivityLabel, err error)
	ListCurrentByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, skipToken string, count *bool, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListCurrentByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, skipToken string, count *bool, filter string) (result sql.SensitivityLabelListResultIterator, err error)
	ListRecommendedByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, skipToken string, includeDisabledRecommendations *bool, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListRecommendedByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, skipToken string, includeDisabledRecommendations *bool, filter string) (result sql.SensitivityLabelListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.SensitivityLabelUpdateList) (result autorest.Response, err error)
}

var _ SensitivityLabelsClientAPI = (*sql.SensitivityLabelsClient)(nil)

// RecommendedSensitivityLabelsClientAPI contains the set of methods on the RecommendedSensitivityLabelsClient type.
type RecommendedSensitivityLabelsClientAPI interface {
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.RecommendedSensitivityLabelUpdateList) (result autorest.Response, err error)
}

var _ RecommendedSensitivityLabelsClientAPI = (*sql.RecommendedSensitivityLabelsClient)(nil)

// ServerBlobAuditingPoliciesClientAPI contains the set of methods on the ServerBlobAuditingPoliciesClient type.
type ServerBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerBlobAuditingPolicy) (result sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicyListResultIterator, err error)
}

var _ ServerBlobAuditingPoliciesClientAPI = (*sql.ServerBlobAuditingPoliciesClient)(nil)

// DatabaseBlobAuditingPoliciesClientAPI contains the set of methods on the DatabaseBlobAuditingPoliciesClient type.
type DatabaseBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseBlobAuditingPolicy) (result sql.DatabaseBlobAuditingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicyListResultIterator, err error)
}

var _ DatabaseBlobAuditingPoliciesClientAPI = (*sql.DatabaseBlobAuditingPoliciesClient)(nil)

// ExtendedDatabaseBlobAuditingPoliciesClientAPI contains the set of methods on the ExtendedDatabaseBlobAuditingPoliciesClient type.
type ExtendedDatabaseBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ExtendedDatabaseBlobAuditingPolicy) (result sql.ExtendedDatabaseBlobAuditingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicyListResultIterator, err error)
}

var _ ExtendedDatabaseBlobAuditingPoliciesClientAPI = (*sql.ExtendedDatabaseBlobAuditingPoliciesClient)(nil)

// ExtendedServerBlobAuditingPoliciesClientAPI contains the set of methods on the ExtendedServerBlobAuditingPoliciesClient type.
type ExtendedServerBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ExtendedServerBlobAuditingPolicy) (result sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicyListResultIterator, err error)
}

var _ ExtendedServerBlobAuditingPoliciesClientAPI = (*sql.ExtendedServerBlobAuditingPoliciesClient)(nil)

// DatabaseAdvancedThreatProtectionSettingsClientAPI contains the set of methods on the DatabaseAdvancedThreatProtectionSettingsClient type.
type DatabaseAdvancedThreatProtectionSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseAdvancedThreatProtection) (result sql.DatabaseAdvancedThreatProtection, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseAdvancedThreatProtection, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseAdvancedThreatProtectionListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseAdvancedThreatProtectionListResultIterator, err error)
}

var _ DatabaseAdvancedThreatProtectionSettingsClientAPI = (*sql.DatabaseAdvancedThreatProtectionSettingsClient)(nil)

// ServerAdvancedThreatProtectionSettingsClientAPI contains the set of methods on the ServerAdvancedThreatProtectionSettingsClient type.
type ServerAdvancedThreatProtectionSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerAdvancedThreatProtection) (result sql.ServerAdvancedThreatProtectionSettingsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAdvancedThreatProtection, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.LogicalServerAdvancedThreatProtectionListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.LogicalServerAdvancedThreatProtectionListResultIterator, err error)
}

var _ ServerAdvancedThreatProtectionSettingsClientAPI = (*sql.ServerAdvancedThreatProtectionSettingsClient)(nil)

// ManagedServerDNSAliasesClientAPI contains the set of methods on the ManagedServerDNSAliasesClient type.
type ManagedServerDNSAliasesClientAPI interface {
	Acquire(ctx context.Context, resourceGroupName string, managedInstanceName string, DNSAliasName string, parameters sql.ManagedServerDNSAliasAcquisition) (result sql.ManagedServerDNSAliasesAcquireFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, DNSAliasName string, parameters sql.ManagedServerDNSAliasCreation) (result sql.ManagedServerDNSAliasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, DNSAliasName string) (result sql.ManagedServerDNSAliasesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, DNSAliasName string) (result sql.ManagedServerDNSAlias, err error)
	ListByManagedInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedServerDNSAliasListResultPage, err error)
	ListByManagedInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedServerDNSAliasListResultIterator, err error)
}

var _ ManagedServerDNSAliasesClientAPI = (*sql.ManagedServerDNSAliasesClient)(nil)

// DatabaseSQLVulnerabilityAssessmentBaselinesClientAPI contains the set of methods on the DatabaseSQLVulnerabilityAssessmentBaselinesClient type.
type DatabaseSQLVulnerabilityAssessmentBaselinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput) (result sql.DatabaseSQLVulnerabilityAssessmentBaselineSet, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSQLVulnerabilityAssessmentBaselineSet, err error)
	ListBySQLVulnerabilityAssessment(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage, err error)
	ListBySQLVulnerabilityAssessmentComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator, err error)
}

var _ DatabaseSQLVulnerabilityAssessmentBaselinesClientAPI = (*sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient)(nil)

// DatabaseSQLVulnerabilityAssessmentExecuteScanClientAPI contains the set of methods on the DatabaseSQLVulnerabilityAssessmentExecuteScanClient type.
type DatabaseSQLVulnerabilityAssessmentExecuteScanClientAPI interface {
	Execute(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSQLVulnerabilityAssessmentExecuteScanExecuteFuture, err error)
}

var _ DatabaseSQLVulnerabilityAssessmentExecuteScanClientAPI = (*sql.DatabaseSQLVulnerabilityAssessmentExecuteScanClient)(nil)

// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientAPI contains the set of methods on the DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient type.
type DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, parameters sql.DatabaseSQLVulnerabilityAssessmentRuleBaselineInput) (result sql.DatabaseSQLVulnerabilityAssessmentRuleBaseline, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string) (result sql.DatabaseSQLVulnerabilityAssessmentRuleBaseline, err error)
	ListByBaseline(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage, err error)
	ListByBaselineComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator, err error)
}

var _ DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientAPI = (*sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient)(nil)

// DatabaseSQLVulnerabilityAssessmentScanResultClientAPI contains the set of methods on the DatabaseSQLVulnerabilityAssessmentScanResultClient type.
type DatabaseSQLVulnerabilityAssessmentScanResultClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string, scanResultID string) (result sql.VulnerabilityAssessmentScanResults, err error)
	ListByScan(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.VulnerabilityAssessmentScanListResultPage, err error)
	ListByScanComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.VulnerabilityAssessmentScanListResultIterator, err error)
}

var _ DatabaseSQLVulnerabilityAssessmentScanResultClientAPI = (*sql.DatabaseSQLVulnerabilityAssessmentScanResultClient)(nil)

// DatabaseSQLVulnerabilityAssessmentScansClientAPI contains the set of methods on the DatabaseSQLVulnerabilityAssessmentScansClient type.
type DatabaseSQLVulnerabilityAssessmentScansClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.VulnerabilityAssessmentScanRecordType, err error)
	ListBySQLVulnerabilityAssessments(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultTypePage, err error)
	ListBySQLVulnerabilityAssessmentsComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultTypeIterator, err error)
}

var _ DatabaseSQLVulnerabilityAssessmentScansClientAPI = (*sql.DatabaseSQLVulnerabilityAssessmentScansClient)(nil)

// DatabaseSQLVulnerabilityAssessmentsSettingsClientAPI contains the set of methods on the DatabaseSQLVulnerabilityAssessmentsSettingsClient type.
type DatabaseSQLVulnerabilityAssessmentsSettingsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessment, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessmentListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessmentListResultIterator, err error)
}

var _ DatabaseSQLVulnerabilityAssessmentsSettingsClientAPI = (*sql.DatabaseSQLVulnerabilityAssessmentsSettingsClient)(nil)

// ManagedDatabaseAdvancedThreatProtectionSettingsClientAPI contains the set of methods on the ManagedDatabaseAdvancedThreatProtectionSettingsClient type.
type ManagedDatabaseAdvancedThreatProtectionSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseAdvancedThreatProtection) (result sql.ManagedDatabaseAdvancedThreatProtection, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseAdvancedThreatProtection, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseAdvancedThreatProtectionListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseAdvancedThreatProtectionListResultIterator, err error)
}

var _ ManagedDatabaseAdvancedThreatProtectionSettingsClientAPI = (*sql.ManagedDatabaseAdvancedThreatProtectionSettingsClient)(nil)

// ManagedDatabaseRestoreDetailsClientAPI contains the set of methods on the ManagedDatabaseRestoreDetailsClient type.
type ManagedDatabaseRestoreDetailsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseRestoreDetailsResult, err error)
}

var _ ManagedDatabaseRestoreDetailsClientAPI = (*sql.ManagedDatabaseRestoreDetailsClient)(nil)

// ManagedDatabasesClientAPI contains the set of methods on the ManagedDatabasesClient type.
type ManagedDatabasesClientAPI interface {
	CancelMove(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseMoveDefinition) (result sql.ManagedDatabasesCancelMoveFuture, err error)
	CompleteMove(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseMoveDefinition) (result sql.ManagedDatabasesCompleteMoveFuture, err error)
	CompleteRestore(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.CompleteDatabaseRestoreDefinition) (result sql.ManagedDatabasesCompleteRestoreFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabase) (result sql.ManagedDatabasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabasesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabase, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultIterator, err error)
	ListInaccessibleByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultPage, err error)
	ListInaccessibleByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultIterator, err error)
	StartMove(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseStartMoveDefinition) (result sql.ManagedDatabasesStartMoveFuture, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseUpdate) (result sql.ManagedDatabasesUpdateFuture, err error)
}

var _ ManagedDatabasesClientAPI = (*sql.ManagedDatabasesClient)(nil)

// ManagedInstanceAdvancedThreatProtectionSettingsClientAPI contains the set of methods on the ManagedInstanceAdvancedThreatProtectionSettingsClient type.
type ManagedInstanceAdvancedThreatProtectionSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceAdvancedThreatProtection) (result sql.ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdvancedThreatProtection, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdvancedThreatProtectionListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdvancedThreatProtectionListResultIterator, err error)
}

var _ ManagedInstanceAdvancedThreatProtectionSettingsClientAPI = (*sql.ManagedInstanceAdvancedThreatProtectionSettingsClient)(nil)

// ReplicationLinksClientAPI contains the set of methods on the ReplicationLinksClient type.
type ReplicationLinksClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksFailoverFuture, err error)
	FailoverAllowDataLoss(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLink, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ReplicationLinkListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ReplicationLinkListResultIterator, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ReplicationLinkListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ReplicationLinkListResultIterator, err error)
}

var _ ReplicationLinksClientAPI = (*sql.ReplicationLinksClient)(nil)

// VulnerabilityAssessmentBaselineClientAPI contains the set of methods on the VulnerabilityAssessmentBaselineClient type.
type VulnerabilityAssessmentBaselineClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseSQLVulnerabilityAssessmentBaselineSet, err error)
	ListBySQLVulnerabilityAssessment(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage, err error)
	ListBySQLVulnerabilityAssessmentComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator, err error)
}

var _ VulnerabilityAssessmentBaselineClientAPI = (*sql.VulnerabilityAssessmentBaselineClient)(nil)

// VulnerabilityAssessmentBaselinesClientAPI contains the set of methods on the VulnerabilityAssessmentBaselinesClient type.
type VulnerabilityAssessmentBaselinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput) (result sql.DatabaseSQLVulnerabilityAssessmentBaselineSet, err error)
}

var _ VulnerabilityAssessmentBaselinesClientAPI = (*sql.VulnerabilityAssessmentBaselinesClient)(nil)

// VulnerabilityAssessmentExecuteScanClientAPI contains the set of methods on the VulnerabilityAssessmentExecuteScanClient type.
type VulnerabilityAssessmentExecuteScanClientAPI interface {
	Execute(ctx context.Context, resourceGroupName string, serverName string) (result sql.VulnerabilityAssessmentExecuteScanExecuteFuture, err error)
}

var _ VulnerabilityAssessmentExecuteScanClientAPI = (*sql.VulnerabilityAssessmentExecuteScanClient)(nil)

// VulnerabilityAssessmentRuleBaselineClientAPI contains the set of methods on the VulnerabilityAssessmentRuleBaselineClient type.
type VulnerabilityAssessmentRuleBaselineClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, ruleID string, parameters sql.DatabaseSQLVulnerabilityAssessmentRuleBaselineInput) (result sql.DatabaseSQLVulnerabilityAssessmentRuleBaseline, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, ruleID string) (result sql.DatabaseSQLVulnerabilityAssessmentRuleBaseline, err error)
	ListByBaseline(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage, err error)
	ListByBaselineComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator, err error)
}

var _ VulnerabilityAssessmentRuleBaselineClientAPI = (*sql.VulnerabilityAssessmentRuleBaselineClient)(nil)

// VulnerabilityAssessmentRuleBaselinesClientAPI contains the set of methods on the VulnerabilityAssessmentRuleBaselinesClient type.
type VulnerabilityAssessmentRuleBaselinesClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, serverName string, ruleID string) (result autorest.Response, err error)
}

var _ VulnerabilityAssessmentRuleBaselinesClientAPI = (*sql.VulnerabilityAssessmentRuleBaselinesClient)(nil)

// VulnerabilityAssessmentScanResultClientAPI contains the set of methods on the VulnerabilityAssessmentScanResultClient type.
type VulnerabilityAssessmentScanResultClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, scanID string, scanResultID string) (result sql.VulnerabilityAssessmentScanResults, err error)
	ListByScan(ctx context.Context, resourceGroupName string, serverName string, scanID string) (result sql.VulnerabilityAssessmentScanListResultPage, err error)
	ListByScanComplete(ctx context.Context, resourceGroupName string, serverName string, scanID string) (result sql.VulnerabilityAssessmentScanListResultIterator, err error)
}

var _ VulnerabilityAssessmentScanResultClientAPI = (*sql.VulnerabilityAssessmentScanResultClient)(nil)

// VulnerabilityAssessmentScansClientAPI contains the set of methods on the VulnerabilityAssessmentScansClient type.
type VulnerabilityAssessmentScansClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, scanID string) (result sql.VulnerabilityAssessmentScanRecordType, err error)
	ListBySQLVulnerabilityAssessments(ctx context.Context, resourceGroupName string, serverName string) (result sql.VulnerabilityAssessmentScanRecordListResultTypePage, err error)
	ListBySQLVulnerabilityAssessmentsComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.VulnerabilityAssessmentScanRecordListResultTypeIterator, err error)
}

var _ VulnerabilityAssessmentScansClientAPI = (*sql.VulnerabilityAssessmentScansClient)(nil)

// VulnerabilityAssessmentsSettingsClientAPI contains the set of methods on the VulnerabilityAssessmentsSettingsClient type.
type VulnerabilityAssessmentsSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.VulnerabilityAssessment) (result sql.VulnerabilityAssessment, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.VulnerabilityAssessment, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.VulnerabilityAssessmentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.VulnerabilityAssessmentListResultIterator, err error)
}

var _ VulnerabilityAssessmentsSettingsClientAPI = (*sql.VulnerabilityAssessmentsSettingsClient)(nil)

// VulnerabilityAssessmentsClientAPI contains the set of methods on the VulnerabilityAssessmentsClient type.
type VulnerabilityAssessmentsClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result autorest.Response, err error)
}

var _ VulnerabilityAssessmentsClientAPI = (*sql.VulnerabilityAssessmentsClient)(nil)

// ManagedDatabaseMoveOperationsClientAPI contains the set of methods on the ManagedDatabaseMoveOperationsClient type.
type ManagedDatabaseMoveOperationsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, locationName string, operationID uuid.UUID) (result sql.ManagedDatabaseMoveOperationResult, err error)
	ListByLocation(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, filter string) (result sql.ManagedDatabaseMoveOperationListResultPage, err error)
	ListByLocationComplete(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, filter string) (result sql.ManagedDatabaseMoveOperationListResultIterator, err error)
}

var _ ManagedDatabaseMoveOperationsClientAPI = (*sql.ManagedDatabaseMoveOperationsClient)(nil)

// ManagedInstanceDtcsClientAPI contains the set of methods on the ManagedInstanceDtcsClient type.
type ManagedInstanceDtcsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceDtc) (result sql.ManagedInstanceDtcsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceDtc, err error)
	ListByManagedInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceDtcListResultPage, err error)
	ListByManagedInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceDtcListResultIterator, err error)
}

var _ ManagedInstanceDtcsClientAPI = (*sql.ManagedInstanceDtcsClient)(nil)

// SynapseLinkWorkspacesClientAPI contains the set of methods on the SynapseLinkWorkspacesClient type.
type SynapseLinkWorkspacesClientAPI interface {
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.SynapseLinkWorkspaceListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.SynapseLinkWorkspaceListResultIterator, err error)
}

var _ SynapseLinkWorkspacesClientAPI = (*sql.SynapseLinkWorkspacesClient)(nil)

// VirtualClustersClientAPI contains the set of methods on the VirtualClustersClient type.
type VirtualClustersClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, virtualClusterName string) (result sql.VirtualClustersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, virtualClusterName string) (result sql.VirtualCluster, err error)
	List(ctx context.Context) (result sql.VirtualClusterListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.VirtualClusterListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.VirtualClusterListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.VirtualClusterListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, virtualClusterName string, parameters sql.VirtualClusterUpdate) (result sql.VirtualClustersUpdateFuture, err error)
	UpdateDNSServers(ctx context.Context, resourceGroupName string, virtualClusterName string) (result sql.VirtualClustersUpdateDNSServersFuture, err error)
}

var _ VirtualClustersClientAPI = (*sql.VirtualClustersClient)(nil)
