package confidentialledger

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// LedgerRoleName enumerates the values for ledger role name.
type LedgerRoleName string

const (
	// LedgerRoleNameAdministrator ...
	LedgerRoleNameAdministrator LedgerRoleName = "Administrator"
	// LedgerRoleNameContributor ...
	LedgerRoleNameContributor LedgerRoleName = "Contributor"
	// LedgerRoleNameReader ...
	LedgerRoleNameReader LedgerRoleName = "Reader"
)

// PossibleLedgerRoleNameValues returns an array of possible values for the LedgerRoleName const type.
func PossibleLedgerRoleNameValues() []LedgerRoleName {
	return []LedgerRoleName{LedgerRoleNameAdministrator, LedgerRoleNameContributor, LedgerRoleNameReader}
}

// LedgerType enumerates the values for ledger type.
type LedgerType string

const (
	// LedgerTypePrivate ...
	LedgerTypePrivate LedgerType = "Private"
	// LedgerTypePublic ...
	LedgerTypePublic LedgerType = "Public"
	// LedgerTypeUnknown ...
	LedgerTypeUnknown LedgerType = "Unknown"
)

// PossibleLedgerTypeValues returns an array of possible values for the LedgerType const type.
func PossibleLedgerTypeValues() []LedgerType {
	return []LedgerType{LedgerTypePrivate, LedgerTypePublic, LedgerTypeUnknown}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUnknown ...
	ProvisioningStateUnknown ProvisioningState = "Unknown"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUnknown, ProvisioningStateUpdating}
}
