package network

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Access enumerates the values for access.
type Access string

const (
	// Allow ...
	Allow Access = "Allow"
	// Deny ...
	Deny Access = "Deny"
)

// PossibleAccessValues returns an array of possible values for the Access const type.
func PossibleAccessValues() []Access {
	return []Access{Allow, Deny}
}

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeAllow ...
	ActionTypeAllow ActionType = "Allow"
	// ActionTypeAnomalyScoring ...
	ActionTypeAnomalyScoring ActionType = "AnomalyScoring"
	// ActionTypeBlock ...
	ActionTypeBlock ActionType = "Block"
	// ActionTypeLog ...
	ActionTypeLog ActionType = "Log"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeAllow, ActionTypeAnomalyScoring, ActionTypeBlock, ActionTypeLog}
}

// AddressPrefixType enumerates the values for address prefix type.
type AddressPrefixType string

const (
	// IPPrefix ...
	IPPrefix AddressPrefixType = "IPPrefix"
	// ServiceTag ...
	ServiceTag AddressPrefixType = "ServiceTag"
)

// PossibleAddressPrefixTypeValues returns an array of possible values for the AddressPrefixType const type.
func PossibleAddressPrefixTypeValues() []AddressPrefixType {
	return []AddressPrefixType{IPPrefix, ServiceTag}
}

// ApplicationGatewayBackendHealthServerHealth enumerates the values for application gateway backend health
// server health.
type ApplicationGatewayBackendHealthServerHealth string

const (
	// Down ...
	Down ApplicationGatewayBackendHealthServerHealth = "Down"
	// Draining ...
	Draining ApplicationGatewayBackendHealthServerHealth = "Draining"
	// Partial ...
	Partial ApplicationGatewayBackendHealthServerHealth = "Partial"
	// Unknown ...
	Unknown ApplicationGatewayBackendHealthServerHealth = "Unknown"
	// Up ...
	Up ApplicationGatewayBackendHealthServerHealth = "Up"
)

// PossibleApplicationGatewayBackendHealthServerHealthValues returns an array of possible values for the ApplicationGatewayBackendHealthServerHealth const type.
func PossibleApplicationGatewayBackendHealthServerHealthValues() []ApplicationGatewayBackendHealthServerHealth {
	return []ApplicationGatewayBackendHealthServerHealth{Down, Draining, Partial, Unknown, Up}
}

// ApplicationGatewayClientRevocationOptions enumerates the values for application gateway client revocation
// options.
type ApplicationGatewayClientRevocationOptions string

const (
	// None ...
	None ApplicationGatewayClientRevocationOptions = "None"
	// OCSP ...
	OCSP ApplicationGatewayClientRevocationOptions = "OCSP"
)

// PossibleApplicationGatewayClientRevocationOptionsValues returns an array of possible values for the ApplicationGatewayClientRevocationOptions const type.
func PossibleApplicationGatewayClientRevocationOptionsValues() []ApplicationGatewayClientRevocationOptions {
	return []ApplicationGatewayClientRevocationOptions{None, OCSP}
}

// ApplicationGatewayCookieBasedAffinity enumerates the values for application gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// Disabled ...
	Disabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// Enabled ...
	Enabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// PossibleApplicationGatewayCookieBasedAffinityValues returns an array of possible values for the ApplicationGatewayCookieBasedAffinity const type.
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return []ApplicationGatewayCookieBasedAffinity{Disabled, Enabled}
}

// ApplicationGatewayCustomErrorStatusCode enumerates the values for application gateway custom error status
// code.
type ApplicationGatewayCustomErrorStatusCode string

const (
	// HTTPStatus403 ...
	HTTPStatus403 ApplicationGatewayCustomErrorStatusCode = "HttpStatus403"
	// HTTPStatus502 ...
	HTTPStatus502 ApplicationGatewayCustomErrorStatusCode = "HttpStatus502"
)

// PossibleApplicationGatewayCustomErrorStatusCodeValues returns an array of possible values for the ApplicationGatewayCustomErrorStatusCode const type.
func PossibleApplicationGatewayCustomErrorStatusCodeValues() []ApplicationGatewayCustomErrorStatusCode {
	return []ApplicationGatewayCustomErrorStatusCode{HTTPStatus403, HTTPStatus502}
}

// ApplicationGatewayFirewallMode enumerates the values for application gateway firewall mode.
type ApplicationGatewayFirewallMode string

const (
	// Detection ...
	Detection ApplicationGatewayFirewallMode = "Detection"
	// Prevention ...
	Prevention ApplicationGatewayFirewallMode = "Prevention"
)

// PossibleApplicationGatewayFirewallModeValues returns an array of possible values for the ApplicationGatewayFirewallMode const type.
func PossibleApplicationGatewayFirewallModeValues() []ApplicationGatewayFirewallMode {
	return []ApplicationGatewayFirewallMode{Detection, Prevention}
}

// ApplicationGatewayLoadDistributionAlgorithm enumerates the values for application gateway load distribution
// algorithm.
type ApplicationGatewayLoadDistributionAlgorithm string

const (
	// IPHash ...
	IPHash ApplicationGatewayLoadDistributionAlgorithm = "IpHash"
	// LeastConnections ...
	LeastConnections ApplicationGatewayLoadDistributionAlgorithm = "LeastConnections"
	// RoundRobin ...
	RoundRobin ApplicationGatewayLoadDistributionAlgorithm = "RoundRobin"
)

// PossibleApplicationGatewayLoadDistributionAlgorithmValues returns an array of possible values for the ApplicationGatewayLoadDistributionAlgorithm const type.
func PossibleApplicationGatewayLoadDistributionAlgorithmValues() []ApplicationGatewayLoadDistributionAlgorithm {
	return []ApplicationGatewayLoadDistributionAlgorithm{IPHash, LeastConnections, RoundRobin}
}

// ApplicationGatewayOperationalState enumerates the values for application gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// Running ...
	Running ApplicationGatewayOperationalState = "Running"
	// Starting ...
	Starting ApplicationGatewayOperationalState = "Starting"
	// Stopped ...
	Stopped ApplicationGatewayOperationalState = "Stopped"
	// Stopping ...
	Stopping ApplicationGatewayOperationalState = "Stopping"
)

// PossibleApplicationGatewayOperationalStateValues returns an array of possible values for the ApplicationGatewayOperationalState const type.
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return []ApplicationGatewayOperationalState{Running, Starting, Stopped, Stopping}
}

// ApplicationGatewayProtocol enumerates the values for application gateway protocol.
type ApplicationGatewayProtocol string

const (
	// HTTP ...
	HTTP ApplicationGatewayProtocol = "Http"
	// HTTPS ...
	HTTPS ApplicationGatewayProtocol = "Https"
	// TCP ...
	TCP ApplicationGatewayProtocol = "Tcp"
	// TLS ...
	TLS ApplicationGatewayProtocol = "Tls"
)

// PossibleApplicationGatewayProtocolValues returns an array of possible values for the ApplicationGatewayProtocol const type.
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return []ApplicationGatewayProtocol{HTTP, HTTPS, TCP, TLS}
}

// ApplicationGatewayRedirectType enumerates the values for application gateway redirect type.
type ApplicationGatewayRedirectType string

const (
	// Found ...
	Found ApplicationGatewayRedirectType = "Found"
	// Permanent ...
	Permanent ApplicationGatewayRedirectType = "Permanent"
	// SeeOther ...
	SeeOther ApplicationGatewayRedirectType = "SeeOther"
	// Temporary ...
	Temporary ApplicationGatewayRedirectType = "Temporary"
)

// PossibleApplicationGatewayRedirectTypeValues returns an array of possible values for the ApplicationGatewayRedirectType const type.
func PossibleApplicationGatewayRedirectTypeValues() []ApplicationGatewayRedirectType {
	return []ApplicationGatewayRedirectType{Found, Permanent, SeeOther, Temporary}
}

// ApplicationGatewayRequestRoutingRuleType enumerates the values for application gateway request routing rule
// type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// Basic ...
	Basic ApplicationGatewayRequestRoutingRuleType = "Basic"
	// PathBasedRouting ...
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = "PathBasedRouting"
)

// PossibleApplicationGatewayRequestRoutingRuleTypeValues returns an array of possible values for the ApplicationGatewayRequestRoutingRuleType const type.
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return []ApplicationGatewayRequestRoutingRuleType{Basic, PathBasedRouting}
}

// ApplicationGatewayRuleSetStatusOptions enumerates the values for application gateway rule set status
// options.
type ApplicationGatewayRuleSetStatusOptions string

const (
	// Deprecated ...
	Deprecated ApplicationGatewayRuleSetStatusOptions = "Deprecated"
	// GA ...
	GA ApplicationGatewayRuleSetStatusOptions = "GA"
	// Preview ...
	Preview ApplicationGatewayRuleSetStatusOptions = "Preview"
	// Supported ...
	Supported ApplicationGatewayRuleSetStatusOptions = "Supported"
)

// PossibleApplicationGatewayRuleSetStatusOptionsValues returns an array of possible values for the ApplicationGatewayRuleSetStatusOptions const type.
func PossibleApplicationGatewayRuleSetStatusOptionsValues() []ApplicationGatewayRuleSetStatusOptions {
	return []ApplicationGatewayRuleSetStatusOptions{Deprecated, GA, Preview, Supported}
}

// ApplicationGatewaySkuName enumerates the values for application gateway sku name.
type ApplicationGatewaySkuName string

const (
	// StandardBasic ...
	StandardBasic ApplicationGatewaySkuName = "Standard_Basic"
	// StandardLarge ...
	StandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// StandardMedium ...
	StandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// StandardSmall ...
	StandardSmall ApplicationGatewaySkuName = "Standard_Small"
	// StandardV2 ...
	StandardV2 ApplicationGatewaySkuName = "Standard_v2"
	// WAFLarge ...
	WAFLarge ApplicationGatewaySkuName = "WAF_Large"
	// WAFMedium ...
	WAFMedium ApplicationGatewaySkuName = "WAF_Medium"
	// WAFV2 ...
	WAFV2 ApplicationGatewaySkuName = "WAF_v2"
)

// PossibleApplicationGatewaySkuNameValues returns an array of possible values for the ApplicationGatewaySkuName const type.
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return []ApplicationGatewaySkuName{StandardBasic, StandardLarge, StandardMedium, StandardSmall, StandardV2, WAFLarge, WAFMedium, WAFV2}
}

// ApplicationGatewaySslCipherSuite enumerates the values for application gateway ssl cipher suite.
type ApplicationGatewaySslCipherSuite string

const (
	// TLSDHEDSSWITH3DESEDECBCSHA ...
	TLSDHEDSSWITH3DESEDECBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA"
	// TLSDHEDSSWITHAES128CBCSHA ...
	TLSDHEDSSWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA"
	// TLSDHEDSSWITHAES128CBCSHA256 ...
	TLSDHEDSSWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256"
	// TLSDHEDSSWITHAES256CBCSHA ...
	TLSDHEDSSWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA"
	// TLSDHEDSSWITHAES256CBCSHA256 ...
	TLSDHEDSSWITHAES256CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256"
	// TLSDHERSAWITHAES128CBCSHA ...
	TLSDHERSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA"
	// TLSDHERSAWITHAES128GCMSHA256 ...
	TLSDHERSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"
	// TLSDHERSAWITHAES256CBCSHA ...
	TLSDHERSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA"
	// TLSDHERSAWITHAES256GCMSHA384 ...
	TLSDHERSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"
	// TLSECDHEECDSAWITHAES128CBCSHA ...
	TLSECDHEECDSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA"
	// TLSECDHEECDSAWITHAES128CBCSHA256 ...
	TLSECDHEECDSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"
	// TLSECDHEECDSAWITHAES128GCMSHA256 ...
	TLSECDHEECDSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"
	// TLSECDHEECDSAWITHAES256CBCSHA ...
	TLSECDHEECDSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA"
	// TLSECDHEECDSAWITHAES256CBCSHA384 ...
	TLSECDHEECDSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384"
	// TLSECDHEECDSAWITHAES256GCMSHA384 ...
	TLSECDHEECDSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"
	// TLSECDHERSAWITHAES128CBCSHA ...
	TLSECDHERSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"
	// TLSECDHERSAWITHAES128CBCSHA256 ...
	TLSECDHERSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"
	// TLSECDHERSAWITHAES128GCMSHA256 ...
	TLSECDHERSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"
	// TLSECDHERSAWITHAES256CBCSHA ...
	TLSECDHERSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"
	// TLSECDHERSAWITHAES256CBCSHA384 ...
	TLSECDHERSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384"
	// TLSECDHERSAWITHAES256GCMSHA384 ...
	TLSECDHERSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"
	// TLSRSAWITH3DESEDECBCSHA ...
	TLSRSAWITH3DESEDECBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_3DES_EDE_CBC_SHA"
	// TLSRSAWITHAES128CBCSHA ...
	TLSRSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_CBC_SHA"
	// TLSRSAWITHAES128CBCSHA256 ...
	TLSRSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_CBC_SHA256"
	// TLSRSAWITHAES128GCMSHA256 ...
	TLSRSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_GCM_SHA256"
	// TLSRSAWITHAES256CBCSHA ...
	TLSRSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_CBC_SHA"
	// TLSRSAWITHAES256CBCSHA256 ...
	TLSRSAWITHAES256CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_CBC_SHA256"
	// TLSRSAWITHAES256GCMSHA384 ...
	TLSRSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_GCM_SHA384"
)

// PossibleApplicationGatewaySslCipherSuiteValues returns an array of possible values for the ApplicationGatewaySslCipherSuite const type.
func PossibleApplicationGatewaySslCipherSuiteValues() []ApplicationGatewaySslCipherSuite {
	return []ApplicationGatewaySslCipherSuite{TLSDHEDSSWITH3DESEDECBCSHA, TLSDHEDSSWITHAES128CBCSHA, TLSDHEDSSWITHAES128CBCSHA256, TLSDHEDSSWITHAES256CBCSHA, TLSDHEDSSWITHAES256CBCSHA256, TLSDHERSAWITHAES128CBCSHA, TLSDHERSAWITHAES128GCMSHA256, TLSDHERSAWITHAES256CBCSHA, TLSDHERSAWITHAES256GCMSHA384, TLSECDHEECDSAWITHAES128CBCSHA, TLSECDHEECDSAWITHAES128CBCSHA256, TLSECDHEECDSAWITHAES128GCMSHA256, TLSECDHEECDSAWITHAES256CBCSHA, TLSECDHEECDSAWITHAES256CBCSHA384, TLSECDHEECDSAWITHAES256GCMSHA384, TLSECDHERSAWITHAES128CBCSHA, TLSECDHERSAWITHAES128CBCSHA256, TLSECDHERSAWITHAES128GCMSHA256, TLSECDHERSAWITHAES256CBCSHA, TLSECDHERSAWITHAES256CBCSHA384, TLSECDHERSAWITHAES256GCMSHA384, TLSRSAWITH3DESEDECBCSHA, TLSRSAWITHAES128CBCSHA, TLSRSAWITHAES128CBCSHA256, TLSRSAWITHAES128GCMSHA256, TLSRSAWITHAES256CBCSHA, TLSRSAWITHAES256CBCSHA256, TLSRSAWITHAES256GCMSHA384}
}

// ApplicationGatewaySslPolicyName enumerates the values for application gateway ssl policy name.
type ApplicationGatewaySslPolicyName string

const (
	// AppGwSslPolicy20150501 ...
	AppGwSslPolicy20150501 ApplicationGatewaySslPolicyName = "AppGwSslPolicy20150501"
	// AppGwSslPolicy20170401 ...
	AppGwSslPolicy20170401 ApplicationGatewaySslPolicyName = "AppGwSslPolicy20170401"
	// AppGwSslPolicy20170401S ...
	AppGwSslPolicy20170401S ApplicationGatewaySslPolicyName = "AppGwSslPolicy20170401S"
	// AppGwSslPolicy20220101 ...
	AppGwSslPolicy20220101 ApplicationGatewaySslPolicyName = "AppGwSslPolicy20220101"
	// AppGwSslPolicy20220101S ...
	AppGwSslPolicy20220101S ApplicationGatewaySslPolicyName = "AppGwSslPolicy20220101S"
)

// PossibleApplicationGatewaySslPolicyNameValues returns an array of possible values for the ApplicationGatewaySslPolicyName const type.
func PossibleApplicationGatewaySslPolicyNameValues() []ApplicationGatewaySslPolicyName {
	return []ApplicationGatewaySslPolicyName{AppGwSslPolicy20150501, AppGwSslPolicy20170401, AppGwSslPolicy20170401S, AppGwSslPolicy20220101, AppGwSslPolicy20220101S}
}

// ApplicationGatewaySslPolicyType enumerates the values for application gateway ssl policy type.
type ApplicationGatewaySslPolicyType string

const (
	// Custom ...
	Custom ApplicationGatewaySslPolicyType = "Custom"
	// CustomV2 ...
	CustomV2 ApplicationGatewaySslPolicyType = "CustomV2"
	// Predefined ...
	Predefined ApplicationGatewaySslPolicyType = "Predefined"
)

// PossibleApplicationGatewaySslPolicyTypeValues returns an array of possible values for the ApplicationGatewaySslPolicyType const type.
func PossibleApplicationGatewaySslPolicyTypeValues() []ApplicationGatewaySslPolicyType {
	return []ApplicationGatewaySslPolicyType{Custom, CustomV2, Predefined}
}

// ApplicationGatewaySslProtocol enumerates the values for application gateway ssl protocol.
type ApplicationGatewaySslProtocol string

const (
	// TLSv10 ...
	TLSv10 ApplicationGatewaySslProtocol = "TLSv1_0"
	// TLSv11 ...
	TLSv11 ApplicationGatewaySslProtocol = "TLSv1_1"
	// TLSv12 ...
	TLSv12 ApplicationGatewaySslProtocol = "TLSv1_2"
	// TLSv13 ...
	TLSv13 ApplicationGatewaySslProtocol = "TLSv1_3"
)

// PossibleApplicationGatewaySslProtocolValues returns an array of possible values for the ApplicationGatewaySslProtocol const type.
func PossibleApplicationGatewaySslProtocolValues() []ApplicationGatewaySslProtocol {
	return []ApplicationGatewaySslProtocol{TLSv10, TLSv11, TLSv12, TLSv13}
}

// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// ApplicationGatewayTierStandard ...
	ApplicationGatewayTierStandard ApplicationGatewayTier = "Standard"
	// ApplicationGatewayTierStandardBasic ...
	ApplicationGatewayTierStandardBasic ApplicationGatewayTier = "Standard_Basic"
	// ApplicationGatewayTierStandardV2 ...
	ApplicationGatewayTierStandardV2 ApplicationGatewayTier = "Standard_v2"
	// ApplicationGatewayTierWAF ...
	ApplicationGatewayTierWAF ApplicationGatewayTier = "WAF"
	// ApplicationGatewayTierWAFV2 ...
	ApplicationGatewayTierWAFV2 ApplicationGatewayTier = "WAF_v2"
)

// PossibleApplicationGatewayTierValues returns an array of possible values for the ApplicationGatewayTier const type.
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return []ApplicationGatewayTier{ApplicationGatewayTierStandard, ApplicationGatewayTierStandardBasic, ApplicationGatewayTierStandardV2, ApplicationGatewayTierWAF, ApplicationGatewayTierWAFV2}
}

// ApplicationGatewayTierTypes enumerates the values for application gateway tier types.
type ApplicationGatewayTierTypes string

const (
	// ApplicationGatewayTierTypesStandard ...
	ApplicationGatewayTierTypesStandard ApplicationGatewayTierTypes = "Standard"
	// ApplicationGatewayTierTypesStandardV2 ...
	ApplicationGatewayTierTypesStandardV2 ApplicationGatewayTierTypes = "Standard_v2"
	// ApplicationGatewayTierTypesWAF ...
	ApplicationGatewayTierTypesWAF ApplicationGatewayTierTypes = "WAF"
	// ApplicationGatewayTierTypesWAFV2 ...
	ApplicationGatewayTierTypesWAFV2 ApplicationGatewayTierTypes = "WAF_v2"
)

// PossibleApplicationGatewayTierTypesValues returns an array of possible values for the ApplicationGatewayTierTypes const type.
func PossibleApplicationGatewayTierTypesValues() []ApplicationGatewayTierTypes {
	return []ApplicationGatewayTierTypes{ApplicationGatewayTierTypesStandard, ApplicationGatewayTierTypesStandardV2, ApplicationGatewayTierTypesWAF, ApplicationGatewayTierTypesWAFV2}
}

// ApplicationGatewayWafRuleActionTypes enumerates the values for application gateway waf rule action types.
type ApplicationGatewayWafRuleActionTypes string

const (
	// ApplicationGatewayWafRuleActionTypesAllow ...
	ApplicationGatewayWafRuleActionTypesAllow ApplicationGatewayWafRuleActionTypes = "Allow"
	// ApplicationGatewayWafRuleActionTypesAnomalyScoring ...
	ApplicationGatewayWafRuleActionTypesAnomalyScoring ApplicationGatewayWafRuleActionTypes = "AnomalyScoring"
	// ApplicationGatewayWafRuleActionTypesBlock ...
	ApplicationGatewayWafRuleActionTypesBlock ApplicationGatewayWafRuleActionTypes = "Block"
	// ApplicationGatewayWafRuleActionTypesLog ...
	ApplicationGatewayWafRuleActionTypesLog ApplicationGatewayWafRuleActionTypes = "Log"
	// ApplicationGatewayWafRuleActionTypesNone ...
	ApplicationGatewayWafRuleActionTypesNone ApplicationGatewayWafRuleActionTypes = "None"
)

// PossibleApplicationGatewayWafRuleActionTypesValues returns an array of possible values for the ApplicationGatewayWafRuleActionTypes const type.
func PossibleApplicationGatewayWafRuleActionTypesValues() []ApplicationGatewayWafRuleActionTypes {
	return []ApplicationGatewayWafRuleActionTypes{ApplicationGatewayWafRuleActionTypesAllow, ApplicationGatewayWafRuleActionTypesAnomalyScoring, ApplicationGatewayWafRuleActionTypesBlock, ApplicationGatewayWafRuleActionTypesLog, ApplicationGatewayWafRuleActionTypesNone}
}

// ApplicationGatewayWafRuleStateTypes enumerates the values for application gateway waf rule state types.
type ApplicationGatewayWafRuleStateTypes string

const (
	// ApplicationGatewayWafRuleStateTypesDisabled ...
	ApplicationGatewayWafRuleStateTypesDisabled ApplicationGatewayWafRuleStateTypes = "Disabled"
	// ApplicationGatewayWafRuleStateTypesEnabled ...
	ApplicationGatewayWafRuleStateTypesEnabled ApplicationGatewayWafRuleStateTypes = "Enabled"
)

// PossibleApplicationGatewayWafRuleStateTypesValues returns an array of possible values for the ApplicationGatewayWafRuleStateTypes const type.
func PossibleApplicationGatewayWafRuleStateTypesValues() []ApplicationGatewayWafRuleStateTypes {
	return []ApplicationGatewayWafRuleStateTypes{ApplicationGatewayWafRuleStateTypesDisabled, ApplicationGatewayWafRuleStateTypesEnabled}
}

// AssociationType enumerates the values for association type.
type AssociationType string

const (
	// Associated ...
	Associated AssociationType = "Associated"
	// Contains ...
	Contains AssociationType = "Contains"
)

// PossibleAssociationTypeValues returns an array of possible values for the AssociationType const type.
func PossibleAssociationTypeValues() []AssociationType {
	return []AssociationType{Associated, Contains}
}

// AuthenticationMethod enumerates the values for authentication method.
type AuthenticationMethod string

const (
	// EAPMSCHAPv2 ...
	EAPMSCHAPv2 AuthenticationMethod = "EAPMSCHAPv2"
	// EAPTLS ...
	EAPTLS AuthenticationMethod = "EAPTLS"
)

// PossibleAuthenticationMethodValues returns an array of possible values for the AuthenticationMethod const type.
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return []AuthenticationMethod{EAPMSCHAPv2, EAPTLS}
}

// AuthorizationUseStatus enumerates the values for authorization use status.
type AuthorizationUseStatus string

const (
	// Available ...
	Available AuthorizationUseStatus = "Available"
	// InUse ...
	InUse AuthorizationUseStatus = "InUse"
)

// PossibleAuthorizationUseStatusValues returns an array of possible values for the AuthorizationUseStatus const type.
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return []AuthorizationUseStatus{Available, InUse}
}

// AutoLearnPrivateRangesMode enumerates the values for auto learn private ranges mode.
type AutoLearnPrivateRangesMode string

const (
	// AutoLearnPrivateRangesModeDisabled ...
	AutoLearnPrivateRangesModeDisabled AutoLearnPrivateRangesMode = "Disabled"
	// AutoLearnPrivateRangesModeEnabled ...
	AutoLearnPrivateRangesModeEnabled AutoLearnPrivateRangesMode = "Enabled"
)

// PossibleAutoLearnPrivateRangesModeValues returns an array of possible values for the AutoLearnPrivateRangesMode const type.
func PossibleAutoLearnPrivateRangesModeValues() []AutoLearnPrivateRangesMode {
	return []AutoLearnPrivateRangesMode{AutoLearnPrivateRangesModeDisabled, AutoLearnPrivateRangesModeEnabled}
}

// AzureFirewallApplicationRuleProtocolType enumerates the values for azure firewall application rule protocol
// type.
type AzureFirewallApplicationRuleProtocolType string

const (
	// AzureFirewallApplicationRuleProtocolTypeHTTP ...
	AzureFirewallApplicationRuleProtocolTypeHTTP AzureFirewallApplicationRuleProtocolType = "Http"
	// AzureFirewallApplicationRuleProtocolTypeHTTPS ...
	AzureFirewallApplicationRuleProtocolTypeHTTPS AzureFirewallApplicationRuleProtocolType = "Https"
	// AzureFirewallApplicationRuleProtocolTypeMssql ...
	AzureFirewallApplicationRuleProtocolTypeMssql AzureFirewallApplicationRuleProtocolType = "Mssql"
)

// PossibleAzureFirewallApplicationRuleProtocolTypeValues returns an array of possible values for the AzureFirewallApplicationRuleProtocolType const type.
func PossibleAzureFirewallApplicationRuleProtocolTypeValues() []AzureFirewallApplicationRuleProtocolType {
	return []AzureFirewallApplicationRuleProtocolType{AzureFirewallApplicationRuleProtocolTypeHTTP, AzureFirewallApplicationRuleProtocolTypeHTTPS, AzureFirewallApplicationRuleProtocolTypeMssql}
}

// AzureFirewallNatRCActionType enumerates the values for azure firewall nat rc action type.
type AzureFirewallNatRCActionType string

const (
	// Dnat ...
	Dnat AzureFirewallNatRCActionType = "Dnat"
	// Snat ...
	Snat AzureFirewallNatRCActionType = "Snat"
)

// PossibleAzureFirewallNatRCActionTypeValues returns an array of possible values for the AzureFirewallNatRCActionType const type.
func PossibleAzureFirewallNatRCActionTypeValues() []AzureFirewallNatRCActionType {
	return []AzureFirewallNatRCActionType{Dnat, Snat}
}

// AzureFirewallNetworkRuleProtocol enumerates the values for azure firewall network rule protocol.
type AzureFirewallNetworkRuleProtocol string

const (
	// AzureFirewallNetworkRuleProtocolAny ...
	AzureFirewallNetworkRuleProtocolAny AzureFirewallNetworkRuleProtocol = "Any"
	// AzureFirewallNetworkRuleProtocolICMP ...
	AzureFirewallNetworkRuleProtocolICMP AzureFirewallNetworkRuleProtocol = "ICMP"
	// AzureFirewallNetworkRuleProtocolTCP ...
	AzureFirewallNetworkRuleProtocolTCP AzureFirewallNetworkRuleProtocol = "TCP"
	// AzureFirewallNetworkRuleProtocolUDP ...
	AzureFirewallNetworkRuleProtocolUDP AzureFirewallNetworkRuleProtocol = "UDP"
)

// PossibleAzureFirewallNetworkRuleProtocolValues returns an array of possible values for the AzureFirewallNetworkRuleProtocol const type.
func PossibleAzureFirewallNetworkRuleProtocolValues() []AzureFirewallNetworkRuleProtocol {
	return []AzureFirewallNetworkRuleProtocol{AzureFirewallNetworkRuleProtocolAny, AzureFirewallNetworkRuleProtocolICMP, AzureFirewallNetworkRuleProtocolTCP, AzureFirewallNetworkRuleProtocolUDP}
}

// AzureFirewallRCActionType enumerates the values for azure firewall rc action type.
type AzureFirewallRCActionType string

const (
	// AzureFirewallRCActionTypeAllow ...
	AzureFirewallRCActionTypeAllow AzureFirewallRCActionType = "Allow"
	// AzureFirewallRCActionTypeDeny ...
	AzureFirewallRCActionTypeDeny AzureFirewallRCActionType = "Deny"
)

// PossibleAzureFirewallRCActionTypeValues returns an array of possible values for the AzureFirewallRCActionType const type.
func PossibleAzureFirewallRCActionTypeValues() []AzureFirewallRCActionType {
	return []AzureFirewallRCActionType{AzureFirewallRCActionTypeAllow, AzureFirewallRCActionTypeDeny}
}

// AzureFirewallSkuName enumerates the values for azure firewall sku name.
type AzureFirewallSkuName string

const (
	// AZFWHub ...
	AZFWHub AzureFirewallSkuName = "AZFW_Hub"
	// AZFWVNet ...
	AZFWVNet AzureFirewallSkuName = "AZFW_VNet"
)

// PossibleAzureFirewallSkuNameValues returns an array of possible values for the AzureFirewallSkuName const type.
func PossibleAzureFirewallSkuNameValues() []AzureFirewallSkuName {
	return []AzureFirewallSkuName{AZFWHub, AZFWVNet}
}

// AzureFirewallSkuTier enumerates the values for azure firewall sku tier.
type AzureFirewallSkuTier string

const (
	// AzureFirewallSkuTierBasic ...
	AzureFirewallSkuTierBasic AzureFirewallSkuTier = "Basic"
	// AzureFirewallSkuTierPremium ...
	AzureFirewallSkuTierPremium AzureFirewallSkuTier = "Premium"
	// AzureFirewallSkuTierStandard ...
	AzureFirewallSkuTierStandard AzureFirewallSkuTier = "Standard"
)

// PossibleAzureFirewallSkuTierValues returns an array of possible values for the AzureFirewallSkuTier const type.
func PossibleAzureFirewallSkuTierValues() []AzureFirewallSkuTier {
	return []AzureFirewallSkuTier{AzureFirewallSkuTierBasic, AzureFirewallSkuTierPremium, AzureFirewallSkuTierStandard}
}

// AzureFirewallThreatIntelMode enumerates the values for azure firewall threat intel mode.
type AzureFirewallThreatIntelMode string

const (
	// AzureFirewallThreatIntelModeAlert ...
	AzureFirewallThreatIntelModeAlert AzureFirewallThreatIntelMode = "Alert"
	// AzureFirewallThreatIntelModeDeny ...
	AzureFirewallThreatIntelModeDeny AzureFirewallThreatIntelMode = "Deny"
	// AzureFirewallThreatIntelModeOff ...
	AzureFirewallThreatIntelModeOff AzureFirewallThreatIntelMode = "Off"
)

// PossibleAzureFirewallThreatIntelModeValues returns an array of possible values for the AzureFirewallThreatIntelMode const type.
func PossibleAzureFirewallThreatIntelModeValues() []AzureFirewallThreatIntelMode {
	return []AzureFirewallThreatIntelMode{AzureFirewallThreatIntelModeAlert, AzureFirewallThreatIntelModeDeny, AzureFirewallThreatIntelModeOff}
}

// BastionConnectProtocol enumerates the values for bastion connect protocol.
type BastionConnectProtocol string

const (
	// RDP ...
	RDP BastionConnectProtocol = "RDP"
	// SSH ...
	SSH BastionConnectProtocol = "SSH"
)

// PossibleBastionConnectProtocolValues returns an array of possible values for the BastionConnectProtocol const type.
func PossibleBastionConnectProtocolValues() []BastionConnectProtocol {
	return []BastionConnectProtocol{RDP, SSH}
}

// BastionHostSkuName enumerates the values for bastion host sku name.
type BastionHostSkuName string

const (
	// BastionHostSkuNameBasic ...
	BastionHostSkuNameBasic BastionHostSkuName = "Basic"
	// BastionHostSkuNameStandard ...
	BastionHostSkuNameStandard BastionHostSkuName = "Standard"
)

// PossibleBastionHostSkuNameValues returns an array of possible values for the BastionHostSkuName const type.
func PossibleBastionHostSkuNameValues() []BastionHostSkuName {
	return []BastionHostSkuName{BastionHostSkuNameBasic, BastionHostSkuNameStandard}
}

// BgpPeerState enumerates the values for bgp peer state.
type BgpPeerState string

const (
	// BgpPeerStateConnected ...
	BgpPeerStateConnected BgpPeerState = "Connected"
	// BgpPeerStateConnecting ...
	BgpPeerStateConnecting BgpPeerState = "Connecting"
	// BgpPeerStateIdle ...
	BgpPeerStateIdle BgpPeerState = "Idle"
	// BgpPeerStateStopped ...
	BgpPeerStateStopped BgpPeerState = "Stopped"
	// BgpPeerStateUnknown ...
	BgpPeerStateUnknown BgpPeerState = "Unknown"
)

// PossibleBgpPeerStateValues returns an array of possible values for the BgpPeerState const type.
func PossibleBgpPeerStateValues() []BgpPeerState {
	return []BgpPeerState{BgpPeerStateConnected, BgpPeerStateConnecting, BgpPeerStateIdle, BgpPeerStateStopped, BgpPeerStateUnknown}
}

// CircuitConnectionStatus enumerates the values for circuit connection status.
type CircuitConnectionStatus string

const (
	// Connected ...
	Connected CircuitConnectionStatus = "Connected"
	// Connecting ...
	Connecting CircuitConnectionStatus = "Connecting"
	// Disconnected ...
	Disconnected CircuitConnectionStatus = "Disconnected"
)

// PossibleCircuitConnectionStatusValues returns an array of possible values for the CircuitConnectionStatus const type.
func PossibleCircuitConnectionStatusValues() []CircuitConnectionStatus {
	return []CircuitConnectionStatus{Connected, Connecting, Disconnected}
}

// CommissionedState enumerates the values for commissioned state.
type CommissionedState string

const (
	// Commissioned ...
	Commissioned CommissionedState = "Commissioned"
	// CommissionedNoInternetAdvertise ...
	CommissionedNoInternetAdvertise CommissionedState = "CommissionedNoInternetAdvertise"
	// Commissioning ...
	Commissioning CommissionedState = "Commissioning"
	// Decommissioning ...
	Decommissioning CommissionedState = "Decommissioning"
	// Deprovisioned ...
	Deprovisioned CommissionedState = "Deprovisioned"
	// Deprovisioning ...
	Deprovisioning CommissionedState = "Deprovisioning"
	// Provisioned ...
	Provisioned CommissionedState = "Provisioned"
	// Provisioning ...
	Provisioning CommissionedState = "Provisioning"
)

// PossibleCommissionedStateValues returns an array of possible values for the CommissionedState const type.
func PossibleCommissionedStateValues() []CommissionedState {
	return []CommissionedState{Commissioned, CommissionedNoInternetAdvertise, Commissioning, Decommissioning, Deprovisioned, Deprovisioning, Provisioned, Provisioning}
}

// ConfigurationType enumerates the values for configuration type.
type ConfigurationType string

const (
	// Connectivity ...
	Connectivity ConfigurationType = "Connectivity"
	// SecurityAdmin ...
	SecurityAdmin ConfigurationType = "SecurityAdmin"
)

// PossibleConfigurationTypeValues returns an array of possible values for the ConfigurationType const type.
func PossibleConfigurationTypeValues() []ConfigurationType {
	return []ConfigurationType{Connectivity, SecurityAdmin}
}

// ConnectionMonitorEndpointFilterItemType enumerates the values for connection monitor endpoint filter item
// type.
type ConnectionMonitorEndpointFilterItemType string

const (
	// AgentAddress ...
	AgentAddress ConnectionMonitorEndpointFilterItemType = "AgentAddress"
)

// PossibleConnectionMonitorEndpointFilterItemTypeValues returns an array of possible values for the ConnectionMonitorEndpointFilterItemType const type.
func PossibleConnectionMonitorEndpointFilterItemTypeValues() []ConnectionMonitorEndpointFilterItemType {
	return []ConnectionMonitorEndpointFilterItemType{AgentAddress}
}

// ConnectionMonitorEndpointFilterType enumerates the values for connection monitor endpoint filter type.
type ConnectionMonitorEndpointFilterType string

const (
	// Include ...
	Include ConnectionMonitorEndpointFilterType = "Include"
)

// PossibleConnectionMonitorEndpointFilterTypeValues returns an array of possible values for the ConnectionMonitorEndpointFilterType const type.
func PossibleConnectionMonitorEndpointFilterTypeValues() []ConnectionMonitorEndpointFilterType {
	return []ConnectionMonitorEndpointFilterType{Include}
}

// ConnectionMonitorSourceStatus enumerates the values for connection monitor source status.
type ConnectionMonitorSourceStatus string

const (
	// ConnectionMonitorSourceStatusActive ...
	ConnectionMonitorSourceStatusActive ConnectionMonitorSourceStatus = "Active"
	// ConnectionMonitorSourceStatusInactive ...
	ConnectionMonitorSourceStatusInactive ConnectionMonitorSourceStatus = "Inactive"
	// ConnectionMonitorSourceStatusUnknown ...
	ConnectionMonitorSourceStatusUnknown ConnectionMonitorSourceStatus = "Unknown"
)

// PossibleConnectionMonitorSourceStatusValues returns an array of possible values for the ConnectionMonitorSourceStatus const type.
func PossibleConnectionMonitorSourceStatusValues() []ConnectionMonitorSourceStatus {
	return []ConnectionMonitorSourceStatus{ConnectionMonitorSourceStatusActive, ConnectionMonitorSourceStatusInactive, ConnectionMonitorSourceStatusUnknown}
}

// ConnectionMonitorTestConfigurationProtocol enumerates the values for connection monitor test configuration
// protocol.
type ConnectionMonitorTestConfigurationProtocol string

const (
	// ConnectionMonitorTestConfigurationProtocolHTTP ...
	ConnectionMonitorTestConfigurationProtocolHTTP ConnectionMonitorTestConfigurationProtocol = "Http"
	// ConnectionMonitorTestConfigurationProtocolIcmp ...
	ConnectionMonitorTestConfigurationProtocolIcmp ConnectionMonitorTestConfigurationProtocol = "Icmp"
	// ConnectionMonitorTestConfigurationProtocolTCP ...
	ConnectionMonitorTestConfigurationProtocolTCP ConnectionMonitorTestConfigurationProtocol = "Tcp"
)

// PossibleConnectionMonitorTestConfigurationProtocolValues returns an array of possible values for the ConnectionMonitorTestConfigurationProtocol const type.
func PossibleConnectionMonitorTestConfigurationProtocolValues() []ConnectionMonitorTestConfigurationProtocol {
	return []ConnectionMonitorTestConfigurationProtocol{ConnectionMonitorTestConfigurationProtocolHTTP, ConnectionMonitorTestConfigurationProtocolIcmp, ConnectionMonitorTestConfigurationProtocolTCP}
}

// ConnectionMonitorType enumerates the values for connection monitor type.
type ConnectionMonitorType string

const (
	// MultiEndpoint ...
	MultiEndpoint ConnectionMonitorType = "MultiEndpoint"
	// SingleSourceDestination ...
	SingleSourceDestination ConnectionMonitorType = "SingleSourceDestination"
)

// PossibleConnectionMonitorTypeValues returns an array of possible values for the ConnectionMonitorType const type.
func PossibleConnectionMonitorTypeValues() []ConnectionMonitorType {
	return []ConnectionMonitorType{MultiEndpoint, SingleSourceDestination}
}

// ConnectionState enumerates the values for connection state.
type ConnectionState string

const (
	// ConnectionStateReachable ...
	ConnectionStateReachable ConnectionState = "Reachable"
	// ConnectionStateUnknown ...
	ConnectionStateUnknown ConnectionState = "Unknown"
	// ConnectionStateUnreachable ...
	ConnectionStateUnreachable ConnectionState = "Unreachable"
)

// PossibleConnectionStateValues returns an array of possible values for the ConnectionState const type.
func PossibleConnectionStateValues() []ConnectionState {
	return []ConnectionState{ConnectionStateReachable, ConnectionStateUnknown, ConnectionStateUnreachable}
}

// ConnectionStatus enumerates the values for connection status.
type ConnectionStatus string

const (
	// ConnectionStatusConnected ...
	ConnectionStatusConnected ConnectionStatus = "Connected"
	// ConnectionStatusDegraded ...
	ConnectionStatusDegraded ConnectionStatus = "Degraded"
	// ConnectionStatusDisconnected ...
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	// ConnectionStatusUnknown ...
	ConnectionStatusUnknown ConnectionStatus = "Unknown"
)

// PossibleConnectionStatusValues returns an array of possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{ConnectionStatusConnected, ConnectionStatusDegraded, ConnectionStatusDisconnected, ConnectionStatusUnknown}
}

// ConnectivityTopology enumerates the values for connectivity topology.
type ConnectivityTopology string

const (
	// HubAndSpoke ...
	HubAndSpoke ConnectivityTopology = "HubAndSpoke"
	// Mesh ...
	Mesh ConnectivityTopology = "Mesh"
)

// PossibleConnectivityTopologyValues returns an array of possible values for the ConnectivityTopology const type.
func PossibleConnectivityTopologyValues() []ConnectivityTopology {
	return []ConnectivityTopology{HubAndSpoke, Mesh}
}

// CoverageLevel enumerates the values for coverage level.
type CoverageLevel string

const (
	// AboveAverage ...
	AboveAverage CoverageLevel = "AboveAverage"
	// Average ...
	Average CoverageLevel = "Average"
	// BelowAverage ...
	BelowAverage CoverageLevel = "BelowAverage"
	// Default ...
	Default CoverageLevel = "Default"
	// Full ...
	Full CoverageLevel = "Full"
	// Low ...
	Low CoverageLevel = "Low"
)

// PossibleCoverageLevelValues returns an array of possible values for the CoverageLevel const type.
func PossibleCoverageLevelValues() []CoverageLevel {
	return []CoverageLevel{AboveAverage, Average, BelowAverage, Default, Full, Low}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// CustomIPPrefixType enumerates the values for custom ip prefix type.
type CustomIPPrefixType string

const (
	// Child ...
	Child CustomIPPrefixType = "Child"
	// Parent ...
	Parent CustomIPPrefixType = "Parent"
	// Singular ...
	Singular CustomIPPrefixType = "Singular"
)

// PossibleCustomIPPrefixTypeValues returns an array of possible values for the CustomIPPrefixType const type.
func PossibleCustomIPPrefixTypeValues() []CustomIPPrefixType {
	return []CustomIPPrefixType{Child, Parent, Singular}
}

// DdosSettingsProtectionMode enumerates the values for ddos settings protection mode.
type DdosSettingsProtectionMode string

const (
	// DdosSettingsProtectionModeDisabled ...
	DdosSettingsProtectionModeDisabled DdosSettingsProtectionMode = "Disabled"
	// DdosSettingsProtectionModeEnabled ...
	DdosSettingsProtectionModeEnabled DdosSettingsProtectionMode = "Enabled"
	// DdosSettingsProtectionModeVirtualNetworkInherited ...
	DdosSettingsProtectionModeVirtualNetworkInherited DdosSettingsProtectionMode = "VirtualNetworkInherited"
)

// PossibleDdosSettingsProtectionModeValues returns an array of possible values for the DdosSettingsProtectionMode const type.
func PossibleDdosSettingsProtectionModeValues() []DdosSettingsProtectionMode {
	return []DdosSettingsProtectionMode{DdosSettingsProtectionModeDisabled, DdosSettingsProtectionModeEnabled, DdosSettingsProtectionModeVirtualNetworkInherited}
}

// DeleteExistingPeering enumerates the values for delete existing peering.
type DeleteExistingPeering string

const (
	// False ...
	False DeleteExistingPeering = "False"
	// True ...
	True DeleteExistingPeering = "True"
)

// PossibleDeleteExistingPeeringValues returns an array of possible values for the DeleteExistingPeering const type.
func PossibleDeleteExistingPeeringValues() []DeleteExistingPeering {
	return []DeleteExistingPeering{False, True}
}

// DeleteOptions enumerates the values for delete options.
type DeleteOptions string

const (
	// Delete ...
	Delete DeleteOptions = "Delete"
	// Detach ...
	Detach DeleteOptions = "Detach"
)

// PossibleDeleteOptionsValues returns an array of possible values for the DeleteOptions const type.
func PossibleDeleteOptionsValues() []DeleteOptions {
	return []DeleteOptions{Delete, Detach}
}

// DeploymentStatus enumerates the values for deployment status.
type DeploymentStatus string

const (
	// Deployed ...
	Deployed DeploymentStatus = "Deployed"
	// Deploying ...
	Deploying DeploymentStatus = "Deploying"
	// Failed ...
	Failed DeploymentStatus = "Failed"
	// NotStarted ...
	NotStarted DeploymentStatus = "NotStarted"
)

// PossibleDeploymentStatusValues returns an array of possible values for the DeploymentStatus const type.
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return []DeploymentStatus{Deployed, Deploying, Failed, NotStarted}
}

// DestinationPortBehavior enumerates the values for destination port behavior.
type DestinationPortBehavior string

const (
	// DestinationPortBehaviorListenIfAvailable ...
	DestinationPortBehaviorListenIfAvailable DestinationPortBehavior = "ListenIfAvailable"
	// DestinationPortBehaviorNone ...
	DestinationPortBehaviorNone DestinationPortBehavior = "None"
)

// PossibleDestinationPortBehaviorValues returns an array of possible values for the DestinationPortBehavior const type.
func PossibleDestinationPortBehaviorValues() []DestinationPortBehavior {
	return []DestinationPortBehavior{DestinationPortBehaviorListenIfAvailable, DestinationPortBehaviorNone}
}

// DhGroup enumerates the values for dh group.
type DhGroup string

const (
	// DhGroupDHGroup1 ...
	DhGroupDHGroup1 DhGroup = "DHGroup1"
	// DhGroupDHGroup14 ...
	DhGroupDHGroup14 DhGroup = "DHGroup14"
	// DhGroupDHGroup2 ...
	DhGroupDHGroup2 DhGroup = "DHGroup2"
	// DhGroupDHGroup2048 ...
	DhGroupDHGroup2048 DhGroup = "DHGroup2048"
	// DhGroupDHGroup24 ...
	DhGroupDHGroup24 DhGroup = "DHGroup24"
	// DhGroupECP256 ...
	DhGroupECP256 DhGroup = "ECP256"
	// DhGroupECP384 ...
	DhGroupECP384 DhGroup = "ECP384"
	// DhGroupNone ...
	DhGroupNone DhGroup = "None"
)

// PossibleDhGroupValues returns an array of possible values for the DhGroup const type.
func PossibleDhGroupValues() []DhGroup {
	return []DhGroup{DhGroupDHGroup1, DhGroupDHGroup14, DhGroupDHGroup2, DhGroupDHGroup2048, DhGroupDHGroup24, DhGroupECP256, DhGroupECP384, DhGroupNone}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// Inbound ...
	Inbound Direction = "Inbound"
	// Outbound ...
	Outbound Direction = "Outbound"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{Inbound, Outbound}
}

// EffectiveRouteSource enumerates the values for effective route source.
type EffectiveRouteSource string

const (
	// EffectiveRouteSourceDefault ...
	EffectiveRouteSourceDefault EffectiveRouteSource = "Default"
	// EffectiveRouteSourceUnknown ...
	EffectiveRouteSourceUnknown EffectiveRouteSource = "Unknown"
	// EffectiveRouteSourceUser ...
	EffectiveRouteSourceUser EffectiveRouteSource = "User"
	// EffectiveRouteSourceVirtualNetworkGateway ...
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = "VirtualNetworkGateway"
)

// PossibleEffectiveRouteSourceValues returns an array of possible values for the EffectiveRouteSource const type.
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return []EffectiveRouteSource{EffectiveRouteSourceDefault, EffectiveRouteSourceUnknown, EffectiveRouteSourceUser, EffectiveRouteSourceVirtualNetworkGateway}
}

// EffectiveRouteState enumerates the values for effective route state.
type EffectiveRouteState string

const (
	// Active ...
	Active EffectiveRouteState = "Active"
	// Invalid ...
	Invalid EffectiveRouteState = "Invalid"
)

// PossibleEffectiveRouteStateValues returns an array of possible values for the EffectiveRouteState const type.
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return []EffectiveRouteState{Active, Invalid}
}

// EffectiveSecurityRuleProtocol enumerates the values for effective security rule protocol.
type EffectiveSecurityRuleProtocol string

const (
	// EffectiveSecurityRuleProtocolAll ...
	EffectiveSecurityRuleProtocolAll EffectiveSecurityRuleProtocol = "All"
	// EffectiveSecurityRuleProtocolTCP ...
	EffectiveSecurityRuleProtocolTCP EffectiveSecurityRuleProtocol = "Tcp"
	// EffectiveSecurityRuleProtocolUDP ...
	EffectiveSecurityRuleProtocolUDP EffectiveSecurityRuleProtocol = "Udp"
)

// PossibleEffectiveSecurityRuleProtocolValues returns an array of possible values for the EffectiveSecurityRuleProtocol const type.
func PossibleEffectiveSecurityRuleProtocolValues() []EffectiveSecurityRuleProtocol {
	return []EffectiveSecurityRuleProtocol{EffectiveSecurityRuleProtocolAll, EffectiveSecurityRuleProtocolTCP, EffectiveSecurityRuleProtocolUDP}
}

// EndpointType enumerates the values for endpoint type.
type EndpointType string

const (
	// AzureArcVM ...
	AzureArcVM EndpointType = "AzureArcVM"
	// AzureSubnet ...
	AzureSubnet EndpointType = "AzureSubnet"
	// AzureVM ...
	AzureVM EndpointType = "AzureVM"
	// AzureVMSS ...
	AzureVMSS EndpointType = "AzureVMSS"
	// AzureVNet ...
	AzureVNet EndpointType = "AzureVNet"
	// ExternalAddress ...
	ExternalAddress EndpointType = "ExternalAddress"
	// MMAWorkspaceMachine ...
	MMAWorkspaceMachine EndpointType = "MMAWorkspaceMachine"
	// MMAWorkspaceNetwork ...
	MMAWorkspaceNetwork EndpointType = "MMAWorkspaceNetwork"
)

// PossibleEndpointTypeValues returns an array of possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{AzureArcVM, AzureSubnet, AzureVM, AzureVMSS, AzureVNet, ExternalAddress, MMAWorkspaceMachine, MMAWorkspaceNetwork}
}

// EvaluationState enumerates the values for evaluation state.
type EvaluationState string

const (
	// EvaluationStateCompleted ...
	EvaluationStateCompleted EvaluationState = "Completed"
	// EvaluationStateInProgress ...
	EvaluationStateInProgress EvaluationState = "InProgress"
	// EvaluationStateNotStarted ...
	EvaluationStateNotStarted EvaluationState = "NotStarted"
)

// PossibleEvaluationStateValues returns an array of possible values for the EvaluationState const type.
func PossibleEvaluationStateValues() []EvaluationState {
	return []EvaluationState{EvaluationStateCompleted, EvaluationStateInProgress, EvaluationStateNotStarted}
}

// ExpressRouteCircuitPeeringAdvertisedPublicPrefixState enumerates the values for express route circuit
// peering advertised public prefix state.
type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState string

const (
	// Configured ...
	Configured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configured"
	// Configuring ...
	Configuring ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configuring"
	// NotConfigured ...
	NotConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "NotConfigured"
	// ValidationNeeded ...
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "ValidationNeeded"
)

// PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues returns an array of possible values for the ExpressRouteCircuitPeeringAdvertisedPublicPrefixState const type.
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState{Configured, Configuring, NotConfigured, ValidationNeeded}
}

// ExpressRouteCircuitPeeringState enumerates the values for express route circuit peering state.
type ExpressRouteCircuitPeeringState string

const (
	// ExpressRouteCircuitPeeringStateDisabled ...
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = "Disabled"
	// ExpressRouteCircuitPeeringStateEnabled ...
	ExpressRouteCircuitPeeringStateEnabled ExpressRouteCircuitPeeringState = "Enabled"
)

// PossibleExpressRouteCircuitPeeringStateValues returns an array of possible values for the ExpressRouteCircuitPeeringState const type.
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return []ExpressRouteCircuitPeeringState{ExpressRouteCircuitPeeringStateDisabled, ExpressRouteCircuitPeeringStateEnabled}
}

// ExpressRouteCircuitSkuFamily enumerates the values for express route circuit sku family.
type ExpressRouteCircuitSkuFamily string

const (
	// MeteredData ...
	MeteredData ExpressRouteCircuitSkuFamily = "MeteredData"
	// UnlimitedData ...
	UnlimitedData ExpressRouteCircuitSkuFamily = "UnlimitedData"
)

// PossibleExpressRouteCircuitSkuFamilyValues returns an array of possible values for the ExpressRouteCircuitSkuFamily const type.
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return []ExpressRouteCircuitSkuFamily{MeteredData, UnlimitedData}
}

// ExpressRouteCircuitSkuTier enumerates the values for express route circuit sku tier.
type ExpressRouteCircuitSkuTier string

const (
	// ExpressRouteCircuitSkuTierBasic ...
	ExpressRouteCircuitSkuTierBasic ExpressRouteCircuitSkuTier = "Basic"
	// ExpressRouteCircuitSkuTierLocal ...
	ExpressRouteCircuitSkuTierLocal ExpressRouteCircuitSkuTier = "Local"
	// ExpressRouteCircuitSkuTierPremium ...
	ExpressRouteCircuitSkuTierPremium ExpressRouteCircuitSkuTier = "Premium"
	// ExpressRouteCircuitSkuTierStandard ...
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = "Standard"
)

// PossibleExpressRouteCircuitSkuTierValues returns an array of possible values for the ExpressRouteCircuitSkuTier const type.
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return []ExpressRouteCircuitSkuTier{ExpressRouteCircuitSkuTierBasic, ExpressRouteCircuitSkuTierLocal, ExpressRouteCircuitSkuTierPremium, ExpressRouteCircuitSkuTierStandard}
}

// ExpressRouteLinkAdminState enumerates the values for express route link admin state.
type ExpressRouteLinkAdminState string

const (
	// ExpressRouteLinkAdminStateDisabled ...
	ExpressRouteLinkAdminStateDisabled ExpressRouteLinkAdminState = "Disabled"
	// ExpressRouteLinkAdminStateEnabled ...
	ExpressRouteLinkAdminStateEnabled ExpressRouteLinkAdminState = "Enabled"
)

// PossibleExpressRouteLinkAdminStateValues returns an array of possible values for the ExpressRouteLinkAdminState const type.
func PossibleExpressRouteLinkAdminStateValues() []ExpressRouteLinkAdminState {
	return []ExpressRouteLinkAdminState{ExpressRouteLinkAdminStateDisabled, ExpressRouteLinkAdminStateEnabled}
}

// ExpressRouteLinkConnectorType enumerates the values for express route link connector type.
type ExpressRouteLinkConnectorType string

const (
	// LC ...
	LC ExpressRouteLinkConnectorType = "LC"
	// SC ...
	SC ExpressRouteLinkConnectorType = "SC"
)

// PossibleExpressRouteLinkConnectorTypeValues returns an array of possible values for the ExpressRouteLinkConnectorType const type.
func PossibleExpressRouteLinkConnectorTypeValues() []ExpressRouteLinkConnectorType {
	return []ExpressRouteLinkConnectorType{LC, SC}
}

// ExpressRouteLinkMacSecCipher enumerates the values for express route link mac sec cipher.
type ExpressRouteLinkMacSecCipher string

const (
	// GcmAes128 ...
	GcmAes128 ExpressRouteLinkMacSecCipher = "GcmAes128"
	// GcmAes256 ...
	GcmAes256 ExpressRouteLinkMacSecCipher = "GcmAes256"
	// GcmAesXpn128 ...
	GcmAesXpn128 ExpressRouteLinkMacSecCipher = "GcmAesXpn128"
	// GcmAesXpn256 ...
	GcmAesXpn256 ExpressRouteLinkMacSecCipher = "GcmAesXpn256"
)

// PossibleExpressRouteLinkMacSecCipherValues returns an array of possible values for the ExpressRouteLinkMacSecCipher const type.
func PossibleExpressRouteLinkMacSecCipherValues() []ExpressRouteLinkMacSecCipher {
	return []ExpressRouteLinkMacSecCipher{GcmAes128, GcmAes256, GcmAesXpn128, GcmAesXpn256}
}

// ExpressRouteLinkMacSecSciState enumerates the values for express route link mac sec sci state.
type ExpressRouteLinkMacSecSciState string

const (
	// ExpressRouteLinkMacSecSciStateDisabled ...
	ExpressRouteLinkMacSecSciStateDisabled ExpressRouteLinkMacSecSciState = "Disabled"
	// ExpressRouteLinkMacSecSciStateEnabled ...
	ExpressRouteLinkMacSecSciStateEnabled ExpressRouteLinkMacSecSciState = "Enabled"
)

// PossibleExpressRouteLinkMacSecSciStateValues returns an array of possible values for the ExpressRouteLinkMacSecSciState const type.
func PossibleExpressRouteLinkMacSecSciStateValues() []ExpressRouteLinkMacSecSciState {
	return []ExpressRouteLinkMacSecSciState{ExpressRouteLinkMacSecSciStateDisabled, ExpressRouteLinkMacSecSciStateEnabled}
}

// ExpressRoutePeeringState enumerates the values for express route peering state.
type ExpressRoutePeeringState string

const (
	// ExpressRoutePeeringStateDisabled ...
	ExpressRoutePeeringStateDisabled ExpressRoutePeeringState = "Disabled"
	// ExpressRoutePeeringStateEnabled ...
	ExpressRoutePeeringStateEnabled ExpressRoutePeeringState = "Enabled"
)

// PossibleExpressRoutePeeringStateValues returns an array of possible values for the ExpressRoutePeeringState const type.
func PossibleExpressRoutePeeringStateValues() []ExpressRoutePeeringState {
	return []ExpressRoutePeeringState{ExpressRoutePeeringStateDisabled, ExpressRoutePeeringStateEnabled}
}

// ExpressRoutePeeringType enumerates the values for express route peering type.
type ExpressRoutePeeringType string

const (
	// AzurePrivatePeering ...
	AzurePrivatePeering ExpressRoutePeeringType = "AzurePrivatePeering"
	// AzurePublicPeering ...
	AzurePublicPeering ExpressRoutePeeringType = "AzurePublicPeering"
	// MicrosoftPeering ...
	MicrosoftPeering ExpressRoutePeeringType = "MicrosoftPeering"
)

// PossibleExpressRoutePeeringTypeValues returns an array of possible values for the ExpressRoutePeeringType const type.
func PossibleExpressRoutePeeringTypeValues() []ExpressRoutePeeringType {
	return []ExpressRoutePeeringType{AzurePrivatePeering, AzurePublicPeering, MicrosoftPeering}
}

// ExpressRoutePortAuthorizationUseStatus enumerates the values for express route port authorization use
// status.
type ExpressRoutePortAuthorizationUseStatus string

const (
	// ExpressRoutePortAuthorizationUseStatusAvailable ...
	ExpressRoutePortAuthorizationUseStatusAvailable ExpressRoutePortAuthorizationUseStatus = "Available"
	// ExpressRoutePortAuthorizationUseStatusInUse ...
	ExpressRoutePortAuthorizationUseStatusInUse ExpressRoutePortAuthorizationUseStatus = "InUse"
)

// PossibleExpressRoutePortAuthorizationUseStatusValues returns an array of possible values for the ExpressRoutePortAuthorizationUseStatus const type.
func PossibleExpressRoutePortAuthorizationUseStatusValues() []ExpressRoutePortAuthorizationUseStatus {
	return []ExpressRoutePortAuthorizationUseStatus{ExpressRoutePortAuthorizationUseStatusAvailable, ExpressRoutePortAuthorizationUseStatusInUse}
}

// ExpressRoutePortsBillingType enumerates the values for express route ports billing type.
type ExpressRoutePortsBillingType string

const (
	// ExpressRoutePortsBillingTypeMeteredData ...
	ExpressRoutePortsBillingTypeMeteredData ExpressRoutePortsBillingType = "MeteredData"
	// ExpressRoutePortsBillingTypeUnlimitedData ...
	ExpressRoutePortsBillingTypeUnlimitedData ExpressRoutePortsBillingType = "UnlimitedData"
)

// PossibleExpressRoutePortsBillingTypeValues returns an array of possible values for the ExpressRoutePortsBillingType const type.
func PossibleExpressRoutePortsBillingTypeValues() []ExpressRoutePortsBillingType {
	return []ExpressRoutePortsBillingType{ExpressRoutePortsBillingTypeMeteredData, ExpressRoutePortsBillingTypeUnlimitedData}
}

// ExpressRoutePortsEncapsulation enumerates the values for express route ports encapsulation.
type ExpressRoutePortsEncapsulation string

const (
	// Dot1Q ...
	Dot1Q ExpressRoutePortsEncapsulation = "Dot1Q"
	// QinQ ...
	QinQ ExpressRoutePortsEncapsulation = "QinQ"
)

// PossibleExpressRoutePortsEncapsulationValues returns an array of possible values for the ExpressRoutePortsEncapsulation const type.
func PossibleExpressRoutePortsEncapsulationValues() []ExpressRoutePortsEncapsulation {
	return []ExpressRoutePortsEncapsulation{Dot1Q, QinQ}
}

// ExtendedLocationTypes enumerates the values for extended location types.
type ExtendedLocationTypes string

const (
	// EdgeZone ...
	EdgeZone ExtendedLocationTypes = "EdgeZone"
)

// PossibleExtendedLocationTypesValues returns an array of possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{EdgeZone}
}

// FirewallPolicyFilterRuleCollectionActionType enumerates the values for firewall policy filter rule
// collection action type.
type FirewallPolicyFilterRuleCollectionActionType string

const (
	// FirewallPolicyFilterRuleCollectionActionTypeAllow ...
	FirewallPolicyFilterRuleCollectionActionTypeAllow FirewallPolicyFilterRuleCollectionActionType = "Allow"
	// FirewallPolicyFilterRuleCollectionActionTypeDeny ...
	FirewallPolicyFilterRuleCollectionActionTypeDeny FirewallPolicyFilterRuleCollectionActionType = "Deny"
)

// PossibleFirewallPolicyFilterRuleCollectionActionTypeValues returns an array of possible values for the FirewallPolicyFilterRuleCollectionActionType const type.
func PossibleFirewallPolicyFilterRuleCollectionActionTypeValues() []FirewallPolicyFilterRuleCollectionActionType {
	return []FirewallPolicyFilterRuleCollectionActionType{FirewallPolicyFilterRuleCollectionActionTypeAllow, FirewallPolicyFilterRuleCollectionActionTypeDeny}
}

// FirewallPolicyIDPSQuerySortOrder enumerates the values for firewall policy idps query sort order.
type FirewallPolicyIDPSQuerySortOrder string

const (
	// Ascending ...
	Ascending FirewallPolicyIDPSQuerySortOrder = "Ascending"
	// Descending ...
	Descending FirewallPolicyIDPSQuerySortOrder = "Descending"
)

// PossibleFirewallPolicyIDPSQuerySortOrderValues returns an array of possible values for the FirewallPolicyIDPSQuerySortOrder const type.
func PossibleFirewallPolicyIDPSQuerySortOrderValues() []FirewallPolicyIDPSQuerySortOrder {
	return []FirewallPolicyIDPSQuerySortOrder{Ascending, Descending}
}

// FirewallPolicyIntrusionDetectionProtocol enumerates the values for firewall policy intrusion detection
// protocol.
type FirewallPolicyIntrusionDetectionProtocol string

const (
	// FirewallPolicyIntrusionDetectionProtocolANY ...
	FirewallPolicyIntrusionDetectionProtocolANY FirewallPolicyIntrusionDetectionProtocol = "ANY"
	// FirewallPolicyIntrusionDetectionProtocolICMP ...
	FirewallPolicyIntrusionDetectionProtocolICMP FirewallPolicyIntrusionDetectionProtocol = "ICMP"
	// FirewallPolicyIntrusionDetectionProtocolTCP ...
	FirewallPolicyIntrusionDetectionProtocolTCP FirewallPolicyIntrusionDetectionProtocol = "TCP"
	// FirewallPolicyIntrusionDetectionProtocolUDP ...
	FirewallPolicyIntrusionDetectionProtocolUDP FirewallPolicyIntrusionDetectionProtocol = "UDP"
)

// PossibleFirewallPolicyIntrusionDetectionProtocolValues returns an array of possible values for the FirewallPolicyIntrusionDetectionProtocol const type.
func PossibleFirewallPolicyIntrusionDetectionProtocolValues() []FirewallPolicyIntrusionDetectionProtocol {
	return []FirewallPolicyIntrusionDetectionProtocol{FirewallPolicyIntrusionDetectionProtocolANY, FirewallPolicyIntrusionDetectionProtocolICMP, FirewallPolicyIntrusionDetectionProtocolTCP, FirewallPolicyIntrusionDetectionProtocolUDP}
}

// FirewallPolicyIntrusionDetectionStateType enumerates the values for firewall policy intrusion detection
// state type.
type FirewallPolicyIntrusionDetectionStateType string

const (
	// FirewallPolicyIntrusionDetectionStateTypeAlert ...
	FirewallPolicyIntrusionDetectionStateTypeAlert FirewallPolicyIntrusionDetectionStateType = "Alert"
	// FirewallPolicyIntrusionDetectionStateTypeDeny ...
	FirewallPolicyIntrusionDetectionStateTypeDeny FirewallPolicyIntrusionDetectionStateType = "Deny"
	// FirewallPolicyIntrusionDetectionStateTypeOff ...
	FirewallPolicyIntrusionDetectionStateTypeOff FirewallPolicyIntrusionDetectionStateType = "Off"
)

// PossibleFirewallPolicyIntrusionDetectionStateTypeValues returns an array of possible values for the FirewallPolicyIntrusionDetectionStateType const type.
func PossibleFirewallPolicyIntrusionDetectionStateTypeValues() []FirewallPolicyIntrusionDetectionStateType {
	return []FirewallPolicyIntrusionDetectionStateType{FirewallPolicyIntrusionDetectionStateTypeAlert, FirewallPolicyIntrusionDetectionStateTypeDeny, FirewallPolicyIntrusionDetectionStateTypeOff}
}

// FirewallPolicyNatRuleCollectionActionType enumerates the values for firewall policy nat rule collection
// action type.
type FirewallPolicyNatRuleCollectionActionType string

const (
	// DNAT ...
	DNAT FirewallPolicyNatRuleCollectionActionType = "DNAT"
)

// PossibleFirewallPolicyNatRuleCollectionActionTypeValues returns an array of possible values for the FirewallPolicyNatRuleCollectionActionType const type.
func PossibleFirewallPolicyNatRuleCollectionActionTypeValues() []FirewallPolicyNatRuleCollectionActionType {
	return []FirewallPolicyNatRuleCollectionActionType{DNAT}
}

// FirewallPolicyRuleApplicationProtocolType enumerates the values for firewall policy rule application
// protocol type.
type FirewallPolicyRuleApplicationProtocolType string

const (
	// FirewallPolicyRuleApplicationProtocolTypeHTTP ...
	FirewallPolicyRuleApplicationProtocolTypeHTTP FirewallPolicyRuleApplicationProtocolType = "Http"
	// FirewallPolicyRuleApplicationProtocolTypeHTTPS ...
	FirewallPolicyRuleApplicationProtocolTypeHTTPS FirewallPolicyRuleApplicationProtocolType = "Https"
)

// PossibleFirewallPolicyRuleApplicationProtocolTypeValues returns an array of possible values for the FirewallPolicyRuleApplicationProtocolType const type.
func PossibleFirewallPolicyRuleApplicationProtocolTypeValues() []FirewallPolicyRuleApplicationProtocolType {
	return []FirewallPolicyRuleApplicationProtocolType{FirewallPolicyRuleApplicationProtocolTypeHTTP, FirewallPolicyRuleApplicationProtocolTypeHTTPS}
}

// FirewallPolicyRuleNetworkProtocol enumerates the values for firewall policy rule network protocol.
type FirewallPolicyRuleNetworkProtocol string

const (
	// FirewallPolicyRuleNetworkProtocolAny ...
	FirewallPolicyRuleNetworkProtocolAny FirewallPolicyRuleNetworkProtocol = "Any"
	// FirewallPolicyRuleNetworkProtocolICMP ...
	FirewallPolicyRuleNetworkProtocolICMP FirewallPolicyRuleNetworkProtocol = "ICMP"
	// FirewallPolicyRuleNetworkProtocolTCP ...
	FirewallPolicyRuleNetworkProtocolTCP FirewallPolicyRuleNetworkProtocol = "TCP"
	// FirewallPolicyRuleNetworkProtocolUDP ...
	FirewallPolicyRuleNetworkProtocolUDP FirewallPolicyRuleNetworkProtocol = "UDP"
)

// PossibleFirewallPolicyRuleNetworkProtocolValues returns an array of possible values for the FirewallPolicyRuleNetworkProtocol const type.
func PossibleFirewallPolicyRuleNetworkProtocolValues() []FirewallPolicyRuleNetworkProtocol {
	return []FirewallPolicyRuleNetworkProtocol{FirewallPolicyRuleNetworkProtocolAny, FirewallPolicyRuleNetworkProtocolICMP, FirewallPolicyRuleNetworkProtocolTCP, FirewallPolicyRuleNetworkProtocolUDP}
}

// FirewallPolicySkuTier enumerates the values for firewall policy sku tier.
type FirewallPolicySkuTier string

const (
	// FirewallPolicySkuTierBasic ...
	FirewallPolicySkuTierBasic FirewallPolicySkuTier = "Basic"
	// FirewallPolicySkuTierPremium ...
	FirewallPolicySkuTierPremium FirewallPolicySkuTier = "Premium"
	// FirewallPolicySkuTierStandard ...
	FirewallPolicySkuTierStandard FirewallPolicySkuTier = "Standard"
)

// PossibleFirewallPolicySkuTierValues returns an array of possible values for the FirewallPolicySkuTier const type.
func PossibleFirewallPolicySkuTierValues() []FirewallPolicySkuTier {
	return []FirewallPolicySkuTier{FirewallPolicySkuTierBasic, FirewallPolicySkuTierPremium, FirewallPolicySkuTierStandard}
}

// FlowLogFormatType enumerates the values for flow log format type.
type FlowLogFormatType string

const (
	// JSON ...
	JSON FlowLogFormatType = "JSON"
)

// PossibleFlowLogFormatTypeValues returns an array of possible values for the FlowLogFormatType const type.
func PossibleFlowLogFormatTypeValues() []FlowLogFormatType {
	return []FlowLogFormatType{JSON}
}

// GatewayLoadBalancerTunnelInterfaceType enumerates the values for gateway load balancer tunnel interface
// type.
type GatewayLoadBalancerTunnelInterfaceType string

const (
	// GatewayLoadBalancerTunnelInterfaceTypeExternal ...
	GatewayLoadBalancerTunnelInterfaceTypeExternal GatewayLoadBalancerTunnelInterfaceType = "External"
	// GatewayLoadBalancerTunnelInterfaceTypeInternal ...
	GatewayLoadBalancerTunnelInterfaceTypeInternal GatewayLoadBalancerTunnelInterfaceType = "Internal"
	// GatewayLoadBalancerTunnelInterfaceTypeNone ...
	GatewayLoadBalancerTunnelInterfaceTypeNone GatewayLoadBalancerTunnelInterfaceType = "None"
)

// PossibleGatewayLoadBalancerTunnelInterfaceTypeValues returns an array of possible values for the GatewayLoadBalancerTunnelInterfaceType const type.
func PossibleGatewayLoadBalancerTunnelInterfaceTypeValues() []GatewayLoadBalancerTunnelInterfaceType {
	return []GatewayLoadBalancerTunnelInterfaceType{GatewayLoadBalancerTunnelInterfaceTypeExternal, GatewayLoadBalancerTunnelInterfaceTypeInternal, GatewayLoadBalancerTunnelInterfaceTypeNone}
}

// GatewayLoadBalancerTunnelProtocol enumerates the values for gateway load balancer tunnel protocol.
type GatewayLoadBalancerTunnelProtocol string

const (
	// GatewayLoadBalancerTunnelProtocolNative ...
	GatewayLoadBalancerTunnelProtocolNative GatewayLoadBalancerTunnelProtocol = "Native"
	// GatewayLoadBalancerTunnelProtocolNone ...
	GatewayLoadBalancerTunnelProtocolNone GatewayLoadBalancerTunnelProtocol = "None"
	// GatewayLoadBalancerTunnelProtocolVXLAN ...
	GatewayLoadBalancerTunnelProtocolVXLAN GatewayLoadBalancerTunnelProtocol = "VXLAN"
)

// PossibleGatewayLoadBalancerTunnelProtocolValues returns an array of possible values for the GatewayLoadBalancerTunnelProtocol const type.
func PossibleGatewayLoadBalancerTunnelProtocolValues() []GatewayLoadBalancerTunnelProtocol {
	return []GatewayLoadBalancerTunnelProtocol{GatewayLoadBalancerTunnelProtocolNative, GatewayLoadBalancerTunnelProtocolNone, GatewayLoadBalancerTunnelProtocolVXLAN}
}

// Geo enumerates the values for geo.
type Geo string

const (
	// AFRI ...
	AFRI Geo = "AFRI"
	// APAC ...
	APAC Geo = "APAC"
	// AQ ...
	AQ Geo = "AQ"
	// EURO ...
	EURO Geo = "EURO"
	// GLOBAL ...
	GLOBAL Geo = "GLOBAL"
	// LATAM ...
	LATAM Geo = "LATAM"
	// ME ...
	ME Geo = "ME"
	// NAM ...
	NAM Geo = "NAM"
	// OCEANIA ...
	OCEANIA Geo = "OCEANIA"
)

// PossibleGeoValues returns an array of possible values for the Geo const type.
func PossibleGeoValues() []Geo {
	return []Geo{AFRI, APAC, AQ, EURO, GLOBAL, LATAM, ME, NAM, OCEANIA}
}

// GroupConnectivity enumerates the values for group connectivity.
type GroupConnectivity string

const (
	// GroupConnectivityDirectlyConnected ...
	GroupConnectivityDirectlyConnected GroupConnectivity = "DirectlyConnected"
	// GroupConnectivityNone ...
	GroupConnectivityNone GroupConnectivity = "None"
)

// PossibleGroupConnectivityValues returns an array of possible values for the GroupConnectivity const type.
func PossibleGroupConnectivityValues() []GroupConnectivity {
	return []GroupConnectivity{GroupConnectivityDirectlyConnected, GroupConnectivityNone}
}

// HTTPConfigurationMethod enumerates the values for http configuration method.
type HTTPConfigurationMethod string

const (
	// Get ...
	Get HTTPConfigurationMethod = "Get"
	// Post ...
	Post HTTPConfigurationMethod = "Post"
)

// PossibleHTTPConfigurationMethodValues returns an array of possible values for the HTTPConfigurationMethod const type.
func PossibleHTTPConfigurationMethodValues() []HTTPConfigurationMethod {
	return []HTTPConfigurationMethod{Get, Post}
}

// HTTPMethod enumerates the values for http method.
type HTTPMethod string

const (
	// HTTPMethodGet ...
	HTTPMethodGet HTTPMethod = "Get"
)

// PossibleHTTPMethodValues returns an array of possible values for the HTTPMethod const type.
func PossibleHTTPMethodValues() []HTTPMethod {
	return []HTTPMethod{HTTPMethodGet}
}

// HubBgpConnectionStatus enumerates the values for hub bgp connection status.
type HubBgpConnectionStatus string

const (
	// HubBgpConnectionStatusConnected ...
	HubBgpConnectionStatusConnected HubBgpConnectionStatus = "Connected"
	// HubBgpConnectionStatusConnecting ...
	HubBgpConnectionStatusConnecting HubBgpConnectionStatus = "Connecting"
	// HubBgpConnectionStatusNotConnected ...
	HubBgpConnectionStatusNotConnected HubBgpConnectionStatus = "NotConnected"
	// HubBgpConnectionStatusUnknown ...
	HubBgpConnectionStatusUnknown HubBgpConnectionStatus = "Unknown"
)

// PossibleHubBgpConnectionStatusValues returns an array of possible values for the HubBgpConnectionStatus const type.
func PossibleHubBgpConnectionStatusValues() []HubBgpConnectionStatus {
	return []HubBgpConnectionStatus{HubBgpConnectionStatusConnected, HubBgpConnectionStatusConnecting, HubBgpConnectionStatusNotConnected, HubBgpConnectionStatusUnknown}
}

// HubRoutingPreference enumerates the values for hub routing preference.
type HubRoutingPreference string

const (
	// HubRoutingPreferenceASPath ...
	HubRoutingPreferenceASPath HubRoutingPreference = "ASPath"
	// HubRoutingPreferenceExpressRoute ...
	HubRoutingPreferenceExpressRoute HubRoutingPreference = "ExpressRoute"
	// HubRoutingPreferenceVpnGateway ...
	HubRoutingPreferenceVpnGateway HubRoutingPreference = "VpnGateway"
)

// PossibleHubRoutingPreferenceValues returns an array of possible values for the HubRoutingPreference const type.
func PossibleHubRoutingPreferenceValues() []HubRoutingPreference {
	return []HubRoutingPreference{HubRoutingPreferenceASPath, HubRoutingPreferenceExpressRoute, HubRoutingPreferenceVpnGateway}
}

// HubVirtualNetworkConnectionStatus enumerates the values for hub virtual network connection status.
type HubVirtualNetworkConnectionStatus string

const (
	// HubVirtualNetworkConnectionStatusConnected ...
	HubVirtualNetworkConnectionStatusConnected HubVirtualNetworkConnectionStatus = "Connected"
	// HubVirtualNetworkConnectionStatusConnecting ...
	HubVirtualNetworkConnectionStatusConnecting HubVirtualNetworkConnectionStatus = "Connecting"
	// HubVirtualNetworkConnectionStatusNotConnected ...
	HubVirtualNetworkConnectionStatusNotConnected HubVirtualNetworkConnectionStatus = "NotConnected"
	// HubVirtualNetworkConnectionStatusUnknown ...
	HubVirtualNetworkConnectionStatusUnknown HubVirtualNetworkConnectionStatus = "Unknown"
)

// PossibleHubVirtualNetworkConnectionStatusValues returns an array of possible values for the HubVirtualNetworkConnectionStatus const type.
func PossibleHubVirtualNetworkConnectionStatusValues() []HubVirtualNetworkConnectionStatus {
	return []HubVirtualNetworkConnectionStatus{HubVirtualNetworkConnectionStatusConnected, HubVirtualNetworkConnectionStatusConnecting, HubVirtualNetworkConnectionStatusNotConnected, HubVirtualNetworkConnectionStatusUnknown}
}

// IkeEncryption enumerates the values for ike encryption.
type IkeEncryption string

const (
	// AES128 ...
	AES128 IkeEncryption = "AES128"
	// AES192 ...
	AES192 IkeEncryption = "AES192"
	// AES256 ...
	AES256 IkeEncryption = "AES256"
	// DES ...
	DES IkeEncryption = "DES"
	// DES3 ...
	DES3 IkeEncryption = "DES3"
	// GCMAES128 ...
	GCMAES128 IkeEncryption = "GCMAES128"
	// GCMAES256 ...
	GCMAES256 IkeEncryption = "GCMAES256"
)

// PossibleIkeEncryptionValues returns an array of possible values for the IkeEncryption const type.
func PossibleIkeEncryptionValues() []IkeEncryption {
	return []IkeEncryption{AES128, AES192, AES256, DES, DES3, GCMAES128, GCMAES256}
}

// IkeIntegrity enumerates the values for ike integrity.
type IkeIntegrity string

const (
	// IkeIntegrityGCMAES128 ...
	IkeIntegrityGCMAES128 IkeIntegrity = "GCMAES128"
	// IkeIntegrityGCMAES256 ...
	IkeIntegrityGCMAES256 IkeIntegrity = "GCMAES256"
	// IkeIntegrityMD5 ...
	IkeIntegrityMD5 IkeIntegrity = "MD5"
	// IkeIntegritySHA1 ...
	IkeIntegritySHA1 IkeIntegrity = "SHA1"
	// IkeIntegritySHA256 ...
	IkeIntegritySHA256 IkeIntegrity = "SHA256"
	// IkeIntegritySHA384 ...
	IkeIntegritySHA384 IkeIntegrity = "SHA384"
)

// PossibleIkeIntegrityValues returns an array of possible values for the IkeIntegrity const type.
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return []IkeIntegrity{IkeIntegrityGCMAES128, IkeIntegrityGCMAES256, IkeIntegrityMD5, IkeIntegritySHA1, IkeIntegritySHA256, IkeIntegritySHA384}
}

// InboundSecurityRulesProtocol enumerates the values for inbound security rules protocol.
type InboundSecurityRulesProtocol string

const (
	// InboundSecurityRulesProtocolTCP ...
	InboundSecurityRulesProtocolTCP InboundSecurityRulesProtocol = "TCP"
	// InboundSecurityRulesProtocolUDP ...
	InboundSecurityRulesProtocolUDP InboundSecurityRulesProtocol = "UDP"
)

// PossibleInboundSecurityRulesProtocolValues returns an array of possible values for the InboundSecurityRulesProtocol const type.
func PossibleInboundSecurityRulesProtocolValues() []InboundSecurityRulesProtocol {
	return []InboundSecurityRulesProtocol{InboundSecurityRulesProtocolTCP, InboundSecurityRulesProtocolUDP}
}

// IntentPolicyBasedService enumerates the values for intent policy based service.
type IntentPolicyBasedService string

const (
	// IntentPolicyBasedServiceAll ...
	IntentPolicyBasedServiceAll IntentPolicyBasedService = "All"
	// IntentPolicyBasedServiceAllowRulesOnly ...
	IntentPolicyBasedServiceAllowRulesOnly IntentPolicyBasedService = "AllowRulesOnly"
	// IntentPolicyBasedServiceNone ...
	IntentPolicyBasedServiceNone IntentPolicyBasedService = "None"
)

// PossibleIntentPolicyBasedServiceValues returns an array of possible values for the IntentPolicyBasedService const type.
func PossibleIntentPolicyBasedServiceValues() []IntentPolicyBasedService {
	return []IntentPolicyBasedService{IntentPolicyBasedServiceAll, IntentPolicyBasedServiceAllowRulesOnly, IntentPolicyBasedServiceNone}
}

// InterfaceAuxiliaryMode enumerates the values for interface auxiliary mode.
type InterfaceAuxiliaryMode string

const (
	// InterfaceAuxiliaryModeFloating ...
	InterfaceAuxiliaryModeFloating InterfaceAuxiliaryMode = "Floating"
	// InterfaceAuxiliaryModeMaxConnections ...
	InterfaceAuxiliaryModeMaxConnections InterfaceAuxiliaryMode = "MaxConnections"
	// InterfaceAuxiliaryModeNone ...
	InterfaceAuxiliaryModeNone InterfaceAuxiliaryMode = "None"
)

// PossibleInterfaceAuxiliaryModeValues returns an array of possible values for the InterfaceAuxiliaryMode const type.
func PossibleInterfaceAuxiliaryModeValues() []InterfaceAuxiliaryMode {
	return []InterfaceAuxiliaryMode{InterfaceAuxiliaryModeFloating, InterfaceAuxiliaryModeMaxConnections, InterfaceAuxiliaryModeNone}
}

// InterfaceMigrationPhase enumerates the values for interface migration phase.
type InterfaceMigrationPhase string

const (
	// InterfaceMigrationPhaseAbort ...
	InterfaceMigrationPhaseAbort InterfaceMigrationPhase = "Abort"
	// InterfaceMigrationPhaseCommit ...
	InterfaceMigrationPhaseCommit InterfaceMigrationPhase = "Commit"
	// InterfaceMigrationPhaseCommitted ...
	InterfaceMigrationPhaseCommitted InterfaceMigrationPhase = "Committed"
	// InterfaceMigrationPhaseNone ...
	InterfaceMigrationPhaseNone InterfaceMigrationPhase = "None"
	// InterfaceMigrationPhasePrepare ...
	InterfaceMigrationPhasePrepare InterfaceMigrationPhase = "Prepare"
)

// PossibleInterfaceMigrationPhaseValues returns an array of possible values for the InterfaceMigrationPhase const type.
func PossibleInterfaceMigrationPhaseValues() []InterfaceMigrationPhase {
	return []InterfaceMigrationPhase{InterfaceMigrationPhaseAbort, InterfaceMigrationPhaseCommit, InterfaceMigrationPhaseCommitted, InterfaceMigrationPhaseNone, InterfaceMigrationPhasePrepare}
}

// InterfaceNicType enumerates the values for interface nic type.
type InterfaceNicType string

const (
	// Elastic ...
	Elastic InterfaceNicType = "Elastic"
	// Standard ...
	Standard InterfaceNicType = "Standard"
)

// PossibleInterfaceNicTypeValues returns an array of possible values for the InterfaceNicType const type.
func PossibleInterfaceNicTypeValues() []InterfaceNicType {
	return []InterfaceNicType{Elastic, Standard}
}

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic ...
	Dynamic IPAllocationMethod = "Dynamic"
	// Static ...
	Static IPAllocationMethod = "Static"
)

// PossibleIPAllocationMethodValues returns an array of possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{Dynamic, Static}
}

// IPAllocationType enumerates the values for ip allocation type.
type IPAllocationType string

const (
	// Hypernet ...
	Hypernet IPAllocationType = "Hypernet"
	// Undefined ...
	Undefined IPAllocationType = "Undefined"
)

// PossibleIPAllocationTypeValues returns an array of possible values for the IPAllocationType const type.
func PossibleIPAllocationTypeValues() []IPAllocationType {
	return []IPAllocationType{Hypernet, Undefined}
}

// IPFlowProtocol enumerates the values for ip flow protocol.
type IPFlowProtocol string

const (
	// IPFlowProtocolTCP ...
	IPFlowProtocolTCP IPFlowProtocol = "TCP"
	// IPFlowProtocolUDP ...
	IPFlowProtocolUDP IPFlowProtocol = "UDP"
)

// PossibleIPFlowProtocolValues returns an array of possible values for the IPFlowProtocol const type.
func PossibleIPFlowProtocolValues() []IPFlowProtocol {
	return []IPFlowProtocol{IPFlowProtocolTCP, IPFlowProtocolUDP}
}

// IpsecEncryption enumerates the values for ipsec encryption.
type IpsecEncryption string

const (
	// IpsecEncryptionAES128 ...
	IpsecEncryptionAES128 IpsecEncryption = "AES128"
	// IpsecEncryptionAES192 ...
	IpsecEncryptionAES192 IpsecEncryption = "AES192"
	// IpsecEncryptionAES256 ...
	IpsecEncryptionAES256 IpsecEncryption = "AES256"
	// IpsecEncryptionDES ...
	IpsecEncryptionDES IpsecEncryption = "DES"
	// IpsecEncryptionDES3 ...
	IpsecEncryptionDES3 IpsecEncryption = "DES3"
	// IpsecEncryptionGCMAES128 ...
	IpsecEncryptionGCMAES128 IpsecEncryption = "GCMAES128"
	// IpsecEncryptionGCMAES192 ...
	IpsecEncryptionGCMAES192 IpsecEncryption = "GCMAES192"
	// IpsecEncryptionGCMAES256 ...
	IpsecEncryptionGCMAES256 IpsecEncryption = "GCMAES256"
	// IpsecEncryptionNone ...
	IpsecEncryptionNone IpsecEncryption = "None"
)

// PossibleIpsecEncryptionValues returns an array of possible values for the IpsecEncryption const type.
func PossibleIpsecEncryptionValues() []IpsecEncryption {
	return []IpsecEncryption{IpsecEncryptionAES128, IpsecEncryptionAES192, IpsecEncryptionAES256, IpsecEncryptionDES, IpsecEncryptionDES3, IpsecEncryptionGCMAES128, IpsecEncryptionGCMAES192, IpsecEncryptionGCMAES256, IpsecEncryptionNone}
}

// IpsecIntegrity enumerates the values for ipsec integrity.
type IpsecIntegrity string

const (
	// IpsecIntegrityGCMAES128 ...
	IpsecIntegrityGCMAES128 IpsecIntegrity = "GCMAES128"
	// IpsecIntegrityGCMAES192 ...
	IpsecIntegrityGCMAES192 IpsecIntegrity = "GCMAES192"
	// IpsecIntegrityGCMAES256 ...
	IpsecIntegrityGCMAES256 IpsecIntegrity = "GCMAES256"
	// IpsecIntegrityMD5 ...
	IpsecIntegrityMD5 IpsecIntegrity = "MD5"
	// IpsecIntegritySHA1 ...
	IpsecIntegritySHA1 IpsecIntegrity = "SHA1"
	// IpsecIntegritySHA256 ...
	IpsecIntegritySHA256 IpsecIntegrity = "SHA256"
)

// PossibleIpsecIntegrityValues returns an array of possible values for the IpsecIntegrity const type.
func PossibleIpsecIntegrityValues() []IpsecIntegrity {
	return []IpsecIntegrity{IpsecIntegrityGCMAES128, IpsecIntegrityGCMAES192, IpsecIntegrityGCMAES256, IpsecIntegrityMD5, IpsecIntegritySHA1, IpsecIntegritySHA256}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 ...
	IPv4 IPVersion = "IPv4"
	// IPv6 ...
	IPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPv4, IPv6}
}

// IsGlobal enumerates the values for is global.
type IsGlobal string

const (
	// IsGlobalFalse ...
	IsGlobalFalse IsGlobal = "False"
	// IsGlobalTrue ...
	IsGlobalTrue IsGlobal = "True"
)

// PossibleIsGlobalValues returns an array of possible values for the IsGlobal const type.
func PossibleIsGlobalValues() []IsGlobal {
	return []IsGlobal{IsGlobalFalse, IsGlobalTrue}
}

// IssueType enumerates the values for issue type.
type IssueType string

const (
	// IssueTypeAgentStopped ...
	IssueTypeAgentStopped IssueType = "AgentStopped"
	// IssueTypeDNSResolution ...
	IssueTypeDNSResolution IssueType = "DnsResolution"
	// IssueTypeGuestFirewall ...
	IssueTypeGuestFirewall IssueType = "GuestFirewall"
	// IssueTypeNetworkSecurityRule ...
	IssueTypeNetworkSecurityRule IssueType = "NetworkSecurityRule"
	// IssueTypePlatform ...
	IssueTypePlatform IssueType = "Platform"
	// IssueTypePortThrottled ...
	IssueTypePortThrottled IssueType = "PortThrottled"
	// IssueTypeSocketBind ...
	IssueTypeSocketBind IssueType = "SocketBind"
	// IssueTypeUnknown ...
	IssueTypeUnknown IssueType = "Unknown"
	// IssueTypeUserDefinedRoute ...
	IssueTypeUserDefinedRoute IssueType = "UserDefinedRoute"
)

// PossibleIssueTypeValues returns an array of possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{IssueTypeAgentStopped, IssueTypeDNSResolution, IssueTypeGuestFirewall, IssueTypeNetworkSecurityRule, IssueTypePlatform, IssueTypePortThrottled, IssueTypeSocketBind, IssueTypeUnknown, IssueTypeUserDefinedRoute}
}

// IsWorkloadProtected enumerates the values for is workload protected.
type IsWorkloadProtected string

const (
	// IsWorkloadProtectedFalse ...
	IsWorkloadProtectedFalse IsWorkloadProtected = "False"
	// IsWorkloadProtectedTrue ...
	IsWorkloadProtectedTrue IsWorkloadProtected = "True"
)

// PossibleIsWorkloadProtectedValues returns an array of possible values for the IsWorkloadProtected const type.
func PossibleIsWorkloadProtectedValues() []IsWorkloadProtected {
	return []IsWorkloadProtected{IsWorkloadProtectedFalse, IsWorkloadProtectedTrue}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindActiveBaseSecurityAdminRule ...
	KindActiveBaseSecurityAdminRule Kind = "ActiveBaseSecurityAdminRule"
	// KindCustom ...
	KindCustom Kind = "Custom"
	// KindDefault ...
	KindDefault Kind = "Default"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindActiveBaseSecurityAdminRule, KindCustom, KindDefault}
}

// KindBasicBaseAdminRule enumerates the values for kind basic base admin rule.
type KindBasicBaseAdminRule string

const (
	// KindBasicBaseAdminRuleKindBaseAdminRule ...
	KindBasicBaseAdminRuleKindBaseAdminRule KindBasicBaseAdminRule = "BaseAdminRule"
	// KindBasicBaseAdminRuleKindCustom ...
	KindBasicBaseAdminRuleKindCustom KindBasicBaseAdminRule = "Custom"
	// KindBasicBaseAdminRuleKindDefault ...
	KindBasicBaseAdminRuleKindDefault KindBasicBaseAdminRule = "Default"
)

// PossibleKindBasicBaseAdminRuleValues returns an array of possible values for the KindBasicBaseAdminRule const type.
func PossibleKindBasicBaseAdminRuleValues() []KindBasicBaseAdminRule {
	return []KindBasicBaseAdminRule{KindBasicBaseAdminRuleKindBaseAdminRule, KindBasicBaseAdminRuleKindCustom, KindBasicBaseAdminRuleKindDefault}
}

// KindBasicEffectiveBaseSecurityAdminRule enumerates the values for kind basic effective base security admin
// rule.
type KindBasicEffectiveBaseSecurityAdminRule string

const (
	// KindBasicEffectiveBaseSecurityAdminRuleKindCustom ...
	KindBasicEffectiveBaseSecurityAdminRuleKindCustom KindBasicEffectiveBaseSecurityAdminRule = "Custom"
	// KindBasicEffectiveBaseSecurityAdminRuleKindDefault ...
	KindBasicEffectiveBaseSecurityAdminRuleKindDefault KindBasicEffectiveBaseSecurityAdminRule = "Default"
	// KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule ...
	KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule KindBasicEffectiveBaseSecurityAdminRule = "EffectiveBaseSecurityAdminRule"
)

// PossibleKindBasicEffectiveBaseSecurityAdminRuleValues returns an array of possible values for the KindBasicEffectiveBaseSecurityAdminRule const type.
func PossibleKindBasicEffectiveBaseSecurityAdminRuleValues() []KindBasicEffectiveBaseSecurityAdminRule {
	return []KindBasicEffectiveBaseSecurityAdminRule{KindBasicEffectiveBaseSecurityAdminRuleKindCustom, KindBasicEffectiveBaseSecurityAdminRuleKindDefault, KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule}
}

// LoadBalancerBackendAddressAdminState enumerates the values for load balancer backend address admin state.
type LoadBalancerBackendAddressAdminState string

const (
	// LoadBalancerBackendAddressAdminStateDown ...
	LoadBalancerBackendAddressAdminStateDown LoadBalancerBackendAddressAdminState = "Down"
	// LoadBalancerBackendAddressAdminStateDrain ...
	LoadBalancerBackendAddressAdminStateDrain LoadBalancerBackendAddressAdminState = "Drain"
	// LoadBalancerBackendAddressAdminStateNone ...
	LoadBalancerBackendAddressAdminStateNone LoadBalancerBackendAddressAdminState = "None"
	// LoadBalancerBackendAddressAdminStateUp ...
	LoadBalancerBackendAddressAdminStateUp LoadBalancerBackendAddressAdminState = "Up"
)

// PossibleLoadBalancerBackendAddressAdminStateValues returns an array of possible values for the LoadBalancerBackendAddressAdminState const type.
func PossibleLoadBalancerBackendAddressAdminStateValues() []LoadBalancerBackendAddressAdminState {
	return []LoadBalancerBackendAddressAdminState{LoadBalancerBackendAddressAdminStateDown, LoadBalancerBackendAddressAdminStateDrain, LoadBalancerBackendAddressAdminStateNone, LoadBalancerBackendAddressAdminStateUp}
}

// LoadBalancerOutboundRuleProtocol enumerates the values for load balancer outbound rule protocol.
type LoadBalancerOutboundRuleProtocol string

const (
	// LoadBalancerOutboundRuleProtocolAll ...
	LoadBalancerOutboundRuleProtocolAll LoadBalancerOutboundRuleProtocol = "All"
	// LoadBalancerOutboundRuleProtocolTCP ...
	LoadBalancerOutboundRuleProtocolTCP LoadBalancerOutboundRuleProtocol = "Tcp"
	// LoadBalancerOutboundRuleProtocolUDP ...
	LoadBalancerOutboundRuleProtocolUDP LoadBalancerOutboundRuleProtocol = "Udp"
)

// PossibleLoadBalancerOutboundRuleProtocolValues returns an array of possible values for the LoadBalancerOutboundRuleProtocol const type.
func PossibleLoadBalancerOutboundRuleProtocolValues() []LoadBalancerOutboundRuleProtocol {
	return []LoadBalancerOutboundRuleProtocol{LoadBalancerOutboundRuleProtocolAll, LoadBalancerOutboundRuleProtocolTCP, LoadBalancerOutboundRuleProtocolUDP}
}

// LoadBalancerSkuName enumerates the values for load balancer sku name.
type LoadBalancerSkuName string

const (
	// LoadBalancerSkuNameBasic ...
	LoadBalancerSkuNameBasic LoadBalancerSkuName = "Basic"
	// LoadBalancerSkuNameGateway ...
	LoadBalancerSkuNameGateway LoadBalancerSkuName = "Gateway"
	// LoadBalancerSkuNameStandard ...
	LoadBalancerSkuNameStandard LoadBalancerSkuName = "Standard"
)

// PossibleLoadBalancerSkuNameValues returns an array of possible values for the LoadBalancerSkuName const type.
func PossibleLoadBalancerSkuNameValues() []LoadBalancerSkuName {
	return []LoadBalancerSkuName{LoadBalancerSkuNameBasic, LoadBalancerSkuNameGateway, LoadBalancerSkuNameStandard}
}

// LoadBalancerSkuTier enumerates the values for load balancer sku tier.
type LoadBalancerSkuTier string

const (
	// Global ...
	Global LoadBalancerSkuTier = "Global"
	// Regional ...
	Regional LoadBalancerSkuTier = "Regional"
)

// PossibleLoadBalancerSkuTierValues returns an array of possible values for the LoadBalancerSkuTier const type.
func PossibleLoadBalancerSkuTierValues() []LoadBalancerSkuTier {
	return []LoadBalancerSkuTier{Global, Regional}
}

// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// LoadDistributionDefault ...
	LoadDistributionDefault LoadDistribution = "Default"
	// LoadDistributionSourceIP ...
	LoadDistributionSourceIP LoadDistribution = "SourceIP"
	// LoadDistributionSourceIPProtocol ...
	LoadDistributionSourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// PossibleLoadDistributionValues returns an array of possible values for the LoadDistribution const type.
func PossibleLoadDistributionValues() []LoadDistribution {
	return []LoadDistribution{LoadDistributionDefault, LoadDistributionSourceIP, LoadDistributionSourceIPProtocol}
}

// ManagedRuleEnabledState enumerates the values for managed rule enabled state.
type ManagedRuleEnabledState string

const (
	// ManagedRuleEnabledStateDisabled ...
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	// ManagedRuleEnabledStateEnabled ...
	ManagedRuleEnabledStateEnabled ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns an array of possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{ManagedRuleEnabledStateDisabled, ManagedRuleEnabledStateEnabled}
}

// NatGatewaySkuName enumerates the values for nat gateway sku name.
type NatGatewaySkuName string

const (
	// NatGatewaySkuNameStandard ...
	NatGatewaySkuNameStandard NatGatewaySkuName = "Standard"
)

// PossibleNatGatewaySkuNameValues returns an array of possible values for the NatGatewaySkuName const type.
func PossibleNatGatewaySkuNameValues() []NatGatewaySkuName {
	return []NatGatewaySkuName{NatGatewaySkuNameStandard}
}

// NextHopType enumerates the values for next hop type.
type NextHopType string

const (
	// NextHopTypeHyperNetGateway ...
	NextHopTypeHyperNetGateway NextHopType = "HyperNetGateway"
	// NextHopTypeInternet ...
	NextHopTypeInternet NextHopType = "Internet"
	// NextHopTypeNone ...
	NextHopTypeNone NextHopType = "None"
	// NextHopTypeVirtualAppliance ...
	NextHopTypeVirtualAppliance NextHopType = "VirtualAppliance"
	// NextHopTypeVirtualNetworkGateway ...
	NextHopTypeVirtualNetworkGateway NextHopType = "VirtualNetworkGateway"
	// NextHopTypeVnetLocal ...
	NextHopTypeVnetLocal NextHopType = "VnetLocal"
)

// PossibleNextHopTypeValues returns an array of possible values for the NextHopType const type.
func PossibleNextHopTypeValues() []NextHopType {
	return []NextHopType{NextHopTypeHyperNetGateway, NextHopTypeInternet, NextHopTypeNone, NextHopTypeVirtualAppliance, NextHopTypeVirtualNetworkGateway, NextHopTypeVnetLocal}
}

// NextStep enumerates the values for next step.
type NextStep string

const (
	// NextStepContinue ...
	NextStepContinue NextStep = "Continue"
	// NextStepTerminate ...
	NextStepTerminate NextStep = "Terminate"
	// NextStepUnknown ...
	NextStepUnknown NextStep = "Unknown"
)

// PossibleNextStepValues returns an array of possible values for the NextStep const type.
func PossibleNextStepValues() []NextStep {
	return []NextStep{NextStepContinue, NextStepTerminate, NextStepUnknown}
}

// OfficeTrafficCategory enumerates the values for office traffic category.
type OfficeTrafficCategory string

const (
	// OfficeTrafficCategoryAll ...
	OfficeTrafficCategoryAll OfficeTrafficCategory = "All"
	// OfficeTrafficCategoryNone ...
	OfficeTrafficCategoryNone OfficeTrafficCategory = "None"
	// OfficeTrafficCategoryOptimize ...
	OfficeTrafficCategoryOptimize OfficeTrafficCategory = "Optimize"
	// OfficeTrafficCategoryOptimizeAndAllow ...
	OfficeTrafficCategoryOptimizeAndAllow OfficeTrafficCategory = "OptimizeAndAllow"
)

// PossibleOfficeTrafficCategoryValues returns an array of possible values for the OfficeTrafficCategory const type.
func PossibleOfficeTrafficCategoryValues() []OfficeTrafficCategory {
	return []OfficeTrafficCategory{OfficeTrafficCategoryAll, OfficeTrafficCategoryNone, OfficeTrafficCategoryOptimize, OfficeTrafficCategoryOptimizeAndAllow}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}

// Origin enumerates the values for origin.
type Origin string

const (
	// OriginInbound ...
	OriginInbound Origin = "Inbound"
	// OriginLocal ...
	OriginLocal Origin = "Local"
	// OriginOutbound ...
	OriginOutbound Origin = "Outbound"
)

// PossibleOriginValues returns an array of possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{OriginInbound, OriginLocal, OriginOutbound}
}

// OutputType enumerates the values for output type.
type OutputType string

const (
	// Workspace ...
	Workspace OutputType = "Workspace"
)

// PossibleOutputTypeValues returns an array of possible values for the OutputType const type.
func PossibleOutputTypeValues() []OutputType {
	return []OutputType{Workspace}
}

// OwaspCrsExclusionEntryMatchVariable enumerates the values for owasp crs exclusion entry match variable.
type OwaspCrsExclusionEntryMatchVariable string

const (
	// RequestArgKeys ...
	RequestArgKeys OwaspCrsExclusionEntryMatchVariable = "RequestArgKeys"
	// RequestArgNames ...
	RequestArgNames OwaspCrsExclusionEntryMatchVariable = "RequestArgNames"
	// RequestArgValues ...
	RequestArgValues OwaspCrsExclusionEntryMatchVariable = "RequestArgValues"
	// RequestCookieKeys ...
	RequestCookieKeys OwaspCrsExclusionEntryMatchVariable = "RequestCookieKeys"
	// RequestCookieNames ...
	RequestCookieNames OwaspCrsExclusionEntryMatchVariable = "RequestCookieNames"
	// RequestCookieValues ...
	RequestCookieValues OwaspCrsExclusionEntryMatchVariable = "RequestCookieValues"
	// RequestHeaderKeys ...
	RequestHeaderKeys OwaspCrsExclusionEntryMatchVariable = "RequestHeaderKeys"
	// RequestHeaderNames ...
	RequestHeaderNames OwaspCrsExclusionEntryMatchVariable = "RequestHeaderNames"
	// RequestHeaderValues ...
	RequestHeaderValues OwaspCrsExclusionEntryMatchVariable = "RequestHeaderValues"
)

// PossibleOwaspCrsExclusionEntryMatchVariableValues returns an array of possible values for the OwaspCrsExclusionEntryMatchVariable const type.
func PossibleOwaspCrsExclusionEntryMatchVariableValues() []OwaspCrsExclusionEntryMatchVariable {
	return []OwaspCrsExclusionEntryMatchVariable{RequestArgKeys, RequestArgNames, RequestArgValues, RequestCookieKeys, RequestCookieNames, RequestCookieValues, RequestHeaderKeys, RequestHeaderNames, RequestHeaderValues}
}

// OwaspCrsExclusionEntrySelectorMatchOperator enumerates the values for owasp crs exclusion entry selector
// match operator.
type OwaspCrsExclusionEntrySelectorMatchOperator string

const (
	// OwaspCrsExclusionEntrySelectorMatchOperatorContains ...
	OwaspCrsExclusionEntrySelectorMatchOperatorContains OwaspCrsExclusionEntrySelectorMatchOperator = "Contains"
	// OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith ...
	OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith OwaspCrsExclusionEntrySelectorMatchOperator = "EndsWith"
	// OwaspCrsExclusionEntrySelectorMatchOperatorEquals ...
	OwaspCrsExclusionEntrySelectorMatchOperatorEquals OwaspCrsExclusionEntrySelectorMatchOperator = "Equals"
	// OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny ...
	OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny OwaspCrsExclusionEntrySelectorMatchOperator = "EqualsAny"
	// OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith ...
	OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith OwaspCrsExclusionEntrySelectorMatchOperator = "StartsWith"
)

// PossibleOwaspCrsExclusionEntrySelectorMatchOperatorValues returns an array of possible values for the OwaspCrsExclusionEntrySelectorMatchOperator const type.
func PossibleOwaspCrsExclusionEntrySelectorMatchOperatorValues() []OwaspCrsExclusionEntrySelectorMatchOperator {
	return []OwaspCrsExclusionEntrySelectorMatchOperator{OwaspCrsExclusionEntrySelectorMatchOperatorContains, OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith, OwaspCrsExclusionEntrySelectorMatchOperatorEquals, OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny, OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith}
}

// PacketCaptureTargetType enumerates the values for packet capture target type.
type PacketCaptureTargetType string

const (
	// PacketCaptureTargetTypeAzureVM ...
	PacketCaptureTargetTypeAzureVM PacketCaptureTargetType = "AzureVM"
	// PacketCaptureTargetTypeAzureVMSS ...
	PacketCaptureTargetTypeAzureVMSS PacketCaptureTargetType = "AzureVMSS"
)

// PossiblePacketCaptureTargetTypeValues returns an array of possible values for the PacketCaptureTargetType const type.
func PossiblePacketCaptureTargetTypeValues() []PacketCaptureTargetType {
	return []PacketCaptureTargetType{PacketCaptureTargetTypeAzureVM, PacketCaptureTargetTypeAzureVMSS}
}

// PcError enumerates the values for pc error.
type PcError string

const (
	// AgentStopped ...
	AgentStopped PcError = "AgentStopped"
	// CaptureFailed ...
	CaptureFailed PcError = "CaptureFailed"
	// InternalError ...
	InternalError PcError = "InternalError"
	// LocalFileFailed ...
	LocalFileFailed PcError = "LocalFileFailed"
	// StorageFailed ...
	StorageFailed PcError = "StorageFailed"
)

// PossiblePcErrorValues returns an array of possible values for the PcError const type.
func PossiblePcErrorValues() []PcError {
	return []PcError{AgentStopped, CaptureFailed, InternalError, LocalFileFailed, StorageFailed}
}

// PcProtocol enumerates the values for pc protocol.
type PcProtocol string

const (
	// PcProtocolAny ...
	PcProtocolAny PcProtocol = "Any"
	// PcProtocolTCP ...
	PcProtocolTCP PcProtocol = "TCP"
	// PcProtocolUDP ...
	PcProtocolUDP PcProtocol = "UDP"
)

// PossiblePcProtocolValues returns an array of possible values for the PcProtocol const type.
func PossiblePcProtocolValues() []PcProtocol {
	return []PcProtocol{PcProtocolAny, PcProtocolTCP, PcProtocolUDP}
}

// PcStatus enumerates the values for pc status.
type PcStatus string

const (
	// PcStatusError ...
	PcStatusError PcStatus = "Error"
	// PcStatusNotStarted ...
	PcStatusNotStarted PcStatus = "NotStarted"
	// PcStatusRunning ...
	PcStatusRunning PcStatus = "Running"
	// PcStatusStopped ...
	PcStatusStopped PcStatus = "Stopped"
	// PcStatusUnknown ...
	PcStatusUnknown PcStatus = "Unknown"
)

// PossiblePcStatusValues returns an array of possible values for the PcStatus const type.
func PossiblePcStatusValues() []PcStatus {
	return []PcStatus{PcStatusError, PcStatusNotStarted, PcStatusRunning, PcStatusStopped, PcStatusUnknown}
}

// PfsGroup enumerates the values for pfs group.
type PfsGroup string

const (
	// PfsGroupECP256 ...
	PfsGroupECP256 PfsGroup = "ECP256"
	// PfsGroupECP384 ...
	PfsGroupECP384 PfsGroup = "ECP384"
	// PfsGroupNone ...
	PfsGroupNone PfsGroup = "None"
	// PfsGroupPFS1 ...
	PfsGroupPFS1 PfsGroup = "PFS1"
	// PfsGroupPFS14 ...
	PfsGroupPFS14 PfsGroup = "PFS14"
	// PfsGroupPFS2 ...
	PfsGroupPFS2 PfsGroup = "PFS2"
	// PfsGroupPFS2048 ...
	PfsGroupPFS2048 PfsGroup = "PFS2048"
	// PfsGroupPFS24 ...
	PfsGroupPFS24 PfsGroup = "PFS24"
	// PfsGroupPFSMM ...
	PfsGroupPFSMM PfsGroup = "PFSMM"
)

// PossiblePfsGroupValues returns an array of possible values for the PfsGroup const type.
func PossiblePfsGroupValues() []PfsGroup {
	return []PfsGroup{PfsGroupECP256, PfsGroupECP384, PfsGroupNone, PfsGroupPFS1, PfsGroupPFS14, PfsGroupPFS2, PfsGroupPFS2048, PfsGroupPFS24, PfsGroupPFSMM}
}

// PreferredIPVersion enumerates the values for preferred ip version.
type PreferredIPVersion string

const (
	// PreferredIPVersionIPv4 ...
	PreferredIPVersionIPv4 PreferredIPVersion = "IPv4"
	// PreferredIPVersionIPv6 ...
	PreferredIPVersionIPv6 PreferredIPVersion = "IPv6"
)

// PossiblePreferredIPVersionValues returns an array of possible values for the PreferredIPVersion const type.
func PossiblePreferredIPVersionValues() []PreferredIPVersion {
	return []PreferredIPVersion{PreferredIPVersionIPv4, PreferredIPVersionIPv6}
}

// PreferredRoutingGateway enumerates the values for preferred routing gateway.
type PreferredRoutingGateway string

const (
	// PreferredRoutingGatewayExpressRoute ...
	PreferredRoutingGatewayExpressRoute PreferredRoutingGateway = "ExpressRoute"
	// PreferredRoutingGatewayNone ...
	PreferredRoutingGatewayNone PreferredRoutingGateway = "None"
	// PreferredRoutingGatewayVpnGateway ...
	PreferredRoutingGatewayVpnGateway PreferredRoutingGateway = "VpnGateway"
)

// PossiblePreferredRoutingGatewayValues returns an array of possible values for the PreferredRoutingGateway const type.
func PossiblePreferredRoutingGatewayValues() []PreferredRoutingGateway {
	return []PreferredRoutingGateway{PreferredRoutingGatewayExpressRoute, PreferredRoutingGatewayNone, PreferredRoutingGatewayVpnGateway}
}

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolHTTPS ...
	ProbeProtocolHTTPS ProbeProtocol = "Https"
	// ProbeProtocolTCP ...
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolHTTPS, ProbeProtocolTCP}
}

// ProcessorArchitecture enumerates the values for processor architecture.
type ProcessorArchitecture string

const (
	// Amd64 ...
	Amd64 ProcessorArchitecture = "Amd64"
	// X86 ...
	X86 ProcessorArchitecture = "X86"
)

// PossibleProcessorArchitectureValues returns an array of possible values for the ProcessorArchitecture const type.
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return []ProcessorArchitecture{Amd64, X86}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolHTTP ...
	ProtocolHTTP Protocol = "Http"
	// ProtocolHTTPS ...
	ProtocolHTTPS Protocol = "Https"
	// ProtocolIcmp ...
	ProtocolIcmp Protocol = "Icmp"
	// ProtocolTCP ...
	ProtocolTCP Protocol = "Tcp"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{ProtocolHTTP, ProtocolHTTPS, ProtocolIcmp, ProtocolTCP}
}

// ProtocolType enumerates the values for protocol type.
type ProtocolType string

const (
	// ProtocolTypeAh ...
	ProtocolTypeAh ProtocolType = "Ah"
	// ProtocolTypeAll ...
	ProtocolTypeAll ProtocolType = "All"
	// ProtocolTypeDoNotUse ...
	ProtocolTypeDoNotUse ProtocolType = "DoNotUse"
	// ProtocolTypeEsp ...
	ProtocolTypeEsp ProtocolType = "Esp"
	// ProtocolTypeGre ...
	ProtocolTypeGre ProtocolType = "Gre"
	// ProtocolTypeIcmp ...
	ProtocolTypeIcmp ProtocolType = "Icmp"
	// ProtocolTypeTCP ...
	ProtocolTypeTCP ProtocolType = "Tcp"
	// ProtocolTypeUDP ...
	ProtocolTypeUDP ProtocolType = "Udp"
	// ProtocolTypeVxlan ...
	ProtocolTypeVxlan ProtocolType = "Vxlan"
)

// PossibleProtocolTypeValues returns an array of possible values for the ProtocolType const type.
func PossibleProtocolTypeValues() []ProtocolType {
	return []ProtocolType{ProtocolTypeAh, ProtocolTypeAll, ProtocolTypeDoNotUse, ProtocolTypeEsp, ProtocolTypeGre, ProtocolTypeIcmp, ProtocolTypeTCP, ProtocolTypeUDP, ProtocolTypeVxlan}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// PublicIPAddressMigrationPhase enumerates the values for public ip address migration phase.
type PublicIPAddressMigrationPhase string

const (
	// PublicIPAddressMigrationPhaseAbort ...
	PublicIPAddressMigrationPhaseAbort PublicIPAddressMigrationPhase = "Abort"
	// PublicIPAddressMigrationPhaseCommit ...
	PublicIPAddressMigrationPhaseCommit PublicIPAddressMigrationPhase = "Commit"
	// PublicIPAddressMigrationPhaseCommitted ...
	PublicIPAddressMigrationPhaseCommitted PublicIPAddressMigrationPhase = "Committed"
	// PublicIPAddressMigrationPhaseNone ...
	PublicIPAddressMigrationPhaseNone PublicIPAddressMigrationPhase = "None"
	// PublicIPAddressMigrationPhasePrepare ...
	PublicIPAddressMigrationPhasePrepare PublicIPAddressMigrationPhase = "Prepare"
)

// PossiblePublicIPAddressMigrationPhaseValues returns an array of possible values for the PublicIPAddressMigrationPhase const type.
func PossiblePublicIPAddressMigrationPhaseValues() []PublicIPAddressMigrationPhase {
	return []PublicIPAddressMigrationPhase{PublicIPAddressMigrationPhaseAbort, PublicIPAddressMigrationPhaseCommit, PublicIPAddressMigrationPhaseCommitted, PublicIPAddressMigrationPhaseNone, PublicIPAddressMigrationPhasePrepare}
}

// PublicIPAddressSkuName enumerates the values for public ip address sku name.
type PublicIPAddressSkuName string

const (
	// PublicIPAddressSkuNameBasic ...
	PublicIPAddressSkuNameBasic PublicIPAddressSkuName = "Basic"
	// PublicIPAddressSkuNameStandard ...
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = "Standard"
)

// PossiblePublicIPAddressSkuNameValues returns an array of possible values for the PublicIPAddressSkuName const type.
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return []PublicIPAddressSkuName{PublicIPAddressSkuNameBasic, PublicIPAddressSkuNameStandard}
}

// PublicIPAddressSkuTier enumerates the values for public ip address sku tier.
type PublicIPAddressSkuTier string

const (
	// PublicIPAddressSkuTierGlobal ...
	PublicIPAddressSkuTierGlobal PublicIPAddressSkuTier = "Global"
	// PublicIPAddressSkuTierRegional ...
	PublicIPAddressSkuTierRegional PublicIPAddressSkuTier = "Regional"
)

// PossiblePublicIPAddressSkuTierValues returns an array of possible values for the PublicIPAddressSkuTier const type.
func PossiblePublicIPAddressSkuTierValues() []PublicIPAddressSkuTier {
	return []PublicIPAddressSkuTier{PublicIPAddressSkuTierGlobal, PublicIPAddressSkuTierRegional}
}

// PublicIPPrefixSkuName enumerates the values for public ip prefix sku name.
type PublicIPPrefixSkuName string

const (
	// PublicIPPrefixSkuNameStandard ...
	PublicIPPrefixSkuNameStandard PublicIPPrefixSkuName = "Standard"
)

// PossiblePublicIPPrefixSkuNameValues returns an array of possible values for the PublicIPPrefixSkuName const type.
func PossiblePublicIPPrefixSkuNameValues() []PublicIPPrefixSkuName {
	return []PublicIPPrefixSkuName{PublicIPPrefixSkuNameStandard}
}

// PublicIPPrefixSkuTier enumerates the values for public ip prefix sku tier.
type PublicIPPrefixSkuTier string

const (
	// PublicIPPrefixSkuTierGlobal ...
	PublicIPPrefixSkuTierGlobal PublicIPPrefixSkuTier = "Global"
	// PublicIPPrefixSkuTierRegional ...
	PublicIPPrefixSkuTierRegional PublicIPPrefixSkuTier = "Regional"
)

// PossiblePublicIPPrefixSkuTierValues returns an array of possible values for the PublicIPPrefixSkuTier const type.
func PossiblePublicIPPrefixSkuTierValues() []PublicIPPrefixSkuTier {
	return []PublicIPPrefixSkuTier{PublicIPPrefixSkuTierGlobal, PublicIPPrefixSkuTierRegional}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// RouteMapActionType enumerates the values for route map action type.
type RouteMapActionType string

const (
	// RouteMapActionTypeAdd ...
	RouteMapActionTypeAdd RouteMapActionType = "Add"
	// RouteMapActionTypeDrop ...
	RouteMapActionTypeDrop RouteMapActionType = "Drop"
	// RouteMapActionTypeRemove ...
	RouteMapActionTypeRemove RouteMapActionType = "Remove"
	// RouteMapActionTypeReplace ...
	RouteMapActionTypeReplace RouteMapActionType = "Replace"
	// RouteMapActionTypeUnknown ...
	RouteMapActionTypeUnknown RouteMapActionType = "Unknown"
)

// PossibleRouteMapActionTypeValues returns an array of possible values for the RouteMapActionType const type.
func PossibleRouteMapActionTypeValues() []RouteMapActionType {
	return []RouteMapActionType{RouteMapActionTypeAdd, RouteMapActionTypeDrop, RouteMapActionTypeRemove, RouteMapActionTypeReplace, RouteMapActionTypeUnknown}
}

// RouteMapMatchCondition enumerates the values for route map match condition.
type RouteMapMatchCondition string

const (
	// RouteMapMatchConditionContains ...
	RouteMapMatchConditionContains RouteMapMatchCondition = "Contains"
	// RouteMapMatchConditionEquals ...
	RouteMapMatchConditionEquals RouteMapMatchCondition = "Equals"
	// RouteMapMatchConditionNotContains ...
	RouteMapMatchConditionNotContains RouteMapMatchCondition = "NotContains"
	// RouteMapMatchConditionNotEquals ...
	RouteMapMatchConditionNotEquals RouteMapMatchCondition = "NotEquals"
	// RouteMapMatchConditionUnknown ...
	RouteMapMatchConditionUnknown RouteMapMatchCondition = "Unknown"
)

// PossibleRouteMapMatchConditionValues returns an array of possible values for the RouteMapMatchCondition const type.
func PossibleRouteMapMatchConditionValues() []RouteMapMatchCondition {
	return []RouteMapMatchCondition{RouteMapMatchConditionContains, RouteMapMatchConditionEquals, RouteMapMatchConditionNotContains, RouteMapMatchConditionNotEquals, RouteMapMatchConditionUnknown}
}

// RouteNextHopType enumerates the values for route next hop type.
type RouteNextHopType string

const (
	// RouteNextHopTypeInternet ...
	RouteNextHopTypeInternet RouteNextHopType = "Internet"
	// RouteNextHopTypeNone ...
	RouteNextHopTypeNone RouteNextHopType = "None"
	// RouteNextHopTypeVirtualAppliance ...
	RouteNextHopTypeVirtualAppliance RouteNextHopType = "VirtualAppliance"
	// RouteNextHopTypeVirtualNetworkGateway ...
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	// RouteNextHopTypeVnetLocal ...
	RouteNextHopTypeVnetLocal RouteNextHopType = "VnetLocal"
)

// PossibleRouteNextHopTypeValues returns an array of possible values for the RouteNextHopType const type.
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return []RouteNextHopType{RouteNextHopTypeInternet, RouteNextHopTypeNone, RouteNextHopTypeVirtualAppliance, RouteNextHopTypeVirtualNetworkGateway, RouteNextHopTypeVnetLocal}
}

// RoutingState enumerates the values for routing state.
type RoutingState string

const (
	// RoutingStateFailed ...
	RoutingStateFailed RoutingState = "Failed"
	// RoutingStateNone ...
	RoutingStateNone RoutingState = "None"
	// RoutingStateProvisioned ...
	RoutingStateProvisioned RoutingState = "Provisioned"
	// RoutingStateProvisioning ...
	RoutingStateProvisioning RoutingState = "Provisioning"
)

// PossibleRoutingStateValues returns an array of possible values for the RoutingState const type.
func PossibleRoutingStateValues() []RoutingState {
	return []RoutingState{RoutingStateFailed, RoutingStateNone, RoutingStateProvisioned, RoutingStateProvisioning}
}

// RuleCollectionType enumerates the values for rule collection type.
type RuleCollectionType string

const (
	// RuleCollectionTypeFirewallPolicyFilterRuleCollection ...
	RuleCollectionTypeFirewallPolicyFilterRuleCollection RuleCollectionType = "FirewallPolicyFilterRuleCollection"
	// RuleCollectionTypeFirewallPolicyNatRuleCollection ...
	RuleCollectionTypeFirewallPolicyNatRuleCollection RuleCollectionType = "FirewallPolicyNatRuleCollection"
	// RuleCollectionTypeFirewallPolicyRuleCollection ...
	RuleCollectionTypeFirewallPolicyRuleCollection RuleCollectionType = "FirewallPolicyRuleCollection"
)

// PossibleRuleCollectionTypeValues returns an array of possible values for the RuleCollectionType const type.
func PossibleRuleCollectionTypeValues() []RuleCollectionType {
	return []RuleCollectionType{RuleCollectionTypeFirewallPolicyFilterRuleCollection, RuleCollectionTypeFirewallPolicyNatRuleCollection, RuleCollectionTypeFirewallPolicyRuleCollection}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// RuleTypeApplicationRule ...
	RuleTypeApplicationRule RuleType = "ApplicationRule"
	// RuleTypeFirewallPolicyRule ...
	RuleTypeFirewallPolicyRule RuleType = "FirewallPolicyRule"
	// RuleTypeNatRule ...
	RuleTypeNatRule RuleType = "NatRule"
	// RuleTypeNetworkRule ...
	RuleTypeNetworkRule RuleType = "NetworkRule"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{RuleTypeApplicationRule, RuleTypeFirewallPolicyRule, RuleTypeNatRule, RuleTypeNetworkRule}
}

// ScopeConnectionState enumerates the values for scope connection state.
type ScopeConnectionState string

const (
	// ScopeConnectionStateConflict ...
	ScopeConnectionStateConflict ScopeConnectionState = "Conflict"
	// ScopeConnectionStateConnected ...
	ScopeConnectionStateConnected ScopeConnectionState = "Connected"
	// ScopeConnectionStatePending ...
	ScopeConnectionStatePending ScopeConnectionState = "Pending"
	// ScopeConnectionStateRejected ...
	ScopeConnectionStateRejected ScopeConnectionState = "Rejected"
	// ScopeConnectionStateRevoked ...
	ScopeConnectionStateRevoked ScopeConnectionState = "Revoked"
)

// PossibleScopeConnectionStateValues returns an array of possible values for the ScopeConnectionState const type.
func PossibleScopeConnectionStateValues() []ScopeConnectionState {
	return []ScopeConnectionState{ScopeConnectionStateConflict, ScopeConnectionStateConnected, ScopeConnectionStatePending, ScopeConnectionStateRejected, ScopeConnectionStateRevoked}
}

// SecurityConfigurationRuleAccess enumerates the values for security configuration rule access.
type SecurityConfigurationRuleAccess string

const (
	// SecurityConfigurationRuleAccessAllow ...
	SecurityConfigurationRuleAccessAllow SecurityConfigurationRuleAccess = "Allow"
	// SecurityConfigurationRuleAccessAlwaysAllow ...
	SecurityConfigurationRuleAccessAlwaysAllow SecurityConfigurationRuleAccess = "AlwaysAllow"
	// SecurityConfigurationRuleAccessDeny ...
	SecurityConfigurationRuleAccessDeny SecurityConfigurationRuleAccess = "Deny"
)

// PossibleSecurityConfigurationRuleAccessValues returns an array of possible values for the SecurityConfigurationRuleAccess const type.
func PossibleSecurityConfigurationRuleAccessValues() []SecurityConfigurationRuleAccess {
	return []SecurityConfigurationRuleAccess{SecurityConfigurationRuleAccessAllow, SecurityConfigurationRuleAccessAlwaysAllow, SecurityConfigurationRuleAccessDeny}
}

// SecurityConfigurationRuleDirection enumerates the values for security configuration rule direction.
type SecurityConfigurationRuleDirection string

const (
	// SecurityConfigurationRuleDirectionInbound ...
	SecurityConfigurationRuleDirectionInbound SecurityConfigurationRuleDirection = "Inbound"
	// SecurityConfigurationRuleDirectionOutbound ...
	SecurityConfigurationRuleDirectionOutbound SecurityConfigurationRuleDirection = "Outbound"
)

// PossibleSecurityConfigurationRuleDirectionValues returns an array of possible values for the SecurityConfigurationRuleDirection const type.
func PossibleSecurityConfigurationRuleDirectionValues() []SecurityConfigurationRuleDirection {
	return []SecurityConfigurationRuleDirection{SecurityConfigurationRuleDirectionInbound, SecurityConfigurationRuleDirectionOutbound}
}

// SecurityConfigurationRuleProtocol enumerates the values for security configuration rule protocol.
type SecurityConfigurationRuleProtocol string

const (
	// SecurityConfigurationRuleProtocolAh ...
	SecurityConfigurationRuleProtocolAh SecurityConfigurationRuleProtocol = "Ah"
	// SecurityConfigurationRuleProtocolAny ...
	SecurityConfigurationRuleProtocolAny SecurityConfigurationRuleProtocol = "Any"
	// SecurityConfigurationRuleProtocolEsp ...
	SecurityConfigurationRuleProtocolEsp SecurityConfigurationRuleProtocol = "Esp"
	// SecurityConfigurationRuleProtocolIcmp ...
	SecurityConfigurationRuleProtocolIcmp SecurityConfigurationRuleProtocol = "Icmp"
	// SecurityConfigurationRuleProtocolTCP ...
	SecurityConfigurationRuleProtocolTCP SecurityConfigurationRuleProtocol = "Tcp"
	// SecurityConfigurationRuleProtocolUDP ...
	SecurityConfigurationRuleProtocolUDP SecurityConfigurationRuleProtocol = "Udp"
)

// PossibleSecurityConfigurationRuleProtocolValues returns an array of possible values for the SecurityConfigurationRuleProtocol const type.
func PossibleSecurityConfigurationRuleProtocolValues() []SecurityConfigurationRuleProtocol {
	return []SecurityConfigurationRuleProtocol{SecurityConfigurationRuleProtocolAh, SecurityConfigurationRuleProtocolAny, SecurityConfigurationRuleProtocolEsp, SecurityConfigurationRuleProtocolIcmp, SecurityConfigurationRuleProtocolTCP, SecurityConfigurationRuleProtocolUDP}
}

// SecurityPartnerProviderConnectionStatus enumerates the values for security partner provider connection
// status.
type SecurityPartnerProviderConnectionStatus string

const (
	// SecurityPartnerProviderConnectionStatusConnected ...
	SecurityPartnerProviderConnectionStatusConnected SecurityPartnerProviderConnectionStatus = "Connected"
	// SecurityPartnerProviderConnectionStatusNotConnected ...
	SecurityPartnerProviderConnectionStatusNotConnected SecurityPartnerProviderConnectionStatus = "NotConnected"
	// SecurityPartnerProviderConnectionStatusPartiallyConnected ...
	SecurityPartnerProviderConnectionStatusPartiallyConnected SecurityPartnerProviderConnectionStatus = "PartiallyConnected"
	// SecurityPartnerProviderConnectionStatusUnknown ...
	SecurityPartnerProviderConnectionStatusUnknown SecurityPartnerProviderConnectionStatus = "Unknown"
)

// PossibleSecurityPartnerProviderConnectionStatusValues returns an array of possible values for the SecurityPartnerProviderConnectionStatus const type.
func PossibleSecurityPartnerProviderConnectionStatusValues() []SecurityPartnerProviderConnectionStatus {
	return []SecurityPartnerProviderConnectionStatus{SecurityPartnerProviderConnectionStatusConnected, SecurityPartnerProviderConnectionStatusNotConnected, SecurityPartnerProviderConnectionStatusPartiallyConnected, SecurityPartnerProviderConnectionStatusUnknown}
}

// SecurityProviderName enumerates the values for security provider name.
type SecurityProviderName string

const (
	// Checkpoint ...
	Checkpoint SecurityProviderName = "Checkpoint"
	// IBoss ...
	IBoss SecurityProviderName = "IBoss"
	// ZScaler ...
	ZScaler SecurityProviderName = "ZScaler"
)

// PossibleSecurityProviderNameValues returns an array of possible values for the SecurityProviderName const type.
func PossibleSecurityProviderNameValues() []SecurityProviderName {
	return []SecurityProviderName{Checkpoint, IBoss, ZScaler}
}

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// SecurityRuleAccessAllow ...
	SecurityRuleAccessAllow SecurityRuleAccess = "Allow"
	// SecurityRuleAccessDeny ...
	SecurityRuleAccessDeny SecurityRuleAccess = "Deny"
)

// PossibleSecurityRuleAccessValues returns an array of possible values for the SecurityRuleAccess const type.
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return []SecurityRuleAccess{SecurityRuleAccessAllow, SecurityRuleAccessDeny}
}

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// SecurityRuleDirectionInbound ...
	SecurityRuleDirectionInbound SecurityRuleDirection = "Inbound"
	// SecurityRuleDirectionOutbound ...
	SecurityRuleDirectionOutbound SecurityRuleDirection = "Outbound"
)

// PossibleSecurityRuleDirectionValues returns an array of possible values for the SecurityRuleDirection const type.
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return []SecurityRuleDirection{SecurityRuleDirectionInbound, SecurityRuleDirectionOutbound}
}

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// SecurityRuleProtocolAh ...
	SecurityRuleProtocolAh SecurityRuleProtocol = "Ah"
	// SecurityRuleProtocolAsterisk ...
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = "*"
	// SecurityRuleProtocolEsp ...
	SecurityRuleProtocolEsp SecurityRuleProtocol = "Esp"
	// SecurityRuleProtocolIcmp ...
	SecurityRuleProtocolIcmp SecurityRuleProtocol = "Icmp"
	// SecurityRuleProtocolTCP ...
	SecurityRuleProtocolTCP SecurityRuleProtocol = "Tcp"
	// SecurityRuleProtocolUDP ...
	SecurityRuleProtocolUDP SecurityRuleProtocol = "Udp"
)

// PossibleSecurityRuleProtocolValues returns an array of possible values for the SecurityRuleProtocol const type.
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return []SecurityRuleProtocol{SecurityRuleProtocolAh, SecurityRuleProtocolAsterisk, SecurityRuleProtocolEsp, SecurityRuleProtocolIcmp, SecurityRuleProtocolTCP, SecurityRuleProtocolUDP}
}

// ServiceProviderProvisioningState enumerates the values for service provider provisioning state.
type ServiceProviderProvisioningState string

const (
	// ServiceProviderProvisioningStateDeprovisioning ...
	ServiceProviderProvisioningStateDeprovisioning ServiceProviderProvisioningState = "Deprovisioning"
	// ServiceProviderProvisioningStateNotProvisioned ...
	ServiceProviderProvisioningStateNotProvisioned ServiceProviderProvisioningState = "NotProvisioned"
	// ServiceProviderProvisioningStateProvisioned ...
	ServiceProviderProvisioningStateProvisioned ServiceProviderProvisioningState = "Provisioned"
	// ServiceProviderProvisioningStateProvisioning ...
	ServiceProviderProvisioningStateProvisioning ServiceProviderProvisioningState = "Provisioning"
)

// PossibleServiceProviderProvisioningStateValues returns an array of possible values for the ServiceProviderProvisioningState const type.
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return []ServiceProviderProvisioningState{ServiceProviderProvisioningStateDeprovisioning, ServiceProviderProvisioningStateNotProvisioned, ServiceProviderProvisioningStateProvisioned, ServiceProviderProvisioningStateProvisioning}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityWarning}
}

// SlotType enumerates the values for slot type.
type SlotType string

const (
	// Production ...
	Production SlotType = "Production"
	// Staging ...
	Staging SlotType = "Staging"
)

// PossibleSlotTypeValues returns an array of possible values for the SlotType const type.
func PossibleSlotTypeValues() []SlotType {
	return []SlotType{Production, Staging}
}

// SyncRemoteAddressSpace enumerates the values for sync remote address space.
type SyncRemoteAddressSpace string

const (
	// SyncRemoteAddressSpaceTrue ...
	SyncRemoteAddressSpaceTrue SyncRemoteAddressSpace = "true"
)

// PossibleSyncRemoteAddressSpaceValues returns an array of possible values for the SyncRemoteAddressSpace const type.
func PossibleSyncRemoteAddressSpaceValues() []SyncRemoteAddressSpace {
	return []SyncRemoteAddressSpace{SyncRemoteAddressSpaceTrue}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolAll ...
	TransportProtocolAll TransportProtocol = "All"
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "Udp"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolAll, TransportProtocolTCP, TransportProtocolUDP}
}

// TunnelConnectionStatus enumerates the values for tunnel connection status.
type TunnelConnectionStatus string

const (
	// TunnelConnectionStatusConnected ...
	TunnelConnectionStatusConnected TunnelConnectionStatus = "Connected"
	// TunnelConnectionStatusConnecting ...
	TunnelConnectionStatusConnecting TunnelConnectionStatus = "Connecting"
	// TunnelConnectionStatusNotConnected ...
	TunnelConnectionStatusNotConnected TunnelConnectionStatus = "NotConnected"
	// TunnelConnectionStatusUnknown ...
	TunnelConnectionStatusUnknown TunnelConnectionStatus = "Unknown"
)

// PossibleTunnelConnectionStatusValues returns an array of possible values for the TunnelConnectionStatus const type.
func PossibleTunnelConnectionStatusValues() []TunnelConnectionStatus {
	return []TunnelConnectionStatus{TunnelConnectionStatusConnected, TunnelConnectionStatusConnecting, TunnelConnectionStatusNotConnected, TunnelConnectionStatusUnknown}
}

// UseHubGateway enumerates the values for use hub gateway.
type UseHubGateway string

const (
	// UseHubGatewayFalse ...
	UseHubGatewayFalse UseHubGateway = "False"
	// UseHubGatewayTrue ...
	UseHubGatewayTrue UseHubGateway = "True"
)

// PossibleUseHubGatewayValues returns an array of possible values for the UseHubGateway const type.
func PossibleUseHubGatewayValues() []UseHubGateway {
	return []UseHubGateway{UseHubGatewayFalse, UseHubGatewayTrue}
}

// VerbosityLevel enumerates the values for verbosity level.
type VerbosityLevel string

const (
	// VerbosityLevelFull ...
	VerbosityLevelFull VerbosityLevel = "Full"
	// VerbosityLevelMinimum ...
	VerbosityLevelMinimum VerbosityLevel = "Minimum"
	// VerbosityLevelNormal ...
	VerbosityLevelNormal VerbosityLevel = "Normal"
)

// PossibleVerbosityLevelValues returns an array of possible values for the VerbosityLevel const type.
func PossibleVerbosityLevelValues() []VerbosityLevel {
	return []VerbosityLevel{VerbosityLevelFull, VerbosityLevelMinimum, VerbosityLevelNormal}
}

// VirtualNetworkEncryptionEnforcement enumerates the values for virtual network encryption enforcement.
type VirtualNetworkEncryptionEnforcement string

const (
	// AllowUnencrypted ...
	AllowUnencrypted VirtualNetworkEncryptionEnforcement = "AllowUnencrypted"
	// DropUnencrypted ...
	DropUnencrypted VirtualNetworkEncryptionEnforcement = "DropUnencrypted"
)

// PossibleVirtualNetworkEncryptionEnforcementValues returns an array of possible values for the VirtualNetworkEncryptionEnforcement const type.
func PossibleVirtualNetworkEncryptionEnforcementValues() []VirtualNetworkEncryptionEnforcement {
	return []VirtualNetworkEncryptionEnforcement{AllowUnencrypted, DropUnencrypted}
}

// VirtualNetworkGatewayConnectionMode enumerates the values for virtual network gateway connection mode.
type VirtualNetworkGatewayConnectionMode string

const (
	// VirtualNetworkGatewayConnectionModeDefault ...
	VirtualNetworkGatewayConnectionModeDefault VirtualNetworkGatewayConnectionMode = "Default"
	// VirtualNetworkGatewayConnectionModeInitiatorOnly ...
	VirtualNetworkGatewayConnectionModeInitiatorOnly VirtualNetworkGatewayConnectionMode = "InitiatorOnly"
	// VirtualNetworkGatewayConnectionModeResponderOnly ...
	VirtualNetworkGatewayConnectionModeResponderOnly VirtualNetworkGatewayConnectionMode = "ResponderOnly"
)

// PossibleVirtualNetworkGatewayConnectionModeValues returns an array of possible values for the VirtualNetworkGatewayConnectionMode const type.
func PossibleVirtualNetworkGatewayConnectionModeValues() []VirtualNetworkGatewayConnectionMode {
	return []VirtualNetworkGatewayConnectionMode{VirtualNetworkGatewayConnectionModeDefault, VirtualNetworkGatewayConnectionModeInitiatorOnly, VirtualNetworkGatewayConnectionModeResponderOnly}
}

// VirtualNetworkGatewayConnectionProtocol enumerates the values for virtual network gateway connection
// protocol.
type VirtualNetworkGatewayConnectionProtocol string

const (
	// IKEv1 ...
	IKEv1 VirtualNetworkGatewayConnectionProtocol = "IKEv1"
	// IKEv2 ...
	IKEv2 VirtualNetworkGatewayConnectionProtocol = "IKEv2"
)

// PossibleVirtualNetworkGatewayConnectionProtocolValues returns an array of possible values for the VirtualNetworkGatewayConnectionProtocol const type.
func PossibleVirtualNetworkGatewayConnectionProtocolValues() []VirtualNetworkGatewayConnectionProtocol {
	return []VirtualNetworkGatewayConnectionProtocol{IKEv1, IKEv2}
}

// VirtualNetworkGatewayConnectionStatus enumerates the values for virtual network gateway connection status.
type VirtualNetworkGatewayConnectionStatus string

const (
	// VirtualNetworkGatewayConnectionStatusConnected ...
	VirtualNetworkGatewayConnectionStatusConnected VirtualNetworkGatewayConnectionStatus = "Connected"
	// VirtualNetworkGatewayConnectionStatusConnecting ...
	VirtualNetworkGatewayConnectionStatusConnecting VirtualNetworkGatewayConnectionStatus = "Connecting"
	// VirtualNetworkGatewayConnectionStatusNotConnected ...
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	// VirtualNetworkGatewayConnectionStatusUnknown ...
	VirtualNetworkGatewayConnectionStatusUnknown VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// PossibleVirtualNetworkGatewayConnectionStatusValues returns an array of possible values for the VirtualNetworkGatewayConnectionStatus const type.
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return []VirtualNetworkGatewayConnectionStatus{VirtualNetworkGatewayConnectionStatusConnected, VirtualNetworkGatewayConnectionStatusConnecting, VirtualNetworkGatewayConnectionStatusNotConnected, VirtualNetworkGatewayConnectionStatusUnknown}
}

// VirtualNetworkGatewayConnectionType enumerates the values for virtual network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// ExpressRoute ...
	ExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// IPsec ...
	IPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// Vnet2Vnet ...
	Vnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VPNClient ...
	VPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// PossibleVirtualNetworkGatewayConnectionTypeValues returns an array of possible values for the VirtualNetworkGatewayConnectionType const type.
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return []VirtualNetworkGatewayConnectionType{ExpressRoute, IPsec, Vnet2Vnet, VPNClient}
}

// VirtualNetworkGatewaySkuName enumerates the values for virtual network gateway sku name.
type VirtualNetworkGatewaySkuName string

const (
	// VirtualNetworkGatewaySkuNameBasic ...
	VirtualNetworkGatewaySkuNameBasic VirtualNetworkGatewaySkuName = "Basic"
	// VirtualNetworkGatewaySkuNameErGw1AZ ...
	VirtualNetworkGatewaySkuNameErGw1AZ VirtualNetworkGatewaySkuName = "ErGw1AZ"
	// VirtualNetworkGatewaySkuNameErGw2AZ ...
	VirtualNetworkGatewaySkuNameErGw2AZ VirtualNetworkGatewaySkuName = "ErGw2AZ"
	// VirtualNetworkGatewaySkuNameErGw3AZ ...
	VirtualNetworkGatewaySkuNameErGw3AZ VirtualNetworkGatewaySkuName = "ErGw3AZ"
	// VirtualNetworkGatewaySkuNameHighPerformance ...
	VirtualNetworkGatewaySkuNameHighPerformance VirtualNetworkGatewaySkuName = "HighPerformance"
	// VirtualNetworkGatewaySkuNameStandard ...
	VirtualNetworkGatewaySkuNameStandard VirtualNetworkGatewaySkuName = "Standard"
	// VirtualNetworkGatewaySkuNameUltraPerformance ...
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = "UltraPerformance"
	// VirtualNetworkGatewaySkuNameVpnGw1 ...
	VirtualNetworkGatewaySkuNameVpnGw1 VirtualNetworkGatewaySkuName = "VpnGw1"
	// VirtualNetworkGatewaySkuNameVpnGw1AZ ...
	VirtualNetworkGatewaySkuNameVpnGw1AZ VirtualNetworkGatewaySkuName = "VpnGw1AZ"
	// VirtualNetworkGatewaySkuNameVpnGw2 ...
	VirtualNetworkGatewaySkuNameVpnGw2 VirtualNetworkGatewaySkuName = "VpnGw2"
	// VirtualNetworkGatewaySkuNameVpnGw2AZ ...
	VirtualNetworkGatewaySkuNameVpnGw2AZ VirtualNetworkGatewaySkuName = "VpnGw2AZ"
	// VirtualNetworkGatewaySkuNameVpnGw3 ...
	VirtualNetworkGatewaySkuNameVpnGw3 VirtualNetworkGatewaySkuName = "VpnGw3"
	// VirtualNetworkGatewaySkuNameVpnGw3AZ ...
	VirtualNetworkGatewaySkuNameVpnGw3AZ VirtualNetworkGatewaySkuName = "VpnGw3AZ"
	// VirtualNetworkGatewaySkuNameVpnGw4 ...
	VirtualNetworkGatewaySkuNameVpnGw4 VirtualNetworkGatewaySkuName = "VpnGw4"
	// VirtualNetworkGatewaySkuNameVpnGw4AZ ...
	VirtualNetworkGatewaySkuNameVpnGw4AZ VirtualNetworkGatewaySkuName = "VpnGw4AZ"
	// VirtualNetworkGatewaySkuNameVpnGw5 ...
	VirtualNetworkGatewaySkuNameVpnGw5 VirtualNetworkGatewaySkuName = "VpnGw5"
	// VirtualNetworkGatewaySkuNameVpnGw5AZ ...
	VirtualNetworkGatewaySkuNameVpnGw5AZ VirtualNetworkGatewaySkuName = "VpnGw5AZ"
)

// PossibleVirtualNetworkGatewaySkuNameValues returns an array of possible values for the VirtualNetworkGatewaySkuName const type.
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return []VirtualNetworkGatewaySkuName{VirtualNetworkGatewaySkuNameBasic, VirtualNetworkGatewaySkuNameErGw1AZ, VirtualNetworkGatewaySkuNameErGw2AZ, VirtualNetworkGatewaySkuNameErGw3AZ, VirtualNetworkGatewaySkuNameHighPerformance, VirtualNetworkGatewaySkuNameStandard, VirtualNetworkGatewaySkuNameUltraPerformance, VirtualNetworkGatewaySkuNameVpnGw1, VirtualNetworkGatewaySkuNameVpnGw1AZ, VirtualNetworkGatewaySkuNameVpnGw2, VirtualNetworkGatewaySkuNameVpnGw2AZ, VirtualNetworkGatewaySkuNameVpnGw3, VirtualNetworkGatewaySkuNameVpnGw3AZ, VirtualNetworkGatewaySkuNameVpnGw4, VirtualNetworkGatewaySkuNameVpnGw4AZ, VirtualNetworkGatewaySkuNameVpnGw5, VirtualNetworkGatewaySkuNameVpnGw5AZ}
}

// VirtualNetworkGatewaySkuTier enumerates the values for virtual network gateway sku tier.
type VirtualNetworkGatewaySkuTier string

const (
	// VirtualNetworkGatewaySkuTierBasic ...
	VirtualNetworkGatewaySkuTierBasic VirtualNetworkGatewaySkuTier = "Basic"
	// VirtualNetworkGatewaySkuTierErGw1AZ ...
	VirtualNetworkGatewaySkuTierErGw1AZ VirtualNetworkGatewaySkuTier = "ErGw1AZ"
	// VirtualNetworkGatewaySkuTierErGw2AZ ...
	VirtualNetworkGatewaySkuTierErGw2AZ VirtualNetworkGatewaySkuTier = "ErGw2AZ"
	// VirtualNetworkGatewaySkuTierErGw3AZ ...
	VirtualNetworkGatewaySkuTierErGw3AZ VirtualNetworkGatewaySkuTier = "ErGw3AZ"
	// VirtualNetworkGatewaySkuTierHighPerformance ...
	VirtualNetworkGatewaySkuTierHighPerformance VirtualNetworkGatewaySkuTier = "HighPerformance"
	// VirtualNetworkGatewaySkuTierStandard ...
	VirtualNetworkGatewaySkuTierStandard VirtualNetworkGatewaySkuTier = "Standard"
	// VirtualNetworkGatewaySkuTierUltraPerformance ...
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = "UltraPerformance"
	// VirtualNetworkGatewaySkuTierVpnGw1 ...
	VirtualNetworkGatewaySkuTierVpnGw1 VirtualNetworkGatewaySkuTier = "VpnGw1"
	// VirtualNetworkGatewaySkuTierVpnGw1AZ ...
	VirtualNetworkGatewaySkuTierVpnGw1AZ VirtualNetworkGatewaySkuTier = "VpnGw1AZ"
	// VirtualNetworkGatewaySkuTierVpnGw2 ...
	VirtualNetworkGatewaySkuTierVpnGw2 VirtualNetworkGatewaySkuTier = "VpnGw2"
	// VirtualNetworkGatewaySkuTierVpnGw2AZ ...
	VirtualNetworkGatewaySkuTierVpnGw2AZ VirtualNetworkGatewaySkuTier = "VpnGw2AZ"
	// VirtualNetworkGatewaySkuTierVpnGw3 ...
	VirtualNetworkGatewaySkuTierVpnGw3 VirtualNetworkGatewaySkuTier = "VpnGw3"
	// VirtualNetworkGatewaySkuTierVpnGw3AZ ...
	VirtualNetworkGatewaySkuTierVpnGw3AZ VirtualNetworkGatewaySkuTier = "VpnGw3AZ"
	// VirtualNetworkGatewaySkuTierVpnGw4 ...
	VirtualNetworkGatewaySkuTierVpnGw4 VirtualNetworkGatewaySkuTier = "VpnGw4"
	// VirtualNetworkGatewaySkuTierVpnGw4AZ ...
	VirtualNetworkGatewaySkuTierVpnGw4AZ VirtualNetworkGatewaySkuTier = "VpnGw4AZ"
	// VirtualNetworkGatewaySkuTierVpnGw5 ...
	VirtualNetworkGatewaySkuTierVpnGw5 VirtualNetworkGatewaySkuTier = "VpnGw5"
	// VirtualNetworkGatewaySkuTierVpnGw5AZ ...
	VirtualNetworkGatewaySkuTierVpnGw5AZ VirtualNetworkGatewaySkuTier = "VpnGw5AZ"
)

// PossibleVirtualNetworkGatewaySkuTierValues returns an array of possible values for the VirtualNetworkGatewaySkuTier const type.
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return []VirtualNetworkGatewaySkuTier{VirtualNetworkGatewaySkuTierBasic, VirtualNetworkGatewaySkuTierErGw1AZ, VirtualNetworkGatewaySkuTierErGw2AZ, VirtualNetworkGatewaySkuTierErGw3AZ, VirtualNetworkGatewaySkuTierHighPerformance, VirtualNetworkGatewaySkuTierStandard, VirtualNetworkGatewaySkuTierUltraPerformance, VirtualNetworkGatewaySkuTierVpnGw1, VirtualNetworkGatewaySkuTierVpnGw1AZ, VirtualNetworkGatewaySkuTierVpnGw2, VirtualNetworkGatewaySkuTierVpnGw2AZ, VirtualNetworkGatewaySkuTierVpnGw3, VirtualNetworkGatewaySkuTierVpnGw3AZ, VirtualNetworkGatewaySkuTierVpnGw4, VirtualNetworkGatewaySkuTierVpnGw4AZ, VirtualNetworkGatewaySkuTierVpnGw5, VirtualNetworkGatewaySkuTierVpnGw5AZ}
}

// VirtualNetworkGatewayType enumerates the values for virtual network gateway type.
type VirtualNetworkGatewayType string

const (
	// VirtualNetworkGatewayTypeExpressRoute ...
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	// VirtualNetworkGatewayTypeLocalGateway ...
	VirtualNetworkGatewayTypeLocalGateway VirtualNetworkGatewayType = "LocalGateway"
	// VirtualNetworkGatewayTypeVpn ...
	VirtualNetworkGatewayTypeVpn VirtualNetworkGatewayType = "Vpn"
)

// PossibleVirtualNetworkGatewayTypeValues returns an array of possible values for the VirtualNetworkGatewayType const type.
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return []VirtualNetworkGatewayType{VirtualNetworkGatewayTypeExpressRoute, VirtualNetworkGatewayTypeLocalGateway, VirtualNetworkGatewayTypeVpn}
}

// VirtualNetworkPeeringLevel enumerates the values for virtual network peering level.
type VirtualNetworkPeeringLevel string

const (
	// FullyInSync ...
	FullyInSync VirtualNetworkPeeringLevel = "FullyInSync"
	// LocalAndRemoteNotInSync ...
	LocalAndRemoteNotInSync VirtualNetworkPeeringLevel = "LocalAndRemoteNotInSync"
	// LocalNotInSync ...
	LocalNotInSync VirtualNetworkPeeringLevel = "LocalNotInSync"
	// RemoteNotInSync ...
	RemoteNotInSync VirtualNetworkPeeringLevel = "RemoteNotInSync"
)

// PossibleVirtualNetworkPeeringLevelValues returns an array of possible values for the VirtualNetworkPeeringLevel const type.
func PossibleVirtualNetworkPeeringLevelValues() []VirtualNetworkPeeringLevel {
	return []VirtualNetworkPeeringLevel{FullyInSync, LocalAndRemoteNotInSync, LocalNotInSync, RemoteNotInSync}
}

// VirtualNetworkPeeringState enumerates the values for virtual network peering state.
type VirtualNetworkPeeringState string

const (
	// VirtualNetworkPeeringStateConnected ...
	VirtualNetworkPeeringStateConnected VirtualNetworkPeeringState = "Connected"
	// VirtualNetworkPeeringStateDisconnected ...
	VirtualNetworkPeeringStateDisconnected VirtualNetworkPeeringState = "Disconnected"
	// VirtualNetworkPeeringStateInitiated ...
	VirtualNetworkPeeringStateInitiated VirtualNetworkPeeringState = "Initiated"
)

// PossibleVirtualNetworkPeeringStateValues returns an array of possible values for the VirtualNetworkPeeringState const type.
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return []VirtualNetworkPeeringState{VirtualNetworkPeeringStateConnected, VirtualNetworkPeeringStateDisconnected, VirtualNetworkPeeringStateInitiated}
}

// VirtualNetworkPrivateEndpointNetworkPolicies enumerates the values for virtual network private endpoint
// network policies.
type VirtualNetworkPrivateEndpointNetworkPolicies string

const (
	// VirtualNetworkPrivateEndpointNetworkPoliciesDisabled ...
	VirtualNetworkPrivateEndpointNetworkPoliciesDisabled VirtualNetworkPrivateEndpointNetworkPolicies = "Disabled"
	// VirtualNetworkPrivateEndpointNetworkPoliciesEnabled ...
	VirtualNetworkPrivateEndpointNetworkPoliciesEnabled VirtualNetworkPrivateEndpointNetworkPolicies = "Enabled"
)

// PossibleVirtualNetworkPrivateEndpointNetworkPoliciesValues returns an array of possible values for the VirtualNetworkPrivateEndpointNetworkPolicies const type.
func PossibleVirtualNetworkPrivateEndpointNetworkPoliciesValues() []VirtualNetworkPrivateEndpointNetworkPolicies {
	return []VirtualNetworkPrivateEndpointNetworkPolicies{VirtualNetworkPrivateEndpointNetworkPoliciesDisabled, VirtualNetworkPrivateEndpointNetworkPoliciesEnabled}
}

// VirtualNetworkPrivateLinkServiceNetworkPolicies enumerates the values for virtual network private link
// service network policies.
type VirtualNetworkPrivateLinkServiceNetworkPolicies string

const (
	// VirtualNetworkPrivateLinkServiceNetworkPoliciesDisabled ...
	VirtualNetworkPrivateLinkServiceNetworkPoliciesDisabled VirtualNetworkPrivateLinkServiceNetworkPolicies = "Disabled"
	// VirtualNetworkPrivateLinkServiceNetworkPoliciesEnabled ...
	VirtualNetworkPrivateLinkServiceNetworkPoliciesEnabled VirtualNetworkPrivateLinkServiceNetworkPolicies = "Enabled"
)

// PossibleVirtualNetworkPrivateLinkServiceNetworkPoliciesValues returns an array of possible values for the VirtualNetworkPrivateLinkServiceNetworkPolicies const type.
func PossibleVirtualNetworkPrivateLinkServiceNetworkPoliciesValues() []VirtualNetworkPrivateLinkServiceNetworkPolicies {
	return []VirtualNetworkPrivateLinkServiceNetworkPolicies{VirtualNetworkPrivateLinkServiceNetworkPoliciesDisabled, VirtualNetworkPrivateLinkServiceNetworkPoliciesEnabled}
}

// VirtualWanSecurityProviderType enumerates the values for virtual wan security provider type.
type VirtualWanSecurityProviderType string

const (
	// External ...
	External VirtualWanSecurityProviderType = "External"
	// Native ...
	Native VirtualWanSecurityProviderType = "Native"
)

// PossibleVirtualWanSecurityProviderTypeValues returns an array of possible values for the VirtualWanSecurityProviderType const type.
func PossibleVirtualWanSecurityProviderTypeValues() []VirtualWanSecurityProviderType {
	return []VirtualWanSecurityProviderType{External, Native}
}

// VnetLocalRouteOverrideCriteria enumerates the values for vnet local route override criteria.
type VnetLocalRouteOverrideCriteria string

const (
	// VnetLocalRouteOverrideCriteriaContains ...
	VnetLocalRouteOverrideCriteriaContains VnetLocalRouteOverrideCriteria = "Contains"
	// VnetLocalRouteOverrideCriteriaEqual ...
	VnetLocalRouteOverrideCriteriaEqual VnetLocalRouteOverrideCriteria = "Equal"
)

// PossibleVnetLocalRouteOverrideCriteriaValues returns an array of possible values for the VnetLocalRouteOverrideCriteria const type.
func PossibleVnetLocalRouteOverrideCriteriaValues() []VnetLocalRouteOverrideCriteria {
	return []VnetLocalRouteOverrideCriteria{VnetLocalRouteOverrideCriteriaContains, VnetLocalRouteOverrideCriteriaEqual}
}

// VpnAuthenticationType enumerates the values for vpn authentication type.
type VpnAuthenticationType string

const (
	// AAD ...
	AAD VpnAuthenticationType = "AAD"
	// Certificate ...
	Certificate VpnAuthenticationType = "Certificate"
	// Radius ...
	Radius VpnAuthenticationType = "Radius"
)

// PossibleVpnAuthenticationTypeValues returns an array of possible values for the VpnAuthenticationType const type.
func PossibleVpnAuthenticationTypeValues() []VpnAuthenticationType {
	return []VpnAuthenticationType{AAD, Certificate, Radius}
}

// VpnClientProtocol enumerates the values for vpn client protocol.
type VpnClientProtocol string

const (
	// IkeV2 ...
	IkeV2 VpnClientProtocol = "IkeV2"
	// OpenVPN ...
	OpenVPN VpnClientProtocol = "OpenVPN"
	// SSTP ...
	SSTP VpnClientProtocol = "SSTP"
)

// PossibleVpnClientProtocolValues returns an array of possible values for the VpnClientProtocol const type.
func PossibleVpnClientProtocolValues() []VpnClientProtocol {
	return []VpnClientProtocol{IkeV2, OpenVPN, SSTP}
}

// VpnConnectionStatus enumerates the values for vpn connection status.
type VpnConnectionStatus string

const (
	// VpnConnectionStatusConnected ...
	VpnConnectionStatusConnected VpnConnectionStatus = "Connected"
	// VpnConnectionStatusConnecting ...
	VpnConnectionStatusConnecting VpnConnectionStatus = "Connecting"
	// VpnConnectionStatusNotConnected ...
	VpnConnectionStatusNotConnected VpnConnectionStatus = "NotConnected"
	// VpnConnectionStatusUnknown ...
	VpnConnectionStatusUnknown VpnConnectionStatus = "Unknown"
)

// PossibleVpnConnectionStatusValues returns an array of possible values for the VpnConnectionStatus const type.
func PossibleVpnConnectionStatusValues() []VpnConnectionStatus {
	return []VpnConnectionStatus{VpnConnectionStatusConnected, VpnConnectionStatusConnecting, VpnConnectionStatusNotConnected, VpnConnectionStatusUnknown}
}

// VpnGatewayGeneration enumerates the values for vpn gateway generation.
type VpnGatewayGeneration string

const (
	// VpnGatewayGenerationGeneration1 ...
	VpnGatewayGenerationGeneration1 VpnGatewayGeneration = "Generation1"
	// VpnGatewayGenerationGeneration2 ...
	VpnGatewayGenerationGeneration2 VpnGatewayGeneration = "Generation2"
	// VpnGatewayGenerationNone ...
	VpnGatewayGenerationNone VpnGatewayGeneration = "None"
)

// PossibleVpnGatewayGenerationValues returns an array of possible values for the VpnGatewayGeneration const type.
func PossibleVpnGatewayGenerationValues() []VpnGatewayGeneration {
	return []VpnGatewayGeneration{VpnGatewayGenerationGeneration1, VpnGatewayGenerationGeneration2, VpnGatewayGenerationNone}
}

// VpnGatewayTunnelingProtocol enumerates the values for vpn gateway tunneling protocol.
type VpnGatewayTunnelingProtocol string

const (
	// VpnGatewayTunnelingProtocolIkeV2 ...
	VpnGatewayTunnelingProtocolIkeV2 VpnGatewayTunnelingProtocol = "IkeV2"
	// VpnGatewayTunnelingProtocolOpenVPN ...
	VpnGatewayTunnelingProtocolOpenVPN VpnGatewayTunnelingProtocol = "OpenVPN"
)

// PossibleVpnGatewayTunnelingProtocolValues returns an array of possible values for the VpnGatewayTunnelingProtocol const type.
func PossibleVpnGatewayTunnelingProtocolValues() []VpnGatewayTunnelingProtocol {
	return []VpnGatewayTunnelingProtocol{VpnGatewayTunnelingProtocolIkeV2, VpnGatewayTunnelingProtocolOpenVPN}
}

// VpnLinkConnectionMode enumerates the values for vpn link connection mode.
type VpnLinkConnectionMode string

const (
	// VpnLinkConnectionModeDefault ...
	VpnLinkConnectionModeDefault VpnLinkConnectionMode = "Default"
	// VpnLinkConnectionModeInitiatorOnly ...
	VpnLinkConnectionModeInitiatorOnly VpnLinkConnectionMode = "InitiatorOnly"
	// VpnLinkConnectionModeResponderOnly ...
	VpnLinkConnectionModeResponderOnly VpnLinkConnectionMode = "ResponderOnly"
)

// PossibleVpnLinkConnectionModeValues returns an array of possible values for the VpnLinkConnectionMode const type.
func PossibleVpnLinkConnectionModeValues() []VpnLinkConnectionMode {
	return []VpnLinkConnectionMode{VpnLinkConnectionModeDefault, VpnLinkConnectionModeInitiatorOnly, VpnLinkConnectionModeResponderOnly}
}

// VpnNatRuleMode enumerates the values for vpn nat rule mode.
type VpnNatRuleMode string

const (
	// EgressSnat ...
	EgressSnat VpnNatRuleMode = "EgressSnat"
	// IngressSnat ...
	IngressSnat VpnNatRuleMode = "IngressSnat"
)

// PossibleVpnNatRuleModeValues returns an array of possible values for the VpnNatRuleMode const type.
func PossibleVpnNatRuleModeValues() []VpnNatRuleMode {
	return []VpnNatRuleMode{EgressSnat, IngressSnat}
}

// VpnNatRuleType enumerates the values for vpn nat rule type.
type VpnNatRuleType string

const (
	// VpnNatRuleTypeDynamic ...
	VpnNatRuleTypeDynamic VpnNatRuleType = "Dynamic"
	// VpnNatRuleTypeStatic ...
	VpnNatRuleTypeStatic VpnNatRuleType = "Static"
)

// PossibleVpnNatRuleTypeValues returns an array of possible values for the VpnNatRuleType const type.
func PossibleVpnNatRuleTypeValues() []VpnNatRuleType {
	return []VpnNatRuleType{VpnNatRuleTypeDynamic, VpnNatRuleTypeStatic}
}

// VpnPolicyMemberAttributeType enumerates the values for vpn policy member attribute type.
type VpnPolicyMemberAttributeType string

const (
	// AADGroupID ...
	AADGroupID VpnPolicyMemberAttributeType = "AADGroupId"
	// CertificateGroupID ...
	CertificateGroupID VpnPolicyMemberAttributeType = "CertificateGroupId"
	// RadiusAzureGroupID ...
	RadiusAzureGroupID VpnPolicyMemberAttributeType = "RadiusAzureGroupId"
)

// PossibleVpnPolicyMemberAttributeTypeValues returns an array of possible values for the VpnPolicyMemberAttributeType const type.
func PossibleVpnPolicyMemberAttributeTypeValues() []VpnPolicyMemberAttributeType {
	return []VpnPolicyMemberAttributeType{AADGroupID, CertificateGroupID, RadiusAzureGroupID}
}

// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// PolicyBased ...
	PolicyBased VpnType = "PolicyBased"
	// RouteBased ...
	RouteBased VpnType = "RouteBased"
)

// PossibleVpnTypeValues returns an array of possible values for the VpnType const type.
func PossibleVpnTypeValues() []VpnType {
	return []VpnType{PolicyBased, RouteBased}
}

// WebApplicationFirewallAction enumerates the values for web application firewall action.
type WebApplicationFirewallAction string

const (
	// WebApplicationFirewallActionAllow ...
	WebApplicationFirewallActionAllow WebApplicationFirewallAction = "Allow"
	// WebApplicationFirewallActionBlock ...
	WebApplicationFirewallActionBlock WebApplicationFirewallAction = "Block"
	// WebApplicationFirewallActionLog ...
	WebApplicationFirewallActionLog WebApplicationFirewallAction = "Log"
)

// PossibleWebApplicationFirewallActionValues returns an array of possible values for the WebApplicationFirewallAction const type.
func PossibleWebApplicationFirewallActionValues() []WebApplicationFirewallAction {
	return []WebApplicationFirewallAction{WebApplicationFirewallActionAllow, WebApplicationFirewallActionBlock, WebApplicationFirewallActionLog}
}

// WebApplicationFirewallEnabledState enumerates the values for web application firewall enabled state.
type WebApplicationFirewallEnabledState string

const (
	// WebApplicationFirewallEnabledStateDisabled ...
	WebApplicationFirewallEnabledStateDisabled WebApplicationFirewallEnabledState = "Disabled"
	// WebApplicationFirewallEnabledStateEnabled ...
	WebApplicationFirewallEnabledStateEnabled WebApplicationFirewallEnabledState = "Enabled"
)

// PossibleWebApplicationFirewallEnabledStateValues returns an array of possible values for the WebApplicationFirewallEnabledState const type.
func PossibleWebApplicationFirewallEnabledStateValues() []WebApplicationFirewallEnabledState {
	return []WebApplicationFirewallEnabledState{WebApplicationFirewallEnabledStateDisabled, WebApplicationFirewallEnabledStateEnabled}
}

// WebApplicationFirewallMatchVariable enumerates the values for web application firewall match variable.
type WebApplicationFirewallMatchVariable string

const (
	// PostArgs ...
	PostArgs WebApplicationFirewallMatchVariable = "PostArgs"
	// QueryString ...
	QueryString WebApplicationFirewallMatchVariable = "QueryString"
	// RemoteAddr ...
	RemoteAddr WebApplicationFirewallMatchVariable = "RemoteAddr"
	// RequestBody ...
	RequestBody WebApplicationFirewallMatchVariable = "RequestBody"
	// RequestCookies ...
	RequestCookies WebApplicationFirewallMatchVariable = "RequestCookies"
	// RequestHeaders ...
	RequestHeaders WebApplicationFirewallMatchVariable = "RequestHeaders"
	// RequestMethod ...
	RequestMethod WebApplicationFirewallMatchVariable = "RequestMethod"
	// RequestURI ...
	RequestURI WebApplicationFirewallMatchVariable = "RequestUri"
)

// PossibleWebApplicationFirewallMatchVariableValues returns an array of possible values for the WebApplicationFirewallMatchVariable const type.
func PossibleWebApplicationFirewallMatchVariableValues() []WebApplicationFirewallMatchVariable {
	return []WebApplicationFirewallMatchVariable{PostArgs, QueryString, RemoteAddr, RequestBody, RequestCookies, RequestHeaders, RequestMethod, RequestURI}
}

// WebApplicationFirewallMode enumerates the values for web application firewall mode.
type WebApplicationFirewallMode string

const (
	// WebApplicationFirewallModeDetection ...
	WebApplicationFirewallModeDetection WebApplicationFirewallMode = "Detection"
	// WebApplicationFirewallModePrevention ...
	WebApplicationFirewallModePrevention WebApplicationFirewallMode = "Prevention"
)

// PossibleWebApplicationFirewallModeValues returns an array of possible values for the WebApplicationFirewallMode const type.
func PossibleWebApplicationFirewallModeValues() []WebApplicationFirewallMode {
	return []WebApplicationFirewallMode{WebApplicationFirewallModeDetection, WebApplicationFirewallModePrevention}
}

// WebApplicationFirewallOperator enumerates the values for web application firewall operator.
type WebApplicationFirewallOperator string

const (
	// WebApplicationFirewallOperatorAny ...
	WebApplicationFirewallOperatorAny WebApplicationFirewallOperator = "Any"
	// WebApplicationFirewallOperatorBeginsWith ...
	WebApplicationFirewallOperatorBeginsWith WebApplicationFirewallOperator = "BeginsWith"
	// WebApplicationFirewallOperatorContains ...
	WebApplicationFirewallOperatorContains WebApplicationFirewallOperator = "Contains"
	// WebApplicationFirewallOperatorEndsWith ...
	WebApplicationFirewallOperatorEndsWith WebApplicationFirewallOperator = "EndsWith"
	// WebApplicationFirewallOperatorEqual ...
	WebApplicationFirewallOperatorEqual WebApplicationFirewallOperator = "Equal"
	// WebApplicationFirewallOperatorGeoMatch ...
	WebApplicationFirewallOperatorGeoMatch WebApplicationFirewallOperator = "GeoMatch"
	// WebApplicationFirewallOperatorGreaterThan ...
	WebApplicationFirewallOperatorGreaterThan WebApplicationFirewallOperator = "GreaterThan"
	// WebApplicationFirewallOperatorGreaterThanOrEqual ...
	WebApplicationFirewallOperatorGreaterThanOrEqual WebApplicationFirewallOperator = "GreaterThanOrEqual"
	// WebApplicationFirewallOperatorIPMatch ...
	WebApplicationFirewallOperatorIPMatch WebApplicationFirewallOperator = "IPMatch"
	// WebApplicationFirewallOperatorLessThan ...
	WebApplicationFirewallOperatorLessThan WebApplicationFirewallOperator = "LessThan"
	// WebApplicationFirewallOperatorLessThanOrEqual ...
	WebApplicationFirewallOperatorLessThanOrEqual WebApplicationFirewallOperator = "LessThanOrEqual"
	// WebApplicationFirewallOperatorRegex ...
	WebApplicationFirewallOperatorRegex WebApplicationFirewallOperator = "Regex"
)

// PossibleWebApplicationFirewallOperatorValues returns an array of possible values for the WebApplicationFirewallOperator const type.
func PossibleWebApplicationFirewallOperatorValues() []WebApplicationFirewallOperator {
	return []WebApplicationFirewallOperator{WebApplicationFirewallOperatorAny, WebApplicationFirewallOperatorBeginsWith, WebApplicationFirewallOperatorContains, WebApplicationFirewallOperatorEndsWith, WebApplicationFirewallOperatorEqual, WebApplicationFirewallOperatorGeoMatch, WebApplicationFirewallOperatorGreaterThan, WebApplicationFirewallOperatorGreaterThanOrEqual, WebApplicationFirewallOperatorIPMatch, WebApplicationFirewallOperatorLessThan, WebApplicationFirewallOperatorLessThanOrEqual, WebApplicationFirewallOperatorRegex}
}

// WebApplicationFirewallPolicyResourceState enumerates the values for web application firewall policy resource
// state.
type WebApplicationFirewallPolicyResourceState string

const (
	// WebApplicationFirewallPolicyResourceStateCreating ...
	WebApplicationFirewallPolicyResourceStateCreating WebApplicationFirewallPolicyResourceState = "Creating"
	// WebApplicationFirewallPolicyResourceStateDeleting ...
	WebApplicationFirewallPolicyResourceStateDeleting WebApplicationFirewallPolicyResourceState = "Deleting"
	// WebApplicationFirewallPolicyResourceStateDisabled ...
	WebApplicationFirewallPolicyResourceStateDisabled WebApplicationFirewallPolicyResourceState = "Disabled"
	// WebApplicationFirewallPolicyResourceStateDisabling ...
	WebApplicationFirewallPolicyResourceStateDisabling WebApplicationFirewallPolicyResourceState = "Disabling"
	// WebApplicationFirewallPolicyResourceStateEnabled ...
	WebApplicationFirewallPolicyResourceStateEnabled WebApplicationFirewallPolicyResourceState = "Enabled"
	// WebApplicationFirewallPolicyResourceStateEnabling ...
	WebApplicationFirewallPolicyResourceStateEnabling WebApplicationFirewallPolicyResourceState = "Enabling"
)

// PossibleWebApplicationFirewallPolicyResourceStateValues returns an array of possible values for the WebApplicationFirewallPolicyResourceState const type.
func PossibleWebApplicationFirewallPolicyResourceStateValues() []WebApplicationFirewallPolicyResourceState {
	return []WebApplicationFirewallPolicyResourceState{WebApplicationFirewallPolicyResourceStateCreating, WebApplicationFirewallPolicyResourceStateDeleting, WebApplicationFirewallPolicyResourceStateDisabled, WebApplicationFirewallPolicyResourceStateDisabling, WebApplicationFirewallPolicyResourceStateEnabled, WebApplicationFirewallPolicyResourceStateEnabling}
}

// WebApplicationFirewallRuleType enumerates the values for web application firewall rule type.
type WebApplicationFirewallRuleType string

const (
	// WebApplicationFirewallRuleTypeInvalid ...
	WebApplicationFirewallRuleTypeInvalid WebApplicationFirewallRuleType = "Invalid"
	// WebApplicationFirewallRuleTypeMatchRule ...
	WebApplicationFirewallRuleTypeMatchRule WebApplicationFirewallRuleType = "MatchRule"
)

// PossibleWebApplicationFirewallRuleTypeValues returns an array of possible values for the WebApplicationFirewallRuleType const type.
func PossibleWebApplicationFirewallRuleTypeValues() []WebApplicationFirewallRuleType {
	return []WebApplicationFirewallRuleType{WebApplicationFirewallRuleTypeInvalid, WebApplicationFirewallRuleTypeMatchRule}
}

// WebApplicationFirewallTransform enumerates the values for web application firewall transform.
type WebApplicationFirewallTransform string

const (
	// HTMLEntityDecode ...
	HTMLEntityDecode WebApplicationFirewallTransform = "HtmlEntityDecode"
	// Lowercase ...
	Lowercase WebApplicationFirewallTransform = "Lowercase"
	// RemoveNulls ...
	RemoveNulls WebApplicationFirewallTransform = "RemoveNulls"
	// Trim ...
	Trim WebApplicationFirewallTransform = "Trim"
	// Uppercase ...
	Uppercase WebApplicationFirewallTransform = "Uppercase"
	// URLDecode ...
	URLDecode WebApplicationFirewallTransform = "UrlDecode"
	// URLEncode ...
	URLEncode WebApplicationFirewallTransform = "UrlEncode"
)

// PossibleWebApplicationFirewallTransformValues returns an array of possible values for the WebApplicationFirewallTransform const type.
func PossibleWebApplicationFirewallTransformValues() []WebApplicationFirewallTransform {
	return []WebApplicationFirewallTransform{HTMLEntityDecode, Lowercase, RemoveNulls, Trim, Uppercase, URLDecode, URLEncode}
}
