//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package security

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/security/mgmt/v3.0/security"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AadConnectivityState = original.AadConnectivityState

const (
	Connected   AadConnectivityState = original.Connected
	Discovered  AadConnectivityState = original.Discovered
	NotLicensed AadConnectivityState = original.NotLicensed
)

type Action = original.Action

const (
	Add         Action = original.Add
	Recommended Action = original.Recommended
	Remove      Action = original.Remove
)

type ActionType = original.ActionType

const (
	ActionTypeAutomationAction ActionType = original.ActionTypeAutomationAction
	ActionTypeEventHub         ActionType = original.ActionTypeEventHub
	ActionTypeLogicApp         ActionType = original.ActionTypeLogicApp
	ActionTypeWorkspace        ActionType = original.ActionTypeWorkspace
)

type AdditionalWorkspaceDataType = original.AdditionalWorkspaceDataType

const (
	Alerts    AdditionalWorkspaceDataType = original.Alerts
	RawEvents AdditionalWorkspaceDataType = original.RawEvents
)

type AdditionalWorkspaceType = original.AdditionalWorkspaceType

const (
	Sentinel AdditionalWorkspaceType = original.Sentinel
)

type AlertSeverity = original.AlertSeverity

const (
	High          AlertSeverity = original.High
	Informational AlertSeverity = original.Informational
	Low           AlertSeverity = original.Low
	Medium        AlertSeverity = original.Medium
)

type AlertStatus = original.AlertStatus

const (
	Active     AlertStatus = original.Active
	Dismissed  AlertStatus = original.Dismissed
	InProgress AlertStatus = original.InProgress
	Resolved   AlertStatus = original.Resolved
)

type ApplicationConditionOperator = original.ApplicationConditionOperator

const (
	Equals ApplicationConditionOperator = original.Equals
	In     ApplicationConditionOperator = original.In
)

type AssessedResourceType = original.AssessedResourceType

const (
	AssessedResourceTypeAdditionalData                 AssessedResourceType = original.AssessedResourceTypeAdditionalData
	AssessedResourceTypeContainerRegistryVulnerability AssessedResourceType = original.AssessedResourceTypeContainerRegistryVulnerability
	AssessedResourceTypeServerVulnerabilityAssessment  AssessedResourceType = original.AssessedResourceTypeServerVulnerabilityAssessment
	AssessedResourceTypeSQLServerVulnerability         AssessedResourceType = original.AssessedResourceTypeSQLServerVulnerability
)

type AssessmentStatusCode = original.AssessmentStatusCode

const (
	Healthy       AssessmentStatusCode = original.Healthy
	NotApplicable AssessmentStatusCode = original.NotApplicable
	Unhealthy     AssessmentStatusCode = original.Unhealthy
)

type AssessmentType = original.AssessmentType

const (
	BuiltIn         AssessmentType = original.BuiltIn
	CustomerManaged AssessmentType = original.CustomerManaged
	CustomPolicy    AssessmentType = original.CustomPolicy
	VerifiedPartner AssessmentType = original.VerifiedPartner
)

type AuthenticationProvisioningState = original.AuthenticationProvisioningState

const (
	Expired         AuthenticationProvisioningState = original.Expired
	IncorrectPolicy AuthenticationProvisioningState = original.IncorrectPolicy
	Invalid         AuthenticationProvisioningState = original.Invalid
	Valid           AuthenticationProvisioningState = original.Valid
)

type AuthenticationType = original.AuthenticationType

const (
	AuthenticationTypeAuthenticationDetailsProperties AuthenticationType = original.AuthenticationTypeAuthenticationDetailsProperties
	AuthenticationTypeAwsAssumeRole                   AuthenticationType = original.AuthenticationTypeAwsAssumeRole
	AuthenticationTypeAwsCreds                        AuthenticationType = original.AuthenticationTypeAwsCreds
	AuthenticationTypeGcpCredentials                  AuthenticationType = original.AuthenticationTypeGcpCredentials
)

type AutoProvision = original.AutoProvision

const (
	Off AutoProvision = original.Off
	On  AutoProvision = original.On
)

type BundleType = original.BundleType

const (
	AppServices       BundleType = original.AppServices
	CosmosDbs         BundleType = original.CosmosDbs
	DNS               BundleType = original.DNS
	KeyVaults         BundleType = original.KeyVaults
	KubernetesService BundleType = original.KubernetesService
	ResourceManager   BundleType = original.ResourceManager
	SQLServers        BundleType = original.SQLServers
	StorageAccounts   BundleType = original.StorageAccounts
	VirtualMachines   BundleType = original.VirtualMachines
)

type Categories = original.Categories

const (
	Compute           Categories = original.Compute
	Data              Categories = original.Data
	IdentityAndAccess Categories = original.IdentityAndAccess
	IoT               Categories = original.IoT
	Networking        Categories = original.Networking
)

type CloudName = original.CloudName

const (
	AWS         CloudName = original.AWS
	Azure       CloudName = original.Azure
	AzureDevOps CloudName = original.AzureDevOps
	GCP         CloudName = original.GCP
	Github      CloudName = original.Github
)

type ConfigurationStatus = original.ConfigurationStatus

const (
	ConfigurationStatusConfigured    ConfigurationStatus = original.ConfigurationStatusConfigured
	ConfigurationStatusFailed        ConfigurationStatus = original.ConfigurationStatusFailed
	ConfigurationStatusInProgress    ConfigurationStatus = original.ConfigurationStatusInProgress
	ConfigurationStatusNoStatus      ConfigurationStatus = original.ConfigurationStatusNoStatus
	ConfigurationStatusNotConfigured ConfigurationStatus = original.ConfigurationStatusNotConfigured
)

type ConfigurationStatus1 = original.ConfigurationStatus1

const (
	ConfigurationStatus1Configured    ConfigurationStatus1 = original.ConfigurationStatus1Configured
	ConfigurationStatus1Failed        ConfigurationStatus1 = original.ConfigurationStatus1Failed
	ConfigurationStatus1InProgress    ConfigurationStatus1 = original.ConfigurationStatus1InProgress
	ConfigurationStatus1NoStatus      ConfigurationStatus1 = original.ConfigurationStatus1NoStatus
	ConfigurationStatus1NotConfigured ConfigurationStatus1 = original.ConfigurationStatus1NotConfigured
)

type ConfigurationStatus2 = original.ConfigurationStatus2

const (
	ConfigurationStatus2Configured    ConfigurationStatus2 = original.ConfigurationStatus2Configured
	ConfigurationStatus2Failed        ConfigurationStatus2 = original.ConfigurationStatus2Failed
	ConfigurationStatus2InProgress    ConfigurationStatus2 = original.ConfigurationStatus2InProgress
	ConfigurationStatus2NoStatus      ConfigurationStatus2 = original.ConfigurationStatus2NoStatus
	ConfigurationStatus2NotConfigured ConfigurationStatus2 = original.ConfigurationStatus2NotConfigured
)

type ConnectionType = original.ConnectionType

const (
	External ConnectionType = original.External
	Internal ConnectionType = original.Internal
)

type ControlType = original.ControlType

const (
	ControlTypeBuiltIn ControlType = original.ControlTypeBuiltIn
	ControlTypeCustom  ControlType = original.ControlTypeCustom
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DataSource = original.DataSource

const (
	TwinData DataSource = original.TwinData
)

type Direction = original.Direction

const (
	Inbound  Direction = original.Inbound
	Outbound Direction = original.Outbound
)

type EndOfSupportStatus = original.EndOfSupportStatus

const (
	NoLongerSupported                EndOfSupportStatus = original.NoLongerSupported
	None                             EndOfSupportStatus = original.None
	UpcomingNoLongerSupported        EndOfSupportStatus = original.UpcomingNoLongerSupported
	UpcomingVersionNoLongerSupported EndOfSupportStatus = original.UpcomingVersionNoLongerSupported
	VersionNoLongerSupported         EndOfSupportStatus = original.VersionNoLongerSupported
)

type EnforcementMode = original.EnforcementMode

const (
	EnforcementModeAudit   EnforcementMode = original.EnforcementModeAudit
	EnforcementModeEnforce EnforcementMode = original.EnforcementModeEnforce
	EnforcementModeNone    EnforcementMode = original.EnforcementModeNone
)

type EnforcementSupport = original.EnforcementSupport

const (
	NotSupported EnforcementSupport = original.NotSupported
	Supported    EnforcementSupport = original.Supported
	Unknown      EnforcementSupport = original.Unknown
)

type EnvironmentType = original.EnvironmentType

const (
	EnvironmentTypeAwsAccount       EnvironmentType = original.EnvironmentTypeAwsAccount
	EnvironmentTypeAzureDevOpsScope EnvironmentType = original.EnvironmentTypeAzureDevOpsScope
	EnvironmentTypeEnvironmentData  EnvironmentType = original.EnvironmentTypeEnvironmentData
	EnvironmentTypeGcpProject       EnvironmentType = original.EnvironmentTypeGcpProject
	EnvironmentTypeGithubScope      EnvironmentType = original.EnvironmentTypeGithubScope
)

type EventSource = original.EventSource

const (
	EventSourceAlerts                                 EventSource = original.EventSourceAlerts
	EventSourceAssessments                            EventSource = original.EventSourceAssessments
	EventSourceAssessmentsSnapshot                    EventSource = original.EventSourceAssessmentsSnapshot
	EventSourceRegulatoryComplianceAssessment         EventSource = original.EventSourceRegulatoryComplianceAssessment
	EventSourceRegulatoryComplianceAssessmentSnapshot EventSource = original.EventSourceRegulatoryComplianceAssessmentSnapshot
	EventSourceSecureScoreControls                    EventSource = original.EventSourceSecureScoreControls
	EventSourceSecureScoreControlsSnapshot            EventSource = original.EventSourceSecureScoreControlsSnapshot
	EventSourceSecureScores                           EventSource = original.EventSourceSecureScores
	EventSourceSecureScoresSnapshot                   EventSource = original.EventSourceSecureScoresSnapshot
	EventSourceSubAssessments                         EventSource = original.EventSourceSubAssessments
	EventSourceSubAssessmentsSnapshot                 EventSource = original.EventSourceSubAssessmentsSnapshot
)

type Exe = original.Exe

const (
	ExeAudit   Exe = original.ExeAudit
	ExeEnforce Exe = original.ExeEnforce
	ExeNone    Exe = original.ExeNone
)

type Executable = original.Executable

const (
	ExecutableAudit   Executable = original.ExecutableAudit
	ExecutableEnforce Executable = original.ExecutableEnforce
	ExecutableNone    Executable = original.ExecutableNone
)

type ExpandControlsEnum = original.ExpandControlsEnum

const (
	Definition ExpandControlsEnum = original.Definition
)

type ExpandEnum = original.ExpandEnum

const (
	Links    ExpandEnum = original.Links
	Metadata ExpandEnum = original.Metadata
)

type ExportData = original.ExportData

const (
	ExportDataRawEvents ExportData = original.ExportDataRawEvents
)

type ExternalSecuritySolutionKind = original.ExternalSecuritySolutionKind

const (
	AAD ExternalSecuritySolutionKind = original.AAD
	ATA ExternalSecuritySolutionKind = original.ATA
	CEF ExternalSecuritySolutionKind = original.CEF
)

type Family = original.Family

const (
	Ngfw    Family = original.Ngfw
	SaasWaf Family = original.SaasWaf
	Va      Family = original.Va
	Waf     Family = original.Waf
)

type FileType = original.FileType

const (
	FileTypeDll        FileType = original.FileTypeDll
	FileTypeExe        FileType = original.FileTypeExe
	FileTypeExecutable FileType = original.FileTypeExecutable
	FileTypeMsi        FileType = original.FileTypeMsi
	FileTypeScript     FileType = original.FileTypeScript
	FileTypeUnknown    FileType = original.FileTypeUnknown
)

type GovernanceRuleConditionOperator = original.GovernanceRuleConditionOperator

const (
	GovernanceRuleConditionOperatorEquals GovernanceRuleConditionOperator = original.GovernanceRuleConditionOperatorEquals
	GovernanceRuleConditionOperatorIn     GovernanceRuleConditionOperator = original.GovernanceRuleConditionOperatorIn
)

type GovernanceRuleOwnerSourceType = original.GovernanceRuleOwnerSourceType

const (
	ByTag    GovernanceRuleOwnerSourceType = original.ByTag
	Manually GovernanceRuleOwnerSourceType = original.Manually
)

type GovernanceRuleType = original.GovernanceRuleType

const (
	Integrated GovernanceRuleType = original.Integrated
	ServiceNow GovernanceRuleType = original.ServiceNow
)

type HybridComputeProvisioningState = original.HybridComputeProvisioningState

const (
	HybridComputeProvisioningStateExpired HybridComputeProvisioningState = original.HybridComputeProvisioningStateExpired
	HybridComputeProvisioningStateInvalid HybridComputeProvisioningState = original.HybridComputeProvisioningStateInvalid
	HybridComputeProvisioningStateValid   HybridComputeProvisioningState = original.HybridComputeProvisioningStateValid
)

type ImplementationEffort = original.ImplementationEffort

const (
	ImplementationEffortHigh     ImplementationEffort = original.ImplementationEffortHigh
	ImplementationEffortLow      ImplementationEffort = original.ImplementationEffortLow
	ImplementationEffortModerate ImplementationEffort = original.ImplementationEffortModerate
)

type InformationProtectionPolicyName = original.InformationProtectionPolicyName

const (
	Custom    InformationProtectionPolicyName = original.Custom
	Effective InformationProtectionPolicyName = original.Effective
)

type Intent = original.Intent

const (
	IntentCollection          Intent = original.IntentCollection
	IntentCommandAndControl   Intent = original.IntentCommandAndControl
	IntentCredentialAccess    Intent = original.IntentCredentialAccess
	IntentDefenseEvasion      Intent = original.IntentDefenseEvasion
	IntentDiscovery           Intent = original.IntentDiscovery
	IntentExecution           Intent = original.IntentExecution
	IntentExfiltration        Intent = original.IntentExfiltration
	IntentExploitation        Intent = original.IntentExploitation
	IntentImpact              Intent = original.IntentImpact
	IntentInitialAccess       Intent = original.IntentInitialAccess
	IntentLateralMovement     Intent = original.IntentLateralMovement
	IntentPersistence         Intent = original.IntentPersistence
	IntentPreAttack           Intent = original.IntentPreAttack
	IntentPrivilegeEscalation Intent = original.IntentPrivilegeEscalation
	IntentProbing             Intent = original.IntentProbing
	IntentUnknown             Intent = original.IntentUnknown
)

type Issue = original.Issue

const (
	ExecutableViolationsAudited   Issue = original.ExecutableViolationsAudited
	MsiAndScriptViolationsAudited Issue = original.MsiAndScriptViolationsAudited
	MsiAndScriptViolationsBlocked Issue = original.MsiAndScriptViolationsBlocked
	RulesViolatedManually         Issue = original.RulesViolatedManually
	ViolationsAudited             Issue = original.ViolationsAudited
	ViolationsBlocked             Issue = original.ViolationsBlocked
)

type KindEnum = original.KindEnum

const (
	KindAAD                      KindEnum = original.KindAAD
	KindATA                      KindEnum = original.KindATA
	KindCEF                      KindEnum = original.KindCEF
	KindExternalSecuritySolution KindEnum = original.KindExternalSecuritySolution
)

type KindEnum1 = original.KindEnum1

const (
	KindAlertSimulatorRequestProperties KindEnum1 = original.KindAlertSimulatorRequestProperties
	KindBundles                         KindEnum1 = original.KindBundles
)

type KindEnum2 = original.KindEnum2

const (
	KindAlertSyncSettings  KindEnum2 = original.KindAlertSyncSettings
	KindDataExportSettings KindEnum2 = original.KindDataExportSettings
	KindSetting            KindEnum2 = original.KindSetting
)

type MinimalSeverity = original.MinimalSeverity

const (
	MinimalSeverityHigh   MinimalSeverity = original.MinimalSeverityHigh
	MinimalSeverityLow    MinimalSeverity = original.MinimalSeverityLow
	MinimalSeverityMedium MinimalSeverity = original.MinimalSeverityMedium
)

type Msi = original.Msi

const (
	MsiAudit   Msi = original.MsiAudit
	MsiEnforce Msi = original.MsiEnforce
	MsiNone    Msi = original.MsiNone
)

type OfferingType = original.OfferingType

const (
	OfferingTypeCloudOffering                OfferingType = original.OfferingTypeCloudOffering
	OfferingTypeCspmMonitorAws               OfferingType = original.OfferingTypeCspmMonitorAws
	OfferingTypeCspmMonitorAzureDevOps       OfferingType = original.OfferingTypeCspmMonitorAzureDevOps
	OfferingTypeCspmMonitorGcp               OfferingType = original.OfferingTypeCspmMonitorGcp
	OfferingTypeCspmMonitorGithub            OfferingType = original.OfferingTypeCspmMonitorGithub
	OfferingTypeDefenderCspmAws              OfferingType = original.OfferingTypeDefenderCspmAws
	OfferingTypeDefenderCspmGcp              OfferingType = original.OfferingTypeDefenderCspmGcp
	OfferingTypeDefenderForContainersAws     OfferingType = original.OfferingTypeDefenderForContainersAws
	OfferingTypeDefenderForContainersGcp     OfferingType = original.OfferingTypeDefenderForContainersGcp
	OfferingTypeDefenderForDatabasesAws      OfferingType = original.OfferingTypeDefenderForDatabasesAws
	OfferingTypeDefenderForDatabasesGcp      OfferingType = original.OfferingTypeDefenderForDatabasesGcp
	OfferingTypeDefenderForDevOpsAzureDevOps OfferingType = original.OfferingTypeDefenderForDevOpsAzureDevOps
	OfferingTypeDefenderForDevOpsGithub      OfferingType = original.OfferingTypeDefenderForDevOpsGithub
	OfferingTypeDefenderForServersAws        OfferingType = original.OfferingTypeDefenderForServersAws
	OfferingTypeDefenderForServersGcp        OfferingType = original.OfferingTypeDefenderForServersGcp
	OfferingTypeInformationProtectionAws     OfferingType = original.OfferingTypeInformationProtectionAws
)

type Operator = original.Operator

const (
	OperatorContains             Operator = original.OperatorContains
	OperatorEndsWith             Operator = original.OperatorEndsWith
	OperatorEquals               Operator = original.OperatorEquals
	OperatorGreaterThan          Operator = original.OperatorGreaterThan
	OperatorGreaterThanOrEqualTo Operator = original.OperatorGreaterThanOrEqualTo
	OperatorLesserThan           Operator = original.OperatorLesserThan
	OperatorLesserThanOrEqualTo  Operator = original.OperatorLesserThanOrEqualTo
	OperatorNotEquals            Operator = original.OperatorNotEquals
	OperatorStartsWith           Operator = original.OperatorStartsWith
)

type OrganizationMembershipType = original.OrganizationMembershipType

const (
	OrganizationMembershipTypeAwsOrganizationalData OrganizationMembershipType = original.OrganizationMembershipTypeAwsOrganizationalData
	OrganizationMembershipTypeMember                OrganizationMembershipType = original.OrganizationMembershipTypeMember
	OrganizationMembershipTypeOrganization          OrganizationMembershipType = original.OrganizationMembershipTypeOrganization
)

type OrganizationMembershipTypeBasicGcpOrganizationalData = original.OrganizationMembershipTypeBasicGcpOrganizationalData

const (
	OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData OrganizationMembershipTypeBasicGcpOrganizationalData = original.OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData
	OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember                OrganizationMembershipTypeBasicGcpOrganizationalData = original.OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember
	OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization          OrganizationMembershipTypeBasicGcpOrganizationalData = original.OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization
)

type PermissionProperty = original.PermissionProperty

const (
	AWSAmazonSSMAutomationRole      PermissionProperty = original.AWSAmazonSSMAutomationRole
	AWSAWSSecurityHubReadOnlyAccess PermissionProperty = original.AWSAWSSecurityHubReadOnlyAccess
	AWSSecurityAudit                PermissionProperty = original.AWSSecurityAudit
	GCPSecurityCenterAdminViewer    PermissionProperty = original.GCPSecurityCenterAdminViewer
)

type PricingTier = original.PricingTier

const (
	Free     PricingTier = original.Free
	Standard PricingTier = original.Standard
)

type PropertyType = original.PropertyType

const (
	Boolean PropertyType = original.Boolean
	Integer PropertyType = original.Integer
	Number  PropertyType = original.Number
	String  PropertyType = original.String
)

type Protocol = original.Protocol

const (
	All Protocol = original.All
	TCP Protocol = original.TCP
	UDP Protocol = original.UDP
)

type ProvisioningState = original.ProvisioningState

const (
	Failed    ProvisioningState = original.Failed
	Succeeded ProvisioningState = original.Succeeded
	Updating  ProvisioningState = original.Updating
)

type ProvisioningState1 = original.ProvisioningState1

const (
	ProvisioningState1Canceled       ProvisioningState1 = original.ProvisioningState1Canceled
	ProvisioningState1Deprovisioning ProvisioningState1 = original.ProvisioningState1Deprovisioning
	ProvisioningState1Failed         ProvisioningState1 = original.ProvisioningState1Failed
	ProvisioningState1Provisioning   ProvisioningState1 = original.ProvisioningState1Provisioning
	ProvisioningState1Succeeded      ProvisioningState1 = original.ProvisioningState1Succeeded
)

type Rank = original.Rank

const (
	RankCritical Rank = original.RankCritical
	RankHigh     Rank = original.RankHigh
	RankLow      Rank = original.RankLow
	RankMedium   Rank = original.RankMedium
	RankNone     Rank = original.RankNone
)

type RecommendationAction = original.RecommendationAction

const (
	RecommendationActionAdd         RecommendationAction = original.RecommendationActionAdd
	RecommendationActionRecommended RecommendationAction = original.RecommendationActionRecommended
	RecommendationActionRemove      RecommendationAction = original.RecommendationActionRemove
)

type RecommendationAction1 = original.RecommendationAction1

const (
	RecommendationAction1Add         RecommendationAction1 = original.RecommendationAction1Add
	RecommendationAction1Recommended RecommendationAction1 = original.RecommendationAction1Recommended
	RecommendationAction1Remove      RecommendationAction1 = original.RecommendationAction1Remove
)

type RecommendationConfigStatus = original.RecommendationConfigStatus

const (
	Disabled RecommendationConfigStatus = original.Disabled
	Enabled  RecommendationConfigStatus = original.Enabled
)

type RecommendationStatus = original.RecommendationStatus

const (
	RecommendationStatusNoStatus       RecommendationStatus = original.RecommendationStatusNoStatus
	RecommendationStatusNotAvailable   RecommendationStatus = original.RecommendationStatusNotAvailable
	RecommendationStatusNotRecommended RecommendationStatus = original.RecommendationStatusNotRecommended
	RecommendationStatusRecommended    RecommendationStatus = original.RecommendationStatusRecommended
)

type RecommendationType = original.RecommendationType

const (
	IoTACRAuthentication             RecommendationType = original.IoTACRAuthentication
	IoTAgentSendsUnutilizedMessages  RecommendationType = original.IoTAgentSendsUnutilizedMessages
	IoTBaseline                      RecommendationType = original.IoTBaseline
	IoTEdgeHubMemOptimize            RecommendationType = original.IoTEdgeHubMemOptimize
	IoTEdgeLoggingOptions            RecommendationType = original.IoTEdgeLoggingOptions
	IoTInconsistentModuleSettings    RecommendationType = original.IoTInconsistentModuleSettings
	IoTInstallAgent                  RecommendationType = original.IoTInstallAgent
	IoTIPFilterDenyAll               RecommendationType = original.IoTIPFilterDenyAll
	IoTIPFilterPermissiveRule        RecommendationType = original.IoTIPFilterPermissiveRule
	IoTOpenPorts                     RecommendationType = original.IoTOpenPorts
	IoTPermissiveFirewallPolicy      RecommendationType = original.IoTPermissiveFirewallPolicy
	IoTPermissiveInputFirewallRules  RecommendationType = original.IoTPermissiveInputFirewallRules
	IoTPermissiveOutputFirewallRules RecommendationType = original.IoTPermissiveOutputFirewallRules
	IoTPrivilegedDockerOptions       RecommendationType = original.IoTPrivilegedDockerOptions
	IoTSharedCredentials             RecommendationType = original.IoTSharedCredentials
	IoTVulnerableTLSCipherSuite      RecommendationType = original.IoTVulnerableTLSCipherSuite
)

type ReportedSeverity = original.ReportedSeverity

const (
	ReportedSeverityHigh          ReportedSeverity = original.ReportedSeverityHigh
	ReportedSeverityInformational ReportedSeverity = original.ReportedSeverityInformational
	ReportedSeverityLow           ReportedSeverity = original.ReportedSeverityLow
	ReportedSeverityMedium        ReportedSeverity = original.ReportedSeverityMedium
)

type ResourceStatus = original.ResourceStatus

const (
	ResourceStatusHealthy       ResourceStatus = original.ResourceStatusHealthy
	ResourceStatusNotApplicable ResourceStatus = original.ResourceStatusNotApplicable
	ResourceStatusNotHealthy    ResourceStatus = original.ResourceStatusNotHealthy
	ResourceStatusOffByPolicy   ResourceStatus = original.ResourceStatusOffByPolicy
)

type Roles = original.Roles

const (
	AccountAdmin Roles = original.AccountAdmin
	Contributor  Roles = original.Contributor
	Owner        Roles = original.Owner
	ServiceAdmin Roles = original.ServiceAdmin
)

type RuleSeverity = original.RuleSeverity

const (
	RuleSeverityHigh          RuleSeverity = original.RuleSeverityHigh
	RuleSeverityInformational RuleSeverity = original.RuleSeverityInformational
	RuleSeverityLow           RuleSeverity = original.RuleSeverityLow
	RuleSeverityMedium        RuleSeverity = original.RuleSeverityMedium
	RuleSeverityObsolete      RuleSeverity = original.RuleSeverityObsolete
)

type RuleState = original.RuleState

const (
	RuleStateDisabled RuleState = original.RuleStateDisabled
	RuleStateEnabled  RuleState = original.RuleStateEnabled
	RuleStateExpired  RuleState = original.RuleStateExpired
)

type RuleStatus = original.RuleStatus

const (
	Finding       RuleStatus = original.Finding
	InternalError RuleStatus = original.InternalError
	NonFinding    RuleStatus = original.NonFinding
)

type RuleType = original.RuleType

const (
	BaselineExpected RuleType = original.BaselineExpected
	Binary           RuleType = original.Binary
	NegativeList     RuleType = original.NegativeList
	PositiveList     RuleType = original.PositiveList
)

type RuleTypeBasicCustomAlertRule = original.RuleTypeBasicCustomAlertRule

const (
	RuleTypeActiveConnectionsNotInAllowedRange       RuleTypeBasicCustomAlertRule = original.RuleTypeActiveConnectionsNotInAllowedRange
	RuleTypeAllowlistCustomAlertRule                 RuleTypeBasicCustomAlertRule = original.RuleTypeAllowlistCustomAlertRule
	RuleTypeAmqpC2DMessagesNotInAllowedRange         RuleTypeBasicCustomAlertRule = original.RuleTypeAmqpC2DMessagesNotInAllowedRange
	RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = original.RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange
	RuleTypeAmqpD2CMessagesNotInAllowedRange         RuleTypeBasicCustomAlertRule = original.RuleTypeAmqpD2CMessagesNotInAllowedRange
	RuleTypeConnectionFromIPNotAllowed               RuleTypeBasicCustomAlertRule = original.RuleTypeConnectionFromIPNotAllowed
	RuleTypeConnectionToIPNotAllowed                 RuleTypeBasicCustomAlertRule = original.RuleTypeConnectionToIPNotAllowed
	RuleTypeCustomAlertRule                          RuleTypeBasicCustomAlertRule = original.RuleTypeCustomAlertRule
	RuleTypeDenylistCustomAlertRule                  RuleTypeBasicCustomAlertRule = original.RuleTypeDenylistCustomAlertRule
	RuleTypeDirectMethodInvokesNotInAllowedRange     RuleTypeBasicCustomAlertRule = original.RuleTypeDirectMethodInvokesNotInAllowedRange
	RuleTypeFailedLocalLoginsNotInAllowedRange       RuleTypeBasicCustomAlertRule = original.RuleTypeFailedLocalLoginsNotInAllowedRange
	RuleTypeFileUploadsNotInAllowedRange             RuleTypeBasicCustomAlertRule = original.RuleTypeFileUploadsNotInAllowedRange
	RuleTypeHTTPC2DMessagesNotInAllowedRange         RuleTypeBasicCustomAlertRule = original.RuleTypeHTTPC2DMessagesNotInAllowedRange
	RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = original.RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange
	RuleTypeHTTPD2CMessagesNotInAllowedRange         RuleTypeBasicCustomAlertRule = original.RuleTypeHTTPD2CMessagesNotInAllowedRange
	RuleTypeListCustomAlertRule                      RuleTypeBasicCustomAlertRule = original.RuleTypeListCustomAlertRule
	RuleTypeLocalUserNotAllowed                      RuleTypeBasicCustomAlertRule = original.RuleTypeLocalUserNotAllowed
	RuleTypeMqttC2DMessagesNotInAllowedRange         RuleTypeBasicCustomAlertRule = original.RuleTypeMqttC2DMessagesNotInAllowedRange
	RuleTypeMqttC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = original.RuleTypeMqttC2DRejectedMessagesNotInAllowedRange
	RuleTypeMqttD2CMessagesNotInAllowedRange         RuleTypeBasicCustomAlertRule = original.RuleTypeMqttD2CMessagesNotInAllowedRange
	RuleTypeProcessNotAllowed                        RuleTypeBasicCustomAlertRule = original.RuleTypeProcessNotAllowed
	RuleTypeQueuePurgesNotInAllowedRange             RuleTypeBasicCustomAlertRule = original.RuleTypeQueuePurgesNotInAllowedRange
	RuleTypeThresholdCustomAlertRule                 RuleTypeBasicCustomAlertRule = original.RuleTypeThresholdCustomAlertRule
	RuleTypeTimeWindowCustomAlertRule                RuleTypeBasicCustomAlertRule = original.RuleTypeTimeWindowCustomAlertRule
	RuleTypeTwinUpdatesNotInAllowedRange             RuleTypeBasicCustomAlertRule = original.RuleTypeTwinUpdatesNotInAllowedRange
	RuleTypeUnauthorizedOperationsNotInAllowedRange  RuleTypeBasicCustomAlertRule = original.RuleTypeUnauthorizedOperationsNotInAllowedRange
)

type ScanState = original.ScanState

const (
	ScanStateFailed      ScanState = original.ScanStateFailed
	ScanStateFailedToRun ScanState = original.ScanStateFailedToRun
	ScanStateInProgress  ScanState = original.ScanStateInProgress
	ScanStatePassed      ScanState = original.ScanStatePassed
)

type ScanTriggerType = original.ScanTriggerType

const (
	OnDemand  ScanTriggerType = original.OnDemand
	Recurring ScanTriggerType = original.Recurring
)

type ScanningMode = original.ScanningMode

const (
	Default ScanningMode = original.Default
)

type Script = original.Script

const (
	ScriptAudit   Script = original.ScriptAudit
	ScriptEnforce Script = original.ScriptEnforce
	ScriptNone    Script = original.ScriptNone
)

type SettingName2 = original.SettingName2

const (
	SettingName2MCAS                           SettingName2 = original.SettingName2MCAS
	SettingName2Sentinel                       SettingName2 = original.SettingName2Sentinel
	SettingName2WDATP                          SettingName2 = original.SettingName2WDATP
	SettingName2WDATPEXCLUDELINUXPUBLICPREVIEW SettingName2 = original.SettingName2WDATPEXCLUDELINUXPUBLICPREVIEW
	SettingName2WDATPUNIFIEDSOLUTION           SettingName2 = original.SettingName2WDATPUNIFIEDSOLUTION
)

type SettingName4 = original.SettingName4

const (
	SettingName4MCAS                           SettingName4 = original.SettingName4MCAS
	SettingName4Sentinel                       SettingName4 = original.SettingName4Sentinel
	SettingName4WDATP                          SettingName4 = original.SettingName4WDATP
	SettingName4WDATPEXCLUDELINUXPUBLICPREVIEW SettingName4 = original.SettingName4WDATPEXCLUDELINUXPUBLICPREVIEW
	SettingName4WDATPUNIFIEDSOLUTION           SettingName4 = original.SettingName4WDATPUNIFIEDSOLUTION
)

type SettingName5 = original.SettingName5

const (
	SettingName5MCAS                           SettingName5 = original.SettingName5MCAS
	SettingName5Sentinel                       SettingName5 = original.SettingName5Sentinel
	SettingName5WDATP                          SettingName5 = original.SettingName5WDATP
	SettingName5WDATPEXCLUDELINUXPUBLICPREVIEW SettingName5 = original.SettingName5WDATPEXCLUDELINUXPUBLICPREVIEW
	SettingName5WDATPUNIFIEDSOLUTION           SettingName5 = original.SettingName5WDATPUNIFIEDSOLUTION
)

type Severity = original.Severity

const (
	SeverityHigh   Severity = original.SeverityHigh
	SeverityLow    Severity = original.SeverityLow
	SeverityMedium Severity = original.SeverityMedium
)

type SeverityEnum = original.SeverityEnum

const (
	SeverityEnumHigh   SeverityEnum = original.SeverityEnumHigh
	SeverityEnumLow    SeverityEnum = original.SeverityEnumLow
	SeverityEnumMedium SeverityEnum = original.SeverityEnumMedium
)

type SolutionStatus = original.SolutionStatus

const (
	SolutionStatusDisabled SolutionStatus = original.SolutionStatusDisabled
	SolutionStatusEnabled  SolutionStatus = original.SolutionStatusEnabled
)

type Source = original.Source

const (
	SourceAzure           Source = original.SourceAzure
	SourceOnPremise       Source = original.SourceOnPremise
	SourceOnPremiseSQL    Source = original.SourceOnPremiseSQL
	SourceResourceDetails Source = original.SourceResourceDetails
)

type SourceSystem = original.SourceSystem

const (
	SourceSystemAzureAppLocker    SourceSystem = original.SourceSystemAzureAppLocker
	SourceSystemAzureAuditD       SourceSystem = original.SourceSystemAzureAuditD
	SourceSystemNonAzureAppLocker SourceSystem = original.SourceSystemNonAzureAppLocker
	SourceSystemNonAzureAuditD    SourceSystem = original.SourceSystemNonAzureAuditD
	SourceSystemNone              SourceSystem = original.SourceSystemNone
)

type State = original.State

const (
	StateFailed      State = original.StateFailed
	StatePassed      State = original.StatePassed
	StateSkipped     State = original.StateSkipped
	StateUnsupported State = original.StateUnsupported
)

type StateForAlertNotifications = original.StateForAlertNotifications

const (
	StateForAlertNotificationsOff StateForAlertNotifications = original.StateForAlertNotificationsOff
	StateForAlertNotificationsOn  StateForAlertNotifications = original.StateForAlertNotificationsOn
)

type StateForNotificationsByRole = original.StateForNotificationsByRole

const (
	StateForNotificationsByRoleOff StateForNotificationsByRole = original.StateForNotificationsByRoleOff
	StateForNotificationsByRoleOn  StateForNotificationsByRole = original.StateForNotificationsByRoleOn
)

type Status = original.Status

const (
	Initiated Status = original.Initiated
	Revoked   Status = original.Revoked
)

type StatusReason = original.StatusReason

const (
	StatusReasonExpired               StatusReason = original.StatusReasonExpired
	StatusReasonNewerRequestInitiated StatusReason = original.StatusReasonNewerRequestInitiated
	StatusReasonUserRequested         StatusReason = original.StatusReasonUserRequested
)

type SubAssessmentStatusCode = original.SubAssessmentStatusCode

const (
	SubAssessmentStatusCodeHealthy       SubAssessmentStatusCode = original.SubAssessmentStatusCodeHealthy
	SubAssessmentStatusCodeNotApplicable SubAssessmentStatusCode = original.SubAssessmentStatusCodeNotApplicable
	SubAssessmentStatusCodeUnhealthy     SubAssessmentStatusCode = original.SubAssessmentStatusCodeUnhealthy
)

type SubPlan = original.SubPlan

const (
	P1 SubPlan = original.P1
	P2 SubPlan = original.P2
)

type SupportedCloudEnum = original.SupportedCloudEnum

const (
	SupportedCloudEnumAWS SupportedCloudEnum = original.SupportedCloudEnumAWS
	SupportedCloudEnumGCP SupportedCloudEnum = original.SupportedCloudEnumGCP
)

type Tactics = original.Tactics

const (
	Collection          Tactics = original.Collection
	CommandandControl   Tactics = original.CommandandControl
	CredentialAccess    Tactics = original.CredentialAccess
	DefenseEvasion      Tactics = original.DefenseEvasion
	Discovery           Tactics = original.Discovery
	Execution           Tactics = original.Execution
	Exfiltration        Tactics = original.Exfiltration
	Impact              Tactics = original.Impact
	InitialAccess       Tactics = original.InitialAccess
	LateralMovement     Tactics = original.LateralMovement
	Persistence         Tactics = original.Persistence
	PrivilegeEscalation Tactics = original.PrivilegeEscalation
	Reconnaissance      Tactics = original.Reconnaissance
	ResourceDevelopment Tactics = original.ResourceDevelopment
)

type TaskUpdateActionType = original.TaskUpdateActionType

const (
	Activate TaskUpdateActionType = original.Activate
	Close    TaskUpdateActionType = original.Close
	Dismiss  TaskUpdateActionType = original.Dismiss
	Resolve  TaskUpdateActionType = original.Resolve
	Start    TaskUpdateActionType = original.Start
)

type Techniques = original.Techniques

const (
	AbuseElevationControlMechanism          Techniques = original.AbuseElevationControlMechanism
	AccessTokenManipulation                 Techniques = original.AccessTokenManipulation
	AccountDiscovery                        Techniques = original.AccountDiscovery
	AccountManipulation                     Techniques = original.AccountManipulation
	ActiveScanning                          Techniques = original.ActiveScanning
	ApplicationLayerProtocol                Techniques = original.ApplicationLayerProtocol
	AudioCapture                            Techniques = original.AudioCapture
	BootorLogonAutostartExecution           Techniques = original.BootorLogonAutostartExecution
	BootorLogonInitializationScripts        Techniques = original.BootorLogonInitializationScripts
	BruteForce                              Techniques = original.BruteForce
	CloudInfrastructureDiscovery            Techniques = original.CloudInfrastructureDiscovery
	CloudServiceDashboard                   Techniques = original.CloudServiceDashboard
	CloudServiceDiscovery                   Techniques = original.CloudServiceDiscovery
	CommandandScriptingInterpreter          Techniques = original.CommandandScriptingInterpreter
	CompromiseClientSoftwareBinary          Techniques = original.CompromiseClientSoftwareBinary
	CompromiseInfrastructure                Techniques = original.CompromiseInfrastructure
	ContainerandResourceDiscovery           Techniques = original.ContainerandResourceDiscovery
	CreateAccount                           Techniques = original.CreateAccount
	CreateorModifySystemProcess             Techniques = original.CreateorModifySystemProcess
	CredentialsfromPasswordStores           Techniques = original.CredentialsfromPasswordStores
	DataDestruction                         Techniques = original.DataDestruction
	DataEncryptedforImpact                  Techniques = original.DataEncryptedforImpact
	DatafromCloudStorageObject              Techniques = original.DatafromCloudStorageObject
	DatafromConfigurationRepository         Techniques = original.DatafromConfigurationRepository
	DatafromInformationRepositories         Techniques = original.DatafromInformationRepositories
	DatafromLocalSystem                     Techniques = original.DatafromLocalSystem
	DataManipulation                        Techniques = original.DataManipulation
	DataStaged                              Techniques = original.DataStaged
	Defacement                              Techniques = original.Defacement
	DeobfuscateDecodeFilesorInformation     Techniques = original.DeobfuscateDecodeFilesorInformation
	DiskWipe                                Techniques = original.DiskWipe
	DomainTrustDiscovery                    Techniques = original.DomainTrustDiscovery
	DriveByCompromise                       Techniques = original.DriveByCompromise
	DynamicResolution                       Techniques = original.DynamicResolution
	EndpointDenialofService                 Techniques = original.EndpointDenialofService
	EventTriggeredExecution                 Techniques = original.EventTriggeredExecution
	ExfiltrationOverAlternativeProtocol     Techniques = original.ExfiltrationOverAlternativeProtocol
	ExploitationforClientExecution          Techniques = original.ExploitationforClientExecution
	ExploitationforCredentialAccess         Techniques = original.ExploitationforCredentialAccess
	ExploitationforDefenseEvasion           Techniques = original.ExploitationforDefenseEvasion
	ExploitationforPrivilegeEscalation      Techniques = original.ExploitationforPrivilegeEscalation
	ExploitationofRemoteServices            Techniques = original.ExploitationofRemoteServices
	ExploitPublicFacingApplication          Techniques = original.ExploitPublicFacingApplication
	ExternalRemoteServices                  Techniques = original.ExternalRemoteServices
	FallbackChannels                        Techniques = original.FallbackChannels
	FileandDirectoryDiscovery               Techniques = original.FileandDirectoryDiscovery
	FileandDirectoryPermissionsModification Techniques = original.FileandDirectoryPermissionsModification
	GatherVictimNetworkInformation          Techniques = original.GatherVictimNetworkInformation
	HideArtifacts                           Techniques = original.HideArtifacts
	HijackExecutionFlow                     Techniques = original.HijackExecutionFlow
	ImpairDefenses                          Techniques = original.ImpairDefenses
	ImplantContainerImage                   Techniques = original.ImplantContainerImage
	IndicatorRemovalonHost                  Techniques = original.IndicatorRemovalonHost
	IndirectCommandExecution                Techniques = original.IndirectCommandExecution
	IngressToolTransfer                     Techniques = original.IngressToolTransfer
	InputCapture                            Techniques = original.InputCapture
	InterProcessCommunication               Techniques = original.InterProcessCommunication
	LateralToolTransfer                     Techniques = original.LateralToolTransfer
	ManInTheMiddle                          Techniques = original.ManInTheMiddle
	Masquerading                            Techniques = original.Masquerading
	ModifyAuthenticationProcess             Techniques = original.ModifyAuthenticationProcess
	ModifyRegistry                          Techniques = original.ModifyRegistry
	NetworkDenialofService                  Techniques = original.NetworkDenialofService
	NetworkServiceScanning                  Techniques = original.NetworkServiceScanning
	NetworkSniffing                         Techniques = original.NetworkSniffing
	NonApplicationLayerProtocol             Techniques = original.NonApplicationLayerProtocol
	NonStandardPort                         Techniques = original.NonStandardPort
	ObfuscatedFilesorInformation            Techniques = original.ObfuscatedFilesorInformation
	ObtainCapabilities                      Techniques = original.ObtainCapabilities
	OfficeApplicationStartup                Techniques = original.OfficeApplicationStartup
	OSCredentialDumping                     Techniques = original.OSCredentialDumping
	PermissionGroupsDiscovery               Techniques = original.PermissionGroupsDiscovery
	Phishing                                Techniques = original.Phishing
	PreOSBoot                               Techniques = original.PreOSBoot
	ProcessDiscovery                        Techniques = original.ProcessDiscovery
	ProcessInjection                        Techniques = original.ProcessInjection
	ProtocolTunneling                       Techniques = original.ProtocolTunneling
	Proxy                                   Techniques = original.Proxy
	QueryRegistry                           Techniques = original.QueryRegistry
	RemoteAccessSoftware                    Techniques = original.RemoteAccessSoftware
	RemoteServices                          Techniques = original.RemoteServices
	RemoteServiceSessionHijacking           Techniques = original.RemoteServiceSessionHijacking
	RemoteSystemDiscovery                   Techniques = original.RemoteSystemDiscovery
	ResourceHijacking                       Techniques = original.ResourceHijacking
	ScheduledTaskJob                        Techniques = original.ScheduledTaskJob
	ScreenCapture                           Techniques = original.ScreenCapture
	SearchVictimOwnedWebsites               Techniques = original.SearchVictimOwnedWebsites
	ServerSoftwareComponent                 Techniques = original.ServerSoftwareComponent
	ServiceStop                             Techniques = original.ServiceStop
	SignedBinaryProxyExecution              Techniques = original.SignedBinaryProxyExecution
	SoftwareDeploymentTools                 Techniques = original.SoftwareDeploymentTools
	SQLStoredProcedures                     Techniques = original.SQLStoredProcedures
	StealorForgeKerberosTickets             Techniques = original.StealorForgeKerberosTickets
	SubvertTrustControls                    Techniques = original.SubvertTrustControls
	SupplyChainCompromise                   Techniques = original.SupplyChainCompromise
	SystemInformationDiscovery              Techniques = original.SystemInformationDiscovery
	TaintSharedContent                      Techniques = original.TaintSharedContent
	TrafficSignaling                        Techniques = original.TrafficSignaling
	TransferDatatoCloudAccount              Techniques = original.TransferDatatoCloudAccount
	TrustedRelationship                     Techniques = original.TrustedRelationship
	UnsecuredCredentials                    Techniques = original.UnsecuredCredentials
	UserExecution                           Techniques = original.UserExecution
	ValidAccounts                           Techniques = original.ValidAccounts
	WindowsManagementInstrumentation        Techniques = original.WindowsManagementInstrumentation
)

type Threats = original.Threats

const (
	AccountBreach        Threats = original.AccountBreach
	DataExfiltration     Threats = original.DataExfiltration
	DataSpillage         Threats = original.DataSpillage
	DenialOfService      Threats = original.DenialOfService
	ElevationOfPrivilege Threats = original.ElevationOfPrivilege
	MaliciousInsider     Threats = original.MaliciousInsider
	MissingCoverage      Threats = original.MissingCoverage
	ThreatResistance     Threats = original.ThreatResistance
)

type TransportProtocol = original.TransportProtocol

const (
	TransportProtocolTCP TransportProtocol = original.TransportProtocolTCP
	TransportProtocolUDP TransportProtocol = original.TransportProtocolUDP
)

type Type = original.Type

const (
	Qualys Type = original.Qualys
	TVM    Type = original.TVM
)

type Type1 = original.Type1

const (
	BinarySignature          Type1 = original.BinarySignature
	File                     Type1 = original.File
	FileHash                 Type1 = original.FileHash
	ProductSignature         Type1 = original.ProductSignature
	PublisherSignature       Type1 = original.PublisherSignature
	VersionAndAboveSignature Type1 = original.VersionAndAboveSignature
)

type TypeBasicResourceIdentifier = original.TypeBasicResourceIdentifier

const (
	TypeAzureResource      TypeBasicResourceIdentifier = original.TypeAzureResource
	TypeLogAnalytics       TypeBasicResourceIdentifier = original.TypeLogAnalytics
	TypeResourceIdentifier TypeBasicResourceIdentifier = original.TypeResourceIdentifier
)

type UnmaskedIPLoggingStatus = original.UnmaskedIPLoggingStatus

const (
	UnmaskedIPLoggingStatusDisabled UnmaskedIPLoggingStatus = original.UnmaskedIPLoggingStatusDisabled
	UnmaskedIPLoggingStatusEnabled  UnmaskedIPLoggingStatus = original.UnmaskedIPLoggingStatusEnabled
)

type UserImpact = original.UserImpact

const (
	UserImpactHigh     UserImpact = original.UserImpactHigh
	UserImpactLow      UserImpact = original.UserImpactLow
	UserImpactModerate UserImpact = original.UserImpactModerate
)

type ValueType = original.ValueType

const (
	ValueTypeIPCidr ValueType = original.ValueTypeIPCidr
	ValueTypeString ValueType = original.ValueTypeString
)

type AadConnectivityState1 = original.AadConnectivityState1
type AadExternalSecuritySolution = original.AadExternalSecuritySolution
type AadSolutionProperties = original.AadSolutionProperties
type ActiveConnectionsNotInAllowedRange = original.ActiveConnectionsNotInAllowedRange
type AdaptiveApplicationControlGroup = original.AdaptiveApplicationControlGroup
type AdaptiveApplicationControlGroupData = original.AdaptiveApplicationControlGroupData
type AdaptiveApplicationControlGroups = original.AdaptiveApplicationControlGroups
type AdaptiveApplicationControlIssueSummary = original.AdaptiveApplicationControlIssueSummary
type AdaptiveApplicationControlsClient = original.AdaptiveApplicationControlsClient
type AdaptiveNetworkHardening = original.AdaptiveNetworkHardening
type AdaptiveNetworkHardeningEnforceRequest = original.AdaptiveNetworkHardeningEnforceRequest
type AdaptiveNetworkHardeningProperties = original.AdaptiveNetworkHardeningProperties
type AdaptiveNetworkHardeningsClient = original.AdaptiveNetworkHardeningsClient
type AdaptiveNetworkHardeningsEnforceFuture = original.AdaptiveNetworkHardeningsEnforceFuture
type AdaptiveNetworkHardeningsList = original.AdaptiveNetworkHardeningsList
type AdaptiveNetworkHardeningsListIterator = original.AdaptiveNetworkHardeningsListIterator
type AdaptiveNetworkHardeningsListPage = original.AdaptiveNetworkHardeningsListPage
type AdditionalData = original.AdditionalData
type AdditionalWorkspacesProperties = original.AdditionalWorkspacesProperties
type AdvancedThreatProtectionClient = original.AdvancedThreatProtectionClient
type AdvancedThreatProtectionProperties = original.AdvancedThreatProtectionProperties
type AdvancedThreatProtectionSetting = original.AdvancedThreatProtectionSetting
type Alert = original.Alert
type AlertEntity = original.AlertEntity
type AlertList = original.AlertList
type AlertListIterator = original.AlertListIterator
type AlertListPage = original.AlertListPage
type AlertProperties = original.AlertProperties
type AlertPropertiesSupportingEvidence = original.AlertPropertiesSupportingEvidence
type AlertSimulatorBundlesRequestProperties = original.AlertSimulatorBundlesRequestProperties
type AlertSimulatorRequestBody = original.AlertSimulatorRequestBody
type AlertSimulatorRequestProperties = original.AlertSimulatorRequestProperties
type AlertSyncSettingProperties = original.AlertSyncSettingProperties
type AlertSyncSettings = original.AlertSyncSettings
type AlertsClient = original.AlertsClient
type AlertsSimulateFuture = original.AlertsSimulateFuture
type AlertsSuppressionRule = original.AlertsSuppressionRule
type AlertsSuppressionRuleProperties = original.AlertsSuppressionRuleProperties
type AlertsSuppressionRulesClient = original.AlertsSuppressionRulesClient
type AlertsSuppressionRulesList = original.AlertsSuppressionRulesList
type AlertsSuppressionRulesListIterator = original.AlertsSuppressionRulesListIterator
type AlertsSuppressionRulesListPage = original.AlertsSuppressionRulesListPage
type AllowedConnectionsClient = original.AllowedConnectionsClient
type AllowedConnectionsList = original.AllowedConnectionsList
type AllowedConnectionsListIterator = original.AllowedConnectionsListIterator
type AllowedConnectionsListPage = original.AllowedConnectionsListPage
type AllowedConnectionsResource = original.AllowedConnectionsResource
type AllowedConnectionsResourceProperties = original.AllowedConnectionsResourceProperties
type AllowlistCustomAlertRule = original.AllowlistCustomAlertRule
type AmqpC2DMessagesNotInAllowedRange = original.AmqpC2DMessagesNotInAllowedRange
type AmqpC2DRejectedMessagesNotInAllowedRange = original.AmqpC2DRejectedMessagesNotInAllowedRange
type AmqpD2CMessagesNotInAllowedRange = original.AmqpD2CMessagesNotInAllowedRange
type Application = original.Application
type ApplicationClient = original.ApplicationClient
type ApplicationCondition = original.ApplicationCondition
type ApplicationProperties = original.ApplicationProperties
type ApplicationsClient = original.ApplicationsClient
type ApplicationsList = original.ApplicationsList
type ApplicationsListIterator = original.ApplicationsListIterator
type ApplicationsListPage = original.ApplicationsListPage
type AscLocation = original.AscLocation
type AscLocationList = original.AscLocationList
type AscLocationListIterator = original.AscLocationListIterator
type AscLocationListPage = original.AscLocationListPage
type Assessment = original.Assessment
type AssessmentLinks = original.AssessmentLinks
type AssessmentList = original.AssessmentList
type AssessmentListIterator = original.AssessmentListIterator
type AssessmentListPage = original.AssessmentListPage
type AssessmentMetadata = original.AssessmentMetadata
type AssessmentMetadataPartnerData = original.AssessmentMetadataPartnerData
type AssessmentMetadataProperties = original.AssessmentMetadataProperties
type AssessmentMetadataPropertiesResponse = original.AssessmentMetadataPropertiesResponse
type AssessmentMetadataPropertiesResponsePublishDates = original.AssessmentMetadataPropertiesResponsePublishDates
type AssessmentMetadataResponse = original.AssessmentMetadataResponse
type AssessmentMetadataResponseList = original.AssessmentMetadataResponseList
type AssessmentMetadataResponseListIterator = original.AssessmentMetadataResponseListIterator
type AssessmentMetadataResponseListPage = original.AssessmentMetadataResponseListPage
type AssessmentPartnerData = original.AssessmentPartnerData
type AssessmentProperties = original.AssessmentProperties
type AssessmentPropertiesBase = original.AssessmentPropertiesBase
type AssessmentPropertiesResponse = original.AssessmentPropertiesResponse
type AssessmentResponse = original.AssessmentResponse
type AssessmentStatus = original.AssessmentStatus
type AssessmentStatusResponse = original.AssessmentStatusResponse
type AssessmentsClient = original.AssessmentsClient
type AssessmentsMetadataClient = original.AssessmentsMetadataClient
type AtaExternalSecuritySolution = original.AtaExternalSecuritySolution
type AtaSolutionProperties = original.AtaSolutionProperties
type AuthenticationDetailsProperties = original.AuthenticationDetailsProperties
type AutoProvisioningSetting = original.AutoProvisioningSetting
type AutoProvisioningSettingList = original.AutoProvisioningSettingList
type AutoProvisioningSettingListIterator = original.AutoProvisioningSettingListIterator
type AutoProvisioningSettingListPage = original.AutoProvisioningSettingListPage
type AutoProvisioningSettingProperties = original.AutoProvisioningSettingProperties
type AutoProvisioningSettingsClient = original.AutoProvisioningSettingsClient
type Automation = original.Automation
type AutomationAction = original.AutomationAction
type AutomationActionEventHub = original.AutomationActionEventHub
type AutomationActionLogicApp = original.AutomationActionLogicApp
type AutomationActionWorkspace = original.AutomationActionWorkspace
type AutomationList = original.AutomationList
type AutomationListIterator = original.AutomationListIterator
type AutomationListPage = original.AutomationListPage
type AutomationProperties = original.AutomationProperties
type AutomationRuleSet = original.AutomationRuleSet
type AutomationScope = original.AutomationScope
type AutomationSource = original.AutomationSource
type AutomationTriggeringRule = original.AutomationTriggeringRule
type AutomationValidationStatus = original.AutomationValidationStatus
type AutomationsClient = original.AutomationsClient
type AwAssumeRoleAuthenticationDetailsProperties = original.AwAssumeRoleAuthenticationDetailsProperties
type AwsCredsAuthenticationDetailsProperties = original.AwsCredsAuthenticationDetailsProperties
type AwsEnvironmentData = original.AwsEnvironmentData
type AwsOrganizationalData = original.AwsOrganizationalData
type AwsOrganizationalDataMaster = original.AwsOrganizationalDataMaster
type AwsOrganizationalDataMember = original.AwsOrganizationalDataMember
type AzureDevOpsScopeEnvironmentData = original.AzureDevOpsScopeEnvironmentData
type AzureResourceDetails = original.AzureResourceDetails
type AzureResourceIdentifier = original.AzureResourceIdentifier
type AzureResourceLink = original.AzureResourceLink
type AzureTrackedResourceLocation = original.AzureTrackedResourceLocation
type BaseClient = original.BaseClient
type Baseline = original.Baseline
type BaselineAdjustedResult = original.BaselineAdjustedResult
type BasicAdditionalData = original.BasicAdditionalData
type BasicAlertSimulatorRequestProperties = original.BasicAlertSimulatorRequestProperties
type BasicAllowlistCustomAlertRule = original.BasicAllowlistCustomAlertRule
type BasicAuthenticationDetailsProperties = original.BasicAuthenticationDetailsProperties
type BasicAutomationAction = original.BasicAutomationAction
type BasicAwsOrganizationalData = original.BasicAwsOrganizationalData
type BasicCloudOffering = original.BasicCloudOffering
type BasicCustomAlertRule = original.BasicCustomAlertRule
type BasicEnvironmentData = original.BasicEnvironmentData
type BasicExternalSecuritySolution = original.BasicExternalSecuritySolution
type BasicGcpOrganizationalData = original.BasicGcpOrganizationalData
type BasicListCustomAlertRule = original.BasicListCustomAlertRule
type BasicOnPremiseResourceDetails = original.BasicOnPremiseResourceDetails
type BasicResourceDetails = original.BasicResourceDetails
type BasicResourceIdentifier = original.BasicResourceIdentifier
type BasicSetting = original.BasicSetting
type BasicThresholdCustomAlertRule = original.BasicThresholdCustomAlertRule
type BasicTimeWindowCustomAlertRule = original.BasicTimeWindowCustomAlertRule
type BenchmarkReference = original.BenchmarkReference
type CVE = original.CVE
type CVSS = original.CVSS
type CefExternalSecuritySolution = original.CefExternalSecuritySolution
type CefSolutionProperties = original.CefSolutionProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CloudOffering = original.CloudOffering
type Compliance = original.Compliance
type ComplianceList = original.ComplianceList
type ComplianceListIterator = original.ComplianceListIterator
type ComplianceListPage = original.ComplianceListPage
type ComplianceProperties = original.ComplianceProperties
type ComplianceResult = original.ComplianceResult
type ComplianceResultList = original.ComplianceResultList
type ComplianceResultListIterator = original.ComplianceResultListIterator
type ComplianceResultListPage = original.ComplianceResultListPage
type ComplianceResultProperties = original.ComplianceResultProperties
type ComplianceResultsClient = original.ComplianceResultsClient
type ComplianceSegment = original.ComplianceSegment
type CompliancesClient = original.CompliancesClient
type Condition = original.Condition
type ConnectableResource = original.ConnectableResource
type ConnectedResource = original.ConnectedResource
type ConnectedWorkspace = original.ConnectedWorkspace
type ConnectionFromIPNotAllowed = original.ConnectionFromIPNotAllowed
type ConnectionStrings = original.ConnectionStrings
type ConnectionToIPNotAllowed = original.ConnectionToIPNotAllowed
type Connector = original.Connector
type ConnectorApplicationClient = original.ConnectorApplicationClient
type ConnectorApplicationsClient = original.ConnectorApplicationsClient
type ConnectorGovernanceRuleClient = original.ConnectorGovernanceRuleClient
type ConnectorGovernanceRulesClient = original.ConnectorGovernanceRulesClient
type ConnectorGovernanceRulesExecuteStatusClient = original.ConnectorGovernanceRulesExecuteStatusClient
type ConnectorGovernanceRulesExecuteStatusGetFuture = original.ConnectorGovernanceRulesExecuteStatusGetFuture
type ConnectorProperties = original.ConnectorProperties
type ConnectorSetting = original.ConnectorSetting
type ConnectorSettingList = original.ConnectorSettingList
type ConnectorSettingListIterator = original.ConnectorSettingListIterator
type ConnectorSettingListPage = original.ConnectorSettingListPage
type ConnectorSettingProperties = original.ConnectorSettingProperties
type ConnectorsClient = original.ConnectorsClient
type ConnectorsGroupClient = original.ConnectorsGroupClient
type ConnectorsList = original.ConnectorsList
type ConnectorsListIterator = original.ConnectorsListIterator
type ConnectorsListPage = original.ConnectorsListPage
type Contact = original.Contact
type ContactList = original.ContactList
type ContactListIterator = original.ContactListIterator
type ContactListPage = original.ContactListPage
type ContactProperties = original.ContactProperties
type ContactPropertiesAlertNotifications = original.ContactPropertiesAlertNotifications
type ContactPropertiesNotificationsByRole = original.ContactPropertiesNotificationsByRole
type ContactsClient = original.ContactsClient
type ContainerRegistryVulnerabilityProperties = original.ContainerRegistryVulnerabilityProperties
type CspmMonitorAwsOffering = original.CspmMonitorAwsOffering
type CspmMonitorAwsOfferingNativeCloudConnection = original.CspmMonitorAwsOfferingNativeCloudConnection
type CspmMonitorAzureDevOpsOffering = original.CspmMonitorAzureDevOpsOffering
type CspmMonitorGcpOffering = original.CspmMonitorGcpOffering
type CspmMonitorGcpOfferingNativeCloudConnection = original.CspmMonitorGcpOfferingNativeCloudConnection
type CspmMonitorGithubOffering = original.CspmMonitorGithubOffering
type CustomAlertRule = original.CustomAlertRule
type CustomAssessmentAutomation = original.CustomAssessmentAutomation
type CustomAssessmentAutomationProperties = original.CustomAssessmentAutomationProperties
type CustomAssessmentAutomationRequest = original.CustomAssessmentAutomationRequest
type CustomAssessmentAutomationRequestProperties = original.CustomAssessmentAutomationRequestProperties
type CustomAssessmentAutomationsClient = original.CustomAssessmentAutomationsClient
type CustomAssessmentAutomationsListResult = original.CustomAssessmentAutomationsListResult
type CustomAssessmentAutomationsListResultIterator = original.CustomAssessmentAutomationsListResultIterator
type CustomAssessmentAutomationsListResultPage = original.CustomAssessmentAutomationsListResultPage
type CustomEntityStoreAssignment = original.CustomEntityStoreAssignment
type CustomEntityStoreAssignmentProperties = original.CustomEntityStoreAssignmentProperties
type CustomEntityStoreAssignmentRequest = original.CustomEntityStoreAssignmentRequest
type CustomEntityStoreAssignmentRequestProperties = original.CustomEntityStoreAssignmentRequestProperties
type CustomEntityStoreAssignmentsClient = original.CustomEntityStoreAssignmentsClient
type CustomEntityStoreAssignmentsListResult = original.CustomEntityStoreAssignmentsListResult
type CustomEntityStoreAssignmentsListResultIterator = original.CustomEntityStoreAssignmentsListResultIterator
type CustomEntityStoreAssignmentsListResultPage = original.CustomEntityStoreAssignmentsListResultPage
type DataExportSettingProperties = original.DataExportSettingProperties
type DataExportSettings = original.DataExportSettings
type DefenderCspmAwsOffering = original.DefenderCspmAwsOffering
type DefenderCspmAwsOfferingVMScanners = original.DefenderCspmAwsOfferingVMScanners
type DefenderCspmAwsOfferingVMScannersConfiguration = original.DefenderCspmAwsOfferingVMScannersConfiguration
type DefenderCspmGcpOffering = original.DefenderCspmGcpOffering
type DefenderFoDatabasesAwsOffering = original.DefenderFoDatabasesAwsOffering
type DefenderFoDatabasesAwsOfferingArcAutoProvisioning = original.DefenderFoDatabasesAwsOfferingArcAutoProvisioning
type DefenderFoDatabasesAwsOfferingRds = original.DefenderFoDatabasesAwsOfferingRds
type DefenderForContainersAwsOffering = original.DefenderForContainersAwsOffering
type DefenderForContainersAwsOfferingCloudWatchToKinesis = original.DefenderForContainersAwsOfferingCloudWatchToKinesis
type DefenderForContainersAwsOfferingContainerVulnerabilityAssessment = original.DefenderForContainersAwsOfferingContainerVulnerabilityAssessment
type DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask = original.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask
type DefenderForContainersAwsOfferingKinesisToS3 = original.DefenderForContainersAwsOfferingKinesisToS3
type DefenderForContainersAwsOfferingKubernetesScubaReader = original.DefenderForContainersAwsOfferingKubernetesScubaReader
type DefenderForContainersAwsOfferingKubernetesService = original.DefenderForContainersAwsOfferingKubernetesService
type DefenderForContainersGcpOffering = original.DefenderForContainersGcpOffering
type DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection = original.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection
type DefenderForContainersGcpOfferingNativeCloudConnection = original.DefenderForContainersGcpOfferingNativeCloudConnection
type DefenderForDatabasesGcpOffering = original.DefenderForDatabasesGcpOffering
type DefenderForDatabasesGcpOfferingArcAutoProvisioning = original.DefenderForDatabasesGcpOfferingArcAutoProvisioning
type DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning = original.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning
type DefenderForDevOpsAzureDevOpsOffering = original.DefenderForDevOpsAzureDevOpsOffering
type DefenderForDevOpsGithubOffering = original.DefenderForDevOpsGithubOffering
type DefenderForServersAwsOffering = original.DefenderForServersAwsOffering
type DefenderForServersAwsOfferingArcAutoProvisioning = original.DefenderForServersAwsOfferingArcAutoProvisioning
type DefenderForServersAwsOfferingDefenderForServers = original.DefenderForServersAwsOfferingDefenderForServers
type DefenderForServersAwsOfferingMdeAutoProvisioning = original.DefenderForServersAwsOfferingMdeAutoProvisioning
type DefenderForServersAwsOfferingSubPlan = original.DefenderForServersAwsOfferingSubPlan
type DefenderForServersAwsOfferingVMScanners = original.DefenderForServersAwsOfferingVMScanners
type DefenderForServersAwsOfferingVMScannersConfiguration = original.DefenderForServersAwsOfferingVMScannersConfiguration
type DefenderForServersAwsOfferingVaAutoProvisioning = original.DefenderForServersAwsOfferingVaAutoProvisioning
type DefenderForServersAwsOfferingVaAutoProvisioningConfiguration = original.DefenderForServersAwsOfferingVaAutoProvisioningConfiguration
type DefenderForServersGcpOffering = original.DefenderForServersGcpOffering
type DefenderForServersGcpOfferingArcAutoProvisioning = original.DefenderForServersGcpOfferingArcAutoProvisioning
type DefenderForServersGcpOfferingDefenderForServers = original.DefenderForServersGcpOfferingDefenderForServers
type DefenderForServersGcpOfferingMdeAutoProvisioning = original.DefenderForServersGcpOfferingMdeAutoProvisioning
type DefenderForServersGcpOfferingSubPlan = original.DefenderForServersGcpOfferingSubPlan
type DefenderForServersGcpOfferingVaAutoProvisioning = original.DefenderForServersGcpOfferingVaAutoProvisioning
type DefenderForServersGcpOfferingVaAutoProvisioningConfiguration = original.DefenderForServersGcpOfferingVaAutoProvisioningConfiguration
type DenylistCustomAlertRule = original.DenylistCustomAlertRule
type DeviceSecurityGroup = original.DeviceSecurityGroup
type DeviceSecurityGroupList = original.DeviceSecurityGroupList
type DeviceSecurityGroupListIterator = original.DeviceSecurityGroupListIterator
type DeviceSecurityGroupListPage = original.DeviceSecurityGroupListPage
type DeviceSecurityGroupProperties = original.DeviceSecurityGroupProperties
type DeviceSecurityGroupsClient = original.DeviceSecurityGroupsClient
type DirectMethodInvokesNotInAllowedRange = original.DirectMethodInvokesNotInAllowedRange
type DiscoveredSecuritySolution = original.DiscoveredSecuritySolution
type DiscoveredSecuritySolutionList = original.DiscoveredSecuritySolutionList
type DiscoveredSecuritySolutionListIterator = original.DiscoveredSecuritySolutionListIterator
type DiscoveredSecuritySolutionListPage = original.DiscoveredSecuritySolutionListPage
type DiscoveredSecuritySolutionProperties = original.DiscoveredSecuritySolutionProperties
type DiscoveredSecuritySolutionsClient = original.DiscoveredSecuritySolutionsClient
type ETag = original.ETag
type EffectiveNetworkSecurityGroups = original.EffectiveNetworkSecurityGroups
type EnvironmentData = original.EnvironmentData
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ExecuteGovernanceRuleParams = original.ExecuteGovernanceRuleParams
type ExecuteRuleStatus = original.ExecuteRuleStatus
type ExternalSecuritySolution = original.ExternalSecuritySolution
type ExternalSecuritySolutionKind1 = original.ExternalSecuritySolutionKind1
type ExternalSecuritySolutionList = original.ExternalSecuritySolutionList
type ExternalSecuritySolutionListIterator = original.ExternalSecuritySolutionListIterator
type ExternalSecuritySolutionListPage = original.ExternalSecuritySolutionListPage
type ExternalSecuritySolutionModel = original.ExternalSecuritySolutionModel
type ExternalSecuritySolutionProperties = original.ExternalSecuritySolutionProperties
type ExternalSecuritySolutionsClient = original.ExternalSecuritySolutionsClient
type FailedLocalLoginsNotInAllowedRange = original.FailedLocalLoginsNotInAllowedRange
type FileUploadsNotInAllowedRange = original.FileUploadsNotInAllowedRange
type GcpCredentialsDetailsProperties = original.GcpCredentialsDetailsProperties
type GcpOrganizationalData = original.GcpOrganizationalData
type GcpOrganizationalDataMember = original.GcpOrganizationalDataMember
type GcpOrganizationalDataOrganization = original.GcpOrganizationalDataOrganization
type GcpProjectDetails = original.GcpProjectDetails
type GcpProjectEnvironmentData = original.GcpProjectEnvironmentData
type GithubScopeEnvironmentData = original.GithubScopeEnvironmentData
type GovernanceAssignment = original.GovernanceAssignment
type GovernanceAssignmentAdditionalData = original.GovernanceAssignmentAdditionalData
type GovernanceAssignmentProperties = original.GovernanceAssignmentProperties
type GovernanceAssignmentsClient = original.GovernanceAssignmentsClient
type GovernanceAssignmentsList = original.GovernanceAssignmentsList
type GovernanceAssignmentsListIterator = original.GovernanceAssignmentsListIterator
type GovernanceAssignmentsListPage = original.GovernanceAssignmentsListPage
type GovernanceEmailNotification = original.GovernanceEmailNotification
type GovernanceRule = original.GovernanceRule
type GovernanceRuleClient = original.GovernanceRuleClient
type GovernanceRuleEmailNotification = original.GovernanceRuleEmailNotification
type GovernanceRuleList = original.GovernanceRuleList
type GovernanceRuleListIterator = original.GovernanceRuleListIterator
type GovernanceRuleListPage = original.GovernanceRuleListPage
type GovernanceRuleOwnerSource = original.GovernanceRuleOwnerSource
type GovernanceRuleProperties = original.GovernanceRuleProperties
type GovernanceRulesClient = original.GovernanceRulesClient
type GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture = original.GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture
type GovernanceRulesRuleIDExecuteSingleSubscriptionFuture = original.GovernanceRulesRuleIDExecuteSingleSubscriptionFuture
type HTTPC2DMessagesNotInAllowedRange = original.HTTPC2DMessagesNotInAllowedRange
type HTTPC2DRejectedMessagesNotInAllowedRange = original.HTTPC2DRejectedMessagesNotInAllowedRange
type HTTPD2CMessagesNotInAllowedRange = original.HTTPD2CMessagesNotInAllowedRange
type HybridComputeSettingsProperties = original.HybridComputeSettingsProperties
type InformationProtectionAwsOffering = original.InformationProtectionAwsOffering
type InformationProtectionAwsOfferingInformationProtection = original.InformationProtectionAwsOfferingInformationProtection
type InformationProtectionKeyword = original.InformationProtectionKeyword
type InformationProtectionPoliciesClient = original.InformationProtectionPoliciesClient
type InformationProtectionPolicy = original.InformationProtectionPolicy
type InformationProtectionPolicyList = original.InformationProtectionPolicyList
type InformationProtectionPolicyListIterator = original.InformationProtectionPolicyListIterator
type InformationProtectionPolicyListPage = original.InformationProtectionPolicyListPage
type InformationProtectionPolicyProperties = original.InformationProtectionPolicyProperties
type InformationType = original.InformationType
type IngestionConnectionString = original.IngestionConnectionString
type IngestionSetting = original.IngestionSetting
type IngestionSettingList = original.IngestionSettingList
type IngestionSettingListIterator = original.IngestionSettingListIterator
type IngestionSettingListPage = original.IngestionSettingListPage
type IngestionSettingToken = original.IngestionSettingToken
type IngestionSettingsClient = original.IngestionSettingsClient
type IoTSecurityAggregatedAlert = original.IoTSecurityAggregatedAlert
type IoTSecurityAggregatedAlertList = original.IoTSecurityAggregatedAlertList
type IoTSecurityAggregatedAlertListIterator = original.IoTSecurityAggregatedAlertListIterator
type IoTSecurityAggregatedAlertListPage = original.IoTSecurityAggregatedAlertListPage
type IoTSecurityAggregatedAlertProperties = original.IoTSecurityAggregatedAlertProperties
type IoTSecurityAggregatedAlertPropertiesTopDevicesListItem = original.IoTSecurityAggregatedAlertPropertiesTopDevicesListItem
type IoTSecurityAggregatedRecommendation = original.IoTSecurityAggregatedRecommendation
type IoTSecurityAggregatedRecommendationList = original.IoTSecurityAggregatedRecommendationList
type IoTSecurityAggregatedRecommendationListIterator = original.IoTSecurityAggregatedRecommendationListIterator
type IoTSecurityAggregatedRecommendationListPage = original.IoTSecurityAggregatedRecommendationListPage
type IoTSecurityAggregatedRecommendationProperties = original.IoTSecurityAggregatedRecommendationProperties
type IoTSecurityAlertedDevice = original.IoTSecurityAlertedDevice
type IoTSecurityDeviceAlert = original.IoTSecurityDeviceAlert
type IoTSecurityDeviceRecommendation = original.IoTSecurityDeviceRecommendation
type IoTSecuritySolutionAnalyticsModel = original.IoTSecuritySolutionAnalyticsModel
type IoTSecuritySolutionAnalyticsModelList = original.IoTSecuritySolutionAnalyticsModelList
type IoTSecuritySolutionAnalyticsModelProperties = original.IoTSecuritySolutionAnalyticsModelProperties
type IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem = original.IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem
type IoTSecuritySolutionModel = original.IoTSecuritySolutionModel
type IoTSecuritySolutionProperties = original.IoTSecuritySolutionProperties
type IoTSecuritySolutionsList = original.IoTSecuritySolutionsList
type IoTSecuritySolutionsListIterator = original.IoTSecuritySolutionsListIterator
type IoTSecuritySolutionsListPage = original.IoTSecuritySolutionsListPage
type IoTSeverityMetrics = original.IoTSeverityMetrics
type IotSecuritySolutionAnalyticsClient = original.IotSecuritySolutionAnalyticsClient
type IotSecuritySolutionClient = original.IotSecuritySolutionClient
type IotSecuritySolutionsAnalyticsAggregatedAlertClient = original.IotSecuritySolutionsAnalyticsAggregatedAlertClient
type IotSecuritySolutionsAnalyticsRecommendationClient = original.IotSecuritySolutionsAnalyticsRecommendationClient
type JitNetworkAccessPoliciesClient = original.JitNetworkAccessPoliciesClient
type JitNetworkAccessPoliciesList = original.JitNetworkAccessPoliciesList
type JitNetworkAccessPoliciesListIterator = original.JitNetworkAccessPoliciesListIterator
type JitNetworkAccessPoliciesListPage = original.JitNetworkAccessPoliciesListPage
type JitNetworkAccessPolicy = original.JitNetworkAccessPolicy
type JitNetworkAccessPolicyInitiatePort = original.JitNetworkAccessPolicyInitiatePort
type JitNetworkAccessPolicyInitiateRequest = original.JitNetworkAccessPolicyInitiateRequest
type JitNetworkAccessPolicyInitiateVirtualMachine = original.JitNetworkAccessPolicyInitiateVirtualMachine
type JitNetworkAccessPolicyProperties = original.JitNetworkAccessPolicyProperties
type JitNetworkAccessPolicyVirtualMachine = original.JitNetworkAccessPolicyVirtualMachine
type JitNetworkAccessPortRule = original.JitNetworkAccessPortRule
type JitNetworkAccessRequest = original.JitNetworkAccessRequest
type JitNetworkAccessRequestPort = original.JitNetworkAccessRequestPort
type JitNetworkAccessRequestVirtualMachine = original.JitNetworkAccessRequestVirtualMachine
type Kind = original.Kind
type ListCustomAlertRule = original.ListCustomAlertRule
type LocalUserNotAllowed = original.LocalUserNotAllowed
type Location = original.Location
type LocationsClient = original.LocationsClient
type LogAnalyticsIdentifier = original.LogAnalyticsIdentifier
type MdeOnboardingData = original.MdeOnboardingData
type MdeOnboardingDataList = original.MdeOnboardingDataList
type MdeOnboardingDataProperties = original.MdeOnboardingDataProperties
type MdeOnboardingsClient = original.MdeOnboardingsClient
type MqttC2DMessagesNotInAllowedRange = original.MqttC2DMessagesNotInAllowedRange
type MqttC2DRejectedMessagesNotInAllowedRange = original.MqttC2DRejectedMessagesNotInAllowedRange
type MqttD2CMessagesNotInAllowedRange = original.MqttD2CMessagesNotInAllowedRange
type OnPremiseResourceDetails = original.OnPremiseResourceDetails
type OnPremiseSQLResourceDetails = original.OnPremiseSQLResourceDetails
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationListIterator = original.OperationListIterator
type OperationListPage = original.OperationListPage
type OperationsClient = original.OperationsClient
type PathRecommendation = original.PathRecommendation
type Pricing = original.Pricing
type PricingList = original.PricingList
type PricingProperties = original.PricingProperties
type PricingsClient = original.PricingsClient
type ProcessNotAllowed = original.ProcessNotAllowed
type ProtectionMode = original.ProtectionMode
type ProxyServerProperties = original.ProxyServerProperties
type PublisherInfo = original.PublisherInfo
type QueryCheck = original.QueryCheck
type QueuePurgesNotInAllowedRange = original.QueuePurgesNotInAllowedRange
type RecommendationConfigurationProperties = original.RecommendationConfigurationProperties
type RegulatoryComplianceAssessment = original.RegulatoryComplianceAssessment
type RegulatoryComplianceAssessmentList = original.RegulatoryComplianceAssessmentList
type RegulatoryComplianceAssessmentListIterator = original.RegulatoryComplianceAssessmentListIterator
type RegulatoryComplianceAssessmentListPage = original.RegulatoryComplianceAssessmentListPage
type RegulatoryComplianceAssessmentProperties = original.RegulatoryComplianceAssessmentProperties
type RegulatoryComplianceAssessmentsClient = original.RegulatoryComplianceAssessmentsClient
type RegulatoryComplianceControl = original.RegulatoryComplianceControl
type RegulatoryComplianceControlList = original.RegulatoryComplianceControlList
type RegulatoryComplianceControlListIterator = original.RegulatoryComplianceControlListIterator
type RegulatoryComplianceControlListPage = original.RegulatoryComplianceControlListPage
type RegulatoryComplianceControlProperties = original.RegulatoryComplianceControlProperties
type RegulatoryComplianceControlsClient = original.RegulatoryComplianceControlsClient
type RegulatoryComplianceStandard = original.RegulatoryComplianceStandard
type RegulatoryComplianceStandardList = original.RegulatoryComplianceStandardList
type RegulatoryComplianceStandardListIterator = original.RegulatoryComplianceStandardListIterator
type RegulatoryComplianceStandardListPage = original.RegulatoryComplianceStandardListPage
type RegulatoryComplianceStandardProperties = original.RegulatoryComplianceStandardProperties
type RegulatoryComplianceStandardsClient = original.RegulatoryComplianceStandardsClient
type Remediation = original.Remediation
type RemediationEta = original.RemediationEta
type Resource = original.Resource
type ResourceDetails = original.ResourceDetails
type ResourceIdentifier = original.ResourceIdentifier
type Rule = original.Rule
type RuleResults = original.RuleResults
type RuleResultsInput = original.RuleResultsInput
type RuleResultsProperties = original.RuleResultsProperties
type RulesResults = original.RulesResults
type RulesResultsInput = original.RulesResultsInput
type SQLServerVulnerabilityProperties = original.SQLServerVulnerabilityProperties
type SQLVulnerabilityAssessmentBaselineRulesClient = original.SQLVulnerabilityAssessmentBaselineRulesClient
type SQLVulnerabilityAssessmentScanResultsClient = original.SQLVulnerabilityAssessmentScanResultsClient
type SQLVulnerabilityAssessmentScansClient = original.SQLVulnerabilityAssessmentScansClient
type Scan = original.Scan
type ScanProperties = original.ScanProperties
type ScanResult = original.ScanResult
type ScanResultProperties = original.ScanResultProperties
type ScanResults = original.ScanResults
type Scans = original.Scans
type ScopeElement = original.ScopeElement
type ScoreDetails = original.ScoreDetails
type SecureScoreControlDefinitionItem = original.SecureScoreControlDefinitionItem
type SecureScoreControlDefinitionItemProperties = original.SecureScoreControlDefinitionItemProperties
type SecureScoreControlDefinitionList = original.SecureScoreControlDefinitionList
type SecureScoreControlDefinitionListIterator = original.SecureScoreControlDefinitionListIterator
type SecureScoreControlDefinitionListPage = original.SecureScoreControlDefinitionListPage
type SecureScoreControlDefinitionSource = original.SecureScoreControlDefinitionSource
type SecureScoreControlDefinitionsClient = original.SecureScoreControlDefinitionsClient
type SecureScoreControlDetails = original.SecureScoreControlDetails
type SecureScoreControlList = original.SecureScoreControlList
type SecureScoreControlListIterator = original.SecureScoreControlListIterator
type SecureScoreControlListPage = original.SecureScoreControlListPage
type SecureScoreControlScore = original.SecureScoreControlScore
type SecureScoreControlScoreDetails = original.SecureScoreControlScoreDetails
type SecureScoreControlsClient = original.SecureScoreControlsClient
type SecureScoreItem = original.SecureScoreItem
type SecureScoreItemProperties = original.SecureScoreItemProperties
type SecureScoresClient = original.SecureScoresClient
type SecureScoresList = original.SecureScoresList
type SecureScoresListIterator = original.SecureScoresListIterator
type SecureScoresListPage = original.SecureScoresListPage
type SensitivityLabel = original.SensitivityLabel
type ServerVulnerabilityAssessment = original.ServerVulnerabilityAssessment
type ServerVulnerabilityAssessmentClient = original.ServerVulnerabilityAssessmentClient
type ServerVulnerabilityAssessmentDeleteFuture = original.ServerVulnerabilityAssessmentDeleteFuture
type ServerVulnerabilityAssessmentProperties = original.ServerVulnerabilityAssessmentProperties
type ServerVulnerabilityAssessmentsList = original.ServerVulnerabilityAssessmentsList
type ServerVulnerabilityProperties = original.ServerVulnerabilityProperties
type ServicePrincipalProperties = original.ServicePrincipalProperties
type Setting = original.Setting
type SettingModel = original.SettingModel
type SettingsClient = original.SettingsClient
type SettingsList = original.SettingsList
type SettingsListIterator = original.SettingsListIterator
type SettingsListPage = original.SettingsListPage
type Software = original.Software
type SoftwareInventoriesClient = original.SoftwareInventoriesClient
type SoftwareProperties = original.SoftwareProperties
type SoftwaresList = original.SoftwaresList
type SoftwaresListIterator = original.SoftwaresListIterator
type SoftwaresListPage = original.SoftwaresListPage
type Solution = original.Solution
type SolutionList = original.SolutionList
type SolutionListIterator = original.SolutionListIterator
type SolutionListPage = original.SolutionListPage
type SolutionProperties = original.SolutionProperties
type SolutionsClient = original.SolutionsClient
type SolutionsReferenceData = original.SolutionsReferenceData
type SolutionsReferenceDataClient = original.SolutionsReferenceDataClient
type SolutionsReferenceDataList = original.SolutionsReferenceDataList
type SolutionsReferenceDataProperties = original.SolutionsReferenceDataProperties
type SubAssessment = original.SubAssessment
type SubAssessmentList = original.SubAssessmentList
type SubAssessmentListIterator = original.SubAssessmentListIterator
type SubAssessmentListPage = original.SubAssessmentListPage
type SubAssessmentProperties = original.SubAssessmentProperties
type SubAssessmentStatus = original.SubAssessmentStatus
type SubAssessmentsClient = original.SubAssessmentsClient
type SubscriptionGovernanceRulesExecuteStatusClient = original.SubscriptionGovernanceRulesExecuteStatusClient
type SubscriptionGovernanceRulesExecuteStatusGetFuture = original.SubscriptionGovernanceRulesExecuteStatusGetFuture
type SuppressionAlertsScope = original.SuppressionAlertsScope
type SystemData = original.SystemData
type Tags = original.Tags
type TagsResource = original.TagsResource
type Task = original.Task
type TaskList = original.TaskList
type TaskListIterator = original.TaskListIterator
type TaskListPage = original.TaskListPage
type TaskParameters = original.TaskParameters
type TaskProperties = original.TaskProperties
type TasksClient = original.TasksClient
type ThresholdCustomAlertRule = original.ThresholdCustomAlertRule
type TimeWindowCustomAlertRule = original.TimeWindowCustomAlertRule
type TopologyClient = original.TopologyClient
type TopologyList = original.TopologyList
type TopologyListIterator = original.TopologyListIterator
type TopologyListPage = original.TopologyListPage
type TopologyResource = original.TopologyResource
type TopologyResourceProperties = original.TopologyResourceProperties
type TopologySingleResource = original.TopologySingleResource
type TopologySingleResourceChild = original.TopologySingleResourceChild
type TopologySingleResourceParent = original.TopologySingleResourceParent
type TrackedResource = original.TrackedResource
type TwinUpdatesNotInAllowedRange = original.TwinUpdatesNotInAllowedRange
type UnauthorizedOperationsNotInAllowedRange = original.UnauthorizedOperationsNotInAllowedRange
type UpdateIoTSecuritySolutionProperties = original.UpdateIoTSecuritySolutionProperties
type UpdateIotSecuritySolutionData = original.UpdateIotSecuritySolutionData
type UserDefinedResourcesProperties = original.UserDefinedResourcesProperties
type UserRecommendation = original.UserRecommendation
type VMRecommendation = original.VMRecommendation
type VaRule = original.VaRule
type VendorReference = original.VendorReference
type WorkspaceSetting = original.WorkspaceSetting
type WorkspaceSettingList = original.WorkspaceSettingList
type WorkspaceSettingListIterator = original.WorkspaceSettingListIterator
type WorkspaceSettingListPage = original.WorkspaceSettingListPage
type WorkspaceSettingProperties = original.WorkspaceSettingProperties
type WorkspaceSettingsClient = original.WorkspaceSettingsClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAdaptiveApplicationControlsClient(subscriptionID string) AdaptiveApplicationControlsClient {
	return original.NewAdaptiveApplicationControlsClient(subscriptionID)
}
func NewAdaptiveApplicationControlsClientWithBaseURI(baseURI string, subscriptionID string) AdaptiveApplicationControlsClient {
	return original.NewAdaptiveApplicationControlsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAdaptiveNetworkHardeningsClient(subscriptionID string) AdaptiveNetworkHardeningsClient {
	return original.NewAdaptiveNetworkHardeningsClient(subscriptionID)
}
func NewAdaptiveNetworkHardeningsClientWithBaseURI(baseURI string, subscriptionID string) AdaptiveNetworkHardeningsClient {
	return original.NewAdaptiveNetworkHardeningsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAdaptiveNetworkHardeningsListIterator(page AdaptiveNetworkHardeningsListPage) AdaptiveNetworkHardeningsListIterator {
	return original.NewAdaptiveNetworkHardeningsListIterator(page)
}
func NewAdaptiveNetworkHardeningsListPage(cur AdaptiveNetworkHardeningsList, getNextPage func(context.Context, AdaptiveNetworkHardeningsList) (AdaptiveNetworkHardeningsList, error)) AdaptiveNetworkHardeningsListPage {
	return original.NewAdaptiveNetworkHardeningsListPage(cur, getNextPage)
}
func NewAdvancedThreatProtectionClient(subscriptionID string) AdvancedThreatProtectionClient {
	return original.NewAdvancedThreatProtectionClient(subscriptionID)
}
func NewAdvancedThreatProtectionClientWithBaseURI(baseURI string, subscriptionID string) AdvancedThreatProtectionClient {
	return original.NewAdvancedThreatProtectionClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return original.NewAlertListIterator(page)
}
func NewAlertListPage(cur AlertList, getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return original.NewAlertListPage(cur, getNextPage)
}
func NewAlertsClient(subscriptionID string) AlertsClient {
	return original.NewAlertsClient(subscriptionID)
}
func NewAlertsClientWithBaseURI(baseURI string, subscriptionID string) AlertsClient {
	return original.NewAlertsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertsSuppressionRulesClient(subscriptionID string) AlertsSuppressionRulesClient {
	return original.NewAlertsSuppressionRulesClient(subscriptionID)
}
func NewAlertsSuppressionRulesClientWithBaseURI(baseURI string, subscriptionID string) AlertsSuppressionRulesClient {
	return original.NewAlertsSuppressionRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertsSuppressionRulesListIterator(page AlertsSuppressionRulesListPage) AlertsSuppressionRulesListIterator {
	return original.NewAlertsSuppressionRulesListIterator(page)
}
func NewAlertsSuppressionRulesListPage(cur AlertsSuppressionRulesList, getNextPage func(context.Context, AlertsSuppressionRulesList) (AlertsSuppressionRulesList, error)) AlertsSuppressionRulesListPage {
	return original.NewAlertsSuppressionRulesListPage(cur, getNextPage)
}
func NewAllowedConnectionsClient(subscriptionID string) AllowedConnectionsClient {
	return original.NewAllowedConnectionsClient(subscriptionID)
}
func NewAllowedConnectionsClientWithBaseURI(baseURI string, subscriptionID string) AllowedConnectionsClient {
	return original.NewAllowedConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAllowedConnectionsListIterator(page AllowedConnectionsListPage) AllowedConnectionsListIterator {
	return original.NewAllowedConnectionsListIterator(page)
}
func NewAllowedConnectionsListPage(cur AllowedConnectionsList, getNextPage func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)) AllowedConnectionsListPage {
	return original.NewAllowedConnectionsListPage(cur, getNextPage)
}
func NewApplicationClient(subscriptionID string) ApplicationClient {
	return original.NewApplicationClient(subscriptionID)
}
func NewApplicationClientWithBaseURI(baseURI string, subscriptionID string) ApplicationClient {
	return original.NewApplicationClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationsClient(subscriptionID string) ApplicationsClient {
	return original.NewApplicationsClient(subscriptionID)
}
func NewApplicationsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationsClient {
	return original.NewApplicationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationsListIterator(page ApplicationsListPage) ApplicationsListIterator {
	return original.NewApplicationsListIterator(page)
}
func NewApplicationsListPage(cur ApplicationsList, getNextPage func(context.Context, ApplicationsList) (ApplicationsList, error)) ApplicationsListPage {
	return original.NewApplicationsListPage(cur, getNextPage)
}
func NewAscLocationListIterator(page AscLocationListPage) AscLocationListIterator {
	return original.NewAscLocationListIterator(page)
}
func NewAscLocationListPage(cur AscLocationList, getNextPage func(context.Context, AscLocationList) (AscLocationList, error)) AscLocationListPage {
	return original.NewAscLocationListPage(cur, getNextPage)
}
func NewAssessmentListIterator(page AssessmentListPage) AssessmentListIterator {
	return original.NewAssessmentListIterator(page)
}
func NewAssessmentListPage(cur AssessmentList, getNextPage func(context.Context, AssessmentList) (AssessmentList, error)) AssessmentListPage {
	return original.NewAssessmentListPage(cur, getNextPage)
}
func NewAssessmentMetadataResponseListIterator(page AssessmentMetadataResponseListPage) AssessmentMetadataResponseListIterator {
	return original.NewAssessmentMetadataResponseListIterator(page)
}
func NewAssessmentMetadataResponseListPage(cur AssessmentMetadataResponseList, getNextPage func(context.Context, AssessmentMetadataResponseList) (AssessmentMetadataResponseList, error)) AssessmentMetadataResponseListPage {
	return original.NewAssessmentMetadataResponseListPage(cur, getNextPage)
}
func NewAssessmentsClient(subscriptionID string) AssessmentsClient {
	return original.NewAssessmentsClient(subscriptionID)
}
func NewAssessmentsClientWithBaseURI(baseURI string, subscriptionID string) AssessmentsClient {
	return original.NewAssessmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssessmentsMetadataClient(subscriptionID string) AssessmentsMetadataClient {
	return original.NewAssessmentsMetadataClient(subscriptionID)
}
func NewAssessmentsMetadataClientWithBaseURI(baseURI string, subscriptionID string) AssessmentsMetadataClient {
	return original.NewAssessmentsMetadataClientWithBaseURI(baseURI, subscriptionID)
}
func NewAutoProvisioningSettingListIterator(page AutoProvisioningSettingListPage) AutoProvisioningSettingListIterator {
	return original.NewAutoProvisioningSettingListIterator(page)
}
func NewAutoProvisioningSettingListPage(cur AutoProvisioningSettingList, getNextPage func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)) AutoProvisioningSettingListPage {
	return original.NewAutoProvisioningSettingListPage(cur, getNextPage)
}
func NewAutoProvisioningSettingsClient(subscriptionID string) AutoProvisioningSettingsClient {
	return original.NewAutoProvisioningSettingsClient(subscriptionID)
}
func NewAutoProvisioningSettingsClientWithBaseURI(baseURI string, subscriptionID string) AutoProvisioningSettingsClient {
	return original.NewAutoProvisioningSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAutomationListIterator(page AutomationListPage) AutomationListIterator {
	return original.NewAutomationListIterator(page)
}
func NewAutomationListPage(cur AutomationList, getNextPage func(context.Context, AutomationList) (AutomationList, error)) AutomationListPage {
	return original.NewAutomationListPage(cur, getNextPage)
}
func NewAutomationsClient(subscriptionID string) AutomationsClient {
	return original.NewAutomationsClient(subscriptionID)
}
func NewAutomationsClientWithBaseURI(baseURI string, subscriptionID string) AutomationsClient {
	return original.NewAutomationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewComplianceListIterator(page ComplianceListPage) ComplianceListIterator {
	return original.NewComplianceListIterator(page)
}
func NewComplianceListPage(cur ComplianceList, getNextPage func(context.Context, ComplianceList) (ComplianceList, error)) ComplianceListPage {
	return original.NewComplianceListPage(cur, getNextPage)
}
func NewComplianceResultListIterator(page ComplianceResultListPage) ComplianceResultListIterator {
	return original.NewComplianceResultListIterator(page)
}
func NewComplianceResultListPage(cur ComplianceResultList, getNextPage func(context.Context, ComplianceResultList) (ComplianceResultList, error)) ComplianceResultListPage {
	return original.NewComplianceResultListPage(cur, getNextPage)
}
func NewComplianceResultsClient(subscriptionID string) ComplianceResultsClient {
	return original.NewComplianceResultsClient(subscriptionID)
}
func NewComplianceResultsClientWithBaseURI(baseURI string, subscriptionID string) ComplianceResultsClient {
	return original.NewComplianceResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCompliancesClient(subscriptionID string) CompliancesClient {
	return original.NewCompliancesClient(subscriptionID)
}
func NewCompliancesClientWithBaseURI(baseURI string, subscriptionID string) CompliancesClient {
	return original.NewCompliancesClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectorApplicationClient(subscriptionID string) ConnectorApplicationClient {
	return original.NewConnectorApplicationClient(subscriptionID)
}
func NewConnectorApplicationClientWithBaseURI(baseURI string, subscriptionID string) ConnectorApplicationClient {
	return original.NewConnectorApplicationClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectorApplicationsClient(subscriptionID string) ConnectorApplicationsClient {
	return original.NewConnectorApplicationsClient(subscriptionID)
}
func NewConnectorApplicationsClientWithBaseURI(baseURI string, subscriptionID string) ConnectorApplicationsClient {
	return original.NewConnectorApplicationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectorGovernanceRuleClient(subscriptionID string) ConnectorGovernanceRuleClient {
	return original.NewConnectorGovernanceRuleClient(subscriptionID)
}
func NewConnectorGovernanceRuleClientWithBaseURI(baseURI string, subscriptionID string) ConnectorGovernanceRuleClient {
	return original.NewConnectorGovernanceRuleClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectorGovernanceRulesClient(subscriptionID string) ConnectorGovernanceRulesClient {
	return original.NewConnectorGovernanceRulesClient(subscriptionID)
}
func NewConnectorGovernanceRulesClientWithBaseURI(baseURI string, subscriptionID string) ConnectorGovernanceRulesClient {
	return original.NewConnectorGovernanceRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectorGovernanceRulesExecuteStatusClient(subscriptionID string) ConnectorGovernanceRulesExecuteStatusClient {
	return original.NewConnectorGovernanceRulesExecuteStatusClient(subscriptionID)
}
func NewConnectorGovernanceRulesExecuteStatusClientWithBaseURI(baseURI string, subscriptionID string) ConnectorGovernanceRulesExecuteStatusClient {
	return original.NewConnectorGovernanceRulesExecuteStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectorSettingListIterator(page ConnectorSettingListPage) ConnectorSettingListIterator {
	return original.NewConnectorSettingListIterator(page)
}
func NewConnectorSettingListPage(cur ConnectorSettingList, getNextPage func(context.Context, ConnectorSettingList) (ConnectorSettingList, error)) ConnectorSettingListPage {
	return original.NewConnectorSettingListPage(cur, getNextPage)
}
func NewConnectorsClient(subscriptionID string) ConnectorsClient {
	return original.NewConnectorsClient(subscriptionID)
}
func NewConnectorsClientWithBaseURI(baseURI string, subscriptionID string) ConnectorsClient {
	return original.NewConnectorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectorsGroupClient(subscriptionID string) ConnectorsGroupClient {
	return original.NewConnectorsGroupClient(subscriptionID)
}
func NewConnectorsGroupClientWithBaseURI(baseURI string, subscriptionID string) ConnectorsGroupClient {
	return original.NewConnectorsGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectorsListIterator(page ConnectorsListPage) ConnectorsListIterator {
	return original.NewConnectorsListIterator(page)
}
func NewConnectorsListPage(cur ConnectorsList, getNextPage func(context.Context, ConnectorsList) (ConnectorsList, error)) ConnectorsListPage {
	return original.NewConnectorsListPage(cur, getNextPage)
}
func NewContactListIterator(page ContactListPage) ContactListIterator {
	return original.NewContactListIterator(page)
}
func NewContactListPage(cur ContactList, getNextPage func(context.Context, ContactList) (ContactList, error)) ContactListPage {
	return original.NewContactListPage(cur, getNextPage)
}
func NewContactsClient(subscriptionID string) ContactsClient {
	return original.NewContactsClient(subscriptionID)
}
func NewContactsClientWithBaseURI(baseURI string, subscriptionID string) ContactsClient {
	return original.NewContactsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCustomAssessmentAutomationsClient(subscriptionID string) CustomAssessmentAutomationsClient {
	return original.NewCustomAssessmentAutomationsClient(subscriptionID)
}
func NewCustomAssessmentAutomationsClientWithBaseURI(baseURI string, subscriptionID string) CustomAssessmentAutomationsClient {
	return original.NewCustomAssessmentAutomationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCustomAssessmentAutomationsListResultIterator(page CustomAssessmentAutomationsListResultPage) CustomAssessmentAutomationsListResultIterator {
	return original.NewCustomAssessmentAutomationsListResultIterator(page)
}
func NewCustomAssessmentAutomationsListResultPage(cur CustomAssessmentAutomationsListResult, getNextPage func(context.Context, CustomAssessmentAutomationsListResult) (CustomAssessmentAutomationsListResult, error)) CustomAssessmentAutomationsListResultPage {
	return original.NewCustomAssessmentAutomationsListResultPage(cur, getNextPage)
}
func NewCustomEntityStoreAssignmentsClient(subscriptionID string) CustomEntityStoreAssignmentsClient {
	return original.NewCustomEntityStoreAssignmentsClient(subscriptionID)
}
func NewCustomEntityStoreAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) CustomEntityStoreAssignmentsClient {
	return original.NewCustomEntityStoreAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCustomEntityStoreAssignmentsListResultIterator(page CustomEntityStoreAssignmentsListResultPage) CustomEntityStoreAssignmentsListResultIterator {
	return original.NewCustomEntityStoreAssignmentsListResultIterator(page)
}
func NewCustomEntityStoreAssignmentsListResultPage(cur CustomEntityStoreAssignmentsListResult, getNextPage func(context.Context, CustomEntityStoreAssignmentsListResult) (CustomEntityStoreAssignmentsListResult, error)) CustomEntityStoreAssignmentsListResultPage {
	return original.NewCustomEntityStoreAssignmentsListResultPage(cur, getNextPage)
}
func NewDeviceSecurityGroupListIterator(page DeviceSecurityGroupListPage) DeviceSecurityGroupListIterator {
	return original.NewDeviceSecurityGroupListIterator(page)
}
func NewDeviceSecurityGroupListPage(cur DeviceSecurityGroupList, getNextPage func(context.Context, DeviceSecurityGroupList) (DeviceSecurityGroupList, error)) DeviceSecurityGroupListPage {
	return original.NewDeviceSecurityGroupListPage(cur, getNextPage)
}
func NewDeviceSecurityGroupsClient(subscriptionID string) DeviceSecurityGroupsClient {
	return original.NewDeviceSecurityGroupsClient(subscriptionID)
}
func NewDeviceSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) DeviceSecurityGroupsClient {
	return original.NewDeviceSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiscoveredSecuritySolutionListIterator(page DiscoveredSecuritySolutionListPage) DiscoveredSecuritySolutionListIterator {
	return original.NewDiscoveredSecuritySolutionListIterator(page)
}
func NewDiscoveredSecuritySolutionListPage(cur DiscoveredSecuritySolutionList, getNextPage func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)) DiscoveredSecuritySolutionListPage {
	return original.NewDiscoveredSecuritySolutionListPage(cur, getNextPage)
}
func NewDiscoveredSecuritySolutionsClient(subscriptionID string) DiscoveredSecuritySolutionsClient {
	return original.NewDiscoveredSecuritySolutionsClient(subscriptionID)
}
func NewDiscoveredSecuritySolutionsClientWithBaseURI(baseURI string, subscriptionID string) DiscoveredSecuritySolutionsClient {
	return original.NewDiscoveredSecuritySolutionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExternalSecuritySolutionListIterator(page ExternalSecuritySolutionListPage) ExternalSecuritySolutionListIterator {
	return original.NewExternalSecuritySolutionListIterator(page)
}
func NewExternalSecuritySolutionListPage(cur ExternalSecuritySolutionList, getNextPage func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)) ExternalSecuritySolutionListPage {
	return original.NewExternalSecuritySolutionListPage(cur, getNextPage)
}
func NewExternalSecuritySolutionsClient(subscriptionID string) ExternalSecuritySolutionsClient {
	return original.NewExternalSecuritySolutionsClient(subscriptionID)
}
func NewExternalSecuritySolutionsClientWithBaseURI(baseURI string, subscriptionID string) ExternalSecuritySolutionsClient {
	return original.NewExternalSecuritySolutionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGovernanceAssignmentsClient(subscriptionID string) GovernanceAssignmentsClient {
	return original.NewGovernanceAssignmentsClient(subscriptionID)
}
func NewGovernanceAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) GovernanceAssignmentsClient {
	return original.NewGovernanceAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGovernanceAssignmentsListIterator(page GovernanceAssignmentsListPage) GovernanceAssignmentsListIterator {
	return original.NewGovernanceAssignmentsListIterator(page)
}
func NewGovernanceAssignmentsListPage(cur GovernanceAssignmentsList, getNextPage func(context.Context, GovernanceAssignmentsList) (GovernanceAssignmentsList, error)) GovernanceAssignmentsListPage {
	return original.NewGovernanceAssignmentsListPage(cur, getNextPage)
}
func NewGovernanceRuleClient(subscriptionID string) GovernanceRuleClient {
	return original.NewGovernanceRuleClient(subscriptionID)
}
func NewGovernanceRuleClientWithBaseURI(baseURI string, subscriptionID string) GovernanceRuleClient {
	return original.NewGovernanceRuleClientWithBaseURI(baseURI, subscriptionID)
}
func NewGovernanceRuleListIterator(page GovernanceRuleListPage) GovernanceRuleListIterator {
	return original.NewGovernanceRuleListIterator(page)
}
func NewGovernanceRuleListPage(cur GovernanceRuleList, getNextPage func(context.Context, GovernanceRuleList) (GovernanceRuleList, error)) GovernanceRuleListPage {
	return original.NewGovernanceRuleListPage(cur, getNextPage)
}
func NewGovernanceRulesClient(subscriptionID string) GovernanceRulesClient {
	return original.NewGovernanceRulesClient(subscriptionID)
}
func NewGovernanceRulesClientWithBaseURI(baseURI string, subscriptionID string) GovernanceRulesClient {
	return original.NewGovernanceRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewInformationProtectionPoliciesClient(subscriptionID string) InformationProtectionPoliciesClient {
	return original.NewInformationProtectionPoliciesClient(subscriptionID)
}
func NewInformationProtectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) InformationProtectionPoliciesClient {
	return original.NewInformationProtectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewInformationProtectionPolicyListIterator(page InformationProtectionPolicyListPage) InformationProtectionPolicyListIterator {
	return original.NewInformationProtectionPolicyListIterator(page)
}
func NewInformationProtectionPolicyListPage(cur InformationProtectionPolicyList, getNextPage func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)) InformationProtectionPolicyListPage {
	return original.NewInformationProtectionPolicyListPage(cur, getNextPage)
}
func NewIngestionSettingListIterator(page IngestionSettingListPage) IngestionSettingListIterator {
	return original.NewIngestionSettingListIterator(page)
}
func NewIngestionSettingListPage(cur IngestionSettingList, getNextPage func(context.Context, IngestionSettingList) (IngestionSettingList, error)) IngestionSettingListPage {
	return original.NewIngestionSettingListPage(cur, getNextPage)
}
func NewIngestionSettingsClient(subscriptionID string) IngestionSettingsClient {
	return original.NewIngestionSettingsClient(subscriptionID)
}
func NewIngestionSettingsClientWithBaseURI(baseURI string, subscriptionID string) IngestionSettingsClient {
	return original.NewIngestionSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIoTSecurityAggregatedAlertListIterator(page IoTSecurityAggregatedAlertListPage) IoTSecurityAggregatedAlertListIterator {
	return original.NewIoTSecurityAggregatedAlertListIterator(page)
}
func NewIoTSecurityAggregatedAlertListPage(cur IoTSecurityAggregatedAlertList, getNextPage func(context.Context, IoTSecurityAggregatedAlertList) (IoTSecurityAggregatedAlertList, error)) IoTSecurityAggregatedAlertListPage {
	return original.NewIoTSecurityAggregatedAlertListPage(cur, getNextPage)
}
func NewIoTSecurityAggregatedRecommendationListIterator(page IoTSecurityAggregatedRecommendationListPage) IoTSecurityAggregatedRecommendationListIterator {
	return original.NewIoTSecurityAggregatedRecommendationListIterator(page)
}
func NewIoTSecurityAggregatedRecommendationListPage(cur IoTSecurityAggregatedRecommendationList, getNextPage func(context.Context, IoTSecurityAggregatedRecommendationList) (IoTSecurityAggregatedRecommendationList, error)) IoTSecurityAggregatedRecommendationListPage {
	return original.NewIoTSecurityAggregatedRecommendationListPage(cur, getNextPage)
}
func NewIoTSecuritySolutionsListIterator(page IoTSecuritySolutionsListPage) IoTSecuritySolutionsListIterator {
	return original.NewIoTSecuritySolutionsListIterator(page)
}
func NewIoTSecuritySolutionsListPage(cur IoTSecuritySolutionsList, getNextPage func(context.Context, IoTSecuritySolutionsList) (IoTSecuritySolutionsList, error)) IoTSecuritySolutionsListPage {
	return original.NewIoTSecuritySolutionsListPage(cur, getNextPage)
}
func NewIotSecuritySolutionAnalyticsClient(subscriptionID string) IotSecuritySolutionAnalyticsClient {
	return original.NewIotSecuritySolutionAnalyticsClient(subscriptionID)
}
func NewIotSecuritySolutionAnalyticsClientWithBaseURI(baseURI string, subscriptionID string) IotSecuritySolutionAnalyticsClient {
	return original.NewIotSecuritySolutionAnalyticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIotSecuritySolutionClient(subscriptionID string) IotSecuritySolutionClient {
	return original.NewIotSecuritySolutionClient(subscriptionID)
}
func NewIotSecuritySolutionClientWithBaseURI(baseURI string, subscriptionID string) IotSecuritySolutionClient {
	return original.NewIotSecuritySolutionClientWithBaseURI(baseURI, subscriptionID)
}
func NewIotSecuritySolutionsAnalyticsAggregatedAlertClient(subscriptionID string) IotSecuritySolutionsAnalyticsAggregatedAlertClient {
	return original.NewIotSecuritySolutionsAnalyticsAggregatedAlertClient(subscriptionID)
}
func NewIotSecuritySolutionsAnalyticsAggregatedAlertClientWithBaseURI(baseURI string, subscriptionID string) IotSecuritySolutionsAnalyticsAggregatedAlertClient {
	return original.NewIotSecuritySolutionsAnalyticsAggregatedAlertClientWithBaseURI(baseURI, subscriptionID)
}
func NewIotSecuritySolutionsAnalyticsRecommendationClient(subscriptionID string) IotSecuritySolutionsAnalyticsRecommendationClient {
	return original.NewIotSecuritySolutionsAnalyticsRecommendationClient(subscriptionID)
}
func NewIotSecuritySolutionsAnalyticsRecommendationClientWithBaseURI(baseURI string, subscriptionID string) IotSecuritySolutionsAnalyticsRecommendationClient {
	return original.NewIotSecuritySolutionsAnalyticsRecommendationClientWithBaseURI(baseURI, subscriptionID)
}
func NewJitNetworkAccessPoliciesClient(subscriptionID string) JitNetworkAccessPoliciesClient {
	return original.NewJitNetworkAccessPoliciesClient(subscriptionID)
}
func NewJitNetworkAccessPoliciesClientWithBaseURI(baseURI string, subscriptionID string) JitNetworkAccessPoliciesClient {
	return original.NewJitNetworkAccessPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewJitNetworkAccessPoliciesListIterator(page JitNetworkAccessPoliciesListPage) JitNetworkAccessPoliciesListIterator {
	return original.NewJitNetworkAccessPoliciesListIterator(page)
}
func NewJitNetworkAccessPoliciesListPage(cur JitNetworkAccessPoliciesList, getNextPage func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)) JitNetworkAccessPoliciesListPage {
	return original.NewJitNetworkAccessPoliciesListPage(cur, getNextPage)
}
func NewLocationsClient(subscriptionID string) LocationsClient {
	return original.NewLocationsClient(subscriptionID)
}
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string) LocationsClient {
	return original.NewLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMdeOnboardingsClient(subscriptionID string) MdeOnboardingsClient {
	return original.NewMdeOnboardingsClient(subscriptionID)
}
func NewMdeOnboardingsClientWithBaseURI(baseURI string, subscriptionID string) MdeOnboardingsClient {
	return original.NewMdeOnboardingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return original.NewOperationListIterator(page)
}
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return original.NewOperationListPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPricingsClient(subscriptionID string) PricingsClient {
	return original.NewPricingsClient(subscriptionID)
}
func NewPricingsClientWithBaseURI(baseURI string, subscriptionID string) PricingsClient {
	return original.NewPricingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRegulatoryComplianceAssessmentListIterator(page RegulatoryComplianceAssessmentListPage) RegulatoryComplianceAssessmentListIterator {
	return original.NewRegulatoryComplianceAssessmentListIterator(page)
}
func NewRegulatoryComplianceAssessmentListPage(cur RegulatoryComplianceAssessmentList, getNextPage func(context.Context, RegulatoryComplianceAssessmentList) (RegulatoryComplianceAssessmentList, error)) RegulatoryComplianceAssessmentListPage {
	return original.NewRegulatoryComplianceAssessmentListPage(cur, getNextPage)
}
func NewRegulatoryComplianceAssessmentsClient(subscriptionID string) RegulatoryComplianceAssessmentsClient {
	return original.NewRegulatoryComplianceAssessmentsClient(subscriptionID)
}
func NewRegulatoryComplianceAssessmentsClientWithBaseURI(baseURI string, subscriptionID string) RegulatoryComplianceAssessmentsClient {
	return original.NewRegulatoryComplianceAssessmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRegulatoryComplianceControlListIterator(page RegulatoryComplianceControlListPage) RegulatoryComplianceControlListIterator {
	return original.NewRegulatoryComplianceControlListIterator(page)
}
func NewRegulatoryComplianceControlListPage(cur RegulatoryComplianceControlList, getNextPage func(context.Context, RegulatoryComplianceControlList) (RegulatoryComplianceControlList, error)) RegulatoryComplianceControlListPage {
	return original.NewRegulatoryComplianceControlListPage(cur, getNextPage)
}
func NewRegulatoryComplianceControlsClient(subscriptionID string) RegulatoryComplianceControlsClient {
	return original.NewRegulatoryComplianceControlsClient(subscriptionID)
}
func NewRegulatoryComplianceControlsClientWithBaseURI(baseURI string, subscriptionID string) RegulatoryComplianceControlsClient {
	return original.NewRegulatoryComplianceControlsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRegulatoryComplianceStandardListIterator(page RegulatoryComplianceStandardListPage) RegulatoryComplianceStandardListIterator {
	return original.NewRegulatoryComplianceStandardListIterator(page)
}
func NewRegulatoryComplianceStandardListPage(cur RegulatoryComplianceStandardList, getNextPage func(context.Context, RegulatoryComplianceStandardList) (RegulatoryComplianceStandardList, error)) RegulatoryComplianceStandardListPage {
	return original.NewRegulatoryComplianceStandardListPage(cur, getNextPage)
}
func NewRegulatoryComplianceStandardsClient(subscriptionID string) RegulatoryComplianceStandardsClient {
	return original.NewRegulatoryComplianceStandardsClient(subscriptionID)
}
func NewRegulatoryComplianceStandardsClientWithBaseURI(baseURI string, subscriptionID string) RegulatoryComplianceStandardsClient {
	return original.NewRegulatoryComplianceStandardsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLVulnerabilityAssessmentBaselineRulesClient(subscriptionID string) SQLVulnerabilityAssessmentBaselineRulesClient {
	return original.NewSQLVulnerabilityAssessmentBaselineRulesClient(subscriptionID)
}
func NewSQLVulnerabilityAssessmentBaselineRulesClientWithBaseURI(baseURI string, subscriptionID string) SQLVulnerabilityAssessmentBaselineRulesClient {
	return original.NewSQLVulnerabilityAssessmentBaselineRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLVulnerabilityAssessmentScanResultsClient(subscriptionID string) SQLVulnerabilityAssessmentScanResultsClient {
	return original.NewSQLVulnerabilityAssessmentScanResultsClient(subscriptionID)
}
func NewSQLVulnerabilityAssessmentScanResultsClientWithBaseURI(baseURI string, subscriptionID string) SQLVulnerabilityAssessmentScanResultsClient {
	return original.NewSQLVulnerabilityAssessmentScanResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLVulnerabilityAssessmentScansClient(subscriptionID string) SQLVulnerabilityAssessmentScansClient {
	return original.NewSQLVulnerabilityAssessmentScansClient(subscriptionID)
}
func NewSQLVulnerabilityAssessmentScansClientWithBaseURI(baseURI string, subscriptionID string) SQLVulnerabilityAssessmentScansClient {
	return original.NewSQLVulnerabilityAssessmentScansClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecureScoreControlDefinitionListIterator(page SecureScoreControlDefinitionListPage) SecureScoreControlDefinitionListIterator {
	return original.NewSecureScoreControlDefinitionListIterator(page)
}
func NewSecureScoreControlDefinitionListPage(cur SecureScoreControlDefinitionList, getNextPage func(context.Context, SecureScoreControlDefinitionList) (SecureScoreControlDefinitionList, error)) SecureScoreControlDefinitionListPage {
	return original.NewSecureScoreControlDefinitionListPage(cur, getNextPage)
}
func NewSecureScoreControlDefinitionsClient(subscriptionID string) SecureScoreControlDefinitionsClient {
	return original.NewSecureScoreControlDefinitionsClient(subscriptionID)
}
func NewSecureScoreControlDefinitionsClientWithBaseURI(baseURI string, subscriptionID string) SecureScoreControlDefinitionsClient {
	return original.NewSecureScoreControlDefinitionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecureScoreControlListIterator(page SecureScoreControlListPage) SecureScoreControlListIterator {
	return original.NewSecureScoreControlListIterator(page)
}
func NewSecureScoreControlListPage(cur SecureScoreControlList, getNextPage func(context.Context, SecureScoreControlList) (SecureScoreControlList, error)) SecureScoreControlListPage {
	return original.NewSecureScoreControlListPage(cur, getNextPage)
}
func NewSecureScoreControlsClient(subscriptionID string) SecureScoreControlsClient {
	return original.NewSecureScoreControlsClient(subscriptionID)
}
func NewSecureScoreControlsClientWithBaseURI(baseURI string, subscriptionID string) SecureScoreControlsClient {
	return original.NewSecureScoreControlsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecureScoresClient(subscriptionID string) SecureScoresClient {
	return original.NewSecureScoresClient(subscriptionID)
}
func NewSecureScoresClientWithBaseURI(baseURI string, subscriptionID string) SecureScoresClient {
	return original.NewSecureScoresClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecureScoresListIterator(page SecureScoresListPage) SecureScoresListIterator {
	return original.NewSecureScoresListIterator(page)
}
func NewSecureScoresListPage(cur SecureScoresList, getNextPage func(context.Context, SecureScoresList) (SecureScoresList, error)) SecureScoresListPage {
	return original.NewSecureScoresListPage(cur, getNextPage)
}
func NewServerVulnerabilityAssessmentClient(subscriptionID string) ServerVulnerabilityAssessmentClient {
	return original.NewServerVulnerabilityAssessmentClient(subscriptionID)
}
func NewServerVulnerabilityAssessmentClientWithBaseURI(baseURI string, subscriptionID string) ServerVulnerabilityAssessmentClient {
	return original.NewServerVulnerabilityAssessmentClientWithBaseURI(baseURI, subscriptionID)
}
func NewSettingsClient(subscriptionID string) SettingsClient {
	return original.NewSettingsClient(subscriptionID)
}
func NewSettingsClientWithBaseURI(baseURI string, subscriptionID string) SettingsClient {
	return original.NewSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSettingsListIterator(page SettingsListPage) SettingsListIterator {
	return original.NewSettingsListIterator(page)
}
func NewSettingsListPage(cur SettingsList, getNextPage func(context.Context, SettingsList) (SettingsList, error)) SettingsListPage {
	return original.NewSettingsListPage(cur, getNextPage)
}
func NewSoftwareInventoriesClient(subscriptionID string) SoftwareInventoriesClient {
	return original.NewSoftwareInventoriesClient(subscriptionID)
}
func NewSoftwareInventoriesClientWithBaseURI(baseURI string, subscriptionID string) SoftwareInventoriesClient {
	return original.NewSoftwareInventoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSoftwaresListIterator(page SoftwaresListPage) SoftwaresListIterator {
	return original.NewSoftwaresListIterator(page)
}
func NewSoftwaresListPage(cur SoftwaresList, getNextPage func(context.Context, SoftwaresList) (SoftwaresList, error)) SoftwaresListPage {
	return original.NewSoftwaresListPage(cur, getNextPage)
}
func NewSolutionListIterator(page SolutionListPage) SolutionListIterator {
	return original.NewSolutionListIterator(page)
}
func NewSolutionListPage(cur SolutionList, getNextPage func(context.Context, SolutionList) (SolutionList, error)) SolutionListPage {
	return original.NewSolutionListPage(cur, getNextPage)
}
func NewSolutionsClient(subscriptionID string) SolutionsClient {
	return original.NewSolutionsClient(subscriptionID)
}
func NewSolutionsClientWithBaseURI(baseURI string, subscriptionID string) SolutionsClient {
	return original.NewSolutionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSolutionsReferenceDataClient(subscriptionID string) SolutionsReferenceDataClient {
	return original.NewSolutionsReferenceDataClient(subscriptionID)
}
func NewSolutionsReferenceDataClientWithBaseURI(baseURI string, subscriptionID string) SolutionsReferenceDataClient {
	return original.NewSolutionsReferenceDataClientWithBaseURI(baseURI, subscriptionID)
}
func NewSubAssessmentListIterator(page SubAssessmentListPage) SubAssessmentListIterator {
	return original.NewSubAssessmentListIterator(page)
}
func NewSubAssessmentListPage(cur SubAssessmentList, getNextPage func(context.Context, SubAssessmentList) (SubAssessmentList, error)) SubAssessmentListPage {
	return original.NewSubAssessmentListPage(cur, getNextPage)
}
func NewSubAssessmentsClient(subscriptionID string) SubAssessmentsClient {
	return original.NewSubAssessmentsClient(subscriptionID)
}
func NewSubAssessmentsClientWithBaseURI(baseURI string, subscriptionID string) SubAssessmentsClient {
	return original.NewSubAssessmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSubscriptionGovernanceRulesExecuteStatusClient(subscriptionID string) SubscriptionGovernanceRulesExecuteStatusClient {
	return original.NewSubscriptionGovernanceRulesExecuteStatusClient(subscriptionID)
}
func NewSubscriptionGovernanceRulesExecuteStatusClientWithBaseURI(baseURI string, subscriptionID string) SubscriptionGovernanceRulesExecuteStatusClient {
	return original.NewSubscriptionGovernanceRulesExecuteStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return original.NewTaskListIterator(page)
}
func NewTaskListPage(cur TaskList, getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return original.NewTaskListPage(cur, getNextPage)
}
func NewTasksClient(subscriptionID string) TasksClient {
	return original.NewTasksClient(subscriptionID)
}
func NewTasksClientWithBaseURI(baseURI string, subscriptionID string) TasksClient {
	return original.NewTasksClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopologyClient(subscriptionID string) TopologyClient {
	return original.NewTopologyClient(subscriptionID)
}
func NewTopologyClientWithBaseURI(baseURI string, subscriptionID string) TopologyClient {
	return original.NewTopologyClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopologyListIterator(page TopologyListPage) TopologyListIterator {
	return original.NewTopologyListIterator(page)
}
func NewTopologyListPage(cur TopologyList, getNextPage func(context.Context, TopologyList) (TopologyList, error)) TopologyListPage {
	return original.NewTopologyListPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceSettingListIterator(page WorkspaceSettingListPage) WorkspaceSettingListIterator {
	return original.NewWorkspaceSettingListIterator(page)
}
func NewWorkspaceSettingListPage(cur WorkspaceSettingList, getNextPage func(context.Context, WorkspaceSettingList) (WorkspaceSettingList, error)) WorkspaceSettingListPage {
	return original.NewWorkspaceSettingListPage(cur, getNextPage)
}
func NewWorkspaceSettingsClient(subscriptionID string) WorkspaceSettingsClient {
	return original.NewWorkspaceSettingsClient(subscriptionID)
}
func NewWorkspaceSettingsClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceSettingsClient {
	return original.NewWorkspaceSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleAadConnectivityStateValues() []AadConnectivityState {
	return original.PossibleAadConnectivityStateValues()
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleActionValues() []Action {
	return original.PossibleActionValues()
}
func PossibleAdditionalWorkspaceDataTypeValues() []AdditionalWorkspaceDataType {
	return original.PossibleAdditionalWorkspaceDataTypeValues()
}
func PossibleAdditionalWorkspaceTypeValues() []AdditionalWorkspaceType {
	return original.PossibleAdditionalWorkspaceTypeValues()
}
func PossibleAlertSeverityValues() []AlertSeverity {
	return original.PossibleAlertSeverityValues()
}
func PossibleAlertStatusValues() []AlertStatus {
	return original.PossibleAlertStatusValues()
}
func PossibleApplicationConditionOperatorValues() []ApplicationConditionOperator {
	return original.PossibleApplicationConditionOperatorValues()
}
func PossibleAssessedResourceTypeValues() []AssessedResourceType {
	return original.PossibleAssessedResourceTypeValues()
}
func PossibleAssessmentStatusCodeValues() []AssessmentStatusCode {
	return original.PossibleAssessmentStatusCodeValues()
}
func PossibleAssessmentTypeValues() []AssessmentType {
	return original.PossibleAssessmentTypeValues()
}
func PossibleAuthenticationProvisioningStateValues() []AuthenticationProvisioningState {
	return original.PossibleAuthenticationProvisioningStateValues()
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleAutoProvisionValues() []AutoProvision {
	return original.PossibleAutoProvisionValues()
}
func PossibleBundleTypeValues() []BundleType {
	return original.PossibleBundleTypeValues()
}
func PossibleCategoriesValues() []Categories {
	return original.PossibleCategoriesValues()
}
func PossibleCloudNameValues() []CloudName {
	return original.PossibleCloudNameValues()
}
func PossibleConfigurationStatus1Values() []ConfigurationStatus1 {
	return original.PossibleConfigurationStatus1Values()
}
func PossibleConfigurationStatus2Values() []ConfigurationStatus2 {
	return original.PossibleConfigurationStatus2Values()
}
func PossibleConfigurationStatusValues() []ConfigurationStatus {
	return original.PossibleConfigurationStatusValues()
}
func PossibleConnectionTypeValues() []ConnectionType {
	return original.PossibleConnectionTypeValues()
}
func PossibleControlTypeValues() []ControlType {
	return original.PossibleControlTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDataSourceValues() []DataSource {
	return original.PossibleDataSourceValues()
}
func PossibleDirectionValues() []Direction {
	return original.PossibleDirectionValues()
}
func PossibleEndOfSupportStatusValues() []EndOfSupportStatus {
	return original.PossibleEndOfSupportStatusValues()
}
func PossibleEnforcementModeValues() []EnforcementMode {
	return original.PossibleEnforcementModeValues()
}
func PossibleEnforcementSupportValues() []EnforcementSupport {
	return original.PossibleEnforcementSupportValues()
}
func PossibleEnvironmentTypeValues() []EnvironmentType {
	return original.PossibleEnvironmentTypeValues()
}
func PossibleEventSourceValues() []EventSource {
	return original.PossibleEventSourceValues()
}
func PossibleExeValues() []Exe {
	return original.PossibleExeValues()
}
func PossibleExecutableValues() []Executable {
	return original.PossibleExecutableValues()
}
func PossibleExpandControlsEnumValues() []ExpandControlsEnum {
	return original.PossibleExpandControlsEnumValues()
}
func PossibleExpandEnumValues() []ExpandEnum {
	return original.PossibleExpandEnumValues()
}
func PossibleExportDataValues() []ExportData {
	return original.PossibleExportDataValues()
}
func PossibleExternalSecuritySolutionKindValues() []ExternalSecuritySolutionKind {
	return original.PossibleExternalSecuritySolutionKindValues()
}
func PossibleFamilyValues() []Family {
	return original.PossibleFamilyValues()
}
func PossibleFileTypeValues() []FileType {
	return original.PossibleFileTypeValues()
}
func PossibleGovernanceRuleConditionOperatorValues() []GovernanceRuleConditionOperator {
	return original.PossibleGovernanceRuleConditionOperatorValues()
}
func PossibleGovernanceRuleOwnerSourceTypeValues() []GovernanceRuleOwnerSourceType {
	return original.PossibleGovernanceRuleOwnerSourceTypeValues()
}
func PossibleGovernanceRuleTypeValues() []GovernanceRuleType {
	return original.PossibleGovernanceRuleTypeValues()
}
func PossibleHybridComputeProvisioningStateValues() []HybridComputeProvisioningState {
	return original.PossibleHybridComputeProvisioningStateValues()
}
func PossibleImplementationEffortValues() []ImplementationEffort {
	return original.PossibleImplementationEffortValues()
}
func PossibleInformationProtectionPolicyNameValues() []InformationProtectionPolicyName {
	return original.PossibleInformationProtectionPolicyNameValues()
}
func PossibleIntentValues() []Intent {
	return original.PossibleIntentValues()
}
func PossibleIssueValues() []Issue {
	return original.PossibleIssueValues()
}
func PossibleKindEnum1Values() []KindEnum1 {
	return original.PossibleKindEnum1Values()
}
func PossibleKindEnum2Values() []KindEnum2 {
	return original.PossibleKindEnum2Values()
}
func PossibleKindEnumValues() []KindEnum {
	return original.PossibleKindEnumValues()
}
func PossibleMinimalSeverityValues() []MinimalSeverity {
	return original.PossibleMinimalSeverityValues()
}
func PossibleMsiValues() []Msi {
	return original.PossibleMsiValues()
}
func PossibleOfferingTypeValues() []OfferingType {
	return original.PossibleOfferingTypeValues()
}
func PossibleOperatorValues() []Operator {
	return original.PossibleOperatorValues()
}
func PossibleOrganizationMembershipTypeBasicGcpOrganizationalDataValues() []OrganizationMembershipTypeBasicGcpOrganizationalData {
	return original.PossibleOrganizationMembershipTypeBasicGcpOrganizationalDataValues()
}
func PossibleOrganizationMembershipTypeValues() []OrganizationMembershipType {
	return original.PossibleOrganizationMembershipTypeValues()
}
func PossiblePermissionPropertyValues() []PermissionProperty {
	return original.PossiblePermissionPropertyValues()
}
func PossiblePricingTierValues() []PricingTier {
	return original.PossiblePricingTierValues()
}
func PossiblePropertyTypeValues() []PropertyType {
	return original.PossiblePropertyTypeValues()
}
func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return original.PossibleProvisioningState1Values()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleRankValues() []Rank {
	return original.PossibleRankValues()
}
func PossibleRecommendationAction1Values() []RecommendationAction1 {
	return original.PossibleRecommendationAction1Values()
}
func PossibleRecommendationActionValues() []RecommendationAction {
	return original.PossibleRecommendationActionValues()
}
func PossibleRecommendationConfigStatusValues() []RecommendationConfigStatus {
	return original.PossibleRecommendationConfigStatusValues()
}
func PossibleRecommendationStatusValues() []RecommendationStatus {
	return original.PossibleRecommendationStatusValues()
}
func PossibleRecommendationTypeValues() []RecommendationType {
	return original.PossibleRecommendationTypeValues()
}
func PossibleReportedSeverityValues() []ReportedSeverity {
	return original.PossibleReportedSeverityValues()
}
func PossibleResourceStatusValues() []ResourceStatus {
	return original.PossibleResourceStatusValues()
}
func PossibleRolesValues() []Roles {
	return original.PossibleRolesValues()
}
func PossibleRuleSeverityValues() []RuleSeverity {
	return original.PossibleRuleSeverityValues()
}
func PossibleRuleStateValues() []RuleState {
	return original.PossibleRuleStateValues()
}
func PossibleRuleStatusValues() []RuleStatus {
	return original.PossibleRuleStatusValues()
}
func PossibleRuleTypeBasicCustomAlertRuleValues() []RuleTypeBasicCustomAlertRule {
	return original.PossibleRuleTypeBasicCustomAlertRuleValues()
}
func PossibleRuleTypeValues() []RuleType {
	return original.PossibleRuleTypeValues()
}
func PossibleScanStateValues() []ScanState {
	return original.PossibleScanStateValues()
}
func PossibleScanTriggerTypeValues() []ScanTriggerType {
	return original.PossibleScanTriggerTypeValues()
}
func PossibleScanningModeValues() []ScanningMode {
	return original.PossibleScanningModeValues()
}
func PossibleScriptValues() []Script {
	return original.PossibleScriptValues()
}
func PossibleSettingName2Values() []SettingName2 {
	return original.PossibleSettingName2Values()
}
func PossibleSettingName4Values() []SettingName4 {
	return original.PossibleSettingName4Values()
}
func PossibleSettingName5Values() []SettingName5 {
	return original.PossibleSettingName5Values()
}
func PossibleSeverityEnumValues() []SeverityEnum {
	return original.PossibleSeverityEnumValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleSolutionStatusValues() []SolutionStatus {
	return original.PossibleSolutionStatusValues()
}
func PossibleSourceSystemValues() []SourceSystem {
	return original.PossibleSourceSystemValues()
}
func PossibleSourceValues() []Source {
	return original.PossibleSourceValues()
}
func PossibleStateForAlertNotificationsValues() []StateForAlertNotifications {
	return original.PossibleStateForAlertNotificationsValues()
}
func PossibleStateForNotificationsByRoleValues() []StateForNotificationsByRole {
	return original.PossibleStateForNotificationsByRoleValues()
}
func PossibleStateValues() []State {
	return original.PossibleStateValues()
}
func PossibleStatusReasonValues() []StatusReason {
	return original.PossibleStatusReasonValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func PossibleSubAssessmentStatusCodeValues() []SubAssessmentStatusCode {
	return original.PossibleSubAssessmentStatusCodeValues()
}
func PossibleSubPlanValues() []SubPlan {
	return original.PossibleSubPlanValues()
}
func PossibleSupportedCloudEnumValues() []SupportedCloudEnum {
	return original.PossibleSupportedCloudEnumValues()
}
func PossibleTacticsValues() []Tactics {
	return original.PossibleTacticsValues()
}
func PossibleTaskUpdateActionTypeValues() []TaskUpdateActionType {
	return original.PossibleTaskUpdateActionTypeValues()
}
func PossibleTechniquesValues() []Techniques {
	return original.PossibleTechniquesValues()
}
func PossibleThreatsValues() []Threats {
	return original.PossibleThreatsValues()
}
func PossibleTransportProtocolValues() []TransportProtocol {
	return original.PossibleTransportProtocolValues()
}
func PossibleType1Values() []Type1 {
	return original.PossibleType1Values()
}
func PossibleTypeBasicResourceIdentifierValues() []TypeBasicResourceIdentifier {
	return original.PossibleTypeBasicResourceIdentifierValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleUnmaskedIPLoggingStatusValues() []UnmaskedIPLoggingStatus {
	return original.PossibleUnmaskedIPLoggingStatusValues()
}
func PossibleUserImpactValues() []UserImpact {
	return original.PossibleUserImpactValues()
}
func PossibleValueTypeValues() []ValueType {
	return original.PossibleValueTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
