//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package digitaltwins

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/digitaltwins/2020-05-31-preview/digitaltwins"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type Client = original.Client
type Error = original.Error
type ErrorResponse = original.ErrorResponse
type EventRoute = original.EventRoute
type EventRouteCollection = original.EventRouteCollection
type EventRouteCollectionIterator = original.EventRouteCollectionIterator
type EventRouteCollectionPage = original.EventRouteCollectionPage
type EventRoutesClient = original.EventRoutesClient
type IncomingRelationship = original.IncomingRelationship
type IncomingRelationshipCollection = original.IncomingRelationshipCollection
type IncomingRelationshipCollectionIterator = original.IncomingRelationshipCollectionIterator
type IncomingRelationshipCollectionPage = original.IncomingRelationshipCollectionPage
type InnerError = original.InnerError
type ListModelData = original.ListModelData
type ModelData = original.ModelData
type ModelsClient = original.ModelsClient
type PagedModelDataCollection = original.PagedModelDataCollection
type PagedModelDataCollectionIterator = original.PagedModelDataCollectionIterator
type PagedModelDataCollectionPage = original.PagedModelDataCollectionPage
type QueryClient = original.QueryClient
type QueryResult = original.QueryResult
type QuerySpecification = original.QuerySpecification
type RelationshipCollection = original.RelationshipCollection
type RelationshipCollectionIterator = original.RelationshipCollectionIterator
type RelationshipCollectionPage = original.RelationshipCollectionPage
type SetObject = original.SetObject

func New() BaseClient {
	return original.New()
}
func NewClient() Client {
	return original.NewClient()
}
func NewClientWithBaseURI(baseURI string) Client {
	return original.NewClientWithBaseURI(baseURI)
}
func NewEventRouteCollectionIterator(page EventRouteCollectionPage) EventRouteCollectionIterator {
	return original.NewEventRouteCollectionIterator(page)
}
func NewEventRouteCollectionPage(cur EventRouteCollection, getNextPage func(context.Context, EventRouteCollection) (EventRouteCollection, error)) EventRouteCollectionPage {
	return original.NewEventRouteCollectionPage(cur, getNextPage)
}
func NewEventRoutesClient() EventRoutesClient {
	return original.NewEventRoutesClient()
}
func NewEventRoutesClientWithBaseURI(baseURI string) EventRoutesClient {
	return original.NewEventRoutesClientWithBaseURI(baseURI)
}
func NewIncomingRelationshipCollectionIterator(page IncomingRelationshipCollectionPage) IncomingRelationshipCollectionIterator {
	return original.NewIncomingRelationshipCollectionIterator(page)
}
func NewIncomingRelationshipCollectionPage(cur IncomingRelationshipCollection, getNextPage func(context.Context, IncomingRelationshipCollection) (IncomingRelationshipCollection, error)) IncomingRelationshipCollectionPage {
	return original.NewIncomingRelationshipCollectionPage(cur, getNextPage)
}
func NewModelsClient() ModelsClient {
	return original.NewModelsClient()
}
func NewModelsClientWithBaseURI(baseURI string) ModelsClient {
	return original.NewModelsClientWithBaseURI(baseURI)
}
func NewPagedModelDataCollectionIterator(page PagedModelDataCollectionPage) PagedModelDataCollectionIterator {
	return original.NewPagedModelDataCollectionIterator(page)
}
func NewPagedModelDataCollectionPage(cur PagedModelDataCollection, getNextPage func(context.Context, PagedModelDataCollection) (PagedModelDataCollection, error)) PagedModelDataCollectionPage {
	return original.NewPagedModelDataCollectionPage(cur, getNextPage)
}
func NewQueryClient() QueryClient {
	return original.NewQueryClient()
}
func NewQueryClientWithBaseURI(baseURI string) QueryClient {
	return original.NewQueryClientWithBaseURI(baseURI)
}
func NewRelationshipCollectionIterator(page RelationshipCollectionPage) RelationshipCollectionIterator {
	return original.NewRelationshipCollectionIterator(page)
}
func NewRelationshipCollectionPage(cur RelationshipCollection, getNextPage func(context.Context, RelationshipCollection) (RelationshipCollection, error)) RelationshipCollectionPage {
	return original.NewRelationshipCollectionPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
