// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideosignalingchannels

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opGetIceServerConfig = "GetIceServerConfig"

// GetIceServerConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetIceServerConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIceServerConfig for more information on using the GetIceServerConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIceServerConfigRequest method.
//	req, resp := client.GetIceServerConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-signaling-2019-12-04/GetIceServerConfig
func (c *KinesisVideoSignalingChannels) GetIceServerConfigRequest(input *GetIceServerConfigInput) (req *request.Request, output *GetIceServerConfigOutput) {
	op := &request.Operation{
		Name:       opGetIceServerConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/get-ice-server-config",
	}

	if input == nil {
		input = &GetIceServerConfigInput{}
	}

	output = &GetIceServerConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIceServerConfig API operation for Amazon Kinesis Video Signaling Channels.
//
// Gets the Interactive Connectivity Establishment (ICE) server configuration
// information, including URIs, username, and password which can be used to
// configure the WebRTC connection. The ICE component uses this configuration
// information to setup the WebRTC connection, including authenticating with
// the Traversal Using Relays around NAT (TURN) relay server.
//
// TURN is a protocol that is used to improve the connectivity of peer-to-peer
// applications. By providing a cloud-based relay service, TURN ensures that
// a connection can be established even when one or more peers are incapable
// of a direct peer-to-peer connection. For more information, see A REST API
// For Access To TURN Services (https://tools.ietf.org/html/draft-uberti-rtcweb-turn-rest-00).
//
// You can invoke this API to establish a fallback mechanism in case either
// of the peers is unable to establish a direct peer-to-peer connection over
// a signaling channel. You must specify either a signaling channel ARN or the
// client ID in order to invoke this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Signaling Channels's
// API operation GetIceServerConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidClientException
//     The specified client is invalid.
//
//   - SessionExpiredException
//     If the client session is expired. Once the client is connected, the session
//     is valid for 45 minutes. Client should reconnect to the channel to continue
//     sending/receiving messages.
//
//   - ClientLimitExceededException
//     Your request was throttled because you have exceeded the limit of allowed
//     client calls. Try making the call later.
//
//   - ResourceNotFoundException
//     The specified resource is not found.
//
//   - InvalidArgumentException
//     The value for this input parameter is invalid.
//
//   - NotAuthorizedException
//     The caller is not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-signaling-2019-12-04/GetIceServerConfig
func (c *KinesisVideoSignalingChannels) GetIceServerConfig(input *GetIceServerConfigInput) (*GetIceServerConfigOutput, error) {
	req, out := c.GetIceServerConfigRequest(input)
	return out, req.Send()
}

// GetIceServerConfigWithContext is the same as GetIceServerConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetIceServerConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideoSignalingChannels) GetIceServerConfigWithContext(ctx aws.Context, input *GetIceServerConfigInput, opts ...request.Option) (*GetIceServerConfigOutput, error) {
	req, out := c.GetIceServerConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendAlexaOfferToMaster = "SendAlexaOfferToMaster"

// SendAlexaOfferToMasterRequest generates a "aws/request.Request" representing the
// client's request for the SendAlexaOfferToMaster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendAlexaOfferToMaster for more information on using the SendAlexaOfferToMaster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendAlexaOfferToMasterRequest method.
//	req, resp := client.SendAlexaOfferToMasterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-signaling-2019-12-04/SendAlexaOfferToMaster
func (c *KinesisVideoSignalingChannels) SendAlexaOfferToMasterRequest(input *SendAlexaOfferToMasterInput) (req *request.Request, output *SendAlexaOfferToMasterOutput) {
	op := &request.Operation{
		Name:       opSendAlexaOfferToMaster,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/send-alexa-offer-to-master",
	}

	if input == nil {
		input = &SendAlexaOfferToMasterInput{}
	}

	output = &SendAlexaOfferToMasterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendAlexaOfferToMaster API operation for Amazon Kinesis Video Signaling Channels.
//
// This API allows you to connect WebRTC-enabled devices with Alexa display
// devices. When invoked, it sends the Alexa Session Description Protocol (SDP)
// offer to the master peer. The offer is delivered as soon as the master is
// connected to the specified signaling channel. This API returns the SDP answer
// from the connected master. If the master is not connected to the signaling
// channel, redelivery requests are made until the message expires.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Signaling Channels's
// API operation SendAlexaOfferToMaster for usage and error information.
//
// Returned Error Types:
//
//   - ClientLimitExceededException
//     Your request was throttled because you have exceeded the limit of allowed
//     client calls. Try making the call later.
//
//   - ResourceNotFoundException
//     The specified resource is not found.
//
//   - InvalidArgumentException
//     The value for this input parameter is invalid.
//
//   - NotAuthorizedException
//     The caller is not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-signaling-2019-12-04/SendAlexaOfferToMaster
func (c *KinesisVideoSignalingChannels) SendAlexaOfferToMaster(input *SendAlexaOfferToMasterInput) (*SendAlexaOfferToMasterOutput, error) {
	req, out := c.SendAlexaOfferToMasterRequest(input)
	return out, req.Send()
}

// SendAlexaOfferToMasterWithContext is the same as SendAlexaOfferToMaster with the addition of
// the ability to pass a context and additional request options.
//
// See SendAlexaOfferToMaster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideoSignalingChannels) SendAlexaOfferToMasterWithContext(ctx aws.Context, input *SendAlexaOfferToMasterInput, opts ...request.Option) (*SendAlexaOfferToMasterOutput, error) {
	req, out := c.SendAlexaOfferToMasterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Your request was throttled because you have exceeded the limit of allowed
// client calls. Try making the call later.
type ClientLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientLimitExceededException) GoString() string {
	return s.String()
}

func newErrorClientLimitExceededException(v protocol.ResponseMetadata) error {
	return &ClientLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientLimitExceededException) Code() string {
	return "ClientLimitExceededException"
}

// Message returns the exception's message.
func (s *ClientLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientLimitExceededException) OrigErr() error {
	return nil
}

func (s *ClientLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetIceServerConfigInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the signaling channel to be used for the peer-to-peer connection
	// between configured peers.
	//
	// ChannelARN is a required field
	ChannelARN *string `min:"1" type:"string" required:"true"`

	// Unique identifier for the viewer. Must be unique within the signaling channel.
	ClientId *string `min:"1" type:"string"`

	// Specifies the desired service. Currently, TURN is the only valid value.
	Service *string `type:"string" enum:"Service"`

	// An optional user ID to be associated with the credentials.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIceServerConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIceServerConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIceServerConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIceServerConfigInput"}
	if s.ChannelARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelARN"))
	}
	if s.ChannelARN != nil && len(*s.ChannelARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelARN", 1))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelARN sets the ChannelARN field's value.
func (s *GetIceServerConfigInput) SetChannelARN(v string) *GetIceServerConfigInput {
	s.ChannelARN = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *GetIceServerConfigInput) SetClientId(v string) *GetIceServerConfigInput {
	s.ClientId = &v
	return s
}

// SetService sets the Service field's value.
func (s *GetIceServerConfigInput) SetService(v string) *GetIceServerConfigInput {
	s.Service = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *GetIceServerConfigInput) SetUsername(v string) *GetIceServerConfigInput {
	s.Username = &v
	return s
}

type GetIceServerConfigOutput struct {
	_ struct{} `type:"structure"`

	// The list of ICE server information objects.
	IceServerList []*IceServer `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIceServerConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIceServerConfigOutput) GoString() string {
	return s.String()
}

// SetIceServerList sets the IceServerList field's value.
func (s *GetIceServerConfigOutput) SetIceServerList(v []*IceServer) *GetIceServerConfigOutput {
	s.IceServerList = v
	return s
}

// A structure for the ICE server connection data.
type IceServer struct {
	_ struct{} `type:"structure"`

	// A password to login to the ICE server.
	Password *string `min:"1" type:"string"`

	// The period of time, in seconds, during which the username and password are
	// valid.
	Ttl *int64 `min:"30" type:"integer"`

	// An array of URIs, in the form specified in the I-D.petithuguenin-behave-turn-uris
	// (https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03) spec.
	// These URIs provide the different addresses and/or protocols that can be used
	// to reach the TURN server.
	Uris []*string `type:"list"`

	// A username to login to the ICE server.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IceServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IceServer) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *IceServer) SetPassword(v string) *IceServer {
	s.Password = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *IceServer) SetTtl(v int64) *IceServer {
	s.Ttl = &v
	return s
}

// SetUris sets the Uris field's value.
func (s *IceServer) SetUris(v []*string) *IceServer {
	s.Uris = v
	return s
}

// SetUsername sets the Username field's value.
func (s *IceServer) SetUsername(v string) *IceServer {
	s.Username = &v
	return s
}

// The value for this input parameter is invalid.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified client is invalid.
type InvalidClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidClientException) GoString() string {
	return s.String()
}

func newErrorInvalidClientException(v protocol.ResponseMetadata) error {
	return &InvalidClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidClientException) Code() string {
	return "InvalidClientException"
}

// Message returns the exception's message.
func (s *InvalidClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidClientException) OrigErr() error {
	return nil
}

func (s *InvalidClientException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The caller is not authorized to perform this operation.
type NotAuthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) GoString() string {
	return s.String()
}

func newErrorNotAuthorizedException(v protocol.ResponseMetadata) error {
	return &NotAuthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotAuthorizedException) Code() string {
	return "NotAuthorizedException"
}

// Message returns the exception's message.
func (s *NotAuthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotAuthorizedException) OrigErr() error {
	return nil
}

func (s *NotAuthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotAuthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotAuthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SendAlexaOfferToMasterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the signaling channel by which Alexa and the master peer communicate.
	//
	// ChannelARN is a required field
	ChannelARN *string `min:"1" type:"string" required:"true"`

	// The base64-encoded SDP offer content.
	//
	// MessagePayload is a required field
	MessagePayload *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the sender client.
	//
	// SenderClientId is a required field
	SenderClientId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAlexaOfferToMasterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAlexaOfferToMasterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendAlexaOfferToMasterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendAlexaOfferToMasterInput"}
	if s.ChannelARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelARN"))
	}
	if s.ChannelARN != nil && len(*s.ChannelARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelARN", 1))
	}
	if s.MessagePayload == nil {
		invalidParams.Add(request.NewErrParamRequired("MessagePayload"))
	}
	if s.MessagePayload != nil && len(*s.MessagePayload) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessagePayload", 1))
	}
	if s.SenderClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("SenderClientId"))
	}
	if s.SenderClientId != nil && len(*s.SenderClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SenderClientId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelARN sets the ChannelARN field's value.
func (s *SendAlexaOfferToMasterInput) SetChannelARN(v string) *SendAlexaOfferToMasterInput {
	s.ChannelARN = &v
	return s
}

// SetMessagePayload sets the MessagePayload field's value.
func (s *SendAlexaOfferToMasterInput) SetMessagePayload(v string) *SendAlexaOfferToMasterInput {
	s.MessagePayload = &v
	return s
}

// SetSenderClientId sets the SenderClientId field's value.
func (s *SendAlexaOfferToMasterInput) SetSenderClientId(v string) *SendAlexaOfferToMasterInput {
	s.SenderClientId = &v
	return s
}

type SendAlexaOfferToMasterOutput struct {
	_ struct{} `type:"structure"`

	// The base64-encoded SDP answer content.
	Answer *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAlexaOfferToMasterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAlexaOfferToMasterOutput) GoString() string {
	return s.String()
}

// SetAnswer sets the Answer field's value.
func (s *SendAlexaOfferToMasterOutput) SetAnswer(v string) *SendAlexaOfferToMasterOutput {
	s.Answer = &v
	return s
}

// If the client session is expired. Once the client is connected, the session
// is valid for 45 minutes. Client should reconnect to the channel to continue
// sending/receiving messages.
type SessionExpiredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionExpiredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionExpiredException) GoString() string {
	return s.String()
}

func newErrorSessionExpiredException(v protocol.ResponseMetadata) error {
	return &SessionExpiredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SessionExpiredException) Code() string {
	return "SessionExpiredException"
}

// Message returns the exception's message.
func (s *SessionExpiredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SessionExpiredException) OrigErr() error {
	return nil
}

func (s *SessionExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SessionExpiredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SessionExpiredException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ServiceTurn is a Service enum value
	ServiceTurn = "TURN"
)

// Service_Values returns all elements of the Service enum
func Service_Values() []string {
	return []string{
		ServiceTurn,
	}
}
