// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package dlmiface provides an interface to enable mocking the Amazon Data Lifecycle Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package dlmiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/dlm"
)

// DLMAPI provides an interface to enable mocking the
// dlm.DLM service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Data Lifecycle Manager.
//	func myFunc(svc dlmiface.DLMAPI) bool {
//	    // Make svc.CreateLifecyclePolicy request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := dlm.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockDLMClient struct {
//	    dlmiface.DLMAPI
//	}
//	func (m *mockDLMClient) CreateLifecyclePolicy(input *dlm.CreateLifecyclePolicyInput) (*dlm.CreateLifecyclePolicyOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockDLMClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type DLMAPI interface {
	CreateLifecyclePolicy(*dlm.CreateLifecyclePolicyInput) (*dlm.CreateLifecyclePolicyOutput, error)
	CreateLifecyclePolicyWithContext(aws.Context, *dlm.CreateLifecyclePolicyInput, ...request.Option) (*dlm.CreateLifecyclePolicyOutput, error)
	CreateLifecyclePolicyRequest(*dlm.CreateLifecyclePolicyInput) (*request.Request, *dlm.CreateLifecyclePolicyOutput)

	DeleteLifecyclePolicy(*dlm.DeleteLifecyclePolicyInput) (*dlm.DeleteLifecyclePolicyOutput, error)
	DeleteLifecyclePolicyWithContext(aws.Context, *dlm.DeleteLifecyclePolicyInput, ...request.Option) (*dlm.DeleteLifecyclePolicyOutput, error)
	DeleteLifecyclePolicyRequest(*dlm.DeleteLifecyclePolicyInput) (*request.Request, *dlm.DeleteLifecyclePolicyOutput)

	GetLifecyclePolicies(*dlm.GetLifecyclePoliciesInput) (*dlm.GetLifecyclePoliciesOutput, error)
	GetLifecyclePoliciesWithContext(aws.Context, *dlm.GetLifecyclePoliciesInput, ...request.Option) (*dlm.GetLifecyclePoliciesOutput, error)
	GetLifecyclePoliciesRequest(*dlm.GetLifecyclePoliciesInput) (*request.Request, *dlm.GetLifecyclePoliciesOutput)

	GetLifecyclePolicy(*dlm.GetLifecyclePolicyInput) (*dlm.GetLifecyclePolicyOutput, error)
	GetLifecyclePolicyWithContext(aws.Context, *dlm.GetLifecyclePolicyInput, ...request.Option) (*dlm.GetLifecyclePolicyOutput, error)
	GetLifecyclePolicyRequest(*dlm.GetLifecyclePolicyInput) (*request.Request, *dlm.GetLifecyclePolicyOutput)

	ListTagsForResource(*dlm.ListTagsForResourceInput) (*dlm.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *dlm.ListTagsForResourceInput, ...request.Option) (*dlm.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*dlm.ListTagsForResourceInput) (*request.Request, *dlm.ListTagsForResourceOutput)

	TagResource(*dlm.TagResourceInput) (*dlm.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *dlm.TagResourceInput, ...request.Option) (*dlm.TagResourceOutput, error)
	TagResourceRequest(*dlm.TagResourceInput) (*request.Request, *dlm.TagResourceOutput)

	UntagResource(*dlm.UntagResourceInput) (*dlm.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *dlm.UntagResourceInput, ...request.Option) (*dlm.UntagResourceOutput, error)
	UntagResourceRequest(*dlm.UntagResourceInput) (*request.Request, *dlm.UntagResourceOutput)

	UpdateLifecyclePolicy(*dlm.UpdateLifecyclePolicyInput) (*dlm.UpdateLifecyclePolicyOutput, error)
	UpdateLifecyclePolicyWithContext(aws.Context, *dlm.UpdateLifecyclePolicyInput, ...request.Option) (*dlm.UpdateLifecyclePolicyOutput, error)
	UpdateLifecyclePolicyRequest(*dlm.UpdateLifecyclePolicyInput) (*request.Request, *dlm.UpdateLifecyclePolicyOutput)
}

var _ DLMAPI = (*dlm.DLM)(nil)
