// SPDX-FileCopyrightText: 2025 Mahjongg Contributors
// SPDX-License-Identifier: GPL-2.0-or-later

private void test_slot () {
    var x = 1;
    var y = 2;
    var layer = 3;
    var slot_a = new Slot (x, y, layer);
    var slot_b = new Slot (x, y, layer);
    var slot_c = new Slot (x + 1, y, layer);

    assert_true (slot_a.x == x);
    assert_true (slot_a.y == y);
    assert_true (slot_a.layer == layer);
    assert_true (slot_a.equals (slot_b));
    assert_false (slot_b.equals (slot_c));
}

private void verify_slots (Map map, int[,] expected_layout) {
    assert_true (map.n_slots == 144);

    for (int i = 0; i < map.n_slots; i++) {
        var slot = map.get_slot (i);
        assert_true (slot.x == expected_layout[i, 0]);
        assert_true (slot.y == expected_layout[i, 1]);
        assert_true (slot.layer == expected_layout[i, 2]);
    }
}

private void test_load_maps () {
    var maps = new Maps ();
    maps.load ();
    assert_true (maps.n_maps == 10);

    var score_name = "easy";
    var display_name = maps.get_map_display_name (score_name);
    unowned var map = maps.get_map_by_name (display_name);
    unowned var first_map = map;
    assert_true (map.name == display_name == "Turtle");
    assert_true (map.score_name == score_name);
    assert_true (map.width == 30);
    assert_true (map.height == 16);
    assert_true (map.h_overhang == 0);
    assert_true (map.v_overhang == 0);
    verify_slots (
        map,
        {
            {24, 0, 0},
            {22, 0, 0},
            {28, 7, 0},
            {20, 0, 0},
            {26, 7, 0},
            {18, 0, 0},
            {20, 2, 0},
            {22, 4, 0},
            {24, 6, 0},
            {16, 0, 0},
            {18, 2, 0},
            {20, 4, 0},
            {22, 6, 0},
            {24, 8, 0},
            {14, 0, 0},
            {16, 2, 0},
            {18, 4, 0},
            {20, 6, 0},
            {22, 8, 0},
            {12, 0, 0},
            {14, 2, 0},
            {16, 4, 0},
            {18, 6, 0},
            {20, 8, 0},
            {22, 10, 0},
            {10, 0, 0},
            {12, 2, 0},
            {14, 4, 0},
            {16, 6, 0},
            {18, 8, 0},
            {20, 10, 0},
            {24, 14, 0},
            {8, 0, 0},
            {10, 2, 0},
            {12, 4, 0},
            {14, 6, 0},
            {16, 8, 0},
            {18, 10, 0},
            {20, 12, 0},
            {22, 14, 0},
            {6, 0, 0},
            {8, 2, 0},
            {10, 4, 0},
            {12, 6, 0},
            {14, 8, 0},
            {16, 10, 0},
            {18, 12, 0},
            {20, 14, 0},
            {4, 0, 0},
            {6, 2, 0},
            {8, 4, 0},
            {10, 6, 0},
            {12, 8, 0},
            {14, 10, 0},
            {16, 12, 0},
            {18, 14, 0},
            {2, 0, 0},
            {6, 4, 0},
            {8, 6, 0},
            {10, 8, 0},
            {12, 10, 0},
            {14, 12, 0},
            {16, 14, 0},
            {4, 4, 0},
            {6, 6, 0},
            {8, 8, 0},
            {10, 10, 0},
            {12, 12, 0},
            {14, 14, 0},
            {4, 6, 0},
            {6, 8, 0},
            {8, 10, 0},
            {10, 12, 0},
            {12, 14, 0},
            {2, 6, 0},
            {4, 8, 0},
            {6, 10, 0},
            {8, 12, 0},
            {10, 14, 0},
            {2, 8, 0},
            {4, 10, 0},
            {6, 12, 0},
            {8, 14, 0},
            {0, 7, 0},
            {6, 14, 0},
            {4, 14, 0},
            {2, 14, 0},
            {18, 2, 1},
            {16, 2, 1},
            {18, 4, 1},
            {14, 2, 1},
            {16, 4, 1},
            {18, 6, 1},
            {12, 2, 1},
            {14, 4, 1},
            {16, 6, 1},
            {18, 8, 1},
            {10, 2, 1},
            {12, 4, 1},
            {14, 6, 1},
            {16, 8, 1},
            {18, 10, 1},
            {8, 2, 1},
            {10, 4, 1},
            {12, 6, 1},
            {14, 8, 1},
            {16, 10, 1},
            {18, 12, 1},
            {8, 4, 1},
            {10, 6, 1},
            {12, 8, 1},
            {14, 10, 1},
            {16, 12, 1},
            {8, 6, 1},
            {10, 8, 1},
            {12, 10, 1},
            {14, 12, 1},
            {8, 8, 1},
            {10, 10, 1},
            {12, 12, 1},
            {8, 10, 1},
            {10, 12, 1},
            {8, 12, 1},
            {16, 4, 2},
            {14, 4, 2},
            {16, 6, 2},
            {12, 4, 2},
            {14, 6, 2},
            {16, 8, 2},
            {10, 4, 2},
            {12, 6, 2},
            {14, 8, 2},
            {16, 10, 2},
            {10, 6, 2},
            {12, 8, 2},
            {14, 10, 2},
            {10, 8, 2},
            {12, 10, 2},
            {10, 10, 2},
            {14, 6, 3},
            {12, 6, 3},
            {14, 8, 3},
            {12, 8, 3},
            {13, 7, 4},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "The Ziggurat");
    assert_true (map.score_name == "ziggurat");
    assert_true (map.width == 30);
    assert_true (map.height == 16);
    assert_true (map.h_overhang == 0);
    assert_true (map.v_overhang == 0);
    verify_slots (
        map,
        {
            {28, 0, 0},
            {28, 2, 0},
            {28, 4, 0},
            {23, 0, 0},
            {28, 6, 0},
            {21, 0, 0},
            {23, 2, 0},
            {26, 6, 0},
            {28, 8, 0},
            {19, 0, 0},
            {23, 4, 0},
            {24, 6, 0},
            {26, 8, 0},
            {28, 10, 0},
            {17, 0, 0},
            {22, 6, 0},
            {24, 8, 0},
            {28, 12, 0},
            {15, 0, 0},
            {22, 8, 0},
            {28, 14, 0},
            {13, 0, 0},
            {15, 2, 0},
            {23, 10, 0},
            {11, 0, 0},
            {13, 2, 0},
            {15, 4, 0},
            {23, 12, 0},
            {9, 0, 0},
            {13, 4, 0},
            {23, 14, 0},
            {7, 0, 0},
            {21, 14, 0},
            {5, 0, 0},
            {15, 10, 0},
            {19, 14, 0},
            {5, 2, 0},
            {13, 10, 0},
            {15, 12, 0},
            {17, 14, 0},
            {5, 4, 0},
            {13, 12, 0},
            {15, 14, 0},
            {0, 0, 0},
            {6, 6, 0},
            {13, 14, 0},
            {0, 2, 0},
            {4, 6, 0},
            {6, 8, 0},
            {11, 14, 0},
            {0, 4, 0},
            {2, 6, 0},
            {4, 8, 0},
            {5, 10, 0},
            {9, 14, 0},
            {0, 6, 0},
            {2, 8, 0},
            {5, 12, 0},
            {7, 14, 0},
            {0, 8, 0},
            {5, 14, 0},
            {0, 10, 0},
            {0, 12, 0},
            {0, 14, 0},
            {22, 1, 1},
            {26, 6, 1},
            {24, 6, 1},
            {26, 8, 1},
            {22, 6, 1},
            {24, 8, 1},
            {22, 8, 1},
            {15, 2, 1},
            {13, 2, 1},
            {22, 13, 1},
            {6, 1, 1},
            {15, 12, 1},
            {13, 12, 1},
            {6, 6, 1},
            {4, 6, 1},
            {6, 8, 1},
            {2, 6, 1},
            {4, 8, 1},
            {2, 8, 1},
            {6, 13, 1},
            {22, 1, 2},
            {24, 6, 2},
            {22, 6, 2},
            {24, 8, 2},
            {20, 6, 2},
            {22, 8, 2},
            {14, 2, 2},
            {20, 8, 2},
            {22, 13, 2},
            {6, 1, 2},
            {8, 6, 2},
            {14, 12, 2},
            {6, 6, 2},
            {8, 8, 2},
            {4, 6, 2},
            {6, 8, 2},
            {4, 8, 2},
            {6, 13, 2},
            {22, 6, 3},
            {20, 6, 3},
            {22, 8, 3},
            {18, 6, 3},
            {20, 8, 3},
            {16, 6, 3},
            {18, 8, 3},
            {14, 6, 3},
            {16, 8, 3},
            {12, 6, 3},
            {14, 8, 3},
            {10, 6, 3},
            {12, 8, 3},
            {8, 6, 3},
            {10, 8, 3},
            {6, 6, 3},
            {8, 8, 3},
            {6, 8, 3},
            {20, 6, 4},
            {18, 6, 4},
            {20, 8, 4},
            {16, 6, 4},
            {18, 8, 4},
            {14, 6, 4},
            {16, 8, 4},
            {12, 6, 4},
            {14, 8, 4},
            {10, 6, 4},
            {12, 8, 4},
            {8, 6, 4},
            {10, 8, 4},
            {8, 8, 4},
            {18, 6, 5},
            {16, 6, 5},
            {18, 8, 5},
            {14, 6, 5},
            {16, 8, 5},
            {12, 6, 5},
            {14, 8, 5},
            {10, 6, 5},
            {12, 8, 5},
            {10, 8, 5},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "Four Bridges");
    assert_true (map.score_name == "bridges");
    assert_true (map.width == 26);
    assert_true (map.height == 18);
    assert_true (map.h_overhang == 0);
    assert_true (map.v_overhang == 0);
    verify_slots (
        map,
        {
            {22, 0, 0},
            {20, 0, 0},
            {18, 0, 0},
            {20, 2, 0},
            {24, 6, 0},
            {16, 0, 0},
            {18, 2, 0},
            {20, 4, 0},
            {22, 6, 0},
            {14, 0, 0},
            {16, 2, 0},
            {18, 4, 0},
            {20, 6, 0},
            {24, 10, 0},
            {21, 8, 0},
            {12, 0, 0},
            {14, 2, 0},
            {16, 4, 0},
            {18, 6, 0},
            {22, 10, 0},
            {19, 8, 0},
            {10, 0, 0},
            {14, 4, 0},
            {16, 6, 0},
            {20, 10, 0},
            {17, 8, 0},
            {8, 0, 0},
            {10, 2, 0},
            {12, 4, 0},
            {14, 6, 0},
            {18, 10, 0},
            {20, 12, 0},
            {6, 0, 0},
            {8, 2, 0},
            {10, 4, 0},
            {12, 6, 0},
            {16, 10, 0},
            {18, 12, 0},
            {20, 14, 0},
            {22, 16, 0},
            {4, 0, 0},
            {6, 2, 0},
            {8, 4, 0},
            {10, 6, 0},
            {14, 10, 0},
            {16, 12, 0},
            {18, 14, 0},
            {20, 16, 0},
            {2, 0, 0},
            {4, 2, 0},
            {6, 4, 0},
            {8, 6, 0},
            {12, 10, 0},
            {14, 12, 0},
            {16, 14, 0},
            {18, 16, 0},
            {4, 4, 0},
            {6, 6, 0},
            {10, 10, 0},
            {12, 12, 0},
            {14, 14, 0},
            {16, 16, 0},
            {7, 8, 0},
            {4, 6, 0},
            {8, 10, 0},
            {10, 12, 0},
            {14, 16, 0},
            {5, 8, 0},
            {2, 6, 0},
            {6, 10, 0},
            {8, 12, 0},
            {10, 14, 0},
            {12, 16, 0},
            {3, 8, 0},
            {0, 6, 0},
            {4, 10, 0},
            {6, 12, 0},
            {8, 14, 0},
            {10, 16, 0},
            {2, 10, 0},
            {4, 12, 0},
            {6, 14, 0},
            {8, 16, 0},
            {0, 10, 0},
            {4, 14, 0},
            {6, 16, 0},
            {4, 16, 0},
            {2, 16, 0},
            {19, 1, 1},
            {17, 1, 1},
            {19, 3, 1},
            {15, 1, 1},
            {17, 3, 1},
            {19, 5, 1},
            {15, 3, 1},
            {17, 5, 1},
            {15, 5, 1},
            {9, 1, 1},
            {19, 11, 1},
            {7, 1, 1},
            {9, 3, 1},
            {17, 11, 1},
            {19, 13, 1},
            {5, 1, 1},
            {7, 3, 1},
            {9, 5, 1},
            {15, 11, 1},
            {17, 13, 1},
            {19, 15, 1},
            {5, 3, 1},
            {7, 5, 1},
            {15, 13, 1},
            {17, 15, 1},
            {5, 5, 1},
            {15, 15, 1},
            {9, 11, 1},
            {7, 11, 1},
            {9, 13, 1},
            {5, 11, 1},
            {7, 13, 1},
            {9, 15, 1},
            {5, 13, 1},
            {7, 15, 1},
            {5, 15, 1},
            {18, 2, 2},
            {16, 2, 2},
            {18, 4, 2},
            {16, 4, 2},
            {8, 2, 2},
            {18, 12, 2},
            {6, 2, 2},
            {8, 4, 2},
            {16, 12, 2},
            {18, 14, 2},
            {6, 4, 2},
            {16, 14, 2},
            {8, 12, 2},
            {6, 12, 2},
            {8, 14, 2},
            {6, 14, 2},
            {17, 3, 3},
            {7, 3, 3},
            {17, 13, 3},
            {7, 13, 3},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "Cloud");
    assert_true (map.score_name == "cloud");
    assert_true (map.width == 28);
    assert_true (map.height == 13);
    assert_true (map.h_overhang == 0);
    assert_true (map.v_overhang == 2);
    verify_slots (
        map,
        {
            {26, 0, 0},
            {24, 0, 0},
            {26, 2, 0},
            {22, 0, 0},
            {24, 2, 0},
            {26, 4, 0},
            {20, 0, 0},
            {22, 2, 0},
            {24, 4, 0},
            {26, 6, 0},
            {18, 0, 0},
            {20, 2, 0},
            {22, 4, 0},
            {24, 6, 0},
            {26, 8, 0},
            {16, 0, 0},
            {18, 2, 0},
            {20, 4, 0},
            {22, 6, 0},
            {24, 8, 0},
            {14, 0, 0},
            {16, 2, 0},
            {18, 4, 0},
            {20, 6, 0},
            {22, 8, 0},
            {12, 0, 0},
            {14, 2, 0},
            {16, 4, 0},
            {18, 6, 0},
            {20, 8, 0},
            {10, 0, 0},
            {12, 2, 0},
            {14, 4, 0},
            {16, 6, 0},
            {18, 8, 0},
            {21, 11, 0},
            {8, 0, 0},
            {10, 2, 0},
            {12, 4, 0},
            {14, 6, 0},
            {16, 8, 0},
            {19, 11, 0},
            {6, 0, 0},
            {8, 2, 0},
            {10, 4, 0},
            {12, 6, 0},
            {14, 8, 0},
            {17, 11, 0},
            {4, 0, 0},
            {6, 2, 0},
            {8, 4, 0},
            {10, 6, 0},
            {12, 8, 0},
            {15, 11, 0},
            {2, 0, 0},
            {4, 2, 0},
            {6, 4, 0},
            {8, 6, 0},
            {10, 8, 0},
            {13, 11, 0},
            {0, 0, 0},
            {2, 2, 0},
            {4, 4, 0},
            {6, 6, 0},
            {8, 8, 0},
            {11, 11, 0},
            {0, 2, 0},
            {2, 4, 0},
            {4, 6, 0},
            {6, 8, 0},
            {9, 11, 0},
            {0, 4, 0},
            {2, 6, 0},
            {4, 8, 0},
            {7, 11, 0},
            {0, 6, 0},
            {2, 8, 0},
            {5, 11, 0},
            {0, 8, 0},
            {24, 0, 1},
            {24, 2, 1},
            {20, 0, 1},
            {24, 4, 1},
            {20, 2, 1},
            {24, 6, 1},
            {16, 0, 1},
            {20, 4, 1},
            {16, 2, 1},
            {20, 6, 1},
            {12, 0, 1},
            {16, 4, 1},
            {12, 2, 1},
            {16, 6, 1},
            {20, 11, 1},
            {8, 0, 1},
            {12, 4, 1},
            {18, 11, 1},
            {8, 2, 1},
            {12, 6, 1},
            {16, 11, 1},
            {4, 0, 1},
            {8, 4, 1},
            {14, 11, 1},
            {4, 2, 1},
            {8, 6, 1},
            {12, 11, 1},
            {0, 0, 1},
            {4, 4, 1},
            {10, 11, 1},
            {0, 2, 1},
            {4, 6, 1},
            {8, 11, 1},
            {0, 4, 1},
            {6, 11, 1},
            {0, 6, 1},
            {24, 0, 2},
            {24, 2, 2},
            {20, 0, 2},
            {24, 4, 2},
            {20, 2, 2},
            {24, 6, 2},
            {16, 0, 2},
            {20, 4, 2},
            {16, 2, 2},
            {20, 6, 2},
            {12, 0, 2},
            {16, 4, 2},
            {12, 2, 2},
            {16, 6, 2},
            {8, 0, 2},
            {12, 4, 2},
            {8, 2, 2},
            {12, 6, 2},
            {4, 0, 2},
            {8, 4, 2},
            {4, 2, 2},
            {8, 6, 2},
            {12, 11, 2},
            {0, 0, 2},
            {4, 4, 2},
            {0, 2, 2},
            {4, 6, 2},
            {0, 4, 2},
            {0, 6, 2},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "Tic-Tac-Toe");
    assert_true (map.score_name == "tictactoe");
    assert_true (map.width == 26);
    assert_true (map.height == 18);
    assert_true (map.h_overhang == 0);
    assert_true (map.v_overhang == 1);
    verify_slots (
        map,
        {
            {24, 4, 0},
            {18, 0, 0},
            {22, 4, 0},
            {18, 2, 0},
            {20, 4, 0},
            {18, 4, 0},
            {16, 4, 0},
            {18, 6, 0},
            {24, 12, 0},
            {14, 4, 0},
            {18, 8, 0},
            {22, 12, 0},
            {12, 4, 0},
            {18, 10, 0},
            {20, 12, 0},
            {6, 0, 0},
            {10, 4, 0},
            {18, 12, 0},
            {6, 2, 0},
            {8, 4, 0},
            {16, 12, 0},
            {18, 14, 0},
            {6, 4, 0},
            {14, 12, 0},
            {18, 16, 0},
            {4, 4, 0},
            {6, 6, 0},
            {12, 12, 0},
            {2, 4, 0},
            {6, 8, 0},
            {10, 12, 0},
            {0, 4, 0},
            {6, 10, 0},
            {8, 12, 0},
            {6, 12, 0},
            {4, 12, 0},
            {6, 14, 0},
            {2, 12, 0},
            {6, 16, 0},
            {0, 12, 0},
            {18, 0, 1},
            {22, 4, 1},
            {18, 2, 1},
            {20, 4, 1},
            {18, 4, 1},
            {16, 4, 1},
            {18, 6, 1},
            {14, 4, 1},
            {18, 8, 1},
            {22, 12, 1},
            {12, 4, 1},
            {18, 10, 1},
            {20, 12, 1},
            {6, 0, 1},
            {10, 4, 1},
            {18, 12, 1},
            {6, 2, 1},
            {8, 4, 1},
            {16, 12, 1},
            {18, 14, 1},
            {6, 4, 1},
            {14, 12, 1},
            {18, 16, 1},
            {4, 4, 1},
            {6, 6, 1},
            {12, 12, 1},
            {2, 4, 1},
            {6, 8, 1},
            {10, 12, 1},
            {6, 10, 1},
            {8, 12, 1},
            {6, 12, 1},
            {4, 12, 1},
            {6, 14, 1},
            {2, 12, 1},
            {6, 16, 1},
            {18, 2, 2},
            {20, 4, 2},
            {18, 4, 2},
            {16, 4, 2},
            {18, 6, 2},
            {14, 4, 2},
            {18, 8, 2},
            {12, 4, 2},
            {18, 10, 2},
            {20, 12, 2},
            {10, 4, 2},
            {18, 12, 2},
            {6, 2, 2},
            {8, 4, 2},
            {16, 12, 2},
            {18, 14, 2},
            {6, 4, 2},
            {14, 12, 2},
            {4, 4, 2},
            {6, 6, 2},
            {12, 12, 2},
            {6, 8, 2},
            {10, 12, 2},
            {6, 10, 2},
            {8, 12, 2},
            {6, 12, 2},
            {4, 12, 2},
            {6, 14, 2},
            {18, 4, 3},
            {16, 4, 3},
            {18, 6, 3},
            {14, 4, 3},
            {18, 8, 3},
            {12, 4, 3},
            {18, 10, 3},
            {10, 4, 3},
            {18, 12, 3},
            {8, 4, 3},
            {16, 12, 3},
            {6, 4, 3},
            {14, 12, 3},
            {6, 6, 3},
            {12, 12, 3},
            {6, 8, 3},
            {10, 12, 3},
            {6, 10, 3},
            {8, 12, 3},
            {6, 12, 3},
            {18, 4, 4},
            {16, 4, 4},
            {18, 6, 4},
            {14, 4, 4},
            {18, 8, 4},
            {12, 4, 4},
            {18, 10, 4},
            {10, 4, 4},
            {18, 12, 4},
            {8, 4, 4},
            {16, 12, 4},
            {6, 4, 4},
            {14, 12, 4},
            {6, 6, 4},
            {12, 12, 4},
            {6, 8, 4},
            {10, 12, 4},
            {6, 10, 4},
            {8, 12, 4},
            {6, 12, 4},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "Red Dragon");
    assert_true (map.score_name == "dragon");
    assert_true (map.width == 30);
    assert_true (map.height == 15);
    assert_true (map.h_overhang == 0);
    assert_true (map.v_overhang == 0);
    verify_slots (
        map,
        {
            {28, 0, 0},
            {28, 3, 0},
            {24, 0, 0},
            {22, 0, 0},
            {24, 2, 0},
            {28, 6, 0},
            {20, 0, 0},
            {22, 2, 0},
            {24, 4, 0},
            {28, 9, 0},
            {18, 0, 0},
            {20, 2, 0},
            {22, 4, 0},
            {24, 6, 0},
            {16, 0, 0},
            {18, 2, 0},
            {20, 4, 0},
            {22, 6, 0},
            {24, 8, 0},
            {28, 12, 0},
            {14, 0, 0},
            {16, 2, 0},
            {18, 4, 0},
            {20, 6, 0},
            {22, 8, 0},
            {24, 10, 0},
            {12, 0, 0},
            {14, 2, 0},
            {16, 4, 0},
            {18, 6, 0},
            {20, 8, 0},
            {22, 10, 0},
            {24, 13, 0},
            {10, 0, 0},
            {12, 2, 0},
            {14, 4, 0},
            {16, 6, 0},
            {18, 8, 0},
            {20, 10, 0},
            {8, 0, 0},
            {10, 2, 0},
            {12, 4, 0},
            {14, 6, 0},
            {16, 8, 0},
            {18, 10, 0},
            {20, 13, 0},
            {6, 0, 0},
            {8, 2, 0},
            {10, 4, 0},
            {12, 6, 0},
            {14, 8, 0},
            {16, 10, 0},
            {4, 0, 0},
            {6, 2, 0},
            {8, 4, 0},
            {10, 6, 0},
            {12, 8, 0},
            {14, 10, 0},
            {16, 13, 0},
            {4, 2, 0},
            {6, 4, 0},
            {8, 6, 0},
            {10, 8, 0},
            {12, 10, 0},
            {0, 0, 0},
            {4, 4, 0},
            {6, 6, 0},
            {8, 8, 0},
            {10, 10, 0},
            {12, 13, 0},
            {4, 6, 0},
            {6, 8, 0},
            {8, 10, 0},
            {0, 3, 0},
            {4, 8, 0},
            {6, 10, 0},
            {8, 13, 0},
            {0, 6, 0},
            {4, 10, 0},
            {0, 9, 0},
            {4, 13, 0},
            {0, 12, 0},
            {21, 1, 1},
            {23, 3, 1},
            {19, 1, 1},
            {21, 3, 1},
            {23, 5, 1},
            {17, 1, 1},
            {19, 3, 1},
            {21, 5, 1},
            {23, 7, 1},
            {15, 1, 1},
            {17, 3, 1},
            {19, 5, 1},
            {21, 7, 1},
            {13, 1, 1},
            {15, 3, 1},
            {17, 5, 1},
            {19, 7, 1},
            {21, 9, 1},
            {11, 1, 1},
            {13, 3, 1},
            {15, 5, 1},
            {17, 7, 1},
            {19, 9, 1},
            {9, 1, 1},
            {11, 3, 1},
            {13, 5, 1},
            {15, 7, 1},
            {17, 9, 1},
            {7, 1, 1},
            {9, 3, 1},
            {11, 5, 1},
            {13, 7, 1},
            {15, 9, 1},
            {7, 3, 1},
            {9, 5, 1},
            {11, 7, 1},
            {13, 9, 1},
            {5, 3, 1},
            {7, 5, 1},
            {9, 7, 1},
            {11, 9, 1},
            {7, 7, 1},
            {9, 9, 1},
            {7, 9, 1},
            {5, 9, 1},
            {16, 2, 2},
            {22, 8, 2},
            {14, 2, 2},
            {16, 4, 2},
            {12, 2, 2},
            {14, 4, 2},
            {16, 6, 2},
            {10, 2, 2},
            {12, 4, 2},
            {14, 6, 2},
            {16, 8, 2},
            {10, 4, 2},
            {12, 6, 2},
            {14, 8, 2},
            {10, 6, 2},
            {12, 8, 2},
            {10, 8, 2},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "Overpass");
    assert_true (map.score_name == "overpass");
    assert_true (map.width == 24);
    assert_true (map.height == 18);
    assert_true (map.h_overhang == 1);
    assert_true (map.v_overhang == 0);
    verify_slots (
        map,
        {
            {22, 4, 0},
            {20, 4, 0},
            {22, 6, 0},
            {14, 0, 0},
            {22, 8, 0},
            {12, 0, 0},
            {14, 2, 0},
            {22, 10, 0},
            {10, 0, 0},
            {12, 2, 0},
            {14, 4, 0},
            {22, 12, 0},
            {8, 0, 0},
            {10, 2, 0},
            {12, 4, 0},
            {14, 6, 0},
            {22, 14, 0},
            {8, 2, 0},
            {10, 4, 0},
            {12, 6, 0},
            {14, 8, 0},
            {20, 14, 0},
            {8, 4, 0},
            {10, 6, 0},
            {12, 8, 0},
            {14, 10, 0},
            {8, 6, 0},
            {10, 8, 0},
            {12, 10, 0},
            {14, 12, 0},
            {8, 8, 0},
            {10, 10, 0},
            {12, 12, 0},
            {14, 14, 0},
            {2, 4, 0},
            {8, 10, 0},
            {10, 12, 0},
            {12, 14, 0},
            {14, 16, 0},
            {0, 4, 0},
            {8, 12, 0},
            {10, 14, 0},
            {12, 16, 0},
            {0, 6, 0},
            {8, 14, 0},
            {10, 16, 0},
            {0, 8, 0},
            {8, 16, 0},
            {0, 10, 0},
            {0, 12, 0},
            {2, 14, 0},
            {0, 14, 0},
            {22, 4, 1},
            {22, 6, 1},
            {20, 6, 1},
            {22, 8, 1},
            {20, 8, 1},
            {22, 10, 1},
            {20, 10, 1},
            {22, 12, 1},
            {20, 12, 1},
            {22, 14, 1},
            {0, 4, 1},
            {2, 6, 1},
            {0, 6, 1},
            {2, 8, 1},
            {0, 8, 1},
            {2, 10, 1},
            {0, 10, 1},
            {2, 12, 1},
            {0, 12, 1},
            {0, 14, 1},
            {20, 6, 2},
            {18, 6, 2},
            {20, 8, 2},
            {18, 8, 2},
            {20, 10, 2},
            {18, 10, 2},
            {20, 12, 2},
            {18, 12, 2},
            {4, 6, 2},
            {2, 6, 2},
            {4, 8, 2},
            {2, 8, 2},
            {4, 10, 2},
            {2, 10, 2},
            {4, 12, 2},
            {2, 12, 2},
            {18, 6, 3},
            {16, 6, 3},
            {18, 8, 3},
            {14, 6, 3},
            {16, 8, 3},
            {18, 10, 3},
            {12, 6, 3},
            {14, 8, 3},
            {16, 10, 3},
            {18, 12, 3},
            {10, 6, 3},
            {12, 8, 3},
            {14, 10, 3},
            {16, 12, 3},
            {8, 6, 3},
            {10, 8, 3},
            {12, 10, 3},
            {14, 12, 3},
            {6, 6, 3},
            {8, 8, 3},
            {10, 10, 3},
            {12, 12, 3},
            {4, 6, 3},
            {6, 8, 3},
            {8, 10, 3},
            {10, 12, 3},
            {4, 8, 3},
            {6, 10, 3},
            {8, 12, 3},
            {4, 10, 3},
            {6, 12, 3},
            {4, 12, 3},
            {16, 6, 4},
            {14, 6, 4},
            {16, 8, 4},
            {12, 6, 4},
            {14, 8, 4},
            {16, 10, 4},
            {10, 6, 4},
            {12, 8, 4},
            {14, 10, 4},
            {16, 12, 4},
            {8, 6, 4},
            {10, 8, 4},
            {12, 10, 4},
            {14, 12, 4},
            {6, 6, 4},
            {8, 8, 4},
            {10, 10, 4},
            {12, 12, 4},
            {6, 8, 4},
            {8, 10, 4},
            {10, 12, 4},
            {6, 10, 4},
            {8, 12, 4},
            {6, 12, 4},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "Pyramid's Walls");
    assert_true (map.score_name == "pyramid");
    assert_true (map.width == 24);
    assert_true (map.height == 14);
    assert_true (map.h_overhang == 4);
    assert_true (map.v_overhang == 6);
    verify_slots (
        map,
        {
            {22, 0, 0},
            {20, 0, 0},
            {22, 2, 0},
            {18, 0, 0},
            {22, 4, 0},
            {16, 0, 0},
            {22, 6, 0},
            {14, 0, 0},
            {22, 8, 0},
            {12, 0, 0},
            {22, 10, 0},
            {17, 6, 0},
            {10, 0, 0},
            {22, 12, 0},
            {15, 6, 0},
            {8, 0, 0},
            {20, 12, 0},
            {13, 6, 0},
            {6, 0, 0},
            {18, 12, 0},
            {11, 6, 0},
            {4, 0, 0},
            {16, 12, 0},
            {9, 6, 0},
            {2, 0, 0},
            {14, 12, 0},
            {7, 6, 0},
            {0, 0, 0},
            {12, 12, 0},
            {5, 6, 0},
            {0, 2, 0},
            {10, 12, 0},
            {0, 4, 0},
            {8, 12, 0},
            {0, 6, 0},
            {6, 12, 0},
            {0, 8, 0},
            {4, 12, 0},
            {0, 10, 0},
            {2, 12, 0},
            {0, 12, 0},
            {20, 0, 1},
            {22, 3, 1},
            {18, 0, 1},
            {22, 5, 1},
            {16, 0, 1},
            {22, 7, 1},
            {14, 0, 1},
            {22, 9, 1},
            {12, 0, 1},
            {10, 0, 1},
            {16, 6, 1},
            {8, 0, 1},
            {14, 6, 1},
            {20, 12, 1},
            {6, 0, 1},
            {12, 6, 1},
            {18, 12, 1},
            {4, 0, 1},
            {10, 6, 1},
            {16, 12, 1},
            {2, 0, 1},
            {8, 6, 1},
            {14, 12, 1},
            {6, 6, 1},
            {12, 12, 1},
            {10, 12, 1},
            {0, 3, 1},
            {8, 12, 1},
            {0, 5, 1},
            {6, 12, 1},
            {0, 7, 1},
            {4, 12, 1},
            {0, 9, 1},
            {2, 12, 1},
            {18, 0, 2},
            {22, 4, 2},
            {16, 0, 2},
            {22, 6, 2},
            {14, 0, 2},
            {22, 8, 2},
            {12, 0, 2},
            {10, 0, 2},
            {15, 6, 2},
            {8, 0, 2},
            {13, 6, 2},
            {6, 0, 2},
            {18, 12, 2},
            {11, 6, 2},
            {4, 0, 2},
            {16, 12, 2},
            {9, 6, 2},
            {14, 12, 2},
            {7, 6, 2},
            {12, 12, 2},
            {10, 12, 2},
            {0, 4, 2},
            {8, 12, 2},
            {0, 6, 2},
            {6, 12, 2},
            {0, 8, 2},
            {4, 12, 2},
            {22, 5, 3},
            {16, 0, 3},
            {22, 7, 3},
            {14, 0, 3},
            {12, 0, 3},
            {10, 0, 3},
            {8, 0, 3},
            {14, 6, 3},
            {6, 0, 3},
            {12, 6, 3},
            {10, 6, 3},
            {16, 12, 3},
            {8, 6, 3},
            {14, 12, 3},
            {12, 12, 3},
            {10, 12, 3},
            {8, 12, 3},
            {0, 5, 3},
            {6, 12, 3},
            {0, 7, 3},
            {22, 6, 4},
            {14, 0, 4},
            {12, 0, 4},
            {10, 0, 4},
            {8, 0, 4},
            {13, 6, 4},
            {11, 6, 4},
            {9, 6, 4},
            {14, 12, 4},
            {12, 12, 4},
            {10, 12, 4},
            {8, 12, 4},
            {0, 6, 4},
            {12, 0, 5},
            {10, 0, 5},
            {12, 6, 5},
            {10, 6, 5},
            {12, 12, 5},
            {10, 12, 5},
            {11, 0, 6},
            {11, 6, 6},
            {11, 12, 6},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "Confounding Cross");
    assert_true (map.score_name == "confounding");
    assert_true (map.width == 22);
    assert_true (map.height == 18);
    assert_true (map.h_overhang == 0);
    assert_true (map.v_overhang == 0);
    verify_slots (
        map,
        {
            {18, 2, 0},
            {16, 2, 0},
            {18, 4, 0},
            {14, 2, 0},
            {16, 4, 0},
            {18, 6, 0},
            {20, 8, 0},
            {10, 0, 0},
            {12, 2, 0},
            {18, 8, 0},
            {10, 2, 0},
            {16, 8, 0},
            {18, 10, 0},
            {8, 2, 0},
            {10, 4, 0},
            {14, 8, 0},
            {18, 12, 0},
            {6, 2, 0},
            {10, 6, 0},
            {12, 8, 0},
            {16, 12, 0},
            {18, 14, 0},
            {4, 2, 0},
            {10, 8, 0},
            {16, 14, 0},
            {2, 2, 0},
            {4, 4, 0},
            {8, 8, 0},
            {10, 10, 0},
            {14, 14, 0},
            {2, 4, 0},
            {6, 8, 0},
            {10, 12, 0},
            {12, 14, 0},
            {2, 6, 0},
            {4, 8, 0},
            {10, 14, 0},
            {2, 8, 0},
            {8, 14, 0},
            {10, 16, 0},
            {0, 8, 0},
            {2, 10, 0},
            {4, 12, 0},
            {6, 14, 0},
            {2, 12, 0},
            {4, 14, 0},
            {2, 14, 0},
            {18, 2, 1},
            {16, 2, 1},
            {18, 4, 1},
            {14, 2, 1},
            {16, 4, 1},
            {18, 6, 1},
            {19, 8, 1},
            {10, 1, 1},
            {17, 8, 1},
            {18, 10, 1},
            {10, 3, 1},
            {15, 8, 1},
            {18, 12, 1},
            {10, 5, 1},
            {13, 8, 1},
            {6, 2, 1},
            {11, 7, 1},
            {16, 12, 1},
            {18, 14, 1},
            {4, 2, 1},
            {9, 7, 1},
            {11, 9, 1},
            {16, 14, 1},
            {2, 2, 1},
            {4, 4, 1},
            {9, 9, 1},
            {14, 14, 1},
            {7, 8, 1},
            {10, 11, 1},
            {2, 4, 1},
            {5, 8, 1},
            {10, 13, 1},
            {2, 6, 1},
            {3, 8, 1},
            {10, 15, 1},
            {1, 8, 1},
            {2, 10, 1},
            {4, 12, 1},
            {6, 14, 1},
            {2, 12, 1},
            {4, 14, 1},
            {2, 14, 1},
            {18, 2, 2},
            {16, 2, 2},
            {18, 4, 2},
            {18, 8, 2},
            {10, 2, 2},
            {16, 8, 2},
            {10, 4, 2},
            {14, 8, 2},
            {18, 12, 2},
            {10, 6, 2},
            {12, 8, 2},
            {18, 14, 2},
            {4, 2, 2},
            {10, 8, 2},
            {16, 14, 2},
            {2, 2, 2},
            {8, 8, 2},
            {10, 10, 2},
            {2, 4, 2},
            {6, 8, 2},
            {10, 12, 2},
            {4, 8, 2},
            {10, 14, 2},
            {2, 8, 2},
            {2, 12, 2},
            {4, 14, 2},
            {2, 14, 2},
            {18, 2, 3},
            {17, 8, 3},
            {10, 3, 3},
            {15, 8, 3},
            {10, 5, 3},
            {13, 8, 3},
            {11, 7, 3},
            {18, 14, 3},
            {9, 7, 3},
            {11, 9, 3},
            {2, 2, 3},
            {9, 9, 3},
            {7, 8, 3},
            {10, 11, 3},
            {5, 8, 3},
            {10, 13, 3},
            {3, 8, 3},
            {2, 14, 3},
            {10, 4, 4},
            {14, 8, 4},
            {10, 6, 4},
            {12, 8, 4},
            {10, 8, 4},
            {8, 8, 4},
            {10, 10, 4},
            {6, 8, 4},
            {10, 12, 4},
            {10, 8, 5},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map.name == "Taipei");
    assert_true (map.score_name == "difficult");
    assert_true (map.width == 22);
    assert_true (map.height == 14);
    assert_true (map.h_overhang == 0);
    assert_true (map.v_overhang == 1);
    verify_slots (
        map,
        {
            {19, 1, 0},
            {17, 1, 0},
            {19, 3, 0},
            {14, 0, 0},
            {17, 3, 0},
            {20, 6, 0},
            {15, 2, 0},
            {18, 5, 0},
            {12, 0, 0},
            {13, 2, 0},
            {16, 5, 0},
            {18, 7, 0},
            {10, 0, 0},
            {14, 4, 0},
            {19, 9, 0},
            {11, 2, 0},
            {16, 7, 0},
            {8, 0, 0},
            {12, 4, 0},
            {14, 6, 0},
            {17, 9, 0},
            {19, 11, 0},
            {9, 2, 0},
            {6, 0, 0},
            {10, 4, 0},
            {12, 6, 0},
            {14, 8, 0},
            {17, 11, 0},
            {7, 2, 0},
            {15, 10, 0},
            {8, 4, 0},
            {10, 6, 0},
            {12, 8, 0},
            {5, 2, 0},
            {13, 10, 0},
            {3, 1, 0},
            {6, 4, 0},
            {8, 6, 0},
            {10, 8, 0},
            {14, 12, 0},
            {11, 10, 0},
            {1, 1, 0},
            {3, 3, 0},
            {6, 6, 0},
            {8, 8, 0},
            {12, 12, 0},
            {4, 5, 0},
            {9, 10, 0},
            {1, 3, 0},
            {6, 8, 0},
            {10, 12, 0},
            {2, 5, 0},
            {4, 7, 0},
            {7, 10, 0},
            {8, 12, 0},
            {2, 7, 0},
            {5, 10, 0},
            {0, 6, 0},
            {3, 9, 0},
            {6, 12, 0},
            {1, 9, 0},
            {3, 11, 0},
            {1, 11, 0},
            {18, 2, 1},
            {16, 2, 1},
            {13, 0, 1},
            {17, 4, 1},
            {14, 2, 1},
            {15, 4, 1},
            {17, 6, 1},
            {11, 1, 1},
            {12, 3, 1},
            {15, 6, 1},
            {17, 8, 1},
            {9, 1, 1},
            {13, 5, 1},
            {18, 10, 1},
            {7, 0, 1},
            {10, 3, 1},
            {15, 8, 1},
            {11, 5, 1},
            {13, 7, 1},
            {16, 10, 1},
            {8, 3, 1},
            {6, 2, 1},
            {9, 5, 1},
            {11, 7, 1},
            {14, 10, 1},
            {12, 9, 1},
            {4, 2, 1},
            {7, 5, 1},
            {9, 7, 1},
            {5, 4, 1},
            {10, 9, 1},
            {13, 12, 1},
            {2, 2, 1},
            {7, 7, 1},
            {11, 11, 1},
            {3, 4, 1},
            {5, 6, 1},
            {8, 9, 1},
            {9, 11, 1},
            {3, 6, 1},
            {5, 8, 1},
            {6, 10, 1},
            {3, 8, 1},
            {7, 12, 1},
            {4, 10, 1},
            {2, 10, 1},
            {15, 4, 2},
            {16, 6, 2},
            {13, 4, 2},
            {14, 6, 2},
            {11, 4, 2},
            {15, 8, 2},
            {12, 6, 2},
            {9, 4, 2},
            {13, 8, 2},
            {10, 6, 2},
            {7, 4, 2},
            {11, 8, 2},
            {8, 6, 2},
            {5, 4, 2},
            {9, 8, 2},
            {6, 6, 2},
            {7, 8, 2},
            {4, 6, 2},
            {5, 8, 2},
            {15, 6, 3},
            {13, 5, 3},
            {11, 5, 3},
            {13, 7, 3},
            {9, 5, 3},
            {11, 7, 3},
            {7, 5, 3},
            {9, 7, 3},
            {7, 7, 3},
            {5, 6, 3},
            {12, 6, 4},
            {10, 6, 4},
            {8, 6, 4},
            {11, 6, 5},
            {9, 6, 5},
            {10, 6, 6},
        }
    );

    map = maps.get_next_map (map);
    assert_true (map == first_map);
}

public int main (string[] args) {
    Test.init (ref args);
    Test.add_func ("/map/slot", test_slot);
    Test.add_func ("/map/load_maps", test_load_maps);

    return Test.run ();
}
