/* desktop-plugin.c generated by valac 0.36.9, the Vala compiler
 * generated from desktop-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_DESKTOP_PLUGIN (games_desktop_plugin_get_type ())
#define GAMES_DESKTOP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_PLUGIN, GamesDesktopPlugin))
#define GAMES_DESKTOP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_PLUGIN, GamesDesktopPluginClass))
#define GAMES_IS_DESKTOP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_PLUGIN))
#define GAMES_IS_DESKTOP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_PLUGIN))
#define GAMES_DESKTOP_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_PLUGIN, GamesDesktopPluginClass))

typedef struct _GamesDesktopPlugin GamesDesktopPlugin;
typedef struct _GamesDesktopPluginClass GamesDesktopPluginClass;
typedef struct _GamesDesktopPluginPrivate GamesDesktopPluginPrivate;

#define GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY (games_desktop_tracker_uri_query_get_type ())
#define GAMES_DESKTOP_TRACKER_URI_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY, GamesDesktopTrackerUriQuery))
#define GAMES_DESKTOP_TRACKER_URI_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY, GamesDesktopTrackerUriQueryClass))
#define GAMES_IS_DESKTOP_TRACKER_URI_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY))
#define GAMES_IS_DESKTOP_TRACKER_URI_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY))
#define GAMES_DESKTOP_TRACKER_URI_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY, GamesDesktopTrackerUriQueryClass))

typedef struct _GamesDesktopTrackerUriQuery GamesDesktopTrackerUriQuery;
typedef struct _GamesDesktopTrackerUriQueryClass GamesDesktopTrackerUriQueryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GAMES_TYPE_DESKTOP_TITLE (games_desktop_title_get_type ())
#define GAMES_DESKTOP_TITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_TITLE, GamesDesktopTitle))
#define GAMES_DESKTOP_TITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_TITLE, GamesDesktopTitleClass))
#define GAMES_IS_DESKTOP_TITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_TITLE))
#define GAMES_IS_DESKTOP_TITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_TITLE))
#define GAMES_DESKTOP_TITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_TITLE, GamesDesktopTitleClass))

typedef struct _GamesDesktopTitle GamesDesktopTitle;
typedef struct _GamesDesktopTitleClass GamesDesktopTitleClass;

#define GAMES_TYPE_DESKTOP_ICON (games_desktop_icon_get_type ())
#define GAMES_DESKTOP_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_ICON, GamesDesktopIcon))
#define GAMES_DESKTOP_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_ICON, GamesDesktopIconClass))
#define GAMES_IS_DESKTOP_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_ICON))
#define GAMES_IS_DESKTOP_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_ICON))
#define GAMES_DESKTOP_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_ICON, GamesDesktopIconClass))

typedef struct _GamesDesktopIcon GamesDesktopIcon;
typedef struct _GamesDesktopIconClass GamesDesktopIconClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _GamesDesktopPlugin {
	GObject parent_instance;
	GamesDesktopPluginPrivate * priv;
};

struct _GamesDesktopPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_DESKTOP_ERROR_INVALID_APPINFO,
	GAMES_DESKTOP_ERROR_BLACKLISTED_GAME
} GamesDesktopError;
#define GAMES_DESKTOP_ERROR games_desktop_error_quark ()

static gpointer games_desktop_plugin_parent_class = NULL;
static gchar** games_desktop_plugin_categories_black_list;
static gint games_desktop_plugin_categories_black_list_length1;
static gchar** games_desktop_plugin_categories_black_list = NULL;
static gint games_desktop_plugin_categories_black_list_length1 = 0;
static gint _games_desktop_plugin_categories_black_list_size_ = 0;
static gchar** games_desktop_plugin_executable_black_list;
static gint games_desktop_plugin_executable_black_list_length1;
static gchar** games_desktop_plugin_executable_black_list = NULL;
static gint games_desktop_plugin_executable_black_list_length1 = 0;
static gint _games_desktop_plugin_executable_black_list_size_ = 0;
static gchar** games_desktop_plugin_base_name_black_list;
static gint games_desktop_plugin_base_name_black_list_length1;
static gchar** games_desktop_plugin_base_name_black_list = NULL;
static gint games_desktop_plugin_base_name_black_list_length1 = 0;
static gint _games_desktop_plugin_base_name_black_list_size_ = 0;
static GamesPluginIface * games_desktop_plugin_games_plugin_parent_iface = NULL;
static GType games_desktop_plugin_type_id = 0;

GType games_desktop_plugin_get_type (void) G_GNUC_CONST;
enum  {
	GAMES_DESKTOP_PLUGIN_0_PROPERTY
};
#define GAMES_DESKTOP_PLUGIN_MIME_TYPE "application/x-desktop"
static gchar** games_desktop_plugin_real_get_mime_types (GamesPlugin* base, int* result_length1);
static GamesUriSource** games_desktop_plugin_real_get_uri_sources (GamesPlugin* base, int* result_length1);
GType games_desktop_tracker_uri_query_get_type (void) G_GNUC_CONST;
GamesDesktopTrackerUriQuery* games_desktop_tracker_uri_query_new (void);
GamesDesktopTrackerUriQuery* games_desktop_tracker_uri_query_construct (GType object_type);
static GamesUriGameFactory** games_desktop_plugin_real_get_uri_game_factories (GamesPlugin* base, int* result_length1);
static GamesGame* games_desktop_plugin_game_for_uri (GamesUri* uri, GError** error);
static GamesGame* _games_desktop_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri, gpointer self, GError** error);
static void games_desktop_plugin_check_uri (GamesUri* uri, GError** error);
GType games_desktop_title_get_type (void) G_GNUC_CONST;
GamesDesktopTitle* games_desktop_title_new (GDesktopAppInfo* app_info);
GamesDesktopTitle* games_desktop_title_construct (GType object_type, GDesktopAppInfo* app_info);
GType games_desktop_icon_get_type (void) G_GNUC_CONST;
GamesDesktopIcon* games_desktop_icon_new (GDesktopAppInfo* app_info);
GamesDesktopIcon* games_desktop_icon_construct (GType object_type, GDesktopAppInfo* app_info);
GQuark games_desktop_error_quark (void);
static void games_desktop_plugin_check_displayability (GDesktopAppInfo* app_info, GError** error);
static void games_desktop_plugin_check_categories (GDesktopAppInfo* app_info, GError** error);
static void games_desktop_plugin_check_executable (GDesktopAppInfo* app_info, GError** error);
static void games_desktop_plugin_check_base_name (GFile* file, GError** error);
static gchar** games_desktop_plugin_get_categories_black_list (int* result_length1, GError** error);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static gchar** games_desktop_plugin_get_executable_black_list (int* result_length1, GError** error);
static gchar** games_desktop_plugin_get_base_name_black_list (int* result_length1, GError** error);
static gchar** games_desktop_plugin_get_lines_from_resource (const gchar* resource, int* result_length1, GError** error);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
GamesDesktopPlugin* games_desktop_plugin_new (void);
GamesDesktopPlugin* games_desktop_plugin_construct (GType object_type);
static void games_desktop_plugin_finalize (GObject * obj);
GType register_games_plugin (GTypeModule* module);
GType games_desktop_icon_register_type (GTypeModule * module);
GType games_desktop_plugin_register_type (GTypeModule * module);
GType games_desktop_title_register_type (GTypeModule * module);
GType games_desktop_tracker_uri_query_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar** games_desktop_plugin_real_get_mime_types (GamesPlugin* base, int* result_length1) {
	GamesDesktopPlugin * self;
	gchar** result = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (GamesDesktopPlugin*) base;
	_tmp0_ = g_strdup (GAMES_DESKTOP_PLUGIN_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GamesUriSource** games_desktop_plugin_real_get_uri_sources (GamesPlugin* base, int* result_length1) {
	GamesDesktopPlugin * self;
	GamesUriSource** result = NULL;
	GamesDesktopTrackerUriQuery* query = NULL;
	GamesDesktopTrackerUriQuery* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (GamesDesktopPlugin*) base;
	_tmp0_ = games_desktop_tracker_uri_query_new ();
	query = _tmp0_;
	{
		TrackerSparqlConnection* connection = NULL;
		TrackerSparqlConnection* _tmp1_;
		GamesTrackerUriSource* uri_source = NULL;
		GamesTrackerUriSource* _tmp2_;
		GamesTrackerUriSource* _tmp3_;
		GamesTrackerUriSource* _tmp4_;
		GamesUriSource* _tmp5_;
		GamesUriSource** _tmp6_;
		GamesUriSource** _tmp7_;
		gint _tmp7__length1;
		_tmp1_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		connection = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = games_tracker_uri_source_new (connection);
		uri_source = _tmp2_;
		_tmp3_ = uri_source;
		games_tracker_uri_source_add_query (_tmp3_, (GamesTrackerUriQuery*) query);
		_tmp4_ = uri_source;
		_tmp5_ = _g_object_ref0 ((GamesUriSource*) _tmp4_);
		_tmp6_ = g_new0 (GamesUriSource*, 1 + 1);
		_tmp6_[0] = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp7__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp7__length1;
		}
		result = _tmp7_;
		_g_object_unref0 (uri_source);
		_g_object_unref0 (connection);
		_g_object_unref0 (query);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GamesUriSource** _tmp10_;
		GamesUriSource** _tmp11_;
		gint _tmp11__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_debug ("desktop-plugin.vala:20: %s", _tmp9_);
		_tmp10_ = g_new0 (GamesUriSource*, 0 + 1);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp11__length1;
		}
		result = _tmp11_;
		_g_error_free0 (e);
		_g_object_unref0 (query);
		return result;
	}
	__finally0:
	_g_object_unref0 (query);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static GamesGame* _games_desktop_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri, gpointer self, GError** error) {
	GamesGame* result;
	result = games_desktop_plugin_game_for_uri (uri, error);
	return result;
}


static GamesUriGameFactory** games_desktop_plugin_real_get_uri_game_factories (GamesPlugin* base, int* result_length1) {
	GamesDesktopPlugin * self;
	GamesUriGameFactory** result = NULL;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	self = (GamesDesktopPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_desktop_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_DESKTOP_PLUGIN_MIME_TYPE);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}


static GamesGame* games_desktop_plugin_game_for_uri (GamesUri* uri, GError** error) {
	GamesGame* result = NULL;
	GamesUri* _tmp0_;
	GFile* file = NULL;
	GamesUri* _tmp1_;
	GFile* _tmp2_;
	gchar* path = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	GDesktopAppInfo* app_info = NULL;
	const gchar* _tmp5_;
	GDesktopAppInfo* _tmp6_;
	GamesDesktopTitle* title = NULL;
	GDesktopAppInfo* _tmp7_;
	GamesDesktopTitle* _tmp8_;
	GamesDesktopIcon* icon = NULL;
	GDesktopAppInfo* _tmp9_;
	GamesDesktopIcon* _tmp10_;
	GamesDummyCover* cover = NULL;
	GamesDummyCover* _tmp11_;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar* command = NULL;
	GDesktopAppInfo* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	gchar** _tmp17_ = NULL;
	gint _tmp18_;
	gboolean _tmp19_;
	GamesCommandRunner* runner = NULL;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GamesCommandRunner* _tmp23_;
	GamesDesktopTitle* _tmp24_;
	GamesDesktopIcon* _tmp25_;
	GamesDummyCover* _tmp26_;
	GamesCommandRunner* _tmp27_;
	GamesGenericGame* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	games_desktop_plugin_check_uri (_tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = uri;
	_tmp2_ = games_uri_to_file (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_get_path (_tmp3_);
	path = _tmp4_;
	_tmp5_ = path;
	_tmp6_ = g_desktop_app_info_new_from_filename (_tmp5_);
	app_info = _tmp6_;
	_tmp7_ = app_info;
	_tmp8_ = games_desktop_title_new (_tmp7_);
	title = _tmp8_;
	_tmp9_ = app_info;
	_tmp10_ = games_desktop_icon_new (_tmp9_);
	icon = _tmp10_;
	_tmp11_ = games_dummy_cover_new ();
	cover = _tmp11_;
	_tmp12_ = app_info;
	_tmp13_ = g_app_info_get_commandline ((GAppInfo*) _tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	command = _tmp14_;
	_tmp16_ = command;
	_tmp19_ = g_shell_parse_argv (_tmp16_, &_tmp18_, &_tmp17_, &_inner_error_);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	args = _tmp17_;
	args_length1 = _tmp18_;
	_args_size_ = args_length1;
	_tmp15_ = _tmp19_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (command);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (cover);
		_g_object_unref0 (icon);
		_g_object_unref0 (title);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return NULL;
	}
	if (!_tmp15_) {
		const gchar* _tmp20_;
		GError* _tmp21_;
		_tmp20_ = command;
		_tmp21_ = g_error_new (GAMES_COMMAND_ERROR, GAMES_COMMAND_ERROR_INVALID_COMMAND, _ ("Invalid command “%s”."), _tmp20_);
		_inner_error_ = _tmp21_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (command);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (cover);
		_g_object_unref0 (icon);
		_g_object_unref0 (title);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp22_ = args;
	_tmp22__length1 = args_length1;
	_tmp23_ = games_command_runner_new (_tmp22_, _tmp22__length1, TRUE);
	runner = _tmp23_;
	_tmp24_ = title;
	_tmp25_ = icon;
	_tmp26_ = cover;
	_tmp27_ = runner;
	_tmp28_ = games_generic_game_new ((GamesTitle*) _tmp24_, (GamesIcon*) _tmp25_, (GamesCover*) _tmp26_, (GamesRunner*) _tmp27_);
	result = (GamesGame*) _tmp28_;
	_g_object_unref0 (runner);
	_g_free0 (command);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (cover);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (app_info);
	_g_free0 (path);
	_g_object_unref0 (file);
	return result;
}


static void games_desktop_plugin_check_uri (GamesUri* uri, GError** error) {
	GFile* file = NULL;
	GamesUri* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	gchar* path = NULL;
	GFile* _tmp9_;
	gchar* _tmp10_;
	GDesktopAppInfo* app_info = NULL;
	const gchar* _tmp11_;
	GDesktopAppInfo* _tmp12_;
	GDesktopAppInfo* _tmp13_;
	GDesktopAppInfo* _tmp16_;
	GDesktopAppInfo* _tmp17_;
	GDesktopAppInfo* _tmp18_;
	GFile* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	_tmp1_ = games_uri_to_file (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		GamesUri* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp4_ = uri;
		_tmp5_ = games_uri_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, _ ("Tracker listed file not found: “%s”."), _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return;
	}
	_tmp9_ = file;
	_tmp10_ = g_file_get_path (_tmp9_);
	path = _tmp10_;
	_tmp11_ = path;
	_tmp12_ = g_desktop_app_info_new_from_filename (_tmp11_);
	app_info = _tmp12_;
	_tmp13_ = app_info;
	if (_tmp13_ == NULL) {
		const gchar* _tmp14_;
		GError* _tmp15_;
		_tmp14_ = path;
		_tmp15_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_INVALID_APPINFO, _ ("Couldn’t parse desktop entry “%s”."), _tmp14_);
		_inner_error_ = _tmp15_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp16_ = app_info;
	games_desktop_plugin_check_displayability (_tmp16_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp17_ = app_info;
	games_desktop_plugin_check_categories (_tmp17_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp18_ = app_info;
	games_desktop_plugin_check_executable (_tmp18_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp19_ = file;
	games_desktop_plugin_check_base_name (_tmp19_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_g_object_unref0 (app_info);
	_g_free0 (path);
	_g_object_unref0 (file);
}


static void games_desktop_plugin_check_displayability (GDesktopAppInfo* app_info, GError** error) {
	GDesktopAppInfo* _tmp0_;
	gboolean _tmp1_;
	GDesktopAppInfo* _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (app_info != NULL);
	_tmp0_ = app_info;
	_tmp1_ = g_desktop_app_info_get_nodisplay (_tmp0_);
	if (_tmp1_) {
		GDesktopAppInfo* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = app_info;
		_tmp3_ = g_desktop_app_info_get_filename (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, _ ("“%s” shouldn’t be displayed."), _tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp6_ = app_info;
	_tmp7_ = g_desktop_app_info_get_is_hidden (_tmp6_);
	if (_tmp7_) {
		GDesktopAppInfo* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		_tmp8_ = app_info;
		_tmp9_ = g_desktop_app_info_get_filename (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, _ ("“%s” is hidden."), _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void games_desktop_plugin_check_categories (GDesktopAppInfo* app_info, GError** error) {
	gchar* categories_string = NULL;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** categories = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint categories_length1;
	gint _categories_size_;
	gchar** _tmp6_ = NULL;
	gint _tmp7_;
	gchar** _tmp8_;
	gint _tmp6__length1;
	gint __tmp6__size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (app_info != NULL);
	_tmp0_ = app_info;
	_tmp1_ = g_desktop_app_info_get_categories (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	categories_string = _tmp2_;
	_tmp3_ = categories_string;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ";", 0);
	categories = _tmp5_;
	categories_length1 = _vala_array_length (_tmp4_);
	_categories_size_ = categories_length1;
	_tmp8_ = games_desktop_plugin_get_categories_black_list (&_tmp7_, &_inner_error_);
	_tmp6_ = _tmp8_;
	_tmp6__length1 = _tmp7_;
	__tmp6__size_ = _tmp6__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (categories_string);
		return;
	}
	{
		gchar** category_collection = NULL;
		gint category_collection_length1 = 0;
		gint _category_collection_size_ = 0;
		gint category_it = 0;
		category_collection = _tmp6_;
		category_collection_length1 = _tmp6__length1;
		for (category_it = 0; category_it < _tmp6__length1; category_it = category_it + 1) {
			gchar* _tmp9_;
			gchar* category = NULL;
			_tmp9_ = g_strdup (category_collection[category_it]);
			category = _tmp9_;
			{
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				_tmp10_ = category;
				_tmp11_ = categories;
				_tmp11__length1 = categories_length1;
				if (_vala_string_array_contains (_tmp11_, _tmp11__length1, _tmp10_)) {
					GDesktopAppInfo* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					GError* _tmp16_;
					_tmp12_ = app_info;
					_tmp13_ = g_desktop_app_info_get_filename (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = category;
					_tmp16_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, _ ("“%s” has blacklisted category “%s”."), _tmp14_, _tmp15_);
					_inner_error_ = _tmp16_;
					g_propagate_error (error, _inner_error_);
					_g_free0 (category);
					_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
					categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (categories_string);
					return;
				}
				_g_free0 (category);
			}
		}
	}
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (categories_string);
}


static void games_desktop_plugin_check_executable (GDesktopAppInfo* app_info, GError** error) {
	gchar* app_executable = NULL;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _tmp4_;
	gchar** _tmp5_;
	gint _tmp3__length1;
	gint __tmp3__size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (app_info != NULL);
	_tmp0_ = app_info;
	_tmp1_ = g_app_info_get_executable ((GAppInfo*) _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	app_executable = _tmp2_;
	_tmp5_ = games_desktop_plugin_get_executable_black_list (&_tmp4_, &_inner_error_);
	_tmp3_ = _tmp5_;
	_tmp3__length1 = _tmp4_;
	__tmp3__size_ = _tmp3__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (app_executable);
		return;
	}
	{
		gchar** executable_collection = NULL;
		gint executable_collection_length1 = 0;
		gint _executable_collection_size_ = 0;
		gint executable_it = 0;
		executable_collection = _tmp3_;
		executable_collection_length1 = _tmp3__length1;
		for (executable_it = 0; executable_it < _tmp3__length1; executable_it = executable_it + 1) {
			gchar* _tmp6_;
			gchar* executable = NULL;
			_tmp6_ = g_strdup (executable_collection[executable_it]);
			executable = _tmp6_;
			{
				gboolean _tmp7_ = FALSE;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = app_executable;
				_tmp9_ = executable;
				if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
					_tmp7_ = TRUE;
				} else {
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gboolean _tmp14_;
					_tmp10_ = app_executable;
					_tmp11_ = executable;
					_tmp12_ = g_strconcat ("/", _tmp11_, NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_str_has_suffix (_tmp10_, _tmp13_);
					_tmp7_ = _tmp14_;
					_g_free0 (_tmp13_);
				}
				if (_tmp7_) {
					GDesktopAppInfo* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					GError* _tmp19_;
					_tmp15_ = app_info;
					_tmp16_ = g_desktop_app_info_get_filename (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = executable;
					_tmp19_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, _ ("“%s” has blacklisted executable “%s”."), _tmp17_, _tmp18_);
					_inner_error_ = _tmp19_;
					g_propagate_error (error, _inner_error_);
					_g_free0 (executable);
					_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (app_executable);
					return;
				}
				_g_free0 (executable);
			}
		}
	}
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (app_executable);
}


static void games_desktop_plugin_check_base_name (GFile* file, GError** error) {
	gchar* base_name = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gint _tmp3_;
	gchar** _tmp4_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	base_name = _tmp1_;
	_tmp4_ = games_desktop_plugin_get_base_name_black_list (&_tmp3_, &_inner_error_);
	_tmp2_ = _tmp4_;
	_tmp2__length1 = _tmp3_;
	__tmp2__size_ = _tmp2__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (base_name);
		return;
	}
	_tmp5_ = base_name;
	if (_vala_string_array_contains (_tmp2_, _tmp2__length1, _tmp5_)) {
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		GError* _tmp10_;
		_tmp6_ = file;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, _ ("“%s” is blacklisted."), _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (base_name);
		return;
	}
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (base_name);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** games_desktop_plugin_get_categories_black_list (int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_desktop_plugin_categories_black_list;
	_tmp0__length1 = games_desktop_plugin_categories_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_ = NULL;
		gint _tmp2_;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_plugin_get_lines_from_resource ("plugins/desktop/blacklists/desktop-categories.blacklist", &_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_plugin_categories_black_list = (_vala_array_free (games_desktop_plugin_categories_black_list, games_desktop_plugin_categories_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_plugin_categories_black_list = _tmp4_;
		games_desktop_plugin_categories_black_list_length1 = _tmp4__length1;
		_games_desktop_plugin_categories_black_list_size_ = games_desktop_plugin_categories_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_plugin_categories_black_list;
	_tmp5__length1 = games_desktop_plugin_categories_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup1 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** games_desktop_plugin_get_executable_black_list (int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_desktop_plugin_executable_black_list;
	_tmp0__length1 = games_desktop_plugin_executable_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_ = NULL;
		gint _tmp2_;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_plugin_get_lines_from_resource ("plugins/desktop/blacklists/desktop-executable.blacklist", &_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_plugin_executable_black_list = (_vala_array_free (games_desktop_plugin_executable_black_list, games_desktop_plugin_executable_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_plugin_executable_black_list = _tmp4_;
		games_desktop_plugin_executable_black_list_length1 = _tmp4__length1;
		_games_desktop_plugin_executable_black_list_size_ = games_desktop_plugin_executable_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_plugin_executable_black_list;
	_tmp5__length1 = games_desktop_plugin_executable_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** games_desktop_plugin_get_base_name_black_list (int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_desktop_plugin_base_name_black_list;
	_tmp0__length1 = games_desktop_plugin_base_name_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_ = NULL;
		gint _tmp2_;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_plugin_get_lines_from_resource ("plugins/desktop/blacklists/desktop-base-name.blacklist", &_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_plugin_base_name_black_list = (_vala_array_free (games_desktop_plugin_base_name_black_list, games_desktop_plugin_base_name_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_plugin_base_name_black_list = _tmp4_;
		games_desktop_plugin_base_name_black_list_length1 = _tmp4__length1;
		_games_desktop_plugin_base_name_black_list_size_ = games_desktop_plugin_base_name_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_plugin_base_name_black_list;
	_tmp5__length1 = games_desktop_plugin_base_name_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup3 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** games_desktop_plugin_get_lines_from_resource (const gchar* resource, int* result_length1, GError** error) {
	gchar** result = NULL;
	GBytes* bytes = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GBytes* _tmp3_;
	GBytes* _tmp4_;
	gchar* text = NULL;
	gsize _tmp5_;
	guint8* _tmp6_;
	gchar* _tmp7_;
	gchar** lines = NULL;
	gchar** _tmp8_;
	gint lines_length1;
	gint _lines_size_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp0_ = resource;
	_tmp1_ = g_strconcat ("/org/gnome/Games/", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_resources_lookup_data (_tmp2_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	bytes = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp6_ = g_bytes_get_data (bytes, &_tmp5_);
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	text = _tmp7_;
	_tmp8_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp8_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp9_ = text;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp11_;
		line_collection_length1 = _vala_array_length (_tmp10_);
		for (line_it = 0; line_it < _vala_array_length (_tmp10_); line_it = line_it + 1) {
			gchar* _tmp12_;
			gchar* line = NULL;
			_tmp12_ = g_strdup (line_collection[line_it]);
			line = _tmp12_;
			{
				const gchar* _tmp13_;
				_tmp13_ = line;
				if (g_strcmp0 (_tmp13_, "") != 0) {
					gchar** _tmp14_;
					gint _tmp14__length1;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = lines;
					_tmp14__length1 = lines_length1;
					_tmp15_ = line;
					_tmp16_ = g_strdup (_tmp15_);
					_vala_array_add1 (&lines, &lines_length1, &_lines_size_, _tmp16_);
				}
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp17_ = lines;
	_tmp17__length1 = lines_length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	_g_free0 (text);
	_g_bytes_unref0 (bytes);
	return result;
}


GamesDesktopPlugin* games_desktop_plugin_construct (GType object_type) {
	GamesDesktopPlugin * self = NULL;
	self = (GamesDesktopPlugin*) g_object_new (object_type, NULL);
	return self;
}


GamesDesktopPlugin* games_desktop_plugin_new (void) {
	return games_desktop_plugin_construct (GAMES_TYPE_DESKTOP_PLUGIN);
}


static void games_desktop_plugin_class_init (GamesDesktopPluginClass * klass) {
	games_desktop_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_desktop_plugin_finalize;
}


static void games_desktop_plugin_games_plugin_interface_init (GamesPluginIface * iface) {
	games_desktop_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_mime_types = (gchar** (*) (GamesPlugin *, int*)) games_desktop_plugin_real_get_mime_types;
	iface->get_uri_sources = (GamesUriSource** (*) (GamesPlugin *, int*)) games_desktop_plugin_real_get_uri_sources;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin *, int*)) games_desktop_plugin_real_get_uri_game_factories;
}


static void games_desktop_plugin_instance_init (GamesDesktopPlugin * self) {
}


static void games_desktop_plugin_finalize (GObject * obj) {
	GamesDesktopPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DESKTOP_PLUGIN, GamesDesktopPlugin);
	G_OBJECT_CLASS (games_desktop_plugin_parent_class)->finalize (obj);
}


GType games_desktop_plugin_get_type (void) {
	return games_desktop_plugin_type_id;
}


GType games_desktop_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesDesktopPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_desktop_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesDesktopPlugin), 0, (GInstanceInitFunc) games_desktop_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_desktop_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_desktop_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesDesktopPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_desktop_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_desktop_plugin_type_id;
}


GType register_games_plugin (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	games_desktop_icon_register_type (module);
	games_desktop_plugin_register_type (module);
	games_desktop_title_register_type (module);
	games_desktop_tracker_uri_query_register_type (module);
	result = GAMES_TYPE_DESKTOP_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



