/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "globus_common.h"

#ifdef TARGET_ARCH_WIN32
#define EAFNOSUPPORT WSAEAFNOSUPPORT
#endif

#ifdef GLOBUS_IMPLEMENT_INET_PTON
int
inet_pton(
    int                                 af,
    const char *                        src,
    void *                              dst)
{
    uint32_t                            addr;
    
    if (af != AF_INET || src == NULL || dst == NULL)
    {
        errno = EAFNOSUPPORT;
        return -1;
    }
    
    addr = inet_addr(src);

    if (addr != 0xffffffff)
    {
        struct in_addr * dstaddr = dst;

        dstaddr->s_addr = addr;

        return 1;
    }
    else
    {
        return 0;
    }
}
#endif /* GLOBUS_IMPLMENENT_INET_PTON */
