/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.jni.FillList;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.jni.JNIDatumLibrary;
import geotrans3.jni.JNIEllipsoidLibrary;
import geotrans3.misc.Info;
import geotrans3.misc.StringHandler;
import geotrans3.utility.Platform;
import geotrans3.utility.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class DeleteDlg
extends JDialog {
    private JNICoordinateConversionService jniCoordinateConversionService;
    private JNIDatumLibrary jniDatumLibrary;
    private JNIEllipsoidLibrary jniEllipsoidLibrary;
    private int listType;
    private int index;
    private boolean deleted;
    private JPanel comboBoxPanel;
    private JLabel deleteLabel;
    private JComboBox comboBox;
    private JPanel buttonsPanel;
    private JButton okButton;
    private JButton cancelButton;

    public DeleteDlg(JNICoordinateConversionService jNICoordinateConversionService, Frame frame, boolean bl, int n) throws CoordinateConversionException {
        super(frame, bl);
        this.jniCoordinateConversionService = jNICoordinateConversionService;
        this.jniDatumLibrary = new JNIDatumLibrary(jNICoordinateConversionService.getDatumLibrary());
        this.jniEllipsoidLibrary = new JNIEllipsoidLibrary(jNICoordinateConversionService.getEllipsoidLibrary());
        this.listType = n;
        this.initComponents();
        this.index = 0;
        this.deleted = false;
        if (this.listType == 0) {
            this.setTitle("Delete Datum");
            this.deleteLabel.setText("Datum:");
            new FillList(this.jniDatumLibrary, this.jniEllipsoidLibrary, this.comboBox, 0);
        } else {
            this.setTitle("Delete Ellipsoid");
            this.deleteLabel.setText("Ellipsoid:");
            new FillList(this.jniDatumLibrary, this.jniEllipsoidLibrary, this.comboBox, 1);
        }
        this.pack();
        Utility.center(frame, this);
        if (Platform.isJavaV1_3) {
            this.deleteLabel.setForeground(Color.black);
        }
        if (Platform.isUnix) {
            this.deleteLabel.setFont(new Font("Dialog", 1, 10));
            this.comboBox.setFont(new Font("Dialog", 1, 10));
            this.okButton.setFont(new Font("Dialog", 1, 10));
            this.cancelButton.setFont(new Font("Dialog", 1, 10));
        }
    }

    private void initComponents() {
        this.comboBoxPanel = new JPanel();
        this.deleteLabel = new JLabel();
        this.comboBox = new JComboBox();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("DELETE ");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DeleteDlg.this.closeDialog(windowEvent);
            }
        });
        this.comboBoxPanel.setLayout(new GridBagLayout());
        this.deleteLabel.setHorizontalAlignment(2);
        this.deleteLabel.setText("Select Datum");
        this.deleteLabel.setAlignmentX(1.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 20, 0, 20);
        gridBagConstraints.anchor = 18;
        this.comboBoxPanel.add((Component)this.deleteLabel, gridBagConstraints);
        this.comboBox.setMaximumRowCount(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 20, 10, 20);
        gridBagConstraints.anchor = 17;
        this.comboBoxPanel.add((Component)this.comboBox, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.getContentPane().add((Component)this.comboBoxPanel, gridBagConstraints2);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.okButton.setMnemonic(79);
        this.okButton.setText("OK");
        this.okButton.setBorder(new BevelBorder(0));
        this.okButton.setMaximumSize(new Dimension(43, 22));
        this.okButton.setMinimumSize(new Dimension(43, 22));
        this.okButton.setPreferredSize(new Dimension(43, 22));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeleteDlg.this.okActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.ipadx = 25;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints3);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setBorder(new BevelBorder(0));
        this.cancelButton.setMaximumSize(new Dimension(43, 22));
        this.cancelButton.setMinimumSize(new Dimension(43, 22));
        this.cancelButton.setPreferredSize(new Dimension(43, 22));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeleteDlg.this.cancelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.ipadx = 25;
        gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 8, 0);
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints2);
    }

    private void cancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
        this.deleted = false;
    }

    private void okActionPerformed(ActionEvent actionEvent) {
        this.deleted = false;
        StringHandler stringHandler = new StringHandler();
        this.index = this.comboBox.getSelectedIndex();
        try {
            if (this.listType == 0) {
                Info info = this.jniDatumLibrary.getDatumInfo(this.index);
                this.jniDatumLibrary.removeDatum(info.getCode());
            } else {
                Info info = this.jniEllipsoidLibrary.getEllipsoidInfo(this.index);
                this.jniEllipsoidLibrary.removeEllipsoid(info.getCode());
            }
            this.setVisible(false);
            this.dispose();
            this.deleted = true;
        }
        catch (CoordinateConversionException coordinateConversionException) {
            stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
        this.deleted = false;
    }

    public static void main(String[] stringArray) {
    }

    public int getIndex() {
        return this.index;
    }

    public boolean getDeleted() {
        return this.deleted;
    }
}

