/*
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

/* ================================================================================

     Project      :   ADSP-BF608
     File         :   defBF608.h
     Description  :   Register Definitions

     Date         :   06-07-2012
     Tag          :   BF60X_TOOLS_CCES_1_0_1

     Copyright (c) 2011-2012 Analog Devices, Inc.  All Rights Reserved.
     This software is proprietary and confidential to Analog Devices, Inc. and
     its licensors.

     This file was auto-generated. Do not make local changes to this file.

   ================================================================================ */

#ifndef _DEF_BF608_H
#define _DEF_BF608_H

#if defined (_MISRA_RULES)
#pragma diag(push)
#pragma diag(suppress:misra_rule_19_7:"ADI header allows function-like macros")
#pragma diag(suppress:misra_rule_19_13:"ADI headers can use the # and ## preprocessor operators")
#endif /* _MISRA_RULES */

/* do not add casts to literal constants in assembly code */
#if defined(_LANGUAGE_ASM) || defined(__ASSEMBLER__)
#define _ADI_MSK( mask, type ) (mask) /* Make a bitmask */
#else
#define _ADI_MSK( mask, type ) ((type)(mask)) /* Make a bitmask */
#endif

#ifdef _MISRA_RULES
#pragma diag(pop)
#endif /* _MISRA_RULES */

#ifndef __ADI_GENERATED_DEF_HEADERS__
#define __ADI_GENERATED_DEF_HEADERS__    1
#endif

/* MMR modules defined for the ADSP-BF608 */

#define __ADI_HAS_SYS__           1
#define __ADI_HAS_SIMENV__        1
#define __ADI_HAS_CNT__           1
#define __ADI_HAS_RSI__           1
#define __ADI_HAS_CAN__           1
#define __ADI_HAS_LP__            1
#define __ADI_HAS_TIMER__         1
#define __ADI_HAS_CRC__           1
#define __ADI_HAS_TWI__           1
#define __ADI_HAS_UART__          1
#define __ADI_HAS_PORT__          1
#define __ADI_HAS_PADS__          1
#define __ADI_HAS_PINT__          1
#define __ADI_HAS_SMC__           1
#define __ADI_HAS_WDOG__          1
#define __ADI_HAS_EPPI__          1
#define __ADI_HAS_PIXC__          1
#define __ADI_HAS_PVP__           1
#define __ADI_HAS_PWM__           1
#define __ADI_HAS_VID__           1
#define __ADI_HAS_SWU__           1
#define __ADI_HAS_SDU__           1
#define __ADI_HAS_EMAC__          1
#define __ADI_HAS_SPORT__         1
#define __ADI_HAS_SPI__           1
#define __ADI_HAS_DMA__           1
#define __ADI_HAS_ACM__           1
#define __ADI_HAS_DMC__           1
#define __ADI_HAS_SCB__           1
#define __ADI_HAS_L2CTL__         1
#define __ADI_HAS_SEC__           1
#define __ADI_HAS_TRU__           1
#define __ADI_HAS_RCU__           1
#define __ADI_HAS_SPU__           1
#define __ADI_HAS_CGU__           1
#define __ADI_HAS_DPM__           1
#define __ADI_HAS_EFS__           1
#define __ADI_HAS_USB__           1
#define __ADI_HAS_L1DM__          1
#define __ADI_HAS_L1IM__          1
#define __ADI_HAS_ICU__           1
#define __ADI_HAS_TMR__           1
#define __ADI_HAS_DBG__           1
#define __ADI_HAS_TB__            1
#define __ADI_HAS_WP__            1
#define __ADI_HAS_PF__            1

/* =========================
        REGFILE
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        ASTAT                                Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_ASTAT_VS                        25                               /* Sticky version of ASTAT_V */
#define BITP_ASTAT_V                         24                               /* Overflow Flag */
#define BITP_ASTAT_AV1S                      19                               /* Sticky Overflow Flag 1 */
#define BITP_ASTAT_AV1                       18                               /* Overflow Flag 1 */
#define BITP_ASTAT_AV0S                      17                               /* Sticky Overflow Flag 0 */
#define BITP_ASTAT_AV0                       16                               /* Overflow Flag 0 */
#define BITP_ASTAT_AC1                       13                               /* Carry Flag 1 */
#define BITP_ASTAT_AC0                       12                               /* Carry Flag 0 */
#define BITP_ASTAT_RND_MOD                    8                               /* Rounding Mode */
#define BITP_ASTAT_AQ                         6                               /* Quotient Bit */
#define BITP_ASTAT_CC                         5                               /* Condition Code */
#define BITP_ASTAT_V_COPY                     3                               /* Overflow Flag */
#define BITP_ASTAT_AC0_COPY                   2                               /* Carry Flag 0 */
#define BITP_ASTAT_AN                         1                               /* Negative Flag */
#define BITP_ASTAT_AZ                         0                               /* Zero Flag */
#define BITM_ASTAT_VS                        (_ADI_MSK(0x02000000,uint32_t))  /* Sticky version of ASTAT_V */
#define BITM_ASTAT_V                         (_ADI_MSK(0x01000000,uint32_t))  /* Overflow Flag */
#define BITM_ASTAT_AV1S                      (_ADI_MSK(0x00080000,uint32_t))  /* Sticky Overflow Flag 1 */
#define BITM_ASTAT_AV1                       (_ADI_MSK(0x00040000,uint32_t))  /* Overflow Flag 1 */
#define BITM_ASTAT_AV0S                      (_ADI_MSK(0x00020000,uint32_t))  /* Sticky Overflow Flag 0 */
#define BITM_ASTAT_AV0                       (_ADI_MSK(0x00010000,uint32_t))  /* Overflow Flag 0 */
#define BITM_ASTAT_AC1                       (_ADI_MSK(0x00002000,uint32_t))  /* Carry Flag 1 */
#define BITM_ASTAT_AC0                       (_ADI_MSK(0x00001000,uint32_t))  /* Carry Flag 0 */
#define BITM_ASTAT_RND_MOD                   (_ADI_MSK(0x00000100,uint32_t))  /* Rounding Mode */
#define BITM_ASTAT_AQ                        (_ADI_MSK(0x00000040,uint32_t))  /* Quotient Bit */
#define BITM_ASTAT_CC                        (_ADI_MSK(0x00000020,uint32_t))  /* Condition Code */
#define BITM_ASTAT_V_COPY                    (_ADI_MSK(0x00000008,uint32_t))  /* Overflow Flag */
#define BITM_ASTAT_AC0_COPY                  (_ADI_MSK(0x00000004,uint32_t))  /* Carry Flag 0 */
#define BITM_ASTAT_AN                        (_ADI_MSK(0x00000002,uint32_t))  /* Negative Flag */
#define BITM_ASTAT_AZ                        (_ADI_MSK(0x00000001,uint32_t))  /* Zero Flag */

/* ------------------------------------------------------------------------------------------------------------------------
        LT                                   Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_LT_ADDR                          1                               /* Loop Top Address */
#define BITP_LT_LSB                           0
#define BITM_LT_ADDR                         (_ADI_MSK(0xFFFFFFFE,uint32_t))  /* Loop Top Address */
#define BITM_LT_LSB                          (_ADI_MSK(0x00000001,uint32_t))

/* ------------------------------------------------------------------------------------------------------------------------
        SEQSTAT                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SEQSTAT_NSPECABT                19                               /* Nonspeculative access was aborted */
#define BITP_SEQSTAT_HWERRCAUSE              14                               /* Holds cause of last hardware error generated by the core */
#define BITP_SEQSTAT_SFTRESET                13                               /* Indicates whether the last reset was a software reset */
#define BITP_SEQSTAT_ITESTABT                12                               /* ITEST_COMMAND was aborted */
#define BITP_SEQSTAT_DTESTABT                11                               /* DTEST_COMMAND was aborted */
#define BITP_SEQSTAT_SYSNMI                  10                               /* System NMI Input Active */
#define BITP_SEQSTAT_PEIC                     9                               /* Parity Error on Instruction L1 Read for Core */
#define BITP_SEQSTAT_PEDC                     8                               /* Parity Error on Data L1 Read for Core */
#define BITP_SEQSTAT_PEIX                     7                               /* Parity Error on Instruction L1 Read for L2 Transfer */
#define BITP_SEQSTAT_PEDX                     6                               /* Parity Error on Data L1 Read for L2 Transfer */
#define BITP_SEQSTAT_EXCAUSE                  0                               /* Holds cause of last-executed exception */
#define BITM_SEQSTAT_NSPECABT                (_ADI_MSK(0x00080000,uint32_t))  /* Nonspeculative access was aborted */
#define BITM_SEQSTAT_HWERRCAUSE              (_ADI_MSK(0x0007C000,uint32_t))  /* Holds cause of last hardware error generated by the core */
#define BITM_SEQSTAT_SFTRESET                (_ADI_MSK(0x00002000,uint32_t))  /* Indicates whether the last reset was a software reset */
#define BITM_SEQSTAT_ITESTABT                (_ADI_MSK(0x00001000,uint32_t))  /* ITEST_COMMAND was aborted */
#define BITM_SEQSTAT_DTESTABT                (_ADI_MSK(0x00000800,uint32_t))  /* DTEST_COMMAND was aborted */
#define BITM_SEQSTAT_SYSNMI                  (_ADI_MSK(0x00000400,uint32_t))  /* System NMI Input Active */
#define BITM_SEQSTAT_PEIC                    (_ADI_MSK(0x00000200,uint32_t))  /* Parity Error on Instruction L1 Read for Core */
#define BITM_SEQSTAT_PEDC                    (_ADI_MSK(0x00000100,uint32_t))  /* Parity Error on Data L1 Read for Core */
#define BITM_SEQSTAT_PEIX                    (_ADI_MSK(0x00000080,uint32_t))  /* Parity Error on Instruction L1 Read for L2 Transfer */
#define BITM_SEQSTAT_PEDX                    (_ADI_MSK(0x00000040,uint32_t))  /* Parity Error on Data L1 Read for L2 Transfer */

#define BITM_SEQSTAT_EXCAUSE                 (_ADI_MSK(0x0000003F,uint32_t))  /* Holds cause of last-executed exception */
#define ENUM_SEQSTAT_EXINST                  (_ADI_MSK(0x00000000,uint32_t))  /* EXCAUSE: EXCPT Instruction */
#define ENUM_SEQSTAT_SSTEP                   (_ADI_MSK(0x00000010,uint32_t))  /* EXCAUSE: Single Step */
#define ENUM_SEQSTAT_EMUTROV                 (_ADI_MSK(0x00000011,uint32_t))  /* EXCAUSE: Trace Buffer */
#define ENUM_SEQSTAT_UNDEFINST               (_ADI_MSK(0x00000021,uint32_t))  /* EXCAUSE: Undefined Instruction */
#define ENUM_SEQSTAT_ILLCOMB                 (_ADI_MSK(0x00000022,uint32_t))  /* EXCAUSE: Illegal Combination */
#define ENUM_SEQSTAT_DAGPROTVIOL             (_ADI_MSK(0x00000023,uint32_t))  /* EXCAUSE: DAG Protection Violation */
#define ENUM_SEQSTAT_DAGALGN                 (_ADI_MSK(0x00000024,uint32_t))  /* EXCAUSE: DAG Misaligned Access */
#define ENUM_SEQSTAT_UNRECOVER               (_ADI_MSK(0x00000025,uint32_t))  /* EXCAUSE: Unrecoverable Event */
#define ENUM_SEQSTAT_DAGCPLBMISS             (_ADI_MSK(0x00000026,uint32_t))  /* EXCAUSE: DAG CPLB Miss */
#define ENUM_SEQSTAT_DAGMCPLBH               (_ADI_MSK(0x00000027,uint32_t))  /* EXCAUSE: DAG Multiple CPLB Hits */
#define ENUM_SEQSTAT_EMUWPMATCH              (_ADI_MSK(0x00000028,uint32_t))  /* EXCAUSE: Watchpoint Match */
#define ENUM_SEQSTAT_IFALGN                  (_ADI_MSK(0x0000002A,uint32_t))  /* EXCAUSE: I-Fetch Misaligned Access */
#define ENUM_SEQSTAT_IFPROTVIOL              (_ADI_MSK(0x0000002B,uint32_t))  /* EXCAUSE: I-Fetch Protection Violation */
#define ENUM_SEQSTAT_IFCPLBMISS              (_ADI_MSK(0x0000002C,uint32_t))  /* EXCAUSE: I-Fetch CPLB Miss */
#define ENUM_SEQSTAT_IFMCPLBH                (_ADI_MSK(0x0000002D,uint32_t))  /* EXCAUSE: I-Fetch Multiple CPLB Hits */
#define ENUM_SEQSTAT_PROTVIOL                (_ADI_MSK(0x0000002E,uint32_t))  /* EXCAUSE: Illegal use superv. res */

/* ------------------------------------------------------------------------------------------------------------------------
        SYSCFG                               Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SYSCFG_SNEN                      2                               /* Self-Nesting Interrupt Enable */
#define BITP_SYSCFG_CCEN                      1                               /* Enable cycle counter */
#define BITP_SYSCFG_SSSTEP                    0                               /* Supervisor single step */
#define BITM_SYSCFG_SNEN                     (_ADI_MSK(0x00000004,uint32_t))  /* Self-Nesting Interrupt Enable */
#define BITM_SYSCFG_CCEN                     (_ADI_MSK(0x00000002,uint32_t))  /* Enable cycle counter */
#define BITM_SYSCFG_SSSTEP                   (_ADI_MSK(0x00000001,uint32_t))  /* Supervisor single step */

/* ==================================================
        CNT Registers
   ================================================== */

/* =========================
        CNT0
   ========================= */
#define REG_CNT0_CFG                    0xFFC00400         /* CNT0 Configuration Register */
#define REG_CNT0_IMSK                   0xFFC00404         /* CNT0 Interrupt Mask Register */
#define REG_CNT0_STAT                   0xFFC00408         /* CNT0 Status Register */
#define REG_CNT0_CMD                    0xFFC0040C         /* CNT0 Command Register */
#define REG_CNT0_DEBNCE                 0xFFC00410         /* CNT0 Debounce Register */
#define REG_CNT0_CNTR                   0xFFC00414         /* CNT0 Counter Register */
#define REG_CNT0_MAX                    0xFFC00418         /* CNT0 Maximum Count Register */
#define REG_CNT0_MIN                    0xFFC0041C         /* CNT0 Minimum Count Register */

/* =========================
        CNT
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        CNT_CFG                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CNT_CFG_INPDIS                  15                               /* CUD and CDG Pin Input Disable */
#define BITP_CNT_CFG_BNDMODE                 12                               /* Boundary Register Mode */
#define BITP_CNT_CFG_ZMZC                    11                               /* CZM Zeroes Counter Enable */
#define BITP_CNT_CFG_CNTMODE                  8                               /* Counter Operating Mode */
#define BITP_CNT_CFG_CZMINV                   6                               /* CZM Pin Polarity Invert */
#define BITP_CNT_CFG_CUDINV                   5                               /* CUD Pin Polarity Invert */
#define BITP_CNT_CFG_CDGINV                   4                               /* CDG Pin Polarity Invert */
#define BITP_CNT_CFG_DEBEN                    1                               /* Debounce Enable */
#define BITP_CNT_CFG_EN                       0                               /* Counter Enable */

#define BITM_CNT_CFG_INPDIS                  (_ADI_MSK(0x00008000,uint16_t))  /* CUD and CDG Pin Input Disable */
#define ENUM_CNT_CFG_NO_INPDIS               (_ADI_MSK(0x00000000,uint16_t))  /* INPDIS: Enable */
#define ENUM_CNT_CFG_INPDIS                  (_ADI_MSK(0x00008000,uint16_t))  /* INPDIS: Pin Input Disable */

#define BITM_CNT_CFG_BNDMODE                 (_ADI_MSK(0x00003000,uint16_t))  /* Boundary Register Mode */
#define ENUM_CNT_CFG_BNDMODE_BNDCOMP         (_ADI_MSK(0x00000000,uint16_t))  /* BNDMODE: BND_COMP */
#define ENUM_CNT_CFG_BNDMODE_BINENC          (_ADI_MSK(0x00001000,uint16_t))  /* BNDMODE: BIN_ENC */
#define ENUM_CNT_CFG_BNDMODE_BNDCAPT         (_ADI_MSK(0x00002000,uint16_t))  /* BNDMODE: BND_CAPT */
#define ENUM_CNT_CFG_BNDMODE_BNDAEXT         (_ADI_MSK(0x00003000,uint16_t))  /* BNDMODE: BND_AEXT */

#define BITM_CNT_CFG_ZMZC                    (_ADI_MSK(0x00000800,uint16_t))  /* CZM Zeroes Counter Enable */
#define ENUM_CNT_CFG_ZMZC_DIS                (_ADI_MSK(0x00000000,uint16_t))  /* ZMZC: Disable */
#define ENUM_CNT_CFG_ZMZC_EN                 (_ADI_MSK(0x00000800,uint16_t))  /* ZMZC: Enable */

#define BITM_CNT_CFG_CNTMODE                 (_ADI_MSK(0x00000700,uint16_t))  /* Counter Operating Mode */
#define ENUM_CNT_CFG_CNTMODE_QUADENC         (_ADI_MSK(0x00000000,uint16_t))  /* CNTMODE: QUAD_ENC */
#define ENUM_CNT_CFG_CNTMODE_BINENC          (_ADI_MSK(0x00000100,uint16_t))  /* CNTMODE: BIN_ENC */
#define ENUM_CNT_CFG_CNTMODE_UDCNT           (_ADI_MSK(0x00000200,uint16_t))  /* CNTMODE: UD_CNT */
#define ENUM_CNT_CFG_CNTMODE_DIRCNT          (_ADI_MSK(0x00000400,uint16_t))  /* CNTMODE: DIR_CNT */
#define ENUM_CNT_CFG_CNTMODE_DIRTMR          (_ADI_MSK(0x00000500,uint16_t))  /* CNTMODE: DIR_TMR */

#define BITM_CNT_CFG_CZMINV                  (_ADI_MSK(0x00000040,uint16_t))  /* CZM Pin Polarity Invert */
#define ENUM_CNT_CFG_CZMINV_AHI              (_ADI_MSK(0x00000000,uint16_t))  /* CZMINV: Active High, Rising Edge */
#define ENUM_CNT_CFG_CZMINV_ALO              (_ADI_MSK(0x00000040,uint16_t))  /* CZMINV: Active Low, Falling Edge */

#define BITM_CNT_CFG_CUDINV                  (_ADI_MSK(0x00000020,uint16_t))  /* CUD Pin Polarity Invert */
#define ENUM_CNT_CFG_CUDINV_AHI              (_ADI_MSK(0x00000000,uint16_t))  /* CUDINV: Active High, Rising Edge */
#define ENUM_CNT_CFG_CUDINV_ALO              (_ADI_MSK(0x00000020,uint16_t))  /* CUDINV: Active Low, Falling Edge */

#define BITM_CNT_CFG_CDGINV                  (_ADI_MSK(0x00000010,uint16_t))  /* CDG Pin Polarity Invert */
#define ENUM_CNT_CFG_CDGINV_AHI              (_ADI_MSK(0x00000000,uint16_t))  /* CDGINV: Active High, Rising Edge */
#define ENUM_CNT_CFG_CDGINV_ALO              (_ADI_MSK(0x00000010,uint16_t))  /* CDGINV: Active Low, Falling Edge */

#define BITM_CNT_CFG_DEBEN                   (_ADI_MSK(0x00000002,uint16_t))  /* Debounce Enable */
#define ENUM_CNT_CFG_DEBDIS                  (_ADI_MSK(0x00000000,uint16_t))  /* DEBEN: Disable */
#define ENUM_CNT_CFG_DEBEN                   (_ADI_MSK(0x00000002,uint16_t))  /* DEBEN: Enable */

#define BITM_CNT_CFG_EN                      (_ADI_MSK(0x00000001,uint16_t))  /* Counter Enable */
#define ENUM_CNT_CFG_CNTDIS                  (_ADI_MSK(0x00000000,uint16_t))  /* EN: Counter Disable */
#define ENUM_CNT_CFG_CNTEN                   (_ADI_MSK(0x00000001,uint16_t))  /* EN: Counter Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        CNT_IMSK                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CNT_IMSK_CZMZ                   10                               /* Counter Zeroed by Zero Marker Interrupt Enable */
#define BITP_CNT_IMSK_CZME                    9                               /* Zero Marker Error Interrupt Enable */
#define BITP_CNT_IMSK_CZM                     8                               /* CZM Pin / Pushbutton Interrupt Enable */
#define BITP_CNT_IMSK_CZERO                   7                               /* CNT_CNTR Counts To Zero Interrupt Enable */
#define BITP_CNT_IMSK_COV15                   6                               /* Bit 15 Overflow Interrupt Enable */
#define BITP_CNT_IMSK_COV31                   5                               /* Bit 31 Overflow Interrupt Enable */
#define BITP_CNT_IMSK_MAXC                    4                               /* Max Count Interrupt Enable */
#define BITP_CNT_IMSK_MINC                    3                               /* Min Count Interrupt Enable */
#define BITP_CNT_IMSK_DC                      2                               /* Downcount Interrupt enable */
#define BITP_CNT_IMSK_UC                      1                               /* Upcount Interrupt Enable */
#define BITP_CNT_IMSK_IC                      0                               /* Illegal Gray/Binary Code Interrupt Enable */

#define BITM_CNT_IMSK_CZMZ                   (_ADI_MSK(0x00000400,uint16_t))  /* Counter Zeroed by Zero Marker Interrupt Enable */
#define ENUM_CNT_IMSK_CZMZ_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* CZMZ: Mask Interrupt */
#define ENUM_CNT_IMSK_CZMZ_UMSK              (_ADI_MSK(0x00000400,uint16_t))  /* CZMZ: Unmask Interrupt */

#define BITM_CNT_IMSK_CZME                   (_ADI_MSK(0x00000200,uint16_t))  /* Zero Marker Error Interrupt Enable */
#define ENUM_CNT_IMSK_CZME_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* CZME: Mask Interrupt */
#define ENUM_CNT_IMSK_CZME_UMSK              (_ADI_MSK(0x00000200,uint16_t))  /* CZME: Unmask Interrupt */

#define BITM_CNT_IMSK_CZM                    (_ADI_MSK(0x00000100,uint16_t))  /* CZM Pin / Pushbutton Interrupt Enable */
#define ENUM_CNT_IMSK_CZM_MSK                (_ADI_MSK(0x00000000,uint16_t))  /* CZM: Mask Interrupt */
#define ENUM_CNT_IMSK_CZM_UMSK               (_ADI_MSK(0x00000100,uint16_t))  /* CZM: Unmask Interrupt */

#define BITM_CNT_IMSK_CZERO                  (_ADI_MSK(0x00000080,uint16_t))  /* CNT_CNTR Counts To Zero Interrupt Enable */
#define ENUM_CNT_IMSK_CZERO_MSK              (_ADI_MSK(0x00000000,uint16_t))  /* CZERO: Mask Interrupt */
#define ENUM_CNT_IMSK_CZERO_UMSK             (_ADI_MSK(0x00000080,uint16_t))  /* CZERO: Unmask Interrupt */

#define BITM_CNT_IMSK_COV15                  (_ADI_MSK(0x00000040,uint16_t))  /* Bit 15 Overflow Interrupt Enable */
#define ENUM_CNT_IMSK_COV15_MSK              (_ADI_MSK(0x00000000,uint16_t))  /* COV15: Mask Interrupt */
#define ENUM_CNT_IMSK_COV15_UMSK             (_ADI_MSK(0x00000040,uint16_t))  /* COV15: Unmask Interrupt */

#define BITM_CNT_IMSK_COV31                  (_ADI_MSK(0x00000020,uint16_t))  /* Bit 31 Overflow Interrupt Enable */
#define ENUM_CNT_IMSK_COV31_MSK              (_ADI_MSK(0x00000000,uint16_t))  /* COV31: Mask Interrupt */
#define ENUM_CNT_IMSK_COV31_UMSK             (_ADI_MSK(0x00000020,uint16_t))  /* COV31: Unmask Interrupt */

#define BITM_CNT_IMSK_MAXC                   (_ADI_MSK(0x00000010,uint16_t))  /* Max Count Interrupt Enable */
#define ENUM_CNT_IMSK_MAXC_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* MAXC: Mask Interrupt */
#define ENUM_CNT_IMSK_MAXC_UMSK              (_ADI_MSK(0x00000010,uint16_t))  /* MAXC: Unmask Interrupt */

#define BITM_CNT_IMSK_MINC                   (_ADI_MSK(0x00000008,uint16_t))  /* Min Count Interrupt Enable */
#define ENUM_CNT_IMSK_MINC_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* MINC: Mask Interrupt */
#define ENUM_CNT_IMSK_MINC_UMSK              (_ADI_MSK(0x00000008,uint16_t))  /* MINC: Unmask Interrupt */

#define BITM_CNT_IMSK_DC                     (_ADI_MSK(0x00000004,uint16_t))  /* Downcount Interrupt enable */
#define ENUM_CNT_IMSK_DC_MSK                 (_ADI_MSK(0x00000000,uint16_t))  /* DC: Mask Interrupt */
#define ENUM_CNT_IMSK_DC_UMSK                (_ADI_MSK(0x00000004,uint16_t))  /* DC: Unmask Interrupt */

#define BITM_CNT_IMSK_UC                     (_ADI_MSK(0x00000002,uint16_t))  /* Upcount Interrupt Enable */
#define ENUM_CNT_IMSK_UC_MSK                 (_ADI_MSK(0x00000000,uint16_t))  /* UC: Mask Interrupt */
#define ENUM_CNT_IMSK_UC_UMSK                (_ADI_MSK(0x00000002,uint16_t))  /* UC: Unmask Interrupt */

#define BITM_CNT_IMSK_IC                     (_ADI_MSK(0x00000001,uint16_t))  /* Illegal Gray/Binary Code Interrupt Enable */
#define ENUM_CNT_IMSK_IC_MSK                 (_ADI_MSK(0x00000000,uint16_t))  /* IC: Mask Interrupt */
#define ENUM_CNT_IMSK_IC_UMSK                (_ADI_MSK(0x00000001,uint16_t))  /* IC: Unmask Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        CNT_STAT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CNT_STAT_CZMZ                   10                               /* Counter Zeroed By Zero Marker interrupt */
#define BITP_CNT_STAT_CZME                    9                               /* Zero Marker Error interrupt */
#define BITP_CNT_STAT_CZM                     8                               /* CZM Pin/Pushbutton interrupt */
#define BITP_CNT_STAT_CZERO                   7                               /* CNT_CNTR Counts To Zero interrupt */
#define BITP_CNT_STAT_COV15                   6                               /* Bit 15 overflow interrupt */
#define BITP_CNT_STAT_COV31                   5                               /* Bit 31 overflow interrupt */
#define BITP_CNT_STAT_MAXC                    4                               /* Max interrupt */
#define BITP_CNT_STAT_MINC                    3                               /* Min interrupt */
#define BITP_CNT_STAT_DC                      2                               /* Downcount interrupt */
#define BITP_CNT_STAT_UC                      1                               /* Upcount interrupt */
#define BITP_CNT_STAT_IC                      0                               /* Illegal gray/binary code interrupt */
#define BITM_CNT_STAT_CZMZ                   (_ADI_MSK(0x00000400,uint16_t))  /* Counter Zeroed By Zero Marker interrupt */
#define BITM_CNT_STAT_CZME                   (_ADI_MSK(0x00000200,uint16_t))  /* Zero Marker Error interrupt */
#define BITM_CNT_STAT_CZM                    (_ADI_MSK(0x00000100,uint16_t))  /* CZM Pin/Pushbutton interrupt */
#define BITM_CNT_STAT_CZERO                  (_ADI_MSK(0x00000080,uint16_t))  /* CNT_CNTR Counts To Zero interrupt */
#define BITM_CNT_STAT_COV15                  (_ADI_MSK(0x00000040,uint16_t))  /* Bit 15 overflow interrupt */
#define BITM_CNT_STAT_COV31                  (_ADI_MSK(0x00000020,uint16_t))  /* Bit 31 overflow interrupt */
#define BITM_CNT_STAT_MAXC                   (_ADI_MSK(0x00000010,uint16_t))  /* Max interrupt */
#define BITM_CNT_STAT_MINC                   (_ADI_MSK(0x00000008,uint16_t))  /* Min interrupt */
#define BITM_CNT_STAT_DC                     (_ADI_MSK(0x00000004,uint16_t))  /* Downcount interrupt */
#define BITM_CNT_STAT_UC                     (_ADI_MSK(0x00000002,uint16_t))  /* Upcount interrupt */
#define BITM_CNT_STAT_IC                     (_ADI_MSK(0x00000001,uint16_t))  /* Illegal gray/binary code interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        CNT_CMD                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CNT_CMD_W1ZMONCE                12                               /* Write 1 Zero Marker Clear Once Enable */
#define BITP_CNT_CMD_W1LMAXMIN               10                               /* Write 1 MAX copy from MIN */
#define BITP_CNT_CMD_W1LMAXCNT                9                               /* Write 1 MAX capture from CNTR */
#define BITP_CNT_CMD_W1LMAXZERO               8                               /* Write 1 MAX to zero */
#define BITP_CNT_CMD_W1LMINMAX                7                               /* Write 1 MIN copy from MAX */
#define BITP_CNT_CMD_W1LMINCNT                5                               /* Write 1 MIN capture from CNTR */
#define BITP_CNT_CMD_W1LMINZERO               4                               /* Write 1 MIN to zero */
#define BITP_CNT_CMD_W1LCNTMAX                3                               /* Write 1 CNTR load from MAX */
#define BITP_CNT_CMD_W1LCNTMIN                2                               /* Write 1 CNTR load from MIN */
#define BITP_CNT_CMD_W1LCNTZERO               0                               /* Write 1 CNTR to zero */
#define BITM_CNT_CMD_W1ZMONCE                (_ADI_MSK(0x00001000,uint16_t))  /* Write 1 Zero Marker Clear Once Enable */
#define BITM_CNT_CMD_W1LMAXMIN               (_ADI_MSK(0x00000400,uint16_t))  /* Write 1 MAX copy from MIN */
#define BITM_CNT_CMD_W1LMAXCNT               (_ADI_MSK(0x00000200,uint16_t))  /* Write 1 MAX capture from CNTR */
#define BITM_CNT_CMD_W1LMAXZERO              (_ADI_MSK(0x00000100,uint16_t))  /* Write 1 MAX to zero */
#define BITM_CNT_CMD_W1LMINMAX               (_ADI_MSK(0x00000080,uint16_t))  /* Write 1 MIN copy from MAX */
#define BITM_CNT_CMD_W1LMINCNT               (_ADI_MSK(0x00000020,uint16_t))  /* Write 1 MIN capture from CNTR */
#define BITM_CNT_CMD_W1LMINZERO              (_ADI_MSK(0x00000010,uint16_t))  /* Write 1 MIN to zero */
#define BITM_CNT_CMD_W1LCNTMAX               (_ADI_MSK(0x00000008,uint16_t))  /* Write 1 CNTR load from MAX */
#define BITM_CNT_CMD_W1LCNTMIN               (_ADI_MSK(0x00000004,uint16_t))  /* Write 1 CNTR load from MIN */
#define BITM_CNT_CMD_W1LCNTZERO              (_ADI_MSK(0x00000001,uint16_t))  /* Write 1 CNTR to zero */

/* ------------------------------------------------------------------------------------------------------------------------
        CNT_DEBNCE                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CNT_DEBNCE_DPRESCALE             0                               /* Debounce Prescale */
#define BITM_CNT_DEBNCE_DPRESCALE            (_ADI_MSK(0x0000001F,uint16_t))  /* Debounce Prescale */

/* ==================================================
        RSI Registers
   ================================================== */

/* =========================
        RSI0
   ========================= */
#define REG_RSI0_CTL                    0xFFC00604         /* RSI0 Control Register */
#define REG_RSI0_ARG                    0xFFC00608         /* RSI0 Argument Register */
#define REG_RSI0_CMD                    0xFFC0060C         /* RSI0 Command Register */
#define REG_RSI0_RESP_CMD               0xFFC00610         /* RSI0 Response Command Register */
#define REG_RSI0_RESP0                  0xFFC00614         /* RSI0 Response 0 Register */
#define REG_RSI0_RESP1                  0xFFC00618         /* RSI0 Response 1 Register */
#define REG_RSI0_RESP2                  0xFFC0061C         /* RSI0 Response 2 Register */
#define REG_RSI0_RESP3                  0xFFC00620         /* RSI0 Response 3 Register */
#define REG_RSI0_DATA_TMR               0xFFC00624         /* RSI0 Data Timer Register */
#define REG_RSI0_DATA_LEN               0xFFC00628         /* RSI0 Data Length Register */
#define REG_RSI0_DATA_CTL               0xFFC0062C         /* RSI0 Data Control Register */
#define REG_RSI0_DATA_CNT               0xFFC00630         /* RSI0 Data Count Register */
#define REG_RSI0_XFRSTAT                0xFFC00634         /* RSI0 Status Register */
#define REG_RSI0_XFRSTAT_CLR            0xFFC00638         /* RSI0 Status Clear Register */
#define REG_RSI0_XFR_IMSK0              0xFFC0063C         /* RSI0 Interrupt 0 Mask Register */
#define REG_RSI0_XFR_IMSK1              0xFFC00640         /* RSI0 Interrupt 1 Mask Register */
#define REG_RSI0_FIFO_CNT               0xFFC00648         /* RSI0 FIFO Counter Register */
#define REG_RSI0_CEATA                  0xFFC0064C         /* RSI0 This register contains bit to dis CCS gen */
#define REG_RSI0_BOOT_TCNTR             0xFFC00650         /* RSI0 Boot Timing Counter Register */
#define REG_RSI0_BACK_TOUT              0xFFC00654         /* RSI0 Boot Acknowledge Timeout Register */
#define REG_RSI0_SLP_WKUP_TOUT          0xFFC00658         /* RSI0 Sleep Wakeup Timeout Register */
#define REG_RSI0_BLKSZ                  0xFFC0065C         /* RSI0 Block Size Register */
#define REG_RSI0_FIFO                   0xFFC00680         /* RSI0 Data FIFO Register */
#define REG_RSI0_STAT0                  0xFFC006C0         /* RSI0 Exception Status Register */
#define REG_RSI0_IMSK0                  0xFFC006C4         /* RSI0 Exception Mask Register */
#define REG_RSI0_CFG                    0xFFC006C8         /* RSI0 Configuration Register */
#define REG_RSI0_RD_WAIT                0xFFC006CC         /* RSI0 Read Wait Enable Register */
#define REG_RSI0_PID0                   0xFFC006D0         /* RSI0 Peripheral Identification Register */
#define REG_RSI0_PID1                   0xFFC006D4         /* RSI0 Peripheral Identification Register */
#define REG_RSI0_PID2                   0xFFC006D8         /* RSI0 Peripheral Identification Register */
#define REG_RSI0_PID3                   0xFFC006DC         /* RSI0 Peripheral Identification Register */

/* =========================
        RSI
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        RSI_CTL                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_CTL_CARDTYPE                13                               /* Type of Card */
#define BITP_RSI_CTL_BUSWID                  11                               /* Wide Bus Mode Enable */
#define BITP_RSI_CTL_BYPASS                  10                               /* Bypass clock divisor */
#define BITP_RSI_CTL_PWRSAVE                  9                               /* Power Save Enable */
#define BITP_RSI_CTL_CLKEN                    8                               /* RSI_CLK Bus Clock Enable */
#define BITP_RSI_CTL_CLKDIV                   0                               /* RSI_CLK Divisor */
#define BITM_RSI_CTL_CARDTYPE                (_ADI_MSK(0x0000E000,uint16_t))  /* Type of Card */
#define BITM_RSI_CTL_BUSWID                  (_ADI_MSK(0x00001800,uint16_t))  /* Wide Bus Mode Enable */
#define BITM_RSI_CTL_BYPASS                  (_ADI_MSK(0x00000400,uint16_t))  /* Bypass clock divisor */
#define BITM_RSI_CTL_PWRSAVE                 (_ADI_MSK(0x00000200,uint16_t))  /* Power Save Enable */
#define BITM_RSI_CTL_CLKEN                   (_ADI_MSK(0x00000100,uint16_t))  /* RSI_CLK Bus Clock Enable */
#define BITM_RSI_CTL_CLKDIV                  (_ADI_MSK(0x000000FF,uint16_t))  /* RSI_CLK Divisor */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_CMD                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_CMD_CHKBUSY                 12                               /* Check Busy Condition */
#define BITP_RSI_CMD_CRCDIS                  11                               /* Disable CRC Check */
#define BITP_RSI_CMD_EN                      10                               /* Command Enable */
#define BITP_RSI_CMD_PNDEN                    9                               /* Command Pending enabled */
#define BITP_RSI_CMD_IEN                      8                               /* Command Interrupt Enabled */
#define BITP_RSI_CMD_LRSP                     7                               /* Long Response */
#define BITP_RSI_CMD_RSP                      6                               /* Response */
#define BITP_RSI_CMD_IDX                      0                               /* Command Index */
#define BITM_RSI_CMD_CHKBUSY                 (_ADI_MSK(0x00001000,uint16_t))  /* Check Busy Condition */
#define BITM_RSI_CMD_CRCDIS                  (_ADI_MSK(0x00000800,uint16_t))  /* Disable CRC Check */
#define BITM_RSI_CMD_EN                      (_ADI_MSK(0x00000400,uint16_t))  /* Command Enable */
#define BITM_RSI_CMD_PNDEN                   (_ADI_MSK(0x00000200,uint16_t))  /* Command Pending enabled */
#define BITM_RSI_CMD_IEN                     (_ADI_MSK(0x00000100,uint16_t))  /* Command Interrupt Enabled */
#define BITM_RSI_CMD_LRSP                    (_ADI_MSK(0x00000080,uint16_t))  /* Long Response */
#define BITM_RSI_CMD_RSP                     (_ADI_MSK(0x00000040,uint16_t))  /* Response */
#define BITM_RSI_CMD_IDX                     (_ADI_MSK(0x0000003F,uint16_t))  /* Command Index */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_RESP_CMD                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_RESP_CMD_VALUE               0                               /* Response Command */
#define BITM_RSI_RESP_CMD_VALUE              (_ADI_MSK(0x0000003F,uint16_t))  /* Response Command */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_DATA_CTL                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_DATA_CTL_CEATAIEN            9                               /* Ceata Command Completion Interrupt Enable */
#define BITP_RSI_DATA_CTL_CEATAMODE           8                               /* Ceata Mode enable */
#define BITP_RSI_DATA_CTL_DMAEN               3                               /* Data Transfer DMA Enable */
#define BITP_RSI_DATA_CTL_DATMODE             2                               /* Data Transfer Mode */
#define BITP_RSI_DATA_CTL_DATDIR              1                               /* Data Transfer Direction */
#define BITP_RSI_DATA_CTL_DATEN               0                               /* Data Transfer Enable */
#define BITM_RSI_DATA_CTL_CEATAIEN           (_ADI_MSK(0x00000200,uint16_t))  /* Ceata Command Completion Interrupt Enable */
#define BITM_RSI_DATA_CTL_CEATAMODE          (_ADI_MSK(0x00000100,uint16_t))  /* Ceata Mode enable */
#define BITM_RSI_DATA_CTL_DMAEN              (_ADI_MSK(0x00000008,uint16_t))  /* Data Transfer DMA Enable */
#define BITM_RSI_DATA_CTL_DATMODE            (_ADI_MSK(0x00000004,uint16_t))  /* Data Transfer Mode */
#define BITM_RSI_DATA_CTL_DATDIR             (_ADI_MSK(0x00000002,uint16_t))  /* Data Transfer Direction */
#define BITM_RSI_DATA_CTL_DATEN              (_ADI_MSK(0x00000001,uint16_t))  /* Data Transfer Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_XFRSTAT                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_XFRSTAT_RXFIFORDY           21                               /* Receive FIFO Available */
#define BITP_RSI_XFRSTAT_TXFIFORDY           20                               /* Transmit FIFO Available */
#define BITP_RSI_XFRSTAT_RXFIFOZERO          19                               /* Receive FIFO Empty */
#define BITP_RSI_XFRSTAT_TXFIFOZERO          18                               /* Transmit FIFO Empty */
#define BITP_RSI_XFRSTAT_RXFIFOFULL          17                               /* Receive FIFO Full */
#define BITP_RSI_XFRSTAT_TXFIFOFULL          16                               /* Transmit FIFO Full */
#define BITP_RSI_XFRSTAT_RXFIFOSTAT          15                               /* Receive FIFO Status */
#define BITP_RSI_XFRSTAT_TXFIFOSTAT          14                               /* Transmit FIFO Status */
#define BITP_RSI_XFRSTAT_RXACT               13                               /* Receive Active */
#define BITP_RSI_XFRSTAT_TXACT               12                               /* Transmit Active */
#define BITP_RSI_XFRSTAT_CMDACT              11                               /* Command Active */
#define BITP_RSI_XFRSTAT_DATBLKEND           10                               /* Data Block End */
#define BITP_RSI_XFRSTAT_SBITERR              9                               /* Start Bit Error */
#define BITP_RSI_XFRSTAT_DATEND               8                               /* Data End */
#define BITP_RSI_XFRSTAT_CMDSENT              7                               /* Command Sent */
#define BITP_RSI_XFRSTAT_RESPEND              6                               /* Command Response End */
#define BITP_RSI_XFRSTAT_RXOVER               5                               /* Receive Over run */
#define BITP_RSI_XFRSTAT_TXUNDR               4                               /* Transmit Under run */
#define BITP_RSI_XFRSTAT_DATTO                3                               /* Data Timeout */
#define BITP_RSI_XFRSTAT_CMDTO                2                               /* CMD Timeout */
#define BITP_RSI_XFRSTAT_DATCRCFAIL           1                               /* Data CRC Fail */
#define BITP_RSI_XFRSTAT_CMDCRCFAIL           0                               /* CMD CRC Fail */
#define BITM_RSI_XFRSTAT_RXFIFORDY           (_ADI_MSK(0x00200000,uint32_t))  /* Receive FIFO Available */
#define BITM_RSI_XFRSTAT_TXFIFORDY           (_ADI_MSK(0x00100000,uint32_t))  /* Transmit FIFO Available */
#define BITM_RSI_XFRSTAT_RXFIFOZERO          (_ADI_MSK(0x00080000,uint32_t))  /* Receive FIFO Empty */
#define BITM_RSI_XFRSTAT_TXFIFOZERO          (_ADI_MSK(0x00040000,uint32_t))  /* Transmit FIFO Empty */
#define BITM_RSI_XFRSTAT_RXFIFOFULL          (_ADI_MSK(0x00020000,uint32_t))  /* Receive FIFO Full */
#define BITM_RSI_XFRSTAT_TXFIFOFULL          (_ADI_MSK(0x00010000,uint32_t))  /* Transmit FIFO Full */
#define BITM_RSI_XFRSTAT_RXFIFOSTAT          (_ADI_MSK(0x00008000,uint32_t))  /* Receive FIFO Status */
#define BITM_RSI_XFRSTAT_TXFIFOSTAT          (_ADI_MSK(0x00004000,uint32_t))  /* Transmit FIFO Status */
#define BITM_RSI_XFRSTAT_RXACT               (_ADI_MSK(0x00002000,uint32_t))  /* Receive Active */
#define BITM_RSI_XFRSTAT_TXACT               (_ADI_MSK(0x00001000,uint32_t))  /* Transmit Active */
#define BITM_RSI_XFRSTAT_CMDACT              (_ADI_MSK(0x00000800,uint32_t))  /* Command Active */
#define BITM_RSI_XFRSTAT_DATBLKEND           (_ADI_MSK(0x00000400,uint32_t))  /* Data Block End */
#define BITM_RSI_XFRSTAT_SBITERR             (_ADI_MSK(0x00000200,uint32_t))  /* Start Bit Error */
#define BITM_RSI_XFRSTAT_DATEND              (_ADI_MSK(0x00000100,uint32_t))  /* Data End */
#define BITM_RSI_XFRSTAT_CMDSENT             (_ADI_MSK(0x00000080,uint32_t))  /* Command Sent */
#define BITM_RSI_XFRSTAT_RESPEND             (_ADI_MSK(0x00000040,uint32_t))  /* Command Response End */
#define BITM_RSI_XFRSTAT_RXOVER              (_ADI_MSK(0x00000020,uint32_t))  /* Receive Over run */
#define BITM_RSI_XFRSTAT_TXUNDR              (_ADI_MSK(0x00000010,uint32_t))  /* Transmit Under run */
#define BITM_RSI_XFRSTAT_DATTO               (_ADI_MSK(0x00000008,uint32_t))  /* Data Timeout */
#define BITM_RSI_XFRSTAT_CMDTO               (_ADI_MSK(0x00000004,uint32_t))  /* CMD Timeout */
#define BITM_RSI_XFRSTAT_DATCRCFAIL          (_ADI_MSK(0x00000002,uint32_t))  /* Data CRC Fail */
#define BITM_RSI_XFRSTAT_CMDCRCFAIL          (_ADI_MSK(0x00000001,uint32_t))  /* CMD CRC Fail */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_XFRSTAT_CLR                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_XFRSTAT_CLR_DATBLKEND       10                               /* Data Block End Status */
#define BITP_RSI_XFRSTAT_CLR_STRTBITERR       9                               /* Start Bit Error Status */
#define BITP_RSI_XFRSTAT_CLR_DATEND           8                               /* Data End Status */
#define BITP_RSI_XFRSTAT_CLR_CMDSENT          7                               /* Command Sent Status */
#define BITP_RSI_XFRSTAT_CLR_RESPEND          6                               /* Command Response End Status */
#define BITP_RSI_XFRSTAT_CLR_RXOVER           5                               /* Receive Over run Status */
#define BITP_RSI_XFRSTAT_CLR_TXUNDR           4                               /* Transmit Under run Status */
#define BITP_RSI_XFRSTAT_CLR_DATTO            3                               /* Data Timeout Status */
#define BITP_RSI_XFRSTAT_CLR_CMDTO            2                               /* CMD Timeout Status */
#define BITP_RSI_XFRSTAT_CLR_DATCRCFAIL       1                               /* Data CRC Fail Status */
#define BITP_RSI_XFRSTAT_CLR_CMDCRCFAIL       0                               /* CMD CRC Fail Status */
#define BITM_RSI_XFRSTAT_CLR_DATBLKEND       (_ADI_MSK(0x00000400,uint16_t))  /* Data Block End Status */
#define BITM_RSI_XFRSTAT_CLR_STRTBITERR      (_ADI_MSK(0x00000200,uint16_t))  /* Start Bit Error Status */
#define BITM_RSI_XFRSTAT_CLR_DATEND          (_ADI_MSK(0x00000100,uint16_t))  /* Data End Status */
#define BITM_RSI_XFRSTAT_CLR_CMDSENT         (_ADI_MSK(0x00000080,uint16_t))  /* Command Sent Status */
#define BITM_RSI_XFRSTAT_CLR_RESPEND         (_ADI_MSK(0x00000040,uint16_t))  /* Command Response End Status */
#define BITM_RSI_XFRSTAT_CLR_RXOVER          (_ADI_MSK(0x00000020,uint16_t))  /* Receive Over run Status */
#define BITM_RSI_XFRSTAT_CLR_TXUNDR          (_ADI_MSK(0x00000010,uint16_t))  /* Transmit Under run Status */
#define BITM_RSI_XFRSTAT_CLR_DATTO           (_ADI_MSK(0x00000008,uint16_t))  /* Data Timeout Status */
#define BITM_RSI_XFRSTAT_CLR_CMDTO           (_ADI_MSK(0x00000004,uint16_t))  /* CMD Timeout Status */
#define BITM_RSI_XFRSTAT_CLR_DATCRCFAIL      (_ADI_MSK(0x00000002,uint16_t))  /* Data CRC Fail Status */
#define BITM_RSI_XFRSTAT_CLR_CMDCRCFAIL      (_ADI_MSK(0x00000001,uint16_t))  /* CMD CRC Fail Status */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_XFR_IMSK0                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_XFR_IMSK0_RXFIFORDY         21                               /* Enable Interrupt for Receive FIFO Available */
#define BITP_RSI_XFR_IMSK0_TXFIFORDY         20                               /* Enable Interrupt for Transmit FIFO Available */
#define BITP_RSI_XFR_IMSK0_RXFIFOZERO        19                               /* Enable Interrupt for Receive FIFO Empty */
#define BITP_RSI_XFR_IMSK0_TXFIFOZERO        18                               /* Enable Interrupt for Transmit FIFO Empty */
#define BITP_RSI_XFR_IMSK0_RXFIFOFULL        17                               /* Enable Interrupt for Receive FIFO Full */
#define BITP_RSI_XFR_IMSK0_TXFIFOFULL        16                               /* Enable Interrupt for Transmit FIFO Full */
#define BITP_RSI_XFR_IMSK0_RXFIFOSTAT        15                               /* Enable Interrupt for Receive FIFO Status */
#define BITP_RSI_XFR_IMSK0_TXFIFOSTAT        14                               /* Enable Interrupt for Transmit FIFO Status */
#define BITP_RSI_XFR_IMSK0_RXACT             13                               /* Enable Interrupt for Receive Active */
#define BITP_RSI_XFR_IMSK0_TXACT             12                               /* Enable Interrupt for Transmit Active */
#define BITP_RSI_XFR_IMSK0_CMDACT            11                               /* Enable Interrupt for Command Active */
#define BITP_RSI_XFR_IMSK0_DATBLKEND         10                               /* Enable Interrupt for Data Block End */
#define BITP_RSI_XFR_IMSK0_STRTBITERR         9                               /* Enable Interrupt for Start Bit Error */
#define BITP_RSI_XFR_IMSK0_DATEND             8                               /* Enable Interrupt for Data End */
#define BITP_RSI_XFR_IMSK0_CMDSENT            7                               /* Enable Interrupt for Command Sent */
#define BITP_RSI_XFR_IMSK0_RESPEND            6                               /* Enable Interrupt for Command Response End */
#define BITP_RSI_XFR_IMSK0_RXOVER             5                               /* Enable Interrupt for Receive Over run */
#define BITP_RSI_XFR_IMSK0_TXUNDR             4                               /* Enable Interrupt for Transmit Under run */
#define BITP_RSI_XFR_IMSK0_DATTO              3                               /* Enable Interrupt for Data Timeout */
#define BITP_RSI_XFR_IMSK0_CMDTO              2                               /* Enable Interrupt for CMD Timeout */
#define BITP_RSI_XFR_IMSK0_DATCRCFAIL         1                               /* Enable Interrupt for Data CRC Fail */
#define BITP_RSI_XFR_IMSK0_CMDCRCFAIL         0                               /* Enable Interrupt for CMD CRC Fail */
#define BITM_RSI_XFR_IMSK0_RXFIFORDY         (_ADI_MSK(0x00200000,uint32_t))  /* Enable Interrupt for Receive FIFO Available */
#define BITM_RSI_XFR_IMSK0_TXFIFORDY         (_ADI_MSK(0x00100000,uint32_t))  /* Enable Interrupt for Transmit FIFO Available */
#define BITM_RSI_XFR_IMSK0_RXFIFOZERO        (_ADI_MSK(0x00080000,uint32_t))  /* Enable Interrupt for Receive FIFO Empty */
#define BITM_RSI_XFR_IMSK0_TXFIFOZERO        (_ADI_MSK(0x00040000,uint32_t))  /* Enable Interrupt for Transmit FIFO Empty */
#define BITM_RSI_XFR_IMSK0_RXFIFOFULL        (_ADI_MSK(0x00020000,uint32_t))  /* Enable Interrupt for Receive FIFO Full */
#define BITM_RSI_XFR_IMSK0_TXFIFOFULL        (_ADI_MSK(0x00010000,uint32_t))  /* Enable Interrupt for Transmit FIFO Full */
#define BITM_RSI_XFR_IMSK0_RXFIFOSTAT        (_ADI_MSK(0x00008000,uint32_t))  /* Enable Interrupt for Receive FIFO Status */
#define BITM_RSI_XFR_IMSK0_TXFIFOSTAT        (_ADI_MSK(0x00004000,uint32_t))  /* Enable Interrupt for Transmit FIFO Status */
#define BITM_RSI_XFR_IMSK0_RXACT             (_ADI_MSK(0x00002000,uint32_t))  /* Enable Interrupt for Receive Active */
#define BITM_RSI_XFR_IMSK0_TXACT             (_ADI_MSK(0x00001000,uint32_t))  /* Enable Interrupt for Transmit Active */
#define BITM_RSI_XFR_IMSK0_CMDACT            (_ADI_MSK(0x00000800,uint32_t))  /* Enable Interrupt for Command Active */
#define BITM_RSI_XFR_IMSK0_DATBLKEND         (_ADI_MSK(0x00000400,uint32_t))  /* Enable Interrupt for Data Block End */
#define BITM_RSI_XFR_IMSK0_STRTBITERR        (_ADI_MSK(0x00000200,uint32_t))  /* Enable Interrupt for Start Bit Error */
#define BITM_RSI_XFR_IMSK0_DATEND            (_ADI_MSK(0x00000100,uint32_t))  /* Enable Interrupt for Data End */
#define BITM_RSI_XFR_IMSK0_CMDSENT           (_ADI_MSK(0x00000080,uint32_t))  /* Enable Interrupt for Command Sent */
#define BITM_RSI_XFR_IMSK0_RESPEND           (_ADI_MSK(0x00000040,uint32_t))  /* Enable Interrupt for Command Response End */
#define BITM_RSI_XFR_IMSK0_RXOVER            (_ADI_MSK(0x00000020,uint32_t))  /* Enable Interrupt for Receive Over run */
#define BITM_RSI_XFR_IMSK0_TXUNDR            (_ADI_MSK(0x00000010,uint32_t))  /* Enable Interrupt for Transmit Under run */
#define BITM_RSI_XFR_IMSK0_DATTO             (_ADI_MSK(0x00000008,uint32_t))  /* Enable Interrupt for Data Timeout */
#define BITM_RSI_XFR_IMSK0_CMDTO             (_ADI_MSK(0x00000004,uint32_t))  /* Enable Interrupt for CMD Timeout */
#define BITM_RSI_XFR_IMSK0_DATCRCFAIL        (_ADI_MSK(0x00000002,uint32_t))  /* Enable Interrupt for Data CRC Fail */
#define BITM_RSI_XFR_IMSK0_CMDCRCFAIL        (_ADI_MSK(0x00000001,uint32_t))  /* Enable Interrupt for CMD CRC Fail */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_XFR_IMSK1                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_XFR_IMSK1_RXFIFORDY         21                               /* Enable Interrupt for Receive FIFO Available */
#define BITP_RSI_XFR_IMSK1_TXFIFORDY         20                               /* Enable Interrupt for Transmit FIFO Available */
#define BITP_RSI_XFR_IMSK1_RXFIFOZERO        19                               /* Enable Interrupt for Receive FIFO Empty */
#define BITP_RSI_XFR_IMSK1_TXFIFOZERO        18                               /* Enable Interrupt for Transmit FIFO Empty */
#define BITP_RSI_XFR_IMSK1_RXFIFOFULL        17                               /* Enable Interrupt for Receive FIFO Full */
#define BITP_RSI_XFR_IMSK1_TXFIFOFULL        16                               /* Enable Interrupt for Transmit FIFO Full */
#define BITP_RSI_XFR_IMSK1_RXFIFOSTAT        15                               /* Enable Interrupt for Receive FIFO Status */
#define BITP_RSI_XFR_IMSK1_TXFIFOSTAT        14                               /* Enable Interrupt for Transmit FIFO Status */
#define BITP_RSI_XFR_IMSK1_RXACT             13                               /* Enable Interrupt for Receive Active */
#define BITP_RSI_XFR_IMSK1_TXACT             12                               /* Enable Interrupt for Transmit Active */
#define BITP_RSI_XFR_IMSK1_CMDACT            11                               /* Enable Interrupt for Command Active */
#define BITP_RSI_XFR_IMSK1_DATBLKEND         10                               /* Enable Interrupt for Data Block End */
#define BITP_RSI_XFR_IMSK1_STRTBITERR         9                               /* Enable Interrupt for Start Bit Error */
#define BITP_RSI_XFR_IMSK1_DATEND             8                               /* Enable Interrupt for Data End */
#define BITP_RSI_XFR_IMSK1_CMDSENT            7                               /* Enable Interrupt for Command Sent */
#define BITP_RSI_XFR_IMSK1_RESPEND            6                               /* Enable Interrupt for Command Response End */
#define BITP_RSI_XFR_IMSK1_RXOVER             5                               /* Enable Interrupt for Receive Over run */
#define BITP_RSI_XFR_IMSK1_TXUNDR             4                               /* Enable Interrupt for Transmit Under run */
#define BITP_RSI_XFR_IMSK1_DATTO              3                               /* Enable Interrupt for Data Timeout */
#define BITP_RSI_XFR_IMSK1_CMDTO              2                               /* Enable Interrupt for CMD Timeout */
#define BITP_RSI_XFR_IMSK1_DATCRCFAIL         1                               /* Enable Interrupt for Data CRC Fail */
#define BITP_RSI_XFR_IMSK1_CMDCRCFAIL         0                               /* Enable Interrupt for CMD CRC Fail */
#define BITM_RSI_XFR_IMSK1_RXFIFORDY         (_ADI_MSK(0x00200000,uint32_t))  /* Enable Interrupt for Receive FIFO Available */
#define BITM_RSI_XFR_IMSK1_TXFIFORDY         (_ADI_MSK(0x00100000,uint32_t))  /* Enable Interrupt for Transmit FIFO Available */
#define BITM_RSI_XFR_IMSK1_RXFIFOZERO        (_ADI_MSK(0x00080000,uint32_t))  /* Enable Interrupt for Receive FIFO Empty */
#define BITM_RSI_XFR_IMSK1_TXFIFOZERO        (_ADI_MSK(0x00040000,uint32_t))  /* Enable Interrupt for Transmit FIFO Empty */
#define BITM_RSI_XFR_IMSK1_RXFIFOFULL        (_ADI_MSK(0x00020000,uint32_t))  /* Enable Interrupt for Receive FIFO Full */
#define BITM_RSI_XFR_IMSK1_TXFIFOFULL        (_ADI_MSK(0x00010000,uint32_t))  /* Enable Interrupt for Transmit FIFO Full */
#define BITM_RSI_XFR_IMSK1_RXFIFOSTAT        (_ADI_MSK(0x00008000,uint32_t))  /* Enable Interrupt for Receive FIFO Status */
#define BITM_RSI_XFR_IMSK1_TXFIFOSTAT        (_ADI_MSK(0x00004000,uint32_t))  /* Enable Interrupt for Transmit FIFO Status */
#define BITM_RSI_XFR_IMSK1_RXACT             (_ADI_MSK(0x00002000,uint32_t))  /* Enable Interrupt for Receive Active */
#define BITM_RSI_XFR_IMSK1_TXACT             (_ADI_MSK(0x00001000,uint32_t))  /* Enable Interrupt for Transmit Active */
#define BITM_RSI_XFR_IMSK1_CMDACT            (_ADI_MSK(0x00000800,uint32_t))  /* Enable Interrupt for Command Active */
#define BITM_RSI_XFR_IMSK1_DATBLKEND         (_ADI_MSK(0x00000400,uint32_t))  /* Enable Interrupt for Data Block End */
#define BITM_RSI_XFR_IMSK1_STRTBITERR        (_ADI_MSK(0x00000200,uint32_t))  /* Enable Interrupt for Start Bit Error */
#define BITM_RSI_XFR_IMSK1_DATEND            (_ADI_MSK(0x00000100,uint32_t))  /* Enable Interrupt for Data End */
#define BITM_RSI_XFR_IMSK1_CMDSENT           (_ADI_MSK(0x00000080,uint32_t))  /* Enable Interrupt for Command Sent */
#define BITM_RSI_XFR_IMSK1_RESPEND           (_ADI_MSK(0x00000040,uint32_t))  /* Enable Interrupt for Command Response End */
#define BITM_RSI_XFR_IMSK1_RXOVER            (_ADI_MSK(0x00000020,uint32_t))  /* Enable Interrupt for Receive Over run */
#define BITM_RSI_XFR_IMSK1_TXUNDR            (_ADI_MSK(0x00000010,uint32_t))  /* Enable Interrupt for Transmit Under run */
#define BITM_RSI_XFR_IMSK1_DATTO             (_ADI_MSK(0x00000008,uint32_t))  /* Enable Interrupt for Data Timeout */
#define BITM_RSI_XFR_IMSK1_CMDTO             (_ADI_MSK(0x00000004,uint32_t))  /* Enable Interrupt for CMD Timeout */
#define BITM_RSI_XFR_IMSK1_DATCRCFAIL        (_ADI_MSK(0x00000002,uint32_t))  /* Enable Interrupt for Data CRC Fail */
#define BITM_RSI_XFR_IMSK1_CMDCRCFAIL        (_ADI_MSK(0x00000001,uint32_t))  /* Enable Interrupt for CMD CRC Fail */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_FIFO_CNT                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_FIFO_CNT_VALUE               0                               /* FIFO Count */
#define BITM_RSI_FIFO_CNT_VALUE              (_ADI_MSK(0x00007FFF,uint16_t))  /* FIFO Count */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_CEATA                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_CEATA_INT_DIS                0                               /* CEATA Disable Interrupt */
#define BITM_RSI_CEATA_INT_DIS               (_ADI_MSK(0x00000001,uint32_t))  /* CEATA Disable Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_BOOT_TCNTR                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_BOOT_TCNTR_HOLD              8                               /* Boot Hold Time */
#define BITP_RSI_BOOT_TCNTR_SETUP             0                               /* Boot Setup Time */
#define BITM_RSI_BOOT_TCNTR_HOLD             (_ADI_MSK(0x0000FF00,uint16_t))  /* Boot Hold Time */
#define BITM_RSI_BOOT_TCNTR_SETUP            (_ADI_MSK(0x000000FF,uint16_t))  /* Boot Setup Time */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_BLKSZ                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_BLKSZ_VALUE                  0                               /* Size of Each Block of Data */
#define BITM_RSI_BLKSZ_VALUE                 (_ADI_MSK(0x00001FFF,uint16_t))  /* Size of Each Block of Data */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_STAT0                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_STAT0_BUSYMODE              31                               /* Card is in Busy mode */
#define BITP_RSI_STAT0_SLPMODE               30                               /* Card in Sleep Mode */
#define BITP_RSI_STAT0_CARDRDY               17                               /* Card Ready */
#define BITP_RSI_STAT0_SLPWKPTOUT            16                               /* Sleep Wakeup Timer Expired */
#define BITP_RSI_STAT0_WKPDONE               15                               /* Card Entered Standby state */
#define BITP_RSI_STAT0_SLPDONE               14                               /* Card Entered Sleep State */
#define BITP_RSI_STAT0_BACKDONE              13                               /* Correct Boot Ack is received */
#define BITP_RSI_STAT0_BACKBAD               12                               /* Boot Ack received is corrupted */
#define BITP_RSI_STAT0_BACKTO                11                               /* Boot Acknowledge Timeout */
#define BITP_RSI_STAT0_BDATTO                10                               /* Boot Data Timeout */
#define BITP_RSI_STAT0_BHOLDEXP               9                               /* Boot Hold Time Expiry */
#define BITP_RSI_STAT0_BSETUPEXP              8                               /* Boot Setup Time Expiry */
#define BITP_RSI_STAT0_CEATAINT               5                               /* CEATA Interrupt */
#define BITP_RSI_STAT0_SDCARD                 4                               /* SD Card Detected */
#define BITP_RSI_STAT0_SDIOINT                1                               /* SDIO Interrupt */
#define BITM_RSI_STAT0_BUSYMODE              (_ADI_MSK(0x80000000,uint32_t))  /* Card is in Busy mode */
#define BITM_RSI_STAT0_SLPMODE               (_ADI_MSK(0x40000000,uint32_t))  /* Card in Sleep Mode */
#define BITM_RSI_STAT0_CARDRDY               (_ADI_MSK(0x00020000,uint32_t))  /* Card Ready */
#define BITM_RSI_STAT0_SLPWKPTOUT            (_ADI_MSK(0x00010000,uint32_t))  /* Sleep Wakeup Timer Expired */
#define BITM_RSI_STAT0_WKPDONE               (_ADI_MSK(0x00008000,uint32_t))  /* Card Entered Standby state */
#define BITM_RSI_STAT0_SLPDONE               (_ADI_MSK(0x00004000,uint32_t))  /* Card Entered Sleep State */
#define BITM_RSI_STAT0_BACKDONE              (_ADI_MSK(0x00002000,uint32_t))  /* Correct Boot Ack is received */
#define BITM_RSI_STAT0_BACKBAD               (_ADI_MSK(0x00001000,uint32_t))  /* Boot Ack received is corrupted */
#define BITM_RSI_STAT0_BACKTO                (_ADI_MSK(0x00000800,uint32_t))  /* Boot Acknowledge Timeout */
#define BITM_RSI_STAT0_BDATTO                (_ADI_MSK(0x00000400,uint32_t))  /* Boot Data Timeout */
#define BITM_RSI_STAT0_BHOLDEXP              (_ADI_MSK(0x00000200,uint32_t))  /* Boot Hold Time Expiry */
#define BITM_RSI_STAT0_BSETUPEXP             (_ADI_MSK(0x00000100,uint32_t))  /* Boot Setup Time Expiry */
#define BITM_RSI_STAT0_CEATAINT              (_ADI_MSK(0x00000020,uint32_t))  /* CEATA Interrupt */
#define BITM_RSI_STAT0_SDCARD                (_ADI_MSK(0x00000010,uint32_t))  /* SD Card Detected */
#define BITM_RSI_STAT0_SDIOINT               (_ADI_MSK(0x00000002,uint32_t))  /* SDIO Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_IMSK0                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_IMSK0_CARDRDY               17                               /* Mask Interrupt for Card Ready */
#define BITP_RSI_IMSK0_SLPWKPTOUT            16                               /* Mask Interrupt for Sleep Wakeup Timer Expired */
#define BITP_RSI_IMSK0_WKPDONE               15                               /* Mask Interrupt for Card Entered Standby state */
#define BITP_RSI_IMSK0_SLPDONE               14                               /* Mask Interrupt for Card Entered Sleep State */
#define BITP_RSI_IMSK0_BACKDONE              13                               /* Mask Interrupt for Correct Boot Ack is received */
#define BITP_RSI_IMSK0_BACKBAD               12                               /* Mask Interrupt for Boot Ack received is corrupted */
#define BITP_RSI_IMSK0_BACKTO                11                               /* Mask Interrupt for Boot Acknowledge Timeout */
#define BITP_RSI_IMSK0_BDATTO                10                               /* Mask Interrupt for Boot Data Timeout */
#define BITP_RSI_IMSK0_BHOLDEXP               9                               /* Mask Interrupt for Boot Hold Time Expiry */
#define BITP_RSI_IMSK0_BSETUPEXP              8                               /* Mask Interrupt for Boot Setup Time Expiry */
#define BITP_RSI_IMSK0_CEATAINT               5                               /* Mask CEATA Interrupt */
#define BITP_RSI_IMSK0_SDCARD                 4                               /* Mask Interrupt for SD Card Detected */
#define BITP_RSI_IMSK0_SDIOINT                1                               /* Mask SDIO Interrupt */
#define BITM_RSI_IMSK0_CARDRDY               (_ADI_MSK(0x00020000,uint32_t))  /* Mask Interrupt for Card Ready */
#define BITM_RSI_IMSK0_SLPWKPTOUT            (_ADI_MSK(0x00010000,uint32_t))  /* Mask Interrupt for Sleep Wakeup Timer Expired */
#define BITM_RSI_IMSK0_WKPDONE               (_ADI_MSK(0x00008000,uint32_t))  /* Mask Interrupt for Card Entered Standby state */
#define BITM_RSI_IMSK0_SLPDONE               (_ADI_MSK(0x00004000,uint32_t))  /* Mask Interrupt for Card Entered Sleep State */
#define BITM_RSI_IMSK0_BACKDONE              (_ADI_MSK(0x00002000,uint32_t))  /* Mask Interrupt for Correct Boot Ack is received */
#define BITM_RSI_IMSK0_BACKBAD               (_ADI_MSK(0x00001000,uint32_t))  /* Mask Interrupt for Boot Ack received is corrupted */
#define BITM_RSI_IMSK0_BACKTO                (_ADI_MSK(0x00000800,uint32_t))  /* Mask Interrupt for Boot Acknowledge Timeout */
#define BITM_RSI_IMSK0_BDATTO                (_ADI_MSK(0x00000400,uint32_t))  /* Mask Interrupt for Boot Data Timeout */
#define BITM_RSI_IMSK0_BHOLDEXP              (_ADI_MSK(0x00000200,uint32_t))  /* Mask Interrupt for Boot Hold Time Expiry */
#define BITM_RSI_IMSK0_BSETUPEXP             (_ADI_MSK(0x00000100,uint32_t))  /* Mask Interrupt for Boot Setup Time Expiry */
#define BITM_RSI_IMSK0_CEATAINT              (_ADI_MSK(0x00000020,uint32_t))  /* Mask CEATA Interrupt */
#define BITM_RSI_IMSK0_SDCARD                (_ADI_MSK(0x00000010,uint32_t))  /* Mask Interrupt for SD Card Detected */
#define BITM_RSI_IMSK0_SDIOINT               (_ADI_MSK(0x00000002,uint32_t))  /* Mask SDIO Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_CFG                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_CFG_BACKEN                  14                               /* Boot Acknowledge enabled */
#define BITP_RSI_CFG_MMCBMODE                13                               /* MMC Boot Mode select */
#define BITP_RSI_CFG_MMCBEN                  12                               /* MMC Boot Enabled */
#define BITP_RSI_CFG_OPENDRAIN               11                               /* MC_CMD Output Control */
#define BITP_RSI_CFG_PWRON                    9                               /* 11 - RSI Enabled */
#define BITP_RSI_CFG_IEBYPDIS                 8                               /* Disabled IE Bypass */
#define BITP_RSI_CFG_DAT3PUP                  6                               /* Pull-Up SD_DAT3 */
#define BITP_RSI_CFG_DATPUP                   5                               /* Pull-Up SD_DAT */
#define BITP_RSI_CFG_RST                      4                               /* SDMMC Reset */
#define BITP_RSI_CFG_MWINEN                   3                               /* Moving Window Enable */
#define BITP_RSI_CFG_SD4EN                    2                               /* SDIO 4-Bit Enable */
#define BITP_RSI_CFG_CLKSEN                   0                               /* Clocks Enable */
#define BITM_RSI_CFG_BACKEN                  (_ADI_MSK(0x00004000,uint16_t))  /* Boot Acknowledge enabled */
#define BITM_RSI_CFG_MMCBMODE                (_ADI_MSK(0x00002000,uint16_t))  /* MMC Boot Mode select */
#define BITM_RSI_CFG_MMCBEN                  (_ADI_MSK(0x00001000,uint16_t))  /* MMC Boot Enabled */
#define BITM_RSI_CFG_OPENDRAIN               (_ADI_MSK(0x00000800,uint16_t))  /* MC_CMD Output Control */
#define BITM_RSI_CFG_PWRON                   (_ADI_MSK(0x00000600,uint16_t))  /* 11 - RSI Enabled */
#define BITM_RSI_CFG_IEBYPDIS                (_ADI_MSK(0x00000100,uint16_t))  /* Disabled IE Bypass */
#define BITM_RSI_CFG_DAT3PUP                 (_ADI_MSK(0x00000040,uint16_t))  /* Pull-Up SD_DAT3 */
#define BITM_RSI_CFG_DATPUP                  (_ADI_MSK(0x00000020,uint16_t))  /* Pull-Up SD_DAT */
#define BITM_RSI_CFG_RST                     (_ADI_MSK(0x00000010,uint16_t))  /* SDMMC Reset */
#define BITM_RSI_CFG_MWINEN                  (_ADI_MSK(0x00000008,uint16_t))  /* Moving Window Enable */
#define BITM_RSI_CFG_SD4EN                   (_ADI_MSK(0x00000004,uint16_t))  /* SDIO 4-Bit Enable */
#define BITM_RSI_CFG_CLKSEN                  (_ADI_MSK(0x00000001,uint16_t))  /* Clocks Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_RD_WAIT                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_RD_WAIT_REQUEST              0                               /* Read Wait Request */
#define BITM_RSI_RD_WAIT_REQUEST             (_ADI_MSK(0x00000001,uint16_t))  /* Read Wait Request */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_PID0                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_PID0_VALUE                   0                               /* Peripheral Identification */
#define BITM_RSI_PID0_VALUE                  (_ADI_MSK(0x000000FF,uint32_t))  /* Peripheral Identification */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_PID1                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_PID1_VALUE                   0                               /* Peripheral Identification */
#define BITM_RSI_PID1_VALUE                  (_ADI_MSK(0x000000FF,uint32_t))  /* Peripheral Identification */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_PID2                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_PID2_VALUE                   0                               /* Peripheral Identification */
#define BITM_RSI_PID2_VALUE                  (_ADI_MSK(0x000000FF,uint32_t))  /* Peripheral Identification */

/* ------------------------------------------------------------------------------------------------------------------------
        RSI_PID3                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_RSI_PID3_VALUE                   0                               /* Peripheral Identification */
#define BITM_RSI_PID3_VALUE                  (_ADI_MSK(0x000000FF,uint32_t))  /* Peripheral Identification */

/* ==================================================
        Controller Area Network Registers
   ================================================== */

/* =========================
        CAN0
   ========================= */
#define REG_CAN0_MC1                    0xFFC00A00         /* CAN0 Mailbox Configuration 1 Register */
#define REG_CAN0_MD1                    0xFFC00A04         /* CAN0 Mailbox Direction 1 Register */
#define REG_CAN0_TRS1                   0xFFC00A08         /* CAN0 Transmission Request Set 1 Register */
#define REG_CAN0_TRR1                   0xFFC00A0C         /* CAN0 Transmission Request Reset 1 Register */
#define REG_CAN0_TA1                    0xFFC00A10         /* CAN0 Transmission Acknowledge 1 Register */
#define REG_CAN0_AA1                    0xFFC00A14         /* CAN0 Abort Acknowledge 1 Register */
#define REG_CAN0_RMP1                   0xFFC00A18         /* CAN0 Receive Message Pending 1 Register */
#define REG_CAN0_RML1                   0xFFC00A1C         /* CAN0 Receive Message Lost 1 Register */
#define REG_CAN0_MBTIF1                 0xFFC00A20         /* CAN0 Mailbox Transmit Interrupt Flag 1 Register */
#define REG_CAN0_MBRIF1                 0xFFC00A24         /* CAN0 Mailbox Receive Interrupt Flag 1 Register */
#define REG_CAN0_MBIM1                  0xFFC00A28         /* CAN0 Mailbox Interrupt Mask 1 Register */
#define REG_CAN0_RFH1                   0xFFC00A2C         /* CAN0 Remote Frame Handling 1 Register */
#define REG_CAN0_OPSS1                  0xFFC00A30         /* CAN0 Overwrite Protection/Single Shot Transmission 1 Register */
#define REG_CAN0_MC2                    0xFFC00A40         /* CAN0 Mailbox Configuration 2 Register */
#define REG_CAN0_MD2                    0xFFC00A44         /* CAN0 Mailbox Direction 2 Register */
#define REG_CAN0_TRS2                   0xFFC00A48         /* CAN0 Transmission Request Set 2 Register */
#define REG_CAN0_TRR2                   0xFFC00A4C         /* CAN0 Transmission Request Reset 2 Register */
#define REG_CAN0_TA2                    0xFFC00A50         /* CAN0 Transmission Acknowledge 2 Register */
#define REG_CAN0_AA2                    0xFFC00A54         /* CAN0 Abort Acknowledge 2 Register */
#define REG_CAN0_RMP2                   0xFFC00A58         /* CAN0 Receive Message Pending 2 Register */
#define REG_CAN0_RML2                   0xFFC00A5C         /* CAN0 Receive Message Lost 2 Register */
#define REG_CAN0_MBTIF2                 0xFFC00A60         /* CAN0 Mailbox Transmit Interrupt Flag 2 Register */
#define REG_CAN0_MBRIF2                 0xFFC00A64         /* CAN0 Mailbox Receive Interrupt Flag 2 Register */
#define REG_CAN0_MBIM2                  0xFFC00A68         /* CAN0 Mailbox Interrupt Mask 2 Register */
#define REG_CAN0_RFH2                   0xFFC00A6C         /* CAN0 Remote Frame Handling 2 Register */
#define REG_CAN0_OPSS2                  0xFFC00A70         /* CAN0 Overwrite Protection/Single Shot Transmission 2 Register */
#define REG_CAN0_CLK                    0xFFC00A80         /* CAN0 Clock Register */
#define REG_CAN0_TIMING                 0xFFC00A84         /* CAN0 Timing Register */
#define REG_CAN0_DBG                    0xFFC00A88         /* CAN0 Debug Register */
#define REG_CAN0_STAT                   0xFFC00A8C         /* CAN0 Status Register */
#define REG_CAN0_CEC                    0xFFC00A90         /* CAN0 Error Counter Register */
#define REG_CAN0_GIS                    0xFFC00A94         /* CAN0 Global CAN Interrupt Status Register */
#define REG_CAN0_GIM                    0xFFC00A98         /* CAN0 Global CAN Interrupt Mask Register */
#define REG_CAN0_GIF                    0xFFC00A9C         /* CAN0 Global CAN Interrupt Flag Register */
#define REG_CAN0_CTL                    0xFFC00AA0         /* CAN0 CAN Master Control Register */
#define REG_CAN0_INT                    0xFFC00AA4         /* CAN0 Interrupt Pending Register */
#define REG_CAN0_MBTD                   0xFFC00AAC         /* CAN0 Temporary Mailbox Disable Register */
#define REG_CAN0_EWR                    0xFFC00AB0         /* CAN0 Error Counter Warning Level Register */
#define REG_CAN0_ESR                    0xFFC00AB4         /* CAN0 Error Status Register */
#define REG_CAN0_UCCNT                  0xFFC00AC4         /* CAN0 Universal Counter Register */
#define REG_CAN0_UCRC                   0xFFC00AC8         /* CAN0 Universal Counter Reload/Capture Register */
#define REG_CAN0_UCCNF                  0xFFC00ACC         /* CAN0 Universal Counter Configuration Mode Register */
#define REG_CAN0_AM00L                  0xFFC00B00         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM01L                  0xFFC00B08         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM02L                  0xFFC00B10         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM03L                  0xFFC00B18         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM04L                  0xFFC00B20         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM05L                  0xFFC00B28         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM06L                  0xFFC00B30         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM07L                  0xFFC00B38         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM08L                  0xFFC00B40         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM09L                  0xFFC00B48         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM10L                  0xFFC00B50         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM11L                  0xFFC00B58         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM12L                  0xFFC00B60         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM13L                  0xFFC00B68         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM14L                  0xFFC00B70         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM15L                  0xFFC00B78         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM16L                  0xFFC00B80         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM17L                  0xFFC00B88         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM18L                  0xFFC00B90         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM19L                  0xFFC00B98         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM20L                  0xFFC00BA0         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM21L                  0xFFC00BA8         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM22L                  0xFFC00BB0         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM23L                  0xFFC00BB8         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM24L                  0xFFC00BC0         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM25L                  0xFFC00BC8         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM26L                  0xFFC00BD0         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM27L                  0xFFC00BD8         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM28L                  0xFFC00BE0         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM29L                  0xFFC00BE8         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM30L                  0xFFC00BF0         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM31L                  0xFFC00BF8         /* CAN0 Acceptance Mask (L) Register */
#define REG_CAN0_AM00H                  0xFFC00B04         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM01H                  0xFFC00B0C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM02H                  0xFFC00B14         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM03H                  0xFFC00B1C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM04H                  0xFFC00B24         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM05H                  0xFFC00B2C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM06H                  0xFFC00B34         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM07H                  0xFFC00B3C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM08H                  0xFFC00B44         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM09H                  0xFFC00B4C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM10H                  0xFFC00B54         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM11H                  0xFFC00B5C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM12H                  0xFFC00B64         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM13H                  0xFFC00B6C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM14H                  0xFFC00B74         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM15H                  0xFFC00B7C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM16H                  0xFFC00B84         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM17H                  0xFFC00B8C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM18H                  0xFFC00B94         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM19H                  0xFFC00B9C         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM20H                  0xFFC00BA4         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM21H                  0xFFC00BAC         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM22H                  0xFFC00BB4         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM23H                  0xFFC00BBC         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM24H                  0xFFC00BC4         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM25H                  0xFFC00BCC         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM26H                  0xFFC00BD4         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM27H                  0xFFC00BDC         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM28H                  0xFFC00BE4         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM29H                  0xFFC00BEC         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM30H                  0xFFC00BF4         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_AM31H                  0xFFC00BFC         /* CAN0 Acceptance Mask (H) Register */
#define REG_CAN0_MB00_DATA0             0xFFC00C00         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB01_DATA0             0xFFC00C20         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB02_DATA0             0xFFC00C40         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB03_DATA0             0xFFC00C60         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB04_DATA0             0xFFC00C80         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB05_DATA0             0xFFC00CA0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB06_DATA0             0xFFC00CC0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB07_DATA0             0xFFC00CE0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB08_DATA0             0xFFC00D00         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB09_DATA0             0xFFC00D20         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB10_DATA0             0xFFC00D40         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB11_DATA0             0xFFC00D60         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB12_DATA0             0xFFC00D80         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB13_DATA0             0xFFC00DA0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB14_DATA0             0xFFC00DC0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB15_DATA0             0xFFC00DE0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB16_DATA0             0xFFC00E00         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB17_DATA0             0xFFC00E20         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB18_DATA0             0xFFC00E40         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB19_DATA0             0xFFC00E60         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB20_DATA0             0xFFC00E80         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB21_DATA0             0xFFC00EA0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB22_DATA0             0xFFC00EC0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB23_DATA0             0xFFC00EE0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB24_DATA0             0xFFC00F00         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB25_DATA0             0xFFC00F20         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB26_DATA0             0xFFC00F40         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB27_DATA0             0xFFC00F60         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB28_DATA0             0xFFC00F80         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB29_DATA0             0xFFC00FA0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB30_DATA0             0xFFC00FC0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB31_DATA0             0xFFC00FE0         /* CAN0 Mailbox Word 0 Register */
#define REG_CAN0_MB00_DATA1             0xFFC00C04         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB01_DATA1             0xFFC00C24         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB02_DATA1             0xFFC00C44         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB03_DATA1             0xFFC00C64         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB04_DATA1             0xFFC00C84         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB05_DATA1             0xFFC00CA4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB06_DATA1             0xFFC00CC4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB07_DATA1             0xFFC00CE4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB08_DATA1             0xFFC00D04         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB09_DATA1             0xFFC00D24         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB10_DATA1             0xFFC00D44         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB11_DATA1             0xFFC00D64         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB12_DATA1             0xFFC00D84         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB13_DATA1             0xFFC00DA4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB14_DATA1             0xFFC00DC4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB15_DATA1             0xFFC00DE4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB16_DATA1             0xFFC00E04         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB17_DATA1             0xFFC00E24         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB18_DATA1             0xFFC00E44         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB19_DATA1             0xFFC00E64         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB20_DATA1             0xFFC00E84         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB21_DATA1             0xFFC00EA4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB22_DATA1             0xFFC00EC4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB23_DATA1             0xFFC00EE4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB24_DATA1             0xFFC00F04         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB25_DATA1             0xFFC00F24         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB26_DATA1             0xFFC00F44         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB27_DATA1             0xFFC00F64         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB28_DATA1             0xFFC00F84         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB29_DATA1             0xFFC00FA4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB30_DATA1             0xFFC00FC4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB31_DATA1             0xFFC00FE4         /* CAN0 Mailbox Word 1 Register */
#define REG_CAN0_MB00_DATA2             0xFFC00C08         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB01_DATA2             0xFFC00C28         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB02_DATA2             0xFFC00C48         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB03_DATA2             0xFFC00C68         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB04_DATA2             0xFFC00C88         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB05_DATA2             0xFFC00CA8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB06_DATA2             0xFFC00CC8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB07_DATA2             0xFFC00CE8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB08_DATA2             0xFFC00D08         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB09_DATA2             0xFFC00D28         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB10_DATA2             0xFFC00D48         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB11_DATA2             0xFFC00D68         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB12_DATA2             0xFFC00D88         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB13_DATA2             0xFFC00DA8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB14_DATA2             0xFFC00DC8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB15_DATA2             0xFFC00DE8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB16_DATA2             0xFFC00E08         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB17_DATA2             0xFFC00E28         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB18_DATA2             0xFFC00E48         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB19_DATA2             0xFFC00E68         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB20_DATA2             0xFFC00E88         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB21_DATA2             0xFFC00EA8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB22_DATA2             0xFFC00EC8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB23_DATA2             0xFFC00EE8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB24_DATA2             0xFFC00F08         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB25_DATA2             0xFFC00F28         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB26_DATA2             0xFFC00F48         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB27_DATA2             0xFFC00F68         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB28_DATA2             0xFFC00F88         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB29_DATA2             0xFFC00FA8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB30_DATA2             0xFFC00FC8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB31_DATA2             0xFFC00FE8         /* CAN0 Mailbox Word 2 Register */
#define REG_CAN0_MB00_DATA3             0xFFC00C0C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB01_DATA3             0xFFC00C2C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB02_DATA3             0xFFC00C4C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB03_DATA3             0xFFC00C6C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB04_DATA3             0xFFC00C8C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB05_DATA3             0xFFC00CAC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB06_DATA3             0xFFC00CCC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB07_DATA3             0xFFC00CEC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB08_DATA3             0xFFC00D0C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB09_DATA3             0xFFC00D2C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB10_DATA3             0xFFC00D4C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB11_DATA3             0xFFC00D6C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB12_DATA3             0xFFC00D8C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB13_DATA3             0xFFC00DAC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB14_DATA3             0xFFC00DCC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB15_DATA3             0xFFC00DEC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB16_DATA3             0xFFC00E0C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB17_DATA3             0xFFC00E2C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB18_DATA3             0xFFC00E4C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB19_DATA3             0xFFC00E6C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB20_DATA3             0xFFC00E8C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB21_DATA3             0xFFC00EAC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB22_DATA3             0xFFC00ECC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB23_DATA3             0xFFC00EEC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB24_DATA3             0xFFC00F0C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB25_DATA3             0xFFC00F2C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB26_DATA3             0xFFC00F4C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB27_DATA3             0xFFC00F6C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB28_DATA3             0xFFC00F8C         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB29_DATA3             0xFFC00FAC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB30_DATA3             0xFFC00FCC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB31_DATA3             0xFFC00FEC         /* CAN0 Mailbox Word 3 Register */
#define REG_CAN0_MB00_LENGTH            0xFFC00C10         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB01_LENGTH            0xFFC00C30         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB02_LENGTH            0xFFC00C50         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB03_LENGTH            0xFFC00C70         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB04_LENGTH            0xFFC00C90         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB05_LENGTH            0xFFC00CB0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB06_LENGTH            0xFFC00CD0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB07_LENGTH            0xFFC00CF0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB08_LENGTH            0xFFC00D10         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB09_LENGTH            0xFFC00D30         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB10_LENGTH            0xFFC00D50         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB11_LENGTH            0xFFC00D70         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB12_LENGTH            0xFFC00D90         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB13_LENGTH            0xFFC00DB0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB14_LENGTH            0xFFC00DD0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB15_LENGTH            0xFFC00DF0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB16_LENGTH            0xFFC00E10         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB17_LENGTH            0xFFC00E30         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB18_LENGTH            0xFFC00E50         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB19_LENGTH            0xFFC00E70         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB20_LENGTH            0xFFC00E90         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB21_LENGTH            0xFFC00EB0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB22_LENGTH            0xFFC00ED0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB23_LENGTH            0xFFC00EF0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB24_LENGTH            0xFFC00F10         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB25_LENGTH            0xFFC00F30         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB26_LENGTH            0xFFC00F50         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB27_LENGTH            0xFFC00F70         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB28_LENGTH            0xFFC00F90         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB29_LENGTH            0xFFC00FB0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB30_LENGTH            0xFFC00FD0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB31_LENGTH            0xFFC00FF0         /* CAN0 Mailbox Length Register */
#define REG_CAN0_MB00_TIMESTAMP         0xFFC00C14         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB01_TIMESTAMP         0xFFC00C34         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB02_TIMESTAMP         0xFFC00C54         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB03_TIMESTAMP         0xFFC00C74         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB04_TIMESTAMP         0xFFC00C94         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB05_TIMESTAMP         0xFFC00CB4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB06_TIMESTAMP         0xFFC00CD4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB07_TIMESTAMP         0xFFC00CF4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB08_TIMESTAMP         0xFFC00D14         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB09_TIMESTAMP         0xFFC00D34         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB10_TIMESTAMP         0xFFC00D54         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB11_TIMESTAMP         0xFFC00D74         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB12_TIMESTAMP         0xFFC00D94         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB13_TIMESTAMP         0xFFC00DB4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB14_TIMESTAMP         0xFFC00DD4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB15_TIMESTAMP         0xFFC00DF4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB16_TIMESTAMP         0xFFC00E14         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB17_TIMESTAMP         0xFFC00E34         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB18_TIMESTAMP         0xFFC00E54         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB19_TIMESTAMP         0xFFC00E74         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB20_TIMESTAMP         0xFFC00E94         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB21_TIMESTAMP         0xFFC00EB4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB22_TIMESTAMP         0xFFC00ED4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB23_TIMESTAMP         0xFFC00EF4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB24_TIMESTAMP         0xFFC00F14         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB25_TIMESTAMP         0xFFC00F34         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB26_TIMESTAMP         0xFFC00F54         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB27_TIMESTAMP         0xFFC00F74         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB28_TIMESTAMP         0xFFC00F94         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB29_TIMESTAMP         0xFFC00FB4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB30_TIMESTAMP         0xFFC00FD4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB31_TIMESTAMP         0xFFC00FF4         /* CAN0 Mailbox Timestamp Register */
#define REG_CAN0_MB00_ID0               0xFFC00C18         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB01_ID0               0xFFC00C38         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB02_ID0               0xFFC00C58         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB03_ID0               0xFFC00C78         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB04_ID0               0xFFC00C98         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB05_ID0               0xFFC00CB8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB06_ID0               0xFFC00CD8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB07_ID0               0xFFC00CF8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB08_ID0               0xFFC00D18         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB09_ID0               0xFFC00D38         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB10_ID0               0xFFC00D58         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB11_ID0               0xFFC00D78         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB12_ID0               0xFFC00D98         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB13_ID0               0xFFC00DB8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB14_ID0               0xFFC00DD8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB15_ID0               0xFFC00DF8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB16_ID0               0xFFC00E18         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB17_ID0               0xFFC00E38         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB18_ID0               0xFFC00E58         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB19_ID0               0xFFC00E78         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB20_ID0               0xFFC00E98         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB21_ID0               0xFFC00EB8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB22_ID0               0xFFC00ED8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB23_ID0               0xFFC00EF8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB24_ID0               0xFFC00F18         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB25_ID0               0xFFC00F38         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB26_ID0               0xFFC00F58         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB27_ID0               0xFFC00F78         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB28_ID0               0xFFC00F98         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB29_ID0               0xFFC00FB8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB30_ID0               0xFFC00FD8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB31_ID0               0xFFC00FF8         /* CAN0 Mailbox ID 0 Register */
#define REG_CAN0_MB00_ID1               0xFFC00C1C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB01_ID1               0xFFC00C3C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB02_ID1               0xFFC00C5C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB03_ID1               0xFFC00C7C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB04_ID1               0xFFC00C9C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB05_ID1               0xFFC00CBC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB06_ID1               0xFFC00CDC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB07_ID1               0xFFC00CFC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB08_ID1               0xFFC00D1C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB09_ID1               0xFFC00D3C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB10_ID1               0xFFC00D5C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB11_ID1               0xFFC00D7C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB12_ID1               0xFFC00D9C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB13_ID1               0xFFC00DBC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB14_ID1               0xFFC00DDC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB15_ID1               0xFFC00DFC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB16_ID1               0xFFC00E1C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB17_ID1               0xFFC00E3C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB18_ID1               0xFFC00E5C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB19_ID1               0xFFC00E7C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB20_ID1               0xFFC00E9C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB21_ID1               0xFFC00EBC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB22_ID1               0xFFC00EDC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB23_ID1               0xFFC00EFC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB24_ID1               0xFFC00F1C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB25_ID1               0xFFC00F3C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB26_ID1               0xFFC00F5C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB27_ID1               0xFFC00F7C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB28_ID1               0xFFC00F9C         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB29_ID1               0xFFC00FBC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB30_ID1               0xFFC00FDC         /* CAN0 Mailbox ID 1 Register */
#define REG_CAN0_MB31_ID1               0xFFC00FFC         /* CAN0 Mailbox ID 1 Register */

/* =========================
        CAN
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MC1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MC1_MB00                     0                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB01                     1                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB02                     2                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB03                     3                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB04                     4                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB05                     5                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB06                     6                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB07                     7                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB08                     8                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB09                     9                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB10                    10                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB11                    11                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB12                    12                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB13                    13                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB14                    14                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC1_MB15                    15                               /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB00                    (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB01                    (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB02                    (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB03                    (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB04                    (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB05                    (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB06                    (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB07                    (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB08                    (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB09                    (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB10                    (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB11                    (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB12                    (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB13                    (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB14                    (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC1_MB15                    (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Enable/Disable */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MD1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MD1_MB00                     0                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB01                     1                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB02                     2                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB03                     3                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB04                     4                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB05                     5                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB06                     6                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB07                     7                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB08                     8                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB09                     9                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB10                    10                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB11                    11                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB12                    12                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB13                    13                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB14                    14                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD1_MB15                    15                               /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB00                    (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB01                    (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB02                    (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB03                    (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB04                    (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB05                    (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB06                    (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB07                    (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB08                    (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB09                    (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB10                    (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB11                    (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB12                    (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB13                    (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB14                    (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD1_MB15                    (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit/Receive */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_TRS1                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_TRS1_MB00                    0                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB01                    1                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB02                    2                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB03                    3                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB04                    4                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB05                    5                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB06                    6                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB07                    7                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB08                    8                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB09                    9                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB10                   10                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB11                   11                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB12                   12                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB13                   13                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB14                   14                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS1_MB15                   15                               /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS1_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit Request */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_TRR1                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_TRR1_MB00                    0                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB01                    1                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB02                    2                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB03                    3                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB04                    4                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB05                    5                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB06                    6                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB07                    7                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB08                    8                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB09                    9                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB10                   10                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB11                   11                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB12                   12                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB13                   13                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB14                   14                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR1_MB15                   15                               /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR1_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit Abort */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_TA1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_TA1_MB00                     0                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB01                     1                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB02                     2                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB03                     3                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB04                     4                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB05                     5                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB06                     6                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB07                     7                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB08                     8                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB09                     9                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB10                    10                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB11                    11                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB12                    12                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB13                    13                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB14                    14                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA1_MB15                    15                               /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB00                    (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB01                    (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB02                    (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB03                    (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB04                    (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB05                    (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB06                    (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB07                    (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB08                    (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB09                    (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB10                    (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB11                    (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB12                    (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB13                    (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB14                    (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA1_MB15                    (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit Acknowledge */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_AA1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_AA1_MB00                     0                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB01                     1                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB02                     2                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB03                     3                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB04                     4                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB05                     5                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB06                     6                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB07                     7                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB08                     8                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB09                     9                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB10                    10                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB11                    11                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB12                    12                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB13                    13                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB14                    14                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA1_MB15                    15                               /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB00                    (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB01                    (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB02                    (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB03                    (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB04                    (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB05                    (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB06                    (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB07                    (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB08                    (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB09                    (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB10                    (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB11                    (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB12                    (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB13                    (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB14                    (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA1_MB15                    (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Abort Acknowledge */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_RMP1                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_RMP1_MB00                    0                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB01                    1                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB02                    2                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB03                    3                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB04                    4                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB05                    5                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB06                    6                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB07                    7                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB08                    8                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB09                    9                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB10                   10                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB11                   11                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB12                   12                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB13                   13                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB14                   14                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP1_MB15                   15                               /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP1_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Message Pending */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_RML1                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_RML1_MB00                    0                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB01                    1                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB02                    2                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB03                    3                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB04                    4                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB05                    5                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB06                    6                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB07                    7                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB08                    8                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB09                    9                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB10                   10                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB11                   11                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB12                   12                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB13                   13                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB14                   14                               /* Mailbox n Message Lost */
#define BITP_CAN_RML1_MB15                   15                               /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML1_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Message Lost */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBTIF1                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MBTIF1_MB00                  0                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB01                  1                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB02                  2                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB03                  3                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB04                  4                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB05                  5                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB06                  6                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB07                  7                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB08                  8                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB09                  9                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB10                 10                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB11                 11                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB12                 12                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB13                 13                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB14                 14                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF1_MB15                 15                               /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB00                 (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB01                 (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB02                 (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB03                 (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB04                 (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB05                 (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB06                 (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB07                 (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB08                 (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB09                 (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB10                 (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB11                 (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB12                 (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB13                 (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB14                 (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF1_MB15                 (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit Interrupt Pending */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBRIF1                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MBRIF1_MB00                  0                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB01                  1                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB02                  2                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB03                  3                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB04                  4                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB05                  5                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB06                  6                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB07                  7                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB08                  8                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB09                  9                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB10                 10                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB11                 11                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB12                 12                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB13                 13                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB14                 14                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF1_MB15                 15                               /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB00                 (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB01                 (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB02                 (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB03                 (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB04                 (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB05                 (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB06                 (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB07                 (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB08                 (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB09                 (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB10                 (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB11                 (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB12                 (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB13                 (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB14                 (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF1_MB15                 (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Receive Interrupt Pending */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBIM1                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MBIM1_MB00                   0                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB01                   1                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB02                   2                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB03                   3                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB04                   4                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB05                   5                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB06                   6                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB07                   7                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB08                   8                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB09                   9                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB10                  10                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB11                  11                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB12                  12                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB13                  13                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB14                  14                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM1_MB15                  15                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB00                  (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB01                  (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB02                  (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB03                  (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB04                  (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB05                  (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB06                  (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB07                  (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB08                  (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB09                  (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB10                  (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB11                  (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB12                  (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB13                  (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB14                  (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM1_MB15                  (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_RFH1                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_RFH1_MB00                    0                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB01                    1                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB02                    2                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB03                    3                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB04                    4                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB05                    5                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB06                    6                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB07                    7                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB08                    8                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB09                    9                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB10                   10                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB11                   11                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB12                   12                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB13                   13                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB14                   14                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH1_MB15                   15                               /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH1_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Remote Frame Handling Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_OPSS1                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_OPSS1_MB00                   0                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB01                   1                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB02                   2                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB03                   3                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB04                   4                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB05                   5                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB06                   6                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB07                   7                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB08                   8                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB09                   9                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB10                  10                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB11                  11                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB12                  12                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB13                  13                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB14                  14                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS1_MB15                  15                               /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB00                  (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB01                  (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB02                  (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB03                  (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB04                  (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB05                  (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB06                  (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB07                  (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB08                  (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB09                  (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB10                  (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB11                  (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB12                  (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB13                  (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB14                  (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS1_MB15                  (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Overwrite Protection Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MC2                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MC2_MB00                     0                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB01                     1                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB02                     2                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB03                     3                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB04                     4                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB05                     5                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB06                     6                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB07                     7                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB08                     8                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB09                     9                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB10                    10                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB11                    11                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB12                    12                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB13                    13                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB14                    14                               /* Mailbox n Enable/Disable */
#define BITP_CAN_MC2_MB15                    15                               /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB00                    (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB01                    (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB02                    (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB03                    (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB04                    (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB05                    (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB06                    (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB07                    (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB08                    (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB09                    (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB10                    (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB11                    (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB12                    (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB13                    (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB14                    (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Enable/Disable */
#define BITM_CAN_MC2_MB15                    (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Enable/Disable */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MD2                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MD2_MB00                     0                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB01                     1                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB02                     2                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB03                     3                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB04                     4                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB05                     5                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB06                     6                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB07                     7                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB08                     8                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB09                     9                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB10                    10                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB11                    11                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB12                    12                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB13                    13                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB14                    14                               /* Mailbox n Transmit/Receive */
#define BITP_CAN_MD2_MB15                    15                               /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB00                    (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB01                    (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB02                    (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB03                    (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB04                    (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB05                    (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB06                    (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB07                    (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB08                    (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB09                    (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB10                    (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB11                    (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB12                    (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB13                    (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB14                    (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit/Receive */
#define BITM_CAN_MD2_MB15                    (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit/Receive */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_TRS2                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_TRS2_MB00                    0                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB01                    1                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB02                    2                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB03                    3                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB04                    4                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB05                    5                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB06                    6                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB07                    7                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB08                    8                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB09                    9                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB10                   10                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB11                   11                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB12                   12                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB13                   13                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB14                   14                               /* Mailbox n Transmit Request */
#define BITP_CAN_TRS2_MB15                   15                               /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit Request */
#define BITM_CAN_TRS2_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit Request */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_TRR2                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_TRR2_MB00                    0                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB01                    1                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB02                    2                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB03                    3                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB04                    4                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB05                    5                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB06                    6                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB07                    7                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB08                    8                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB09                    9                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB10                   10                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB11                   11                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB12                   12                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB13                   13                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB14                   14                               /* Mailbox n Transmit Abort */
#define BITP_CAN_TRR2_MB15                   15                               /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit Abort */
#define BITM_CAN_TRR2_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit Abort */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_TA2                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_TA2_MB00                     0                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB01                     1                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB02                     2                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB03                     3                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB04                     4                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB05                     5                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB06                     6                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB07                     7                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB08                     8                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB09                     9                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB10                    10                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB11                    11                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB12                    12                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB13                    13                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB14                    14                               /* Mailbox n Transmit Acknowledge */
#define BITP_CAN_TA2_MB15                    15                               /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB00                    (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB01                    (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB02                    (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB03                    (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB04                    (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB05                    (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB06                    (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB07                    (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB08                    (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB09                    (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB10                    (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB11                    (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB12                    (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB13                    (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB14                    (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit Acknowledge */
#define BITM_CAN_TA2_MB15                    (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit Acknowledge */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_AA2                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_AA2_MB00                     0                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB01                     1                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB02                     2                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB03                     3                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB04                     4                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB05                     5                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB06                     6                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB07                     7                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB08                     8                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB09                     9                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB10                    10                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB11                    11                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB12                    12                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB13                    13                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB14                    14                               /* Mailbox n Abort Acknowledge */
#define BITP_CAN_AA2_MB15                    15                               /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB00                    (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB01                    (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB02                    (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB03                    (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB04                    (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB05                    (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB06                    (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB07                    (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB08                    (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB09                    (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB10                    (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB11                    (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB12                    (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB13                    (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB14                    (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Abort Acknowledge */
#define BITM_CAN_AA2_MB15                    (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Abort Acknowledge */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_RMP2                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_RMP2_MB00                    0                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB01                    1                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB02                    2                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB03                    3                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB04                    4                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB05                    5                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB06                    6                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB07                    7                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB08                    8                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB09                    9                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB10                   10                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB11                   11                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB12                   12                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB13                   13                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB14                   14                               /* Mailbox n Message Pending */
#define BITP_CAN_RMP2_MB15                   15                               /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Message Pending */
#define BITM_CAN_RMP2_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Message Pending */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_RML2                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_RML2_MB00                    0                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB01                    1                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB02                    2                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB03                    3                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB04                    4                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB05                    5                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB06                    6                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB07                    7                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB08                    8                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB09                    9                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB10                   10                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB11                   11                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB12                   12                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB13                   13                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB14                   14                               /* Mailbox n Message Lost */
#define BITP_CAN_RML2_MB15                   15                               /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Message Lost */
#define BITM_CAN_RML2_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Message Lost */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBTIF2                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MBTIF2_MB00                  0                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB01                  1                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB02                  2                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB03                  3                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB04                  4                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB05                  5                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB06                  6                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB07                  7                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB08                  8                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB09                  9                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB10                 10                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB11                 11                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB12                 12                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB13                 13                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB14                 14                               /* Mailbox n Transmit Interrupt Pending */
#define BITP_CAN_MBTIF2_MB15                 15                               /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB00                 (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB01                 (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB02                 (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB03                 (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB04                 (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB05                 (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB06                 (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB07                 (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB08                 (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB09                 (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB10                 (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB11                 (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB12                 (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB13                 (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB14                 (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit Interrupt Pending */
#define BITM_CAN_MBTIF2_MB15                 (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit Interrupt Pending */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBRIF2                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MBRIF2_MB00                  0                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB01                  1                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB02                  2                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB03                  3                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB04                  4                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB05                  5                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB06                  6                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB07                  7                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB08                  8                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB09                  9                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB10                 10                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB11                 11                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB12                 12                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB13                 13                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB14                 14                               /* Mailbox n Receive Interrupt Pending */
#define BITP_CAN_MBRIF2_MB15                 15                               /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB00                 (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB01                 (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB02                 (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB03                 (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB04                 (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB05                 (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB06                 (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB07                 (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB08                 (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB09                 (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB10                 (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB11                 (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB12                 (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB13                 (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB14                 (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Receive Interrupt Pending */
#define BITM_CAN_MBRIF2_MB15                 (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Receive Interrupt Pending */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBIM2                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MBIM2_MB00                   0                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB01                   1                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB02                   2                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB03                   3                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB04                   4                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB05                   5                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB06                   6                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB07                   7                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB08                   8                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB09                   9                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB10                  10                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB11                  11                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB12                  12                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB13                  13                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB14                  14                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITP_CAN_MBIM2_MB15                  15                               /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB00                  (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB01                  (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB02                  (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB03                  (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB04                  (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB05                  (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB06                  (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB07                  (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB08                  (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB09                  (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB10                  (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB11                  (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB12                  (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB13                  (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB14                  (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */
#define BITM_CAN_MBIM2_MB15                  (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Transmit and Receive Interrupt Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_RFH2                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_RFH2_MB00                    0                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB01                    1                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB02                    2                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB03                    3                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB04                    4                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB05                    5                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB06                    6                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB07                    7                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB08                    8                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB09                    9                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB10                   10                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB11                   11                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB12                   12                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB13                   13                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB14                   14                               /* Mailbox n Remote Frame Handling Enable */
#define BITP_CAN_RFH2_MB15                   15                               /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB00                   (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB01                   (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB02                   (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB03                   (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB04                   (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB05                   (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB06                   (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB07                   (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB08                   (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB09                   (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB10                   (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB11                   (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB12                   (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB13                   (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB14                   (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Remote Frame Handling Enable */
#define BITM_CAN_RFH2_MB15                   (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Remote Frame Handling Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_OPSS2                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_OPSS2_MB00                   0                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB01                   1                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB02                   2                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB03                   3                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB04                   4                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB05                   5                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB06                   6                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB07                   7                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB08                   8                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB09                   9                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB10                  10                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB11                  11                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB12                  12                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB13                  13                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB14                  14                               /* Mailbox n Overwrite Protection Enable */
#define BITP_CAN_OPSS2_MB15                  15                               /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB00                  (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB01                  (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB02                  (_ADI_MSK(0x00000004,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB03                  (_ADI_MSK(0x00000008,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB04                  (_ADI_MSK(0x00000010,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB05                  (_ADI_MSK(0x00000020,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB06                  (_ADI_MSK(0x00000040,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB07                  (_ADI_MSK(0x00000080,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB08                  (_ADI_MSK(0x00000100,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB09                  (_ADI_MSK(0x00000200,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB10                  (_ADI_MSK(0x00000400,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB11                  (_ADI_MSK(0x00000800,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB12                  (_ADI_MSK(0x00001000,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB13                  (_ADI_MSK(0x00002000,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB14                  (_ADI_MSK(0x00004000,uint16_t))  /* Mailbox n Overwrite Protection Enable */
#define BITM_CAN_OPSS2_MB15                  (_ADI_MSK(0x00008000,uint16_t))  /* Mailbox n Overwrite Protection Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_CLK                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_CLK_BRP                      0                               /* Bit Rate Prescaler */
#define BITM_CAN_CLK_BRP                     (_ADI_MSK(0x000003FF,uint16_t))  /* Bit Rate Prescaler */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_TIMING                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_TIMING_SJW                   8                               /* Synchronization Jump Width */
#define BITP_CAN_TIMING_SAM                   7                               /* Sampling */
#define BITP_CAN_TIMING_TSEG2                 4                               /* Time Segment 2 */
#define BITP_CAN_TIMING_TSEG1                 0                               /* Time Segment 1 */
#define BITM_CAN_TIMING_SJW                  (_ADI_MSK(0x00000300,uint16_t))  /* Synchronization Jump Width */
#define BITM_CAN_TIMING_SAM                  (_ADI_MSK(0x00000080,uint16_t))  /* Sampling */
#define BITM_CAN_TIMING_TSEG2                (_ADI_MSK(0x00000070,uint16_t))  /* Time Segment 2 */
#define BITM_CAN_TIMING_TSEG1                (_ADI_MSK(0x0000000F,uint16_t))  /* Time Segment 1 */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_DBG                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_DBG_CDE                     15                               /* CAN Debug Mode Enable */
#define BITP_CAN_DBG_MRB                      5                               /* Mode Read Back */
#define BITP_CAN_DBG_MAA                      4                               /* Mode Auto Acknowledge */
#define BITP_CAN_DBG_DIL                      3                               /* Disable Internal Loop */
#define BITP_CAN_DBG_DTO                      2                               /* Disable Tx Output Pin */
#define BITP_CAN_DBG_DRI                      1                               /* Disable Receive Input Pin */
#define BITP_CAN_DBG_DEC                      0                               /* Disable Transmit and Receive Error Counters */
#define BITM_CAN_DBG_CDE                     (_ADI_MSK(0x00008000,uint16_t))  /* CAN Debug Mode Enable */
#define BITM_CAN_DBG_MRB                     (_ADI_MSK(0x00000020,uint16_t))  /* Mode Read Back */
#define BITM_CAN_DBG_MAA                     (_ADI_MSK(0x00000010,uint16_t))  /* Mode Auto Acknowledge */
#define BITM_CAN_DBG_DIL                     (_ADI_MSK(0x00000008,uint16_t))  /* Disable Internal Loop */
#define BITM_CAN_DBG_DTO                     (_ADI_MSK(0x00000004,uint16_t))  /* Disable Tx Output Pin */
#define BITM_CAN_DBG_DRI                     (_ADI_MSK(0x00000002,uint16_t))  /* Disable Receive Input Pin */
#define BITM_CAN_DBG_DEC                     (_ADI_MSK(0x00000001,uint16_t))  /* Disable Transmit and Receive Error Counters */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_STAT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_STAT_REC                    15                               /* Receive Mode */
#define BITP_CAN_STAT_TRM                    14                               /* Transmit Mode */
#define BITP_CAN_STAT_MBPTR                   8                               /* Mailbox Pointer */
#define BITP_CAN_STAT_CCA                     7                               /* CAN Configuration Mode Acknowledge */
#define BITP_CAN_STAT_CSA                     6                               /* CAN Suspend Mode Acknowledge */
#define BITP_CAN_STAT_EBO                     3                               /* CAN Error Bus Off Mode */
#define BITP_CAN_STAT_EP                      2                               /* CAN Error Passive Mode */
#define BITP_CAN_STAT_WR                      1                               /* CAN Receive Warning Flag */
#define BITP_CAN_STAT_WT                      0                               /* CAN Transmit Warning Flag */
#define BITM_CAN_STAT_REC                    (_ADI_MSK(0x00008000,uint16_t))  /* Receive Mode */
#define BITM_CAN_STAT_TRM                    (_ADI_MSK(0x00004000,uint16_t))  /* Transmit Mode */
#define BITM_CAN_STAT_MBPTR                  (_ADI_MSK(0x00001F00,uint16_t))  /* Mailbox Pointer */
#define BITM_CAN_STAT_CCA                    (_ADI_MSK(0x00000080,uint16_t))  /* CAN Configuration Mode Acknowledge */
#define BITM_CAN_STAT_CSA                    (_ADI_MSK(0x00000040,uint16_t))  /* CAN Suspend Mode Acknowledge */
#define BITM_CAN_STAT_EBO                    (_ADI_MSK(0x00000008,uint16_t))  /* CAN Error Bus Off Mode */
#define BITM_CAN_STAT_EP                     (_ADI_MSK(0x00000004,uint16_t))  /* CAN Error Passive Mode */
#define BITM_CAN_STAT_WR                     (_ADI_MSK(0x00000002,uint16_t))  /* CAN Receive Warning Flag */
#define BITM_CAN_STAT_WT                     (_ADI_MSK(0x00000001,uint16_t))  /* CAN Transmit Warning Flag */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_CEC                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_CEC_TXECNT                   8                               /* Transmit Error Counter */
#define BITP_CAN_CEC_RXECNT                   0                               /* Receive Error Counter */
#define BITM_CAN_CEC_TXECNT                  (_ADI_MSK(0x0000FF00,uint16_t))  /* Transmit Error Counter */
#define BITM_CAN_CEC_RXECNT                  (_ADI_MSK(0x000000FF,uint16_t))  /* Receive Error Counter */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_GIS                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_GIS_ADIS                    10                               /* Access Denied Interrupt Status */
#define BITP_CAN_GIS_UCEIS                    8                               /* Universal Counter Exceeded Interrupt Status */
#define BITP_CAN_GIS_RMLIS                    7                               /* Receive Message Lost Interrupt Status */
#define BITP_CAN_GIS_AAIS                     6                               /* Abort Acknowledge Interrupt Status */
#define BITP_CAN_GIS_UIAIS                    5                               /* Unimplemented Address Interrupt Status */
#define BITP_CAN_GIS_WUIS                     4                               /* Wake Up Interrupt Status */
#define BITP_CAN_GIS_BOIS                     3                               /* Bus Off Interrupt Status */
#define BITP_CAN_GIS_EPIS                     2                               /* Error Passive Interrupt Status */
#define BITP_CAN_GIS_EWRIS                    1                               /* Error Warning Receive  Interrupt Status */
#define BITP_CAN_GIS_EWTIS                    0                               /* Error Warning Transmit Interrupt Status */
#define BITM_CAN_GIS_ADIS                    (_ADI_MSK(0x00000400,uint16_t))  /* Access Denied Interrupt Status */
#define BITM_CAN_GIS_UCEIS                   (_ADI_MSK(0x00000100,uint16_t))  /* Universal Counter Exceeded Interrupt Status */
#define BITM_CAN_GIS_RMLIS                   (_ADI_MSK(0x00000080,uint16_t))  /* Receive Message Lost Interrupt Status */
#define BITM_CAN_GIS_AAIS                    (_ADI_MSK(0x00000040,uint16_t))  /* Abort Acknowledge Interrupt Status */
#define BITM_CAN_GIS_UIAIS                   (_ADI_MSK(0x00000020,uint16_t))  /* Unimplemented Address Interrupt Status */
#define BITM_CAN_GIS_WUIS                    (_ADI_MSK(0x00000010,uint16_t))  /* Wake Up Interrupt Status */
#define BITM_CAN_GIS_BOIS                    (_ADI_MSK(0x00000008,uint16_t))  /* Bus Off Interrupt Status */
#define BITM_CAN_GIS_EPIS                    (_ADI_MSK(0x00000004,uint16_t))  /* Error Passive Interrupt Status */
#define BITM_CAN_GIS_EWRIS                   (_ADI_MSK(0x00000002,uint16_t))  /* Error Warning Receive  Interrupt Status */
#define BITM_CAN_GIS_EWTIS                   (_ADI_MSK(0x00000001,uint16_t))  /* Error Warning Transmit Interrupt Status */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_GIM                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_GIM_ADIM                    10                               /* Access Denied Interrupt Mask */
#define BITP_CAN_GIM_UCEIM                    8                               /* Universal Counter Exceeded Interrupt Mask */
#define BITP_CAN_GIM_RMLIM                    7                               /* Receive Message Lost Interrupt Mask */
#define BITP_CAN_GIM_AAIM                     6                               /* Abort Acknowledge Interrupt Mask */
#define BITP_CAN_GIM_UIAIM                    5                               /* Unimplemented Address Interrupt Mask */
#define BITP_CAN_GIM_WUIM                     4                               /* Wake Up Interrupt Mask */
#define BITP_CAN_GIM_BOIM                     3                               /* Bus Off Interrupt Mask */
#define BITP_CAN_GIM_EPIM                     2                               /* Error Passive Interrupt Mask */
#define BITP_CAN_GIM_EWRIM                    1                               /* Error Warning Receive Interrupt Mask */
#define BITP_CAN_GIM_EWTIM                    0                               /* Error Warning Transmit Interrupt Mask */
#define BITM_CAN_GIM_ADIM                    (_ADI_MSK(0x00000400,uint16_t))  /* Access Denied Interrupt Mask */
#define BITM_CAN_GIM_UCEIM                   (_ADI_MSK(0x00000100,uint16_t))  /* Universal Counter Exceeded Interrupt Mask */
#define BITM_CAN_GIM_RMLIM                   (_ADI_MSK(0x00000080,uint16_t))  /* Receive Message Lost Interrupt Mask */
#define BITM_CAN_GIM_AAIM                    (_ADI_MSK(0x00000040,uint16_t))  /* Abort Acknowledge Interrupt Mask */
#define BITM_CAN_GIM_UIAIM                   (_ADI_MSK(0x00000020,uint16_t))  /* Unimplemented Address Interrupt Mask */
#define BITM_CAN_GIM_WUIM                    (_ADI_MSK(0x00000010,uint16_t))  /* Wake Up Interrupt Mask */
#define BITM_CAN_GIM_BOIM                    (_ADI_MSK(0x00000008,uint16_t))  /* Bus Off Interrupt Mask */
#define BITM_CAN_GIM_EPIM                    (_ADI_MSK(0x00000004,uint16_t))  /* Error Passive Interrupt Mask */
#define BITM_CAN_GIM_EWRIM                   (_ADI_MSK(0x00000002,uint16_t))  /* Error Warning Receive Interrupt Mask */
#define BITM_CAN_GIM_EWTIM                   (_ADI_MSK(0x00000001,uint16_t))  /* Error Warning Transmit Interrupt Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_GIF                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_GIF_ADIF                    10                               /* Access Denied Interrupt Flag */
#define BITP_CAN_GIF_UCEIF                    8                               /* Universal Counter Exceeded Interrupt Flag */
#define BITP_CAN_GIF_RMLIF                    7                               /* Receive Message Lost Interrupt Flag */
#define BITP_CAN_GIF_AAIF                     6                               /* Abort Acknowledge Interrupt Flag */
#define BITP_CAN_GIF_UIAIF                    5                               /* Unimplemented Address Interrupt Flag */
#define BITP_CAN_GIF_WUIF                     4                               /* Wake Up Interrupt Flag */
#define BITP_CAN_GIF_BOIF                     3                               /* Bus Off Interrupt Flag */
#define BITP_CAN_GIF_EPIF                     2                               /* Error Passive Interrupt Flag */
#define BITP_CAN_GIF_EWRIF                    1                               /* Error Warning Receive Interrupt Flag */
#define BITP_CAN_GIF_EWTIF                    0                               /* Error Warning Transmit Interrupt Flag */
#define BITM_CAN_GIF_ADIF                    (_ADI_MSK(0x00000400,uint16_t))  /* Access Denied Interrupt Flag */
#define BITM_CAN_GIF_UCEIF                   (_ADI_MSK(0x00000100,uint16_t))  /* Universal Counter Exceeded Interrupt Flag */
#define BITM_CAN_GIF_RMLIF                   (_ADI_MSK(0x00000080,uint16_t))  /* Receive Message Lost Interrupt Flag */
#define BITM_CAN_GIF_AAIF                    (_ADI_MSK(0x00000040,uint16_t))  /* Abort Acknowledge Interrupt Flag */
#define BITM_CAN_GIF_UIAIF                   (_ADI_MSK(0x00000020,uint16_t))  /* Unimplemented Address Interrupt Flag */
#define BITM_CAN_GIF_WUIF                    (_ADI_MSK(0x00000010,uint16_t))  /* Wake Up Interrupt Flag */
#define BITM_CAN_GIF_BOIF                    (_ADI_MSK(0x00000008,uint16_t))  /* Bus Off Interrupt Flag */
#define BITM_CAN_GIF_EPIF                    (_ADI_MSK(0x00000004,uint16_t))  /* Error Passive Interrupt Flag */
#define BITM_CAN_GIF_EWRIF                   (_ADI_MSK(0x00000002,uint16_t))  /* Error Warning Receive Interrupt Flag */
#define BITM_CAN_GIF_EWTIF                   (_ADI_MSK(0x00000001,uint16_t))  /* Error Warning Transmit Interrupt Flag */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_CTL                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_CTL_CCR                      7                               /* CAN Configuration Mode Request */
#define BITP_CAN_CTL_CSR                      6                               /* CAN Suspend Mode Request */
#define BITP_CAN_CTL_SMR                      5                               /* Sleep Mode Request */
#define BITP_CAN_CTL_WBA                      4                               /* Wake Up on CAN Bus Activity */
#define BITP_CAN_CTL_ABO                      2                               /* Auto Bus On */
#define BITP_CAN_CTL_DNM                      1                               /* Device Net Mode */
#define BITP_CAN_CTL_SRS                      0                               /* Software Reset */
#define BITM_CAN_CTL_CCR                     (_ADI_MSK(0x00000080,uint16_t))  /* CAN Configuration Mode Request */
#define BITM_CAN_CTL_CSR                     (_ADI_MSK(0x00000040,uint16_t))  /* CAN Suspend Mode Request */
#define BITM_CAN_CTL_SMR                     (_ADI_MSK(0x00000020,uint16_t))  /* Sleep Mode Request */
#define BITM_CAN_CTL_WBA                     (_ADI_MSK(0x00000010,uint16_t))  /* Wake Up on CAN Bus Activity */
#define BITM_CAN_CTL_ABO                     (_ADI_MSK(0x00000004,uint16_t))  /* Auto Bus On */
#define BITM_CAN_CTL_DNM                     (_ADI_MSK(0x00000002,uint16_t))  /* Device Net Mode */
#define BITM_CAN_CTL_SRS                     (_ADI_MSK(0x00000001,uint16_t))  /* Software Reset */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_INT                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_INT_CANRX                    7                               /* Serial Input From Transceiver */
#define BITP_CAN_INT_CANTX                    6                               /* Serial Input To Transceiver */
#define BITP_CAN_INT_SMACK                    3                               /* Sleep Mode Acknowledge */
#define BITP_CAN_INT_GIRQ                     2                               /* Global CAN Interrupt Output */
#define BITP_CAN_INT_MBTIRQ                   1                               /* Mailbox Transmit Interrupt Output */
#define BITP_CAN_INT_MBRIRQ                   0                               /* Mailbox Receive Interrupt Output */
#define BITM_CAN_INT_CANRX                   (_ADI_MSK(0x00000080,uint16_t))  /* Serial Input From Transceiver */
#define BITM_CAN_INT_CANTX                   (_ADI_MSK(0x00000040,uint16_t))  /* Serial Input To Transceiver */
#define BITM_CAN_INT_SMACK                   (_ADI_MSK(0x00000008,uint16_t))  /* Sleep Mode Acknowledge */
#define BITM_CAN_INT_GIRQ                    (_ADI_MSK(0x00000004,uint16_t))  /* Global CAN Interrupt Output */
#define BITM_CAN_INT_MBTIRQ                  (_ADI_MSK(0x00000002,uint16_t))  /* Mailbox Transmit Interrupt Output */
#define BITM_CAN_INT_MBRIRQ                  (_ADI_MSK(0x00000001,uint16_t))  /* Mailbox Receive Interrupt Output */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBTD                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MBTD_TDR                     7                               /* Temporary Disable Request */
#define BITP_CAN_MBTD_TDA                     6                               /* Temporary Disable Acknowledge */
#define BITP_CAN_MBTD_TDPTR                   0                               /* Temporary Disable Pointer */
#define BITM_CAN_MBTD_TDR                    (_ADI_MSK(0x00000080,uint16_t))  /* Temporary Disable Request */
#define BITM_CAN_MBTD_TDA                    (_ADI_MSK(0x00000040,uint16_t))  /* Temporary Disable Acknowledge */
#define BITM_CAN_MBTD_TDPTR                  (_ADI_MSK(0x0000001F,uint16_t))  /* Temporary Disable Pointer */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_EWR                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_EWR_EWLTEC                   8                               /* Transmit Error Warning Limit */
#define BITP_CAN_EWR_EWLREC                   0                               /* Receive Error Warning Limit */
#define BITM_CAN_EWR_EWLTEC                  (_ADI_MSK(0x0000FF00,uint16_t))  /* Transmit Error Warning Limit */
#define BITM_CAN_EWR_EWLREC                  (_ADI_MSK(0x000000FF,uint16_t))  /* Receive Error Warning Limit */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_ESR                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_ESR_FER                      7                               /* Form Error */
#define BITP_CAN_ESR_BEF                      6                               /* Bit Error Flag */
#define BITP_CAN_ESR_SAO                      5                               /* Stuck at Dominant */
#define BITP_CAN_ESR_CRCE                     4                               /* CRC Error */
#define BITP_CAN_ESR_SER                      3                               /* Stuff Bit Error */
#define BITP_CAN_ESR_ACKE                     2                               /* Acknowledge Error */
#define BITM_CAN_ESR_FER                     (_ADI_MSK(0x00000080,uint16_t))  /* Form Error */
#define BITM_CAN_ESR_BEF                     (_ADI_MSK(0x00000040,uint16_t))  /* Bit Error Flag */
#define BITM_CAN_ESR_SAO                     (_ADI_MSK(0x00000020,uint16_t))  /* Stuck at Dominant */
#define BITM_CAN_ESR_CRCE                    (_ADI_MSK(0x00000010,uint16_t))  /* CRC Error */
#define BITM_CAN_ESR_SER                     (_ADI_MSK(0x00000008,uint16_t))  /* Stuff Bit Error */
#define BITM_CAN_ESR_ACKE                    (_ADI_MSK(0x00000004,uint16_t))  /* Acknowledge Error */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_UCCNF                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_UCCNF_UCE                    7                               /* Universal Counter Enable */
#define BITP_CAN_UCCNF_UCCT                   6                               /* Universal Counter CAN Trigger */
#define BITP_CAN_UCCNF_UCRC                   5                               /* Universal Counter Reload/Clear */
#define BITP_CAN_UCCNF_UCCNF                  0                               /* Universal Counter Configuration */
#define BITM_CAN_UCCNF_UCE                   (_ADI_MSK(0x00000080,uint16_t))  /* Universal Counter Enable */
#define BITM_CAN_UCCNF_UCCT                  (_ADI_MSK(0x00000040,uint16_t))  /* Universal Counter CAN Trigger */
#define BITM_CAN_UCCNF_UCRC                  (_ADI_MSK(0x00000020,uint16_t))  /* Universal Counter Reload/Clear */
#define BITM_CAN_UCCNF_UCCNF                 (_ADI_MSK(0x0000000F,uint16_t))  /* Universal Counter Configuration */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_AMnH                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_AMH_FDF                     15                               /* Filter on Delay Field */
#define BITP_CAN_AMH_FMD                     14                               /* Full Mask Data */
#define BITP_CAN_AMH_AMIDE                   13                               /* Acceptance Mask Identifier Extension */
#define BITP_CAN_AMH_BASEID                   2                               /* Base Identifier */
#define BITP_CAN_AMH_EXTID                    0                               /* Extended Identifier */
#define BITM_CAN_AMH_FDF                     (_ADI_MSK(0x00008000,uint16_t))  /* Filter on Delay Field */
#define BITM_CAN_AMH_FMD                     (_ADI_MSK(0x00004000,uint16_t))  /* Full Mask Data */
#define BITM_CAN_AMH_AMIDE                   (_ADI_MSK(0x00002000,uint16_t))  /* Acceptance Mask Identifier Extension */
#define BITM_CAN_AMH_BASEID                  (_ADI_MSK(0x00001FFC,uint16_t))  /* Base Identifier */
#define BITM_CAN_AMH_EXTID                   (_ADI_MSK(0x00000003,uint16_t))  /* Extended Identifier */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBn_DATA0                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MB_DATA0_DFB6                8                               /* Data Field Byte 6 */
#define BITP_CAN_MB_DATA0_DFB7                0                               /* Data Field Byte 7 */
#define BITM_CAN_MB_DATA0_DFB6               (_ADI_MSK(0x0000FF00,uint16_t))  /* Data Field Byte 6 */
#define BITM_CAN_MB_DATA0_DFB7               (_ADI_MSK(0x000000FF,uint16_t))  /* Data Field Byte 7 */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBn_DATA1                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MB_DATA1_DFB4                8                               /* Data Field Byte 4 */
#define BITP_CAN_MB_DATA1_DFB5                0                               /* Data Field Byte 5 */
#define BITM_CAN_MB_DATA1_DFB4               (_ADI_MSK(0x0000FF00,uint16_t))  /* Data Field Byte 4 */
#define BITM_CAN_MB_DATA1_DFB5               (_ADI_MSK(0x000000FF,uint16_t))  /* Data Field Byte 5 */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBn_DATA2                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MB_DATA2_DFB2                8                               /* Data Field Byte 2 */
#define BITP_CAN_MB_DATA2_DFB3                0                               /* Data Field Byte 3 */
#define BITM_CAN_MB_DATA2_DFB2               (_ADI_MSK(0x0000FF00,uint16_t))  /* Data Field Byte 2 */
#define BITM_CAN_MB_DATA2_DFB3               (_ADI_MSK(0x000000FF,uint16_t))  /* Data Field Byte 3 */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBn_DATA3                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MB_DATA3_DFB0                8                               /* Data Field Byte 0 */
#define BITP_CAN_MB_DATA3_DFB1                0                               /* Data Field Byte 1 */
#define BITM_CAN_MB_DATA3_DFB0               (_ADI_MSK(0x0000FF00,uint16_t))  /* Data Field Byte 0 */
#define BITM_CAN_MB_DATA3_DFB1               (_ADI_MSK(0x000000FF,uint16_t))  /* Data Field Byte 1 */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBn_LENGTH                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MB_LENGTH_DLC                0                               /* Data Length Code */
#define BITM_CAN_MB_LENGTH_DLC               (_ADI_MSK(0x0000000F,uint16_t))  /* Data Length Code */

/* ------------------------------------------------------------------------------------------------------------------------
        CAN_MBn_ID1                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CAN_MB_ID1_AME                  15                               /* Acceptance Mask Enable */
#define BITP_CAN_MB_ID1_RTR                  14                               /* Remote Transmission Request */
#define BITP_CAN_MB_ID1_IDE                  13                               /* Identifier Extension */
#define BITP_CAN_MB_ID1_BASEID                2                               /* Base Identifier */
#define BITP_CAN_MB_ID1_EXTID                 0                               /* Extended Identifier */
#define BITM_CAN_MB_ID1_AME                  (_ADI_MSK(0x00008000,uint16_t))  /* Acceptance Mask Enable */
#define BITM_CAN_MB_ID1_RTR                  (_ADI_MSK(0x00004000,uint16_t))  /* Remote Transmission Request */
#define BITM_CAN_MB_ID1_IDE                  (_ADI_MSK(0x00002000,uint16_t))  /* Identifier Extension */
#define BITM_CAN_MB_ID1_BASEID               (_ADI_MSK(0x00001FFC,uint16_t))  /* Base Identifier */
#define BITM_CAN_MB_ID1_EXTID                (_ADI_MSK(0x00000003,uint16_t))  /* Extended Identifier */

/* ==================================================
        Link Port Registers
   ================================================== */

/* =========================
        LP0
   ========================= */
#define REG_LP0_CTL                     0xFFC01000         /* LP0 Control Register */
#define REG_LP0_STAT                    0xFFC01004         /* LP0 Status Register */
#define REG_LP0_DIV                     0xFFC01008         /* LP0 Clock Divider Value */
#define REG_LP0_TX                      0xFFC01010         /* LP0 Transmit Buffer */
#define REG_LP0_RX                      0xFFC01014         /* LP0 Receive Buffer */
#define REG_LP0_TXIN_SHDW               0xFFC01018         /* LP0 Shadow Input Transmit Buffer */
#define REG_LP0_TXOUT_SHDW              0xFFC0101C         /* LP0 Shadow Output Transmit Buffer */

/* =========================
        LP1
   ========================= */
#define REG_LP1_CTL                     0xFFC01100         /* LP1 Control Register */
#define REG_LP1_STAT                    0xFFC01104         /* LP1 Status Register */
#define REG_LP1_DIV                     0xFFC01108         /* LP1 Clock Divider Value */
#define REG_LP1_TX                      0xFFC01110         /* LP1 Transmit Buffer */
#define REG_LP1_RX                      0xFFC01114         /* LP1 Receive Buffer */
#define REG_LP1_TXIN_SHDW               0xFFC01118         /* LP1 Shadow Input Transmit Buffer */
#define REG_LP1_TXOUT_SHDW              0xFFC0111C         /* LP1 Shadow Output Transmit Buffer */

/* =========================
        LP2
   ========================= */
#define REG_LP2_CTL                     0xFFC01200         /* LP2 Control Register */
#define REG_LP2_STAT                    0xFFC01204         /* LP2 Status Register */
#define REG_LP2_DIV                     0xFFC01208         /* LP2 Clock Divider Value */
#define REG_LP2_TX                      0xFFC01210         /* LP2 Transmit Buffer */
#define REG_LP2_RX                      0xFFC01214         /* LP2 Receive Buffer */
#define REG_LP2_TXIN_SHDW               0xFFC01218         /* LP2 Shadow Input Transmit Buffer */
#define REG_LP2_TXOUT_SHDW              0xFFC0121C         /* LP2 Shadow Output Transmit Buffer */

/* =========================
        LP3
   ========================= */
#define REG_LP3_CTL                     0xFFC01300         /* LP3 Control Register */
#define REG_LP3_STAT                    0xFFC01304         /* LP3 Status Register */
#define REG_LP3_DIV                     0xFFC01308         /* LP3 Clock Divider Value */
#define REG_LP3_TX                      0xFFC01310         /* LP3 Transmit Buffer */
#define REG_LP3_RX                      0xFFC01314         /* LP3 Receive Buffer */
#define REG_LP3_TXIN_SHDW               0xFFC01318         /* LP3 Shadow Input Transmit Buffer */
#define REG_LP3_TXOUT_SHDW              0xFFC0131C         /* LP3 Shadow Output Transmit Buffer */

/* =========================
        LP
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        LP_CTL                               Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_LP_CTL_ITMSK                    11                               /* Receive FIFO Overflow Interrupt Mask */
#define BITP_LP_CTL_RRQMSK                    9                               /* Receive Request Interrupt Mask */
#define BITP_LP_CTL_TRQMSK                    8                               /* Transmit Request Interrupt Mask */
#define BITP_LP_CTL_TRAN                      3                               /* Transfer Direction */
#define BITP_LP_CTL_EN                        0                               /* Enable */

#define BITM_LP_CTL_ITMSK                    (_ADI_MSK(0x00000800,uint32_t))  /* Receive FIFO Overflow Interrupt Mask */
#define ENUM_LP_CTL_RX_OVF_DIS               (_ADI_MSK(0x00000000,uint32_t))  /* ITMSK: Mask */
#define ENUM_LP_CTL_RX_OVF_EN                (_ADI_MSK(0x00000800,uint32_t))  /* ITMSK: Unmask */

#define BITM_LP_CTL_RRQMSK                   (_ADI_MSK(0x00000200,uint32_t))  /* Receive Request Interrupt Mask */
#define ENUM_LP_CTL_RRQ_DIS                  (_ADI_MSK(0x00000000,uint32_t))  /* RRQMSK: Mask */
#define ENUM_LP_CTL_RRQ_EN                   (_ADI_MSK(0x00000200,uint32_t))  /* RRQMSK: Unmask */

#define BITM_LP_CTL_TRQMSK                   (_ADI_MSK(0x00000100,uint32_t))  /* Transmit Request Interrupt Mask */
#define ENUM_LP_CTL_TRQ_DIS                  (_ADI_MSK(0x00000000,uint32_t))  /* TRQMSK: Mask */
#define ENUM_LP_CTL_TRQ_EN                   (_ADI_MSK(0x00000100,uint32_t))  /* TRQMSK: Unmask */

#define BITM_LP_CTL_TRAN                     (_ADI_MSK(0x00000008,uint32_t))  /* Transfer Direction */
#define ENUM_LP_CTL_RX                       (_ADI_MSK(0x00000000,uint32_t))  /* TRAN: Receive */
#define ENUM_LP_CTL_TX                       (_ADI_MSK(0x00000008,uint32_t))  /* TRAN: Transmit */

#define BITM_LP_CTL_EN                       (_ADI_MSK(0x00000001,uint32_t))  /* Enable */
#define ENUM_LP_CTL_DIS                      (_ADI_MSK(0x00000000,uint32_t))  /* EN: Disable */
#define ENUM_LP_CTL_EN                       (_ADI_MSK(0x00000001,uint32_t))  /* EN: Enable   linkport */

/* ------------------------------------------------------------------------------------------------------------------------
        LP_STAT                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_LP_STAT_LPBS                     8                               /* Bus Status */
#define BITP_LP_STAT_LERR                     7                               /* Buffer Pack Error Status */
#define BITP_LP_STAT_FFST                     4                               /* FIFO Status */
#define BITP_LP_STAT_LPIT                     3                               /* Receive FIFO Overflow Interrupt */
#define BITP_LP_STAT_LRRQ                     1                               /* Receive Request */
#define BITP_LP_STAT_LTRQ                     0                               /* Transmit Request */

#define BITM_LP_STAT_LPBS                    (_ADI_MSK(0x00000100,uint32_t))  /* Bus Status */
#define ENUM_LP_STAT_IDLE                    (_ADI_MSK(0x00000000,uint32_t))  /* LPBS: Bus is Idle */
#define ENUM_LP_STAT_BUSY                    (_ADI_MSK(0x00000100,uint32_t))  /* LPBS: Bus Busy */

#define BITM_LP_STAT_LERR                    (_ADI_MSK(0x00000080,uint32_t))  /* Buffer Pack Error Status */
#define ENUM_LP_STAT_PACK_DONE               (_ADI_MSK(0x00000000,uint32_t))  /* LERR: Packing Complete */
#define ENUM_LP_STAT_PACK_PROG               (_ADI_MSK(0x00000080,uint32_t))  /* LERR: Packing Incomplete */

#define BITM_LP_STAT_FFST                    (_ADI_MSK(0x00000070,uint32_t))  /* FIFO Status */
#define ENUM_LP_STAT_RX0_TX0                 (_ADI_MSK(0x00000000,uint32_t))  /* FFST: TX - Empty; RX -Empty */
#define ENUM_LP_STAT_RX1_TXR                 (_ADI_MSK(0x00000010,uint32_t))  /* FFST: TX - reserved ; RX - One Word */
#define ENUM_LP_STAT_RX2_TXR                 (_ADI_MSK(0x00000020,uint32_t))  /* FFST: TX - reserved; RX - Two Word */
#define ENUM_LP_STAT_RX3_TXR                 (_ADI_MSK(0x00000030,uint32_t))  /* FFST: TX - reserved; RX - Three Word */
#define ENUM_LP_STAT_RX4_TX1                 (_ADI_MSK(0x00000040,uint32_t))  /* FFST: TX - One Word; RX - Four word */
#define ENUM_LP_STAT_RXR1_TXR1               (_ADI_MSK(0x00000050,uint32_t))  /* FFST: TX - Reserved; RX - Reserved */
#define ENUM_LP_STAT_RXR2_TXR2               (_ADI_MSK(0x00000060,uint32_t))  /* FFST: TX - FIFO Full; RX - Reserved */
#define ENUM_LP_STAT_RXR3_TXR3               (_ADI_MSK(0x00000070,uint32_t))  /* FFST: TX - Reserved; RX - Reserved */
#define BITM_LP_STAT_LPIT                    (_ADI_MSK(0x00000008,uint32_t))  /* Receive FIFO Overflow Interrupt */
#define BITM_LP_STAT_LRRQ                    (_ADI_MSK(0x00000002,uint32_t))  /* Receive Request */
#define BITM_LP_STAT_LTRQ                    (_ADI_MSK(0x00000001,uint32_t))  /* Transmit Request */

/* ------------------------------------------------------------------------------------------------------------------------
        LP_DIV                               Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_LP_DIV_VALUE                     0                               /* Divisor Value */
#define BITM_LP_DIV_VALUE                    (_ADI_MSK(0x000000FF,uint32_t))  /* Divisor Value */

/* ==================================================
        General Purpose Timer Block Registers
   ================================================== */

/* =========================
        TIMER0
   ========================= */
#define REG_TIMER0_REVID                0xFFC01400         /* TIMER0 Revision ID Register */
#define REG_TIMER0_RUN                  0xFFC01404         /* TIMER0 Run Register */
#define REG_TIMER0_RUN_SET              0xFFC01408         /* TIMER0 Run Set Register */
#define REG_TIMER0_RUN_CLR              0xFFC0140C         /* TIMER0 Run Clear Register */
#define REG_TIMER0_STOP_CFG             0xFFC01410         /* TIMER0 Stop Configuration Register */
#define REG_TIMER0_STOP_CFG_SET         0xFFC01414         /* TIMER0 Stop Configuration Set Register */
#define REG_TIMER0_STOP_CFG_CLR         0xFFC01418         /* TIMER0 Stop Configuration Clear Register */
#define REG_TIMER0_DATA_IMSK            0xFFC0141C         /* TIMER0 Data Interrupt Mask Register */
#define REG_TIMER0_STAT_IMSK            0xFFC01420         /* TIMER0 Status Interrupt Mask Register */
#define REG_TIMER0_TRG_MSK              0xFFC01424         /* TIMER0 Trigger Master Mask Register */
#define REG_TIMER0_TRG_IE               0xFFC01428         /* TIMER0 Trigger Slave Enable Register */
#define REG_TIMER0_DATA_ILAT            0xFFC0142C         /* TIMER0 Data Interrupt Latch Register */
#define REG_TIMER0_STAT_ILAT            0xFFC01430         /* TIMER0 Status Interrupt Latch Register */
#define REG_TIMER0_ERR_TYPE             0xFFC01434         /* TIMER0 Error Type Status Register */
#define REG_TIMER0_BCAST_PER            0xFFC01438         /* TIMER0 Broadcast Period Register */
#define REG_TIMER0_BCAST_WID            0xFFC0143C         /* TIMER0 Broadcast Width Register */
#define REG_TIMER0_BCAST_DLY            0xFFC01440         /* TIMER0 Broadcast Delay Register */
#define REG_TIMER0_TMR0_CFG             0xFFC01460         /* TIMER0 Timer n Configuration Register */
#define REG_TIMER0_TMR1_CFG             0xFFC01480         /* TIMER0 Timer n Configuration Register */
#define REG_TIMER0_TMR2_CFG             0xFFC014A0         /* TIMER0 Timer n Configuration Register */
#define REG_TIMER0_TMR3_CFG             0xFFC014C0         /* TIMER0 Timer n Configuration Register */
#define REG_TIMER0_TMR4_CFG             0xFFC014E0         /* TIMER0 Timer n Configuration Register */
#define REG_TIMER0_TMR5_CFG             0xFFC01500         /* TIMER0 Timer n Configuration Register */
#define REG_TIMER0_TMR6_CFG             0xFFC01520         /* TIMER0 Timer n Configuration Register */
#define REG_TIMER0_TMR7_CFG             0xFFC01540         /* TIMER0 Timer n Configuration Register */
#define REG_TIMER0_TMR0_CNT             0xFFC01464         /* TIMER0 Timer n Counter Register */
#define REG_TIMER0_TMR1_CNT             0xFFC01484         /* TIMER0 Timer n Counter Register */
#define REG_TIMER0_TMR2_CNT             0xFFC014A4         /* TIMER0 Timer n Counter Register */
#define REG_TIMER0_TMR3_CNT             0xFFC014C4         /* TIMER0 Timer n Counter Register */
#define REG_TIMER0_TMR4_CNT             0xFFC014E4         /* TIMER0 Timer n Counter Register */
#define REG_TIMER0_TMR5_CNT             0xFFC01504         /* TIMER0 Timer n Counter Register */
#define REG_TIMER0_TMR6_CNT             0xFFC01524         /* TIMER0 Timer n Counter Register */
#define REG_TIMER0_TMR7_CNT             0xFFC01544         /* TIMER0 Timer n Counter Register */
#define REG_TIMER0_TMR0_PER             0xFFC01468         /* TIMER0 Timer n Period Register */
#define REG_TIMER0_TMR1_PER             0xFFC01488         /* TIMER0 Timer n Period Register */
#define REG_TIMER0_TMR2_PER             0xFFC014A8         /* TIMER0 Timer n Period Register */
#define REG_TIMER0_TMR3_PER             0xFFC014C8         /* TIMER0 Timer n Period Register */
#define REG_TIMER0_TMR4_PER             0xFFC014E8         /* TIMER0 Timer n Period Register */
#define REG_TIMER0_TMR5_PER             0xFFC01508         /* TIMER0 Timer n Period Register */
#define REG_TIMER0_TMR6_PER             0xFFC01528         /* TIMER0 Timer n Period Register */
#define REG_TIMER0_TMR7_PER             0xFFC01548         /* TIMER0 Timer n Period Register */
#define REG_TIMER0_TMR0_WID             0xFFC0146C         /* TIMER0 Timer n Width Register */
#define REG_TIMER0_TMR1_WID             0xFFC0148C         /* TIMER0 Timer n Width Register */
#define REG_TIMER0_TMR2_WID             0xFFC014AC         /* TIMER0 Timer n Width Register */
#define REG_TIMER0_TMR3_WID             0xFFC014CC         /* TIMER0 Timer n Width Register */
#define REG_TIMER0_TMR4_WID             0xFFC014EC         /* TIMER0 Timer n Width Register */
#define REG_TIMER0_TMR5_WID             0xFFC0150C         /* TIMER0 Timer n Width Register */
#define REG_TIMER0_TMR6_WID             0xFFC0152C         /* TIMER0 Timer n Width Register */
#define REG_TIMER0_TMR7_WID             0xFFC0154C         /* TIMER0 Timer n Width Register */
#define REG_TIMER0_TMR0_DLY             0xFFC01470         /* TIMER0 Timer n Delay Register */
#define REG_TIMER0_TMR1_DLY             0xFFC01490         /* TIMER0 Timer n Delay Register */
#define REG_TIMER0_TMR2_DLY             0xFFC014B0         /* TIMER0 Timer n Delay Register */
#define REG_TIMER0_TMR3_DLY             0xFFC014D0         /* TIMER0 Timer n Delay Register */
#define REG_TIMER0_TMR4_DLY             0xFFC014F0         /* TIMER0 Timer n Delay Register */
#define REG_TIMER0_TMR5_DLY             0xFFC01510         /* TIMER0 Timer n Delay Register */
#define REG_TIMER0_TMR6_DLY             0xFFC01530         /* TIMER0 Timer n Delay Register */
#define REG_TIMER0_TMR7_DLY             0xFFC01550         /* TIMER0 Timer n Delay Register */

/* =========================
        TIMER
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_REVID                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_REVID_MAJOR                4                               /* Major Revision ID */
#define BITP_TIMER_REVID_REV                  0                               /* Incremental Revision ID */
#define BITM_TIMER_REVID_MAJOR               (_ADI_MSK(0x000000F0,uint16_t))  /* Major Revision ID */
#define BITM_TIMER_REVID_REV                 (_ADI_MSK(0x0000000F,uint16_t))  /* Incremental Revision ID */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_RUN                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_RUN_TMR00                  0                               /* Start/Stop Timer n */
#define BITP_TIMER_RUN_TMR01                  1                               /* Start/Stop Timer n */
#define BITP_TIMER_RUN_TMR02                  2                               /* Start/Stop Timer n */
#define BITP_TIMER_RUN_TMR03                  3                               /* Start/Stop Timer n */
#define BITP_TIMER_RUN_TMR04                  4                               /* Start/Stop Timer n */
#define BITP_TIMER_RUN_TMR05                  5                               /* Start/Stop Timer n */
#define BITP_TIMER_RUN_TMR06                  6                               /* Start/Stop Timer n */
#define BITP_TIMER_RUN_TMR07                  7                               /* Start/Stop Timer n */
#define BITM_TIMER_RUN_TMR00                 (_ADI_MSK(0x00000001,uint16_t))  /* Start/Stop Timer n */
#define BITM_TIMER_RUN_TMR01                 (_ADI_MSK(0x00000002,uint16_t))  /* Start/Stop Timer n */
#define BITM_TIMER_RUN_TMR02                 (_ADI_MSK(0x00000004,uint16_t))  /* Start/Stop Timer n */
#define BITM_TIMER_RUN_TMR03                 (_ADI_MSK(0x00000008,uint16_t))  /* Start/Stop Timer n */
#define BITM_TIMER_RUN_TMR04                 (_ADI_MSK(0x00000010,uint16_t))  /* Start/Stop Timer n */
#define BITM_TIMER_RUN_TMR05                 (_ADI_MSK(0x00000020,uint16_t))  /* Start/Stop Timer n */
#define BITM_TIMER_RUN_TMR06                 (_ADI_MSK(0x00000040,uint16_t))  /* Start/Stop Timer n */
#define BITM_TIMER_RUN_TMR07                 (_ADI_MSK(0x00000080,uint16_t))  /* Start/Stop Timer n */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_RUN_SET                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_RUN_SET_TMR00              0                               /* RUN Set Alias */
#define BITP_TIMER_RUN_SET_TMR01              1                               /* RUN Set Alias */
#define BITP_TIMER_RUN_SET_TMR02              2                               /* RUN Set Alias */
#define BITP_TIMER_RUN_SET_TMR03              3                               /* RUN Set Alias */
#define BITP_TIMER_RUN_SET_TMR04              4                               /* RUN Set Alias */
#define BITP_TIMER_RUN_SET_TMR05              5                               /* RUN Set Alias */
#define BITP_TIMER_RUN_SET_TMR06              6                               /* RUN Set Alias */
#define BITP_TIMER_RUN_SET_TMR07              7                               /* RUN Set Alias */
#define BITM_TIMER_RUN_SET_TMR00             (_ADI_MSK(0x00000001,uint16_t))  /* RUN Set Alias */
#define BITM_TIMER_RUN_SET_TMR01             (_ADI_MSK(0x00000002,uint16_t))  /* RUN Set Alias */
#define BITM_TIMER_RUN_SET_TMR02             (_ADI_MSK(0x00000004,uint16_t))  /* RUN Set Alias */
#define BITM_TIMER_RUN_SET_TMR03             (_ADI_MSK(0x00000008,uint16_t))  /* RUN Set Alias */
#define BITM_TIMER_RUN_SET_TMR04             (_ADI_MSK(0x00000010,uint16_t))  /* RUN Set Alias */
#define BITM_TIMER_RUN_SET_TMR05             (_ADI_MSK(0x00000020,uint16_t))  /* RUN Set Alias */
#define BITM_TIMER_RUN_SET_TMR06             (_ADI_MSK(0x00000040,uint16_t))  /* RUN Set Alias */
#define BITM_TIMER_RUN_SET_TMR07             (_ADI_MSK(0x00000080,uint16_t))  /* RUN Set Alias */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_RUN_CLR                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_RUN_CLR_TMR00              0                               /* RUN Clear Alias */
#define BITP_TIMER_RUN_CLR_TMR01              1                               /* RUN Clear Alias */
#define BITP_TIMER_RUN_CLR_TMR02              2                               /* RUN Clear Alias */
#define BITP_TIMER_RUN_CLR_TMR03              3                               /* RUN Clear Alias */
#define BITP_TIMER_RUN_CLR_TMR04              4                               /* RUN Clear Alias */
#define BITP_TIMER_RUN_CLR_TMR05              5                               /* RUN Clear Alias */
#define BITP_TIMER_RUN_CLR_TMR06              6                               /* RUN Clear Alias */
#define BITP_TIMER_RUN_CLR_TMR07              7                               /* RUN Clear Alias */
#define BITM_TIMER_RUN_CLR_TMR00             (_ADI_MSK(0x00000001,uint16_t))  /* RUN Clear Alias */
#define BITM_TIMER_RUN_CLR_TMR01             (_ADI_MSK(0x00000002,uint16_t))  /* RUN Clear Alias */
#define BITM_TIMER_RUN_CLR_TMR02             (_ADI_MSK(0x00000004,uint16_t))  /* RUN Clear Alias */
#define BITM_TIMER_RUN_CLR_TMR03             (_ADI_MSK(0x00000008,uint16_t))  /* RUN Clear Alias */
#define BITM_TIMER_RUN_CLR_TMR04             (_ADI_MSK(0x00000010,uint16_t))  /* RUN Clear Alias */
#define BITM_TIMER_RUN_CLR_TMR05             (_ADI_MSK(0x00000020,uint16_t))  /* RUN Clear Alias */
#define BITM_TIMER_RUN_CLR_TMR06             (_ADI_MSK(0x00000040,uint16_t))  /* RUN Clear Alias */
#define BITM_TIMER_RUN_CLR_TMR07             (_ADI_MSK(0x00000080,uint16_t))  /* RUN Clear Alias */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_STOP_CFG                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_STOP_CFG_TMR00             0                               /* Stop Mode Select */
#define BITP_TIMER_STOP_CFG_TMR01             1                               /* Stop Mode Select */
#define BITP_TIMER_STOP_CFG_TMR02             2                               /* Stop Mode Select */
#define BITP_TIMER_STOP_CFG_TMR03             3                               /* Stop Mode Select */
#define BITP_TIMER_STOP_CFG_TMR04             4                               /* Stop Mode Select */
#define BITP_TIMER_STOP_CFG_TMR05             5                               /* Stop Mode Select */
#define BITP_TIMER_STOP_CFG_TMR06             6                               /* Stop Mode Select */
#define BITP_TIMER_STOP_CFG_TMR07             7                               /* Stop Mode Select */
#define BITM_TIMER_STOP_CFG_TMR00            (_ADI_MSK(0x00000001,uint16_t))  /* Stop Mode Select */
#define BITM_TIMER_STOP_CFG_TMR01            (_ADI_MSK(0x00000002,uint16_t))  /* Stop Mode Select */
#define BITM_TIMER_STOP_CFG_TMR02            (_ADI_MSK(0x00000004,uint16_t))  /* Stop Mode Select */
#define BITM_TIMER_STOP_CFG_TMR03            (_ADI_MSK(0x00000008,uint16_t))  /* Stop Mode Select */
#define BITM_TIMER_STOP_CFG_TMR04            (_ADI_MSK(0x00000010,uint16_t))  /* Stop Mode Select */
#define BITM_TIMER_STOP_CFG_TMR05            (_ADI_MSK(0x00000020,uint16_t))  /* Stop Mode Select */
#define BITM_TIMER_STOP_CFG_TMR06            (_ADI_MSK(0x00000040,uint16_t))  /* Stop Mode Select */
#define BITM_TIMER_STOP_CFG_TMR07            (_ADI_MSK(0x00000080,uint16_t))  /* Stop Mode Select */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_STOP_CFG_SET                   Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_STOP_CFG_SET_TMR00         0                               /* STOP_CFG Set Alias */
#define BITP_TIMER_STOP_CFG_SET_TMR01         1                               /* STOP_CFG Set Alias */
#define BITP_TIMER_STOP_CFG_SET_TMR02         2                               /* STOP_CFG Set Alias */
#define BITP_TIMER_STOP_CFG_SET_TMR03         3                               /* STOP_CFG Set Alias */
#define BITP_TIMER_STOP_CFG_SET_TMR04         4                               /* STOP_CFG Set Alias */
#define BITP_TIMER_STOP_CFG_SET_TMR05         5                               /* STOP_CFG Set Alias */
#define BITP_TIMER_STOP_CFG_SET_TMR06         6                               /* STOP_CFG Set Alias */
#define BITP_TIMER_STOP_CFG_SET_TMR07         7                               /* STOP_CFG Set Alias */
#define BITM_TIMER_STOP_CFG_SET_TMR00        (_ADI_MSK(0x00000001,uint16_t))  /* STOP_CFG Set Alias */
#define BITM_TIMER_STOP_CFG_SET_TMR01        (_ADI_MSK(0x00000002,uint16_t))  /* STOP_CFG Set Alias */
#define BITM_TIMER_STOP_CFG_SET_TMR02        (_ADI_MSK(0x00000004,uint16_t))  /* STOP_CFG Set Alias */
#define BITM_TIMER_STOP_CFG_SET_TMR03        (_ADI_MSK(0x00000008,uint16_t))  /* STOP_CFG Set Alias */
#define BITM_TIMER_STOP_CFG_SET_TMR04        (_ADI_MSK(0x00000010,uint16_t))  /* STOP_CFG Set Alias */
#define BITM_TIMER_STOP_CFG_SET_TMR05        (_ADI_MSK(0x00000020,uint16_t))  /* STOP_CFG Set Alias */
#define BITM_TIMER_STOP_CFG_SET_TMR06        (_ADI_MSK(0x00000040,uint16_t))  /* STOP_CFG Set Alias */
#define BITM_TIMER_STOP_CFG_SET_TMR07        (_ADI_MSK(0x00000080,uint16_t))  /* STOP_CFG Set Alias */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_STOP_CFG_CLR                   Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_STOP_CFG_CLR_TMR00         0                               /* STOP_CFG Clear Alias */
#define BITP_TIMER_STOP_CFG_CLR_TMR01         1                               /* STOP_CFG Clear Alias */
#define BITP_TIMER_STOP_CFG_CLR_TMR02         2                               /* STOP_CFG Clear Alias */
#define BITP_TIMER_STOP_CFG_CLR_TMR03         3                               /* STOP_CFG Clear Alias */
#define BITP_TIMER_STOP_CFG_CLR_TMR04         4                               /* STOP_CFG Clear Alias */
#define BITP_TIMER_STOP_CFG_CLR_TMR05         5                               /* STOP_CFG Clear Alias */
#define BITP_TIMER_STOP_CFG_CLR_TMR06         6                               /* STOP_CFG Clear Alias */
#define BITP_TIMER_STOP_CFG_CLR_TMR07         7                               /* STOP_CFG Clear Alias */
#define BITM_TIMER_STOP_CFG_CLR_TMR00        (_ADI_MSK(0x00000001,uint16_t))  /* STOP_CFG Clear Alias */
#define BITM_TIMER_STOP_CFG_CLR_TMR01        (_ADI_MSK(0x00000002,uint16_t))  /* STOP_CFG Clear Alias */
#define BITM_TIMER_STOP_CFG_CLR_TMR02        (_ADI_MSK(0x00000004,uint16_t))  /* STOP_CFG Clear Alias */
#define BITM_TIMER_STOP_CFG_CLR_TMR03        (_ADI_MSK(0x00000008,uint16_t))  /* STOP_CFG Clear Alias */
#define BITM_TIMER_STOP_CFG_CLR_TMR04        (_ADI_MSK(0x00000010,uint16_t))  /* STOP_CFG Clear Alias */
#define BITM_TIMER_STOP_CFG_CLR_TMR05        (_ADI_MSK(0x00000020,uint16_t))  /* STOP_CFG Clear Alias */
#define BITM_TIMER_STOP_CFG_CLR_TMR06        (_ADI_MSK(0x00000040,uint16_t))  /* STOP_CFG Clear Alias */
#define BITM_TIMER_STOP_CFG_CLR_TMR07        (_ADI_MSK(0x00000080,uint16_t))  /* STOP_CFG Clear Alias */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_DATA_IMSK                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_DATA_IMSK_TMR00            0                               /* Data Interrupt Mask */
#define BITP_TIMER_DATA_IMSK_TMR01            1                               /* Data Interrupt Mask */
#define BITP_TIMER_DATA_IMSK_TMR02            2                               /* Data Interrupt Mask */
#define BITP_TIMER_DATA_IMSK_TMR03            3                               /* Data Interrupt Mask */
#define BITP_TIMER_DATA_IMSK_TMR04            4                               /* Data Interrupt Mask */
#define BITP_TIMER_DATA_IMSK_TMR05            5                               /* Data Interrupt Mask */
#define BITP_TIMER_DATA_IMSK_TMR06            6                               /* Data Interrupt Mask */
#define BITP_TIMER_DATA_IMSK_TMR07            7                               /* Data Interrupt Mask */
#define BITM_TIMER_DATA_IMSK_TMR00           (_ADI_MSK(0x00000001,uint16_t))  /* Data Interrupt Mask */
#define BITM_TIMER_DATA_IMSK_TMR01           (_ADI_MSK(0x00000002,uint16_t))  /* Data Interrupt Mask */
#define BITM_TIMER_DATA_IMSK_TMR02           (_ADI_MSK(0x00000004,uint16_t))  /* Data Interrupt Mask */
#define BITM_TIMER_DATA_IMSK_TMR03           (_ADI_MSK(0x00000008,uint16_t))  /* Data Interrupt Mask */
#define BITM_TIMER_DATA_IMSK_TMR04           (_ADI_MSK(0x00000010,uint16_t))  /* Data Interrupt Mask */
#define BITM_TIMER_DATA_IMSK_TMR05           (_ADI_MSK(0x00000020,uint16_t))  /* Data Interrupt Mask */
#define BITM_TIMER_DATA_IMSK_TMR06           (_ADI_MSK(0x00000040,uint16_t))  /* Data Interrupt Mask */
#define BITM_TIMER_DATA_IMSK_TMR07           (_ADI_MSK(0x00000080,uint16_t))  /* Data Interrupt Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_STAT_IMSK                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_STAT_IMSK_TMR00            0                               /* Status Interrupt Mask */
#define BITP_TIMER_STAT_IMSK_TMR01            1                               /* Status Interrupt Mask */
#define BITP_TIMER_STAT_IMSK_TMR02            2                               /* Status Interrupt Mask */
#define BITP_TIMER_STAT_IMSK_TMR03            3                               /* Status Interrupt Mask */
#define BITP_TIMER_STAT_IMSK_TMR04            4                               /* Status Interrupt Mask */
#define BITP_TIMER_STAT_IMSK_TMR05            5                               /* Status Interrupt Mask */
#define BITP_TIMER_STAT_IMSK_TMR06            6                               /* Status Interrupt Mask */
#define BITP_TIMER_STAT_IMSK_TMR07            7                               /* Status Interrupt Mask */
#define BITM_TIMER_STAT_IMSK_TMR00           (_ADI_MSK(0x00000001,uint16_t))  /* Status Interrupt Mask */
#define BITM_TIMER_STAT_IMSK_TMR01           (_ADI_MSK(0x00000002,uint16_t))  /* Status Interrupt Mask */
#define BITM_TIMER_STAT_IMSK_TMR02           (_ADI_MSK(0x00000004,uint16_t))  /* Status Interrupt Mask */
#define BITM_TIMER_STAT_IMSK_TMR03           (_ADI_MSK(0x00000008,uint16_t))  /* Status Interrupt Mask */
#define BITM_TIMER_STAT_IMSK_TMR04           (_ADI_MSK(0x00000010,uint16_t))  /* Status Interrupt Mask */
#define BITM_TIMER_STAT_IMSK_TMR05           (_ADI_MSK(0x00000020,uint16_t))  /* Status Interrupt Mask */
#define BITM_TIMER_STAT_IMSK_TMR06           (_ADI_MSK(0x00000040,uint16_t))  /* Status Interrupt Mask */
#define BITM_TIMER_STAT_IMSK_TMR07           (_ADI_MSK(0x00000080,uint16_t))  /* Status Interrupt Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_TRG_MSK                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_TRG_MSK_TMR00              0                               /* Trigger Output Mask */
#define BITP_TIMER_TRG_MSK_TMR01              1                               /* Trigger Output Mask */
#define BITP_TIMER_TRG_MSK_TMR02              2                               /* Trigger Output Mask */
#define BITP_TIMER_TRG_MSK_TMR03              3                               /* Trigger Output Mask */
#define BITP_TIMER_TRG_MSK_TMR04              4                               /* Trigger Output Mask */
#define BITP_TIMER_TRG_MSK_TMR05              5                               /* Trigger Output Mask */
#define BITP_TIMER_TRG_MSK_TMR06              6                               /* Trigger Output Mask */
#define BITP_TIMER_TRG_MSK_TMR07              7                               /* Trigger Output Mask */
#define BITM_TIMER_TRG_MSK_TMR00             (_ADI_MSK(0x00000001,uint16_t))  /* Trigger Output Mask */
#define BITM_TIMER_TRG_MSK_TMR01             (_ADI_MSK(0x00000002,uint16_t))  /* Trigger Output Mask */
#define BITM_TIMER_TRG_MSK_TMR02             (_ADI_MSK(0x00000004,uint16_t))  /* Trigger Output Mask */
#define BITM_TIMER_TRG_MSK_TMR03             (_ADI_MSK(0x00000008,uint16_t))  /* Trigger Output Mask */
#define BITM_TIMER_TRG_MSK_TMR04             (_ADI_MSK(0x00000010,uint16_t))  /* Trigger Output Mask */
#define BITM_TIMER_TRG_MSK_TMR05             (_ADI_MSK(0x00000020,uint16_t))  /* Trigger Output Mask */
#define BITM_TIMER_TRG_MSK_TMR06             (_ADI_MSK(0x00000040,uint16_t))  /* Trigger Output Mask */
#define BITM_TIMER_TRG_MSK_TMR07             (_ADI_MSK(0x00000080,uint16_t))  /* Trigger Output Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_TRG_IE                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_TRG_IE_TMR00               0                               /* Trigger Input Enable */
#define BITP_TIMER_TRG_IE_TMR01               1                               /* Trigger Input Enable */
#define BITP_TIMER_TRG_IE_TMR02               2                               /* Trigger Input Enable */
#define BITP_TIMER_TRG_IE_TMR03               3                               /* Trigger Input Enable */
#define BITP_TIMER_TRG_IE_TMR04               4                               /* Trigger Input Enable */
#define BITP_TIMER_TRG_IE_TMR05               5                               /* Trigger Input Enable */
#define BITP_TIMER_TRG_IE_TMR06               6                               /* Trigger Input Enable */
#define BITP_TIMER_TRG_IE_TMR07               7                               /* Trigger Input Enable */
#define BITM_TIMER_TRG_IE_TMR00              (_ADI_MSK(0x00000001,uint16_t))  /* Trigger Input Enable */
#define BITM_TIMER_TRG_IE_TMR01              (_ADI_MSK(0x00000002,uint16_t))  /* Trigger Input Enable */
#define BITM_TIMER_TRG_IE_TMR02              (_ADI_MSK(0x00000004,uint16_t))  /* Trigger Input Enable */
#define BITM_TIMER_TRG_IE_TMR03              (_ADI_MSK(0x00000008,uint16_t))  /* Trigger Input Enable */
#define BITM_TIMER_TRG_IE_TMR04              (_ADI_MSK(0x00000010,uint16_t))  /* Trigger Input Enable */
#define BITM_TIMER_TRG_IE_TMR05              (_ADI_MSK(0x00000020,uint16_t))  /* Trigger Input Enable */
#define BITM_TIMER_TRG_IE_TMR06              (_ADI_MSK(0x00000040,uint16_t))  /* Trigger Input Enable */
#define BITM_TIMER_TRG_IE_TMR07              (_ADI_MSK(0x00000080,uint16_t))  /* Trigger Input Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_DATA_ILAT                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_DATA_ILAT_TMR00            0                               /* Data Interrupt Latch */
#define BITP_TIMER_DATA_ILAT_TMR01            1                               /* Data Interrupt Latch */
#define BITP_TIMER_DATA_ILAT_TMR02            2                               /* Data Interrupt Latch */
#define BITP_TIMER_DATA_ILAT_TMR03            3                               /* Data Interrupt Latch */
#define BITP_TIMER_DATA_ILAT_TMR04            4                               /* Data Interrupt Latch */
#define BITP_TIMER_DATA_ILAT_TMR05            5                               /* Data Interrupt Latch */
#define BITP_TIMER_DATA_ILAT_TMR06            6                               /* Data Interrupt Latch */
#define BITP_TIMER_DATA_ILAT_TMR07            7                               /* Data Interrupt Latch */
#define BITM_TIMER_DATA_ILAT_TMR00           (_ADI_MSK(0x00000001,uint16_t))  /* Data Interrupt Latch */
#define BITM_TIMER_DATA_ILAT_TMR01           (_ADI_MSK(0x00000002,uint16_t))  /* Data Interrupt Latch */
#define BITM_TIMER_DATA_ILAT_TMR02           (_ADI_MSK(0x00000004,uint16_t))  /* Data Interrupt Latch */
#define BITM_TIMER_DATA_ILAT_TMR03           (_ADI_MSK(0x00000008,uint16_t))  /* Data Interrupt Latch */
#define BITM_TIMER_DATA_ILAT_TMR04           (_ADI_MSK(0x00000010,uint16_t))  /* Data Interrupt Latch */
#define BITM_TIMER_DATA_ILAT_TMR05           (_ADI_MSK(0x00000020,uint16_t))  /* Data Interrupt Latch */
#define BITM_TIMER_DATA_ILAT_TMR06           (_ADI_MSK(0x00000040,uint16_t))  /* Data Interrupt Latch */
#define BITM_TIMER_DATA_ILAT_TMR07           (_ADI_MSK(0x00000080,uint16_t))  /* Data Interrupt Latch */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_STAT_ILAT                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_STAT_ILAT_TMR00            0                               /* Status Interrupt Latch */
#define BITP_TIMER_STAT_ILAT_TMR01            1                               /* Status Interrupt Latch */
#define BITP_TIMER_STAT_ILAT_TMR02            2                               /* Status Interrupt Latch */
#define BITP_TIMER_STAT_ILAT_TMR03            3                               /* Status Interrupt Latch */
#define BITP_TIMER_STAT_ILAT_TMR04            4                               /* Status Interrupt Latch */
#define BITP_TIMER_STAT_ILAT_TMR05            5                               /* Status Interrupt Latch */
#define BITP_TIMER_STAT_ILAT_TMR06            6                               /* Status Interrupt Latch */
#define BITP_TIMER_STAT_ILAT_TMR07            7                               /* Status Interrupt Latch */
#define BITM_TIMER_STAT_ILAT_TMR00           (_ADI_MSK(0x00000001,uint16_t))  /* Status Interrupt Latch */
#define BITM_TIMER_STAT_ILAT_TMR01           (_ADI_MSK(0x00000002,uint16_t))  /* Status Interrupt Latch */
#define BITM_TIMER_STAT_ILAT_TMR02           (_ADI_MSK(0x00000004,uint16_t))  /* Status Interrupt Latch */
#define BITM_TIMER_STAT_ILAT_TMR03           (_ADI_MSK(0x00000008,uint16_t))  /* Status Interrupt Latch */
#define BITM_TIMER_STAT_ILAT_TMR04           (_ADI_MSK(0x00000010,uint16_t))  /* Status Interrupt Latch */
#define BITM_TIMER_STAT_ILAT_TMR05           (_ADI_MSK(0x00000020,uint16_t))  /* Status Interrupt Latch */
#define BITM_TIMER_STAT_ILAT_TMR06           (_ADI_MSK(0x00000040,uint16_t))  /* Status Interrupt Latch */
#define BITM_TIMER_STAT_ILAT_TMR07           (_ADI_MSK(0x00000080,uint16_t))  /* Status Interrupt Latch */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_ERR_TYPE                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_ERR_TYPE_TERR7            14                               /* Error type for Timer 7 */
#define BITP_TIMER_ERR_TYPE_TERR6            12                               /* Error type for Timer 6 */
#define BITP_TIMER_ERR_TYPE_TERR5            10                               /* Error type for Timer 5 */
#define BITP_TIMER_ERR_TYPE_TERR4             8                               /* Error type for Timer 4 */
#define BITP_TIMER_ERR_TYPE_TERR3             6                               /* Error type for Timer 3 */
#define BITP_TIMER_ERR_TYPE_TERR2             4                               /* Error type for Timer 2 */
#define BITP_TIMER_ERR_TYPE_TERR1             2                               /* Error type for Timer 1 */
#define BITP_TIMER_ERR_TYPE_TERR0             0                               /* Error type for Timer 0 */

#define BITM_TIMER_ERR_TYPE_TERR7            (_ADI_MSK(0x0000C000,uint32_t))  /* Error type for Timer 7 */
#define ENUM_TIMER_ERR_TYPE_NO_ERR7          (_ADI_MSK(0x00000000,uint32_t))  /* TERR7: No Error */
#define ENUM_TIMER_ERR_TYPE_CNTOVF7          (_ADI_MSK(0x00004000,uint32_t))  /* TERR7: Counter Overflow Error */
#define ENUM_TIMER_ERR_TYPE_PERPRG7          (_ADI_MSK(0x00008000,uint32_t))  /* TERR7: PER Register Programming Error */
#define ENUM_TIMER_ERR_TYPE_PULSEPRG7        (_ADI_MSK(0x0000C000,uint32_t))  /* TERR7: WID or DLY Register Programming Error */

#define BITM_TIMER_ERR_TYPE_TERR6            (_ADI_MSK(0x00003000,uint32_t))  /* Error type for Timer 6 */
#define ENUM_TIMER_ERR_TYPE_NO_ERR6          (_ADI_MSK(0x00000000,uint32_t))  /* TERR6: No Error */
#define ENUM_TIMER_ERR_TYPE_CNTOVF6          (_ADI_MSK(0x00001000,uint32_t))  /* TERR6: Counter Overflow Error */
#define ENUM_TIMER_ERR_TYPE_PERPRG6          (_ADI_MSK(0x00002000,uint32_t))  /* TERR6: PER Register Programming Error */
#define ENUM_TIMER_ERR_TYPE_PULSEPRG6        (_ADI_MSK(0x00003000,uint32_t))  /* TERR6: WID or DLY Register Programming Error */

#define BITM_TIMER_ERR_TYPE_TERR5            (_ADI_MSK(0x00000C00,uint32_t))  /* Error type for Timer 5 */
#define ENUM_TIMER_ERR_TYPE_NO_ERR5          (_ADI_MSK(0x00000000,uint32_t))  /* TERR5: No Error */
#define ENUM_TIMER_ERR_TYPE_CNTOVF5          (_ADI_MSK(0x00000400,uint32_t))  /* TERR5: Counter Overflow Error */
#define ENUM_TIMER_ERR_TYPE_PERPRG5          (_ADI_MSK(0x00000800,uint32_t))  /* TERR5: PER Register Programming Error */
#define ENUM_TIMER_ERR_TYPE_PULSEPRG5        (_ADI_MSK(0x00000C00,uint32_t))  /* TERR5: WID or DLY Register Programming Error */

#define BITM_TIMER_ERR_TYPE_TERR4            (_ADI_MSK(0x00000300,uint32_t))  /* Error type for Timer 4 */
#define ENUM_TIMER_ERR_TYPE_NO_ERR4          (_ADI_MSK(0x00000000,uint32_t))  /* TERR4: No Error */
#define ENUM_TIMER_ERR_TYPE_CNTOVF4          (_ADI_MSK(0x00000100,uint32_t))  /* TERR4: Counter Overflow Error */
#define ENUM_TIMER_ERR_TYPE_PERPRG4          (_ADI_MSK(0x00000200,uint32_t))  /* TERR4: PER Register Programming Error */
#define ENUM_TIMER_ERR_TYPE_PULSEPRG4        (_ADI_MSK(0x00000300,uint32_t))  /* TERR4: WID or DLY Register Programming Error */

#define BITM_TIMER_ERR_TYPE_TERR3            (_ADI_MSK(0x000000C0,uint32_t))  /* Error type for Timer 3 */
#define ENUM_TIMER_ERR_TYPE_NO_ERR3          (_ADI_MSK(0x00000000,uint32_t))  /* TERR3: No Error */
#define ENUM_TIMER_ERR_TYPE_CNTOVF3          (_ADI_MSK(0x00000040,uint32_t))  /* TERR3: Counter Overflow Error */
#define ENUM_TIMER_ERR_TYPE_PERPRG3          (_ADI_MSK(0x00000080,uint32_t))  /* TERR3: PER Register Programming Error */
#define ENUM_TIMER_ERR_TYPE_PULSEPRG3        (_ADI_MSK(0x000000C0,uint32_t))  /* TERR3: WID or DLY Register Programming Error */

#define BITM_TIMER_ERR_TYPE_TERR2            (_ADI_MSK(0x00000030,uint32_t))  /* Error type for Timer 2 */
#define ENUM_TIMER_ERR_TYPE_NO_ERR2          (_ADI_MSK(0x00000000,uint32_t))  /* TERR2: No Error */
#define ENUM_TIMER_ERR_TYPE_CNTOVF2          (_ADI_MSK(0x00000010,uint32_t))  /* TERR2: Counter Overflow Error */
#define ENUM_TIMER_ERR_TYPE_PERPRG2          (_ADI_MSK(0x00000020,uint32_t))  /* TERR2: PER Register Programming Error */
#define ENUM_TIMER_ERR_TYPE_PULSEPRG2        (_ADI_MSK(0x00000030,uint32_t))  /* TERR2: WID or DLY Register Programming Error */

#define BITM_TIMER_ERR_TYPE_TERR1            (_ADI_MSK(0x0000000C,uint32_t))  /* Error type for Timer 1 */
#define ENUM_TIMER_ERR_TYPE_NO_ERR1          (_ADI_MSK(0x00000000,uint32_t))  /* TERR1: No Error */
#define ENUM_TIMER_ERR_TYPE_CNTOVF1          (_ADI_MSK(0x00000004,uint32_t))  /* TERR1: Counter Overflow Error */
#define ENUM_TIMER_ERR_TYPE_PERPRG1          (_ADI_MSK(0x00000008,uint32_t))  /* TERR1: PER Register Programming Error */
#define ENUM_TIMER_ERR_TYPE_PULSEPRG1        (_ADI_MSK(0x0000000C,uint32_t))  /* TERR1: WID or DLY Register Programming Error */

#define BITM_TIMER_ERR_TYPE_TERR0            (_ADI_MSK(0x00000003,uint32_t))  /* Error type for Timer 0 */
#define ENUM_TIMER_ERR_TYPE_NO_ERR0          (_ADI_MSK(0x00000000,uint32_t))  /* TERR0: No Error */
#define ENUM_TIMER_ERR_TYPE_CNTOVF0          (_ADI_MSK(0x00000001,uint32_t))  /* TERR0: Counter Overflow Error */
#define ENUM_TIMER_ERR_TYPE_PERPRG0          (_ADI_MSK(0x00000002,uint32_t))  /* TERR0: PER Register Programming Error */
#define ENUM_TIMER_ERR_TYPE_PULSEPRG0        (_ADI_MSK(0x00000003,uint32_t))  /* TERR0: WID or DLY Register Programming Error */

/* ------------------------------------------------------------------------------------------------------------------------
        TIMER_TMR_CFG                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TIMER_TMR_CFG_EMURUN            15                               /* Run Timer (Counter) During Emulation */
#define BITP_TIMER_TMR_CFG_BPEREN            14                               /* Broadcast Period Enable */
#define BITP_TIMER_TMR_CFG_BWIDEN            13                               /* Broadcast Width Enable */
#define BITP_TIMER_TMR_CFG_BDLYEN            12                               /* Broadcast Delay Enable */
#define BITP_TIMER_TMR_CFG_OUTDIS            11                               /* Output Disable */
#define BITP_TIMER_TMR_CFG_TINSEL            10                               /* Timer Input Select (for WIDCAP, WATCHDOG, PININT modes) */
#define BITP_TIMER_TMR_CFG_CLKSEL             8                               /* Clock Select */
#define BITP_TIMER_TMR_CFG_PULSEHI            7                               /* Polarity Response Select */
#define BITP_TIMER_TMR_CFG_SLAVETRIG          6                               /* Slave Trigger Response */
#define BITP_TIMER_TMR_CFG_IRQMODE            4                               /* Interrupt Modes */
#define BITP_TIMER_TMR_CFG_TMODE              0                               /* Timer Mode Select */

#define BITM_TIMER_TMR_CFG_EMURUN            (_ADI_MSK(0x00008000,uint16_t))  /* Run Timer (Counter) During Emulation */
#define ENUM_TIMER_TMR_CFG_EMU_NOCNT         (_ADI_MSK(0x00000000,uint16_t))  /* EMURUN: Stop Timer During Emulation */
#define ENUM_TIMER_TMR_CFG_EMU_CNT           (_ADI_MSK(0x00008000,uint16_t))  /* EMURUN: Run Timer During Emulation */

#define BITM_TIMER_TMR_CFG_BPEREN            (_ADI_MSK(0x00004000,uint16_t))  /* Broadcast Period Enable */
#define ENUM_TIMER_TMR_CFG_BCASTPER_DIS      (_ADI_MSK(0x00000000,uint16_t))  /* BPEREN: Disable Broadcast to PER Register */
#define ENUM_TIMER_TMR_CFG_BCASTPER_EN       (_ADI_MSK(0x00004000,uint16_t))  /* BPEREN: Enable Broadcast to PER Register */

#define BITM_TIMER_TMR_CFG_BWIDEN            (_ADI_MSK(0x00002000,uint16_t))  /* Broadcast Width Enable */
#define ENUM_TIMER_TMR_CFG_BCASTWID_DIS      (_ADI_MSK(0x00000000,uint16_t))  /* BWIDEN: Disable Broadcast to WID Register */
#define ENUM_TIMER_TMR_CFG_BCASTWID_EN       (_ADI_MSK(0x00002000,uint16_t))  /* BWIDEN: Enable Broadcast to WID Register */

#define BITM_TIMER_TMR_CFG_BDLYEN            (_ADI_MSK(0x00001000,uint16_t))  /* Broadcast Delay Enable */
#define ENUM_TIMER_TMR_CFG_BCASTDLY_DIS      (_ADI_MSK(0x00000000,uint16_t))  /* BDLYEN: Disable Broadcast to DLY Register */
#define ENUM_TIMER_TMR_CFG_BCASTDLY_EN       (_ADI_MSK(0x00001000,uint16_t))  /* BDLYEN: Enable Broadcast to DLY Register */

#define BITM_TIMER_TMR_CFG_OUTDIS            (_ADI_MSK(0x00000800,uint16_t))  /* Output Disable */
#define ENUM_TIMER_TMR_CFG_PADOUT_EN         (_ADI_MSK(0x00000000,uint16_t))  /* OUTDIS: Enable TMR pin output buffer */
#define ENUM_TIMER_TMR_CFG_PADOUT_DIS        (_ADI_MSK(0x00000800,uint16_t))  /* OUTDIS: Disable TMR pin output buffer */

#define BITM_TIMER_TMR_CFG_TINSEL            (_ADI_MSK(0x00000400,uint16_t))  /* Timer Input Select (for WIDCAP, WATCHDOG, PININT modes) */
#define ENUM_TIMER_TMR_CFG_TINSEL_TMR        (_ADI_MSK(0x00000000,uint16_t))  /* TINSEL: Use TMR pin input */
#define ENUM_TIMER_TMR_CFG_TINSEL_AUX        (_ADI_MSK(0x00000400,uint16_t))  /* TINSEL: Use TMR Alternate Capture Input */

#define BITM_TIMER_TMR_CFG_CLKSEL            (_ADI_MSK(0x00000300,uint16_t))  /* Clock Select */
#define ENUM_TIMER_TMR_CFG_CLKSEL_SCLK       (_ADI_MSK(0x00000000,uint16_t))  /* CLKSEL: Use SCLK */
#define ENUM_TIMER_TMR_CFG_CLKSEL_ALT0       (_ADI_MSK(0x00000100,uint16_t))  /* CLKSEL: Use TMR_ALT_CLK0 as the TMR clock */
#define ENUM_TIMER_TMR_CFG_CLKSEL_ALT1       (_ADI_MSK(0x00000300,uint16_t))  /* CLKSEL: Use TMR_ALT_CLK1 as the TMR clock */

#define BITM_TIMER_TMR_CFG_PULSEHI           (_ADI_MSK(0x00000080,uint16_t))  /* Polarity Response Select */
#define ENUM_TIMER_TMR_CFG_NEG_EDGE          (_ADI_MSK(0x00000000,uint16_t))  /* PULSEHI: Negative Response/Pulse */
#define ENUM_TIMER_TMR_CFG_POS_EDGE          (_ADI_MSK(0x00000080,uint16_t))  /* PULSEHI: Positive  Response/Pulse */

#define BITM_TIMER_TMR_CFG_SLAVETRIG         (_ADI_MSK(0x00000040,uint16_t))  /* Slave Trigger Response */
#define ENUM_TIMER_TMR_CFG_TRIGSTOP          (_ADI_MSK(0x00000000,uint16_t))  /* SLAVETRIG: Pulse stops timer if it is running */
#define ENUM_TIMER_TMR_CFG_TRIGSTART         (_ADI_MSK(0x00000040,uint16_t))  /* SLAVETRIG: Pulse starts timer if it is stopped */

#define BITM_TIMER_TMR_CFG_IRQMODE           (_ADI_MSK(0x00000030,uint16_t))  /* Interrupt Modes */
#define ENUM_TIMER_TMR_CFG_IRQMODE0          (_ADI_MSK(0x00000000,uint16_t))  /* IRQMODE: Active Edge Mode */
#define ENUM_TIMER_TMR_CFG_IRQMODE1          (_ADI_MSK(0x00000010,uint16_t))  /* IRQMODE: Delay Expired Mode */
#define ENUM_TIMER_TMR_CFG_IRQMODE2          (_ADI_MSK(0x00000020,uint16_t))  /* IRQMODE: Width Plus Delay Expired Mode */
#define ENUM_TIMER_TMR_CFG_IRQMODE3          (_ADI_MSK(0x00000030,uint16_t))  /* IRQMODE: Period Expired Mode */

#define BITM_TIMER_TMR_CFG_TMODE             (_ADI_MSK(0x0000000F,uint16_t))  /* Timer Mode Select */
#define ENUM_TIMER_TMR_CFG_IDLE_MODE         (_ADI_MSK(0x00000000,uint16_t))  /* TMODE: Idle Mode */
#define ENUM_TIMER_TMR_CFG_WIDCAP0_MODE      (_ADI_MSK(0x0000000A,uint16_t))  /* TMODE: Width Capture Asserted Mode */
#define ENUM_TIMER_TMR_CFG_WIDCAP1_MODE      (_ADI_MSK(0x0000000B,uint16_t))  /* TMODE: Width Capture Deasserted Mode */
#define ENUM_TIMER_TMR_CFG_PWMCONT_MODE      (_ADI_MSK(0x0000000C,uint16_t))  /* TMODE: Continuous PWMOUT mode */
#define ENUM_TIMER_TMR_CFG_PWMSING_MODE      (_ADI_MSK(0x0000000D,uint16_t))  /* TMODE: Single pulse PWMOUT mode */
#define ENUM_TIMER_TMR_CFG_EXTCLK_MODE       (_ADI_MSK(0x0000000E,uint16_t))  /* TMODE: EXTCLK mode */
#define ENUM_TIMER_TMR_CFG_PININT_MODE       (_ADI_MSK(0x0000000F,uint16_t))  /* TMODE: PININT (pin interrupt) mode */
#define ENUM_TIMER_TMR_CFG_WDPER_MODE        (_ADI_MSK(0x00000008,uint16_t))  /* TMODE: Period Watchdog Mode */
#define ENUM_TIMER_TMR_CFG_WDWID_MODE        (_ADI_MSK(0x00000009,uint16_t))  /* TMODE: Width Watchdog Mode */

/* ==================================================
        Cyclic Redundancy Check Unit Registers
   ================================================== */

/* =========================
        CRC0
   ========================= */
#define REG_CRC0_CTL                    0xFFC01C00         /* CRC0 Control Register */
#define REG_CRC0_DCNT                   0xFFC01C04         /* CRC0 Data Word Count Register */
#define REG_CRC0_DCNTRLD                0xFFC01C08         /* CRC0 Data Word Count Reload Register */
#define REG_CRC0_COMP                   0xFFC01C14         /* CRC0 Data Compare Register */
#define REG_CRC0_FILLVAL                0xFFC01C18         /* CRC0 Fill Value Register */
#define REG_CRC0_DFIFO                  0xFFC01C1C         /* CRC0 Data FIFO Register */
#define REG_CRC0_INEN                   0xFFC01C20         /* CRC0 Interrupt Enable Register */
#define REG_CRC0_INEN_SET               0xFFC01C24         /* CRC0 Interrupt Enable Set Register */
#define REG_CRC0_INEN_CLR               0xFFC01C28         /* CRC0 Interrupt Enable Clear Register */
#define REG_CRC0_POLY                   0xFFC01C2C         /* CRC0 Polynomial Register */
#define REG_CRC0_STAT                   0xFFC01C40         /* CRC0 Status Register */
#define REG_CRC0_DCNTCAP                0xFFC01C44         /* CRC0 Data Count Capture Register */
#define REG_CRC0_RESULT_FIN             0xFFC01C4C         /* CRC0 CRC Final Result Register */
#define REG_CRC0_RESULT_CUR             0xFFC01C50         /* CRC0 CRC Current Result Register */
#define REG_CRC0_REVID                  0xFFC01C60         /* CRC0 Revision ID Register */

/* =========================
        CRC1
   ========================= */
#define REG_CRC1_CTL                    0xFFC01D00         /* CRC1 Control Register */
#define REG_CRC1_DCNT                   0xFFC01D04         /* CRC1 Data Word Count Register */
#define REG_CRC1_DCNTRLD                0xFFC01D08         /* CRC1 Data Word Count Reload Register */
#define REG_CRC1_COMP                   0xFFC01D14         /* CRC1 Data Compare Register */
#define REG_CRC1_FILLVAL                0xFFC01D18         /* CRC1 Fill Value Register */
#define REG_CRC1_DFIFO                  0xFFC01D1C         /* CRC1 Data FIFO Register */
#define REG_CRC1_INEN                   0xFFC01D20         /* CRC1 Interrupt Enable Register */
#define REG_CRC1_INEN_SET               0xFFC01D24         /* CRC1 Interrupt Enable Set Register */
#define REG_CRC1_INEN_CLR               0xFFC01D28         /* CRC1 Interrupt Enable Clear Register */
#define REG_CRC1_POLY                   0xFFC01D2C         /* CRC1 Polynomial Register */
#define REG_CRC1_STAT                   0xFFC01D40         /* CRC1 Status Register */
#define REG_CRC1_DCNTCAP                0xFFC01D44         /* CRC1 Data Count Capture Register */
#define REG_CRC1_RESULT_FIN             0xFFC01D4C         /* CRC1 CRC Final Result Register */
#define REG_CRC1_RESULT_CUR             0xFFC01D50         /* CRC1 CRC Current Result Register */
#define REG_CRC1_REVID                  0xFFC01D60         /* CRC1 Revision ID Register */

/* =========================
        CRC
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        CRC_CTL                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CRC_CTL_CMPMIRR                 22                               /* COMPARE Register Mirroring */
#define BITP_CRC_CTL_POLYMIRR                21                               /* Polynomial Register Mirroring */
#define BITP_CRC_CTL_RSLTMIRR                20                               /* Result Register Mirroring */
#define BITP_CRC_CTL_FDSEL                   19                               /* FIFO Data Select */
#define BITP_CRC_CTL_W16SWP                  18                               /* Word16 Swapping */
#define BITP_CRC_CTL_BYTMIRR                 17                               /* Byte Mirroring */
#define BITP_CRC_CTL_BITMIRR                 16                               /* Bit Mirroring */
#define BITP_CRC_CTL_IRRSTALL                13                               /* Intermediate Result Ready Stall */
#define BITP_CRC_CTL_OBRSTALL                12                               /* Output Buffer Ready Stall */
#define BITP_CRC_CTL_AUTOCLRF                 9                               /* Auto Clear to One */
#define BITP_CRC_CTL_AUTOCLRZ                 8                               /* Auto Clear to Zero */
#define BITP_CRC_CTL_OPMODE                   4                               /* Operation Mode */
#define BITP_CRC_CTL_BLKEN                    0                               /* Block Enable */
#define BITM_CRC_CTL_CMPMIRR                 (_ADI_MSK(0x00400000,uint32_t))  /* COMPARE Register Mirroring */
#define BITM_CRC_CTL_POLYMIRR                (_ADI_MSK(0x00200000,uint32_t))  /* Polynomial Register Mirroring */
#define BITM_CRC_CTL_RSLTMIRR                (_ADI_MSK(0x00100000,uint32_t))  /* Result Register Mirroring */
#define BITM_CRC_CTL_FDSEL                   (_ADI_MSK(0x00080000,uint32_t))  /* FIFO Data Select */
#define BITM_CRC_CTL_W16SWP                  (_ADI_MSK(0x00040000,uint32_t))  /* Word16 Swapping */
#define BITM_CRC_CTL_BYTMIRR                 (_ADI_MSK(0x00020000,uint32_t))  /* Byte Mirroring */
#define BITM_CRC_CTL_BITMIRR                 (_ADI_MSK(0x00010000,uint32_t))  /* Bit Mirroring */
#define BITM_CRC_CTL_IRRSTALL                (_ADI_MSK(0x00002000,uint32_t))  /* Intermediate Result Ready Stall */
#define BITM_CRC_CTL_OBRSTALL                (_ADI_MSK(0x00001000,uint32_t))  /* Output Buffer Ready Stall */
#define BITM_CRC_CTL_AUTOCLRF                (_ADI_MSK(0x00000200,uint32_t))  /* Auto Clear to One */
#define BITM_CRC_CTL_AUTOCLRZ                (_ADI_MSK(0x00000100,uint32_t))  /* Auto Clear to Zero */
#define BITM_CRC_CTL_OPMODE                  (_ADI_MSK(0x000000F0,uint32_t))  /* Operation Mode */
#define BITM_CRC_CTL_BLKEN                   (_ADI_MSK(0x00000001,uint32_t))  /* Block Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        CRC_INEN                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CRC_INEN_DCNTEXP                 4                               /* Data Count Expired (Status) Interrupt Enable */
#define BITP_CRC_INEN_CMPERR                  1                               /* Compare Error Interrupt Enable */

#define BITM_CRC_INEN_DCNTEXP                (_ADI_MSK(0x00000010,uint32_t))  /* Data Count Expired (Status) Interrupt Enable */
#define ENUM_CRC_INEN_DCNTEXP_MSK            (_ADI_MSK(0x00000000,uint32_t))  /* DCNTEXP: Disable (mask) interrupt */
#define ENUM_CRC_INEN_DCNTEXP_UMSK           (_ADI_MSK(0x00000010,uint32_t))  /* DCNTEXP: Enable (unmask) interrupt */

#define BITM_CRC_INEN_CMPERR                 (_ADI_MSK(0x00000002,uint32_t))  /* Compare Error Interrupt Enable */
#define ENUM_CRC_INEN_CMPERR_MSK             (_ADI_MSK(0x00000000,uint32_t))  /* CMPERR: Disable (mask) interrupt */
#define ENUM_CRC_INEN_CMPERR_UMSK            (_ADI_MSK(0x00000002,uint32_t))  /* CMPERR: Enable (unmask) interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        CRC_INEN_SET                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CRC_INEN_SET_DCNTEXP             4                               /* Data Count Expired (Status) Interrupt Enable Set */
#define BITP_CRC_INEN_SET_CMPERR              1                               /* Compare Error Interrupt Enable Set */
#define BITM_CRC_INEN_SET_DCNTEXP            (_ADI_MSK(0x00000010,uint32_t))  /* Data Count Expired (Status) Interrupt Enable Set */
#define BITM_CRC_INEN_SET_CMPERR             (_ADI_MSK(0x00000002,uint32_t))  /* Compare Error Interrupt Enable Set */

/* ------------------------------------------------------------------------------------------------------------------------
        CRC_INEN_CLR                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CRC_INEN_CLR_DCNTEXP             4                               /* Data Count Expired (Status) Interrupt Enable Clear */
#define BITP_CRC_INEN_CLR_CMPERR              1                               /* Compare Error Interrupt Enable Clear */
#define BITM_CRC_INEN_CLR_DCNTEXP            (_ADI_MSK(0x00000010,uint32_t))  /* Data Count Expired (Status) Interrupt Enable Clear */
#define BITM_CRC_INEN_CLR_CMPERR             (_ADI_MSK(0x00000002,uint32_t))  /* Compare Error Interrupt Enable Clear */

/* ------------------------------------------------------------------------------------------------------------------------
        CRC_STAT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CRC_STAT_FSTAT                  20                               /* FIFO Status */
#define BITP_CRC_STAT_LUTDONE                19                               /* Look Up Table Done */
#define BITP_CRC_STAT_IRR                    18                               /* Intermediate Result Ready */
#define BITP_CRC_STAT_OBR                    17                               /* Output Buffer Ready */
#define BITP_CRC_STAT_IBR                    16                               /* Input Buffer Ready */
#define BITP_CRC_STAT_DCNTEXP                 4                               /* Data Count Expired */
#define BITP_CRC_STAT_CMPERR                  1                               /* Compare Error */
#define BITM_CRC_STAT_FSTAT                  (_ADI_MSK(0x00700000,uint32_t))  /* FIFO Status */
#define BITM_CRC_STAT_LUTDONE                (_ADI_MSK(0x00080000,uint32_t))  /* Look Up Table Done */
#define BITM_CRC_STAT_IRR                    (_ADI_MSK(0x00040000,uint32_t))  /* Intermediate Result Ready */
#define BITM_CRC_STAT_OBR                    (_ADI_MSK(0x00020000,uint32_t))  /* Output Buffer Ready */
#define BITM_CRC_STAT_IBR                    (_ADI_MSK(0x00010000,uint32_t))  /* Input Buffer Ready */
#define BITM_CRC_STAT_DCNTEXP                (_ADI_MSK(0x00000010,uint32_t))  /* Data Count Expired */
#define BITM_CRC_STAT_CMPERR                 (_ADI_MSK(0x00000002,uint32_t))  /* Compare Error */

/* ------------------------------------------------------------------------------------------------------------------------
        CRC_REVID                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_CRC_REVID_MAJOR                  4                               /* Major Revision ID */
#define BITP_CRC_REVID_REV                    0                               /* Incremental Revision ID */
#define BITM_CRC_REVID_MAJOR                 (_ADI_MSK(0x000000F0,uint32_t))  /* Major Revision ID */
#define BITM_CRC_REVID_REV                   (_ADI_MSK(0x0000000F,uint32_t))  /* Incremental Revision ID */

/* ==================================================
        2-Wire Interface Registers
   ================================================== */

/* =========================
        TWI0
   ========================= */
#define REG_TWI0_CLKDIV                 0xFFC01E00         /* TWI0 SCL Clock Divider Register */
#define REG_TWI0_CTL                    0xFFC01E04         /* TWI0 Control Register */
#define REG_TWI0_SLVCTL                 0xFFC01E08         /* TWI0 Slave Mode Control Register */
#define REG_TWI0_SLVSTAT                0xFFC01E0C         /* TWI0 Slave Mode Status Register */
#define REG_TWI0_SLVADDR                0xFFC01E10         /* TWI0 Slave Mode Address Register */
#define REG_TWI0_MSTRCTL                0xFFC01E14         /* TWI0 Master Mode Control Registers */
#define REG_TWI0_MSTRSTAT               0xFFC01E18         /* TWI0 Master Mode Status Register */
#define REG_TWI0_MSTRADDR               0xFFC01E1C         /* TWI0 Master Mode Address Register */
#define REG_TWI0_ISTAT                  0xFFC01E20         /* TWI0 Interrupt Status Register */
#define REG_TWI0_IMSK                   0xFFC01E24         /* TWI0 Interrupt Mask Register */
#define REG_TWI0_FIFOCTL                0xFFC01E28         /* TWI0 FIFO Control Register */
#define REG_TWI0_FIFOSTAT               0xFFC01E2C         /* TWI0 FIFO Status Register */
#define REG_TWI0_TXDATA8                0xFFC01E80         /* TWI0 Tx Data Single-Byte Register */
#define REG_TWI0_TXDATA16               0xFFC01E84         /* TWI0 Tx Data Double-Byte Register */
#define REG_TWI0_RXDATA8                0xFFC01E88         /* TWI0 Rx Data Single-Byte Register */
#define REG_TWI0_RXDATA16               0xFFC01E8C         /* TWI0 Rx Data Double-Byte Register */

/* =========================
        TWI1
   ========================= */
#define REG_TWI1_CLKDIV                 0xFFC01F00         /* TWI1 SCL Clock Divider Register */
#define REG_TWI1_CTL                    0xFFC01F04         /* TWI1 Control Register */
#define REG_TWI1_SLVCTL                 0xFFC01F08         /* TWI1 Slave Mode Control Register */
#define REG_TWI1_SLVSTAT                0xFFC01F0C         /* TWI1 Slave Mode Status Register */
#define REG_TWI1_SLVADDR                0xFFC01F10         /* TWI1 Slave Mode Address Register */
#define REG_TWI1_MSTRCTL                0xFFC01F14         /* TWI1 Master Mode Control Registers */
#define REG_TWI1_MSTRSTAT               0xFFC01F18         /* TWI1 Master Mode Status Register */
#define REG_TWI1_MSTRADDR               0xFFC01F1C         /* TWI1 Master Mode Address Register */
#define REG_TWI1_ISTAT                  0xFFC01F20         /* TWI1 Interrupt Status Register */
#define REG_TWI1_IMSK                   0xFFC01F24         /* TWI1 Interrupt Mask Register */
#define REG_TWI1_FIFOCTL                0xFFC01F28         /* TWI1 FIFO Control Register */
#define REG_TWI1_FIFOSTAT               0xFFC01F2C         /* TWI1 FIFO Status Register */
#define REG_TWI1_TXDATA8                0xFFC01F80         /* TWI1 Tx Data Single-Byte Register */
#define REG_TWI1_TXDATA16               0xFFC01F84         /* TWI1 Tx Data Double-Byte Register */
#define REG_TWI1_RXDATA8                0xFFC01F88         /* TWI1 Rx Data Single-Byte Register */
#define REG_TWI1_RXDATA16               0xFFC01F8C         /* TWI1 Rx Data Double-Byte Register */

/* =========================
        TWI
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        TWI_CLKDIV                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_CLKDIV_CLKHI                 8                               /* SCL Clock High Periods */
#define BITP_TWI_CLKDIV_CLKLO                 0                               /* SCL Clock Low Periods */
#define BITM_TWI_CLKDIV_CLKHI                (_ADI_MSK(0x0000FF00,uint16_t))  /* SCL Clock High Periods */
#define BITM_TWI_CLKDIV_CLKLO                (_ADI_MSK(0x000000FF,uint16_t))  /* SCL Clock Low Periods */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_CTL                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_CTL_SCCB                     9                               /* SCCB Compatibility */
#define BITP_TWI_CTL_EN                       7                               /* Enable Module */
#define BITP_TWI_CTL_PRESCALE                 0                               /* SCLK Prescale Value */

#define BITM_TWI_CTL_SCCB                    (_ADI_MSK(0x00000200,uint16_t))  /* SCCB Compatibility */
#define ENUM_TWI_CTL_SCCB_DIS                (_ADI_MSK(0x00000000,uint16_t))  /* SCCB: Disable SCCB compatibility */
#define ENUM_TWI_CTL_SCCB_EN                 (_ADI_MSK(0x00000200,uint16_t))  /* SCCB: Enable SCCB compatibility */

#define BITM_TWI_CTL_EN                      (_ADI_MSK(0x00000080,uint16_t))  /* Enable Module */
#define ENUM_TWI_CTL_DIS                     (_ADI_MSK(0x00000000,uint16_t))  /* EN: Disable */
#define ENUM_TWI_CTL_EN                      (_ADI_MSK(0x00000080,uint16_t))  /* EN: Enable */
#define BITM_TWI_CTL_PRESCALE                (_ADI_MSK(0x0000007F,uint16_t))  /* SCLK Prescale Value */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_SLVCTL                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_SLVCTL_GEN                   4                               /* General Call Enable */
#define BITP_TWI_SLVCTL_NAK                   3                               /* Not Acknowledge */
#define BITP_TWI_SLVCTL_TDVAL                 2                               /* Transmit Data Valid for Slave */
#define BITP_TWI_SLVCTL_EN                    0                               /* Enable Slave Mode */

#define BITM_TWI_SLVCTL_GEN                  (_ADI_MSK(0x00000010,uint16_t))  /* General Call Enable */
#define ENUM_TWI_SLVCTL_GDIS                 (_ADI_MSK(0x00000000,uint16_t))  /* GEN: Disable General Call Matching */
#define ENUM_TWI_SLVCTL_GEN                  (_ADI_MSK(0x00000010,uint16_t))  /* GEN: Enable General Call Matching */

#define BITM_TWI_SLVCTL_NAK                  (_ADI_MSK(0x00000008,uint16_t))  /* Not Acknowledge */
#define ENUM_TWI_SLVCTL_ACKGEN               (_ADI_MSK(0x00000000,uint16_t))  /* NAK: Generate ACK */
#define ENUM_TWI_SLVCTL_NAKGEN               (_ADI_MSK(0x00000008,uint16_t))  /* NAK: Generate NAK */

#define BITM_TWI_SLVCTL_TDVAL                (_ADI_MSK(0x00000004,uint16_t))  /* Transmit Data Valid for Slave */
#define ENUM_TWI_SLVCTL_INVALID              (_ADI_MSK(0x00000000,uint16_t))  /* TDVAL: Data Invalid for Slave Tx */
#define ENUM_TWI_SLVCTL_VALID                (_ADI_MSK(0x00000004,uint16_t))  /* TDVAL: Data Valid for Slave Tx */

#define BITM_TWI_SLVCTL_EN                   (_ADI_MSK(0x00000001,uint16_t))  /* Enable Slave Mode */
#define ENUM_TWI_SLVCTL_DIS                  (_ADI_MSK(0x00000000,uint16_t))  /* EN: Disable */
#define ENUM_TWI_SLVCTL_EN                   (_ADI_MSK(0x00000001,uint16_t))  /* EN: Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_SLVSTAT                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_SLVSTAT_GCALL                1                               /* General Call */
#define BITP_TWI_SLVSTAT_DIR                  0                               /* Transfer Direction for Slave */

#define BITM_TWI_SLVSTAT_GCALL               (_ADI_MSK(0x00000002,uint16_t))  /* General Call */
#define ENUM_TWI_SLVSTAT_NO                  (_ADI_MSK(0x00000000,uint16_t))  /* GCALL: Not a General Call Address */
#define ENUM_TWI_SLVSTAT_YES                 (_ADI_MSK(0x00000002,uint16_t))  /* GCALL: General Call Address */

#define BITM_TWI_SLVSTAT_DIR                 (_ADI_MSK(0x00000001,uint16_t))  /* Transfer Direction for Slave */
#define ENUM_TWI_SLVSTAT_RX                  (_ADI_MSK(0x00000000,uint16_t))  /* DIR: Slave Receive */
#define ENUM_TWI_SLVSTAT_TX                  (_ADI_MSK(0x00000001,uint16_t))  /* DIR: Slave Transmit */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_SLVADDR                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_SLVADDR_ADDR                 0                               /* Slave Mode Address */
#define BITM_TWI_SLVADDR_ADDR                (_ADI_MSK(0x0000007F,uint16_t))  /* Slave Mode Address */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_MSTRCTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_MSTRCTL_SCLOVR              15                               /* Serial Clock Override */
#define BITP_TWI_MSTRCTL_SDAOVR              14                               /* Serial Data Override */
#define BITP_TWI_MSTRCTL_DCNT                 6                               /* Data Transfer Count */
#define BITP_TWI_MSTRCTL_RSTART               5                               /* Repeat Start */
#define BITP_TWI_MSTRCTL_STOP                 4                               /* Issue Stop Condition */
#define BITP_TWI_MSTRCTL_FAST                 3                               /* Fast Mode */
#define BITP_TWI_MSTRCTL_DIR                  2                               /* Transfer Direction for Master */
#define BITP_TWI_MSTRCTL_EN                   0                               /* Enable Master Mode */

#define BITM_TWI_MSTRCTL_SCLOVR              (_ADI_MSK(0x00008000,uint16_t))  /* Serial Clock Override */
#define ENUM_TWI_MSTRCTL_SCLNORM             (_ADI_MSK(0x00000000,uint16_t))  /* SCLOVR: Permit Normal SCL Operation */
#define ENUM_TWI_MSTRCTL_SCLOVER             (_ADI_MSK(0x00008000,uint16_t))  /* SCLOVR: Override Normal SCL Operation */

#define BITM_TWI_MSTRCTL_SDAOVR              (_ADI_MSK(0x00004000,uint16_t))  /* Serial Data Override */
#define ENUM_TWI_MSTRCTL_SDANORM             (_ADI_MSK(0x00000000,uint16_t))  /* SDAOVR: Permit Normal SDA Operation */
#define ENUM_TWI_MSTRCTL_SDAOVER             (_ADI_MSK(0x00004000,uint16_t))  /* SDAOVR: Override Normal SDA Operation */
#define BITM_TWI_MSTRCTL_DCNT                (_ADI_MSK(0x00003FC0,uint16_t))  /* Data Transfer Count */

#define BITM_TWI_MSTRCTL_RSTART              (_ADI_MSK(0x00000020,uint16_t))  /* Repeat Start */
#define ENUM_TWI_MSTRCTL_END                 (_ADI_MSK(0x00000000,uint16_t))  /* RSTART: Disable Repeat Start */
#define ENUM_TWI_MSTRCTL_RPT                 (_ADI_MSK(0x00000020,uint16_t))  /* RSTART: Enable Repeat Start */

#define BITM_TWI_MSTRCTL_STOP                (_ADI_MSK(0x00000010,uint16_t))  /* Issue Stop Condition */
#define ENUM_TWI_MSTRCTL_NORM                (_ADI_MSK(0x00000000,uint16_t))  /* STOP: Permit Normal Operation */
#define ENUM_TWI_MSTRCTL_STOP                (_ADI_MSK(0x00000010,uint16_t))  /* STOP: Issue Stop */

#define BITM_TWI_MSTRCTL_FAST                (_ADI_MSK(0x00000008,uint16_t))  /* Fast Mode */
#define ENUM_TWI_MSTRCTL_NORM                (_ADI_MSK(0x00000000,uint16_t))  /* FAST: Select Standard Mode */
#define ENUM_TWI_MSTRCTL_FAST                (_ADI_MSK(0x00000008,uint16_t))  /* FAST: Select Fast Mode */

#define BITM_TWI_MSTRCTL_DIR                 (_ADI_MSK(0x00000004,uint16_t))  /* Transfer Direction for Master */
#define ENUM_TWI_MSTRCTL_TX                  (_ADI_MSK(0x00000000,uint16_t))  /* DIR: Master Transmit */
#define ENUM_TWI_MSTRCTL_RX                  (_ADI_MSK(0x00000004,uint16_t))  /* DIR: Master Receive */

#define BITM_TWI_MSTRCTL_EN                  (_ADI_MSK(0x00000001,uint16_t))  /* Enable Master Mode */
#define ENUM_TWI_MSTRCTL_DIS                 (_ADI_MSK(0x00000000,uint16_t))  /* EN: Disable */
#define ENUM_TWI_MSTRCTL_EN                  (_ADI_MSK(0x00000001,uint16_t))  /* EN: Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_MSTRSTAT                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_MSTRSTAT_BUSBUSY             8                               /* Bus Busy */
#define BITP_TWI_MSTRSTAT_SCLSEN              7                               /* Serial Clock Sense */
#define BITP_TWI_MSTRSTAT_SDASEN              6                               /* Serial Data Sense */
#define BITP_TWI_MSTRSTAT_BUFWRERR            5                               /* Buffer Write Error */
#define BITP_TWI_MSTRSTAT_BUFRDERR            4                               /* Buffer Read Error */
#define BITP_TWI_MSTRSTAT_DNAK                3                               /* Data Not Acknowledged */
#define BITP_TWI_MSTRSTAT_ANAK                2                               /* Address Not Acknowledged */
#define BITP_TWI_MSTRSTAT_LOSTARB             1                               /* Lost Arbitration */
#define BITP_TWI_MSTRSTAT_MPROG               0                               /* Master Transfer in Progress */

#define BITM_TWI_MSTRSTAT_BUSBUSY            (_ADI_MSK(0x00000100,uint16_t))  /* Bus Busy */
#define ENUM_TWI_MSTRSTAT_FREE               (_ADI_MSK(0x00000000,uint16_t))  /* BUSBUSY: Bus Free */
#define ENUM_TWI_MSTRSTAT_BUSY               (_ADI_MSK(0x00000100,uint16_t))  /* BUSBUSY: Bus Busy */

#define BITM_TWI_MSTRSTAT_SCLSEN             (_ADI_MSK(0x00000080,uint16_t))  /* Serial Clock Sense */
#define ENUM_TWI_MSTRSTAT_SCLSEN_NO          (_ADI_MSK(0x00000000,uint16_t))  /* SCLSEN: SCL Inactive "One" */
#define ENUM_TWI_MSTRSTAT_SCLSEN_YES         (_ADI_MSK(0x00000080,uint16_t))  /* SCLSEN: SCL Active "Zero" */

#define BITM_TWI_MSTRSTAT_SDASEN             (_ADI_MSK(0x00000040,uint16_t))  /* Serial Data Sense */
#define ENUM_TWI_MSTRSTAT_SDASEN_NO          (_ADI_MSK(0x00000000,uint16_t))  /* SDASEN: SDA Inactive "One" */
#define ENUM_TWI_MSTRSTAT_SDASEN_YES         (_ADI_MSK(0x00000040,uint16_t))  /* SDASEN: SDA Active "Zero" */

#define BITM_TWI_MSTRSTAT_BUFWRERR           (_ADI_MSK(0x00000020,uint16_t))  /* Buffer Write Error */
#define ENUM_TWI_MSTRSTAT_BUFWRERR_NO        (_ADI_MSK(0x00000000,uint16_t))  /* BUFWRERR: No Status */
#define ENUM_TWI_MSTRSTAT_BUFWRERR_YES       (_ADI_MSK(0x00000020,uint16_t))  /* BUFWRERR: Buffer Write Error */

#define BITM_TWI_MSTRSTAT_BUFRDERR           (_ADI_MSK(0x00000010,uint16_t))  /* Buffer Read Error */
#define ENUM_TWI_MSTRSTAT_BUFRDERR_NO        (_ADI_MSK(0x00000000,uint16_t))  /* BUFRDERR: No Status */
#define ENUM_TWI_MSTRSTAT_BUFRDERR_YES       (_ADI_MSK(0x00000010,uint16_t))  /* BUFRDERR: Buffer Read Error */

#define BITM_TWI_MSTRSTAT_DNAK               (_ADI_MSK(0x00000008,uint16_t))  /* Data Not Acknowledged */
#define ENUM_TWI_MSTRSTAT_DNAK_NO            (_ADI_MSK(0x00000000,uint16_t))  /* DNAK: No Status */
#define ENUM_TWI_MSTRSTAT_DNAK_YES           (_ADI_MSK(0x00000008,uint16_t))  /* DNAK: Data NAK */

#define BITM_TWI_MSTRSTAT_ANAK               (_ADI_MSK(0x00000004,uint16_t))  /* Address Not Acknowledged */
#define ENUM_TWI_MSTRSTAT_ANAK_NO            (_ADI_MSK(0x00000000,uint16_t))  /* ANAK: No Status */
#define ENUM_TWI_MSTRSTAT_ANAK_YES           (_ADI_MSK(0x00000004,uint16_t))  /* ANAK: Address NAK */

#define BITM_TWI_MSTRSTAT_LOSTARB            (_ADI_MSK(0x00000002,uint16_t))  /* Lost Arbitration */
#define ENUM_TWI_MSTRSTAT_LOSTARB_NO         (_ADI_MSK(0x00000000,uint16_t))  /* LOSTARB: No Status */
#define ENUM_TWI_MSTRSTAT_LOSTARB_YES        (_ADI_MSK(0x00000002,uint16_t))  /* LOSTARB: Lost Arbitration */

#define BITM_TWI_MSTRSTAT_MPROG              (_ADI_MSK(0x00000001,uint16_t))  /* Master Transfer in Progress */
#define ENUM_TWI_MSTRSTAT_MPROG_NO           (_ADI_MSK(0x00000000,uint16_t))  /* MPROG: No Status */
#define ENUM_TWI_MSTRSTAT_MPROG_YES          (_ADI_MSK(0x00000001,uint16_t))  /* MPROG: Master Transfer in Progress */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_MSTRADDR                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_MSTRADDR_ADDR                0                               /* Master Mode Address */
#define BITM_TWI_MSTRADDR_ADDR               (_ADI_MSK(0x0000007F,uint16_t))  /* Master Mode Address */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_ISTAT                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_ISTAT_SCLI                  15                               /* Serial Clock Interrupt */
#define BITP_TWI_ISTAT_SDAI                  14                               /* Serial Data Interrupt */
#define BITP_TWI_ISTAT_RXSERV                 7                               /* Rx FIFO Service */
#define BITP_TWI_ISTAT_TXSERV                 6                               /* Tx FIFO Service */
#define BITP_TWI_ISTAT_MERR                   5                               /* Master Transfer Error */
#define BITP_TWI_ISTAT_MCOMP                  4                               /* Master Transfer Complete */
#define BITP_TWI_ISTAT_SOVF                   3                               /* Slave Overflow */
#define BITP_TWI_ISTAT_SERR                   2                               /* Slave Transfer Error */
#define BITP_TWI_ISTAT_SCOMP                  1                               /* Slave Transfer Complete */
#define BITP_TWI_ISTAT_SINIT                  0                               /* Slave Transfer Initiated */

#define BITM_TWI_ISTAT_SCLI                  (_ADI_MSK(0x00008000,uint16_t))  /* Serial Clock Interrupt */
#define ENUM_TWI_ISTAT_SCLI_NO               (_ADI_MSK(0x00000000,uint16_t))  /* SCLI: No Interrupt */
#define ENUM_TWI_ISTAT_SCLI_YES              (_ADI_MSK(0x00008000,uint16_t))  /* SCLI: Interrupt Detected */

#define BITM_TWI_ISTAT_SDAI                  (_ADI_MSK(0x00004000,uint16_t))  /* Serial Data Interrupt */
#define ENUM_TWI_ISTAT_SDAI_NO               (_ADI_MSK(0x00000000,uint16_t))  /* SDAI: No Interrupt */
#define ENUM_TWI_ISTAT_SDAI_YES              (_ADI_MSK(0x00004000,uint16_t))  /* SDAI: Interrupt Detected */

#define BITM_TWI_ISTAT_RXSERV                (_ADI_MSK(0x00000080,uint16_t))  /* Rx FIFO Service */
#define ENUM_TWI_ISTAT_RXSERV_NO             (_ADI_MSK(0x00000000,uint16_t))  /* RXSERV: No Interrupt */
#define ENUM_TWI_ISTAT_RXSERV_YES            (_ADI_MSK(0x00000080,uint16_t))  /* RXSERV: Interrupt Detected */

#define BITM_TWI_ISTAT_TXSERV                (_ADI_MSK(0x00000040,uint16_t))  /* Tx FIFO Service */
#define ENUM_TWI_ISTAT_TXSERV_NO             (_ADI_MSK(0x00000000,uint16_t))  /* TXSERV: No Interrupt */
#define ENUM_TWI_ISTAT_TXSERV_YES            (_ADI_MSK(0x00000040,uint16_t))  /* TXSERV: Interrupt Detected */

#define BITM_TWI_ISTAT_MERR                  (_ADI_MSK(0x00000020,uint16_t))  /* Master Transfer Error */
#define ENUM_TWI_ISTAT_MERR_NO               (_ADI_MSK(0x00000000,uint16_t))  /* MERR: No Interrupt */
#define ENUM_TWI_ISTAT_MERR_YES              (_ADI_MSK(0x00000020,uint16_t))  /* MERR: Interrupt Detected */

#define BITM_TWI_ISTAT_MCOMP                 (_ADI_MSK(0x00000010,uint16_t))  /* Master Transfer Complete */
#define ENUM_TWI_ISTAT_MCOMP_NO              (_ADI_MSK(0x00000000,uint16_t))  /* MCOMP: No Interrupt */
#define ENUM_TWI_ISTAT_MCOMP_YES             (_ADI_MSK(0x00000010,uint16_t))  /* MCOMP: Interrupt Detected */

#define BITM_TWI_ISTAT_SOVF                  (_ADI_MSK(0x00000008,uint16_t))  /* Slave Overflow */
#define ENUM_TWI_ISTAT_SOVF_NO               (_ADI_MSK(0x00000000,uint16_t))  /* SOVF: No Interrupt */
#define ENUM_TWI_ISTAT_SOVF_YES              (_ADI_MSK(0x00000008,uint16_t))  /* SOVF: Interrupt Detected */

#define BITM_TWI_ISTAT_SERR                  (_ADI_MSK(0x00000004,uint16_t))  /* Slave Transfer Error */
#define ENUM_TWI_ISTAT_SERR_NO               (_ADI_MSK(0x00000000,uint16_t))  /* SERR: No Interrupt */
#define ENUM_TWI_ISTAT_SERR_YES              (_ADI_MSK(0x00000004,uint16_t))  /* SERR: Interrupt Detected */

#define BITM_TWI_ISTAT_SCOMP                 (_ADI_MSK(0x00000002,uint16_t))  /* Slave Transfer Complete */
#define ENUM_TWI_ISTAT_SCOMP_NO              (_ADI_MSK(0x00000000,uint16_t))  /* SCOMP: No Interrupt */
#define ENUM_TWI_ISTAT_SCOMP_YES             (_ADI_MSK(0x00000002,uint16_t))  /* SCOMP: Interrupt Detected */

#define BITM_TWI_ISTAT_SINIT                 (_ADI_MSK(0x00000001,uint16_t))  /* Slave Transfer Initiated */
#define ENUM_TWI_ISTAT_SINIT_NO              (_ADI_MSK(0x00000000,uint16_t))  /* SINIT: No Interrupt */
#define ENUM_TWI_ISTAT_SINIT_YES             (_ADI_MSK(0x00000001,uint16_t))  /* SINIT: Interrupt Detected */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_IMSK                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_IMSK_SCLI                   15                               /* Serial Clock Interrupt Mask */
#define BITP_TWI_IMSK_SDAI                   14                               /* Serial Data Interrupt Mask */
#define BITP_TWI_IMSK_RXSERV                  7                               /* Rx FIFO Service Interrupt Mask */
#define BITP_TWI_IMSK_TXSERV                  6                               /* Tx FIFO Service Interrupt Mask */
#define BITP_TWI_IMSK_MERR                    5                               /* Master Transfer Error Interrupt Mask */
#define BITP_TWI_IMSK_MCOMP                   4                               /* Master Transfer Complete Interrupt Mask */
#define BITP_TWI_IMSK_SOVF                    3                               /* Slave Overflow Interrupt Mask */
#define BITP_TWI_IMSK_SERR                    2                               /* Slave Transfer Error Interrupt Mask */
#define BITP_TWI_IMSK_SCOMP                   1                               /* Slave Transfer Complete Interrupt Mask */
#define BITP_TWI_IMSK_SINIT                   0                               /* Slave Transfer Initiated Interrupt Mask */

#define BITM_TWI_IMSK_SCLI                   (_ADI_MSK(0x00008000,uint16_t))  /* Serial Clock Interrupt Mask */
#define ENUM_TWI_IMSK_SCLI_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* SCLI: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_SCLI_UMSK              (_ADI_MSK(0x00008000,uint16_t))  /* SCLI: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_SDAI                   (_ADI_MSK(0x00004000,uint16_t))  /* Serial Data Interrupt Mask */
#define ENUM_TWI_IMSK_SDAI_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* SDAI: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_SDAI_UMSK              (_ADI_MSK(0x00004000,uint16_t))  /* SDAI: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_RXSERV                 (_ADI_MSK(0x00000080,uint16_t))  /* Rx FIFO Service Interrupt Mask */
#define ENUM_TWI_IMSK_RXSERV_MSK             (_ADI_MSK(0x00000000,uint16_t))  /* RXSERV: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_RXSERV_UMSK            (_ADI_MSK(0x00000080,uint16_t))  /* RXSERV: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_TXSERV                 (_ADI_MSK(0x00000040,uint16_t))  /* Tx FIFO Service Interrupt Mask */
#define ENUM_TWI_IMSK_TXSERV_MSK             (_ADI_MSK(0x00000000,uint16_t))  /* TXSERV: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_TXSERV_UMSK            (_ADI_MSK(0x00000040,uint16_t))  /* TXSERV: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_MERR                   (_ADI_MSK(0x00000020,uint16_t))  /* Master Transfer Error Interrupt Mask */
#define ENUM_TWI_IMSK_MERR_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* MERR: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_MERR_UMSK              (_ADI_MSK(0x00000020,uint16_t))  /* MERR: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_MCOMP                  (_ADI_MSK(0x00000010,uint16_t))  /* Master Transfer Complete Interrupt Mask */
#define ENUM_TWI_IMSK_MCOMP_MSK              (_ADI_MSK(0x00000000,uint16_t))  /* MCOMP: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_MCOMP_UMSK             (_ADI_MSK(0x00000010,uint16_t))  /* MCOMP: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_SOVF                   (_ADI_MSK(0x00000008,uint16_t))  /* Slave Overflow Interrupt Mask */
#define ENUM_TWI_IMSK_SOVF_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* SOVF: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_SOVF_UMSK              (_ADI_MSK(0x00000008,uint16_t))  /* SOVF: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_SERR                   (_ADI_MSK(0x00000004,uint16_t))  /* Slave Transfer Error Interrupt Mask */
#define ENUM_TWI_IMSK_SERR_MSK               (_ADI_MSK(0x00000000,uint16_t))  /* SERR: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_SERR_UMSK              (_ADI_MSK(0x00000004,uint16_t))  /* SERR: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_SCOMP                  (_ADI_MSK(0x00000002,uint16_t))  /* Slave Transfer Complete Interrupt Mask */
#define ENUM_TWI_IMSK_SCOMP_MSK              (_ADI_MSK(0x00000000,uint16_t))  /* SCOMP: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_SCOMP_UMSK             (_ADI_MSK(0x00000002,uint16_t))  /* SCOMP: Unmask (Enable) Interrupt */

#define BITM_TWI_IMSK_SINIT                  (_ADI_MSK(0x00000001,uint16_t))  /* Slave Transfer Initiated Interrupt Mask */
#define ENUM_TWI_IMSK_SINIT_MSK              (_ADI_MSK(0x00000000,uint16_t))  /* SINIT: Mask (Disable) Interrupt */
#define ENUM_TWI_IMSK_SINIT_UMSK             (_ADI_MSK(0x00000001,uint16_t))  /* SINIT: Unmask (Enable) Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_FIFOCTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_FIFOCTL_RXILEN               3                               /* Rx Buffer Interrupt Length */
#define BITP_TWI_FIFOCTL_TXILEN               2                               /* Tx Buffer Interrupt Length */
#define BITP_TWI_FIFOCTL_RXFLUSH              1                               /* Rx Buffer Flush */
#define BITP_TWI_FIFOCTL_TXFLUSH              0                               /* Tx Buffer Flush */

#define BITM_TWI_FIFOCTL_RXILEN              (_ADI_MSK(0x00000008,uint16_t))  /* Rx Buffer Interrupt Length */
#define ENUM_TWI_FIFOCTL_RXONEBYTE           (_ADI_MSK(0x00000000,uint16_t))  /* RXILEN: RXSERVI on 1 or 2 Bytes in FIFO */
#define ENUM_TWI_FIFOCTL_RXTWOBYTE           (_ADI_MSK(0x00000008,uint16_t))  /* RXILEN: RXSERVI on 2 Bytes in FIFO */

#define BITM_TWI_FIFOCTL_TXILEN              (_ADI_MSK(0x00000004,uint16_t))  /* Tx Buffer Interrupt Length */
#define ENUM_TWI_FIFOCTL_TXONEBYTE           (_ADI_MSK(0x00000000,uint16_t))  /* TXILEN: TXSERVI on 1 Byte of FIFO Empty */
#define ENUM_TWI_FIFOCTL_TXTWOBYTE           (_ADI_MSK(0x00000004,uint16_t))  /* TXILEN: TXSERVI on 2 Bytes of FIFO Empty */

#define BITM_TWI_FIFOCTL_RXFLUSH             (_ADI_MSK(0x00000002,uint16_t))  /* Rx Buffer Flush */
#define ENUM_TWI_FIFOCTL_RXNORM              (_ADI_MSK(0x00000000,uint16_t))  /* RXFLUSH: Normal Operation of Rx Buffer */
#define ENUM_TWI_FIFOCTL_RXFLUSH             (_ADI_MSK(0x00000002,uint16_t))  /* RXFLUSH: Flush Rx Buffer */

#define BITM_TWI_FIFOCTL_TXFLUSH             (_ADI_MSK(0x00000001,uint16_t))  /* Tx Buffer Flush */
#define ENUM_TWI_FIFOCTL_TXNORM              (_ADI_MSK(0x00000000,uint16_t))  /* TXFLUSH: Normal Operation of Tx Buffer */
#define ENUM_TWI_FIFOCTL_TXFLUSH             (_ADI_MSK(0x00000001,uint16_t))  /* TXFLUSH: Flush Tx Buffer */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_FIFOSTAT                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_FIFOSTAT_RXSTAT              2                               /* Rx FIFO Status */
#define BITP_TWI_FIFOSTAT_TXSTAT              0                               /* Tx FIFO Status */
#define BITM_TWI_FIFOSTAT_RXSTAT             (_ADI_MSK(0x0000000C,uint16_t))  /* Rx FIFO Status */
#define BITM_TWI_FIFOSTAT_TXSTAT             (_ADI_MSK(0x00000003,uint16_t))  /* Tx FIFO Status */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_TXDATA8                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_TXDATA8_VALUE                0                               /* Tx Data 8-Bit Value */
#define BITM_TWI_TXDATA8_VALUE               (_ADI_MSK(0x000000FF,uint16_t))  /* Tx Data 8-Bit Value */

/* ------------------------------------------------------------------------------------------------------------------------
        TWI_RXDATA8                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_TWI_RXDATA8_VALUE                0                               /* Rx Data 8-Bit Value */
#define BITM_TWI_RXDATA8_VALUE               (_ADI_MSK(0x000000FF,uint16_t))  /* Rx Data 8-Bit Value */

/* ==================================================
        UART Registers
   ================================================== */

/* =========================
        UART0
   ========================= */
#define REG_UART0_REVID                 0xFFC02000         /* UART0 Revision ID Register */
#define REG_UART0_CTL                   0xFFC02004         /* UART0 Control Register */
#define REG_UART0_STAT                  0xFFC02008         /* UART0 Status Register */
#define REG_UART0_SCR                   0xFFC0200C         /* UART0 Scratch Register */
#define REG_UART0_CLK                   0xFFC02010         /* UART0 Clock Rate Register */
#define REG_UART0_IMSK                  0xFFC02014         /* UART0 Interrupt Mask Register */
#define REG_UART0_IMSK_SET              0xFFC02018         /* UART0 Interrupt Mask Set Register */
#define REG_UART0_IMSK_CLR              0xFFC0201C         /* UART0 Interrupt Mask Clear Register */
#define REG_UART0_RBR                   0xFFC02020         /* UART0 Receive Buffer Register */
#define REG_UART0_THR                   0xFFC02024         /* UART0 Transmit Hold Register */
#define REG_UART0_TAIP                  0xFFC02028         /* UART0 Transmit Address/Insert Pulse Register */
#define REG_UART0_TSR                   0xFFC0202C         /* UART0 Transmit Shift Register */
#define REG_UART0_RSR                   0xFFC02030         /* UART0 Receive Shift Register */
#define REG_UART0_TXCNT                 0xFFC02034         /* UART0 Transmit Counter Register */
#define REG_UART0_RXCNT                 0xFFC02038         /* UART0 Receive Counter Register */

/* =========================
        UART1
   ========================= */
#define REG_UART1_REVID                 0xFFC02400         /* UART1 Revision ID Register */
#define REG_UART1_CTL                   0xFFC02404         /* UART1 Control Register */
#define REG_UART1_STAT                  0xFFC02408         /* UART1 Status Register */
#define REG_UART1_SCR                   0xFFC0240C         /* UART1 Scratch Register */
#define REG_UART1_CLK                   0xFFC02410         /* UART1 Clock Rate Register */
#define REG_UART1_IMSK                  0xFFC02414         /* UART1 Interrupt Mask Register */
#define REG_UART1_IMSK_SET              0xFFC02418         /* UART1 Interrupt Mask Set Register */
#define REG_UART1_IMSK_CLR              0xFFC0241C         /* UART1 Interrupt Mask Clear Register */
#define REG_UART1_RBR                   0xFFC02420         /* UART1 Receive Buffer Register */
#define REG_UART1_THR                   0xFFC02424         /* UART1 Transmit Hold Register */
#define REG_UART1_TAIP                  0xFFC02428         /* UART1 Transmit Address/Insert Pulse Register */
#define REG_UART1_TSR                   0xFFC0242C         /* UART1 Transmit Shift Register */
#define REG_UART1_RSR                   0xFFC02430         /* UART1 Receive Shift Register */
#define REG_UART1_TXCNT                 0xFFC02434         /* UART1 Transmit Counter Register */
#define REG_UART1_RXCNT                 0xFFC02438         /* UART1 Receive Counter Register */

/* =========================
        UART
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        UART_REVID                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_REVID_MAJOR                 4                               /* Major Version */
#define BITP_UART_REVID_REV                   0                               /* Incremental Version */
#define BITM_UART_REVID_MAJOR                (_ADI_MSK(0x000000F0,uint32_t))  /* Major Version */
#define BITM_UART_REVID_REV                  (_ADI_MSK(0x0000000F,uint32_t))  /* Incremental Version */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_CTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_CTL_RFRT                   30                               /* Receive FIFO RTS Threshold */
#define BITP_UART_CTL_RFIT                   29                               /* Receive FIFO IRQ Threshold */
#define BITP_UART_CTL_ACTS                   28                               /* Automatic CTS */
#define BITP_UART_CTL_ARTS                   27                               /* Automatic RTS */
#define BITP_UART_CTL_XOFF                   26                               /* Transmitter off */
#define BITP_UART_CTL_MRTS                   25                               /* Manual Request to Send */
#define BITP_UART_CTL_TPOLC                  24                               /* IrDA TX Polarity Change */
#define BITP_UART_CTL_RPOLC                  23                               /* IrDA RX Polarity Change */
#define BITP_UART_CTL_FCPOL                  22                               /* Flow Control Pin Polarity */
#define BITP_UART_CTL_SB                     19                               /* Set Break */
#define BITP_UART_CTL_FFE                    18                               /* Force Framing Error on Transmit */
#define BITP_UART_CTL_FPE                    17                               /* Force Parity Error on Transmit */
#define BITP_UART_CTL_STP                    16                               /* Sticky Parity */
#define BITP_UART_CTL_EPS                    15                               /* Even Parity Select */
#define BITP_UART_CTL_PEN                    14                               /* Parity Enable */
#define BITP_UART_CTL_STBH                   13                               /* Stop Bits (Half Bit Time) */
#define BITP_UART_CTL_STB                    12                               /* Stop Bits */
#define BITP_UART_CTL_WLS                     8                               /* Word Length Select */
#define BITP_UART_CTL_MOD                     4                               /* Mode of Operation */
#define BITP_UART_CTL_LOOP_EN                 1                               /* Loopback Enable */
#define BITP_UART_CTL_EN                      0                               /* Enable UART */

#define BITM_UART_CTL_RFRT                   (_ADI_MSK(0x40000000,uint32_t))  /* Receive FIFO RTS Threshold */
#define ENUM_UART_CTL_RX_RTS_TH4             (_ADI_MSK(0x00000000,uint32_t))  /* RFRT: De-assert RTS if RX FIFO word count > 4; assert if <= 4 */
#define ENUM_UART_CTL_RX_RTS_TH7             (_ADI_MSK(0x40000000,uint32_t))  /* RFRT: De-assert RTS if RX FIFO word count > 7; assert if <= 7 */

#define BITM_UART_CTL_RFIT                   (_ADI_MSK(0x20000000,uint32_t))  /* Receive FIFO IRQ Threshold */
#define ENUM_UART_CTL_RX_IRQ_TH4             (_ADI_MSK(0x00000000,uint32_t))  /* RFIT: Set RFCS=1 if RX FIFO count >= 4 */
#define ENUM_UART_CTL_RX_IRQ_TH7             (_ADI_MSK(0x20000000,uint32_t))  /* RFIT: Set RFCS=1 if RX FIFO count >= 7 */

#define BITM_UART_CTL_ACTS                   (_ADI_MSK(0x10000000,uint32_t))  /* Automatic CTS */
#define ENUM_UART_CTL_CTS_MAN                (_ADI_MSK(0x00000000,uint32_t))  /* ACTS: Disable TX handshaking protocol */
#define ENUM_UART_CTL_CTS_AUTO               (_ADI_MSK(0x10000000,uint32_t))  /* ACTS: Enable TX handshaking protocol */

#define BITM_UART_CTL_ARTS                   (_ADI_MSK(0x08000000,uint32_t))  /* Automatic RTS */
#define ENUM_UART_CTL_RTS_MAN                (_ADI_MSK(0x00000000,uint32_t))  /* ARTS: Disable RX handshaking protocol. */
#define ENUM_UART_CTL_RTS_AUTO               (_ADI_MSK(0x08000000,uint32_t))  /* ARTS: Enable RX handshaking protocol. */

#define BITM_UART_CTL_XOFF                   (_ADI_MSK(0x04000000,uint32_t))  /* Transmitter off */
#define ENUM_UART_CTL_TX_ON                  (_ADI_MSK(0x00000000,uint32_t))  /* XOFF: Transmission ON, if ACTS=0 */
#define ENUM_UART_CTL_TX_OFF                 (_ADI_MSK(0x04000000,uint32_t))  /* XOFF: Transmission OFF, if ACTS=0 */

#define BITM_UART_CTL_MRTS                   (_ADI_MSK(0x02000000,uint32_t))  /* Manual Request to Send */
#define ENUM_UART_CTL_RTS_DEASSERT           (_ADI_MSK(0x00000000,uint32_t))  /* MRTS: De-assert RTS pin when ARTS=0 */
#define ENUM_UART_CTL_RTS_ASSERT             (_ADI_MSK(0x02000000,uint32_t))  /* MRTS: Assert RTS pin  when ARTS=0 */

#define BITM_UART_CTL_TPOLC                  (_ADI_MSK(0x01000000,uint32_t))  /* IrDA TX Polarity Change */
#define ENUM_UART_CTL_TPOLC_LO               (_ADI_MSK(0x00000000,uint32_t))  /* TPOLC: Active-low TX polarity setting */
#define ENUM_UART_CTL_TPOLC_HI               (_ADI_MSK(0x01000000,uint32_t))  /* TPOLC: Active-high TX polarity setting */

#define BITM_UART_CTL_RPOLC                  (_ADI_MSK(0x00800000,uint32_t))  /* IrDA RX Polarity Change */
#define ENUM_UART_CTL_RPOLC_LO               (_ADI_MSK(0x00000000,uint32_t))  /* RPOLC: Active-low RX polarity setting */
#define ENUM_UART_CTL_RPOLC_HI               (_ADI_MSK(0x00800000,uint32_t))  /* RPOLC: Active-high RX polarity setting */

#define BITM_UART_CTL_FCPOL                  (_ADI_MSK(0x00400000,uint32_t))  /* Flow Control Pin Polarity */
#define ENUM_UART_CTL_FCPOL_LO               (_ADI_MSK(0x00000000,uint32_t))  /* FCPOL: Active low CTS/RTS */
#define ENUM_UART_CTL_FCPOL_HI               (_ADI_MSK(0x00400000,uint32_t))  /* FCPOL: Active high CTS/RTS */

#define BITM_UART_CTL_SB                     (_ADI_MSK(0x00080000,uint32_t))  /* Set Break */
#define ENUM_UART_CTL_NORM_BREAK             (_ADI_MSK(0x00000000,uint32_t))  /* SB: No force */
#define ENUM_UART_CTL_FORCE_BREAK            (_ADI_MSK(0x00080000,uint32_t))  /* SB: Force TX pin to 0 */

#define BITM_UART_CTL_FFE                    (_ADI_MSK(0x00040000,uint32_t))  /* Force Framing Error on Transmit */
#define ENUM_UART_CTL_NORM_FRM_ERR           (_ADI_MSK(0x00000000,uint32_t))  /* FFE: Normal operation */
#define ENUM_UART_CTL_FORCE_FRM_ERR          (_ADI_MSK(0x00040000,uint32_t))  /* FFE: Force error */

#define BITM_UART_CTL_FPE                    (_ADI_MSK(0x00020000,uint32_t))  /* Force Parity Error on Transmit */
#define ENUM_UART_CTL_NORM_PARITY_ERR        (_ADI_MSK(0x00000000,uint32_t))  /* FPE: Normal operation */
#define ENUM_UART_CTL_FORCE_PARITY_ERR       (_ADI_MSK(0x00020000,uint32_t))  /* FPE: Force parity error */

#define BITM_UART_CTL_STP                    (_ADI_MSK(0x00010000,uint32_t))  /* Sticky Parity */
#define ENUM_UART_CTL_NORM_PARITY            (_ADI_MSK(0x00000000,uint32_t))  /* STP: No Forced Parity */
#define ENUM_UART_CTL_STICKY_PARITY          (_ADI_MSK(0x00010000,uint32_t))  /* STP: Force (Stick) Parity to Defined Value (if PEN=1) */

#define BITM_UART_CTL_EPS                    (_ADI_MSK(0x00008000,uint32_t))  /* Even Parity Select */
#define ENUM_UART_CTL_ODD_PARITY             (_ADI_MSK(0x00000000,uint32_t))  /* EPS: Odd parity */
#define ENUM_UART_CTL_EVEN_PARITY            (_ADI_MSK(0x00008000,uint32_t))  /* EPS: Even parity */

#define BITM_UART_CTL_PEN                    (_ADI_MSK(0x00004000,uint32_t))  /* Parity Enable */
#define ENUM_UART_CTL_PARITY_DIS             (_ADI_MSK(0x00000000,uint32_t))  /* PEN: Disable */
#define ENUM_UART_CTL_PARITY_EN              (_ADI_MSK(0x00004000,uint32_t))  /* PEN: Enable parity transmit and check */

#define BITM_UART_CTL_STBH                   (_ADI_MSK(0x00002000,uint32_t))  /* Stop Bits (Half Bit Time) */
#define ENUM_UART_CTL_NO_EXTRA_STBH          (_ADI_MSK(0x00000000,uint32_t))  /* STBH: 0 half-bit-time stop bit */
#define ENUM_UART_CTL_1_EXTRA_STBH           (_ADI_MSK(0x00002000,uint32_t))  /* STBH: 1 half-bit-time stop bit */

#define BITM_UART_CTL_STB                    (_ADI_MSK(0x00001000,uint32_t))  /* Stop Bits */
#define ENUM_UART_CTL_NO_EXTRA_STB           (_ADI_MSK(0x00000000,uint32_t))  /* STB: 1 stop bit */
#define ENUM_UART_CTL_1_EXTRA_STB            (_ADI_MSK(0x00001000,uint32_t))  /* STB: 2 stop bits */

#define BITM_UART_CTL_WLS                    (_ADI_MSK(0x00000300,uint32_t))  /* Word Length Select */
#define ENUM_UART_CTL_WL5BITS                (_ADI_MSK(0x00000000,uint32_t))  /* WLS: 5-bit Word */
#define ENUM_UART_CTL_WL6BITS                (_ADI_MSK(0x00000100,uint32_t))  /* WLS: 6-bit Word */
#define ENUM_UART_CTL_WL7BITS                (_ADI_MSK(0x00000200,uint32_t))  /* WLS: 7-bit Word */
#define ENUM_UART_CTL_WL8BITS                (_ADI_MSK(0x00000300,uint32_t))  /* WLS: 8-bit Word */

#define BITM_UART_CTL_MOD                    (_ADI_MSK(0x00000030,uint32_t))  /* Mode of Operation */
#define ENUM_UART_CTL_UART_MODE              (_ADI_MSK(0x00000000,uint32_t))  /* MOD: UART Mode */
#define ENUM_UART_CTL_MDB_MODE               (_ADI_MSK(0x00000010,uint32_t))  /* MOD: MDB Mode */
#define ENUM_UART_CTL_IRDA_MODE              (_ADI_MSK(0x00000020,uint32_t))  /* MOD: IrDA SIR Mode */

#define BITM_UART_CTL_LOOP_EN                (_ADI_MSK(0x00000002,uint32_t))  /* Loopback Enable */
#define ENUM_UART_CTL_LOOP_DIS               (_ADI_MSK(0x00000000,uint32_t))  /* LOOP_EN: Disable */
#define ENUM_UART_CTL_LOOP_EN                (_ADI_MSK(0x00000002,uint32_t))  /* LOOP_EN: Enable */

#define BITM_UART_CTL_EN                     (_ADI_MSK(0x00000001,uint32_t))  /* Enable UART */
#define ENUM_UART_CTL_CLK_DIS                (_ADI_MSK(0x00000000,uint32_t))  /* EN: Disable */
#define ENUM_UART_CTL_CLK_EN                 (_ADI_MSK(0x00000001,uint32_t))  /* EN: Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_STAT                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_STAT_RFCS                  17                               /* Receive FIFO Count Status */
#define BITP_UART_STAT_CTS                   16                               /* Clear to Send */
#define BITP_UART_STAT_SCTS                  12                               /* Sticky CTS */
#define BITP_UART_STAT_RO                    11                               /* Reception On-going */
#define BITP_UART_STAT_ADDR                  10                               /* Address Bit Status */
#define BITP_UART_STAT_ASTKY                  9                               /* Address Sticky */
#define BITP_UART_STAT_TFI                    8                               /* Transmission Finished Indicator */
#define BITP_UART_STAT_TEMT                   7                               /* TSR and THR Empty */
#define BITP_UART_STAT_THRE                   5                               /* Transmit Hold Register Empty */
#define BITP_UART_STAT_BI                     4                               /* Break Indicator */
#define BITP_UART_STAT_FE                     3                               /* Framing Error */
#define BITP_UART_STAT_PE                     2                               /* Parity Error */
#define BITP_UART_STAT_OE                     1                               /* Overrun Error */
#define BITP_UART_STAT_DR                     0                               /* Data Ready */

#define BITM_UART_STAT_RFCS                  (_ADI_MSK(0x00020000,uint32_t))  /* Receive FIFO Count Status */
#define ENUM_UART_STAT_RFCS_LO               (_ADI_MSK(0x00000000,uint32_t))  /* RFCS: RX FIFO has less than 4 (7) entries when RFIT=0 (1) */
#define ENUM_UART_STAT_RFCS_HI               (_ADI_MSK(0x00020000,uint32_t))  /* RFCS: RX FIFO has at least 4 (7) entries when RFIT=0 (1) */

#define BITM_UART_STAT_CTS                   (_ADI_MSK(0x00010000,uint32_t))  /* Clear to Send */
#define ENUM_UART_STAT_CTS_LO                (_ADI_MSK(0x00000000,uint32_t))  /* CTS: Not clear to send (External device not ready to receive) */
#define ENUM_UART_STAT_CTS_HI                (_ADI_MSK(0x00010000,uint32_t))  /* CTS: Clear to send (External device ready to receive) */

#define BITM_UART_STAT_SCTS                  (_ADI_MSK(0x00001000,uint32_t))  /* Sticky CTS */
#define ENUM_UART_STAT_CTS_LO_STKY           (_ADI_MSK(0x00000000,uint32_t))  /* SCTS: CTS has not transitioned from low to high */
#define ENUM_UART_STAT_CTS_HI_STKY           (_ADI_MSK(0x00001000,uint32_t))  /* SCTS: CTS has transitioned from low to high */

#define BITM_UART_STAT_RO                    (_ADI_MSK(0x00000800,uint32_t))  /* Reception On-going */
#define ENUM_UART_STAT_NO_RX_PROGRESS        (_ADI_MSK(0x00000000,uint32_t))  /* RO: No data reception in progress */
#define ENUM_UART_STAT_RX_PROGRESS           (_ADI_MSK(0x00000800,uint32_t))  /* RO: Data reception in progress */

#define BITM_UART_STAT_ADDR                  (_ADI_MSK(0x00000400,uint32_t))  /* Address Bit Status */
#define ENUM_UART_STAT_ADDR_LO               (_ADI_MSK(0x00000000,uint32_t))  /* ADDR: Address bit is low */
#define ENUM_UART_STAT_ADDR_HI               (_ADI_MSK(0x00000400,uint32_t))  /* ADDR: Address bit is high */

#define BITM_UART_STAT_ASTKY                 (_ADI_MSK(0x00000200,uint32_t))  /* Address Sticky */
#define ENUM_UART_STAT_ADDR_LO_STKY          (_ADI_MSK(0x00000000,uint32_t))  /* ASTKY: ADDR bit has not been set */
#define ENUM_UART_STAT_ADDR_HI_STKY          (_ADI_MSK(0x00000200,uint32_t))  /* ASTKY: ADDR bit has been set */

#define BITM_UART_STAT_TFI                   (_ADI_MSK(0x00000100,uint32_t))  /* Transmission Finished Indicator */
#define ENUM_UART_STAT_TX_NOT_DONE           (_ADI_MSK(0x00000000,uint32_t))  /* TFI: TEMT did not transition from 0 to 1 */
#define ENUM_UART_STAT_TX_DONE               (_ADI_MSK(0x00000100,uint32_t))  /* TFI: TEMT transition from 0 to 1 */

#define BITM_UART_STAT_TEMT                  (_ADI_MSK(0x00000080,uint32_t))  /* TSR and THR Empty */
#define ENUM_UART_STAT_TX_NOT_EMPTY          (_ADI_MSK(0x00000000,uint32_t))  /* TEMT: Not empty TSR/THR */
#define ENUM_UART_STAT_TX_EMPTY              (_ADI_MSK(0x00000080,uint32_t))  /* TEMT: TSR/THR Empty */

#define BITM_UART_STAT_THRE                  (_ADI_MSK(0x00000020,uint32_t))  /* Transmit Hold Register Empty */
#define ENUM_UART_STAT_THR_NOT_EMPTY         (_ADI_MSK(0x00000000,uint32_t))  /* THRE: Not empty THR/TAIP */
#define ENUM_UART_STAT_THR_EMPTY             (_ADI_MSK(0x00000020,uint32_t))  /* THRE: Empty THR/TAIP */

#define BITM_UART_STAT_BI                    (_ADI_MSK(0x00000010,uint32_t))  /* Break Indicator */
#define ENUM_UART_STAT_NO_BREAK_INT          (_ADI_MSK(0x00000000,uint32_t))  /* BI: No break interrupt */
#define ENUM_UART_STAT_BREAK_INT             (_ADI_MSK(0x00000010,uint32_t))  /* BI: Break interrupt */

#define BITM_UART_STAT_FE                    (_ADI_MSK(0x00000008,uint32_t))  /* Framing Error */
#define ENUM_UART_STAT_NO_FRAMING_ERR        (_ADI_MSK(0x00000000,uint32_t))  /* FE: No error */
#define ENUM_UART_STAT_FRAMING_ERR           (_ADI_MSK(0x00000008,uint32_t))  /* FE: Invalid stop bit error */

#define BITM_UART_STAT_PE                    (_ADI_MSK(0x00000004,uint32_t))  /* Parity Error */
#define ENUM_UART_STAT_NO_PARITY_ERR         (_ADI_MSK(0x00000000,uint32_t))  /* PE: No parity error */
#define ENUM_UART_STAT_PARITY_ERR            (_ADI_MSK(0x00000004,uint32_t))  /* PE: Parity error */

#define BITM_UART_STAT_OE                    (_ADI_MSK(0x00000002,uint32_t))  /* Overrun Error */
#define ENUM_UART_STAT_NO_OVR_ERR            (_ADI_MSK(0x00000000,uint32_t))  /* OE: No overrun */
#define ENUM_UART_STAT_OVR_ERR               (_ADI_MSK(0x00000002,uint32_t))  /* OE: Overrun error */

#define BITM_UART_STAT_DR                    (_ADI_MSK(0x00000001,uint32_t))  /* Data Ready */
#define ENUM_UART_STAT_NO_DATA               (_ADI_MSK(0x00000000,uint32_t))  /* DR: No new data */
#define ENUM_UART_STAT_NEW_DATA              (_ADI_MSK(0x00000001,uint32_t))  /* DR: New data in RBR */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_SCR                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_SCR_VALUE                   0                               /* Stored 8-bit Data */
#define BITM_UART_SCR_VALUE                  (_ADI_MSK(0x000000FF,uint32_t))  /* Stored 8-bit Data */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_CLK                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_CLK_EDBO                   31                               /* Enable Divide By One */
#define BITP_UART_CLK_DIV                     0                               /* Divisor */

#define BITM_UART_CLK_EDBO                   (_ADI_MSK(0x80000000,uint32_t))  /* Enable Divide By One */
#define ENUM_UART_CLK_DIS_DIV_BY_ONE         (_ADI_MSK(0x00000000,uint32_t))  /* EDBO: Bit clock prescaler = 16 */
#define ENUM_UART_CLK_EN_DIV_BY_ONE          (_ADI_MSK(0x80000000,uint32_t))  /* EDBO: Bit clock prescaler = 1 */
#define BITM_UART_CLK_DIV                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Divisor */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_IMSK                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_IMSK_ETXS                   9                               /* Enable TX to Status Interrupt Mask Status */
#define BITP_UART_IMSK_ERXS                   8                               /* Enable RX to Status Interrupt Mask Status */
#define BITP_UART_IMSK_EAWI                   7                               /* Enable Address Word Interrupt Mask Status */
#define BITP_UART_IMSK_ERFCI                  6                               /* Enable Receive FIFO Count Interrupt Mask Status */
#define BITP_UART_IMSK_ETFI                   5                               /* Enable Transmission Finished Interrupt Mask Status */
#define BITP_UART_IMSK_EDTPTI                 4                               /* Enable DMA TX Peripheral Trigerred Interrupt Mask Status */
#define BITP_UART_IMSK_EDSSI                  3                               /* Enable Modem Status Interrupt Mask Status */
#define BITP_UART_IMSK_ELSI                   2                               /* Enable Line Status Interrupt Mask Status */
#define BITP_UART_IMSK_ETBEI                  1                               /* Enable Transmit Buffer Empty Interrupt Mask Status */
#define BITP_UART_IMSK_ERBFI                  0                               /* Enable Receive Buffer Full Interrupt Mask Status */

#define BITM_UART_IMSK_ETXS                  (_ADI_MSK(0x00000200,uint32_t))  /* Enable TX to Status Interrupt Mask Status */
#define ENUM_UART_ETXS_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* ETXS: Interrupt is masked */
#define ENUM_UART_ETXS_HI                    (_ADI_MSK(0x00000200,uint32_t))  /* ETXS: Interrupt is unmasked */

#define BITM_UART_IMSK_ERXS                  (_ADI_MSK(0x00000100,uint32_t))  /* Enable RX to Status Interrupt Mask Status */
#define ENUM_UART_ERXS_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* ERXS: Interrupt is masked */
#define ENUM_UART_ERXS_HI                    (_ADI_MSK(0x00000100,uint32_t))  /* ERXS: Interrupt is unmasked */

#define BITM_UART_IMSK_EAWI                  (_ADI_MSK(0x00000080,uint32_t))  /* Enable Address Word Interrupt Mask Status */
#define ENUM_UART_EAWI_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* EAWI: Interrupt is masked */
#define ENUM_UART_EAWI_HI                    (_ADI_MSK(0x00000080,uint32_t))  /* EAWI: Interrupt is unmasked */

#define BITM_UART_IMSK_ERFCI                 (_ADI_MSK(0x00000040,uint32_t))  /* Enable Receive FIFO Count Interrupt Mask Status */
#define ENUM_UART_ERFCI_LO                   (_ADI_MSK(0x00000000,uint32_t))  /* ERFCI: Interrupt is masked */
#define ENUM_UART_ERFCI_HI                   (_ADI_MSK(0x00000040,uint32_t))  /* ERFCI: Interrupt is unmasked */

#define BITM_UART_IMSK_ETFI                  (_ADI_MSK(0x00000020,uint32_t))  /* Enable Transmission Finished Interrupt Mask Status */
#define ENUM_UART_ETFI_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* ETFI: Interrupt is masked */
#define ENUM_UART_ETFI_HI                    (_ADI_MSK(0x00000020,uint32_t))  /* ETFI: Interrupt is unmasked */

#define BITM_UART_IMSK_EDTPTI                (_ADI_MSK(0x00000010,uint32_t))  /* Enable DMA TX Peripheral Trigerred Interrupt Mask Status */
#define ENUM_UART_EDTPTI_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* EDTPTI: Interrupt is masked */
#define ENUM_UART_EDTPTI_HI                  (_ADI_MSK(0x00000010,uint32_t))  /* EDTPTI: Interrupt is unmasked */

#define BITM_UART_IMSK_EDSSI                 (_ADI_MSK(0x00000008,uint32_t))  /* Enable Modem Status Interrupt Mask Status */
#define ENUM_UART_EDSSI_LO                   (_ADI_MSK(0x00000000,uint32_t))  /* EDSSI: Interrupt is masked */
#define ENUM_UART_EDSSI_HI                   (_ADI_MSK(0x00000008,uint32_t))  /* EDSSI: Interrupt is unmasked */

#define BITM_UART_IMSK_ELSI                  (_ADI_MSK(0x00000004,uint32_t))  /* Enable Line Status Interrupt Mask Status */
#define ENUM_UART_ELSI_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* ELSI: Interrupt is masked */
#define ENUM_UART_ELSI_HI                    (_ADI_MSK(0x00000004,uint32_t))  /* ELSI: Interrupt is unmasked */

#define BITM_UART_IMSK_ETBEI                 (_ADI_MSK(0x00000002,uint32_t))  /* Enable Transmit Buffer Empty Interrupt Mask Status */
#define ENUM_UART_ETBEI_LO                   (_ADI_MSK(0x00000000,uint32_t))  /* ETBEI: Interrupt is masked */
#define ENUM_UART_ETBEI_HI                   (_ADI_MSK(0x00000002,uint32_t))  /* ETBEI: Interrupt is unmasked */

#define BITM_UART_IMSK_ERBFI                 (_ADI_MSK(0x00000001,uint32_t))  /* Enable Receive Buffer Full Interrupt Mask Status */
#define ENUM_UART_ERBFI_LO                   (_ADI_MSK(0x00000000,uint32_t))  /* ERBFI: Interrupt is masked */
#define ENUM_UART_ERBFI_HI                   (_ADI_MSK(0x00000001,uint32_t))  /* ERBFI: Interrupt is unmasked */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_IMSK_SET                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_IMSK_SET_ETXS               9                               /* Enable TX to Status Interrupt Mask Set */
#define BITP_UART_IMSK_SET_ERXS               8                               /* Enable RX to Status Interrupt Mask Set */
#define BITP_UART_IMSK_SET_EAWI               7                               /* Enable Address Word Interrupt Mask Set */
#define BITP_UART_IMSK_SET_ERFCI              6                               /* Enable Receive FIFO Count Interrupt Mask Set */
#define BITP_UART_IMSK_SET_ETFI               5                               /* Enable Transmission Finished Interrupt Mask Set */
#define BITP_UART_IMSK_SET_EDTPTI             4                               /* Enable DMA TX Peripheral Triggered Interrupt Mask Set */
#define BITP_UART_IMSK_SET_EDSSI              3                               /* Enable Modem Status Interrupt Mask Set */
#define BITP_UART_IMSK_SET_ELSI               2                               /* Enable Line Status Interrupt Mask Set */
#define BITP_UART_IMSK_SET_ETBEI              1                               /* Enable Transmit Buffer Empty Interrupt Mask Set */
#define BITP_UART_IMSK_SET_ERBFI              0                               /* Enable Receive Buffer Full Interrupt Mask Set */

/* The fields and enumerations for UART_IMSK_SET are also in UART - see the common set of ENUM_UART_* #defines located with register UART_IMSK */

#define BITM_UART_IMSK_SET_ETXS              (_ADI_MSK(0x00000200,uint32_t))  /* Enable TX to Status Interrupt Mask Set */
#define BITM_UART_IMSK_SET_ERXS              (_ADI_MSK(0x00000100,uint32_t))  /* Enable RX to Status Interrupt Mask Set */
#define BITM_UART_IMSK_SET_EAWI              (_ADI_MSK(0x00000080,uint32_t))  /* Enable Address Word Interrupt Mask Set */
#define BITM_UART_IMSK_SET_ERFCI             (_ADI_MSK(0x00000040,uint32_t))  /* Enable Receive FIFO Count Interrupt Mask Set */
#define BITM_UART_IMSK_SET_ETFI              (_ADI_MSK(0x00000020,uint32_t))  /* Enable Transmission Finished Interrupt Mask Set */
#define BITM_UART_IMSK_SET_EDTPTI            (_ADI_MSK(0x00000010,uint32_t))  /* Enable DMA TX Peripheral Triggered Interrupt Mask Set */
#define BITM_UART_IMSK_SET_EDSSI             (_ADI_MSK(0x00000008,uint32_t))  /* Enable Modem Status Interrupt Mask Set */
#define BITM_UART_IMSK_SET_ELSI              (_ADI_MSK(0x00000004,uint32_t))  /* Enable Line Status Interrupt Mask Set */
#define BITM_UART_IMSK_SET_ETBEI             (_ADI_MSK(0x00000002,uint32_t))  /* Enable Transmit Buffer Empty Interrupt Mask Set */
#define BITM_UART_IMSK_SET_ERBFI             (_ADI_MSK(0x00000001,uint32_t))  /* Enable Receive Buffer Full Interrupt Mask Set */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_IMSK_CLR                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_IMSK_CLR_ETXS               9                               /* Enable TX to Status Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_ERXS               8                               /* Enable RX to Status Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_EAWI               7                               /* Enable Address Word Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_ERFCI              6                               /* Enable Receive FIFO Count Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_ETFI               5                               /* Enable Transmission Finished Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_EDTPTI             4                               /* Enable DMA TX Peripheral Triggered Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_EDSSI              3                               /* Enable Modem Status Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_ELSI               2                               /* Enable Line Status Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_ETBEI              1                               /* Enable Transmit Buffer Empty Interrupt Mask Clear */
#define BITP_UART_IMSK_CLR_ERBFI              0                               /* Enable Receive Buffer Full Interrupt Mask Clear */

/* The fields and enumerations for UART_IMSK_CLR are also in UART - see the common set of ENUM_UART_* #defines located with register UART_IMSK */

#define BITM_UART_IMSK_CLR_ETXS              (_ADI_MSK(0x00000200,uint32_t))  /* Enable TX to Status Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_ERXS              (_ADI_MSK(0x00000100,uint32_t))  /* Enable RX to Status Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_EAWI              (_ADI_MSK(0x00000080,uint32_t))  /* Enable Address Word Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_ERFCI             (_ADI_MSK(0x00000040,uint32_t))  /* Enable Receive FIFO Count Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_ETFI              (_ADI_MSK(0x00000020,uint32_t))  /* Enable Transmission Finished Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_EDTPTI            (_ADI_MSK(0x00000010,uint32_t))  /* Enable DMA TX Peripheral Triggered Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_EDSSI             (_ADI_MSK(0x00000008,uint32_t))  /* Enable Modem Status Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_ELSI              (_ADI_MSK(0x00000004,uint32_t))  /* Enable Line Status Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_ETBEI             (_ADI_MSK(0x00000002,uint32_t))  /* Enable Transmit Buffer Empty Interrupt Mask Clear */
#define BITM_UART_IMSK_CLR_ERBFI             (_ADI_MSK(0x00000001,uint32_t))  /* Enable Receive Buffer Full Interrupt Mask Clear */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_RBR                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_RBR_VALUE                   0                               /* 8-bit data */
#define BITM_UART_RBR_VALUE                  (_ADI_MSK(0x000000FF,uint32_t))  /* 8-bit data */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_THR                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_THR_VALUE                   0                               /* 8 bit data */
#define BITM_UART_THR_VALUE                  (_ADI_MSK(0x000000FF,uint32_t))  /* 8 bit data */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_TAIP                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_TAIP_VALUE                  0                               /* 8-bit data */
#define BITM_UART_TAIP_VALUE                 (_ADI_MSK(0x000000FF,uint32_t))  /* 8-bit data */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_TSR                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_TSR_VALUE                   0                               /* Contents of TSR */
#define BITM_UART_TSR_VALUE                  (_ADI_MSK(0x000007FF,uint32_t))  /* Contents of TSR */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_RSR                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_RSR_VALUE                   0                               /* Contents of RSR */
#define BITM_UART_RSR_VALUE                  (_ADI_MSK(0x000003FF,uint32_t))  /* Contents of RSR */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_TXCNT                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_TXCNT_VALUE                 0                               /* 16-bit Counter Value */
#define BITM_UART_TXCNT_VALUE                (_ADI_MSK(0x0000FFFF,uint32_t))  /* 16-bit Counter Value */

/* ------------------------------------------------------------------------------------------------------------------------
        UART_RXCNT                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_UART_RXCNT_VALUE                 0                               /* 16-bit Counter Value */
#define BITM_UART_RXCNT_VALUE                (_ADI_MSK(0x0000FFFF,uint32_t))  /* 16-bit Counter Value */

/* ==================================================
        General Purpose Input/Output Registers
   ================================================== */

/* =========================
        PORTA
   ========================= */
#define REG_PORTA_FER                   0xFFC03000         /* PORTA Port x Function Enable Register */
#define REG_PORTA_FER_SET               0xFFC03004         /* PORTA Port x Function Enable Set Register */
#define REG_PORTA_FER_CLR               0xFFC03008         /* PORTA Port x Function Enable Clear Register */
#define REG_PORTA_DATA                  0xFFC0300C         /* PORTA Port x GPIO Data Register */
#define REG_PORTA_DATA_SET              0xFFC03010         /* PORTA Port x GPIO Data Set Register */
#define REG_PORTA_DATA_CLR              0xFFC03014         /* PORTA Port x GPIO Data Clear Register */
#define REG_PORTA_DIR                   0xFFC03018         /* PORTA Port x GPIO Direction Register */
#define REG_PORTA_DIR_SET               0xFFC0301C         /* PORTA Port x GPIO Direction Set Register */
#define REG_PORTA_DIR_CLR               0xFFC03020         /* PORTA Port x GPIO Direction Clear Register */
#define REG_PORTA_INEN                  0xFFC03024         /* PORTA Port x GPIO Input Enable Register */
#define REG_PORTA_INEN_SET              0xFFC03028         /* PORTA Port x GPIO Input Enable Set Register */
#define REG_PORTA_INEN_CLR              0xFFC0302C         /* PORTA Port x GPIO Input Enable Clear Register */
#define REG_PORTA_MUX                   0xFFC03030         /* PORTA Port x Multiplexer Control Register */
#define REG_PORTA_DATA_TGL              0xFFC03034         /* PORTA Port x GPIO Input Enable Toggle Register */
#define REG_PORTA_POL                   0xFFC03038         /* PORTA Port x GPIO Polarity Invert Register */
#define REG_PORTA_POL_SET               0xFFC0303C         /* PORTA Port x GPIO Polarity Invert Set Register */
#define REG_PORTA_POL_CLR               0xFFC03040         /* PORTA Port x GPIO Polarity Invert Clear Register */
#define REG_PORTA_LOCK                  0xFFC03044         /* PORTA Port x GPIO Lock Register */
#define REG_PORTA_REVID                 0xFFC0307C         /* PORTA Port x GPIO Revision ID */

/* =========================
        PORTB
   ========================= */
#define REG_PORTB_FER                   0xFFC03080         /* PORTB Port x Function Enable Register */
#define REG_PORTB_FER_SET               0xFFC03084         /* PORTB Port x Function Enable Set Register */
#define REG_PORTB_FER_CLR               0xFFC03088         /* PORTB Port x Function Enable Clear Register */
#define REG_PORTB_DATA                  0xFFC0308C         /* PORTB Port x GPIO Data Register */
#define REG_PORTB_DATA_SET              0xFFC03090         /* PORTB Port x GPIO Data Set Register */
#define REG_PORTB_DATA_CLR              0xFFC03094         /* PORTB Port x GPIO Data Clear Register */
#define REG_PORTB_DIR                   0xFFC03098         /* PORTB Port x GPIO Direction Register */
#define REG_PORTB_DIR_SET               0xFFC0309C         /* PORTB Port x GPIO Direction Set Register */
#define REG_PORTB_DIR_CLR               0xFFC030A0         /* PORTB Port x GPIO Direction Clear Register */
#define REG_PORTB_INEN                  0xFFC030A4         /* PORTB Port x GPIO Input Enable Register */
#define REG_PORTB_INEN_SET              0xFFC030A8         /* PORTB Port x GPIO Input Enable Set Register */
#define REG_PORTB_INEN_CLR              0xFFC030AC         /* PORTB Port x GPIO Input Enable Clear Register */
#define REG_PORTB_MUX                   0xFFC030B0         /* PORTB Port x Multiplexer Control Register */
#define REG_PORTB_DATA_TGL              0xFFC030B4         /* PORTB Port x GPIO Input Enable Toggle Register */
#define REG_PORTB_POL                   0xFFC030B8         /* PORTB Port x GPIO Polarity Invert Register */
#define REG_PORTB_POL_SET               0xFFC030BC         /* PORTB Port x GPIO Polarity Invert Set Register */
#define REG_PORTB_POL_CLR               0xFFC030C0         /* PORTB Port x GPIO Polarity Invert Clear Register */
#define REG_PORTB_LOCK                  0xFFC030C4         /* PORTB Port x GPIO Lock Register */
#define REG_PORTB_REVID                 0xFFC030FC         /* PORTB Port x GPIO Revision ID */

/* =========================
        PORTC
   ========================= */
#define REG_PORTC_FER                   0xFFC03100         /* PORTC Port x Function Enable Register */
#define REG_PORTC_FER_SET               0xFFC03104         /* PORTC Port x Function Enable Set Register */
#define REG_PORTC_FER_CLR               0xFFC03108         /* PORTC Port x Function Enable Clear Register */
#define REG_PORTC_DATA                  0xFFC0310C         /* PORTC Port x GPIO Data Register */
#define REG_PORTC_DATA_SET              0xFFC03110         /* PORTC Port x GPIO Data Set Register */
#define REG_PORTC_DATA_CLR              0xFFC03114         /* PORTC Port x GPIO Data Clear Register */
#define REG_PORTC_DIR                   0xFFC03118         /* PORTC Port x GPIO Direction Register */
#define REG_PORTC_DIR_SET               0xFFC0311C         /* PORTC Port x GPIO Direction Set Register */
#define REG_PORTC_DIR_CLR               0xFFC03120         /* PORTC Port x GPIO Direction Clear Register */
#define REG_PORTC_INEN                  0xFFC03124         /* PORTC Port x GPIO Input Enable Register */
#define REG_PORTC_INEN_SET              0xFFC03128         /* PORTC Port x GPIO Input Enable Set Register */
#define REG_PORTC_INEN_CLR              0xFFC0312C         /* PORTC Port x GPIO Input Enable Clear Register */
#define REG_PORTC_MUX                   0xFFC03130         /* PORTC Port x Multiplexer Control Register */
#define REG_PORTC_DATA_TGL              0xFFC03134         /* PORTC Port x GPIO Input Enable Toggle Register */
#define REG_PORTC_POL                   0xFFC03138         /* PORTC Port x GPIO Polarity Invert Register */
#define REG_PORTC_POL_SET               0xFFC0313C         /* PORTC Port x GPIO Polarity Invert Set Register */
#define REG_PORTC_POL_CLR               0xFFC03140         /* PORTC Port x GPIO Polarity Invert Clear Register */
#define REG_PORTC_LOCK                  0xFFC03144         /* PORTC Port x GPIO Lock Register */
#define REG_PORTC_REVID                 0xFFC0317C         /* PORTC Port x GPIO Revision ID */

/* =========================
        PORTD
   ========================= */
#define REG_PORTD_FER                   0xFFC03180         /* PORTD Port x Function Enable Register */
#define REG_PORTD_FER_SET               0xFFC03184         /* PORTD Port x Function Enable Set Register */
#define REG_PORTD_FER_CLR               0xFFC03188         /* PORTD Port x Function Enable Clear Register */
#define REG_PORTD_DATA                  0xFFC0318C         /* PORTD Port x GPIO Data Register */
#define REG_PORTD_DATA_SET              0xFFC03190         /* PORTD Port x GPIO Data Set Register */
#define REG_PORTD_DATA_CLR              0xFFC03194         /* PORTD Port x GPIO Data Clear Register */
#define REG_PORTD_DIR                   0xFFC03198         /* PORTD Port x GPIO Direction Register */
#define REG_PORTD_DIR_SET               0xFFC0319C         /* PORTD Port x GPIO Direction Set Register */
#define REG_PORTD_DIR_CLR               0xFFC031A0         /* PORTD Port x GPIO Direction Clear Register */
#define REG_PORTD_INEN                  0xFFC031A4         /* PORTD Port x GPIO Input Enable Register */
#define REG_PORTD_INEN_SET              0xFFC031A8         /* PORTD Port x GPIO Input Enable Set Register */
#define REG_PORTD_INEN_CLR              0xFFC031AC         /* PORTD Port x GPIO Input Enable Clear Register */
#define REG_PORTD_MUX                   0xFFC031B0         /* PORTD Port x Multiplexer Control Register */
#define REG_PORTD_DATA_TGL              0xFFC031B4         /* PORTD Port x GPIO Input Enable Toggle Register */
#define REG_PORTD_POL                   0xFFC031B8         /* PORTD Port x GPIO Polarity Invert Register */
#define REG_PORTD_POL_SET               0xFFC031BC         /* PORTD Port x GPIO Polarity Invert Set Register */
#define REG_PORTD_POL_CLR               0xFFC031C0         /* PORTD Port x GPIO Polarity Invert Clear Register */
#define REG_PORTD_LOCK                  0xFFC031C4         /* PORTD Port x GPIO Lock Register */
#define REG_PORTD_REVID                 0xFFC031FC         /* PORTD Port x GPIO Revision ID */

/* =========================
        PORTE
   ========================= */
#define REG_PORTE_FER                   0xFFC03200         /* PORTE Port x Function Enable Register */
#define REG_PORTE_FER_SET               0xFFC03204         /* PORTE Port x Function Enable Set Register */
#define REG_PORTE_FER_CLR               0xFFC03208         /* PORTE Port x Function Enable Clear Register */
#define REG_PORTE_DATA                  0xFFC0320C         /* PORTE Port x GPIO Data Register */
#define REG_PORTE_DATA_SET              0xFFC03210         /* PORTE Port x GPIO Data Set Register */
#define REG_PORTE_DATA_CLR              0xFFC03214         /* PORTE Port x GPIO Data Clear Register */
#define REG_PORTE_DIR                   0xFFC03218         /* PORTE Port x GPIO Direction Register */
#define REG_PORTE_DIR_SET               0xFFC0321C         /* PORTE Port x GPIO Direction Set Register */
#define REG_PORTE_DIR_CLR               0xFFC03220         /* PORTE Port x GPIO Direction Clear Register */
#define REG_PORTE_INEN                  0xFFC03224         /* PORTE Port x GPIO Input Enable Register */
#define REG_PORTE_INEN_SET              0xFFC03228         /* PORTE Port x GPIO Input Enable Set Register */
#define REG_PORTE_INEN_CLR              0xFFC0322C         /* PORTE Port x GPIO Input Enable Clear Register */
#define REG_PORTE_MUX                   0xFFC03230         /* PORTE Port x Multiplexer Control Register */
#define REG_PORTE_DATA_TGL              0xFFC03234         /* PORTE Port x GPIO Input Enable Toggle Register */
#define REG_PORTE_POL                   0xFFC03238         /* PORTE Port x GPIO Polarity Invert Register */
#define REG_PORTE_POL_SET               0xFFC0323C         /* PORTE Port x GPIO Polarity Invert Set Register */
#define REG_PORTE_POL_CLR               0xFFC03240         /* PORTE Port x GPIO Polarity Invert Clear Register */
#define REG_PORTE_LOCK                  0xFFC03244         /* PORTE Port x GPIO Lock Register */
#define REG_PORTE_REVID                 0xFFC0327C         /* PORTE Port x GPIO Revision ID */

/* =========================
        PORTF
   ========================= */
#define REG_PORTF_FER                   0xFFC03280         /* PORTF Port x Function Enable Register */
#define REG_PORTF_FER_SET               0xFFC03284         /* PORTF Port x Function Enable Set Register */
#define REG_PORTF_FER_CLR               0xFFC03288         /* PORTF Port x Function Enable Clear Register */
#define REG_PORTF_DATA                  0xFFC0328C         /* PORTF Port x GPIO Data Register */
#define REG_PORTF_DATA_SET              0xFFC03290         /* PORTF Port x GPIO Data Set Register */
#define REG_PORTF_DATA_CLR              0xFFC03294         /* PORTF Port x GPIO Data Clear Register */
#define REG_PORTF_DIR                   0xFFC03298         /* PORTF Port x GPIO Direction Register */
#define REG_PORTF_DIR_SET               0xFFC0329C         /* PORTF Port x GPIO Direction Set Register */
#define REG_PORTF_DIR_CLR               0xFFC032A0         /* PORTF Port x GPIO Direction Clear Register */
#define REG_PORTF_INEN                  0xFFC032A4         /* PORTF Port x GPIO Input Enable Register */
#define REG_PORTF_INEN_SET              0xFFC032A8         /* PORTF Port x GPIO Input Enable Set Register */
#define REG_PORTF_INEN_CLR              0xFFC032AC         /* PORTF Port x GPIO Input Enable Clear Register */
#define REG_PORTF_MUX                   0xFFC032B0         /* PORTF Port x Multiplexer Control Register */
#define REG_PORTF_DATA_TGL              0xFFC032B4         /* PORTF Port x GPIO Input Enable Toggle Register */
#define REG_PORTF_POL                   0xFFC032B8         /* PORTF Port x GPIO Polarity Invert Register */
#define REG_PORTF_POL_SET               0xFFC032BC         /* PORTF Port x GPIO Polarity Invert Set Register */
#define REG_PORTF_POL_CLR               0xFFC032C0         /* PORTF Port x GPIO Polarity Invert Clear Register */
#define REG_PORTF_LOCK                  0xFFC032C4         /* PORTF Port x GPIO Lock Register */
#define REG_PORTF_REVID                 0xFFC032FC         /* PORTF Port x GPIO Revision ID */

/* =========================
        PORTG
   ========================= */
#define REG_PORTG_FER                   0xFFC03300         /* PORTG Port x Function Enable Register */
#define REG_PORTG_FER_SET               0xFFC03304         /* PORTG Port x Function Enable Set Register */
#define REG_PORTG_FER_CLR               0xFFC03308         /* PORTG Port x Function Enable Clear Register */
#define REG_PORTG_DATA                  0xFFC0330C         /* PORTG Port x GPIO Data Register */
#define REG_PORTG_DATA_SET              0xFFC03310         /* PORTG Port x GPIO Data Set Register */
#define REG_PORTG_DATA_CLR              0xFFC03314         /* PORTG Port x GPIO Data Clear Register */
#define REG_PORTG_DIR                   0xFFC03318         /* PORTG Port x GPIO Direction Register */
#define REG_PORTG_DIR_SET               0xFFC0331C         /* PORTG Port x GPIO Direction Set Register */
#define REG_PORTG_DIR_CLR               0xFFC03320         /* PORTG Port x GPIO Direction Clear Register */
#define REG_PORTG_INEN                  0xFFC03324         /* PORTG Port x GPIO Input Enable Register */
#define REG_PORTG_INEN_SET              0xFFC03328         /* PORTG Port x GPIO Input Enable Set Register */
#define REG_PORTG_INEN_CLR              0xFFC0332C         /* PORTG Port x GPIO Input Enable Clear Register */
#define REG_PORTG_MUX                   0xFFC03330         /* PORTG Port x Multiplexer Control Register */
#define REG_PORTG_DATA_TGL              0xFFC03334         /* PORTG Port x GPIO Input Enable Toggle Register */
#define REG_PORTG_POL                   0xFFC03338         /* PORTG Port x GPIO Polarity Invert Register */
#define REG_PORTG_POL_SET               0xFFC0333C         /* PORTG Port x GPIO Polarity Invert Set Register */
#define REG_PORTG_POL_CLR               0xFFC03340         /* PORTG Port x GPIO Polarity Invert Clear Register */
#define REG_PORTG_LOCK                  0xFFC03344         /* PORTG Port x GPIO Lock Register */
#define REG_PORTG_REVID                 0xFFC0337C         /* PORTG Port x GPIO Revision ID */

/* =========================
        PORT
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        PORT_FER                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_FER_PX15                   15                               /* Port x Bit 15 Mode */
#define BITP_PORT_FER_PX14                   14                               /* Port x Bit 14 Mode */
#define BITP_PORT_FER_PX13                   13                               /* Port x Bit 13 Mode */
#define BITP_PORT_FER_PX12                   12                               /* Port x Bit 12 Mode */
#define BITP_PORT_FER_PX11                   11                               /* Port x Bit 11 Mode */
#define BITP_PORT_FER_PX10                   10                               /* Port x Bit 10 Mode */
#define BITP_PORT_FER_PX9                     9                               /* Port x Bit 9 Mode */
#define BITP_PORT_FER_PX8                     8                               /* Port x Bit 8 Mode */
#define BITP_PORT_FER_PX7                     7                               /* Port x Bit 7 Mode */
#define BITP_PORT_FER_PX6                     6                               /* Port x Bit 6 Mode */
#define BITP_PORT_FER_PX5                     5                               /* Port x Bit 5 Mode */
#define BITP_PORT_FER_PX4                     4                               /* Port x Bit 4 Mode */
#define BITP_PORT_FER_PX3                     3                               /* Port x Bit 3 Mode */
#define BITP_PORT_FER_PX2                     2                               /* Port x Bit 2 Mode */
#define BITP_PORT_FER_PX1                     1                               /* Port x Bit 1 Mode */
#define BITP_PORT_FER_PX0                     0                               /* Port x Bit 0 Mode */
#define BITM_PORT_FER_PX15                   (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Mode */
#define BITM_PORT_FER_PX14                   (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Mode */
#define BITM_PORT_FER_PX13                   (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Mode */
#define BITM_PORT_FER_PX12                   (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Mode */
#define BITM_PORT_FER_PX11                   (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Mode */
#define BITM_PORT_FER_PX10                   (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Mode */
#define BITM_PORT_FER_PX9                    (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Mode */
#define BITM_PORT_FER_PX8                    (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Mode */
#define BITM_PORT_FER_PX7                    (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Mode */
#define BITM_PORT_FER_PX6                    (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Mode */
#define BITM_PORT_FER_PX5                    (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Mode */
#define BITM_PORT_FER_PX4                    (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Mode */
#define BITM_PORT_FER_PX3                    (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Mode */
#define BITM_PORT_FER_PX2                    (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Mode */
#define BITM_PORT_FER_PX1                    (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Mode */
#define BITM_PORT_FER_PX0                    (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Mode */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_FER_SET                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_FER_SET_PX15               15                               /* Port x Bit 15 Mode Set */
#define BITP_PORT_FER_SET_PX14               14                               /* Port x Bit 14 Mode Set */
#define BITP_PORT_FER_SET_PX13               13                               /* Port x Bit 13 Mode Set */
#define BITP_PORT_FER_SET_PX12               12                               /* Port x Bit 12 Mode Set */
#define BITP_PORT_FER_SET_PX11               11                               /* Port x Bit 11 Mode Set */
#define BITP_PORT_FER_SET_PX10               10                               /* Port x Bit 10 Mode Set */
#define BITP_PORT_FER_SET_PX9                 9                               /* Port x Bit 9 Mode Set */
#define BITP_PORT_FER_SET_PX8                 8                               /* Port x Bit 8 Mode Set */
#define BITP_PORT_FER_SET_PX7                 7                               /* Port x Bit 7 Mode Set */
#define BITP_PORT_FER_SET_PX6                 6                               /* Port x Bit 6 Mode Set */
#define BITP_PORT_FER_SET_PX5                 5                               /* Port x Bit 5 Mode Set */
#define BITP_PORT_FER_SET_PX4                 4                               /* Port x Bit 4 Mode Set */
#define BITP_PORT_FER_SET_PX3                 3                               /* Port x Bit 3 Mode Set */
#define BITP_PORT_FER_SET_PX2                 2                               /* Port x Bit 2 Mode Set */
#define BITP_PORT_FER_SET_PX1                 1                               /* Port x Bit 1 Mode Set */
#define BITP_PORT_FER_SET_PX0                 0                               /* Port x Bit 0 Mode Set */
#define BITM_PORT_FER_SET_PX15               (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Mode Set */
#define BITM_PORT_FER_SET_PX14               (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Mode Set */
#define BITM_PORT_FER_SET_PX13               (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Mode Set */
#define BITM_PORT_FER_SET_PX12               (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Mode Set */
#define BITM_PORT_FER_SET_PX11               (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Mode Set */
#define BITM_PORT_FER_SET_PX10               (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Mode Set */
#define BITM_PORT_FER_SET_PX9                (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Mode Set */
#define BITM_PORT_FER_SET_PX8                (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Mode Set */
#define BITM_PORT_FER_SET_PX7                (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Mode Set */
#define BITM_PORT_FER_SET_PX6                (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Mode Set */
#define BITM_PORT_FER_SET_PX5                (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Mode Set */
#define BITM_PORT_FER_SET_PX4                (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Mode Set */
#define BITM_PORT_FER_SET_PX3                (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Mode Set */
#define BITM_PORT_FER_SET_PX2                (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Mode Set */
#define BITM_PORT_FER_SET_PX1                (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Mode Set */
#define BITM_PORT_FER_SET_PX0                (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Mode Set */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_FER_CLR                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_FER_CLR_PX15               15                               /* Port x Bit 15 Mode Clear */
#define BITP_PORT_FER_CLR_PX14               14                               /* Port x Bit 14 Mode Clear */
#define BITP_PORT_FER_CLR_PX13               13                               /* Port x Bit 13 Mode Clear */
#define BITP_PORT_FER_CLR_PX12               12                               /* Port x Bit 12 Mode Clear */
#define BITP_PORT_FER_CLR_PX11               11                               /* Port x Bit 11 Mode Clear */
#define BITP_PORT_FER_CLR_PX10               10                               /* Port x Bit 10 Mode Clear */
#define BITP_PORT_FER_CLR_PX9                 9                               /* Port x Bit 9 Mode Clear */
#define BITP_PORT_FER_CLR_PX8                 8                               /* Port x Bit 8 Mode Clear */
#define BITP_PORT_FER_CLR_PX7                 7                               /* Port x Bit 7 Mode Clear */
#define BITP_PORT_FER_CLR_PX6                 6                               /* Port x Bit 6 Mode Clear */
#define BITP_PORT_FER_CLR_PX5                 5                               /* Port x Bit 5 Mode Clear */
#define BITP_PORT_FER_CLR_PX4                 4                               /* Port x Bit 4 Mode Clear */
#define BITP_PORT_FER_CLR_PX3                 3                               /* Port x Bit 3 Mode Clear */
#define BITP_PORT_FER_CLR_PX2                 2                               /* Port x Bit 2 Mode Clear */
#define BITP_PORT_FER_CLR_PX1                 1                               /* Port x Bit 1 Mode Clear */
#define BITP_PORT_FER_CLR_PX0                 0                               /* Port x Bit 0 Mode Clear */
#define BITM_PORT_FER_CLR_PX15               (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Mode Clear */
#define BITM_PORT_FER_CLR_PX14               (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Mode Clear */
#define BITM_PORT_FER_CLR_PX13               (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Mode Clear */
#define BITM_PORT_FER_CLR_PX12               (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Mode Clear */
#define BITM_PORT_FER_CLR_PX11               (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Mode Clear */
#define BITM_PORT_FER_CLR_PX10               (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Mode Clear */
#define BITM_PORT_FER_CLR_PX9                (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Mode Clear */
#define BITM_PORT_FER_CLR_PX8                (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Mode Clear */
#define BITM_PORT_FER_CLR_PX7                (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Mode Clear */
#define BITM_PORT_FER_CLR_PX6                (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Mode Clear */
#define BITM_PORT_FER_CLR_PX5                (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Mode Clear */
#define BITM_PORT_FER_CLR_PX4                (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Mode Clear */
#define BITM_PORT_FER_CLR_PX3                (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Mode Clear */
#define BITM_PORT_FER_CLR_PX2                (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Mode Clear */
#define BITM_PORT_FER_CLR_PX1                (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Mode Clear */
#define BITM_PORT_FER_CLR_PX0                (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Mode Clear */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_DATA                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_DATA_PX15                  15                               /* Port x Bit 15 Data */
#define BITP_PORT_DATA_PX14                  14                               /* Port x Bit 14 Data */
#define BITP_PORT_DATA_PX13                  13                               /* Port x Bit 13 Data */
#define BITP_PORT_DATA_PX12                  12                               /* Port x Bit 12 Data */
#define BITP_PORT_DATA_PX11                  11                               /* Port x Bit 11 Data */
#define BITP_PORT_DATA_PX10                  10                               /* Port x Bit 10 Data */
#define BITP_PORT_DATA_PX9                    9                               /* Port x Bit 9 Data */
#define BITP_PORT_DATA_PX8                    8                               /* Port x Bit 8 Data */
#define BITP_PORT_DATA_PX7                    7                               /* Port x Bit 7 Data */
#define BITP_PORT_DATA_PX6                    6                               /* Port x Bit 6 Data */
#define BITP_PORT_DATA_PX5                    5                               /* Port x Bit 5 Data */
#define BITP_PORT_DATA_PX4                    4                               /* Port x Bit 4 Data */
#define BITP_PORT_DATA_PX3                    3                               /* Port x Bit 3 Data */
#define BITP_PORT_DATA_PX2                    2                               /* Port x Bit 2 Data */
#define BITP_PORT_DATA_PX1                    1                               /* Port x Bit 1 Data */
#define BITP_PORT_DATA_PX0                    0                               /* Port x Bit 0 Data */
#define BITM_PORT_DATA_PX15                  (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Data */
#define BITM_PORT_DATA_PX14                  (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Data */
#define BITM_PORT_DATA_PX13                  (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Data */
#define BITM_PORT_DATA_PX12                  (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Data */
#define BITM_PORT_DATA_PX11                  (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Data */
#define BITM_PORT_DATA_PX10                  (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Data */
#define BITM_PORT_DATA_PX9                   (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Data */
#define BITM_PORT_DATA_PX8                   (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Data */
#define BITM_PORT_DATA_PX7                   (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Data */
#define BITM_PORT_DATA_PX6                   (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Data */
#define BITM_PORT_DATA_PX5                   (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Data */
#define BITM_PORT_DATA_PX4                   (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Data */
#define BITM_PORT_DATA_PX3                   (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Data */
#define BITM_PORT_DATA_PX2                   (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Data */
#define BITM_PORT_DATA_PX1                   (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Data */
#define BITM_PORT_DATA_PX0                   (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Data */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_DATA_SET                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_DATA_SET_PX15              15                               /* Port x Bit 15 Data Set */
#define BITP_PORT_DATA_SET_PX14              14                               /* Port x Bit 14 Data Set */
#define BITP_PORT_DATA_SET_PX13              13                               /* Port x Bit 13 Data Set */
#define BITP_PORT_DATA_SET_PX12              12                               /* Port x Bit 12 Data Set */
#define BITP_PORT_DATA_SET_PX11              11                               /* Port x Bit 11 Data Set */
#define BITP_PORT_DATA_SET_PX10              10                               /* Port x Bit 10 Data Set */
#define BITP_PORT_DATA_SET_PX9                9                               /* Port x Bit 9 Data Set */
#define BITP_PORT_DATA_SET_PX8                8                               /* Port x Bit 8 Data Set */
#define BITP_PORT_DATA_SET_PX7                7                               /* Port x Bit 7 Data Set */
#define BITP_PORT_DATA_SET_PX6                6                               /* Port x Bit 6 Data Set */
#define BITP_PORT_DATA_SET_PX5                5                               /* Port x Bit 5 Data Set */
#define BITP_PORT_DATA_SET_PX4                4                               /* Port x Bit 4 Data Set */
#define BITP_PORT_DATA_SET_PX3                3                               /* Port x Bit 3 Data Set */
#define BITP_PORT_DATA_SET_PX2                2                               /* Port x Bit 2 Data Set */
#define BITP_PORT_DATA_SET_PX1                1                               /* Port x Bit 1 Data Set */
#define BITP_PORT_DATA_SET_PX0                0                               /* Port x Bit 0 Data Set */
#define BITM_PORT_DATA_SET_PX15              (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Data Set */
#define BITM_PORT_DATA_SET_PX14              (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Data Set */
#define BITM_PORT_DATA_SET_PX13              (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Data Set */
#define BITM_PORT_DATA_SET_PX12              (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Data Set */
#define BITM_PORT_DATA_SET_PX11              (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Data Set */
#define BITM_PORT_DATA_SET_PX10              (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Data Set */
#define BITM_PORT_DATA_SET_PX9               (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Data Set */
#define BITM_PORT_DATA_SET_PX8               (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Data Set */
#define BITM_PORT_DATA_SET_PX7               (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Data Set */
#define BITM_PORT_DATA_SET_PX6               (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Data Set */
#define BITM_PORT_DATA_SET_PX5               (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Data Set */
#define BITM_PORT_DATA_SET_PX4               (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Data Set */
#define BITM_PORT_DATA_SET_PX3               (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Data Set */
#define BITM_PORT_DATA_SET_PX2               (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Data Set */
#define BITM_PORT_DATA_SET_PX1               (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Data Set */
#define BITM_PORT_DATA_SET_PX0               (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Data Set */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_DATA_CLR                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_DATA_CLR_PX15              15                               /* Port x Bit 15 Data Clear */
#define BITP_PORT_DATA_CLR_PX14              14                               /* Port x Bit 14 Data Clear */
#define BITP_PORT_DATA_CLR_PX13              13                               /* Port x Bit 13 Data Clear */
#define BITP_PORT_DATA_CLR_PX12              12                               /* Port x Bit 12 Data Clear */
#define BITP_PORT_DATA_CLR_PX11              11                               /* Port x Bit 11 Data Clear */
#define BITP_PORT_DATA_CLR_PX10              10                               /* Port x Bit 10 Data Clear */
#define BITP_PORT_DATA_CLR_PX9                9                               /* Port x Bit 9 Data Clear */
#define BITP_PORT_DATA_CLR_PX8                8                               /* Port x Bit 8 Data Clear */
#define BITP_PORT_DATA_CLR_PX7                7                               /* Port x Bit 7 Data Clear */
#define BITP_PORT_DATA_CLR_PX6                6                               /* Port x Bit 6 Data Clear */
#define BITP_PORT_DATA_CLR_PX5                5                               /* Port x Bit 5 Data Clear */
#define BITP_PORT_DATA_CLR_PX4                4                               /* Port x Bit 4 Data Clear */
#define BITP_PORT_DATA_CLR_PX3                3                               /* Port x Bit 3 Data Clear */
#define BITP_PORT_DATA_CLR_PX2                2                               /* Port x Bit 2 Data Clear */
#define BITP_PORT_DATA_CLR_PX1                1                               /* Port x Bit 1 Data Clear */
#define BITP_PORT_DATA_CLR_PX0                0                               /* Port x Bit 0 Data Clear */
#define BITM_PORT_DATA_CLR_PX15              (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Data Clear */
#define BITM_PORT_DATA_CLR_PX14              (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Data Clear */
#define BITM_PORT_DATA_CLR_PX13              (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Data Clear */
#define BITM_PORT_DATA_CLR_PX12              (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Data Clear */
#define BITM_PORT_DATA_CLR_PX11              (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Data Clear */
#define BITM_PORT_DATA_CLR_PX10              (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Data Clear */
#define BITM_PORT_DATA_CLR_PX9               (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Data Clear */
#define BITM_PORT_DATA_CLR_PX8               (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Data Clear */
#define BITM_PORT_DATA_CLR_PX7               (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Data Clear */
#define BITM_PORT_DATA_CLR_PX6               (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Data Clear */
#define BITM_PORT_DATA_CLR_PX5               (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Data Clear */
#define BITM_PORT_DATA_CLR_PX4               (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Data Clear */
#define BITM_PORT_DATA_CLR_PX3               (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Data Clear */
#define BITM_PORT_DATA_CLR_PX2               (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Data Clear */
#define BITM_PORT_DATA_CLR_PX1               (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Data Clear */
#define BITM_PORT_DATA_CLR_PX0               (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Data Clear */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_DIR                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_DIR_PX15                   15                               /* Port x Bit 15 Direction */
#define BITP_PORT_DIR_PX14                   14                               /* Port x Bit 14 Direction */
#define BITP_PORT_DIR_PX13                   13                               /* Port x Bit 13 Direction */
#define BITP_PORT_DIR_PX12                   12                               /* Port x Bit 12 Direction */
#define BITP_PORT_DIR_PX11                   11                               /* Port x Bit 11 Direction */
#define BITP_PORT_DIR_PX10                   10                               /* Port x Bit 10 Direction */
#define BITP_PORT_DIR_PX9                     9                               /* Port x Bit 9 Direction */
#define BITP_PORT_DIR_PX8                     8                               /* Port x Bit 8 Direction */
#define BITP_PORT_DIR_PX7                     7                               /* Port x Bit 7 Direction */
#define BITP_PORT_DIR_PX6                     6                               /* Port x Bit 6 Direction */
#define BITP_PORT_DIR_PX5                     5                               /* Port x Bit 5 Direction */
#define BITP_PORT_DIR_PX4                     4                               /* Port x Bit 4 Direction */
#define BITP_PORT_DIR_PX3                     3                               /* Port x Bit 3 Direction */
#define BITP_PORT_DIR_PX2                     2                               /* Port x Bit 2 Direction */
#define BITP_PORT_DIR_PX1                     1                               /* Port x Bit 1 Direction */
#define BITP_PORT_DIR_PX0                     0                               /* Port x Bit 0 Direction */
#define BITM_PORT_DIR_PX15                   (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Direction */
#define BITM_PORT_DIR_PX14                   (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Direction */
#define BITM_PORT_DIR_PX13                   (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Direction */
#define BITM_PORT_DIR_PX12                   (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Direction */
#define BITM_PORT_DIR_PX11                   (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Direction */
#define BITM_PORT_DIR_PX10                   (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Direction */
#define BITM_PORT_DIR_PX9                    (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Direction */
#define BITM_PORT_DIR_PX8                    (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Direction */
#define BITM_PORT_DIR_PX7                    (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Direction */
#define BITM_PORT_DIR_PX6                    (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Direction */
#define BITM_PORT_DIR_PX5                    (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Direction */
#define BITM_PORT_DIR_PX4                    (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Direction */
#define BITM_PORT_DIR_PX3                    (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Direction */
#define BITM_PORT_DIR_PX2                    (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Direction */
#define BITM_PORT_DIR_PX1                    (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Direction */
#define BITM_PORT_DIR_PX0                    (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Direction */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_DIR_SET                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_DIR_SET_PX15               15                               /* Port x Bit 15 Direction Set */
#define BITP_PORT_DIR_SET_PX14               14                               /* Port x Bit 14 Direction Set */
#define BITP_PORT_DIR_SET_PX13               13                               /* Port x Bit 13 Direction Set */
#define BITP_PORT_DIR_SET_PX12               12                               /* Port x Bit 12 Direction Set */
#define BITP_PORT_DIR_SET_PX11               11                               /* Port x Bit 11 Direction Set */
#define BITP_PORT_DIR_SET_PX10               10                               /* Port x Bit 10 Direction Set */
#define BITP_PORT_DIR_SET_PX9                 9                               /* Port x Bit 9 Direction Set */
#define BITP_PORT_DIR_SET_PX8                 8                               /* Port x Bit 8 Direction Set */
#define BITP_PORT_DIR_SET_PX7                 7                               /* Port x Bit 7 Direction Set */
#define BITP_PORT_DIR_SET_PX6                 6                               /* Port x Bit 6 Direction Set */
#define BITP_PORT_DIR_SET_PX5                 5                               /* Port x Bit 5 Direction Set */
#define BITP_PORT_DIR_SET_PX4                 4                               /* Port x Bit 4 Direction Set */
#define BITP_PORT_DIR_SET_PX3                 3                               /* Port x Bit 3 Direction Set */
#define BITP_PORT_DIR_SET_PX2                 2                               /* Port x Bit 2 Direction Set */
#define BITP_PORT_DIR_SET_PX1                 1                               /* Port x Bit 1 Direction Set */
#define BITP_PORT_DIR_SET_PX0                 0                               /* Port x Bit 0 Direction Set */
#define BITM_PORT_DIR_SET_PX15               (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Direction Set */
#define BITM_PORT_DIR_SET_PX14               (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Direction Set */
#define BITM_PORT_DIR_SET_PX13               (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Direction Set */
#define BITM_PORT_DIR_SET_PX12               (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Direction Set */
#define BITM_PORT_DIR_SET_PX11               (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Direction Set */
#define BITM_PORT_DIR_SET_PX10               (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Direction Set */
#define BITM_PORT_DIR_SET_PX9                (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Direction Set */
#define BITM_PORT_DIR_SET_PX8                (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Direction Set */
#define BITM_PORT_DIR_SET_PX7                (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Direction Set */
#define BITM_PORT_DIR_SET_PX6                (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Direction Set */
#define BITM_PORT_DIR_SET_PX5                (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Direction Set */
#define BITM_PORT_DIR_SET_PX4                (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Direction Set */
#define BITM_PORT_DIR_SET_PX3                (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Direction Set */
#define BITM_PORT_DIR_SET_PX2                (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Direction Set */
#define BITM_PORT_DIR_SET_PX1                (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Direction Set */
#define BITM_PORT_DIR_SET_PX0                (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Direction Set */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_DIR_CLR                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_DIR_CLR_PX15               15                               /* Port x Bit 15 Direction Clear */
#define BITP_PORT_DIR_CLR_PX14               14                               /* Port x Bit 14 Direction Clear */
#define BITP_PORT_DIR_CLR_PX13               13                               /* Port x Bit 13 Direction Clear */
#define BITP_PORT_DIR_CLR_PX12               12                               /* Port x Bit 12 Direction Clear */
#define BITP_PORT_DIR_CLR_PX11               11                               /* Port x Bit 11 Direction Clear */
#define BITP_PORT_DIR_CLR_PX10               10                               /* Port x Bit 10 Direction Clear */
#define BITP_PORT_DIR_CLR_PX9                 9                               /* Port x Bit 9 Direction Clear */
#define BITP_PORT_DIR_CLR_PX8                 8                               /* Port x Bit 8 Direction Clear */
#define BITP_PORT_DIR_CLR_PX7                 7                               /* Port x Bit 7 Direction Clear */
#define BITP_PORT_DIR_CLR_PX6                 6                               /* Port x Bit 6 Direction Clear */
#define BITP_PORT_DIR_CLR_PX5                 5                               /* Port x Bit 5 Direction Clear */
#define BITP_PORT_DIR_CLR_PX4                 4                               /* Port x Bit 4 Direction Clear */
#define BITP_PORT_DIR_CLR_PX3                 3                               /* Port x Bit 3 Direction Clear */
#define BITP_PORT_DIR_CLR_PX2                 2                               /* Port x Bit 2 Direction Clear */
#define BITP_PORT_DIR_CLR_PX1                 1                               /* Port x Bit 1 Direction Clear */
#define BITP_PORT_DIR_CLR_PX0                 0                               /* Port x Bit 0 Direction Clear */
#define BITM_PORT_DIR_CLR_PX15               (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Direction Clear */
#define BITM_PORT_DIR_CLR_PX14               (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Direction Clear */
#define BITM_PORT_DIR_CLR_PX13               (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Direction Clear */
#define BITM_PORT_DIR_CLR_PX12               (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Direction Clear */
#define BITM_PORT_DIR_CLR_PX11               (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Direction Clear */
#define BITM_PORT_DIR_CLR_PX10               (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Direction Clear */
#define BITM_PORT_DIR_CLR_PX9                (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Direction Clear */
#define BITM_PORT_DIR_CLR_PX8                (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Direction Clear */
#define BITM_PORT_DIR_CLR_PX7                (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Direction Clear */
#define BITM_PORT_DIR_CLR_PX6                (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Direction Clear */
#define BITM_PORT_DIR_CLR_PX5                (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Direction Clear */
#define BITM_PORT_DIR_CLR_PX4                (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Direction Clear */
#define BITM_PORT_DIR_CLR_PX3                (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Direction Clear */
#define BITM_PORT_DIR_CLR_PX2                (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Direction Clear */
#define BITM_PORT_DIR_CLR_PX1                (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Direction Clear */
#define BITM_PORT_DIR_CLR_PX0                (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Direction Clear */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_INEN                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_INEN_PX15                  15                               /* Port x Bit 15 Input Enable */
#define BITP_PORT_INEN_PX14                  14                               /* Port x Bit 14 Input Enable */
#define BITP_PORT_INEN_PX13                  13                               /* Port x Bit 13 Input Enable */
#define BITP_PORT_INEN_PX12                  12                               /* Port x Bit 12 Input Enable */
#define BITP_PORT_INEN_PX11                  11                               /* Port x Bit 11 Input Enable */
#define BITP_PORT_INEN_PX10                  10                               /* Port x Bit 10 Input Enable */
#define BITP_PORT_INEN_PX9                    9                               /* Port x Bit 9 Input Enable */
#define BITP_PORT_INEN_PX8                    8                               /* Port x Bit 8 Input Enable */
#define BITP_PORT_INEN_PX7                    7                               /* Port x Bit 7 Input Enable */
#define BITP_PORT_INEN_PX6                    6                               /* Port x Bit 6 Input Enable */
#define BITP_PORT_INEN_PX5                    5                               /* Port x Bit 5 Input Enable */
#define BITP_PORT_INEN_PX4                    4                               /* Port x Bit 4 Input Enable */
#define BITP_PORT_INEN_PX3                    3                               /* Port x Bit 3 Input Enable */
#define BITP_PORT_INEN_PX2                    2                               /* Port x Bit 2 Input Enable */
#define BITP_PORT_INEN_PX1                    1                               /* Port x Bit 1 Input Enable */
#define BITP_PORT_INEN_PX0                    0                               /* Port x Bit 0 Input Enable */
#define BITM_PORT_INEN_PX15                  (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Input Enable */
#define BITM_PORT_INEN_PX14                  (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Input Enable */
#define BITM_PORT_INEN_PX13                  (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Input Enable */
#define BITM_PORT_INEN_PX12                  (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Input Enable */
#define BITM_PORT_INEN_PX11                  (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Input Enable */
#define BITM_PORT_INEN_PX10                  (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Input Enable */
#define BITM_PORT_INEN_PX9                   (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Input Enable */
#define BITM_PORT_INEN_PX8                   (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Input Enable */
#define BITM_PORT_INEN_PX7                   (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Input Enable */
#define BITM_PORT_INEN_PX6                   (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Input Enable */
#define BITM_PORT_INEN_PX5                   (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Input Enable */
#define BITM_PORT_INEN_PX4                   (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Input Enable */
#define BITM_PORT_INEN_PX3                   (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Input Enable */
#define BITM_PORT_INEN_PX2                   (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Input Enable */
#define BITM_PORT_INEN_PX1                   (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Input Enable */
#define BITM_PORT_INEN_PX0                   (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Input Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_INEN_SET                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_INEN_SET_PX15              15                               /* Port x Bit 15 Input Enable Set */
#define BITP_PORT_INEN_SET_PX14              14                               /* Port x Bit 14 Input Enable Set */
#define BITP_PORT_INEN_SET_PX13              13                               /* Port x Bit 13 Input Enable Set */
#define BITP_PORT_INEN_SET_PX12              12                               /* Port x Bit 12 Input Enable Set */
#define BITP_PORT_INEN_SET_PX11              11                               /* Port x Bit 11 Input Enable Set */
#define BITP_PORT_INEN_SET_PX10              10                               /* Port x Bit 10 Input Enable Set */
#define BITP_PORT_INEN_SET_PX9                9                               /* Port x Bit 9 Input Enable Set */
#define BITP_PORT_INEN_SET_PX8                8                               /* Port x Bit 8 Input Enable Set */
#define BITP_PORT_INEN_SET_PX7                7                               /* Port x Bit 7 Input Enable Set */
#define BITP_PORT_INEN_SET_PX6                6                               /* Port x Bit 6 Input Enable Set */
#define BITP_PORT_INEN_SET_PX5                5                               /* Port x Bit 5 Input Enable Set */
#define BITP_PORT_INEN_SET_PX4                4                               /* Port x Bit 4 Input Enable Set */
#define BITP_PORT_INEN_SET_PX3                3                               /* Port x Bit 3 Input Enable Set */
#define BITP_PORT_INEN_SET_PX2                2                               /* Port x Bit 2 Input Enable Set */
#define BITP_PORT_INEN_SET_PX1                1                               /* Port x Bit 1 Input Enable Set */
#define BITP_PORT_INEN_SET_PX0                0                               /* Port x Bit 0 Input Enable Set */
#define BITM_PORT_INEN_SET_PX15              (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Input Enable Set */
#define BITM_PORT_INEN_SET_PX14              (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Input Enable Set */
#define BITM_PORT_INEN_SET_PX13              (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Input Enable Set */
#define BITM_PORT_INEN_SET_PX12              (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Input Enable Set */
#define BITM_PORT_INEN_SET_PX11              (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Input Enable Set */
#define BITM_PORT_INEN_SET_PX10              (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Input Enable Set */
#define BITM_PORT_INEN_SET_PX9               (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Input Enable Set */
#define BITM_PORT_INEN_SET_PX8               (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Input Enable Set */
#define BITM_PORT_INEN_SET_PX7               (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Input Enable Set */
#define BITM_PORT_INEN_SET_PX6               (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Input Enable Set */
#define BITM_PORT_INEN_SET_PX5               (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Input Enable Set */
#define BITM_PORT_INEN_SET_PX4               (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Input Enable Set */
#define BITM_PORT_INEN_SET_PX3               (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Input Enable Set */
#define BITM_PORT_INEN_SET_PX2               (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Input Enable Set */
#define BITM_PORT_INEN_SET_PX1               (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Input Enable Set */
#define BITM_PORT_INEN_SET_PX0               (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Input Enable Set */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_INEN_CLR                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_INEN_CLR_PX15              15                               /* Port x Bit 15 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX14              14                               /* Port x Bit 14 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX13              13                               /* Port x Bit 13 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX12              12                               /* Port x Bit 12 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX11              11                               /* Port x Bit 11 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX10              10                               /* Port x Bit 10 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX9                9                               /* Port x Bit 9 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX8                8                               /* Port x Bit 8 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX7                7                               /* Port x Bit 7 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX6                6                               /* Port x Bit 6 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX5                5                               /* Port x Bit 5 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX4                4                               /* Port x Bit 4 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX3                3                               /* Port x Bit 3 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX2                2                               /* Port x Bit 2 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX1                1                               /* Port x Bit 1 Input Enable Clear */
#define BITP_PORT_INEN_CLR_PX0                0                               /* Port x Bit 0 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX15              (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX14              (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX13              (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX12              (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX11              (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX10              (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX9               (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX8               (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX7               (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX6               (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX5               (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX4               (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX3               (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX2               (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX1               (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Input Enable Clear */
#define BITM_PORT_INEN_CLR_PX0               (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Input Enable Clear */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_MUX                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_MUX_MUX15                  30                               /* Mux for Port x Bit 15 */
#define BITP_PORT_MUX_MUX14                  28                               /* Mux for Port x Bit 14 */
#define BITP_PORT_MUX_MUX13                  26                               /* Mux for Port x Bit 13 */
#define BITP_PORT_MUX_MUX12                  24                               /* Mux for Port x Bit 12 */
#define BITP_PORT_MUX_MUX11                  22                               /* Mux for Port x Bit 11 */
#define BITP_PORT_MUX_MUX10                  20                               /* Mux for Port x Bit 10 */
#define BITP_PORT_MUX_MUX9                   18                               /* Mux for Port x Bit 9 */
#define BITP_PORT_MUX_MUX8                   16                               /* Mux for Port x Bit 8 */
#define BITP_PORT_MUX_MUX7                   14                               /* Mux for Port x Bit 7 */
#define BITP_PORT_MUX_MUX6                   12                               /* Mux for Port x Bit 6 */
#define BITP_PORT_MUX_MUX5                   10                               /* Mux for Port x Bit 5 */
#define BITP_PORT_MUX_MUX4                    8                               /* Mux for Port x Bit 4 */
#define BITP_PORT_MUX_MUX3                    6                               /* Mux for Port x Bit 3 */
#define BITP_PORT_MUX_MUX2                    4                               /* Mux for Port x Bit 2 */
#define BITP_PORT_MUX_MUX1                    2                               /* Mux for Port x Bit 1 */
#define BITP_PORT_MUX_MUX0                    0                               /* Mux for Port x Bit 0 */
#define BITM_PORT_MUX_MUX15                  (_ADI_MSK(0xC0000000,uint32_t))  /* Mux for Port x Bit 15 */
#define BITM_PORT_MUX_MUX14                  (_ADI_MSK(0x30000000,uint32_t))  /* Mux for Port x Bit 14 */
#define BITM_PORT_MUX_MUX13                  (_ADI_MSK(0x0C000000,uint32_t))  /* Mux for Port x Bit 13 */
#define BITM_PORT_MUX_MUX12                  (_ADI_MSK(0x03000000,uint32_t))  /* Mux for Port x Bit 12 */
#define BITM_PORT_MUX_MUX11                  (_ADI_MSK(0x00C00000,uint32_t))  /* Mux for Port x Bit 11 */
#define BITM_PORT_MUX_MUX10                  (_ADI_MSK(0x00300000,uint32_t))  /* Mux for Port x Bit 10 */
#define BITM_PORT_MUX_MUX9                   (_ADI_MSK(0x000C0000,uint32_t))  /* Mux for Port x Bit 9 */
#define BITM_PORT_MUX_MUX8                   (_ADI_MSK(0x00030000,uint32_t))  /* Mux for Port x Bit 8 */
#define BITM_PORT_MUX_MUX7                   (_ADI_MSK(0x0000C000,uint32_t))  /* Mux for Port x Bit 7 */
#define BITM_PORT_MUX_MUX6                   (_ADI_MSK(0x00003000,uint32_t))  /* Mux for Port x Bit 6 */
#define BITM_PORT_MUX_MUX5                   (_ADI_MSK(0x00000C00,uint32_t))  /* Mux for Port x Bit 5 */
#define BITM_PORT_MUX_MUX4                   (_ADI_MSK(0x00000300,uint32_t))  /* Mux for Port x Bit 4 */
#define BITM_PORT_MUX_MUX3                   (_ADI_MSK(0x000000C0,uint32_t))  /* Mux for Port x Bit 3 */
#define BITM_PORT_MUX_MUX2                   (_ADI_MSK(0x00000030,uint32_t))  /* Mux for Port x Bit 2 */
#define BITM_PORT_MUX_MUX1                   (_ADI_MSK(0x0000000C,uint32_t))  /* Mux for Port x Bit 1 */
#define BITM_PORT_MUX_MUX0                   (_ADI_MSK(0x00000003,uint32_t))  /* Mux for Port x Bit 0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_DATA_TGL                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_DATA_TGL_PX15              15                               /* Port x Bit 15 Toggle */
#define BITP_PORT_DATA_TGL_PX14              14                               /* Port x Bit 14 Toggle */
#define BITP_PORT_DATA_TGL_PX13              13                               /* Port x Bit 13 Toggle */
#define BITP_PORT_DATA_TGL_PX12              12                               /* Port x Bit 12 Toggle */
#define BITP_PORT_DATA_TGL_PX11              11                               /* Port x Bit 11 Toggle */
#define BITP_PORT_DATA_TGL_PX10              10                               /* Port x Bit 10 Toggle */
#define BITP_PORT_DATA_TGL_PX9                9                               /* Port x Bit 9 Toggle */
#define BITP_PORT_DATA_TGL_PX8                8                               /* Port x Bit 8 Toggle */
#define BITP_PORT_DATA_TGL_PX7                7                               /* Port x Bit 7 Toggle */
#define BITP_PORT_DATA_TGL_PX6                6                               /* Port x Bit 6 Toggle */
#define BITP_PORT_DATA_TGL_PX5                5                               /* Port x Bit 5 Toggle */
#define BITP_PORT_DATA_TGL_PX4                4                               /* Port x Bit 4 Toggle */
#define BITP_PORT_DATA_TGL_PX3                3                               /* Port x Bit 3 Toggle */
#define BITP_PORT_DATA_TGL_PX2                2                               /* Port x Bit 2 Toggle */
#define BITP_PORT_DATA_TGL_PX1                1                               /* Port x Bit 1 Toggle */
#define BITP_PORT_DATA_TGL_PX0                0                               /* Port x Bit 0 Toggle */
#define BITM_PORT_DATA_TGL_PX15              (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Toggle */
#define BITM_PORT_DATA_TGL_PX14              (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Toggle */
#define BITM_PORT_DATA_TGL_PX13              (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Toggle */
#define BITM_PORT_DATA_TGL_PX12              (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Toggle */
#define BITM_PORT_DATA_TGL_PX11              (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Toggle */
#define BITM_PORT_DATA_TGL_PX10              (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Toggle */
#define BITM_PORT_DATA_TGL_PX9               (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Toggle */
#define BITM_PORT_DATA_TGL_PX8               (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Toggle */
#define BITM_PORT_DATA_TGL_PX7               (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Toggle */
#define BITM_PORT_DATA_TGL_PX6               (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Toggle */
#define BITM_PORT_DATA_TGL_PX5               (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Toggle */
#define BITM_PORT_DATA_TGL_PX4               (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Toggle */
#define BITM_PORT_DATA_TGL_PX3               (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Toggle */
#define BITM_PORT_DATA_TGL_PX2               (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Toggle */
#define BITM_PORT_DATA_TGL_PX1               (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Toggle */
#define BITM_PORT_DATA_TGL_PX0               (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Toggle */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_POL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_POL_PX15                   15                               /* Port x Bit 15 Polarity Invert */
#define BITP_PORT_POL_PX14                   14                               /* Port x Bit 14 Polarity Invert */
#define BITP_PORT_POL_PX13                   13                               /* Port x Bit 13 Polarity Invert */
#define BITP_PORT_POL_PX12                   12                               /* Port x Bit 12 Polarity Invert */
#define BITP_PORT_POL_PX11                   11                               /* Port x Bit 11 Polarity Invert */
#define BITP_PORT_POL_PX10                   10                               /* Port x Bit 10 Polarity Invert */
#define BITP_PORT_POL_PX9                     9                               /* Port x Bit 9 Polarity Invert */
#define BITP_PORT_POL_PX8                     8                               /* Port x Bit 8 Polarity Invert */
#define BITP_PORT_POL_PX7                     7                               /* Port x Bit 7 Polarity Invert */
#define BITP_PORT_POL_PX6                     6                               /* Port x Bit 6 Polarity Invert */
#define BITP_PORT_POL_PX5                     5                               /* Port x Bit 5 Polarity Invert */
#define BITP_PORT_POL_PX4                     4                               /* Port x Bit 4 Polarity Invert */
#define BITP_PORT_POL_PX3                     3                               /* Port x Bit 3 Polarity Invert */
#define BITP_PORT_POL_PX2                     2                               /* Port x Bit 2 Polarity Invert */
#define BITP_PORT_POL_PX1                     1                               /* Port x Bit 1 Polarity Invert */
#define BITP_PORT_POL_PX0                     0                               /* Port x Bit 0 Polarity Invert */
#define BITM_PORT_POL_PX15                   (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Polarity Invert */
#define BITM_PORT_POL_PX14                   (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Polarity Invert */
#define BITM_PORT_POL_PX13                   (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Polarity Invert */
#define BITM_PORT_POL_PX12                   (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Polarity Invert */
#define BITM_PORT_POL_PX11                   (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Polarity Invert */
#define BITM_PORT_POL_PX10                   (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Polarity Invert */
#define BITM_PORT_POL_PX9                    (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Polarity Invert */
#define BITM_PORT_POL_PX8                    (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Polarity Invert */
#define BITM_PORT_POL_PX7                    (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Polarity Invert */
#define BITM_PORT_POL_PX6                    (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Polarity Invert */
#define BITM_PORT_POL_PX5                    (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Polarity Invert */
#define BITM_PORT_POL_PX4                    (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Polarity Invert */
#define BITM_PORT_POL_PX3                    (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Polarity Invert */
#define BITM_PORT_POL_PX2                    (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Polarity Invert */
#define BITM_PORT_POL_PX1                    (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Polarity Invert */
#define BITM_PORT_POL_PX0                    (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Polarity Invert */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_POL_SET                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_POL_SET_PX15               15                               /* Port x Bit 15 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX14               14                               /* Port x Bit 14 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX13               13                               /* Port x Bit 13 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX12               12                               /* Port x Bit 12 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX11               11                               /* Port x Bit 11 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX10               10                               /* Port x Bit 10 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX9                 9                               /* Port x Bit 9 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX8                 8                               /* Port x Bit 8 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX7                 7                               /* Port x Bit 7 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX6                 6                               /* Port x Bit 6 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX5                 5                               /* Port x Bit 5 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX4                 4                               /* Port x Bit 4 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX3                 3                               /* Port x Bit 3 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX2                 2                               /* Port x Bit 2 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX1                 1                               /* Port x Bit 1 Polarity Invert Set */
#define BITP_PORT_POL_SET_PX0                 0                               /* Port x Bit 0 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX15               (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX14               (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX13               (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX12               (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX11               (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX10               (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX9                (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX8                (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX7                (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX6                (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX5                (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX4                (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX3                (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX2                (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX1                (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Polarity Invert Set */
#define BITM_PORT_POL_SET_PX0                (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Polarity Invert Set */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_POL_CLR                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_POL_CLR_PX15               15                               /* Port x Bit 15 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX14               14                               /* Port x Bit 14 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX13               13                               /* Port x Bit 13 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX12               12                               /* Port x Bit 12 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX11               11                               /* Port x Bit 11 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX10               10                               /* Port x Bit 10 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX9                 9                               /* Port x Bit 9 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX8                 8                               /* Port x Bit 8 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX7                 7                               /* Port x Bit 7 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX6                 6                               /* Port x Bit 6 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX5                 5                               /* Port x Bit 5 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX4                 4                               /* Port x Bit 4 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX3                 3                               /* Port x Bit 3 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX2                 2                               /* Port x Bit 2 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX1                 1                               /* Port x Bit 1 Polarity Invert Clear */
#define BITP_PORT_POL_CLR_PX0                 0                               /* Port x Bit 0 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX15               (_ADI_MSK(0x00008000,uint32_t))  /* Port x Bit 15 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX14               (_ADI_MSK(0x00004000,uint32_t))  /* Port x Bit 14 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX13               (_ADI_MSK(0x00002000,uint32_t))  /* Port x Bit 13 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX12               (_ADI_MSK(0x00001000,uint32_t))  /* Port x Bit 12 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX11               (_ADI_MSK(0x00000800,uint32_t))  /* Port x Bit 11 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX10               (_ADI_MSK(0x00000400,uint32_t))  /* Port x Bit 10 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX9                (_ADI_MSK(0x00000200,uint32_t))  /* Port x Bit 9 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX8                (_ADI_MSK(0x00000100,uint32_t))  /* Port x Bit 8 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX7                (_ADI_MSK(0x00000080,uint32_t))  /* Port x Bit 7 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX6                (_ADI_MSK(0x00000040,uint32_t))  /* Port x Bit 6 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX5                (_ADI_MSK(0x00000020,uint32_t))  /* Port x Bit 5 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX4                (_ADI_MSK(0x00000010,uint32_t))  /* Port x Bit 4 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX3                (_ADI_MSK(0x00000008,uint32_t))  /* Port x Bit 3 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX2                (_ADI_MSK(0x00000004,uint32_t))  /* Port x Bit 2 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX1                (_ADI_MSK(0x00000002,uint32_t))  /* Port x Bit 1 Polarity Invert Clear */
#define BITM_PORT_POL_CLR_PX0                (_ADI_MSK(0x00000001,uint32_t))  /* Port x Bit 0 Polarity Invert Clear */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_LOCK                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_LOCK_LOCK                  31                               /* Lock */
#define BITP_PORT_LOCK_POLAR                  5                               /* Polarity Lock */
#define BITP_PORT_LOCK_INEN                   4                               /* Input Enable Lock */
#define BITP_PORT_LOCK_DIR                    3                               /* Direction Lock */
#define BITP_PORT_LOCK_DATA                   2                               /* Data Lock */
#define BITP_PORT_LOCK_MUX                    1                               /* Function Multiplexer Lock */
#define BITP_PORT_LOCK_FER                    0                               /* Function Enable Lock */
#define BITM_PORT_LOCK_LOCK                  (_ADI_MSK(0x80000000,uint32_t))  /* Lock */
#define BITM_PORT_LOCK_POLAR                 (_ADI_MSK(0x00000020,uint32_t))  /* Polarity Lock */
#define BITM_PORT_LOCK_INEN                  (_ADI_MSK(0x00000010,uint32_t))  /* Input Enable Lock */
#define BITM_PORT_LOCK_DIR                   (_ADI_MSK(0x00000008,uint32_t))  /* Direction Lock */
#define BITM_PORT_LOCK_DATA                  (_ADI_MSK(0x00000004,uint32_t))  /* Data Lock */
#define BITM_PORT_LOCK_MUX                   (_ADI_MSK(0x00000002,uint32_t))  /* Function Multiplexer Lock */
#define BITM_PORT_LOCK_FER                   (_ADI_MSK(0x00000001,uint32_t))  /* Function Enable Lock */

/* ------------------------------------------------------------------------------------------------------------------------
        PORT_REVID                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PORT_REVID_MAJOR                 4                               /* Major ID */
#define BITP_PORT_REVID_REV                   0                               /* Revision ID */
#define BITM_PORT_REVID_MAJOR                (_ADI_MSK(0x000000F0,uint32_t))  /* Major ID */
#define BITM_PORT_REVID_REV                  (_ADI_MSK(0x0000000F,uint32_t))  /* Revision ID */

/* ==================================================
        Pads Controller Registers
   ================================================== */

/* =========================
        PADS0
   ========================= */
#define REG_PADS0_EMAC_PTP_CLKSEL       0xFFC03404         /* PADS0 Clock Selection for EMAC and PTP */
#define REG_PADS0_TWI_VSEL              0xFFC03408         /* PADS0 TWI Voltage Selection */
#define REG_PADS0_PORTS_HYST            0xFFC03440         /* PADS0 Hysteresis Enable Register */

/* =========================
        PADS
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        PADS_EMAC_PTP_CLKSEL                 Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PADS_EMAC_PTP_CLKSEL_EMAC1       2                               /* Select Clock Source for PTP Block in EMAC1 */
#define BITP_PADS_EMAC_PTP_CLKSEL_EMAC0       0                               /* PTP Clock Source 0 */
#define BITM_PADS_EMAC_PTP_CLKSEL_EMAC1      (_ADI_MSK(0x0000000C,uint32_t))  /* Select Clock Source for PTP Block in EMAC1 */
#define BITM_PADS_EMAC_PTP_CLKSEL_EMAC0      (_ADI_MSK(0x00000003,uint32_t))  /* PTP Clock Source 0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PADS_TWI_VSEL                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PADS_TWI_VSEL_TWI1               4                               /* TWI Voltage Select 1 */
#define BITP_PADS_TWI_VSEL_TWI0               0                               /* TWI Voltage Select 0 */
#define BITM_PADS_TWI_VSEL_TWI1              (_ADI_MSK(0x00000070,uint32_t))  /* TWI Voltage Select 1 */
#define BITM_PADS_TWI_VSEL_TWI0              (_ADI_MSK(0x00000007,uint32_t))  /* TWI Voltage Select 0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PADS_PORTS_HYST                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PADS_PORTS_HYST_G                6                               /* Port G Hysteresis */
#define BITP_PADS_PORTS_HYST_F                5                               /* Port F Hysteresis */
#define BITP_PADS_PORTS_HYST_E                4                               /* Port E Hysteresis */
#define BITP_PADS_PORTS_HYST_D                3                               /* Port D Hysteresis */
#define BITP_PADS_PORTS_HYST_C                2                               /* Port C Hysteresis */
#define BITP_PADS_PORTS_HYST_B                1                               /* Port B Hysteresis */
#define BITP_PADS_PORTS_HYST_A                0                               /* Port A Hysteresis */
#define BITM_PADS_PORTS_HYST_G               (_ADI_MSK(0x00000040,uint32_t))  /* Port G Hysteresis */
#define BITM_PADS_PORTS_HYST_F               (_ADI_MSK(0x00000020,uint32_t))  /* Port F Hysteresis */
#define BITM_PADS_PORTS_HYST_E               (_ADI_MSK(0x00000010,uint32_t))  /* Port E Hysteresis */
#define BITM_PADS_PORTS_HYST_D               (_ADI_MSK(0x00000008,uint32_t))  /* Port D Hysteresis */
#define BITM_PADS_PORTS_HYST_C               (_ADI_MSK(0x00000004,uint32_t))  /* Port C Hysteresis */
#define BITM_PADS_PORTS_HYST_B               (_ADI_MSK(0x00000002,uint32_t))  /* Port B Hysteresis */
#define BITM_PADS_PORTS_HYST_A               (_ADI_MSK(0x00000001,uint32_t))  /* Port A Hysteresis */

/* ==================================================
        PINT Registers
   ================================================== */

/* =========================
        PINT0
   ========================= */
#define REG_PINT0_MSK_SET               0xFFC04000         /* PINT0 Pint Mask Set Register */
#define REG_PINT0_MSK_CLR               0xFFC04004         /* PINT0 Pint Mask Clear Register */
#define REG_PINT0_REQ                   0xFFC04008         /* PINT0 Pint Request Register */
#define REG_PINT0_ASSIGN                0xFFC0400C         /* PINT0 Pint Assign Register */
#define REG_PINT0_EDGE_SET              0xFFC04010         /* PINT0 Pint Edge Set Register */
#define REG_PINT0_EDGE_CLR              0xFFC04014         /* PINT0 Pint Edge Clear Register */
#define REG_PINT0_INV_SET               0xFFC04018         /* PINT0 Pint Invert Set Register */
#define REG_PINT0_INV_CLR               0xFFC0401C         /* PINT0 Pint Invert Clear Register */
#define REG_PINT0_PINSTATE              0xFFC04020         /* PINT0 Pint Pinstate Register */
#define REG_PINT0_LATCH                 0xFFC04024         /* PINT0 Pint Latch Register */

/* =========================
        PINT1
   ========================= */
#define REG_PINT1_MSK_SET               0xFFC04100         /* PINT1 Pint Mask Set Register */
#define REG_PINT1_MSK_CLR               0xFFC04104         /* PINT1 Pint Mask Clear Register */
#define REG_PINT1_REQ                   0xFFC04108         /* PINT1 Pint Request Register */
#define REG_PINT1_ASSIGN                0xFFC0410C         /* PINT1 Pint Assign Register */
#define REG_PINT1_EDGE_SET              0xFFC04110         /* PINT1 Pint Edge Set Register */
#define REG_PINT1_EDGE_CLR              0xFFC04114         /* PINT1 Pint Edge Clear Register */
#define REG_PINT1_INV_SET               0xFFC04118         /* PINT1 Pint Invert Set Register */
#define REG_PINT1_INV_CLR               0xFFC0411C         /* PINT1 Pint Invert Clear Register */
#define REG_PINT1_PINSTATE              0xFFC04120         /* PINT1 Pint Pinstate Register */
#define REG_PINT1_LATCH                 0xFFC04124         /* PINT1 Pint Latch Register */

/* =========================
        PINT2
   ========================= */
#define REG_PINT2_MSK_SET               0xFFC04200         /* PINT2 Pint Mask Set Register */
#define REG_PINT2_MSK_CLR               0xFFC04204         /* PINT2 Pint Mask Clear Register */
#define REG_PINT2_REQ                   0xFFC04208         /* PINT2 Pint Request Register */
#define REG_PINT2_ASSIGN                0xFFC0420C         /* PINT2 Pint Assign Register */
#define REG_PINT2_EDGE_SET              0xFFC04210         /* PINT2 Pint Edge Set Register */
#define REG_PINT2_EDGE_CLR              0xFFC04214         /* PINT2 Pint Edge Clear Register */
#define REG_PINT2_INV_SET               0xFFC04218         /* PINT2 Pint Invert Set Register */
#define REG_PINT2_INV_CLR               0xFFC0421C         /* PINT2 Pint Invert Clear Register */
#define REG_PINT2_PINSTATE              0xFFC04220         /* PINT2 Pint Pinstate Register */
#define REG_PINT2_LATCH                 0xFFC04224         /* PINT2 Pint Latch Register */

/* =========================
        PINT3
   ========================= */
#define REG_PINT3_MSK_SET               0xFFC04300         /* PINT3 Pint Mask Set Register */
#define REG_PINT3_MSK_CLR               0xFFC04304         /* PINT3 Pint Mask Clear Register */
#define REG_PINT3_REQ                   0xFFC04308         /* PINT3 Pint Request Register */
#define REG_PINT3_ASSIGN                0xFFC0430C         /* PINT3 Pint Assign Register */
#define REG_PINT3_EDGE_SET              0xFFC04310         /* PINT3 Pint Edge Set Register */
#define REG_PINT3_EDGE_CLR              0xFFC04314         /* PINT3 Pint Edge Clear Register */
#define REG_PINT3_INV_SET               0xFFC04318         /* PINT3 Pint Invert Set Register */
#define REG_PINT3_INV_CLR               0xFFC0431C         /* PINT3 Pint Invert Clear Register */
#define REG_PINT3_PINSTATE              0xFFC04320         /* PINT3 Pint Pinstate Register */
#define REG_PINT3_LATCH                 0xFFC04324         /* PINT3 Pint Latch Register */

/* =========================
        PINT4
   ========================= */
#define REG_PINT4_MSK_SET               0xFFC04400         /* PINT4 Pint Mask Set Register */
#define REG_PINT4_MSK_CLR               0xFFC04404         /* PINT4 Pint Mask Clear Register */
#define REG_PINT4_REQ                   0xFFC04408         /* PINT4 Pint Request Register */
#define REG_PINT4_ASSIGN                0xFFC0440C         /* PINT4 Pint Assign Register */
#define REG_PINT4_EDGE_SET              0xFFC04410         /* PINT4 Pint Edge Set Register */
#define REG_PINT4_EDGE_CLR              0xFFC04414         /* PINT4 Pint Edge Clear Register */
#define REG_PINT4_INV_SET               0xFFC04418         /* PINT4 Pint Invert Set Register */
#define REG_PINT4_INV_CLR               0xFFC0441C         /* PINT4 Pint Invert Clear Register */
#define REG_PINT4_PINSTATE              0xFFC04420         /* PINT4 Pint Pinstate Register */
#define REG_PINT4_LATCH                 0xFFC04424         /* PINT4 Pint Latch Register */

/* =========================
        PINT5
   ========================= */
#define REG_PINT5_MSK_SET               0xFFC04500         /* PINT5 Pint Mask Set Register */
#define REG_PINT5_MSK_CLR               0xFFC04504         /* PINT5 Pint Mask Clear Register */
#define REG_PINT5_REQ                   0xFFC04508         /* PINT5 Pint Request Register */
#define REG_PINT5_ASSIGN                0xFFC0450C         /* PINT5 Pint Assign Register */
#define REG_PINT5_EDGE_SET              0xFFC04510         /* PINT5 Pint Edge Set Register */
#define REG_PINT5_EDGE_CLR              0xFFC04514         /* PINT5 Pint Edge Clear Register */
#define REG_PINT5_INV_SET               0xFFC04518         /* PINT5 Pint Invert Set Register */
#define REG_PINT5_INV_CLR               0xFFC0451C         /* PINT5 Pint Invert Clear Register */
#define REG_PINT5_PINSTATE              0xFFC04520         /* PINT5 Pint Pinstate Register */
#define REG_PINT5_LATCH                 0xFFC04524         /* PINT5 Pint Latch Register */

/* =========================
        PINT
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        PINT_MSK_SET                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_MSK_SET_PIQ31              31                               /* Pin Interrupt 31 Unmask */
#define BITP_PINT_MSK_SET_PIQ30              30                               /* Pin Interrupt 30 Unmask */
#define BITP_PINT_MSK_SET_PIQ29              29                               /* Pin Interrupt 29 Unmask */
#define BITP_PINT_MSK_SET_PIQ28              28                               /* Pin Interrupt 28 Unmask */
#define BITP_PINT_MSK_SET_PIQ27              27                               /* Pin Interrupt 27 Unmask */
#define BITP_PINT_MSK_SET_PIQ26              26                               /* Pin Interrupt 26 Unmask */
#define BITP_PINT_MSK_SET_PIQ25              25                               /* Pin Interrupt 25 Unmask */
#define BITP_PINT_MSK_SET_PIQ24              24                               /* Pin Interrupt 24 Unmask */
#define BITP_PINT_MSK_SET_PIQ23              23                               /* Pin Interrupt 23 Unmask */
#define BITP_PINT_MSK_SET_PIQ22              22                               /* Pin Interrupt 22 Unmask */
#define BITP_PINT_MSK_SET_PIQ21              21                               /* Pin Interrupt 21 Unmask */
#define BITP_PINT_MSK_SET_PIQ20              20                               /* Pin Interrupt 20 Unmask */
#define BITP_PINT_MSK_SET_PIQ19              19                               /* Pin Interrupt 19 Unmask */
#define BITP_PINT_MSK_SET_PIQ18              18                               /* Pin Interrupt 18 Unmask */
#define BITP_PINT_MSK_SET_PIQ17              17                               /* Pin Interrupt 17 Unmask */
#define BITP_PINT_MSK_SET_PIQ16              16                               /* Pin Interrupt 16 Unmask */
#define BITP_PINT_MSK_SET_PIQ15              15                               /* Pin Interrupt 15 Unmask */
#define BITP_PINT_MSK_SET_PIQ14              14                               /* Pin Interrupt 14 Unmask */
#define BITP_PINT_MSK_SET_PIQ13              13                               /* Pin Interrupt 13 Unmask */
#define BITP_PINT_MSK_SET_PIQ12              12                               /* Pin Interrupt 12 Unmask */
#define BITP_PINT_MSK_SET_PIQ11              11                               /* Pin Interrupt 11 Unmask */
#define BITP_PINT_MSK_SET_PIQ10              10                               /* Pin Interrupt 10 Unmask */
#define BITP_PINT_MSK_SET_PIQ9                9                               /* Pin Interrupt 9 Unmask */
#define BITP_PINT_MSK_SET_PIQ8                8                               /* Pin Interrupt 8 Unmask */
#define BITP_PINT_MSK_SET_PIQ7                7                               /* Pin Interrupt 7 Unmask */
#define BITP_PINT_MSK_SET_PIQ6                6                               /* Pin Interrupt 6 Unmask */
#define BITP_PINT_MSK_SET_PIQ5                5                               /* Pin Interrupt 5 Unmask */
#define BITP_PINT_MSK_SET_PIQ4                4                               /* Pin Interrupt 4 Unmask */
#define BITP_PINT_MSK_SET_PIQ3                3                               /* Pin Interrupt 3 Unmask */
#define BITP_PINT_MSK_SET_PIQ2                2                               /* Pin Interrupt 2 Unmask */
#define BITP_PINT_MSK_SET_PIQ1                1                               /* Pin Interrupt 1 Unmask */
#define BITP_PINT_MSK_SET_PIQ0                0                               /* Pin Interrupt 0 Unmask */
#define BITM_PINT_MSK_SET_PIQ31              (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 Unmask */
#define BITM_PINT_MSK_SET_PIQ30              (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 Unmask */
#define BITM_PINT_MSK_SET_PIQ29              (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 Unmask */
#define BITM_PINT_MSK_SET_PIQ28              (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 Unmask */
#define BITM_PINT_MSK_SET_PIQ27              (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 Unmask */
#define BITM_PINT_MSK_SET_PIQ26              (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 Unmask */
#define BITM_PINT_MSK_SET_PIQ25              (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 Unmask */
#define BITM_PINT_MSK_SET_PIQ24              (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 Unmask */
#define BITM_PINT_MSK_SET_PIQ23              (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 Unmask */
#define BITM_PINT_MSK_SET_PIQ22              (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 Unmask */
#define BITM_PINT_MSK_SET_PIQ21              (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 Unmask */
#define BITM_PINT_MSK_SET_PIQ20              (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 Unmask */
#define BITM_PINT_MSK_SET_PIQ19              (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 Unmask */
#define BITM_PINT_MSK_SET_PIQ18              (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 Unmask */
#define BITM_PINT_MSK_SET_PIQ17              (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 Unmask */
#define BITM_PINT_MSK_SET_PIQ16              (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 Unmask */
#define BITM_PINT_MSK_SET_PIQ15              (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 Unmask */
#define BITM_PINT_MSK_SET_PIQ14              (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 Unmask */
#define BITM_PINT_MSK_SET_PIQ13              (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 Unmask */
#define BITM_PINT_MSK_SET_PIQ12              (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 Unmask */
#define BITM_PINT_MSK_SET_PIQ11              (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 Unmask */
#define BITM_PINT_MSK_SET_PIQ10              (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 Unmask */
#define BITM_PINT_MSK_SET_PIQ9               (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 Unmask */
#define BITM_PINT_MSK_SET_PIQ8               (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 Unmask */
#define BITM_PINT_MSK_SET_PIQ7               (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 Unmask */
#define BITM_PINT_MSK_SET_PIQ6               (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 Unmask */
#define BITM_PINT_MSK_SET_PIQ5               (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 Unmask */
#define BITM_PINT_MSK_SET_PIQ4               (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 Unmask */
#define BITM_PINT_MSK_SET_PIQ3               (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 Unmask */
#define BITM_PINT_MSK_SET_PIQ2               (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 Unmask */
#define BITM_PINT_MSK_SET_PIQ1               (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 Unmask */
#define BITM_PINT_MSK_SET_PIQ0               (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 Unmask */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_MSK_CLR                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_MSK_CLR_PIQ31              31                               /* Pin Interrupt 31 Mask */
#define BITP_PINT_MSK_CLR_PIQ30              30                               /* Pin Interrupt 30 Mask */
#define BITP_PINT_MSK_CLR_PIQ29              29                               /* Pin Interrupt 29 Mask */
#define BITP_PINT_MSK_CLR_PIQ28              28                               /* Pin Interrupt 28 Mask */
#define BITP_PINT_MSK_CLR_PIQ27              27                               /* Pin Interrupt 27 Mask */
#define BITP_PINT_MSK_CLR_PIQ26              26                               /* Pin Interrupt 26 Mask */
#define BITP_PINT_MSK_CLR_PIQ25              25                               /* Pin Interrupt 25 Mask */
#define BITP_PINT_MSK_CLR_PIQ24              24                               /* Pin Interrupt 24 Mask */
#define BITP_PINT_MSK_CLR_PIQ23              23                               /* Pin Interrupt 23 Mask */
#define BITP_PINT_MSK_CLR_PIQ22              22                               /* Pin Interrupt 22 Mask */
#define BITP_PINT_MSK_CLR_PIQ21              21                               /* Pin Interrupt 21 Mask */
#define BITP_PINT_MSK_CLR_PIQ20              20                               /* Pin Interrupt 20 Mask */
#define BITP_PINT_MSK_CLR_PIQ19              19                               /* Pin Interrupt 19 Mask */
#define BITP_PINT_MSK_CLR_PIQ18              18                               /* Pin Interrupt 18 Mask */
#define BITP_PINT_MSK_CLR_PIQ17              17                               /* Pin Interrupt 17 Mask */
#define BITP_PINT_MSK_CLR_PIQ16              16                               /* Pin Interrupt 16 Mask */
#define BITP_PINT_MSK_CLR_PIQ15              15                               /* Pin Interrupt 15 Mask */
#define BITP_PINT_MSK_CLR_PIQ14              14                               /* Pin Interrupt 14 Mask */
#define BITP_PINT_MSK_CLR_PIQ13              13                               /* Pin Interrupt 13 Mask */
#define BITP_PINT_MSK_CLR_PIQ12              12                               /* Pin Interrupt 12 Mask */
#define BITP_PINT_MSK_CLR_PIQ11              11                               /* Pin Interrupt 11 Mask */
#define BITP_PINT_MSK_CLR_PIQ10              10                               /* Pin Interrupt 10 Mask */
#define BITP_PINT_MSK_CLR_PIQ9                9                               /* Pin Interrupt 9 Mask */
#define BITP_PINT_MSK_CLR_PIQ8                8                               /* Pin Interrupt 8 Mask */
#define BITP_PINT_MSK_CLR_PIQ7                7                               /* Pin Interrupt 7 Mask */
#define BITP_PINT_MSK_CLR_PIQ6                6                               /* Pin Interrupt 6 Mask */
#define BITP_PINT_MSK_CLR_PIQ5                5                               /* Pin Interrupt 5 Mask */
#define BITP_PINT_MSK_CLR_PIQ4                4                               /* Pin Interrupt 4 Mask */
#define BITP_PINT_MSK_CLR_PIQ3                3                               /* Pin Interrupt 3 Mask */
#define BITP_PINT_MSK_CLR_PIQ2                2                               /* Pin Interrupt 2 Mask */
#define BITP_PINT_MSK_CLR_PIQ1                1                               /* Pin Interrupt 1 Mask */
#define BITP_PINT_MSK_CLR_PIQ0                0                               /* Pin Interrupt 0 Mask */
#define BITM_PINT_MSK_CLR_PIQ31              (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 Mask */
#define BITM_PINT_MSK_CLR_PIQ30              (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 Mask */
#define BITM_PINT_MSK_CLR_PIQ29              (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 Mask */
#define BITM_PINT_MSK_CLR_PIQ28              (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 Mask */
#define BITM_PINT_MSK_CLR_PIQ27              (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 Mask */
#define BITM_PINT_MSK_CLR_PIQ26              (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 Mask */
#define BITM_PINT_MSK_CLR_PIQ25              (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 Mask */
#define BITM_PINT_MSK_CLR_PIQ24              (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 Mask */
#define BITM_PINT_MSK_CLR_PIQ23              (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 Mask */
#define BITM_PINT_MSK_CLR_PIQ22              (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 Mask */
#define BITM_PINT_MSK_CLR_PIQ21              (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 Mask */
#define BITM_PINT_MSK_CLR_PIQ20              (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 Mask */
#define BITM_PINT_MSK_CLR_PIQ19              (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 Mask */
#define BITM_PINT_MSK_CLR_PIQ18              (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 Mask */
#define BITM_PINT_MSK_CLR_PIQ17              (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 Mask */
#define BITM_PINT_MSK_CLR_PIQ16              (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 Mask */
#define BITM_PINT_MSK_CLR_PIQ15              (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 Mask */
#define BITM_PINT_MSK_CLR_PIQ14              (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 Mask */
#define BITM_PINT_MSK_CLR_PIQ13              (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 Mask */
#define BITM_PINT_MSK_CLR_PIQ12              (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 Mask */
#define BITM_PINT_MSK_CLR_PIQ11              (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 Mask */
#define BITM_PINT_MSK_CLR_PIQ10              (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 Mask */
#define BITM_PINT_MSK_CLR_PIQ9               (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 Mask */
#define BITM_PINT_MSK_CLR_PIQ8               (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 Mask */
#define BITM_PINT_MSK_CLR_PIQ7               (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 Mask */
#define BITM_PINT_MSK_CLR_PIQ6               (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 Mask */
#define BITM_PINT_MSK_CLR_PIQ5               (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 Mask */
#define BITM_PINT_MSK_CLR_PIQ4               (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 Mask */
#define BITM_PINT_MSK_CLR_PIQ3               (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 Mask */
#define BITM_PINT_MSK_CLR_PIQ2               (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 Mask */
#define BITM_PINT_MSK_CLR_PIQ1               (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 Mask */
#define BITM_PINT_MSK_CLR_PIQ0               (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_REQ                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_REQ_PIQ31                  31                               /* Pin Interrupt 31 Request */
#define BITP_PINT_REQ_PIQ30                  30                               /* Pin Interrupt 30 Request */
#define BITP_PINT_REQ_PIQ29                  29                               /* Pin Interrupt 29 Request */
#define BITP_PINT_REQ_PIQ28                  28                               /* Pin Interrupt 28 Request */
#define BITP_PINT_REQ_PIQ27                  27                               /* Pin Interrupt 27 Request */
#define BITP_PINT_REQ_PIQ26                  26                               /* Pin Interrupt 26 Request */
#define BITP_PINT_REQ_PIQ25                  25                               /* Pin Interrupt 25 Request */
#define BITP_PINT_REQ_PIQ24                  24                               /* Pin Interrupt 24 Request */
#define BITP_PINT_REQ_PIQ23                  23                               /* Pin Interrupt 23 Request */
#define BITP_PINT_REQ_PIQ22                  22                               /* Pin Interrupt 22 Request */
#define BITP_PINT_REQ_PIQ21                  21                               /* Pin Interrupt 21 Request */
#define BITP_PINT_REQ_PIQ20                  20                               /* Pin Interrupt 20 Request */
#define BITP_PINT_REQ_PIQ19                  19                               /* Pin Interrupt 19 Request */
#define BITP_PINT_REQ_PIQ18                  18                               /* Pin Interrupt 18 Request */
#define BITP_PINT_REQ_PIQ17                  17                               /* Pin Interrupt 17 Request */
#define BITP_PINT_REQ_PIQ16                  16                               /* Pin Interrupt 16 Request */
#define BITP_PINT_REQ_PIQ15                  15                               /* Pin Interrupt 15 Request */
#define BITP_PINT_REQ_PIQ14                  14                               /* Pin Interrupt 14 Request */
#define BITP_PINT_REQ_PIQ13                  13                               /* Pin Interrupt 13 Request */
#define BITP_PINT_REQ_PIQ12                  12                               /* Pin Interrupt 12 Request */
#define BITP_PINT_REQ_PIQ11                  11                               /* Pin Interrupt 11 Request */
#define BITP_PINT_REQ_PIQ10                  10                               /* Pin Interrupt 10 Request */
#define BITP_PINT_REQ_PIQ9                    9                               /* Pin Interrupt 9 Request */
#define BITP_PINT_REQ_PIQ8                    8                               /* Pin Interrupt 8 Request */
#define BITP_PINT_REQ_PIQ7                    7                               /* Pin Interrupt 7 Request */
#define BITP_PINT_REQ_PIQ6                    6                               /* Pin Interrupt 6 Request */
#define BITP_PINT_REQ_PIQ5                    5                               /* Pin Interrupt 5 Request */
#define BITP_PINT_REQ_PIQ4                    4                               /* Pin Interrupt 4 Request */
#define BITP_PINT_REQ_PIQ3                    3                               /* Pin Interrupt 3 Request */
#define BITP_PINT_REQ_PIQ2                    2                               /* Pin Interrupt 2 Request */
#define BITP_PINT_REQ_PIQ1                    1                               /* Pin Interrupt 1 Request */
#define BITP_PINT_REQ_PIQ0                    0                               /* Pin Interrupt 0 Request */
#define BITM_PINT_REQ_PIQ31                  (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 Request */
#define BITM_PINT_REQ_PIQ30                  (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 Request */
#define BITM_PINT_REQ_PIQ29                  (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 Request */
#define BITM_PINT_REQ_PIQ28                  (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 Request */
#define BITM_PINT_REQ_PIQ27                  (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 Request */
#define BITM_PINT_REQ_PIQ26                  (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 Request */
#define BITM_PINT_REQ_PIQ25                  (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 Request */
#define BITM_PINT_REQ_PIQ24                  (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 Request */
#define BITM_PINT_REQ_PIQ23                  (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 Request */
#define BITM_PINT_REQ_PIQ22                  (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 Request */
#define BITM_PINT_REQ_PIQ21                  (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 Request */
#define BITM_PINT_REQ_PIQ20                  (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 Request */
#define BITM_PINT_REQ_PIQ19                  (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 Request */
#define BITM_PINT_REQ_PIQ18                  (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 Request */
#define BITM_PINT_REQ_PIQ17                  (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 Request */
#define BITM_PINT_REQ_PIQ16                  (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 Request */
#define BITM_PINT_REQ_PIQ15                  (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 Request */
#define BITM_PINT_REQ_PIQ14                  (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 Request */
#define BITM_PINT_REQ_PIQ13                  (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 Request */
#define BITM_PINT_REQ_PIQ12                  (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 Request */
#define BITM_PINT_REQ_PIQ11                  (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 Request */
#define BITM_PINT_REQ_PIQ10                  (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 Request */
#define BITM_PINT_REQ_PIQ9                   (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 Request */
#define BITM_PINT_REQ_PIQ8                   (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 Request */
#define BITM_PINT_REQ_PIQ7                   (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 Request */
#define BITM_PINT_REQ_PIQ6                   (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 Request */
#define BITM_PINT_REQ_PIQ5                   (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 Request */
#define BITM_PINT_REQ_PIQ4                   (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 Request */
#define BITM_PINT_REQ_PIQ3                   (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 Request */
#define BITM_PINT_REQ_PIQ2                   (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 Request */
#define BITM_PINT_REQ_PIQ1                   (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 Request */
#define BITM_PINT_REQ_PIQ0                   (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 Request */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_ASSIGN                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_ASSIGN_B3MAP               24                               /* Byte 3 Mapping */
#define BITP_PINT_ASSIGN_B2MAP               16                               /* Byte 2 Mapping */
#define BITP_PINT_ASSIGN_B1MAP                8                               /* Byte 1 Mapping */
#define BITP_PINT_ASSIGN_B0MAP                0                               /* Byte 0 Mapping */
#define BITM_PINT_ASSIGN_B3MAP               (_ADI_MSK(0xFF000000,uint32_t))  /* Byte 3 Mapping */
#define BITM_PINT_ASSIGN_B2MAP               (_ADI_MSK(0x00FF0000,uint32_t))  /* Byte 2 Mapping */
#define BITM_PINT_ASSIGN_B1MAP               (_ADI_MSK(0x0000FF00,uint32_t))  /* Byte 1 Mapping */
#define BITM_PINT_ASSIGN_B0MAP               (_ADI_MSK(0x000000FF,uint32_t))  /* Byte 0 Mapping */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_EDGE_SET                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_EDGE_SET_PIQ31             31                               /* Pin Interrupt 31 Edge */
#define BITP_PINT_EDGE_SET_PIQ30             30                               /* Pin Interrupt 30 Edge */
#define BITP_PINT_EDGE_SET_PIQ29             29                               /* Pin Interrupt 29 Edge */
#define BITP_PINT_EDGE_SET_PIQ28             28                               /* Pin Interrupt 28 Edge */
#define BITP_PINT_EDGE_SET_PIQ27             27                               /* Pin Interrupt 27 Edge */
#define BITP_PINT_EDGE_SET_PIQ26             26                               /* Pin Interrupt 26 Edge */
#define BITP_PINT_EDGE_SET_PIQ25             25                               /* Pin Interrupt 25 Edge */
#define BITP_PINT_EDGE_SET_PIQ24             24                               /* Pin Interrupt 24 Edge */
#define BITP_PINT_EDGE_SET_PIQ23             23                               /* Pin Interrupt 23 Edge */
#define BITP_PINT_EDGE_SET_PIQ22             22                               /* Pin Interrupt 22 Edge */
#define BITP_PINT_EDGE_SET_PIQ21             21                               /* Pin Interrupt 21 Edge */
#define BITP_PINT_EDGE_SET_PIQ20             20                               /* Pin Interrupt 20 Edge */
#define BITP_PINT_EDGE_SET_PIQ19             19                               /* Pin Interrupt 19 Edge */
#define BITP_PINT_EDGE_SET_PIQ18             18                               /* Pin Interrupt 18 Edge */
#define BITP_PINT_EDGE_SET_PIQ17             17                               /* Pin Interrupt 17 Edge */
#define BITP_PINT_EDGE_SET_PIQ16             16                               /* Pin Interrupt 16 Edge */
#define BITP_PINT_EDGE_SET_PIQ15             15                               /* Pin Interrupt 15 Edge */
#define BITP_PINT_EDGE_SET_PIQ14             14                               /* Pin Interrupt 14 Edge */
#define BITP_PINT_EDGE_SET_PIQ13             13                               /* Pin Interrupt 13 Edge */
#define BITP_PINT_EDGE_SET_PIQ12             12                               /* Pin Interrupt 12 Edge */
#define BITP_PINT_EDGE_SET_PIQ11             11                               /* Pin Interrupt 11 Edge */
#define BITP_PINT_EDGE_SET_PIQ10             10                               /* Pin Interrupt 10 Edge */
#define BITP_PINT_EDGE_SET_PIQ9               9                               /* Pin Interrupt 9 Edge */
#define BITP_PINT_EDGE_SET_PIQ8               8                               /* Pin Interrupt 8 Edge */
#define BITP_PINT_EDGE_SET_PIQ7               7                               /* Pin Interrupt 7 Edge */
#define BITP_PINT_EDGE_SET_PIQ6               6                               /* Pin Interrupt 6 Edge */
#define BITP_PINT_EDGE_SET_PIQ5               5                               /* Pin Interrupt 5 Edge */
#define BITP_PINT_EDGE_SET_PIQ4               4                               /* Pin Interrupt 4 Edge */
#define BITP_PINT_EDGE_SET_PIQ3               3                               /* Pin Interrupt 3 Edge */
#define BITP_PINT_EDGE_SET_PIQ2               2                               /* Pin Interrupt 2 Edge */
#define BITP_PINT_EDGE_SET_PIQ1               1                               /* Pin Interrupt 1 Edge */
#define BITP_PINT_EDGE_SET_PIQ0               0                               /* Pin Interrupt 0 Edge */
#define BITM_PINT_EDGE_SET_PIQ31             (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 Edge */
#define BITM_PINT_EDGE_SET_PIQ30             (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 Edge */
#define BITM_PINT_EDGE_SET_PIQ29             (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 Edge */
#define BITM_PINT_EDGE_SET_PIQ28             (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 Edge */
#define BITM_PINT_EDGE_SET_PIQ27             (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 Edge */
#define BITM_PINT_EDGE_SET_PIQ26             (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 Edge */
#define BITM_PINT_EDGE_SET_PIQ25             (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 Edge */
#define BITM_PINT_EDGE_SET_PIQ24             (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 Edge */
#define BITM_PINT_EDGE_SET_PIQ23             (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 Edge */
#define BITM_PINT_EDGE_SET_PIQ22             (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 Edge */
#define BITM_PINT_EDGE_SET_PIQ21             (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 Edge */
#define BITM_PINT_EDGE_SET_PIQ20             (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 Edge */
#define BITM_PINT_EDGE_SET_PIQ19             (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 Edge */
#define BITM_PINT_EDGE_SET_PIQ18             (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 Edge */
#define BITM_PINT_EDGE_SET_PIQ17             (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 Edge */
#define BITM_PINT_EDGE_SET_PIQ16             (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 Edge */
#define BITM_PINT_EDGE_SET_PIQ15             (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 Edge */
#define BITM_PINT_EDGE_SET_PIQ14             (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 Edge */
#define BITM_PINT_EDGE_SET_PIQ13             (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 Edge */
#define BITM_PINT_EDGE_SET_PIQ12             (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 Edge */
#define BITM_PINT_EDGE_SET_PIQ11             (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 Edge */
#define BITM_PINT_EDGE_SET_PIQ10             (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 Edge */
#define BITM_PINT_EDGE_SET_PIQ9              (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 Edge */
#define BITM_PINT_EDGE_SET_PIQ8              (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 Edge */
#define BITM_PINT_EDGE_SET_PIQ7              (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 Edge */
#define BITM_PINT_EDGE_SET_PIQ6              (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 Edge */
#define BITM_PINT_EDGE_SET_PIQ5              (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 Edge */
#define BITM_PINT_EDGE_SET_PIQ4              (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 Edge */
#define BITM_PINT_EDGE_SET_PIQ3              (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 Edge */
#define BITM_PINT_EDGE_SET_PIQ2              (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 Edge */
#define BITM_PINT_EDGE_SET_PIQ1              (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 Edge */
#define BITM_PINT_EDGE_SET_PIQ0              (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 Edge */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_EDGE_CLR                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_EDGE_CLR_PIQ31             31                               /* Pin Interrupt 31 Level */
#define BITP_PINT_EDGE_CLR_PIQ30             30                               /* Pin Interrupt 30 Level */
#define BITP_PINT_EDGE_CLR_PIQ29             29                               /* Pin Interrupt 29 Level */
#define BITP_PINT_EDGE_CLR_PIQ28             28                               /* Pin Interrupt 28 Level */
#define BITP_PINT_EDGE_CLR_PIQ27             27                               /* Pin Interrupt 27 Level */
#define BITP_PINT_EDGE_CLR_PIQ26             26                               /* Pin Interrupt 26 Level */
#define BITP_PINT_EDGE_CLR_PIQ25             25                               /* Pin Interrupt 25 Level */
#define BITP_PINT_EDGE_CLR_PIQ24             24                               /* Pin Interrupt 24 Level */
#define BITP_PINT_EDGE_CLR_PIQ23             23                               /* Pin Interrupt 23 Level */
#define BITP_PINT_EDGE_CLR_PIQ22             22                               /* Pin Interrupt 22 Level */
#define BITP_PINT_EDGE_CLR_PIQ21             21                               /* Pin Interrupt 21 Level */
#define BITP_PINT_EDGE_CLR_PIQ20             20                               /* Pin Interrupt 20 Level */
#define BITP_PINT_EDGE_CLR_PIQ19             19                               /* Pin Interrupt 19 Level */
#define BITP_PINT_EDGE_CLR_PIQ18             18                               /* Pin Interrupt 18 Level */
#define BITP_PINT_EDGE_CLR_PIQ17             17                               /* Pin Interrupt 17 Level */
#define BITP_PINT_EDGE_CLR_PIQ16             16                               /* Pin Interrupt 16 Level */
#define BITP_PINT_EDGE_CLR_PIQ15             15                               /* Pin Interrupt 15 Level */
#define BITP_PINT_EDGE_CLR_PIQ14             14                               /* Pin Interrupt 14 Level */
#define BITP_PINT_EDGE_CLR_PIQ13             13                               /* Pin Interrupt 13 Level */
#define BITP_PINT_EDGE_CLR_PIQ12             12                               /* Pin Interrupt 12 Level */
#define BITP_PINT_EDGE_CLR_PIQ11             11                               /* Pin Interrupt 11 Level */
#define BITP_PINT_EDGE_CLR_PIQ10             10                               /* Pin Interrupt 10 Level */
#define BITP_PINT_EDGE_CLR_PIQ9               9                               /* Pin Interrupt 9 Level */
#define BITP_PINT_EDGE_CLR_PIQ8               8                               /* Pin Interrupt 8 Level */
#define BITP_PINT_EDGE_CLR_PIQ7               7                               /* Pin Interrupt 7 Level */
#define BITP_PINT_EDGE_CLR_PIQ6               6                               /* Pin Interrupt 6 Level */
#define BITP_PINT_EDGE_CLR_PIQ5               5                               /* Pin Interrupt 5 Level */
#define BITP_PINT_EDGE_CLR_PIQ4               4                               /* Pin Interrupt 4 Level */
#define BITP_PINT_EDGE_CLR_PIQ3               3                               /* Pin Interrupt 3 Level */
#define BITP_PINT_EDGE_CLR_PIQ2               2                               /* Pin Interrupt 2 Level */
#define BITP_PINT_EDGE_CLR_PIQ1               1                               /* Pin Interrupt 1 Level */
#define BITP_PINT_EDGE_CLR_PIQ0               0                               /* Pin Interrupt 0 Level */
#define BITM_PINT_EDGE_CLR_PIQ31             (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 Level */
#define BITM_PINT_EDGE_CLR_PIQ30             (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 Level */
#define BITM_PINT_EDGE_CLR_PIQ29             (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 Level */
#define BITM_PINT_EDGE_CLR_PIQ28             (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 Level */
#define BITM_PINT_EDGE_CLR_PIQ27             (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 Level */
#define BITM_PINT_EDGE_CLR_PIQ26             (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 Level */
#define BITM_PINT_EDGE_CLR_PIQ25             (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 Level */
#define BITM_PINT_EDGE_CLR_PIQ24             (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 Level */
#define BITM_PINT_EDGE_CLR_PIQ23             (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 Level */
#define BITM_PINT_EDGE_CLR_PIQ22             (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 Level */
#define BITM_PINT_EDGE_CLR_PIQ21             (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 Level */
#define BITM_PINT_EDGE_CLR_PIQ20             (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 Level */
#define BITM_PINT_EDGE_CLR_PIQ19             (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 Level */
#define BITM_PINT_EDGE_CLR_PIQ18             (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 Level */
#define BITM_PINT_EDGE_CLR_PIQ17             (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 Level */
#define BITM_PINT_EDGE_CLR_PIQ16             (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 Level */
#define BITM_PINT_EDGE_CLR_PIQ15             (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 Level */
#define BITM_PINT_EDGE_CLR_PIQ14             (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 Level */
#define BITM_PINT_EDGE_CLR_PIQ13             (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 Level */
#define BITM_PINT_EDGE_CLR_PIQ12             (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 Level */
#define BITM_PINT_EDGE_CLR_PIQ11             (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 Level */
#define BITM_PINT_EDGE_CLR_PIQ10             (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 Level */
#define BITM_PINT_EDGE_CLR_PIQ9              (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 Level */
#define BITM_PINT_EDGE_CLR_PIQ8              (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 Level */
#define BITM_PINT_EDGE_CLR_PIQ7              (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 Level */
#define BITM_PINT_EDGE_CLR_PIQ6              (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 Level */
#define BITM_PINT_EDGE_CLR_PIQ5              (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 Level */
#define BITM_PINT_EDGE_CLR_PIQ4              (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 Level */
#define BITM_PINT_EDGE_CLR_PIQ3              (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 Level */
#define BITM_PINT_EDGE_CLR_PIQ2              (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 Level */
#define BITM_PINT_EDGE_CLR_PIQ1              (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 Level */
#define BITM_PINT_EDGE_CLR_PIQ0              (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 Level */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_INV_SET                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_INV_SET_PIQ31              31                               /* Pin Interrupt 31 Invert */
#define BITP_PINT_INV_SET_PIQ30              30                               /* Pin Interrupt 30 Invert */
#define BITP_PINT_INV_SET_PIQ29              29                               /* Pin Interrupt 29 Invert */
#define BITP_PINT_INV_SET_PIQ28              28                               /* Pin Interrupt 28 Invert */
#define BITP_PINT_INV_SET_PIQ27              27                               /* Pin Interrupt 27 Invert */
#define BITP_PINT_INV_SET_PIQ26              26                               /* Pin Interrupt 26 Invert */
#define BITP_PINT_INV_SET_PIQ25              25                               /* Pin Interrupt 25 Invert */
#define BITP_PINT_INV_SET_PIQ24              24                               /* Pin Interrupt 24 Invert */
#define BITP_PINT_INV_SET_PIQ23              23                               /* Pin Interrupt 23 Invert */
#define BITP_PINT_INV_SET_PIQ22              22                               /* Pin Interrupt 22 Invert */
#define BITP_PINT_INV_SET_PIQ21              21                               /* Pin Interrupt 21 Invert */
#define BITP_PINT_INV_SET_PIQ20              20                               /* Pin Interrupt 20 Invert */
#define BITP_PINT_INV_SET_PIQ19              19                               /* Pin Interrupt 19 Invert */
#define BITP_PINT_INV_SET_PIQ18              18                               /* Pin Interrupt 18 Invert */
#define BITP_PINT_INV_SET_PIQ17              17                               /* Pin Interrupt 17 Invert */
#define BITP_PINT_INV_SET_PIQ16              16                               /* Pin Interrupt 16 Invert */
#define BITP_PINT_INV_SET_PIQ15              15                               /* Pin Interrupt 15 Invert */
#define BITP_PINT_INV_SET_PIQ14              14                               /* Pin Interrupt 14 Invert */
#define BITP_PINT_INV_SET_PIQ13              13                               /* Pin Interrupt 13 Invert */
#define BITP_PINT_INV_SET_PIQ12              12                               /* Pin Interrupt 12 Invert */
#define BITP_PINT_INV_SET_PIQ11              11                               /* Pin Interrupt 11 Invert */
#define BITP_PINT_INV_SET_PIQ10              10                               /* Pin Interrupt 10 Invert */
#define BITP_PINT_INV_SET_PIQ9                9                               /* Pin Interrupt 9 Invert */
#define BITP_PINT_INV_SET_PIQ8                8                               /* Pin Interrupt 8 Invert */
#define BITP_PINT_INV_SET_PIQ7                7                               /* Pin Interrupt 7 Invert */
#define BITP_PINT_INV_SET_PIQ6                6                               /* Pin Interrupt 6 Invert */
#define BITP_PINT_INV_SET_PIQ5                5                               /* Pin Interrupt 5 Invert */
#define BITP_PINT_INV_SET_PIQ4                4                               /* Pin Interrupt 4 Invert */
#define BITP_PINT_INV_SET_PIQ3                3                               /* Pin Interrupt 3 Invert */
#define BITP_PINT_INV_SET_PIQ2                2                               /* Pin Interrupt 2 Invert */
#define BITP_PINT_INV_SET_PIQ1                1                               /* Pin Interrupt 1 Invert */
#define BITP_PINT_INV_SET_PIQ0                0                               /* Pin Interrupt 0 Invert */
#define BITM_PINT_INV_SET_PIQ31              (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 Invert */
#define BITM_PINT_INV_SET_PIQ30              (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 Invert */
#define BITM_PINT_INV_SET_PIQ29              (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 Invert */
#define BITM_PINT_INV_SET_PIQ28              (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 Invert */
#define BITM_PINT_INV_SET_PIQ27              (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 Invert */
#define BITM_PINT_INV_SET_PIQ26              (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 Invert */
#define BITM_PINT_INV_SET_PIQ25              (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 Invert */
#define BITM_PINT_INV_SET_PIQ24              (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 Invert */
#define BITM_PINT_INV_SET_PIQ23              (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 Invert */
#define BITM_PINT_INV_SET_PIQ22              (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 Invert */
#define BITM_PINT_INV_SET_PIQ21              (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 Invert */
#define BITM_PINT_INV_SET_PIQ20              (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 Invert */
#define BITM_PINT_INV_SET_PIQ19              (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 Invert */
#define BITM_PINT_INV_SET_PIQ18              (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 Invert */
#define BITM_PINT_INV_SET_PIQ17              (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 Invert */
#define BITM_PINT_INV_SET_PIQ16              (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 Invert */
#define BITM_PINT_INV_SET_PIQ15              (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 Invert */
#define BITM_PINT_INV_SET_PIQ14              (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 Invert */
#define BITM_PINT_INV_SET_PIQ13              (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 Invert */
#define BITM_PINT_INV_SET_PIQ12              (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 Invert */
#define BITM_PINT_INV_SET_PIQ11              (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 Invert */
#define BITM_PINT_INV_SET_PIQ10              (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 Invert */
#define BITM_PINT_INV_SET_PIQ9               (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 Invert */
#define BITM_PINT_INV_SET_PIQ8               (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 Invert */
#define BITM_PINT_INV_SET_PIQ7               (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 Invert */
#define BITM_PINT_INV_SET_PIQ6               (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 Invert */
#define BITM_PINT_INV_SET_PIQ5               (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 Invert */
#define BITM_PINT_INV_SET_PIQ4               (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 Invert */
#define BITM_PINT_INV_SET_PIQ3               (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 Invert */
#define BITM_PINT_INV_SET_PIQ2               (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 Invert */
#define BITM_PINT_INV_SET_PIQ1               (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 Invert */
#define BITM_PINT_INV_SET_PIQ0               (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 Invert */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_INV_CLR                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_INV_CLR_PIQ31              31                               /* Pin Interrupt 31 No Invert */
#define BITP_PINT_INV_CLR_PIQ30              30                               /* Pin Interrupt 30 No Invert */
#define BITP_PINT_INV_CLR_PIQ29              29                               /* Pin Interrupt 29 No Invert */
#define BITP_PINT_INV_CLR_PIQ28              28                               /* Pin Interrupt 28 No Invert */
#define BITP_PINT_INV_CLR_PIQ27              27                               /* Pin Interrupt 27 No Invert */
#define BITP_PINT_INV_CLR_PIQ26              26                               /* Pin Interrupt 26 No Invert */
#define BITP_PINT_INV_CLR_PIQ25              25                               /* Pin Interrupt 25 No Invert */
#define BITP_PINT_INV_CLR_PIQ24              24                               /* Pin Interrupt 24 No Invert */
#define BITP_PINT_INV_CLR_PIQ23              23                               /* Pin Interrupt 23 No Invert */
#define BITP_PINT_INV_CLR_PIQ22              22                               /* Pin Interrupt 22 No Invert */
#define BITP_PINT_INV_CLR_PIQ21              21                               /* Pin Interrupt 21 No Invert */
#define BITP_PINT_INV_CLR_PIQ20              20                               /* Pin Interrupt 20 No Invert */
#define BITP_PINT_INV_CLR_PIQ19              19                               /* Pin Interrupt 19 No Invert */
#define BITP_PINT_INV_CLR_PIQ18              18                               /* Pin Interrupt 18 No Invert */
#define BITP_PINT_INV_CLR_PIQ17              17                               /* Pin Interrupt 17 No Invert */
#define BITP_PINT_INV_CLR_PIQ16              16                               /* Pin Interrupt 16 No Invert */
#define BITP_PINT_INV_CLR_PIQ15              15                               /* Pin Interrupt 15 No Invert */
#define BITP_PINT_INV_CLR_PIQ14              14                               /* Pin Interrupt 14 No Invert */
#define BITP_PINT_INV_CLR_PIQ13              13                               /* Pin Interrupt 13 No Invert */
#define BITP_PINT_INV_CLR_PIQ12              12                               /* Pin Interrupt 12 No Invert */
#define BITP_PINT_INV_CLR_PIQ11              11                               /* Pin Interrupt 11 No Invert */
#define BITP_PINT_INV_CLR_PIQ10              10                               /* Pin Interrupt 10 No Invert */
#define BITP_PINT_INV_CLR_PIQ9                9                               /* Pin Interrupt 9 No Invert */
#define BITP_PINT_INV_CLR_PIQ8                8                               /* Pin Interrupt 8 No Invert */
#define BITP_PINT_INV_CLR_PIQ7                7                               /* Pin Interrupt 7 No Invert */
#define BITP_PINT_INV_CLR_PIQ6                6                               /* Pin Interrupt 6 No Invert */
#define BITP_PINT_INV_CLR_PIQ5                5                               /* Pin Interrupt 5 No Invert */
#define BITP_PINT_INV_CLR_PIQ4                4                               /* Pin Interrupt 4 No Invert */
#define BITP_PINT_INV_CLR_PIQ3                3                               /* Pin Interrupt 3 No Invert */
#define BITP_PINT_INV_CLR_PIQ2                2                               /* Pin Interrupt 2 No Invert */
#define BITP_PINT_INV_CLR_PIQ1                1                               /* Pin Interrupt 1 No Invert */
#define BITP_PINT_INV_CLR_PIQ0                0                               /* Pin Interrupt 0 No Invert */
#define BITM_PINT_INV_CLR_PIQ31              (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 No Invert */
#define BITM_PINT_INV_CLR_PIQ30              (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 No Invert */
#define BITM_PINT_INV_CLR_PIQ29              (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 No Invert */
#define BITM_PINT_INV_CLR_PIQ28              (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 No Invert */
#define BITM_PINT_INV_CLR_PIQ27              (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 No Invert */
#define BITM_PINT_INV_CLR_PIQ26              (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 No Invert */
#define BITM_PINT_INV_CLR_PIQ25              (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 No Invert */
#define BITM_PINT_INV_CLR_PIQ24              (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 No Invert */
#define BITM_PINT_INV_CLR_PIQ23              (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 No Invert */
#define BITM_PINT_INV_CLR_PIQ22              (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 No Invert */
#define BITM_PINT_INV_CLR_PIQ21              (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 No Invert */
#define BITM_PINT_INV_CLR_PIQ20              (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 No Invert */
#define BITM_PINT_INV_CLR_PIQ19              (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 No Invert */
#define BITM_PINT_INV_CLR_PIQ18              (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 No Invert */
#define BITM_PINT_INV_CLR_PIQ17              (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 No Invert */
#define BITM_PINT_INV_CLR_PIQ16              (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 No Invert */
#define BITM_PINT_INV_CLR_PIQ15              (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 No Invert */
#define BITM_PINT_INV_CLR_PIQ14              (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 No Invert */
#define BITM_PINT_INV_CLR_PIQ13              (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 No Invert */
#define BITM_PINT_INV_CLR_PIQ12              (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 No Invert */
#define BITM_PINT_INV_CLR_PIQ11              (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 No Invert */
#define BITM_PINT_INV_CLR_PIQ10              (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 No Invert */
#define BITM_PINT_INV_CLR_PIQ9               (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 No Invert */
#define BITM_PINT_INV_CLR_PIQ8               (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 No Invert */
#define BITM_PINT_INV_CLR_PIQ7               (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 No Invert */
#define BITM_PINT_INV_CLR_PIQ6               (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 No Invert */
#define BITM_PINT_INV_CLR_PIQ5               (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 No Invert */
#define BITM_PINT_INV_CLR_PIQ4               (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 No Invert */
#define BITM_PINT_INV_CLR_PIQ3               (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 No Invert */
#define BITM_PINT_INV_CLR_PIQ2               (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 No Invert */
#define BITM_PINT_INV_CLR_PIQ1               (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 No Invert */
#define BITM_PINT_INV_CLR_PIQ0               (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 No Invert */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_PINSTATE                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_PINSTATE_PIQ31             31                               /* Pin Interrupt 31 State */
#define BITP_PINT_PINSTATE_PIQ30             30                               /* Pin Interrupt 30 State */
#define BITP_PINT_PINSTATE_PIQ29             29                               /* Pin Interrupt 29 State */
#define BITP_PINT_PINSTATE_PIQ28             28                               /* Pin Interrupt 28 State */
#define BITP_PINT_PINSTATE_PIQ27             27                               /* Pin Interrupt 27 State */
#define BITP_PINT_PINSTATE_PIQ26             26                               /* Pin Interrupt 26 State */
#define BITP_PINT_PINSTATE_PIQ25             25                               /* Pin Interrupt 25 State */
#define BITP_PINT_PINSTATE_PIQ24             24                               /* Pin Interrupt 24 State */
#define BITP_PINT_PINSTATE_PIQ23             23                               /* Pin Interrupt 23 State */
#define BITP_PINT_PINSTATE_PIQ22             22                               /* Pin Interrupt 22 State */
#define BITP_PINT_PINSTATE_PIQ21             21                               /* Pin Interrupt 21 State */
#define BITP_PINT_PINSTATE_PIQ20             20                               /* Pin Interrupt 20 State */
#define BITP_PINT_PINSTATE_PIQ19             19                               /* Pin Interrupt 19 State */
#define BITP_PINT_PINSTATE_PIQ18             18                               /* Pin Interrupt 18 State */
#define BITP_PINT_PINSTATE_PIQ17             17                               /* Pin Interrupt 17 State */
#define BITP_PINT_PINSTATE_PIQ16             16                               /* Pin Interrupt 16 State */
#define BITP_PINT_PINSTATE_PIQ15             15                               /* Pin Interrupt 15 State */
#define BITP_PINT_PINSTATE_PIQ14             14                               /* Pin Interrupt 14 State */
#define BITP_PINT_PINSTATE_PIQ13             13                               /* Pin Interrupt 13 State */
#define BITP_PINT_PINSTATE_PIQ12             12                               /* Pin Interrupt 12 State */
#define BITP_PINT_PINSTATE_PIQ11             11                               /* Pin Interrupt 11 State */
#define BITP_PINT_PINSTATE_PIQ10             10                               /* Pin Interrupt 10 State */
#define BITP_PINT_PINSTATE_PIQ9               9                               /* Pin Interrupt 9 State */
#define BITP_PINT_PINSTATE_PIQ8               8                               /* Pin Interrupt 8 State */
#define BITP_PINT_PINSTATE_PIQ7               7                               /* Pin Interrupt 7 State */
#define BITP_PINT_PINSTATE_PIQ6               6                               /* Pin Interrupt 6 State */
#define BITP_PINT_PINSTATE_PIQ5               5                               /* Pin Interrupt 5 State */
#define BITP_PINT_PINSTATE_PIQ4               4                               /* Pin Interrupt 4 State */
#define BITP_PINT_PINSTATE_PIQ3               3                               /* Pin Interrupt 3 State */
#define BITP_PINT_PINSTATE_PIQ2               2                               /* Pin Interrupt 2 State */
#define BITP_PINT_PINSTATE_PIQ1               1                               /* Pin Interrupt 1 State */
#define BITP_PINT_PINSTATE_PIQ0               0                               /* Pin Interrupt 0 State */
#define BITM_PINT_PINSTATE_PIQ31             (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 State */
#define BITM_PINT_PINSTATE_PIQ30             (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 State */
#define BITM_PINT_PINSTATE_PIQ29             (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 State */
#define BITM_PINT_PINSTATE_PIQ28             (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 State */
#define BITM_PINT_PINSTATE_PIQ27             (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 State */
#define BITM_PINT_PINSTATE_PIQ26             (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 State */
#define BITM_PINT_PINSTATE_PIQ25             (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 State */
#define BITM_PINT_PINSTATE_PIQ24             (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 State */
#define BITM_PINT_PINSTATE_PIQ23             (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 State */
#define BITM_PINT_PINSTATE_PIQ22             (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 State */
#define BITM_PINT_PINSTATE_PIQ21             (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 State */
#define BITM_PINT_PINSTATE_PIQ20             (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 State */
#define BITM_PINT_PINSTATE_PIQ19             (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 State */
#define BITM_PINT_PINSTATE_PIQ18             (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 State */
#define BITM_PINT_PINSTATE_PIQ17             (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 State */
#define BITM_PINT_PINSTATE_PIQ16             (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 State */
#define BITM_PINT_PINSTATE_PIQ15             (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 State */
#define BITM_PINT_PINSTATE_PIQ14             (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 State */
#define BITM_PINT_PINSTATE_PIQ13             (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 State */
#define BITM_PINT_PINSTATE_PIQ12             (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 State */
#define BITM_PINT_PINSTATE_PIQ11             (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 State */
#define BITM_PINT_PINSTATE_PIQ10             (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 State */
#define BITM_PINT_PINSTATE_PIQ9              (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 State */
#define BITM_PINT_PINSTATE_PIQ8              (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 State */
#define BITM_PINT_PINSTATE_PIQ7              (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 State */
#define BITM_PINT_PINSTATE_PIQ6              (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 State */
#define BITM_PINT_PINSTATE_PIQ5              (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 State */
#define BITM_PINT_PINSTATE_PIQ4              (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 State */
#define BITM_PINT_PINSTATE_PIQ3              (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 State */
#define BITM_PINT_PINSTATE_PIQ2              (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 State */
#define BITM_PINT_PINSTATE_PIQ1              (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 State */
#define BITM_PINT_PINSTATE_PIQ0              (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 State */

/* ------------------------------------------------------------------------------------------------------------------------
        PINT_LATCH                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PINT_LATCH_PIQ31                31                               /* Pin Interrupt 31 Latch */
#define BITP_PINT_LATCH_PIQ30                30                               /* Pin Interrupt 30 Latch */
#define BITP_PINT_LATCH_PIQ29                29                               /* Pin Interrupt 29 Latch */
#define BITP_PINT_LATCH_PIQ28                28                               /* Pin Interrupt 28 Latch */
#define BITP_PINT_LATCH_PIQ27                27                               /* Pin Interrupt 27 Latch */
#define BITP_PINT_LATCH_PIQ26                26                               /* Pin Interrupt 26 Latch */
#define BITP_PINT_LATCH_PIQ25                25                               /* Pin Interrupt 25 Latch */
#define BITP_PINT_LATCH_PIQ24                24                               /* Pin Interrupt 24 Latch */
#define BITP_PINT_LATCH_PIQ23                23                               /* Pin Interrupt 23 Latch */
#define BITP_PINT_LATCH_PIQ22                22                               /* Pin Interrupt 22 Latch */
#define BITP_PINT_LATCH_PIQ21                21                               /* Pin Interrupt 21 Latch */
#define BITP_PINT_LATCH_PIQ20                20                               /* Pin Interrupt 20 Latch */
#define BITP_PINT_LATCH_PIQ19                19                               /* Pin Interrupt 19 Latch */
#define BITP_PINT_LATCH_PIQ18                18                               /* Pin Interrupt 18 Latch */
#define BITP_PINT_LATCH_PIQ17                17                               /* Pin Interrupt 17 Latch */
#define BITP_PINT_LATCH_PIQ16                16                               /* Pin Interrupt 16 Latch */
#define BITP_PINT_LATCH_PIQ15                15                               /* Pin Interrupt 15 Latch */
#define BITP_PINT_LATCH_PIQ14                14                               /* Pin Interrupt 14 Latch */
#define BITP_PINT_LATCH_PIQ13                13                               /* Pin Interrupt 13 Latch */
#define BITP_PINT_LATCH_PIQ12                12                               /* Pin Interrupt 12 Latch */
#define BITP_PINT_LATCH_PIQ11                11                               /* Pin Interrupt 11 Latch */
#define BITP_PINT_LATCH_PIQ10                10                               /* Pin Interrupt 10 Latch */
#define BITP_PINT_LATCH_PIQ9                  9                               /* Pin Interrupt 9 Latch */
#define BITP_PINT_LATCH_PIQ8                  8                               /* Pin Interrupt 8 Latch */
#define BITP_PINT_LATCH_PIQ7                  7                               /* Pin Interrupt 7 Latch */
#define BITP_PINT_LATCH_PIQ6                  6                               /* Pin Interrupt 6 Latch */
#define BITP_PINT_LATCH_PIQ5                  5                               /* Pin Interrupt 5 Latch */
#define BITP_PINT_LATCH_PIQ4                  4                               /* Pin Interrupt 4 Latch */
#define BITP_PINT_LATCH_PIQ3                  3                               /* Pin Interrupt 3 Latch */
#define BITP_PINT_LATCH_PIQ2                  2                               /* Pin Interrupt 2 Latch */
#define BITP_PINT_LATCH_PIQ1                  1                               /* Pin Interrupt 1 Latch */
#define BITP_PINT_LATCH_PIQ0                  0                               /* Pin Interrupt 0 Latch */
#define BITM_PINT_LATCH_PIQ31                (_ADI_MSK(0x80000000,uint32_t))  /* Pin Interrupt 31 Latch */
#define BITM_PINT_LATCH_PIQ30                (_ADI_MSK(0x40000000,uint32_t))  /* Pin Interrupt 30 Latch */
#define BITM_PINT_LATCH_PIQ29                (_ADI_MSK(0x20000000,uint32_t))  /* Pin Interrupt 29 Latch */
#define BITM_PINT_LATCH_PIQ28                (_ADI_MSK(0x10000000,uint32_t))  /* Pin Interrupt 28 Latch */
#define BITM_PINT_LATCH_PIQ27                (_ADI_MSK(0x08000000,uint32_t))  /* Pin Interrupt 27 Latch */
#define BITM_PINT_LATCH_PIQ26                (_ADI_MSK(0x04000000,uint32_t))  /* Pin Interrupt 26 Latch */
#define BITM_PINT_LATCH_PIQ25                (_ADI_MSK(0x02000000,uint32_t))  /* Pin Interrupt 25 Latch */
#define BITM_PINT_LATCH_PIQ24                (_ADI_MSK(0x01000000,uint32_t))  /* Pin Interrupt 24 Latch */
#define BITM_PINT_LATCH_PIQ23                (_ADI_MSK(0x00800000,uint32_t))  /* Pin Interrupt 23 Latch */
#define BITM_PINT_LATCH_PIQ22                (_ADI_MSK(0x00400000,uint32_t))  /* Pin Interrupt 22 Latch */
#define BITM_PINT_LATCH_PIQ21                (_ADI_MSK(0x00200000,uint32_t))  /* Pin Interrupt 21 Latch */
#define BITM_PINT_LATCH_PIQ20                (_ADI_MSK(0x00100000,uint32_t))  /* Pin Interrupt 20 Latch */
#define BITM_PINT_LATCH_PIQ19                (_ADI_MSK(0x00080000,uint32_t))  /* Pin Interrupt 19 Latch */
#define BITM_PINT_LATCH_PIQ18                (_ADI_MSK(0x00040000,uint32_t))  /* Pin Interrupt 18 Latch */
#define BITM_PINT_LATCH_PIQ17                (_ADI_MSK(0x00020000,uint32_t))  /* Pin Interrupt 17 Latch */
#define BITM_PINT_LATCH_PIQ16                (_ADI_MSK(0x00010000,uint32_t))  /* Pin Interrupt 16 Latch */
#define BITM_PINT_LATCH_PIQ15                (_ADI_MSK(0x00008000,uint32_t))  /* Pin Interrupt 15 Latch */
#define BITM_PINT_LATCH_PIQ14                (_ADI_MSK(0x00004000,uint32_t))  /* Pin Interrupt 14 Latch */
#define BITM_PINT_LATCH_PIQ13                (_ADI_MSK(0x00002000,uint32_t))  /* Pin Interrupt 13 Latch */
#define BITM_PINT_LATCH_PIQ12                (_ADI_MSK(0x00001000,uint32_t))  /* Pin Interrupt 12 Latch */
#define BITM_PINT_LATCH_PIQ11                (_ADI_MSK(0x00000800,uint32_t))  /* Pin Interrupt 11 Latch */
#define BITM_PINT_LATCH_PIQ10                (_ADI_MSK(0x00000400,uint32_t))  /* Pin Interrupt 10 Latch */
#define BITM_PINT_LATCH_PIQ9                 (_ADI_MSK(0x00000200,uint32_t))  /* Pin Interrupt 9 Latch */
#define BITM_PINT_LATCH_PIQ8                 (_ADI_MSK(0x00000100,uint32_t))  /* Pin Interrupt 8 Latch */
#define BITM_PINT_LATCH_PIQ7                 (_ADI_MSK(0x00000080,uint32_t))  /* Pin Interrupt 7 Latch */
#define BITM_PINT_LATCH_PIQ6                 (_ADI_MSK(0x00000040,uint32_t))  /* Pin Interrupt 6 Latch */
#define BITM_PINT_LATCH_PIQ5                 (_ADI_MSK(0x00000020,uint32_t))  /* Pin Interrupt 5 Latch */
#define BITM_PINT_LATCH_PIQ4                 (_ADI_MSK(0x00000010,uint32_t))  /* Pin Interrupt 4 Latch */
#define BITM_PINT_LATCH_PIQ3                 (_ADI_MSK(0x00000008,uint32_t))  /* Pin Interrupt 3 Latch */
#define BITM_PINT_LATCH_PIQ2                 (_ADI_MSK(0x00000004,uint32_t))  /* Pin Interrupt 2 Latch */
#define BITM_PINT_LATCH_PIQ1                 (_ADI_MSK(0x00000002,uint32_t))  /* Pin Interrupt 1 Latch */
#define BITM_PINT_LATCH_PIQ0                 (_ADI_MSK(0x00000001,uint32_t))  /* Pin Interrupt 0 Latch */

/* ==================================================
        Static Memory Controller Registers
   ================================================== */

/* =========================
        SMC0
   ========================= */
#define REG_SMC0_GCTL                   0xFFC16004         /* SMC0 Grant Control Register */
#define REG_SMC0_GSTAT                  0xFFC16008         /* SMC0 Grant Status Register */
#define REG_SMC0_B0CTL                  0xFFC1600C         /* SMC0 Bank 0 Control Register */
#define REG_SMC0_B0TIM                  0xFFC16010         /* SMC0 Bank 0 Timing Register */
#define REG_SMC0_B0ETIM                 0xFFC16014         /* SMC0 Bank 0 Extended Timing Register */
#define REG_SMC0_B1CTL                  0xFFC1601C         /* SMC0 Bank 1 Control Register */
#define REG_SMC0_B1TIM                  0xFFC16020         /* SMC0 Bank 1 Timing Register */
#define REG_SMC0_B1ETIM                 0xFFC16024         /* SMC0 Bank 1 Extended Timing Register */
#define REG_SMC0_B2CTL                  0xFFC1602C         /* SMC0 Bank 2 Control Register */
#define REG_SMC0_B2TIM                  0xFFC16030         /* SMC0 Bank 2 Timing Register */
#define REG_SMC0_B2ETIM                 0xFFC16034         /* SMC0 Bank 2 Extended Timing Register */
#define REG_SMC0_B3CTL                  0xFFC1603C         /* SMC0 Bank 3 Control Register */
#define REG_SMC0_B3TIM                  0xFFC16040         /* SMC0 Bank 3 Timing Register */
#define REG_SMC0_B3ETIM                 0xFFC16044         /* SMC0 Bank 3 Extended Timing Register */

/* =========================
        SMC
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        SMC_GCTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_GCTL_BGDIS                   4                               /* Bus Grant Disable */
#define BITM_SMC_GCTL_BGDIS                  (_ADI_MSK(0x00000010,uint32_t))  /* Bus Grant Disable */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_GSTAT                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_GSTAT_BGHSTAT                2                               /* Bus Grant Hold Status */
#define BITP_SMC_GSTAT_BRQSTAT                1                               /* Bus Request Status */
#define BITP_SMC_GSTAT_BGSTAT                 0                               /* Bus Grant Status */
#define BITM_SMC_GSTAT_BGHSTAT               (_ADI_MSK(0x00000004,uint32_t))  /* Bus Grant Hold Status */
#define BITM_SMC_GSTAT_BRQSTAT               (_ADI_MSK(0x00000002,uint32_t))  /* Bus Request Status */
#define BITM_SMC_GSTAT_BGSTAT                (_ADI_MSK(0x00000001,uint32_t))  /* Bus Grant Status */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B0CTL                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B0CTL_BTYPE                 26                               /* Burst Type for Flash */
#define BITP_SMC_B0CTL_BCLK                  24                               /* Burst Clock Frequency Divisor */
#define BITP_SMC_B0CTL_PGSZ                  20                               /* Flash Page Size */
#define BITP_SMC_B0CTL_RDYABTEN              14                               /* ARDY Abort Enable */
#define BITP_SMC_B0CTL_RDYPOL                13                               /* ARDY Polarity */
#define BITP_SMC_B0CTL_RDYEN                 12                               /* ARDY Enable */
#define BITP_SMC_B0CTL_SELCTRL                8                               /* Select Control */
#define BITP_SMC_B0CTL_MODE                   4                               /* Memory Access Mode */
#define BITP_SMC_B0CTL_EN                     0                               /* Bank 0 Enable */
#define BITM_SMC_B0CTL_BTYPE                 (_ADI_MSK(0x04000000,uint32_t))  /* Burst Type for Flash */
#define BITM_SMC_B0CTL_BCLK                  (_ADI_MSK(0x03000000,uint32_t))  /* Burst Clock Frequency Divisor */
#define BITM_SMC_B0CTL_PGSZ                  (_ADI_MSK(0x00300000,uint32_t))  /* Flash Page Size */
#define BITM_SMC_B0CTL_RDYABTEN              (_ADI_MSK(0x00004000,uint32_t))  /* ARDY Abort Enable */
#define BITM_SMC_B0CTL_RDYPOL                (_ADI_MSK(0x00002000,uint32_t))  /* ARDY Polarity */
#define BITM_SMC_B0CTL_RDYEN                 (_ADI_MSK(0x00001000,uint32_t))  /* ARDY Enable */
#define BITM_SMC_B0CTL_SELCTRL               (_ADI_MSK(0x00000300,uint32_t))  /* Select Control */
#define BITM_SMC_B0CTL_MODE                  (_ADI_MSK(0x00000030,uint32_t))  /* Memory Access Mode */
#define BITM_SMC_B0CTL_EN                    (_ADI_MSK(0x00000001,uint32_t))  /* Bank 0 Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B0TIM                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B0TIM_RAT                   24                               /* Read Access Time */
#define BITP_SMC_B0TIM_RHT                   20                               /* Read Hold Time */
#define BITP_SMC_B0TIM_RST                   16                               /* Read Setup Time */
#define BITP_SMC_B0TIM_WAT                    8                               /* Write Access Time */
#define BITP_SMC_B0TIM_WHT                    4                               /* Write Hold Time */
#define BITP_SMC_B0TIM_WST                    0                               /* Write Setup Time */
#define BITM_SMC_B0TIM_RAT                   (_ADI_MSK(0x3F000000,uint32_t))  /* Read Access Time */
#define BITM_SMC_B0TIM_RHT                   (_ADI_MSK(0x00700000,uint32_t))  /* Read Hold Time */
#define BITM_SMC_B0TIM_RST                   (_ADI_MSK(0x00070000,uint32_t))  /* Read Setup Time */
#define BITM_SMC_B0TIM_WAT                   (_ADI_MSK(0x00003F00,uint32_t))  /* Write Access Time */
#define BITM_SMC_B0TIM_WHT                   (_ADI_MSK(0x00000070,uint32_t))  /* Write Hold Time */
#define BITM_SMC_B0TIM_WST                   (_ADI_MSK(0x00000007,uint32_t))  /* Write Setup Time */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B0ETIM                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B0ETIM_PGWS                 16                               /* Page Wait States */
#define BITP_SMC_B0ETIM_IT                   12                               /* Idle Time */
#define BITP_SMC_B0ETIM_TT                    8                               /* Transition Time */
#define BITP_SMC_B0ETIM_PREAT                 4                               /* Pre Access Time */
#define BITP_SMC_B0ETIM_PREST                 0                               /* Pre Setup Time */
#define BITM_SMC_B0ETIM_PGWS                 (_ADI_MSK(0x000F0000,uint32_t))  /* Page Wait States */
#define BITM_SMC_B0ETIM_IT                   (_ADI_MSK(0x00007000,uint32_t))  /* Idle Time */
#define BITM_SMC_B0ETIM_TT                   (_ADI_MSK(0x00000700,uint32_t))  /* Transition Time */
#define BITM_SMC_B0ETIM_PREAT                (_ADI_MSK(0x00000030,uint32_t))  /* Pre Access Time */
#define BITM_SMC_B0ETIM_PREST                (_ADI_MSK(0x00000003,uint32_t))  /* Pre Setup Time */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B1CTL                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B1CTL_BTYPE                 26                               /* Burst Type for Flash */
#define BITP_SMC_B1CTL_BCLK                  24                               /* Burst Clock Frequency Divisor */
#define BITP_SMC_B1CTL_PGSZ                  20                               /* Flash Page Size */
#define BITP_SMC_B1CTL_RDYABTEN              14                               /* ARDY Abort Enable */
#define BITP_SMC_B1CTL_RDYPOL                13                               /* ARDY Polarity */
#define BITP_SMC_B1CTL_RDYEN                 12                               /* ARDY Enable */
#define BITP_SMC_B1CTL_SELCTRL                8                               /* Select Control */
#define BITP_SMC_B1CTL_MODE                   4                               /* Memory Access Mode */
#define BITP_SMC_B1CTL_EN                     0                               /* Bank 1 Enable */
#define BITM_SMC_B1CTL_BTYPE                 (_ADI_MSK(0x04000000,uint32_t))  /* Burst Type for Flash */
#define BITM_SMC_B1CTL_BCLK                  (_ADI_MSK(0x03000000,uint32_t))  /* Burst Clock Frequency Divisor */
#define BITM_SMC_B1CTL_PGSZ                  (_ADI_MSK(0x00300000,uint32_t))  /* Flash Page Size */
#define BITM_SMC_B1CTL_RDYABTEN              (_ADI_MSK(0x00004000,uint32_t))  /* ARDY Abort Enable */
#define BITM_SMC_B1CTL_RDYPOL                (_ADI_MSK(0x00002000,uint32_t))  /* ARDY Polarity */
#define BITM_SMC_B1CTL_RDYEN                 (_ADI_MSK(0x00001000,uint32_t))  /* ARDY Enable */
#define BITM_SMC_B1CTL_SELCTRL               (_ADI_MSK(0x00000300,uint32_t))  /* Select Control */
#define BITM_SMC_B1CTL_MODE                  (_ADI_MSK(0x00000030,uint32_t))  /* Memory Access Mode */
#define BITM_SMC_B1CTL_EN                    (_ADI_MSK(0x00000001,uint32_t))  /* Bank 1 Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B1TIM                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B1TIM_RAT                   24                               /* Read Access Time */
#define BITP_SMC_B1TIM_RHT                   20                               /* Read Hold Time */
#define BITP_SMC_B1TIM_RST                   16                               /* Read Setup Time */
#define BITP_SMC_B1TIM_WAT                    8                               /* Write Access Time */
#define BITP_SMC_B1TIM_WHT                    4                               /* Write Hold Time */
#define BITP_SMC_B1TIM_WST                    0                               /* Write Setup Time */
#define BITM_SMC_B1TIM_RAT                   (_ADI_MSK(0x3F000000,uint32_t))  /* Read Access Time */
#define BITM_SMC_B1TIM_RHT                   (_ADI_MSK(0x00700000,uint32_t))  /* Read Hold Time */
#define BITM_SMC_B1TIM_RST                   (_ADI_MSK(0x00070000,uint32_t))  /* Read Setup Time */
#define BITM_SMC_B1TIM_WAT                   (_ADI_MSK(0x00003F00,uint32_t))  /* Write Access Time */
#define BITM_SMC_B1TIM_WHT                   (_ADI_MSK(0x00000070,uint32_t))  /* Write Hold Time */
#define BITM_SMC_B1TIM_WST                   (_ADI_MSK(0x00000007,uint32_t))  /* Write Setup Time */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B1ETIM                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B1ETIM_PGWS                 16                               /* Page Wait States */
#define BITP_SMC_B1ETIM_IT                   12                               /* Idle Time */
#define BITP_SMC_B1ETIM_TT                    8                               /* Transition Time */
#define BITP_SMC_B1ETIM_PREAT                 4                               /* Pre Access Time */
#define BITP_SMC_B1ETIM_PREST                 0                               /* Pre Setup Time */
#define BITM_SMC_B1ETIM_PGWS                 (_ADI_MSK(0x000F0000,uint32_t))  /* Page Wait States */
#define BITM_SMC_B1ETIM_IT                   (_ADI_MSK(0x00007000,uint32_t))  /* Idle Time */
#define BITM_SMC_B1ETIM_TT                   (_ADI_MSK(0x00000700,uint32_t))  /* Transition Time */
#define BITM_SMC_B1ETIM_PREAT                (_ADI_MSK(0x00000030,uint32_t))  /* Pre Access Time */
#define BITM_SMC_B1ETIM_PREST                (_ADI_MSK(0x00000003,uint32_t))  /* Pre Setup Time */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B2CTL                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B2CTL_BTYPE                 26                               /* Burst Type for Flash */
#define BITP_SMC_B2CTL_BCLK                  24                               /* Burst Clock Frequency Divisor */
#define BITP_SMC_B2CTL_PGSZ                  20                               /* Flash Page Size */
#define BITP_SMC_B2CTL_RDYABTEN              14                               /* ARDY Abort Enable */
#define BITP_SMC_B2CTL_RDYPOL                13                               /* ARDY Polarity */
#define BITP_SMC_B2CTL_RDYEN                 12                               /* ARDY Enable */
#define BITP_SMC_B2CTL_SELCTRL                8                               /* Select Control */
#define BITP_SMC_B2CTL_MODE                   4                               /* Memory Access Mode */
#define BITP_SMC_B2CTL_EN                     0                               /* Bank 2 Enable */
#define BITM_SMC_B2CTL_BTYPE                 (_ADI_MSK(0x04000000,uint32_t))  /* Burst Type for Flash */
#define BITM_SMC_B2CTL_BCLK                  (_ADI_MSK(0x03000000,uint32_t))  /* Burst Clock Frequency Divisor */
#define BITM_SMC_B2CTL_PGSZ                  (_ADI_MSK(0x00300000,uint32_t))  /* Flash Page Size */
#define BITM_SMC_B2CTL_RDYABTEN              (_ADI_MSK(0x00004000,uint32_t))  /* ARDY Abort Enable */
#define BITM_SMC_B2CTL_RDYPOL                (_ADI_MSK(0x00002000,uint32_t))  /* ARDY Polarity */
#define BITM_SMC_B2CTL_RDYEN                 (_ADI_MSK(0x00001000,uint32_t))  /* ARDY Enable */
#define BITM_SMC_B2CTL_SELCTRL               (_ADI_MSK(0x00000300,uint32_t))  /* Select Control */
#define BITM_SMC_B2CTL_MODE                  (_ADI_MSK(0x00000030,uint32_t))  /* Memory Access Mode */
#define BITM_SMC_B2CTL_EN                    (_ADI_MSK(0x00000001,uint32_t))  /* Bank 2 Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B2TIM                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B2TIM_RAT                   24                               /* Read Access Time */
#define BITP_SMC_B2TIM_RHT                   20                               /* Read Hold Time */
#define BITP_SMC_B2TIM_RST                   16                               /* Read Setup Time */
#define BITP_SMC_B2TIM_WAT                    8                               /* Write Access Time */
#define BITP_SMC_B2TIM_WHT                    4                               /* Write Hold Time */
#define BITP_SMC_B2TIM_WST                    0                               /* Write Setup Time */
#define BITM_SMC_B2TIM_RAT                   (_ADI_MSK(0x3F000000,uint32_t))  /* Read Access Time */
#define BITM_SMC_B2TIM_RHT                   (_ADI_MSK(0x00700000,uint32_t))  /* Read Hold Time */
#define BITM_SMC_B2TIM_RST                   (_ADI_MSK(0x00070000,uint32_t))  /* Read Setup Time */
#define BITM_SMC_B2TIM_WAT                   (_ADI_MSK(0x00003F00,uint32_t))  /* Write Access Time */
#define BITM_SMC_B2TIM_WHT                   (_ADI_MSK(0x00000070,uint32_t))  /* Write Hold Time */
#define BITM_SMC_B2TIM_WST                   (_ADI_MSK(0x00000007,uint32_t))  /* Write Setup Time */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B2ETIM                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B2ETIM_PGWS                 16                               /* Page Wait States */
#define BITP_SMC_B2ETIM_IT                   12                               /* Idle Time */
#define BITP_SMC_B2ETIM_TT                    8                               /* Transition Time */
#define BITP_SMC_B2ETIM_PREAT                 4                               /* Pre Access Time */
#define BITP_SMC_B2ETIM_PREST                 0                               /* Pre Setup Time */
#define BITM_SMC_B2ETIM_PGWS                 (_ADI_MSK(0x000F0000,uint32_t))  /* Page Wait States */
#define BITM_SMC_B2ETIM_IT                   (_ADI_MSK(0x00007000,uint32_t))  /* Idle Time */
#define BITM_SMC_B2ETIM_TT                   (_ADI_MSK(0x00000700,uint32_t))  /* Transition Time */
#define BITM_SMC_B2ETIM_PREAT                (_ADI_MSK(0x00000030,uint32_t))  /* Pre Access Time */
#define BITM_SMC_B2ETIM_PREST                (_ADI_MSK(0x00000003,uint32_t))  /* Pre Setup Time */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B3CTL                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B3CTL_BTYPE                 26                               /* Burst Type for Flash */
#define BITP_SMC_B3CTL_BCLK                  24                               /* Burst Clock Frequency Divisor */
#define BITP_SMC_B3CTL_PGSZ                  20                               /* Flash Page Size */
#define BITP_SMC_B3CTL_RDYABTEN              14                               /* ARDY Abort Enable */
#define BITP_SMC_B3CTL_RDYPOL                13                               /* ARDY Polarity */
#define BITP_SMC_B3CTL_RDYEN                 12                               /* ARDY Enable */
#define BITP_SMC_B3CTL_SELCTRL                8                               /* Select Control */
#define BITP_SMC_B3CTL_MODE                   4                               /* Memory Access Mode */
#define BITP_SMC_B3CTL_EN                     0                               /* Bank 3 Enable */
#define BITM_SMC_B3CTL_BTYPE                 (_ADI_MSK(0x04000000,uint32_t))  /* Burst Type for Flash */
#define BITM_SMC_B3CTL_BCLK                  (_ADI_MSK(0x03000000,uint32_t))  /* Burst Clock Frequency Divisor */
#define BITM_SMC_B3CTL_PGSZ                  (_ADI_MSK(0x00300000,uint32_t))  /* Flash Page Size */
#define BITM_SMC_B3CTL_RDYABTEN              (_ADI_MSK(0x00004000,uint32_t))  /* ARDY Abort Enable */
#define BITM_SMC_B3CTL_RDYPOL                (_ADI_MSK(0x00002000,uint32_t))  /* ARDY Polarity */
#define BITM_SMC_B3CTL_RDYEN                 (_ADI_MSK(0x00001000,uint32_t))  /* ARDY Enable */
#define BITM_SMC_B3CTL_SELCTRL               (_ADI_MSK(0x00000300,uint32_t))  /* Select Control */
#define BITM_SMC_B3CTL_MODE                  (_ADI_MSK(0x00000030,uint32_t))  /* Memory Access Mode */
#define BITM_SMC_B3CTL_EN                    (_ADI_MSK(0x00000001,uint32_t))  /* Bank 3 Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B3TIM                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B3TIM_RAT                   24                               /* Read Access Time */
#define BITP_SMC_B3TIM_RHT                   20                               /* Read Hold Time */
#define BITP_SMC_B3TIM_RST                   16                               /* Read Setup Time */
#define BITP_SMC_B3TIM_WAT                    8                               /* Write Access Time */
#define BITP_SMC_B3TIM_WHT                    4                               /* Write Hold Time */
#define BITP_SMC_B3TIM_WST                    0                               /* Write Setup Time */
#define BITM_SMC_B3TIM_RAT                   (_ADI_MSK(0x3F000000,uint32_t))  /* Read Access Time */
#define BITM_SMC_B3TIM_RHT                   (_ADI_MSK(0x00700000,uint32_t))  /* Read Hold Time */
#define BITM_SMC_B3TIM_RST                   (_ADI_MSK(0x00070000,uint32_t))  /* Read Setup Time */
#define BITM_SMC_B3TIM_WAT                   (_ADI_MSK(0x00003F00,uint32_t))  /* Write Access Time */
#define BITM_SMC_B3TIM_WHT                   (_ADI_MSK(0x00000070,uint32_t))  /* Write Hold Time */
#define BITM_SMC_B3TIM_WST                   (_ADI_MSK(0x00000007,uint32_t))  /* Write Setup Time */

/* ------------------------------------------------------------------------------------------------------------------------
        SMC_B3ETIM                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SMC_B3ETIM_PGWS                 16                               /* Page Wait States */
#define BITP_SMC_B3ETIM_IT                   12                               /* Idle Time */
#define BITP_SMC_B3ETIM_TT                    8                               /* Transition Time */
#define BITP_SMC_B3ETIM_PREAT                 4                               /* Pre Access Time */
#define BITP_SMC_B3ETIM_PREST                 0                               /* Pre Setup Time */
#define BITM_SMC_B3ETIM_PGWS                 (_ADI_MSK(0x000F0000,uint32_t))  /* Page Wait States */
#define BITM_SMC_B3ETIM_IT                   (_ADI_MSK(0x00007000,uint32_t))  /* Idle Time */
#define BITM_SMC_B3ETIM_TT                   (_ADI_MSK(0x00000700,uint32_t))  /* Transition Time */
#define BITM_SMC_B3ETIM_PREAT                (_ADI_MSK(0x00000030,uint32_t))  /* Pre Access Time */
#define BITM_SMC_B3ETIM_PREST                (_ADI_MSK(0x00000003,uint32_t))  /* Pre Setup Time */

/* ==================================================
        Watch Dog Timer Unit Registers
   ================================================== */

/* =========================
        WDOG0
   ========================= */
#define REG_WDOG0_CTL                   0xFFC17000         /* WDOG0 Control Register */
#define REG_WDOG0_CNT                   0xFFC17004         /* WDOG0 Count Register */
#define REG_WDOG0_STAT                  0xFFC17008         /* WDOG0 Watchdog Timer Status Register */

/* =========================
        WDOG1
   ========================= */
#define REG_WDOG1_CTL                   0xFFC17800         /* WDOG1 Control Register */
#define REG_WDOG1_CNT                   0xFFC17804         /* WDOG1 Count Register */
#define REG_WDOG1_STAT                  0xFFC17808         /* WDOG1 Watchdog Timer Status Register */

/* =========================
        WDOG
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        WDOG_CTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_WDOG_CTL_WDRO                   15                               /* Watch Dog Rollover */
#define BITP_WDOG_CTL_WDEN                    4                               /* Watch Dog Enable */

#define BITM_WDOG_CTL_WDRO                   (_ADI_MSK(0x00008000,uint32_t))  /* Watch Dog Rollover */
#define ENUM_WDOG_CTL_WDTEXP                 (_ADI_MSK(0x00008000,uint32_t))  /* WDRO: WDT has expired */
#define BITM_WDOG_CTL_WDEN                   (_ADI_MSK(0x00000FF0,uint32_t))  /* Watch Dog Enable */

/* ==================================================
        EPPI Registers
   ================================================== */

/* =========================
        EPPI0
   ========================= */
#define REG_EPPI0_STAT                  0xFFC18000         /* EPPI0 Status Register */
#define REG_EPPI0_HCNT                  0xFFC18004         /* EPPI0 Horizontal Transfer Count Register */
#define REG_EPPI0_HDLY                  0xFFC18008         /* EPPI0 Horizontal Delay Count Register */
#define REG_EPPI0_VCNT                  0xFFC1800C         /* EPPI0 Vertical Transfer Count Register */
#define REG_EPPI0_VDLY                  0xFFC18010         /* EPPI0 Vertical Delay Count Register */
#define REG_EPPI0_FRAME                 0xFFC18014         /* EPPI0 Lines Per Frame Register */
#define REG_EPPI0_LINE                  0xFFC18018         /* EPPI0 Samples Per Line Register */
#define REG_EPPI0_CLKDIV                0xFFC1801C         /* EPPI0 Clock Divide Register */
#define REG_EPPI0_CTL                   0xFFC18020         /* EPPI0 Control Register */
#define REG_EPPI0_FS1_WLHB              0xFFC18024         /* EPPI0 FS1 Width Register / EPPI Horizontal Blanking Samples Per Line Register */
#define REG_EPPI0_FS1_PASPL             0xFFC18028         /* EPPI0 FS1 Period Register / EPPI Active Samples Per Line Register */
#define REG_EPPI0_FS2_WLVB              0xFFC1802C         /* EPPI0 FS2 Width Register / EPPI Lines Of Vertical Blanking Register */
#define REG_EPPI0_FS2_PALPF             0xFFC18030         /* EPPI0 FS2 Period Register / EPPI Active Lines Per Field Register */
#define REG_EPPI0_IMSK                  0xFFC18034         /* EPPI0 Interrupt Mask Register */
#define REG_EPPI0_ODDCLIP               0xFFC1803C         /* EPPI0 Clipping Register for ODD (Chroma) Data */
#define REG_EPPI0_EVENCLIP              0xFFC18040         /* EPPI0 Clipping Register for EVEN (Luma) Data */
#define REG_EPPI0_FS1_DLY               0xFFC18044         /* EPPI0 Frame Sync 1 Delay Value */
#define REG_EPPI0_FS2_DLY               0xFFC18048         /* EPPI0 Frame Sync 2 Delay Value */
#define REG_EPPI0_CTL2                  0xFFC1804C         /* EPPI0 Control Register 2 */

/* =========================
        EPPI1
   ========================= */
#define REG_EPPI1_STAT                  0xFFC18400         /* EPPI1 Status Register */
#define REG_EPPI1_HCNT                  0xFFC18404         /* EPPI1 Horizontal Transfer Count Register */
#define REG_EPPI1_HDLY                  0xFFC18408         /* EPPI1 Horizontal Delay Count Register */
#define REG_EPPI1_VCNT                  0xFFC1840C         /* EPPI1 Vertical Transfer Count Register */
#define REG_EPPI1_VDLY                  0xFFC18410         /* EPPI1 Vertical Delay Count Register */
#define REG_EPPI1_FRAME                 0xFFC18414         /* EPPI1 Lines Per Frame Register */
#define REG_EPPI1_LINE                  0xFFC18418         /* EPPI1 Samples Per Line Register */
#define REG_EPPI1_CLKDIV                0xFFC1841C         /* EPPI1 Clock Divide Register */
#define REG_EPPI1_CTL                   0xFFC18420         /* EPPI1 Control Register */
#define REG_EPPI1_FS1_WLHB              0xFFC18424         /* EPPI1 FS1 Width Register / EPPI Horizontal Blanking Samples Per Line Register */
#define REG_EPPI1_FS1_PASPL             0xFFC18428         /* EPPI1 FS1 Period Register / EPPI Active Samples Per Line Register */
#define REG_EPPI1_FS2_WLVB              0xFFC1842C         /* EPPI1 FS2 Width Register / EPPI Lines Of Vertical Blanking Register */
#define REG_EPPI1_FS2_PALPF             0xFFC18430         /* EPPI1 FS2 Period Register / EPPI Active Lines Per Field Register */
#define REG_EPPI1_IMSK                  0xFFC18434         /* EPPI1 Interrupt Mask Register */
#define REG_EPPI1_ODDCLIP               0xFFC1843C         /* EPPI1 Clipping Register for ODD (Chroma) Data */
#define REG_EPPI1_EVENCLIP              0xFFC18440         /* EPPI1 Clipping Register for EVEN (Luma) Data */
#define REG_EPPI1_FS1_DLY               0xFFC18444         /* EPPI1 Frame Sync 1 Delay Value */
#define REG_EPPI1_FS2_DLY               0xFFC18448         /* EPPI1 Frame Sync 2 Delay Value */
#define REG_EPPI1_CTL2                  0xFFC1844C         /* EPPI1 Control Register 2 */

/* =========================
        EPPI2
   ========================= */
#define REG_EPPI2_STAT                  0xFFC18800         /* EPPI2 Status Register */
#define REG_EPPI2_HCNT                  0xFFC18804         /* EPPI2 Horizontal Transfer Count Register */
#define REG_EPPI2_HDLY                  0xFFC18808         /* EPPI2 Horizontal Delay Count Register */
#define REG_EPPI2_VCNT                  0xFFC1880C         /* EPPI2 Vertical Transfer Count Register */
#define REG_EPPI2_VDLY                  0xFFC18810         /* EPPI2 Vertical Delay Count Register */
#define REG_EPPI2_FRAME                 0xFFC18814         /* EPPI2 Lines Per Frame Register */
#define REG_EPPI2_LINE                  0xFFC18818         /* EPPI2 Samples Per Line Register */
#define REG_EPPI2_CLKDIV                0xFFC1881C         /* EPPI2 Clock Divide Register */
#define REG_EPPI2_CTL                   0xFFC18820         /* EPPI2 Control Register */
#define REG_EPPI2_FS1_WLHB              0xFFC18824         /* EPPI2 FS1 Width Register / EPPI Horizontal Blanking Samples Per Line Register */
#define REG_EPPI2_FS1_PASPL             0xFFC18828         /* EPPI2 FS1 Period Register / EPPI Active Samples Per Line Register */
#define REG_EPPI2_FS2_WLVB              0xFFC1882C         /* EPPI2 FS2 Width Register / EPPI Lines Of Vertical Blanking Register */
#define REG_EPPI2_FS2_PALPF             0xFFC18830         /* EPPI2 FS2 Period Register / EPPI Active Lines Per Field Register */
#define REG_EPPI2_IMSK                  0xFFC18834         /* EPPI2 Interrupt Mask Register */
#define REG_EPPI2_ODDCLIP               0xFFC1883C         /* EPPI2 Clipping Register for ODD (Chroma) Data */
#define REG_EPPI2_EVENCLIP              0xFFC18840         /* EPPI2 Clipping Register for EVEN (Luma) Data */
#define REG_EPPI2_FS1_DLY               0xFFC18844         /* EPPI2 Frame Sync 1 Delay Value */
#define REG_EPPI2_FS2_DLY               0xFFC18848         /* EPPI2 Frame Sync 2 Delay Value */
#define REG_EPPI2_CTL2                  0xFFC1884C         /* EPPI2 Control Register 2 */

/* =========================
        EPPI
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_STAT                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_STAT_FLD                   15                               /* Current Field Received by EPPI */
#define BITP_EPPI_STAT_ERRDET                14                               /* Preamble Error Detected */
#define BITP_EPPI_STAT_PXPERR                 7                               /* PxP Ready Error */
#define BITP_EPPI_STAT_ERRNCOR                6                               /* Preamble Error Not Corrected */
#define BITP_EPPI_STAT_FTERRUNDR              5                               /* Frame Track Underflow */
#define BITP_EPPI_STAT_FTERROVR               4                               /* Frame Track Overflow */
#define BITP_EPPI_STAT_LTERRUNDR              3                               /* Line Track Underflow */
#define BITP_EPPI_STAT_LTERROVR               2                               /* Line Track Overflow */
#define BITP_EPPI_STAT_YFIFOERR               1                               /* Luma FIFO Error */
#define BITP_EPPI_STAT_CFIFOERR               0                               /* Chroma FIFO Error */

#define BITM_EPPI_STAT_FLD                   (_ADI_MSK(0x00008000,uint32_t))  /* Current Field Received by EPPI */
#define ENUM_EPPI_STAT_FIELD1                (_ADI_MSK(0x00000000,uint32_t))  /* FLD: Field 1 */
#define ENUM_EPPI_STAT_FIELD2                (_ADI_MSK(0x00008000,uint32_t))  /* FLD: Field 2 */

#define BITM_EPPI_STAT_ERRDET                (_ADI_MSK(0x00004000,uint32_t))  /* Preamble Error Detected */
#define ENUM_EPPI_STAT_NO_PRERR              (_ADI_MSK(0x00000000,uint32_t))  /* ERRDET: No preamble error detected */
#define ENUM_EPPI_STAT_PRERR                 (_ADI_MSK(0x00004000,uint32_t))  /* ERRDET: Preamble error detected */
#define BITM_EPPI_STAT_PXPERR                (_ADI_MSK(0x00000080,uint32_t))  /* PxP Ready Error */

#define BITM_EPPI_STAT_ERRNCOR               (_ADI_MSK(0x00000040,uint32_t))  /* Preamble Error Not Corrected */
#define ENUM_EPPI_STAT_NO_ERRNCOR            (_ADI_MSK(0x00000000,uint32_t))  /* ERRNCOR: No uncorrected preamble error has occurred */
#define ENUM_EPPI_STAT_ERRNCOR               (_ADI_MSK(0x00000040,uint32_t))  /* ERRNCOR: Preamble error detected but not corrected */

#define BITM_EPPI_STAT_FTERRUNDR             (_ADI_MSK(0x00000020,uint32_t))  /* Frame Track Underflow */
#define ENUM_EPPI_STAT_NO_FTERRUNDR          (_ADI_MSK(0x00000000,uint32_t))  /* FTERRUNDR: No Error Detected */
#define ENUM_EPPI_STAT_FTERRUNDR             (_ADI_MSK(0x00000020,uint32_t))  /* FTERRUNDR: Error Occurred */

#define BITM_EPPI_STAT_FTERROVR              (_ADI_MSK(0x00000010,uint32_t))  /* Frame Track Overflow */
#define ENUM_EPPI_STAT_NO_FTERROVR           (_ADI_MSK(0x00000000,uint32_t))  /* FTERROVR: No Error Detected */
#define ENUM_EPPI_STAT_FTERROVR              (_ADI_MSK(0x00000010,uint32_t))  /* FTERROVR: Error Occurred */

#define BITM_EPPI_STAT_LTERRUNDR             (_ADI_MSK(0x00000008,uint32_t))  /* Line Track Underflow */
#define ENUM_EPPI_STAT_NO_LTERRUNDR          (_ADI_MSK(0x00000000,uint32_t))  /* LTERRUNDR: No Error Detected */
#define ENUM_EPPI_STAT_LTERRUNDR             (_ADI_MSK(0x00000008,uint32_t))  /* LTERRUNDR: Error Occurred */

#define BITM_EPPI_STAT_LTERROVR              (_ADI_MSK(0x00000004,uint32_t))  /* Line Track Overflow */
#define ENUM_EPPI_STAT_NO_LTERROVR           (_ADI_MSK(0x00000000,uint32_t))  /* LTERROVR: No Error Detected */
#define ENUM_EPPI_STAT_LTERROVR              (_ADI_MSK(0x00000004,uint32_t))  /* LTERROVR: Error Occurred */

#define BITM_EPPI_STAT_YFIFOERR              (_ADI_MSK(0x00000002,uint32_t))  /* Luma FIFO Error */
#define ENUM_EPPI_STAT_NO_YFIFOERR           (_ADI_MSK(0x00000000,uint32_t))  /* YFIFOERR: No Error Detected */
#define ENUM_EPPI_STAT_YFIFOERR              (_ADI_MSK(0x00000002,uint32_t))  /* YFIFOERR: Error Occurred */

#define BITM_EPPI_STAT_CFIFOERR              (_ADI_MSK(0x00000001,uint32_t))  /* Chroma FIFO Error */
#define ENUM_EPPI_STAT_NO_CFIFOERR           (_ADI_MSK(0x00000000,uint32_t))  /* CFIFOERR: No Error Detected */
#define ENUM_EPPI_STAT_CFIFOERR              (_ADI_MSK(0x00000001,uint32_t))  /* CFIFOERR: Error Occurred */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_HCNT                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_HCNT_VALUE                  0                               /* Horizontal Transfer Count */
#define BITM_EPPI_HCNT_VALUE                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Horizontal Transfer Count */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_HDLY                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_HDLY_VALUE                  0                               /* Horizontal Delay Count */
#define BITM_EPPI_HDLY_VALUE                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Horizontal Delay Count */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_VCNT                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_VCNT_VALUE                  0                               /* Vertical Transfer Count */
#define BITM_EPPI_VCNT_VALUE                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Vertical Transfer Count */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_VDLY                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_VDLY_VALUE                  0                               /* Vertical Delay Count */
#define BITM_EPPI_VDLY_VALUE                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Vertical Delay Count */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_FRAME                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_FRAME_VALUE                 0                               /* Lines Per Frame */
#define BITM_EPPI_FRAME_VALUE                (_ADI_MSK(0x0000FFFF,uint32_t))  /* Lines Per Frame */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_LINE                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_LINE_VALUE                  0                               /* Samples Per Line */
#define BITM_EPPI_LINE_VALUE                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Samples Per Line */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_CLKDIV                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_CLKDIV_VALUE                0                               /* Internal Clock Divider */
#define BITM_EPPI_CLKDIV_VALUE               (_ADI_MSK(0x0000FFFF,uint32_t))  /* Internal Clock Divider */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_CTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_CTL_CLKGATEN               31                               /* Clock Gating Enable */
#define BITP_EPPI_CTL_MUXSEL                 30                               /* MUX Select */
#define BITP_EPPI_CTL_DMAFINEN               29                               /* DMA Finish Enable */
#define BITP_EPPI_CTL_DMACFG                 28                               /* One or Two DMA Channels Mode */
#define BITP_EPPI_CTL_RGBFMTEN               27                               /* RGB Formatting Enable */
#define BITP_EPPI_CTL_SPLTWRD                26                               /* Split Word */
#define BITP_EPPI_CTL_SUBSPLTODD             25                               /* Sub-Split Odd Samples */
#define BITP_EPPI_CTL_SPLTEO                 24                               /* Split Even and Odd Data Samples */
#define BITP_EPPI_CTL_SWAPEN                 23                               /* Swap Enable */
#define BITP_EPPI_CTL_PACKEN                 22                               /* Pack/Unpack Enable */
#define BITP_EPPI_CTL_SKIPEO                 21                               /* Skip Even or Odd */
#define BITP_EPPI_CTL_SKIPEN                 20                               /* Skip Enable */
#define BITP_EPPI_CTL_DMIRR                  19                               /* Data Mirroring */
#define BITP_EPPI_CTL_DLEN                   16                               /* Data Length */
#define BITP_EPPI_CTL_POLS                   14                               /* Frame Sync Polarity */
#define BITP_EPPI_CTL_POLC                   12                               /* Clock Polarity */
#define BITP_EPPI_CTL_SIGNEXT                11                               /* Sign Extension */
#define BITP_EPPI_CTL_IFSGEN                 10                               /* Internal Frame Sync Generation */
#define BITP_EPPI_CTL_ICLKGEN                 9                               /* Internal Clock Generation */
#define BITP_EPPI_CTL_BLANKGEN                8                               /* king Generation (ITU Output Mode) */
#define BITP_EPPI_CTL_ITUTYPE                 7                               /* ITU Interlace or Progressive */
#define BITP_EPPI_CTL_FLDSEL                  6                               /* Field Select/Trigger */
#define BITP_EPPI_CTL_FSCFG                   4                               /* Frame Sync Configuration */
#define BITP_EPPI_CTL_XFRTYPE                 2                               /* Transfer Type ( Operating Mode) */
#define BITP_EPPI_CTL_DIR                     1                               /* PPI Direction */
#define BITP_EPPI_CTL_EN                      0                               /* PPI Enable */

#define BITM_EPPI_CTL_CLKGATEN               (_ADI_MSK(0x80000000,uint32_t))  /* Clock Gating Enable */
#define ENUM_EPPI_CTL_CLKGATE_DIS            (_ADI_MSK(0x00000000,uint32_t))  /* CLKGATEN: Disable */
#define ENUM_EPPI_CTL_CLKGATE_EN             (_ADI_MSK(0x80000000,uint32_t))  /* CLKGATEN: Enable */

#define BITM_EPPI_CTL_MUXSEL                 (_ADI_MSK(0x40000000,uint32_t))  /* MUX Select */
#define ENUM_EPPI_CTL_MUXSEL0                (_ADI_MSK(0x00000000,uint32_t))  /* MUXSEL: Normal Operation */
#define ENUM_EPPI_CTL_MUXSEL1                (_ADI_MSK(0x40000000,uint32_t))  /* MUXSEL: Multiplexed Operation */

#define BITM_EPPI_CTL_DMAFINEN               (_ADI_MSK(0x20000000,uint32_t))  /* DMA Finish Enable */
#define ENUM_EPPI_CTL_FINISH_DIS             (_ADI_MSK(0x00000000,uint32_t))  /* DMAFINEN: No Finish Command */
#define ENUM_EPPI_CTL_FINISH_EN              (_ADI_MSK(0x20000000,uint32_t))  /* DMAFINEN: Enable Send Finish Command */

#define BITM_EPPI_CTL_DMACFG                 (_ADI_MSK(0x10000000,uint32_t))  /* One or Two DMA Channels Mode */
#define ENUM_EPPI_CTL_DMA1CHAN               (_ADI_MSK(0x00000000,uint32_t))  /* DMACFG: PPI uses one DMA Channel */
#define ENUM_EPPI_CTL_DMA2CHAN               (_ADI_MSK(0x10000000,uint32_t))  /* DMACFG: PPI uses two DMA Channels */

#define BITM_EPPI_CTL_RGBFMTEN               (_ADI_MSK(0x08000000,uint32_t))  /* RGB Formatting Enable */
#define ENUM_EPPI_CTL_RGBFMT_DIS             (_ADI_MSK(0x00000000,uint32_t))  /* RGBFMTEN: Disable RGB Formatted Output */
#define ENUM_EPPI_CTL_RGBFMT_EN              (_ADI_MSK(0x08000000,uint32_t))  /* RGBFMTEN: Enable RGB Formatted Output */

#define BITM_EPPI_CTL_SPLTWRD                (_ADI_MSK(0x04000000,uint32_t))  /* Split Word */
#define ENUM_EPPI_CTL_NO_WORDSPLIT           (_ADI_MSK(0x00000000,uint32_t))  /* SPLTWRD: PPI_DATA has (DLEN-1) bits of Y or Cr or Cb */
#define ENUM_EPPI_CTL_WORDSPLIT              (_ADI_MSK(0x04000000,uint32_t))  /* SPLTWRD: PPI_DATA contains 2 elements per word */

#define BITM_EPPI_CTL_SUBSPLTODD             (_ADI_MSK(0x02000000,uint32_t))  /* Sub-Split Odd Samples */
#define ENUM_EPPI_CTL_NO_SUBSPLIT            (_ADI_MSK(0x00000000,uint32_t))  /* SUBSPLTODD: Disable */
#define ENUM_EPPI_CTL_SUBSPLIT_ODD           (_ADI_MSK(0x02000000,uint32_t))  /* SUBSPLTODD: Enable */

#define BITM_EPPI_CTL_SPLTEO                 (_ADI_MSK(0x01000000,uint32_t))  /* Split Even and Odd Data Samples */
#define ENUM_EPPI_CTL_SPLTEO_DIS             (_ADI_MSK(0x00000000,uint32_t))  /* SPLTEO: Do Not Split Samples */
#define ENUM_EPPI_CTL_SPLTEO_EN              (_ADI_MSK(0x01000000,uint32_t))  /* SPLTEO: Split Even/Odd Samples */

#define BITM_EPPI_CTL_SWAPEN                 (_ADI_MSK(0x00800000,uint32_t))  /* Swap Enable */
#define ENUM_EPPI_CTL_SWAP_DIS               (_ADI_MSK(0x00000000,uint32_t))  /* SWAPEN: Disable */
#define ENUM_EPPI_CTL_SWAP_EN                (_ADI_MSK(0x00800000,uint32_t))  /* SWAPEN: Enable */

#define BITM_EPPI_CTL_PACKEN                 (_ADI_MSK(0x00400000,uint32_t))  /* Pack/Unpack Enable */
#define ENUM_EPPI_CTL_PACK_DIS               (_ADI_MSK(0x00000000,uint32_t))  /* PACKEN: Disable */
#define ENUM_EPPI_CTL_PACK_EN                (_ADI_MSK(0x00400000,uint32_t))  /* PACKEN: Enable */

#define BITM_EPPI_CTL_SKIPEO                 (_ADI_MSK(0x00200000,uint32_t))  /* Skip Even or Odd */
#define ENUM_EPPI_CTL_SKIPODD                (_ADI_MSK(0x00000000,uint32_t))  /* SKIPEO: Skip Odd Samples */
#define ENUM_EPPI_CTL_SKIPEVEN               (_ADI_MSK(0x00200000,uint32_t))  /* SKIPEO: Skip Even Samples */

#define BITM_EPPI_CTL_SKIPEN                 (_ADI_MSK(0x00100000,uint32_t))  /* Skip Enable */
#define ENUM_EPPI_CTL_NO_SKIP                (_ADI_MSK(0x00000000,uint32_t))  /* SKIPEN: No Samples Skipping */
#define ENUM_EPPI_CTL_SKIP                   (_ADI_MSK(0x00100000,uint32_t))  /* SKIPEN: Skip Alternate Samples */

#define BITM_EPPI_CTL_DMIRR                  (_ADI_MSK(0x00080000,uint32_t))  /* Data Mirroring */
#define ENUM_EPPI_CTL_NO_MIRROR              (_ADI_MSK(0x00000000,uint32_t))  /* DMIRR: No Data Mirroring */
#define ENUM_EPPI_CTL_MIRROR                 (_ADI_MSK(0x00080000,uint32_t))  /* DMIRR: Data Mirroring */

#define BITM_EPPI_CTL_DLEN                   (_ADI_MSK(0x00070000,uint32_t))  /* Data Length */
#define ENUM_EPPI_CTL_DLEN08                 (_ADI_MSK(0x00000000,uint32_t))  /* DLEN: 8 bits */
#define ENUM_EPPI_CTL_DLEN10                 (_ADI_MSK(0x00010000,uint32_t))  /* DLEN: 10 bits */
#define ENUM_EPPI_CTL_DLEN12                 (_ADI_MSK(0x00020000,uint32_t))  /* DLEN: 12 bits */
#define ENUM_EPPI_CTL_DLEN14                 (_ADI_MSK(0x00030000,uint32_t))  /* DLEN: 14 bits */
#define ENUM_EPPI_CTL_DLEN16                 (_ADI_MSK(0x00040000,uint32_t))  /* DLEN: 16 bits */
#define ENUM_EPPI_CTL_DLEN18                 (_ADI_MSK(0x00050000,uint32_t))  /* DLEN: 18 bits */
#define ENUM_EPPI_CTL_DLEN20                 (_ADI_MSK(0x00060000,uint32_t))  /* DLEN: 20 bits */
#define ENUM_EPPI_CTL_DLEN24                 (_ADI_MSK(0x00070000,uint32_t))  /* DLEN: 24 bits */

#define BITM_EPPI_CTL_POLS                   (_ADI_MSK(0x0000C000,uint32_t))  /* Frame Sync Polarity */
#define ENUM_EPPI_CTL_FS1HI_FS2HI            (_ADI_MSK(0x00000000,uint32_t))  /* POLS: FS1 and FS2 are active high */
#define ENUM_EPPI_CTL_FS1LO_FS2HI            (_ADI_MSK(0x00004000,uint32_t))  /* POLS: FS1 is active low. FS2 is active high */
#define ENUM_EPPI_CTL_FS1HI_FS2LO            (_ADI_MSK(0x00008000,uint32_t))  /* POLS: FS1 is active high. FS2 is active low */
#define ENUM_EPPI_CTL_FS1LO_FS2LO            (_ADI_MSK(0x0000C000,uint32_t))  /* POLS: FS1 and FS2 are active low */

#define BITM_EPPI_CTL_POLC                   (_ADI_MSK(0x00003000,uint32_t))  /* Clock Polarity */
#define ENUM_EPPI_CTL_POLC00                 (_ADI_MSK(0x00000000,uint32_t))  /* POLC: Clock/Sync polarity mode 0 */
#define ENUM_EPPI_CTL_POLC01                 (_ADI_MSK(0x00001000,uint32_t))  /* POLC: Clock/Sync polarity mode 1 */
#define ENUM_EPPI_CTL_POLC10                 (_ADI_MSK(0x00002000,uint32_t))  /* POLC: Clock/Sync polarity mode 2 */
#define ENUM_EPPI_CTL_POLC11                 (_ADI_MSK(0x00003000,uint32_t))  /* POLC: Clock/Sync polarity mode 3 */

#define BITM_EPPI_CTL_SIGNEXT                (_ADI_MSK(0x00000800,uint32_t))  /* Sign Extension */
#define ENUM_EPPI_CTL_ZEROFILL               (_ADI_MSK(0x00000000,uint32_t))  /* SIGNEXT: Zero Filled */
#define ENUM_EPPI_CTL_SIGNEXT                (_ADI_MSK(0x00000800,uint32_t))  /* SIGNEXT: Sign Extended */

#define BITM_EPPI_CTL_IFSGEN                 (_ADI_MSK(0x00000400,uint32_t))  /* Internal Frame Sync Generation */
#define ENUM_EPPI_CTL_EXTFS                  (_ADI_MSK(0x00000000,uint32_t))  /* IFSGEN: External Frame Sync */
#define ENUM_EPPI_CTL_INTFS                  (_ADI_MSK(0x00000400,uint32_t))  /* IFSGEN: Internal Frame Sync */

#define BITM_EPPI_CTL_ICLKGEN                (_ADI_MSK(0x00000200,uint32_t))  /* Internal Clock Generation */
#define ENUM_EPPI_CTL_EXTCLK                 (_ADI_MSK(0x00000000,uint32_t))  /* ICLKGEN: External Clock */
#define ENUM_EPPI_CTL_INTCLK                 (_ADI_MSK(0x00000200,uint32_t))  /* ICLKGEN: Internal Clock */

#define BITM_EPPI_CTL_BLANKGEN               (_ADI_MSK(0x00000100,uint32_t))  /* king Generation (ITU Output Mode) */
#define ENUM_EPPI_CTL_NO_BLANKGEN            (_ADI_MSK(0x00000000,uint32_t))  /* BLANKGEN: Disable */
#define ENUM_EPPI_CTL_BLANKGEN               (_ADI_MSK(0x00000100,uint32_t))  /* BLANKGEN: Enable */

#define BITM_EPPI_CTL_ITUTYPE                (_ADI_MSK(0x00000080,uint32_t))  /* ITU Interlace or Progressive */
#define ENUM_EPPI_CTL_INTERLACED             (_ADI_MSK(0x00000000,uint32_t))  /* ITUTYPE: Interlaced */
#define ENUM_EPPI_CTL_PROGRESSIVE            (_ADI_MSK(0x00000080,uint32_t))  /* ITUTYPE: Progressive */

#define BITM_EPPI_CTL_FLDSEL                 (_ADI_MSK(0x00000040,uint32_t))  /* Field Select/Trigger */
#define ENUM_EPPI_CTL_FLDSEL_LO              (_ADI_MSK(0x00000000,uint32_t))  /* FLDSEL: Field Mode 0 */
#define ENUM_EPPI_CTL_FLDSEL_HI              (_ADI_MSK(0x00000040,uint32_t))  /* FLDSEL: Field Mode 1 */

#define BITM_EPPI_CTL_FSCFG                  (_ADI_MSK(0x00000030,uint32_t))  /* Frame Sync Configuration */
#define ENUM_EPPI_CTL_SYNC0                  (_ADI_MSK(0x00000000,uint32_t))  /* FSCFG: Sync Mode 0 */
#define ENUM_EPPI_CTL_SYNC1                  (_ADI_MSK(0x00000010,uint32_t))  /* FSCFG: Sync Mode 1 */
#define ENUM_EPPI_CTL_SYNC2                  (_ADI_MSK(0x00000020,uint32_t))  /* FSCFG: Sync Mode 2 */
#define ENUM_EPPI_CTL_SYNC3                  (_ADI_MSK(0x00000030,uint32_t))  /* FSCFG: Sync Mode 3 */

#define BITM_EPPI_CTL_XFRTYPE                (_ADI_MSK(0x0000000C,uint32_t))  /* Transfer Type ( Operating Mode) */
#define ENUM_EPPI_CTL_ACTIVE656              (_ADI_MSK(0x00000000,uint32_t))  /* XFRTYPE: ITU656 Active Video Only Mode */
#define ENUM_EPPI_CTL_ENTIRE656              (_ADI_MSK(0x00000004,uint32_t))  /* XFRTYPE: ITU656 Entire Field Mode */
#define ENUM_EPPI_CTL_VERT656                (_ADI_MSK(0x00000008,uint32_t))  /* XFRTYPE: ITU656 Vertical Blanking Only Mode */
#define ENUM_EPPI_CTL_NON656                 (_ADI_MSK(0x0000000C,uint32_t))  /* XFRTYPE: Non-ITU656 Mode (GP Mode) */

#define BITM_EPPI_CTL_DIR                    (_ADI_MSK(0x00000002,uint32_t))  /* PPI Direction */
#define ENUM_EPPI_CTL_RXMODE                 (_ADI_MSK(0x00000000,uint32_t))  /* DIR: Receive Mode */
#define ENUM_EPPI_CTL_TXMODE                 (_ADI_MSK(0x00000002,uint32_t))  /* DIR: Transmit Mode */

#define BITM_EPPI_CTL_EN                     (_ADI_MSK(0x00000001,uint32_t))  /* PPI Enable */
#define ENUM_EPPI_CTL_DIS                    (_ADI_MSK(0x00000000,uint32_t))  /* EN: Disable */
#define ENUM_EPPI_CTL_EN                     (_ADI_MSK(0x00000001,uint32_t))  /* EN: Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_FS2_WLVB                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_FS2_WLVB_F2VBAD            24                               /* Field 2 Vertical Blanking After Data */
#define BITP_EPPI_FS2_WLVB_F2VBBD            16                               /* Field 2 Vertical Blanking Before Data */
#define BITP_EPPI_FS2_WLVB_F1VBAD             8                               /* Field 1 Vertical Blanking After Data */
#define BITP_EPPI_FS2_WLVB_F1VBBD             0                               /* Field 1 Vertical Blanking Before Data */
#define BITM_EPPI_FS2_WLVB_F2VBAD            (_ADI_MSK(0xFF000000,uint32_t))  /* Field 2 Vertical Blanking After Data */
#define BITM_EPPI_FS2_WLVB_F2VBBD            (_ADI_MSK(0x00FF0000,uint32_t))  /* Field 2 Vertical Blanking Before Data */
#define BITM_EPPI_FS2_WLVB_F1VBAD            (_ADI_MSK(0x0000FF00,uint32_t))  /* Field 1 Vertical Blanking After Data */
#define BITM_EPPI_FS2_WLVB_F1VBBD            (_ADI_MSK(0x000000FF,uint32_t))  /* Field 1 Vertical Blanking Before Data */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_FS2_PALPF                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_FS2_PALPF_F2ACT            16                               /* Field 2 Active */
#define BITP_EPPI_FS2_PALPF_F1ACT             0                               /* Field 1 Active */
#define BITM_EPPI_FS2_PALPF_F2ACT            (_ADI_MSK(0xFFFF0000,uint32_t))  /* Field 2 Active */
#define BITM_EPPI_FS2_PALPF_F1ACT            (_ADI_MSK(0x0000FFFF,uint32_t))  /* Field 1 Active */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_IMSK                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_IMSK_PXPERR                 7                               /* PxP Ready Error Interrupt Mask */
#define BITP_EPPI_IMSK_ERRNCOR                6                               /* ITU Preamble Error Not Corrected Interrupt Mask */
#define BITP_EPPI_IMSK_FTERRUNDR              5                               /* Frame Track Underflow Error Interrupt Mask */
#define BITP_EPPI_IMSK_FTERROVR               4                               /* Frame Track Overflow Error Interrupt Mask */
#define BITP_EPPI_IMSK_LTERRUNDR              3                               /* Line Track Underflow Error Interrupt Mask */
#define BITP_EPPI_IMSK_LTERROVR               2                               /* Line Track Overflow Error Interrupt Mask */
#define BITP_EPPI_IMSK_YFIFOERR               1                               /* YFIFO Underflow or Overflow Error Interrupt Mask */
#define BITP_EPPI_IMSK_CFIFOERR               0                               /* CFIFO Underflow or Overflow Error Interrupt Mask */

#define BITM_EPPI_IMSK_PXPERR                (_ADI_MSK(0x00000080,uint32_t))  /* PxP Ready Error Interrupt Mask */
#define ENUM_EPPI_IMSK_PXPERR_UMSK           (_ADI_MSK(0x00000000,uint32_t))  /* PXPERR: Unmask Interrupt */
#define ENUM_EPPI_IMSK_PXPERR_MSK            (_ADI_MSK(0x00000080,uint32_t))  /* PXPERR: Mask Interrupt */

#define BITM_EPPI_IMSK_ERRNCOR               (_ADI_MSK(0x00000040,uint32_t))  /* ITU Preamble Error Not Corrected Interrupt Mask */
#define ENUM_EPPI_IMSK_ERRNCOR_UMSK          (_ADI_MSK(0x00000000,uint32_t))  /* ERRNCOR: Unmask Interrupt */
#define ENUM_EPPI_IMSK_ERRNCOR_MSK           (_ADI_MSK(0x00000040,uint32_t))  /* ERRNCOR: Mask Interrupt */

#define BITM_EPPI_IMSK_FTERRUNDR             (_ADI_MSK(0x00000020,uint32_t))  /* Frame Track Underflow Error Interrupt Mask */
#define ENUM_EPPI_IMSK_FTERRUNDR_UMSK        (_ADI_MSK(0x00000000,uint32_t))  /* FTERRUNDR: Unmask Interrupt */
#define ENUM_EPPI_IMSK_FTERRUNDR_MSK         (_ADI_MSK(0x00000020,uint32_t))  /* FTERRUNDR: Mask Interrupt */

#define BITM_EPPI_IMSK_FTERROVR              (_ADI_MSK(0x00000010,uint32_t))  /* Frame Track Overflow Error Interrupt Mask */
#define ENUM_EPPI_IMSK_FTERROVR_UMSK         (_ADI_MSK(0x00000000,uint32_t))  /* FTERROVR: Unmask Interrupt */
#define ENUM_EPPI_IMSK_FTERROVR_MSK          (_ADI_MSK(0x00000010,uint32_t))  /* FTERROVR: Mask Interrupt */

#define BITM_EPPI_IMSK_LTERRUNDR             (_ADI_MSK(0x00000008,uint32_t))  /* Line Track Underflow Error Interrupt Mask */
#define ENUM_EPPI_IMSK_LTERRUNDR_UMSK        (_ADI_MSK(0x00000000,uint32_t))  /* LTERRUNDR: Unmask Interrupt */
#define ENUM_EPPI_IMSK_LTERRUNDR_MSK         (_ADI_MSK(0x00000008,uint32_t))  /* LTERRUNDR: Mask Interrupt */

#define BITM_EPPI_IMSK_LTERROVR              (_ADI_MSK(0x00000004,uint32_t))  /* Line Track Overflow Error Interrupt Mask */
#define ENUM_EPPI_IMSK_LTERROVR_UMSK         (_ADI_MSK(0x00000000,uint32_t))  /* LTERROVR: Unmask Interrupt */
#define ENUM_EPPI_IMSK_LTERROVR_MSK          (_ADI_MSK(0x00000004,uint32_t))  /* LTERROVR: Mask Interrupt */

#define BITM_EPPI_IMSK_YFIFOERR              (_ADI_MSK(0x00000002,uint32_t))  /* YFIFO Underflow or Overflow Error Interrupt Mask */
#define ENUM_EPPI_IMSK_YFIFOERR_UMSK         (_ADI_MSK(0x00000000,uint32_t))  /* YFIFOERR: Unmask Interrupt */
#define ENUM_EPPI_IMSK_YFIFOERR_MSK          (_ADI_MSK(0x00000002,uint32_t))  /* YFIFOERR: Mask Interrupt */

#define BITM_EPPI_IMSK_CFIFOERR              (_ADI_MSK(0x00000001,uint32_t))  /* CFIFO Underflow or Overflow Error Interrupt Mask */
#define ENUM_EPPI_IMSK_CFIFOERR_UMSK         (_ADI_MSK(0x00000000,uint32_t))  /* CFIFOERR: Unmask Interrupt */
#define ENUM_EPPI_IMSK_CFIFOERR_MSK          (_ADI_MSK(0x00000001,uint32_t))  /* CFIFOERR: Mask Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_ODDCLIP                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_ODDCLIP_HIGHODD            16                               /* High Odd Clipping Threshold (Chroma Data) */
#define BITP_EPPI_ODDCLIP_LOWODD              0                               /* Low Odd Clipping Threshold (Chroma Data) */
#define BITM_EPPI_ODDCLIP_HIGHODD            (_ADI_MSK(0xFFFF0000,uint32_t))  /* High Odd Clipping Threshold (Chroma Data) */
#define BITM_EPPI_ODDCLIP_LOWODD             (_ADI_MSK(0x0000FFFF,uint32_t))  /* Low Odd Clipping Threshold (Chroma Data) */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_EVENCLIP                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_EVENCLIP_HIGHEVEN          16                               /* High Even Clipping Threshold (Luma Data) */
#define BITP_EPPI_EVENCLIP_LOWEVEN            0                               /* Low Even Clipping Threshold (Luma Data) */
#define BITM_EPPI_EVENCLIP_HIGHEVEN          (_ADI_MSK(0xFFFF0000,uint32_t))  /* High Even Clipping Threshold (Luma Data) */
#define BITM_EPPI_EVENCLIP_LOWEVEN           (_ADI_MSK(0x0000FFFF,uint32_t))  /* Low Even Clipping Threshold (Luma Data) */

/* ------------------------------------------------------------------------------------------------------------------------
        EPPI_CTL2                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EPPI_CTL2_FS1FINEN               1                               /* HSYNC Finish Enable */

#define BITM_EPPI_CTL2_FS1FINEN              (_ADI_MSK(0x00000002,uint32_t))  /* HSYNC Finish Enable */
#define ENUM_EPPI_CTL2_FS2FIN_EN             (_ADI_MSK(0x00000000,uint32_t))  /* FS1FINEN: Finish sent after frame RX done */
#define ENUM_EPPI_CTL2_FS1FIN_EN             (_ADI_MSK(0x00000002,uint32_t))  /* FS1FINEN: Finish sent after frame/line RX done */

/* ==================================================
        Pixel Compositor Registers
   ================================================== */

/* =========================
        PIXC0
   ========================= */
#define REG_PIXC0_CTL                   0xFFC19000         /* PIXC0 Control Register */
#define REG_PIXC0_PPL                   0xFFC19004         /* PIXC0 Pixels Per Line Register */
#define REG_PIXC0_LPF                   0xFFC19008         /* PIXC0 Line Per Frame Register */
#define REG_PIXC0_HSTART_A              0xFFC1900C         /* PIXC0 Overlay A Horizontal Start Register */
#define REG_PIXC0_HEND_A                0xFFC19010         /* PIXC0 Overlay A Horizontal End Register */
#define REG_PIXC0_VSTART_A              0xFFC19014         /* PIXC0 Overlay A Vertical Start Register */
#define REG_PIXC0_VEND_A                0xFFC19018         /* PIXC0 Overlay A Vertical End Register */
#define REG_PIXC0_TRANSP_A              0xFFC1901C         /* PIXC0 Overlay A Transparency Ratio Register */
#define REG_PIXC0_HSTART_B              0xFFC19020         /* PIXC0 Overlay B Horizontal Start Register */
#define REG_PIXC0_HEND_B                0xFFC19024         /* PIXC0 Overlay B Horizontal End Register */
#define REG_PIXC0_VSTART_B              0xFFC19028         /* PIXC0 Overlay B Vertical Start Register */
#define REG_PIXC0_VEND_B                0xFFC1902C         /* PIXC0 Overlay B Vertical End Register */
#define REG_PIXC0_TRANSP_B              0xFFC19030         /* PIXC0 Overlay B Transparency Ratio Register */
#define REG_PIXC0_IRQSTAT               0xFFC1903C         /* PIXC0 Interrupt Status Register */
#define REG_PIXC0_CONRY                 0xFFC19040         /* PIXC0 RY Conversion Component Register */
#define REG_PIXC0_CONGU                 0xFFC19044         /* PIXC0 GU Conversion Component Register */
#define REG_PIXC0_CONBV                 0xFFC19048         /* PIXC0 BV Conversion Component Register */
#define REG_PIXC0_CCBIAS                0xFFC1904C         /* PIXC0 Conversion Bias Register */
#define REG_PIXC0_TC                    0xFFC19050         /* PIXC0 Transparency Color Register */
#define REG_PIXC0_REVID                 0xFFC19054         /* PIXC0 Revision Id */

/* =========================
        PIXC
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_CTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_CTL_ORGBFRMT               10                               /* Output RGB Data Format */
#define BITP_PIXC_CTL_IRGBFRMT                8                               /* Input Image Channel RGB Data Format */
#define BITP_PIXC_CTL_ENTC                    7                               /* Enable Transparent Color */
#define BITP_PIXC_CTL_UDSMOD                  6                               /* Up/Down Sampling Mode */
#define BITP_PIXC_CTL_OUTFRMT                 5                               /* Output Data Format */
#define BITP_PIXC_CTL_OVFRMT                  4                               /* Overlay Data Format */
#define BITP_PIXC_CTL_IFRMT                   3                               /* Image Data Format */
#define BITP_PIXC_CTL_OVENB                   2                               /* Overlay Block B Enable */
#define BITP_PIXC_CTL_OVENA                   1                               /* Overlay Block A Enable */
#define BITP_PIXC_CTL_EN                      0                               /* Overlay Manager enable (module enable) */
#define BITM_PIXC_CTL_ORGBFRMT               (_ADI_MSK(0x00000C00,uint32_t))  /* Output RGB Data Format */
#define BITM_PIXC_CTL_IRGBFRMT               (_ADI_MSK(0x00000300,uint32_t))  /* Input Image Channel RGB Data Format */
#define BITM_PIXC_CTL_ENTC                   (_ADI_MSK(0x00000080,uint32_t))  /* Enable Transparent Color */
#define BITM_PIXC_CTL_UDSMOD                 (_ADI_MSK(0x00000040,uint32_t))  /* Up/Down Sampling Mode */
#define BITM_PIXC_CTL_OUTFRMT                (_ADI_MSK(0x00000020,uint32_t))  /* Output Data Format */
#define BITM_PIXC_CTL_OVFRMT                 (_ADI_MSK(0x00000010,uint32_t))  /* Overlay Data Format */
#define BITM_PIXC_CTL_IFRMT                  (_ADI_MSK(0x00000008,uint32_t))  /* Image Data Format */
#define BITM_PIXC_CTL_OVENB                  (_ADI_MSK(0x00000004,uint32_t))  /* Overlay Block B Enable */
#define BITM_PIXC_CTL_OVENA                  (_ADI_MSK(0x00000002,uint32_t))  /* Overlay Block A Enable */
#define BITM_PIXC_CTL_EN                     (_ADI_MSK(0x00000001,uint32_t))  /* Overlay Manager enable (module enable) */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_TRANSP_A                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_TRANSP_A_VALUE              0                               /* Overlay Transparency Ratio Values */
#define BITM_PIXC_TRANSP_A_VALUE             (_ADI_MSK(0x0000000F,uint16_t))  /* Overlay Transparency Ratio Values */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_TRANSP_B                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_TRANSP_B_VALUE              0                               /* Overlay Transparency Ratio Values */
#define BITM_PIXC_TRANSP_B_VALUE             (_ADI_MSK(0x0000000F,uint16_t))  /* Overlay Transparency Ratio Values */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_IRQSTAT                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_IRQSTAT_FRMSTAT             3                               /* Frame Interrupt Status */
#define BITP_PIXC_IRQSTAT_OVSTAT              2                               /* Overlay Interrupt Status */
#define BITP_PIXC_IRQSTAT_FRMEN               1                               /* Frame Interrupt  Enable */
#define BITP_PIXC_IRQSTAT_OVEN                0                               /* Overlay Interrupt Enable */
#define BITM_PIXC_IRQSTAT_FRMSTAT            (_ADI_MSK(0x00000008,uint16_t))  /* Frame Interrupt Status */
#define BITM_PIXC_IRQSTAT_OVSTAT             (_ADI_MSK(0x00000004,uint16_t))  /* Overlay Interrupt Status */
#define BITM_PIXC_IRQSTAT_FRMEN              (_ADI_MSK(0x00000002,uint16_t))  /* Frame Interrupt  Enable */
#define BITM_PIXC_IRQSTAT_OVEN               (_ADI_MSK(0x00000001,uint16_t))  /* Overlay Interrupt Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_CONRY                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_CONRY_RYMULT4              30                               /* Multiply the Row by 4 */
#define BITP_PIXC_CONRY_A13                  20                               /* A13 element in the coefficient matrix */
#define BITP_PIXC_CONRY_A12                  10                               /* A12 element in the coefficient matrix */
#define BITP_PIXC_CONRY_A11                   0                               /* A11 element in the coefficient matrix */
#define BITM_PIXC_CONRY_RYMULT4              (_ADI_MSK(0x40000000,uint32_t))  /* Multiply the Row by 4 */
#define BITM_PIXC_CONRY_A13                  (_ADI_MSK(0x3FF00000,uint32_t))  /* A13 element in the coefficient matrix */
#define BITM_PIXC_CONRY_A12                  (_ADI_MSK(0x000FFC00,uint32_t))  /* A12 element in the coefficient matrix */
#define BITM_PIXC_CONRY_A11                  (_ADI_MSK(0x000003FF,uint32_t))  /* A11 element in the coefficient matrix */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_CONGU                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_CONGU_GUMULT4              30                               /* Multiply The Row By 4 */
#define BITP_PIXC_CONGU_A23                  20                               /* A23 element in the coefficient matrix */
#define BITP_PIXC_CONGU_A22                  10                               /* A22 element in the coefficient matrix */
#define BITP_PIXC_CONGU_A21                   0                               /* A21 element in the coefficient matrix */
#define BITM_PIXC_CONGU_GUMULT4              (_ADI_MSK(0x40000000,uint32_t))  /* Multiply The Row By 4 */
#define BITM_PIXC_CONGU_A23                  (_ADI_MSK(0x3FF00000,uint32_t))  /* A23 element in the coefficient matrix */
#define BITM_PIXC_CONGU_A22                  (_ADI_MSK(0x000FFC00,uint32_t))  /* A22 element in the coefficient matrix */
#define BITM_PIXC_CONGU_A21                  (_ADI_MSK(0x000003FF,uint32_t))  /* A21 element in the coefficient matrix */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_CONBV                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_CONBV_BVMULT4              30                               /* Multiply The Row By 4 */
#define BITP_PIXC_CONBV_A33                  20                               /* A33 element in the coefficient matrix */
#define BITP_PIXC_CONBV_A32                  10                               /* A32 element in the coefficient matrix */
#define BITP_PIXC_CONBV_A31                   0                               /* A31 element in the coefficient matrix */
#define BITM_PIXC_CONBV_BVMULT4              (_ADI_MSK(0x40000000,uint32_t))  /* Multiply The Row By 4 */
#define BITM_PIXC_CONBV_A33                  (_ADI_MSK(0x3FF00000,uint32_t))  /* A33 element in the coefficient matrix */
#define BITM_PIXC_CONBV_A32                  (_ADI_MSK(0x000FFC00,uint32_t))  /* A32 element in the coefficient matrix */
#define BITM_PIXC_CONBV_A31                  (_ADI_MSK(0x000003FF,uint32_t))  /* A31 element in the coefficient matrix */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_CCBIAS                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_CCBIAS_A34                 20                               /* A34 in bias vector */
#define BITP_PIXC_CCBIAS_A24                 10                               /* A24 in bias vector */
#define BITP_PIXC_CCBIAS_A14                  0                               /* A14 in bias vector */
#define BITM_PIXC_CCBIAS_A34                 (_ADI_MSK(0x3FF00000,uint32_t))  /* A34 in bias vector */
#define BITM_PIXC_CCBIAS_A24                 (_ADI_MSK(0x000FFC00,uint32_t))  /* A24 in bias vector */
#define BITM_PIXC_CCBIAS_A14                 (_ADI_MSK(0x000003FF,uint32_t))  /* A14 in bias vector */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_TC                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_TC_BVT                     16                               /* Trans. color - B/V component */
#define BITP_PIXC_TC_GUT                      8                               /* Trans. color - G/U component */
#define BITP_PIXC_TC_RYT                      0                               /* Trans. color - R/Y component */
#define BITM_PIXC_TC_BVT                     (_ADI_MSK(0x00FF0000,uint32_t))  /* Trans. color - B/V component */
#define BITM_PIXC_TC_GUT                     (_ADI_MSK(0x0000FF00,uint32_t))  /* Trans. color - G/U component */
#define BITM_PIXC_TC_RYT                     (_ADI_MSK(0x000000FF,uint32_t))  /* Trans. color - R/Y component */

/* ------------------------------------------------------------------------------------------------------------------------
        PIXC_REVID                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PIXC_REVID_MAJOR                 4                               /* Major Version ID */
#define BITP_PIXC_REVID_REV                   0                               /* Incremental Version ID */
#define BITM_PIXC_REVID_MAJOR                (_ADI_MSK(0x000000F0,uint32_t))  /* Major Version ID */
#define BITM_PIXC_REVID_REV                  (_ADI_MSK(0x0000000F,uint32_t))  /* Incremental Version ID */

/* ==================================================
        PVP Registers
   ================================================== */
/* ------------------------------------------------------------------------------------------------------------------------
        PVP                             Block level enums
   ------------------------------------------------------------------------------------------------------------------------ */
#define ENUM_PVP_GCFG                   0x00          /* PVP Block ID Code for GCFG */
#define ENUM_PVP_OPF0                   0x01          /* PVP Block ID Code for OPF0 */
#define ENUM_PVP_OPF1                   0x02          /* PVP Block ID Code for OPF1 */
#define ENUM_PVP_OPF2                   0x03          /* PVP Block ID Code for OPF2 */
#define ENUM_PVP_OPF3                   0x04          /* PVP Block ID Code for OPF3 */
#define ENUM_PVP_PEC                    0x05          /* PVP Block ID Code for PEC */
#define ENUM_PVP_IIM0                   0x06          /* PVP Block ID Code for IIM0 */
#define ENUM_PVP_IIM1                   0x07          /* PVP Block ID Code for IIM1 */
#define ENUM_PVP_ACU                    0x08          /* PVP Block ID Code for ACU */
#define ENUM_PVP_UDS                    0x0A          /* PVP Block ID Code for UDS */
#define ENUM_PVP_IPF0                   0x0C          /* PVP Block ID Code for IPF0 */
#define ENUM_PVP_IPF1                   0x0E          /* PVP Block ID Code for IPF1 */
#define ENUM_PVP_CNV0                   0x10          /* PVP Block ID Code for CNV0 */
#define ENUM_PVP_CNV1                   0x14          /* PVP Block ID Code for CNV1 */
#define ENUM_PVP_CNV2                   0x18          /* PVP Block ID Code for CNV2 */
#define ENUM_PVP_CNV3                   0x1C          /* PVP Block ID Code for CNV3 */
#define ENUM_PVP_THC0                   0x20          /* PVP Block ID Code for THC0 */
#define ENUM_PVP_THC1                   0x28          /* PVP Block ID Code for THC1 */
#define ENUM_PVP_PMA                    0x30          /* PVP Block ID Code for PMA */

/* =========================
        PVP0
   ========================= */
#define REG_PVP0_REVID                  0xFFC1A000         /* PVP0 Revision ID */
#define REG_PVP0_CTL                    0xFFC1A004         /* PVP0 Control */
#define REG_PVP0_IMSK0                  0xFFC1A008         /* PVP0 Interrupt Mask n */
#define REG_PVP0_IMSK1                  0xFFC1A00C         /* PVP0 Interrupt Mask n */
#define REG_PVP0_STAT                   0xFFC1A010         /* PVP0 Status */
#define REG_PVP0_ILAT                   0xFFC1A014         /* PVP0 Interrupt Latch Status n */
#define REG_PVP0_IREQ0                  0xFFC1A018         /* PVP0 Interrupt Request n */
#define REG_PVP0_IREQ1                  0xFFC1A01C         /* PVP0 Interrupt Request n */
#define REG_PVP0_OPF0_CFG               0xFFC1A020         /* PVP0 OPFn (Camera Pipe) Configuration */
#define REG_PVP0_OPF1_CFG               0xFFC1A040         /* PVP0 OPFn (Camera Pipe) Configuration */
#define REG_PVP0_OPF2_CFG               0xFFC1A060         /* PVP0 OPFn (Camera Pipe) Configuration */
#define REG_PVP0_OPF0_CTL               0xFFC1A024         /* PVP0 OPFn (Camera Pipe) Control */
#define REG_PVP0_OPF1_CTL               0xFFC1A044         /* PVP0 OPFn (Camera Pipe) Control */
#define REG_PVP0_OPF2_CTL               0xFFC1A064         /* PVP0 OPFn (Camera Pipe) Control */
#define REG_PVP0_OPF3_CFG               0xFFC1A080         /* PVP0 OPF3 (Memory Pipe) Configuration */
#define REG_PVP0_OPF3_CTL               0xFFC1A084         /* PVP0 OPF3 (Memory Pipe) Control */
#define REG_PVP0_PEC_CFG                0xFFC1A0A0         /* PVP0 PEC Configuration */
#define REG_PVP0_PEC_CTL                0xFFC1A0A4         /* PVP0 PEC Control */
#define REG_PVP0_PEC_D1TH0              0xFFC1A0A8         /* PVP0 PEC Lower Hysteresis Threshold */
#define REG_PVP0_PEC_D1TH1              0xFFC1A0AC         /* PVP0 PEC Upper Hysteresis Threshold */
#define REG_PVP0_PEC_D2TH0              0xFFC1A0B0         /* PVP0 PEC Weak Zero Crossing Threshold */
#define REG_PVP0_PEC_D2TH1              0xFFC1A0B4         /* PVP0 PEC Strong Zero Crossing Threshold */
#define REG_PVP0_IIM0_CFG               0xFFC1A0C0         /* PVP0 IIMn Configuration */
#define REG_PVP0_IIM1_CFG               0xFFC1A0E0         /* PVP0 IIMn Configuration */
#define REG_PVP0_IIM0_CTL               0xFFC1A0C4         /* PVP0 IIMn Control */
#define REG_PVP0_IIM1_CTL               0xFFC1A0E4         /* PVP0 IIMn Control */
#define REG_PVP0_IIM0_SCALE             0xFFC1A0C8         /* PVP0 IIMn Scaling Values */
#define REG_PVP0_IIM1_SCALE             0xFFC1A0E8         /* PVP0 IIMn Scaling Values */
#define REG_PVP0_IIM0_SOVF_STAT         0xFFC1A0CC         /* PVP0 IIMn Signed Overflow Status */
#define REG_PVP0_IIM1_SOVF_STAT         0xFFC1A0EC         /* PVP0 IIMn Signed Overflow Status */
#define REG_PVP0_IIM0_UOVF_STAT         0xFFC1A0D0         /* PVP0 IIMn Unsigned Overflow Status */
#define REG_PVP0_IIM1_UOVF_STAT         0xFFC1A0F0         /* PVP0 IIMn Unsigned Overflow Status */
#define REG_PVP0_ACU_CFG                0xFFC1A100         /* PVP0 ACU Configuration */
#define REG_PVP0_ACU_CTL                0xFFC1A104         /* PVP0 ACU Control */
#define REG_PVP0_ACU_OFFSET             0xFFC1A108         /* PVP0 ACU SUM Constant */
#define REG_PVP0_ACU_FACTOR             0xFFC1A10C         /* PVP0 ACU PROD Constant */
#define REG_PVP0_ACU_SHIFT              0xFFC1A110         /* PVP0 ACU Shift Constant */
#define REG_PVP0_ACU_MIN                0xFFC1A114         /* PVP0 ACU Lower Sat Threshold Min */
#define REG_PVP0_ACU_MAX                0xFFC1A118         /* PVP0 ACU Upper Sat Threshold Max */
#define REG_PVP0_UDS_CFG                0xFFC1A140         /* PVP0 UDS Configuration */
#define REG_PVP0_UDS_CTL                0xFFC1A144         /* PVP0 UDS Control */
#define REG_PVP0_UDS_OHCNT              0xFFC1A148         /* PVP0 UDS Output HCNT */
#define REG_PVP0_UDS_OVCNT              0xFFC1A14C         /* PVP0 UDS Output VCNT */
#define REG_PVP0_UDS_HAVG               0xFFC1A150         /* PVP0 UDS HAVG */
#define REG_PVP0_UDS_VAVG               0xFFC1A154         /* PVP0 UDS VAVG */
#define REG_PVP0_IPF0_CFG               0xFFC1A180         /* PVP0 IPF0 (Camera Pipe) Configuration */
#define REG_PVP0_IPF0_PIPECTL           0xFFC1A184         /* PVP0 IPFn (Camera/Memory Pipe) Pipe Control */
#define REG_PVP0_IPF1_PIPECTL           0xFFC1A1C4         /* PVP0 IPFn (Camera/Memory Pipe) Pipe Control */
#define REG_PVP0_IPF0_CTL               0xFFC1A188         /* PVP0 IPFn (Camera/Memory Pipe) Control */
#define REG_PVP0_IPF1_CTL               0xFFC1A1C8         /* PVP0 IPFn (Camera/Memory Pipe) Control */
#define REG_PVP0_IPF0_TAG               0xFFC1A18C         /* PVP0 IPFn (Camera/Memory Pipe) TAG Value */
#define REG_PVP0_IPF1_TAG               0xFFC1A1CC         /* PVP0 IPFn (Camera/Memory Pipe) TAG Value */
#define REG_PVP0_IPF0_FCNT              0xFFC1A190         /* PVP0 IPFn (Camera/Memory Pipe) Frame Count */
#define REG_PVP0_IPF1_FCNT              0xFFC1A1D0         /* PVP0 IPFn (Camera/Memory Pipe) Frame Count */
#define REG_PVP0_IPF0_HCNT              0xFFC1A194         /* PVP0 IPFn (Camera/Memory Pipe) Horizontal Count */
#define REG_PVP0_IPF1_HCNT              0xFFC1A1D4         /* PVP0 IPFn (Camera/Memory Pipe) Horizontal Count */
#define REG_PVP0_IPF0_VCNT              0xFFC1A198         /* PVP0 IPFn (Camera/Memory Pipe) Vertical Count */
#define REG_PVP0_IPF1_VCNT              0xFFC1A1D8         /* PVP0 IPFn (Camera/Memory Pipe) Vertical Count */
#define REG_PVP0_IPF0_HPOS              0xFFC1A19C         /* PVP0 IPF0 (Camera Pipe) Horizontal Position */
#define REG_PVP0_IPF0_VPOS              0xFFC1A1A0         /* PVP0 IPF0 (Camera Pipe) Vertical Position */
#define REG_PVP0_IPF0_TAG_STAT          0xFFC1A1A4         /* PVP0 IPFn (Camera/Memory Pipe) TAG Status */
#define REG_PVP0_IPF1_TAG_STAT          0xFFC1A1E4         /* PVP0 IPFn (Camera/Memory Pipe) TAG Status */
#define REG_PVP0_IPF1_CFG               0xFFC1A1C0         /* PVP0 IPF1 (Memory Pipe) Configuration */
#define REG_PVP0_CNV0_CFG               0xFFC1A200         /* PVP0 CNVn Configuration */
#define REG_PVP0_CNV1_CFG               0xFFC1A280         /* PVP0 CNVn Configuration */
#define REG_PVP0_CNV2_CFG               0xFFC1A300         /* PVP0 CNVn Configuration */
#define REG_PVP0_CNV3_CFG               0xFFC1A380         /* PVP0 CNVn Configuration */
#define REG_PVP0_CNV0_CTL               0xFFC1A204         /* PVP0 CNVn Control */
#define REG_PVP0_CNV1_CTL               0xFFC1A284         /* PVP0 CNVn Control */
#define REG_PVP0_CNV2_CTL               0xFFC1A304         /* PVP0 CNVn Control */
#define REG_PVP0_CNV3_CTL               0xFFC1A384         /* PVP0 CNVn Control */
#define REG_PVP0_CNV0_C00C01            0xFFC1A208         /* PVP0 CNVn Coefficients 0,0 and 0,1 */
#define REG_PVP0_CNV1_C00C01            0xFFC1A288         /* PVP0 CNVn Coefficients 0,0 and 0,1 */
#define REG_PVP0_CNV2_C00C01            0xFFC1A308         /* PVP0 CNVn Coefficients 0,0 and 0,1 */
#define REG_PVP0_CNV3_C00C01            0xFFC1A388         /* PVP0 CNVn Coefficients 0,0 and 0,1 */
#define REG_PVP0_CNV0_C02C03            0xFFC1A20C         /* PVP0 CNVn Coefficients 0,2 and 0,3 */
#define REG_PVP0_CNV1_C02C03            0xFFC1A28C         /* PVP0 CNVn Coefficients 0,2 and 0,3 */
#define REG_PVP0_CNV2_C02C03            0xFFC1A30C         /* PVP0 CNVn Coefficients 0,2 and 0,3 */
#define REG_PVP0_CNV3_C02C03            0xFFC1A38C         /* PVP0 CNVn Coefficients 0,2 and 0,3 */
#define REG_PVP0_CNV0_C04               0xFFC1A210         /* PVP0 CNVn Coefficient 0,4 */
#define REG_PVP0_CNV1_C04               0xFFC1A290         /* PVP0 CNVn Coefficient 0,4 */
#define REG_PVP0_CNV2_C04               0xFFC1A310         /* PVP0 CNVn Coefficient 0,4 */
#define REG_PVP0_CNV3_C04               0xFFC1A390         /* PVP0 CNVn Coefficient 0,4 */
#define REG_PVP0_CNV0_C10C11            0xFFC1A214         /* PVP0 CNVn Coefficients 1,0 and 1,1 */
#define REG_PVP0_CNV1_C10C11            0xFFC1A294         /* PVP0 CNVn Coefficients 1,0 and 1,1 */
#define REG_PVP0_CNV2_C10C11            0xFFC1A314         /* PVP0 CNVn Coefficients 1,0 and 1,1 */
#define REG_PVP0_CNV3_C10C11            0xFFC1A394         /* PVP0 CNVn Coefficients 1,0 and 1,1 */
#define REG_PVP0_CNV0_C12C13            0xFFC1A218         /* PVP0 CNVn Coefficients 1,2 and 1,3 */
#define REG_PVP0_CNV1_C12C13            0xFFC1A298         /* PVP0 CNVn Coefficients 1,2 and 1,3 */
#define REG_PVP0_CNV2_C12C13            0xFFC1A318         /* PVP0 CNVn Coefficients 1,2 and 1,3 */
#define REG_PVP0_CNV3_C12C13            0xFFC1A398         /* PVP0 CNVn Coefficients 1,2 and 1,3 */
#define REG_PVP0_CNV0_C14               0xFFC1A21C         /* PVP0 CNVn Coefficient 1,4 */
#define REG_PVP0_CNV1_C14               0xFFC1A29C         /* PVP0 CNVn Coefficient 1,4 */
#define REG_PVP0_CNV2_C14               0xFFC1A31C         /* PVP0 CNVn Coefficient 1,4 */
#define REG_PVP0_CNV3_C14               0xFFC1A39C         /* PVP0 CNVn Coefficient 1,4 */
#define REG_PVP0_CNV0_C20C21            0xFFC1A220         /* PVP0 CNVn Coefficients 2,0 and 2,1 */
#define REG_PVP0_CNV1_C20C21            0xFFC1A2A0         /* PVP0 CNVn Coefficients 2,0 and 2,1 */
#define REG_PVP0_CNV2_C20C21            0xFFC1A320         /* PVP0 CNVn Coefficients 2,0 and 2,1 */
#define REG_PVP0_CNV3_C20C21            0xFFC1A3A0         /* PVP0 CNVn Coefficients 2,0 and 2,1 */
#define REG_PVP0_CNV0_C22C23            0xFFC1A224         /* PVP0 CNVn Coefficients 2,2 and 2,3 */
#define REG_PVP0_CNV1_C22C23            0xFFC1A2A4         /* PVP0 CNVn Coefficients 2,2 and 2,3 */
#define REG_PVP0_CNV2_C22C23            0xFFC1A324         /* PVP0 CNVn Coefficients 2,2 and 2,3 */
#define REG_PVP0_CNV3_C22C23            0xFFC1A3A4         /* PVP0 CNVn Coefficients 2,2 and 2,3 */
#define REG_PVP0_CNV0_C24               0xFFC1A228         /* PVP0 CNVn Coefficient 2,4 */
#define REG_PVP0_CNV1_C24               0xFFC1A2A8         /* PVP0 CNVn Coefficient 2,4 */
#define REG_PVP0_CNV2_C24               0xFFC1A328         /* PVP0 CNVn Coefficient 2,4 */
#define REG_PVP0_CNV3_C24               0xFFC1A3A8         /* PVP0 CNVn Coefficient 2,4 */
#define REG_PVP0_CNV0_C30C31            0xFFC1A22C         /* PVP0 CNVn Coefficients 3,0 and 3,1 */
#define REG_PVP0_CNV1_C30C31            0xFFC1A2AC         /* PVP0 CNVn Coefficients 3,0 and 3,1 */
#define REG_PVP0_CNV2_C30C31            0xFFC1A32C         /* PVP0 CNVn Coefficients 3,0 and 3,1 */
#define REG_PVP0_CNV3_C30C31            0xFFC1A3AC         /* PVP0 CNVn Coefficients 3,0 and 3,1 */
#define REG_PVP0_CNV0_C32C33            0xFFC1A230         /* PVP0 CNVn Coefficients 3,2 and 3,3 */
#define REG_PVP0_CNV1_C32C33            0xFFC1A2B0         /* PVP0 CNVn Coefficients 3,2 and 3,3 */
#define REG_PVP0_CNV2_C32C33            0xFFC1A330         /* PVP0 CNVn Coefficients 3,2 and 3,3 */
#define REG_PVP0_CNV3_C32C33            0xFFC1A3B0         /* PVP0 CNVn Coefficients 3,2 and 3,3 */
#define REG_PVP0_CNV0_C34               0xFFC1A234         /* PVP0 CNVn Coefficient 3,4 */
#define REG_PVP0_CNV1_C34               0xFFC1A2B4         /* PVP0 CNVn Coefficient 3,4 */
#define REG_PVP0_CNV2_C34               0xFFC1A334         /* PVP0 CNVn Coefficient 3,4 */
#define REG_PVP0_CNV3_C34               0xFFC1A3B4         /* PVP0 CNVn Coefficient 3,4 */
#define REG_PVP0_CNV0_C40C41            0xFFC1A238         /* PVP0 CNVn Coefficients 4,0 and 4,1 */
#define REG_PVP0_CNV1_C40C41            0xFFC1A2B8         /* PVP0 CNVn Coefficients 4,0 and 4,1 */
#define REG_PVP0_CNV2_C40C41            0xFFC1A338         /* PVP0 CNVn Coefficients 4,0 and 4,1 */
#define REG_PVP0_CNV3_C40C41            0xFFC1A3B8         /* PVP0 CNVn Coefficients 4,0 and 4,1 */
#define REG_PVP0_CNV0_C42C43            0xFFC1A23C         /* PVP0 CNVn Coefficients 4,2 and 4,3 */
#define REG_PVP0_CNV1_C42C43            0xFFC1A2BC         /* PVP0 CNVn Coefficients 4,2 and 4,3 */
#define REG_PVP0_CNV2_C42C43            0xFFC1A33C         /* PVP0 CNVn Coefficients 4,2 and 4,3 */
#define REG_PVP0_CNV3_C42C43            0xFFC1A3BC         /* PVP0 CNVn Coefficients 4,2 and 4,3 */
#define REG_PVP0_CNV0_C44               0xFFC1A240         /* PVP0 CNVn Coefficient 4,4 */
#define REG_PVP0_CNV1_C44               0xFFC1A2C0         /* PVP0 CNVn Coefficient 4,4 */
#define REG_PVP0_CNV2_C44               0xFFC1A340         /* PVP0 CNVn Coefficient 4,4 */
#define REG_PVP0_CNV3_C44               0xFFC1A3C0         /* PVP0 CNVn Coefficient 4,4 */
#define REG_PVP0_CNV0_SCALE             0xFFC1A244         /* PVP0 CNVn Scaling Factor */
#define REG_PVP0_CNV1_SCALE             0xFFC1A2C4         /* PVP0 CNVn Scaling Factor */
#define REG_PVP0_CNV2_SCALE             0xFFC1A344         /* PVP0 CNVn Scaling Factor */
#define REG_PVP0_CNV3_SCALE             0xFFC1A3C4         /* PVP0 CNVn Scaling Factor */
#define REG_PVP0_THC0_CFG               0xFFC1A400         /* PVP0 THCn Configuration */
#define REG_PVP0_THC1_CFG               0xFFC1A500         /* PVP0 THCn Configuration */
#define REG_PVP0_THC0_CTL               0xFFC1A404         /* PVP0 THCn Control */
#define REG_PVP0_THC1_CTL               0xFFC1A504         /* PVP0 THCn Control */
#define REG_PVP0_THC0_HFCNT             0xFFC1A408         /* PVP0 THCn Histogram Frame Count */
#define REG_PVP0_THC1_HFCNT             0xFFC1A508         /* PVP0 THCn Histogram Frame Count */
#define REG_PVP0_THC0_RMAXREP           0xFFC1A40C         /* PVP0 THCn Max RLE Reports */
#define REG_PVP0_THC1_RMAXREP           0xFFC1A50C         /* PVP0 THCn Max RLE Reports */
#define REG_PVP0_THC0_CMINVAL           0xFFC1A410         /* PVP0 THCn Min Clip Value */
#define REG_PVP0_THC1_CMINVAL           0xFFC1A510         /* PVP0 THCn Min Clip Value */
#define REG_PVP0_THC0_CMINTH            0xFFC1A414         /* PVP0 THCn Clip Min Threshold */
#define REG_PVP0_THC1_CMINTH            0xFFC1A514         /* PVP0 THCn Clip Min Threshold */
#define REG_PVP0_THC0_CMAXTH            0xFFC1A418         /* PVP0 THCn Clip Max Threshold */
#define REG_PVP0_THC1_CMAXTH            0xFFC1A518         /* PVP0 THCn Clip Max Threshold */
#define REG_PVP0_THC0_CMAXVAL           0xFFC1A41C         /* PVP0 THCn Max Clip Value */
#define REG_PVP0_THC1_CMAXVAL           0xFFC1A51C         /* PVP0 THCn Max Clip Value */
#define REG_PVP0_THC0_TH0               0xFFC1A420         /* PVP0 THCn Threshold Value 0 */
#define REG_PVP0_THC1_TH0               0xFFC1A520         /* PVP0 THCn Threshold Value 0 */
#define REG_PVP0_THC0_TH1               0xFFC1A424         /* PVP0 THCn Threshold Value 1 */
#define REG_PVP0_THC1_TH1               0xFFC1A524         /* PVP0 THCn Threshold Value 1 */
#define REG_PVP0_THC0_TH2               0xFFC1A428         /* PVP0 THCn Threshold Value 2 */
#define REG_PVP0_THC1_TH2               0xFFC1A528         /* PVP0 THCn Threshold Value 2 */
#define REG_PVP0_THC0_TH3               0xFFC1A42C         /* PVP0 THCn Threshold Value 3 */
#define REG_PVP0_THC1_TH3               0xFFC1A52C         /* PVP0 THCn Threshold Value 3 */
#define REG_PVP0_THC0_TH4               0xFFC1A430         /* PVP0 THCn Threshold Value 4 */
#define REG_PVP0_THC1_TH4               0xFFC1A530         /* PVP0 THCn Threshold Value 4 */
#define REG_PVP0_THC0_TH5               0xFFC1A434         /* PVP0 THCn Threshold Value 5 */
#define REG_PVP0_THC1_TH5               0xFFC1A534         /* PVP0 THCn Threshold Value 5 */
#define REG_PVP0_THC0_TH6               0xFFC1A438         /* PVP0 THCn Threshold Value 6 */
#define REG_PVP0_THC1_TH6               0xFFC1A538         /* PVP0 THCn Threshold Value 6 */
#define REG_PVP0_THC0_TH7               0xFFC1A43C         /* PVP0 THCn Threshold Value 7 */
#define REG_PVP0_THC1_TH7               0xFFC1A53C         /* PVP0 THCn Threshold Value 7 */
#define REG_PVP0_THC0_TH8               0xFFC1A440         /* PVP0 THCn Threshold Value 8 */
#define REG_PVP0_THC1_TH8               0xFFC1A540         /* PVP0 THCn Threshold Value 8 */
#define REG_PVP0_THC0_TH9               0xFFC1A444         /* PVP0 THCn Threshold Value 9 */
#define REG_PVP0_THC1_TH9               0xFFC1A544         /* PVP0 THCn Threshold Value 9 */
#define REG_PVP0_THC0_TH10              0xFFC1A448         /* PVP0 THCn Threshold Value 10 */
#define REG_PVP0_THC1_TH10              0xFFC1A548         /* PVP0 THCn Threshold Value 10 */
#define REG_PVP0_THC0_TH11              0xFFC1A44C         /* PVP0 THCn Threshold Value 11 */
#define REG_PVP0_THC1_TH11              0xFFC1A54C         /* PVP0 THCn Threshold Value 11 */
#define REG_PVP0_THC0_TH12              0xFFC1A450         /* PVP0 THCn Threshold Value 12 */
#define REG_PVP0_THC1_TH12              0xFFC1A550         /* PVP0 THCn Threshold Value 12 */
#define REG_PVP0_THC0_TH13              0xFFC1A454         /* PVP0 THCn Threshold Value 13 */
#define REG_PVP0_THC1_TH13              0xFFC1A554         /* PVP0 THCn Threshold Value 13 */
#define REG_PVP0_THC0_TH14              0xFFC1A458         /* PVP0 THCn Threshold Value 14 */
#define REG_PVP0_THC1_TH14              0xFFC1A558         /* PVP0 THCn Threshold Value 14 */
#define REG_PVP0_THC0_TH15              0xFFC1A45C         /* PVP0 THCn Threshold Value 15 */
#define REG_PVP0_THC1_TH15              0xFFC1A55C         /* PVP0 THCn Threshold Value 15 */
#define REG_PVP0_THC0_HHPOS             0xFFC1A460         /* PVP0 THCn Histogram Horzontal Position */
#define REG_PVP0_THC1_HHPOS             0xFFC1A560         /* PVP0 THCn Histogram Horzontal Position */
#define REG_PVP0_THC0_HVPOS             0xFFC1A464         /* PVP0 THCn Histogram Vertical Position */
#define REG_PVP0_THC1_HVPOS             0xFFC1A564         /* PVP0 THCn Histogram Vertical Position */
#define REG_PVP0_THC0_HHCNT             0xFFC1A468         /* PVP0 THCn Histogram Horizontal Count */
#define REG_PVP0_THC1_HHCNT             0xFFC1A568         /* PVP0 THCn Histogram Horizontal Count */
#define REG_PVP0_THC0_HVCNT             0xFFC1A46C         /* PVP0 THCn Histogram Vertical Count */
#define REG_PVP0_THC1_HVCNT             0xFFC1A56C         /* PVP0 THCn Histogram Vertical Count */
#define REG_PVP0_THC0_RHPOS             0xFFC1A470         /* PVP0 THCn RLE Horizontal Position */
#define REG_PVP0_THC1_RHPOS             0xFFC1A570         /* PVP0 THCn RLE Horizontal Position */
#define REG_PVP0_THC0_RVPOS             0xFFC1A474         /* PVP0 THCn RLE Vertical Position */
#define REG_PVP0_THC1_RVPOS             0xFFC1A574         /* PVP0 THCn RLE Vertical Position */
#define REG_PVP0_THC0_RHCNT             0xFFC1A478         /* PVP0 THCn RLE Horizontal Count */
#define REG_PVP0_THC1_RHCNT             0xFFC1A578         /* PVP0 THCn RLE Horizontal Count */
#define REG_PVP0_THC0_RVCNT             0xFFC1A47C         /* PVP0 THCn RLE Vertical Count */
#define REG_PVP0_THC1_RVCNT             0xFFC1A57C         /* PVP0 THCn RLE Vertical Count */
#define REG_PVP0_THC0_HFCNT_STAT        0xFFC1A480         /* PVP0 THCn Histogram Frame Count Status */
#define REG_PVP0_THC1_HFCNT_STAT        0xFFC1A580         /* PVP0 THCn Histogram Frame Count Status */
#define REG_PVP0_THC0_HCNT0_STAT        0xFFC1A484         /* PVP0 THCn Histogram Counter Value 0 */
#define REG_PVP0_THC1_HCNT0_STAT        0xFFC1A584         /* PVP0 THCn Histogram Counter Value 0 */
#define REG_PVP0_THC0_HCNT1_STAT        0xFFC1A488         /* PVP0 THCn Histogram Counter Value 1 */
#define REG_PVP0_THC1_HCNT1_STAT        0xFFC1A588         /* PVP0 THCn Histogram Counter Value 1 */
#define REG_PVP0_THC0_HCNT2_STAT        0xFFC1A48C         /* PVP0 THCn Histogram Counter Value 2 */
#define REG_PVP0_THC1_HCNT2_STAT        0xFFC1A58C         /* PVP0 THCn Histogram Counter Value 2 */
#define REG_PVP0_THC0_HCNT3_STAT        0xFFC1A490         /* PVP0 THCn Histogram Counter Value 3 */
#define REG_PVP0_THC1_HCNT3_STAT        0xFFC1A590         /* PVP0 THCn Histogram Counter Value 3 */
#define REG_PVP0_THC0_HCNT4_STAT        0xFFC1A494         /* PVP0 THCn Histogram Counter Value 4 */
#define REG_PVP0_THC1_HCNT4_STAT        0xFFC1A594         /* PVP0 THCn Histogram Counter Value 4 */
#define REG_PVP0_THC0_HCNT5_STAT        0xFFC1A498         /* PVP0 THCn Histogram Counter Value 5 */
#define REG_PVP0_THC1_HCNT5_STAT        0xFFC1A598         /* PVP0 THCn Histogram Counter Value 5 */
#define REG_PVP0_THC0_HCNT6_STAT        0xFFC1A49C         /* PVP0 THCn Histogram Counter Value 6 */
#define REG_PVP0_THC1_HCNT6_STAT        0xFFC1A59C         /* PVP0 THCn Histogram Counter Value 6 */
#define REG_PVP0_THC0_HCNT7_STAT        0xFFC1A4A0         /* PVP0 THCn Histogram Counter Value 7 */
#define REG_PVP0_THC1_HCNT7_STAT        0xFFC1A5A0         /* PVP0 THCn Histogram Counter Value 7 */
#define REG_PVP0_THC0_HCNT8_STAT        0xFFC1A4A4         /* PVP0 THCn Histogram Counter Value 8 */
#define REG_PVP0_THC1_HCNT8_STAT        0xFFC1A5A4         /* PVP0 THCn Histogram Counter Value 8 */
#define REG_PVP0_THC0_HCNT9_STAT        0xFFC1A4A8         /* PVP0 THCn Histogram Counter Value 9 */
#define REG_PVP0_THC1_HCNT9_STAT        0xFFC1A5A8         /* PVP0 THCn Histogram Counter Value 9 */
#define REG_PVP0_THC0_HCNT10_STAT       0xFFC1A4AC         /* PVP0 THCn Histogram Counter Value 10 */
#define REG_PVP0_THC1_HCNT10_STAT       0xFFC1A5AC         /* PVP0 THCn Histogram Counter Value 10 */
#define REG_PVP0_THC0_HCNT11_STAT       0xFFC1A4B0         /* PVP0 THCn Histogram Counter Value 11 */
#define REG_PVP0_THC1_HCNT11_STAT       0xFFC1A5B0         /* PVP0 THCn Histogram Counter Value 11 */
#define REG_PVP0_THC0_HCNT12_STAT       0xFFC1A4B4         /* PVP0 THCn Histogram Counter Value 12 */
#define REG_PVP0_THC1_HCNT12_STAT       0xFFC1A5B4         /* PVP0 THCn Histogram Counter Value 12 */
#define REG_PVP0_THC0_HCNT13_STAT       0xFFC1A4B8         /* PVP0 THCn Histogram Counter Value 13 */
#define REG_PVP0_THC1_HCNT13_STAT       0xFFC1A5B8         /* PVP0 THCn Histogram Counter Value 13 */
#define REG_PVP0_THC0_HCNT14_STAT       0xFFC1A4BC         /* PVP0 THCn Histogram Counter Value 14 */
#define REG_PVP0_THC1_HCNT14_STAT       0xFFC1A5BC         /* PVP0 THCn Histogram Counter Value 14 */
#define REG_PVP0_THC0_HCNT15_STAT       0xFFC1A4C0         /* PVP0 THCn Histogram Counter Value 15 */
#define REG_PVP0_THC1_HCNT15_STAT       0xFFC1A5C0         /* PVP0 THCn Histogram Counter Value 15 */
#define REG_PVP0_THC0_RREP_STAT         0xFFC1A4C4         /* PVP0 THCn Number of RLE Reports */
#define REG_PVP0_THC1_RREP_STAT         0xFFC1A5C4         /* PVP0 THCn Number of RLE Reports */
#define REG_PVP0_PMA_CFG                0xFFC1A600         /* PVP0 PMA Configuration */

/* =========================
        PVP
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        PVP_REVID                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_REVID_MAJOR                  4                               /* Major ID */
#define BITP_PVP_REVID_REV                    0                               /* Revision ID for a given Major ID */
#define BITM_PVP_REVID_MAJOR                 (_ADI_MSK(0x000000F0,uint32_t))  /* Major ID */
#define BITM_PVP_REVID_REV                   (_ADI_MSK(0x0000000F,uint32_t))  /* Revision ID for a given Major ID */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CTL                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CTL_CLKDIV                   4                               /* Clock Divisor */
#define BITP_PVP_CTL_CPEN                     2                               /* Camera Pipe Enable */
#define BITP_PVP_CTL_MPEN                     1                               /* Memory Pipe Enable */
#define BITP_PVP_CTL_PVPEN                    0                               /* PVP Enable */

#define BITM_PVP_CTL_CLKDIV                  (_ADI_MSK(0x00000010,uint32_t))  /* Clock Divisor */
#define ENUM_PVP_CTL_CLKDIV1                 (_ADI_MSK(0x00000000,uint32_t))  /* CLKDIV: PVPCLK = SCLK0 */
#define ENUM_PVP_CTL_CLKDIV2                 (_ADI_MSK(0x00000010,uint32_t))  /* CLKDIV: PVPCLK = SCLK0/2 */

#define BITM_PVP_CTL_CPEN                    (_ADI_MSK(0x00000004,uint32_t))  /* Camera Pipe Enable */
#define ENUM_PVP_CTL_CPDIS                   (_ADI_MSK(0x00000000,uint32_t))  /* CPEN: Disable Camera Pipe */
#define ENUM_PVP_CTL_CPEN                    (_ADI_MSK(0x00000004,uint32_t))  /* CPEN: Enable Camera Pipe */

#define BITM_PVP_CTL_MPEN                    (_ADI_MSK(0x00000002,uint32_t))  /* Memory Pipe Enable */
#define ENUM_PVP_CTL_MPDIS                   (_ADI_MSK(0x00000000,uint32_t))  /* MPEN: Disable Memory Pipe */
#define ENUM_PVP_CTL_MPEN                    (_ADI_MSK(0x00000002,uint32_t))  /* MPEN: Enable Memory Pipe */

#define BITM_PVP_CTL_PVPEN                   (_ADI_MSK(0x00000001,uint32_t))  /* PVP Enable */
#define ENUM_PVP_CTL_PVPDIS                  (_ADI_MSK(0x00000000,uint32_t))  /* PVPEN: Disable PVP */
#define ENUM_PVP_CTL_PVPEN                   (_ADI_MSK(0x00000001,uint32_t))  /* PVPEN: Enable PVP */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IMSK                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IMSK_ACUSUMSAT              27                               /* ACU SUM Saturate Unmask */
#define BITP_PVP_IMSK_ACUPRODSAT             26                               /* ACU PROD Saturate Unmask */
#define BITP_PVP_IMSK_ACUOUTSAT              25                               /* ACU MIN/MAX Saturate Unmask */
#define BITP_PVP_IMSK_ACUDIVERR              24                               /* ACU Divide By Zero Unmask */
#define BITP_PVP_IMSK_IIM1SOVF               23                               /* IIM1 Signed Overflow Unmask */
#define BITP_PVP_IMSK_IIM1UOVF               22                               /* IIM1 Unsigned Overflow Unmask */
#define BITP_PVP_IMSK_IIM0SOVF               21                               /* IIM0 Signed Overflow Unmask */
#define BITP_PVP_IMSK_IIM0UOVF               20                               /* IIM0 Unsigned Overflow Unmask */
#define BITP_PVP_IMSK_THC1RDY                18                               /* THC1 Report Ready Unmask */
#define BITP_PVP_IMSK_THC0RDY                16                               /* THC0 Report Ready Unmask */
#define BITP_PVP_IMSK_MPRDY                  15                               /* Memory Pipe Ready Unmask */
#define BITP_PVP_IMSK_CPRDY                  14                               /* Camera Pipe Ready Unmask */
#define BITP_PVP_IMSK_MPDRN                  13                               /* Memory Pipe Drain Done Unmask */
#define BITP_PVP_IMSK_CPDRN                  12                               /* Camera Pipe Drain Done Unmask */
#define BITP_PVP_IMSK_CPIPFOVF               10                               /* Camera Pipe Pixel Overrun Unmask */
#define BITP_PVP_IMSK_MPOPFDAT                9                               /* Memory Pipe First Pixel Unmask */
#define BITP_PVP_IMSK_CPOPFDAT                8                               /* Camera Pipe First Pixel Unmask */
#define BITP_PVP_IMSK_CPSTOVF                 7                               /* Status DDE Stall Error Unmask */
#define BITP_PVP_IMSK_OPF2OVF                 6                               /* OPF2 DDE Stall Error Unmask */
#define BITP_PVP_IMSK_OPF1OVF                 5                               /* OPF1 DDE Stall Error Unmask */
#define BITP_PVP_IMSK_OPF0OVF                 4                               /* OPF0 DDE Stall Error Unmask */
#define BITP_PVP_IMSK_MPWRERR                 3                               /* Memory Pipe MMR Write Error Unmask */
#define BITP_PVP_IMSK_CPWRERR                 2                               /* Camera Pipe MMR Write Error Unmask */
#define BITP_PVP_IMSK_MPDC                    1                               /* Memory Pipe DC Unmask */
#define BITP_PVP_IMSK_CPDC                    0                               /* Camera Pipe DC Unmask */

/* The fields and enumerations for PVP_IMSK are also in PVP - see the common set of ENUM_PVP_* #defines located with register PVP_STAT */

#define BITM_PVP_IMSK_ACUSUMSAT              (_ADI_MSK(0x08000000,uint32_t))  /* ACU SUM Saturate Unmask */
#define BITM_PVP_IMSK_ACUPRODSAT             (_ADI_MSK(0x04000000,uint32_t))  /* ACU PROD Saturate Unmask */
#define BITM_PVP_IMSK_ACUOUTSAT              (_ADI_MSK(0x02000000,uint32_t))  /* ACU MIN/MAX Saturate Unmask */
#define BITM_PVP_IMSK_ACUDIVERR              (_ADI_MSK(0x01000000,uint32_t))  /* ACU Divide By Zero Unmask */
#define BITM_PVP_IMSK_IIM1SOVF               (_ADI_MSK(0x00800000,uint32_t))  /* IIM1 Signed Overflow Unmask */
#define BITM_PVP_IMSK_IIM1UOVF               (_ADI_MSK(0x00400000,uint32_t))  /* IIM1 Unsigned Overflow Unmask */
#define BITM_PVP_IMSK_IIM0SOVF               (_ADI_MSK(0x00200000,uint32_t))  /* IIM0 Signed Overflow Unmask */
#define BITM_PVP_IMSK_IIM0UOVF               (_ADI_MSK(0x00100000,uint32_t))  /* IIM0 Unsigned Overflow Unmask */
#define BITM_PVP_IMSK_THC1RDY                (_ADI_MSK(0x00040000,uint32_t))  /* THC1 Report Ready Unmask */
#define BITM_PVP_IMSK_THC0RDY                (_ADI_MSK(0x00010000,uint32_t))  /* THC0 Report Ready Unmask */
#define BITM_PVP_IMSK_MPRDY                  (_ADI_MSK(0x00008000,uint32_t))  /* Memory Pipe Ready Unmask */
#define BITM_PVP_IMSK_CPRDY                  (_ADI_MSK(0x00004000,uint32_t))  /* Camera Pipe Ready Unmask */
#define BITM_PVP_IMSK_MPDRN                  (_ADI_MSK(0x00002000,uint32_t))  /* Memory Pipe Drain Done Unmask */
#define BITM_PVP_IMSK_CPDRN                  (_ADI_MSK(0x00001000,uint32_t))  /* Camera Pipe Drain Done Unmask */
#define BITM_PVP_IMSK_CPIPFOVF               (_ADI_MSK(0x00000400,uint32_t))  /* Camera Pipe Pixel Overrun Unmask */
#define BITM_PVP_IMSK_MPOPFDAT               (_ADI_MSK(0x00000200,uint32_t))  /* Memory Pipe First Pixel Unmask */
#define BITM_PVP_IMSK_CPOPFDAT               (_ADI_MSK(0x00000100,uint32_t))  /* Camera Pipe First Pixel Unmask */
#define BITM_PVP_IMSK_CPSTOVF                (_ADI_MSK(0x00000080,uint32_t))  /* Status DDE Stall Error Unmask */
#define BITM_PVP_IMSK_OPF2OVF                (_ADI_MSK(0x00000040,uint32_t))  /* OPF2 DDE Stall Error Unmask */
#define BITM_PVP_IMSK_OPF1OVF                (_ADI_MSK(0x00000020,uint32_t))  /* OPF1 DDE Stall Error Unmask */
#define BITM_PVP_IMSK_OPF0OVF                (_ADI_MSK(0x00000010,uint32_t))  /* OPF0 DDE Stall Error Unmask */
#define BITM_PVP_IMSK_MPWRERR                (_ADI_MSK(0x00000008,uint32_t))  /* Memory Pipe MMR Write Error Unmask */
#define BITM_PVP_IMSK_CPWRERR                (_ADI_MSK(0x00000004,uint32_t))  /* Camera Pipe MMR Write Error Unmask */
#define BITM_PVP_IMSK_MPDC                   (_ADI_MSK(0x00000002,uint32_t))  /* Memory Pipe DC Unmask */
#define BITM_PVP_IMSK_CPDC                   (_ADI_MSK(0x00000001,uint32_t))  /* Camera Pipe DC Unmask */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_STAT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_STAT_ACUSUMSAT              27                               /* ACU SUM Saturate Status */
#define BITP_PVP_STAT_ACUPRODSAT             26                               /* ACU PROD Saturate Status */
#define BITP_PVP_STAT_ACUOUTSAT              25                               /* ACU MIN/MAX Saturate Status */
#define BITP_PVP_STAT_ACUDIVERR              24                               /* ACU Divide By Zero Status */
#define BITP_PVP_STAT_IIM1SOVF               23                               /* IIM1 Signed Overflow Status */
#define BITP_PVP_STAT_IIM1UOVF               22                               /* IIM1 Unsigned Overflow Status */
#define BITP_PVP_STAT_IIM0SOVF               21                               /* IIM0 Signed Overflow Status */
#define BITP_PVP_STAT_IIM0UOVF               20                               /* IIM0 Unsigned Overflow Status */
#define BITP_PVP_STAT_THC1RDY                18                               /* THC1 Report Ready Status */
#define BITP_PVP_STAT_THC0RDY                16                               /* THC0 Report Ready Status */
#define BITP_PVP_STAT_MPRDY                  15                               /* Memory Pipe Ready Status */
#define BITP_PVP_STAT_CPRDY                  14                               /* Camera Pipe Ready Status */
#define BITP_PVP_STAT_MPDRN                  13                               /* Memory Pipe Drain Done Status */
#define BITP_PVP_STAT_CPDRN                  12                               /* Camera Pipe Drain Done Status */
#define BITP_PVP_STAT_CPIPFOVF               10                               /* Camera Pipe Pixel Overrun Status */
#define BITP_PVP_STAT_MPOPFDAT                9                               /* Memory Pipe First Pixel Status */
#define BITP_PVP_STAT_CPOPFDAT                8                               /* Camera Pipe First Pixel Status */
#define BITP_PVP_STAT_CPSTOVF                 7                               /* Camera Pipe DDE Stall Error Status */
#define BITP_PVP_STAT_OPF2OVF                 6                               /* OPF2 DDE Stall Error Status */
#define BITP_PVP_STAT_OPF1OVF                 5                               /* OPF1 DDE Stall Error Status */
#define BITP_PVP_STAT_OPF0OVF                 4                               /* OPF0 DDE Stall Error Status */
#define BITP_PVP_STAT_MPWRERR                 3                               /* Memory Pipe MMR Write Error Status */
#define BITP_PVP_STAT_CPWRERR                 2                               /* Camera Pipe MMR Write Error Status */
#define BITP_PVP_STAT_MPDC                    1                               /* Memory Pipe DC Status */
#define BITP_PVP_STAT_CPDC                    0                               /* Camera Pipe DC Status */

#define BITM_PVP_STAT_ACUSUMSAT              (_ADI_MSK(0x08000000,uint32_t))  /* ACU SUM Saturate Status */
#define ENUM_PVP_ACUSUMSAT_LO                (_ADI_MSK(0x00000000,uint32_t))  /* ACUSUMSAT: No Pending Interrupt */
#define ENUM_PVP_ACUSUMSAT_HI                (_ADI_MSK(0x08000000,uint32_t))  /* ACUSUMSAT: Pending Interrupt */

#define BITM_PVP_STAT_ACUPRODSAT             (_ADI_MSK(0x04000000,uint32_t))  /* ACU PROD Saturate Status */
#define ENUM_PVP_ACUPRODSAT_LO               (_ADI_MSK(0x00000000,uint32_t))  /* ACUPRODSAT: No Pending Interrupt */
#define ENUM_PVP_ACUPRODSAT_HI               (_ADI_MSK(0x04000000,uint32_t))  /* ACUPRODSAT: Pending Interrupt */

#define BITM_PVP_STAT_ACUOUTSAT              (_ADI_MSK(0x02000000,uint32_t))  /* ACU MIN/MAX Saturate Status */
#define ENUM_PVP_ACUOUTSAT_LO                (_ADI_MSK(0x00000000,uint32_t))  /* ACUOUTSAT: No Pending Interrupt */
#define ENUM_PVP_ACUOUTSAT_HI                (_ADI_MSK(0x02000000,uint32_t))  /* ACUOUTSAT: Pending Interrupt */

#define BITM_PVP_STAT_ACUDIVERR              (_ADI_MSK(0x01000000,uint32_t))  /* ACU Divide By Zero Status */
#define ENUM_PVP_ACUDIVERR_LO                (_ADI_MSK(0x00000000,uint32_t))  /* ACUDIVERR: No Pending Interrupt */
#define ENUM_PVP_ACUDIVERR_HI                (_ADI_MSK(0x01000000,uint32_t))  /* ACUDIVERR: Pending Interrupt */

#define BITM_PVP_STAT_IIM1SOVF               (_ADI_MSK(0x00800000,uint32_t))  /* IIM1 Signed Overflow Status */
#define ENUM_PVP_IIM1SOVF_LO                 (_ADI_MSK(0x00000000,uint32_t))  /* IIM1SOVF: No Pending Interrupt */
#define ENUM_PVP_IIM1SOVF_HI                 (_ADI_MSK(0x00800000,uint32_t))  /* IIM1SOVF: Pending Interrupt */

#define BITM_PVP_STAT_IIM1UOVF               (_ADI_MSK(0x00400000,uint32_t))  /* IIM1 Unsigned Overflow Status */
#define ENUM_PVP_IIM1UOVF_LO                 (_ADI_MSK(0x00000000,uint32_t))  /* IIM1UOVF: No Pending Interrupt */
#define ENUM_PVP_IIM1UOVF_HI                 (_ADI_MSK(0x00400000,uint32_t))  /* IIM1UOVF: Pending Interrupt */

#define BITM_PVP_STAT_IIM0SOVF               (_ADI_MSK(0x00200000,uint32_t))  /* IIM0 Signed Overflow Status */
#define ENUM_PVP_IIM0SOVF_LO                 (_ADI_MSK(0x00000000,uint32_t))  /* IIM0SOVF: No Pending Interrupt */
#define ENUM_PVP_IIM0SOVF_HI                 (_ADI_MSK(0x00200000,uint32_t))  /* IIM0SOVF: Pending Interrupt */

#define BITM_PVP_STAT_IIM0UOVF               (_ADI_MSK(0x00100000,uint32_t))  /* IIM0 Unsigned Overflow Status */
#define ENUM_PVP_IIM0UOVF_LO                 (_ADI_MSK(0x00000000,uint32_t))  /* IIM0UOVF: No Pending Interrupt */
#define ENUM_PVP_IIM0UOVF_HI                 (_ADI_MSK(0x00100000,uint32_t))  /* IIM0UOVF: Pending Interrupt */

#define BITM_PVP_STAT_THC1RDY                (_ADI_MSK(0x00040000,uint32_t))  /* THC1 Report Ready Status */
#define ENUM_PVP_THC1RDY_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* THC1RDY: No Pending Interrupt */
#define ENUM_PVP_THC1RDY_HI                  (_ADI_MSK(0x00040000,uint32_t))  /* THC1RDY: Pending Interrupt */

#define BITM_PVP_STAT_THC0RDY                (_ADI_MSK(0x00010000,uint32_t))  /* THC0 Report Ready Status */
#define ENUM_PVP_THC0RDY_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* THC0RDY: No Pending Interrupt */
#define ENUM_PVP_THC0RDY_HI                  (_ADI_MSK(0x00010000,uint32_t))  /* THC0RDY: Pending Interrupt */

#define BITM_PVP_STAT_MPRDY                  (_ADI_MSK(0x00008000,uint32_t))  /* Memory Pipe Ready Status */
#define ENUM_PVP_MPRDY_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* MPRDY: No Pending Interrupt */
#define ENUM_PVP_MPRDY_HI                    (_ADI_MSK(0x00008000,uint32_t))  /* MPRDY: Pending Interrupt */

#define BITM_PVP_STAT_CPRDY                  (_ADI_MSK(0x00004000,uint32_t))  /* Camera Pipe Ready Status */
#define ENUM_PVP_CPRDY_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* CPRDY: No Pending Interrupt */
#define ENUM_PVP_CPRDY_HI                    (_ADI_MSK(0x00004000,uint32_t))  /* CPRDY: Pending Interrupt */

#define BITM_PVP_STAT_MPDRN                  (_ADI_MSK(0x00002000,uint32_t))  /* Memory Pipe Drain Done Status */
#define ENUM_PVP_MPDRN_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* MPDRN: No Pending Interrupt */
#define ENUM_PVP_MPDRN_HI                    (_ADI_MSK(0x00002000,uint32_t))  /* MPDRN: Pending Interrupt */

#define BITM_PVP_STAT_CPDRN                  (_ADI_MSK(0x00001000,uint32_t))  /* Camera Pipe Drain Done Status */
#define ENUM_PVP_CPDRN_LO                    (_ADI_MSK(0x00000000,uint32_t))  /* CPDRN: No Pending Interrupt */
#define ENUM_PVP_CPDRN_HI                    (_ADI_MSK(0x00001000,uint32_t))  /* CPDRN: Pending Interrupt */

#define BITM_PVP_STAT_CPIPFOVF               (_ADI_MSK(0x00000400,uint32_t))  /* Camera Pipe Pixel Overrun Status */
#define ENUM_PVP_CPIPFOVF_LO                 (_ADI_MSK(0x00000000,uint32_t))  /* CPIPFOVF: No Pending Interrupt */
#define ENUM_PVP_CPIPFOVF_HI                 (_ADI_MSK(0x00000400,uint32_t))  /* CPIPFOVF: Pending Interrupt */

#define BITM_PVP_STAT_MPOPFDAT               (_ADI_MSK(0x00000200,uint32_t))  /* Memory Pipe First Pixel Status */
#define ENUM_PVP_MPOPFDAT_LO                 (_ADI_MSK(0x00000000,uint32_t))  /* MPOPFDAT: No Pending Interrupt */
#define ENUM_PVP_MPOPFDAT_HI                 (_ADI_MSK(0x00000200,uint32_t))  /* MPOPFDAT: Pending Interrupt */

#define BITM_PVP_STAT_CPOPFDAT               (_ADI_MSK(0x00000100,uint32_t))  /* Camera Pipe First Pixel Status */
#define ENUM_PVP_CPOPFDAT_LO                 (_ADI_MSK(0x00000000,uint32_t))  /* CPOPFDAT: No Pending Interrupt */
#define ENUM_PVP_CPOPFDAT_HI                 (_ADI_MSK(0x00000100,uint32_t))  /* CPOPFDAT: Pending Interrupt */

#define BITM_PVP_STAT_CPSTOVF                (_ADI_MSK(0x00000080,uint32_t))  /* Camera Pipe DDE Stall Error Status */
#define ENUM_PVP_CPSTOVF_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* CPSTOVF: No Pending Interrupt */
#define ENUM_PVP_CPSTOVF_HI                  (_ADI_MSK(0x00000080,uint32_t))  /* CPSTOVF: Pending Interrupt */

#define BITM_PVP_STAT_OPF2OVF                (_ADI_MSK(0x00000040,uint32_t))  /* OPF2 DDE Stall Error Status */
#define ENUM_PVP_OPF2OVF_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* OPF2OVF: No Pending Interrupt */
#define ENUM_PVP_OPF2OVF_HI                  (_ADI_MSK(0x00000040,uint32_t))  /* OPF2OVF: Pending Interrupt */

#define BITM_PVP_STAT_OPF1OVF                (_ADI_MSK(0x00000020,uint32_t))  /* OPF1 DDE Stall Error Status */
#define ENUM_PVP_OPF1OVF_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* OPF1OVF: No Pending Interrupt */
#define ENUM_PVP_OPF1OVF_HI                  (_ADI_MSK(0x00000020,uint32_t))  /* OPF1OVF: Pending Interrupt */

#define BITM_PVP_STAT_OPF0OVF                (_ADI_MSK(0x00000010,uint32_t))  /* OPF0 DDE Stall Error Status */
#define ENUM_PVP_OPF0OVF_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* OPF0OVF: No Pending Interrupt */
#define ENUM_PVP_OPF0OVF_HI                  (_ADI_MSK(0x00000010,uint32_t))  /* OPF0OVF: Pending Interrupt */

#define BITM_PVP_STAT_MPWRERR                (_ADI_MSK(0x00000008,uint32_t))  /* Memory Pipe MMR Write Error Status */
#define ENUM_PVP_MPWRERR_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* MPWRERR: No Pending Interrupt */
#define ENUM_PVP_MPWRERR_HI                  (_ADI_MSK(0x00000008,uint32_t))  /* MPWRERR: Pending Interrupt */

#define BITM_PVP_STAT_CPWRERR                (_ADI_MSK(0x00000004,uint32_t))  /* Camera Pipe MMR Write Error Status */
#define ENUM_PVP_CPWRERR_LO                  (_ADI_MSK(0x00000000,uint32_t))  /* CPWRERR: No Pending Interrupt */
#define ENUM_PVP_CPWRERR_HI                  (_ADI_MSK(0x00000004,uint32_t))  /* CPWRERR: Pending Interrupt */

#define BITM_PVP_STAT_MPDC                   (_ADI_MSK(0x00000002,uint32_t))  /* Memory Pipe DC Status */
#define ENUM_PVP_MPDC_LO                     (_ADI_MSK(0x00000000,uint32_t))  /* MPDC: No Pending Interrupt */
#define ENUM_PVP_MPDC_HI                     (_ADI_MSK(0x00000002,uint32_t))  /* MPDC: Pending Interrupt */

#define BITM_PVP_STAT_CPDC                   (_ADI_MSK(0x00000001,uint32_t))  /* Camera Pipe DC Status */
#define ENUM_PVP_CPDC_LO                     (_ADI_MSK(0x00000000,uint32_t))  /* CPDC: No Pending Interrupt */
#define ENUM_PVP_CPDC_HI                     (_ADI_MSK(0x00000001,uint32_t))  /* CPDC: Pending Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_ILAT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_ILAT_ACUSUMSAT              27                               /* ACU SUM Saturate Latch */
#define BITP_PVP_ILAT_ACUPRODSAT             26                               /* ACU PROD Saturate Latch */
#define BITP_PVP_ILAT_ACUOUTSAT              25                               /* ACU MIN/MAX Saturate Latch */
#define BITP_PVP_ILAT_ACUDIVERR              24                               /* ACU Divide By Zero Latch */
#define BITP_PVP_ILAT_IIM1SOVF               23                               /* IIM1 Signed Overflow Latch */
#define BITP_PVP_ILAT_IIM1UOVF               22                               /* IIM1 Unsigned Overflow Latch */
#define BITP_PVP_ILAT_IIM0SOVF               21                               /* IIM0 Signed Overflow Latch */
#define BITP_PVP_ILAT_IIM0UOVF               20                               /* IIM0 Unsigned Overflow Latch */
#define BITP_PVP_ILAT_THC1RDY                18                               /* THC1 Report Ready Latch */
#define BITP_PVP_ILAT_THC0RDY                16                               /* THC0 Report Ready Latch */
#define BITP_PVP_ILAT_MPRDY                  15                               /* Memory Pipe Ready Latch */
#define BITP_PVP_ILAT_CPRDY                  14                               /* Camera Pipe Ready Latch */
#define BITP_PVP_ILAT_MPDRN                  13                               /* Memory Pipe Drain Done Latch */
#define BITP_PVP_ILAT_CPDRN                  12                               /* Camera Pipe Drain Done Latch */
#define BITP_PVP_ILAT_CPIPFOVF               10                               /* Camera Pipe Pixel Overrun Latch */
#define BITP_PVP_ILAT_MPOPFDAT                9                               /* Memory Pipe First Pixel Latch */
#define BITP_PVP_ILAT_CPOPFDAT                8                               /* Camera Pipe First Pixel Latch */
#define BITP_PVP_ILAT_CPSTOVF                 7                               /* Status DDE Stall Error Latch */
#define BITP_PVP_ILAT_OPF2OVF                 6                               /* OPF2 DDE Stall Error Latch */
#define BITP_PVP_ILAT_OPF1OVF                 5                               /* OPF1 DDE Stall Error Latch */
#define BITP_PVP_ILAT_OPF0OVF                 4                               /* OPF0 DDE Stall Error Latch */
#define BITP_PVP_ILAT_MPWRERR                 3                               /* Memory Pipe MMR Write Error Latch */
#define BITP_PVP_ILAT_CPWRERR                 2                               /* Camera Pipe MMR Write Error Latch */
#define BITP_PVP_ILAT_MPDC                    1                               /* Memory Pipe DC Mask */
#define BITP_PVP_ILAT_CPDC                    0                               /* Camera Pipe DC Latch */

/* The fields and enumerations for PVP_ILAT are also in PVP - see the common set of ENUM_PVP_* #defines located with register PVP_STAT */

#define BITM_PVP_ILAT_ACUSUMSAT              (_ADI_MSK(0x08000000,uint32_t))  /* ACU SUM Saturate Latch */
#define BITM_PVP_ILAT_ACUPRODSAT             (_ADI_MSK(0x04000000,uint32_t))  /* ACU PROD Saturate Latch */
#define BITM_PVP_ILAT_ACUOUTSAT              (_ADI_MSK(0x02000000,uint32_t))  /* ACU MIN/MAX Saturate Latch */
#define BITM_PVP_ILAT_ACUDIVERR              (_ADI_MSK(0x01000000,uint32_t))  /* ACU Divide By Zero Latch */
#define BITM_PVP_ILAT_IIM1SOVF               (_ADI_MSK(0x00800000,uint32_t))  /* IIM1 Signed Overflow Latch */
#define BITM_PVP_ILAT_IIM1UOVF               (_ADI_MSK(0x00400000,uint32_t))  /* IIM1 Unsigned Overflow Latch */
#define BITM_PVP_ILAT_IIM0SOVF               (_ADI_MSK(0x00200000,uint32_t))  /* IIM0 Signed Overflow Latch */
#define BITM_PVP_ILAT_IIM0UOVF               (_ADI_MSK(0x00100000,uint32_t))  /* IIM0 Unsigned Overflow Latch */
#define BITM_PVP_ILAT_THC1RDY                (_ADI_MSK(0x00040000,uint32_t))  /* THC1 Report Ready Latch */
#define BITM_PVP_ILAT_THC0RDY                (_ADI_MSK(0x00010000,uint32_t))  /* THC0 Report Ready Latch */
#define BITM_PVP_ILAT_MPRDY                  (_ADI_MSK(0x00008000,uint32_t))  /* Memory Pipe Ready Latch */
#define BITM_PVP_ILAT_CPRDY                  (_ADI_MSK(0x00004000,uint32_t))  /* Camera Pipe Ready Latch */
#define BITM_PVP_ILAT_MPDRN                  (_ADI_MSK(0x00002000,uint32_t))  /* Memory Pipe Drain Done Latch */
#define BITM_PVP_ILAT_CPDRN                  (_ADI_MSK(0x00001000,uint32_t))  /* Camera Pipe Drain Done Latch */
#define BITM_PVP_ILAT_CPIPFOVF               (_ADI_MSK(0x00000400,uint32_t))  /* Camera Pipe Pixel Overrun Latch */
#define BITM_PVP_ILAT_MPOPFDAT               (_ADI_MSK(0x00000200,uint32_t))  /* Memory Pipe First Pixel Latch */
#define BITM_PVP_ILAT_CPOPFDAT               (_ADI_MSK(0x00000100,uint32_t))  /* Camera Pipe First Pixel Latch */
#define BITM_PVP_ILAT_CPSTOVF                (_ADI_MSK(0x00000080,uint32_t))  /* Status DDE Stall Error Latch */
#define BITM_PVP_ILAT_OPF2OVF                (_ADI_MSK(0x00000040,uint32_t))  /* OPF2 DDE Stall Error Latch */
#define BITM_PVP_ILAT_OPF1OVF                (_ADI_MSK(0x00000020,uint32_t))  /* OPF1 DDE Stall Error Latch */
#define BITM_PVP_ILAT_OPF0OVF                (_ADI_MSK(0x00000010,uint32_t))  /* OPF0 DDE Stall Error Latch */
#define BITM_PVP_ILAT_MPWRERR                (_ADI_MSK(0x00000008,uint32_t))  /* Memory Pipe MMR Write Error Latch */
#define BITM_PVP_ILAT_CPWRERR                (_ADI_MSK(0x00000004,uint32_t))  /* Camera Pipe MMR Write Error Latch */
#define BITM_PVP_ILAT_MPDC                   (_ADI_MSK(0x00000002,uint32_t))  /* Memory Pipe DC Mask */
#define BITM_PVP_ILAT_CPDC                   (_ADI_MSK(0x00000001,uint32_t))  /* Camera Pipe DC Latch */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IREQ                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IREQ_ACUSUMSAT              27                               /* ACU SUM Saturate Request */
#define BITP_PVP_IREQ_ACUPRODSAT             26                               /* ACU PROD Saturate Request */
#define BITP_PVP_IREQ_ACUOUTSAT              25                               /* ACU MIN/MAX Saturate Request */
#define BITP_PVP_IREQ_ACUDIVERR              24                               /* ACU Divide By Zero Request */
#define BITP_PVP_IREQ_IIM1SOVF               23                               /* IIM1 Signed Overflow Request */
#define BITP_PVP_IREQ_IIM1UOVF               22                               /* IIM1 Unsigned Overflow Request */
#define BITP_PVP_IREQ_IIM0SOVF               21                               /* IIM0 Signed Overflow Request */
#define BITP_PVP_IREQ_IIM0UOVF               20                               /* IIM0 Unsigned Overflow Request */
#define BITP_PVP_IREQ_THC1RDY                18                               /* THC1 Report Ready Request */
#define BITP_PVP_IREQ_THC0RDY                16                               /* THC0 Report Ready Request */
#define BITP_PVP_IREQ_MPRDY                  15                               /* Memory Pipe Ready Request */
#define BITP_PVP_IREQ_CPRDY                  14                               /* Camera Pipe Ready Request */
#define BITP_PVP_IREQ_MPDRN                  13                               /* Memory Pipe Drain Done Request */
#define BITP_PVP_IREQ_CPDRN                  12                               /* Camera Pipe Drain Done Request */
#define BITP_PVP_IREQ_CPIPFOVF               10                               /* Camera Pipe Pixel Overrun Request */
#define BITP_PVP_IREQ_MPOPFDAT                9                               /* Memory Pipe First Pixel Request */
#define BITP_PVP_IREQ_CPOPFDAT                8                               /* Camera Pipe First Pixel Request */
#define BITP_PVP_IREQ_CPSTOVF                 7                               /* Status DDE Stall Error Request */
#define BITP_PVP_IREQ_OPF2OVF                 6                               /* OPF2 DDE Stall Error Request */
#define BITP_PVP_IREQ_OPF1OVF                 5                               /* OPF1 DDE Stall Error Request */
#define BITP_PVP_IREQ_OPF0OVF                 4                               /* OPF0 DDE Stall Error Request */
#define BITP_PVP_IREQ_MPWRERR                 3                               /* Memory Pipe MMR Write Error Request */
#define BITP_PVP_IREQ_CPWRERR                 2                               /* Camera Pipe MMR Write Error Request */
#define BITP_PVP_IREQ_MPDC                    1                               /* Memory Pipe DC Request */
#define BITP_PVP_IREQ_CPDC                    0                               /* Camera Pipe DC Request */

/* The fields and enumerations for PVP_IREQ are also in PVP - see the common set of ENUM_PVP_* #defines located with register PVP_STAT */

#define BITM_PVP_IREQ_ACUSUMSAT              (_ADI_MSK(0x08000000,uint32_t))  /* ACU SUM Saturate Request */
#define BITM_PVP_IREQ_ACUPRODSAT             (_ADI_MSK(0x04000000,uint32_t))  /* ACU PROD Saturate Request */
#define BITM_PVP_IREQ_ACUOUTSAT              (_ADI_MSK(0x02000000,uint32_t))  /* ACU MIN/MAX Saturate Request */
#define BITM_PVP_IREQ_ACUDIVERR              (_ADI_MSK(0x01000000,uint32_t))  /* ACU Divide By Zero Request */
#define BITM_PVP_IREQ_IIM1SOVF               (_ADI_MSK(0x00800000,uint32_t))  /* IIM1 Signed Overflow Request */
#define BITM_PVP_IREQ_IIM1UOVF               (_ADI_MSK(0x00400000,uint32_t))  /* IIM1 Unsigned Overflow Request */
#define BITM_PVP_IREQ_IIM0SOVF               (_ADI_MSK(0x00200000,uint32_t))  /* IIM0 Signed Overflow Request */
#define BITM_PVP_IREQ_IIM0UOVF               (_ADI_MSK(0x00100000,uint32_t))  /* IIM0 Unsigned Overflow Request */
#define BITM_PVP_IREQ_THC1RDY                (_ADI_MSK(0x00040000,uint32_t))  /* THC1 Report Ready Request */
#define BITM_PVP_IREQ_THC0RDY                (_ADI_MSK(0x00010000,uint32_t))  /* THC0 Report Ready Request */
#define BITM_PVP_IREQ_MPRDY                  (_ADI_MSK(0x00008000,uint32_t))  /* Memory Pipe Ready Request */
#define BITM_PVP_IREQ_CPRDY                  (_ADI_MSK(0x00004000,uint32_t))  /* Camera Pipe Ready Request */
#define BITM_PVP_IREQ_MPDRN                  (_ADI_MSK(0x00002000,uint32_t))  /* Memory Pipe Drain Done Request */
#define BITM_PVP_IREQ_CPDRN                  (_ADI_MSK(0x00001000,uint32_t))  /* Camera Pipe Drain Done Request */
#define BITM_PVP_IREQ_CPIPFOVF               (_ADI_MSK(0x00000400,uint32_t))  /* Camera Pipe Pixel Overrun Request */
#define BITM_PVP_IREQ_MPOPFDAT               (_ADI_MSK(0x00000200,uint32_t))  /* Memory Pipe First Pixel Request */
#define BITM_PVP_IREQ_CPOPFDAT               (_ADI_MSK(0x00000100,uint32_t))  /* Camera Pipe First Pixel Request */
#define BITM_PVP_IREQ_CPSTOVF                (_ADI_MSK(0x00000080,uint32_t))  /* Status DDE Stall Error Request */
#define BITM_PVP_IREQ_OPF2OVF                (_ADI_MSK(0x00000040,uint32_t))  /* OPF2 DDE Stall Error Request */
#define BITM_PVP_IREQ_OPF1OVF                (_ADI_MSK(0x00000020,uint32_t))  /* OPF1 DDE Stall Error Request */
#define BITM_PVP_IREQ_OPF0OVF                (_ADI_MSK(0x00000010,uint32_t))  /* OPF0 DDE Stall Error Request */
#define BITM_PVP_IREQ_MPWRERR                (_ADI_MSK(0x00000008,uint32_t))  /* Memory Pipe MMR Write Error Request */
#define BITM_PVP_IREQ_CPWRERR                (_ADI_MSK(0x00000004,uint32_t))  /* Camera Pipe MMR Write Error Request */
#define BITM_PVP_IREQ_MPDC                   (_ADI_MSK(0x00000002,uint32_t))  /* Memory Pipe DC Request */
#define BITM_PVP_IREQ_CPDC                   (_ADI_MSK(0x00000001,uint32_t))  /* Camera Pipe DC Request */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_OPF_CFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_OPF_CFG_IBLOCK0              8                               /* Input Block ID */
#define BITP_PVP_OPF_CFG_IPORT0               4                               /* Input Port ID */
#define BITP_PVP_OPF_CFG_MPIPE                2                               /* Memory Pipe */
#define BITP_PVP_OPF_CFG_START                0                               /* Start */
#define BITM_PVP_OPF_CFG_IBLOCK0             (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block ID */
#define BITM_PVP_OPF_CFG_IPORT0              (_ADI_MSK(0x00000030,uint32_t))  /* Input Port ID */
#define BITM_PVP_OPF_CFG_MPIPE               (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define BITM_PVP_OPF_CFG_START               (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_OPF_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_OPF_CTL_FINISH              12                               /* Finish Enable */
#define BITP_PVP_OPF_CTL_OSIZE                8                               /* Output Data Size */
#define BITP_PVP_OPF_CTL_QFRMT                5                               /* Q Format Correction */
#define BITP_PVP_OPF_CTL_IUP16                4                               /* Input Upper 16-Bit Data */
#define BITP_PVP_OPF_CTL_ISIZE                0                               /* Input Data Size */

#define BITM_PVP_OPF_CTL_FINISH              (_ADI_MSK(0x00001000,uint32_t))  /* Finish Enable */
#define ENUM_PVP_OPF_CTL_NOFINISH            (_ADI_MSK(0x00000000,uint32_t))  /* FINISH: Disable Finish Signal */
#define ENUM_PVP_OPF_CTL_FINISH              (_ADI_MSK(0x00001000,uint32_t))  /* FINISH: Enable Finish Signal */

#define BITM_PVP_OPF_CTL_OSIZE               (_ADI_MSK(0x00000300,uint32_t))  /* Output Data Size */
#define ENUM_PVP_OPF_CTL_OSIZE32             (_ADI_MSK(0x00000000,uint32_t))  /* OSIZE: 32-Bit Output Data Size */
#define ENUM_PVP_OPF_CTL_OSIZE16             (_ADI_MSK(0x00000100,uint32_t))  /* OSIZE: 16-Bit Output Data Size */
#define ENUM_PVP_OPF_CTL_OSIZE8              (_ADI_MSK(0x00000200,uint32_t))  /* OSIZE: 8-Bit Output Data Size */

#define BITM_PVP_OPF_CTL_QFRMT               (_ADI_MSK(0x00000020,uint32_t))  /* Q Format Correction */
#define ENUM_PVP_OPF_CTL_NOQFRMT             (_ADI_MSK(0x00000000,uint32_t))  /* QFRMT: Disable Q Format Correction */
#define ENUM_PVP_OPF_CTL_QFRMT               (_ADI_MSK(0x00000020,uint32_t))  /* QFRMT: Enable Q Format Correction */

#define BITM_PVP_OPF_CTL_IUP16               (_ADI_MSK(0x00000010,uint32_t))  /* Input Upper 16-Bit Data */
#define ENUM_PVP_OPF_CTL_LOWER16             (_ADI_MSK(0x00000000,uint32_t))  /* IUP16: Lower 16 Bits */
#define ENUM_PVP_OPF_CTL_UPPER16             (_ADI_MSK(0x00000010,uint32_t))  /* IUP16: Upper 16 Bits */

#define BITM_PVP_OPF_CTL_ISIZE               (_ADI_MSK(0x00000003,uint32_t))  /* Input Data Size */
#define ENUM_PVP_OPF_CTL_ISIZE32             (_ADI_MSK(0x00000000,uint32_t))  /* ISIZE: 32-Bit Input Data Size */
#define ENUM_PVP_OPF_CTL_ISIZE16             (_ADI_MSK(0x00000001,uint32_t))  /* ISIZE: 16-Bit Input Data Size */
#define ENUM_PVP_OPF_CTL_ISIZE8              (_ADI_MSK(0x00000002,uint32_t))  /* ISIZE: 8-Bit Input Data Size */
#define ENUM_PVP_OPF_CTL_ISIZE4              (_ADI_MSK(0x00000003,uint32_t))  /* ISIZE: 4-Bit Input Data Size */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_OPF3_CFG                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_OPF3_CFG_IBLOCK0             8                               /* Input Block ID */
#define BITP_PVP_OPF3_CFG_IPORT0              4                               /* Input Port ID */
#define BITP_PVP_OPF3_CFG_MPIPE               2                               /* Memory Pipe */
#define BITP_PVP_OPF3_CFG_START               0                               /* Start */
#define BITM_PVP_OPF3_CFG_IBLOCK0            (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block ID */
#define BITM_PVP_OPF3_CFG_IPORT0             (_ADI_MSK(0x00000030,uint32_t))  /* Input Port ID */
#define BITM_PVP_OPF3_CFG_MPIPE              (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define BITM_PVP_OPF3_CFG_START              (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_OPF3_CTL                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_OPF3_CTL_FINISH             12                               /* Finish Enable */
#define BITP_PVP_OPF3_CTL_OSIZE               8                               /* Output Data Size */
#define BITP_PVP_OPF3_CTL_QFRMT               5                               /* Q Format Correction */
#define BITP_PVP_OPF3_CTL_IUP16               4                               /* Input Upper 16-Bit Data */
#define BITP_PVP_OPF3_CTL_ISIZE               0                               /* Input Data Size */

#define BITM_PVP_OPF3_CTL_FINISH             (_ADI_MSK(0x00001000,uint32_t))  /* Finish Enable */
#define ENUM_PVP_OPF3_CTL_NOFINISH           (_ADI_MSK(0x00000000,uint32_t))  /* FINISH: Disable Finish Signal */
#define ENUM_PVP_OPF3_CTL_FINISH             (_ADI_MSK(0x00001000,uint32_t))  /* FINISH: Enable Finish Signal */

#define BITM_PVP_OPF3_CTL_OSIZE              (_ADI_MSK(0x00000300,uint32_t))  /* Output Data Size */
#define ENUM_PVP_OPF3_CTL_OSIZE32            (_ADI_MSK(0x00000000,uint32_t))  /* OSIZE: 32-Bit Output Data Size */
#define ENUM_PVP_OPF3_CTL_OSIZE16            (_ADI_MSK(0x00000100,uint32_t))  /* OSIZE: 16-Bit Output Data Size */
#define ENUM_PVP_OPF3_CTL_OSIZE8             (_ADI_MSK(0x00000200,uint32_t))  /* OSIZE: 8-Bit Output Data Size */

#define BITM_PVP_OPF3_CTL_QFRMT              (_ADI_MSK(0x00000020,uint32_t))  /* Q Format Correction */
#define ENUM_PVP_OPF3_CTL_NOQFRMT            (_ADI_MSK(0x00000000,uint32_t))  /* QFRMT: Disable Q Format Correction */
#define ENUM_PVP_OPF3_CTL_QFRMT              (_ADI_MSK(0x00000020,uint32_t))  /* QFRMT: Enable Q Format Correction */

#define BITM_PVP_OPF3_CTL_IUP16              (_ADI_MSK(0x00000010,uint32_t))  /* Input Upper 16-Bit Data */
#define ENUM_PVP_OPF3_CTL_LOWER16            (_ADI_MSK(0x00000000,uint32_t))  /* IUP16: Lower 16 Bits */
#define ENUM_PVP_OPF3_CTL_UPPER16            (_ADI_MSK(0x00000010,uint32_t))  /* IUP16: Upper 16 Bits */

#define BITM_PVP_OPF3_CTL_ISIZE              (_ADI_MSK(0x00000003,uint32_t))  /* Input Data Size */
#define ENUM_PVP_OPF3_CTL_ISIZE32            (_ADI_MSK(0x00000000,uint32_t))  /* ISIZE: 32-Bit Input Data Size */
#define ENUM_PVP_OPF3_CTL_ISIZE16            (_ADI_MSK(0x00000001,uint32_t))  /* ISIZE: 16-Bit Input Data Size */
#define ENUM_PVP_OPF3_CTL_ISIZE8             (_ADI_MSK(0x00000002,uint32_t))  /* ISIZE: 8-Bit Input Data Size */
#define ENUM_PVP_OPF3_CTL_ISIZE4             (_ADI_MSK(0x00000003,uint32_t))  /* ISIZE: 4-Bit Input Data Size */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_PEC_CFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_PEC_CFG_IBLOCK0              8                               /* Input Block ID */
#define BITP_PVP_PEC_CFG_IPORT0               4                               /* Input Port ID */
#define BITP_PVP_PEC_CFG_MPIPE                2                               /* Memory Pipe */
#define BITP_PVP_PEC_CFG_START                0                               /* Start */
#define BITM_PVP_PEC_CFG_IBLOCK0             (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block ID */
#define BITM_PVP_PEC_CFG_IPORT0              (_ADI_MSK(0x00000030,uint32_t))  /* Input Port ID */

#define BITM_PVP_PEC_CFG_MPIPE               (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define ENUM_PVP_PEC_CFG_CAMPIPE             (_ADI_MSK(0x00000000,uint32_t))  /* MPIPE: Camera Pipe */
#define ENUM_PVP_PEC_CFG_MEMPIPE             (_ADI_MSK(0x00000004,uint32_t))  /* MPIPE: Memory Pipe */
#define BITM_PVP_PEC_CFG_START               (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_PEC_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_PEC_CTL_IGNTH1               3                               /* Ignore TH1 Threshold for Encoding */
#define BITP_PVP_PEC_CTL_OSIZE                2                               /* Output Data Size per Bin */
#define BITP_PVP_PEC_CTL_ZCRSS                1                               /* Zero Cross */
#define BITP_PVP_PEC_CTL_MODE                 0                               /* Derivative Mode Select */

#define BITM_PVP_PEC_CTL_IGNTH1              (_ADI_MSK(0x00000008,uint32_t))  /* Ignore TH1 Threshold for Encoding */
#define ENUM_PVP_PEC_CTL_ENCODEDIFF          (_ADI_MSK(0x00000000,uint32_t))  /* IGNTH1: Different Strong/Weak Edge Encoding */
#define ENUM_PVP_PEC_CTL_ENCODESAME          (_ADI_MSK(0x00000008,uint32_t))  /* IGNTH1: Identical Strong/Weak Edge Encoding */

#define BITM_PVP_PEC_CTL_OSIZE               (_ADI_MSK(0x00000004,uint32_t))  /* Output Data Size per Bin */
#define ENUM_PVP_PEC_CTL_BIN8                (_ADI_MSK(0x00000000,uint32_t))  /* OSIZE: 8 Bits Per Bin PEC Output Data Size */
#define ENUM_PVP_PEC_CTL_BIN16               (_ADI_MSK(0x00000004,uint32_t))  /* OSIZE: 16 Bits Per Bin PEC Output Data Size */

#define BITM_PVP_PEC_CTL_ZCRSS               (_ADI_MSK(0x00000002,uint32_t))  /* Zero Cross */
#define ENUM_PVP_PEC_CTL_ANGLE               (_ADI_MSK(0x00000000,uint32_t))  /* ZCRSS: Angle Indices and Sub-Pixel Values */
#define ENUM_PVP_PEC_CTL_ZEROCROSS           (_ADI_MSK(0x00000002,uint32_t))  /* ZCRSS: Zero Crossing Codes and Sub-Pixel Values */

#define BITM_PVP_PEC_CTL_MODE                (_ADI_MSK(0x00000001,uint32_t))  /* Derivative Mode Select */
#define ENUM_PVP_PEC_CTL_DERIV1              (_ADI_MSK(0x00000000,uint32_t))  /* MODE: 1st Derivative Mode */
#define ENUM_PVP_PEC_CTL_DERIV2              (_ADI_MSK(0x00000001,uint32_t))  /* MODE: 2nd Derivative Mode */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_PEC_D1TH0                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_PEC_D1TH0_VALUE              0                               /* Lower Hysteresis Threshold */
#define BITM_PVP_PEC_D1TH0_VALUE             (_ADI_MSK(0x0000FFFF,uint32_t))  /* Lower Hysteresis Threshold */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_PEC_D1TH1                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_PEC_D1TH1_VALUE              0                               /* Upper Hysteresis Threshold */
#define BITM_PVP_PEC_D1TH1_VALUE             (_ADI_MSK(0x0000FFFF,uint32_t))  /* Upper Hysteresis Threshold */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_PEC_D2TH0                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_PEC_D2TH0_VALUE              0                               /* Weak Zero Crossing Threshold */
#define BITM_PVP_PEC_D2TH0_VALUE             (_ADI_MSK(0x00007FFF,uint32_t))  /* Weak Zero Crossing Threshold */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_PEC_D2TH1                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_PEC_D2TH1_VALUE              0                               /* Strong Zero Crossing Threshold */
#define BITM_PVP_PEC_D2TH1_VALUE             (_ADI_MSK(0x00007FFF,uint32_t))  /* Strong Zero Crossing Threshold */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IIM_CFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IIM_CFG_IBLOCK0              8                               /* Input Block ID */
#define BITP_PVP_IIM_CFG_IPORT0               4                               /* Input Port ID */
#define BITP_PVP_IIM_CFG_MPIPE                2                               /* Memory Pipe */
#define BITP_PVP_IIM_CFG_START                0                               /* Start */
#define BITM_PVP_IIM_CFG_IBLOCK0             (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block ID */
#define BITM_PVP_IIM_CFG_IPORT0              (_ADI_MSK(0x00000030,uint32_t))  /* Input Port ID */

#define BITM_PVP_IIM_CFG_MPIPE               (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define ENUM_PVP_IIM_CFG_CAMPIPE             (_ADI_MSK(0x00000000,uint32_t))  /* MPIPE: Camera Pipe */
#define ENUM_PVP_IIM_CFG_MEMPIPE             (_ADI_MSK(0x00000004,uint32_t))  /* MPIPE: Memory Pipe */
#define BITM_PVP_IIM_CFG_START               (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IIM_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IIM_CTL_SHIFT                8                               /* Shift Select */
#define BITP_PVP_IIM_CTL_WIDTH                2                               /* Width Select */
#define BITP_PVP_IIM_CTL_MODE                 0                               /* Mode Select */
#define BITM_PVP_IIM_CTL_SHIFT               (_ADI_MSK(0x00001F00,uint32_t))  /* Shift Select */

#define BITM_PVP_IIM_CTL_WIDTH               (_ADI_MSK(0x0000000C,uint32_t))  /* Width Select */
#define ENUM_PVP_IIM_CTL_SINGLE32            (_ADI_MSK(0x00000000,uint32_t))  /* WIDTH: Single 32 Bit */
#define ENUM_PVP_IIM_CTL_DUAL16              (_ADI_MSK(0x00000004,uint32_t))  /* WIDTH: Dual 16 Bit */
#define ENUM_PVP_IIM_CTL_QUAD8               (_ADI_MSK(0x0000000C,uint32_t))  /* WIDTH: Quad 8 Bit */

#define BITM_PVP_IIM_CTL_MODE                (_ADI_MSK(0x00000003,uint32_t))  /* Mode Select */
#define ENUM_PVP_IIM_CTL_RECTMODE            (_ADI_MSK(0x00000000,uint32_t))  /* MODE: Rectangular Mode ( SAT) */
#define ENUM_PVP_IIM_CTL_DIAGMODE            (_ADI_MSK(0x00000001,uint32_t))  /* MODE: Diagonal Mode ( RSAT -45) */
#define ENUM_PVP_IIM_CTL_ROWMODE             (_ADI_MSK(0x00000002,uint32_t))  /* MODE: Row Mode */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IIM_SCALE                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IIM_SCALE_VSCL              16                               /* Vertical Scaling Factor */
#define BITP_PVP_IIM_SCALE_HSCL               0                               /* Horizontal Scaling Factor */
#define BITM_PVP_IIM_SCALE_VSCL              (_ADI_MSK(0x01FF0000,uint32_t))  /* Vertical Scaling Factor */
#define BITM_PVP_IIM_SCALE_HSCL              (_ADI_MSK(0x000003FF,uint32_t))  /* Horizontal Scaling Factor */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IIM_SOVF_STAT                    Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IIM_SOVF_STAT_VPOS          16                               /* Veritcal Pixel Coordinate */
#define BITP_PVP_IIM_SOVF_STAT_HPOS           0                               /* Horizontal Pixel Coordinate */
#define BITM_PVP_IIM_SOVF_STAT_VPOS          (_ADI_MSK(0x03FF0000,uint32_t))  /* Veritcal Pixel Coordinate */
#define BITM_PVP_IIM_SOVF_STAT_HPOS          (_ADI_MSK(0x000007FF,uint32_t))  /* Horizontal Pixel Coordinate */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IIM_UOVF_STAT                    Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IIM_UOVF_STAT_VPOS          16                               /* Veritcal Pixel Coordinate */
#define BITP_PVP_IIM_UOVF_STAT_HPOS           0                               /* Horizontal Pixel Coordinate */
#define BITM_PVP_IIM_UOVF_STAT_VPOS          (_ADI_MSK(0x03FF0000,uint32_t))  /* Veritcal Pixel Coordinate */
#define BITM_PVP_IIM_UOVF_STAT_HPOS          (_ADI_MSK(0x000007FF,uint32_t))  /* Horizontal Pixel Coordinate */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_ACU_CFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_ACU_CFG_IBLOCK1             16                               /* Input Block 1 ID */
#define BITP_PVP_ACU_CFG_IBLOCK0              8                               /* Input Block 0 ID */
#define BITP_PVP_ACU_CFG_IPORT1               6                               /* Input Port 1 ID */
#define BITP_PVP_ACU_CFG_IPORT0               4                               /* Input Port 0 ID */
#define BITP_PVP_ACU_CFG_MPIPE                2                               /* Memory Pipe */
#define BITP_PVP_ACU_CFG_START                0                               /* Start */
#define BITM_PVP_ACU_CFG_IBLOCK1             (_ADI_MSK(0x00FF0000,uint32_t))  /* Input Block 1 ID */
#define BITM_PVP_ACU_CFG_IBLOCK0             (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block 0 ID */
#define BITM_PVP_ACU_CFG_IPORT1              (_ADI_MSK(0x000000C0,uint32_t))  /* Input Port 1 ID */
#define BITM_PVP_ACU_CFG_IPORT0              (_ADI_MSK(0x00000030,uint32_t))  /* Input Port 0 ID */

#define BITM_PVP_ACU_CFG_MPIPE               (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define ENUM_PVP_ACU_CFG_CAMPIPE             (_ADI_MSK(0x00000000,uint32_t))  /* MPIPE: Camera Pipe */
#define ENUM_PVP_ACU_CFG_MEMPIPE             (_ADI_MSK(0x00000004,uint32_t))  /* MPIPE: Memory Pipe */
#define BITM_PVP_ACU_CFG_START               (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_ACU_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_ACU_CTL_SUMOP               28                               /* Sum Operation */
#define BITP_PVP_ACU_CTL_SUMISW              27                               /* Sum Input Swap */
#define BITP_PVP_ACU_CTL_SUMINP              24                               /* Sum Inputs for Adder */
#define BITP_PVP_ACU_CTL_PRDOP               20                               /* Prod Operation */
#define BITP_PVP_ACU_CTL_PRDISW              19                               /* Prod Input Swap */
#define BITP_PVP_ACU_CTL_PRDINP              16                               /* Prod Inputs for Mult/Div */
#define BITP_PVP_ACU_CTL_ACCFRAME            15                               /* Accumulator Frame */
#define BITP_PVP_ACU_CTL_ACCINP               8                               /* Accumulator Input */
#define BITP_PVP_ACU_CTL_SFTINP               0                               /* Shift Input */

#define BITM_PVP_ACU_CTL_SUMOP               (_ADI_MSK(0x10000000,uint32_t))  /* Sum Operation */
#define ENUM_PVP_ACU_CTL_ADD                 (_ADI_MSK(0x00000000,uint32_t))  /* SUMOP: Add */
#define ENUM_PVP_ACU_CTL_SUBTRACT            (_ADI_MSK(0x10000000,uint32_t))  /* SUMOP: Subtract */

#define BITM_PVP_ACU_CTL_SUMISW              (_ADI_MSK(0x08000000,uint32_t))  /* Sum Input Swap */
#define ENUM_PVP_ACU_CTL_NOSWAPSUM           (_ADI_MSK(0x00000000,uint32_t))  /* SUMISW: Do Not Swap Operands */
#define ENUM_PVP_ACU_CTL_SWAPSUM             (_ADI_MSK(0x08000000,uint32_t))  /* SUMISW: Swap Operands */

#define BITM_PVP_ACU_CTL_SUMINP              (_ADI_MSK(0x03000000,uint32_t))  /* Sum Inputs for Adder */
#define ENUM_PVP_ACU_CTL_SUMXY               (_ADI_MSK(0x00000000,uint32_t))  /* SUMINP: X,Y Inputs */
#define ENUM_PVP_ACU_CTL_SUMXOFF             (_ADI_MSK(0x01000000,uint32_t))  /* SUMINP: X,OFFSET Inputs */
#define ENUM_PVP_ACU_CTL_SUMYOFF             (_ADI_MSK(0x02000000,uint32_t))  /* SUMINP: Y,OFFSET Inputs */

#define BITM_PVP_ACU_CTL_PRDOP               (_ADI_MSK(0x00300000,uint32_t))  /* Prod Operation */
#define ENUM_PVP_ACU_CTL_MULTIPLY            (_ADI_MSK(0x00000000,uint32_t))  /* PRDOP: Multiply */
#define ENUM_PVP_ACU_CTL_DIVQUOTIENT         (_ADI_MSK(0x00100000,uint32_t))  /* PRDOP: Divide with Quotient */
#define ENUM_PVP_ACU_CTL_DIVMODULUS          (_ADI_MSK(0x00200000,uint32_t))  /* PRDOP: Divide with Modulus */

#define BITM_PVP_ACU_CTL_PRDISW              (_ADI_MSK(0x00080000,uint32_t))  /* Prod Input Swap */
#define ENUM_PVP_ACU_CTL_NOSWAPPROD          (_ADI_MSK(0x00000000,uint32_t))  /* PRDISW: Do Not Swap Operands */
#define ENUM_PVP_ACU_CTL_SWAPPROD            (_ADI_MSK(0x00080000,uint32_t))  /* PRDISW: Swap Operands */

#define BITM_PVP_ACU_CTL_PRDINP              (_ADI_MSK(0x00030000,uint32_t))  /* Prod Inputs for Mult/Div */
#define ENUM_PVP_ACU_CTL_PRODXY              (_ADI_MSK(0x00000000,uint32_t))  /* PRDINP: X,Y Inputs */
#define ENUM_PVP_ACU_CTL_PRODXFACT           (_ADI_MSK(0x00010000,uint32_t))  /* PRDINP: X,FACTOR Inputs */
#define ENUM_PVP_ACU_CTL_PRODYFACT           (_ADI_MSK(0x00020000,uint32_t))  /* PRDINP: Y,FACTOR Inputs */
#define ENUM_PVP_ACU_CTL_PRODSUMFACT         (_ADI_MSK(0x00030000,uint32_t))  /* PRDINP: SUM,FACTOR Inputs */

#define BITM_PVP_ACU_CTL_ACCFRAME            (_ADI_MSK(0x00008000,uint32_t))  /* Accumulator Frame */
#define ENUM_PVP_ACU_CTL_ACCUMROW            (_ADI_MSK(0x00000000,uint32_t))  /* ACCFRAME: Clear ACC After Row */
#define ENUM_PVP_ACU_CTL_ACCUMFRAME          (_ADI_MSK(0x00008000,uint32_t))  /* ACCFRAME: Clear ACC After Frame */

#define BITM_PVP_ACU_CTL_ACCINP              (_ADI_MSK(0x00000300,uint32_t))  /* Accumulator Input */
#define ENUM_PVP_ACU_CTL_ACCUMX              (_ADI_MSK(0x00000000,uint32_t))  /* ACCINP: X Input */
#define ENUM_PVP_ACU_CTL_ACCUMSUM            (_ADI_MSK(0x00000100,uint32_t))  /* ACCINP: SUM Input */
#define ENUM_PVP_ACU_CTL_ACCUMPROD           (_ADI_MSK(0x00000200,uint32_t))  /* ACCINP: PROD Input */

#define BITM_PVP_ACU_CTL_SFTINP              (_ADI_MSK(0x00000003,uint32_t))  /* Shift Input */
#define ENUM_PVP_ACU_CTL_SHIFTXIN            (_ADI_MSK(0x00000000,uint32_t))  /* SFTINP: X Input */
#define ENUM_PVP_ACU_CTL_SHIFTSUM            (_ADI_MSK(0x00000001,uint32_t))  /* SFTINP: SUM Result Input */
#define ENUM_PVP_ACU_CTL_SHIFTPROD           (_ADI_MSK(0x00000002,uint32_t))  /* SFTINP: PROD Result Input */
#define ENUM_PVP_ACU_CTL_SHIFTACC            (_ADI_MSK(0x00000003,uint32_t))  /* SFTINP: ACC Result Input */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_ACU_SHIFT                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_ACU_SHIFT_VALUE              0                               /* SHIFT Constant */
#define BITM_PVP_ACU_SHIFT_VALUE             (_ADI_MSK(0x0000003F,uint32_t))  /* SHIFT Constant */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_UDS_CFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_UDS_CFG_IBLOCK0              8                               /* Input Block ID */
#define BITP_PVP_UDS_CFG_IPORT0               4                               /* Input Port ID */
#define BITP_PVP_UDS_CFG_MPIPE                2                               /* Memory Pipe */
#define BITP_PVP_UDS_CFG_START                0                               /* Start */
#define BITM_PVP_UDS_CFG_IBLOCK0             (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block ID */
#define BITM_PVP_UDS_CFG_IPORT0              (_ADI_MSK(0x00000030,uint32_t))  /* Input Port ID */
#define BITM_PVP_UDS_CFG_MPIPE               (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define BITM_PVP_UDS_CFG_START               (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_UDS_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_UDS_CTL_AAVG                 0                               /* Automatic Averaging */

#define BITM_PVP_UDS_CTL_AAVG                (_ADI_MSK(0x00000001,uint32_t))  /* Automatic Averaging */
#define ENUM_PVP_UDS_CTL_MANTAPS             (_ADI_MSK(0x00000000,uint32_t))  /* AAVG: Manual Filter Tap Selection */
#define ENUM_PVP_UDS_CTL_AUTOTAPS            (_ADI_MSK(0x00000001,uint32_t))  /* AAVG: Auto Filter Tap Selection */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_UDS_OHCNT                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_UDS_OHCNT_VALUE              4                               /* H Dimension of Output Frame */
#define BITM_PVP_UDS_OHCNT_VALUE             (_ADI_MSK(0x000000F0,uint32_t))  /* H Dimension of Output Frame */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_UDS_OVCNT                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_UDS_OVCNT_VALUE              4                               /* V Dimension of Output Frame */
#define BITM_PVP_UDS_OVCNT_VALUE             (_ADI_MSK(0x000000F0,uint32_t))  /* V Dimension of Output Frame */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_UDS_HAVG                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_UDS_HAVG_VALUE               0                               /* H Filter Taps */
#define BITM_PVP_UDS_HAVG_VALUE              (_ADI_MSK(0x000000FF,uint32_t))  /* H Filter Taps */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_UDS_VAVG                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_UDS_VAVG_VALUE               0                               /* V Filter Taps */
#define BITM_PVP_UDS_VAVG_VALUE              (_ADI_MSK(0x0000007F,uint32_t))  /* V Filter Taps */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF0_CFG                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF0_CFG_STATWCNT           24                               /* Camera Pipe DMA Status */
#define BITP_PVP_IPF0_CFG_MPIPE               2                               /* Memory Pipe */
#define BITP_PVP_IPF0_CFG_START               0                               /* Start */
#define BITM_PVP_IPF0_CFG_STATWCNT           (_ADI_MSK(0xFF000000,uint32_t))  /* Camera Pipe DMA Status */
#define BITM_PVP_IPF0_CFG_MPIPE              (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define BITM_PVP_IPF0_CFG_START              (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF_PIPECTL                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF_PIPECTL_STATEN           4                               /* DMA Status Enable */
#define BITP_PVP_IPF_PIPECTL_DRAIN            0                               /* Drain Enable */
#define BITM_PVP_IPF_PIPECTL_STATEN          (_ADI_MSK(0x00000010,uint32_t))  /* DMA Status Enable */
#define BITM_PVP_IPF_PIPECTL_DRAIN           (_ADI_MSK(0x00000001,uint32_t))  /* Drain Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF_CTL_QFRMT               27                               /* Q Format Correction */
#define BITP_PVP_IPF_CTL_SIGNEXT             26                               /* Sign Extend */
#define BITP_PVP_IPF_CTL_EXTRED              25                               /* Extract Red/Green */
#define BITP_PVP_IPF_CTL_UNPACK              24                               /* Unpack Incoming */
#define BITP_PVP_IPF_CTL_CFRMT               16                               /* Color Space Format */
#define BITP_PVP_IPF_CTL_OPORT2EN            12                               /* Output Port 2 Enable */
#define BITP_PVP_IPF_CTL_OPORT1EN             8                               /* Output Port 1 Enable */
#define BITP_PVP_IPF_CTL_OPORT0EN             4                               /* Output Port 0 Enable */

#define BITM_PVP_IPF_CTL_QFRMT               (_ADI_MSK(0x08000000,uint32_t))  /* Q Format Correction */
#define ENUM_PVP_IPF_CTL_NOQFRMT             (_ADI_MSK(0x00000000,uint32_t))  /* QFRMT: Disable Q Format Correction */
#define ENUM_PVP_IPF_CTL_QFRMT               (_ADI_MSK(0x08000000,uint32_t))  /* QFRMT: Enable Q Format Correction */

#define BITM_PVP_IPF_CTL_SIGNEXT             (_ADI_MSK(0x04000000,uint32_t))  /* Sign Extend */
#define ENUM_PVP_IPF_CTL_ZEROEXT             (_ADI_MSK(0x00000000,uint32_t))  /* SIGNEXT: Zero Extend */
#define ENUM_PVP_IPF_CTL_SIGNEXT             (_ADI_MSK(0x04000000,uint32_t))  /* SIGNEXT: Sign Extend */

#define BITM_PVP_IPF_CTL_EXTRED              (_ADI_MSK(0x02000000,uint32_t))  /* Extract Red/Green */
#define ENUM_PVP_IPF_CTL_EXTGREEN            (_ADI_MSK(0x00000000,uint32_t))  /* EXTRED: Extract Green */
#define ENUM_PVP_IPF_CTL_EXTRED              (_ADI_MSK(0x02000000,uint32_t))  /* EXTRED: Extract Red */

#define BITM_PVP_IPF_CTL_UNPACK              (_ADI_MSK(0x01000000,uint32_t))  /* Unpack Incoming */
#define ENUM_PVP_IPF_CTL_UNPACKDIS           (_ADI_MSK(0x00000000,uint32_t))  /* UNPACK: No Unpacking */
#define ENUM_PVP_IPF_CTL_UNPACKEN            (_ADI_MSK(0x01000000,uint32_t))  /* UNPACK: Unpack Data */

#define BITM_PVP_IPF_CTL_CFRMT               (_ADI_MSK(0x001F0000,uint32_t))  /* Color Space Format */
#define ENUM_PVP_IPF_CTL_RGB8                (_ADI_MSK(0x00000000,uint32_t))  /* CFRMT: RGB 8-Bit */
#define ENUM_PVP_IPF_CTL_RGB888              (_ADI_MSK(0x00010000,uint32_t))  /* CFRMT: RGB 888 */
#define ENUM_PVP_IPF_CTL_YUV8                (_ADI_MSK(0x00100000,uint32_t))  /* CFRMT: YUV 4:2:2 8-Bit Type 1 */
#define ENUM_PVP_IPF_CTL_YUV8SPLT            (_ADI_MSK(0x00110000,uint32_t))  /* CFRMT: YUV 4:2:2 8-Bit Type 2 */
#define ENUM_PVP_IPF_CTL_YUV8SUBSPLT         (_ADI_MSK(0x00120000,uint32_t))  /* CFRMT: YUV 4:2:2 8-Bit Type 3 */
#define ENUM_PVP_IPF_CTL_YUV8IN16            (_ADI_MSK(0x00130000,uint32_t))  /* CFRMT: YUV 4:2:2 8-Bit Pair 16-Bit */
#define ENUM_PVP_IPF_CTL_RGB565              (_ADI_MSK(0x00020000,uint32_t))  /* CFRMT: RGB 565 */
#define ENUM_PVP_IPF_CTL_YUV16               (_ADI_MSK(0x00140000,uint32_t))  /* CFRMT: YUV 4:2:2 16-Bit Type 1 */
#define ENUM_PVP_IPF_CTL_YUV16SPLT           (_ADI_MSK(0x00150000,uint32_t))  /* CFRMT: YUV 4:2:2 16-Bit Type 2 */
#define ENUM_PVP_IPF_CTL_YUV16SUBSPLT        (_ADI_MSK(0x00160000,uint32_t))  /* CFRMT: YUV 4:2:2 16-Bit Type 3 */
#define ENUM_PVP_IPF_CTL_Y8                  (_ADI_MSK(0x00180000,uint32_t))  /* CFRMT: Y Alone 8-Bit */
#define ENUM_PVP_IPF_CTL_Y16                 (_ADI_MSK(0x00190000,uint32_t))  /* CFRMT: Y Alone 16-Bit */
#define ENUM_PVP_IPF_CTL_Y24                 (_ADI_MSK(0x001A0000,uint32_t))  /* CFRMT: Y Alone 24-Bit */
#define ENUM_PVP_IPF_CTL_WORD32              (_ADI_MSK(0x001B0000,uint32_t))  /* CFRMT: 32 Bit */
#define ENUM_PVP_IPF_CTL_RGB666              (_ADI_MSK(0x00030000,uint32_t))  /* CFRMT: RGB 666 */
#define ENUM_PVP_IPF_CTL_RGB16               (_ADI_MSK(0x00040000,uint32_t))  /* CFRMT: RGB 16-Bit */
#define ENUM_PVP_IPF_CTL_BAYER1              (_ADI_MSK(0x00050000,uint32_t))  /* CFRMT: RGB Bayer Format Type-1 */
#define ENUM_PVP_IPF_CTL_BAYER2              (_ADI_MSK(0x00060000,uint32_t))  /* CFRMT: RGB Bayer Format Type-2 */

#define BITM_PVP_IPF_CTL_OPORT2EN            (_ADI_MSK(0x00001000,uint32_t))  /* Output Port 2 Enable */
#define ENUM_PVP_IPF_CTL_OPORT2DIS           (_ADI_MSK(0x00000000,uint32_t))  /* OPORT2EN: Disable OPORT2 */
#define ENUM_PVP_IPF_CTL_OPORT2EVEN          (_ADI_MSK(0x00001000,uint32_t))  /* OPORT2EN: Enable OPORT2 (full resolution) */

#define BITM_PVP_IPF_CTL_OPORT1EN            (_ADI_MSK(0x00000300,uint32_t))  /* Output Port 1 Enable */
#define ENUM_PVP_IPF_CTL_OPORT1DIS           (_ADI_MSK(0x00000000,uint32_t))  /* OPORT1EN: Disable OPORT1 */
#define ENUM_PVP_IPF_CTL_OPORT1ODD           (_ADI_MSK(0x00000100,uint32_t))  /* OPORT1EN: Enable OPORT1 (full resolution) */
#define ENUM_PVP_IPF_CTL_OPORT1WIN           (_ADI_MSK(0x00000200,uint32_t))  /* OPORT1EN: Enable OPORT1 (windowed resolution) */

#define BITM_PVP_IPF_CTL_OPORT0EN            (_ADI_MSK(0x00000010,uint32_t))  /* Output Port 0 Enable */
#define ENUM_PVP_IPF_CTL_OPORT0DIS           (_ADI_MSK(0x00000000,uint32_t))  /* OPORT0EN: Disable OPORT0 */
#define ENUM_PVP_IPF_CTL_OPORT0EN            (_ADI_MSK(0x00000010,uint32_t))  /* OPORT0EN: Enable OPORT0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF_TAG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF_TAG_VALUE                0                               /* TAG Value */
#define BITM_PVP_IPF_TAG_VALUE               (_ADI_MSK(0x0000FFFF,uint32_t))  /* TAG Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF_HCNT                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF_HCNT_VALUE               0                               /* Effective Width of ROI */
#define BITM_PVP_IPF_HCNT_VALUE              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Effective Width of ROI */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF_VCNT                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF_VCNT_VALUE               0                               /* Effective Height of ROI */
#define BITM_PVP_IPF_VCNT_VALUE              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Effective Height of ROI */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF0_HPOS                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF0_HPOS_VALUE              0                               /* Horizontal Delay of ROI */
#define BITM_PVP_IPF0_HPOS_VALUE             (_ADI_MSK(0x0000FFFF,uint32_t))  /* Horizontal Delay of ROI */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF0_VPOS                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF0_VPOS_VALUE              0                               /* Vertical Delay of ROI */
#define BITM_PVP_IPF0_VPOS_VALUE             (_ADI_MSK(0x0000FFFF,uint32_t))  /* Vertical Delay of ROI */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF_TAG_STAT                     Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF_TAG_STAT_VALUE           0                               /* TAG Value */
#define BITM_PVP_IPF_TAG_STAT_VALUE          (_ADI_MSK(0x0000FFFF,uint32_t))  /* TAG Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_IPF1_CFG                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_IPF1_CFG_STATWCNT           24                               /* Status Word Count */
#define BITP_PVP_IPF1_CFG_MPIPE               2                               /* Memory Pipe */
#define BITP_PVP_IPF1_CFG_START               0                               /* Start */
#define BITM_PVP_IPF1_CFG_STATWCNT           (_ADI_MSK(0xFF000000,uint32_t))  /* Status Word Count */
#define BITM_PVP_IPF1_CFG_MPIPE              (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define BITM_PVP_IPF1_CFG_START              (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_CFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_CFG_IBLOCK0              8                               /* Input Block ID */
#define BITP_PVP_CNV_CFG_IPORT0               4                               /* Input Port ID */
#define BITP_PVP_CNV_CFG_MPIPE                2                               /* Memory Pipe */
#define BITP_PVP_CNV_CFG_START                0                               /* Start */
#define BITM_PVP_CNV_CFG_IBLOCK0             (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block ID */
#define BITM_PVP_CNV_CFG_IPORT0              (_ADI_MSK(0x00000030,uint32_t))  /* Input Port ID */

#define BITM_PVP_CNV_CFG_MPIPE               (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define ENUM_PVP_CNV_CFG_CAMPIPE             (_ADI_MSK(0x00000000,uint32_t))  /* MPIPE: Camera Pipe */
#define ENUM_PVP_CNV_CFG_MEMPIPE             (_ADI_MSK(0x00000004,uint32_t))  /* MPIPE: Memory Pipe */
#define BITM_PVP_CNV_CFG_START               (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_CTL_SHIFT                4                               /* Shift Right */
#define BITP_PVP_CNV_CTL_ZEROFILL             1                               /* Zero Fill */
#define BITP_PVP_CNV_CTL_SAT32                0                               /* Saturate Output to 32 Bits */
#define BITM_PVP_CNV_CTL_SHIFT               (_ADI_MSK(0x000001F0,uint32_t))  /* Shift Right */

#define BITM_PVP_CNV_CTL_ZEROFILL            (_ADI_MSK(0x00000002,uint32_t))  /* Zero Fill */
#define ENUM_PVP_CNV_CTL_EDGEDUP             (_ADI_MSK(0x00000000,uint32_t))  /* ZEROFILL: Duplicated Data Fill */
#define ENUM_PVP_CNV_CTL_EDGEZFILL           (_ADI_MSK(0x00000002,uint32_t))  /* ZEROFILL: Zero Fill */

#define BITM_PVP_CNV_CTL_SAT32               (_ADI_MSK(0x00000001,uint32_t))  /* Saturate Output to 32 Bits */
#define ENUM_PVP_CNV_CTL_SIGNEXT             (_ADI_MSK(0x00000000,uint32_t))  /* SAT32: 16-Bit Saturate of Output */
#define ENUM_PVP_CNV_CTL_SAT32               (_ADI_MSK(0x00000001,uint32_t))  /* SAT32: 32-Bit Saturate of Output */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C00C01                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C00C01_C01              16                               /* Coefficient 0, 1 */
#define BITP_PVP_CNV_C00C01_C00               0                               /* Coefficient 0, 0 */
#define BITM_PVP_CNV_C00C01_C01              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 0, 1 */
#define BITM_PVP_CNV_C00C01_C00              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 0, 0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C02C03                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C02C03_C03              16                               /* Coefficient 0, 3 */
#define BITP_PVP_CNV_C02C03_C02               0                               /* Coefficient 0, 2 */
#define BITM_PVP_CNV_C02C03_C03              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 0, 3 */
#define BITM_PVP_CNV_C02C03_C02              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 0, 2 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C04                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C04_C04                  0                               /* Coefficient 0, 4 */
#define BITM_PVP_CNV_C04_C04                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 0, 4 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C10C11                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C10C11_C11              16                               /* Coefficient 1, 1 */
#define BITP_PVP_CNV_C10C11_C10               0                               /* Coefficient 1, 0 */
#define BITM_PVP_CNV_C10C11_C11              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 1, 1 */
#define BITM_PVP_CNV_C10C11_C10              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 1, 0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C12C13                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C12C13_C13              16                               /* Coefficient 1, 3 */
#define BITP_PVP_CNV_C12C13_C12               0                               /* Coefficient 1, 2 */
#define BITM_PVP_CNV_C12C13_C13              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 1, 3 */
#define BITM_PVP_CNV_C12C13_C12              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 1, 2 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C14                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C14_C14                  0                               /* Coefficient 1, 4 */
#define BITM_PVP_CNV_C14_C14                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 1, 4 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C20C21                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C20C21_C21              16                               /* Coefficient 2, 1 */
#define BITP_PVP_CNV_C20C21_C20               0                               /* Coefficient 2, 0 */
#define BITM_PVP_CNV_C20C21_C21              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 2, 1 */
#define BITM_PVP_CNV_C20C21_C20              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 2, 0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C22C23                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C22C23_C23              16                               /* Coefficient 2, 3 */
#define BITP_PVP_CNV_C22C23_C22               0                               /* Coefficient 2, 2 */
#define BITM_PVP_CNV_C22C23_C23              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 2, 3 */
#define BITM_PVP_CNV_C22C23_C22              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 2, 2 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C24                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C24_C24                  0                               /* Coefficient 2, 4 */
#define BITM_PVP_CNV_C24_C24                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 2, 4 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C30C31                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C30C31_C31              16                               /* Coefficient 3, 1 */
#define BITP_PVP_CNV_C30C31_C30               0                               /* Coefficient 3, 0 */
#define BITM_PVP_CNV_C30C31_C31              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 3, 1 */
#define BITM_PVP_CNV_C30C31_C30              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 3, 0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C32C33                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C32C33_C33              16                               /* Coefficient 3, 3 */
#define BITP_PVP_CNV_C32C33_C32               0                               /* Coefficient 3, 2 */
#define BITM_PVP_CNV_C32C33_C33              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 3, 3 */
#define BITM_PVP_CNV_C32C33_C32              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 3, 2 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C34                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C34_C34                  0                               /* Coefficient 3, 4 */
#define BITM_PVP_CNV_C34_C34                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 3, 4 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C40C41                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C40C41_C41              16                               /* Coefficient 4, 1 */
#define BITP_PVP_CNV_C40C41_C40               0                               /* Coefficient 4, 0 */
#define BITM_PVP_CNV_C40C41_C41              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 4, 1 */
#define BITM_PVP_CNV_C40C41_C40              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 4, 0 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C42C43                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C42C43_C43              16                               /* Coefficient 4, 3 */
#define BITP_PVP_CNV_C42C43_C42               0                               /* Coefficient 4, 2 */
#define BITM_PVP_CNV_C42C43_C43              (_ADI_MSK(0xFFFF0000,uint32_t))  /* Coefficient 4, 3 */
#define BITM_PVP_CNV_C42C43_C42              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 4, 2 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_C44                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_C44_C44                  0                               /* Coefficient 4, 4 */
#define BITM_PVP_CNV_C44_C44                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* Coefficient 4, 4 */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_CNV_SCALE                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_CNV_SCALE_VSCL              16                               /* Vertical Scaling factor */
#define BITP_PVP_CNV_SCALE_HSCL               0                               /* Horizontal Scaling factor */
#define BITM_PVP_CNV_SCALE_VSCL              (_ADI_MSK(0x01FF0000,uint32_t))  /* Vertical Scaling factor */
#define BITM_PVP_CNV_SCALE_HSCL              (_ADI_MSK(0x000003FF,uint32_t))  /* Horizontal Scaling factor */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_THC_CFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_THC_CFG_STATWCNT            24                               /* Status Word Count */
#define BITP_PVP_THC_CFG_IBLOCK0              8                               /* Input Block ID */
#define BITP_PVP_THC_CFG_IPORT0               4                               /* Input Port ID */
#define BITP_PVP_THC_CFG_MPIPE                2                               /* Memory Pipe */
#define BITP_PVP_THC_CFG_START                0                               /* Start */
#define BITM_PVP_THC_CFG_STATWCNT            (_ADI_MSK(0xFF000000,uint32_t))  /* Status Word Count */
#define BITM_PVP_THC_CFG_IBLOCK0             (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block ID */
#define BITM_PVP_THC_CFG_IPORT0              (_ADI_MSK(0x00000030,uint32_t))  /* Input Port ID */

#define BITM_PVP_THC_CFG_MPIPE               (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define ENUM_PVP_THC_CFG_CAMPIPE             (_ADI_MSK(0x00000000,uint32_t))  /* MPIPE: Camera Pipe */
#define ENUM_PVP_THC_CFG_MEMPIPE             (_ADI_MSK(0x00000004,uint32_t))  /* MPIPE: Memory Pipe */
#define BITM_PVP_THC_CFG_START               (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_THC_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_THC_CTL_HISTEN              16                               /* Histogram Counters Enable */
#define BITP_PVP_THC_CTL_RLEWM               11                               /* Run-length Encoding Window Mode */
#define BITP_PVP_THC_CTL_HISTWM               9                               /* Histogram Window Mode */
#define BITP_PVP_THC_CTL_RLEFRAME             8                               /* Run-Length-Encode Frame */
#define BITP_PVP_THC_CTL_OFRMT                4                               /* Output Format */
#define BITP_PVP_THC_CTL_ZEXT                 2                               /* Zero Extend */
#define BITP_PVP_THC_CTL_MODE                 0                               /* Mode */

#define BITM_PVP_THC_CTL_HISTEN              (_ADI_MSK(0x00010000,uint32_t))  /* Histogram Counters Enable */
#define ENUM_PVP_THC_CTL_HISTDIS             (_ADI_MSK(0x00000000,uint32_t))  /* HISTEN: Disable */
#define ENUM_PVP_THC_CTL_HISTEN              (_ADI_MSK(0x00010000,uint32_t))  /* HISTEN: Enable */

#define BITM_PVP_THC_CTL_RLEWM               (_ADI_MSK(0x00001800,uint32_t))  /* Run-length Encoding Window Mode */
#define ENUM_PVP_THC_CTL_COMPFRAME           (_ADI_MSK(0x00000000,uint32_t))  /* RLEWM: Frame Compression */
#define ENUM_PVP_THC_CTL_COMPWIN             (_ADI_MSK(0x00000800,uint32_t))  /* RLEWM: Window Compression */

#define BITM_PVP_THC_CTL_HISTWM              (_ADI_MSK(0x00000600,uint32_t))  /* Histogram Window Mode */
#define ENUM_PVP_THC_CTL_HISTFRAME           (_ADI_MSK(0x00000000,uint32_t))  /* HISTWM: Frame Histogram */
#define ENUM_PVP_THC_CTL_HISTWIN             (_ADI_MSK(0x00000200,uint32_t))  /* HISTWM: Inside-Window Histogram */
#define ENUM_PVP_THC_CTL_HISTOUTWIN          (_ADI_MSK(0x00000400,uint32_t))  /* HISTWM: Outside-Window Histogram */

#define BITM_PVP_THC_CTL_RLEFRAME            (_ADI_MSK(0x00000100,uint32_t))  /* Run-Length-Encode Frame */
#define ENUM_PVP_THC_CTL_RLELINE             (_ADI_MSK(0x00000000,uint32_t))  /* RLEFRAME: Row (Line) Compression */
#define ENUM_PVP_THC_CTL_RLEFRAME            (_ADI_MSK(0x00000100,uint32_t))  /* RLEFRAME: Frame Compression */

#define BITM_PVP_THC_CTL_OFRMT               (_ADI_MSK(0x000000F0,uint32_t))  /* Output Format */
#define ENUM_PVP_THC_CTL_WORD32              (_ADI_MSK(0x00000000,uint32_t))  /* OFRMT: 32-Bit Word ( No Compression ) */
#define ENUM_PVP_THC_CTL_NODATA              (_ADI_MSK(0x000000A0,uint32_t))  /* OFRMT: Disable Output/RLE */
#define ENUM_PVP_THC_CTL_INDX4               (_ADI_MSK(0x00000020,uint32_t))  /* OFRMT: 4-Bit Index ( No Compression) */
#define ENUM_PVP_THC_CTL_INDX4RL4            (_ADI_MSK(0x00000030,uint32_t))  /* OFRMT: 4-Bit Index / 4-Bit Run Length */
#define ENUM_PVP_THC_CTL_INDX4ANGL4          (_ADI_MSK(0x00000040,uint32_t))  /* OFRMT: 4-Bit Index / 4-Bit angle ( No Compression) */
#define ENUM_PVP_THC_CTL_INDX3RL5            (_ADI_MSK(0x00000050,uint32_t))  /* OFRMT: 3-Bit Index / 5-Bit Run Length */
#define ENUM_PVP_THC_CTL_INDX4RL12           (_ADI_MSK(0x00000060,uint32_t))  /* OFRMT: 4-Bit Index / 12-Bit Run Length */
#define ENUM_PVP_THC_CTL_INDX3RL13           (_ADI_MSK(0x00000070,uint32_t))  /* OFRMT: 3-Bit Index / 13-Bit Run Length */
#define ENUM_PVP_THC_CTL_INDX4RL21           (_ADI_MSK(0x00000080,uint32_t))  /* OFRMT: 4-Bit Index / 21-Bit Run Length */
#define ENUM_PVP_THC_CTL_WORD16RL16          (_ADI_MSK(0x00000090,uint32_t))  /* OFRMT: 16-Bit Word / 16-Bit Run Length */

#define BITM_PVP_THC_CTL_ZEXT                (_ADI_MSK(0x00000004,uint32_t))  /* Zero Extend */
#define ENUM_PVP_THC_CTL_ZEXTDIS             (_ADI_MSK(0x00000000,uint32_t))  /* ZEXT: No Zero Extension */
#define ENUM_PVP_THC_CTL_ZEXTEN              (_ADI_MSK(0x00000004,uint32_t))  /* ZEXT: Zero Extend */

#define BITM_PVP_THC_CTL_MODE                (_ADI_MSK(0x00000003,uint32_t))  /* Mode */
#define ENUM_PVP_THC_CTL_CLIPMODE            (_ADI_MSK(0x00000000,uint32_t))  /* MODE: Clipping/Saturation Mode */
#define ENUM_PVP_THC_CTL_QUANTMODE           (_ADI_MSK(0x00000001,uint32_t))  /* MODE: Quantization Mode */
#define ENUM_PVP_THC_CTL_HYSTMODE            (_ADI_MSK(0x00000002,uint32_t))  /* MODE: Hysteresis Mode */

/* ------------------------------------------------------------------------------------------------------------------------
        PVP_PMA_CFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PVP_PMA_CFG_IBLOCK1             16                               /* Input Block 1 ID */
#define BITP_PVP_PMA_CFG_IBLOCK0              8                               /* Input Block 0 ID */
#define BITP_PVP_PMA_CFG_IPORT1               6                               /* Input Port 1 ID */
#define BITP_PVP_PMA_CFG_IPORT0               4                               /* Input Port 0 ID */
#define BITP_PVP_PMA_CFG_MPIPE                2                               /* Memory Pipe */
#define BITP_PVP_PMA_CFG_START                0                               /* Start */
#define BITM_PVP_PMA_CFG_IBLOCK1             (_ADI_MSK(0x00FF0000,uint32_t))  /* Input Block 1 ID */
#define BITM_PVP_PMA_CFG_IBLOCK0             (_ADI_MSK(0x0000FF00,uint32_t))  /* Input Block 0 ID */
#define BITM_PVP_PMA_CFG_IPORT1              (_ADI_MSK(0x000000C0,uint32_t))  /* Input Port 1 ID */
#define BITM_PVP_PMA_CFG_IPORT0              (_ADI_MSK(0x00000030,uint32_t))  /* Input Port 0 ID */

#define BITM_PVP_PMA_CFG_MPIPE               (_ADI_MSK(0x00000004,uint32_t))  /* Memory Pipe */
#define ENUM_PVP_PMA_CFG_CAMPIPE             (_ADI_MSK(0x00000000,uint32_t))  /* MPIPE: Camera Pipe */
#define ENUM_PVP_PMA_CFG_MEMPIPE             (_ADI_MSK(0x00000004,uint32_t))  /* MPIPE: Memory Pipe */
#define BITM_PVP_PMA_CFG_START               (_ADI_MSK(0x00000001,uint32_t))  /* Start */

/* ==================================================
        Pulse-Width Modulator Registers
   ================================================== */

/* =========================
        PWM0
   ========================= */
#define REG_PWM0_CTL                    0xFFC1B000         /* PWM0 Control Register */
#define REG_PWM0_CHANCFG                0xFFC1B004         /* PWM0 Channel Config Register */
#define REG_PWM0_TRIPCFG                0xFFC1B008         /* PWM0 Trip Config Register */
#define REG_PWM0_STAT                   0xFFC1B00C         /* PWM0 Status Register */
#define REG_PWM0_IMSK                   0xFFC1B010         /* PWM0 Interrupt Mask Register */
#define REG_PWM0_ILAT                   0xFFC1B014         /* PWM0 Interrupt Latch Register */
#define REG_PWM0_CHOPCFG                0xFFC1B018         /* PWM0 Chop Configuration Register */
#define REG_PWM0_DT                     0xFFC1B01C         /* PWM0 Dead Time Register */
#define REG_PWM0_SYNC_WID               0xFFC1B020         /* PWM0 Sync Pulse Width Register */
#define REG_PWM0_TM0                    0xFFC1B024         /* PWM0 Timer 0 Period Register */
#define REG_PWM0_TM1                    0xFFC1B028         /* PWM0 Timer 1 Period Register */
#define REG_PWM0_TM2                    0xFFC1B02C         /* PWM0 Timer 2 Period Register */
#define REG_PWM0_TM3                    0xFFC1B030         /* PWM0 Timer 3 Period Register */
#define REG_PWM0_TM4                    0xFFC1B034         /* PWM0 Timer 4 Period Register */
#define REG_PWM0_DLYA                   0xFFC1B038         /* PWM0 Channel A Delay Register */
#define REG_PWM0_DLYB                   0xFFC1B03C         /* PWM0 Channel B Delay Register */
#define REG_PWM0_DLYC                   0xFFC1B040         /* PWM0 Channel C Delay Register */
#define REG_PWM0_DLYD                   0xFFC1B044         /* PWM0 Channel D Delay Register */
#define REG_PWM0_ACTL                   0xFFC1B048         /* PWM0 Channel A Control Register */
#define REG_PWM0_AH0                    0xFFC1B04C         /* PWM0 Channel A-High Duty-0 Register */
#define REG_PWM0_AH1                    0xFFC1B050         /* PWM0 Channel A-High Duty-1 Register */
#define REG_PWM0_AL0                    0xFFC1B05C         /* PWM0 Channel A-Low Duty-0 Register */
#define REG_PWM0_AL1                    0xFFC1B060         /* PWM0 Channel A-Low Duty-1 Register */
#define REG_PWM0_BCTL                   0xFFC1B064         /* PWM0 Channel B Control Register */
#define REG_PWM0_BH0                    0xFFC1B068         /* PWM0 Channel B-High Duty-0 Register */
#define REG_PWM0_BH1                    0xFFC1B06C         /* PWM0 Channel B-High Duty-1 Register */
#define REG_PWM0_BL0                    0xFFC1B078         /* PWM0 Channel B-Low Duty-0 Register */
#define REG_PWM0_BL1                    0xFFC1B07C         /* PWM0 Channel B-Low Duty-1 Register */
#define REG_PWM0_CCTL                   0xFFC1B080         /* PWM0 Channel C Control Register */
#define REG_PWM0_CH0                    0xFFC1B084         /* PWM0 Channel C-High Pulse Duty Register 0 */
#define REG_PWM0_CH1                    0xFFC1B088         /* PWM0 Channel C-High Pulse Duty Register 1 */
#define REG_PWM0_CL0                    0xFFC1B094         /* PWM0 Channel C-Low Pulse Duty Register 0 */
#define REG_PWM0_CL1                    0xFFC1B098         /* PWM0 Channel C-Low Duty-1 Register */
#define REG_PWM0_DCTL                   0xFFC1B09C         /* PWM0 Channel D Control Register */
#define REG_PWM0_DH0                    0xFFC1B0A0         /* PWM0 Channel D-High Duty-0 Register */
#define REG_PWM0_DH1                    0xFFC1B0A4         /* PWM0 Channel D-High Pulse Duty Register 1 */
#define REG_PWM0_DL0                    0xFFC1B0B0         /* PWM0 Channel D-Low Pulse Duty Register 0 */
#define REG_PWM0_DL1                    0xFFC1B0B4         /* PWM0 Channel D-Low Pulse Duty Register 1 */

/* =========================
        PWM1
   ========================= */
#define REG_PWM1_CTL                    0xFFC1B400         /* PWM1 Control Register */
#define REG_PWM1_CHANCFG                0xFFC1B404         /* PWM1 Channel Config Register */
#define REG_PWM1_TRIPCFG                0xFFC1B408         /* PWM1 Trip Config Register */
#define REG_PWM1_STAT                   0xFFC1B40C         /* PWM1 Status Register */
#define REG_PWM1_IMSK                   0xFFC1B410         /* PWM1 Interrupt Mask Register */
#define REG_PWM1_ILAT                   0xFFC1B414         /* PWM1 Interrupt Latch Register */
#define REG_PWM1_CHOPCFG                0xFFC1B418         /* PWM1 Chop Configuration Register */
#define REG_PWM1_DT                     0xFFC1B41C         /* PWM1 Dead Time Register */
#define REG_PWM1_SYNC_WID               0xFFC1B420         /* PWM1 Sync Pulse Width Register */
#define REG_PWM1_TM0                    0xFFC1B424         /* PWM1 Timer 0 Period Register */
#define REG_PWM1_TM1                    0xFFC1B428         /* PWM1 Timer 1 Period Register */
#define REG_PWM1_TM2                    0xFFC1B42C         /* PWM1 Timer 2 Period Register */
#define REG_PWM1_TM3                    0xFFC1B430         /* PWM1 Timer 3 Period Register */
#define REG_PWM1_TM4                    0xFFC1B434         /* PWM1 Timer 4 Period Register */
#define REG_PWM1_DLYA                   0xFFC1B438         /* PWM1 Channel A Delay Register */
#define REG_PWM1_DLYB                   0xFFC1B43C         /* PWM1 Channel B Delay Register */
#define REG_PWM1_DLYC                   0xFFC1B440         /* PWM1 Channel C Delay Register */
#define REG_PWM1_DLYD                   0xFFC1B444         /* PWM1 Channel D Delay Register */
#define REG_PWM1_ACTL                   0xFFC1B448         /* PWM1 Channel A Control Register */
#define REG_PWM1_AH0                    0xFFC1B44C         /* PWM1 Channel A-High Duty-0 Register */
#define REG_PWM1_AH1                    0xFFC1B450         /* PWM1 Channel A-High Duty-1 Register */
#define REG_PWM1_AL0                    0xFFC1B45C         /* PWM1 Channel A-Low Duty-0 Register */
#define REG_PWM1_AL1                    0xFFC1B460         /* PWM1 Channel A-Low Duty-1 Register */
#define REG_PWM1_BCTL                   0xFFC1B464         /* PWM1 Channel B Control Register */
#define REG_PWM1_BH0                    0xFFC1B468         /* PWM1 Channel B-High Duty-0 Register */
#define REG_PWM1_BH1                    0xFFC1B46C         /* PWM1 Channel B-High Duty-1 Register */
#define REG_PWM1_BL0                    0xFFC1B478         /* PWM1 Channel B-Low Duty-0 Register */
#define REG_PWM1_BL1                    0xFFC1B47C         /* PWM1 Channel B-Low Duty-1 Register */
#define REG_PWM1_CCTL                   0xFFC1B480         /* PWM1 Channel C Control Register */
#define REG_PWM1_CH0                    0xFFC1B484         /* PWM1 Channel C-High Pulse Duty Register 0 */
#define REG_PWM1_CH1                    0xFFC1B488         /* PWM1 Channel C-High Pulse Duty Register 1 */
#define REG_PWM1_CL0                    0xFFC1B494         /* PWM1 Channel C-Low Pulse Duty Register 0 */
#define REG_PWM1_CL1                    0xFFC1B498         /* PWM1 Channel C-Low Duty-1 Register */
#define REG_PWM1_DCTL                   0xFFC1B49C         /* PWM1 Channel D Control Register */
#define REG_PWM1_DH0                    0xFFC1B4A0         /* PWM1 Channel D-High Duty-0 Register */
#define REG_PWM1_DH1                    0xFFC1B4A4         /* PWM1 Channel D-High Pulse Duty Register 1 */
#define REG_PWM1_DL0                    0xFFC1B4B0         /* PWM1 Channel D-Low Pulse Duty Register 0 */
#define REG_PWM1_DL1                    0xFFC1B4B4         /* PWM1 Channel D-Low Pulse Duty Register 1 */

/* =========================
        PWM
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        PWM_CTL                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_CTL_INTSYNCREF              18                               /* Timer reference for Internal Sync */
#define BITP_PWM_CTL_EXTSYNCSEL              17                               /* External Sync Select */
#define BITP_PWM_CTL_EXTSYNC                 16                               /* External Sync */
#define BITP_PWM_CTL_DLYDEN                   7                               /* Enable Delay Counter for Channel D */
#define BITP_PWM_CTL_DLYCEN                   6                               /* Enable Delay Counter for Channel C */
#define BITP_PWM_CTL_DLYBEN                   5                               /* Enable Delay Counter for Channel B */
#define BITP_PWM_CTL_DLYAEN                   4                               /* Enable Delay Counter for Channel A */
#define BITP_PWM_CTL_SWTRIP                   2                               /* Software Trip */
#define BITP_PWM_CTL_EMURUN                   1                               /* Output Behavior During Emulation Mode */
#define BITP_PWM_CTL_GLOBEN                   0                               /* Module Enable */

#define BITM_PWM_CTL_INTSYNCREF              (_ADI_MSK(0x001C0000,uint32_t))  /* Timer reference for Internal Sync */
#define ENUM_PWM_CTL_INTSYNC_0               (_ADI_MSK(0x00000000,uint32_t))  /* INTSYNCREF: PWMTMR0 provides sync reference */
#define ENUM_PWM_CTL_INTSYNC_1               (_ADI_MSK(0x00040000,uint32_t))  /* INTSYNCREF: PWMTMR1 provides sync reference */
#define ENUM_PWM_CTL_INTSYNC_2               (_ADI_MSK(0x00080000,uint32_t))  /* INTSYNCREF: PWMTMR2 provides sync reference */
#define ENUM_PWM_CTL_INTSYNC_3               (_ADI_MSK(0x000C0000,uint32_t))  /* INTSYNCREF: PWMTMR3 provides sync reference */
#define ENUM_PWM_CTL_INTSYNC_4               (_ADI_MSK(0x00100000,uint32_t))  /* INTSYNCREF: PWMTMR4 provides sync reference */

#define BITM_PWM_CTL_EXTSYNCSEL              (_ADI_MSK(0x00020000,uint32_t))  /* External Sync Select */
#define ENUM_PWM_CTL_EXTSYNC_ASYNC           (_ADI_MSK(0x00000000,uint32_t))  /* EXTSYNCSEL: Asynchronous External Sync */
#define ENUM_PWM_CTL_EXTSYNC_SYNC            (_ADI_MSK(0x00020000,uint32_t))  /* EXTSYNCSEL: Synchronous External Sync */

#define BITM_PWM_CTL_EXTSYNC                 (_ADI_MSK(0x00010000,uint32_t))  /* External Sync */
#define ENUM_PWM_CTL_INTSYNC                 (_ADI_MSK(0x00000000,uint32_t))  /* EXTSYNC: Internal sync used */
#define ENUM_PWM_CTL_EXTSYNC                 (_ADI_MSK(0x00010000,uint32_t))  /* EXTSYNC: External sync used */

#define BITM_PWM_CTL_DLYDEN                  (_ADI_MSK(0x00000080,uint32_t))  /* Enable Delay Counter for Channel D */
#define ENUM_PWM_CTL_DLYD_DIS                (_ADI_MSK(0x00000000,uint32_t))  /* DLYDEN: Disable */
#define ENUM_PWM_CTL_DLYD_EN                 (_ADI_MSK(0x00000080,uint32_t))  /* DLYDEN: Enable */

#define BITM_PWM_CTL_DLYCEN                  (_ADI_MSK(0x00000040,uint32_t))  /* Enable Delay Counter for Channel C */
#define ENUM_PWM_CTL_DLYC_DIS                (_ADI_MSK(0x00000000,uint32_t))  /* DLYCEN: Disable */
#define ENUM_PWM_CTL_DLYC_EN                 (_ADI_MSK(0x00000040,uint32_t))  /* DLYCEN: Enable */

#define BITM_PWM_CTL_DLYBEN                  (_ADI_MSK(0x00000020,uint32_t))  /* Enable Delay Counter for Channel B */
#define ENUM_PWM_CTL_DLYB_DIS                (_ADI_MSK(0x00000000,uint32_t))  /* DLYBEN: Disable */
#define ENUM_PWM_CTL_DLYB_EN                 (_ADI_MSK(0x00000020,uint32_t))  /* DLYBEN: Enable */

#define BITM_PWM_CTL_DLYAEN                  (_ADI_MSK(0x00000010,uint32_t))  /* Enable Delay Counter for Channel A */
#define ENUM_PWM_CTL_DLYA_DIS                (_ADI_MSK(0x00000000,uint32_t))  /* DLYAEN: Disable */
#define ENUM_PWM_CTL_DLYA_EN                 (_ADI_MSK(0x00000010,uint32_t))  /* DLYAEN: Enable */

#define BITM_PWM_CTL_SWTRIP                  (_ADI_MSK(0x00000004,uint32_t))  /* Software Trip */
#define ENUM_PWM_CTL_FORCE_TRIP              (_ADI_MSK(0x00000004,uint32_t))  /* SWTRIP: Force a Fault Trip Condition */

#define BITM_PWM_CTL_EMURUN                  (_ADI_MSK(0x00000002,uint32_t))  /* Output Behavior During Emulation Mode */
#define ENUM_PWM_CTL_EMURUN_DIS              (_ADI_MSK(0x00000000,uint32_t))  /* EMURUN: Disable Outputs */
#define ENUM_PWM_CTL_EMURUN_EN               (_ADI_MSK(0x00000002,uint32_t))  /* EMURUN: Enable Outputs */

#define BITM_PWM_CTL_GLOBEN                  (_ADI_MSK(0x00000001,uint32_t))  /* Module Enable */
#define ENUM_PWM_CTL_PWM_DIS                 (_ADI_MSK(0x00000000,uint32_t))  /* GLOBEN: Disable */
#define ENUM_PWM_CTL_PWM_EN                  (_ADI_MSK(0x00000001,uint32_t))  /* GLOBEN: Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_CHANCFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_CHANCFG_ENCHOPDL            30                               /* Channel D Gate Chopping Enable Low Side */
#define BITP_PWM_CHANCFG_POLDL               29                               /* Channel D low side Polarity */
#define BITP_PWM_CHANCFG_ENCHOPDH            27                               /* Channel D Gate Chopping Enable High Side */
#define BITP_PWM_CHANCFG_POLDH               26                               /* Channel D High side Polarity */
#define BITP_PWM_CHANCFG_MODELSD             25                               /* Channel D Mode of low Side Output */
#define BITP_PWM_CHANCFG_REFTMRD             24                               /* Channel D Timer Reference */
#define BITP_PWM_CHANCFG_ENCHOPCL            22                               /* Channel C Gate Chopping Enable Low Side */
#define BITP_PWM_CHANCFG_POLCL               21                               /* Channel C low side Polarity */
#define BITP_PWM_CHANCFG_ENCHOPCH            19                               /* Channel C Gate Chopping Enable High Side */
#define BITP_PWM_CHANCFG_POLCH               18                               /* Channel C High side Polarity */
#define BITP_PWM_CHANCFG_MODELSC             17                               /* Channel C Mode of low Side Output */
#define BITP_PWM_CHANCFG_REFTMRC             16                               /* Channel C Timer Reference */
#define BITP_PWM_CHANCFG_ENCHOPBL            14                               /* Channel B Gate Chopping Enable Low Side */
#define BITP_PWM_CHANCFG_POLBL               13                               /* Channel B low side Polarity */
#define BITP_PWM_CHANCFG_ENCHOPBH            11                               /* Channel B Gate Chopping Enable High Side */
#define BITP_PWM_CHANCFG_POLBH               10                               /* Channel B High side Polarity */
#define BITP_PWM_CHANCFG_MODELSB              9                               /* Channel B Mode of low Side Output */
#define BITP_PWM_CHANCFG_REFTMRB              8                               /* Channel B Timer Reference */
#define BITP_PWM_CHANCFG_ENCHOPAL             6                               /* Channel A Gate Chopping Enable Low Side */
#define BITP_PWM_CHANCFG_POLAL                5                               /* Channel A low side Polarity */
#define BITP_PWM_CHANCFG_ENCHOPAH             3                               /* Channel A Gate Chopping Enable High Side */
#define BITP_PWM_CHANCFG_POLAH                2                               /* Channel A High side Polarity */
#define BITP_PWM_CHANCFG_MODELSA              1                               /* Channel A Mode of low Side Output */
#define BITP_PWM_CHANCFG_REFTMRA              0                               /* Channel A Timer Reference */

#define BITM_PWM_CHANCFG_ENCHOPDL            (_ADI_MSK(0x40000000,uint32_t))  /* Channel D Gate Chopping Enable Low Side */
#define ENUM_PWM_CHANCFG_CHOPDL_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* ENCHOPDL: Disable Chopping Channel D Low Side */
#define ENUM_PWM_CHANCFG_CHOPDL_EN           (_ADI_MSK(0x40000000,uint32_t))  /* ENCHOPDL: Enable Chopping Channel D Low Side */

#define BITM_PWM_CHANCFG_POLDL               (_ADI_MSK(0x20000000,uint32_t))  /* Channel D low side Polarity */
#define ENUM_PWM_CHANCFG_DL_ACTLO            (_ADI_MSK(0x00000000,uint32_t))  /* POLDL: Active Low */
#define ENUM_PWM_CHANCFG_DL_ACTHI            (_ADI_MSK(0x20000000,uint32_t))  /* POLDL: Active High */

#define BITM_PWM_CHANCFG_ENCHOPDH            (_ADI_MSK(0x08000000,uint32_t))  /* Channel D Gate Chopping Enable High Side */
#define ENUM_PWM_CHANCFG_CHOPDH_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* ENCHOPDH: Disable Chopping Channel D High Side */
#define ENUM_PWM_CHANCFG_CHOPDH_EN           (_ADI_MSK(0x08000000,uint32_t))  /* ENCHOPDH: Enable Chopping Channel D High Side */

#define BITM_PWM_CHANCFG_POLDH               (_ADI_MSK(0x04000000,uint32_t))  /* Channel D High side Polarity */
#define ENUM_PWM_CHANCFG_DH_ACTLO            (_ADI_MSK(0x00000000,uint32_t))  /* POLDH: Active Low */
#define ENUM_PWM_CHANCFG_DH_ACTHI            (_ADI_MSK(0x04000000,uint32_t))  /* POLDH: Active High */

#define BITM_PWM_CHANCFG_MODELSD             (_ADI_MSK(0x02000000,uint32_t))  /* Channel D Mode of low Side Output */
#define ENUM_PWM_CHANCFG_LOD_INVHI           (_ADI_MSK(0x00000000,uint32_t))  /* MODELSD: Invert of high output */
#define ENUM_PWM_CHANCFG_LOD_IND             (_ADI_MSK(0x02000000,uint32_t))  /* MODELSD: Independent control */

#define BITM_PWM_CHANCFG_REFTMRD             (_ADI_MSK(0x01000000,uint32_t))  /* Channel D Timer Reference */
#define ENUM_PWM_CHANCFG_REFTMRD_0           (_ADI_MSK(0x00000000,uint32_t))  /* REFTMRD: PWMTMR0 is Channel D reference */
#define ENUM_PWM_CHANCFG_REFTMRD_1           (_ADI_MSK(0x01000000,uint32_t))  /* REFTMRD: PWMTMR1 is Channel D reference */

#define BITM_PWM_CHANCFG_ENCHOPCL            (_ADI_MSK(0x00400000,uint32_t))  /* Channel C Gate Chopping Enable Low Side */
#define ENUM_PWM_CHANCFG_CHOPCL_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* ENCHOPCL: Disable Chopping Channel C Low Side */
#define ENUM_PWM_CHANCFG_CHOPCL_EN           (_ADI_MSK(0x00400000,uint32_t))  /* ENCHOPCL: Enable Chopping Channel C Low Side */

#define BITM_PWM_CHANCFG_POLCL               (_ADI_MSK(0x00200000,uint32_t))  /* Channel C low side Polarity */
#define ENUM_PWM_CHANCFG_CL_ACTLO            (_ADI_MSK(0x00000000,uint32_t))  /* POLCL: Active Low */
#define ENUM_PWM_CHANCFG_CL_ACTHI            (_ADI_MSK(0x00200000,uint32_t))  /* POLCL: Active High */

#define BITM_PWM_CHANCFG_ENCHOPCH            (_ADI_MSK(0x00080000,uint32_t))  /* Channel C Gate Chopping Enable High Side */
#define ENUM_PWM_CHANCFG_CHOPCH_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* ENCHOPCH: Disable Chopping Channel C High Side */
#define ENUM_PWM_CHANCFG_CHOPCH_EN           (_ADI_MSK(0x00080000,uint32_t))  /* ENCHOPCH: Enable Chopping Channel C High Side */

#define BITM_PWM_CHANCFG_POLCH               (_ADI_MSK(0x00040000,uint32_t))  /* Channel C High side Polarity */
#define ENUM_PWM_CHANCFG_CH_ACTLO            (_ADI_MSK(0x00000000,uint32_t))  /* POLCH: Active Low */
#define ENUM_PWM_CHANCFG_CH_ACTHI            (_ADI_MSK(0x00040000,uint32_t))  /* POLCH: Active High */

#define BITM_PWM_CHANCFG_MODELSC             (_ADI_MSK(0x00020000,uint32_t))  /* Channel C Mode of low Side Output */
#define ENUM_PWM_CHANCFG_LOC_INVHI           (_ADI_MSK(0x00000000,uint32_t))  /* MODELSC: Invert of high output */
#define ENUM_PWM_CHANCFG_LOC_IND             (_ADI_MSK(0x00020000,uint32_t))  /* MODELSC: Independent control */

#define BITM_PWM_CHANCFG_REFTMRC             (_ADI_MSK(0x00010000,uint32_t))  /* Channel C Timer Reference */
#define ENUM_PWM_CHANCFG_REFTMRC_0           (_ADI_MSK(0x00000000,uint32_t))  /* REFTMRC: PWMTMR0 is Channel C reference */
#define ENUM_PWM_CHANCFG_REFTMRC_1           (_ADI_MSK(0x00010000,uint32_t))  /* REFTMRC: PWMTMR1 is Channel C reference */

#define BITM_PWM_CHANCFG_ENCHOPBL            (_ADI_MSK(0x00004000,uint32_t))  /* Channel B Gate Chopping Enable Low Side */
#define ENUM_PWM_CHANCFG_CHOPBL_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* ENCHOPBL: Disable Chopping Channel B Low Side */
#define ENUM_PWM_CHANCFG_CHOPBL_EN           (_ADI_MSK(0x00004000,uint32_t))  /* ENCHOPBL: Enable Chopping Channel B Low Side */

#define BITM_PWM_CHANCFG_POLBL               (_ADI_MSK(0x00002000,uint32_t))  /* Channel B low side Polarity */
#define ENUM_PWM_CHANCFG_BL_ACTLO            (_ADI_MSK(0x00000000,uint32_t))  /* POLBL: Active Low */
#define ENUM_PWM_CHANCFG_BL_ACTHI            (_ADI_MSK(0x00002000,uint32_t))  /* POLBL: Active High */

#define BITM_PWM_CHANCFG_ENCHOPBH            (_ADI_MSK(0x00000800,uint32_t))  /* Channel B Gate Chopping Enable High Side */
#define ENUM_PWM_CHANCFG_CHOPBH_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* ENCHOPBH: Disable Chopping Channel B High Side */
#define ENUM_PWM_CHANCFG_CHOPBH_EN           (_ADI_MSK(0x00000800,uint32_t))  /* ENCHOPBH: Enable Chopping Channel B High Side */

#define BITM_PWM_CHANCFG_POLBH               (_ADI_MSK(0x00000400,uint32_t))  /* Channel B High side Polarity */
#define ENUM_PWM_CHANCFG_BH_ACTLO            (_ADI_MSK(0x00000000,uint32_t))  /* POLBH: Active Low */
#define ENUM_PWM_CHANCFG_BH_ACTHI            (_ADI_MSK(0x00000400,uint32_t))  /* POLBH: Active High */

#define BITM_PWM_CHANCFG_MODELSB             (_ADI_MSK(0x00000200,uint32_t))  /* Channel B Mode of low Side Output */
#define ENUM_PWM_CHANCFG_LOB_INV             (_ADI_MSK(0x00000000,uint32_t))  /* MODELSB: Invert of high output */
#define ENUM_PWM_CHANCFG_LOB_IND             (_ADI_MSK(0x00000200,uint32_t))  /* MODELSB: Independent control */

#define BITM_PWM_CHANCFG_REFTMRB             (_ADI_MSK(0x00000100,uint32_t))  /* Channel B Timer Reference */
#define ENUM_PWM_CHANCFG_REFTMRB_0           (_ADI_MSK(0x00000000,uint32_t))  /* REFTMRB: PWMTMR0 is Channel  B reference */
#define ENUM_PWM_CHANCFG_REFTMRB_1           (_ADI_MSK(0x00000100,uint32_t))  /* REFTMRB: PWMTMR1 is Channel B reference */

#define BITM_PWM_CHANCFG_ENCHOPAL            (_ADI_MSK(0x00000040,uint32_t))  /* Channel A Gate Chopping Enable Low Side */
#define ENUM_PWM_CHANCFG_CHOPAL_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* ENCHOPAL: Disable Chopping Channel A Low Side */
#define ENUM_PWM_CHANCFG_CHOPAL_EN           (_ADI_MSK(0x00000040,uint32_t))  /* ENCHOPAL: Enable Chopping Channel A Low Side */

#define BITM_PWM_CHANCFG_POLAL               (_ADI_MSK(0x00000020,uint32_t))  /* Channel A low side Polarity */
#define ENUM_PWM_CHANCFG_AL_ACTLO            (_ADI_MSK(0x00000000,uint32_t))  /* POLAL: Active Low */
#define ENUM_PWM_CHANCFG_AL_ACTHI            (_ADI_MSK(0x00000020,uint32_t))  /* POLAL: Active High */

#define BITM_PWM_CHANCFG_ENCHOPAH            (_ADI_MSK(0x00000008,uint32_t))  /* Channel A Gate Chopping Enable High Side */
#define ENUM_PWM_CHANCFG_CHOPAH_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* ENCHOPAH: Disable Chopping Channel A High Side */
#define ENUM_PWM_CHANCFG_CHOPAH_EN           (_ADI_MSK(0x00000008,uint32_t))  /* ENCHOPAH: Enable Chopping Channel A High Side */

#define BITM_PWM_CHANCFG_POLAH               (_ADI_MSK(0x00000004,uint32_t))  /* Channel A High side Polarity */
#define ENUM_PWM_CHANCFG_AH_ACTLO            (_ADI_MSK(0x00000000,uint32_t))  /* POLAH: Active Low */
#define ENUM_PWM_CHANCFG_AH_ACTHI            (_ADI_MSK(0x00000004,uint32_t))  /* POLAH: Active High */

#define BITM_PWM_CHANCFG_MODELSA             (_ADI_MSK(0x00000002,uint32_t))  /* Channel A Mode of low Side Output */
#define ENUM_PWM_CHANCFG_LOA_INVHI           (_ADI_MSK(0x00000000,uint32_t))  /* MODELSA: Invert of high output */
#define ENUM_PWM_CHANCFG_LOA_IND             (_ADI_MSK(0x00000002,uint32_t))  /* MODELSA: Independent control */

#define BITM_PWM_CHANCFG_REFTMRA             (_ADI_MSK(0x00000001,uint32_t))  /* Channel A Timer Reference */
#define ENUM_PWM_CHANCFG_REFTMRA_0           (_ADI_MSK(0x00000000,uint32_t))  /* REFTMRA: PWMTMR0 is Channel A reference */
#define ENUM_PWM_CHANCFG_REFTMRA_1           (_ADI_MSK(0x00000001,uint32_t))  /* REFTMRA: PWMTMR1 is Channel A reference */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_TRIPCFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_TRIPCFG_MODE1D              27                               /* Mode of TRIP1 for Channel D */
#define BITP_PWM_TRIPCFG_EN1D                26                               /* Enable TRIP1 as a trip source for Channel D */
#define BITP_PWM_TRIPCFG_MODE0D              25                               /* Mode of TRIP0 for Channel D */
#define BITP_PWM_TRIPCFG_EN0D                24                               /* Enable TRIP0 as a trip source for Channel D */
#define BITP_PWM_TRIPCFG_MODE1C              19                               /* Mode of TRIP1 for Channel C */
#define BITP_PWM_TRIPCFG_EN1C                18                               /* Enable TRIP1 as a trip source for Channel C */
#define BITP_PWM_TRIPCFG_MODE0C              17                               /* Mode of TRIP0 for Channel C */
#define BITP_PWM_TRIPCFG_EN0C                16                               /* Enable TRIP0 as a trip source for Channel C */
#define BITP_PWM_TRIPCFG_MODE1B              11                               /* Mode of TRIP1 for Channel B */
#define BITP_PWM_TRIPCFG_EN1B                10                               /* Enable TRIP1 as a trip source for Channel B */
#define BITP_PWM_TRIPCFG_MODE0B               9                               /* Mode of TRIP0 for Channel B */
#define BITP_PWM_TRIPCFG_EN0B                 8                               /* Enable TRIP0 as a trip source for Channel B */
#define BITP_PWM_TRIPCFG_MODE1A               3                               /* Mode of TRIP1 for Channel A */
#define BITP_PWM_TRIPCFG_EN1A                 2                               /* Enable TRIP1 as a trip source for Channel A */
#define BITP_PWM_TRIPCFG_MODE0A               1                               /* Mode of TRIP0 for Channel A */
#define BITP_PWM_TRIPCFG_EN0A                 0                               /* Enable TRIP0 as a trip source for Channel A */

#define BITM_PWM_TRIPCFG_MODE1D              (_ADI_MSK(0x08000000,uint32_t))  /* Mode of TRIP1 for Channel D */
#define ENUM_PWM_TRIPCFG_TRIP1D_FLT          (_ADI_MSK(0x00000000,uint32_t))  /* MODE1D: Fault Trip on TRIP1 Input */
#define ENUM_PWM_TRIPCFG_TRIP1D_RSTRT        (_ADI_MSK(0x08000000,uint32_t))  /* MODE1D: Self Restart on TRIP1 Input */

#define BITM_PWM_TRIPCFG_EN1D                (_ADI_MSK(0x04000000,uint32_t))  /* Enable TRIP1 as a trip source for Channel D */
#define ENUM_PWM_TRIPCFG_TRIP1D_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* EN1D: Disable TRIP1 for Channel D */
#define ENUM_PWM_TRIPCFG_TRIP1D_EN           (_ADI_MSK(0x04000000,uint32_t))  /* EN1D: Enable TRIP1 for Channel D */

#define BITM_PWM_TRIPCFG_MODE0D              (_ADI_MSK(0x02000000,uint32_t))  /* Mode of TRIP0 for Channel D */
#define ENUM_PWM_TRIPCFG_TRIP0D_FLT          (_ADI_MSK(0x00000000,uint32_t))  /* MODE0D: Fault Trip on TRIP0 Input */
#define ENUM_PWM_TRIPCFG_TRIP0D_RSTRT        (_ADI_MSK(0x02000000,uint32_t))  /* MODE0D: Self Restart on TRIP0 Input */

#define BITM_PWM_TRIPCFG_EN0D                (_ADI_MSK(0x01000000,uint32_t))  /* Enable TRIP0 as a trip source for Channel D */
#define ENUM_PWM_TRIPCFG_TRIP0D_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* EN0D: Disable TRIP0 for Channel D */
#define ENUM_PWM_TRIPCFG_TRIP0D_EN           (_ADI_MSK(0x01000000,uint32_t))  /* EN0D: Enable TRIP0 for Channel D */

#define BITM_PWM_TRIPCFG_MODE1C              (_ADI_MSK(0x00080000,uint32_t))  /* Mode of TRIP1 for Channel C */
#define ENUM_PWM_TRIPCFG_TRIP1C_FLT          (_ADI_MSK(0x00000000,uint32_t))  /* MODE1C: Fault Trip on TRIP1 Input */
#define ENUM_PWM_TRIPCFG_TRIP1C_RSTRT        (_ADI_MSK(0x00080000,uint32_t))  /* MODE1C: Self Restart on TRIP1 Input */

#define BITM_PWM_TRIPCFG_EN1C                (_ADI_MSK(0x00040000,uint32_t))  /* Enable TRIP1 as a trip source for Channel C */
#define ENUM_PWM_TRIPCFG_TRIP1C_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* EN1C: Disable TRIP1 for Channel C */
#define ENUM_PWM_TRIPCFG_TRIP1C_EN           (_ADI_MSK(0x00040000,uint32_t))  /* EN1C: Enable TRIP1 for Channel C */

#define BITM_PWM_TRIPCFG_MODE0C              (_ADI_MSK(0x00020000,uint32_t))  /* Mode of TRIP0 for Channel C */
#define ENUM_PWM_TRIPCFG_TRIP0C_FLT          (_ADI_MSK(0x00000000,uint32_t))  /* MODE0C: Fault Trip on TRIP0 Input */
#define ENUM_PWM_TRIPCFG_TRIP0C_RSTRT        (_ADI_MSK(0x00020000,uint32_t))  /* MODE0C: Self Restart on TRIP0 Input */

#define BITM_PWM_TRIPCFG_EN0C                (_ADI_MSK(0x00010000,uint32_t))  /* Enable TRIP0 as a trip source for Channel C */
#define ENUM_PWM_TRIPCFG_TRIP0C_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* EN0C: Disable TRIP0 for Channel C */
#define ENUM_PWM_TRIPCFG_TRIP0C_EN           (_ADI_MSK(0x00010000,uint32_t))  /* EN0C: Enable TRIP0 for Channel C */

#define BITM_PWM_TRIPCFG_MODE1B              (_ADI_MSK(0x00000800,uint32_t))  /* Mode of TRIP1 for Channel B */
#define ENUM_PWM_TRIPCFG_TRIP1B_FLT          (_ADI_MSK(0x00000000,uint32_t))  /* MODE1B: Fault Trip on TRIP1 Input */
#define ENUM_PWM_TRIPCFG_TRIP1B_RSTRT        (_ADI_MSK(0x00000800,uint32_t))  /* MODE1B: Self Restart on TRIP1 Input */

#define BITM_PWM_TRIPCFG_EN1B                (_ADI_MSK(0x00000400,uint32_t))  /* Enable TRIP1 as a trip source for Channel B */
#define ENUM_PWM_TRIPCFG_TRIP1B_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* EN1B: Disable TRIP1 for Channel B */
#define ENUM_PWM_TRIPCFG_TRIP1B_EN           (_ADI_MSK(0x00000400,uint32_t))  /* EN1B: Enable TRIP1 for Channel B */

#define BITM_PWM_TRIPCFG_MODE0B              (_ADI_MSK(0x00000200,uint32_t))  /* Mode of TRIP0 for Channel B */
#define ENUM_PWM_TRIPCFG_TRIP0B_FLT          (_ADI_MSK(0x00000000,uint32_t))  /* MODE0B: Fault Trip on TRIP0 Input */
#define ENUM_PWM_TRIPCFG_TRIP0B_RSTRT        (_ADI_MSK(0x00000200,uint32_t))  /* MODE0B: Self Restart on TRIP0 Input */

#define BITM_PWM_TRIPCFG_EN0B                (_ADI_MSK(0x00000100,uint32_t))  /* Enable TRIP0 as a trip source for Channel B */
#define ENUM_PWM_TRIPCFG_TRIP0B_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* EN0B: Disable TRIP0 for Channel B */
#define ENUM_PWM_TRIPCFG_TRIP0B_EN           (_ADI_MSK(0x00000100,uint32_t))  /* EN0B: Enable TRIP0 for Channel B */

#define BITM_PWM_TRIPCFG_MODE1A              (_ADI_MSK(0x00000008,uint32_t))  /* Mode of TRIP1 for Channel A */
#define ENUM_PWM_TRIPCFG_TRIP1A_FLT          (_ADI_MSK(0x00000000,uint32_t))  /* MODE1A: Fault Trip on TRIP1 Input */
#define ENUM_PWM_TRIPCFG_TRIP1A_RSTRT        (_ADI_MSK(0x00000008,uint32_t))  /* MODE1A: Self Restart on TRIP1 Input */

#define BITM_PWM_TRIPCFG_EN1A                (_ADI_MSK(0x00000004,uint32_t))  /* Enable TRIP1 as a trip source for Channel A */
#define ENUM_PWM_TRIPCFG_TRIP1A_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* EN1A: Disable TRIP1 for Channel A */
#define ENUM_PWM_TRIPCFG_TRIP1A_EN           (_ADI_MSK(0x00000004,uint32_t))  /* EN1A: Enable TRIP1 for Channel A */

#define BITM_PWM_TRIPCFG_MODE0A              (_ADI_MSK(0x00000002,uint32_t))  /* Mode of TRIP0 for Channel A */
#define ENUM_PWM_TRIPCFG_TRIP0A_FLT          (_ADI_MSK(0x00000000,uint32_t))  /* MODE0A: Fault Trip on TRIP0 Input */
#define ENUM_PWM_TRIPCFG_TRIP0A_RSTRT        (_ADI_MSK(0x00000002,uint32_t))  /* MODE0A: Self Restart on TRIP0 Input */

#define BITM_PWM_TRIPCFG_EN0A                (_ADI_MSK(0x00000001,uint32_t))  /* Enable TRIP0 as a trip source for Channel A */
#define ENUM_PWM_TRIPCFG_TRIP0A_DIS          (_ADI_MSK(0x00000000,uint32_t))  /* EN0A: Disable TRIP0 for Channel A */
#define ENUM_PWM_TRIPCFG_TRIP0A_EN           (_ADI_MSK(0x00000001,uint32_t))  /* EN0A: Enable TRIP0 for Channel A */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_STAT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_STAT_TMR4PHASE              28                               /* PWMTMR4 Phase Status */
#define BITP_PWM_STAT_TMR3PHASE              27                               /* PWMTMR3 Phase Status */
#define BITP_PWM_STAT_TMR2PHASE              26                               /* PWMTMR2 Phase Status */
#define BITP_PWM_STAT_TMR1PHASE              25                               /* PWMTMR1 Phase Status */
#define BITP_PWM_STAT_TMR0PHASE              24                               /* PWMTMR0 Phase Status */
#define BITP_PWM_STAT_TMR4PER                20                               /* PWMTMR4 Period Boundary Status */
#define BITP_PWM_STAT_TMR3PER                19                               /* PWMTMR3 Period Boundary Status */
#define BITP_PWM_STAT_TMR2PER                18                               /* PWMTMR2 Period Boundary Status */
#define BITP_PWM_STAT_TMR1PER                17                               /* PWMTMR1 Period Boundary Status */
#define BITP_PWM_STAT_TMR0PER                16                               /* PWMTMR0 Period Boundary Status */
#define BITP_PWM_STAT_SRTRIPD                11                               /* Self-Restart Trip Status for Channel D */
#define BITP_PWM_STAT_FLTTRIPD               10                               /* Fault Trip Status for Channel D */
#define BITP_PWM_STAT_SRTRIPC                 9                               /* Self-Restart Trip Status for Channel C */
#define BITP_PWM_STAT_FLTTRIPC                8                               /* Fault Trip Status for Channel C */
#define BITP_PWM_STAT_SRTRIPB                 7                               /* Self-Restart Trip Status for Channel B */
#define BITP_PWM_STAT_FLTTRIPB                6                               /* Fault Trip Status for Channel B */
#define BITP_PWM_STAT_SRTRIPA                 5                               /* Self-Restart Trip Status for Channel A */
#define BITP_PWM_STAT_FLTTRIPA                4                               /* Fault Trip Status for Channel A */
#define BITP_PWM_STAT_RAWTRIP1                3                               /* Raw Trip 1 Status */
#define BITP_PWM_STAT_RAWTRIP0                2                               /* Raw Trip 0 Status */
#define BITP_PWM_STAT_TRIP1                   1                               /* Status bit set when TRIP1 is active low */
#define BITP_PWM_STAT_TRIP0                   0                               /* Status bit set when TRIP0 is active low */

#define BITM_PWM_STAT_TMR4PHASE              (_ADI_MSK(0x10000000,uint32_t))  /* PWMTMR4 Phase Status */
#define ENUM_PWM_STAT_TMR4PH1                (_ADI_MSK(0x00000000,uint32_t))  /* TMR4PHASE: 1st Half Phase */
#define ENUM_PWM_STAT_TMR4PH2                (_ADI_MSK(0x10000000,uint32_t))  /* TMR4PHASE: 2nd Half Phase */

#define BITM_PWM_STAT_TMR3PHASE              (_ADI_MSK(0x08000000,uint32_t))  /* PWMTMR3 Phase Status */
#define ENUM_PWM_STAT_TMR3PH1                (_ADI_MSK(0x00000000,uint32_t))  /* TMR3PHASE: 1st Half Phase */
#define ENUM_PWM_STAT_TMR3PH2                (_ADI_MSK(0x08000000,uint32_t))  /* TMR3PHASE: 2nd Half Phase */

#define BITM_PWM_STAT_TMR2PHASE              (_ADI_MSK(0x04000000,uint32_t))  /* PWMTMR2 Phase Status */
#define ENUM_PWM_STAT_TMR2PH1                (_ADI_MSK(0x00000000,uint32_t))  /* TMR2PHASE: 1st Half Phase */
#define ENUM_PWM_STAT_TMR2PH2                (_ADI_MSK(0x04000000,uint32_t))  /* TMR2PHASE: 2nd Half Phase */

#define BITM_PWM_STAT_TMR1PHASE              (_ADI_MSK(0x02000000,uint32_t))  /* PWMTMR1 Phase Status */
#define ENUM_PWM_STAT_TMR1PH1                (_ADI_MSK(0x00000000,uint32_t))  /* TMR1PHASE: 1st Half Phase */
#define ENUM_PWM_STAT_TMR1PH2                (_ADI_MSK(0x02000000,uint32_t))  /* TMR1PHASE: 2nd Half Phase */

#define BITM_PWM_STAT_TMR0PHASE              (_ADI_MSK(0x01000000,uint32_t))  /* PWMTMR0 Phase Status */
#define ENUM_PWM_STAT_TMR0PH1                (_ADI_MSK(0x00000000,uint32_t))  /* TMR0PHASE: 1st Half Phase */
#define ENUM_PWM_STAT_TMR0PH2                (_ADI_MSK(0x01000000,uint32_t))  /* TMR0PHASE: 2nd Half Phase */

#define BITM_PWM_STAT_TMR4PER                (_ADI_MSK(0x00100000,uint32_t))  /* PWMTMR4 Period Boundary Status */
#define ENUM_PWM_STAT_NOT_PER4               (_ADI_MSK(0x00000000,uint32_t))  /* TMR4PER: PWMTMR4 period boundary not reached */
#define ENUM_PWM_STAT_PER4                   (_ADI_MSK(0x00100000,uint32_t))  /* TMR4PER: PWMTMR4 period boundary reached */

#define BITM_PWM_STAT_TMR3PER                (_ADI_MSK(0x00080000,uint32_t))  /* PWMTMR3 Period Boundary Status */
#define ENUM_PWM_STAT_NOT_PER3               (_ADI_MSK(0x00000000,uint32_t))  /* TMR3PER: PWMTMR3 period boundary not reached */
#define ENUM_PWM_STAT_PER3                   (_ADI_MSK(0x00080000,uint32_t))  /* TMR3PER: PWMTMR3 period boundary reached */

#define BITM_PWM_STAT_TMR2PER                (_ADI_MSK(0x00040000,uint32_t))  /* PWMTMR2 Period Boundary Status */
#define ENUM_PWM_STAT_NOT_PER2               (_ADI_MSK(0x00000000,uint32_t))  /* TMR2PER: PWMTMR2 period boundary not reached */
#define ENUM_PWM_STAT_PER2                   (_ADI_MSK(0x00040000,uint32_t))  /* TMR2PER: PWMTMR2 period boundary reached */

#define BITM_PWM_STAT_TMR1PER                (_ADI_MSK(0x00020000,uint32_t))  /* PWMTMR1 Period Boundary Status */
#define ENUM_PWM_STAT_NOT_PER1               (_ADI_MSK(0x00000000,uint32_t))  /* TMR1PER: PWMTMR1 period boundary not reached */
#define ENUM_PWM_STAT_PER1                   (_ADI_MSK(0x00020000,uint32_t))  /* TMR1PER: PWMTMR1 period boundary reached */

#define BITM_PWM_STAT_TMR0PER                (_ADI_MSK(0x00010000,uint32_t))  /* PWMTMR0 Period Boundary Status */
#define ENUM_PWM_STAT_NOT_PER0               (_ADI_MSK(0x00000000,uint32_t))  /* TMR0PER: PWMTMR0 period boundary not reached */
#define ENUM_PWM_STAT_PER0                   (_ADI_MSK(0x00010000,uint32_t))  /* TMR0PER: PWMTMR0 period boundary reached */

#define BITM_PWM_STAT_SRTRIPD                (_ADI_MSK(0x00000800,uint32_t))  /* Self-Restart Trip Status for Channel D */
#define ENUM_PWM_STAT_SRD_NOTRIP             (_ADI_MSK(0x00000000,uint32_t))  /* SRTRIPD: Channel D Self-Restart Trip Status is "not tripped" */
#define ENUM_PWM_STAT_SRD_TRIP               (_ADI_MSK(0x00000800,uint32_t))  /* SRTRIPD: Channel D Self-Restart Trip Status is "tripped" */

#define BITM_PWM_STAT_FLTTRIPD               (_ADI_MSK(0x00000400,uint32_t))  /* Fault Trip Status for Channel D */
#define ENUM_PWM_STAT_FLTD_NOTRIP            (_ADI_MSK(0x00000000,uint32_t))  /* FLTTRIPD: Channel D Fault Trip Status is "not tripped" */
#define ENUM_PWM_STAT_FLTD_TRIP              (_ADI_MSK(0x00000400,uint32_t))  /* FLTTRIPD: Channel D Fault Trip Status is "tripped" */

#define BITM_PWM_STAT_SRTRIPC                (_ADI_MSK(0x00000200,uint32_t))  /* Self-Restart Trip Status for Channel C */
#define ENUM_PWM_STAT_SRC_NOTRIP             (_ADI_MSK(0x00000000,uint32_t))  /* SRTRIPC: Channel C Self-Restart Trip Status is "not tripped" */
#define ENUM_PWM_STAT_SRC_TRIP               (_ADI_MSK(0x00000200,uint32_t))  /* SRTRIPC: Channel C Self-Restart Trip Status is "tripped" */

#define BITM_PWM_STAT_FLTTRIPC               (_ADI_MSK(0x00000100,uint32_t))  /* Fault Trip Status for Channel C */
#define ENUM_PWM_STAT_FLTC_NOTRIP            (_ADI_MSK(0x00000000,uint32_t))  /* FLTTRIPC: Channel C Fault Trip Status is "not tripped" */
#define ENUM_PWM_STAT_FLTC_TRIP              (_ADI_MSK(0x00000100,uint32_t))  /* FLTTRIPC: Channel C Fault Trip Status is "tripped" */

#define BITM_PWM_STAT_SRTRIPB                (_ADI_MSK(0x00000080,uint32_t))  /* Self-Restart Trip Status for Channel B */
#define ENUM_PWM_STAT_SRB_NOTRIP             (_ADI_MSK(0x00000000,uint32_t))  /* SRTRIPB: Channel B Self-Restart Trip Status is "not tripped" */
#define ENUM_PWM_STAT_SRB_TRIP               (_ADI_MSK(0x00000080,uint32_t))  /* SRTRIPB: Channel B Self-Restart Trip Status is "tripped" */

#define BITM_PWM_STAT_FLTTRIPB               (_ADI_MSK(0x00000040,uint32_t))  /* Fault Trip Status for Channel B */
#define ENUM_PWM_STAT_FLTB_NOTRIP            (_ADI_MSK(0x00000000,uint32_t))  /* FLTTRIPB: Channel B Fault Trip Status is "not tripped" */
#define ENUM_PWM_STAT_FLTB_TRIP              (_ADI_MSK(0x00000040,uint32_t))  /* FLTTRIPB: Channel A Fault Trip Status is "tripped" */

#define BITM_PWM_STAT_SRTRIPA                (_ADI_MSK(0x00000020,uint32_t))  /* Self-Restart Trip Status for Channel A */
#define ENUM_PWM_STAT_SRA_NOTRIP             (_ADI_MSK(0x00000000,uint32_t))  /* SRTRIPA: Channel A Self-Restart Trip Status is "not tripped" */
#define ENUM_PWM_STAT_SRA_TRIP               (_ADI_MSK(0x00000020,uint32_t))  /* SRTRIPA: Channel A Self-Restart Trip Status is "tripped" */

#define BITM_PWM_STAT_FLTTRIPA               (_ADI_MSK(0x00000010,uint32_t))  /* Fault Trip Status for Channel A */
#define ENUM_PWM_STAT_FLTA_NOTRIP            (_ADI_MSK(0x00000000,uint32_t))  /* FLTTRIPA: Channel A Fault Trip Status is "not tripped" */
#define ENUM_PWM_STAT_FLTA_TRIP              (_ADI_MSK(0x00000010,uint32_t))  /* FLTTRIPA: Channel A Fault Trip Status is "tripped" */

#define BITM_PWM_STAT_RAWTRIP1               (_ADI_MSK(0x00000008,uint32_t))  /* Raw Trip 1 Status */
#define ENUM_PWM_STAT_TRIP1LVL_LO            (_ADI_MSK(0x00000000,uint32_t))  /* RAWTRIP1: TRIP1 Level is Low */
#define ENUM_PWM_STAT_TRIP1LVL_HI            (_ADI_MSK(0x00000008,uint32_t))  /* RAWTRIP1: TRIP1 Level is High */

#define BITM_PWM_STAT_RAWTRIP0               (_ADI_MSK(0x00000004,uint32_t))  /* Raw Trip 0 Status */
#define ENUM_PWM_STAT_TRIP0LVL_LO            (_ADI_MSK(0x00000000,uint32_t))  /* RAWTRIP0: TRIP0 Level is Low */
#define ENUM_PWM_STAT_TRIP0LVL_HI            (_ADI_MSK(0x00000004,uint32_t))  /* RAWTRIP0: TRIP0 Level is High */

#define BITM_PWM_STAT_TRIP1                  (_ADI_MSK(0x00000002,uint32_t))  /* Status bit set when TRIP1 is active low */
#define ENUM_PWM_STAT_NO_TRIP1               (_ADI_MSK(0x00000000,uint32_t))  /* TRIP1: TRIP1 status is "not tripped" */
#define ENUM_PWM_STAT_TRIP1                  (_ADI_MSK(0x00000002,uint32_t))  /* TRIP1: TRIP1 status is "tripped" (active low) */

#define BITM_PWM_STAT_TRIP0                  (_ADI_MSK(0x00000001,uint32_t))  /* Status bit set when TRIP0 is active low */
#define ENUM_PWM_STAT_NO_TRIP0               (_ADI_MSK(0x00000000,uint32_t))  /* TRIP0: TRIP0 status is "not tripped" */
#define ENUM_PWM_STAT_TRIP0                  (_ADI_MSK(0x00000001,uint32_t))  /* TRIP0: TRIP0 status is "tripped" (active low) */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_IMSK                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_IMSK_TMR4PER                20                               /* PWMTMR4 Period Boundary Interrupt Enable */
#define BITP_PWM_IMSK_TMR3PER                19                               /* PWMTMR3 Period Boundary Interrupt Enable */
#define BITP_PWM_IMSK_TMR2PER                18                               /* PWMTMR2 Period Boundary Interrupt Enable */
#define BITP_PWM_IMSK_TMR1PER                17                               /* PWMTMR1 Period Boundary Interrupt Enable */
#define BITP_PWM_IMSK_TMR0PER                16                               /* PWMTMR0 Period Boundary Interrupt Enable */
#define BITP_PWM_IMSK_TRIP1                   1                               /* TRIP1 Interrupt Enable */
#define BITP_PWM_IMSK_TRIP0                   0                               /* TRIP0 Interrupt Enable */

#define BITM_PWM_IMSK_TMR4PER                (_ADI_MSK(0x00100000,uint32_t))  /* PWMTMR4 Period Boundary Interrupt Enable */
#define ENUM_PWM_IMSK_PER4_MSK               (_ADI_MSK(0x00000000,uint32_t))  /* TMR4PER: Mask PWMTMR4 Period Interrupt */
#define ENUM_PWM_IMSK_PER4_UMSK              (_ADI_MSK(0x00100000,uint32_t))  /* TMR4PER: Unmask PWMTMR4 Period Interrupt */

#define BITM_PWM_IMSK_TMR3PER                (_ADI_MSK(0x00080000,uint32_t))  /* PWMTMR3 Period Boundary Interrupt Enable */
#define ENUM_PWM_IMSK_PER3_MSK               (_ADI_MSK(0x00000000,uint32_t))  /* TMR3PER: Mask PWMTMR3 Period Interrupt */
#define ENUM_PWM_IMSK_PER3_UMSK              (_ADI_MSK(0x00080000,uint32_t))  /* TMR3PER: Unmask PWMTMR3 Period Interrupt */

#define BITM_PWM_IMSK_TMR2PER                (_ADI_MSK(0x00040000,uint32_t))  /* PWMTMR2 Period Boundary Interrupt Enable */
#define ENUM_PWM_IMSK_PER2_MSK               (_ADI_MSK(0x00000000,uint32_t))  /* TMR2PER: Mask PWMTMR2 Period Interrupt */
#define ENUM_PWM_IMSK_PER2_UMSK              (_ADI_MSK(0x00040000,uint32_t))  /* TMR2PER: Unmask PWMTMR2 Period Interrupt */

#define BITM_PWM_IMSK_TMR1PER                (_ADI_MSK(0x00020000,uint32_t))  /* PWMTMR1 Period Boundary Interrupt Enable */
#define ENUM_PWM_IMSK_PER1_MSK               (_ADI_MSK(0x00000000,uint32_t))  /* TMR1PER: Mask PWMTMR1 Period Interrupt */
#define ENUM_PWM_IMSK_PER1_UMSK              (_ADI_MSK(0x00020000,uint32_t))  /* TMR1PER: Unmask PWMTMR1 Period Interrupt */

#define BITM_PWM_IMSK_TMR0PER                (_ADI_MSK(0x00010000,uint32_t))  /* PWMTMR0 Period Boundary Interrupt Enable */
#define ENUM_PWM_IMSK_PER0_MSK               (_ADI_MSK(0x00000000,uint32_t))  /* TMR0PER: Mask PWMTMR0 Period Interrupt */
#define ENUM_PWM_IMSK_PER0_UMSK              (_ADI_MSK(0x00010000,uint32_t))  /* TMR0PER: Unmask PWMTMR0 Period Interrupt */

#define BITM_PWM_IMSK_TRIP1                  (_ADI_MSK(0x00000002,uint32_t))  /* TRIP1 Interrupt Enable */
#define ENUM_PWM_IMSK_TRIP1_MSK              (_ADI_MSK(0x00000000,uint32_t))  /* TRIP1: Mask TRIP1 Interrupt */
#define ENUM_PWM_IMSK_TRIP1_UMSK             (_ADI_MSK(0x00000002,uint32_t))  /* TRIP1: Unmask TRIP1 Interrupt */

#define BITM_PWM_IMSK_TRIP0                  (_ADI_MSK(0x00000001,uint32_t))  /* TRIP0 Interrupt Enable */
#define ENUM_PWM_IMSK_TRIP0_MSK              (_ADI_MSK(0x00000000,uint32_t))  /* TRIP0: Mask TRIP0 Interrupt */
#define ENUM_PWM_IMSK_TRIP0_UMSK             (_ADI_MSK(0x00000001,uint32_t))  /* TRIP0: Unmask TRIP0 Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_ILAT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_ILAT_TMR4PER                20                               /* PWMTMR4 Period Latched Interrupt Status */
#define BITP_PWM_ILAT_TMR3PER                19                               /* PWMTMR3 Period Latched Interrupt Status */
#define BITP_PWM_ILAT_TMR2PER                18                               /* PWMTMR2 Period Latched Interrupt Status */
#define BITP_PWM_ILAT_TMR1PER                17                               /* PWMTMR1 Period Latched Interrupt Status */
#define BITP_PWM_ILAT_TMR0PER                16                               /* PWMTMR0 Period Boundary Interrupt Latched Status */
#define BITP_PWM_ILAT_TRIP1                   1                               /* TRIP1 Interrupt Latched Status */
#define BITP_PWM_ILAT_TRIP0                   0                               /* TRIP0 Interrupt Latched Status */

#define BITM_PWM_ILAT_TMR4PER                (_ADI_MSK(0x00100000,uint32_t))  /* PWMTMR4 Period Latched Interrupt Status */
#define ENUM_PWM_ILAT_PER4_INTLO             (_ADI_MSK(0x00000000,uint32_t))  /* TMR4PER: No Interrupt Latched */
#define ENUM_PWM_ILAT_PER4_INTHI             (_ADI_MSK(0x00100000,uint32_t))  /* TMR4PER: Interrupt Latched */

#define BITM_PWM_ILAT_TMR3PER                (_ADI_MSK(0x00080000,uint32_t))  /* PWMTMR3 Period Latched Interrupt Status */
#define ENUM_PWM_ILAT_PER3_INTLO             (_ADI_MSK(0x00000000,uint32_t))  /* TMR3PER: No Interrupt Latched */
#define ENUM_PWM_ILAT_PER3_INTHI             (_ADI_MSK(0x00080000,uint32_t))  /* TMR3PER: Interrupt Latched */

#define BITM_PWM_ILAT_TMR2PER                (_ADI_MSK(0x00040000,uint32_t))  /* PWMTMR2 Period Latched Interrupt Status */
#define ENUM_PWM_ILAT_PER2_INTLO             (_ADI_MSK(0x00000000,uint32_t))  /* TMR2PER: No Interrupt Latched */
#define ENUM_PWM_ILAT_PER2_INTHI             (_ADI_MSK(0x00040000,uint32_t))  /* TMR2PER: Interrupt Latched */

#define BITM_PWM_ILAT_TMR1PER                (_ADI_MSK(0x00020000,uint32_t))  /* PWMTMR1 Period Latched Interrupt Status */
#define ENUM_PWM_ILAT_PER1_INTLO             (_ADI_MSK(0x00000000,uint32_t))  /* TMR1PER: No Interrupt Latched */
#define ENUM_PWM_ILAT_PER1_INTHI             (_ADI_MSK(0x00020000,uint32_t))  /* TMR1PER: Interrupt Latched */

#define BITM_PWM_ILAT_TMR0PER                (_ADI_MSK(0x00010000,uint32_t))  /* PWMTMR0 Period Boundary Interrupt Latched Status */
#define ENUM_PWM_ILAT_PER0_INTLO             (_ADI_MSK(0x00000000,uint32_t))  /* TMR0PER: No Interrupt Latched */
#define ENUM_PWM_ILAT_PER0_INTHI             (_ADI_MSK(0x00010000,uint32_t))  /* TMR0PER: Interrupt Latched */

#define BITM_PWM_ILAT_TRIP1                  (_ADI_MSK(0x00000002,uint32_t))  /* TRIP1 Interrupt Latched Status */
#define ENUM_PWM_ILAT_TRIP1_INTLO            (_ADI_MSK(0x00000000,uint32_t))  /* TRIP1: No Interrupt Latched */
#define ENUM_PWM_ILAT_TRIP1_INTHI            (_ADI_MSK(0x00000002,uint32_t))  /* TRIP1: Interrupt Latched */

#define BITM_PWM_ILAT_TRIP0                  (_ADI_MSK(0x00000001,uint32_t))  /* TRIP0 Interrupt Latched Status */
#define ENUM_PWM_ILAT_TRIP0_INTLO            (_ADI_MSK(0x00000000,uint32_t))  /* TRIP0: No Interrupt Latched */
#define ENUM_PWM_ILAT_TRIP0_INTHI            (_ADI_MSK(0x00000001,uint32_t))  /* TRIP0: Interrupt Latched */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_CHOPCFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_CHOPCFG_VALUE                0                               /* Gate Chopping Divisor */
#define BITM_PWM_CHOPCFG_VALUE               (_ADI_MSK(0x000000FF,uint32_t))  /* Gate Chopping Divisor */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DT                               Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DT_VALUE                     0                               /* Dead Time */
#define BITM_PWM_DT_VALUE                    (_ADI_MSK(0x000003FF,uint32_t))  /* Dead Time */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_SYNC_WID                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_SYNC_WID_VALUE               0                               /* Sync Pulse Width */
#define BITM_PWM_SYNC_WID_VALUE              (_ADI_MSK(0x000003FF,uint32_t))  /* Sync Pulse Width */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_TM0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_TM0_VALUE                    0                               /* Timer PWMTMR0 Period Value */
#define BITM_PWM_TM0_VALUE                   (_ADI_MSK(0x0000FFFF,uint32_t))  /* Timer PWMTMR0 Period Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_TM1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_TM1_VALUE                    0                               /* Timer PWMTMR1 Period Value */
#define BITM_PWM_TM1_VALUE                   (_ADI_MSK(0x0000FFFF,uint32_t))  /* Timer PWMTMR1 Period Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_TM2                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_TM2_VALUE                    0                               /* Timer PWMTMR2 Period Value */
#define BITM_PWM_TM2_VALUE                   (_ADI_MSK(0x0000FFFF,uint32_t))  /* Timer PWMTMR2 Period Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_TM3                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_TM3_VALUE                    0                               /* Timer PWMTMR3 Period Value */
#define BITM_PWM_TM3_VALUE                   (_ADI_MSK(0x0000FFFF,uint32_t))  /* Timer PWMTMR3 Period Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_TM4                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_TM4_VALUE                    0                               /* Timer PWMTMR4 Period Value */
#define BITM_PWM_TM4_VALUE                   (_ADI_MSK(0x0000FFFF,uint32_t))  /* Timer PWMTMR4 Period Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DLYA                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DLYA_VALUE                   0                               /* Channel A Delay Value */
#define BITM_PWM_DLYA_VALUE                  (_ADI_MSK(0x0000FFFF,uint32_t))  /* Channel A Delay Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DLYB                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DLYB_VALUE                   0                               /* Channel B Delay Value */
#define BITM_PWM_DLYB_VALUE                  (_ADI_MSK(0x0000FFFF,uint32_t))  /* Channel B Delay Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DLYC                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DLYC_VALUE                   0                               /* Channel C Delay Value */
#define BITM_PWM_DLYC_VALUE                  (_ADI_MSK(0x0000FFFF,uint32_t))  /* Channel C Delay Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DLYD                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DLYD_VALUE                   0                               /* Channel D Delay Value */
#define BITM_PWM_DLYD_VALUE                  (_ADI_MSK(0x0000FFFF,uint32_t))  /* Channel D Delay Value */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_ACTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_ACTL_PULSEMODELO            10                               /* Low Side Output Pulse Position */
#define BITP_PWM_ACTL_PULSEMODEHI             8                               /* High Side Output Pulse Position */
#define BITP_PWM_ACTL_XOVR                    2                               /* high-low Crossover Enable */
#define BITP_PWM_ACTL_DISLO                   1                               /* Channel Low Side Output Disable */
#define BITP_PWM_ACTL_DISHI                   0                               /* Channel High Side Output Disable */

#define BITM_PWM_ACTL_PULSEMODELO            (_ADI_MSK(0x00000C00,uint32_t))  /* Low Side Output Pulse Position */
#define ENUM_PWM_SYM_LO                      (_ADI_MSK(0x00000000,uint32_t))  /* PULSEMODELO: Symmetrical */
#define ENUM_PWM_ASYM_LO                     (_ADI_MSK(0x00000400,uint32_t))  /* PULSEMODELO: Asymmetrical */
#define ENUM_PWM_LEFT_LO                     (_ADI_MSK(0x00000800,uint32_t))  /* PULSEMODELO: Left Half */
#define ENUM_PWM_RIGHT_LO                    (_ADI_MSK(0x00000C00,uint32_t))  /* PULSEMODELO: Right Half */

#define BITM_PWM_ACTL_PULSEMODEHI            (_ADI_MSK(0x00000300,uint32_t))  /* High Side Output Pulse Position */
#define ENUM_PWM_SYM_HI                      (_ADI_MSK(0x00000000,uint32_t))  /* PULSEMODEHI: Symmetrical */
#define ENUM_PWM_ASYM_HI                     (_ADI_MSK(0x00000100,uint32_t))  /* PULSEMODEHI: Asymmetrical */
#define ENUM_PWM_LEFT_HI                     (_ADI_MSK(0x00000200,uint32_t))  /* PULSEMODEHI: Left Half */
#define ENUM_PWM_RIGHT_HI                    (_ADI_MSK(0x00000300,uint32_t))  /* PULSEMODEHI: Right Half */

#define BITM_PWM_ACTL_XOVR                   (_ADI_MSK(0x00000004,uint32_t))  /* high-low Crossover Enable */
#define ENUM_PWM_XOVR_DIS                    (_ADI_MSK(0x00000000,uint32_t))  /* XOVR: Disable Crossover */
#define ENUM_PWM_XOVR_EN                     (_ADI_MSK(0x00000004,uint32_t))  /* XOVR: Enable Crossover */

#define BITM_PWM_ACTL_DISLO                  (_ADI_MSK(0x00000002,uint32_t))  /* Channel Low Side Output Disable */
#define ENUM_PWM_LO_DIS                      (_ADI_MSK(0x00000000,uint32_t))  /* DISLO: Disable Low Side Output */
#define ENUM_PWM_LO_EN                       (_ADI_MSK(0x00000002,uint32_t))  /* DISLO: Enable Low Side Output */

#define BITM_PWM_ACTL_DISHI                  (_ADI_MSK(0x00000001,uint32_t))  /* Channel High Side Output Disable */
#define ENUM_PWM_HI_DIS                      (_ADI_MSK(0x00000000,uint32_t))  /* DISHI: Disable High Side Output */
#define ENUM_PWM_HI_EN                       (_ADI_MSK(0x00000001,uint32_t))  /* DISHI: Enable High Side Output */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_AH0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_AH0_DUTY                     0                               /* Duty Cycle Asserted Count */
#define BITM_PWM_AH0_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_AH1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_AH1_DUTY                     0                               /* Duty Cycle De-Asserted Count */
#define BITM_PWM_AH1_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle De-Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_AL0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_AL0_DUTY                     0                               /* Duty Cycle Asserted Count */
#define BITM_PWM_AL0_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_AL1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_AL1_DUTY                     0                               /* Duty Cycle De-Asserted Count */
#define BITM_PWM_AL1_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle De-Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_BCTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_BCTL_PULSEMODELO            10                               /* Low Side Output Pulse Position */
#define BITP_PWM_BCTL_PULSEMODEHI             8                               /* High Side Output Pulse Position */
#define BITP_PWM_BCTL_XOVR                    2                               /* high-low Crossover Enable */
#define BITP_PWM_BCTL_DISLO                   1                               /* Channel Low Side Output Disable */
#define BITP_PWM_BCTL_DISHI                   0                               /* Channel High Side Output Disable */

/* The fields and enumerations for PWM_BCTL are also in PWM - see the common set of ENUM_PWM_* #defines located with register PWM_ACTL */

#define BITM_PWM_BCTL_PULSEMODELO            (_ADI_MSK(0x00000C00,uint32_t))  /* Low Side Output Pulse Position */
#define BITM_PWM_BCTL_PULSEMODEHI            (_ADI_MSK(0x00000300,uint32_t))  /* High Side Output Pulse Position */
#define BITM_PWM_BCTL_XOVR                   (_ADI_MSK(0x00000004,uint32_t))  /* high-low Crossover Enable */
#define BITM_PWM_BCTL_DISLO                  (_ADI_MSK(0x00000002,uint32_t))  /* Channel Low Side Output Disable */
#define BITM_PWM_BCTL_DISHI                  (_ADI_MSK(0x00000001,uint32_t))  /* Channel High Side Output Disable */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_BH0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_BH0_DUTY                     0                               /* Duty Cycle Asserted Count */
#define BITM_PWM_BH0_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_BH1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_BH1_DUTY                     0                               /* Duty Cycle De-Asserted Count */
#define BITM_PWM_BH1_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle De-Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_BL0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_BL0_DUTY                     0                               /* Duty Cycle Asserted Count */
#define BITM_PWM_BL0_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_BL1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_BL1_DUTY                     0                               /* Duty Cycle De-Asserted Count */
#define BITM_PWM_BL1_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle De-Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_CCTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_CCTL_PULSEMODELO            10                               /* Low Side Output Pulse Position */
#define BITP_PWM_CCTL_PULSEMODEHI             8                               /* High Side Output Pulse Position */
#define BITP_PWM_CCTL_XOVR                    2                               /* high-low Crossover Enable */
#define BITP_PWM_CCTL_DISLO                   1                               /* Channel Low Side Output Disable */
#define BITP_PWM_CCTL_DISHI                   0                               /* Channel High Side Output Disable */

/* The fields and enumerations for PWM_CCTL are also in PWM - see the common set of ENUM_PWM_* #defines located with register PWM_ACTL */

#define BITM_PWM_CCTL_PULSEMODELO            (_ADI_MSK(0x00000C00,uint32_t))  /* Low Side Output Pulse Position */
#define BITM_PWM_CCTL_PULSEMODEHI            (_ADI_MSK(0x00000300,uint32_t))  /* High Side Output Pulse Position */
#define BITM_PWM_CCTL_XOVR                   (_ADI_MSK(0x00000004,uint32_t))  /* high-low Crossover Enable */
#define BITM_PWM_CCTL_DISLO                  (_ADI_MSK(0x00000002,uint32_t))  /* Channel Low Side Output Disable */
#define BITM_PWM_CCTL_DISHI                  (_ADI_MSK(0x00000001,uint32_t))  /* Channel High Side Output Disable */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_CH0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_CH0_DUTY                     0                               /* Duty Cycle Asserted Count */
#define BITM_PWM_CH0_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_CH1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_CH1_DUTY                     0                               /* Duty Cycle De-Asserted Count */
#define BITM_PWM_CH1_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle De-Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_CL0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_CL0_DUTY                     0                               /* Duty Cycle Asserted Count */
#define BITM_PWM_CL0_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_CL1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_CL1_DUTY                     0                               /* Duty Cycle De-Asserted Count */
#define BITM_PWM_CL1_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle De-Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DCTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DCTL_PULSEMODELO            10                               /* Low Side Output Pulse Position */
#define BITP_PWM_DCTL_PULSEMODEHI             8                               /* High Side Output Pulse Position */
#define BITP_PWM_DCTL_XOVR                    2                               /* high-low Crossover Enable */
#define BITP_PWM_DCTL_DISLO                   1                               /* Channel Low Side Output Disable */
#define BITP_PWM_DCTL_DISHI                   0                               /* Channel High Side Output Disable */

/* The fields and enumerations for PWM_DCTL are also in PWM - see the common set of ENUM_PWM_* #defines located with register PWM_ACTL */

#define BITM_PWM_DCTL_PULSEMODELO            (_ADI_MSK(0x00000C00,uint32_t))  /* Low Side Output Pulse Position */
#define BITM_PWM_DCTL_PULSEMODEHI            (_ADI_MSK(0x00000300,uint32_t))  /* High Side Output Pulse Position */
#define BITM_PWM_DCTL_XOVR                   (_ADI_MSK(0x00000004,uint32_t))  /* high-low Crossover Enable */
#define BITM_PWM_DCTL_DISLO                  (_ADI_MSK(0x00000002,uint32_t))  /* Channel Low Side Output Disable */
#define BITM_PWM_DCTL_DISHI                  (_ADI_MSK(0x00000001,uint32_t))  /* Channel High Side Output Disable */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DH0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DH0_DUTY                     0                               /* Duty Cycle Asserted Count */
#define BITM_PWM_DH0_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DH1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DH1_DUTY                     0                               /* Duty Cycle De-Asserted Count */
#define BITM_PWM_DH1_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle De-Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DL0                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DL0_DUTY                     0                               /* Duty Cycle Asserted Count */
#define BITM_PWM_DL0_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle Asserted Count */

/* ------------------------------------------------------------------------------------------------------------------------
        PWM_DL1                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_PWM_DL1_DUTY                     0                               /* Duty Cycle De-Asserted Count */
#define BITM_PWM_DL1_DUTY                    (_ADI_MSK(0x0000FFFF,uint32_t))  /* Duty Cycle De-Asserted Count */

/* ==================================================
        Video Subsystem Registers Registers
   ================================================== */

/* =========================
        VID0
   ========================= */
#define REG_VID0_CONN                   0xFFC1D000         /* VID0 Video Subsystem Connect Register */

/* =========================
        VID
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        VID_CONN                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_VID_CONN_PPI2BCAST              23                               /* PPI_2 Broadcast Mode */
#define BITP_VID_CONN_PPI1BCAST              22                               /* PPI_1 Broadcast Mode */
#define BITP_VID_CONN_PPI0BCAST              21                               /* PPI_0 Broadcast Mode */
#define BITP_VID_CONN_PPI2TX                 16                               /* PPI_2_TX Connectivity */
#define BITP_VID_CONN_PPI1TX                 12                               /* PPI_1_TX Connectivity */
#define BITP_VID_CONN_PPI0TX                  8                               /* PPI_0_TX Connectivity */
#define BITP_VID_CONN_PVP0IN                  4                               /* PVP_IN Connectivity */
#define BITP_VID_CONN_PIXC0IN                 0                               /* PIXC_IN Connectivity */
#define BITM_VID_CONN_PPI2BCAST              (_ADI_MSK(0x00800000,uint32_t))  /* PPI_2 Broadcast Mode */
#define BITM_VID_CONN_PPI1BCAST              (_ADI_MSK(0x00400000,uint32_t))  /* PPI_1 Broadcast Mode */
#define BITM_VID_CONN_PPI0BCAST              (_ADI_MSK(0x00200000,uint32_t))  /* PPI_0 Broadcast Mode */
#define BITM_VID_CONN_PPI2TX                 (_ADI_MSK(0x000F0000,uint32_t))  /* PPI_2_TX Connectivity */
#define BITM_VID_CONN_PPI1TX                 (_ADI_MSK(0x0000F000,uint32_t))  /* PPI_1_TX Connectivity */
#define BITM_VID_CONN_PPI0TX                 (_ADI_MSK(0x00000F00,uint32_t))  /* PPI_0_TX Connectivity */
#define BITM_VID_CONN_PVP0IN                 (_ADI_MSK(0x000000F0,uint32_t))  /* PVP_IN Connectivity */
#define BITM_VID_CONN_PIXC0IN                (_ADI_MSK(0x0000000F,uint32_t))  /* PIXC_IN Connectivity */

/* ==================================================
        System Watchpoint Unit Registers
   ================================================== */

/* =========================
        SWU0
   ========================= */
#define REG_SWU0_GCTL                   0xFFC1E000         /* SWU0 Global Control Register */
#define REG_SWU0_GSTAT                  0xFFC1E004         /* SWU0 Global Status Register */
#define REG_SWU0_CTL0                   0xFFC1E010         /* SWU0 Control Register n */
#define REG_SWU0_CTL1                   0xFFC1E030         /* SWU0 Control Register n */
#define REG_SWU0_CTL2                   0xFFC1E050         /* SWU0 Control Register n */
#define REG_SWU0_CTL3                   0xFFC1E070         /* SWU0 Control Register n */
#define REG_SWU0_LA0                    0xFFC1E014         /* SWU0 Lower Address Register n */
#define REG_SWU0_LA1                    0xFFC1E034         /* SWU0 Lower Address Register n */
#define REG_SWU0_LA2                    0xFFC1E054         /* SWU0 Lower Address Register n */
#define REG_SWU0_LA3                    0xFFC1E074         /* SWU0 Lower Address Register n */
#define REG_SWU0_UA0                    0xFFC1E018         /* SWU0 Upper Address Register n */
#define REG_SWU0_UA1                    0xFFC1E038         /* SWU0 Upper Address Register n */
#define REG_SWU0_UA2                    0xFFC1E058         /* SWU0 Upper Address Register n */
#define REG_SWU0_UA3                    0xFFC1E078         /* SWU0 Upper Address Register n */
#define REG_SWU0_ID0                    0xFFC1E01C         /* SWU0 ID Register n */
#define REG_SWU0_ID1                    0xFFC1E03C         /* SWU0 ID Register n */
#define REG_SWU0_ID2                    0xFFC1E05C         /* SWU0 ID Register n */
#define REG_SWU0_ID3                    0xFFC1E07C         /* SWU0 ID Register n */
#define REG_SWU0_CNT0                   0xFFC1E020         /* SWU0 Count Register n */
#define REG_SWU0_CNT1                   0xFFC1E040         /* SWU0 Count Register n */
#define REG_SWU0_CNT2                   0xFFC1E060         /* SWU0 Count Register n */
#define REG_SWU0_CNT3                   0xFFC1E080         /* SWU0 Count Register n */
#define REG_SWU0_TARG0                  0xFFC1E024         /* SWU0 Target Register n */
#define REG_SWU0_TARG1                  0xFFC1E044         /* SWU0 Target Register n */
#define REG_SWU0_TARG2                  0xFFC1E064         /* SWU0 Target Register n */
#define REG_SWU0_TARG3                  0xFFC1E084         /* SWU0 Target Register n */
#define REG_SWU0_HIST0                  0xFFC1E028         /* SWU0 Bandwidth History Register n */
#define REG_SWU0_HIST1                  0xFFC1E048         /* SWU0 Bandwidth History Register n */
#define REG_SWU0_HIST2                  0xFFC1E068         /* SWU0 Bandwidth History Register n */
#define REG_SWU0_HIST3                  0xFFC1E088         /* SWU0 Bandwidth History Register n */
#define REG_SWU0_CUR0                   0xFFC1E02C         /* SWU0 Current Register n */
#define REG_SWU0_CUR1                   0xFFC1E04C         /* SWU0 Current Register n */
#define REG_SWU0_CUR2                   0xFFC1E06C         /* SWU0 Current Register n */
#define REG_SWU0_CUR3                   0xFFC1E08C         /* SWU0 Current Register n */

/* =========================
        SWU1
   ========================= */
#define REG_SWU1_GCTL                   0xFFCAB000         /* SWU1 Global Control Register */
#define REG_SWU1_GSTAT                  0xFFCAB004         /* SWU1 Global Status Register */
#define REG_SWU1_CTL0                   0xFFCAB010         /* SWU1 Control Register n */
#define REG_SWU1_CTL1                   0xFFCAB030         /* SWU1 Control Register n */
#define REG_SWU1_CTL2                   0xFFCAB050         /* SWU1 Control Register n */
#define REG_SWU1_CTL3                   0xFFCAB070         /* SWU1 Control Register n */
#define REG_SWU1_LA0                    0xFFCAB014         /* SWU1 Lower Address Register n */
#define REG_SWU1_LA1                    0xFFCAB034         /* SWU1 Lower Address Register n */
#define REG_SWU1_LA2                    0xFFCAB054         /* SWU1 Lower Address Register n */
#define REG_SWU1_LA3                    0xFFCAB074         /* SWU1 Lower Address Register n */
#define REG_SWU1_UA0                    0xFFCAB018         /* SWU1 Upper Address Register n */
#define REG_SWU1_UA1                    0xFFCAB038         /* SWU1 Upper Address Register n */
#define REG_SWU1_UA2                    0xFFCAB058         /* SWU1 Upper Address Register n */
#define REG_SWU1_UA3                    0xFFCAB078         /* SWU1 Upper Address Register n */
#define REG_SWU1_ID0                    0xFFCAB01C         /* SWU1 ID Register n */
#define REG_SWU1_ID1                    0xFFCAB03C         /* SWU1 ID Register n */
#define REG_SWU1_ID2                    0xFFCAB05C         /* SWU1 ID Register n */
#define REG_SWU1_ID3                    0xFFCAB07C         /* SWU1 ID Register n */
#define REG_SWU1_CNT0                   0xFFCAB020         /* SWU1 Count Register n */
#define REG_SWU1_CNT1                   0xFFCAB040         /* SWU1 Count Register n */
#define REG_SWU1_CNT2                   0xFFCAB060         /* SWU1 Count Register n */
#define REG_SWU1_CNT3                   0xFFCAB080         /* SWU1 Count Register n */
#define REG_SWU1_TARG0                  0xFFCAB024         /* SWU1 Target Register n */
#define REG_SWU1_TARG1                  0xFFCAB044         /* SWU1 Target Register n */
#define REG_SWU1_TARG2                  0xFFCAB064         /* SWU1 Target Register n */
#define REG_SWU1_TARG3                  0xFFCAB084         /* SWU1 Target Register n */
#define REG_SWU1_HIST0                  0xFFCAB028         /* SWU1 Bandwidth History Register n */
#define REG_SWU1_HIST1                  0xFFCAB048         /* SWU1 Bandwidth History Register n */
#define REG_SWU1_HIST2                  0xFFCAB068         /* SWU1 Bandwidth History Register n */
#define REG_SWU1_HIST3                  0xFFCAB088         /* SWU1 Bandwidth History Register n */
#define REG_SWU1_CUR0                   0xFFCAB02C         /* SWU1 Current Register n */
#define REG_SWU1_CUR1                   0xFFCAB04C         /* SWU1 Current Register n */
#define REG_SWU1_CUR2                   0xFFCAB06C         /* SWU1 Current Register n */
#define REG_SWU1_CUR3                   0xFFCAB08C         /* SWU1 Current Register n */

/* =========================
        SWU2
   ========================= */
#define REG_SWU2_GCTL                   0xFFCAC000         /* SWU2 Global Control Register */
#define REG_SWU2_GSTAT                  0xFFCAC004         /* SWU2 Global Status Register */
#define REG_SWU2_CTL0                   0xFFCAC010         /* SWU2 Control Register n */
#define REG_SWU2_CTL1                   0xFFCAC030         /* SWU2 Control Register n */
#define REG_SWU2_CTL2                   0xFFCAC050         /* SWU2 Control Register n */
#define REG_SWU2_CTL3                   0xFFCAC070         /* SWU2 Control Register n */
#define REG_SWU2_LA0                    0xFFCAC014         /* SWU2 Lower Address Register n */
#define REG_SWU2_LA1                    0xFFCAC034         /* SWU2 Lower Address Register n */
#define REG_SWU2_LA2                    0xFFCAC054         /* SWU2 Lower Address Register n */
#define REG_SWU2_LA3                    0xFFCAC074         /* SWU2 Lower Address Register n */
#define REG_SWU2_UA0                    0xFFCAC018         /* SWU2 Upper Address Register n */
#define REG_SWU2_UA1                    0xFFCAC038         /* SWU2 Upper Address Register n */
#define REG_SWU2_UA2                    0xFFCAC058         /* SWU2 Upper Address Register n */
#define REG_SWU2_UA3                    0xFFCAC078         /* SWU2 Upper Address Register n */
#define REG_SWU2_ID0                    0xFFCAC01C         /* SWU2 ID Register n */
#define REG_SWU2_ID1                    0xFFCAC03C         /* SWU2 ID Register n */
#define REG_SWU2_ID2                    0xFFCAC05C         /* SWU2 ID Register n */
#define REG_SWU2_ID3                    0xFFCAC07C         /* SWU2 ID Register n */
#define REG_SWU2_CNT0                   0xFFCAC020         /* SWU2 Count Register n */
#define REG_SWU2_CNT1                   0xFFCAC040         /* SWU2 Count Register n */
#define REG_SWU2_CNT2                   0xFFCAC060         /* SWU2 Count Register n */
#define REG_SWU2_CNT3                   0xFFCAC080         /* SWU2 Count Register n */
#define REG_SWU2_TARG0                  0xFFCAC024         /* SWU2 Target Register n */
#define REG_SWU2_TARG1                  0xFFCAC044         /* SWU2 Target Register n */
#define REG_SWU2_TARG2                  0xFFCAC064         /* SWU2 Target Register n */
#define REG_SWU2_TARG3                  0xFFCAC084         /* SWU2 Target Register n */
#define REG_SWU2_HIST0                  0xFFCAC028         /* SWU2 Bandwidth History Register n */
#define REG_SWU2_HIST1                  0xFFCAC048         /* SWU2 Bandwidth History Register n */
#define REG_SWU2_HIST2                  0xFFCAC068         /* SWU2 Bandwidth History Register n */
#define REG_SWU2_HIST3                  0xFFCAC088         /* SWU2 Bandwidth History Register n */
#define REG_SWU2_CUR0                   0xFFCAC02C         /* SWU2 Current Register n */
#define REG_SWU2_CUR1                   0xFFCAC04C         /* SWU2 Current Register n */
#define REG_SWU2_CUR2                   0xFFCAC06C         /* SWU2 Current Register n */
#define REG_SWU2_CUR3                   0xFFCAC08C         /* SWU2 Current Register n */

/* =========================
        SWU3
   ========================= */
#define REG_SWU3_GCTL                   0xFFCAD000         /* SWU3 Global Control Register */
#define REG_SWU3_GSTAT                  0xFFCAD004         /* SWU3 Global Status Register */
#define REG_SWU3_CTL0                   0xFFCAD010         /* SWU3 Control Register n */
#define REG_SWU3_CTL1                   0xFFCAD030         /* SWU3 Control Register n */
#define REG_SWU3_CTL2                   0xFFCAD050         /* SWU3 Control Register n */
#define REG_SWU3_CTL3                   0xFFCAD070         /* SWU3 Control Register n */
#define REG_SWU3_LA0                    0xFFCAD014         /* SWU3 Lower Address Register n */
#define REG_SWU3_LA1                    0xFFCAD034         /* SWU3 Lower Address Register n */
#define REG_SWU3_LA2                    0xFFCAD054         /* SWU3 Lower Address Register n */
#define REG_SWU3_LA3                    0xFFCAD074         /* SWU3 Lower Address Register n */
#define REG_SWU3_UA0                    0xFFCAD018         /* SWU3 Upper Address Register n */
#define REG_SWU3_UA1                    0xFFCAD038         /* SWU3 Upper Address Register n */
#define REG_SWU3_UA2                    0xFFCAD058         /* SWU3 Upper Address Register n */
#define REG_SWU3_UA3                    0xFFCAD078         /* SWU3 Upper Address Register n */
#define REG_SWU3_ID0                    0xFFCAD01C         /* SWU3 ID Register n */
#define REG_SWU3_ID1                    0xFFCAD03C         /* SWU3 ID Register n */
#define REG_SWU3_ID2                    0xFFCAD05C         /* SWU3 ID Register n */
#define REG_SWU3_ID3                    0xFFCAD07C         /* SWU3 ID Register n */
#define REG_SWU3_CNT0                   0xFFCAD020         /* SWU3 Count Register n */
#define REG_SWU3_CNT1                   0xFFCAD040         /* SWU3 Count Register n */
#define REG_SWU3_CNT2                   0xFFCAD060         /* SWU3 Count Register n */
#define REG_SWU3_CNT3                   0xFFCAD080         /* SWU3 Count Register n */
#define REG_SWU3_TARG0                  0xFFCAD024         /* SWU3 Target Register n */
#define REG_SWU3_TARG1                  0xFFCAD044         /* SWU3 Target Register n */
#define REG_SWU3_TARG2                  0xFFCAD064         /* SWU3 Target Register n */
#define REG_SWU3_TARG3                  0xFFCAD084         /* SWU3 Target Register n */
#define REG_SWU3_HIST0                  0xFFCAD028         /* SWU3 Bandwidth History Register n */
#define REG_SWU3_HIST1                  0xFFCAD048         /* SWU3 Bandwidth History Register n */
#define REG_SWU3_HIST2                  0xFFCAD068         /* SWU3 Bandwidth History Register n */
#define REG_SWU3_HIST3                  0xFFCAD088         /* SWU3 Bandwidth History Register n */
#define REG_SWU3_CUR0                   0xFFCAD02C         /* SWU3 Current Register n */
#define REG_SWU3_CUR1                   0xFFCAD04C         /* SWU3 Current Register n */
#define REG_SWU3_CUR2                   0xFFCAD06C         /* SWU3 Current Register n */
#define REG_SWU3_CUR3                   0xFFCAD08C         /* SWU3 Current Register n */

/* =========================
        SWU4
   ========================= */
#define REG_SWU4_GCTL                   0xFFCAE000         /* SWU4 Global Control Register */
#define REG_SWU4_GSTAT                  0xFFCAE004         /* SWU4 Global Status Register */
#define REG_SWU4_CTL0                   0xFFCAE010         /* SWU4 Control Register n */
#define REG_SWU4_CTL1                   0xFFCAE030         /* SWU4 Control Register n */
#define REG_SWU4_CTL2                   0xFFCAE050         /* SWU4 Control Register n */
#define REG_SWU4_CTL3                   0xFFCAE070         /* SWU4 Control Register n */
#define REG_SWU4_LA0                    0xFFCAE014         /* SWU4 Lower Address Register n */
#define REG_SWU4_LA1                    0xFFCAE034         /* SWU4 Lower Address Register n */
#define REG_SWU4_LA2                    0xFFCAE054         /* SWU4 Lower Address Register n */
#define REG_SWU4_LA3                    0xFFCAE074         /* SWU4 Lower Address Register n */
#define REG_SWU4_UA0                    0xFFCAE018         /* SWU4 Upper Address Register n */
#define REG_SWU4_UA1                    0xFFCAE038         /* SWU4 Upper Address Register n */
#define REG_SWU4_UA2                    0xFFCAE058         /* SWU4 Upper Address Register n */
#define REG_SWU4_UA3                    0xFFCAE078         /* SWU4 Upper Address Register n */
#define REG_SWU4_ID0                    0xFFCAE01C         /* SWU4 ID Register n */
#define REG_SWU4_ID1                    0xFFCAE03C         /* SWU4 ID Register n */
#define REG_SWU4_ID2                    0xFFCAE05C         /* SWU4 ID Register n */
#define REG_SWU4_ID3                    0xFFCAE07C         /* SWU4 ID Register n */
#define REG_SWU4_CNT0                   0xFFCAE020         /* SWU4 Count Register n */
#define REG_SWU4_CNT1                   0xFFCAE040         /* SWU4 Count Register n */
#define REG_SWU4_CNT2                   0xFFCAE060         /* SWU4 Count Register n */
#define REG_SWU4_CNT3                   0xFFCAE080         /* SWU4 Count Register n */
#define REG_SWU4_TARG0                  0xFFCAE024         /* SWU4 Target Register n */
#define REG_SWU4_TARG1                  0xFFCAE044         /* SWU4 Target Register n */
#define REG_SWU4_TARG2                  0xFFCAE064         /* SWU4 Target Register n */
#define REG_SWU4_TARG3                  0xFFCAE084         /* SWU4 Target Register n */
#define REG_SWU4_HIST0                  0xFFCAE028         /* SWU4 Bandwidth History Register n */
#define REG_SWU4_HIST1                  0xFFCAE048         /* SWU4 Bandwidth History Register n */
#define REG_SWU4_HIST2                  0xFFCAE068         /* SWU4 Bandwidth History Register n */
#define REG_SWU4_HIST3                  0xFFCAE088         /* SWU4 Bandwidth History Register n */
#define REG_SWU4_CUR0                   0xFFCAE02C         /* SWU4 Current Register n */
#define REG_SWU4_CUR1                   0xFFCAE04C         /* SWU4 Current Register n */
#define REG_SWU4_CUR2                   0xFFCAE06C         /* SWU4 Current Register n */
#define REG_SWU4_CUR3                   0xFFCAE08C         /* SWU4 Current Register n */

/* =========================
        SWU5
   ========================= */
#define REG_SWU5_GCTL                   0xFFCAF000         /* SWU5 Global Control Register */
#define REG_SWU5_GSTAT                  0xFFCAF004         /* SWU5 Global Status Register */
#define REG_SWU5_CTL0                   0xFFCAF010         /* SWU5 Control Register n */
#define REG_SWU5_CTL1                   0xFFCAF030         /* SWU5 Control Register n */
#define REG_SWU5_CTL2                   0xFFCAF050         /* SWU5 Control Register n */
#define REG_SWU5_CTL3                   0xFFCAF070         /* SWU5 Control Register n */
#define REG_SWU5_LA0                    0xFFCAF014         /* SWU5 Lower Address Register n */
#define REG_SWU5_LA1                    0xFFCAF034         /* SWU5 Lower Address Register n */
#define REG_SWU5_LA2                    0xFFCAF054         /* SWU5 Lower Address Register n */
#define REG_SWU5_LA3                    0xFFCAF074         /* SWU5 Lower Address Register n */
#define REG_SWU5_UA0                    0xFFCAF018         /* SWU5 Upper Address Register n */
#define REG_SWU5_UA1                    0xFFCAF038         /* SWU5 Upper Address Register n */
#define REG_SWU5_UA2                    0xFFCAF058         /* SWU5 Upper Address Register n */
#define REG_SWU5_UA3                    0xFFCAF078         /* SWU5 Upper Address Register n */
#define REG_SWU5_ID0                    0xFFCAF01C         /* SWU5 ID Register n */
#define REG_SWU5_ID1                    0xFFCAF03C         /* SWU5 ID Register n */
#define REG_SWU5_ID2                    0xFFCAF05C         /* SWU5 ID Register n */
#define REG_SWU5_ID3                    0xFFCAF07C         /* SWU5 ID Register n */
#define REG_SWU5_CNT0                   0xFFCAF020         /* SWU5 Count Register n */
#define REG_SWU5_CNT1                   0xFFCAF040         /* SWU5 Count Register n */
#define REG_SWU5_CNT2                   0xFFCAF060         /* SWU5 Count Register n */
#define REG_SWU5_CNT3                   0xFFCAF080         /* SWU5 Count Register n */
#define REG_SWU5_TARG0                  0xFFCAF024         /* SWU5 Target Register n */
#define REG_SWU5_TARG1                  0xFFCAF044         /* SWU5 Target Register n */
#define REG_SWU5_TARG2                  0xFFCAF064         /* SWU5 Target Register n */
#define REG_SWU5_TARG3                  0xFFCAF084         /* SWU5 Target Register n */
#define REG_SWU5_HIST0                  0xFFCAF028         /* SWU5 Bandwidth History Register n */
#define REG_SWU5_HIST1                  0xFFCAF048         /* SWU5 Bandwidth History Register n */
#define REG_SWU5_HIST2                  0xFFCAF068         /* SWU5 Bandwidth History Register n */
#define REG_SWU5_HIST3                  0xFFCAF088         /* SWU5 Bandwidth History Register n */
#define REG_SWU5_CUR0                   0xFFCAF02C         /* SWU5 Current Register n */
#define REG_SWU5_CUR1                   0xFFCAF04C         /* SWU5 Current Register n */
#define REG_SWU5_CUR2                   0xFFCAF06C         /* SWU5 Current Register n */
#define REG_SWU5_CUR3                   0xFFCAF08C         /* SWU5 Current Register n */

/* =========================
        SWU6
   ========================= */
#define REG_SWU6_GCTL                   0xFFC82000         /* SWU6 Global Control Register */
#define REG_SWU6_GSTAT                  0xFFC82004         /* SWU6 Global Status Register */
#define REG_SWU6_CTL0                   0xFFC82010         /* SWU6 Control Register n */
#define REG_SWU6_CTL1                   0xFFC82030         /* SWU6 Control Register n */
#define REG_SWU6_CTL2                   0xFFC82050         /* SWU6 Control Register n */
#define REG_SWU6_CTL3                   0xFFC82070         /* SWU6 Control Register n */
#define REG_SWU6_LA0                    0xFFC82014         /* SWU6 Lower Address Register n */
#define REG_SWU6_LA1                    0xFFC82034         /* SWU6 Lower Address Register n */
#define REG_SWU6_LA2                    0xFFC82054         /* SWU6 Lower Address Register n */
#define REG_SWU6_LA3                    0xFFC82074         /* SWU6 Lower Address Register n */
#define REG_SWU6_UA0                    0xFFC82018         /* SWU6 Upper Address Register n */
#define REG_SWU6_UA1                    0xFFC82038         /* SWU6 Upper Address Register n */
#define REG_SWU6_UA2                    0xFFC82058         /* SWU6 Upper Address Register n */
#define REG_SWU6_UA3                    0xFFC82078         /* SWU6 Upper Address Register n */
#define REG_SWU6_ID0                    0xFFC8201C         /* SWU6 ID Register n */
#define REG_SWU6_ID1                    0xFFC8203C         /* SWU6 ID Register n */
#define REG_SWU6_ID2                    0xFFC8205C         /* SWU6 ID Register n */
#define REG_SWU6_ID3                    0xFFC8207C         /* SWU6 ID Register n */
#define REG_SWU6_CNT0                   0xFFC82020         /* SWU6 Count Register n */
#define REG_SWU6_CNT1                   0xFFC82040         /* SWU6 Count Register n */
#define REG_SWU6_CNT2                   0xFFC82060         /* SWU6 Count Register n */
#define REG_SWU6_CNT3                   0xFFC82080         /* SWU6 Count Register n */
#define REG_SWU6_TARG0                  0xFFC82024         /* SWU6 Target Register n */
#define REG_SWU6_TARG1                  0xFFC82044         /* SWU6 Target Register n */
#define REG_SWU6_TARG2                  0xFFC82064         /* SWU6 Target Register n */
#define REG_SWU6_TARG3                  0xFFC82084         /* SWU6 Target Register n */
#define REG_SWU6_HIST0                  0xFFC82028         /* SWU6 Bandwidth History Register n */
#define REG_SWU6_HIST1                  0xFFC82048         /* SWU6 Bandwidth History Register n */
#define REG_SWU6_HIST2                  0xFFC82068         /* SWU6 Bandwidth History Register n */
#define REG_SWU6_HIST3                  0xFFC82088         /* SWU6 Bandwidth History Register n */
#define REG_SWU6_CUR0                   0xFFC8202C         /* SWU6 Current Register n */
#define REG_SWU6_CUR1                   0xFFC8204C         /* SWU6 Current Register n */
#define REG_SWU6_CUR2                   0xFFC8206C         /* SWU6 Current Register n */
#define REG_SWU6_CUR3                   0xFFC8208C         /* SWU6 Current Register n */

/* =========================
        SWU
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        SWU_GCTL                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SWU_GCTL_RST                     1                               /* Global Reset */
#define BITP_SWU_GCTL_EN                      0                               /* Global Enable */
#define BITM_SWU_GCTL_RST                    (_ADI_MSK(0x00000002,uint32_t))  /* Global Reset */
#define BITM_SWU_GCTL_EN                     (_ADI_MSK(0x00000001,uint32_t))  /* Global Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        SWU_GSTAT                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SWU_GSTAT_ADDRERR               30                               /* Address Error Status */
#define BITP_SWU_GSTAT_OVRBW3                15                               /* Group 3 Bandwidth Above Maximum Target */
#define BITP_SWU_GSTAT_UNDRBW3               14                               /* Group 3 Bandwidth Below Minimum Target */
#define BITP_SWU_GSTAT_OVRBW2                13                               /* Group 2 Bandwidth Above Maximum Target */
#define BITP_SWU_GSTAT_UNDRBW2               12                               /* Group 2 Bandwidth Below Minimum Target */
#define BITP_SWU_GSTAT_OVRBW1                11                               /* Group 1 Bandwidth Above Maximum Target */
#define BITP_SWU_GSTAT_UNDRBW1               10                               /* Group 1 Bandwidth Below Minimum Target */
#define BITP_SWU_GSTAT_OVRBW0                 9                               /* Group 0 Bandwidth Above Maximum Target */
#define BITP_SWU_GSTAT_UNDRBW0                8                               /* Group 0 Bandwidth Below Minimum Target */
#define BITP_SWU_GSTAT_INT3                   7                               /* Group 3 Interrupt Status */
#define BITP_SWU_GSTAT_INT2                   6                               /* Group 2 Interrupt Status */
#define BITP_SWU_GSTAT_INT1                   5                               /* Group 1 Interrupt Status */
#define BITP_SWU_GSTAT_INT0                   4                               /* Group 0 Interrupt Status */
#define BITP_SWU_GSTAT_MTCH3                  3                               /* Group 3 Match */
#define BITP_SWU_GSTAT_MTCH2                  2                               /* Group 2 Match */
#define BITP_SWU_GSTAT_MTCH1                  1                               /* Group 1 Match */
#define BITP_SWU_GSTAT_MTCH0                  0                               /* Group 0 Match */
#define BITM_SWU_GSTAT_ADDRERR               (_ADI_MSK(0x40000000,uint32_t))  /* Address Error Status */
#define BITM_SWU_GSTAT_OVRBW3                (_ADI_MSK(0x00008000,uint32_t))  /* Group 3 Bandwidth Above Maximum Target */
#define BITM_SWU_GSTAT_UNDRBW3               (_ADI_MSK(0x00004000,uint32_t))  /* Group 3 Bandwidth Below Minimum Target */
#define BITM_SWU_GSTAT_OVRBW2                (_ADI_MSK(0x00002000,uint32_t))  /* Group 2 Bandwidth Above Maximum Target */
#define BITM_SWU_GSTAT_UNDRBW2               (_ADI_MSK(0x00001000,uint32_t))  /* Group 2 Bandwidth Below Minimum Target */
#define BITM_SWU_GSTAT_OVRBW1                (_ADI_MSK(0x00000800,uint32_t))  /* Group 1 Bandwidth Above Maximum Target */
#define BITM_SWU_GSTAT_UNDRBW1               (_ADI_MSK(0x00000400,uint32_t))  /* Group 1 Bandwidth Below Minimum Target */
#define BITM_SWU_GSTAT_OVRBW0                (_ADI_MSK(0x00000200,uint32_t))  /* Group 0 Bandwidth Above Maximum Target */
#define BITM_SWU_GSTAT_UNDRBW0               (_ADI_MSK(0x00000100,uint32_t))  /* Group 0 Bandwidth Below Minimum Target */
#define BITM_SWU_GSTAT_INT3                  (_ADI_MSK(0x00000080,uint32_t))  /* Group 3 Interrupt Status */
#define BITM_SWU_GSTAT_INT2                  (_ADI_MSK(0x00000040,uint32_t))  /* Group 2 Interrupt Status */
#define BITM_SWU_GSTAT_INT1                  (_ADI_MSK(0x00000020,uint32_t))  /* Group 1 Interrupt Status */
#define BITM_SWU_GSTAT_INT0                  (_ADI_MSK(0x00000010,uint32_t))  /* Group 0 Interrupt Status */
#define BITM_SWU_GSTAT_MTCH3                 (_ADI_MSK(0x00000008,uint32_t))  /* Group 3 Match */
#define BITM_SWU_GSTAT_MTCH2                 (_ADI_MSK(0x00000004,uint32_t))  /* Group 2 Match */
#define BITM_SWU_GSTAT_MTCH1                 (_ADI_MSK(0x00000002,uint32_t))  /* Group 1 Match */
#define BITM_SWU_GSTAT_MTCH0                 (_ADI_MSK(0x00000001,uint32_t))  /* Group 0 Match */

/* ------------------------------------------------------------------------------------------------------------------------
        SWU_CTL                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SWU_CTL_MAXACT                  19                               /* Action for Bandwidth Above Maximum */
#define BITP_SWU_CTL_MINACT                  18                               /* Action for Bandwidth Below Minimum */
#define BITP_SWU_CTL_BLENINC                 17                               /* Increment Bandwidth Count by Burst Length */
#define BITP_SWU_CTL_BWEN                    16                               /* Bandwidth Mode Enable */
#define BITP_SWU_CTL_TMEN                    15                               /* Trace Message Enable */
#define BITP_SWU_CTL_TRGEN                   14                               /* Trigger Enable */
#define BITP_SWU_CTL_INTEN                   13                               /* Interrupt Enable */
#define BITP_SWU_CTL_DBGEN                   12                               /* Debug Event Enable */
#define BITP_SWU_CTL_CNTRPTEN                 9                               /* Count Repeat Enable */
#define BITP_SWU_CTL_CNTEN                    8                               /* Count Enable */
#define BITP_SWU_CTL_LCMPEN                   6                               /* Locked Comparison Enable */
#define BITP_SWU_CTL_SCMPEN                   5                               /* Secure Comparison Enable */
#define BITP_SWU_CTL_IDCMPEN                  4                               /* ID Comparison Enable */
#define BITP_SWU_CTL_ACMPM                    2                               /* Address Comparison Mode */
#define BITP_SWU_CTL_DIR                      1                               /* Transaction Direction for Match */
#define BITP_SWU_CTL_EN                       0                               /* Enable Watchpoint */
#define BITM_SWU_CTL_MAXACT                  (_ADI_MSK(0x00080000,uint32_t))  /* Action for Bandwidth Above Maximum */
#define BITM_SWU_CTL_MINACT                  (_ADI_MSK(0x00040000,uint32_t))  /* Action for Bandwidth Below Minimum */
#define BITM_SWU_CTL_BLENINC                 (_ADI_MSK(0x00020000,uint32_t))  /* Increment Bandwidth Count by Burst Length */
#define BITM_SWU_CTL_BWEN                    (_ADI_MSK(0x00010000,uint32_t))  /* Bandwidth Mode Enable */
#define BITM_SWU_CTL_TMEN                    (_ADI_MSK(0x00008000,uint32_t))  /* Trace Message Enable */
#define BITM_SWU_CTL_TRGEN                   (_ADI_MSK(0x00004000,uint32_t))  /* Trigger Enable */
#define BITM_SWU_CTL_INTEN                   (_ADI_MSK(0x00002000,uint32_t))  /* Interrupt Enable */
#define BITM_SWU_CTL_DBGEN                   (_ADI_MSK(0x00001000,uint32_t))  /* Debug Event Enable */
#define BITM_SWU_CTL_CNTRPTEN                (_ADI_MSK(0x00000200,uint32_t))  /* Count Repeat Enable */
#define BITM_SWU_CTL_CNTEN                   (_ADI_MSK(0x00000100,uint32_t))  /* Count Enable */
#define BITM_SWU_CTL_LCMPEN                  (_ADI_MSK(0x00000040,uint32_t))  /* Locked Comparison Enable */
#define BITM_SWU_CTL_SCMPEN                  (_ADI_MSK(0x00000020,uint32_t))  /* Secure Comparison Enable */
#define BITM_SWU_CTL_IDCMPEN                 (_ADI_MSK(0x00000010,uint32_t))  /* ID Comparison Enable */
#define BITM_SWU_CTL_ACMPM                   (_ADI_MSK(0x0000000C,uint32_t))  /* Address Comparison Mode */
#define BITM_SWU_CTL_DIR                     (_ADI_MSK(0x00000002,uint32_t))  /* Transaction Direction for Match */
#define BITM_SWU_CTL_EN                      (_ADI_MSK(0x00000001,uint32_t))  /* Enable Watchpoint */

/* ------------------------------------------------------------------------------------------------------------------------
        SWU_ID                               Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SWU_ID_IDMASK                   16                               /* Identity Mask (for Or with ID) */
#define BITP_SWU_ID_ID                        0                               /* Identity */
#define BITM_SWU_ID_IDMASK                   (_ADI_MSK(0xFFFF0000,uint32_t))  /* Identity Mask (for Or with ID) */
#define BITM_SWU_ID_ID                       (_ADI_MSK(0x0000FFFF,uint32_t))  /* Identity */

/* ------------------------------------------------------------------------------------------------------------------------
        SWU_CNT                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SWU_CNT_COUNT                    0                               /* Count */
#define BITM_SWU_CNT_COUNT                   (_ADI_MSK(0x0000FFFF,uint32_t))  /* Count */

/* ------------------------------------------------------------------------------------------------------------------------
        SWU_TARG                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SWU_TARG_BWMAX                  16                               /* Maximum Bandwidth Target */
#define BITP_SWU_TARG_BWMIN                   0                               /* Minimum Bandwidth Target */
#define BITM_SWU_TARG_BWMAX                  (_ADI_MSK(0xFFFF0000,uint32_t))  /* Maximum Bandwidth Target */
#define BITM_SWU_TARG_BWMIN                  (_ADI_MSK(0x0000FFFF,uint32_t))  /* Minimum Bandwidth Target */

/* ------------------------------------------------------------------------------------------------------------------------
        SWU_HIST                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SWU_HIST_BWHIST1                16                               /* Bandwidth from Window Before Last */
#define BITP_SWU_HIST_BWHIST0                 0                               /* Bandwidth from Last Window */
#define BITM_SWU_HIST_BWHIST1                (_ADI_MSK(0xFFFF0000,uint32_t))  /* Bandwidth from Window Before Last */
#define BITM_SWU_HIST_BWHIST0                (_ADI_MSK(0x0000FFFF,uint32_t))  /* Bandwidth from Last Window */

/* ------------------------------------------------------------------------------------------------------------------------
        SWU_CUR                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SWU_CUR_CURBW                   16                               /* Current Bandwidth */
#define BITP_SWU_CUR_CURCNT                   0                               /* Current Count */
#define BITM_SWU_CUR_CURBW                   (_ADI_MSK(0xFFFF0000,uint32_t))  /* Current Bandwidth */
#define BITM_SWU_CUR_CURCNT                  (_ADI_MSK(0x0000FFFF,uint32_t))  /* Current Count */

/* ==================================================
        System Debug Unit Registers
   ================================================== */

/* =========================
        SDU0
   ========================= */
#define REG_SDU0_IDCODE                 0xFFC1F020         /* SDU0 ID Code Register */
#define REG_SDU0_CTL                    0xFFC1F050         /* SDU0 Control Register */
#define REG_SDU0_STAT                   0xFFC1F054         /* SDU0 Status Register */
#define REG_SDU0_MACCTL                 0xFFC1F058         /* SDU0 Memory Access Control Register */
#define REG_SDU0_MACADDR                0xFFC1F05C         /* SDU0 Memory Access Address Register */
#define REG_SDU0_MACDATA                0xFFC1F060         /* SDU0 Memory Access Data Register */
#define REG_SDU0_DMARD                  0xFFC1F064         /* SDU0 DMA Read Data Register */
#define REG_SDU0_DMAWD                  0xFFC1F068         /* SDU0 DMA Write Data Register */
#define REG_SDU0_MSG                    0xFFC1F080         /* SDU0 Message Register */
#define REG_SDU0_MSG_SET                0xFFC1F084         /* SDU0 Message Set Register */
#define REG_SDU0_MSG_CLR                0xFFC1F088         /* SDU0 Message Clear Register */
#define REG_SDU0_GHLT                   0xFFC1F08C         /* SDU0 Group Halt Register */

/* =========================
        SDU
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        SDU_IDCODE                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SDU_IDCODE_REVID                28                               /* Revision ID */
#define BITP_SDU_IDCODE_PRID                 12                               /* Product ID */
#define BITP_SDU_IDCODE_MFID                  1                               /* Manufacturer ID */
#define BITM_SDU_IDCODE_REVID                (_ADI_MSK(0xF0000000,uint32_t))  /* Revision ID */
#define BITM_SDU_IDCODE_PRID                 (_ADI_MSK(0x0FFFF000,uint32_t))  /* Product ID */
#define BITM_SDU_IDCODE_MFID                 (_ADI_MSK(0x00000FFE,uint32_t))  /* Manufacturer ID */

/* ------------------------------------------------------------------------------------------------------------------------
        SDU_CTL                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SDU_CTL_EHLT                     8                               /* Emulator Halt Select */
#define BITP_SDU_CTL_EMEEN                    4                               /* Emulation Event Enable */
#define BITP_SDU_CTL_DMAEN                    2                               /* DMA Enable */
#define BITP_SDU_CTL_CSPEN                    1                               /* Core Scan Path Enable */
#define BITP_SDU_CTL_SYSRST                   0                               /* System Reset */
#define BITM_SDU_CTL_EHLT                    (_ADI_MSK(0x0000FF00,uint32_t))  /* Emulator Halt Select */
#define BITM_SDU_CTL_EMEEN                   (_ADI_MSK(0x00000010,uint32_t))  /* Emulation Event Enable */
#define BITM_SDU_CTL_DMAEN                   (_ADI_MSK(0x00000004,uint32_t))  /* DMA Enable */
#define BITM_SDU_CTL_CSPEN                   (_ADI_MSK(0x00000002,uint32_t))  /* Core Scan Path Enable */
#define BITM_SDU_CTL_SYSRST                  (_ADI_MSK(0x00000001,uint32_t))  /* System Reset */

/* ------------------------------------------------------------------------------------------------------------------------
        SDU_STAT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SDU_STAT_CRST                   22                               /* Core Reset */
#define BITP_SDU_STAT_CHLT                   21                               /* Core Halt */
#define BITP_SDU_STAT_EME                    20                               /* Emulation Event */
#define BITP_SDU_STAT_GHLTC                  17                               /* Group Halt Cause */
#define BITP_SDU_STAT_GHLT                   16                               /* Group Halt */
#define BITP_SDU_STAT_DMAFIFO                12                               /* DMA FIFO */
#define BITP_SDU_STAT_ADDRERR                11                               /* Address Error */
#define BITP_SDU_STAT_DMAWDRDY               10                               /* DMAWD Ready */
#define BITP_SDU_STAT_DMARDRDY                9                               /* DMARD Ready */
#define BITP_SDU_STAT_MACRDY                  8                               /* MAC Ready */
#define BITP_SDU_STAT_ERRC                    4                               /* Error Cause */
#define BITP_SDU_STAT_SECURE                  3                               /* Secure Mode */
#define BITP_SDU_STAT_DEEPSLEEP               2                               /* Deep Sleep Mode */
#define BITP_SDU_STAT_ERR                     1                               /* Error */
#define BITP_SDU_STAT_SYSRST                  0                               /* System Reset */
#define BITM_SDU_STAT_CRST                   (_ADI_MSK(0x00400000,uint32_t))  /* Core Reset */
#define BITM_SDU_STAT_CHLT                   (_ADI_MSK(0x00200000,uint32_t))  /* Core Halt */
#define BITM_SDU_STAT_EME                    (_ADI_MSK(0x00100000,uint32_t))  /* Emulation Event */
#define BITM_SDU_STAT_GHLTC                  (_ADI_MSK(0x000E0000,uint32_t))  /* Group Halt Cause */
#define BITM_SDU_STAT_GHLT                   (_ADI_MSK(0x00010000,uint32_t))  /* Group Halt */
#define BITM_SDU_STAT_DMAFIFO                (_ADI_MSK(0x00007000,uint32_t))  /* DMA FIFO */
#define BITM_SDU_STAT_ADDRERR                (_ADI_MSK(0x00000800,uint32_t))  /* Address Error */
#define BITM_SDU_STAT_DMAWDRDY               (_ADI_MSK(0x00000400,uint32_t))  /* DMAWD Ready */
#define BITM_SDU_STAT_DMARDRDY               (_ADI_MSK(0x00000200,uint32_t))  /* DMARD Ready */
#define BITM_SDU_STAT_MACRDY                 (_ADI_MSK(0x00000100,uint32_t))  /* MAC Ready */
#define BITM_SDU_STAT_ERRC                   (_ADI_MSK(0x000000F0,uint32_t))  /* Error Cause */
#define BITM_SDU_STAT_SECURE                 (_ADI_MSK(0x00000008,uint32_t))  /* Secure Mode */
#define BITM_SDU_STAT_DEEPSLEEP              (_ADI_MSK(0x00000004,uint32_t))  /* Deep Sleep Mode */
#define BITM_SDU_STAT_ERR                    (_ADI_MSK(0x00000002,uint32_t))  /* Error */
#define BITM_SDU_STAT_SYSRST                 (_ADI_MSK(0x00000001,uint32_t))  /* System Reset */

/* ------------------------------------------------------------------------------------------------------------------------
        SDU_MACCTL                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SDU_MACCTL_AUTOINC               4                               /* Auto (Post) Increment MACADDR (by SIZE) */
#define BITP_SDU_MACCTL_RNW                   3                               /* Read Not Write */
#define BITP_SDU_MACCTL_SIZE                  0                               /* Transfer Data Size */
#define BITM_SDU_MACCTL_AUTOINC              (_ADI_MSK(0x00000010,uint32_t))  /* Auto (Post) Increment MACADDR (by SIZE) */
#define BITM_SDU_MACCTL_RNW                  (_ADI_MSK(0x00000008,uint32_t))  /* Read Not Write */
#define BITM_SDU_MACCTL_SIZE                 (_ADI_MSK(0x00000007,uint32_t))  /* Transfer Data Size */

/* ------------------------------------------------------------------------------------------------------------------------
        SDU_MSG                              Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SDU_MSG_CALLERR                 31                               /* Flag Set by the Boot Code Prior to an Error Call */
#define BITP_SDU_MSG_CALLBACK                30                               /* Flag Set by the Boot Code Prior to a Callback Call */
#define BITP_SDU_MSG_CALLINIT                29                               /* Flag Set by the Boot Code Prior to an Initcode Call */
#define BITP_SDU_MSG_CALLAPP                 28                               /* Flag Set by the Boot Code Prior to an Application Call */
#define BITP_SDU_MSG_HALTONERR               27                               /* Generate an Emulation Exception Prior to an Error Call */
#define BITP_SDU_MSG_HALTONCALL              26                               /* Generate an Emulation Exception Prior to a Callback Call */
#define BITP_SDU_MSG_HALTONINIT              25                               /* Generate an Emulation Exception Prior to an Initcode Call */
#define BITP_SDU_MSG_HALTONAPP               24                               /* Generate an Emulation Exception Prior to an Application Call */
#define BITP_SDU_MSG_L3INIT                  23                               /* Indicates that the L3 Resource is Initialized */
#define BITP_SDU_MSG_L2INIT                  22                               /* Indicates that the L2 Resource is Initialized */
#define BITP_SDU_MSG_C1L1INIT                17                               /* Indicates that the Core 1 L1 Resource is Initialized */
#define BITP_SDU_MSG_C0L1INIT                16                               /* Indicates that the Core 0 L1 Resource is Initialized */
#define BITM_SDU_MSG_CALLERR                 (_ADI_MSK(0x80000000,uint32_t))  /* Flag Set by the Boot Code Prior to an Error Call */
#define BITM_SDU_MSG_CALLBACK                (_ADI_MSK(0x40000000,uint32_t))  /* Flag Set by the Boot Code Prior to a Callback Call */
#define BITM_SDU_MSG_CALLINIT                (_ADI_MSK(0x20000000,uint32_t))  /* Flag Set by the Boot Code Prior to an Initcode Call */
#define BITM_SDU_MSG_CALLAPP                 (_ADI_MSK(0x10000000,uint32_t))  /* Flag Set by the Boot Code Prior to an Application Call */
#define BITM_SDU_MSG_HALTONERR               (_ADI_MSK(0x08000000,uint32_t))  /* Generate an Emulation Exception Prior to an Error Call */
#define BITM_SDU_MSG_HALTONCALL              (_ADI_MSK(0x04000000,uint32_t))  /* Generate an Emulation Exception Prior to a Callback Call */
#define BITM_SDU_MSG_HALTONINIT              (_ADI_MSK(0x02000000,uint32_t))  /* Generate an Emulation Exception Prior to an Initcode Call */
#define BITM_SDU_MSG_HALTONAPP               (_ADI_MSK(0x01000000,uint32_t))  /* Generate an Emulation Exception Prior to an Application Call */
#define BITM_SDU_MSG_L3INIT                  (_ADI_MSK(0x00800000,uint32_t))  /* Indicates that the L3 Resource is Initialized */
#define BITM_SDU_MSG_L2INIT                  (_ADI_MSK(0x00400000,uint32_t))  /* Indicates that the L2 Resource is Initialized */
#define BITM_SDU_MSG_C1L1INIT                (_ADI_MSK(0x00020000,uint32_t))  /* Indicates that the Core 1 L1 Resource is Initialized */
#define BITM_SDU_MSG_C0L1INIT                (_ADI_MSK(0x00010000,uint32_t))  /* Indicates that the Core 0 L1 Resource is Initialized */

/* ------------------------------------------------------------------------------------------------------------------------
        SDU_GHLT                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SDU_GHLT_SS2                    18                               /* Slave Select 2 */
#define BITP_SDU_GHLT_SS1                    17                               /* Slave Select 1 */
#define BITP_SDU_GHLT_SS0                    16                               /* Slave Select 0 */
#define BITP_SDU_GHLT_MS2                     2                               /* Master Select 2 */
#define BITP_SDU_GHLT_MS1                     1                               /* Master Select 1 */
#define BITP_SDU_GHLT_MS0                     0                               /* Master Select 0 */
#define BITM_SDU_GHLT_SS2                    (_ADI_MSK(0x00040000,uint32_t))  /* Slave Select 2 */
#define BITM_SDU_GHLT_SS1                    (_ADI_MSK(0x00020000,uint32_t))  /* Slave Select 1 */
#define BITM_SDU_GHLT_SS0                    (_ADI_MSK(0x00010000,uint32_t))  /* Slave Select 0 */
#define BITM_SDU_GHLT_MS2                    (_ADI_MSK(0x00000004,uint32_t))  /* Master Select 2 */
#define BITM_SDU_GHLT_MS1                    (_ADI_MSK(0x00000002,uint32_t))  /* Master Select 1 */
#define BITM_SDU_GHLT_MS0                    (_ADI_MSK(0x00000001,uint32_t))  /* Master Select 0 */

/* ==================================================
        Ethernet MAC Registers
   ================================================== */

/* =========================
        EMAC0
   ========================= */
#define REG_EMAC0_MACCFG                0xFFC20000         /* EMAC0 MAC Configuration Register */
#define REG_EMAC0_MACFRMFILT            0xFFC20004         /* EMAC0 MAC Rx Frame Filter Register */
#define REG_EMAC0_HASHTBL_HI            0xFFC20008         /* EMAC0 Hash Table High Register */
#define REG_EMAC0_HASHTBL_LO            0xFFC2000C         /* EMAC0 Hash Table Low Register */
#define REG_EMAC0_SMI_ADDR              0xFFC20010         /* EMAC0 SMI Address Register */
#define REG_EMAC0_SMI_DATA              0xFFC20014         /* EMAC0 SMI Data Register */
#define REG_EMAC0_FLOWCTL               0xFFC20018         /* EMAC0 FLow Control Register */
#define REG_EMAC0_VLANTAG               0xFFC2001C         /* EMAC0 VLAN Tag Register */
#define REG_EMAC0_DBG                   0xFFC20024         /* EMAC0 Debug Register */
#define REG_EMAC0_ISTAT                 0xFFC20038         /* EMAC0 Interrupt Status Register */
#define REG_EMAC0_IMSK                  0xFFC2003C         /* EMAC0 Interrupt Mask Register */
#define REG_EMAC0_ADDR0_HI              0xFFC20040         /* EMAC0 MAC Address 0 High Register */
#define REG_EMAC0_ADDR0_LO              0xFFC20044         /* EMAC0 MAC Address 0 Low Register */
#define REG_EMAC0_MMC_CTL               0xFFC20100         /* EMAC0 MMC Control Register */
#define REG_EMAC0_MMC_RXINT             0xFFC20104         /* EMAC0 MMC Rx Interrupt Register */
#define REG_EMAC0_MMC_TXINT             0xFFC20108         /* EMAC0 MMC Tx Interrupt Register */
#define REG_EMAC0_MMC_RXIMSK            0xFFC2010C         /* EMAC0 MMC Rx Interrupt Mask Register */
#define REG_EMAC0_MMC_TXIMSK            0xFFC20110         /* EMAC0 MMC TX Interrupt Mask Register */
#define REG_EMAC0_TXOCTCNT_GB           0xFFC20114         /* EMAC0 Tx OCT Count (Good/Bad) Register */
#define REG_EMAC0_TXFRMCNT_GB           0xFFC20118         /* EMAC0 Tx Frame Count (Good/Bad) Register */
#define REG_EMAC0_TXBCASTFRM_G          0xFFC2011C         /* EMAC0 Tx Broadcast Frames (Good) Register */
#define REG_EMAC0_TXMCASTFRM_G          0xFFC20120         /* EMAC0 Tx Multicast Frames (Good) Register */
#define REG_EMAC0_TX64_GB               0xFFC20124         /* EMAC0 Tx 64-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_TX65TO127_GB          0xFFC20128         /* EMAC0 Tx 65- to 127-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_TX128TO255_GB         0xFFC2012C         /* EMAC0 Tx 128- to 255-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_TX256TO511_GB         0xFFC20130         /* EMAC0 Tx 256- to 511-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_TX512TO1023_GB        0xFFC20134         /* EMAC0 Tx 512- to 1023-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_TX1024TOMAX_GB        0xFFC20138         /* EMAC0 Tx 1024- to Max-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_TXUCASTFRM_GB         0xFFC2013C         /* EMAC0 Tx Unicast Frames (Good/Bad) Register */
#define REG_EMAC0_TXMCASTFRM_GB         0xFFC20140         /* EMAC0 Tx Multicast Frames (Good/Bad) Register */
#define REG_EMAC0_TXBCASTFRM_GB         0xFFC20144         /* EMAC0 Tx Broadcast Frames (Good/Bad) Register */
#define REG_EMAC0_TXUNDR_ERR            0xFFC20148         /* EMAC0 Tx Underflow Error Register */
#define REG_EMAC0_TXSNGCOL_G            0xFFC2014C         /* EMAC0 Tx Single Collision (Good) Register */
#define REG_EMAC0_TXMULTCOL_G           0xFFC20150         /* EMAC0 Tx Multiple Collision (Good) Register */
#define REG_EMAC0_TXDEFERRED            0xFFC20154         /* EMAC0 Tx Deferred Register */
#define REG_EMAC0_TXLATECOL             0xFFC20158         /* EMAC0 Tx Late Collision Register */
#define REG_EMAC0_TXEXCESSCOL           0xFFC2015C         /* EMAC0 Tx Excess Collision Register */
#define REG_EMAC0_TXCARR_ERR            0xFFC20160         /* EMAC0 Tx Carrier Error Register */
#define REG_EMAC0_TXOCTCNT_G            0xFFC20164         /* EMAC0 Tx Octet Count (Good) Register */
#define REG_EMAC0_TXFRMCNT_G            0xFFC20168         /* EMAC0 Tx Frame Count (Good) Register */
#define REG_EMAC0_TXEXCESSDEF           0xFFC2016C         /* EMAC0 Tx Excess Deferral Register */
#define REG_EMAC0_TXPAUSEFRM            0xFFC20170         /* EMAC0 Tx Pause Frame Register */
#define REG_EMAC0_TXVLANFRM_G           0xFFC20174         /* EMAC0 Tx VLAN Frames (Good) Register */
#define REG_EMAC0_RXFRMCNT_GB           0xFFC20180         /* EMAC0 Rx Frame Count (Good/Bad) Register */
#define REG_EMAC0_RXOCTCNT_GB           0xFFC20184         /* EMAC0 Rx Octet Count (Good/Bad) Register */
#define REG_EMAC0_RXOCTCNT_G            0xFFC20188         /* EMAC0 Rx Octet Count (Good) Register */
#define REG_EMAC0_RXBCASTFRM_G          0xFFC2018C         /* EMAC0 Rx Broadcast Frames (Good) Register */
#define REG_EMAC0_RXMCASTFRM_G          0xFFC20190         /* EMAC0 Rx Multicast Frames (Good) Register */
#define REG_EMAC0_RXCRC_ERR             0xFFC20194         /* EMAC0 Rx CRC Error Register */
#define REG_EMAC0_RXALIGN_ERR           0xFFC20198         /* EMAC0 Rx alignment Error Register */
#define REG_EMAC0_RXRUNT_ERR            0xFFC2019C         /* EMAC0 Rx Runt Error Register */
#define REG_EMAC0_RXJAB_ERR             0xFFC201A0         /* EMAC0 Rx Jab Error Register */
#define REG_EMAC0_RXUSIZE_G             0xFFC201A4         /* EMAC0 Rx Undersize (Good) Register */
#define REG_EMAC0_RXOSIZE_G             0xFFC201A8         /* EMAC0 Rx Oversize (Good) Register */
#define REG_EMAC0_RX64_GB               0xFFC201AC         /* EMAC0 Rx 64-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_RX65TO127_GB          0xFFC201B0         /* EMAC0 Rx 65- to 127-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_RX128TO255_GB         0xFFC201B4         /* EMAC0 Rx 128- to 255-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_RX256TO511_GB         0xFFC201B8         /* EMAC0 Rx 256- to 511-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_RX512TO1023_GB        0xFFC201BC         /* EMAC0 Rx 512- to 1023-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_RX1024TOMAX_GB        0xFFC201C0         /* EMAC0 Rx 1024- to Max-Byte Frames (Good/Bad) Register */
#define REG_EMAC0_RXUCASTFRM_G          0xFFC201C4         /* EMAC0 Rx Unicast Frames (Good) Register */
#define REG_EMAC0_RXLEN_ERR             0xFFC201C8         /* EMAC0 Rx Length Error Register */
#define REG_EMAC0_RXOORTYPE             0xFFC201CC         /* EMAC0 Rx Out Of Range Type Register */
#define REG_EMAC0_RXPAUSEFRM            0xFFC201D0         /* EMAC0 Rx Pause Frames Register */
#define REG_EMAC0_RXFIFO_OVF            0xFFC201D4         /* EMAC0 Rx FIFO Overflow Register */
#define REG_EMAC0_RXVLANFRM_GB          0xFFC201D8         /* EMAC0 Rx VLAN Frames (Good/Bad) Register */
#define REG_EMAC0_RXWDOG_ERR            0xFFC201DC         /* EMAC0 Rx Watch Dog Error Register */
#define REG_EMAC0_IPC_RXIMSK            0xFFC20200         /* EMAC0 MMC IPC Rx Interrupt Mask Register */
#define REG_EMAC0_IPC_RXINT             0xFFC20208         /* EMAC0 MMC IPC Rx Interrupt Register */
#define REG_EMAC0_RXIPV4_GD_FRM         0xFFC20210         /* EMAC0 Rx IPv4 Datagrams (Good) Register */
#define REG_EMAC0_RXIPV4_HDR_ERR_FRM    0xFFC20214         /* EMAC0 Rx IPv4 Datagrams Header Errors Register */
#define REG_EMAC0_RXIPV4_NOPAY_FRM      0xFFC20218         /* EMAC0 Rx IPv4 Datagrams No Payload Frame Register */
#define REG_EMAC0_RXIPV4_FRAG_FRM       0xFFC2021C         /* EMAC0 Rx IPv4 Datagrams Fragmented Frames Register */
#define REG_EMAC0_RXIPV4_UDSBL_FRM      0xFFC20220         /* EMAC0 Rx IPv4 UDP Disabled Frames Register */
#define REG_EMAC0_RXIPV6_GD_FRM         0xFFC20224         /* EMAC0 Rx IPv6 Datagrams Good Frames Register */
#define REG_EMAC0_RXIPV6_HDR_ERR_FRM    0xFFC20228         /* EMAC0 Rx IPv6 Datagrams Header Error Frames Register */
#define REG_EMAC0_RXIPV6_NOPAY_FRM      0xFFC2022C         /* EMAC0 Rx IPv6 Datagrams No Payload Frames Register */
#define REG_EMAC0_RXUDP_GD_FRM          0xFFC20230         /* EMAC0 Rx UDP Good Frames Register */
#define REG_EMAC0_RXUDP_ERR_FRM         0xFFC20234         /* EMAC0 Rx UDP Error Frames Register */
#define REG_EMAC0_RXTCP_GD_FRM          0xFFC20238         /* EMAC0 Rx TCP Good Frames Register */
#define REG_EMAC0_RXTCP_ERR_FRM         0xFFC2023C         /* EMAC0 Rx TCP Error Frames Register */
#define REG_EMAC0_RXICMP_GD_FRM         0xFFC20240         /* EMAC0 Rx ICMP Good Frames Register */
#define REG_EMAC0_RXICMP_ERR_FRM        0xFFC20244         /* EMAC0 Rx ICMP Error Frames Register */
#define REG_EMAC0_RXIPV4_GD_OCT         0xFFC20250         /* EMAC0 Rx IPv4 Datagrams Good Octets Register */
#define REG_EMAC0_RXIPV4_HDR_ERR_OCT    0xFFC20254         /* EMAC0 Rx IPv4 Datagrams Header Errors Register */
#define REG_EMAC0_RXIPV4_NOPAY_OCT      0xFFC20258         /* EMAC0 Rx IPv4 Datagrams No Payload Octets Register */
#define REG_EMAC0_RXIPV4_FRAG_OCT       0xFFC2025C         /* EMAC0 Rx IPv4 Datagrams Fragmented Octets Register */
#define REG_EMAC0_RXIPV4_UDSBL_OCT      0xFFC20260         /* EMAC0 Rx IPv4 UDP Disabled Octets Register */
#define REG_EMAC0_RXIPV6_GD_OCT         0xFFC20264         /* EMAC0 Rx IPv6 Good Octets Register */
#define REG_EMAC0_RXIPV6_HDR_ERR_OCT    0xFFC20268         /* EMAC0 Rx IPv6 Header Errors Register */
#define REG_EMAC0_RXIPV6_NOPAY_OCT      0xFFC2026C         /* EMAC0 Rx IPv6 No Payload Octets Register */
#define REG_EMAC0_RXUDP_GD_OCT          0xFFC20270         /* EMAC0 Rx UDP Good Octets Register */
#define REG_EMAC0_RXUDP_ERR_OCT         0xFFC20274         /* EMAC0 Rx UDP Error Octets Register */
#define REG_EMAC0_RXTCP_GD_OCT          0xFFC20278         /* EMAC0 Rx TCP Good Octets Register */
#define REG_EMAC0_RXTCP_ERR_OCT         0xFFC2027C         /* EMAC0 Rx TCP Error Octets Register */
#define REG_EMAC0_RXICMP_GD_OCT         0xFFC20280         /* EMAC0 Rx ICMP Good Octets Register */
#define REG_EMAC0_RXICMP_ERR_OCT        0xFFC20284         /* EMAC0 Rx ICMP Error Octets Register */
#define REG_EMAC0_TM_CTL                0xFFC20700         /* EMAC0 Time Stamp Control Register */
#define REG_EMAC0_TM_SUBSEC             0xFFC20704         /* EMAC0 Time Stamp Sub Second Increment Register */
#define REG_EMAC0_TM_SEC                0xFFC20708         /* EMAC0 Time Stamp Low Seconds Register */
#define REG_EMAC0_TM_NSEC               0xFFC2070C         /* EMAC0 Time Stamp Nano Seconds Register */
#define REG_EMAC0_TM_SECUPDT            0xFFC20710         /* EMAC0 Time Stamp Seconds Update Register */
#define REG_EMAC0_TM_NSECUPDT           0xFFC20714         /* EMAC0 Time Stamp Nano Seconds Update Register */
#define REG_EMAC0_TM_ADDEND             0xFFC20718         /* EMAC0 Time Stamp Addend Register */
#define REG_EMAC0_TM_TGTM               0xFFC2071C         /* EMAC0 Time Stamp Target Time Seconds Register */
#define REG_EMAC0_TM_NTGTM              0xFFC20720         /* EMAC0 Time Stamp Target Time Nano Seconds Register */
#define REG_EMAC0_TM_HISEC              0xFFC20724         /* EMAC0 Time Stamp High Second Register */
#define REG_EMAC0_TM_STMPSTAT           0xFFC20728         /* EMAC0 Time Stamp Status Register */
#define REG_EMAC0_TM_PPSCTL             0xFFC2072C         /* EMAC0 PPS Control Register */
#define REG_EMAC0_TM_AUXSTMP_NSEC       0xFFC20730         /* EMAC0 Time Stamp Auxilary TS Nano Seconds Register */
#define REG_EMAC0_TM_AUXSTMP_SEC        0xFFC20734         /* EMAC0 Time Stamp Auxilary TM Seconds Register */
#define REG_EMAC0_TM_PPSINTVL           0xFFC20760         /* EMAC0 Time Stamp PPS Interval Register */
#define REG_EMAC0_TM_PPSWIDTH           0xFFC20764         /* EMAC0 PPS Width Register */
#define REG_EMAC0_DMA_BUSMODE           0xFFC21000         /* EMAC0 DMA Bus Mode Register */
#define REG_EMAC0_DMA_TXPOLL            0xFFC21004         /* EMAC0 DMA Tx Poll Demand Register */
#define REG_EMAC0_DMA_RXPOLL            0xFFC21008         /* EMAC0 DMA Rx Poll Demand register */
#define REG_EMAC0_DMA_RXDSC_ADDR        0xFFC2100C         /* EMAC0 DMA Rx Descriptor List Address Register */
#define REG_EMAC0_DMA_TXDSC_ADDR        0xFFC21010         /* EMAC0 DMA Tx Descriptor List Address Register */
#define REG_EMAC0_DMA_STAT              0xFFC21014         /* EMAC0 DMA Status Register */
#define REG_EMAC0_DMA_OPMODE            0xFFC21018         /* EMAC0 DMA Operation Mode Register */
#define REG_EMAC0_DMA_IEN               0xFFC2101C         /* EMAC0 DMA Interrupt Enable Register */
#define REG_EMAC0_DMA_MISS_FRM          0xFFC21020         /* EMAC0 DMA Missed Frame Register */
#define REG_EMAC0_DMA_RXIWDOG           0xFFC21024         /* EMAC0 DMA Rx Interrupt Watch Dog Register */
#define REG_EMAC0_DMA_BMMODE            0xFFC21028         /* EMAC0 DMA SCB Bus Mode Register */
#define REG_EMAC0_DMA_BMSTAT            0xFFC2102C         /* EMAC0 DMA SCB Status Register */
#define REG_EMAC0_DMA_TXDSC_CUR         0xFFC21048         /* EMAC0 DMA Tx Descriptor Current Register */
#define REG_EMAC0_DMA_RXDSC_CUR         0xFFC2104C         /* EMAC0 DMA Rx Descriptor Current Register */
#define REG_EMAC0_DMA_TXBUF_CUR         0xFFC21050         /* EMAC0 DMA Tx Buffer Current Register */
#define REG_EMAC0_DMA_RXBUF_CUR         0xFFC21054         /* EMAC0 DMA Rx Buffer Current Register */

/* =========================
        EMAC1
   ========================= */
#define REG_EMAC1_MACCFG                0xFFC22000         /* EMAC1 MAC Configuration Register */
#define REG_EMAC1_MACFRMFILT            0xFFC22004         /* EMAC1 MAC Rx Frame Filter Register */
#define REG_EMAC1_HASHTBL_HI            0xFFC22008         /* EMAC1 Hash Table High Register */
#define REG_EMAC1_HASHTBL_LO            0xFFC2200C         /* EMAC1 Hash Table Low Register */
#define REG_EMAC1_SMI_ADDR              0xFFC22010         /* EMAC1 SMI Address Register */
#define REG_EMAC1_SMI_DATA              0xFFC22014         /* EMAC1 SMI Data Register */
#define REG_EMAC1_FLOWCTL               0xFFC22018         /* EMAC1 FLow Control Register */
#define REG_EMAC1_VLANTAG               0xFFC2201C         /* EMAC1 VLAN Tag Register */
#define REG_EMAC1_DBG                   0xFFC22024         /* EMAC1 Debug Register */
#define REG_EMAC1_ISTAT                 0xFFC22038         /* EMAC1 Interrupt Status Register */
#define REG_EMAC1_IMSK                  0xFFC2203C         /* EMAC1 Interrupt Mask Register */
#define REG_EMAC1_ADDR0_HI              0xFFC22040         /* EMAC1 MAC Address 0 High Register */
#define REG_EMAC1_ADDR0_LO              0xFFC22044         /* EMAC1 MAC Address 0 Low Register */
#define REG_EMAC1_MMC_CTL               0xFFC22100         /* EMAC1 MMC Control Register */
#define REG_EMAC1_MMC_RXINT             0xFFC22104         /* EMAC1 MMC Rx Interrupt Register */
#define REG_EMAC1_MMC_TXINT             0xFFC22108         /* EMAC1 MMC Tx Interrupt Register */
#define REG_EMAC1_MMC_RXIMSK            0xFFC2210C         /* EMAC1 MMC Rx Interrupt Mask Register */
#define REG_EMAC1_MMC_TXIMSK            0xFFC22110         /* EMAC1 MMC TX Interrupt Mask Register */
#define REG_EMAC1_TXOCTCNT_GB           0xFFC22114         /* EMAC1 Tx OCT Count (Good/Bad) Register */
#define REG_EMAC1_TXFRMCNT_GB           0xFFC22118         /* EMAC1 Tx Frame Count (Good/Bad) Register */
#define REG_EMAC1_TXBCASTFRM_G          0xFFC2211C         /* EMAC1 Tx Broadcast Frames (Good) Register */
#define REG_EMAC1_TXMCASTFRM_G          0xFFC22120         /* EMAC1 Tx Multicast Frames (Good) Register */
#define REG_EMAC1_TX64_GB               0xFFC22124         /* EMAC1 Tx 64-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_TX65TO127_GB          0xFFC22128         /* EMAC1 Tx 65- to 127-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_TX128TO255_GB         0xFFC2212C         /* EMAC1 Tx 128- to 255-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_TX256TO511_GB         0xFFC22130         /* EMAC1 Tx 256- to 511-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_TX512TO1023_GB        0xFFC22134         /* EMAC1 Tx 512- to 1023-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_TX1024TOMAX_GB        0xFFC22138         /* EMAC1 Tx 1024- to Max-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_TXUCASTFRM_GB         0xFFC2213C         /* EMAC1 Tx Unicast Frames (Good/Bad) Register */
#define REG_EMAC1_TXMCASTFRM_GB         0xFFC22140         /* EMAC1 Tx Multicast Frames (Good/Bad) Register */
#define REG_EMAC1_TXBCASTFRM_GB         0xFFC22144         /* EMAC1 Tx Broadcast Frames (Good/Bad) Register */
#define REG_EMAC1_TXUNDR_ERR            0xFFC22148         /* EMAC1 Tx Underflow Error Register */
#define REG_EMAC1_TXSNGCOL_G            0xFFC2214C         /* EMAC1 Tx Single Collision (Good) Register */
#define REG_EMAC1_TXMULTCOL_G           0xFFC22150         /* EMAC1 Tx Multiple Collision (Good) Register */
#define REG_EMAC1_TXDEFERRED            0xFFC22154         /* EMAC1 Tx Deferred Register */
#define REG_EMAC1_TXLATECOL             0xFFC22158         /* EMAC1 Tx Late Collision Register */
#define REG_EMAC1_TXEXCESSCOL           0xFFC2215C         /* EMAC1 Tx Excess Collision Register */
#define REG_EMAC1_TXCARR_ERR            0xFFC22160         /* EMAC1 Tx Carrier Error Register */
#define REG_EMAC1_TXOCTCNT_G            0xFFC22164         /* EMAC1 Tx Octet Count (Good) Register */
#define REG_EMAC1_TXFRMCNT_G            0xFFC22168         /* EMAC1 Tx Frame Count (Good) Register */
#define REG_EMAC1_TXEXCESSDEF           0xFFC2216C         /* EMAC1 Tx Excess Deferral Register */
#define REG_EMAC1_TXPAUSEFRM            0xFFC22170         /* EMAC1 Tx Pause Frame Register */
#define REG_EMAC1_TXVLANFRM_G           0xFFC22174         /* EMAC1 Tx VLAN Frames (Good) Register */
#define REG_EMAC1_RXFRMCNT_GB           0xFFC22180         /* EMAC1 Rx Frame Count (Good/Bad) Register */
#define REG_EMAC1_RXOCTCNT_GB           0xFFC22184         /* EMAC1 Rx Octet Count (Good/Bad) Register */
#define REG_EMAC1_RXOCTCNT_G            0xFFC22188         /* EMAC1 Rx Octet Count (Good) Register */
#define REG_EMAC1_RXBCASTFRM_G          0xFFC2218C         /* EMAC1 Rx Broadcast Frames (Good) Register */
#define REG_EMAC1_RXMCASTFRM_G          0xFFC22190         /* EMAC1 Rx Multicast Frames (Good) Register */
#define REG_EMAC1_RXCRC_ERR             0xFFC22194         /* EMAC1 Rx CRC Error Register */
#define REG_EMAC1_RXALIGN_ERR           0xFFC22198         /* EMAC1 Rx alignment Error Register */
#define REG_EMAC1_RXRUNT_ERR            0xFFC2219C         /* EMAC1 Rx Runt Error Register */
#define REG_EMAC1_RXJAB_ERR             0xFFC221A0         /* EMAC1 Rx Jab Error Register */
#define REG_EMAC1_RXUSIZE_G             0xFFC221A4         /* EMAC1 Rx Undersize (Good) Register */
#define REG_EMAC1_RXOSIZE_G             0xFFC221A8         /* EMAC1 Rx Oversize (Good) Register */
#define REG_EMAC1_RX64_GB               0xFFC221AC         /* EMAC1 Rx 64-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_RX65TO127_GB          0xFFC221B0         /* EMAC1 Rx 65- to 127-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_RX128TO255_GB         0xFFC221B4         /* EMAC1 Rx 128- to 255-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_RX256TO511_GB         0xFFC221B8         /* EMAC1 Rx 256- to 511-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_RX512TO1023_GB        0xFFC221BC         /* EMAC1 Rx 512- to 1023-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_RX1024TOMAX_GB        0xFFC221C0         /* EMAC1 Rx 1024- to Max-Byte Frames (Good/Bad) Register */
#define REG_EMAC1_RXUCASTFRM_G          0xFFC221C4         /* EMAC1 Rx Unicast Frames (Good) Register */
#define REG_EMAC1_RXLEN_ERR             0xFFC221C8         /* EMAC1 Rx Length Error Register */
#define REG_EMAC1_RXOORTYPE             0xFFC221CC         /* EMAC1 Rx Out Of Range Type Register */
#define REG_EMAC1_RXPAUSEFRM            0xFFC221D0         /* EMAC1 Rx Pause Frames Register */
#define REG_EMAC1_RXFIFO_OVF            0xFFC221D4         /* EMAC1 Rx FIFO Overflow Register */
#define REG_EMAC1_RXVLANFRM_GB          0xFFC221D8         /* EMAC1 Rx VLAN Frames (Good/Bad) Register */
#define REG_EMAC1_RXWDOG_ERR            0xFFC221DC         /* EMAC1 Rx Watch Dog Error Register */
#define REG_EMAC1_IPC_RXIMSK            0xFFC22200         /* EMAC1 MMC IPC Rx Interrupt Mask Register */
#define REG_EMAC1_IPC_RXINT             0xFFC22208         /* EMAC1 MMC IPC Rx Interrupt Register */
#define REG_EMAC1_RXIPV4_GD_FRM         0xFFC22210         /* EMAC1 Rx IPv4 Datagrams (Good) Register */
#define REG_EMAC1_RXIPV4_HDR_ERR_FRM    0xFFC22214         /* EMAC1 Rx IPv4 Datagrams Header Errors Register */
#define REG_EMAC1_RXIPV4_NOPAY_FRM      0xFFC22218         /* EMAC1 Rx IPv4 Datagrams No Payload Frame Register */
#define REG_EMAC1_RXIPV4_FRAG_FRM       0xFFC2221C         /* EMAC1 Rx IPv4 Datagrams Fragmented Frames Register */
#define REG_EMAC1_RXIPV4_UDSBL_FRM      0xFFC22220         /* EMAC1 Rx IPv4 UDP Disabled Frames Register */
#define REG_EMAC1_RXIPV6_GD_FRM         0xFFC22224         /* EMAC1 Rx IPv6 Datagrams Good Frames Register */
#define REG_EMAC1_RXIPV6_HDR_ERR_FRM    0xFFC22228         /* EMAC1 Rx IPv6 Datagrams Header Error Frames Register */
#define REG_EMAC1_RXIPV6_NOPAY_FRM      0xFFC2222C         /* EMAC1 Rx IPv6 Datagrams No Payload Frames Register */
#define REG_EMAC1_RXUDP_GD_FRM          0xFFC22230         /* EMAC1 Rx UDP Good Frames Register */
#define REG_EMAC1_RXUDP_ERR_FRM         0xFFC22234         /* EMAC1 Rx UDP Error Frames Register */
#define REG_EMAC1_RXTCP_GD_FRM          0xFFC22238         /* EMAC1 Rx TCP Good Frames Register */
#define REG_EMAC1_RXTCP_ERR_FRM         0xFFC2223C         /* EMAC1 Rx TCP Error Frames Register */
#define REG_EMAC1_RXICMP_GD_FRM         0xFFC22240         /* EMAC1 Rx ICMP Good Frames Register */
#define REG_EMAC1_RXICMP_ERR_FRM        0xFFC22244         /* EMAC1 Rx ICMP Error Frames Register */
#define REG_EMAC1_RXIPV4_GD_OCT         0xFFC22250         /* EMAC1 Rx IPv4 Datagrams Good Octets Register */
#define REG_EMAC1_RXIPV4_HDR_ERR_OCT    0xFFC22254         /* EMAC1 Rx IPv4 Datagrams Header Errors Register */
#define REG_EMAC1_RXIPV4_NOPAY_OCT      0xFFC22258         /* EMAC1 Rx IPv4 Datagrams No Payload Octets Register */
#define REG_EMAC1_RXIPV4_FRAG_OCT       0xFFC2225C         /* EMAC1 Rx IPv4 Datagrams Fragmented Octets Register */
#define REG_EMAC1_RXIPV4_UDSBL_OCT      0xFFC22260         /* EMAC1 Rx IPv4 UDP Disabled Octets Register */
#define REG_EMAC1_RXIPV6_GD_OCT         0xFFC22264         /* EMAC1 Rx IPv6 Good Octets Register */
#define REG_EMAC1_RXIPV6_HDR_ERR_OCT    0xFFC22268         /* EMAC1 Rx IPv6 Header Errors Register */
#define REG_EMAC1_RXIPV6_NOPAY_OCT      0xFFC2226C         /* EMAC1 Rx IPv6 No Payload Octets Register */
#define REG_EMAC1_RXUDP_GD_OCT          0xFFC22270         /* EMAC1 Rx UDP Good Octets Register */
#define REG_EMAC1_RXUDP_ERR_OCT         0xFFC22274         /* EMAC1 Rx UDP Error Octets Register */
#define REG_EMAC1_RXTCP_GD_OCT          0xFFC22278         /* EMAC1 Rx TCP Good Octets Register */
#define REG_EMAC1_RXTCP_ERR_OCT         0xFFC2227C         /* EMAC1 Rx TCP Error Octets Register */
#define REG_EMAC1_RXICMP_GD_OCT         0xFFC22280         /* EMAC1 Rx ICMP Good Octets Register */
#define REG_EMAC1_RXICMP_ERR_OCT        0xFFC22284         /* EMAC1 Rx ICMP Error Octets Register */
#define REG_EMAC1_TM_CTL                0xFFC22700         /* EMAC1 Time Stamp Control Register */
#define REG_EMAC1_TM_SUBSEC             0xFFC22704         /* EMAC1 Time Stamp Sub Second Increment Register */
#define REG_EMAC1_TM_SEC                0xFFC22708         /* EMAC1 Time Stamp Low Seconds Register */
#define REG_EMAC1_TM_NSEC               0xFFC2270C         /* EMAC1 Time Stamp Nano Seconds Register */
#define REG_EMAC1_TM_SECUPDT            0xFFC22710         /* EMAC1 Time Stamp Seconds Update Register */
#define REG_EMAC1_TM_NSECUPDT           0xFFC22714         /* EMAC1 Time Stamp Nano Seconds Update Register */
#define REG_EMAC1_TM_ADDEND             0xFFC22718         /* EMAC1 Time Stamp Addend Register */
#define REG_EMAC1_TM_TGTM               0xFFC2271C         /* EMAC1 Time Stamp Target Time Seconds Register */
#define REG_EMAC1_TM_NTGTM              0xFFC22720         /* EMAC1 Time Stamp Target Time Nano Seconds Register */
#define REG_EMAC1_TM_HISEC              0xFFC22724         /* EMAC1 Time Stamp High Second Register */
#define REG_EMAC1_TM_STMPSTAT           0xFFC22728         /* EMAC1 Time Stamp Status Register */
#define REG_EMAC1_TM_PPSCTL             0xFFC2272C         /* EMAC1 PPS Control Register */
#define REG_EMAC1_TM_AUXSTMP_NSEC       0xFFC22730         /* EMAC1 Time Stamp Auxilary TS Nano Seconds Register */
#define REG_EMAC1_TM_AUXSTMP_SEC        0xFFC22734         /* EMAC1 Time Stamp Auxilary TM Seconds Register */
#define REG_EMAC1_TM_PPSINTVL           0xFFC22760         /* EMAC1 Time Stamp PPS Interval Register */
#define REG_EMAC1_TM_PPSWIDTH           0xFFC22764         /* EMAC1 PPS Width Register */
#define REG_EMAC1_DMA_BUSMODE           0xFFC23000         /* EMAC1 DMA Bus Mode Register */
#define REG_EMAC1_DMA_TXPOLL            0xFFC23004         /* EMAC1 DMA Tx Poll Demand Register */
#define REG_EMAC1_DMA_RXPOLL            0xFFC23008         /* EMAC1 DMA Rx Poll Demand register */
#define REG_EMAC1_DMA_RXDSC_ADDR        0xFFC2300C         /* EMAC1 DMA Rx Descriptor List Address Register */
#define REG_EMAC1_DMA_TXDSC_ADDR        0xFFC23010         /* EMAC1 DMA Tx Descriptor List Address Register */
#define REG_EMAC1_DMA_STAT              0xFFC23014         /* EMAC1 DMA Status Register */
#define REG_EMAC1_DMA_OPMODE            0xFFC23018         /* EMAC1 DMA Operation Mode Register */
#define REG_EMAC1_DMA_IEN               0xFFC2301C         /* EMAC1 DMA Interrupt Enable Register */
#define REG_EMAC1_DMA_MISS_FRM          0xFFC23020         /* EMAC1 DMA Missed Frame Register */
#define REG_EMAC1_DMA_RXIWDOG           0xFFC23024         /* EMAC1 DMA Rx Interrupt Watch Dog Register */
#define REG_EMAC1_DMA_BMMODE            0xFFC23028         /* EMAC1 DMA SCB Bus Mode Register */
#define REG_EMAC1_DMA_BMSTAT            0xFFC2302C         /* EMAC1 DMA SCB Status Register */
#define REG_EMAC1_DMA_TXDSC_CUR         0xFFC23048         /* EMAC1 DMA Tx Descriptor Current Register */
#define REG_EMAC1_DMA_RXDSC_CUR         0xFFC2304C         /* EMAC1 DMA Rx Descriptor Current Register */
#define REG_EMAC1_DMA_TXBUF_CUR         0xFFC23050         /* EMAC1 DMA Tx Buffer Current Register */
#define REG_EMAC1_DMA_RXBUF_CUR         0xFFC23054         /* EMAC1 DMA Rx Buffer Current Register */

/* =========================
        EMAC
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_MACCFG                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_MACCFG_CST                 25                               /* CRC Stripping */
#define BITP_EMAC_MACCFG_WD                  23                               /* Watch Dog Disable */
#define BITP_EMAC_MACCFG_JB                  22                               /* Jabber Disable */
#define BITP_EMAC_MACCFG_JE                  20                               /* Jumbo Frame Enable */
#define BITP_EMAC_MACCFG_IFG                 17                               /* Inter Frame Gap */
#define BITP_EMAC_MACCFG_DCRS                16                               /* Disable Carrier Sense */
#define BITP_EMAC_MACCFG_FES                 14                               /* Speed of Operation */
#define BITP_EMAC_MACCFG_DO                  13                               /* Disable Receive Own */
#define BITP_EMAC_MACCFG_LM                  12                               /* Loopback Mode */
#define BITP_EMAC_MACCFG_DM                  11                               /* Duplex Mode */
#define BITP_EMAC_MACCFG_IPC                 10                               /* IP Checksum */
#define BITP_EMAC_MACCFG_DR                   9                               /* Disable Retry */
#define BITP_EMAC_MACCFG_ACS                  7                               /* Automatic Pad/CRC Stripping */
#define BITP_EMAC_MACCFG_BL                   5                               /* Back Off Limit */
#define BITP_EMAC_MACCFG_DC                   4                               /* Deferral Check */
#define BITP_EMAC_MACCFG_TE                   3                               /* Transmitter Enable */
#define BITP_EMAC_MACCFG_RE                   2                               /* Receiver Enable */
#define BITM_EMAC_MACCFG_CST                 (_ADI_MSK(0x02000000,uint32_t))  /* CRC Stripping */
#define BITM_EMAC_MACCFG_WD                  (_ADI_MSK(0x00800000,uint32_t))  /* Watch Dog Disable */
#define BITM_EMAC_MACCFG_JB                  (_ADI_MSK(0x00400000,uint32_t))  /* Jabber Disable */
#define BITM_EMAC_MACCFG_JE                  (_ADI_MSK(0x00100000,uint32_t))  /* Jumbo Frame Enable */

#define BITM_EMAC_MACCFG_IFG                 (_ADI_MSK(0x000E0000,uint32_t))  /* Inter Frame Gap */
#define ENUM_EMAC_MACCFG_BIT_TIMES_96        (_ADI_MSK(0x00000000,uint32_t))  /* IFG: 96 bit times */
#define ENUM_EMAC_MACCFG_BIT_TIMES_88        (_ADI_MSK(0x00020000,uint32_t))  /* IFG: 88 bit times */
#define ENUM_EMAC_MACCFG_BIT_TIMES_80        (_ADI_MSK(0x00040000,uint32_t))  /* IFG: 80 bit times */
#define ENUM_EMAC_MACCFG_BIT_TIMES_72        (_ADI_MSK(0x00060000,uint32_t))  /* IFG: 72 bit times */
#define ENUM_EMAC_MACCFG_BIT_TIMES_64        (_ADI_MSK(0x00080000,uint32_t))  /* IFG: 64 bit times */
#define ENUM_EMAC_MACCFG_BIT_TIMES_56        (_ADI_MSK(0x000A0000,uint32_t))  /* IFG: 56 bit times */
#define ENUM_EMAC_MACCFG_BIT_TIMES_48        (_ADI_MSK(0x000C0000,uint32_t))  /* IFG: 48 bit times */
#define ENUM_EMAC_MACCFG_BIT_TIMES_40        (_ADI_MSK(0x000E0000,uint32_t))  /* IFG: 40 bit times */
#define BITM_EMAC_MACCFG_DCRS                (_ADI_MSK(0x00010000,uint32_t))  /* Disable Carrier Sense */
#define BITM_EMAC_MACCFG_FES                 (_ADI_MSK(0x00004000,uint32_t))  /* Speed of Operation */
#define BITM_EMAC_MACCFG_DO                  (_ADI_MSK(0x00002000,uint32_t))  /* Disable Receive Own */
#define BITM_EMAC_MACCFG_LM                  (_ADI_MSK(0x00001000,uint32_t))  /* Loopback Mode */
#define BITM_EMAC_MACCFG_DM                  (_ADI_MSK(0x00000800,uint32_t))  /* Duplex Mode */
#define BITM_EMAC_MACCFG_IPC                 (_ADI_MSK(0x00000400,uint32_t))  /* IP Checksum */

#define BITM_EMAC_MACCFG_DR                  (_ADI_MSK(0x00000200,uint32_t))  /* Disable Retry */
#define ENUM_EMAC_MACCFG_RETRY_ENABLED       (_ADI_MSK(0x00000000,uint32_t))  /* DR: Retry enabled */
#define ENUM_EMAC_MACCFG_RETRY_DISABLED      (_ADI_MSK(0x00000200,uint32_t))  /* DR: Retry disabled */
#define BITM_EMAC_MACCFG_ACS                 (_ADI_MSK(0x00000080,uint32_t))  /* Automatic Pad/CRC Stripping */

#define BITM_EMAC_MACCFG_BL                  (_ADI_MSK(0x00000060,uint32_t))  /* Back Off Limit */
#define ENUM_EMAC_MACCFG_BL_10               (_ADI_MSK(0x00000000,uint32_t))  /* BL: k = min (n, 10) */
#define ENUM_EMAC_MACCFG_BL_8                (_ADI_MSK(0x00000020,uint32_t))  /* BL: k = min (n, 8) */
#define ENUM_EMAC_MACCFG_BL_4                (_ADI_MSK(0x00000040,uint32_t))  /* BL: k = min (n, 4) */
#define ENUM_EMAC_MACCFG_BL_1                (_ADI_MSK(0x00000060,uint32_t))  /* BL: k = min (n, 1) */
#define BITM_EMAC_MACCFG_DC                  (_ADI_MSK(0x00000010,uint32_t))  /* Deferral Check */
#define BITM_EMAC_MACCFG_TE                  (_ADI_MSK(0x00000008,uint32_t))  /* Transmitter Enable */
#define BITM_EMAC_MACCFG_RE                  (_ADI_MSK(0x00000004,uint32_t))  /* Receiver Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_MACFRMFILT                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_MACFRMFILT_RA              31                               /* Receive All Frames */
#define BITP_EMAC_MACFRMFILT_HPF             10                               /* Hash or Perfect Filter */
#define BITP_EMAC_MACFRMFILT_PCF              6                               /* Pass Control Frames */
#define BITP_EMAC_MACFRMFILT_DBF              5                               /* Disable Broadcast Frames */
#define BITP_EMAC_MACFRMFILT_PM               4                               /* Pass All Multicast Frames */
#define BITP_EMAC_MACFRMFILT_DAIF             3                               /* Destination Address Inverse Filtering */
#define BITP_EMAC_MACFRMFILT_HMC              2                               /* Hash Multicast */
#define BITP_EMAC_MACFRMFILT_HUC              1                               /* Hash Unicast */
#define BITP_EMAC_MACFRMFILT_PR               0                               /* Promiscuous Mode */
#define BITM_EMAC_MACFRMFILT_RA              (_ADI_MSK(0x80000000,uint32_t))  /* Receive All Frames */
#define BITM_EMAC_MACFRMFILT_HPF             (_ADI_MSK(0x00000400,uint32_t))  /* Hash or Perfect Filter */

#define BITM_EMAC_MACFRMFILT_PCF             (_ADI_MSK(0x000000C0,uint32_t))  /* Pass Control Frames */
#define ENUM_EMAC_MACFRMFILT_FILT_ALL        (_ADI_MSK(0x00000000,uint32_t))  /* PCF: Pass no control frames */
#define ENUM_EMAC_MACFRMFILT_NO_PAUSE        (_ADI_MSK(0x00000040,uint32_t))  /* PCF: Pass no PAUSE frames */
#define ENUM_EMAC_MACFRMFILT_FWD_ALL         (_ADI_MSK(0x00000080,uint32_t))  /* PCF: Pass all control frames */
#define ENUM_EMAC_MACFRMFILT_PADR_FILT       (_ADI_MSK(0x000000C0,uint32_t))  /* PCF: Pass address filtered control frames */

#define BITM_EMAC_MACFRMFILT_DBF             (_ADI_MSK(0x00000020,uint32_t))  /* Disable Broadcast Frames */
#define ENUM_EMAC_MACFRMFILT_DIS_BCAST       (_ADI_MSK(0x00000000,uint32_t))  /* DBF: AFM module passes all received broadcast frames */
#define ENUM_EMAC_MACFRMFILT_EN_BCAST        (_ADI_MSK(0x00000020,uint32_t))  /* DBF: AFM module filters all incoming broadcast frames */
#define BITM_EMAC_MACFRMFILT_PM              (_ADI_MSK(0x00000010,uint32_t))  /* Pass All Multicast Frames */
#define BITM_EMAC_MACFRMFILT_DAIF            (_ADI_MSK(0x00000008,uint32_t))  /* Destination Address Inverse Filtering */
#define BITM_EMAC_MACFRMFILT_HMC             (_ADI_MSK(0x00000004,uint32_t))  /* Hash Multicast */
#define BITM_EMAC_MACFRMFILT_HUC             (_ADI_MSK(0x00000002,uint32_t))  /* Hash Unicast */
#define BITM_EMAC_MACFRMFILT_PR              (_ADI_MSK(0x00000001,uint32_t))  /* Promiscuous Mode */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_SMI_ADDR                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_SMI_ADDR_PA                11                               /* Physical Layer Address */
#define BITP_EMAC_SMI_ADDR_SMIR               6                               /* SMI Register Address */
#define BITP_EMAC_SMI_ADDR_CR                 2                               /* Clock Range */
#define BITP_EMAC_SMI_ADDR_SMIW               1                               /* SMI Write */
#define BITP_EMAC_SMI_ADDR_SMIB               0                               /* SMI Busy */
#define BITM_EMAC_SMI_ADDR_PA                (_ADI_MSK(0x0000F800,uint32_t))  /* Physical Layer Address */
#define BITM_EMAC_SMI_ADDR_SMIR              (_ADI_MSK(0x000007C0,uint32_t))  /* SMI Register Address */
#define BITM_EMAC_SMI_ADDR_CR                (_ADI_MSK(0x0000003C,uint32_t))  /* Clock Range */
#define BITM_EMAC_SMI_ADDR_SMIW              (_ADI_MSK(0x00000002,uint32_t))  /* SMI Write */
#define BITM_EMAC_SMI_ADDR_SMIB              (_ADI_MSK(0x00000001,uint32_t))  /* SMI Busy */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_SMI_DATA                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_SMI_DATA_SMID               0                               /* SMI Data */
#define BITM_EMAC_SMI_DATA_SMID              (_ADI_MSK(0x0000FFFF,uint32_t))  /* SMI Data */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_FLOWCTL                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_FLOWCTL_PT                 16                               /* Pause Time */
#define BITP_EMAC_FLOWCTL_UP                  3                               /* Unicast Pause Frame Detect */
#define BITP_EMAC_FLOWCTL_RFE                 2                               /* Receive Flow Control Enable */
#define BITP_EMAC_FLOWCTL_TFE                 1                               /* Transmit Flow Control Enable */
#define BITP_EMAC_FLOWCTL_FCBBPA              0                               /* Initiate Pause Control Frame */
#define BITM_EMAC_FLOWCTL_PT                 (_ADI_MSK(0xFFFF0000,uint32_t))  /* Pause Time */
#define BITM_EMAC_FLOWCTL_UP                 (_ADI_MSK(0x00000008,uint32_t))  /* Unicast Pause Frame Detect */
#define BITM_EMAC_FLOWCTL_RFE                (_ADI_MSK(0x00000004,uint32_t))  /* Receive Flow Control Enable */
#define BITM_EMAC_FLOWCTL_TFE                (_ADI_MSK(0x00000002,uint32_t))  /* Transmit Flow Control Enable */
#define BITM_EMAC_FLOWCTL_FCBBPA             (_ADI_MSK(0x00000001,uint32_t))  /* Initiate Pause Control Frame */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_VLANTAG                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_VLANTAG_ETV                16                               /* Enable Tag VLAN Comparison */
#define BITP_EMAC_VLANTAG_VL                  0                               /* VLAN Tag Id Receive Frames */
#define BITM_EMAC_VLANTAG_ETV                (_ADI_MSK(0x00010000,uint32_t))  /* Enable Tag VLAN Comparison */
#define BITM_EMAC_VLANTAG_VL                 (_ADI_MSK(0x0000FFFF,uint32_t))  /* VLAN Tag Id Receive Frames */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DBG                             Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DBG_TXFIFOFULL             25                               /* Tx FIFO Full */
#define BITP_EMAC_DBG_TXFIFONE               24                               /* Tx FIFO Not Empty */
#define BITP_EMAC_DBG_TXFIFOACT              22                               /* Tx FIFO Active */
#define BITP_EMAC_DBG_TXFIFOCTLST            20                               /* Tx FIFO Controller State */
#define BITP_EMAC_DBG_TXPAUSE                19                               /* Tx Paused */
#define BITP_EMAC_DBG_TXFRCTL                17                               /* Tx Frame Controller State */
#define BITP_EMAC_DBG_MMTEA                  16                               /* MM Tx Engine Active */
#define BITP_EMAC_DBG_RXFIFOST                8                               /* Rx FIFO State */
#define BITP_EMAC_DBG_RXFIFOCTLST             5                               /* Rx FIFO Controller State */
#define BITP_EMAC_DBG_RXFIFOACT               4                               /* Rx FIFO Active */
#define BITP_EMAC_DBG_SFIFOST                 1                               /* Small FIFO State */
#define BITP_EMAC_DBG_MMREA                   0                               /* MM Rx Engine Active */
#define BITM_EMAC_DBG_TXFIFOFULL             (_ADI_MSK(0x02000000,uint32_t))  /* Tx FIFO Full */
#define BITM_EMAC_DBG_TXFIFONE               (_ADI_MSK(0x01000000,uint32_t))  /* Tx FIFO Not Empty */
#define BITM_EMAC_DBG_TXFIFOACT              (_ADI_MSK(0x00400000,uint32_t))  /* Tx FIFO Active */
#define BITM_EMAC_DBG_TXFIFOCTLST            (_ADI_MSK(0x00300000,uint32_t))  /* Tx FIFO Controller State */
#define BITM_EMAC_DBG_TXPAUSE                (_ADI_MSK(0x00080000,uint32_t))  /* Tx Paused */

#define BITM_EMAC_DBG_TXFRCTL                (_ADI_MSK(0x00060000,uint32_t))  /* Tx Frame Controller State */
#define ENUM_EMAC_DBG_TXFRCTL_IDLE           (_ADI_MSK(0x00000000,uint32_t))  /* TXFRCTL: Idle */
#define ENUM_EMAC_DBG_TXFRCTL_WT_STATUS      (_ADI_MSK(0x00020000,uint32_t))  /* TXFRCTL: Wait */
#define ENUM_EMAC_DBG_TXFRCTL_PAUSE          (_ADI_MSK(0x00040000,uint32_t))  /* TXFRCTL: Pause */
#define ENUM_EMAC_DBG_TXFRCTL_TXFRAME        (_ADI_MSK(0x00060000,uint32_t))  /* TXFRCTL: Transmit */
#define BITM_EMAC_DBG_MMTEA                  (_ADI_MSK(0x00010000,uint32_t))  /* MM Tx Engine Active */

#define BITM_EMAC_DBG_RXFIFOST               (_ADI_MSK(0x00000300,uint32_t))  /* Rx FIFO State */
#define ENUM_EMAC_DBG_FIFO_EMPTY             (_ADI_MSK(0x00000000,uint32_t))  /* RXFIFOST: Rx FIFO Empty */
#define ENUM_EMAC_DBG_FIFO_BEL_THERSHLD      (_ADI_MSK(0x00000100,uint32_t))  /* RXFIFOST: Rx FIFO Below De-activate FCT */
#define ENUM_EMAC_DBG_FIFO_ABV_THERSHLD      (_ADI_MSK(0x00000200,uint32_t))  /* RXFIFOST: Rx FIFO Above De-activate FCT */
#define ENUM_EMAC_DBG_FIFO_FULL              (_ADI_MSK(0x00000300,uint32_t))  /* RXFIFOST: Rx FIFO Full */

#define BITM_EMAC_DBG_RXFIFOCTLST            (_ADI_MSK(0x00000060,uint32_t))  /* Rx FIFO Controller State */
#define ENUM_EMAC_DBG_IDLE_FIFO              (_ADI_MSK(0x00000000,uint32_t))  /* RXFIFOCTLST: Idle */
#define ENUM_EMAC_DBG_RD_DATA_FIFO           (_ADI_MSK(0x00000020,uint32_t))  /* RXFIFOCTLST: Read Data */
#define ENUM_EMAC_DBG_RD_STS_FIFO            (_ADI_MSK(0x00000040,uint32_t))  /* RXFIFOCTLST: Read Status */
#define ENUM_EMAC_DBG_FLUSH_FIFO             (_ADI_MSK(0x00000060,uint32_t))  /* RXFIFOCTLST: Flush */
#define BITM_EMAC_DBG_RXFIFOACT              (_ADI_MSK(0x00000010,uint32_t))  /* Rx FIFO Active */
#define BITM_EMAC_DBG_SFIFOST                (_ADI_MSK(0x00000006,uint32_t))  /* Small FIFO State */
#define BITM_EMAC_DBG_MMREA                  (_ADI_MSK(0x00000001,uint32_t))  /* MM Rx Engine Active */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_ISTAT                           Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_ISTAT_TS                    9                               /* Time Stamp Interrupt Status */
#define BITP_EMAC_ISTAT_MMCRC                 7                               /* MMC Receive Checksum Offload Interrupt Status */
#define BITP_EMAC_ISTAT_MMCTX                 6                               /* MMC Transmit Interrupt Status */
#define BITP_EMAC_ISTAT_MMCRX                 5                               /* MMC Receive Interrupt Status */
#define BITP_EMAC_ISTAT_MMC                   4                               /* MMC Interrupt Status */
#define BITM_EMAC_ISTAT_TS                   (_ADI_MSK(0x00000200,uint32_t))  /* Time Stamp Interrupt Status */
#define BITM_EMAC_ISTAT_MMCRC                (_ADI_MSK(0x00000080,uint32_t))  /* MMC Receive Checksum Offload Interrupt Status */
#define BITM_EMAC_ISTAT_MMCTX                (_ADI_MSK(0x00000040,uint32_t))  /* MMC Transmit Interrupt Status */
#define BITM_EMAC_ISTAT_MMCRX                (_ADI_MSK(0x00000020,uint32_t))  /* MMC Receive Interrupt Status */
#define BITM_EMAC_ISTAT_MMC                  (_ADI_MSK(0x00000010,uint32_t))  /* MMC Interrupt Status */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_IMSK                            Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_IMSK_TS                     9                               /* Time Stamp Interrupt Mask */
#define BITM_EMAC_IMSK_TS                    (_ADI_MSK(0x00000200,uint32_t))  /* Time Stamp Interrupt Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_ADDR0_HI                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_ADDR0_HI_ADDR               0                               /* Address */
#define BITM_EMAC_ADDR0_HI_ADDR              (_ADI_MSK(0x0000FFFF,uint32_t))  /* Address */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_MMC_CTL                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_MMC_CTL_FULLPSET            5                               /* Full Preset */
#define BITP_EMAC_MMC_CTL_CNTRPSET            4                               /* Counter Reset/Preset */
#define BITP_EMAC_MMC_CTL_CNTRFRZ             3                               /* Counter Freeze */
#define BITP_EMAC_MMC_CTL_RDRST               2                               /* Read Reset */
#define BITP_EMAC_MMC_CTL_NOROLL              1                               /* No Rollover */
#define BITP_EMAC_MMC_CTL_RST                 0                               /* Reset */
#define BITM_EMAC_MMC_CTL_FULLPSET           (_ADI_MSK(0x00000020,uint32_t))  /* Full Preset */
#define BITM_EMAC_MMC_CTL_CNTRPSET           (_ADI_MSK(0x00000010,uint32_t))  /* Counter Reset/Preset */
#define BITM_EMAC_MMC_CTL_CNTRFRZ            (_ADI_MSK(0x00000008,uint32_t))  /* Counter Freeze */
#define BITM_EMAC_MMC_CTL_RDRST              (_ADI_MSK(0x00000004,uint32_t))  /* Read Reset */
#define BITM_EMAC_MMC_CTL_NOROLL             (_ADI_MSK(0x00000002,uint32_t))  /* No Rollover */
#define BITM_EMAC_MMC_CTL_RST                (_ADI_MSK(0x00000001,uint32_t))  /* Reset */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_MMC_RXINT                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_MMC_RXINT_WDOGERR          23                               /* Rx Watch Dog Error Count Half/Full */
#define BITP_EMAC_MMC_RXINT_VLANFRGB         22                               /* Rx VLAN Frames (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_FIFOOVF          21                               /* Rx FIFO Overflow Count Half/Full */
#define BITP_EMAC_MMC_RXINT_PAUSEFR          20                               /* Rx Pause Frames Count Half/Full */
#define BITP_EMAC_MMC_RXINT_OUTRANGE         19                               /* Rx Out Of Range Type Count Half/Full */
#define BITP_EMAC_MMC_RXINT_LENERR           18                               /* Rx Length Error Count Half/Full */
#define BITP_EMAC_MMC_RXINT_UCASTG           17                               /* Rx Unicast Frames (Good) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_R1024TOMAX       16                               /* Rx 1024-to-max Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_R512TO1023       15                               /* Rx 512-to-1023 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_R256TO511        14                               /* Rx 255-to-511 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_R128TO255        13                               /* Rx 128-to-255 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_R65TO127         12                               /* Rx 65-to-127 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_R64              11                               /* Rx 64 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_OSIZEG           10                               /* Rx Oversize (Good) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_USIZEG            9                               /* Rx Undersize (Good) Count Half/Full */
#define BITP_EMAC_MMC_RXINT_JABERR            8                               /* Rx Jabber Error Count Half/Full */
#define BITP_EMAC_MMC_RXINT_RUNTERR           7                               /* Rx Runt Error Count Half/Full */
#define BITP_EMAC_MMC_RXINT_ALIGNERR          6                               /* Rx Alignment Error Count Half/Full */
#define BITP_EMAC_MMC_RXINT_CRCERR            5                               /* Rx CRC Error Counter Half/Full */
#define BITP_EMAC_MMC_RXINT_MCASTG            4                               /* Rx Multicast Count (Good) Half/Full */
#define BITP_EMAC_MMC_RXINT_BCASTG            3                               /* Rx Broadcast Count (Good) Half/Full */
#define BITP_EMAC_MMC_RXINT_OCTCNTG           2                               /* Octet Count (Good) Half/Full */
#define BITP_EMAC_MMC_RXINT_OCTCNTGB          1                               /* Octet Count (Good/Bad) Half/Full */
#define BITP_EMAC_MMC_RXINT_FRCNTGB           0                               /* Frame Count (Good/Bad) Half/Full */
#define BITM_EMAC_MMC_RXINT_WDOGERR          (_ADI_MSK(0x00800000,uint32_t))  /* Rx Watch Dog Error Count Half/Full */
#define BITM_EMAC_MMC_RXINT_VLANFRGB         (_ADI_MSK(0x00400000,uint32_t))  /* Rx VLAN Frames (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_FIFOOVF          (_ADI_MSK(0x00200000,uint32_t))  /* Rx FIFO Overflow Count Half/Full */
#define BITM_EMAC_MMC_RXINT_PAUSEFR          (_ADI_MSK(0x00100000,uint32_t))  /* Rx Pause Frames Count Half/Full */
#define BITM_EMAC_MMC_RXINT_OUTRANGE         (_ADI_MSK(0x00080000,uint32_t))  /* Rx Out Of Range Type Count Half/Full */
#define BITM_EMAC_MMC_RXINT_LENERR           (_ADI_MSK(0x00040000,uint32_t))  /* Rx Length Error Count Half/Full */
#define BITM_EMAC_MMC_RXINT_UCASTG           (_ADI_MSK(0x00020000,uint32_t))  /* Rx Unicast Frames (Good) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_R1024TOMAX       (_ADI_MSK(0x00010000,uint32_t))  /* Rx 1024-to-max Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_R512TO1023       (_ADI_MSK(0x00008000,uint32_t))  /* Rx 512-to-1023 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_R256TO511        (_ADI_MSK(0x00004000,uint32_t))  /* Rx 255-to-511 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_R128TO255        (_ADI_MSK(0x00002000,uint32_t))  /* Rx 128-to-255 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_R65TO127         (_ADI_MSK(0x00001000,uint32_t))  /* Rx 65-to-127 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_R64              (_ADI_MSK(0x00000800,uint32_t))  /* Rx 64 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_OSIZEG           (_ADI_MSK(0x00000400,uint32_t))  /* Rx Oversize (Good) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_USIZEG           (_ADI_MSK(0x00000200,uint32_t))  /* Rx Undersize (Good) Count Half/Full */
#define BITM_EMAC_MMC_RXINT_JABERR           (_ADI_MSK(0x00000100,uint32_t))  /* Rx Jabber Error Count Half/Full */
#define BITM_EMAC_MMC_RXINT_RUNTERR          (_ADI_MSK(0x00000080,uint32_t))  /* Rx Runt Error Count Half/Full */
#define BITM_EMAC_MMC_RXINT_ALIGNERR         (_ADI_MSK(0x00000040,uint32_t))  /* Rx Alignment Error Count Half/Full */
#define BITM_EMAC_MMC_RXINT_CRCERR           (_ADI_MSK(0x00000020,uint32_t))  /* Rx CRC Error Counter Half/Full */
#define BITM_EMAC_MMC_RXINT_MCASTG           (_ADI_MSK(0x00000010,uint32_t))  /* Rx Multicast Count (Good) Half/Full */
#define BITM_EMAC_MMC_RXINT_BCASTG           (_ADI_MSK(0x00000008,uint32_t))  /* Rx Broadcast Count (Good) Half/Full */
#define BITM_EMAC_MMC_RXINT_OCTCNTG          (_ADI_MSK(0x00000004,uint32_t))  /* Octet Count (Good) Half/Full */
#define BITM_EMAC_MMC_RXINT_OCTCNTGB         (_ADI_MSK(0x00000002,uint32_t))  /* Octet Count (Good/Bad) Half/Full */
#define BITM_EMAC_MMC_RXINT_FRCNTGB          (_ADI_MSK(0x00000001,uint32_t))  /* Frame Count (Good/Bad) Half/Full */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_MMC_TXINT                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_MMC_TXINT_VLANFRGB         24                               /* Tx VLAN Frames (Good) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_PAUSEFRM         23                               /* Tx Pause Frames Count Half/Full */
#define BITP_EMAC_MMC_TXINT_EXCESSDEF        22                               /* Tx Excess Deferred Count Half/Full */
#define BITP_EMAC_MMC_TXINT_FRCNTG           21                               /* Tx Frame Count (Good) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_OCTCNTG          20                               /* Tx Octet Count (Good) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_CARRERR          19                               /* Tx Carrier Error Count Half/Full */
#define BITP_EMAC_MMC_TXINT_EXCESSCOL        18                               /* Tx Exess Collision Count Half/Full */
#define BITP_EMAC_MMC_TXINT_LATECOL          17                               /* Tx Late Collision Count Half/Full */
#define BITP_EMAC_MMC_TXINT_DEFERRED         16                               /* Tx Deffered Count Half/Full */
#define BITP_EMAC_MMC_TXINT_MULTCOLG         15                               /* Tx Multiple collision (Good) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_SNGCOLG          14                               /* Tx Single Collision (Good) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_UNDERR           13                               /* Tx Underflow Error Count Half/Full */
#define BITP_EMAC_MMC_TXINT_BCASTGB          12                               /* Tx Broadcast Frames (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_MCASTGB          11                               /* Tx Multicast Frames (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_UCASTGB          10                               /* Tx Unicast Frames (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_T1024TOMAX        9                               /* Tx 1024-to-max Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_T512TO1023        8                               /* Tx 512-to-1023 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_T256TO511         7                               /* Tx 256-to-511 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_T128TO255         6                               /* Tx 128-to-255 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_T65TO127          5                               /* Tx 65-to-127 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_T64               4                               /* Tx 64 Octets (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_MCASTG            3                               /* Tx Multicast Frames (Good) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_BCASTG            2                               /* Tx Broadcast Frames (Good) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_FRCNTGB           1                               /* Tx Frame Count (Good/Bad) Count Half/Full */
#define BITP_EMAC_MMC_TXINT_OCTCNTGB          0                               /* Tx Octet Count (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_VLANFRGB         (_ADI_MSK(0x01000000,uint32_t))  /* Tx VLAN Frames (Good) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_PAUSEFRM         (_ADI_MSK(0x00800000,uint32_t))  /* Tx Pause Frames Count Half/Full */
#define BITM_EMAC_MMC_TXINT_EXCESSDEF        (_ADI_MSK(0x00400000,uint32_t))  /* Tx Excess Deferred Count Half/Full */
#define BITM_EMAC_MMC_TXINT_FRCNTG           (_ADI_MSK(0x00200000,uint32_t))  /* Tx Frame Count (Good) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_OCTCNTG          (_ADI_MSK(0x00100000,uint32_t))  /* Tx Octet Count (Good) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_CARRERR          (_ADI_MSK(0x00080000,uint32_t))  /* Tx Carrier Error Count Half/Full */
#define BITM_EMAC_MMC_TXINT_EXCESSCOL        (_ADI_MSK(0x00040000,uint32_t))  /* Tx Exess Collision Count Half/Full */
#define BITM_EMAC_MMC_TXINT_LATECOL          (_ADI_MSK(0x00020000,uint32_t))  /* Tx Late Collision Count Half/Full */
#define BITM_EMAC_MMC_TXINT_DEFERRED         (_ADI_MSK(0x00010000,uint32_t))  /* Tx Deffered Count Half/Full */
#define BITM_EMAC_MMC_TXINT_MULTCOLG         (_ADI_MSK(0x00008000,uint32_t))  /* Tx Multiple collision (Good) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_SNGCOLG          (_ADI_MSK(0x00004000,uint32_t))  /* Tx Single Collision (Good) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_UNDERR           (_ADI_MSK(0x00002000,uint32_t))  /* Tx Underflow Error Count Half/Full */
#define BITM_EMAC_MMC_TXINT_BCASTGB          (_ADI_MSK(0x00001000,uint32_t))  /* Tx Broadcast Frames (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_MCASTGB          (_ADI_MSK(0x00000800,uint32_t))  /* Tx Multicast Frames (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_UCASTGB          (_ADI_MSK(0x00000400,uint32_t))  /* Tx Unicast Frames (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_T1024TOMAX       (_ADI_MSK(0x00000200,uint32_t))  /* Tx 1024-to-max Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_T512TO1023       (_ADI_MSK(0x00000100,uint32_t))  /* Tx 512-to-1023 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_T256TO511        (_ADI_MSK(0x00000080,uint32_t))  /* Tx 256-to-511 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_T128TO255        (_ADI_MSK(0x00000040,uint32_t))  /* Tx 128-to-255 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_T65TO127         (_ADI_MSK(0x00000020,uint32_t))  /* Tx 65-to-127 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_T64              (_ADI_MSK(0x00000010,uint32_t))  /* Tx 64 Octets (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_MCASTG           (_ADI_MSK(0x00000008,uint32_t))  /* Tx Multicast Frames (Good) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_BCASTG           (_ADI_MSK(0x00000004,uint32_t))  /* Tx Broadcast Frames (Good) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_FRCNTGB          (_ADI_MSK(0x00000002,uint32_t))  /* Tx Frame Count (Good/Bad) Count Half/Full */
#define BITM_EMAC_MMC_TXINT_OCTCNTGB         (_ADI_MSK(0x00000001,uint32_t))  /* Tx Octet Count (Good/Bad) Count Half/Full */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_MMC_RXIMSK                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_MMC_RXIMSK_WATCHERR        23                               /* Rx Watch Dog Error Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_VLANFRGB        22                               /* Rx VLAN Frames (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_FIFOOV          21                               /* Rx FIFO Overflow Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_PAUSEFRM        20                               /* Rx Pause Frames Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_OUTRANGE        19                               /* Rx Out Of Range Type Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_LENERR          18                               /* Rx Length Error Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_UCASTG          17                               /* Rx Unicast Frames (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_R1024TOMAX      16                               /* Rx 1024-to-max Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_R512TO1023      15                               /* Rx 512-to-1023 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_R256TO511       14                               /* Rx 255-to-511 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_R128TO255       13                               /* Rx 128-to-255 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_R65TO127        12                               /* Rx 65-to-127 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_R64             11                               /* Rx 64 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_OSIZEG          10                               /* Rx Oversize (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_USIZEG           9                               /* Rx Undersize (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_JABERR           8                               /* Rx Jabber Error Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_RUNTERR          7                               /* Rx Runt Error Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_ALIGNERR         6                               /* Rx Alignment Error Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_CRCERR           5                               /* Rx CRC Error Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_MCASTG           4                               /* Rx Multicast Frames (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_BCASTG           3                               /* Rx Broadcast Frames (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_OCTCNTG          2                               /* Rx Octet Count (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_OCTCNTGB         1                               /* Rx Octet Count (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_RXIMSK_FRCNTGB          0                               /* Rx Frame Count (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_WATCHERR        (_ADI_MSK(0x00800000,uint32_t))  /* Rx Watch Dog Error Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_VLANFRGB        (_ADI_MSK(0x00400000,uint32_t))  /* Rx VLAN Frames (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_FIFOOV          (_ADI_MSK(0x00200000,uint32_t))  /* Rx FIFO Overflow Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_PAUSEFRM        (_ADI_MSK(0x00100000,uint32_t))  /* Rx Pause Frames Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_OUTRANGE        (_ADI_MSK(0x00080000,uint32_t))  /* Rx Out Of Range Type Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_LENERR          (_ADI_MSK(0x00040000,uint32_t))  /* Rx Length Error Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_UCASTG          (_ADI_MSK(0x00020000,uint32_t))  /* Rx Unicast Frames (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_R1024TOMAX      (_ADI_MSK(0x00010000,uint32_t))  /* Rx 1024-to-max Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_R512TO1023      (_ADI_MSK(0x00008000,uint32_t))  /* Rx 512-to-1023 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_R256TO511       (_ADI_MSK(0x00004000,uint32_t))  /* Rx 255-to-511 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_R128TO255       (_ADI_MSK(0x00002000,uint32_t))  /* Rx 128-to-255 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_R65TO127        (_ADI_MSK(0x00001000,uint32_t))  /* Rx 65-to-127 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_R64             (_ADI_MSK(0x00000800,uint32_t))  /* Rx 64 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_OSIZEG          (_ADI_MSK(0x00000400,uint32_t))  /* Rx Oversize (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_USIZEG          (_ADI_MSK(0x00000200,uint32_t))  /* Rx Undersize (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_JABERR          (_ADI_MSK(0x00000100,uint32_t))  /* Rx Jabber Error Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_RUNTERR         (_ADI_MSK(0x00000080,uint32_t))  /* Rx Runt Error Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_ALIGNERR        (_ADI_MSK(0x00000040,uint32_t))  /* Rx Alignment Error Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_CRCERR          (_ADI_MSK(0x00000020,uint32_t))  /* Rx CRC Error Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_MCASTG          (_ADI_MSK(0x00000010,uint32_t))  /* Rx Multicast Frames (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_BCASTG          (_ADI_MSK(0x00000008,uint32_t))  /* Rx Broadcast Frames (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_OCTCNTG         (_ADI_MSK(0x00000004,uint32_t))  /* Rx Octet Count (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_OCTCNTGB        (_ADI_MSK(0x00000002,uint32_t))  /* Rx Octet Count (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_RXIMSK_FRCNTGB         (_ADI_MSK(0x00000001,uint32_t))  /* Rx Frame Count (Good/Bad) Count Half/Full Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_MMC_TXIMSK                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_MMC_TXIMSK_VLANFRG         24                               /* Tx VLAN Frames (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_PAUSEFRM        23                               /* Tx Pause Frames Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_EXCESSDEF       22                               /* Tx Excess Deferred Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_FRCNTG          21                               /* Tx Frame Count (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_OCTCNTG         20                               /* Tx Octet Count (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_CARRERR         19                               /* Tx Carrier Error Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_EXCESSCOL       18                               /* Tx Exess collision Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_LATECOL         17                               /* Tx Late Collision Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_DEFERRED        16                               /* Tx Deferred Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_MULTCOLG        15                               /* Tx Multiple Collisions (Good) Count Mask */
#define BITP_EMAC_MMC_TXIMSK_SNGCOLG         14                               /* Tx Single Collision (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_UNDERR          13                               /* Tx Underflow Error Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_BCASTGB         12                               /* Tx Broadcast Frames (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_MCASTGB         11                               /* Tx Multicast Frames (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_UCASTGB         10                               /* Tx Unicast Frames (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_T1024TOMAX       9                               /* Tx 1024-to-max Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_T512TO1023       8                               /* Tx 512-to-1023 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_T256TO511        7                               /* Tx 256-to-511 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_T128TO255        6                               /* Tx 128-to-255 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_T65TO127         5                               /* Tx 65-to-127 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_T64              4                               /* Tx 64 Octets (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_MCASTG           3                               /* Tx Multicast Frames (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_BCASTG           2                               /* Tx Broadcast Frames (Good) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_FRCNTGB          1                               /* Tx Frame Count (Good/Bad) Count Half/Full Mask */
#define BITP_EMAC_MMC_TXIMSK_OCTCNTGB         0                               /* Tx Octet Count (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_VLANFRG         (_ADI_MSK(0x01000000,uint32_t))  /* Tx VLAN Frames (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_PAUSEFRM        (_ADI_MSK(0x00800000,uint32_t))  /* Tx Pause Frames Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_EXCESSDEF       (_ADI_MSK(0x00400000,uint32_t))  /* Tx Excess Deferred Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_FRCNTG          (_ADI_MSK(0x00200000,uint32_t))  /* Tx Frame Count (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_OCTCNTG         (_ADI_MSK(0x00100000,uint32_t))  /* Tx Octet Count (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_CARRERR         (_ADI_MSK(0x00080000,uint32_t))  /* Tx Carrier Error Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_EXCESSCOL       (_ADI_MSK(0x00040000,uint32_t))  /* Tx Exess collision Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_LATECOL         (_ADI_MSK(0x00020000,uint32_t))  /* Tx Late Collision Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_DEFERRED        (_ADI_MSK(0x00010000,uint32_t))  /* Tx Deferred Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_MULTCOLG        (_ADI_MSK(0x00008000,uint32_t))  /* Tx Multiple Collisions (Good) Count Mask */
#define BITM_EMAC_MMC_TXIMSK_SNGCOLG         (_ADI_MSK(0x00004000,uint32_t))  /* Tx Single Collision (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_UNDERR          (_ADI_MSK(0x00002000,uint32_t))  /* Tx Underflow Error Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_BCASTGB         (_ADI_MSK(0x00001000,uint32_t))  /* Tx Broadcast Frames (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_MCASTGB         (_ADI_MSK(0x00000800,uint32_t))  /* Tx Multicast Frames (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_UCASTGB         (_ADI_MSK(0x00000400,uint32_t))  /* Tx Unicast Frames (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_T1024TOMAX      (_ADI_MSK(0x00000200,uint32_t))  /* Tx 1024-to-max Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_T512TO1023      (_ADI_MSK(0x00000100,uint32_t))  /* Tx 512-to-1023 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_T256TO511       (_ADI_MSK(0x00000080,uint32_t))  /* Tx 256-to-511 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_T128TO255       (_ADI_MSK(0x00000040,uint32_t))  /* Tx 128-to-255 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_T65TO127        (_ADI_MSK(0x00000020,uint32_t))  /* Tx 65-to-127 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_T64             (_ADI_MSK(0x00000010,uint32_t))  /* Tx 64 Octets (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_MCASTG          (_ADI_MSK(0x00000008,uint32_t))  /* Tx Multicast Frames (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_BCASTG          (_ADI_MSK(0x00000004,uint32_t))  /* Tx Broadcast Frames (Good) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_FRCNTGB         (_ADI_MSK(0x00000002,uint32_t))  /* Tx Frame Count (Good/Bad) Count Half/Full Mask */
#define BITM_EMAC_MMC_TXIMSK_OCTCNTGB        (_ADI_MSK(0x00000001,uint32_t))  /* Tx Octet Count (Good/Bad) Count Half/Full Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_IPC_RXIMSK                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_IPC_RXIMSK_ICMPERROCT      29                               /* Rx ICMP Error Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_ICMPGOCT        28                               /* Rx ICMP (Good) Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_TCPERROCT       27                               /* Rx TCP Error Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_TCPGOCT         26                               /* Rx TCP (Good) Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_UDPERROCT       25                               /* Rx UDP Error Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_UDPGOCT         24                               /* Rx UDP (Good) Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V6NOPAYOCT      23                               /* Rx IPv6 No Payload Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V6HDERROCT      22                               /* Rx IPv6 Header Error Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V6GOCT          21                               /* Rx IPv6 (Good) Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4UDSBLOCT      20                               /* Rx IPv4 UDS Disable Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4FRAGOCT       19                               /* Rx IPv4 Fragmented Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4NOPAYOCT      18                               /* Rx IPv4 No Payload Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4HDERROCT      17                               /* Rx IPv4 Header Error Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4GOCT          16                               /* Rx IPv4 (Good) Octets Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_ICMPERRFRM      13                               /* Rx ICMP Error Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_ICMPGFRM        12                               /* Rx ICMP (Good) Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_TCPERRFRM       11                               /* Rx TCP Error Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_TCPGFRM         10                               /* Rx TCP (Good) Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_UDPERRFRM        9                               /* Rx UDP Error Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_UDPGFRM          8                               /* Rx UDP (Good) Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V6NOPAYFRM       7                               /* Rx IPv6 No Payload Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V6HDERRFRM       6                               /* Rx IPv6 Header Error Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V6GFRM           5                               /* Rx IPv6 (Good) Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4UDSBLFRM       4                               /* Rx IPv4 UDS Disable Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4FRAGFRM        3                               /* Rx IPv4 Fragmented Frames Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4NOPAYFRM       2                               /* Rx IPv4 No Payload Frame Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4HDERRFRM       1                               /* Rx IPv4 Header Error Frame Count Half/Full Mask */
#define BITP_EMAC_IPC_RXIMSK_V4GFRM           0                               /* Rx IPv4 (Good) Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_ICMPERROCT      (_ADI_MSK(0x20000000,uint32_t))  /* Rx ICMP Error Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_ICMPGOCT        (_ADI_MSK(0x10000000,uint32_t))  /* Rx ICMP (Good) Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_TCPERROCT       (_ADI_MSK(0x08000000,uint32_t))  /* Rx TCP Error Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_TCPGOCT         (_ADI_MSK(0x04000000,uint32_t))  /* Rx TCP (Good) Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_UDPERROCT       (_ADI_MSK(0x02000000,uint32_t))  /* Rx UDP Error Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_UDPGOCT         (_ADI_MSK(0x01000000,uint32_t))  /* Rx UDP (Good) Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V6NOPAYOCT      (_ADI_MSK(0x00800000,uint32_t))  /* Rx IPv6 No Payload Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V6HDERROCT      (_ADI_MSK(0x00400000,uint32_t))  /* Rx IPv6 Header Error Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V6GOCT          (_ADI_MSK(0x00200000,uint32_t))  /* Rx IPv6 (Good) Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4UDSBLOCT      (_ADI_MSK(0x00100000,uint32_t))  /* Rx IPv4 UDS Disable Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4FRAGOCT       (_ADI_MSK(0x00080000,uint32_t))  /* Rx IPv4 Fragmented Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4NOPAYOCT      (_ADI_MSK(0x00040000,uint32_t))  /* Rx IPv4 No Payload Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4HDERROCT      (_ADI_MSK(0x00020000,uint32_t))  /* Rx IPv4 Header Error Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4GOCT          (_ADI_MSK(0x00010000,uint32_t))  /* Rx IPv4 (Good) Octets Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_ICMPERRFRM      (_ADI_MSK(0x00002000,uint32_t))  /* Rx ICMP Error Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_ICMPGFRM        (_ADI_MSK(0x00001000,uint32_t))  /* Rx ICMP (Good) Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_TCPERRFRM       (_ADI_MSK(0x00000800,uint32_t))  /* Rx TCP Error Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_TCPGFRM         (_ADI_MSK(0x00000400,uint32_t))  /* Rx TCP (Good) Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_UDPERRFRM       (_ADI_MSK(0x00000200,uint32_t))  /* Rx UDP Error Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_UDPGFRM         (_ADI_MSK(0x00000100,uint32_t))  /* Rx UDP (Good) Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V6NOPAYFRM      (_ADI_MSK(0x00000080,uint32_t))  /* Rx IPv6 No Payload Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V6HDERRFRM      (_ADI_MSK(0x00000040,uint32_t))  /* Rx IPv6 Header Error Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V6GFRM          (_ADI_MSK(0x00000020,uint32_t))  /* Rx IPv6 (Good) Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4UDSBLFRM      (_ADI_MSK(0x00000010,uint32_t))  /* Rx IPv4 UDS Disable Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4FRAGFRM       (_ADI_MSK(0x00000008,uint32_t))  /* Rx IPv4 Fragmented Frames Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4NOPAYFRM      (_ADI_MSK(0x00000004,uint32_t))  /* Rx IPv4 No Payload Frame Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4HDERRFRM      (_ADI_MSK(0x00000002,uint32_t))  /* Rx IPv4 Header Error Frame Count Half/Full Mask */
#define BITM_EMAC_IPC_RXIMSK_V4GFRM          (_ADI_MSK(0x00000001,uint32_t))  /* Rx IPv4 (Good) Frames Count Half/Full Mask */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_IPC_RXINT                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_IPC_RXINT_ICMPERROCT       29                               /* Rx ICMP Error Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_ICMPGOCT         28                               /* Rx ICMP (Good) Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_TCPERROCT        27                               /* Rx TCP Error Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_TCPGOCT          26                               /* Rx TCP (Good) Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_UDPERROCT        25                               /* Rx UDP Error Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_UDPGOCT          24                               /* Rx UDP (Good) Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V6NOPAYOCT       23                               /* Rx IPv6 No Payload Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V6HDERROCT       22                               /* Rx IPv6 Header Error Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V6GOCT           21                               /* Rx IPv6 (Good) Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4UDSBLOCT       20                               /* Rx IPv4 UDS Disable Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4FRAGOCT        19                               /* Rx IPv4 Fragmented Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4NOPAYOCT       18                               /* Rx IPv4 No Payload Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4HDERROCT       17                               /* Rx IPv4 Header Error Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4GOCT           16                               /* Rx IPv4 (Good) Octets Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_ICMPERRFRM       13                               /* Rx ICMP Error Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_ICMPGFRM         12                               /* Rx ICMP (Good) Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_TCPERRFRM        11                               /* Rx TCP Error Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_TCPGFRM          10                               /* Rx TCP (Good) Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_UDPERRFRM         9                               /* Rx IDP Error Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_UDPGFRM           8                               /* Rx UDP (Good) Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V6NOPAYFRM        7                               /* Rx IPv6 No Payload Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V6HDERRFRM        6                               /* Rx IPv6 Header Error Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V6GFRM            5                               /* Rx IPv6 (Good) Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4UDSBLFRM        4                               /* Rx IPv4 UDS Disable Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4FRAGFRM         3                               /* Rx IPv4 Fragmented Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4NOPAYFRM        2                               /* Rx IPv4 No Payload Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4HDERRFRM        1                               /* Rx IPv4 Header Error Frames Count Half/Full Interrupt */
#define BITP_EMAC_IPC_RXINT_V4GFRM            0                               /* Rx IPv4 (Good) Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_ICMPERROCT       (_ADI_MSK(0x20000000,uint32_t))  /* Rx ICMP Error Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_ICMPGOCT         (_ADI_MSK(0x10000000,uint32_t))  /* Rx ICMP (Good) Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_TCPERROCT        (_ADI_MSK(0x08000000,uint32_t))  /* Rx TCP Error Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_TCPGOCT          (_ADI_MSK(0x04000000,uint32_t))  /* Rx TCP (Good) Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_UDPERROCT        (_ADI_MSK(0x02000000,uint32_t))  /* Rx UDP Error Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_UDPGOCT          (_ADI_MSK(0x01000000,uint32_t))  /* Rx UDP (Good) Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V6NOPAYOCT       (_ADI_MSK(0x00800000,uint32_t))  /* Rx IPv6 No Payload Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V6HDERROCT       (_ADI_MSK(0x00400000,uint32_t))  /* Rx IPv6 Header Error Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V6GOCT           (_ADI_MSK(0x00200000,uint32_t))  /* Rx IPv6 (Good) Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4UDSBLOCT       (_ADI_MSK(0x00100000,uint32_t))  /* Rx IPv4 UDS Disable Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4FRAGOCT        (_ADI_MSK(0x00080000,uint32_t))  /* Rx IPv4 Fragmented Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4NOPAYOCT       (_ADI_MSK(0x00040000,uint32_t))  /* Rx IPv4 No Payload Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4HDERROCT       (_ADI_MSK(0x00020000,uint32_t))  /* Rx IPv4 Header Error Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4GOCT           (_ADI_MSK(0x00010000,uint32_t))  /* Rx IPv4 (Good) Octets Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_ICMPERRFRM       (_ADI_MSK(0x00002000,uint32_t))  /* Rx ICMP Error Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_ICMPGFRM         (_ADI_MSK(0x00001000,uint32_t))  /* Rx ICMP (Good) Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_TCPERRFRM        (_ADI_MSK(0x00000800,uint32_t))  /* Rx TCP Error Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_TCPGFRM          (_ADI_MSK(0x00000400,uint32_t))  /* Rx TCP (Good) Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_UDPERRFRM        (_ADI_MSK(0x00000200,uint32_t))  /* Rx IDP Error Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_UDPGFRM          (_ADI_MSK(0x00000100,uint32_t))  /* Rx UDP (Good) Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V6NOPAYFRM       (_ADI_MSK(0x00000080,uint32_t))  /* Rx IPv6 No Payload Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V6HDERRFRM       (_ADI_MSK(0x00000040,uint32_t))  /* Rx IPv6 Header Error Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V6GFRM           (_ADI_MSK(0x00000020,uint32_t))  /* Rx IPv6 (Good) Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4UDSBLFRM       (_ADI_MSK(0x00000010,uint32_t))  /* Rx IPv4 UDS Disable Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4FRAGFRM        (_ADI_MSK(0x00000008,uint32_t))  /* Rx IPv4 Fragmented Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4NOPAYFRM       (_ADI_MSK(0x00000004,uint32_t))  /* Rx IPv4 No Payload Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4HDERRFRM       (_ADI_MSK(0x00000002,uint32_t))  /* Rx IPv4 Header Error Frames Count Half/Full Interrupt */
#define BITM_EMAC_IPC_RXINT_V4GFRM           (_ADI_MSK(0x00000001,uint32_t))  /* Rx IPv4 (Good) Frames Count Half/Full Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_TM_CTL                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_TM_CTL_ATSFC               24                               /* Auxilary Time Stamp FIFO Clear */
#define BITP_EMAC_TM_CTL_TSENMACADDR         18                               /* Time Stamp Enable MAC Address */
#define BITP_EMAC_TM_CTL_SNAPTYPSEL          16                               /* Snapshot Type Select */
#define BITP_EMAC_TM_CTL_TSMSTRENA           15                               /* Time Stamp Master (Frames) Enable */
#define BITP_EMAC_TM_CTL_TSEVNTENA           14                               /* Time Stamp Event (PTP Frames) Enable */
#define BITP_EMAC_TM_CTL_TSIPV4ENA           13                               /* Time Stamp IPV4 (PTP Frames) Enable */
#define BITP_EMAC_TM_CTL_TSIPV6ENA           12                               /* Time Stamp IPV6 (PTP Frames) Enable */
#define BITP_EMAC_TM_CTL_TSIPENA             11                               /* Time Stamp IP Enable */
#define BITP_EMAC_TM_CTL_TSVER2ENA           10                               /* Time Stamp VER2 (Snooping) Enable */
#define BITP_EMAC_TM_CTL_TSCTRLSSR            9                               /* Time Stamp Control Nanosecond Rollover */
#define BITP_EMAC_TM_CTL_TSENALL              8                               /* Time Stamp Enable All (Frames) */
#define BITP_EMAC_TM_CTL_TSADDREG             5                               /* Time Stamp Addend Register Update */
#define BITP_EMAC_TM_CTL_TSTRIG               4                               /* Time Stamp (Target Time) Trigger Enable */
#define BITP_EMAC_TM_CTL_TSUPDT               3                               /* Time Stamp (System Time) Update */
#define BITP_EMAC_TM_CTL_TSINIT               2                               /* Time Stamp (System Time) Initialize */
#define BITP_EMAC_TM_CTL_TSCFUPDT             1                               /* Time Stamp (System Time) Fine/Coarse Update */
#define BITP_EMAC_TM_CTL_TSENA                0                               /* Time Stamp (PTP) Enable */
#define BITM_EMAC_TM_CTL_ATSFC               (_ADI_MSK(0x01000000,uint32_t))  /* Auxilary Time Stamp FIFO Clear */

#define BITM_EMAC_TM_CTL_TSENMACADDR         (_ADI_MSK(0x00040000,uint32_t))  /* Time Stamp Enable MAC Address */
#define ENUM_EMAC_TM_CTL_D_PTP_ADDRFILT      (_ADI_MSK(0x00000000,uint32_t))  /* TSENMACADDR: Disable PTP MAC address filter */
#define ENUM_EMAC_TM_CTL_E_PTP_ADDRFILT      (_ADI_MSK(0x00040000,uint32_t))  /* TSENMACADDR: Enable PTP MAC address filter */
#define BITM_EMAC_TM_CTL_SNAPTYPSEL          (_ADI_MSK(0x00030000,uint32_t))  /* Snapshot Type Select */

#define BITM_EMAC_TM_CTL_TSMSTRENA           (_ADI_MSK(0x00008000,uint32_t))  /* Time Stamp Master (Frames) Enable */
#define ENUM_EMAC_TM_CTL_E_SLVSNPT_MSGS      (_ADI_MSK(0x00000000,uint32_t))  /* TSMSTRENA: Enable Snapshot for Slave Messages */
#define ENUM_EMAC_TM_CTL_E_MSSNPST_MSGS      (_ADI_MSK(0x00008000,uint32_t))  /* TSMSTRENA: Enable Snapshot for Master Messages */

#define BITM_EMAC_TM_CTL_TSEVNTENA           (_ADI_MSK(0x00004000,uint32_t))  /* Time Stamp Event (PTP Frames) Enable */
#define ENUM_EMAC_TM_CTL_E_ATSTMP_MSGS       (_ADI_MSK(0x00000000,uint32_t))  /* TSEVNTENA: Enable Time Stamp for All Messages */
#define ENUM_EMAC_TM_CTL_E_ETSTMP_MSGS       (_ADI_MSK(0x00004000,uint32_t))  /* TSEVNTENA: Enable Time Stamp for Event Messages Only */

#define BITM_EMAC_TM_CTL_TSIPV4ENA           (_ADI_MSK(0x00002000,uint32_t))  /* Time Stamp IPV4 (PTP Frames) Enable */
#define ENUM_EMAC_TM_CTL_D_TSTMP_IPV4        (_ADI_MSK(0x00000000,uint32_t))  /* TSIPV4ENA: Disable Time Stamp for PTP Over IPv4 Frames */
#define ENUM_EMAC_TM_CTL_E_TSTMP_IPV4        (_ADI_MSK(0x00002000,uint32_t))  /* TSIPV4ENA: Enable Time Stamp for PTP Over IPv4 Frames */

#define BITM_EMAC_TM_CTL_TSIPV6ENA           (_ADI_MSK(0x00001000,uint32_t))  /* Time Stamp IPV6 (PTP Frames) Enable */
#define ENUM_EMAC_TM_CTL_D_TSTMP_IPV6        (_ADI_MSK(0x00000000,uint32_t))  /* TSIPV6ENA: Disable Time Stamp for PTP Over IPv6 frames */
#define ENUM_EMAC_TM_CTL_E_TSTMP_IPV6        (_ADI_MSK(0x00001000,uint32_t))  /* TSIPV6ENA: Enable Time Stamp for PTP Over IPv6 Frames */

#define BITM_EMAC_TM_CTL_TSIPENA             (_ADI_MSK(0x00000800,uint32_t))  /* Time Stamp IP Enable */
#define ENUM_EMAC_TM_CTL_D_PTP_OV_ETHER      (_ADI_MSK(0x00000000,uint32_t))  /* TSIPENA: Disable PTP Over Ethernet Frames */
#define ENUM_EMAC_TM_CTL_E_PTP_OV_ETHER      (_ADI_MSK(0x00000800,uint32_t))  /* TSIPENA: Enable PTP Over Ethernet Frames */

#define BITM_EMAC_TM_CTL_TSVER2ENA           (_ADI_MSK(0x00000400,uint32_t))  /* Time Stamp VER2 (Snooping) Enable */
#define ENUM_EMAC_TM_CTL_D_PKT_SNOOP_V2      (_ADI_MSK(0x00000000,uint32_t))  /* TSVER2ENA: Disable packet snooping for V2 frames */
#define ENUM_EMAC_TM_CTL_E_PKT_SNOOP_V2      (_ADI_MSK(0x00000400,uint32_t))  /* TSVER2ENA: Enable packet snooping for V2 frames */

#define BITM_EMAC_TM_CTL_TSCTRLSSR           (_ADI_MSK(0x00000200,uint32_t))  /* Time Stamp Control Nanosecond Rollover */
#define ENUM_EMAC_TM_CTL_RO_SUBSEC_RES       (_ADI_MSK(0x00000000,uint32_t))  /* TSCTRLSSR: Roll Over Nanosecond After 0x7FFFFFFF */
#define ENUM_EMAC_TM_CTL_RO_NANO_RES         (_ADI_MSK(0x00000200,uint32_t))  /* TSCTRLSSR: Roll Over Nanosecond After 0x3B9AC9FF */

#define BITM_EMAC_TM_CTL_TSENALL             (_ADI_MSK(0x00000100,uint32_t))  /* Time Stamp Enable All (Frames) */
#define ENUM_EMAC_TM_CTL_D_TSALL_FRAMES      (_ADI_MSK(0x00000000,uint32_t))  /* TSENALL: Disable timestamp for all frames */
#define ENUM_EMAC_TM_CTL_E_TSALL_FRAMES      (_ADI_MSK(0x00000100,uint32_t))  /* TSENALL: Enable timestamp for all frames */
#define BITM_EMAC_TM_CTL_TSADDREG            (_ADI_MSK(0x00000020,uint32_t))  /* Time Stamp Addend Register Update */

#define BITM_EMAC_TM_CTL_TSTRIG              (_ADI_MSK(0x00000010,uint32_t))  /* Time Stamp (Target Time) Trigger Enable */
#define ENUM_EMAC_TM_CTL_EN_TRIGGER          (_ADI_MSK(0x00000010,uint32_t))  /* TSTRIG: Interrupt (TS) if system time is greater than target time register */

#define BITM_EMAC_TM_CTL_TSUPDT              (_ADI_MSK(0x00000008,uint32_t))  /* Time Stamp (System Time) Update */
#define ENUM_EMAC_TM_CTL_EN_UPDATE           (_ADI_MSK(0x00000008,uint32_t))  /* TSUPDT: System time updated with Time stamp register values */

#define BITM_EMAC_TM_CTL_TSINIT              (_ADI_MSK(0x00000004,uint32_t))  /* Time Stamp (System Time) Initialize */
#define ENUM_EMAC_TM_CTL_EN_TS_INIT          (_ADI_MSK(0x00000004,uint32_t))  /* TSINIT: System time initialized with Time stamp register values */

#define BITM_EMAC_TM_CTL_TSCFUPDT            (_ADI_MSK(0x00000002,uint32_t))  /* Time Stamp (System Time) Fine/Coarse Update */
#define ENUM_EMAC_TM_CTL_EN_COARSE_UPDT      (_ADI_MSK(0x00000000,uint32_t))  /* TSCFUPDT: Use Coarse Correction Method for System Time Update */
#define ENUM_EMAC_TM_CTL_EN_FINE_UPDT        (_ADI_MSK(0x00000002,uint32_t))  /* TSCFUPDT: Use Fine Correction Method for System Time Update */

#define BITM_EMAC_TM_CTL_TSENA               (_ADI_MSK(0x00000001,uint32_t))  /* Time Stamp (PTP) Enable */
#define ENUM_EMAC_TM_CTL_DTS                 (_ADI_MSK(0x00000000,uint32_t))  /* TSENA: Disable PTP Module */
#define ENUM_EMAC_TM_CTL_TS                  (_ADI_MSK(0x00000001,uint32_t))  /* TSENA: Enable PTP Module */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_TM_SUBSEC                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_TM_SUBSEC_SSINC             0                               /* Sub-Second Increment Value */
#define BITM_EMAC_TM_SUBSEC_SSINC            (_ADI_MSK(0x000000FF,uint32_t))  /* Sub-Second Increment Value */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_TM_NSEC                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_TM_NSEC_TSSS                0                               /* Time Stamp Nanoseconds */
#define BITM_EMAC_TM_NSEC_TSSS               (_ADI_MSK(0x7FFFFFFF,uint32_t))  /* Time Stamp Nanoseconds */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_TM_NSECUPDT                     Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_TM_NSECUPDT_ADDSUB         31                               /* Add or Subtract the Time */
#define BITP_EMAC_TM_NSECUPDT_TSSS            0                               /* Time Stamp Sub Second Initialize/Increment */
#define BITM_EMAC_TM_NSECUPDT_ADDSUB         (_ADI_MSK(0x80000000,uint32_t))  /* Add or Subtract the Time */
#define BITM_EMAC_TM_NSECUPDT_TSSS           (_ADI_MSK(0x7FFFFFFF,uint32_t))  /* Time Stamp Sub Second Initialize/Increment */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_TM_NTGTM                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_TM_NTGTM_TSTRBUSY          31                               /* Target Time Register Busy */
#define BITP_EMAC_TM_NTGTM_TSTR               0                               /* Target Time Nano Seconds */
#define BITM_EMAC_TM_NTGTM_TSTRBUSY          (_ADI_MSK(0x80000000,uint32_t))  /* Target Time Register Busy */
#define BITM_EMAC_TM_NTGTM_TSTR              (_ADI_MSK(0x7FFFFFFF,uint32_t))  /* Target Time Nano Seconds */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_TM_HISEC                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_TM_HISEC_TSHWR              0                               /* Time Stamp Higher Word Seconds Register */
#define BITM_EMAC_TM_HISEC_TSHWR             (_ADI_MSK(0x0000FFFF,uint32_t))  /* Time Stamp Higher Word Seconds Register */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_TM_STMPSTAT                     Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_TM_STMPSTAT_ATSNS          25                               /* Auxilary Time Stamp Number of Snapshots */
#define BITP_EMAC_TM_STMPSTAT_ATSSTM         24                               /* Auxilary Time Stamp Snapshot Trigger Missed */
#define BITP_EMAC_TM_STMPSTAT_TSTRGTERR       3                               /* Time Stamp Target Time Programming Error */
#define BITP_EMAC_TM_STMPSTAT_ATSTS           2                               /* Auxilary Time Stamp Trigger Snapshot */
#define BITP_EMAC_TM_STMPSTAT_TSTARGT         1                               /* Time Stamp Target Time Reached */
#define BITP_EMAC_TM_STMPSTAT_TSSOVF          0                               /* Time Stamp Seconds Overflow */
#define BITM_EMAC_TM_STMPSTAT_ATSNS          (_ADI_MSK(0x0E000000,uint32_t))  /* Auxilary Time Stamp Number of Snapshots */
#define BITM_EMAC_TM_STMPSTAT_ATSSTM         (_ADI_MSK(0x01000000,uint32_t))  /* Auxilary Time Stamp Snapshot Trigger Missed */
#define BITM_EMAC_TM_STMPSTAT_TSTRGTERR      (_ADI_MSK(0x00000008,uint32_t))  /* Time Stamp Target Time Programming Error */
#define BITM_EMAC_TM_STMPSTAT_ATSTS          (_ADI_MSK(0x00000004,uint32_t))  /* Auxilary Time Stamp Trigger Snapshot */
#define BITM_EMAC_TM_STMPSTAT_TSTARGT        (_ADI_MSK(0x00000002,uint32_t))  /* Time Stamp Target Time Reached */
#define BITM_EMAC_TM_STMPSTAT_TSSOVF         (_ADI_MSK(0x00000001,uint32_t))  /* Time Stamp Seconds Overflow */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_TM_PPSCTL                       Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_TM_PPSCTL_TRGTMODSEL        5                               /* Target Time Register Mode */
#define BITP_EMAC_TM_PPSCTL_PPSEN             4                               /* Enable the flexible PPS output mode */
#define BITP_EMAC_TM_PPSCTL_PPSCTL            0                               /* PPS Frequency Control */
#define BITM_EMAC_TM_PPSCTL_TRGTMODSEL       (_ADI_MSK(0x00000060,uint32_t))  /* Target Time Register Mode */
#define BITM_EMAC_TM_PPSCTL_PPSEN            (_ADI_MSK(0x00000010,uint32_t))  /* Enable the flexible PPS output mode */
#define BITM_EMAC_TM_PPSCTL_PPSCTL           (_ADI_MSK(0x0000000F,uint32_t))  /* PPS Frequency Control */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DMA_BUSMODE                     Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DMA_BUSMODE_AAL            25                               /* Address Aligned Bursts */
#define BITP_EMAC_DMA_BUSMODE_PBL8           24                               /* PBL * 8 */
#define BITP_EMAC_DMA_BUSMODE_USP            23                               /* Use Separate PBL */
#define BITP_EMAC_DMA_BUSMODE_RPBL           17                               /* Receive Programmable Burst Length */
#define BITP_EMAC_DMA_BUSMODE_FB             16                               /* Fixed Burst */
#define BITP_EMAC_DMA_BUSMODE_PBL             8                               /* Programmable Burst Length */
#define BITP_EMAC_DMA_BUSMODE_ATDS            7                               /* Alternate Descriptor Size */
#define BITP_EMAC_DMA_BUSMODE_DSL             2                               /* Descriptor Skip Length */
#define BITP_EMAC_DMA_BUSMODE_SWR             0                               /* Software Reset */
#define BITM_EMAC_DMA_BUSMODE_AAL            (_ADI_MSK(0x02000000,uint32_t))  /* Address Aligned Bursts */
#define BITM_EMAC_DMA_BUSMODE_PBL8           (_ADI_MSK(0x01000000,uint32_t))  /* PBL * 8 */
#define BITM_EMAC_DMA_BUSMODE_USP            (_ADI_MSK(0x00800000,uint32_t))  /* Use Separate PBL */
#define BITM_EMAC_DMA_BUSMODE_RPBL           (_ADI_MSK(0x007E0000,uint32_t))  /* Receive Programmable Burst Length */
#define BITM_EMAC_DMA_BUSMODE_FB             (_ADI_MSK(0x00010000,uint32_t))  /* Fixed Burst */
#define BITM_EMAC_DMA_BUSMODE_PBL            (_ADI_MSK(0x00003F00,uint32_t))  /* Programmable Burst Length */
#define BITM_EMAC_DMA_BUSMODE_ATDS           (_ADI_MSK(0x00000080,uint32_t))  /* Alternate Descriptor Size */
#define BITM_EMAC_DMA_BUSMODE_DSL            (_ADI_MSK(0x0000007C,uint32_t))  /* Descriptor Skip Length */
#define BITM_EMAC_DMA_BUSMODE_SWR            (_ADI_MSK(0x00000001,uint32_t))  /* Software Reset */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DMA_STAT                        Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DMA_STAT_TTI               29                               /* Time Stamp Trigger Interrupt */
#define BITP_EMAC_DMA_STAT_MCI               27                               /* MAC MMC Interrupt */
#define BITP_EMAC_DMA_STAT_EB                23                               /* Error Bits */
#define BITP_EMAC_DMA_STAT_TS                20                               /* Transmit Process State */
#define BITP_EMAC_DMA_STAT_RS                17                               /* Receive Process State */
#define BITP_EMAC_DMA_STAT_NIS               16                               /* Normal Interrupt Summary */
#define BITP_EMAC_DMA_STAT_AIS               15                               /* Abnormal Interrupt Summary */
#define BITP_EMAC_DMA_STAT_ERI               14                               /* Early Receive Interrupt */
#define BITP_EMAC_DMA_STAT_FBI               13                               /* Fatal Bus Error Interrupt */
#define BITP_EMAC_DMA_STAT_ETI               10                               /* Early Transmit Interrupt */
#define BITP_EMAC_DMA_STAT_RWT                9                               /* Receive WatchDog Timeout */
#define BITP_EMAC_DMA_STAT_RPS                8                               /* Receive Process Stopped */
#define BITP_EMAC_DMA_STAT_RU                 7                               /* Receive Buffer Unavailable */
#define BITP_EMAC_DMA_STAT_RI                 6                               /* Receive Interrupt */
#define BITP_EMAC_DMA_STAT_UNF                5                               /* Transmit Buffer Underflow */
#define BITP_EMAC_DMA_STAT_OVF                4                               /* Receive Buffer Overflow */
#define BITP_EMAC_DMA_STAT_TJT                3                               /* Transmit Jabber Timeout */
#define BITP_EMAC_DMA_STAT_TU                 2                               /* Transmit Buffer Unavailable */
#define BITP_EMAC_DMA_STAT_TPS                1                               /* Transmit Process Stopped */
#define BITP_EMAC_DMA_STAT_TI                 0                               /* Transmit Interrupt */
#define BITM_EMAC_DMA_STAT_TTI               (_ADI_MSK(0x20000000,uint32_t))  /* Time Stamp Trigger Interrupt */
#define BITM_EMAC_DMA_STAT_MCI               (_ADI_MSK(0x08000000,uint32_t))  /* MAC MMC Interrupt */
#define BITM_EMAC_DMA_STAT_EB                (_ADI_MSK(0x03800000,uint32_t))  /* Error Bits */

#define BITM_EMAC_DMA_STAT_TS                (_ADI_MSK(0x00700000,uint32_t))  /* Transmit Process State */
#define ENUM_EMAC_DMA_STAT_TS_STOPPED        (_ADI_MSK(0x00000000,uint32_t))  /* TS: Stopped; Reset or Stop Transmit Command issued */
#define ENUM_EMAC_DMA_STAT_TS_R_FTD          (_ADI_MSK(0x00100000,uint32_t))  /* TS: Running; Fetching Transmit Transfer Descriptor */
#define ENUM_EMAC_DMA_STAT_TS_R_WSTAT        (_ADI_MSK(0x00200000,uint32_t))  /* TS: Running; Waiting for status */
#define ENUM_EMAC_DMA_STAT_TS_R_TXHMBUF      (_ADI_MSK(0x00300000,uint32_t))  /* TS: Reading Data from host memory buffer and queuing it to TX buffer */
#define ENUM_EMAC_DMA_STAT_TS_WR_TSTMP       (_ADI_MSK(0x00400000,uint32_t))  /* TS: TIME_STAMP write state */
#define ENUM_EMAC_DMA_STAT_TS_SUSPENDED      (_ADI_MSK(0x00600000,uint32_t))  /* TS: Suspended; Transmit Descriptor Unavailable or TX Buffer Underflow */
#define ENUM_EMAC_DMA_STAT_TS_R_CLSTD        (_ADI_MSK(0x00700000,uint32_t))  /* TS: Closing Transmit Descriptor */

#define BITM_EMAC_DMA_STAT_RS                (_ADI_MSK(0x000E0000,uint32_t))  /* Receive Process State */
#define ENUM_EMAC_DMA_STAT_RS_STOPPED        (_ADI_MSK(0x00000000,uint32_t))  /* RS: Stopped: Reset or Stop Receive Command issued. */
#define ENUM_EMAC_DMA_STAT_RS_R_FRD          (_ADI_MSK(0x00020000,uint32_t))  /* RS: Running: Fetching Receive Transfer Descriptor. */
#define ENUM_EMAC_DMA_STAT_RS_R_WTRX         (_ADI_MSK(0x00060000,uint32_t))  /* RS: Running: Waiting for receive packet */
#define ENUM_EMAC_DMA_STAT_RS_SUSPENDED      (_ADI_MSK(0x00080000,uint32_t))  /* RS: Suspended: Receive Descriptor Unavailable */
#define ENUM_EMAC_DMA_STAT_RS_R_CLSRD        (_ADI_MSK(0x000A0000,uint32_t))  /* RS: Running: Closing Receive Descriptor */
#define ENUM_EMAC_DMA_STAT_RS_WR_TSTMP       (_ADI_MSK(0x000C0000,uint32_t))  /* RS: TIME_STAMP write state */
#define ENUM_EMAC_DMA_STAT_RS_R_RXWRHM       (_ADI_MSK(0x000E0000,uint32_t))  /* RS: Running: Transferring RX packet data from RX buffer to host memory */
#define BITM_EMAC_DMA_STAT_NIS               (_ADI_MSK(0x00010000,uint32_t))  /* Normal Interrupt Summary */
#define BITM_EMAC_DMA_STAT_AIS               (_ADI_MSK(0x00008000,uint32_t))  /* Abnormal Interrupt Summary */
#define BITM_EMAC_DMA_STAT_ERI               (_ADI_MSK(0x00004000,uint32_t))  /* Early Receive Interrupt */
#define BITM_EMAC_DMA_STAT_FBI               (_ADI_MSK(0x00002000,uint32_t))  /* Fatal Bus Error Interrupt */
#define BITM_EMAC_DMA_STAT_ETI               (_ADI_MSK(0x00000400,uint32_t))  /* Early Transmit Interrupt */
#define BITM_EMAC_DMA_STAT_RWT               (_ADI_MSK(0x00000200,uint32_t))  /* Receive WatchDog Timeout */
#define BITM_EMAC_DMA_STAT_RPS               (_ADI_MSK(0x00000100,uint32_t))  /* Receive Process Stopped */
#define BITM_EMAC_DMA_STAT_RU                (_ADI_MSK(0x00000080,uint32_t))  /* Receive Buffer Unavailable */
#define BITM_EMAC_DMA_STAT_RI                (_ADI_MSK(0x00000040,uint32_t))  /* Receive Interrupt */
#define BITM_EMAC_DMA_STAT_UNF               (_ADI_MSK(0x00000020,uint32_t))  /* Transmit Buffer Underflow */
#define BITM_EMAC_DMA_STAT_OVF               (_ADI_MSK(0x00000010,uint32_t))  /* Receive Buffer Overflow */
#define BITM_EMAC_DMA_STAT_TJT               (_ADI_MSK(0x00000008,uint32_t))  /* Transmit Jabber Timeout */
#define BITM_EMAC_DMA_STAT_TU                (_ADI_MSK(0x00000004,uint32_t))  /* Transmit Buffer Unavailable */
#define BITM_EMAC_DMA_STAT_TPS               (_ADI_MSK(0x00000002,uint32_t))  /* Transmit Process Stopped */
#define BITM_EMAC_DMA_STAT_TI                (_ADI_MSK(0x00000001,uint32_t))  /* Transmit Interrupt */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DMA_OPMODE                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DMA_OPMODE_DT              26                               /* Disable Dropping TCP/IP Errors */
#define BITP_EMAC_DMA_OPMODE_RSF             25                               /* Receive Store and Forward */
#define BITP_EMAC_DMA_OPMODE_DFF             24                               /* Disable Flushing of received Frames */
#define BITP_EMAC_DMA_OPMODE_TSF             21                               /* Transmit Store and Forward */
#define BITP_EMAC_DMA_OPMODE_FTF             20                               /* Flush Transmit FIFO */
#define BITP_EMAC_DMA_OPMODE_TTC             14                               /* Transmit Threshold Control */
#define BITP_EMAC_DMA_OPMODE_ST              13                               /* Start/Stop Transmission */
#define BITP_EMAC_DMA_OPMODE_FEF              7                               /* Forward Error Frames */
#define BITP_EMAC_DMA_OPMODE_FUF              6                               /* Forward Undersized good Frames */
#define BITP_EMAC_DMA_OPMODE_RTC              3                               /* Receive Threshold Control */
#define BITP_EMAC_DMA_OPMODE_OSF              2                               /* Operate on Second Frame */
#define BITP_EMAC_DMA_OPMODE_SR               1                               /* Start/Stop Receive */
#define BITM_EMAC_DMA_OPMODE_DT              (_ADI_MSK(0x04000000,uint32_t))  /* Disable Dropping TCP/IP Errors */
#define BITM_EMAC_DMA_OPMODE_RSF             (_ADI_MSK(0x02000000,uint32_t))  /* Receive Store and Forward */
#define BITM_EMAC_DMA_OPMODE_DFF             (_ADI_MSK(0x01000000,uint32_t))  /* Disable Flushing of received Frames */
#define BITM_EMAC_DMA_OPMODE_TSF             (_ADI_MSK(0x00200000,uint32_t))  /* Transmit Store and Forward */
#define BITM_EMAC_DMA_OPMODE_FTF             (_ADI_MSK(0x00100000,uint32_t))  /* Flush Transmit FIFO */

#define BITM_EMAC_DMA_OPMODE_TTC             (_ADI_MSK(0x0001C000,uint32_t))  /* Transmit Threshold Control */
#define ENUM_EMAC_DMA_OPMODE_TTC_64          (_ADI_MSK(0x00000000,uint32_t))  /* TTC: 64 */
#define ENUM_EMAC_DMA_OPMODE_TTC_128         (_ADI_MSK(0x00004000,uint32_t))  /* TTC: 128 */
#define ENUM_EMAC_DMA_OPMODE_TTC_192         (_ADI_MSK(0x00008000,uint32_t))  /* TTC: 192 */
#define ENUM_EMAC_DMA_OPMODE_TTC_256         (_ADI_MSK(0x0000C000,uint32_t))  /* TTC: 256 */
#define ENUM_EMAC_DMA_OPMODE_TTC_40          (_ADI_MSK(0x00010000,uint32_t))  /* TTC: 40 */
#define ENUM_EMAC_DMA_OPMODE_TTC_32          (_ADI_MSK(0x00014000,uint32_t))  /* TTC: 32 */
#define ENUM_EMAC_DMA_OPMODE_TTC_24          (_ADI_MSK(0x00018000,uint32_t))  /* TTC: 24 */
#define ENUM_EMAC_DMA_OPMODE_TTC_16          (_ADI_MSK(0x0001C000,uint32_t))  /* TTC: 16 */
#define BITM_EMAC_DMA_OPMODE_ST              (_ADI_MSK(0x00002000,uint32_t))  /* Start/Stop Transmission */
#define BITM_EMAC_DMA_OPMODE_FEF             (_ADI_MSK(0x00000080,uint32_t))  /* Forward Error Frames */
#define BITM_EMAC_DMA_OPMODE_FUF             (_ADI_MSK(0x00000040,uint32_t))  /* Forward Undersized good Frames */

#define BITM_EMAC_DMA_OPMODE_RTC             (_ADI_MSK(0x00000018,uint32_t))  /* Receive Threshold Control */
#define ENUM_EMAC_DMA_OPMODE_RTC_64          (_ADI_MSK(0x00000000,uint32_t))  /* RTC: 64 */
#define ENUM_EMAC_DMA_OPMODE_RTC_32          (_ADI_MSK(0x00000008,uint32_t))  /* RTC: 32 */
#define ENUM_EMAC_DMA_OPMODE_RTC_96          (_ADI_MSK(0x00000010,uint32_t))  /* RTC: 96 */
#define ENUM_EMAC_DMA_OPMODE_RTC_128         (_ADI_MSK(0x00000018,uint32_t))  /* RTC: 128 */
#define BITM_EMAC_DMA_OPMODE_OSF             (_ADI_MSK(0x00000004,uint32_t))  /* Operate on Second Frame */
#define BITM_EMAC_DMA_OPMODE_SR              (_ADI_MSK(0x00000002,uint32_t))  /* Start/Stop Receive */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DMA_IEN                         Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DMA_IEN_NIS                16                               /* Normal Interrupt Summary Enable */
#define BITP_EMAC_DMA_IEN_AIS                15                               /* Abnormal Interrupt Summary Enable */
#define BITP_EMAC_DMA_IEN_ERI                14                               /* Early Receive Interrupt Enable */
#define BITP_EMAC_DMA_IEN_FBI                13                               /* Fatal Bus Error Enable */
#define BITP_EMAC_DMA_IEN_ETI                10                               /* Early Transmit Interrupt Enable */
#define BITP_EMAC_DMA_IEN_RWT                 9                               /* Receive WatchdogTimeout Enable */
#define BITP_EMAC_DMA_IEN_RPS                 8                               /* Receive Stopped Enable */
#define BITP_EMAC_DMA_IEN_RU                  7                               /* Receive Buffer Unavailable Enable */
#define BITP_EMAC_DMA_IEN_RI                  6                               /* Receive Interrupt Enable */
#define BITP_EMAC_DMA_IEN_UNF                 5                               /* Underflow Interrupt Enable */
#define BITP_EMAC_DMA_IEN_OVF                 4                               /* Overflow Interrupt Enable */
#define BITP_EMAC_DMA_IEN_TJT                 3                               /* Transmit Jabber Timeout Enable */
#define BITP_EMAC_DMA_IEN_TU                  2                               /* Transmit Buffer Unavailable Enable */
#define BITP_EMAC_DMA_IEN_TPS                 1                               /* Transmit Stopped Enable */
#define BITP_EMAC_DMA_IEN_TI                  0                               /* Transmit Interrupt Enable */
#define BITM_EMAC_DMA_IEN_NIS                (_ADI_MSK(0x00010000,uint32_t))  /* Normal Interrupt Summary Enable */
#define BITM_EMAC_DMA_IEN_AIS                (_ADI_MSK(0x00008000,uint32_t))  /* Abnormal Interrupt Summary Enable */
#define BITM_EMAC_DMA_IEN_ERI                (_ADI_MSK(0x00004000,uint32_t))  /* Early Receive Interrupt Enable */
#define BITM_EMAC_DMA_IEN_FBI                (_ADI_MSK(0x00002000,uint32_t))  /* Fatal Bus Error Enable */
#define BITM_EMAC_DMA_IEN_ETI                (_ADI_MSK(0x00000400,uint32_t))  /* Early Transmit Interrupt Enable */
#define BITM_EMAC_DMA_IEN_RWT                (_ADI_MSK(0x00000200,uint32_t))  /* Receive WatchdogTimeout Enable */
#define BITM_EMAC_DMA_IEN_RPS                (_ADI_MSK(0x00000100,uint32_t))  /* Receive Stopped Enable */
#define BITM_EMAC_DMA_IEN_RU                 (_ADI_MSK(0x00000080,uint32_t))  /* Receive Buffer Unavailable Enable */
#define BITM_EMAC_DMA_IEN_RI                 (_ADI_MSK(0x00000040,uint32_t))  /* Receive Interrupt Enable */
#define BITM_EMAC_DMA_IEN_UNF                (_ADI_MSK(0x00000020,uint32_t))  /* Underflow Interrupt Enable */
#define BITM_EMAC_DMA_IEN_OVF                (_ADI_MSK(0x00000010,uint32_t))  /* Overflow Interrupt Enable */
#define BITM_EMAC_DMA_IEN_TJT                (_ADI_MSK(0x00000008,uint32_t))  /* Transmit Jabber Timeout Enable */
#define BITM_EMAC_DMA_IEN_TU                 (_ADI_MSK(0x00000004,uint32_t))  /* Transmit Buffer Unavailable Enable */
#define BITM_EMAC_DMA_IEN_TPS                (_ADI_MSK(0x00000002,uint32_t))  /* Transmit Stopped Enable */
#define BITM_EMAC_DMA_IEN_TI                 (_ADI_MSK(0x00000001,uint32_t))  /* Transmit Interrupt Enable */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DMA_MISS_FRM                    Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DMA_MISS_FRM_OVFFIFO       28                               /* Overflow bit for FIFO Overflow Counter */
#define BITP_EMAC_DMA_MISS_FRM_MISSFROV      17                               /* Missed Frames Buffer Overflow */
#define BITP_EMAC_DMA_MISS_FRM_OVFMISS       16                               /* Overflow bit for Missed Frame Counter */
#define BITP_EMAC_DMA_MISS_FRM_MISSFRUN       0                               /* Missed Frames Unavailable Buffer */
#define BITM_EMAC_DMA_MISS_FRM_OVFFIFO       (_ADI_MSK(0x10000000,uint32_t))  /* Overflow bit for FIFO Overflow Counter */
#define BITM_EMAC_DMA_MISS_FRM_MISSFROV      (_ADI_MSK(0x0FFE0000,uint32_t))  /* Missed Frames Buffer Overflow */
#define BITM_EMAC_DMA_MISS_FRM_OVFMISS       (_ADI_MSK(0x00010000,uint32_t))  /* Overflow bit for Missed Frame Counter */
#define BITM_EMAC_DMA_MISS_FRM_MISSFRUN      (_ADI_MSK(0x0000FFFF,uint32_t))  /* Missed Frames Unavailable Buffer */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DMA_RXIWDOG                     Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DMA_RXIWDOG_RIWT            0                               /* RI WatchDog Timer Count */
#define BITM_EMAC_DMA_RXIWDOG_RIWT           (_ADI_MSK(0x000000FF,uint32_t))  /* RI WatchDog Timer Count */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DMA_BMMODE                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DMA_BMMODE_WROSRLMT        20                               /* SCB Maximum Write Outstanding Request */
#define BITP_EMAC_DMA_BMMODE_RDOSRLMT        16                               /* SCB Maximum Read Outstanding Request */
#define BITP_EMAC_DMA_BMMODE_AAL             12                               /* Address Aligned Beats */
#define BITP_EMAC_DMA_BMMODE_BLEN16           3                               /* SCB Burst Length 16 */
#define BITP_EMAC_DMA_BMMODE_BLEN8            2                               /* SCB Burst Length 8 */
#define BITP_EMAC_DMA_BMMODE_BLEN4            1                               /* SCB Burst Length 4 */
#define BITP_EMAC_DMA_BMMODE_UNDEF            0                               /* SCB Undefined Burst Length */
#define BITM_EMAC_DMA_BMMODE_WROSRLMT        (_ADI_MSK(0x00700000,uint32_t))  /* SCB Maximum Write Outstanding Request */
#define BITM_EMAC_DMA_BMMODE_RDOSRLMT        (_ADI_MSK(0x00070000,uint32_t))  /* SCB Maximum Read Outstanding Request */
#define BITM_EMAC_DMA_BMMODE_AAL             (_ADI_MSK(0x00001000,uint32_t))  /* Address Aligned Beats */
#define BITM_EMAC_DMA_BMMODE_BLEN16          (_ADI_MSK(0x00000008,uint32_t))  /* SCB Burst Length 16 */
#define BITM_EMAC_DMA_BMMODE_BLEN8           (_ADI_MSK(0x00000004,uint32_t))  /* SCB Burst Length 8 */
#define BITM_EMAC_DMA_BMMODE_BLEN4           (_ADI_MSK(0x00000002,uint32_t))  /* SCB Burst Length 4 */
#define BITM_EMAC_DMA_BMMODE_UNDEF           (_ADI_MSK(0x00000001,uint32_t))  /* SCB Undefined Burst Length */

/* ------------------------------------------------------------------------------------------------------------------------
        EMAC_DMA_BMSTAT                      Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_EMAC_DMA_BMSTAT_BUSRD            1                               /* Bus (SCB master) Read Active */
#define BITP_EMAC_DMA_BMSTAT_BUSWR            0                               /* Bus (SCB master) Write Active */
#define BITM_EMAC_DMA_BMSTAT_BUSRD           (_ADI_MSK(0x00000002,uint32_t))  /* Bus (SCB master) Read Active */
#define BITM_EMAC_DMA_BMSTAT_BUSWR           (_ADI_MSK(0x00000001,uint32_t))  /* Bus (SCB master) Write Active */

/* ==================================================
        Serial Port Registers
   ================================================== */

/* =========================
        SPORT0
   ========================= */
#define REG_SPORT0_CTL_A                0xFFC40000         /* SPORT0 Half SPORT 'A' Control Register */
#define REG_SPORT0_DIV_A                0xFFC40004         /* SPORT0 Half SPORT 'A' Divisor Register */
#define REG_SPORT0_MCTL_A               0xFFC40008         /* SPORT0 Half SPORT 'A' Multi-channel Control Register */
#define REG_SPORT0_CS0_A                0xFFC4000C         /* SPORT0 Half SPORT 'A' Multi-channel 0-31 Select Register */
#define REG_SPORT0_CS1_A                0xFFC40010         /* SPORT0 Half SPORT 'A' Multi-channel 32-63 Select Register */
#define REG_SPORT0_CS2_A                0xFFC40014         /* SPORT0 Half SPORT 'A' Multi-channel 64-95 Select Register */
#define REG_SPORT0_CS3_A                0xFFC40018         /* SPORT0 Half SPORT 'A' Multi-channel 96-127 Select Register */
#define REG_SPORT0_ERR_A                0xFFC40020         /* SPORT0 Half SPORT 'A' Error Register */
#define REG_SPORT0_MSTAT_A              0xFFC40024         /* SPORT0 Half SPORT 'A' Multi-channel Status Register */
#define REG_SPORT0_CTL2_A               0xFFC40028         /* SPORT0 Half SPORT 'A' Control 2 Register */
#define REG_SPORT0_TXPRI_A              0xFFC40040         /* SPORT0 Half SPORT 'A' Tx Buffer (Primary) Register */
#define REG_SPORT0_RXPRI_A              0xFFC40044         /* SPORT0 Half SPORT 'A' Rx Buffer (Primary) Register */
#define REG_SPORT0_TXSEC_A              0xFFC40048         /* SPORT0 Half SPORT 'A' Tx Buffer (Secondary) Register */
#define REG_SPORT0_RXSEC_A              0xFFC4004C         /* SPORT0 Half SPORT 'A' Rx Buffer (Secondary) Register */
#define REG_SPORT0_CTL_B                0xFFC40080         /* SPORT0 Half SPORT 'B' Control Register */
#define REG_SPORT0_DIV_B                0xFFC40084         /* SPORT0 Half SPORT 'B' Divisor Register */
#define REG_SPORT0_MCTL_B               0xFFC40088         /* SPORT0 Half SPORT 'B' Multi-channel Control Register */
#define REG_SPORT0_CS0_B                0xFFC4008C         /* SPORT0 Half SPORT 'B' Multi-channel 0-31 Select Register */
#define REG_SPORT0_CS1_B                0xFFC40090         /* SPORT0 Half SPORT 'B' Multi-channel 32-63 Select Register */
#define REG_SPORT0_CS2_B                0xFFC40094         /* SPORT0 Half SPORT 'B' Multichannel 64-95 Select Register */
#define REG_SPORT0_CS3_B                0xFFC40098         /* SPORT0 Half SPORT 'B' Multichannel 96-127 Select Register */
#define REG_SPORT0_ERR_B                0xFFC400A0         /* SPORT0 Half SPORT 'B' Error Register */
#define REG_SPORT0_MSTAT_B              0xFFC400A4         /* SPORT0 Half SPORT 'B' Multi-channel Status Register */
#define REG_SPORT0_CTL2_B               0xFFC400A8         /* SPORT0 Half SPORT 'B' Control 2 Register */
#define REG_SPORT0_TXPRI_B              0xFFC400C0         /* SPORT0 Half SPORT 'B' Tx Buffer (Primary) Register */
#define REG_SPORT0_RXPRI_B              0xFFC400C4         /* SPORT0 Half SPORT 'B' Rx Buffer (Primary) Register */
#define REG_SPORT0_TXSEC_B              0xFFC400C8         /* SPORT0 Half SPORT 'B' Tx Buffer (Secondary) Register */
#define REG_SPORT0_RXSEC_B              0xFFC400CC         /* SPORT0 Half SPORT 'B' Rx Buffer (Secondary) Register */

/* =========================
        SPORT1
   ========================= */
#define REG_SPORT1_CTL_A                0xFFC40100         /* SPORT1 Half SPORT 'A' Control Register */
#define REG_SPORT1_DIV_A                0xFFC40104         /* SPORT1 Half SPORT 'A' Divisor Register */
#define REG_SPORT1_MCTL_A               0xFFC40108         /* SPORT1 Half SPORT 'A' Multi-channel Control Register */
#define REG_SPORT1_CS0_A                0xFFC4010C         /* SPORT1 Half SPORT 'A' Multi-channel 0-31 Select Register */
#define REG_SPORT1_CS1_A                0xFFC40110         /* SPORT1 Half SPORT 'A' Multi-channel 32-63 Select Register */
#define REG_SPORT1_CS2_A                0xFFC40114         /* SPORT1 Half SPORT 'A' Multi-channel 64-95 Select Register */
#define REG_SPORT1_CS3_A                0xFFC40118         /* SPORT1 Half SPORT 'A' Multi-channel 96-127 Select Register */
#define REG_SPORT1_ERR_A                0xFFC40120         /* SPORT1 Half SPORT 'A' Error Register */
#define REG_SPORT1_MSTAT_A              0xFFC40124         /* SPORT1 Half SPORT 'A' Multi-channel Status Register */
#define REG_SPORT1_CTL2_A               0xFFC40128         /* SPORT1 Half SPORT 'A' Control 2 Register */
#define REG_SPORT1_TXPRI_A              0xFFC40140         /* SPORT1 Half SPORT 'A' Tx Buffer (Primary) Register */
#define REG_SPORT1_RXPRI_A              0xFFC40144         /* SPORT1 Half SPORT 'A' Rx Buffer (Primary) Register */
#define REG_SPORT1_TXSEC_A              0xFFC40148         /* SPORT1 Half SPORT 'A' Tx Buffer (Secondary) Register */
#define REG_SPORT1_RXSEC_A              0xFFC4014C         /* SPORT1 Half SPORT 'A' Rx Buffer (Secondary) Register */
#define REG_SPORT1_CTL_B                0xFFC40180         /* SPORT1 Half SPORT 'B' Control Register */
#define REG_SPORT1_DIV_B                0xFFC40184         /* SPORT1 Half SPORT 'B' Divisor Register */
#define REG_SPORT1_MCTL_B               0xFFC40188         /* SPORT1 Half SPORT 'B' Multi-channel Control Register */
#define REG_SPORT1_CS0_B                0xFFC4018C         /* SPORT1 Half SPORT 'B' Multi-channel 0-31 Select Register */
#define REG_SPORT1_CS1_B                0xFFC40190         /* SPORT1 Half SPORT 'B' Multi-channel 32-63 Select Register */
#define REG_SPORT1_CS2_B                0xFFC40194         /* SPORT1 Half SPORT 'B' Multichannel 64-95 Select Register */
#define REG_SPORT1_CS3_B                0xFFC40198         /* SPORT1 Half SPORT 'B' Multichannel 96-127 Select Register */
#define REG_SPORT1_ERR_B                0xFFC401A0         /* SPORT1 Half SPORT 'B' Error Register */
#define REG_SPORT1_MSTAT_B              0xFFC401A4         /* SPORT1 Half SPORT 'B' Multi-channel Status Register */
#define REG_SPORT1_CTL2_B               0xFFC401A8         /* SPORT1 Half SPORT 'B' Control 2 Register */
#define REG_SPORT1_TXPRI_B              0xFFC401C0         /* SPORT1 Half SPORT 'B' Tx Buffer (Primary) Register */
#define REG_SPORT1_RXPRI_B              0xFFC401C4         /* SPORT1 Half SPORT 'B' Rx Buffer (Primary) Register */
#define REG_SPORT1_TXSEC_B              0xFFC401C8         /* SPORT1 Half SPORT 'B' Tx Buffer (Secondary) Register */
#define REG_SPORT1_RXSEC_B              0xFFC401CC         /* SPORT1 Half SPORT 'B' Rx Buffer (Secondary) Register */

/* =========================
        SPORT2
   ========================= */
#define REG_SPORT2_CTL_A                0xFFC40200         /* SPORT2 Half SPORT 'A' Control Register */
#define REG_SPORT2_DIV_A                0xFFC40204         /* SPORT2 Half SPORT 'A' Divisor Register */
#define REG_SPORT2_MCTL_A               0xFFC40208         /* SPORT2 Half SPORT 'A' Multi-channel Control Register */
#define REG_SPORT2_CS0_A                0xFFC4020C         /* SPORT2 Half SPORT 'A' Multi-channel 0-31 Select Register */
#define REG_SPORT2_CS1_A                0xFFC40210         /* SPORT2 Half SPORT 'A' Multi-channel 32-63 Select Register */
#define REG_SPORT2_CS2_A                0xFFC40214         /* SPORT2 Half SPORT 'A' Multi-channel 64-95 Select Register */
#define REG_SPORT2_CS3_A                0xFFC40218         /* SPORT2 Half SPORT 'A' Multi-channel 96-127 Select Register */
#define REG_SPORT2_ERR_A                0xFFC40220         /* SPORT2 Half SPORT 'A' Error Register */
#define REG_SPORT2_MSTAT_A              0xFFC40224         /* SPORT2 Half SPORT 'A' Multi-channel Status Register */
#define REG_SPORT2_CTL2_A               0xFFC40228         /* SPORT2 Half SPORT 'A' Control 2 Register */
#define REG_SPORT2_TXPRI_A              0xFFC40240         /* SPORT2 Half SPORT 'A' Tx Buffer (Primary) Register */
#define REG_SPORT2_RXPRI_A              0xFFC40244         /* SPORT2 Half SPORT 'A' Rx Buffer (Primary) Register */
#define REG_SPORT2_TXSEC_A              0xFFC40248         /* SPORT2 Half SPORT 'A' Tx Buffer (Secondary) Register */
#define REG_SPORT2_RXSEC_A              0xFFC4024C         /* SPORT2 Half SPORT 'A' Rx Buffer (Secondary) Register */
#define REG_SPORT2_CTL_B                0xFFC40280         /* SPORT2 Half SPORT 'B' Control Register */
#define REG_SPORT2_DIV_B                0xFFC40284         /* SPORT2 Half SPORT 'B' Divisor Register */
#define REG_SPORT2_MCTL_B               0xFFC40288         /* SPORT2 Half SPORT 'B' Multi-channel Control Register */
#define REG_SPORT2_CS0_B                0xFFC4028C         /* SPORT2 Half SPORT 'B' Multi-channel 0-31 Select Register */
#define REG_SPORT2_CS1_B                0xFFC40290         /* SPORT2 Half SPORT 'B' Multi-channel 32-63 Select Register */
#define REG_SPORT2_CS2_B                0xFFC40294         /* SPORT2 Half SPORT 'B' Multichannel 64-95 Select Register */
#define REG_SPORT2_CS3_B                0xFFC40298         /* SPORT2 Half SPORT 'B' Multichannel 96-127 Select Register */
#define REG_SPORT2_ERR_B                0xFFC402A0         /* SPORT2 Half SPORT 'B' Error Register */
#define REG_SPORT2_MSTAT_B              0xFFC402A4         /* SPORT2 Half SPORT 'B' Multi-channel Status Register */
#define REG_SPORT2_CTL2_B               0xFFC402A8         /* SPORT2 Half SPORT 'B' Control 2 Register */
#define REG_SPORT2_TXPRI_B              0xFFC402C0         /* SPORT2 Half SPORT 'B' Tx Buffer (Primary) Register */
#define REG_SPORT2_RXPRI_B              0xFFC402C4         /* SPORT2 Half SPORT 'B' Rx Buffer (Primary) Register */
#define REG_SPORT2_TXSEC_B              0xFFC402C8         /* SPORT2 Half SPORT 'B' Tx Buffer (Secondary) Register */
#define REG_SPORT2_RXSEC_B              0xFFC402CC         /* SPORT2 Half SPORT 'B' Rx Buffer (Secondary) Register */

/* =========================
        SPORT
   ========================= */
/* ------------------------------------------------------------------------------------------------------------------------
        SPORT_CTL_A                          Pos/Masks                        Description
   ------------------------------------------------------------------------------------------------------------------------ */
#define BITP_SPORT_CTL_A_DXSPRI              30                               /* Data Transfer Buffer Status (Primary) */
#define BITP_SPORT_CTL_DXSPRI                30                               /* Data Transfer Buffer Status (Primary) */
#define BITP_SPORT_CTL_A_DERRPRI             29                               /* Data Error Status (Primary) */
#define BITP_SPORT_CTL_DERRPRI               29                               /* Data Error Status (Primary) */
#define BITP_SPORT_CTL_A_DXSSEC              27                               /* Data Transfer Buffer Status (Secondary) */
#define BITP_SPORT_CTL_DXSSEC                27                               /* Data Transfer Buffer Status (Secondary) */
#define BITP_SPORT_CTL_A_DERRSEC             26                               /* Data Error Status (Secondary) */
#define BITP_SPORT_CTL_DERRSEC               26                               /* Data Error Status (Secondary) */
#define BITP_SPORT_CTL_A_SPTRAN              25                               /* Serial Port Transfer Direction */
#define BITP_SPORT_CTL_SPTRAN                25                               /* Serial Port Transfer Direction */
#define BITP_SPORT_CTL_A_SPENSEC             24                               /* Serial Port Enable (Secondary) */
#define BITP_SPORT_CTL_SPENSEC               24                               /* Serial Port Enable (Secondary) */
#define BITP_SPORT_CTL_A_GCLKEN              21                               /* Gated Clock Enable */
#define BITP_SPORT_CTL_GCLKEN                21                               /* Gated Clock Enable */
#define BITP_SPORT_CTL_A_TFIEN               20                               /* Transmit Finish Interrupt Enable */
#define BITP_SPORT_CTL_TFIEN                 20                               /* Transmit Finish Interrupt Enable */
#define BITP_SPORT_CTL_A_FSED                19                               /* Frame Sync Edge Detect */
#define BITP_SPORT_CTL_FSED                  19                               /* Frame Sync Edge Detect */
#define BITP_SPORT_CTL_A_RJUST               18                               /* Right-Justified Operation Mode */
#define BITP_SPORT_CTL_RJUST                 18                               /* Right-Justified Operation Mode */
#define BITP_SPORT_CTL_A_LAFS                17                               /* Late Frame Sync / OPMODE2 */
#define BITP_SPORT_CTL_LAFS                  17                               /* Late Frame Sync / OPMODE2 */
#define BITP_SPORT_CTL_A_LFS                 16                               /* Active-Low Frame Sync / L_FIRST / PLFS */
#define BITP_SPORT_CTL_LFS                   16                               /* Active-Low Frame Sync / L_FIRST / PLFS */
#define BITP_SPORT_CTL_A_DIFS                15                               /* Data-Independent Frame Sync */
#define BITP_SPORT_CTL_DIFS                  15                               /* Data-Independent Frame Sync */
#define BITP_SPORT_CTL_A_IFS                 14                               /* Internal Frame Sync */
#define BITP_SPORT_CTL_IFS                   14                               /* Internal Frame Sync */
#define BITP_SPORT_CTL_A_FSR                 13                               /* Frame Sync Required */
#define BITP_SPORT_CTL_FSR                   13                               /* Frame Sync Required */
#define BITP_SPORT_CTL_A_CKRE                12                               /* Clock Rising Edge */
#define BITP_SPORT_CTL_CKRE                  12                               /* Clock Rising Edge */
#define BITP_SPORT_CTL_A_OPMODE              11                               /* Operation mode */
#define BITP_SPORT_CTL_OPMODE                11                               /* Operation mode */
#define BITP_SPORT_CTL_A_ICLK                10                               /* Internal Clock */
#define BITP_SPORT_CTL_ICLK                  10                               /* Internal Clock */
#define BITP_SPORT_CTL_A_PACK                 9                               /* Packing Enable */
#define BITP_SPORT_CTL_PACK                   9                               /* Packing Enable */
#define BITP_SPORT_CTL_A_SLEN                 4                               /* Serial Word Length */
#define BITP_SPORT_CTL_SLEN                   4                               /* Serial Word Length */
#define BITP_SPORT_CTL_A_LSBF                 3                               /* Least-Significant Bit First */
#define BITP_SPORT_CTL_LSBF                   3                               /* Least-Significant Bit First */
#define BITP_SPORT_CTL_A_DTYPE                1                               /* Data Type */
#define BITP_SPORT_CTL_DTYPE                  1                               /* Data Type */
#define BITP_SPORT_CTL_A_SPENPRI              0                               /* Serial Port Enable (Primary) */
#define BITP_SPORT_CTL_SPENPRI                0                               /* Serial Port Enable (Primary) */

#define BITM_SPORT_CTL_A_DXSPRI              (_ADI_MSK(0xC0000000,uint32_t))  /* Data Transfer Buffer Status (Primary) */
#define BITM_SPORT_CTL_DXSPRI                (_ADI_MSK(0xC0000000,uint32_t))  /* Data Transfer Buffer Status (Primary) */
#define ENUM_SPORT_CTL_PRM_EMPTY             (_ADI_MSK(0x00000000,uint32_t))  /* DXSPRI: Empty */
#define ENUM_SPORT_CTL_PRM_PART_FULL         (_ADI_MSK(0x80000000,uint32_t))  /* DXSPRI: Partially full */
#define ENUM_SPORT_CTL_PRM_FULL              (_ADI_MSK(0xC0000000,uint32_t))  /* DXSPRI: Full */

#define BITM_SPORT_CTL_A_DERRPRI             (_ADI_MSK(0x20000000,uint32_t))  /* Data Error Status (Primary) */
#define BITM_SPORT_CTL_DERRPRI               (_ADI_MSK(0x20000000,uint32_t))  /* Data Error Status (Primary) */
#define ENUM_SPORT_CTL_PRM_NO_ERR            (_ADI_MSK(0x00000000,uint32_t))  /* DERRPRI: No error */
#define ENUM_SPORT_CTL_PRM_ERR               (_ADI_MSK(0x20000000,uint32_t))  /* DERRPRI: Error (Tx underflow or Rx overflow) */

#define BITM_SPORT_CTL_A_DXSSEC              (_ADI_MSK(0x18000000,uint32_t))  /* Data Transfer Buffer Status (Secondary) */
#define BITM_SPORT_CTL_DXSSEC                (_ADI_MSK(0x18000000,uint32_t))  /* Data Transfer Buffer Status (Secondary) */
#define ENUM_SPORT_CTL_SEC_EMPTY             (_ADI_MSK(0x00000000,uint32_t))  /* DXSSEC: Empty */
#define ENUM_SPORT_CTL_SEC_PART_FULL         (_ADI_MSK(0x10000000,uint32_t))  /* DXSSEC: Partially full */
#define ENUM_SPORT_CTL_SEC_FULL              (_ADI_MSK(0x18000000,uint32_t))  /* DXSSEC: Full */

#define BITM_SPORT_CTL_A_DERRSEC             (_ADI_MSK(0x04000000,uint32_t))  /* Data Error Status (Secondary) */
#define BITM_SPORT_CTL_DERRSEC               (_ADI_MSK(0x04000000,uint32_t))  /* Data Error Status (Secondary) */
#define ENUM_SPORT_CTL_SEC_NO_ERR            (_ADI_MSK(0x00000000,uint32_t))  /* DERRSEC: No error */
#define ENUM_SPORT_CTL_SEC_ERR               (_ADI_MSK(0x04000000,uint32_t))  /* DERRSEC: Error (Tx underflow or Rx overflow) */

#define BITM_SPORT_CTL_A_SPTRAN              (_ADI_MSK(0x02000000,uint32_t))  /* Serial Port Transfer Direction */
#define BITM_SPORT_CTL_SPTRAN                (_ADI_MSK(0x02000000,uint32_t))  /* Serial Port Transfer Direction */
#define ENUM_SPORT_CTL_RX                    (_ADI_MSK(0x00000000,uint32_t))  /* SPTRAN: Receive */
#define ENUM_SPORT_CTL_TX                    (_ADI_MSK(0x02000000,uint32_t))  /* SPTRAN: Transmit */

#define BITM_SPORT_CTL_A_SPENSEC             (_ADI_MSK(0x01000000,uint32_t))  /* Serial Port Enable (Secondary) */
#define BITM_SPORT_CTL_SPENSEC               (_ADI_MSK(0x01000000,uint32_t))  /* Serial Port Enable (Secondary) */
#define ENUM_SPORT_CTL_SECONDARY_DIS         (_ADI_MSK(0x00000000,uint32_t))  /* SPENSEC: Disable */
#define ENUM_SPORT_CTL_SECONDARY_EN          (_ADI_MSK(0x01000000,uint32_t))  /* SPENSEC: Enable */

#define BITM_SPORT_CTL_A_GCLKEN              (_ADI_MSK(0x00200000,uint32_t))  /* Gated Clock Enable */
#define BITM_SPORT_CTL_GCLKEN                (_ADI_MSK(0x00200000,uint32_t))  /* Gated Clock Enable */
#define ENUM_SPORT_CTL_GCLK_DIS              (_ADI_MSK(0x00000000,uint32_t))  /* GCLKEN: Disable */
#define ENUM_SPORT_CTL_GCLK_EN               (_ADI_MSK(0x00200000,uint32_t))  /* GCLKEN: Enable */

#define BITM_SPORT_CTL_A_TFIEN               (_ADI_MSK(0x00100000,uint32_t))  /* Transmit Finish Interrupt Enable */
#define BITM_SPORT_CTL_TFIEN                 (_ADI_MSK(0x00100000,uint32_t))  /* Transmit Finish Interrupt Enable */
#define ENUM_SPORT_CTL_TXFIN_DIS             (_ADI_MSK(0x00000000,uint32_t))  /* TFIEN: Last word sent (DMA count done) interrupt */
#define ENUM_SPORT_CTL_TXFIN_EN              (_ADI_MSK(0x00100000,uint32_t))  /* TFIEN: Last bit sent (Tx buffer done) interrupt */

#define BITM_SPORT_CTL_A_FSED                (_ADI_MSK(0x00080000,uint32_t))  /* Frame Sync Edge Detect */
#define BITM_SPORT_CTL_FSED                  (_ADI_MSK(0x00080000,uint32_t))  /* Frame Sync Edge Detect */
#define ENUM_SPORT_CTL_LEVEL_FS              (_ADI_MSK(0x00000000,uint32_t))  /* FSED: Level detect frame sync */
#define ENUM_SPORT_CTL_EDGE_FS               (_ADI_MSK(0x00080000,uint32_t))  /* FSED: Edge detect frame sync */

#define BITM_SPORT_CTL_A_RJUST               (_ADI_MSK(0x00040000,uint32_t))  /* Right-Justified Operation Mode */
#define BITM_SPORT_CTL_RJUST                 (_ADI_MSK(0x00040000,uint32_t))  /* Right-Justified Operation Mode */
#define ENUM_SPORT_CTL_RJUST_DIS             (_ADI_MSK(0x00000000,uint32_t))  /* RJUST: Disable */
#define ENUM_SPORT_CTL_RJUST_EN              (_ADI_MSK(0x00040000,uint32_t))  /* RJUST: Enable */

#define BITM_SPORT_CTL_A_LAFS                (_ADI_MSK(0x00020000,uint32_t))  /* Late Frame Sync / OPMODE2 */
#define BITM_SPORT_CTL_LAFS                  (_ADI_MSK(0x00020000,uint32_t))  /* Late Frame Sync / OPMODE2 */
#define ENUM_SPORT_CTL_EARLY_FS              (_ADI_MSK(0x00000000,uint32_t))  /* LAFS: Early frame sync */
#define ENUM_SPORT_CTL_LATE_FS               (_ADI_MSK(0x00020000,uint32_t))  /* LAFS: Late frame sync */

#define BITM_SPORT_CTL_A_LFS                 (_ADI_MSK(0x00010000,uint32_t))  /* Active-Low Frame Sync / L_FIRST / PLFS */
#define BITM_SPORT_CTL_LFS                   (_ADI_MSK(0x00010000,uint32_t))  /* Active-Low Frame Sync / L_FIRST / PLFS */
#define ENUM_SPORT_CTL_FS_LO                 (_ADI_MSK(0x00000000,uint32_t))  /* LFS: Active high frame sync (DSP standard mode) */
#define ENUM_SPORT_CTL_FS_HI                 (_ADI_MSK(0x00010000,uint32_t))  /* LFS: Active low frame sync (DSP standard mode) */

#define BITM_SPORT_CTL_A_DIFS                (_ADI_MSK(0x00008000,uint32_t))  /* Data-Independent Frame Sync */
#define BITM_SPORT_CTL_DIFS                  (_ADI_MSK(0x00008000,uint32_t))  /* Data-Independent Frame Sync */
#define ENUM_SPORT_CTL_DATA_DEP_FS           (_ADI_MSK(0x00000000,uint32_t))  /* DIFS: Data-dependent frame sync */
#define ENUM_SPORT_CTL_DATA_INDP_FS          (_ADI_MSK(0x00008000,uint32_t))  /* DIFS: Data-independent frame sync */

#define BITM_SPORT_CTL_A_IFS                 (_ADI_MSK(0x00004000,uint32_t))  /* Internal Frame Sync */
#define BITM_SPORT_CTL_IFS                   (_ADI_MSK(0x00004000,uint32_t))  /* Internal Frame Sync */
#define ENUM_SPORT_CTL_EXTERNAL_FS           (_ADI_MSK(0x00000000,uint32_t))  /* IFS: External frame sync */
#define ENUM_SPORT_CTL_INTERNAL_FS           (_ADI_MSK(0x00004000,uint32_t))  /* IFS: Internal frame sync */

#define BITM_SPORT_CTL_A_FSR                 (_ADI_MSK(0x00002000,uint32_t))  /* Frame Sync Required */
#define BITM_SPORT_CTL_FSR                   (_ADI_MSK(0x00002000,uint32_t))  /* Frame Sync Required */
#define ENUM_SPORT_CTL_FS_NOT_REQ            (_ADI_MSK(0x00000000,uint32_t))  /* FSR: No frame sync required */
#define ENUM_SPORT_CTL_FS_REQ                (_ADI_MSK(0x00002000,uint32_t))  /* FSR: Frame sync required */

#define BITM_SPORT_CTL_A_CKRE                (_ADI_MSK(0x00001000,uint32_t))  /* Clock Rising Edge */